/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.parquet.hadoop;

import com.dataiku.dss.shadelib.org.apache.parquet.HadoopReadOptions;
import com.dataiku.dss.shadelib.org.apache.parquet.ParquetReadOptions;
import com.dataiku.dss.shadelib.org.apache.parquet.Preconditions;
import com.dataiku.dss.shadelib.org.apache.parquet.bytes.ByteBufferAllocator;
import com.dataiku.dss.shadelib.org.apache.parquet.bytes.HeapByteBufferAllocator;
import com.dataiku.dss.shadelib.org.apache.parquet.compression.CompressionCodecFactory;
import com.dataiku.dss.shadelib.org.apache.parquet.conf.HadoopParquetConfiguration;
import com.dataiku.dss.shadelib.org.apache.parquet.conf.ParquetConfiguration;
import com.dataiku.dss.shadelib.org.apache.parquet.crypto.FileDecryptionProperties;
import com.dataiku.dss.shadelib.org.apache.parquet.filter.UnboundRecordFilter;
import com.dataiku.dss.shadelib.org.apache.parquet.filter2.compat.FilterCompat;
import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.InternalParquetRecordReader;
import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.ParquetFileReader;
import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.api.ReadSupport;
import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.util.ConfigurationUtil;
import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.util.HadoopInputFile;
import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.util.HiddenFileFilter;
import com.dataiku.dss.shadelib.org.apache.parquet.io.InputFile;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public class ParquetReader<T>
implements Closeable {
    private final ReadSupport<T> readSupport;
    private final Iterator<InputFile> filesIterator;
    private final ParquetReadOptions options;
    private InternalParquetRecordReader<T> reader;

    @Deprecated
    public ParquetReader(Path file, ReadSupport<T> readSupport) throws IOException {
        this(new Configuration(), file, readSupport, FilterCompat.NOOP);
    }

    @Deprecated
    public ParquetReader(Configuration conf, Path file, ReadSupport<T> readSupport) throws IOException {
        this(conf, file, readSupport, FilterCompat.NOOP);
    }

    @Deprecated
    public ParquetReader(Path file, ReadSupport<T> readSupport, UnboundRecordFilter unboundRecordFilter) throws IOException {
        this(new Configuration(), file, readSupport, FilterCompat.get(unboundRecordFilter));
    }

    @Deprecated
    public ParquetReader(Configuration conf, Path file, ReadSupport<T> readSupport, UnboundRecordFilter unboundRecordFilter) throws IOException {
        this(conf, file, readSupport, FilterCompat.get(unboundRecordFilter));
    }

    private ParquetReader(Configuration conf, Path file, ReadSupport<T> readSupport, FilterCompat.Filter filter) throws IOException {
        this(Collections.singletonList(HadoopInputFile.fromPath(file, conf)), HadoopReadOptions.builder(conf, file).withRecordFilter(Objects.requireNonNull(filter, "filter cannot be null")).build(), readSupport);
    }

    private ParquetReader(List<InputFile> files, ParquetReadOptions options, ReadSupport<T> readSupport) throws IOException {
        this.readSupport = readSupport;
        this.options = options;
        this.filesIterator = files.iterator();
    }

    public T read() throws IOException {
        try {
            if (this.reader != null && this.reader.nextKeyValue()) {
                return this.reader.getCurrentValue();
            }
            this.initReader();
            return this.reader == null ? null : (T)this.read();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public long getCurrentRowIndex() {
        if (this.reader == null) {
            return -1L;
        }
        return this.reader.getCurrentRowIndex();
    }

    private void initReader() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.filesIterator.hasNext()) {
            InputFile file = this.filesIterator.next();
            ParquetFileReader fileReader = ParquetFileReader.open(file, this.options);
            this.reader = new InternalParquetRecordReader<T>(this.readSupport, this.options.getRecordFilter());
            this.reader.initialize(fileReader, this.options);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public static <T> Builder<T> read(InputFile file) throws IOException {
        return new Builder(file);
    }

    public static <T> Builder<T> read(InputFile file, ParquetConfiguration conf) throws IOException {
        return new Builder(file, conf);
    }

    public static <T> Builder<T> builder(ReadSupport<T> readSupport, Path path) {
        return new Builder(readSupport, path);
    }

    public static class Builder<T> {
        private final ReadSupport<T> readSupport;
        private final InputFile file;
        private final Path path;
        private FilterCompat.Filter filter = null;
        private ByteBufferAllocator allocator = new HeapByteBufferAllocator();
        protected ParquetConfiguration configuration;
        private ParquetReadOptions.Builder optionsBuilder;
        @Deprecated
        protected Configuration conf;

        @Deprecated
        private Builder(ReadSupport<T> readSupport, Path path) {
            this.readSupport = Objects.requireNonNull(readSupport, "readSupport cannot be null");
            this.file = null;
            this.path = Objects.requireNonNull(path, "path cannot be null");
            this.conf = new Configuration();
            this.configuration = new HadoopParquetConfiguration(this.conf);
            this.optionsBuilder = HadoopReadOptions.builder(this.conf, path);
        }

        @Deprecated
        protected Builder(Path path) {
            this.readSupport = null;
            this.file = null;
            this.path = Objects.requireNonNull(path, "path cannot be null");
            this.conf = new Configuration();
            this.configuration = new HadoopParquetConfiguration(this.conf);
            this.optionsBuilder = HadoopReadOptions.builder(this.conf, path);
        }

        protected Builder(InputFile file) {
            this.readSupport = null;
            this.file = Objects.requireNonNull(file, "file cannot be null");
            this.path = null;
            if (file instanceof HadoopInputFile) {
                HadoopInputFile hadoopFile = (HadoopInputFile)file;
                this.configuration = new HadoopParquetConfiguration(hadoopFile.getConfiguration());
            } else {
                this.configuration = new HadoopParquetConfiguration();
            }
            this.optionsBuilder = HadoopReadOptions.builder(this.configuration);
        }

        protected Builder(InputFile file, ParquetConfiguration conf) {
            this.readSupport = null;
            this.file = Objects.requireNonNull(file, "file cannot be null");
            this.path = null;
            this.configuration = conf;
            if (file instanceof HadoopInputFile) {
                this.conf = ConfigurationUtil.createHadoopConfiguration(conf);
                HadoopInputFile hadoopFile = (HadoopInputFile)file;
                this.optionsBuilder = HadoopReadOptions.builder(this.conf, hadoopFile.getPath());
            } else {
                this.optionsBuilder = ParquetReadOptions.builder(conf);
            }
        }

        public Builder<T> withConf(Configuration conf) {
            this.conf = Objects.requireNonNull(conf, "conf cannot be null");
            this.configuration = new HadoopParquetConfiguration(this.conf);
            this.optionsBuilder = HadoopReadOptions.builder(conf, this.path);
            if (this.filter != null) {
                this.optionsBuilder.withRecordFilter(this.filter);
            }
            return this;
        }

        public Builder<T> withConf(ParquetConfiguration conf) {
            this.configuration = conf;
            this.optionsBuilder = ParquetReadOptions.builder(conf);
            if (this.filter != null) {
                this.optionsBuilder.withRecordFilter(this.filter);
            }
            return this;
        }

        public Builder<T> withFilter(FilterCompat.Filter filter) {
            this.filter = filter;
            this.optionsBuilder.withRecordFilter(filter);
            return this;
        }

        public Builder<T> withAllocator(ByteBufferAllocator allocator) {
            this.allocator = allocator;
            this.optionsBuilder.withAllocator(allocator);
            return this;
        }

        public Builder<T> useSignedStringMinMax(boolean useSignedStringMinMax) {
            this.optionsBuilder.useSignedStringMinMax(useSignedStringMinMax);
            return this;
        }

        public Builder<T> useSignedStringMinMax() {
            this.optionsBuilder.useSignedStringMinMax();
            return this;
        }

        public Builder<T> useStatsFilter(boolean useStatsFilter) {
            this.optionsBuilder.useStatsFilter(useStatsFilter);
            return this;
        }

        public Builder<T> useStatsFilter() {
            this.optionsBuilder.useStatsFilter();
            return this;
        }

        public Builder<T> useDictionaryFilter(boolean useDictionaryFilter) {
            this.optionsBuilder.useDictionaryFilter(useDictionaryFilter);
            return this;
        }

        public Builder<T> useDictionaryFilter() {
            this.optionsBuilder.useDictionaryFilter();
            return this;
        }

        public Builder<T> useRecordFilter(boolean useRecordFilter) {
            this.optionsBuilder.useRecordFilter(useRecordFilter);
            return this;
        }

        public Builder<T> useRecordFilter() {
            this.optionsBuilder.useRecordFilter();
            return this;
        }

        public Builder<T> useColumnIndexFilter(boolean useColumnIndexFilter) {
            this.optionsBuilder.useColumnIndexFilter(useColumnIndexFilter);
            return this;
        }

        public Builder<T> useColumnIndexFilter() {
            this.optionsBuilder.useColumnIndexFilter();
            return this;
        }

        public Builder<T> usePageChecksumVerification(boolean usePageChecksumVerification) {
            this.optionsBuilder.usePageChecksumVerification(usePageChecksumVerification);
            return this;
        }

        public Builder<T> useBloomFilter(boolean useBloomFilter) {
            this.optionsBuilder.useBloomFilter(useBloomFilter);
            return this;
        }

        public Builder<T> useBloomFilter() {
            this.optionsBuilder.useBloomFilter();
            return this;
        }

        public Builder<T> usePageChecksumVerification() {
            this.optionsBuilder.usePageChecksumVerification();
            return this;
        }

        public Builder<T> withFileRange(long start, long end) {
            this.optionsBuilder.withRange(start, end);
            return this;
        }

        public Builder<T> withCodecFactory(CompressionCodecFactory codecFactory) {
            this.optionsBuilder.withCodecFactory(codecFactory);
            return this;
        }

        public Builder<T> withDecryption(FileDecryptionProperties fileDecryptionProperties) {
            this.optionsBuilder.withDecryption(fileDecryptionProperties);
            return this;
        }

        public Builder<T> set(String key, String value) {
            this.optionsBuilder.set(key, value);
            return this;
        }

        protected ReadSupport<T> getReadSupport() {
            Preconditions.checkArgument(this.readSupport != null, "[BUG] Classes that extend Builder should override getReadSupport()");
            return this.readSupport;
        }

        public ParquetReader<T> build() throws IOException {
            ParquetReadOptions options = this.optionsBuilder.withAllocator(this.allocator).build();
            if (this.path != null) {
                Configuration hadoopConf = ConfigurationUtil.createHadoopConfiguration(this.configuration);
                FileSystem fs = this.path.getFileSystem(hadoopConf);
                FileStatus stat = fs.getFileStatus(this.path);
                if (stat.isFile()) {
                    return new ParquetReader(Collections.singletonList(HadoopInputFile.fromStatus(stat, hadoopConf)), options, this.getReadSupport());
                }
                ArrayList<HadoopInputFile> files = new ArrayList<HadoopInputFile>();
                for (FileStatus fileStatus : fs.listStatus(this.path, (PathFilter)HiddenFileFilter.INSTANCE)) {
                    files.add(HadoopInputFile.fromStatus(fileStatus, hadoopConf));
                }
                return new ParquetReader(files, options, this.getReadSupport());
            }
            return new ParquetReader(Collections.singletonList(this.file), options, this.getReadSupport());
        }
    }
}

