/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.parquet.hadoop.mapred;

import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.Footer;
import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.ParquetInputFormat;
import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.ParquetInputSplit;
import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.ParquetRecordReader;
import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.mapred.Container;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;

public class DeprecatedParquetInputFormat<V>
extends FileInputFormat<Void, Container<V>> {
    protected ParquetInputFormat<V> realInputFormat = new ParquetInputFormat();

    public RecordReader<Void, Container<V>> getRecordReader(org.apache.hadoop.mapred.InputSplit split, JobConf job, Reporter reporter) throws IOException {
        return new RecordReaderWrapper(split, job, reporter);
    }

    public org.apache.hadoop.mapred.InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        if (DeprecatedParquetInputFormat.isTaskSideMetaData(job)) {
            return super.getSplits(job, numSplits);
        }
        List<Footer> footers = this.getFooters(job);
        List<ParquetInputSplit> splits = this.realInputFormat.getSplits((Configuration)job, footers);
        if (splits == null) {
            return null;
        }
        org.apache.hadoop.mapred.InputSplit[] resultSplits = new org.apache.hadoop.mapred.InputSplit[splits.size()];
        int i = 0;
        for (ParquetInputSplit split : splits) {
            resultSplits[i++] = new ParquetInputSplitWrapper(split);
        }
        return resultSplits;
    }

    public List<Footer> getFooters(JobConf job) throws IOException {
        return this.realInputFormat.getFooters((Configuration)job, Arrays.asList(super.listStatus(job)));
    }

    public static boolean isTaskSideMetaData(JobConf job) {
        return job.getBoolean("parquet.task.side.metadata", Boolean.TRUE.booleanValue());
    }

    private static class ParquetInputSplitWrapper
    implements org.apache.hadoop.mapred.InputSplit {
        ParquetInputSplit realSplit;

        public ParquetInputSplitWrapper() {
        }

        public ParquetInputSplitWrapper(ParquetInputSplit realSplit) {
            this.realSplit = realSplit;
        }

        public long getLength() throws IOException {
            return this.realSplit.getLength();
        }

        public String[] getLocations() throws IOException {
            return this.realSplit.getLocations();
        }

        public void readFields(DataInput in) throws IOException {
            this.realSplit = new ParquetInputSplit();
            this.realSplit.readFields(in);
        }

        public void write(DataOutput out) throws IOException {
            this.realSplit.write(out);
        }
    }

    private static class RecordReaderWrapper<V>
    implements RecordReader<Void, Container<V>> {
        private ParquetRecordReader<V> realReader;
        private long splitLen;
        private Container<V> valueContainer = null;
        private boolean firstRecord = false;
        private boolean eof = false;

        public RecordReaderWrapper(org.apache.hadoop.mapred.InputSplit oldSplit, JobConf oldJobConf, Reporter reporter) throws IOException {
            this.splitLen = oldSplit.getLength();
            try {
                this.realReader = new ParquetRecordReader(ParquetInputFormat.getReadSupportInstance((Configuration)oldJobConf), ParquetInputFormat.getFilter((Configuration)oldJobConf));
                if (oldSplit instanceof ParquetInputSplitWrapper) {
                    this.realReader.initialize((InputSplit)((ParquetInputSplitWrapper)oldSplit).realSplit, (Configuration)oldJobConf, reporter);
                } else if (oldSplit instanceof FileSplit) {
                    this.realReader.initialize((InputSplit)((FileSplit)oldSplit), (Configuration)oldJobConf, reporter);
                } else {
                    throw new IllegalArgumentException("Invalid split (not a FileSplit or ParquetInputSplitWrapper): " + oldSplit);
                }
                this.valueContainer = new Container();
                if (this.realReader.nextKeyValue()) {
                    this.firstRecord = true;
                    this.valueContainer.set(this.realReader.getCurrentValue());
                } else {
                    this.eof = true;
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new IOException(e);
            }
        }

        public void close() throws IOException {
            this.realReader.close();
        }

        public Void createKey() {
            return null;
        }

        public Container<V> createValue() {
            return this.valueContainer;
        }

        public long getPos() throws IOException {
            return (long)((float)this.splitLen * this.getProgress());
        }

        public float getProgress() throws IOException {
            try {
                return this.realReader.getProgress();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new IOException(e);
            }
        }

        public boolean next(Void key, Container<V> value) throws IOException {
            if (this.eof) {
                return false;
            }
            if (this.firstRecord) {
                value.set(this.valueContainer.get());
                this.firstRecord = false;
                return true;
            }
            try {
                if (this.realReader.nextKeyValue()) {
                    if (value != null) {
                        value.set(this.realReader.getCurrentValue());
                    }
                    return true;
                }
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            this.eof = true;
            return false;
        }
    }
}

