/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.parquet.hadoop.metadata;

import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.metadata.BlockMetaData;
import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.metadata.FileMetaData;
import com.dataiku.dss.shadelib.shaded.parquet.com.fasterxml.jackson.databind.ObjectMapper;
import com.dataiku.dss.shadelib.shaded.parquet.com.fasterxml.jackson.databind.ObjectWriter;
import com.dataiku.dss.shadelib.shaded.parquet.com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;

public class ParquetMetadata {
    private static final ObjectMapper objectMapper = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    private final FileMetaData fileMetaData;
    private final List<BlockMetaData> blocks;

    public static String toJSON(ParquetMetadata parquetMetaData) {
        return ParquetMetadata.toJSON(parquetMetaData, false);
    }

    public static String toPrettyJSON(ParquetMetadata parquetMetaData) {
        return ParquetMetadata.toJSON(parquetMetaData, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String toJSON(ParquetMetadata parquetMetaData, boolean isPrettyPrint) {
        try (StringWriter stringWriter = new StringWriter();){
            Object objectToPrint = parquetMetaData.getFileMetaData() == null || parquetMetaData.getFileMetaData().getEncryptionType() == FileMetaData.EncryptionType.UNENCRYPTED ? parquetMetaData : parquetMetaData.getFileMetaData();
            ObjectWriter writer = isPrettyPrint ? objectMapper.writerWithDefaultPrettyPrinter() : objectMapper.writer();
            writer.writeValue(stringWriter, objectToPrint);
            String string = stringWriter.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ParquetMetadata fromJSON(String json) {
        try {
            return objectMapper.readValue((Reader)new StringReader(json), ParquetMetadata.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ParquetMetadata(FileMetaData fileMetaData, List<BlockMetaData> blocks) {
        this.fileMetaData = fileMetaData;
        this.blocks = blocks;
    }

    public List<BlockMetaData> getBlocks() {
        return this.blocks;
    }

    public FileMetaData getFileMetaData() {
        return this.fileMetaData;
    }

    public String toString() {
        return "ParquetMetaData{" + this.fileMetaData + ", blocks: " + this.blocks + "}";
    }
}

