/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.parquet.hadoop.util;

import com.dataiku.dss.shadelib.org.apache.parquet.bytes.ByteBufferAllocator;
import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.util.wrapped.io.VectorIoBridge;
import com.dataiku.dss.shadelib.org.apache.parquet.io.DelegatingSeekableInputStream;
import com.dataiku.dss.shadelib.org.apache.parquet.io.ParquetFileRange;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.hadoop.fs.FSDataInputStream;

class H1SeekableInputStream
extends DelegatingSeekableInputStream {
    private final FSDataInputStream stream;

    public H1SeekableInputStream(FSDataInputStream stream) {
        super((InputStream)stream);
        this.stream = stream;
    }

    @Override
    public long getPos() throws IOException {
        return this.stream.getPos();
    }

    @Override
    public void seek(long newPos) throws IOException {
        this.stream.seek(newPos);
    }

    @Override
    public void readFully(byte[] bytes) throws IOException {
        this.stream.readFully(bytes, 0, bytes.length);
    }

    @Override
    public void readFully(byte[] bytes, int start, int len) throws IOException {
        this.stream.readFully(bytes, start, len);
    }

    @Override
    public boolean readVectoredAvailable(ByteBufferAllocator allocator) {
        return VectorIoBridge.instance().readVectoredAvailable(this.stream, allocator);
    }

    @Override
    public void readVectored(List<ParquetFileRange> ranges, ByteBufferAllocator allocator) throws IOException {
        VectorIoBridge.instance().readVectoredRanges(this.stream, ranges, allocator);
    }
}

