/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.parquet.hadoop.util;

import com.dataiku.dss.shadelib.org.apache.parquet.io.PositionOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.fs.FSDataOutputStream;

public class HadoopPositionOutputStream
extends PositionOutputStream {
    private final FSDataOutputStream wrapped;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    HadoopPositionOutputStream(FSDataOutputStream wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public long getPos() throws IOException {
        return this.wrapped.getPos();
    }

    @Override
    public void write(int b) throws IOException {
        this.wrapped.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.wrapped.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.wrapped.write(b, off, len);
    }

    public void sync() throws IOException {
        this.wrapped.hsync();
    }

    @Override
    public void flush() throws IOException {
        this.wrapped.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.closed.getAndSet(true)) {
            return;
        }
        try (FSDataOutputStream fdos = this.wrapped;){
            fdos.flush();
        }
    }
}

