/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.parquet.hadoop.util.wrapped.io;

import com.dataiku.dss.shadelib.org.apache.parquet.Exceptions;
import com.dataiku.dss.shadelib.org.apache.parquet.Preconditions;
import com.dataiku.dss.shadelib.org.apache.parquet.bytes.ByteBufferAllocator;
import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.util.wrapped.io.BindingUtils;
import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.util.wrapped.io.FileRangeBridge;
import com.dataiku.dss.shadelib.org.apache.parquet.io.ParquetFileRange;
import com.dataiku.dss.shadelib.org.apache.parquet.util.DynMethods;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.PositionedReadable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VectorIoBridge {
    private static final Logger LOG = LoggerFactory.getLogger(VectorIoBridge.class);
    private static final String READ_VECTORED = "readVectored";
    private static final String HAS_CAPABILITY = "hasCapability";
    static final String VECTOREDIO_CAPABILITY = "in:readvectored";
    private static final VectorIoBridge INSTANCE = new VectorIoBridge();
    private final DynMethods.UnboundMethod readVectored;
    private final DynMethods.UnboundMethod hasCapabilityMethod;
    private final AtomicLong vectorReads = new AtomicLong();
    private final AtomicLong blocksRead = new AtomicLong();
    private final AtomicLong bytesRead = new AtomicLong();

    private VectorIoBridge() {
        this.readVectored = BindingUtils.loadInvocation(PositionedReadable.class, Void.TYPE, READ_VECTORED, List.class, IntFunction.class);
        LOG.debug("Vector IO availability: {}", (Object)this.available());
        this.hasCapabilityMethod = BindingUtils.loadInvocation(FSDataInputStream.class, Boolean.TYPE, HAS_CAPABILITY, String.class);
    }

    public boolean readVectoredAvailable(FSDataInputStream stream, ByteBufferAllocator allocator) {
        return this.available() && !allocator.isDirect();
    }

    public boolean available() {
        return !this.readVectored.isNoop() && FileRangeBridge.bridgeAvailable();
    }

    private void checkAvailable() {
        if (!this.available()) {
            throw new UnsupportedOperationException("Hadoop VectorIO not found");
        }
    }

    public void readVectoredRanges(FSDataInputStream stream, List<ParquetFileRange> ranges, ByteBufferAllocator allocator) throws IOException {
        if (!this.readVectoredAvailable(stream, allocator)) {
            throw new UnsupportedOperationException("Vectored IO not available on stream " + stream);
        }
        List<ParquetFileRange> sorted2 = VectorIoBridge.validateAndSortRanges(ranges);
        FileRangeBridge rangeBridge = FileRangeBridge.instance();
        List<FileRangeBridge.WrappedFileRange> fileRanges = sorted2.stream().map(rangeBridge::toFileRange).collect(Collectors.toList());
        this.readWrappedRanges((PositionedReadable)stream, fileRanges, allocator::allocate);
        fileRanges.forEach(fileRange -> {
            ParquetFileRange parquetFileRange = (ParquetFileRange)fileRange.getReference();
            parquetFileRange.setDataReadFuture(fileRange.getData());
        });
    }

    private void readWrappedRanges(PositionedReadable stream, List<FileRangeBridge.WrappedFileRange> ranges, IntFunction<ByteBuffer> allocate) throws IOException {
        this.vectorReads.incrementAndGet();
        this.blocksRead.addAndGet(ranges.size());
        List instances = ranges.stream().map(r -> {
            this.bytesRead.addAndGet(r.getLength());
            return r.getFileRange();
        }).collect(Collectors.toList());
        LOG.debug("readVectored with {} ranges on stream {}", (Object)ranges.size(), (Object)stream);
        try {
            this.readVectored.invokeChecked(stream, instances, allocate);
        }
        catch (Exception e) {
            Exceptions.throwIfInstance(e, IOException.class);
            Exceptions.throwIfInstance(e, RuntimeException.class);
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "VectorIoBridge{available=" + this.available() + ", readVectored=" + this.readVectored + ", vectorReads=" + this.vectorReads.get() + ", blocksRead=" + this.blocksRead.get() + ", bytesRead=" + this.bytesRead.get() + '}';
    }

    public boolean hasCapability(FSDataInputStream stream, String capability) {
        if (this.hasCapabilityMethod.isNoop()) {
            return false;
        }
        try {
            return (Boolean)this.hasCapabilityMethod.invoke(stream, capability);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public long getVectorReads() {
        return this.vectorReads.get();
    }

    public long getBlocksRead() {
        return this.blocksRead.get();
    }

    public long getBytesRead() {
        return this.bytesRead.get();
    }

    void resetCounters() {
        this.vectorReads.set(0L);
        this.blocksRead.set(0L);
        this.bytesRead.set(0L);
    }

    private static List<ParquetFileRange> sortRanges(List<ParquetFileRange> input) {
        ArrayList<ParquetFileRange> l = new ArrayList<ParquetFileRange>(input);
        l.sort(Comparator.comparingLong(ParquetFileRange::getOffset));
        return l;
    }

    private static ParquetFileRange validateRangeRequest(ParquetFileRange range) {
        Objects.requireNonNull(range, "range is null");
        Preconditions.checkArgument(range.getLength() >= 0, "length is negative in %s", (Object)range);
        Preconditions.checkArgument(range.getOffset() >= 0L, "offset is negative in %s", (Object)range);
        return range;
    }

    private static List<ParquetFileRange> validateAndSortRanges(List<ParquetFileRange> input) {
        List<ParquetFileRange> sortedRanges;
        Objects.requireNonNull(input, "Null input list");
        if (input.isEmpty()) {
            LOG.debug("Empty input list");
            return input;
        }
        if (input.size() == 1) {
            VectorIoBridge.validateRangeRequest(input.get(0));
            sortedRanges = input;
        } else {
            sortedRanges = VectorIoBridge.sortRanges(input);
            ParquetFileRange prev = null;
            for (ParquetFileRange current : sortedRanges) {
                VectorIoBridge.validateRangeRequest(current);
                if (prev != null) {
                    Preconditions.checkArgument(current.getOffset() >= prev.getOffset() + (long)prev.getLength(), "Overlapping ranges %s and %s", (Object)prev, (Object)current);
                }
                prev = current;
            }
        }
        return sortedRanges;
    }

    public static VectorIoBridge instance() {
        return INSTANCE;
    }

    public static boolean bridgeAvailable() {
        return VectorIoBridge.instance().available();
    }

    public static VectorIoBridge availableInstance() {
        VectorIoBridge bridge = VectorIoBridge.instance();
        bridge.checkAvailable();
        return bridge;
    }
}

