/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.parquet.util;

import com.dataiku.dss.shadelib.org.apache.parquet.ParquetRuntimeException;
import java.util.Arrays;

public final class AutoCloseables {
    public static void close(Iterable<? extends AutoCloseable> autoCloseables) throws Throwable {
        Throwable root = null;
        for (AutoCloseable autoCloseable : autoCloseables) {
            try {
                if (autoCloseable == null) continue;
                autoCloseable.close();
            }
            catch (Throwable e) {
                if (root == null) {
                    root = e;
                    continue;
                }
                root.addSuppressed(e);
            }
        }
        if (root != null) {
            throw root;
        }
    }

    public static void close(AutoCloseable ... autoCloseables) throws Throwable {
        AutoCloseables.close(Arrays.asList(autoCloseables));
    }

    public static void uncheckedClose(Iterable<? extends AutoCloseable> autoCloseables) throws ParquetCloseResourceException {
        try {
            AutoCloseables.close(autoCloseables);
        }
        catch (Throwable e) {
            throw new ParquetCloseResourceException(e);
        }
    }

    public static void uncheckedClose(AutoCloseable ... autoCloseables) {
        AutoCloseables.uncheckedClose(Arrays.asList(autoCloseables));
    }

    private AutoCloseables() {
    }

    public static class ParquetCloseResourceException
    extends ParquetRuntimeException {
        private ParquetCloseResourceException(Throwable e) {
            super("Unable to close resource", e);
        }
    }
}

