/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.parquet.variant;

import com.dataiku.dss.shadelib.org.apache.parquet.variant.Metadata;
import com.dataiku.dss.shadelib.org.apache.parquet.variant.VariantUtil;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.UUID;

public final class Variant {
    final ByteBuffer value;
    final ByteBuffer metadata;
    static final int BINARY_SEARCH_THRESHOLD = 32;

    public Variant(byte[] value, byte[] metadata) {
        this(value, 0, value.length, metadata, 0, metadata.length);
    }

    public Variant(byte[] value, int valuePos, int valueLength, byte[] metadata, int metadataPos, int metadataLength) {
        this(ByteBuffer.wrap(value, valuePos, valueLength), ByteBuffer.wrap(metadata, metadataPos, metadataLength));
    }

    Variant(ByteBuffer value, Metadata metadata) {
        this(value, metadata.getEncodedBuffer());
    }

    public Variant(ByteBuffer value, ByteBuffer metadata) {
        this.value = value.asReadOnlyBuffer();
        this.metadata = metadata.asReadOnlyBuffer();
        if ((metadata.get(metadata.position()) & 0xF) != 1) {
            throw new UnsupportedOperationException(String.format("Unsupported variant metadata version: %d", metadata.get(metadata.position()) & 0xF));
        }
    }

    public ByteBuffer getValueBuffer() {
        return this.value;
    }

    public ByteBuffer getMetadataBuffer() {
        return this.metadata;
    }

    public boolean getBoolean() {
        return VariantUtil.getBoolean(this.value);
    }

    public byte getByte() {
        return VariantUtil.getByte(this.value);
    }

    public short getShort() {
        return VariantUtil.getShort(this.value);
    }

    public int getInt() {
        return VariantUtil.getInt(this.value);
    }

    public long getLong() {
        return VariantUtil.getLong(this.value);
    }

    public double getDouble() {
        return VariantUtil.getDouble(this.value);
    }

    public BigDecimal getDecimal() {
        return VariantUtil.getDecimal(this.value);
    }

    public float getFloat() {
        return VariantUtil.getFloat(this.value);
    }

    public ByteBuffer getBinary() {
        return VariantUtil.getBinary(this.value);
    }

    public UUID getUUID() {
        return VariantUtil.getUUID(this.value);
    }

    public String getString() {
        return VariantUtil.getString(this.value);
    }

    public Type getType() {
        return VariantUtil.getType(this.value);
    }

    public int numObjectElements() {
        return VariantUtil.getObjectInfo((ByteBuffer)this.value).numElements;
    }

    public Variant getFieldByKey(String key) {
        VariantUtil.ObjectInfo info = VariantUtil.getObjectInfo(this.value);
        if (info.numElements < 32) {
            for (int i = 0; i < info.numElements; ++i) {
                ObjectField field = Variant.getFieldAtIndex(i, this.value, this.metadata, info.idSize, info.offsetSize, this.value.position() + info.idStartOffset, this.value.position() + info.offsetStartOffset, this.value.position() + info.dataStartOffset);
                if (!field.key.equals(key)) continue;
                return field.value;
            }
        } else {
            int low = 0;
            int high = info.numElements - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                ObjectField field = Variant.getFieldAtIndex(mid, this.value, this.metadata, info.idSize, info.offsetSize, this.value.position() + info.idStartOffset, this.value.position() + info.offsetStartOffset, this.value.position() + info.dataStartOffset);
                int cmp = field.key.compareTo(key);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return field.value;
            }
        }
        return null;
    }

    public ObjectField getFieldAtIndex(int idx) {
        VariantUtil.ObjectInfo info = VariantUtil.getObjectInfo(this.value);
        ObjectField field = Variant.getFieldAtIndex(idx, this.value, this.metadata, info.idSize, info.offsetSize, this.value.position() + info.idStartOffset, this.value.position() + info.offsetStartOffset, this.value.position() + info.dataStartOffset);
        return field;
    }

    static ObjectField getFieldAtIndex(int index, ByteBuffer value, ByteBuffer metadata, int idSize, int offsetSize, int idStart, int offsetStart, int dataStart) {
        int id = VariantUtil.readUnsigned(value, idStart + idSize * index, idSize);
        int offset = VariantUtil.readUnsigned(value, offsetStart + offsetSize * index, offsetSize);
        String key = VariantUtil.getMetadataKey(metadata, id);
        Variant v = new Variant(VariantUtil.slice(value, dataStart + offset), metadata);
        return new ObjectField(key, v);
    }

    public int numArrayElements() {
        return VariantUtil.getArrayInfo((ByteBuffer)this.value).numElements;
    }

    public Variant getElementAtIndex(int index) {
        VariantUtil.ArrayInfo info = VariantUtil.getArrayInfo(this.value);
        if (index < 0 || index >= info.numElements) {
            return null;
        }
        return Variant.getElementAtIndex(index, this.value, this.metadata, info.offsetSize, this.value.position() + info.offsetStartOffset, this.value.position() + info.dataStartOffset);
    }

    private static Variant getElementAtIndex(int index, ByteBuffer value, ByteBuffer metadata, int offsetSize, int offsetStart, int dataStart) {
        int offset = VariantUtil.readUnsigned(value, offsetStart + offsetSize * index, offsetSize);
        return new Variant(VariantUtil.slice(value, dataStart + offset), metadata);
    }

    public static final class ObjectField {
        public final String key;
        public final Variant value;

        public ObjectField(String key, Variant value) {
            this.key = key;
            this.value = value;
        }
    }

    public static enum Type {
        OBJECT,
        ARRAY,
        NULL,
        BOOLEAN,
        BYTE,
        SHORT,
        INT,
        LONG,
        STRING,
        DOUBLE,
        DECIMAL4,
        DECIMAL8,
        DECIMAL16,
        DATE,
        TIMESTAMP_TZ,
        TIMESTAMP_NTZ,
        FLOAT,
        BINARY,
        TIME,
        TIMESTAMP_NANOS_TZ,
        TIMESTAMP_NANOS_NTZ,
        UUID;

    }
}

