/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.api.v2.params;

import com.dataiku.dss.shadelib.javax.annotation.Nonnull;
import com.dataiku.dss.shadelib.javax.annotation.Nullable;
import com.dataiku.dss.shadelib.org.projectnessie.api.v2.params.ParsedReference;
import com.dataiku.dss.shadelib.org.projectnessie.model.Reference;
import com.dataiku.dss.shadelib.org.projectnessie.model.Validation;
import java.util.function.Supplier;
import java.util.regex.Matcher;

public final class ReferenceResolver {
    private static final String DEFAULT_REF_IN_PATH = "-";

    private ReferenceResolver() {
    }

    public static ParsedReference resolveReferencePathElement(@Nonnull @jakarta.annotation.Nonnull String refPathString, @Nullable @jakarta.annotation.Nullable Reference.ReferenceType namedRefType, @Nonnull @jakarta.annotation.Nonnull Supplier<String> defaultBranchSupplier) {
        Matcher refNameMatcher = Validation.REF_NAME_PATH_PATTERN.matcher(refPathString);
        if (!refNameMatcher.find()) {
            throw new IllegalArgumentException("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'");
        }
        String name = refNameMatcher.group(1);
        if (DEFAULT_REF_IN_PATH.equals(name)) {
            name = defaultBranchSupplier.get();
        }
        Object hash = refNameMatcher.group(2);
        String relativeSpec = refNameMatcher.group(3);
        if (hash != null && relativeSpec != null) {
            hash = (String)hash + relativeSpec;
        } else if (relativeSpec != null) {
            hash = relativeSpec;
        }
        return ParsedReference.parsedReference(name, (String)hash, name != null ? namedRefType : null);
    }
}

