/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.api.ns;

import com.dataiku.dss.shadelib.org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.CreateNamespaceResult;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.GetContentBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.NessieApiV2;
import com.dataiku.dss.shadelib.org.projectnessie.client.builder.BaseCreateNamespaceBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.error.ContentKeyErrorDetails;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieConflictException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieNamespaceAlreadyExistsException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieReferenceNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.model.Branch;
import com.dataiku.dss.shadelib.org.projectnessie.model.CommitMeta;
import com.dataiku.dss.shadelib.org.projectnessie.model.CommitResponse;
import com.dataiku.dss.shadelib.org.projectnessie.model.Content;
import com.dataiku.dss.shadelib.org.projectnessie.model.ContentKey;
import com.dataiku.dss.shadelib.org.projectnessie.model.GetMultipleContentsResponse;
import com.dataiku.dss.shadelib.org.projectnessie.model.ImmutableNamespace;
import com.dataiku.dss.shadelib.org.projectnessie.model.Namespace;
import com.dataiku.dss.shadelib.org.projectnessie.model.Operation;
import java.util.Map;

public final class ClientSideCreateNamespace
extends BaseCreateNamespaceBuilder {
    private final NessieApiV2 api;

    public ClientSideCreateNamespace(NessieApiV2 api) {
        this.api = api;
    }

    @Override
    public Namespace create() throws NessieReferenceNotFoundException, NessieNamespaceAlreadyExistsException {
        return this.createWithResponse().getNamespace();
    }

    @Override
    public CreateNamespaceResult createWithResponse() throws NessieReferenceNotFoundException, NessieNamespaceAlreadyExistsException {
        GetMultipleContentsResponse contentsResponse;
        if (this.namespace.isEmpty()) {
            throw new IllegalArgumentException("Creating empty namespaces is not supported");
        }
        ImmutableNamespace content = Namespace.builder().from(this.namespace).properties(this.properties).build();
        ContentKey key = this.namespace.toContentKey();
        try {
            contentsResponse = ((GetContentBuilder)((GetContentBuilder)this.api.getContent().refName(this.refName)).hashOnRef(this.hashOnRef)).key(key).getWithResponse();
        }
        catch (NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
        Map<ContentKey, Content> contentMap = contentsResponse.toContentsMap();
        Content existing = contentMap.get(key);
        if (existing != null) {
            if (existing instanceof Namespace) {
                throw new NessieNamespaceAlreadyExistsException(ContentKeyErrorDetails.contentKeyErrorDetails(key), String.format("Namespace '%s' already exists", key.toCanonicalString()));
            }
            throw new NessieNamespaceAlreadyExistsException(ContentKeyErrorDetails.contentKeyErrorDetails(key), String.format("Another content object with name '%s' already exists", key.toCanonicalString()));
        }
        try {
            Branch branch = (Branch)contentsResponse.getEffectiveReference();
            CommitMeta meta = this.commitMeta;
            if (meta == null) {
                meta = CommitMeta.fromMessage("create namespace " + String.valueOf(key));
            } else if (meta.getMessage().isEmpty()) {
                meta = CommitMeta.builder().from(meta).message("update namespace " + String.valueOf(key)).build();
            }
            CommitResponse committed = ((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().commitMeta(meta).branch(branch)).operation(Operation.Put.of(key, content)).commitWithResponse();
            Namespace created = ((Namespace)content).withId(committed.toAddedContentsMap().get(key));
            return CreateNamespaceResult.of(created, committed.getTargetBranch());
        }
        catch (NessieConflictException | NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
    }
}

