/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.auth;

import com.dataiku.dss.shadelib.org.projectnessie.client.auth.NessieAuthenticationProvider;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.HttpAuthentication;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.HttpClient;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.RequestContext;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.function.Function;
import java.util.function.Supplier;

public class BasicAuthenticationProvider
implements NessieAuthenticationProvider {
    public static final String AUTH_TYPE_VALUE = "BASIC";

    public static HttpAuthentication create(String username, String password) {
        return new BasicAuthentication(username, password);
    }

    public static HttpAuthentication create(String username, Supplier<String> passwordSupplier) {
        if (username == null || passwordSupplier == null) {
            throw new NullPointerException("username and password supplier must be non-null");
        }
        return new BasicAuthentication(username, passwordSupplier);
    }

    @Override
    public String getAuthTypeValue() {
        return AUTH_TYPE_VALUE;
    }

    @Override
    public HttpAuthentication build(Function<String, String> configSupplier) {
        String password;
        String username = configSupplier.apply("nessie.authentication.username");
        if (username == null) {
            username = configSupplier.apply("nessie.username");
        }
        if ((password = configSupplier.apply("nessie.authentication.password")) == null) {
            password = configSupplier.apply("nessie.password");
        }
        return new BasicAuthentication(username, password);
    }

    private static class BasicAuthentication
    implements HttpAuthentication {
        private final Supplier<String> headerSupplier;

        private static String basicHeader(String username, String password) {
            if (username == null || password == null) {
                throw new NullPointerException("username and password parameters must be present for auth type BASIC");
            }
            String userPass = username + ":" + password;
            byte[] encoded = Base64.getEncoder().encode(userPass.getBytes(StandardCharsets.UTF_8));
            String encodedString = new String(encoded, StandardCharsets.UTF_8);
            return "Basic " + encodedString;
        }

        private BasicAuthentication(String username, String password) {
            String header = BasicAuthentication.basicHeader(username, password);
            this.headerSupplier = () -> header;
        }

        private BasicAuthentication(String username, Supplier<String> passwordSupplier) {
            this.headerSupplier = () -> BasicAuthentication.basicHeader(username, (String)passwordSupplier.get());
        }

        @Override
        public void applyToHttpClient(HttpClient.Builder client) {
            client.addRequestFilter(this::applyToHttpRequest);
        }

        @Override
        public void applyToHttpRequest(RequestContext context) {
            context.putHeader("Authorization", this.headerSupplier.get());
        }
    }
}

