/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonValue;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.AuthorizationCodeFlow;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.ClientCredentialsFlow;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.DeviceCodeFlow;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.Flow;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.OAuth2ClientConfig;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.PasswordFlow;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.RefreshTokensFlow;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.TokenExchangeFlow;
import java.util.Locale;

public enum GrantType {
    CLIENT_CREDENTIALS("client_credentials"){

        @Override
        Flow newFlow(OAuth2ClientConfig config) {
            return new ClientCredentialsFlow(config);
        }
    }
    ,
    PASSWORD("password"){

        @Override
        Flow newFlow(OAuth2ClientConfig config) {
            return new PasswordFlow(config);
        }
    }
    ,
    AUTHORIZATION_CODE("authorization_code"){

        @Override
        Flow newFlow(OAuth2ClientConfig config) {
            return new AuthorizationCodeFlow(config);
        }
    }
    ,
    DEVICE_CODE("urn:ietf:params:oauth:grant-type:device_code"){

        @Override
        Flow newFlow(OAuth2ClientConfig config) {
            return new DeviceCodeFlow(config);
        }
    }
    ,
    REFRESH_TOKEN("refresh_token"){

        @Override
        Flow newFlow(OAuth2ClientConfig config) {
            return new RefreshTokensFlow(config);
        }
    }
    ,
    TOKEN_EXCHANGE("urn:ietf:params:oauth:grant-type:token-exchange"){

        @Override
        Flow newFlow(OAuth2ClientConfig config) {
            return new TokenExchangeFlow(config);
        }
    };

    private final String canonicalName;

    private GrantType(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    @JsonValue
    public String canonicalName() {
        return this.canonicalName;
    }

    public static GrantType fromConfigName(String name) {
        for (GrantType grantType : GrantType.values()) {
            if (!grantType.name().equals(name.toUpperCase(Locale.ROOT)) && !grantType.canonicalName.equals(name)) continue;
            return grantType;
        }
        throw new IllegalArgumentException("Unknown grant type: " + name);
    }

    abstract Flow newFlow(OAuth2ClientConfig var1);

    public boolean requiresUserInteraction() {
        return this == AUTHORIZATION_CODE || this == DEVICE_CODE;
    }

    public boolean isInitial() {
        return this != REFRESH_TOKEN;
    }

    public static class Constants {
        public static final String CLIENT_CREDENTIALS = "client_credentials";
        public static final String PASSWORD = "password";
        public static final String AUTHORIZATION_CODE = "authorization_code";
        public static final String DEVICE_CODE = "urn:ietf:params:oauth:grant-type:device_code";
        public static final String REFRESH_TOKEN = "refresh_token";
        public static final String TOKEN_EXCHANGE = "urn:ietf:params:oauth:grant-type:token-exchange";
    }
}

