/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonCreator;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonIgnore;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonProperty;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.dataiku.dss.shadelib.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.dataiku.dss.shadelib.javax.annotation.CheckReturnValue;
import com.dataiku.dss.shadelib.javax.annotation.Nullable;
import com.dataiku.dss.shadelib.javax.annotation.ParametersAreNonnullByDefault;
import com.dataiku.dss.shadelib.javax.annotation.concurrent.Immutable;
import com.dataiku.dss.shadelib.javax.annotation.concurrent.NotThreadSafe;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.DeviceCodeTokenResponse;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.TokenResponseBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DeviceCodeTokenResponse", generator="Immutables")
@Immutable
final class ImmutableDeviceCodeTokenResponse
implements DeviceCodeTokenResponse {
    private final String tokenType;
    private final String accessTokenPayload;
    @Nullable
    private final Integer accessTokenExpiresInSeconds;
    @Nullable
    private final String refreshTokenPayload;
    @Nullable
    private final Integer refreshTokenExpiresInSeconds;
    @Nullable
    private final String scope;
    private final Map<String, Object> extraParameters;

    private ImmutableDeviceCodeTokenResponse(String tokenType, String accessTokenPayload, @Nullable Integer accessTokenExpiresInSeconds, @Nullable String refreshTokenPayload, @Nullable Integer refreshTokenExpiresInSeconds, @Nullable String scope, Map<String, Object> extraParameters) {
        this.tokenType = tokenType;
        this.accessTokenPayload = accessTokenPayload;
        this.accessTokenExpiresInSeconds = accessTokenExpiresInSeconds;
        this.refreshTokenPayload = refreshTokenPayload;
        this.refreshTokenExpiresInSeconds = refreshTokenExpiresInSeconds;
        this.scope = scope;
        this.extraParameters = extraParameters;
    }

    @Override
    @JsonProperty(value="token_type")
    public String getTokenType() {
        return this.tokenType;
    }

    @Override
    @JsonProperty(value="access_token")
    public String getAccessTokenPayload() {
        return this.accessTokenPayload;
    }

    @Override
    @JsonProperty(value="expires_in")
    @JsonUnwrapped
    @Nullable
    public Integer getAccessTokenExpiresInSeconds() {
        return this.accessTokenExpiresInSeconds;
    }

    @Override
    @JsonProperty(value="refresh_token")
    @Nullable
    public String getRefreshTokenPayload() {
        return this.refreshTokenPayload;
    }

    @Override
    @JsonProperty(value="refresh_expires_in")
    @Nullable
    public Integer getRefreshTokenExpiresInSeconds() {
        return this.refreshTokenExpiresInSeconds;
    }

    @Override
    @JsonProperty(value="scope")
    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Override
    @JsonProperty(value="extraParameters")
    @JsonAnyGetter
    public Map<String, Object> getExtraParameters() {
        return this.extraParameters;
    }

    public final ImmutableDeviceCodeTokenResponse withTokenType(String value) {
        String newValue = Objects.requireNonNull(value, "tokenType");
        if (this.tokenType.equals(newValue)) {
            return this;
        }
        return new ImmutableDeviceCodeTokenResponse(newValue, this.accessTokenPayload, this.accessTokenExpiresInSeconds, this.refreshTokenPayload, this.refreshTokenExpiresInSeconds, this.scope, this.extraParameters);
    }

    public final ImmutableDeviceCodeTokenResponse withAccessTokenPayload(String value) {
        String newValue = Objects.requireNonNull(value, "accessTokenPayload");
        if (this.accessTokenPayload.equals(newValue)) {
            return this;
        }
        return new ImmutableDeviceCodeTokenResponse(this.tokenType, newValue, this.accessTokenExpiresInSeconds, this.refreshTokenPayload, this.refreshTokenExpiresInSeconds, this.scope, this.extraParameters);
    }

    public final ImmutableDeviceCodeTokenResponse withAccessTokenExpiresInSeconds(@Nullable Integer value) {
        if (Objects.equals(this.accessTokenExpiresInSeconds, value)) {
            return this;
        }
        return new ImmutableDeviceCodeTokenResponse(this.tokenType, this.accessTokenPayload, value, this.refreshTokenPayload, this.refreshTokenExpiresInSeconds, this.scope, this.extraParameters);
    }

    public final ImmutableDeviceCodeTokenResponse withRefreshTokenPayload(@Nullable String value) {
        if (Objects.equals(this.refreshTokenPayload, value)) {
            return this;
        }
        return new ImmutableDeviceCodeTokenResponse(this.tokenType, this.accessTokenPayload, this.accessTokenExpiresInSeconds, value, this.refreshTokenExpiresInSeconds, this.scope, this.extraParameters);
    }

    public final ImmutableDeviceCodeTokenResponse withRefreshTokenExpiresInSeconds(@Nullable Integer value) {
        if (Objects.equals(this.refreshTokenExpiresInSeconds, value)) {
            return this;
        }
        return new ImmutableDeviceCodeTokenResponse(this.tokenType, this.accessTokenPayload, this.accessTokenExpiresInSeconds, this.refreshTokenPayload, value, this.scope, this.extraParameters);
    }

    public final ImmutableDeviceCodeTokenResponse withScope(@Nullable String value) {
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return new ImmutableDeviceCodeTokenResponse(this.tokenType, this.accessTokenPayload, this.accessTokenExpiresInSeconds, this.refreshTokenPayload, this.refreshTokenExpiresInSeconds, value, this.extraParameters);
    }

    public final ImmutableDeviceCodeTokenResponse withExtraParameters(Map<String, ? extends Object> entries) {
        if (this.extraParameters == entries) {
            return this;
        }
        Map<String, Object> newValue = ImmutableDeviceCodeTokenResponse.createUnmodifiableMap(true, false, entries);
        return new ImmutableDeviceCodeTokenResponse(this.tokenType, this.accessTokenPayload, this.accessTokenExpiresInSeconds, this.refreshTokenPayload, this.refreshTokenExpiresInSeconds, this.scope, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeviceCodeTokenResponse && this.equalsByValue((ImmutableDeviceCodeTokenResponse)another);
    }

    private boolean equalsByValue(ImmutableDeviceCodeTokenResponse another) {
        return this.tokenType.equals(another.tokenType) && this.accessTokenPayload.equals(another.accessTokenPayload) && Objects.equals(this.accessTokenExpiresInSeconds, another.accessTokenExpiresInSeconds) && Objects.equals(this.refreshTokenPayload, another.refreshTokenPayload) && Objects.equals(this.refreshTokenExpiresInSeconds, another.refreshTokenExpiresInSeconds) && Objects.equals(this.scope, another.scope) && this.extraParameters.equals(another.extraParameters);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.tokenType.hashCode();
        h2 += (h2 << 5) + this.accessTokenPayload.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.accessTokenExpiresInSeconds);
        h2 += (h2 << 5) + Objects.hashCode(this.refreshTokenPayload);
        h2 += (h2 << 5) + Objects.hashCode(this.refreshTokenExpiresInSeconds);
        h2 += (h2 << 5) + Objects.hashCode(this.scope);
        h2 += (h2 << 5) + this.extraParameters.hashCode();
        return h2;
    }

    public String toString() {
        return "DeviceCodeTokenResponse{tokenType=" + this.tokenType + ", accessTokenPayload=" + this.accessTokenPayload + ", accessTokenExpiresInSeconds=" + this.accessTokenExpiresInSeconds + ", refreshTokenPayload=" + this.refreshTokenPayload + ", refreshTokenExpiresInSeconds=" + this.refreshTokenExpiresInSeconds + ", scope=" + this.scope + ", extraParameters=" + String.valueOf(this.extraParameters) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDeviceCodeTokenResponse fromJson(Json json) {
        Builder builder = ImmutableDeviceCodeTokenResponse.builder();
        if (json._tokenType != null) {
            builder.tokenType(json._tokenType);
        }
        if (json._accessTokenPayload != null) {
            builder.accessTokenPayload(json._accessTokenPayload);
        }
        if (json._accessTokenExpiresInSeconds != null) {
            builder.accessTokenExpiresInSeconds(json._accessTokenExpiresInSeconds);
        }
        if (json._refreshTokenPayload != null) {
            builder.refreshTokenPayload(json._refreshTokenPayload);
        }
        if (json._refreshTokenExpiresInSeconds != null) {
            builder.refreshTokenExpiresInSeconds(json._refreshTokenExpiresInSeconds);
        }
        if (json._scope != null) {
            builder.scope(json._scope);
        }
        if (json._extraParameters != null) {
            builder.putAllExtraParameters(json._extraParameters);
        }
        return builder.build();
    }

    public static ImmutableDeviceCodeTokenResponse copyOf(DeviceCodeTokenResponse instance) {
        if (instance instanceof ImmutableDeviceCodeTokenResponse) {
            return (ImmutableDeviceCodeTokenResponse)instance;
        }
        return ImmutableDeviceCodeTokenResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="DeviceCodeTokenResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOKEN_TYPE = 1L;
        private static final long INIT_BIT_ACCESS_TOKEN_PAYLOAD = 2L;
        private long initBits = 3L;
        private String tokenType;
        private String accessTokenPayload;
        private Integer accessTokenExpiresInSeconds;
        private String refreshTokenPayload;
        private Integer refreshTokenExpiresInSeconds;
        private String scope;
        private Map<String, Object> extraParameters = new LinkedHashMap<String, Object>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DeviceCodeTokenResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TokenResponseBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            Integer accessTokenExpiresInSecondsValue;
            String refreshTokenPayloadValue;
            String scopeValue;
            Integer refreshTokenExpiresInSecondsValue;
            TokenResponseBase instance;
            long bits = 0L;
            if (object instanceof DeviceCodeTokenResponse) {
                instance = (DeviceCodeTokenResponse)object;
                if ((bits & 1L) == 0L) {
                    this.accessTokenPayload(instance.getAccessTokenPayload());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    refreshTokenExpiresInSecondsValue = instance.getRefreshTokenExpiresInSeconds();
                    if (refreshTokenExpiresInSecondsValue != null) {
                        this.refreshTokenExpiresInSeconds(refreshTokenExpiresInSecondsValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    refreshTokenPayloadValue = instance.getRefreshTokenPayload();
                    if (refreshTokenPayloadValue != null) {
                        this.refreshTokenPayload(refreshTokenPayloadValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.putAllExtraParameters(instance.getExtraParameters());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.tokenType(instance.getTokenType());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    accessTokenExpiresInSecondsValue = instance.getAccessTokenExpiresInSeconds();
                    if (accessTokenExpiresInSecondsValue != null) {
                        this.accessTokenExpiresInSeconds(accessTokenExpiresInSecondsValue);
                    }
                    bits |= 0x40L;
                }
            }
            if (object instanceof TokenResponseBase) {
                instance = (TokenResponseBase)object;
                if ((bits & 1L) == 0L) {
                    this.accessTokenPayload(instance.getAccessTokenPayload());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    refreshTokenExpiresInSecondsValue = instance.getRefreshTokenExpiresInSeconds();
                    if (refreshTokenExpiresInSecondsValue != null) {
                        this.refreshTokenExpiresInSeconds(refreshTokenExpiresInSecondsValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    refreshTokenPayloadValue = instance.getRefreshTokenPayload();
                    if (refreshTokenPayloadValue != null) {
                        this.refreshTokenPayload(refreshTokenPayloadValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.putAllExtraParameters(instance.getExtraParameters());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.tokenType(instance.getTokenType());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    accessTokenExpiresInSecondsValue = instance.getAccessTokenExpiresInSeconds();
                    if (accessTokenExpiresInSecondsValue != null) {
                        this.accessTokenExpiresInSeconds(accessTokenExpiresInSecondsValue);
                    }
                    bits |= 0x40L;
                }
            }
        }

        @JsonProperty(value="token_type")
        @CanIgnoreReturnValue
        public final Builder tokenType(String tokenType) {
            this.tokenType = Objects.requireNonNull(tokenType, "tokenType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="access_token")
        @CanIgnoreReturnValue
        public final Builder accessTokenPayload(String accessTokenPayload) {
            this.accessTokenPayload = Objects.requireNonNull(accessTokenPayload, "accessTokenPayload");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="expires_in")
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder accessTokenExpiresInSeconds(@Nullable Integer accessTokenExpiresInSeconds) {
            this.accessTokenExpiresInSeconds = accessTokenExpiresInSeconds;
            return this;
        }

        @JsonProperty(value="refresh_token")
        @CanIgnoreReturnValue
        public final Builder refreshTokenPayload(@Nullable String refreshTokenPayload) {
            this.refreshTokenPayload = refreshTokenPayload;
            return this;
        }

        @JsonProperty(value="refresh_expires_in")
        @CanIgnoreReturnValue
        public final Builder refreshTokenExpiresInSeconds(@Nullable Integer refreshTokenExpiresInSeconds) {
            this.refreshTokenExpiresInSeconds = refreshTokenExpiresInSeconds;
            return this;
        }

        @JsonProperty(value="scope")
        @CanIgnoreReturnValue
        public final Builder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putExtraParameter(String key, Object value) {
            this.extraParameters.put(Objects.requireNonNull(key, "extraParameters key"), Objects.requireNonNull(value, value == null ? "extraParameters value for key: " + key : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExtraParameter(Map.Entry<String, ? extends Object> entry) {
            Object v;
            String k = entry.getKey();
            this.extraParameters.put(Objects.requireNonNull(k, "extraParameters key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "extraParameters value for key: " + k : null));
            return this;
        }

        @JsonProperty(value="extraParameters")
        @CanIgnoreReturnValue
        public final Builder extraParameters(Map<String, ? extends Object> entries) {
            this.extraParameters.clear();
            return this.putAllExtraParameters(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllExtraParameters(Map<String, ? extends Object> entries) {
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                Object v;
                String k = e.getKey();
                this.extraParameters.put(Objects.requireNonNull(k, "extraParameters key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "extraParameters value for key: " + k : null));
            }
            return this;
        }

        public ImmutableDeviceCodeTokenResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDeviceCodeTokenResponse(this.tokenType, this.accessTokenPayload, this.accessTokenExpiresInSeconds, this.refreshTokenPayload, this.refreshTokenExpiresInSeconds, this.scope, ImmutableDeviceCodeTokenResponse.createUnmodifiableMap(false, false, this.extraParameters));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tokenType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessTokenPayload");
            }
            return "Cannot build DeviceCodeTokenResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="DeviceCodeTokenResponse", generator="Immutables")
    static final class Json
    implements DeviceCodeTokenResponse {
        @JsonIgnore
        String _tokenType;
        @JsonIgnore
        String _accessTokenPayload;
        @JsonIgnore
        Integer _accessTokenExpiresInSeconds;
        @JsonIgnore
        String _refreshTokenPayload;
        @JsonIgnore
        Integer _refreshTokenExpiresInSeconds;
        @JsonIgnore
        String _scope;
        @JsonIgnore
        final Map<String, Object> _extraParameters = new HashMap<String, Object>();

        Json() {
        }

        @JsonProperty(value="token_type")
        public void setTokenType(String tokenType) {
            this._tokenType = tokenType;
        }

        @JsonProperty(value="access_token")
        public void setAccessTokenPayload(String accessTokenPayload) {
            this._accessTokenPayload = accessTokenPayload;
        }

        @JsonProperty(value="expires_in")
        @JsonUnwrapped
        public void setAccessTokenExpiresInSeconds(@Nullable Integer accessTokenExpiresInSeconds) {
            this._accessTokenExpiresInSeconds = accessTokenExpiresInSeconds;
        }

        @JsonProperty(value="refresh_token")
        public void setRefreshTokenPayload(@Nullable String refreshTokenPayload) {
            this._refreshTokenPayload = refreshTokenPayload;
        }

        @JsonProperty(value="refresh_expires_in")
        public void setRefreshTokenExpiresInSeconds(@Nullable Integer refreshTokenExpiresInSeconds) {
            this._refreshTokenExpiresInSeconds = refreshTokenExpiresInSeconds;
        }

        @JsonProperty(value="scope")
        public void setScope(@Nullable String scope) {
            this._scope = scope;
        }

        @JsonAnySetter
        public void setExtraParameters(String key, Object value) {
            this._extraParameters.put(key, value);
        }

        @Override
        public String getTokenType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAccessTokenPayload() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getAccessTokenExpiresInSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRefreshTokenPayload() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getRefreshTokenExpiresInSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getExtraParameters() {
            throw new UnsupportedOperationException();
        }
    }
}

