/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonProperty;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.dataiku.dss.shadelib.javax.annotation.Nullable;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.ImmutableAccessToken;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.ImmutableRefreshToken;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.Tokens;
import java.time.Instant;
import java.util.Map;
import java.util.function.Supplier;

interface TokenResponseBase {
    default public Tokens asTokens(Supplier<Instant> clock) {
        Instant now = clock.get();
        Integer accessExpiresIn = this.getAccessTokenExpiresInSeconds();
        ImmutableAccessToken accessToken = ImmutableAccessToken.builder().tokenType(this.getTokenType()).payload(this.getAccessTokenPayload()).expirationTime(accessExpiresIn == null ? null : now.plusSeconds(accessExpiresIn.intValue())).build();
        String refreshTokenPayload = this.getRefreshTokenPayload();
        Integer refreshExpiresIn = this.getRefreshTokenExpiresInSeconds();
        ImmutableRefreshToken refreshToken = refreshTokenPayload == null ? null : ImmutableRefreshToken.builder().payload(refreshTokenPayload).expirationTime(refreshExpiresIn == null ? null : now.plusSeconds(refreshExpiresIn.intValue())).build();
        return Tokens.of(accessToken, refreshToken);
    }

    @JsonProperty(value="token_type")
    public String getTokenType();

    @JsonProperty(value="access_token")
    public String getAccessTokenPayload();

    @Nullable
    @JsonProperty(value="expires_in")
    @JsonUnwrapped
    public Integer getAccessTokenExpiresInSeconds();

    @Nullable
    @JsonProperty(value="refresh_token")
    public String getRefreshTokenPayload();

    @Nullable
    @JsonProperty(value="refresh_expires_in")
    public Integer getRefreshTokenExpiresInSeconds();

    @Nullable
    @JsonProperty(value="scope")
    public String getScope();

    @JsonAnyGetter
    public Map<String, Object> getExtraParameters();
}

