/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.http;

public class NessieApiCompatibilityException
extends RuntimeException {
    private final int clientApiVersion;
    private final int minServerApiVersion;
    private final int maxServerApiVersion;
    private final int actualServerApiVersion;

    public NessieApiCompatibilityException(int clientApiVersion, int minServerApiVersion, int maxServerApiVersion, int actualServerApiVersion) {
        super(NessieApiCompatibilityException.formatMessage(clientApiVersion, minServerApiVersion, maxServerApiVersion, actualServerApiVersion));
        this.clientApiVersion = clientApiVersion;
        this.minServerApiVersion = minServerApiVersion;
        this.maxServerApiVersion = maxServerApiVersion;
        this.actualServerApiVersion = actualServerApiVersion;
    }

    private static String formatMessage(int clientApiVersion, int minServerApiVersion, int maxServerApiVersion, int actualServerApiVersion) {
        if (clientApiVersion < minServerApiVersion) {
            return String.format("API version %d is too old for server (minimum supported version is %d)", clientApiVersion, minServerApiVersion);
        }
        if (clientApiVersion > maxServerApiVersion) {
            return String.format("API version %d is too new for server (maximum supported version is %d)", clientApiVersion, maxServerApiVersion);
        }
        return String.format("API version mismatch, check URI prefix (expected: %d, actual: %d)", clientApiVersion, actualServerApiVersion);
    }

    public int getClientApiVersion() {
        return this.clientApiVersion;
    }

    public int getMinServerApiVersion() {
        return this.minServerApiVersion;
    }

    public int getMaxServerApiVersion() {
        return this.maxServerApiVersion;
    }

    public int getActualServerApiVersion() {
        return this.actualServerApiVersion;
    }
}

