/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.error;

import com.dataiku.dss.shadelib.org.projectnessie.error.ErrorCode;
import com.dataiku.dss.shadelib.org.projectnessie.error.ErrorCodeAware;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieError;
import java.io.IOException;

public abstract class BaseNessieClientServerException
extends IOException
implements ErrorCodeAware {
    private final String serverStackTrace;

    protected BaseNessieClientServerException(String message, Throwable cause) {
        super(message, cause);
        this.serverStackTrace = null;
    }

    protected BaseNessieClientServerException(String message) {
        super(message);
        this.serverStackTrace = null;
    }

    protected BaseNessieClientServerException(NessieError error) {
        super(error.getMessage());
        this.serverStackTrace = error.getServerStackTrace();
    }

    public int getStatus() {
        return this.getErrorCode().httpStatus();
    }

    @Override
    public ErrorCode getErrorCode() {
        return ErrorCode.UNKNOWN;
    }

    public String getServerStackTrace() {
        return this.serverStackTrace;
    }
}

