/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.model;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonParser;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.DeserializationContext;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonDeserializer;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.dataiku.dss.shadelib.javax.annotation.Nullable;
import com.dataiku.dss.shadelib.org.projectnessie.model.ContentKey;
import com.dataiku.dss.shadelib.org.projectnessie.model.ImmutableConflict;
import java.io.IOException;
import java.util.Locale;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.media.SchemaProperty;
import org.immutables.value.Value;

@Schema(type=SchemaType.OBJECT, title="Per Content Key conflict details", properties={@SchemaProperty(name="conflictType", description="Conflict type (enum)."), @SchemaProperty(name="key", description="The conflicting Content Key."), @SchemaProperty(name="message", description="Conflict details.")})
@JsonSerialize(as=ImmutableConflict.class)
@JsonDeserialize(as=ImmutableConflict.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@Value.Immutable
public interface Conflict {
    @JsonDeserialize(using=ConflictType.Deserializer.class)
    @Value.Parameter(order=1)
    public ConflictType conflictType();

    @Nullable
    @jakarta.annotation.Nullable
    @Value.Parameter(order=2)
    public ContentKey key();

    @Value.Parameter(order=3)
    public String message();

    public static Conflict conflict(ConflictType conflictType, @Nullable @jakarta.annotation.Nullable ContentKey key, String message) {
        return ImmutableConflict.of(conflictType, key, message);
    }

    public static enum ConflictType {
        UNKNOWN,
        KEY_EXISTS,
        KEY_DOES_NOT_EXIST,
        PAYLOAD_DIFFERS,
        CONTENT_ID_DIFFERS,
        VALUE_DIFFERS,
        NAMESPACE_ABSENT,
        NOT_A_NAMESPACE,
        NAMESPACE_NOT_EMPTY,
        UNEXPECTED_HASH,
        KEY_CONFLICT,
        DOCUMENTATION_DIFFERS;


        public static ConflictType parse(String conflictType) {
            try {
                if (conflictType != null) {
                    return ConflictType.valueOf(conflictType.toUpperCase(Locale.ROOT));
                }
                return null;
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public static final class Deserializer
        extends JsonDeserializer<ConflictType> {
            @Override
            public ConflictType getNullValue(DeserializationContext ctxt) {
                return UNKNOWN;
            }

            @Override
            public ConflictType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                String name = p.readValueAs(String.class);
                return ConflictType.parse(name);
            }
        }
    }
}

