/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.model;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonIgnore;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import com.dataiku.dss.shadelib.org.projectnessie.model.DeltaLakeTable;
import com.dataiku.dss.shadelib.org.projectnessie.model.IcebergTable;
import com.dataiku.dss.shadelib.org.projectnessie.model.IcebergView;
import com.dataiku.dss.shadelib.org.projectnessie.model.Namespace;
import com.dataiku.dss.shadelib.org.projectnessie.model.UDF;
import com.dataiku.dss.shadelib.org.projectnessie.model.Util;
import com.dataiku.dss.shadelib.org.projectnessie.model.types.ContentTypeIdResolver;
import com.dataiku.dss.shadelib.org.projectnessie.model.types.ContentTypes;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.DiscriminatorMapping;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;

@Schema(type=SchemaType.OBJECT, title="Content", anyOf={IcebergTable.class, DeltaLakeTable.class, IcebergView.class, Namespace.class, UDF.class, Map.class}, discriminatorMapping={@DiscriminatorMapping(value="ICEBERG_TABLE", schema=IcebergTable.class), @DiscriminatorMapping(value="DELTA_LAKE_TABLE", schema=DeltaLakeTable.class), @DiscriminatorMapping(value="ICEBERG_VIEW", schema=IcebergView.class), @DiscriminatorMapping(value="NAMESPACE", schema=Namespace.class), @DiscriminatorMapping(value="UDF", schema=UDF.class)}, discriminatorProperty="type")
@JsonTypeIdResolver(value=ContentTypeIdResolver.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="type", visible=true)
public abstract class Content {
    @com.dataiku.dss.shadelib.javax.annotation.Nullable
    @Nullable
    public abstract String getId();

    @JsonIgnore
    @Value.Redacted
    public abstract Type getType();

    public abstract Content withId(String var1);

    public <T> Optional<T> unwrap(Class<T> clazz) {
        Objects.requireNonNull(clazz, "class argument");
        if (clazz.isAssignableFrom(this.getClass())) {
            return Optional.of(clazz.cast(this));
        }
        return Optional.empty();
    }

    @JsonDeserialize(using=Util.ContentTypeDeserializer.class)
    @JsonSerialize(using=Util.ContentTypeSerializer.class)
    @Schema(type=SchemaType.STRING, description="Declares the type of a Nessie content object, which is currently one of ICEBERG_TABLE, DELTA_LAKE_TABLE, ICEBERG_VIEW, NAMESPACE or UDF, which are the discriminator mapping values of the 'Content' type.")
    public static interface Type {
        public static final Type UNKNOWN = ContentTypes.forName("UNKNOWN");
        public static final Type ICEBERG_TABLE = ContentTypes.forName("ICEBERG_TABLE");
        public static final Type DELTA_LAKE_TABLE = ContentTypes.forName("DELTA_LAKE_TABLE");
        public static final Type ICEBERG_VIEW = ContentTypes.forName("ICEBERG_VIEW");
        public static final Type NAMESPACE = ContentTypes.forName("NAMESPACE");
        public static final Type UDF = ContentTypes.forName("UDF");

        public String name();

        public Class<? extends Content> type();
    }
}

