/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.model.types;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.DatabindContext;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JavaType;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.dataiku.dss.shadelib.org.projectnessie.model.Content;
import com.dataiku.dss.shadelib.org.projectnessie.model.types.ContentTypes;
import com.dataiku.dss.shadelib.org.projectnessie.model.types.GenericContent;

public final class ContentTypeIdResolver
extends TypeIdResolverBase {
    private JavaType baseType;

    @Override
    public void init(JavaType bt) {
        this.baseType = bt;
    }

    @Override
    public String idFromValue(Object value) {
        return this.getId(value);
    }

    @Override
    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        return this.getId(value);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    private String getId(Object value) {
        if (value instanceof Content) {
            return ((Content)value).getType().name();
        }
        return null;
    }

    @Override
    public JavaType typeFromId(DatabindContext context, String id) {
        Content.Type subType;
        try {
            subType = ContentTypes.forName(id);
        }
        catch (IllegalArgumentException e) {
            return context.constructSpecializedType(this.baseType, GenericContent.class);
        }
        Class<? extends Content> asType = subType.type();
        if (this.baseType.getRawClass().isAssignableFrom(asType)) {
            return context.constructSpecializedType(this.baseType, asType);
        }
        Class<?> concrete = this.baseType.getRawClass();
        return context.constructSpecializedType(this.baseType, concrete);
    }
}

