/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.model.types;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonInclude;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonGenerator;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonParser;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.DeserializationContext;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonDeserializer;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonSerializer;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.SerializerProvider;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.dataiku.dss.shadelib.org.projectnessie.model.RepositoryConfig;
import com.dataiku.dss.shadelib.org.projectnessie.model.types.ImmutableGenericRepositoryConfig;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Map;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;

@JsonSerialize(using=RepositoryConfigUnknownTypeSerializer.class)
@JsonDeserialize(using=RepositoryConfigUnknownTypeDeserializer.class)
@Value.Immutable
public abstract class GenericRepositoryConfig
implements RepositoryConfig {
    @Override
    @Value.Parameter(order=1)
    public abstract RepositoryConfig.Type getType();

    @com.dataiku.dss.shadelib.javax.annotation.Nullable
    @Nullable
    @Schema(type=SchemaType.OBJECT)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonUnwrapped
    @Value.Parameter(order=3)
    public abstract Map<String, Object> getAttributes();

    public static GenericRepositoryConfig repositoryConfigUnknownType(final String type, Map<String, Object> all) {
        return ImmutableGenericRepositoryConfig.of(new RepositoryConfig.Type(){

            @Override
            public String name() {
                return type;
            }

            @Override
            public Class<? extends RepositoryConfig> type() {
                return GenericRepositoryConfig.class;
            }
        }, all);
    }

    static final class RepositoryConfigUnknownTypeDeserializer
    extends JsonDeserializer<GenericRepositoryConfig> {
        RepositoryConfigUnknownTypeDeserializer() {
        }

        @Override
        public GenericRepositoryConfig deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Map all = p.readValueAs(Map.class);
            Object type = all.remove("type");
            if (type == null) {
                type = "UNKNOWN_CONTENT_TYPE";
            }
            return GenericRepositoryConfig.repositoryConfigUnknownType(type.toString(), all);
        }
    }

    static final class RepositoryConfigUnknownTypeSerializer
    extends JsonSerializer<GenericRepositoryConfig> {
        RepositoryConfigUnknownTypeSerializer() {
        }

        @Override
        public void serializeWithType(GenericRepositoryConfig value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("type", value.getType().name());
            for (Map.Entry<String, Object> entry : value.getAttributes().entrySet()) {
                gen.writeFieldName(entry.getKey());
                gen.writeObject(entry.getValue());
            }
            gen.writeEndObject();
        }

        @Override
        public void serialize(GenericRepositoryConfig value, JsonGenerator gen, SerializerProvider serializers) {
            throw new UnsupportedOperationException();
        }
    }
}

