(function(){"use strict";var app=angular.module("dataiku.ml.report",[]);app.constant("AVAILABLE_EXTERNAL_MODEL_TYPES_DETAILS",[{name:"sagemaker",fullName:"Amazon SageMaker",shortName:"SageMaker",savedModelType:"PROXY_MODEL",connectionType:"SageMaker",canAuthenticateFromEnvironment:true,icon:"dku-icon-model-sagemaker",inputFormats:[{name:"INPUT_SAGEMAKER_CSV",displayName:"SageMaker - CSV"},{name:"INPUT_SAGEMAKER_JSON",displayName:"SageMaker - JSON"},{name:"INPUT_SAGEMAKER_JSON_EXTENDED",displayName:"SageMaker - JSON (extended)"},{name:"INPUT_SAGEMAKER_JSONLINES",displayName:"SageMaker - JSONLINES"},{name:"INPUT_DEPLOY_ANYWHERE_ROW_ORIENTED_JSON",displayName:"Deploy Anywhere - Row oriented JSON"}],outputFormats:[{name:"OUTPUT_SAGEMAKER_CSV",displayName:"SageMaker - CSV"},{name:"OUTPUT_SAGEMAKER_ARRAY_AS_STRING",displayName:"SageMaker - Array as string"},{name:"OUTPUT_SAGEMAKER_JSON",displayName:"SageMaker - JSON"},{name:"OUTPUT_SAGEMAKER_JSONLINES",displayName:"SageMaker - JSONLINES"},{name:"OUTPUT_DEPLOY_ANYWHERE_JSON",displayName:"Deploy Anywhere - JSON"}]},{name:"azure-ml",fullName:"Azure Machine Learning",shortName:"Azure ML",savedModelType:"PROXY_MODEL",connectionType:"AzureML",canAuthenticateFromEnvironment:true,icon:"dku-icon-model-azureml",inputFormats:[{name:"INPUT_AZUREML_JSON_INPUTDATA",displayName:"Azure ML - JSON (input_data)"},{name:"INPUT_AZUREML_JSON_INPUTDATA_DATA",displayName:"Azure ML - JSON (input_data with data and columns)"},{name:"INPUT_AZUREML_JSON_WRITER",displayName:"Azure ML - JSON (Inputs/data)"},{name:"INPUT_DEPLOY_ANYWHERE_ROW_ORIENTED_JSON",displayName:"Deploy Anywhere - Row oriented JSON"}],outputFormats:[{name:"OUTPUT_AZUREML_JSON_OBJECT",displayName:"Azure ML - JSON (Object)"},{name:"OUTPUT_AZUREML_JSON_ARRAY",displayName:"Azure ML - JSON (Array)"},{name:"OUTPUT_DEPLOY_ANYWHERE_JSON",displayName:"Deploy Anywhere - JSON"}]},{name:"vertex-ai",fullName:"Google Vertex AI",shortName:"Vertex AI",savedModelType:"PROXY_MODEL",connectionType:"VertexAIModelDeployment",canAuthenticateFromEnvironment:true,icon:"dku-icon-model-google-vertex",inputFormats:[{name:"INPUT_VERTEX_DEFAULT",displayName:"Vertex - default"}],outputFormats:[{name:"OUTPUT_VERTEX_DEFAULT",displayName:"Vertex - default"}]},{name:"databricks",fullName:"Databricks",shortName:"Databricks",savedModelType:"PROXY_MODEL",connectionType:"DatabricksModelDeployment",canAuthenticateFromEnvironment:false,icon:"dku-icon-model-databricks",inputFormats:[{name:"INPUT_RECORD_ORIENTED_JSON",displayName:"Databricks - Record oriented JSON"},{name:"INPUT_SPLIT_ORIENTED_JSON",displayName:"Databricks - Split oriented JSON"},{name:"INPUT_TF_INPUTS_JSON",displayName:"Databricks - TS Inputs JSON"},{name:"INPUT_TF_INSTANCES_JSON",displayName:"Databricks - TF Instances JSON"},{name:"INPUT_DATABRICKS_CSV",displayName:"Databricks - CSV"}],outputFormats:[{name:"OUTPUT_DATABRICKS_JSON",displayName:"Databricks - JSON"}]},{name:"mlflow",fullName:"MLflow",shortName:"MLflow",savedModelType:"MLFLOW_PYFUNC",icon:"dku-icon-model-mlflow"},{name:"finetuned",fullName:"Fine-tuned LLM",shortName:"Fine-tuned LLM",savedModelType:"LLM_GENERIC",icon:"dku-icon-saved-model-fine-tuning"}]);app.controller("_GenAiPredictionModelReportController",function($scope,$controller,isLLMEvaluation,isAgentEvaluation){$controller("_ModelReportControllerBase",{$scope:$scope});$scope.uiState=$scope.uiState||{};$scope.isLLMEvaluation=function(){return isLLMEvaluation};$scope.isAgentEvaluation=function(){return isAgentEvaluation}});app.controller("_PredictionModelReportController",function($scope,$controller,Assert,DataikuAPI,Debounce,$stateParams,ActivityIndicator,Fn,TopNav,BinaryClassificationModelsService,PartitionedModelsService,ActiveProjectKey,FullModelLikeIdUtils,SavedModelsService,MLDiagnosticsService,ModelEvaluationUtils,ModelDataUtils,AVAILABLE_EXTERNAL_MODEL_TYPES_DETAILS,CachedAPICalls){$controller("_ModelReportControllerBase",{$scope:$scope});$scope.uiState=$scope.uiState||{};$scope.ModelDataUtils=ModelDataUtils;$scope.areMetricsWeighted=function(){return $scope.modelData&&$scope.modelData.coreParams&&!!$scope.modelData.coreParams.weight&&($scope.modelData.coreParams.weight.weightMethod=="SAMPLE_WEIGHT"||$scope.modelData.coreParams.weight.weightMethod=="CLASS_AND_SAMPLE_WEIGHT")};$scope.areMetricsInversePropensityWeighted=function(){return $scope.modelData&&$scope.modelData.modeling.metrics.causalWeighting=="INVERSE_PROPENSITY"};$scope.getSampleWeightVariable=function(){return $scope.areMetricsWeighted()?$scope.modelData.coreParams.weight.sampleWeightVariable:undefined};$scope.printWeightedIfWeighted=function(){return $scope.areMetricsWeighted()?"Weighted":""};$scope.isTimeOrderingEnabled=function(){return $scope.modelData&&$scope.modelData.coreParams&&!!$scope.modelData.coreParams.time&&$scope.modelData.coreParams.time.enabled};$scope.getAggregationExplanation=function(metricName,displayName){return PartitionedModelsService.getAggregationExplanation(metricName,displayName||metricName,$scope.uiState.currentMetricIsCustom)};$scope.trainedOnAllData=function(){return $scope.modelData.splitDesc&&$scope.modelData.splitDesc.fullRows>0||$scope.modelData.trainInfo.fullRows>0};$scope.updateCMG=function(){Assert.inScope($scope,"modelData");if(!$scope.isBinaryClassification()){return}_updateCmgForGivenPerf($scope.modelData.perf);if($scope.modelData.perfWithoutOverrides){_updateCmgForGivenPerf($scope.modelData.perfWithoutOverrides)}};function _updateCmgForGivenPerf(perf){if(!perf||!perf.perCutData){return}perf.perCutData.cmg=ModelDataUtils.computeCmgForGivenPerf($scope.modelData,perf);if($scope.currentCutData){$scope.currentCutData.cmg=perf.perCutData.cmg[$scope.currentCutData.index]}if(perf.perCutData.format){const e=d3.extent(perf.perCutData.cmg);perf.perCutData.format[2]=e[1]-e[0]>10?"1g":".02f"}}function prepareFormat(modelData){try{const pcd=modelData.perf?modelData.perf.perCutData:null;const pdd=modelData.perf?modelData.perf.densityData:null;const predInfo=modelData.predictionInfo?modelData.predictionInfo:null;const tr=modelData.preprocessing?modelData.preprocessing.target_remapping:null;if(pcd){pcd.format=[".02f",".02f",".02f",".02f"]}modelData.classes=tr&&tr.length?tr.map(c=>tr[c.mappedValue].sourceValue):pdd?Object.keys(pdd):null;if(pdd){pdd.x=pdd[modelData.classes[0]].actualIsNotThisClass.map(function(_,i,a){return i/a.length})}if(predInfo&&predInfo.probabilityDensities){predInfo.x=predInfo.probabilityDensities[modelData.classes[0]].density.map(function(_,i,a){return i/a.length})}}catch(ignored){}}function prepareProxyModelSummary(modelData){if(!SavedModelsService.isProxyModel(modelData)){return}const protocol=modelData.proxyModelConfiguration.protocol;if(!protocol){return}const details=AVAILABLE_EXTERNAL_MODEL_TYPES_DETAILS.find(t=>t.name===protocol);if(modelData.inputFormat){if(details.inputFormats){const inputFormatObj=details.inputFormats.find(i=>i.name===modelData.inputFormat);if(inputFormatObj){modelData.inputFormatDisplayName=inputFormatObj.displayName}}}if(modelData.outputFormat){if(details.outputFormats){const outputFormatObj=details.outputFormats.find(i=>i.name===modelData.outputFormat);if(outputFormatObj){modelData.outputFormatDisplayName=outputFormatObj.displayName}}}}$scope.currentGraphData={};function isPrediction(){return $scope.modelData&&$scope.modelData.coreParams&&this.indexOf($scope.modelData.coreParams.prediction_type)!==-1||$scope.evaluationDetails&&$scope.evaluationDetails.evaluation&&this.indexOf($scope.evaluationDetails.evaluation.predictionType)!==-1}$scope.isBinaryClassification=isPrediction.bind(["BINARY_CLASSIFICATION"]);$scope.isMulticlass=isPrediction.bind(["MULTICLASS","DEEP_HUB_IMAGE_CLASSIFICATION"]);$scope.isForecast=isPrediction.bind(["TIMESERIES_FORECAST"]);$scope.isClassification=()=>$scope.isMulticlass()||$scope.isBinaryClassification();$scope.isRegression=isPrediction.bind(["REGRESSION"]);$scope.isPrediction=Fn.cst(true);$scope.isKerasDl=()=>$scope.modelData&&$scope.modelData.coreParams&&$scope.modelData.coreParams.backendType==="KERAS";$scope.isCausalPrediction=isPrediction.bind(["CAUSAL_BINARY_CLASSIFICATION","CAUSAL_REGRESSION"]);$scope.isCausalClassification=isPrediction.bind(["CAUSAL_BINARY_CLASSIFICATION"]);$scope.isMultiValueTreatment=function(){return $scope.modelData&&$scope.modelData.coreParams&&$scope.modelData.coreParams.enable_multi_treatment&&$scope.modelData.coreParams.treatment_values.length>2};$scope.hasMultipleFoldsOrIdentifiers=function(){return $scope.hasMultipleFolds()||$scope.hasMultipleIdentifiers()};$scope.hasMultipleIdentifiers=function(){return $scope.isForecast()&&$scope.modelData.coreParams.timeseriesIdentifiers.length};$scope.hasMultipleFolds=function(){return $scope.isForecast()&&(!$scope.modelData.coreParams.customTrainTestSplit&&$scope.modelData.splitDesc.params.kfold||$scope.modelData.coreParams.customTrainTestSplit&&$scope.modelData.coreParams.customTrainTestIntervals.length>1)};$scope.isMLBackendType=function(mlBackendType){return $scope.modelData.coreParams.backendType===mlBackendType};$scope.supportsOverrides=function(){return!$scope.isExternalMLflowModel()&&isPrediction.bind(["REGRESSION","BINARY_CLASSIFICATION","MULTICLASS"])()&&$scope.isMLBackendType("PY_MEMORY")&&!PartitionedModelsService.isPartitionedModel($scope.modelData)};$scope.supportsModelView=function(skinId){const ensembleUnsupportedIds=["error-analysis"];return!$scope.isPartitionedModel()&&!(ensembleUnsupportedIds.includes(skinId)&&ModelDataUtils.isEnsemble($scope.modelData))};$scope.staticModelSkins=[{id:"stress-test-center-view",ownerPluginId:"model-stress-test",desc:{roles:getStaticModelSkinRoles(),meta:{label:"Stress test center",emptyState:{animationPath:"/static/dataiku/images/analysis/stress-test-center-empty-state.json",text:"This plugin lets you randomly apply distribution shifts and feature corruptions, and check their impact on model performance."},reportSection:"PERFORMANCE"}}},{id:"error-analysis",ownerPluginId:"model-error-analysis",desc:{roles:getStaticModelSkinRoles(),meta:{label:"Model error analysis",emptyState:{animationPath:"/static/dataiku/images/analysis/model-error-analysis-empty-state.json",text:"This plugin helps debug model performance by identifying subpopulations on which it underperforms."},reportSection:"PERFORMANCE"}}},{id:"model-fairness-view",ownerPluginId:"model-fairness-report",desc:{roles:getStaticModelSkinRoles(["BINARY_CLASSIFICATION"]),meta:{label:"Model fairness report",emptyState:{animationPath:"/static/dataiku/images/analysis/model-fairness-report-empty-state.json",text:"This plugin helps you measure your model fairness with regards to a specific group and a given outcome."},reportSection:"EXPLAINIBILITY"}}}];function getStaticModelSkinRoles(predictionTypes=["BINARY_CLASSIFICATION","MULTICLASS","REGRESSION"]){const backendTypes=["PY_MEMORY"];const contentType="prediction";return[{backendTypes:backendTypes,contentType:contentType,predictionTypes:predictionTypes,pathParamsKey:"versionId",type:"SAVED_MODEL"},{backendTypes:backendTypes,contentType:contentType,predictionTypes:predictionTypes,type:"ANALYSIS"}]}$scope.predictionModelReportControllerInitDone=false;if($scope.modelData){$scope.fullModelId=$scope.fullModelId||$scope.modelData.fullModelId;prepareFormat($scope.modelData);prepareProxyModelSummary($scope.modelData);$scope.headTaskCMW=$scope.modelData.headTaskCMW;$scope.updateCMG();if($scope.modelData.userMeta.activeClassifierThreshold){updateGraphData($scope.modelData.userMeta.activeClassifierThreshold)}if($scope.mlTasksContext){$scope.mlTasksContext.model=$scope.modelData}if($scope.smContext){$scope.smContext.model=$scope.modelData}$scope.predictionModelReportControllerInitDone=true}else{const fullModelId=$stateParams.fullModelId||$scope.fullModelId;const treatment=$stateParams.treatment||null;const p=DataikuAPI.ml.prediction.getModelDetails(fullModelId,treatment).success(function(modelData){prepareFormat(modelData);prepareProxyModelSummary(modelData);$scope.modelData=modelData;$scope.headTaskCMW=modelData.headTaskCMW;$scope.updateCMG();CachedAPICalls.pmlDiagnosticsDefinition.then(pmlDiagnosticsDefinition=>{$scope.diagnosticsDefinition=pmlDiagnosticsDefinition($scope.modelData.coreParams.backendType,$scope.modelData.coreParams.prediction_type)});if($scope.isExternalMLflowModel()&&!modelData.modelEvaluation){$scope.evaluationDiagnostics=MLDiagnosticsService.groupByType(modelData.mlDiagnostics);$scope.evaluationDiagnosticsCount=MLDiagnosticsService.countDiagnostics(modelData)}if(modelData.userMeta){TopNav.setPageTitle(modelData.userMeta.name+" - Analysis");updateGraphData($scope.modelData.userMeta.activeClassifierThreshold)}if($scope.mlTasksContext){$scope.mlTasksContext.model=modelData}if($scope.smContext){$scope.smContext.model=modelData}if($scope.onLoadSuccess)$scope.onLoadSuccess();$scope.predictionModelReportControllerInitDone=true}).error(setErrorInScope.bind($scope)).error(function(data,status,headers,config,statusText){$scope.predictionModelReportControllerInitDone=true;if($scope.onLoadError)$scope.onLoadError(data,status,headers,config,statusText)});if($scope.noSpinner)p.noSpinner()}$scope.colors=window.dkuColorPalettes.discrete[0].colors.filter(function(c,i){return i%2===0});$scope.hasVariableImportance=function(){if(!$scope.modelData)return false;const iperf=$scope.modelData.iperf;return!!(iperf&&iperf.rawImportance&&iperf.rawImportance.variables&&iperf.rawImportance.variables.length)};$scope.hasGlobalExplanations=function(){if($scope.isForecast()||$scope.isKerasDl()||$scope.isCausalPrediction())return false;return!!($scope.modelData&&$scope.modelData.globalExplanationsAbsoluteImportance)};$scope.supportsShapleyFeatureImportance=isPrediction.bind(["BINARY_CLASSIFICATION","REGRESSION","MULTICLASS"]);$scope.hasRawCoefficients=function(){if(!$scope.modelData)return false;const iperf=$scope.modelData.iperf;return!!(iperf&&iperf.lmCoefficients)};$scope.hasProbabilityDensities=function(){return $scope.isClassification()&&$scope.modelData&&$scope.modelData.perf&&$scope.modelData.perf.densityData&&$scope.modelData.perf.densityData.x};$scope.hasNoAssociatedModel=function(){return!!$scope.evaluationDetails&&($scope.evaluationDetails.evaluation.modelType=="EXTERNAL"||$scope.evaluationDetails.backingModelVersionDeleted||$scope.fullModelId)};const ufiMinBackGroundSize=25;$scope.canComputeUfi=function(){try{if($scope.trainedOnAllData()){return($scope.modelData.splitDesc.fullRows||$scope.modelData.trainInfo.fullRows)>=ufiMinBackGroundSize}else{return($scope.modelData.splitDesc.trainRows||$scope.modelData.trainInfo.trainRows)>=ufiMinBackGroundSize}}catch(e){return true}};$scope.ufiNotAvailableMessage=function(method){if("ICE"!==method){method="Shapley"}if($scope.isProxyModel()){return method+" feature importance was skipped when creating the external model version."}else if($scope.isMLflowModel()){return method+" feature importance was skipped when importing the MLflow model."}else if($scope.canComputeUfi()){return method+" feature importance was skipped during training."}else{return method+" feature importance isn't available because your model was trained on less than "+ufiMinBackGroundSize+" rows."}};$scope.hasNoAssociatedModelText=function(){return ModelEvaluationUtils.hasNoAssociatedModelText($scope.evaluationDetails,$scope.fullModelId)};$scope.hasPropensityModel=function(){return $scope.isCausalPrediction()&&$scope.modelData&&$scope.modelData.modeling&&$scope.modelData.modeling.propensityModeling&&$scope.modelData.modeling.propensityModeling.enabled};$scope.isNonRandomizationDetected=function(){const test=$scope.modelData.perf.propensityPerf.binomialTreatmentTest;return test.pValue<=1-test.confidenceLevel};$scope.hasFeatures=function(){const features=$scope.modelData&&$scope.modelData.preprocessing&&$scope.modelData.preprocessing.per_feature||{};return!(Object.keys(features).length===0)};$scope.tabNotAvailableText=function(tabName){const tabsMLflowExcluded=["train","coefficients","grid_search","variables","algorithm","overrides_metrics"];const tabsMLflowPerfUnneeded=["features"];const tabsModelNeeded=["train","pdp_plot","individual_explanations","interactive_scoring","coefficients","grid_search","variables","features","algorithm","autoarima_orders","overrides_metrics","timeseries_model_coefficients","timeseries_information_criteria","timeseries_interactive_scoring"];const tabsProbaNeeded=["pdp_plot","individual_explanations","feature_importance","interactive_scoring","bc_decision_chart","bc_lift","c_calibration"];const tabsPerfUnneeded=["input_data_drift","prediction_drift","ensemble_summary","tree_summary","variables","coefficients","pdp_plot","interactive_scoring","features","algorithm","autoarima_orders","timeseries_model_coefficients","timeseries_information_criteria","timeseries_interactive_scoring","train","grid_search","individual_explanations"];const tabsPredictionsNeeded=["individual_explanations","feature_importance"];const tabsProbaDensityNeeded=["individual_explanations","feature_importance"];const tabsPredictionDistributionNeeded=["prediction_drift"];const tabsPredictionPDFNeeded=["prediction_drift"];const tabsCompatibleReferenceNeeded=["prediction_drift","performance_drift"];const tabsKerasExcluded=["individual_explanations","feature_importance","overrides_metrics"];const tabsModelNeededWithCustomPreprocessing=["subpopulation"];const tabNoEnsemble=["overrides_metrics","error-analysis"];const tabsNoModelSer=["summary","input_data_drift"];if($scope.evaluationDetails&&!$scope.evaluationDetails.evaluation.predictionType){return"Not available for an evaluation of a non classification or regression model"}if(tabsKerasExcluded.includes(tabName)&&$scope.modelData&&$scope.modelData.backendType==="KERAS"){return"Not available for Deep learning models"}if((tabsModelNeeded.includes(tabName)||hasCustomPreprocessing($scope.modelData)&&tabsModelNeededWithCustomPreprocessing.includes(tabName))&&$scope.hasNoAssociatedModel()){return $scope.hasNoAssociatedModelText()}if($scope.isExternalMLflowModel()){if(tabsMLflowExcluded.includes(tabName)){return"Not available for MLflow models"}if(!tabsMLflowPerfUnneeded.includes(tabName)&&$scope.modelData&&!$scope.modelData.modelEvaluation&&!$scope.modelData.perf){return"Model was not evaluated."}if(tabName=="features"&&!$scope.hasFeatures()){return"No features in this model's metadata"}}if(tabNoEnsemble.includes(tabName)&&$scope.getAlgorithm()&&$scope.getAlgorithm().endsWith("_ENSEMBLE")){return"Not available for Ensemble models"}if($scope.modelData&&$scope.modelData.modelEvaluation&&$scope.modelData.modelEvaluation&&!$scope.modelData.modelEvaluation.hasModel&&!tabsNoModelSer.includes(tabName)){return"Not available for evaluations without model."}if($scope.modelData&&(!$scope.modelData.perf||$scope.evaluationDetails?.evaluation?.evaluateRecipeParams?.dontComputePerformance)&&!tabsPerfUnneeded.includes(tabName)){return"Model performance was not computed (disabled or ground truth was missing)"}if($scope.uiState.driftState&&$scope.uiState.driftState.selectedReference&&!$scope.uiState.driftState.selectedReference.isCompatibleReference&&tabsCompatibleReferenceNeeded.includes(tabName)){return"The selected drift reference is incompatible with prediction and performance drift"}const modelDataContext=ModelDataUtils.isFromModelEvaluation($scope.modelData)?"Model evaluation":"Model";if($scope.isRegression()&&$scope.modelData&&$scope.modelData.predictionInfo&&!$scope.modelData.predictionInfo.predictions&&tabsPredictionsNeeded.includes(tabName)){return modelDataContext+" does not have prediction statistics with regression predictions"}if($scope.isRegression()&&$scope.modelData&&$scope.modelData.predictionInfo&&!$scope.modelData.predictionInfo.pdf&&tabsPredictionPDFNeeded.includes(tabName)){return modelDataContext+" does not have prediction statistics with probability density function"}if($scope.isClassification()&&$scope.modelData&&$scope.modelData.predictionInfo&&(!$scope.modelData.predictionInfo.probabilityDensities||Object.keys($scope.modelData.predictionInfo.probabilityDensities).length==0)&&tabsProbaDensityNeeded.includes(tabName)){return modelDataContext+" does not have prediction statistics with probability densities"}if($scope.isClassification()&&$scope.modelData&&$scope.modelData.predictionInfo&&(!$scope.modelData.predictionInfo.predictedClassCount||Object.keys($scope.modelData.predictionInfo.predictedClassCount).length==0)&&tabsPredictionDistributionNeeded.includes(tabName)){return modelDataContext+" does not have prediction statistics with prediction distribution"}if($scope.isClassification()&&tabsProbaNeeded.includes(tabName)){if(!ModelDataUtils.hasProbas($scope.modelData)){return"Not available for non-probabilistic models"}if($scope.modelEvaluation&&!$scope.modelEvaluation.outputProbabilities){return"Not available for non-probabilistic evaluations"}}if(tabName=="subpopulation"&&$scope.isMulticlass()){return"Not available for multi-class classification"}return null};function hasCustomPreprocessing(modelData){if(!modelData||!modelData.preprocessing||!modelData.preprocessing.per_feature){return}return Object.values(modelData.preprocessing.per_feature).some(column=>column.numerical_handling&&column.numerical_handling==="CUSTOM"||column.category_handling&&column.category_handling==="CUSTOM"||column.text_handling&&column.text_handling==="CUSTOM")}$scope.hasROCCurve=function(){return $scope.isBinaryClassification()&&$scope.modelData&&$scope.modelData.perf&&$scope.modelData.perf.rocVizData||$scope.isMulticlass()&&Object.keys($scope.modelData&&$scope.modelData.perf&&$scope.modelData.perf.oneVsAllRocCurves||{}).length};$scope.hasPRCurve=function(){return $scope.isBinaryClassification()&&$scope.modelData&&$scope.modelData.perf&&$scope.modelData.perf.prVizData||$scope.isMulticlass()&&Object.keys($scope.modelData&&$scope.modelData.perf&&$scope.modelData.perf.oneVsAllPrCurves||{}).length};$scope.isExternalMLflowModel=function(){return SavedModelsService.isExternalMLflowModel($scope.modelData)};$scope.isLLMEvaluation=function(){return false};$scope.isAgentEvaluation=function(){return false};$scope.isMLflowModel=function(){return SavedModelsService.isMLflowModel($scope.modelData)};$scope.isProxyModel=function(){return SavedModelsService.isProxyModel($scope.modelData)};$scope.isModelWithSingleTree=function(){return["MLLIB_DECISION_TREE","DECISION_TREE_CLASSIFICATION","DECISION_TREE_REGRESSION"].indexOf($scope.getAlgorithm())>=0};$scope.isModelWithMultipleTrees=function(){var algo=$scope.getAlgorithm();return["GBT_REGRESSION","GBT_CLASSIFICATION","RANDOM_FOREST_CLASSIFICATION","RANDOM_FOREST_REGRESSION","MLLIB_GBT","MLLIB_RANDOM_FOREST"].indexOf(algo)>=0&&!(algo=="MLLIB_RANDOM_FOREST"&&$scope.isMulticlass())};$scope.isAutoArimaModel=function(){return $scope.getAlgorithm()==="AUTO_ARIMA"};$scope.isTimeseriesModelWithInformationCriteria=function(){return["AUTO_ARIMA","ETS","SEASONAL_LOESS"].includes($scope.getAlgorithm())};$scope.isTimeseriesModelWithCoefficients=function(){return $scope.modelData?.iperf?.modelCoefficients};$scope.optimalThresholdDefined=function(){return $scope.isExternalMLflowModel()&&typeof $scope.modelData.perf.optimalThreshold!=="undefined"||!$scope.evaluationDetails&&!$scope.isExternalMLflowModel()||$scope.evaluationDetails&&$scope.evaluationDetails.evaluation.thresholdAutoOptimized};$scope.getDefaultThreshold=function(){return $scope.optimalThresholdDefined()?$scope.modelData.perf.optimalThreshold:$scope.isExternalMLflowModel()?$scope.modelData.modeling.forcedClassifierThreshold:$scope.evaluationDetails.evaluation.activeClassifierThreshold};$scope.getThresholdBackToWhat=function(){return $scope.optimalThresholdDefined()?"optimal":"saved value"};$scope.hasThresholdSlider=function(){return $scope.isBinaryClassification()&&$scope.modelData.backendType!=="VERTICA"&&ModelDataUtils.hasProbas($scope.modelData)&&!($scope.isPartitionedModel()&&!FullModelLikeIdUtils.isPartition(FullModelLikeIdUtils.getFmi($scope)))};$scope.uiState.displayMode="records";$scope.getMaybeWeighted=function(x){if(typeof x!=="number"){return x}return $scope.areMetricsWeighted()?x.toFixed(2):x.toFixed(0)};$scope.currentGraphData={};function updateGraphData(nv){if(nv===undefined)return;$scope.currentCutData=BinaryClassificationModelsService.findCutData($scope.modelData.perf,nv);angular.forEach($scope.currentCutData,function(v,k){if(k.charCodeAt(0)<=90){if($scope.areMetricsWeighted())this["Weighted "+k]=v;else this[k]=v}},$scope.currentGraphData)}$scope.$watch("modelData.userMeta.activeClassifierThreshold",updateGraphData);$scope.isLearningCurveSupported=function(){const fmi=FullModelLikeIdUtils.getFmi($scope);const evaluationId=$stateParams.evaluationId;return isPrediction.bind(["BINARY_CLASSIFICATION","MULTICLASS","REGRESSION"])()&&$scope.isMLBackendType("PY_MEMORY")&&!evaluationId&&(FullModelLikeIdUtils.isAnalysis(fmi)||FullModelLikeIdUtils.isSavedModel(fmi))&&(!PartitionedModelsService.isPartitionedModel($scope.modelData)||PartitionedModelsService.isPartitionedModel($scope.modelData)&&FullModelLikeIdUtils.isPartition(fmi))&&SavedModelsService.isVisualMLModel($scope.modelData)&&!ModelDataUtils.isEnsemble($scope.modelData)};if(!$scope.readOnly){const simpleApiResult=function(msg,r){r.success(function(){ActivityIndicator.success(msg)}).error(setErrorInScope.bind($scope))};const debouncedUpdateCMW=Debounce().withDelay(400,1e3).wrap(function(){if(!$scope.savedModel&&!$scope.evaluationDetails){const fmi=FullModelLikeIdUtils.getFmi($scope);simpleApiResult("Weights saved",DataikuAPI.analysis.pml.saveCostMatrixWeights(fmi,$scope.headTaskCMW))}$scope.updateCMG()});const saveMeta=function(){if($scope.readOnly)return;if($scope.evaluationDetails){const mesId=$stateParams.mesId||$scope.mesId;const evaluationId=$stateParams.evaluationId||$scope.evaluationId;let fme=FullModelLikeIdUtils.buildModelEvaluationFmeFromComponents(ActiveProjectKey.get(),mesId,evaluationId);simpleApiResult("Saved",DataikuAPI.modelevaluations.saveEvaluationModelUserMeta(fme,$scope.modelData.userMeta))}else{simpleApiResult("Saved",DataikuAPI.ml.saveModelUserMeta($stateParams.fullModelId||$scope.fullModelId,$scope.modelData.userMeta))}};const debouncedSaveMeta=Debounce().withDelay(400,1e3).wrap(saveMeta);const saveIfDataChanged=function(nv,ov){if(nv&&ov&&!$scope.evaluationDetails&&!_.isEqual(nv,ov)){this.call()}};$scope.$watch("headTaskCMW",saveIfDataChanged.bind(debouncedUpdateCMW),true);$scope.$watch("modelData.userMeta.activeClassifierThreshold",saveIfDataChanged.bind(debouncedSaveMeta),true);$scope.$watch("modelData.userMeta",function(nv,ov){if(nv&&ov&&(nv.name!=ov.name||nv.description!=ov.description||!_.isEqual(nv.labels,ov.labels))){debouncedSaveMeta()}},true);const saveEvaluationUserMeta=function(){const mesId=$stateParams.mesId||$scope.mesId;const evaluationId=$stateParams.evaluationId||$scope.evaluationId;let fme=FullModelLikeIdUtils.buildModelEvaluationFmeFromComponents(ActiveProjectKey.get(),mesId,evaluationId);simpleApiResult("Saved",DataikuAPI.modelevaluations.saveEvaluationUserMeta(fme,$scope.evaluationDetails.evaluation.userMeta))};const debouncedSaveEvaluationUserMeta=Debounce().withDelay(400,1e3).wrap(saveEvaluationUserMeta);$scope.$watch("evaluationDetails.evaluation.userMeta",function(nv,ov){if(nv&&ov&&nv!=ov){debouncedSaveEvaluationUserMeta()}},true)}});app.controller("UpliftCurvesController",function($scope,$stateParams,$state){const isDashboardTile=!!$stateParams.dashboardId;$scope.perf=$scope.modelData.perf.causalPerf;function getCurveDisplayMode(){const advancedOptions=$scope.tile&&$scope.tile.tileParams&&$scope.tile.tileParams.advancedOptions||{};return advancedOptions.upliftCurve&&advancedOptions.upliftCurve.displayMode}if(isDashboardTile){$scope.uiState.displayedUpliftCurve=getCurveDisplayMode()}else{$scope.uiState.displayedUpliftCurve=$stateParams.curveId||"cumulativeUplift"}$scope.getUpliftCurveDisplayMode=function(){if(isDashboardTile)return getCurveDisplayMode();return $scope.uiState.displayedUpliftCurve};$scope.selectUpliftCurve=function(curveId){$scope.uiState.displayedUpliftCurve=curveId;$state.go($state.current,{curveId:curveId})}});app.component("computedOnRows",{bindings:{trainInfo:"<",evaluation:"<",isOnPartitionedBaseModel:"<"},templateUrl:"/templates/ml/prediction-model/computed-on-rows.html"});app.component("thresholdSlider",{bindings:{originalThreshold:"<",backToWhat:"<",activeClassifierThreshold:"="},templateUrl:"/templates/ml/prediction-model/threshold-slider.html",controller:function thresholdSliderController(){const $ctrl=this;$ctrl.resetToThresholdOriginal=function(){$ctrl.activeClassifierThreshold=$ctrl.originalThreshold}}});app.service("PMLCVParamsUtils",function(PMLSettings,SamplingData){const samplingMethods=arr2obj(SamplingData.streamSamplingMethods);const partitionSelectionMethods=arr2obj(SamplingData.partitionSelectionMethods);function selection(prefix,ds,sel){if(ds){this.push([prefix+"dataset",ds])}this.push([prefix+"sampling method",samplingMethods[sel.samplingMethod]]);this.push([prefix+"partitions",partitionSelectionMethods[sel.partitionSelectionMethod]]);if(sel.partitionSelectionMethod==="SELECTED"){this[this.length-1].push(": ",sel.selectedPartitions.join(", "))}if(["HEAD_SEQUENTIAL","RANDOM_FIXED_NB","COLUMN_BASED","COLUMN_ORDERED"].indexOf(sel.samplingMethod)>=0){this.push([prefix+"record limit",sel.maxRecords]);if(sel.samplingMethod==="COLUMN_BASED"){this.push([prefix+"column",sel.column])}else if(sel.samplingMethod==="COLUMN_ORDERED"){this.push([prefix+"sorted by",sel.column])}}else if(sel.samplingMethod==="RANDOM_FIXED_RATIO"){this.push([prefix+"sampling ratio",sel.targetRatio])}}function makeCVParams(split,coreParams,gridSearchParams){const predictionType=coreParams.prediction_type;let ttPolicy=split.ttPolicy;const cvParams=[];if(ttPolicy==="SPLIT_SINGLE_DATASET"){ttPolicy=split.ssdDatasetSmartName?"SPLIT_OTHER_DATASET":"SPLIT_MAIN_DATASET"}else if(ttPolicy==="EXPLICIT_FILTERING_SINGLE_DATASET"){ttPolicy=split.efsdDatasetSmartName?"EXPLICIT_FILTERING_SINGLE_DATASET_OTHER":"EXPLICIT_FILTERING_SINGLE_DATASET_MAIN"}if(predictionType!=="TIMESERIES_FORECAST"){cvParams.push(["policy",arr2obj(PMLSettings.task.trainTestPolicies)[ttPolicy]])}switch(ttPolicy){case"SPLIT_MAIN_DATASET":case"SPLIT_OTHER_DATASET":selection.call(cvParams,"",split.datasetSmartName,split.ssdSelection);if(predictionType!=="TIMESERIES_FORECAST"){cvParams.push(["split mode",arr2obj(PMLSettings.task.splitModes)[split.ssdSplitMode]])}if(coreParams?.customTrainTestSplit){cvParams.push(["number of custom folds",coreParams.customTrainTestIntervals.length])}else if(split.kfold){cvParams.push(["number of folds",split.nFolds]);cvParams.push(["stratified",split.ssdStratified?"Yes":"No"]);cvParams.push(["grouped",split.ssdGrouped?"Yes":"No"]);if(split.ssdGrouped){cvParams.push(["group column",split.ssdGroupColumnName])}if(predictionType==="TIMESERIES_FORECAST"&&gridSearchParams){cvParams.push(["fold offset",gridSearchParams.foldOffset?"Yes":"No"]);cvParams.push(["equal duration train set folds",gridSearchParams.equalDurationFolds?"Yes":"No"])}}else if(predictionType!=="TIMESERIES_FORECAST"){cvParams.push(["train ratio",split.ssdTrainingRatio])}if(predictionType!=="TIMESERIES_FORECAST"){cvParams.push(["random seed",split.ssdSeed])}break;case"EXPLICIT_FILTERING_SINGLE_DATASET":selection.call(cvParams,"Train ",split.eftdTrain.datasetSmartName,split.eftdTrain.selection);selection.call(cvParams,"Test  ",split.eftdTest.datasetSmartName,split.eftdTest.selection);break;case"EXPLICIT_FILTERING_TWO_DATASETS":selection.call(cvParams,"Train ",split.eftdTrain.datasetSmartName,split.eftdTrain.selection);selection.call(cvParams,"Test  ",split.eftdTest.datasetSmartName,split.eftdTest.selection);break;case"FIXED_ID_BASED":break}return cvParams}return{makeCVParams:makeCVParams}});app.filter("getETSShortName",function(){return function(ets_params){let res="";res+=getETSLetter(ets_params.error);res+=getETSLetter(ets_params.trend);res+=getETSLetter(ets_params.damped_trend);res+=getETSLetter(ets_params.seasonal);return res};function getETSLetter(string){switch(string){case"add":return"A";case"mul":return"M";case"none":return"N";case"true":return"d";case"false":return""}}});app.controller("PMLReportTrainController",function($scope,MLDiagnosticsService,FullModelLikeIdUtils,PMLCVParamsUtils,ExportModelDatasetService,GpuUsageService){const split=$scope.modelData.splitDesc.params;$scope.mti=$scope.modelData.trainInfo;$scope.diagnostics=MLDiagnosticsService.groupByType($scope.modelData.mlDiagnostics);$scope.didUseGpu=false;if($scope.modelData.coreParams.executionParams&&$scope.modelData.coreParams.executionParams.gpuConfig&&$scope.modelData.coreParams.executionParams.gpuConfig.params){$scope.didUseGpu=$scope.modelData.coreParams.executionParams.gpuConfig.params.useGpu}$scope.isMLBackendType=function(mlBackendType){return $scope.modelData.coreParams.backendType===mlBackendType};$scope.getFormattedDisabledCapabilities=function(){return $scope.modelData.coreParams.executionParams.gpuConfig.disabledCapabilities.map(item=>GpuUsageService.CAPABILITIES[item].name)};$scope.canDisplayDiagnostics=function(){const modelData=$scope.modelData;if(FullModelLikeIdUtils.isPartition(modelData.fullModelId)){return true}if(!angular.isUndefined(modelData.smOrigin)&&!angular.isUndefined(modelData.smOrigin.fullModelId)){return!FullModelLikeIdUtils.isAnalysisPartitionBaseModel(modelData.smOrigin.fullModelId)}return!FullModelLikeIdUtils.isAnalysisPartitionBaseModel(modelData.fullModelId)};$scope.cvParams=PMLCVParamsUtils.makeCVParams(split,$scope.modelData.coreParams,$scope.modelData.modeling.grid_search_params);$scope.exportTrainTestSets=function(){ExportModelDatasetService.exportTrainTestSets($scope,$scope.modelData.fullModelId)};$scope.exportTrainTestSetsForbiddenReason=function(){return ExportModelDatasetService.exportTrainTestSetsForbiddenReason($scope.modelData)};$scope.isTimeseriesForecastWithBothKfold=function(){if(!$scope.isForecast())return false;return split.kfold&&$scope.modelData.modeling.grid_search_params.mode=="TIME_SERIES_KFOLD"}});app.directive("puppeteerHookElementContentLoaded",function(){return{scope:false,restrict:"A",link:function($scope){$scope.puppeteerHook_elementContentLoaded=true}}});app.controller("DecisionChartController",function($scope,$stateParams,MLChartsCommon){$scope.pcd=$scope.modelData.perf.perCutData;if(!$scope.modelData.trainInfo.kfold){return}$scope.svgCallback=MLChartsCommon.makeSvgAreaCallback(scope=>scope.theData.map(series=>Object.assign({},series,{std:$scope.pcd[series.key.toLowerCase()+"std"]})).filter(_=>_.std).map(series=>({color:series.color,values:series.values.filter(d=>typeof d.y==="number"&&!isNaN(d.y)).map((d,i)=>({x:d.x,y0:Math.max(0,d.y-2*series.std[i]),y1:Math.min(1,d.y+2*series.std[i])}))})))});app.controller("ClassificationDensityController",function($scope){var pdd=$scope.modelData.perf.densityData;$scope.colorsRep=$scope.colors.slice(0,2).concat($scope.colors.slice(0,2));$scope.setDensityClass=function(nc){var dd=pdd[nc];$scope.densityClass=nc;const y1=dd.actualIsNotThisClass.length>0?dd.actualIsNotThisClass:dd.actualIsThisClass.map(i=>0);const y2=dd.actualIsThisClass.length>0?dd.actualIsThisClass:dd.actualIsNotThisClass.map(i=>0);$scope.ys=[y1,y2];$scope.xm=[dd.actualIsNotThisClassMedian,dd.actualIsThisClassMedian];$scope.labels=$scope.isMulticlass()?["For all classes but "+nc,"For class "+nc]:["For class "+$scope.modelData.classes[0],"For class "+$scope.modelData.classes[1]]};$scope.setDensityClass($scope.modelData.classes[$scope.isMulticlass()?0:1])});app.factory("FeatureImportanceService",function($filter){return{build:function(rawImportance,colors){let imp=rawImportance;let rgb=colors[0];const name=$filter("mlFeature");rgb=rgb.replace("#","").replace(/^([0-9a-f])([0-9a-f])([0-9a-f])$/,"$1$1");rgb=parseInt(rgb,16);rgb=["rgba(",rgb>>16,",",rgb>>8&255,", ",rgb&255,", "].join("");if("variables"in imp){imp=imp.variables.map(function(v,i){return{rawVarName:v,varName:name(v),impVal:this[i]}},imp.importances)}else{imp=Object.keys(imp).map(function(v){return{varName:name(v),impVal:imp[v]}})}imp=$filter("orderBy")(imp,"-impVal");const filtered_imp=imp.slice(0,20);const importances=filtered_imp.map(function(o){return[o.varName,o.impVal]});const fades=filtered_imp.map(function(o){return rgb+Math.min(o.impVal/.3+.4,1)+")"});return[importances,fades,imp]}}});app.controller("FeatureImportanceController",function($scope,DataikuAPI,$stateParams,$state,ExportUtils,FeatureImportanceService,FullModelLikeIdUtils,ActiveProjectKey,FutureProgressModal,WT1,$q,StateUtils,ColumnGeneratorService,LocalStorage){$scope.isKFolding=$scope.modelData.trainInfo.kfold;$scope.variableImportanceOnlyForTreeBasedModels=!$scope.isCausalPrediction();if($scope.supportsShapleyFeatureImportance()&&!$scope.isDashboardTile){$scope.uiState.importanceDisplayMode=$stateParams.displayMode||"globalExplanations"}getGlobalExplanations().catch(setErrorInScope.bind($scope));getGlobalExplanationsFacts().catch(setErrorInScope.bind($scope));$scope.isDashboardTile=!!$stateParams.dashboardId;const objectId=$scope.isDashboardTile?`insightId.${$scope.insight.id}`:`fullModelId.${$scope.modelData.fullModelId}`;if($scope.isMulticlass()){$scope.selectableClasses=Object.keys($scope.modelData.predictionInfo.predictedClassCount);$scope.selectedClass=LocalStorage.get(`dss.ml.featureImportance.${objectId}.selectedClass`);if(!$scope.selectedClass){$scope.selectedClass=$scope.selectableClasses[0]}}else{$scope.selectedClass="unique"}$scope.goToEvaluatedFeatureImportance=function(){if($scope.insight){StateUtils.go.savedModelVersion("PREDICTION",$scope.insight.params.savedModelSmartId,$scope.insight.$fullModelId,$scope.insight.$savedModel.projectKey,null,{tab:".tabular-feature_importance"});return}if(!$scope.mesContext.evaluationFullInfo.evaluation)return;const modelRef=$scope.mesContext.evaluationFullInfo.evaluation.modelRef;StateUtils.go.savedModelVersion("PREDICTION",modelRef.smId,modelRef.fullId,modelRef.projectKey,null,{tab:".tabular-feature_importance"})};$scope.scrollToGraph=selectedGraph=>{if(!selectedGraph){return}const selectedGraphDOM=document.getElementById(selectedGraph);if(selectedGraphDOM){selectedGraphDOM.scrollIntoView({behavior:"smooth"})}};$scope.selectDisplayMode=displayMode=>{$scope.uiState.importanceDisplayMode=displayMode;$state.go($state.current,{displayMode:displayMode})};function formatGlobalExplanations(explanationResults){if(explanationResults&&Object.keys(explanationResults).length){$scope.explanationsAll=explanationResults.explanations;$scope.explanations=$scope.explanationsAll[$scope.isMulticlass()?$scope.selectedClass:"unique"];$scope.observations=explanationResults.observations;const absoluteImportance=explanationResults.absoluteImportance;return DataikuAPI.ml.prediction.getColumnImportance($stateParams.fullModelId||$scope.fullModelId).then(function(columnImportanceResp){let knownImportantColumns;if(columnImportanceResp.data){knownImportantColumns=columnImportanceResp.data.columns.map((column,index)=>[column,columnImportanceResp.data.importances[index]])}else{knownImportantColumns=Object.entries(absoluteImportance)}$scope.roundedTo20Features=knownImportantColumns.length>20;knownImportantColumns.sort((a,b)=>b[1]-a[1]);const knownColumnImportances=knownImportantColumns.map(arr=>arr[1]);const top20ColumnImportances=knownColumnImportances.slice(0,20).reduce((partialSum,a)=>partialSum+a,1e-20);const totalColumnImportance=knownColumnImportances.reduce((partialSum,a)=>partialSum+a,1e-20);const top20RatioOfImportance=top20ColumnImportances/totalColumnImportance;$scope.roundedPercentageOfTotalmportance=Math.round(top20RatioOfImportance*1e3)/10;const top20ShapImportantColumns=Object.entries(absoluteImportance).sort((a,b)=>b[1]-a[1]).slice(0,20);const top20TotalShapImportance=top20ShapImportantColumns.reduce((partialSum,a)=>partialSum+a[1],0);const top20DisplayedImportances=Object.fromEntries(top20ShapImportantColumns.map(([col,val])=>[col,val/top20TotalShapImportance*top20RatioOfImportance]));$scope.topColumns=Object.entries(top20DisplayedImportances).map(v=>v[0]);const arr=FeatureImportanceService.build(top20DisplayedImportances,$scope.colors);$scope.globalExplanationsImportance=arr[0];$scope.globalExplanationsFades=arr[1];$scope.globalExplanationsComputed=true;$scope.scatterColumns=ColumnGeneratorService.getPossibleColumns($scope.topColumns,["NUMERIC","CATEGORY","TEXT","VECTOR"],["INPUT"],$scope.modelData.preprocessing.per_feature);$scope.scatterColumnNames=$scope.scatterColumns.map(v=>v.name);$scope.selectedColumn=LocalStorage.get(`dss.ml.featureImportance.${objectId}.selectedColumn`);if(!$scope.selectedColumn){$scope.selectedColumn=$scope.topColumns.find(x=>$scope.scatterColumnNames.includes(x))}$scope.topColumns.reverse()})}return $q.resolve()}$scope.compute=function(){DataikuAPI.ml.prediction.globalExplanationsComputationStart($stateParams.fullModelId||$scope.fullModelId).success(result=>{FutureProgressModal.show($scope,result,"Computing Shapley feature importance").then(explanationResults=>{getGlobalExplanationsFacts();formatGlobalExplanations(explanationResults)})}).error(setErrorInScope.bind($scope));WT1.event("doctor-compute-shapley-feature-importance",{algorithm:$scope.modelData.modeling.algorithm})};function getGlobalExplanations(){const mesId=$stateParams.mesId||$scope.mesId;const evaluationId=$stateParams.evaluationId||$scope.evaluationId;if(mesId){return DataikuAPI.modelevaluations.getGlobalExplanations(FullModelLikeIdUtils.buildModelEvaluationFmeFromComponents(ActiveProjectKey.get(),mesId,evaluationId)).then(({data})=>{return formatGlobalExplanations(data)})}else{return DataikuAPI.ml.prediction.getGlobalExplanations($stateParams.fullModelId||$scope.fullModelId).then(({data})=>{return formatGlobalExplanations(data)})}}function getGlobalExplanationsFacts(){const mesId=$stateParams.mesId||$scope.mesId;const evaluationId=$stateParams.evaluationId||$scope.evaluationId;if(mesId){return DataikuAPI.modelevaluations.getGlobalExplanationsFacts(FullModelLikeIdUtils.buildModelEvaluationFmeFromComponents(ActiveProjectKey.get(),mesId,evaluationId)).then(({data})=>{$scope.perClassFacts=data.perClassFacts})}else{return DataikuAPI.ml.prediction.getGlobalExplanationsFacts($stateParams.fullModelId||$scope.fullModelId).then(({data})=>{$scope.perClassFacts=data.perClassFacts})}}$scope.getVariableImportance=function(){const arr=FeatureImportanceService.build($scope.modelData.iperf.rawImportance,$scope.colors);$scope.variableImportance=arr[0];$scope.variableImportanceFades=arr[1];$scope.variableUnfilteredImportance=arr[2]};$scope.exportVariableImportance=function(){const data=$scope.variableUnfilteredImportance.map(function(x){return[x.rawVarName,x.varName,x.impVal]});ExportUtils.exportUIData($scope,{name:"Variable importance for model: "+$scope.modelData.userMeta.name,columns:[{name:"feature_name",type:"string"},{name:"feature_description",type:"string"},{name:"importance",type:"double"}],data:data},"Export variable importances")};$scope.exportGlobalExplanations=function(){ExportUtils.exportUIData($scope,{name:"Shapley feature importance for model: "+$scope.modelData.userMeta.name,columns:[{name:"feature_name",type:"string"},{name:"importance",type:"double"}],data:$scope.globalExplanationsImportance},"Export Shapley feature importance")};function getRawExplanationsColumnsAndData(observations,explanationsAll){const targetClasses=Object.keys(explanationsAll);const explanationFeatures=Object.keys(explanationsAll[targetClasses[0]]);const obsFeatures=Object.keys(observations);const nbObservations=observations[obsFeatures[0]].length;const observationsWithExplanations=[];for(let observationIdx=0;observationIdx<nbObservations;observationIdx++){const featureValues=obsFeatures.map(feature=>observations[feature][observationIdx]);targetClasses.forEach(targetClass=>{const explanationValues=explanationFeatures.map(feature=>explanationsAll[targetClass][feature][observationIdx]);const observationWithExplanations=featureValues.concat(explanationValues);if($scope.isMulticlass()){observationWithExplanations.push(targetClass)}observationsWithExplanations.push(observationWithExplanations)})}const allColumns=obsFeatures.concat(explanationFeatures.map(feature=>"shapley_"+feature));if($scope.isMulticlass()){allColumns.push("shapley__class")}return[allColumns.map(column=>{return{name:column,type:"string"}}),observationsWithExplanations]}$scope.exportRawExplanations=function(){const[columns,data]=getRawExplanationsColumnsAndData($scope.observations,$scope.explanationsAll);ExportUtils.exportUIData($scope,{name:"Raw shapley feature importance for model: "+$scope.modelData.userMeta.name,columns:columns,data:data},"Export raw explanations")};$scope.onChangeSelectedClass=function(selectedClass){$scope.explanations=$scope.explanationsAll[$scope.isMulticlass()?selectedClass:"unique"];LocalStorage.set(`dss.ml.featureImportance.${objectId}.selectedClass`,selectedClass)};$scope.onChangeSelectedColumn=function(selectedColumn){LocalStorage.set(`dss.ml.featureImportance.${objectId}.selectedColumn`,selectedColumn)}});app.component("globalExplanationsScatterPlot",{templateUrl:"/templates/modelcomparisons/comparison-tabs/scatter_plot.html",bindings:{explanations:"<",observations:"<",columns:"<",perFeature:"<",loadedStateField:"=?"},controller:function($scope,Debounce,$element,PuppeteerLoadedService){const $ctrl=this;$ctrl.onChartInit=function($event){$ctrl.echartsInstance=$event;const debouncedSetPuppeteerField=PuppeteerLoadedService.getDebouncedSetField($scope,$element,$ctrl.loadedStateField);$ctrl.echartsInstance.on("rendered",()=>{debouncedSetPuppeteerField()})};$ctrl.show=function($event,show){const chartOptions=$ctrl.echartsInstance.getOption();const seriesIndex=$event.seriesIndex;if(chartOptions.visualMap[seriesIndex].type==="piecewise"&&chartOptions.visualMap[seriesIndex].showLegendOnHover){chartOptions.visualMap[seriesIndex].show=show;$ctrl.echartsInstance.setOption(chartOptions)}if(chartOptions.visualMap[seriesIndex].type==="piecewise"&&chartOptions.visualMap[seriesIndex].showGroupOnHover){const dataIndexes=[];$ctrl.beeswarmDataCategorical[$event.data[2]].values.forEach((a,index)=>{if(a[3]===$event.data[3]){dataIndexes.push(index)}});$ctrl.echartsInstance.dispatchAction({type:show?"highlight":"downplay",seriesIndex:seriesIndex,dataIndex:dataIndexes})}};$ctrl.$onInit=function(){$ctrl.chartOptions=buildChartOptions()};$ctrl.$onChanges=function(){$ctrl.chartOptions=buildChartOptions()};let colMax;let colMin;function getCategoricalUniqueValues(colObservations){const colObservationsSet=new Set(colObservations);const colObservationsLower=new Set([...colObservationsSet].map(x=>x.toLowerCase()));const booleans=colObservationsLower===new Set(["true","false"])||colObservationsLower===new Set(["true","false",""]);let sortedValueCounts;if(booleans){sortedValueCounts=[...colObservationsSet].sort().reverse()}else{const valueCounts={};colObservations.forEach(val=>{if(val in valueCounts){valueCounts[val]+=1}else{valueCounts[val]=1}});sortedValueCounts=Object.entries(valueCounts).sort(function(a,b){if(a[0]==="")return 1;else if(b[0]==="")return-1;else return b[1]-a[1]}).map(item=>item[0])}return sortedValueCounts}function buildChartOptions(){const max=Math.ceil(Math.max(...Object.values($ctrl.explanations).flat().map(Math.abs))*10)/10;const beeswarmData=[];$ctrl.beeswarmDataCategorical={};const jitterRandomNums=[.1871,.0472,.0488,.1945,-.141,.0865,.1165,-.0983,-.1128,.0171,.0554,-.0276,.0561,-.0573,-.1523,-.1426,.0672,-.0154,.0789,.177,-.0215,.0533,.1659,.181,-.0754,.1079,.0295,-.1167,-.1225,-.1451,.0422,-.1081,.1312,.0852,-.1916,.1141,-.1029,-.1247,-.1448,.0517,-.0597,-.1888,-.1868,.088,-.1844,.0529,-.1984,-.087,-.1167,-.1905];for(let i=0;i<$ctrl.columns.length;i++){const col=$ctrl.columns[i];const colExplanations=$ctrl.explanations[col];const colObservations=$ctrl.observations[col];const colFeatType=$ctrl.perFeature[col].type;const treatAsNumeric=colFeatType==="NUMERIC"&&colObservations.every(x=>{return x===""||!isNaN(x)});if(treatAsNumeric){const colObservationsSorted=[...colObservations].sort((a,b)=>a-b);colMax=d3.quantile(colObservationsSorted,.95);colMin=d3.quantile(colObservationsSorted,.05)}else{$ctrl.beeswarmDataCategorical[col]={values:[],uniqueValues:getCategoricalUniqueValues(colObservations)}}for(let j=0;j<colExplanations.length;j++){const randomNum=jitterRandomNums[j%jitterRandomNums.length];let featValue=.5;if(treatAsNumeric&&colObservations[j]!=""&&colMax!=colMin){featValue=Math.min(Math.max(colObservations[j],colMin),colMax);featValue=(featValue-colMin)/(colMax-colMin)}if(!treatAsNumeric){$ctrl.beeswarmDataCategorical[col].values.push([colExplanations[j],i+1+randomNum,col,colObservations[j]])}else{beeswarmData.push([colExplanations[j],i+1+randomNum,featValue,colObservations[j]])}}}const columnsAugmented=["",...$ctrl.columns,""];const series=[{type:"scatter",data:beeswarmData,symbolSize:5,name:"numerical"}];const visualMap=[{dimension:"2",hoverLink:false,inRange:{color:["#3A69DA","#C6302A"]},left:"0%",max:1,min:0,orient:"horizontal",seriesIndex:0,text:["High numerical value","Low numerical value"],textStyle:{color:"#000",fontFamily:"SourceSansPro"},top:"0%",type:"continuous"}];Object.entries($ctrl.beeswarmDataCategorical).forEach(([_,value],index)=>{const seriesIndex=index+1;series.push({type:"scatter",data:value.values,symbolSize:5,dimensions:[null,null,null,{type:"ordinal"}]});if(value.uniqueValues.length>6){const categories=value.uniqueValues;visualMap.push({bottom:10,categories:categories,dimension:"3",hoverLink:false,inRange:{color:"#808080"},itemHeight:20,left:"82%",seriesIndex:seriesIndex,show:false,showGroupOnHover:true,showLabel:false,showLegendOnHover:false,top:"2%",type:"piecewise"})}else{const colors=["#F8A217","#23A373","#82BCE6","#FBCD22","#9061B8","#8ABB4C"];let inUseColours;if(value.uniqueValues.includes("")){inUseColours=colors.slice(0,value.uniqueValues.length-1);inUseColours.push("#999999")}else{inUseColours=colors.slice(0,value.uniqueValues.length)}visualMap.push({bottom:10,categories:value.uniqueValues,dimension:"3",formatter:function(value){const sanitized=sanitize(value);if(sanitized===""){return"Missing Values"}if(sanitized.length>10){return sanitized.substring(0,7)+"..."}else{return sanitized}},hoverLink:false,inRange:{color:inUseColours},itemHeight:20,left:"0%",orient:"horizontal",padding:4,selectedMode:false,seriesIndex:seriesIndex,show:false,showGroupOnHover:true,showLegendOnHover:true,textGap:4,top:"6%",type:"piecewise"})}});return{emphasis:{itemStyle:{borderColor:"#3B99FC",borderWidth:1}},grid:{left:"150px",right:20,top:70},series:series,textStyle:{color:"#000000",fontFamily:"SourceSansPro"},tooltip:{borderColor:"#F2F2F2",borderRadius:0,extraCssText:"box-shadow: 0px 5px 6px rgba(0, 0, 0, 0.1);",formatter:param=>{const shapleyValue=param.value[0].toFixed(3);const columnIdx=param.value[1];const column=$ctrl.columns[Math.round(columnIdx-1)];const observation=param.value[3];const observationString=observation.toString().length>50?observation.toString().substring(0,50)+"...":observation.toString();const dotColor=param.color;let html='<table class="global-explanations-scatter__tooltip-table">';html+="<tr><td>"+sanitize(column)+' <i class="icon-circle" style="color: '+dotColor+'"></td><td><strong>'+sanitize(observationString)+"</strong></td></tr>";html+="<tr><td>Shapley value</td><td><strong>"+shapleyValue+"</strong></td></tr>";html+="</table>";return html},trigger:"item"},visualMap:visualMap,xAxis:{axisLabel:{margin:30},axisLine:{show:false},axisTick:{show:true},max:max,min:-max,nameGap:10,nameLocation:"middle",splitLine:{show:false},type:"value"},yAxis:{axisLabel:{formatter:function(value,index){const colName=columnsAugmented[value];return colName.length>20?colName.substring(0,20)+"...":colName}},axisLine:{show:true},axisTick:{alignWithLabel:true,show:false},data:columnsAugmented,max:columnsAugmented.length-1,min:0,splitLine:{show:true},splitNumber:columnsAugmented.length-1,type:"value"}}}}});app.component("globalExplanationsDependencePlot",{templateUrl:"/templates/modelcomparisons/comparison-tabs/scatter_plot.html",bindings:{explanations:"<",observations:"<",column:"<",type:"<",loadedStateField:"=?"},controller:function($scope,Debounce,$element,PuppeteerLoadedService){const $ctrl=this;$ctrl.$onInit=function(){$ctrl.chartOptions=buildChartOptions()};$ctrl.$onChanges=function(){$ctrl.chartOptions=buildChartOptions()};$ctrl.onChartInit=function($event){$ctrl.echartsInstance=$event;const debouncedSetPuppeteerField=PuppeteerLoadedService.getDebouncedSetField($scope,$element,$ctrl.loadedStateField);$ctrl.echartsInstance.on("rendered",()=>{debouncedSetPuppeteerField()})};function buildChartOptions(){const colExplanations=$ctrl.explanations[$ctrl.column];const colObservations=$ctrl.observations[$ctrl.column];const xAxis={type:"value",nameLocation:"middle",nameGap:30,splitLine:{show:true},axisTick:{alignWithLabel:true,show:true},name:$ctrl.column};const data=[];if($ctrl.type==="TEXT"||$ctrl.type==="CATEGORY"||$ctrl.type==="VECTOR"){const counts={};for(let i=0;i<colObservations.length;i++){counts[colObservations[i]]=1+(counts[colObservations[i]]||0)}const sortedCounts=Object.entries(counts).sort((a,b)=>b[1]-a[1]);const topCategories=sortedCounts.length>5?sortedCounts.slice(0,4).map(x=>x[0]):sortedCounts.map(x=>x[0]);const axisLabels=["",...sortedCounts.length>5?topCategories.concat(["Other"]):topCategories,""];for(let i=0;i<colObservations.length;i++){if(topCategories.includes(colObservations[i])){data.push([topCategories.indexOf(colObservations[i])+1,colExplanations[i],colObservations[i]])}else{data.push([topCategories.length+1,colExplanations[i],colObservations[i]])}}xAxis.data=axisLabels;xAxis.min=0;xAxis.max=axisLabels.length-1;xAxis.splitNumber=axisLabels.length-1;xAxis.axisLabel={formatter:function(value,index){const colName=axisLabels[value];return colName.length>20?colName.substring(0,20)+"...":colName}}}else{for(let i=0;i<colExplanations.length;i++){data.push([colObservations[i],colExplanations[i],colObservations[i]])}}return{tooltip:{trigger:"item",formatter:param=>{const shapleyValue=param.value[1];const observation=param.value[2];const observationString=observation.toString().length>50?observation.toString().substring(0,50)+"...":observation.toString();return`${sanitize($ctrl.column)}: ${sanitize(observationString)}<br>`+`Shapley value: ${shapleyValue}<br>`}},xAxis:xAxis,yAxis:{type:"value",nameLocation:"middle",nameGap:75,boundaryGap:["10%","10%"],splitLine:{show:true},name:"Shapley value"},series:[{type:"scatter",data:data,symbolSize:5}],textStyle:{color:"#000000",fontFamily:"SourceSansPro"},grid:{left:"150px",right:20}}}}});app.directive("cateHistogram",function($filter){return{scope:{histogramData:"<"},template:`<div class="h100">
            <div block-api-error />
            <ng2-lazy-echart [options]="chartOptions" ng-if="chartOptions"></ng2-lazy-echart>
        </div>`,link:function(scope){const bins=scope.histogramData.map(function(bin,idx){const mean=(bin.bin_min+bin.bin_max)/2;return[mean,bin.count,mean,bin.bin_min,bin.bin_max]});scope.chartOptions={animation:false,textStyle:{fontFamily:"SourceSansPro"},tooltip:{trigger:"axis",axisPointer:{type:"shadow"},formatter:function(data){const series=data[0];const lowerBound=$filter("nicePrecision")(series.data[3],3);const upperBound=$filter("nicePrecision")(series.data[4],3);const firstTooltipLine=series.dataIndex!==bins.length-1?`[${lowerBound}; ${upperBound})`:`[${lowerBound}; ${upperBound}]`;return`<span class="font-weight-bold">${firstTooltipLine}</span><br/>
                            <i class='icon-circle mright8' style='color: ${series.color}'></i>Count: ${series.data[1]}<br/>`}},legend:{show:false},grid:{bottom:88,left:56,right:32},xAxis:{name:"Predicted individual treatment effect",nameGap:40,nameLocation:"middle",type:"category",axisLabel:{rotate:45,formatter:value=>$filter("nicePrecision")(parseFloat(value),3)}},yAxis:{name:"Number of occurrences",nameGap:40,nameLocation:"middle",type:"value"},series:[{data:bins,type:"bar"}]};const COLORS={green:"#81C141",red:"#CE1228"};scope.chartOptions.visualMap=[{type:"piecewise",orient:"horizontal",pieces:[{max:0,color:COLORS.red,label:"Negative effect"},{min:0,color:COLORS.green,label:"Positive effect"}],dimension:2}]}}});app.directive("propensityPositivityChart",function(){return{scope:{data:"<"},template:`<div class="h100">
            <div block-api-error />
            <ng2-lazy-echart [options]="chartOptions" ng-if="chartOptions"></ng2-lazy-echart>
        </div>`,link:function(scope){const probaDistribsTreated=scope.data.probaDistribs[1];const probaDistribsControl=scope.data.probaDistribs[0];const bins=scope.data.bins;const nBins=scope.data.bins.length;const COLORS={blue:"#1F77B4",orange:"#FF7F0E"};scope.chartOptions={textStyle:{fontFamily:"SourceSansPro"},tooltip:{trigger:"axis",axisPointer:{type:"shadow"},formatter:function(params){const[firstSeries,secondSeries]=params;const idx=firstSeries.dataIndex;let tooltipContent=`<span class='text-debug'>[${idx/(nBins-1)}, ${(idx+1)/(nBins-1)}]</span><br/>`;tooltipContent+=`${firstSeries.seriesName}: <span class='font-weight-bold'>${firstSeries.data}</span>`;if(secondSeries){tooltipContent+=`<br/>${secondSeries.seriesName}: <span class='font-weight-bold'>${secondSeries.data}</span>`}return tooltipContent}},legend:{},grid:{bottom:88,left:56,right:32},xAxis:{name:"Propensity",nameGap:24,nameLocation:"middle",type:"category",data:bins},yAxis:{scale:true,name:"Number of occurrences",nameGap:40,nameLocation:"middle",type:"value"},series:[{name:"Treated",type:"bar",data:probaDistribsTreated,color:COLORS.blue},{name:"Control",type:"bar",data:probaDistribsControl,color:COLORS.orange}]}}}});app.directive("upliftMetricChart",function(){return{scope:{data:"<",metric:"@",netUplift:"<?",netUpliftPoint:"<?",testAte:"<",normalized:"<"},template:`<div class="h100">
            <div block-api-error />
            <ng2-lazy-echart [options]="chartOptions" ng-if="chartOptions"></ng2-lazy-echart>
        </div>`,link:function(scope){const curveData=scope.data.map(dataPoint=>[dataPoint.x,dataPoint.y]);const lastDataPointIdx=scope.data.length-1;const randomAssignmentData=scope.data.map((dataPoint,idx)=>[dataPoint.x,scope.testAte*idx/lastDataPointIdx]);const netUpliftAtSpecifiedLevel=scope.netUplift!=undefined&&scope.netUpliftPoint!=undefined?scope.netUplift+scope.testAte*scope.netUpliftPoint:null;const COLORS={blue:"#1F77B4",orange:"#FF7F0E",green:"#4caf50"};const toFixed=(number,precision)=>parseFloat(number.toFixed(precision));function tooltipContentForSeries(series){return`<i class='icon-circle mright8' style='color: ${series.color}'></i>
                    ${series.seriesName}: ${toFixed(series.data[1],3)}<br/>`}function updateGraph(curveData,randomAssignmentData,netUpliftAtSpecifiedLevel){if(scope.normalized){const normalizationScale=Math.abs(scope.testAte);if(normalizationScale>0){curveData=curveData.map(dataPoint=>[dataPoint[0],dataPoint[1]/normalizationScale]);randomAssignmentData=randomAssignmentData.map(dataPoint=>[dataPoint[0],dataPoint[1]/normalizationScale]);if(netUpliftAtSpecifiedLevel!=null){netUpliftAtSpecifiedLevel/=normalizationScale}}}const currentModelSeries={type:"line",symbol:"none",data:curveData,name:scope.metric,color:COLORS.blue};if(netUpliftAtSpecifiedLevel!=null){currentModelSeries.markLine={data:[{xAxis:scope.netUpliftPoint*100,label:{color:COLORS.green,padding:-4,fontSize:10}},{yAxis:netUpliftAtSpecifiedLevel,label:{align:"center",color:COLORS.green,fontSize:10,formatter:`Uplift at ${scope.netUpliftPoint*100}%: ${toFixed(netUpliftAtSpecifiedLevel,3)}\n`,lineHeight:14,padding:[0,0,0,112],position:"start"}}],lineStyle:{type:"dashed",width:1,color:COLORS.green},precision:10,silent:true,symbol:"none"}}const randomModelSeries={type:"line",symbol:"none",data:randomAssignmentData,name:"Random",color:COLORS.orange,lineStyle:{type:"dashed"}};scope.chartOptions={animation:false,legend:{type:"scroll",y:16,x:"center",itemStyle:{opacity:0}},tooltip:{trigger:"axis",textStyle:{fontSize:13},formatter:function(params){const[metricSeries,randomSeries]=params;let tooltipContent=`<b>${toFixed(metricSeries.data[0],4)}% of the population</b><br/>`;tooltipContent+=tooltipContentForSeries(metricSeries);tooltipContent+=tooltipContentForSeries(randomSeries);return tooltipContent}},textStyle:{fontFamily:"SourceSansPro"},grid:{right:4},xAxis:{axisLine:{onZero:false},axisLabel:{rotate:45,formatter:val=>toFixed(val,3)},name:"Fraction of the test observations, sorted by decreasing predicted individual effect\n(% of total test observations)",nameGap:24,nameLocation:"middle"},yAxis:{axisLabel:{formatter:val=>toFixed(val,3)},scale:true,name:"Cumulative effect"+(scope.normalized?" (ratio of the ATE on the test set)":""),nameGap:36,nameLocation:"middle",type:"value"},series:[currentModelSeries,randomModelSeries]}}scope.$watch("normalized",function(){updateGraph(curveData,randomAssignmentData,netUpliftAtSpecifiedLevel)})}}});app.controller("_snippetMetricsCommon",function($scope,PartitionedModelsService,ModelDataUtils){function getMetric(metricFieldName){return $scope.display.metrics.find(m=>metricFieldName===m.fieldName)}$scope.getAggregationExplanation=function(metric){const metricName=metric.metricName||metric.fieldName.toUpperCase();const displayName=metric.shortName||metric.name||metric.fieldName;return PartitionedModelsService.getAggregationExplanation(metricName,displayName,false,$scope.display.predictionType==="TIMESERIES_FORECAST")};$scope.getCustomMetricAggregationExplanation=function(metric){return PartitionedModelsService.getAggregationExplanation(metric.name,metric.name,true,$scope.display.predictionType==="TIMESERIES_FORECAST")};function getNumDecimalsFromMetric(numDecimalsOrMetric){if(!numDecimalsOrMetric){return 0}if(typeof numDecimalsOrMetric==="number"){return numDecimalsOrMetric}let metric=getMetric(numDecimalsOrMetric);let numDecimals=$scope.display.numDecimalsMetrics[metric.fieldName];if(metric.minDecimals){numDecimals=Math.max(metric.minDecimals,numDecimals)}if(metric.maxDecimals){numDecimals=Math.min(metric.maxDecimals,numDecimals)}return numDecimals}$scope.formatMetric=function(value,metricFieldName,forcedNumDecimals){let metric=getMetric(metricFieldName);let numDecimals;if(forcedNumDecimals){numDecimals=forcedNumDecimals}else{numDecimals=getNumDecimalsFromMetric(metricFieldName)}const modelHasProbas=ModelDataUtils.hasProbas($scope.modelData);if(angular.isUndefined(value)||value===0&&metric.ignoreZero||!modelHasProbas&&metric.needsProbability){return"-"}let exp=value>1e4;if(exp){numDecimals=4}if(metric.percentage){return getDetailedPercent(value,numDecimals).toFixed(numDecimals)+" %"}else{return getDetailedValue(value,numDecimals)[exp?"toPrecision":"toFixed"](numDecimals)}};function getDetailedValue(value,numDecimals){return Math.round(value*Math.pow(10,numDecimals))/Math.pow(10,numDecimals)}function getDetailedPercent(p,numDecimals){return getDetailedValue(p*100,numDecimals)}function getDiffWithAllDataset(metric,numDecimals){switch(metric){case"actual":return getDetailedPercent($scope.data.perf.singleMetrics.actPos["ratio"],numDecimals)-getDetailedPercent($scope.allDatasetPerf.singleMetrics.actPos["ratio"],numDecimals);case"predicted":return getDetailedPercent($scope.data.perf.singleMetrics.predPos["ratio"],numDecimals)-getDetailedPercent($scope.allDatasetPerf.singleMetrics.predPos["ratio"],numDecimals);default:return 0}}$scope.isAboveAllDataset=function(metric){return getDiffWithAllDataset(metric,getNumDecimalsFromMetric(metric))>0};$scope.isBelowAllDataset=function(metric){return getDiffWithAllDataset(metric,getNumDecimalsFromMetric(metric))<0};$scope.getAbsoluteDiffWithAllDataset=function(metric,numDecimalsOrMetric){const numDecimals=getNumDecimalsFromMetric(numDecimalsOrMetric);return Math.abs(getDiffWithAllDataset(metric,numDecimals).toFixed(numDecimals))+" %"}});app.directive("partitionSummaryValue",function(){return{restrict:"E",templateUrl:"/templates/ml/prediction-model/partition_summary-value.html",scope:{allDatasetPerf:"=",data:"=",threshold:"=",colors:"=",display:"=",modelData:"=",partitionStates:"="},controller:function($scope,$controller){$controller("_snippetMetricsCommon",{$scope:$scope});$scope.getLinearGradient=function(ratio){return"linear-gradient(to right, #c6e8d3 0%, #c6e8d3 "+ratio*100+"%,rgba(0, 0, 0, 0) "+ratio*100+"%, rgba(0, 0, 0, 0) 100%)"};$scope.uiState={isExpanded:false};$scope.getCustomMetricResult=function(customMetricResults,customMetricName){return customMetricResults.find(metricResult=>metricResult.metric.name===customMetricName)};$scope.onClick=function(event){if($scope.data.excluded)return;if($scope.display.predictionType==="TIMESERIES_FORECAST")return;if(event.originalEvent.composedPath().some(_=>_.className==="icon-info-sign"))return;$scope.uiState.isExpanded=!$scope.uiState.isExpanded}}}});app.controller("VariableCoefficientController",function($scope,$filter,ListFilter,Debounce,ExportUtils,getNameValueFromMLFeatureFilter){$scope.uiState={advanced:false};var coefs=$scope.modelData.iperf.lmCoefficients.variables.map(function(v,i){var splitedFeature=getNameValueFromMLFeatureFilter(v),o={full:v,name:splitedFeature.name,value:splitedFeature.value,coef:this.coefs[i],coefRescaled:this.rescaledCoefs?this.rescaledCoefs[i]:undefined,abs:Math.abs(this.coefs[i]),rescaledAbs:this.rescaledCoefs?Math.abs(this.rescaledCoefs[i]):undefined};if(this.tstat){o.tstat=this.tstat[i]}if(this.pvalue){o.pvalue=this.pvalue[i]}if(this.stderr){o.stderr=this.stderr[i]}if(this.rescaledStderr){o.rescaledStderr=this.rescaledStderr[i]}return o},$scope.modelData.iperf.lmCoefficients),maxCoef=Math.max.apply(Math,$scope.modelData.iperf.lmCoefficients.coefs.map(Math.abs)),maxRescaledCoef=$scope.modelData.iperf.lmCoefficients.rescaledCoefs?Math.max.apply(Math,$scope.modelData.iperf.lmCoefficients.rescaledCoefs.map(Math.abs)):undefined,filteredCoefs=coefs;function getVars(){filteredCoefs=!$scope.coefFilter?coefs:ListFilter.filter(coefs,$scope.coefFilter);sortVars()}function sortVars(){var sort=["+name","+value"];var by=$scope.sort.by;if(!$scope.displayOptions.showRawCoefs){if(by=="abs"){by="rescaledAbs"}else if(by=="coef"){by="coefRescaled"}}if($scope.sort.by!=="name"){sort.unshift("+"+by)}sort[0]=($scope.sort.reverse?"-":"+")+sort[0].substring(1);$scope.pagination.list=$filter("orderBy")(filteredCoefs,sort);$scope.pagination.page=1;getCoeffs()}function getCoeffs(){$scope.pagination.update();$scope.coefs=$scope.pagination.slice}$scope.exportCoefficients=function(){let lmc=$scope.modelData.iperf.lmCoefficients;let f=$filter("mlFeature");let data;if($scope.uiState.advanced){data=$filter("orderBy")(coefs,"-abs").map(function(x){return[x.full,f(x.full),$scope.displayOptions.showRawCoefs?x.coef:x.coefRescaled,x.stderr===0?"":x.stderr,x.tstat===0?"":x.tstat,x.pvalue===0?"":x.pvalue]});data.push(["Intercept",null,$scope.displayOptions.showRawCoefs?lmc.interceptCoef:lmc.rescaledInterceptCoef,lmc.interceptStderr===0?"":lmc.interceptStderr,lmc.interceptTstat===0?"":lmc.interceptTstat,lmc.interceptPvalue===0?"":lmc.interceptPvalue])}else{data=$filter("orderBy")(coefs,"-abs").map(function(x){return[x.full,f(x.full),$scope.displayOptions.showRawCoefs?x.coef:x.coefRescaled]});data.push(["Intercept",null,$scope.displayOptions.showRawCoefs?lmc.interceptCoef:lmc.rescaledInterceptCoef])}let columns=[{name:"feature_name",type:"string"},{name:"feature_description",type:"string"},{name:"coefficient",type:"double"}];if($scope.uiState.advanced){columns.push({name:"stderr",type:"double"});columns.push({name:"tstat",type:"double"});columns.push({name:"pvalue",type:"double"})}ExportUtils.exportUIData($scope,{columns:columns,data:data},"Export coefficients")};$scope.sorts={name:"Name",coef:"Coefficient",abs:"| Coefficient |"};if($scope.modelData.iperf.lmCoefficients.pvalue){$scope.sorts["pvalue"]="Trust"}$scope.sort={by:"abs",reverse:true};$scope.baseWidth=function(){return 50/($scope.displayOptions.showRawCoefs?maxCoef:maxRescaledCoef)};$scope.displayPossibleSmall=function(value){if(value<1e-4){return"< 1e-4"}else{return value.toFixed(4)}};$scope.getCoef=function(c){return $scope.displayOptions.showRawCoefs?c.coef:c.coefRescaled};var lmc=$scope.modelData.iperf.lmCoefficients;$scope.getIntercept=function(){return $scope.displayOptions.showRawCoefs?lmc.interceptCoef:lmc.rescaledInterceptCoef};$scope.getInterceptStderr=function(){return $scope.displayOptions.showRawCoefs?lmc.interceptStderr:lmc.rescaledInterceptStderr};$scope.getInterceptTstat=function(){return $scope.displayOptions.showRawCoefs?lmc.interceptTstat:lmc.rescaledInterceptTstat};$scope.getInterceptPvalue=function(){return $scope.displayOptions.showRawCoefs?lmc.interceptPvalue:lmc.rescaledInterceptPvalue};$scope.getStderr=function(c){return $scope.displayOptions.showRawCoefs?c.stderr:c.rescaledStderr};$scope.getAbs=function(c){return $scope.displayOptions.showRawCoefs?c.abs:c.rescaledAbs};$scope.coefFilter="";$scope.displayOptions={showRawCoefs:!$scope.modelData.iperf.lmCoefficients.rescaledCoefs};$scope.pagination=new ListFilter.Pagination([],50);$scope.$watch("coefFilter",Debounce().withScope($scope).withDelay(75,150).wrap(getVars),true);$scope.$watch("sort",sortVars,true);$scope.$watch("displayOptions",sortVars,true);$scope.$watch("pagination.page",getCoeffs);getVars();$scope.puppeteerHook_elementContentLoaded=true});app.controller("MultiClassConfusionMatrixController",function($scope,Fn,$filter,Assert){Assert.trueish($scope.modelData.perf,"no modelData.perf");Assert.trueish($scope.modelData.perf.confusion,"no confusion matrix data");var perActual=$scope.modelData.perf.confusion.perActual;$scope.total=$scope.modelData.perf.confusion.totalRows;if($scope.modelData.classes&&$scope.modelData.classes.length){$scope.cs=$scope.modelData.classes}else{$scope.cs=$scope.modelData.perf.classes}$scope.n=$scope.cs.length;$scope.displayMode="actual";var predictedClassCount=$scope.cs.map(Fn.cst(0)),all100=$scope.cs.map(Fn.cst("100 %")),smartPC=$filter("smartPercentage"),data={};data.records=$scope.cs.map(function(ca,i){return $scope.cs.map(function(cp,j){if(!perActual[ca]||!perActual[ca].perPredicted[cp])return 0;predictedClassCount[j]+=perActual[ca].perPredicted[cp];return perActual[ca].perPredicted[cp]})});data.actual=data.records.map(function(cps,i){if(!perActual[$scope.cs[i]])return cps.map(_=>"-");return cps.map(function(cp){return this>0?smartPC(cp/this,0,true):"-"},perActual[$scope.cs[i]].actualClassCount)});data.predicted=data.records.map(function(cps){return cps.map(function(cp,j){return predictedClassCount[j]>0?smartPC(cp/predictedClassCount[j],0,true):"-"})});$scope.tableHidden=data.records.length>50;$scope.showTable=function(){$scope.tableHidden=false};$scope.data=data;$scope.sumActual={records:$scope.cs.map(Fn.dict(perActual,{})).map(Fn.prop("actualClassCount")).map(x=>isNaN(x)?0:x),actual:all100};$scope.sumPredicted={records:predictedClassCount,predicted:all100};$scope.total=$scope.sumActual.records.reduce(function(x,y){return Number(x)+Number(y)},0);$scope.puppeteerHook_elementContentLoaded=true});app.controller("ROCCurveController",function($scope,ExportUtils){$scope.setLabels=function(){if($scope.areMetricsWeighted()){$scope.data.xlabel="Weighted False Positive Rate";$scope.data.ylabel="Weighted True Positive Rate"}else{$scope.data.xlabel="False Positive Rate";$scope.data.ylabel="True Positive Rate"}};const perf=$scope.modelData.perf;if($scope.isMulticlass()){$scope.setRocClass=function(nv){$scope.data=[perf.oneVsAllRocCurves[nv]];$scope.rocAuc=perf.oneVsAllRocAUC[nv];$scope.setLabels()};$scope.rocClass=$scope.modelData.classes[0];$scope.setRocClass($scope.rocClass);$scope.auc=perf.metrics.mrocAUC;$scope.aucstd=perf.metrics.mrocAUCstd}else{$scope.data=perf.rocVizData;$scope.auc=perf.tiMetrics.auc;$scope.aucstd=perf.tiMetrics.aucstd;$scope.setLabels()}$scope.exportROCData=function(){var data=$scope.data[0].map(function(x){return[x.x,x.y,x.p>1?1:x.p]});ExportUtils.exportUIData($scope,{name:"ROC data for model: "+$scope.modelData.userMeta.name,columns:[{name:"False positive rate",type:"double"},{name:"True positive rate",type:"double"},{name:"Proba threshold",type:"double"}],data:data},"Export ROC curve")};$scope.$on("exportData",function(){$scope.exportROCData()})});app.controller("PrecisionRecallCurveController",function($scope,ExportUtils){$scope.setLabels=function(){$scope.data.xlabel="Recall";$scope.data.ylabel="Precision";if($scope.areMetricsWeighted()){$scope.data.xlabel="Weighted "+$scope.data.xlabel;$scope.data.ylabel="Weighted "+$scope.data.ylabel}};const perf=$scope.modelData.perf;if($scope.isMulticlass()){$scope.setPrClass=function(nv){$scope.data=[perf.oneVsAllPrCurves[nv]];$scope.classAveragePrecision=perf.oneVsAllAveragePrecision[nv];$scope.setLabels()};$scope.prClass=$scope.modelData.classes[0];$scope.setPrClass($scope.prClass);$scope.averagePrecision=perf.metrics.averagePrecision;$scope.averagePrecisionstd=perf.metrics.averagePrecisionstd}else{$scope.data=perf.prVizData;$scope.averagePrecision=perf.tiMetrics.averagePrecision;$scope.averagePrecisionstd=perf.tiMetrics.averagePrecisionstd;$scope.setLabels()}$scope.hasFolds=$scope.modelData.trainInfo.kfold;$scope.exportPRData=function(){var data=$scope.data[0].bins.map(function(x){return[x.x,x.y,x.p>1?1:x.p]});ExportUtils.exportUIData($scope,{name:"Precision-Recall data for model: "+$scope.modelData.userMeta.name,columns:[{name:"Recall",type:"double"},{name:"Precision",type:"double"},{name:"Proba threshold",type:"double"}],data:data},"Export Precision-Recall curve")};$scope.$on("exportData",function(){$scope.exportPRData()})});app.controller("RocAndPrCurvesController",function($scope,$state,$stateParams){$scope.curves=[{curveId:"roc",fullName:"ROC curve",buttonName:"ROC curve",template:"/templates/ml/prediction-model/c_roc.html",available:$scope.hasROCCurve()},{curveId:"pr",fullName:"Precision-Recall curve",buttonName:"PR curve",template:"/templates/ml/prediction-model/c_precision_recall.html",available:$scope.hasPRCurve()}];if($stateParams.curveId){$scope.displayedCurve=$scope.curves.find(c=>c.curveId===$stateParams.curveId)}$scope.displayedCurve=$scope.displayedCurve||$scope.curves.find(c=>c.available)||$scope.curves[0];$scope.embeddedMode=true;$scope.selectCurve=function(curve){$scope.displayedCurve=curve;$state.go($state.current,{curveId:curve.curveId},{reload:false})};$scope.exportData=function(){$scope.$broadcast("exportData")}});app.controller("CalibrationCurveController",function($scope,ExportUtils){const perf=$scope.perf;$scope.setLabels=function(){if($scope.areMetricsWeighted()){$scope.data.xlabel="Weighted Average of Predicted Probability for Positive Class";$scope.data.ylabel="Weighted Frequency of Positive Class"}else{$scope.data.xlabel="Average of Predicted Probability for Positive Class";$scope.data.ylabel="Frequency of Positive Class"}};if($scope.isMulticlass()){$scope.setCalibrationClass=function(nv){$scope.data=[perf.oneVsAllCalibrationCurves[nv]];$scope.calibrationLoss=perf.oneVsAllCalibrationLoss[nv];$scope.setLabels()};$scope.calibrationClass=$scope.modelData.classes[0];$scope.setCalibrationClass($scope.calibrationClass);$scope.mCalibrationLoss=perf.metrics.mCalibrationLoss;$scope.mCalibrationLossStd=perf.metrics.mCalibrationLossstd}else{$scope.data=[perf.calibrationData];$scope.calibrationLoss=perf.tiMetrics.calibrationLoss;$scope.setLabels()}var calibrationMethod=$scope.modelData.coreParams&&$scope.modelData.coreParams.calibration?$scope.modelData.coreParams.calibration.calibrationMethod:undefined;if(calibrationMethod==="ISOTONIC"){$scope.uiState.calibrationMethod="Isotonic Regression"}else if(calibrationMethod==="SIGMOID"){$scope.uiState.calibrationMethod="Sigmoid (Platt scaling)"}else{$scope.uiState.calibrationMethod="No calibration"}$scope.exportCalibrationData=function(){const data=$scope.data[0].filter(_=>_.n>0).map(_=>[_.x,_.y,_.n]);ExportUtils.exportUIData($scope,{name:"Calibration data for model: "+$scope.modelData.userMeta.name,columns:[{name:"Average of Predicted Probability for Positive Class",type:"double"},{name:"Frequency of Positive Class",type:"double"},{name:"Count of Records",type:"double"}],data:data},"Export Calibration Curve")};$scope.hasCalibrationData=function(){return typeof perf.calibrationData!=="undefined"||typeof perf.oneVsAllCalibrationCurves!=="undefined"}});app.service("ResidualsPlottingService",function(){const BLUE_COLOR="#1F77B4";const ORANGE_COLOR="#FF7F0E";return{createResidualsBarChartConfig:createResidualsBarChartConfig,getQQPlotConfig:getQQPlotConfig};function createResidualsBarChartConfig(residuals,isStandardized=true,residualsMean=null,residualsStd=null){const zeroResiduals=residuals.every(value=>value===0);let minResidual,maxResidual;if(residuals&&residuals.length>0){minResidual=maxResidual=residuals[0];for(let i=1;i<residuals.length;i++){if(residuals[i]<minResidual)minResidual=residuals[i];if(residuals[i]>maxResidual)maxResidual=residuals[i]}}else{minResidual=maxResidual=0}const x=d3.scale.linear().domain([minResidual,maxResidual]).nice();const data=d3.layout.histogram().frequency(0).bins(x.ticks(20))(residuals);const bars=data.filter(d=>d.length>0).map(d=>{return{min:d.x,max:d.x+d.dx,count:d.length}});const scaleFactor=residuals.length*(Math.abs(maxResidual-minResidual)/data.filter(d=>d.length>0).length);function generateNormalDistribution(mean,stdDev,xs){let data=[];xs.forEach(x=>{let fx=1/Math.sqrt(2*Math.PI*Math.pow(stdDev,2))*Math.exp(-Math.pow(x-mean,2)/(2*Math.pow(stdDev,2)));data.push([x,fx*scaleFactor])});return data}const bins=bars.map(b=>[(b.max+b.min)/2,b.count]);const title=zeroResiduals?{text:"All residuals are 0",left:"center",top:"center",textStyle:{fontWeight:"bold",fontSize:12}}:{text:isStandardized?"Standardized residuals distribution":"Residuals distribution",textAlign:"left",textStyle:{fontWeight:"bold",fontSize:12}};const graphOptions={grid:{top:32,bottom:40,right:8,left:48},title:title,xAxis:[{name:isStandardized?"Standardized residual value":"Residual value",type:"value",nameLocation:"middle",nameGap:24}],yAxis:[{name:"Count",nameRotate:90,nameGap:36,type:"value",nameLocation:"center",axisLabel:{formatter:function(value){if(residuals&&residuals.length>0){return`${(value*100/residuals.length).toFixed(0)}%`}else{return`${value}`}}}}],tooltip:{trigger:"axis",confine:true,formatter:params=>{return params.map(p=>{if(residuals&&residuals.length>0){const percent=(p.value[1]*100/residuals.length).toFixed(2)+"%";return`${p.marker} ${p.seriesName}<span style="float: right; margin-left: 20px"><b> ${percent}</b></span>`}else{return`${p.marker} ${p.seriesName}<span style="float: right; margin-left: 20px"><b> ${p.value[1]}</b></span>`}}).join("<br/>")}},series:[{name:"Count",type:"bar",barWidth:"100%",data:bins,color:BLUE_COLOR},{name:"Normal distribution",type:"line",showSymbol:true,clip:true,data:generateNormalDistribution(isStandardized?0:residualsMean,isStandardized?1:residualsStd,bars.map(b=>(b.max+b.min)/2)),color:ORANGE_COLOR}]};if(!isStandardized){graphOptions.series.push({name:"Mean",type:"line",markLine:{silent:true,symbol:"none",label:{show:true,formatter:"Average (clipped): {c}"},data:[{xAxis:residualsMean,lineStyle:{color:ORANGE_COLOR,width:2,type:"dashed"}}]}})}return graphOptions}function getQQPlotConfig(stdResiduals,theoreticalQuantiles){return{grid:{top:32,bottom:40,right:8,left:48},title:{text:"Normal Q-Q Plot",textAlign:"left",textStyle:{fontWeight:"bold",fontSize:12}},xAxis:{name:"Standardized quantiles",nameLocation:"start",nameGap:32,nameRotate:90},yAxis:{name:"Theoretical quantiles",nameGap:24,nameLocation:"start"},tooltip:{trigger:"axis",confine:true},series:[{data:stdResiduals.sort(function(a,b){return a-b}).map((r,idx)=>[theoreticalQuantiles[idx],r]),type:"scatter",symbolSize:4,color:BLUE_COLOR,name:"Standardized quantiles",sampling:"lttb"},{data:[[theoreticalQuantiles[0],theoreticalQuantiles[0]],[theoreticalQuantiles[theoreticalQuantiles.length-1],theoreticalQuantiles[theoreticalQuantiles.length-1]]],type:"line",showSymbol:false,color:ORANGE_COLOR,name:"Theoretical quantiles"}]}}});app.controller("ErrorDistributionController",function($scope,ResidualsPlottingService,$filter){if(getCookie("dku_graphics_export")==="true"){$scope.isInExport=true}const rp=$scope.modelData.perf.regression_performance;angular.forEach(rp,function(v,k){if(k.substr(-6)==="_error"&&typeof v==="number"){$scope[k.substr(0,k.length-6)]=v.toPrecision(5)}});$scope.hasRawMinMax=function(){return $scope.modelData.perf.regression_performance.hasOwnProperty("raw_min_error")&&$scope.modelData.perf.regression_performance.hasOwnProperty("raw_max_error")};$scope.hasRawMeanStd=function(){return $scope.modelData.perf.regression_performance.hasOwnProperty("raw_average_error")&&$scope.modelData.perf.regression_performance.hasOwnProperty("raw_std_error")};$scope.nicePrecision=n=>$filter("nicePrecision")(n,4);const residuals=$scope.modelData.perf?.residuals;if(residuals){$scope.residualsHistograms=ResidualsPlottingService.createResidualsBarChartConfig(residuals.residuals,false,residuals.residualsMean,residuals.residualsStd);$scope.stats=residuals.stats;$scope.qqplots=ResidualsPlottingService.getQQPlotConfig(residuals.stdResiduals,residuals.theoreticalQuantiles)}if(rp.error_distribution){$scope.bars=rp.error_distribution.map(function(p){return{min:p.bin_min,max:p.bin_max,count:p.count}})}setTimeout(function(){$scope.puppeteerHook_elementContentLoaded=true},2e3)});app.controller("StdModelReportFeaturesHandlingController",function($scope,ListFilter,TimeseriesForecastingUtils,DataikuAPI,EmbeddingService){$scope.filter={query:"",pagination:new ListFilter.Pagination([],40)};$scope.uiState={showAllPreprocessedFeatures:false};$scope.getCategoricalEncodingHeader=function(feature){return["category"].concat($scope.modelData.preprocessingReport.categoricalEncodings[feature]["targetValues"])};$scope.getLimitedCategoricalEncodingRows=function(feature){const featureEncodings=$scope.modelData.preprocessingReport.categoricalEncodings[feature];const sortByCountsIndices=featureEncodings.counts.map((count,idx)=>{return{idx:idx,count:count}}).sort((a,b)=>{return a.count>b.count?-1:a.count==b.count?0:1}).map(obj=>obj.idx);return sortByCountsIndices.map(idx=>{return[featureEncodings.values[idx]].concat(featureEncodings.encodings[idx])}).slice(0,20)};$scope.updateList=function(){$scope.filteredList=ListFilter.filter($scope.features,$scope.filter.query);$scope.currentPageItems=$scope.filter.pagination.updateAndGetSlice($scope.filteredList)};$scope.$watch("filter",$scope.updateList,true);$scope.embeddingMetadataFetcher=EmbeddingService.metadataFetcher(setErrorInScope.bind($scope));$scope.$watch("modelData",function(nv,ov){if(nv){$scope.features=[];const algoDoesNotSupportExternalFeatures=TimeseriesForecastingUtils.ALGOS_WITHOUT_EXTERNAL_FEATURES.names.includes($scope.modelData.modeling.algorithm);const algoSupportsPastOnlyExternalFeatures=TimeseriesForecastingUtils.ALGOS_COMPATIBLE_WITH_PAST_ONLY_FEATURES.names.includes($scope.modelData.modeling.algorithm);$.each($scope.modelData.preprocessing.per_feature,function(k,v){const featurePreprocessing=Object.assign({},v);featurePreprocessing.name=k;const hasCategoricalEncodings=nv.preprocessingReport&&"categoricalEncodings"in nv.preprocessingReport&&k in nv.preprocessingReport.categoricalEncodings&&nv.preprocessingReport.categoricalEncodings[k].values.length>0;featurePreprocessing.hasReport=featurePreprocessing.type=="CATEGORY"&&featurePreprocessing.role!="REJECT"&&featurePreprocessing.category_handling=="IMPACT"&&hasCategoricalEncodings||featurePreprocessing.type=="CATEGORY"&&featurePreprocessing.role!="REJECT"&&featurePreprocessing.category_handling=="ORDINAL"&&hasCategoricalEncodings||featurePreprocessing.type=="CATEGORY"&&featurePreprocessing.role!="REJECT"&&featurePreprocessing.category_handling=="FREQUENCY"&&hasCategoricalEncodings||featurePreprocessing.type=="TEXT"&&featurePreprocessing.role!="REJECT"&&featurePreprocessing.text_handling=="TOKENIZE_COUNTS"||featurePreprocessing.type=="TEXT"&&featurePreprocessing.role!="REJECT"&&featurePreprocessing.text_handling=="SENTENCE_EMBEDDING"||featurePreprocessing.type=="IMAGE"&&featurePreprocessing.role!="REJECT"&&featurePreprocessing.image_handling=="EMBEDDING_EXTRACTION"||featurePreprocessing.type=="TEXT"&&featurePreprocessing.role!="REJECT"&&featurePreprocessing.text_handling=="TOKENIZE_TFIDF";const isUnsupportedExternalFeature=(featurePreprocessing.role==="INPUT"||featurePreprocessing.role==="INPUT_PAST_ONLY")&&algoDoesNotSupportExternalFeatures;const isUnsupportedPastOnlyFeature=featurePreprocessing.role==="INPUT_PAST_ONLY"&&!algoSupportsPastOnlyExternalFeatures;if(isUnsupportedExternalFeature||isUnsupportedPastOnlyFeature){featurePreprocessing.role="REJECT"}if(featurePreprocessing.role==="TIMESERIES_IDENTIFIER"){const resolvedParams=$scope.modelData.actualParams.resolved;const resolvedAlgoParamsWithIdsAsFeatCapability=resolvedParams.gluonts_deepar_timeseries_params||resolvedParams.gluonts_transformer_timeseries_params||resolvedParams.gluonts_mqcnn_timeseries_params;featurePreprocessing.alsoHasInputRole=resolvedAlgoParamsWithIdsAsFeatCapability&&resolvedAlgoParamsWithIdsAsFeatCapability.use_timeseries_identifiers_as_features}$scope.features.push(featurePreprocessing)});$scope.updateList();$scope.someMonotonicityConstraints=Object.values($scope.modelData.preprocessing.per_feature).some(x=>x.role=="INPUT"&&x.type=="NUMERIC"&&x.numerical_handling=="REGULAR"&&x.monotonic!="NONE")}})});app.component("featureGenerationReport",{bindings:{modelData:"<"},templateUrl:"/templates/ml/prediction-model/timeseries/feature-generation.html",controller:function(ListFilter,TimeseriesForecastingUtils,$scope){var ctrl=this;ctrl.prettyTimeUnit=TimeseriesForecastingUtils.prettyTimeUnit;ctrl.$onInit=function(){ctrl.tables={shiftPagination:new ListFilter.Pagination([],40),windowsPaginations:[]};ctrl.hasAutoShifts=Object.entries(ctrl.modelData.preprocessing.feature_generation.shifts).some(shiftAndFeatureName=>shiftAndFeatureName[1].from_horizon_mode=="AUTO");ctrl.autoShiftsParams=ctrl.modelData.preprocessing.feature_generation.auto_shifts_params;ctrl.shifts=Object.entries(ctrl.modelData.preprocessing.feature_generation.shifts).map(shiftAndFeatureName=>{let copy=angular.copy(shiftAndFeatureName);let feature_name=copy[0];let shift=copy[1];shift.feature_name=feature_name;shift.feature_type=ctrl.modelData.preprocessing.per_feature[feature_name].type;shift.feature_role=ctrl.modelData.preprocessing.per_feature[feature_name].role;return shift}).filter(x=>x.feature_role!=="REJECT").filter(x=>x.from_forecast.length>0||x.from_horizon_mode=="FIXED"&&x.from_horizon.length>0||x.from_horizon_mode=="AUTO");ctrl.windows=ctrl.modelData.preprocessing.feature_generation.windows.map((rawWindow,index)=>{let window=angular.copy(rawWindow);window.operations_list=Object.entries(window.operations_map).filter(featureNameAndWindowOperations=>{let featureName=featureNameAndWindowOperations[0];return TimeseriesForecastingUtils.isWindowCompatible(ctrl.modelData.preprocessing.per_feature[featureName])&&featureNameAndWindowOperations[1].some(operation=>operation.enabled)}).map(featureNameAndWindowOperations=>{let res={};res.feature_name=featureNameAndWindowOperations[0];res.feature_type=ctrl.modelData.preprocessing.per_feature[res.feature_name].type;res.feature_role=ctrl.modelData.preprocessing.per_feature[res.feature_name].role;res.window=featureNameAndWindowOperations[1];return res});ctrl.tables.windowsPaginations.push(new ListFilter.Pagination([],40));window.index=index;return window});ctrl.windows=ctrl.windows.filter(x=>x.operations_list.length>0);ctrl.updateList=function(){ctrl.currentPageShifts=ctrl.tables.shiftPagination.updateAndGetSlice(ctrl.shifts);ctrl.windowPages=ctrl.tables.windowsPaginations.map((windowPagination,index)=>windowPagination.updateAndGetSlice(ctrl.windows[index].operations_list))};ctrl.updateList();ctrl.getCompatibleOperations=function(feature){return feature.window.filter(operation=>feature.feature_type==="CATEGORY"&&operation.operation==="FREQUENCY"||feature.feature_type==="NUMERIC"&&operation.operation!=="FREQUENCY")}};$scope.$watch(()=>ctrl.tables,function(newVal,oldVal){ctrl.updateList()},true)}});app.controller("GridSearchReportController",function($scope,$filter,PMLSettings,ExportUtils,MLChartsCommon,CustomMetricIDService,NumberFormatter,Fn){$scope.fieldList=[{field:"score",name:"Score",metric:true},{field:"scoreStd",name:"Score StdDev",metric:true},{field:"fitTime",name:"Fit Time",metric:true},{field:"fitTimeStd",name:"Fit Time StdDev",metric:true},{field:"scoreTime",name:"Score Time",metric:true},{field:"scoreTimeStd",name:"Score Time StdDev",metric:true}];$scope.uiState={showConstantColumns:false,chartColumn:null,chartLogScale:null,showFitTime:false,view:"1D"};$scope.selectView=function(view){$scope.uiState.view=view};$scope.$watch("modelData.iperf.gridCells",gridCells=>{if(!gridCells)return;$scope.gridCells=gridCells;if(["SVC_CLASSIFICATION","SVM_REGRESSION"].includes($scope.modelData.modeling.algorithm)){$scope.gridCells.forEach(function(cell){let gamma_value=cell.params.gamma;if(typeof gamma_value!=="undefined"&&!["auto","scale"].includes(gamma_value)){cell.params["custom_gamma"]=gamma_value;cell.params["gamma"]="custom"}})}$scope.paramColumns=gridCells.map(_=>Object.keys(_.params)).reduce((a,b)=>a.concat(b.filter(_=>a.indexOf(_)<0)),[]);$scope.gridData=gridCells.map(cell=>$scope.paramColumns.map(_=>cell.params[_]).concat($scope.fieldList.map(_=>cell[_.field])).map(_=>_===null||_===undefined?"":_));$scope.pairwiseDependencies=computeHyperparametersPairwiseDependencies();const columnChanges=$scope.paramColumns.map((col,i)=>$scope.gridData.map(_=>_[i]).some((cell,j,values)=>j>0&&cell!=values[j-1]));$scope.changingParamColumns=$scope.paramColumns.filter((col,i)=>columnChanges[i]);$scope.changingGridData=$scope.gridData.map((row,j)=>row.filter((col,i)=>i>=$scope.paramColumns.length||columnChanges[i]));if($scope.changingParamColumns.indexOf($scope.uiState.chartColumn)<0){$scope.uiState.chartColumn=$scope.changingParamColumns[0]}const metric=$scope.modelData.modeling.metrics.evaluationMetric;if(metric){if(metric==="CUSTOM"){const customEvaluationMetricName=$scope.modelData.modeling.metrics.customEvaluationMetricName;const customMetric=$scope.modelData.modeling.metrics.customMetrics.find(cM=>cM.name===customEvaluationMetricName);$scope.uiState.currentMetric=CustomMetricIDService.getCustomMetricId(customMetric.name);$scope.uiState.scoreMetric=" ("+customEvaluationMetricName+")"}else{$scope.uiState.scoreMetric=" ("+(PMLSettings.names.evaluationMetrics[metric]||metric)+")";$scope.uiState.currentMetric=metric}}else{$scope.uiState.scoreMetric="";$scope.uiState.currentMetric=metric}});$scope.$watch("uiState.showConstantColumns",showConstantColumns=>{let tableData;let tableColumns;if(showConstantColumns){tableColumns=$scope.paramColumns;tableData=$scope.gridData}else{tableColumns=$scope.changingParamColumns;tableData=$scope.changingGridData}$scope.displayColumns=tableColumns.map(col=>({field:col,name:col,metric:false})).concat($scope.fieldList);$scope.displayData=tableData.map(row=>{return $scope.displayColumns.reduce((result,item,index)=>{result[item.field]=row[index];return result},{})})});$scope.formatSearchTableValue=function(value,precision,displayIntegersAsFloat){if(angular.isString(value)){return value!==""?value:"-"}var isInteger=value%1==0;return displayIntegersAsFloat||!isInteger?value.toFixed(precision):value};function formatTimeShort(maxValue,seconds){let components=[];if(maxValue>=86400){components=[{v:Math.floor(seconds/86400),t:"d"},{v:Math.round(seconds%86400/3600),t:"h"}]}else if(maxValue>=3600){components=[{v:Math.floor(seconds/3600),t:"h"},{v:Math.round(seconds%3600/60),t:"m"}]}else if(maxValue>=60){components=[{v:Math.floor(seconds/60),t:"m"},{v:Math.round(seconds%60),t:"s"}]}else if(maxValue>=10){components=[{v:Math.round(seconds),t:"s"}]}else if(maxValue>=1){components=[{v:seconds.toFixed(1),t:"s"}]}else if(maxValue>=.1){components=[{v:seconds.toFixed(2),t:"s"}]}else{components=[{v:seconds.toFixed(3),t:"s"}]}if(seconds===0){return"0"+components[components.length-1].t}else{let result="";components.forEach(function(item){if(item.v>0){if(result.length>0){result+=" "}result+=item.v+item.t}});return result}}function formatTimeFull(seconds){let str="";if(seconds>=86400){str+=Math.floor(seconds/86400)+"d ";seconds=seconds%86400}if(seconds>=3600){str+=Math.floor(seconds/3600)+"h ";seconds=seconds%3600}if(seconds>=60){str+=Math.floor(seconds/60)+"m ";seconds=seconds%60}return str+seconds.toFixed(3)+"s"}$scope.$watch("uiState.chartColumn",column=>{const colIdx=$scope.paramColumns.indexOf(column);if(colIdx<0)return;const scoreIdx=$scope.paramColumns.length;const fitTimeIdx=scoreIdx+2;const colors=$scope.colors.slice(0,3);const naturalSort=(a,b)=>a==b?0:a<b?-1:1;const validGridData=filterInvalidScoresFromGridData();let x=validGridData.map(_=>_[colIdx]);let score=validGridData.map(_=>_[scoreIdx]);let fitTime=validGridData.map(_=>_[fitTimeIdx]);function groupByX(series,x){const values={};const min={};const max={};for(let i in x){const curX=x[i];if(!(curX in values)){values[curX]=[]}values[curX].push(series[i])}for(let curX in values){min[curX]=Math.min(...values[curX]);max[curX]=Math.max(...values[curX]);values[curX]=values[curX].reduce((a,b)=>a+b,0)/values[curX].length}return{avg:values,min:min,max:max}}score=groupByX(score,x);fitTime=groupByX(fitTime,x);x=x.sort(naturalSort).filter((curX,i,x)=>curX!==""&&(i==0||curX!=x[i-1]));for(let k of["avg","min","max"]){score[k]=x.map(curX=>score[k][curX]);fitTime[k]=x.map(curX=>fitTime[k][curX])}const minScore=Math.min(...score.min);const maxScore=Math.max(...score.max);const minAvgScore=Math.min(...score.avg);const maxAvgScore=Math.max(...score.avg);const maxFitTime=Math.max(...fitTime.max);const lib=PMLSettings.sort.lowerIsBetter($scope.uiState.currentMetric,$scope.modelData.modeling.metrics.customMetrics)?-1:1;const indexOfBestScore=lib>0?score.avg.indexOf(maxAvgScore):score.avg.indexOf(minAvgScore);const scale=function(){if(minScore>=0&&maxScore<=1){if(maxAvgScore-minAvgScore>=.2){return[0,1]}else{const factor=Math.abs(maxScore-minScore)*.1;const furtherMax=maxScore>0?maxScore+factor:maxScore-factor;const furtherMin=minScore>0?minScore-factor:minScore+factor;return[Math.max(0,furtherMin),Math.min(1,furtherMax)]}}else{const furtherMax=maxScore>0?maxScore*1.05:maxScore*.95;const furtherMin=minScore>0?minScore*.95:minScore*1.05;return[furtherMin,furtherMax]}}();const scale2=[0,maxFitTime];const xAreNumbers=x.every(_=>typeof _==="number");const format=["",minScore>-10&&maxScore<10?".4g":".4s",formatTimeShort.bind(null,maxFitTime),formatTimeFull];const svgAreaCallback=MLChartsCommon.makeSvgAreaCallback(scope=>[{color:colors[0],values:$scope.chart.x.map((curX,i)=>({x:curX,y0:score.min[i],y1:score.max[i]}))},{color:colors[1],yScale:scope.ys2.scale.copy().range(scope.chart.yScale().range()),values:$scope.chart.x.map((curX,i)=>({x:curX,y0:fitTime.min[i],y1:fitTime.max[i]}))}]);const svgCallback=(svg,scope)=>{svg.selectAll(".nv-y.nv-axis text").style("fill",colors[0]);$scope.showHideFitTime=function(){let displayValue=$scope.uiState.showFitTime?"":"none";svg.selectAll("g.nv-lineChart g.nv-line g.nv-series-1").style("display",displayValue);let area=svg.select(".tubes").selectAll("path");if(area&&area.length>0){area[0][1].style.opacity=$scope.uiState.showFitTime?".3":"0"}svg.select("g.nv-lineChart g.secondary-axis").style("display",displayValue);svg.selectAll("g.nv-legendWrap g.nv-series:nth-child(2) .nv-legend-symbol").style("fill-opacity",$scope.uiState.showFitTime?"1":"0")};$scope.showHideFitTime();scope.chart.legend.updateState(false);scope.chart.legend.dispatch.on("legendClick.overload",function(d,index){if(index===1){$scope.$apply(function(){$scope.uiState.showFitTime=!$scope.uiState.showFitTime})}});if(indexOfBestScore>=0){const xMarkStrokeWidth=2;let xBestScore=x[indexOfBestScore];if(!xAreNumbers){xBestScore=x.indexOf(xBestScore)}let xTranslate=scope.chart.xScale()(xBestScore);if(indexOfBestScore===0){xTranslate+=xMarkStrokeWidth}let xMarkG=svg.select(".nv-lineChart").append("g").attr("class","x mark").attr("transform","translate("+xTranslate+", 0)");xMarkG.append("path").attr("d","M0,0 V"+scope.axisHeight).attr("stroke-width",xMarkStrokeWidth).attr("stroke",colors[2]).attr("stroke-dasharray","5,3")}if($scope.uiState.chartLogScale===null){scope.chart.interactiveLayer.tooltip.headerFormatter($scope.chart.format[0])}else{scope.chart.interactiveLayer.tooltip.headerFormatter($scope.chart.xNumericFormat)}svgAreaCallback(svg,scope);d3.selectAll(".nvtooltip").remove()};$scope.chart={format:format,x:x,colors:colors,scale:scale,scale2:scale2,svgCallback:svgCallback,xLabels:x,score:score.avg,fitTime:fitTime.avg};if(!xAreNumbers){$scope.uiState.chartLogScale=null}else{const min=Math.min(...x);const max=Math.max(...x);if(min==0){$scope.uiState.chartLogScale=max>10}else if(max==0){$scope.uiState.chartLogScale=min<-10}else{$scope.uiState.chartLogScale=Math.abs(max/min)>10}if(min<=.01||max>=100){$scope.chart.xNumericFormat=_=>MLChartsCommon.trimTrailingZeros(d3.format(".3e")(_))}else{$scope.chart.xNumericFormat=_=>MLChartsCommon.trimTrailingZeros(d3.format(".4g")(_))}}updateChartXScale($scope.uiState.chartLogScale)});$scope.$watch("uiState.showFitTime",function(){if($scope.showHideFitTime){$scope.showHideFitTime()}});function updateChartXScale(chartLogScale){let x=$scope.chart.x;if(chartLogScale===null){$scope.chart.xScale=d3.scale.linear().domain([-.1,x.length-.9]);$scope.chart.x=x.map((_,i)=>i);$scope.chart.xTicks=$scope.chart.x;$scope.chart.format[0]=function(xValue){if(xValue<0||xValue>x.length-1){return""}else{return $scope.chart.xLabels[xValue]}}}else{if(chartLogScale){$scope.chart.xScale=d3.scale.log();if(x[0]<=0){x=x.slice();x[0]=1e-23;$scope.chart.xScale.clamp(true)}$scope.chart.xTicks=false;$scope.chart.format[0]=function(xValue){if(xValue===x[0]||xValue===x[x.length-1]){return $scope.chart.xNumericFormat(xValue)}else{if(!["1","2","4"].includes(d3.format(".0e")(xValue)[0])){return""}return $scope.chart.xNumericFormat(xValue)}}}else{$scope.chart.xTicks=false;$scope.chart.xScale=d3.scale.linear();$scope.chart.format[0]=$scope.chart.xNumericFormat}$scope.chart.xScale.domain([x[0],x[x.length-1]])}}$scope.$watch("uiState.chartLogScale",updateChartXScale);$scope.exportGridSearchData=function(){if(!$scope.gridCells)return;ExportUtils.exportUIData($scope,{name:"Hyperparameter search data for model: "+$scope.modelData.userMeta.name,columns:$scope.paramColumns.map(_=>({name:_,type:"string"})).concat($scope.fieldList.map(_=>({name:_.name,type:"double"}))),data:$scope.gridData},"Export hyperparameter search data")};$scope.hasOptimizedNEstimators=()=>{const modelingParameters=$scope.mlTasksContext.model.modeling;const{algorithm}=modelingParameters;if(algorithm.startsWith("XGBOOST")){return modelingParameters.xgboost_grid.enable_early_stopping}if(algorithm==="LIGHTGBM_CLASSIFICATION"){return modelingParameters.lightgbm_classification_grid.early_stopping}if(algorithm==="LIGHTGBM_REGRESSION"){return modelingParameters.lightgbm_regression_grid.early_stopping}return false};function computeHyperparametersPairwiseDependencies(){const scoreIdx=$scope.paramColumns.length;const pairsIndices=[].concat(...$scope.paramColumns.map((_,idx)=>$scope.paramColumns.slice(idx+1).map((_,idx2)=>[idx,idx+1+idx2])));let dependencies=Array.from(pairsIndices,function(pairIndices){const[param1Idx,param2Idx]=pairIndices;const validGridData=filterInvalidScoresFromGridData();const scoresByXY=validGridData.reduce(function(acc,data){const[x,y,score]=[data[param1Idx],data[param2Idx],data[scoreIdx]];if(x!==""&&y!==""){let xyKey=JSON.stringify([x,y]);if(!(xyKey in acc)){acc[xyKey]=[]}acc[xyKey].push(score)}return acc},{});for(let xyPair in scoresByXY){scoresByXY[xyPair]=scoresByXY[xyPair].reduce((a,b)=>a+b,0)/scoresByXY[xyPair].length}const x=Object.keys(scoresByXY).map(_=>JSON.parse(_)[0]);const y=Object.keys(scoresByXY).map(_=>JSON.parse(_)[1]);const score=Object.values(scoresByXY);const xUnique=new Set(x);const yUnique=new Set(y);if(xUnique.size===1||yUnique.size===1){return{}}return{xLabel:$scope.paramColumns[param1Idx],yLabel:$scope.paramColumns[param2Idx],x:x,xCategorical:!x.every(_=>typeof _==="number"),y:y,yCategorical:!y.every(_=>typeof _==="number"),score:score}});dependencies=dependencies.filter(dependency=>!angular.equals(dependency,{}));return dependencies}function filterInvalidScoresFromGridData(){const scoreIdx=$scope.paramColumns.length;return $scope.gridData.filter(x=>x[scoreIdx]!=="")}});app.filter("modelImportantParamName",function(){const dict={depth:"Depth",min_samples:"Min samples",trees:"Trees",penalty:"Penalty",max_depth:"Max depth",criterion:"Split criterion",alpha:"Alpha",lambda:"Lambda",epsilon:"Epsilon",gamma:"Gamma",C:"C",kernel:"Kernel",loss:"Loss",k:"K",distance_weighting:"Distance weighting",layer_sizes:"Layer size",max_iters:"Max iterations",hidden_layers:"Hidden layers",activation:"Activation",dropout:"Dropout",l1:"L1",l2:"L2",strategy:"Strategy",smoothing:"Smoothing",learning_rate:"Learning rate",features:"Features",solver:"Solver",epochs:"Epochs",boosting_type:"Boosting type",n_estimators:"Nb. estimators",num_leaves:"Nb. leaves",units:"Units"};return function(input){if(input&&input in dict)return dict[input];return input}});app.controller("HyperparametersPairwiseDependenciesController",["$scope","MLChartsCommon",function($scope,MLChartsCommon){function groupByCategoryReducer(categories){let groupByCategory=function(acc,value,index){let category=categories[index];acc[category]=acc[category]||[];acc[category].push(value);return acc};return groupByCategory}function groupDependenciesByY(acc,dependency){if(acc.has(dependency.xLabel)&&!(!dependency.xCategorical&&dependency.yCategorical)||dependency.xCategorical&&!dependency.yCategorical){acc.set(dependency.xLabel,acc.get(dependency.xLabel)||[]);acc.get(dependency.xLabel).push({x:dependency.y,xLabel:dependency.yLabel,xCategorical:dependency.yCategorical,y:dependency.x,yLabel:dependency.xLabel,yCategorical:dependency.xCategorical,score:dependency.score})}else{acc.set(dependency.yLabel,acc.get(dependency.yLabel)||[]);acc.get(dependency.yLabel).push(dependency)}return acc}function setXScaleMultiline(x){let xScale,xNumericFormat,xScaleFormat,xTicks;const min=Math.min(...x);const max=Math.max(...x);xNumericFormat=MLChartsCommon.makeAxisNumericFormatter(min,max,3,1);const logScale=min>0&&max/min>10;if(logScale){xScale=d3.scale.log().domain([min,max]);xTicks=[];if(max/min>=1e5){for(let tickValue of xScale.ticks()){if(tickValue/10**Math.floor(Math.log10(tickValue))===1){xTicks.push(tickValue)}}xTicks=xTicks.filter((_,idx)=>{if(idx%Math.floor(xTicks.length/4)===0)return true})}else{xTicks=false}xScaleFormat=function(xValue){if(xValue===x[0]||xValue===x[x.length-1]){return xNumericFormat(xValue)}else{if(d3.format(".0e")(xValue)[0]!=="1"){return""}return xNumericFormat(xValue)}}}else{xTicks=false;xScale=d3.scale.linear().domain([min,max]);xScaleFormat=xNumericFormat}return{xScale:xScale,xScaleFormat:xScaleFormat,xTicks:xTicks}}$scope.$watch("pairwiseDependencies",pairwiseDependencies=>{let dependenciesByY=pairwiseDependencies.reduce(groupDependenciesByY,new Map);let columnLabelCounts={};let plotsDataByYDict={};for(const[yLabel,dependencies]of dependenciesByY){for(const dependency of dependencies){let plotData={};if(dependency.xCategorical&&dependency.yCategorical){plotData.plotType="CATEGORIES-HEATMAP";plotData.x=dependency.x;plotData.y=dependency.y;plotData.xLabel=dependency.xLabel;plotData.yLabel=dependency.yLabel;plotData.score=dependency.score}else if(dependency.xCategorical||dependency.yCategorical){plotData.plotType="MULTILINE";plotData.legend=[...new Set(dependency.y)];plotData.legendLabel=dependency.yLabel;plotData.colors=$scope.colors.slice(0,plotData.legend.length);const{xScale,xScaleFormat,xTicks}=setXScaleMultiline(dependency.x);plotData.xScale=xScale;plotData.xTicks=xTicks;const categories=dependency.y;plotData.x=Object.values(dependency.x.reduce(groupByCategoryReducer(categories),{}));plotData.xLabel=dependency.xLabel;plotData.score=Object.values(dependency.score.reduce(groupByCategoryReducer(categories),{}));plotData.x.forEach(function(_,idx){let combinedArray=[];for(let j=0;j<plotData.x[idx].length;j++){combinedArray.push({x:plotData.x[idx][j],score:plotData.score[idx][j]})}combinedArray.sort(function(a,b){return a.x<b.x?-1:a.x==b.x?0:1});for(let k=0;k<combinedArray.length;k++){plotData.x[idx][k]=combinedArray[k].x;plotData.score[idx][k]=combinedArray[k].score}});let minScore=Math.min(...dependency.score);let maxScore=Math.max(...dependency.score);plotData.scale=function(){if(minScore>=0&&maxScore<=1){if(maxScore-minScore>=.2){return[0,1]}else{const factor=Math.abs(maxScore-minScore)*.1;const furtherMax=maxScore>0?maxScore+factor:maxScore-factor;const furtherMin=minScore>0?minScore-factor:minScore+factor;return[Math.max(0,furtherMin),Math.min(1,furtherMax)]}}else{const furtherMax=maxScore>0?maxScore*1.05:maxScore*.95;const furtherMin=minScore>0?minScore*.95:minScore*1.05;return[furtherMin,furtherMax]}}();let yScaleFormat=MLChartsCommon.makeAxisNumericFormatter(minScore,maxScore,3,1);plotData.format=[xScaleFormat,yScaleFormat];plotData.svgCallback=function(svg,scope){scope.chart.yAxis.axisLabelDistance(-15);scope.chart.interpolate(gaussianSmooth);let tooltipNumericFormat=MLChartsCommon.makeTooltipNumericFormatter(3,4);scope.chart.tooltip.contentGenerator(function(d){return`
                                <table class="mlchart-tooltip__table">
                                    <tr>
                                        <td class="mlchart-tooltip__label">Score ${$scope.uiState.scoreMetric}</td>
                                        <td class="mlchart-tooltip__value">${tooltipNumericFormat(d.series[0].value)}</td>
                                    </tr>
                                    <tr>
                                        <td class="mlchart-tooltip__label">${plotData.xLabel}</td>
                                        <td class="mlchart-tooltip__value">${tooltipNumericFormat(d.value)}</td>
                                    </tr>
                                    <tr>
                                        <td class="mlchart-tooltip__label">${plotData.legendLabel}</td>
                                        <td class="mlchart-tooltip__value">${d.series[0].key}</td>
                                    </tr>
                                </table>`});svg.datum(scope.theData).call(scope.chart)}}else{plotData.plotType="CONTOUR";plotData.x=dependency.x;plotData.y=dependency.y;plotData.xLabel=dependency.xLabel;plotData.yLabel=dependency.yLabel;plotData.score=dependency.score}columnLabelCounts[plotData.xLabel]=(columnLabelCounts[plotData.xLabel]||0)+1;plotsDataByYDict[yLabel]=plotsDataByYDict[yLabel]||[];plotsDataByYDict[yLabel].push(plotData)}}$scope.orderedColumns=Object.keys(columnLabelCounts).sort((a,b)=>-columnLabelCounts[a]+columnLabelCounts[b]);$scope.plotsDataByY=Object.entries(plotsDataByYDict).sort((a,b)=>-a[1].length+b[1].length).map(([yLabel,plotsData])=>{const newPlotsData=$scope.orderedColumns.map(xLabel=>{let plotsWithXLabel=plotsData.filter(plotData=>{return plotData.xLabel===xLabel});return plotsWithXLabel.length?plotsWithXLabel[0]:{plotType:"EMPTY"}});return[yLabel,newPlotsData]});$scope.maxRowLength=Math.max(...$scope.plotsDataByY.map(_=>_[1].length));$scope.plotWidth=Math.max(Math.min(Math.floor(900/$scope.maxRowLength),350),250)});function gaussianSmooth(points){let gaussian=function(a,b,bandwidth){return Math.exp(-Math.pow(a-b,2)/(2*bandwidth*bandwidth))};if(points.length<=2){return points.join("L")}const x=points.map(_=>_[0]);const bandwidth=(Math.max(...x)-Math.min(...x))/Math.min(points.length,7);return MLChartsCommon.linspace(Math.min(...x),Math.max(...x),50).map(function(xValue){var numerator=d3.sum(points,point=>gaussian(point[0],xValue,bandwidth)*point[1]);var denominator=d3.sum(points,point=>gaussian(point[0],xValue,bandwidth));return[xValue,numerator/denominator]}).join("L")}}]);app.component("reportPaneTitleBar",{restrict:"E",transclude:true,template:`
        <div class="model-report-title" ng-if="showTitle()" ng-class="{'mbot0': noBottomMargin}">
            <h2 class="model-report-title__tab-name">{{ $ctrl.paneTitle }}</h2>
            <post-train-weights-explanation sample-weight-variable="$ctrl.sampleWeightVariable"/>
            <post-train-inverse-propensity-weights-explanation ng-if="$ctrl.isInversePropensityWeighted"/>
            <div class="model-report-title__content" ng-transclude></div>
        </div>`,bindings:{paneTitle:"@",sampleWeightVariable:"<",isInversePropensityWeighted:"<"},controller:function($scope,$attrs,$transclude,$stateParams){this.$onInit=()=>{$transclude(content=>$scope.hasTranscluded=!!content.length);$scope.showTitle=()=>$scope.hasTranscluded||this.sampleWeightVariable!==undefined||this.isInversePropensityWeighted||!$stateParams.dashboardId;$scope.noBottomMargin=$attrs.noBottomMargin!==undefined}}});app.component("postTrainWeightsExplanation",{template:`
        <span ng-if="$ctrl.sampleWeightVariable !== undefined"
              class="post-train-weights-explanation"
              toggle="tooltip-bottom"
              container="body"
              title="Metrics and aggregates (averages, quantiles etc.) are computed with the variable '{{$ctrl.sampleWeightVariable}}' as sample weight, unless explicitly stated otherwise.">
            <i class="post-train-weights-explanation__icon icon-dku-weight"></i>
            <span class="post-train-weights-explanation__text">{{$ctrl.sampleWeightVariable}}</span>
        </span>`,bindings:{sampleWeightVariable:"<"}});app.component("postTrainInversePropensityWeightsExplanation",{template:`
        <span
              class="post-train-weights-explanation"
              toggle="tooltip-bottom"
              container="body"
              title="Metrics and aggregates (averages, quantiles etc.) are computed with inverse propensity weights.">
            <i class="post-train-weights-explanation__icon icon-dku-weight"></i>
            <span class="post-train-weights-explanation__text">Inverse Propensity Weighting</span>
        </span>`})})();(function(){"use strict";const app=angular.module("dataiku.ml.explainability",[]);app.constant("epochShift",2208988800);app.component("explanationParams",{bindings:{params:"=",onParamsChange:"&"},templateUrl:"/templates/ml/prediction-model/explanation-params-form.html",controller:function($scope){const $ctrl=this;$ctrl.localParams={};$ctrl.applyChanges=()=>{angular.copy($ctrl.localParams,$ctrl.params);$ctrl.onParamsChange&&$ctrl.onParamsChange()};$ctrl.resetParams=()=>{angular.copy($ctrl.params,$ctrl.localParams)};$scope.$watch("$ctrl.params",$ctrl.resetParams)}});app.component("computationParams",{bindings:{params:"=",hideNbJobs:"<",sampleSizeLabel:"<",sampleSizeHelp:"<",lastRandomState:"<",lastSampleSize:"<"},templateUrl:"/templates/ml/prediction-model/computation-params-form.html",controller:function($scope){const $ctrl=this;$ctrl.localParams={};$ctrl.$onInit=()=>{$ctrl.sampleSizeLabel=$ctrl.sampleSizeLabel||"Sample size";$ctrl.sampleSizeHelp=$ctrl.sampleSizeHelp||"Number of records of the dataset to use for the computation"};$ctrl.applyChanges=()=>{angular.copy($ctrl.localParams,$ctrl.params)};$ctrl.resetParams=()=>{angular.copy($ctrl.params,$ctrl.localParams)};$scope.$watch("$ctrl.params",$ctrl.resetParams)}})})();(function(){"use strict";const app=angular.module("dataiku.ml.explainability");app.service("OverridesExtraColumnsService",function(ModelDataUtils,MLTaskDesignUtils){function _getExtraColumns(isBinaryClassification,isClassification,uncertaintySettings){let extraColumns=[];if(!isBinaryClassification){extraColumns.push({name:"prediction",type:isClassification?"string":"double"})}if(isClassification){extraColumns.push({name:"prediction_uncertainty",type:"double"})}if(uncertaintySettings&&uncertaintySettings.predictionIntervalsEnabled){extraColumns=extraColumns.concat([{name:"prediction_interval_size",type:"double"},{name:"prediction_interval_relative_size",type:"double"},{name:"prediction_interval_lower",type:"double"},{name:"prediction_interval_upper",type:"double"}])}return extraColumns}function getExtraColumnsFromModelData(modelData){return _getExtraColumns(ModelDataUtils.isBinaryClassification(modelData),ModelDataUtils.isClassification(modelData),ModelDataUtils.getUncertaintySettings(modelData))}function getExtraColumnsFromMLTaskDesign(mltaskDesign){return _getExtraColumns(MLTaskDesignUtils.isBinaryClassification(mltaskDesign),MLTaskDesignUtils.isClassification(mltaskDesign),MLTaskDesignUtils.getUncertaintySettings(mltaskDesign))}return{getExtraColumnsFromModelData:getExtraColumnsFromModelData,getExtraColumnsFromMLTaskDesign:getExtraColumnsFromMLTaskDesign}});app.constant("OverridesMetricsView",{SANKEY:"SANKEY",TABLE:"TABLE"});app.controller("OverridesMetricsController",function($scope,$stateParams,OverridesMetricsView,ModelDataUtils){$scope.OverridesMetricsView=OverridesMetricsView;$scope.ModelDataUtils=ModelDataUtils;$scope.activeView=OverridesMetricsView.SANKEY;$scope.inDashboard=$stateParams.dashboardId||$stateParams.insightId});app.component("overridesMetricsViewSelector",{bindings:{activeView:"="},templateUrl:"/templates/ml/prediction-model/overrides/metrics_view_selector.html",controller:function($scope,OverridesMetricsView){$scope.OverridesMetricsView=OverridesMetricsView}});app.service("OverridesMetricsService",function(BinaryClassificationModelsService,ModelDataUtils){return{getNbTotalRows:(modelData,evaluation)=>{if(evaluation){return evaluation.nbEvaluationRows}else if(modelData.trainInfo.fullRows){return modelData.trainInfo.fullRows}return modelData.trainInfo.testRows},getOverridesMetrics:modelData=>{if(ModelDataUtils.isBinaryClassification(modelData)){let currentCutData=BinaryClassificationModelsService.findCutData(modelData.perf,modelData.userMeta["activeClassifierThreshold"]);if(currentCutData!==undefined&&modelData.perf.perCutData.overridesMetrics){return modelData.perf.perCutData.overridesMetrics[currentCutData.index].perOverride}}else{return modelData.perf.metrics&&modelData.perf.metrics.overridesMetrics.perOverride}}}});app.component("overridesMetricsSankey",{bindings:{modelData:"<",evaluation:"<"},templateUrl:"/templates/ml/prediction-model/overrides/metrics_sankey.html",controller:function($scope,$filter,OverridesMetricsService,ModelDataUtils){const $ctrl=this;function getOverridesMetrics(){return OverridesMetricsService.getOverridesMetrics($ctrl.modelData)}function getNiceOverrideDescription(overrideIndex){const override=$ctrl.modelData.overridesParams.overrides[overrideIndex];const name=$filter("escapeHtml")(override.name);return`'${name}': `+'<code class="overrides-metrics__tooltip-code">'+$filter("stripHtml")($filter("filterNiceRepr")(override.filter))+"</code>"}function getChartStyle(){const nbOverrides=getOverridesMetrics().length;return{height:`${250+5*nbOverrides}px`,minWidth:`${150+180*nbOverrides}px`}}function getChartOptions(){const BASE_OPTIONS={type:"sankey",orient:"horizontal",draggable:false,nodeAlign:"left",label:{position:"left"},layoutIterations:0,nodeGap:16,top:16,right:16,bottom:16,left:16};const MATCHING_COLOR="#76B8FD";const NOT_MATCHING_COLOR="#BBBBBB";const OVERRIDE_COLOR="#2D86FB";const KEPT_COLOR="#666666";const MATCHING_NODE_PARAMS={itemStyle:{color:MATCHING_COLOR},label:{show:true}};const NOT_MATCHING_NODE_PARAMS={itemStyle:{color:NOT_MATCHING_COLOR},label:{show:false,formatter:""}};const LAST_NOT_MATCHING_NODE_PARAMS={itemStyle:{color:NOT_MATCHING_COLOR},label:{show:true}};const OVERRIDDEN_NODE_PARAMS={itemStyle:{color:OVERRIDE_COLOR},label:{formatter:"Overridden"}};const KEPT_NODE_PARAMS={itemStyle:{color:KEPT_COLOR},label:{formatter:"Kept"}};const ORIGINAL_PREDICTIONS_NODE_PARAMS={itemStyle:{color:NOT_MATCHING_COLOR},label:{show:true,rotate:90,position:"inside",align:"middle"}};const MATCHING_LINK_PARAMS={lineStyle:{opacity:.5,color:MATCHING_COLOR}};const NOT_MATCHING_LINK_PARAMS={lineStyle:{opacity:.5,color:NOT_MATCHING_COLOR}};const OVERRIDDEN_LINK_PARAMS={lineStyle:{opacity:.5,color:OVERRIDE_COLOR}};const KEPT_LINK_PARAMS={lineStyle:{opacity:.3,color:KEPT_COLOR}};const ORIGINAL_PREDICTIONS_NODE_NAME="Original predictions";const NOT_MATCHING_ANY_NODE_NAME="Didn't match any override";const getNotMatchingNodeName=index=>`Didn't match override #${index}`;const getMatchingNodeName=index=>`Matched override #${index}`;const getKeptNodeName=index=>`Kept by #${index}`;const getOverriddenNodeName=index=>`Overridden by #${index}`;const getMatchingTooltip=(value,index)=>`<strong>${value}</strong> rows <strong>matched</strong> ${getNiceOverrideDescription(index)}`;const getNotMatchingAnyTooltip=value=>`<strong>${value}</strong> rows <strong>didn't match</strong> any overrides`;const getKeptTooltip=(value,index)=>`<strong>${value}</strong> rows had the right prediction before matching ${getNiceOverrideDescription(index)}`;const getOverriddenTooltip=(value,index)=>`<strong>${value}</strong> rows were <strong>overridden</strong> by ${getNiceOverrideDescription(index)}`;const getNotMatchingTooltip=(value,index,previousValue)=>{const tooltipContent=`<strong>${value}</strong> rows <strong>didn't match</strong> ${getNiceOverrideDescription(index)}`;if(index>0){return`Out of the ${previousValue} rows that didn't match any prior overrides, `+tooltipContent}return tooltipContent};const overrides=getOverridesMetrics();const nodes=[];const links=[];nodes.push({name:ORIGINAL_PREDICTIONS_NODE_NAME,...ORIGINAL_PREDICTIONS_NODE_PARAMS});let remainingRows=OverridesMetricsService.getNbTotalRows($ctrl.modelData,$ctrl.evaluation);for(let i=0;i<overrides.length;i++){const isFirstOverride=i===0;const override=overrides[i];const source=isFirstOverride?ORIGINAL_PREDICTIONS_NODE_NAME:getNotMatchingNodeName(i);remainingRows-=override.nbMatchingRows;if(remainingRows>0){const target=getNotMatchingNodeName(i+1);const value=remainingRows;const tooltipContent=getNotMatchingTooltip(value,i,remainingRows+override.nbMatchingRows);nodes.push({name:target,tooltipContent:tooltipContent,...NOT_MATCHING_NODE_PARAMS});links.push({value:value,target:target,source:source,tooltipContent:tooltipContent,...NOT_MATCHING_LINK_PARAMS})}if(override.nbMatchingRows>0){const target=getMatchingNodeName(i+1);const value=override.nbMatchingRows;const tooltipContent=getMatchingTooltip(value,i);nodes.push({name:target,tooltipContent:tooltipContent,...MATCHING_NODE_PARAMS});links.push({value:value,source:source,target:target,tooltipContent:tooltipContent,...MATCHING_LINK_PARAMS})}}if(remainingRows>0){const source=getNotMatchingNodeName(overrides.length);const target=NOT_MATCHING_ANY_NODE_NAME;const value=remainingRows;const tooltipContent=getNotMatchingAnyTooltip(value);nodes.push({name:target,tooltipContent:tooltipContent,...LAST_NOT_MATCHING_NODE_PARAMS});links.push({value:value,target:target,source:source,tooltipContent:tooltipContent,...NOT_MATCHING_LINK_PARAMS})}for(let i=0;i<overrides.length;i++){const override=overrides[i];const source=getMatchingNodeName(i+1);if(override.nbMatchingRows-override.nbChangedRows>0){const target=getKeptNodeName(i+1);const value=override.nbMatchingRows-override.nbChangedRows;const tooltipContent=getKeptTooltip(value,i);nodes.push({name:target,tooltipContent:tooltipContent,...KEPT_NODE_PARAMS});links.push({value:value,source:source,target:target,tooltipContent:tooltipContent,...KEPT_LINK_PARAMS})}if(override.nbChangedRows>0){const target=getOverriddenNodeName(i+1);const value=override.nbChangedRows;const tooltipContent=getOverriddenTooltip(value,i);nodes.push({name:target,tooltipContent:tooltipContent,...OVERRIDDEN_NODE_PARAMS});links.push({value:value,source:source,target:target,tooltipContent:tooltipContent,...OVERRIDDEN_LINK_PARAMS})}}return{series:[{nodes:nodes,links:links,...BASE_OPTIONS}]}}const updateOptions=()=>{$scope.options=getChartOptions();$scope.chartStyle=getChartStyle()};$ctrl.onChartInit=chartHandle=>{chartHandle.on("mousemove",params=>{if(!params.data.tooltipContent){return}$scope.showTooltip=true;$scope.content=params.data.tooltipContent;const container=angular.element(".overrides-metrics__sankey-container");const tooltip=angular.element(".overrides-metrics__tooltip");const totalScrollFromTop=container.parents().toArray().reduce((total,e)=>total+$(e).scrollTop(),0);const contentY=params.event.offsetY-totalScrollFromTop;let contentX=params.event.offsetX-container.scrollLeft()-tooltip.outerWidth()/2;const overflowRight=contentX+tooltip.outerWidth()-container.width();const overflowLeft=-contentX;if(overflowRight>0){contentX-=overflowRight}else if(overflowLeft>0){contentX+=overflowLeft}$scope.contentX=contentX;$scope.contentY=contentY;$scope.arrowX=params.event.offsetX-container.scrollLeft();$scope.$apply()});chartHandle.on("mouseout",()=>{$scope.showTooltip=false;$scope.$apply()})};$ctrl.$onInit=()=>{if(ModelDataUtils.isBinaryClassification($ctrl.modelData)){const thresholdUpdateChecker=ModelDataUtils.createThresholdUpdateChecker();$ctrl.$doCheck=()=>thresholdUpdateChecker.executeIfUpdated($ctrl.modelData,updateOptions)}updateOptions()}}});app.component("overridesMetricsTable",{bindings:{modelData:"<",evaluation:"<"},templateUrl:"/templates/ml/prediction-model/overrides/metrics_table.html",controller:function($scope,OverridesMetricsService,ModelDataUtils){const $ctrl=this;const ALREADY_MATCHED_COLOR="#666666";const MATCHING_COLOR="#76B8FD";const NOT_MATCHING_COLOR="#BBBBBB";const OUTCOME_CHANGED_COLOR="#2D86FB";const OUTCOME_KEPT_COLOR="#BBBBBB";$scope.matchStatusRegions={};$scope.matchedRegions={};$scope.outcomeStatusRegions={};$scope.anyMatch={};function updateRegions(){const overridesMetrics=OverridesMetricsService.getOverridesMetrics($ctrl.modelData);const nbTotalRows=OverridesMetricsService.getNbTotalRows($ctrl.modelData,$ctrl.evaluation);$scope.overridesResult={};let nbAlreadyMatchedRows=0;for(const overrideMetrics of overridesMetrics){const name=overrideMetrics.name;const nbMatchingRows=overrideMetrics.nbMatchingRows;const nbChangedRows=overrideMetrics.nbChangedRows;const nbNonMatchingRows=nbTotalRows-nbMatchingRows-nbAlreadyMatchedRows;const nbKeptRows=nbMatchingRows-nbChangedRows;$scope.anyMatch[name]=nbMatchingRows>0;$scope.matchStatusRegions[name]=[{size:nbAlreadyMatchedRows,color:ALREADY_MATCHED_COLOR},{size:nbMatchingRows,color:MATCHING_COLOR},{size:nbNonMatchingRows,color:NOT_MATCHING_COLOR}];$scope.matchedRegions[name]=[{size:nbMatchingRows,color:MATCHING_COLOR}];$scope.outcomeStatusRegions[name]=[{size:nbChangedRows,color:OUTCOME_CHANGED_COLOR},{size:nbKeptRows,color:OUTCOME_KEPT_COLOR}];nbAlreadyMatchedRows+=nbMatchingRows}}$ctrl.$onInit=()=>{$ctrl.hasOverrides=ModelDataUtils.hasOverrides($ctrl.modelData);if(ModelDataUtils.isBinaryClassification($ctrl.modelData)){const thresholdUpdateChecker=ModelDataUtils.createThresholdUpdateChecker();$ctrl.$doCheck=()=>thresholdUpdateChecker.executeIfUpdated($ctrl.modelData,updateRegions)}updateRegions()}}});app.component("overridesCreateNewModel",{bindings:{modelData:"<"},template:`
    <saved-model-overrides-create-new-model ng-if="$ctrl.isSavedModel"
                                            fmi="$ctrl.fmi"
                                            model-data="$ctrl.modelData">
    </saved-model-overrides-create-new-model>
    <analysis-overrides-create-new-model ng-if="$ctrl.isAnalysis"
                                         fmi="$ctrl.fmi"
                                         model-data="$ctrl.modelData">
    </analysis-overrides-create-new-model>`,controller:function(FullModelLikeIdUtils){const $ctrl=this;$ctrl.$onInit=function(){$ctrl.fmi=$ctrl.modelData.fullModelId;$ctrl.isAnalysis=FullModelLikeIdUtils.isAnalysis($ctrl.fmi);$ctrl.isSavedModel=FullModelLikeIdUtils.isSavedModel($ctrl.fmi)}}});app.component("savedModelOverridesCreateNewModel",{bindings:{modelData:"<",fmi:"<"},template:`
    <overrides-create-new-model-button model-data="$ctrl.modelData"
                                       fmi="$ctrl.fmi"
                                       on-model-creation-callback="$ctrl.onModelCreationCallback"
                                       modal-title="$ctrl.modalTitle"
                                       modal-description="A new model version will be created to apply the newly defined overrides. The existing model version will remain available.">
    </overrides-create-new-model-button>
`,controller:function($scope,$state,DataikuAPI,FutureProgressModal,ModelDataUtils){const $ctrl=this;$ctrl.$onInit=()=>{$ctrl.modalTitle=`Create new version with ${ModelDataUtils.hasOverrides($ctrl.modelData)?"different overrides":"newly defined overrides"}`};$ctrl.onModelCreationCallback=function(newModelName,newOverridesParams,dismissModalCallback){DataikuAPI.savedmodels.prediction.createModelVersionWithDifferentOverrides($ctrl.fmi,newModelName,newOverridesParams).success(function(data){const hasOverrides=ModelDataUtils.hasOverrides($ctrl.modelData);const progressModalTitle=hasOverrides?"Creating new version with different overrides":"Creating new version with overrides";FutureProgressModal.show($scope.$new(),data,progressModalTitle).then(function(newFmi){if(newFmi){dismissModalCallback();$state.go("projects.project.savedmodels.savedmodel.prediction.report",{fullModelId:newFmi})}}).catch(setErrorInScope.bind($scope))}).error(setErrorInScope.bind($scope))}}});app.component("analysisOverridesCreateNewModel",{bindings:{modelData:"<",fmi:"<"},template:`
  <overrides-create-new-model-button model-data="$ctrl.modelData"
                                     fmi="$ctrl.fmi"
                                     create-disabled-message="$ctrl.createDisabledMessage"
                                     on-model-creation-callback="$ctrl.onModelCreationCallback" 
                                     modal-title="$ctrl.modalTitle"
                                     modal-description="A new modeling session will be created to apply the newly defined overrides. The existing model will remain available in the existing session.">
  </overrides-create-new-model-button>
`,controller:function($scope,$state,$stateParams,$interval,DataikuAPI,ModelDataUtils){const $ctrl=this;function pollTaskStatus(){DataikuAPI.analysis.pml.getLightTaskStatus($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId).success(function(data){$ctrl.isTaskWorking=data&&(data.guessing||data.training)}).error(setErrorInScope.bind($scope))}let cancelPoll;function startPoll(){cancelPoll=$interval(pollTaskStatus,5e3)}$ctrl.onModelCreationCallback=function(newModelName,newOverridesParams,dismissModalCallback){DataikuAPI.analysis.pml.createNewModelWithDifferentOverrides($ctrl.fmi,newModelName,newOverridesParams).success(function(){dismissModalCallback();$state.go("projects.project.analyses.analysis.ml.predmltask.list.results.sessions")}).error(setErrorInScope.bind($scope))};$ctrl.createDisabledMessage=function(){if($ctrl.isTaskWorking){return"Cannot create a new model during an ongoing training."}return null};$ctrl.$onInit=function(){$ctrl.isTaskWorking=false;$ctrl.modalTitle=`Create new model with ${ModelDataUtils.hasOverrides($ctrl.modelData)?"different":"newly defined"} overrides`;startPoll()};$ctrl.$onDestroy=function(){$interval.cancel(cancelPoll)}}});app.component("overridesCreateNewModelButton",{bindings:{fmi:"<",modelData:"<",onModelCreationCallback:"<",modalTitle:"<",modalDescription:"@",createDisabledMessage:"<?"},templateUrl:"/templates/ml/prediction-model/overrides/create_new_model.html",controller:function($scope,CreateModalFromTemplate,DataikuAPI,MlParamsWithFilterService,ModelDataUtils,OverridesExtraColumnsService){const $ctrl=this;function getAuthorizedColumnsForOverrides(){const authorizedColumnsSchema=angular.copy($ctrl.modelData.splitDesc.schema);authorizedColumnsSchema.columns.splice(authorizedColumnsSchema.columns.map(column=>column.name).indexOf($ctrl.modelData.coreParams.target_variable),1);MlParamsWithFilterService.enrichPostScriptSchemaWithExtraColumns(authorizedColumnsSchema,OverridesExtraColumnsService.getExtraColumnsFromModelData($ctrl.modelData));return authorizedColumnsSchema}function getSuggestedNameForNewVersion(currentName){const regexMatch=currentName.match(/(?<baseName>.*) - new Overrides( \((?<nbDuplicates>\d+)\))?$/);if(!regexMatch){return currentName+" - new Overrides"}const baseName=regexMatch.groups.baseName;const nbDuplicates=regexMatch.groups.nbDuplicates?Number(regexMatch.groups.nbDuplicates)+1:2;return`${baseName} - new Overrides (${nbDuplicates})`}$ctrl.$onInit=()=>{$ctrl.hasOverrides=ModelDataUtils.hasOverrides($ctrl.modelData)};$ctrl.openCreateNewModelModal=function(){CreateModalFromTemplate("/templates/ml/prediction-model/overrides/new_model_modal.html",$scope,null,function(newScope){newScope.newOverridesParams=$ctrl.modelData.overridesParams?angular.copy($ctrl.modelData.overridesParams):{overrides:[]};newScope.overridesChanged=()=>!angular.equals($ctrl.modelData.overridesParams,newScope.newOverridesParams);newScope.isClassification=ModelDataUtils.isClassification($ctrl.modelData);newScope.newModelName=getSuggestedNameForNewVersion($ctrl.modelData.userMeta.name);newScope.postScriptFeaturesSchema=getAuthorizedColumnsForOverrides();newScope.classes=$ctrl.modelData.classes;newScope.confirm=function(){$ctrl.onModelCreationCallback(newScope.newModelName,newScope.newOverridesParams,()=>newScope.dismiss())};newScope.cancel=function(){newScope.dismiss()};const targetColumnAnalysisCallback=()=>DataikuAPI.analysis.predicted.detailedColumnAnalysis($ctrl.fmi,$ctrl.modelData.trainedWithScript,$ctrl.modelData.coreParams.target_variable,50);newScope.addNewMlOverride=MlParamsWithFilterService.createAddNewOverrideParamCallback(newScope.newOverridesParams.overrides,ModelDataUtils.isClassification($ctrl.modelData),targetColumnAnalysisCallback,$ctrl.modelData.classes)})}}});app.component("overriddenBadgeBase",{template:`
        <span ng-if="$ctrl.shouldDisplay"
              class="overridden-prediction-badge cursor-pointer"
              dku-inline-popover
              placement="bottom"
              container="body">
            <label>
                <i class="overridden-prediction-badge__icon icon-dku-override {{ !$ctrl.iconOnly ? 'mleft4' : '' }}"></i>
                <span class="overridden-prediction-badge__text" ng-show="!$ctrl.iconOnly">{{ $ctrl.textInBadge }}</span>
            </label>
            <content>
                <ng-transclude ng-show="!$ctrl.hideTranscludedContent"></ng-transclude>
                <hr ng-show="!$ctrl.hideTranscludedContent" class="mtop8 mbot8">
                Applied rule: <strong>{{ getAppliedOverride().name }}</strong>
                <code class="overrides-metrics__tooltip-code">{{ getAppliedOverride().filter | filterNiceRepr | stripHtml }}</code>
            </content>
        </span>
        <span ng-if="!$ctrl.shouldDisplay" class="overridden-prediction-badge-placeholder"></span>
    `,bindings:{modelData:"<",overrideInfo:"<",textInBadge:"<?",shouldDisplay:"<",iconOnly:"=?",hideTranscludedContent:"<?"},restrict:"E",transclude:true,controller:function($scope,ModelDataUtils,WhatIfFormattingService){const $ctrl=this;$scope.ModelDataUtils=ModelDataUtils;$scope.WhatIfFormattingService=WhatIfFormattingService;$scope.getAppliedOverride=()=>$ctrl.modelData.overridesParams.overrides.find(e=>$ctrl.overrideInfo&&$ctrl.overrideInfo.appliedRule===e.name)}});app.component("overriddenPredictionBadge",{template:`
        <overridden-badge-base ng-if="ModelDataUtils.isMulticlass($ctrl.modelData)"
                               model-data="$ctrl.modelData"
                               override-info="$ctrl.overrideInfo"
                               text-in-badge="'was ' + getFormattedPredictionForMulticlass() + ' before override'"
                               should-display="$ctrl.overrideInfo.ruleMatched && ($ctrl.overrideInfo.predictionChanged || !$ctrl.iconOnly)"
                               icon-only="$ctrl.iconOnly">
            Before overrides:
            <ul>
                <li ng-repeat="clazz in $ctrl.modelData.classes">{{ clazz }}: <span class="interactive-scoring__prediction">{{ WhatIfFormattingService.formatProba($ctrl.overrideInfo.rawResult.probabilities[clazz]) }}%</span></li>
            </ul>
        </overridden-badge-base>
        <overridden-badge-base ng-if="ModelDataUtils.isBinaryClassification($ctrl.modelData)"
                               model-data="$ctrl.modelData"
                               override-info="$ctrl.overrideInfo"
                               text-in-badge="'was &lsquo;' + WhatIfFormattingService.formatPrediction($ctrl.modelData, $ctrl.overrideInfo.rawResult.prediction) + '&rsquo; before override'"
                               should-display="$ctrl.overrideInfo.ruleMatched && $ctrl.overrideInfo.predictionChanged"
                               icon-only="$ctrl.iconOnly"
                               hide-transcluded-content="!$ctrl.iconOnly">
            ...was <span class="interactive-scoring__prediction">'{{ WhatIfFormattingService.formatPrediction($ctrl.modelData, $ctrl.overrideInfo.rawResult.prediction) }}'</span> before overrides
        </overridden-badge-base>
        <overridden-badge-base ng-if="ModelDataUtils.isRegression($ctrl.modelData)"
                               model-data="$ctrl.modelData"
                               override-info="$ctrl.overrideInfo"
                               text-in-badge="'was ' + WhatIfFormattingService.formatPrediction($ctrl.modelData, $ctrl.overrideInfo.rawResult.prediction) + ' before override'"
                               should-display="$ctrl.overrideInfo.ruleMatched && $ctrl.overrideInfo.predictionChanged"
                               icon-only="$ctrl.iconOnly"
                               hide-transcluded-content="!$ctrl.iconOnly">
            ...was <span class="interactive-scoring__prediction">{{ WhatIfFormattingService.formatPrediction($ctrl.modelData, $ctrl.overrideInfo.rawResult.prediction) }}</span> before overrides
        </overridden-badge-base>
    `,bindings:{overrideInfo:"<",modelData:"<",iconOnly:"=?"},controller:function($scope,WhatIfFormattingService,ModelDataUtils){const $ctrl=this;$scope.ModelDataUtils=ModelDataUtils;$scope.WhatIfFormattingService=WhatIfFormattingService;$scope.getFormattedPredictionForMulticlass=()=>{if(!$ctrl.overrideInfo||!$ctrl.overrideInfo.rawResult){return}const proba=WhatIfFormattingService.formatProba($ctrl.overrideInfo.rawResult.probabilities[$ctrl.overrideInfo.rawResult.prediction])+"%";if($ctrl.overrideInfo.predictionChanged){return`'${WhatIfFormattingService.formatPrediction($ctrl.modelData,$ctrl.overrideInfo.rawResult.prediction)}' — ${proba}`}return proba}}});app.component("overriddenProbaBadge",{template:`
        <overridden-badge-base ng-if="ModelDataUtils.isMulticlass($ctrl.modelData)"
                               model-data="$ctrl.modelData"
                               override-info="$ctrl.overrideInfo"
                               should-display="$ctrl.overrideInfo.ruleMatched"
                               icon-only="$ctrl.iconOnly">
            Before overrides:
            <ul>
                <li ng-repeat="clazz in $ctrl.modelData.classes">{{ clazz }}: <span class="interactive-scoring__prediction">{{ WhatIfFormattingService.formatProba($ctrl.overrideInfo.rawResult.probabilities[clazz]) }}%</span></li>
            </ul>
        </overridden-badge-base>
        <overridden-badge-base ng-if="ModelDataUtils.isBinaryClassification($ctrl.modelData)"
                               model-data="$ctrl.modelData"
                               override-info="$ctrl.overrideInfo"
                               text-in-badge="'was ' + WhatIfFormattingService.formatProba($ctrl.overrideInfo.rawResult.probabilities[$ctrl.modelData.classes[1]]) + '% before override'"
                               should-display="$ctrl.overrideInfo.ruleMatched"
                               icon-only="$ctrl.iconOnly"
                               hide-transcluded-content="!$ctrl.iconOnly">
            ...was <span class="interactive-scoring__prediction">{{ WhatIfFormattingService.formatProba($ctrl.overrideInfo.rawResult.probabilities[$ctrl.modelData.classes[1]]) }}%</span> before overrides
        </overridden-badge-base>
    `,bindings:{overrideInfo:"<",modelData:"<",iconOnly:"=?"},controller:function($scope,ModelDataUtils,WhatIfFormattingService){$scope.ModelDataUtils=ModelDataUtils;$scope.WhatIfFormattingService=WhatIfFormattingService}})})();(function(){"use strict";var app=angular.module("dataiku.ml.explainability");app.controller("PdpPlotController",function($scope,DataikuAPI,$stateParams,FutureProgressModal,WT1,ActiveProjectKey,epochShift,ExportUtils,FullModelLikeIdUtils){function preparePartialDependence(scope){const distributionColor="#D5D9D9";const pdData=scope.modelData.iperf.partialDependencies;scope.data={};scope.heights={};scope.distributions={};scope.computedPostTraining={};scope.isDate={};scope.nbRecords={};scope.nbPoints={};scope.onSample={};let classes=scope.modelData.classes;if(scope.isBinaryClassification()){classes=[scope.modelData.classes[1]]}const nbOfClasses=classes?classes.length:1;(pdData||[]).forEach(function(pd){scope.computedPostTraining[pd.feature]=pd.computedPostTraining;scope.nbRecords[pd.feature]=pd.nbRecords;scope.onSample[pd.feature]=pd.onSample;if(pd.featureBins){if(pd.isDate){pd.featureBins=pd.featureBins.map(d=>new Date(d-epochShift)*1e3)}scope.nbPoints[pd.feature]=pd.featureBins.length;scope.data[pd.feature]=[];scope.isDate[pd.feature]=pd.isDate;pd.data.forEach((data,i)=>{const binsWithoutDropped=pd.featureBins.filter((_,j)=>{return pd.indicesToDrop.indexOf(j)===-1});const values=data.filter((_,j)=>{return pd.indicesToDrop.indexOf(j)===-1}).map((y,j)=>{return[binsWithoutDropped[j],y]});scope.data[pd.feature][i]={key:classes?classes[i]:"Partial dependence",values:values,color:scope.colors[i],type:"line",yAxis:1}});if(pd.distribution){scope.data[pd.feature].push({key:"Distribution",yAxis:2,type:"bar",color:distributionColor,values:pd.distribution.map((d,i)=>[pd.featureBins[i],d])})}}else if(pd.categories){if(pd.distribution){scope.distributions[pd.feature]=[{color:distributionColor,values:pd.distribution.map((d,i)=>({label:pd.categories[i],value:d}))}]}scope.nbPoints[pd.feature]=pd.categories.filter(modality=>!(modality in scope.labelsRemaping)).length;scope.heights[pd.feature]=pd.categories.length*nbOfClasses*15+400;scope.data[pd.feature]=[];pd.data.forEach((pdp,i)=>{scope.data[pd.feature][i]={key:classes?classes[i]:"Partial dependence",values:[]};pdp.forEach((pdpValue,j)=>{let modality=pd.categories[j];const isUnrepresented=pd.unrepresentedModalities.indexOf(modality)>-1;if(scope.labelsRemaping[modality]){modality=scope.labelsRemaping[modality]}if(isUnrepresented){modality+="*"}if(pd.indicesToDrop.indexOf(j)>-1){pdpValue=Number.NaN;modality+="**"}scope.data[pd.feature][i].values.push({label:modality,value:pdpValue,color:scope.colors[i]})})})}});scope.alreadyComputedFeatures=new Set(scope.features.filter(f=>scope.data[f]));scope.alreadyPostTrainingComputedFeatures=scope.features.filter(f=>scope.data[f]&&scope.computedPostTraining[f])}const allFeaturesInfo=$scope.modelData.preprocessing.per_feature;$scope.authorizedFeaturetypes=["CATEGORY","NUMERIC"];$scope.features=Object.keys(allFeaturesInfo).filter(feature=>{return allFeaturesInfo[feature].role==="INPUT"&&$scope.authorizedFeaturetypes.includes(allFeaturesInfo[feature].type)});$scope.isKFolding=$scope.modelData.trainInfo.kfold;$scope.featuresType={};$scope.features.forEach(feature=>$scope.featuresType[feature]=$scope.modelData.preprocessing.per_feature[feature].type);$scope.computationParams={sample_size:1e4,random_state:1337,n_jobs:1,debug_mode:false};$scope.labelsRemaping={"__DKU_N/A__":"[No value]",__DKU_OTHERS__:"[Others]",__DKU_UNREPRESENTED__:"[Unrepresented in train]"};preparePartialDependence($scope);if(!$scope.uiState.selectedFeature){$scope.uiState.selectedFeature=$scope.features.find(f=>$scope.data[f]&&$scope.computedPostTraining[f])}$scope.canCompute=function(){return $scope.uiState.selectedFeature&&$scope.computationParams.n_jobs!==0};$scope.canComputeAll=function(){return $scope.features.length>0&&$scope.computationParams.n_jobs!==0};$scope.$watch("uiState.selectedFeature",nv=>{if($scope.nbRecords[nv]){$scope.computationParams={...$scope.computationParams,sample_size:$scope.nbRecords[nv]}}d3.selectAll(".pdp__chart svg > *").remove()});$scope.computedOnStr=function(){const nbRecords=$scope.nbRecords[$scope.uiState.selectedFeature];const onSample=$scope.onSample[$scope.uiState.selectedFeature];let dataset="";if($scope.isKFolding){dataset="dataset"}else{if($scope.computedPostTraining[$scope.uiState.selectedFeature]){if($scope.isExternalMLflowModel()){dataset="evaluation set"}else{dataset="test set"}}else{dataset="train set"}}if(nbRecords){if(!onSample){return`${nbRecords} rows (the full ${dataset})`}else{return`${nbRecords} rows (a sample of the ${dataset})`}}else{return`the full ${dataset}`}};$scope.number;$scope.hideBanner=function(){$scope.uiState.bannerHidden=true};$scope.computeSelectedFeature=function(){const selectedFeat=$scope.uiState.selectedFeature;if(selectedFeat){$scope.computePartialDependency([selectedFeat],$scope.computationParams)}};$scope.computeAll=function(){if($scope.features.length>0){$scope.computePartialDependency($scope.features,$scope.computationParams)}};$scope.computePartialDependency=function(features,computationParams){const wt1Payload={computeAll:features.length>1,predictionType:$scope.modelData.coreParams.prediction_type};if(!wt1Payload.computeAll){wt1Payload.featureType=$scope.featuresType[features[0]]}const mesId=$stateParams.mesId||$scope.mesId;const evaluationId=$stateParams.evaluationId||$scope.evaluationId;if(mesId){DataikuAPI.modelevaluations.pdpComputationStart(FullModelLikeIdUtils.buildModelEvaluationFmeFromComponents(ActiveProjectKey.get(),mesId,evaluationId),features,computationParams).success(result=>{FutureProgressModal.show($scope,result,"Computing Partial Dependence").then(data=>{$scope.modelData.iperf.partialDependencies=data.partialDependencies;preparePartialDependence($scope)})}).error(setErrorInScope.bind($scope));WT1.event("doctor-compute-pdp",wt1Payload)}else{DataikuAPI.ml.prediction.pdpComputationStart($stateParams.fullModelId||$scope.fullModelId,features,computationParams).success(result=>{FutureProgressModal.show($scope,result,"Computing Partial Dependence").then(data=>{$scope.modelData.iperf.partialDependencies=data.partialDependencies;preparePartialDependence($scope)})}).error(setErrorInScope.bind($scope));WT1.event("doctor-compute-pdp",wt1Payload)}};$scope.exportPartialDependency=function(feature){const pdData=$scope.modelData.iperf.partialDependencies.find(d=>d["feature"]==feature);let partialDependenceColumns;if($scope.isBinaryClassification()){partialDependenceColumns=["class "+$scope.modelData.classes[1]+" partial dependence"]}else if($scope.isMulticlass()){partialDependenceColumns=$scope.modelData.classes.map(c=>"class "+c+" partial dependence")}else{partialDependenceColumns=["Partial dependence"]}const exportColumns=[pdData.featureBins?{name:"bin edges",type:"float"}:{name:"categories",type:"string"},{name:"distribution",type:"float"},...partialDependenceColumns.map(c=>({name:c,type:"float"})),{name:"sample size",type:"int"},{name:"random state",type:"int"}];const pdpValues=angular.copy(pdData.data);for(const value of pdpValues){for(const index of pdData.indicesToDrop){value[index]=null}}let dataToExport=[pdData.featureBins||pdData.categories,pdData.distribution,...pdpValues,Array(pdData.data[0].length).fill($scope.computationParams.sample_size),Array(pdData.data[0].length).fill($scope.computationParams.random_state)];if(pdData.categories){for(let[index,category]of dataToExport[0].entries()){if($scope.labelsRemaping[category]){dataToExport[0][index]=$scope.labelsRemaping[category]}}}dataToExport=dataToExport[0].map((_,colIndex)=>dataToExport.map(row=>row[colIndex]));ExportUtils.exportUIData($scope,{name:"Partial dependence of column "+feature+" for model "+$scope.modelData.userMeta.name,columns:exportColumns,data:dataToExport},"Export explanations");WT1.event("doctor-export-pdp",{predictionType:$scope.modelData.coreParams.prediction_type,featureType:$scope.featuresType[feature]})};$scope.puppeteerHook_elementContentLoaded=true})})();(function(){"use strict";var app=angular.module("dataiku.ml.explainability");app.controller("_SubpopTableUtilsController",function($scope,$filter,Fn,$interpolate,epochShift,CustomMetricIDService,BinaryClassificationModelsService,ModelDataUtils,ResidualsPlottingService){$scope.colorsRep=$scope.colors.slice(0,2).concat($scope.colors.slice(0,2));function getPercentString(v){if(v<.01){return"< 1 %"}else if(v>1){return"100 %"}else{return Math.round(v*100)+" %"}}function formatModalitiesInformation(data){if(data){if(data.modalities){data.modalities.forEach(function(modality){modality.weightedPercentage=modality.weightedCount/data.weightedNbRecords;modality.weightedPercentageStr=getPercentString(modality.weightedPercentage);modality.title=getValueTitle(modality,data.computed_as_type,data.isDate);modality.longTitle=getValueLongTitle(modality,data.computed_as_type,data.isDate)})}if(data.allDatasetModality){data.allDatasetModality.title="";data.allDatasetModality.longTitle="";data.allDatasetModality.weightedPercentage=1;data.allDatasetModality.weightedPercentageStr="100 %"}}}function convertPyTimestampToDateStr(dateFormat){return tmstp=>{return d3.time.format(dateFormat)(new Date(1e3*(tmstp-epochShift)))}}function getValueTitle(modality,computedAsType,isDate){if(modality.missing_values){return"Missing values"}switch(computedAsType){case"CATEGORY":{return modality.value}case"NUMERIC":{let formatData=isDate?convertPyTimestampToDateStr("%Y/%m/%d"):value=>" "+$filter("smartNumber")(value)+" ";const gt=modality.gte!==undefined?"["+formatData(modality.gte):"("+formatData(modality.gt);const lt=modality.lte!==undefined?formatData(modality.lte)+"]":formatData(modality.lt)+")";return gt+", "+lt}}}function getValueLongTitle(modality,computedAsType,isDate){let longTitle=modality.weightedPercentageStr;if($scope.areMetricsWeighted()){longTitle+=" (weighted out of "+modality.count+" rows)"}else if(angular.isDefined(modality.count)){longTitle+=" ("+modality.count+" rows)"}longTitle+=" — ";if(computedAsType==="NUMERIC"&&!modality.missing_values){let formatData=isDate?convertPyTimestampToDateStr("%Y-%m-%d %H:%M:%S"):value=>value;const gt=modality.gte!==undefined?formatData(modality.gte)+" <= ":formatData(modality.gt)+" < ";const lt=modality.lte!==undefined?" <= "+formatData(modality.lte):" < "+formatData(modality.lt);return longTitle+gt+$scope.modelData.selectedSubpopFeat+lt}else{return longTitle+getValueTitle(modality,computedAsType)}}function formatMultiClassifPerfData(perfData,index){if(!perfData){return}perfData.singleMetrics={index:index,hammingLoss:perfData.metrics.hammingLoss,Precision:perfData.metrics.precision,Recall:perfData.metrics.recall,"F1-Score":perfData.metrics.f1,Accuracy:perfData.metrics.accuracy,logLoss:perfData.metrics.logLoss,auc:perfData.metrics.mrocAUC,averagePrecision:perfData.metrics.averagePrecision};if($scope.modelData.modeling&&$scope.modelData.modeling.metrics.customMetrics){perfData.singleMetrics.customMetricsResults=perfData.metrics.customMetricsResults||[]}}function formatBinaryClassifPerfData(perfData,cut){if(!perfData||!perfData.perCutData){return}const cutData=BinaryClassificationModelsService.findCutData(perfData,cut);let headTaskCMW=$scope.modelData.headTaskCMW;let tp=cutData.tp.records;let tn=cutData.tn.records;let fp=cutData.fp.records;let fn=cutData.fn.records;perfData.singleMetrics={...cutData,logLoss:perfData.tiMetrics.logLoss,auc:perfData.tiMetrics.auc,averagePrecision:perfData.tiMetrics.averagePrecision,lift:perfData.tiMetrics.lift,cmg:(headTaskCMW.tnGain*tn+headTaskCMW.tpGain*tp+headTaskCMW.fpGain*fp+headTaskCMW.fnGain*fn)/(tn+tp+fn+fp)};if(perfData.tiMetrics.customMetricsResults&&Array.isArray(perfData.singleMetrics.customMetricsResults)){perfData.singleMetrics.customMetricsResults.push(...perfData.tiMetrics.customMetricsResults)}let pdd=perfData.densityData;let c=$scope.modelData.classes[1];let dd=pdd[c];if(pdd&&Object.keys(pdd).length){pdd.x=dd.actualIsNotThisClass.map(function(_,i,a){return i/a.length});pdd.ys=[dd.actualIsNotThisClass,dd.actualIsThisClass];pdd.xm=[cut];pdd.labels=["class "+$scope.modelData.classes[0],"class "+$scope.modelData.classes[1]];pdd.colors=$scope.colors.slice(0,2).concat("#9467bd")}}function formatRegressionPerfData(perfData){if(perfData.residuals){perfData.residualsHistograms=ResidualsPlottingService.createResidualsBarChartConfig(perfData.residuals.residuals,false,perfData.residuals.residualsMean,perfData.residuals.residualsStd);delete perfData.residualsHistograms.title;perfData.residualsHistograms.xAxis[0].nameTextStyle={fontSize:11,color:"#000000"};perfData.residualsHistograms.yAxis[0].nameTextStyle=perfData.residualsHistograms.xAxis[0].nameTextStyle}else if(perfData.regression_performance){const ed=perfData.regression_performance.error_distribution;if(ed){perfData.errorDistribBars=ed.map(p=>({min:p.bin_min,max:p.bin_max,count:p.count}))}}perfData.singleMetrics={};if($scope.modelData.modeling&&$scope.modelData.modeling.metrics.customMetrics){perfData.singleMetrics.customMetricsResults=perfData.metrics.customMetricsResults||[]}let spd=perfData.scatterPlotData;if(spd){let hashTbl=new Set;for(var i=spd.x.length-1;i>=0;i--){const key=spd.x[i]+"#"+spd.y[i];if(hashTbl.has(key)){spd.x.splice(i,1);spd.y.splice(i,1)}else{hashTbl.add(key)}}perfData.spd=spd}}function formatPerfDataAllModalities(data,thresholdFn=Fn.cst($scope.modelData.userMeta.activeClassifierThreshold)){let formatFunc;if($scope.isBinaryClassification()){formatFunc=mod=>formatBinaryClassifPerfData(mod.perf,thresholdFn(mod))}else if($scope.isRegression()){formatFunc=mod=>formatRegressionPerfData(mod.perf)}else if($scope.isMulticlass()){formatFunc=mod=>formatMultiClassifPerfData(mod.perf,mod.index)}else if($scope.isForecast()){formatFunc=()=>{}}if(data){if(data.modalities){data.modalities.forEach(modality=>{if(!modality.excluded&&modality.perf){formatFunc(modality)}})}if(data.allDatasetModality&&data.allDatasetModality.perf){formatFunc(data.allDatasetModality)}}}$scope.getCurrentFeatureData=()=>{return $scope.modelData.subPopulation[$scope.modelData.selectedSubpopFeat]};$scope.getNumModalities=()=>{return $scope.getCurrentFeatureData().modalities.length};$scope.isSelectedFeatureInput=()=>{return $scope.per_feature&&($scope.per_feature[$scope.modelData.selectedSubpopFeat]||{}).role=="INPUT"};$scope.getNbRecords=()=>{return $scope.getCurrentFeatureData().nbRecords};$scope.getMetricName=function(metric){if(!metric){return"-"}return metric.shortName||metric.name||metric.fieldName};$scope.getMetricLongName=function(metric){if(!metric){return"-"}return metric.name||metric.fieldName};$scope.getModalityType=plural=>{const featType=$scope.getCurrentFeatureData().computed_as_type;switch(featType){case"NUMERIC":return plural?"bins":"bin";case"CATEGORY":default:return plural?"modalities":"modality"}};$scope.isScrolling=false;$scope.setAllDatasetScrolled=userAction=>{$scope.isScrolling=userAction.target.scrollTop>0;$scope.$apply()};$scope.sortByMetric=metricId=>{let ss=$scope.selection;const isCustomMetric=CustomMetricIDService.checkMetricIsCustom(metricId);let metric;if(isCustomMetric){const metricName=CustomMetricIDService.getCustomMetricName(metricId);metric=$scope.uiState.display.customMetrics.find(m=>m.name===metricName)}else{metric=$scope.uiState.display.metrics.find(m=>m.fieldName===metricId)}let modalities=$scope.getCurrentFeatureData().modalities;if($scope.uiState.sortMetric===metricId){ss.orderReversed=!ss.orderReversed;if(metricId!=="modality"){modalities.filter(modality=>modality.excluded).forEach(modality=>{modality.sortMetric*=-1})}return}else{ss.orderReversed=false}$scope.uiState.sortMetric=metricId;modalities.forEach(modality=>{let sortMetric;if(metricId==="modality"){sortMetric=-modality.index}else{if(!modality.excluded){if(angular.isDefined(metric)){sortMetric=metric.getMetricFromPerf(modality.perf)}else{sortMetric=$interpolate(`{{${metricId}}}`)(modality)}}else{if(ss.orderReversed){sortMetric=Number.MAX_VALUE}else{sortMetric=-Number.MAX_VALUE}}}modality.sortMetric=sortMetric});ss.orderQuery=["-sortMetric",ss.orderReversed?"-title":"+title",ss.orderReversed?"-longTitle":"+longTitle"]};$scope.isSortMetric=function(metricFieldName){return $scope.uiState.sortMetric===metricFieldName};function reinitializeSort(){let ss=$scope.selection;$scope.uiState.sortMetric=undefined;ss.orderQuery=undefined;ss.orderReversed=undefined}function setNumDecimalsMetrics(subpopData){let getArrayMinDiffNumDecimals=arr=>{let minDiff=Number.MAX_VALUE;let sortedArr=arr.sort((a,b)=>a>b?1:-1);let diff;for(let i=0;i<sortedArr.length-1;i++){diff=sortedArr[i+1]-sortedArr[i];if(diff<minDiff){minDiff=diff}}return Math.max(-Math.ceil(Math.log10(minDiff)),0)};let numDecimalsMetrics=$scope.uiState.display.numDecimalsMetrics;let nonExcludedModalitiesPerf=subpopData.modalities.concat(subpopData.allDatasetModality).filter(modality=>!modality.excluded).map(modality=>modality.perf);$scope.uiState.display.metrics.forEach(m=>{let numDecimals=getArrayMinDiffNumDecimals(nonExcludedModalitiesPerf.map(perf=>m.getMetricFromPerf(perf)));if(m.percentage){numDecimals=Math.max(numDecimals-2,0)}numDecimalsMetrics[m.fieldName]=numDecimals})}function setDisplayedMetrics(){const modeling=$scope.modelData.modeling;if(modeling&&modeling.metrics){if(modeling.metrics.evaluationMetric==="CUSTOM"){$scope.uiState.display.modelMetric=$scope.uiState.display.customMetrics.find(cm=>cm.name===modeling.metrics.customEvaluationMetricName);$scope.uiState.display.modelMetric.isCustom=true}else{$scope.uiState.display.modelMetric=$scope.uiState.display.metrics.find(m=>modeling.metrics.evaluationMetric==(m.metricName||m.fieldName.toUpperCase()));$scope.uiState.display.modelMetric.isCustom=false}$scope.uiState.display.modelMetric.displayed=true;$scope.uiState.display.modelMetric.isModelMetric=true}$scope.uiState.display.metrics.filter(m=>!m.isModelMetric).filter(m=>ModelDataUtils.hasProbas($scope.modelData)||!m.needsProbability).sort((m1,m2)=>m1.byDefault===m2.byDefault?0:m1.byDefault?-1:1).slice(0,3).forEach(m=>{m.displayed=true})}function buildAllDatasetModality(data,allDatasetPerf){if(data){data.allDatasetModality={isAllDataset:true,count:data.nbRecords,perf:allDatasetPerf,index:-1}}}$scope.formatTableResults=function(data,allDatasetPerf,thresholdFn){setDisplayedMetrics();buildAllDatasetModality(data,allDatasetPerf);formatModalitiesInformation(data);formatPerfDataAllModalities(data,thresholdFn);setNumDecimalsMetrics(data);reinitializeSort()};$scope.selection=$.extend({filterParams:{userQueryTargets:["title","weightedPercentageStr"]}},$scope.selection||{});const probabilityCharts=[["DENSITY","Density Chart"],["PROBA_DISTRIB","Probability Distribution"]];const confusionMatrixModes=[["records",$scope.areMetricsWeighted()?"Weighted record count":"record count"],["actual",$scope.areMetricsWeighted()?"Weighted % of actual classes":"% of actual classes"],["predicted",$scope.areMetricsWeighted()?"Weighted % of predicted classes":"% of predicted classes"]];const bcSingleMetrics=[{fieldName:"Accuracy",minDecimals:2,maxDecimals:4},{fieldName:"Precision",minDecimals:2,maxDecimals:4,byDefault:true},{fieldName:"Recall",minDecimals:2,maxDecimals:4,byDefault:true},{fieldName:"F1-Score",name:"F1-score",metricName:"F1",minDecimals:2,maxDecimals:4},{fieldName:"cmg",name:"Cost Matrix",metricName:"COST_MATRIX",minDecimals:2,maxDecimals:4},{fieldName:"hammingLoss",name:"Hamming Loss",minDecimals:2,maxDecimals:4},{fieldName:"mcc",name:"Matthews Correlation Coefficient",shortName:"MC Coeff.",minDecimals:2,maxDecimals:4},{fieldName:"auc",name:"ROC AUC",metricName:"ROC_AUC",minDecimals:2,maxDecimals:4,byDefault:true,needsProbability:true},{fieldName:"lift",name:"Lift",metricName:"CUMULATIVE_LIFT",minDecimals:2,maxDecimals:4,needsProbability:true},{fieldName:"averagePrecision",name:"Average Precision",metricName:"AVERAGE_PRECISION",minDecimals:2,maxDecimals:4,needsProbability:true},{fieldName:"logLoss",metricName:"LOG_LOSS",name:"Log Loss",minDecimals:2,maxDecimals:4,needsProbability:true},{fieldName:"actual",fake:true,percentage:true,maxDecimals:1,getMetricFromPerf:perf=>perf.singleMetrics.actPos["ratio"]},{fieldName:"predicted",fake:true,percentage:true,maxDecimals:1,getMetricFromPerf:perf=>perf.singleMetrics.predPos["ratio"]}];bcSingleMetrics.forEach(sm=>{if(sm.getMetricFromPerf===undefined){sm.getMetricFromPerf=perf=>perf.singleMetrics[sm.fieldName]}});const regSingleMetrics=[{fieldName:"evs",name:"Explained Variance Score",shortName:"Explained Var.",minDecimals:2,maxDecimals:4},{fieldName:"mape",shortName:"MAPE",name:"Mean Absolute Percentage Error (MAPE)",minDecimals:1,maxDecimals:2,percentage:true},{fieldName:"mae",shortName:"MAE",name:"Mean Absolute Error (MAE)",minDecimals:1,maxDecimals:2,byDefault:true},{fieldName:"mse",shortName:"MSE",name:"Mean Squared Error (MSE)",minDecimals:0,maxDecimals:1},{fieldName:"rmse",shortName:"RMSE",name:"Root Mean Squared Error (RMSE)",minDecimals:1,maxDecimals:2,byDefault:true},{fieldName:"rmsle",shortName:"RMSLE",name:"Root Mean Squared Logarithmic Error (RMSLE)",ignoreZero:true,minDecimals:1,maxDecimals:2},{fieldName:"r2",name:"R2 Score",minDecimals:2,maxDecimals:4,byDefault:true},{fieldName:"pearson",shortName:"Pearson Coeff.",name:"Pearson Coefficient",minDecimals:2,maxDecimals:4}];regSingleMetrics.forEach(sm=>{sm.getMetricFromPerf=perf=>perf.metrics[sm.fieldName]});const mcSingleMetrics=[{fieldName:"Accuracy",minDecimals:2,maxDecimals:4},{fieldName:"Precision",minDecimals:2,maxDecimals:4,byDefault:true},{fieldName:"Recall",minDecimals:2,maxDecimals:4,byDefault:true},{fieldName:"F1-Score",name:"F1-score",metricName:"F1",minDecimals:2,maxDecimals:4},{fieldName:"hammingLoss",name:"Hamming Loss",minDecimals:2,maxDecimals:4},{fieldName:"auc",name:"ROC AUC",metricName:"ROC_AUC",minDecimals:2,maxDecimals:4,byDefault:true,needsProbability:true},{fieldName:"averagePrecision",name:"Average Precision",metricName:"AVERAGE_PRECISION",minDecimals:2,maxDecimals:4,needsProbability:true},{fieldName:"logLoss",metricName:"LOG_LOSS",name:"Log Loss",minDecimals:2,maxDecimals:4,needsProbability:true}];mcSingleMetrics.forEach(sm=>{if(sm.getMetricFromPerf===undefined){sm.getMetricFromPerf=perf=>perf.singleMetrics[sm.fieldName]}});const tsSingleMetrics=[{fieldName:"mase",name:"Mean Absolute Scaled Error",shortName:"MASE",minDecimals:1,maxDecimals:2,byDefault:true},{fieldName:"mape",shortName:"MAPE",name:"Mean Absolute Percentage Error",minDecimals:1,maxDecimals:2,percentage:true,byDefault:true},{fieldName:"smape",shortName:"Symmetric MAPE",name:"Symmetric Mean Absolute Percentage Error",minDecimals:2,maxDecimals:4,byDefault:true},{fieldName:"mae",shortName:"MAE",name:"Mean Absolute Error",minDecimals:2,maxDecimals:4,byDefault:true},{fieldName:"meanAbsoluteQuantileLoss",metricName:"MEAN_ABSOLUTE_QUANTILE_LOSS",shortName:"Mean Absolute Quantile Loss",name:"Mean Absolute Quantile Loss",minDecimals:1,maxDecimals:2},{fieldName:"meanWeightedQuantileLoss",metricName:"MEAN_WEIGHTED_QUANTILE_LOSS",shortName:"Mean Weighted Quantile Loss",name:"Mean Weighted Quantile Loss",minDecimals:1,maxDecimals:2},{fieldName:"mse",shortName:"MSE",name:"Mean Squared Error",minDecimals:0,maxDecimals:1},{fieldName:"rmse",shortName:"RMSE",name:"Root Mean Squared Error",minDecimals:1,maxDecimals:2,byDefault:true},{fieldName:"msis",shortName:"MSIS",name:"Mean Scaled Interval Score",minDecimals:0,maxDecimals:1},{fieldName:"nd",shortName:"Normalized Deviation",name:"Normalized Deviation",minDecimals:2,maxDecimals:4}];tsSingleMetrics.forEach(sm=>{if(sm.getMetricFromPerf===undefined){sm.getMetricFromPerf=perf=>perf.aggregatedMetrics[sm.fieldName]}});$scope.toggleMetricDisplay=function(metric){if(!metric.isModelMetric){metric.displayed=!metric.displayed}};$scope.metricExists=function(metric){return!metric.fake&&metric.getMetricFromPerf($scope.getCurrentFeatureData().allDatasetModality.perf)!==undefined};$scope.per_feature=$scope.modelData.preprocessing.per_feature;$scope.metricsWeighted=false;$scope.authorizedColTypes=["CATEGORY","NUMERIC"];$scope.authorizedColRoles=["INPUT","REJECT"];$scope.computedSubpopulations=new Set;let metrics;if($scope.isBinaryClassification()){metrics=bcSingleMetrics}else if($scope.isRegression()){metrics=regSingleMetrics}else if($scope.isMulticlass()){metrics=mcSingleMetrics}else if($scope.isForecast()){metrics=tsSingleMetrics}$scope.uiState={display:{predictionType:$scope.modelData.coreParams.prediction_type,probabilityCharts:probabilityCharts,probabilityChart:probabilityCharts[0][0],confusionMatrixModes:confusionMatrixModes,confusionMatrixMode:confusionMatrixModes[0][0],metrics:metrics,numDecimalsMetrics:{}},selection:$scope.selection,noValueComputed:!$scope.modelData.selectedSubpopFeat}});app.controller("SubpopulationController",function($scope,DataikuAPI,$stateParams,FutureProgressModal,WT1,$filter,$controller,ActiveProjectKey,FullModelLikeIdUtils,PMLFilteringService,CustomMetricIDService){$controller("_SubpopTableUtilsController",{$scope:$scope});$scope.CustomMetricIDService=CustomMetricIDService;if($scope.modelData.modeling&&$scope.modelData.modeling.metrics&&$scope.modelData.modeling.metrics.customMetrics){$scope.uiState.display.customMetrics=$scope.modelData.modeling.metrics.customMetrics.map(item=>{let retItem=angular.copy(item);retItem.id=CustomMetricIDService.getCustomMetricId(item.name);retItem.displayed=false;retItem.getMetricFromPerf=perf=>{return perf.singleMetrics.customMetricsResults.find(cmr=>cmr.metric.name===item.name)["value"]};return retItem})}$scope.computationParams={sample_size:1e4,random_state:1337,n_jobs:1,debug_mode:false};function processSubpopInfo(subpopInfo){$scope.computedSubpopulations=new Set(subpopInfo.features.filter(f=>f.done_at).map(f=>f.feature));if($scope.isExternalMLflowModel()){$scope.computedOn="evaluation dataset"}else{$scope.computedOn=subpopInfo.computedOn}$scope.onSample=subpopInfo.onSample;if(subpopInfo.onSample){$scope.computationParams={...$scope.computationParams,sample_size:subpopInfo.sampleSize,random_state:subpopInfo.randomState}}$scope.lastRandomState=subpopInfo.randomState;$scope.lastSampleSize=subpopInfo.sampleSize;if($scope.modelData.selectedSubpopFeat===undefined&&$scope.computedSubpopulations.size>0){$scope.uiState.subpopFeature=$scope.computedSubpopulations.values().next().value}}function retrieveSubpopulationsInfo(){var id=$stateParams.fullModelId||$scope.fullModelId;const mesId=$stateParams.mesId||$scope.mesId;const evaluationId=$stateParams.evaluationId||$scope.evaluationId;if(mesId)DataikuAPI.modelevaluations.getSubpopulationsInfo(FullModelLikeIdUtils.buildModelEvaluationFmeFromComponents(ActiveProjectKey.get(),mesId,evaluationId)).success(function(subpopInfo){if(!$.isEmptyObject(subpopInfo)){processSubpopInfo(subpopInfo)}$scope.puppeteerHook_elementContentLoaded=true}).error(setErrorInScope.bind($scope));else DataikuAPI.ml.prediction.getSubpopulationsInfo(id).success(function(subpopInfo){if(!$.isEmptyObject(subpopInfo)){processSubpopInfo(subpopInfo)}$scope.puppeteerHook_elementContentLoaded=true}).error(setErrorInScope.bind($scope))}function fetchSubpopulationResults(feature){var id=$stateParams.fullModelId||$scope.fullModelId;const mesId=$stateParams.mesId||$scope.mesId;const evaluationId=$stateParams.evaluationId||$scope.evaluationId;if(mesId){DataikuAPI.modelevaluations.getSubpopulation(FullModelLikeIdUtils.buildModelEvaluationFmeFromComponents(ActiveProjectKey.get(),mesId,evaluationId),[feature]).success(function(data){updateWithNewSubpopulationResults(feature,data)})}else{DataikuAPI.ml.prediction.getSubpopulation(id,[feature]).success(function(data){updateWithNewSubpopulationResults(feature,data)})}}function updateWithNewSubpopulationResults(feature,subpopulationResults){$scope.modelData.selectedSubpopFeat=feature;$scope.modelData.subPopulation=$scope.modelData.subPopulation||new Map;$scope.modelData.subPopulation[feature]=subpopulationResults.subpopulationAnalyses.find(sa=>sa.feature===feature);$scope.modelData.allDatasetPerf=subpopulationResults.global.perf;retrieveSubpopulationsInfo();$scope.formatTableResults($scope.modelData.subPopulation[feature],$scope.modelData.allDatasetPerf);$scope.uiState.noValueComputed=false}function selectFetchedSubpopulationResults(feature){$scope.modelData.selectedSubpopFeat=feature;$scope.formatTableResults($scope.modelData.subPopulation[feature],$scope.modelData.allDatasetPerf)}function restoreSortbyMetricFromUiState(){let uiStateSelection=$scope.uiState.selection;let selection=$scope.selection;selection.orderReversed=uiStateSelection.orderReversed;selection.orderQuery=uiStateSelection.orderQuery;selection.filterQuery=uiStateSelection.filterQuery}$scope.$watch("uiState.subpopFeature",function(newFeature,oldFeature){if(!newFeature||newFeature===oldFeature){return}if($scope.computedSubpopulations.has(newFeature)){if($scope.modelData.subPopulation&&$scope.modelData.subPopulation[newFeature]){selectFetchedSubpopulationResults(newFeature)}else{fetchSubpopulationResults(newFeature)}}});$scope.$watch("modelData.userMeta.activeClassifierThreshold",function(){if($scope.modelData.selectedSubpopFeat&&$scope.modelData.subPopulation&&$scope.modelData.subPopulation[$scope.modelData.selectedSubpopFeat]){$scope.formatTableResults($scope.modelData.subPopulation[$scope.modelData.selectedSubpopFeat],$scope.modelData.allDatasetPerf)}});$scope.canCompute=function(){return $scope.uiState.subpopFeature&&$scope.computationParams.n_jobs!==0};$scope.computeSubpopulation=function(feature){if(!feature){return}const mesId=$stateParams.mesId||$scope.mesId;const evaluationId=$stateParams.evaluationId||$scope.evaluationId;if(mesId){DataikuAPI.modelevaluations.subpopulationComputationStart(FullModelLikeIdUtils.buildModelEvaluationFmeFromComponents(ActiveProjectKey.get(),mesId,evaluationId),[feature],$scope.computationParams).success(function(data){var newScope=$scope.$new();FutureProgressModal.show(newScope,data,"Computing Subpopulation").then(function(subpopulationResults){if(subpopulationResults){updateWithNewSubpopulationResults(feature,subpopulationResults)}})}).error(setErrorInScope.bind($scope));WT1.event("me-compute-subpopulation",{predictionType:$scope.evaluationDetails.evaluation.predictionType,weightMethod:$scope.evaluationDetails.details.coreParams.weight.weightMethod})}else{var id=$stateParams.fullModelId||$scope.fullModelId;DataikuAPI.ml.prediction.subpopulationComputationStart(id,[feature],$scope.computationParams).success(function(data){var newScope=$scope.$new();FutureProgressModal.show(newScope,data,"Computing Subpopulation").then(function(subpopulationResults){if(subpopulationResults){updateWithNewSubpopulationResults(feature,subpopulationResults)}})}).error(setErrorInScope.bind($scope));WT1.event("pml-compute-subpopulation",{backendType:$scope.modelData.backendType,taskType:"PREDICTION",predictionType:$scope.modelData.coreParams.prediction_type,weightMethod:$scope.modelData.coreParams.weight.weightMethod})}};retrieveSubpopulationsInfo();if($scope.modelData.$uiStateSubpopulation!==undefined){$scope.uiState=$scope.modelData.$uiStateSubpopulation;restoreSortbyMetricFromUiState()}else{$scope.modelData.$uiStateSubpopulation=$scope.uiState}});app.directive("subpopulationValue",function(){return{restrict:"E",templateUrl:"/templates/ml/prediction-model/subpopulation-value.html",scope:{allDatasetPerf:"=",data:"=",threshold:"=",colors:"=",display:"=",modelData:"="},controller:function($scope,$controller){$controller("_snippetMetricsCommon",{$scope:$scope});$scope.getLinearGradient=function(ratio){return"linear-gradient(to right, #9dccfe 0%, #9dccfe "+ratio*100+"%,rgba(0, 0, 0, 0) "+ratio*100+"%, rgba(0, 0, 0, 0) 100%)"};$scope.uiState={isExpanded:false,excludedReasons:{DROPPED:"(all subpopulation dropped by the preprocessing)",NOTARGET:"(no target or weights on the subpopulation)",ONECLASS:"(only one class in subpopulation)",ONEVALUE:"(only one value in subpopulation)"}}}}})})();(function(){"use strict";var app=angular.module("dataiku.ml.explainability");app.controller("IndividualExplanationsController",function($scope,DataikuAPI,$stateParams,FutureProgressModal,ExportUtils,WT1,ActiveProjectKey,FullModelLikeIdUtils){const predictionLimit={min:0,max:1};const xDomain={min:0,max:1};const NUMBER_OF_BINS=20;$scope.isKFolding=$scope.modelData.trainInfo.kfold;$scope.computationParams={sample_size:Math.min(1e3,maxRows()),random_state:1337,n_jobs:1,debug_mode:false};$scope.uiState={selectedFeature:undefined,showLowPredictions:true,showHighPredictions:true,nbExplanations:3,method:"ICE",exportMode:false};$scope.chartColor="#D5D9D9";$scope.labels=[""];if($scope.isMulticlass()){$scope.selectableClasses=Object.keys($scope.modelData.predictionInfo.predictedClassCount)}$scope.selectedRange={};$scope.forms={};$scope.puppeteerPrepareForExport=function(){$scope.uiState.exportMode=true};function getClassificationDataToPlot(className){const predictionInfo=$scope.modelData.predictionInfo;const probabilityDensityForClass=predictionInfo.probabilityDensities[className];const median=probabilityDensityForClass.median;return{x:predictionInfo.x,y:probabilityDensityForClass.density,median:median}}function updateChartDataWithClass(className){const data=getClassificationDataToPlot(className);$scope.axes={x:data.x,ys:[data.y]};$scope.average=data.median}function maxRows(){if($scope.isKFolding){return $scope.modelData.trainInfo.fullRows}else{return $scope.modelData.trainInfo.testRows}}$scope.$watch("selectedClass",function(className){if(className){updateChartDataWithClass(className);updateResultsWithClass(className)}});$scope.$watch("axes",function(){let binSize=.01;if($scope.isRegression()){const predictions=$scope.modelData.predictionInfo.predictions;predictionLimit.max=d3.max(predictions);predictionLimit.min=d3.min(predictions);binSize=(predictionLimit.max-predictionLimit.min)/NUMBER_OF_BINS}const{from,to}=getInitialBrushRange(10,binSize);$scope.selectedRange.from=from;$scope.selectedRange.to=to},true);if($scope.isClassification()){if($scope.isMulticlass()){$scope.selectedClass=$scope.modelData.classes[0]}else{const data=getClassificationDataToPlot($scope.modelData.classes[1]);$scope.average=data.median;$scope.axes={x:data.x,ys:[data.y]}}$scope.dataAxes=["Predicted probability","Probability density"];$scope.scale=d3.scale.linear().domain([xDomain.min,xDomain.max])}else if($scope.isRegression()){const predictions=$scope.modelData.predictionInfo.predictions;predictionLimit.max=d3.max(predictions);predictionLimit.min=d3.min(predictions);const x=d3.scale.linear().domain([predictionLimit.min,predictionLimit.max]).nice();const data=d3.layout.histogram().frequency(0).bins(x.ticks(NUMBER_OF_BINS))(predictions);$scope.axes={x:data.map(d=>d.x),ys:[data.map(d=>d.y)]};xDomain.min=d3.min($scope.axes.x);xDomain.max=d3.max($scope.axes.x);$scope.average=weightedMean($scope.axes.x,$scope.axes.ys[0]);$scope.dataAxes=["Prediction","Prediction density"];$scope.scale=d3.scale.linear().domain([xDomain.min,xDomain.max])}function weightedMean(arrValues,arrWeights){let cumSum=0;let totalWeight=0;for(let i=0;i<arrValues.length;i++){cumSum+=arrValues[i]*arrWeights[i];totalWeight+=arrWeights[i]}return cumSum/totalWeight}function getInitialBrushRange(nbWantedRows,binSize){let estimatedNbRowsInLeft=0;let estimatedNbRowsInRight=0;let xInfBrush,xSupBrush;for(let i=0;i<$scope.axes.x.length;i++){if($scope.isRegression()){estimatedNbRowsInLeft+=$scope.axes.ys[0][i]*$scope.computationParams.sample_size;estimatedNbRowsInRight+=$scope.axes.ys[0][$scope.axes.x.length-i-1]*$scope.computationParams.sample_size}else{estimatedNbRowsInLeft+=binSize*$scope.axes.ys[0][i]*$scope.computationParams.sample_size;estimatedNbRowsInRight+=binSize*$scope.axes.ys[0][$scope.axes.x.length-i-1]*$scope.computationParams.sample_size}if(xInfBrush===undefined&&estimatedNbRowsInLeft>=nbWantedRows){xInfBrush=$scope.axes.x[i]}if(xSupBrush===undefined&&estimatedNbRowsInRight>=nbWantedRows){xSupBrush=$scope.axes.x[$scope.axes.x.length-i-1]}}const middleRange=(xDomain.max-xDomain.min)/2;if(!xInfBrush){xInfBrush=middleRange}if(!xSupBrush){xSupBrush=middleRange}return{from:xInfBrush,to:xSupBrush}}function setNumberOfRowsInLeftBrush(){let binSize=.01;let estimatedNbRowsInLeft=0;for(let i=0;i<$scope.axes.x.length;i++){if($scope.isRegression()){if($scope.axes.x[i]<=$scope.selectedRange.from){estimatedNbRowsInLeft+=$scope.axes.ys[0][i]*$scope.computationParams.sample_size}}else{if($scope.axes.x[i]<=$scope.selectedRange.from){estimatedNbRowsInLeft+=binSize*$scope.axes.ys[0][i]*$scope.computationParams.sample_size}}}$scope.nbRowsLeft=Math.round(estimatedNbRowsInLeft)}function setNumberOfRowsInRightBrush(){let binSize=.01;let estimatedNbRowsInRight=0;for(let i=0;i<$scope.axes.x.length;i++){if($scope.isRegression()){if($scope.axes.x[$scope.axes.x.length-i-1]>=$scope.selectedRange.to){estimatedNbRowsInRight+=$scope.axes.ys[0][$scope.axes.x.length-i-1]*$scope.computationParams.sample_size}}else{if($scope.axes.x[$scope.axes.x.length-i-1]>=$scope.selectedRange.to){estimatedNbRowsInRight+=binSize*$scope.axes.ys[0][$scope.axes.x.length-i-1]*$scope.computationParams.sample_size}}}$scope.nbRowsRight=Math.round(estimatedNbRowsInRight)}$scope.addBrush=function(){const epsilon=(xDomain.max-xDomain.min)/1e3;d3.selectAll(".line-chart-brush__right").remove();d3.selectAll(".line-chart-brush__left").remove();d3.selectAll(".x-average-mark").remove();const backgroundRect=d3.select(".nv-background rect");const backgroundG=d3.select(".nv-background");const brushHeight=Number(backgroundRect.style("height").split("px")[0]);const brushSvg=backgroundG.select(function(){return this.parentNode});brushSvg.attr("height",backgroundRect.style("height"));const rightExtentRange=[$scope.selectedRange.to,xDomain.max];const leftExtentRange=[xDomain.min,$scope.selectedRange.from];if(leftExtentRange[1]>rightExtentRange[0]){leftExtentRange[1]=rightExtentRange[0]}if(leftExtentRange[1]===xDomain.min){leftExtentRange[1]+=epsilon}if(rightExtentRange[0]===xDomain.max){rightExtentRange[0]-=epsilon}const width=backgroundG.node().getBoundingClientRect().width;const xScale=$scope.scale.range([0,width]);const brushHandlerHeight=30;const brushHandlerWidth=15;const onRightBrushed=function(){let rightExtent=rightBrush.extent();if(d3.event.mode==="move"){rightExtent=[$scope.selectedRange.to,xDomain.max]}else if(rightExtent[1]===rightExtent[0]){rightExtent[0]-=epsilon;$scope.selectedRange.to=rightExtent[1]}else{if(leftBrush&&rightExtent[0]<leftBrush.extent()[1]){rightExtent[0]=leftBrush.extent()[1]}$scope.selectedRange.to=rightExtent[0]}$scope.$digest();d3.select(this).call(rightBrush.extent(rightExtent))};const onLeftBrushed=function(){let leftExtent=leftBrush.extent();if(d3.event.mode==="move"){leftExtent=[xDomain.min,$scope.selectedRange.from]}else if(leftExtent[1]===leftExtent[0]){leftExtent[1]+=epsilon;$scope.selectedRange.from=leftExtent[0]}else{if(rightBrush&&leftExtent[1]>rightBrush.extent()[0]){leftExtent[1]=rightBrush.extent()[0]}$scope.selectedRange.from=leftExtent[1]}$scope.$digest();d3.select(this).call(leftBrush.extent(leftExtent))};brushSvg.append("path").attr("d","M0,0 V"+(brushHeight-10)).attr("stroke-width","1px").attr("stroke",$scope.chartColor).attr("stroke-dasharray","5,3").attr("transform","translate("+xScale($scope.average)+", 10)").attr("class","x-average-mark");brushSvg.append("text").attr("x",xScale($scope.average)).attr("y",-1).attr("text-anchor","middle").attr("class","x-average-mark").attr("fill",$scope.chartColor).text($scope.isClassification()?"Average probability":"Average prediction");let leftBrush,rightBrush;if($scope.uiState.showLowPredictions){const leftBrushG=brushSvg.append("g").attr("class","x line-chart-brush__left");leftBrush=d3.svg.brush().x(xScale).on("brush",onLeftBrushed).extent(leftExtentRange);const lB=leftBrushG.call(leftBrush);lB.selectAll(".extent").attr("y",0).attr("height",brushHeight).style("cursor","unset");leftBrushG.selectAll(".resize.e > rect").attr("y",0).attr("height",brushHeight).attr("width",5).style("visibility","visible");leftBrushG.selectAll(".resize.e").append("rect").attr("x",-8).attr("y",brushHeight/2-brushHandlerHeight/2).attr("height",brushHandlerHeight).attr("width",brushHandlerWidth)}if($scope.uiState.showHighPredictions){const rightBrushG=brushSvg.append("g").attr("class","x line-chart-brush__right");rightBrush=d3.svg.brush().x(xScale).on("brush",onRightBrushed).extent(rightExtentRange);const rB=rightBrushG.call(rightBrush);rB.selectAll(".extent").attr("y",0).attr("height",brushHeight).style("cursor","unset");rightBrushG.selectAll(".resize.w > rect").attr("y",0).attr("height",brushHeight).attr("width",5).style("visibility","visible");rightBrushG.selectAll(".resize.w").append("rect").attr("x",-8).attr("y",brushHeight/2-brushHandlerHeight/2).attr("height",brushHandlerHeight).attr("width",brushHandlerWidth)}setNumberOfRowsInRightBrush();setNumberOfRowsInLeftBrush()};$scope.uiState.selectedColumn=findAnIdentifier();getExplanations();$scope.canCompute=function(){return $scope.forms.explanationsForm.nbExplanations.$valid&&($scope.uiState.showHighPredictions||$scope.uiState.showLowPredictions)};$scope.compute=function(){let computationParams={low_predictions_boundary:$scope.selectedRange.from,high_predictions_boundary:$scope.selectedRange.to,nb_explanations:$scope.uiState.nbExplanations,class_to_compute:$scope.selectedClass,method:$scope.uiState.method,...$scope.computationParams};const mesId=$stateParams.mesId||$scope.mesId;const evaluationId=$stateParams.evaluationId||$scope.evaluationId;if(mesId){DataikuAPI.modelevaluations.individualExplanationsComputationStart(FullModelLikeIdUtils.buildModelEvaluationFmeFromComponents(ActiveProjectKey.get(),mesId,evaluationId),computationParams).success(result=>{FutureProgressModal.show($scope,result,"Computing Individual Explanations").then(explanationResults=>{formatExplanationResults(explanationResults)})}).error(setErrorInScope.bind($scope))}else{DataikuAPI.ml.prediction.individualExplanationsComputationStart($stateParams.fullModelId||$scope.fullModelId,computationParams).success(result=>{FutureProgressModal.show($scope,result,"Computing Individual Explanations").then(explanationResults=>{formatExplanationResults(explanationResults)})}).error(setErrorInScope.bind($scope))}WT1.event("doctor-compute-explanations",{lowPredictionsBoundary:$scope.selectedRange.from,highPredictionsBoundary:$scope.selectedRange.to,nbExplanations:$scope.uiState.nbExplanations,predictionType:$scope.modelData.coreParams.prediction_type,sampleSize:$scope.computationParams.sample_size,method:$scope.uiState.method})};function sortAndSplitExplanations(){const results=$scope.results;const explanations={high:{values:[],index:[]},low:{values:[],index:[]}};for(let i=0;i<results.predictions.length;i++){const prediction=results.predictions[i];explanations.high.values[i]=[];explanations.low.values[i]=[];if(prediction<=$scope.selectedRange.from){explanations.low.index.push(i)}else if(prediction>=$scope.selectedRange.to){explanations.high.index.push(i)}for(const feature in results.explanations){const explanation={featureName:feature,featureValue:results.observations[feature][i],value:results.explanations[feature][i]};if(prediction<=$scope.selectedRange.from){explanations.low.values[i].push(explanation)}else if(prediction>=$scope.selectedRange.to){explanations.high.values[i].push(explanation)}}explanations.low.values[i].sort((exp1,exp2)=>Math.abs(exp2.value)-Math.abs(exp1.value));explanations.low.values[i]=explanations.low.values[i].slice(0,results.nbExplanations);explanations.high.values[i].sort((exp1,exp2)=>Math.abs(exp2.value)-Math.abs(exp1.value));explanations.high.values[i]=explanations.high.values[i].slice(0,results.nbExplanations)}explanations.low.index.sort((i1,i2)=>results.predictions[i1]-results.predictions[i2]);explanations.high.index.sort((i1,i2)=>results.predictions[i2]-results.predictions[i1]);return explanations}function findAnIdentifier(){const perFeature=$scope.modelData.preprocessing.per_feature;let defaultIdentifier;for(const feature in perFeature){if(defaultIdentifier===undefined||feature<defaultIdentifier){defaultIdentifier=feature}if(perFeature[feature].autoReason==="REJECT_IDENTIFIER"){return feature}}return defaultIdentifier}function getExplanations(){const mesId=$stateParams.mesId||$scope.mesId;const evaluationId=$stateParams.evaluationId||$scope.evaluationId;if(mesId){DataikuAPI.modelevaluations.getIndividualExplanations(FullModelLikeIdUtils.buildModelEvaluationFmeFromComponents(ActiveProjectKey.get(),mesId,evaluationId)).success(allResults=>{formatExplanationResults(allResults)})}else{DataikuAPI.ml.prediction.getIndividualExplanations($stateParams.fullModelId||$scope.fullModelId).success(allResults=>{formatExplanationResults(allResults)})}}function formatExplanationResults(explanationResults){if(explanationResults.perClass){$scope.perClassResults=explanationResults.perClass;updateResultsWithClass($scope.selectedClass)}$scope.puppeteerHook_elementContentLoaded=true}function updateResultsWithClass(className){if($scope.perClassResults){$scope.results=$scope.perClassResults[$scope.isMulticlass()?className:"unique"];if($scope.results){$scope.uiState.nbExplanations=$scope.results.nbExplanations;$scope.computationParams={...$scope.computationParams,sample_size:$scope.results.nbRecords,random_state:$scope.results.randomState};$scope.uiState.method=$scope.results.method;$scope.selectedRange={from:$scope.results.lowPredictionsBoundary,to:$scope.results.highPredictionsBoundary};$scope.explanations=sortAndSplitExplanations($scope)}}}$scope.exportExplanations=function(){const exportColumns=Object.keys($scope.results.observations).map(feature=>{return{name:feature,type:"string"}});exportColumns.push({name:$scope.isRegression()?"predictions":"probas",type:"string"});exportColumns.push({name:"explanations",type:"string"});const indices=[...$scope.explanations.high.index,...$scope.explanations.low.index];const data=[];for(let i=0;i<indices.length;i++){const newRows=[];for(const col of Object.keys($scope.results.observations)){newRows.push($scope.results.observations[col][i])}newRows.push($scope.results.predictions[i]);const explanationRow={};const explanations=$scope.explanations.low.index.includes(i)?$scope.explanations.low.values[i]:$scope.explanations.high.values[i];for(const explanation of explanations){explanationRow[explanation.featureName]=explanation.value}newRows.push(JSON.stringify(explanationRow));data.push(newRows)}ExportUtils.exportUIData($scope,{name:"Individual explanations for model:"+$scope.modelData.userMeta.name,columns:exportColumns,data:data},"Export explanations")};$scope.$watch("selectedRange.to",(newValue,oldValue)=>{if(oldValue!==newValue){setNumberOfRowsInRightBrush()}});$scope.$watch("selectedRange.from",(newValue,oldValue)=>{if(oldValue!==newValue){setNumberOfRowsInLeftBrush()}});$scope.$watch("computationParams.sample_size",()=>{setNumberOfRowsInLeftBrush();setNumberOfRowsInRightBrush()})});app.factory("ExplanationBarUtils",function(){return{computeExplanationBarWidthFunc:function(explanationBarMaxWidth){return(higherExplanation,currentExplanation)=>{const width=Math.trunc(Math.abs(currentExplanation/higherExplanation)*explanationBarMaxWidth);return width===0?1:width}},computeExplanationXBarPositionFunc:function(explanationBarMaxWidth,explanationBarContainerWidth){return(higherExplanation,currentExplanation)=>{const orientatedWidth=Math.trunc(currentExplanation/Math.abs(higherExplanation)*explanationBarMaxWidth);if(orientatedWidth>0){return Math.trunc(explanationBarContainerWidth/2)}else{return Math.trunc(explanationBarContainerWidth/2+orientatedWidth)}}}}});app.directive("individualExplanationCards",["$timeout","CreateModalFromTemplate","ExplanationBarUtils","PromptUtils",function($timeout,CreateModalFromTemplate,ExplanationBarUtils,PromptUtils){return{restrict:"E",templateUrl:"/templates/ml/prediction-model/individual_explanation_cards.html",scope:{selectedColumn:"=",results:"=",isRegression:"=",explanations:"=",imageSettings:"="},link:function(scope){scope.explanationsHidden=[];scope.featuresShown=[];scope.subtitle=scope.isRegression?"Prediction":"Probability";const barMaxWidth=40;scope.barContainerWidth=100;scope.getBarWidth=ExplanationBarUtils.computeExplanationBarWidthFunc(barMaxWidth);scope.getXBarPosition=ExplanationBarUtils.computeExplanationXBarPositionFunc(barMaxWidth,scope.barContainerWidth);scope.toggleExplanations=function(index){scope.explanationsHidden[index]=!scope.explanationsHidden[index]};scope.toggleFeatures=function(index){scope.featuresShown[index]=!scope.featuresShown[index]};if(scope.imageSettings){let loadedImageCount=0;scope.showLargeImages=true;scope.paths=scope.results?.observations[scope.selectedColumn];scope.folderId=scope.imageSettings.managedFolderSmartName;scope.getImageUrl=path=>PromptUtils.getImageUrl(path,scope.folderId);scope.openImage=function(index){const modalScope=scope.$new();modalScope.paths=scope.paths;modalScope.selectedIndex=index;modalScope.getImageUrl=scope.getImageUrl;modalScope.showLargeImages=scope.showLargeImages;CreateModalFromTemplate("/templates/promptstudios/prompt-image-modal.html",modalScope,null,function(newScope){newScope.onItemChange=function(newIndex){$timeout(()=>newScope.selectedIndex=newIndex)}})};scope.handleImageLoad=()=>{loadedImageCount++}}}}}])})();(function(){"use strict";var app=angular.module("dataiku.ml.explainability");app.controller("InteractiveScoringController",function($scope,$timeout,$q,DataikuAPI,WT1,Debounce,ExplanationBarUtils,WhatIfRouter,WhatIfView,localStorageService,CreateModalFromTemplate,ClipboardUtils,ActivityIndicator,ExportUtils,Dialogs,openDkuPopin,epochShift,ExplorationLocalStore,OutcomeOptimizationSpecialTarget,FullModelLikeIdUtils,SpinnerService,FutureWatcher,FeaturesDistributionAdapter,NO_TARGET_CLASS,InteractiveModelCommand,LoggerProvider,WhatIfFeaturesSortingFactory,WhatIfFormattingService){const logger=LoggerProvider.getLogger("ml.interactive-scoring");if(!$scope.modelData){return}const perFeature=$scope.modelData.preprocessing.per_feature;const authorizedTypes=["CATEGORY","NUMERIC","TEXT","VECTOR","IMAGE"];const authorizedRoles=["INPUT"];const fullModelId=$scope.fmi=FullModelLikeIdUtils.getFmi($scope);const backendFormat="YYYY-MM-DDTHH:mm:ss.SSS";const scorePrefix="proba_";const OTHERS_COLOR="#ddd";const computationStatus={DONE:"DONE",COMPUTING:"COMPUTING",ABORTED:"ABORTED",ERROR:"ERROR"};const LOCAL_STORAGE_CACHING_ENABLED=true;const LOCAL_STORAGE_VERSION="v2";const baseKey=`dku.ml.interactivescoring.${LOCAL_STORAGE_VERSION}`;let LOCAL_STORAGE_BUCKET_KEY,LOCAL_STORAGE_EXPLANATION_PARAMS_KEY,LOCAL_STORAGE_UI_STATE_KEY;if($scope.insight&&$scope.insight.id){LOCAL_STORAGE_BUCKET_KEY=`${baseKey}.insight.${$scope.insight.id}.bucket`;LOCAL_STORAGE_EXPLANATION_PARAMS_KEY=`${baseKey}.insight.${$scope.insight.id}.explanationParams`;LOCAL_STORAGE_UI_STATE_KEY=`${baseKey}.insight.${$scope.insight.id}.uiState`}else{LOCAL_STORAGE_BUCKET_KEY=`${baseKey}.${fullModelId}.bucket`;LOCAL_STORAGE_EXPLANATION_PARAMS_KEY=`${baseKey}.${fullModelId}.explanationParams`;LOCAL_STORAGE_UI_STATE_KEY=`${baseKey}.${fullModelId}.uiState`}$scope.userFeatures=null;let currentComputation={COMPARATOR:{SCORING:{status:undefined,runningJobId:null,nextComputation:null},EXPLANATIONS:{status:undefined,runningJobId:null,nextComputation:null}},MAIN:{SCORING:{status:undefined,runningJobId:null,nextComputation:null},EXPLANATIONS:{status:undefined,runningJobId:null,nextComputation:null}}};$scope.ignoreFeatureTooltip="Ignore feature: don't specify a value to the model";$scope.formatProba=proba=>d3.format(",.2f")(proba*100);$scope.getNoScoreReason=function(){if($scope.allFeaturesEmpty()){return"Set at least one feature value to compute the prediction"}if(!$scope.allEnabledImageFeaturesFilled()){return"Upload an image for each enabled image feature to compute a prediction"}if($scope.isCurrentViewAborted(InteractiveModelCommand.SCORING)){return"Aborted task: Change a feature value to recompute the prediction"}return"This row may have been ignored by the preparation script or the model."};$scope.getNoExplanationReason=function(){if($scope.getExplanationIncompatibility()){return $scope.getExplanationIncompatibility()}if(!$scope.explanationParams.enabled){return"Check option to compute features importance"}if($scope.allFeaturesEmpty()){return"Set at least one feature value to compute features importance"}if($scope.isCurrentViewAborted(InteractiveModelCommand.EXPLANATIONS)){return"Aborted task: Change a feature value to recompute features importance"}return"This row may have been ignored by the preparation script or the model."};$scope.getExplanationIncompatibility=function(){if($scope.modelData.coreParams.backendType==="KERAS"){return"Cannot compute explanations for a Deep learning model"}if(Object.values($scope.modelData.preprocessing.per_feature).some(feature=>feature.role=="INPUT"&&feature.type=="IMAGE"&&feature.image_handling=="EMBEDDING_EXTRACTION")){return"Cannot compute explanations for a model with an image embedding extraction preprocessing"}if(!$scope.canComputeUfi()){return $scope.ufiNotAvailableMessage($scope.explanationParams?$scope.explanationParams.method:"")}return null};$scope.uiStateAlreadyLoaded=false;if(LOCAL_STORAGE_CACHING_ENABLED&&localStorageService.get(LOCAL_STORAGE_UI_STATE_KEY)){logger.info("Retrieving saved uiState");$scope.uiState=localStorageService.get(LOCAL_STORAGE_UI_STATE_KEY);$scope.uiStateAlreadyLoaded=true}else{logger.info("Loading uiState");$scope.uiState={features:[],preScriptFeatures:[],applyPreparationScript:null,couldNotRetrieveSchema:false,hasPreparationSteps:false,featureFilterOptions:[]}}const whatIfRouter=$scope.whatIfRouter=WhatIfRouter.build();$scope.WhatIfView=WhatIfView;$scope.InteractiveModelCommand=InteractiveModelCommand;$scope.WhatIfFormattingService=WhatIfFormattingService;$scope.featuresSortingService=WhatIfFeaturesSortingFactory.init();$scope.selection=$scope.featuresSortingService.cleanSelection();$scope.showOtherFeatures=false;$scope.errors={};$scope.labels=[""];$scope.barContainerWidth=350;$scope.compareBarContainerWidth=125;$scope.barMaxWidth=100;$scope.compareBarMaxWidth=50;$scope.getExplanationXBarPosition=ExplanationBarUtils.computeExplanationXBarPositionFunc($scope.barMaxWidth,$scope.barContainerWidth);$scope.getCompareExplanationXBarPosition=ExplanationBarUtils.computeExplanationXBarPositionFunc($scope.compareBarMaxWidth,$scope.compareBarContainerWidth);$scope.pickerFormat="YYYY-MM-DD HH:mm";$scope.score=undefined;$scope.explanations=undefined;$scope.explanationParams=localStorageService.get(LOCAL_STORAGE_EXPLANATION_PARAMS_KEY)||{nbExplanations:5,method:"ICE",enabled:$scope.getExplanationIncompatibility()===null};$scope.bucket=localStorageService.get(LOCAL_STORAGE_BUCKET_KEY)||[];$scope.bucketCharts=[];$scope.scrollToLastItem=false;$scope.sendBasicWT1Event=function(){WT1.event("interactive-scoring",{explanationParams:$scope.explanationParams,applyPreparationScript:$scope.uiState.applyPreparationScript})};$scope.hasPrediction=function(score){if(!score)return false;if(!score.override)return true;return!(score.override.rulePolicy==="DECLINED")};let distributions=null;FeaturesDistributionAdapter.init(fullModelId).then(_distributions=>{distributions=_distributions}).finally(()=>{$scope.$digest()});$scope.getExplorationDisabledReason=()=>{if($scope.modelData.backendType==="KERAS"){return"This option is not available for deep learning models"}if($scope.isPartitionedModel()&&$scope.isOnPartitionedBaseModel()){return"Switch to a specific partition to use exploration tools"}if($scope.getAlgorithm().endsWith("_ENSEMBLE")){return"This option is not available for ensemble models"}if($scope.uiState.applyPreparationScript){return'This option is not available when "Apply preparation script" is enabled'}if($scope.modelData.modeling.skipExpensiveReports){return"This option is not available because computation of expensive reports was disabled"}if(!distributions){return"This model is too old, retrain it to use exploration tools"}if($scope.getFeatures().some(feature=>feature.editMode==="UNSET")){return"This option is not available when some features are ignored"}if(!$scope.hasPrediction($scope.score)){return"This option is not available when the prediction is not valid"}return null};$scope.openExplorationConstraints=()=>{$scope.featuresSortingService.setPerFeatureDistributionType(distributions);const reference={};const explorationLocalStore=$scope.explorationLocalStore=ExplorationLocalStore(fullModelId,$scope.insight);for(const feature of $scope.getFeatures()){reference[feature.name]=feature.value}if($scope.isClassification()){const predictionColorMap=Object.fromEntries($scope.predictions.filter(pc=>pc.color!==OTHERS_COLOR).map(pc=>[pc.name,pc.color]));explorationLocalStore.setPredictionColorMap(predictionColorMap);explorationLocalStore.setTarget(NO_TARGET_CLASS)}else{explorationLocalStore.setTarget(OutcomeOptimizationSpecialTarget.MIN)}const formattedScore={...$scope.score};formattedScore["prediction"]=WhatIfFormattingService.formatPrediction($scope.modelData,$scope.score.prediction);explorationLocalStore.setScore(formattedScore);explorationLocalStore.setReference(reference);whatIfRouter.openConstraints()};$scope.abortAllComputations=()=>{for(const view in currentComputation){for(const computationType in currentComputation[view]){abortComputationIfRunning(view,computationType)}}};$scope.openComparator=()=>{whatIfRouter.openComparator();WT1.event("interactive-scoring-compare-button",{itemCount:$scope.bucket.length});if($scope.bucket.length>0){computeAll($scope.bucket,null)}setTimeout(()=>$scope.scrollToLastItem=false)};$scope.changeEditMode=function(feature,newMode,triggerCompute=true){feature.editMode=newMode;const featureOldValue=feature.value;switch(newMode){case"UNSET":feature.value=null;break;case"DOMAIN":if(feature.type==="NUMERIC"||feature.type==="DATE"){if(feature.value===null||isNaN(feature.value)){feature.value=feature.defaultValue}else if(feature.value>feature.max){feature.value=feature.max}else if(feature.value<feature.min){feature.value=feature.min}}else if(feature.type==="CATEGORY"){if(!feature.possibleValues.includes(feature.value)){feature.value=feature.defaultValue}}else if(feature.type==="IMAGE"){if(feature.value===null){feature.value=feature.defaultValue}}break;case"RAW":if(feature.type!=="NUMERIC"){if(feature.value===null){feature.value=""}}break}if(triggerCompute&&featureOldValue!==feature.value){onFeatureChange()}};$scope.toggleOtherFeatures=function(){$scope.showOtherFeatures=!$scope.showOtherFeatures};function isViewComputing(view,computationType=null){if(computationType!==null){return currentComputation[view][computationType].status===computationStatus.COMPUTING}return Object.values(currentComputation[view]).some(computationType=>computationType.status===computationStatus.COMPUTING)}$scope.isCurrentViewComputing=function(computationType){return isViewComputing(whatIfRouter.getCurrentView(),computationType)};$scope.isSomethingComputing=function(){return Object.keys(currentComputation).some(view=>isViewComputing(view))};function isViewAborted(view,computationType=null){if(computationType!==null){return currentComputation[view][computationType].status===computationStatus.ABORTED}return Object.values(currentComputation[view]).some(computationType=>computationType.status===computationStatus.ABORTED)}$scope.isCurrentViewAborted=function(computationType=null){return isViewAborted(whatIfRouter.getCurrentView(),computationType)};$scope.fileUploaded=function(event,feature){const file=event.srcElement.files[0];const reader=new FileReader;reader.onloadend=function(event){feature.value=event.target.result.split(",")[1];$scope.onFeatureChange()};reader.readAsDataURL(file)};$scope.getFeatures=function(){return getFeaturesFromUiState($scope.uiState)};$scope.allFeaturesEmpty=function(){return $scope.getFeatures().every(f=>f.value==undefined)};$scope.allEnabledImageFeaturesFilled=function(){return $scope.getFeatures().filter(f=>f.type=="IMAGE").every(f=>f.editMode=="UNSET"||f.value!=undefined)};$scope.getPredictedClassProba=function(score){if($scope.isClassification()){return $scope.formatProba(score[scorePrefix+score.prediction])}};$scope.getPositiveClassProba=function(score){if($scope.isBinaryClassification()){return $scope.formatProba(score[scorePrefix+$scope.getPositiveClass()])}};$scope.getProbaForBucketItem=function(score){if($scope.isMulticlass()){return $scope.getPredictedClassProba(score)}else if($scope.isBinaryClassification()){return $scope.getPositiveClassProba(score)}};function getOtherFeatures(){if($scope.tile){if($scope.tile.tileParams.advancedOptions.interactiveScoring){$scope.userFeatures=$scope.tile.tileParams.advancedOptions.interactiveScoring.featuresOrder;return $scope.getFeatures().filter(f=>!$scope.userFeatures.includes(f.name)&&f.type!=="PART_DIM").map(f=>f.name)}else{return[]}}}$scope.hasFilteredOutFeatures=function(){const otherFeatures=getOtherFeatures();return $scope.userFeatures&&otherFeatures&&otherFeatures.length};$scope.keepOnlyMainFeatures=function(feature){if($scope.userFeatures){return $scope.userFeatures.includes(feature.name)}return!$scope.keepOnlyPartDimensions(feature)};$scope.keepOnlyPartDimensions=function(feature){return feature.type=="PART_DIM"};$scope.keepOtherFeatures=function(feature){const otherFeatures=getOtherFeatures();if(otherFeatures){return otherFeatures.includes(feature.name)}return false};$scope.getPositiveClass=function(){return $scope.modelData.classes?$scope.modelData.classes[1]:""};const setUserDefinedOrdersIfNecessary=()=>{if(!$scope.userFeatures){return}if($scope.uiState.features){$scope.uiState.features.forEach(feature=>feature.userDefinedOrder=$scope.userFeatures.indexOf(feature.name))}if($scope.uiState.preScriptFeatures){$scope.uiState.preScriptFeatures.forEach(feature=>feature.userDefinedOrder=$scope.userFeatures.indexOf(feature.name))}$scope.$broadcast("refresh-list")};function getFeaturesFromUiState(uiState){return uiState.applyPreparationScript?uiState.preScriptFeatures:uiState.features}function formatFeatures(features){return features.map(feature=>({name:feature.name,value:feature.value,type:feature.type,distributionType:feature.distributionType,importance:feature.importance}))}function roundToXDigits(value,nDigits){return parseFloat(value.toFixed(nDigits))}function getFeatureInfo(collectorData,featuresStorageType,featureName,featureType){let defaultValue;let defaultEditMode="DOMAIN";if(!(featureName in featuresStorageType)||!(featureName in collectorData.per_feature)){return{value:"",editMode:"RAW",defaultEditMode:"RAW"}}switch(featureType){case"NUMERIC":{const isTemporal=["date","dateonly","datetimenotz"].indexOf(featuresStorageType[featureName])>=0;const isInteger=featuresStorageType[featureName]==="bigint";const defaultNumValue=collectorData.per_feature[featureName].stats.median;const min=collectorData.per_feature[featureName].stats.min;const max=collectorData.per_feature[featureName].stats.max;const nDecimals=isInteger?0:WhatIfFormattingService.getSmartNumberDigits(min,max);defaultValue=isTemporal?moment.unix(defaultNumValue-epochShift).utc().format($scope.pickerFormat):roundToXDigits(defaultNumValue,nDecimals);return{value:defaultValue,min:roundToXDigits(min,nDecimals),max:roundToXDigits(max,nDecimals),type:isTemporal?"DATE":featureType,editMode:defaultEditMode,defaultValue:defaultValue,defaultEditMode:defaultEditMode,nDecimals:nDecimals}}case"CATEGORY":{const possibleValues=[...collectorData.per_feature[featureName].category_possible_values||[]];if(perFeature[featureName].dummy_drop==="DROP"){const doppedModality=collectorData.per_feature[featureName].dropped_modality;if(doppedModality!==undefined&&doppedModality!=="__DKU_N/A__"){possibleValues.push(doppedModality)}}defaultValue=collectorData.per_feature[featureName].stats.mostFrequentValue;defaultEditMode=possibleValues&&possibleValues.length?"DOMAIN":"RAW";return{value:defaultValue,editMode:defaultEditMode,defaultValue:defaultValue,possibleValues:possibleValues,defaultEditMode:defaultEditMode}}case"VECTOR":{defaultEditMode="RAW";const vector=[];vector.length=collectorData.per_feature[featureName].vector_length||0;defaultValue="["+vector.fill(0).join(", ")+"]";return{value:defaultValue,editMode:defaultEditMode,defaultValue:defaultValue,defaultEditMode:defaultEditMode}}case"TEXT":defaultEditMode="RAW";return{value:"",editMode:defaultEditMode,defaultEditMode:defaultEditMode};case"IMAGE":return{value:undefined,defaultValue:undefined,editMode:defaultEditMode,defaultEditMode:defaultEditMode}}}function formatFeatureDomains(records){return records.map(features=>{const formattedRecord={};features.forEach(feature=>{if(feature.value!==null){formattedRecord[feature.name]=feature.type=="DATE"?moment(feature.value).utc().format(backendFormat):feature.value}});return formattedRecord})}function generateChartData(){if(!$scope.score)return;if($scope.isClassification()){const MAX_CLASSES=6;$scope.predictions=getPredictionChartData($scope.score,MAX_CLASSES);$scope.threshold=$scope.isBinaryClassification()?$scope.modelData.userMeta.activeClassifierThreshold:undefined}else if($scope.isRegression()){$scope.prediction=$scope.score.prediction;let predictions;if($scope.modelData.predictionInfo){predictions=$scope.modelData.predictionInfo.predictions}else{predictions=$scope.modelData.perf.scatterPlotData.y}const rangeLimit={min:0,max:1};rangeLimit.max=d3.max(predictions);rangeLimit.min=d3.min(predictions);const x=d3.scale.linear().domain([rangeLimit.min,rangeLimit.max]).nice();const data=d3.layout.histogram().frequency(0).bins(x.ticks(20))(predictions);$scope.axes={x:data.map(d=>d.x),ys:[data.map(d=>d.y)]};$scope.xm=[$scope.prediction];$scope.dataAxes=["Prediction","Prediction density"]}}function sortAndFormatExplanations(results){const allFormattedExplanations=[];for(const result of results){const formattedExplanations=[];if(result===null||!result.explanation||!$scope.hasPrediction(result.score)){allFormattedExplanations.push(null)}else{for(const featureName in result.explanation){formattedExplanations.push({feature:featureName,value:result.explanation[featureName]})}const sortedExplanations=formattedExplanations.sort((exp1,exp2)=>Math.abs(exp2.value)-Math.abs(exp1.value));$scope.topExplanationValue=sortedExplanations[0].value;sortedExplanations.forEach(explanation=>{explanation.barWidthRatio=ExplanationBarUtils.computeExplanationBarWidthFunc($scope.barMaxWidth)($scope.topExplanationValue,explanation.value)/$scope.barMaxWidth});allFormattedExplanations.push(sortedExplanations)}}return allFormattedExplanations}$scope.onFeatureChange=Debounce().withDelay(200,200).withScope($scope).wrap(onFeatureChange);const computeScoreDebounced=Debounce().withDelay(200,200).withScope($scope).wrap(computeScore);const computeExplanationsDebounced=Debounce().withDelay(1e3,1e3).withScope($scope).wrap(computeExplanations);if($scope.tile&&$scope.tile.tileParams.advancedOptions.interactiveScoring){$scope.userFeatures=$scope.tile.tileParams.advancedOptions.interactiveScoring.featuresOrder}if($scope.uiStateAlreadyLoaded){$scope.featuresSortingService.setPerFeatureIndex($scope.uiState.schemaColumns);$scope.featuresSortingService.setPerFeatureImportance($scope.uiState.perFeatureImportance);angular.extend($scope.selection,$scope.featuresSortingService.getDefaultSelection());if($scope.userFeatures){$scope.selection.orderQuery="userDefinedOrder";$scope.selection.orderReversed=false}onFeatureChange();$scope.sendBasicWT1Event()}else{Promise.all([DataikuAPI.ml.prediction.getCollectorData(fullModelId),DataikuAPI.ml.prediction.getColumnImportance(fullModelId),DataikuAPI.ml.prediction.getSplitDesc(fullModelId)]).then(([collectorDataResp,columnImportanceResp,splitDescResp])=>{const collectorData=collectorDataResp.data;let perFeatureImportance;$scope.uiState.schemaColumns=splitDescResp.data.schema.columns;if(columnImportanceResp.data){const columns=columnImportanceResp.data.columns;const importances=columnImportanceResp.data.importances;perFeatureImportance={};columns.forEach((col,i)=>perFeatureImportance[col]=importances[i]);$scope.uiState.perFeatureImportance=perFeatureImportance;$scope.featuresSortingService.setPerFeatureImportance($scope.uiState.perFeatureImportance)}$scope.featuresSortingService.setPerFeatureIndex($scope.uiState.schemaColumns);$scope.uiState.featureFilterOptions=$scope.featuresSortingService.getSortOptions();angular.extend($scope.selection,$scope.featuresSortingService.getDefaultSelection());$scope.uiState.featuresStorageType=Object.fromEntries(splitDescResp.data.schema.columns.map(x=>[x.name,x.type]));$scope.uiState.features=splitDescResp.data.schema.columns.map(column=>column.name).filter(featureName=>featureName in perFeature).filter(featureName=>authorizedTypes.includes(perFeature[featureName].type)&&authorizedRoles.includes(perFeature[featureName].role)).map((name,index)=>({index:index,name:name,type:perFeature[name].type,role:perFeature[name].role,importance:perFeatureImportance?perFeatureImportance[name]:null,...getFeatureInfo(collectorData,$scope.uiState.featuresStorageType,name,perFeature[name].type)}));if($scope.isPartitionedModel()&&$scope.isOnPartitionedBaseModel()){const dimensionNames=$scope.modelData.coreParams.partitionedModel.dimensionNames;const donePartitions=Object.entries($scope.partitionedModelSnippets.partitions.summaries).filter(([_,partition])=>partition.state.endsWith("DONE")).map(([name,_])=>name.split("|"));for(const[index,dimensionName]of dimensionNames.entries()){const possibleValues=[...new Set(donePartitions.map(part=>part[index]))];$scope.uiState.features.push({name:dimensionName,defaultValue:donePartitions[0][index],value:donePartitions[0][index],type:"PART_DIM",possibleValues:possibleValues})}}$scope.uiState.features.forEach(feature=>feature.distributionType=feature.type);if($scope.userFeatures){setUserDefinedOrdersIfNecessary();$scope.selection.orderQuery="userDefinedOrder";$scope.selection.orderReversed=false}DataikuAPI.ml.prediction.getPreparationScript(fullModelId).success(preparationScript=>{$scope.uiState.hasPreparationSteps=preparationScript.steps.some(step=>!step.disabled);if($scope.uiState.hasPreparationSteps){$scope.uiState.applyPreparationScript=true;DataikuAPI.ml.prediction.getInputDatasetSchema(fullModelId).success(schema=>{$scope.uiState.preScriptFeatures=schema.columns.map((col,index)=>{const f=$scope.uiState.features.find(f=>f.name===col.name)||{name:col.name,type:"TEXT",value:"",editMode:"RAW",importance:-1};f.index=index;return f});$scope.uiState.preScriptFeatures.forEach(feature=>feature.distributionType=feature.type);setUserDefinedOrdersIfNecessary();onFeatureChange()}).catch(error=>{if(error.status!=404){setErrorInScope.bind($scope)(error.data,error.status,error.headers)}else{$scope.uiState.applyPreparationScript=false;$scope.uiState.couldNotRetrieveSchema=true;onFeatureChange()}}).finally(()=>{$scope.sendBasicWT1Event()})}else{onFeatureChange();$scope.sendBasicWT1Event()}}).catch(setErrorInScope.bind($scope))}).catch(setErrorInScope.bind($scope))}function protectBucketFromConflicts(needPreparationScript){return new Promise((resolve,reject)=>{if($scope.bucket.length!==0&&$scope.bucket[0].applyPreparationScript!==null&&needPreparationScript!==null&&$scope.bucket[0].applyPreparationScript!==needPreparationScript){CreateModalFromTemplate("templates/ml/prediction-model/interactive-scoring-conflict-dialog.html",$scope,null,function(newScope){newScope.showTips=true;newScope.pasteAnyway=()=>{newScope.dismiss();$scope.bucket=[];resolve()};newScope.cancel=()=>{newScope.dismiss();reject()}})}else{resolve()}})}function safelyPasteInBucket(pastedItems){const needPreparationScript=pastedItems[0].applyPreparationScript;protectBucketFromConflicts(needPreparationScript).then(()=>{pasteInBucket(pastedItems)})}function addToBucket(){const newItem={name:"",score:$scope.score,explanation:$scope.explanations,features:$scope.getFeatures(),applyPreparationScript:$scope.uiState.applyPreparationScript};newItem.features=formatFeatures(newItem.features);$scope.scrollToLastItem=true;$scope.bucket.push(newItem);ActivityIndicator.success("Added to comparator.");$scope.$apply()}$scope.safelyAddToBucket=function(){const needPreparationScript=$scope.uiState.applyPreparationScript;protectBucketFromConflicts(needPreparationScript).then(()=>{addToBucket()})};$scope.removeFromBucket=function(index){$scope.bucket[index].removing=true;$timeout(()=>{$scope.bucket.splice(index,1)},500)};$scope.removeAllFromBucket=function(){Dialogs.confirm($scope,"Clear all items","Are you sure you want to clear all items in the comparator?").then(function(){$scope.bucket=[];ActivityIndicator.success("All items cleared from comparator.")})};function formatItemsForLocalStorage(items){let formatedItems=angular.copy(items);return formatedItems.map(item=>{Object.keys(item).forEach(key=>{if(key.startsWith("$")){delete item[key]}});item.features=formatFeatures(item.features);item.score=undefined;item.explanation=undefined;return item})}function getPredictionChartData(predictions,maxClasses){if(!$scope.isClassification())return;let classes=$scope.modelData.classes.filter(pc=>`${scorePrefix}${pc}`in predictions);let colorPalette=$scope.colors.slice(0,classes.length);let chartPredictions=classes.map((pc,index)=>({name:pc,value:predictions[`${scorePrefix}${pc}`],color:colorPalette[index]}));if($scope.isBinaryClassification()){chartPredictions=[chartPredictions[1],chartPredictions[0]]}else{chartPredictions.sort((p1,p2)=>p2.value-p1.value);if(chartPredictions.length>maxClasses){chartPredictions=chartPredictions.slice(0,maxClasses-1);const othersPercentage=1-chartPredictions.reduce((total,prediction)=>total+prediction.value,0);chartPredictions.push({name:"Others",value:othersPercentage,color:OTHERS_COLOR})}}return chartPredictions}$scope.$watch("bucket",function(){localStorageService.set(LOCAL_STORAGE_BUCKET_KEY,formatItemsForLocalStorage($scope.bucket));if($scope.isClassification()){$scope.bucketCharts=$scope.bucket.map(item=>item.score?getPredictionChartData(item.score,3):null)}if($scope.bucket.length>1){const listOfFeatureValues=$scope.bucket[0].features.map((_,colIndex)=>$scope.bucket.map(row=>row.features[colIndex].value));const allEqual=arr=>arr.every(v=>v===arr[0]);for(const[i,featureValues]of listOfFeatureValues.entries()){for(const item of $scope.bucket){item.features[i].greyed=allEqual(featureValues)}}}else if($scope.bucket.length===1){$scope.bucket[0].features.forEach(f=>f.greyed=false)}},true);$scope.$watch("uiState",function(){localStorageService.set(LOCAL_STORAGE_UI_STATE_KEY,$scope.uiState)},true);$scope.$watch("selection.orderQuery",$scope.featuresSortingService.updateSortOrderAfterOptionChange.bind($scope.featuresSortingService));$scope.$on("$destroy",function(){localStorageService.set(LOCAL_STORAGE_BUCKET_KEY,$scope.bucket)});$scope.$watchCollection("userFeatures",setUserDefinedOrdersIfNecessary);const copyType="interactive-scoring";$scope.copyValues=function(items){let copy={type:copyType,version:$scope.$root.appConfig.version.product_version,samples:items.map(item=>({name:item.name,features:formatFeatures(item.features),applyPreparationScript:item.applyPreparationScript}))};ClipboardUtils.copyToClipboard(JSON.stringify(copy,null,2),`Copied ${items.length} item${items.length===1?"":"s"} to clipboard.`)};$scope.disableAllFeatures=function(){$scope.getFeatures().forEach(feature=>$scope.changeEditMode(feature,"UNSET",false));onFeatureChange()};$scope.resetAllFeaturesToDefault=function(){$scope.getFeatures().forEach(feature=>{feature.value=feature.defaultValue;feature.editMode=feature.defaultEditMode});onFeatureChange()};$scope.openPasteDialog=function(pasteType){let newScope=$scope.$new();CreateModalFromTemplate("/templates/ml/prediction-model/interactive_scoring_paste_modal.html",newScope,"PasteModalController",function(modalScope){modalScope.showTips=true;modalScope.copyType="interactive-scoring";modalScope.itemKey="samples";modalScope.pasteSingle=pasteType===WhatIfView.MAIN;modalScope.pasteItems=pasteType===WhatIfView.MAIN?pasteFeatures:safelyPasteInBucket;modalScope.validateData=validatePastedData;modalScope.applyGenericFormat=formatCopiedData})};function formatCopiedData(data){if(Array.isArray(data.samples)){return data}else{return{type:copyType,version:$scope.$root.appConfig.version.product_version,samples:[{name:"",features:Object.entries(data).map(([name,value])=>{return{name:name,value:value}}),applyPreparationScript:null}]}}}$scope.openPasteModalFromKeydown=function(data){try{data=JSON.parse(data)}catch(e){}if(data&&!Array.isArray(data.samples)){data=formatCopiedData(data);if(!validatePastedData(data.samples)){return}}if(data&&data.samples&&data.samples.length&&data.type===copyType){let newScope=$scope.$new();CreateModalFromTemplate("/templates/ml/prediction-model/interactive_scoring_paste_modal.html",newScope,"PasteModalController",function(modalScope){modalScope.uiState.editMode=false;modalScope.uiState.items=data.samples;modalScope.pasteSingle=whatIfRouter.getCurrentView()===WhatIfView.MAIN;modalScope.pasteItems=whatIfRouter.getCurrentView()===WhatIfView.MAIN?pasteFeatures:safelyPasteInBucket;modalScope.validateData=validatePastedData})}};$scope.getCurrentItem=function(){return{name:"",features:$scope.getFeatures(),applyPreparationScript:$scope.uiState.applyPreparationScript}};$scope.keydownCopy=function(event){if(whatIfRouter.getCurrentView()===WhatIfView.MAIN&&isViewComputing(WhatIfView.MAIN)){$scope.copyValues([$scope.getCurrentItem()]);event.currentTarget.focus()}};function validatePastedData(pastedItems){const allFeatures=$scope.getFeatures();return pastedItems.every(item=>{return item.features.some(feature=>{return allFeatures.find(f=>feature.name===f.name)})})}function pasteFeatures(pastedItems){if(!pastedItems.length)return;const firstItem=pastedItems[0];$scope.uiState.applyPreparationScript=firstItem.applyPreparationScript;$scope.getFeatures().forEach(feature=>{const pastedFeature=firstItem.features.find(f=>feature.name===f.name);const pastedValue=pastedFeature?pastedFeature.value:null;feature.editMode=getNewEditMode(feature,pastedValue);feature.value=pastedValue});onFeatureChange();WT1.event("interactive-scoring-paste",{nbItems:pastedItems.length,type:"features"})}function getNewEditMode(feature,newValue){if(newValue!==null){if(feature.type==="NUMERIC"){if(newValue<feature.min||newValue>feature.max){return"RAW"}}else if(feature.type==="CATEGORY"){if(!feature.possibleValues.includes(newValue)){return"RAW"}}return"DOMAIN"}return"UNSET"}function pasteInBucket(pastedItems){const featureNames=$scope.getFeatures().map(feature=>feature.name);const newItems=[];pastedItems.forEach(item=>{newItems.push({name:item.name,features:featureNames.map(featureName=>{const matchedFeature=item.features.find(f=>f.name===featureName)||{};return{name:featureName,value:matchedFeature.value,type:matchedFeature.type}}),applyPreparationScript:item.applyPreparationScript})});const newBucket=$scope.bucket.concat(angular.copy(newItems));computeAll(newBucket,null,()=>{$scope.bucket=newBucket;$scope.scrollToLastItem=whatIfRouter.getCurrentView()===WhatIfView.COMPARATOR;ActivityIndicator.success(`${newItems.length} item${newItems.length===1?"":"s"} successfully pasted.`)});WT1.event("interactive-scoring-paste",{nbItems:pastedItems.length,type:"comparator"})}$scope.exportComparator=function(){const featureColumns=$scope.bucket[0].features.map(feature=>({name:feature.name,type:$scope.uiState.featuresStorageType[feature.name]||"string"}));const nameColumn={name:"score_name",type:"string"};let predictionColumns=[];if($scope.isClassification()){predictionColumns=[...$scope.modelData.classes.map(c=>({name:`${scorePrefix}${c}`,type:"string"})),{name:"prediction",type:"string"}]}else if($scope.isRegression()){predictionColumns=[{name:"prediction",type:$scope.uiState.featuresStorageType[$scope.modelData.coreParams.target_variable]}]}const explanationColumns=[{name:"explanations",type:"string"},{name:"explanation_method",type:"string"}];const withOverrideInfo=$scope.bucket.some(item=>item.score.override);const data=$scope.bucket.map(item=>{const featureValues=featureColumns.map(column=>{const feature=item.features.find(f=>f.name===column.name);return feature?feature.value:null});let predictions=[item.score?item.score.prediction[0]:null];if($scope.isClassification()){predictions=[...$scope.modelData.classes.map(c=>item.score?item.score[`${scorePrefix}${c}`]:null),...predictions]}let values=[...featureValues,item.name,...predictions];if($scope.getExplanationIncompatibility()==null){const listOfExplanations=item.explanation.map(f=>{return{[f.feature]:f.value}});const explanationsStr=JSON.stringify(Object.assign({},...listOfExplanations));values=[...values,explanationsStr,$scope.explanationParams.method]}if(withOverrideInfo){values.push(JSON.stringify(item.score.override))}return values});let columns=[...featureColumns,nameColumn,...predictionColumns];if($scope.getExplanationIncompatibility()==null){columns=[...columns,...explanationColumns]}if(withOverrideInfo){columns.push({name:"override",type:"string"})}ExportUtils.exportUIData($scope,{name:"Interactive scoring for model: "+$scope.modelData.userMeta.name,columns:columns,data:data},"Export Interactive Scoring");WT1.event("interactive-scoring-export-button",{explanationMethod:$scope.explanationParams.method,nbItems:data.length})};function canCompute(){return!($scope.uiState.applyPreparationScript&&$scope.uiState.couldNotRetrieveSchema)&&!$scope.allFeaturesEmpty()&&$scope.allEnabledImageFeaturesFilled()}function compute(actionFn,params,view,computationType,callback){if(!isViewComputing(view,computationType)){currentComputation[view][computationType].status=computationStatus.COMPUTING;$scope.errors[computationType]=null;currentComputation[view][computationType].nextComputation=null;actionFn(params).then(function(data){if(!isViewAborted(view,computationType)){currentComputation[view][computationType].status=computationStatus.DONE;if(currentComputation[view][computationType].nextComputation){compute(actionFn,currentComputation[view][computationType].nextComputation,view,computationType,callback)}else{callback(data);$scope.$digest()}}}).catch(error=>{$scope.errors[computationType]=error;currentComputation[view][computationType].status=computationStatus.ERROR;if(currentComputation[view][computationType].nextComputation){compute(actionFn,currentComputation[view][computationType].nextComputation,view,computationType,callback)}})}else{currentComputation[view][computationType].nextComputation=$scope.uiState}}function makeComputationPromise(apiCall,view,computationType){return new Promise(function(resolve,reject){function err(...args){currentComputation[view][computationType].runningJobId=null;setErrorInScope.apply($scope,args);reject(...args)}apiCall.noSpinner().success(function(initialResponse){if(initialResponse.hasResult){resolve(prepareOverrideInfoFromResults(initialResponse.result))}else{currentComputation[view][computationType].runningJobId=initialResponse.jobId;FutureWatcher.watchJobId(initialResponse.jobId).success(doneResponse=>{currentComputation[view][computationType].runningJobId=null;resolve(prepareOverrideInfoFromResults(doneResponse.result))}).error(err)}}).error(err)})}function computeScore(){const view=whatIfRouter.getCurrentView();const promiseFn=params=>{const computationParams={applyPreparationScript:params.applyPreparationScript,type:InteractiveModelCommand.SCORING};return makeComputationPromise(DataikuAPI.interactiveModel.compute(fullModelId,computationParams,formatFeatureDomains([getFeaturesFromUiState(params)])),view,computationParams["type"])};return compute(promiseFn,$scope.uiState,view,InteractiveModelCommand.SCORING,data=>{if($scope.allFeaturesEmpty()){$scope.score=null}else{$scope.score=data[0]===null?null:data[0].score;generateChartData()}})}function computeExplanations(){const currView=whatIfRouter.getCurrentView();const promiseFn=params=>{const computationParams={applyPreparationScript:params.applyPreparationScript,explanationMethod:$scope.explanationParams.method,nExplanations:$scope.explanationParams.nbExplanations,type:InteractiveModelCommand.EXPLANATIONS};return makeComputationPromise(DataikuAPI.interactiveModel.compute(fullModelId,computationParams,formatFeatureDomains([getFeaturesFromUiState(params)])),currView,computationParams["type"])};return compute(promiseFn,$scope.uiState,currView,InteractiveModelCommand.EXPLANATIONS,function(data){const allExplanations=sortAndFormatExplanations(data);if($scope.allFeaturesEmpty()){$scope.explanations=null}else{$scope.explanations=allExplanations!==null&&allExplanations.length?allExplanations[0]:[]}})}async function computeAll(bucketItems,currentFeatures,callback){const allFeatures=bucketItems.map(item=>item.features);if(currentFeatures){allFeatures.push(currentFeatures)}const view=whatIfRouter.getCurrentView();const computationParams={applyPreparationScript:$scope.uiState.applyPreparationScript};let computePromise;const records=formatFeatureDomains(allFeatures);if($scope.getExplanationIncompatibility()){computationParams["type"]=InteractiveModelCommand.SCORING;computePromise=makeComputationPromise(DataikuAPI.interactiveModel.compute(fullModelId,computationParams,records),view,computationParams["type"])}else{computationParams["explanationMethod"]=$scope.explanationParams.method;computationParams["nExplanations"]=$scope.explanationParams.nbExplanations;computationParams["type"]=InteractiveModelCommand.EXPLANATIONS;computePromise=makeComputationPromise(DataikuAPI.interactiveModel.compute(fullModelId,computationParams,records),view,computationParams["type"])}currentComputation[view][computationParams["type"]].status=computationStatus.COMPUTING;if(whatIfRouter.getCurrentView()===WhatIfView.COMPARATOR){SpinnerService.lockOnPromise(computePromise)}$q.when(computePromise).then(results=>{if(!isViewAborted(view,computationParams["type"])){currentComputation[view][computationParams["type"]].status=computationStatus.DONE;const scores=results.map(result=>result===null?null:result.score);let explanations=sortAndFormatExplanations(results);if(currentFeatures){$scope.score=scores.pop();$scope.explanations=explanations?explanations.pop():null}bucketItems.forEach((item,index)=>{item.explanation=explanations?explanations[index]:null;item.score=scores[index]});if(callback){callback()}}}).catch(error=>{currentComputation[view][computationParams["type"]].status=computationStatus.ERROR;setErrorInScope.bind($scope)(error.data,error.status,error.headers)})}function abortComputationIfRunning(view,computationType){const jobId=currentComputation[view][computationType].runningJobId;if(jobId!==null){if(view===WhatIfView.MAIN){computationType===InteractiveModelCommand.SCORING?$scope.score=null:$scope.explanations=null}DataikuAPI.futures.abort(jobId).success(function(data){currentComputation[view][computationType].runningJobId=null;currentComputation[view][computationType].status=computationStatus.ABORTED;currentComputation[view][computationType].nextComputation=null})}}function prepareOverrideInfoFromResults(results){results.forEach(result=>{if(result&&result.score&&result.score.override){result.score.override=JSON.parse(result.score.override)}});return results}$scope.onExplanationParamsChange=function(){localStorageService.set(LOCAL_STORAGE_EXPLANATION_PARAMS_KEY,$scope.explanationParams);$scope.explanations=undefined;computeAll($scope.bucket,$scope.getFeatures(),()=>{if(whatIfRouter.getCurrentView()===WhatIfView.MAIN){generateChartData()}$scope.sendBasicWT1Event()})};$scope.explanationDisableToggled=function(){localStorageService.set(LOCAL_STORAGE_EXPLANATION_PARAMS_KEY,$scope.explanationParams);if($scope.explanationParams.enabled){computeExplanations()}else{$scope.explanations=null;$scope.errors[InteractiveModelCommand.EXPLANATIONS]=null}$scope.sendBasicWT1Event()};function onFeatureChange(){if(canCompute()){$scope.explanations=undefined;$scope.score=undefined;computeFeature(true)}else{$scope.explanations=null;$scope.score=null}}async function computeFeature(withDebounce){if(withDebounce){computeScoreDebounced();if(!$scope.getExplanationIncompatibility()&&$scope.explanationParams.enabled){computeExplanationsDebounced()}}else{computeScore();if(!$scope.getExplanationIncompatibility()&&$scope.explanationParams.enabled){computeExplanations()}}}$scope.extractFeatureFromBucketItem=(item,featureName)=>item.features.find(f=>f.name===featureName);$scope.puppeteerHook_elementContentLoaded=true});app.component("interactiveScoringFeatureValue",{template:`
            <div ng-class="{'interactive_scoring__greyed-feature': $ctrl.feature.greyed}">
                <h5 class="font-weight-semi-bold mbot0 mx-textellipsis">{{ $ctrl.feature.name }}</h5>
                <span ng-if="isNull"><i>ignored</i></span>
                <span ng-if="!isNull">
                    <span ng-if="isEmptyOrUndefined"><i>none</i></span>
                    <span ng-if="!isEmptyOrUndefined">
                        <span ng-if="$ctrl.feature.type !== 'IMAGE'">{{ $ctrl.feature.value }}</span>
                        <img ng-if="$ctrl.feature.type === 'IMAGE'" data-ng-src="data:image/png;base64,{{$ctrl.feature.value}}"/>
                    </span>
                </span>
            </div>`,bindings:{feature:"<"},controller:function($scope){this.$onInit=function(){$scope.isNull=this.feature.value===null;$scope.isEmptyOrUndefined=this.feature.value===undefined||this.feature.value===""}}});app.component("whatIfSortingWidget",{template:`
            <div class="std-list-search-box horizontal-flex h-auto {{$ctrl.additionalClass}}">
                <span ng-if="!$ctrl.searchBarOnly" class="horizontal-flex mright8">
                    <sort-order-button class="interactive-scoring__reverse-sort-btn" value="$ctrl.selection.orderReversed"></sort-order-button>
                    <select dku-bs-select class="input-group-btn interactive-scoring__sort-select" ng-model="$ctrl.selection.orderQuery" ng-options="opt.value as opt.label for opt in $ctrl.featureFilterOptions"></select>
                </span>
                <span class="interactive-scoring__search-bar-group">
                    <span class="add-on"><i class="icon-dku-search padleftright4"></i></span>
                    <input class="interactive-scoring__search-bar" type="search" ng-model="$ctrl.selection.filterQuery.userQuery" placeholder="Filter..."/>
                </span>
            </div>`,bindings:{searchBarOnly:"<",selection:"<",featureFilterOptions:"<",additionalClass:"<"}})})();(function(){"use strict";const app=angular.module("dataiku.ml.explainability");const getDigitalBlueRGBA=alpha=>`rgba(59, 153, 252, ${alpha})`;app.component("explorationConstraints",{bindings:{isClassification:"<",isRegression:"<",isMulticlass:"<",whatIfRouter:"<",fmi:"<",explorationLocalStore:"<",modelData:"<",storageTypes:"<",featuresSortingService:"<"},templateUrl:"/templates/ml/prediction-model/exploration/exploration-constraints.html",controller:function($scope,EmuType,FeaturesDistributionAdapter,ConstraintHelper,LoggerProvider,ExplorationWT1Service){this.$onInit=function(){if(!this.explorationLocalStore.canUseConstraintsPage()){const logger=LoggerProvider.getLogger("ml.exploration.constraints");logger.warn("Cannot open constraints: some variables are missing in the local storage");this.whatIfRouter.openMainView();return}$scope.unlockedFeaturesMask={};$scope.validConstraintsMask={};$scope.prediction=this.explorationLocalStore.getScore().prediction;$scope.sortOptions=this.featuresSortingService.getSortOptions();$scope.selection=this.featuresSortingService.cleanSelection();$scope.$watch("selection.orderQuery",this.featuresSortingService.updateSortOrderAfterOptionChange.bind(this.featuresSortingService));$scope.featureDomains=[];$scope.reference=this.explorationLocalStore.getReference();$scope.saveTarget=target=>this.explorationLocalStore.setTarget(target);$scope.target=this.explorationLocalStore.getTarget();const wt1Service=ExplorationWT1Service.init(this.isClassification,Object.keys($scope.reference).length);FeaturesDistributionAdapter.init(this.fmi,this.storageTypes).then(distributions=>{const objFromFeatureNames=fn=>Object.fromEntries(distributions.getNames().map(name=>[name,fn(name)]));$scope.distributionAdapters=objFromFeatureNames(distributions.getSingle);$scope.trainTypes=objFromFeatureNames(name=>distributions.getSingle(name).type);$scope.constraintHelpers=objFromFeatureNames(name=>ConstraintHelper.init($scope.distributionAdapters[name],this.storageTypes[name]));$scope.featureDomains=this.explorationLocalStore.getFeatureDomains();if(!$scope.featureDomains.length){$scope.resetFeatureDomains()}$scope.unlockedFeaturesMask=Object.fromEntries($scope.featureDomains.map(feature=>[feature.name,feature.type!==EmuType.FROZEN]));$scope.validConstraintsMask=Object.fromEntries($scope.featureDomains.map(feature=>[feature.name,true]));wt1Service.emitConstraintsOpened()})};function setState(feature,makeActionable){const actuallyMakeActionable=makeActionable&&!$scope.constraintHelpers[feature.name].shouldAlwaysBeFrozen();$scope.unlockedFeaturesMask[feature.name]=actuallyMakeActionable;feature.type=actuallyMakeActionable?$scope.constraintHelpers[feature.name].emuType:EmuType.FROZEN;$scope.saveFeatureDomains()}$scope.setStateOfAllFeatures=makeActionable=>$scope.featureDomains.forEach(feature=>setState(feature,makeActionable));$scope.resetFeatureDomains=()=>{$scope.featureDomains=Object.values($scope.constraintHelpers).map(constraintHelper=>constraintHelper.getDefaultConstraint());$scope.setStateOfAllFeatures(false);this.featuresSortingService.enrichWithSortingAttributes($scope.featureDomains);$scope.saveFeatureDomains()};$scope.toggleConstraint=feature=>setState(feature,!$scope.unlockedFeaturesMask[feature.name]);$scope.freeze=feature=>setState(feature,false);$scope.saveFeatureDomains=()=>this.explorationLocalStore.setFeatureDomains($scope.featureDomains);$scope.nbActionableFeatures=()=>Object.values($scope.unlockedFeaturesMask).reduce((a,b)=>a+b,0);$scope.nbFrozenFeatures=()=>Object.keys($scope.unlockedFeaturesMask).length-$scope.nbActionableFeatures();$scope.getComputeDisabledReason=()=>{const atLeastOneInvalidConstraint=$scope.featureDomains.map(feature=>feature.name).some(feature=>!$scope.validConstraintsMask[feature]&&$scope.unlockedFeaturesMask[feature]);if(atLeastOneInvalidConstraint){return"Some constraints are invalid"}if(!$scope.nbActionableFeatures()){return"Specify at least one actionable feature to begin exploration"}return null}}});app.directive("constraintCard",function(ConstraintHelper){return{scope:{distribution:"<",featureDomain:"=",reference:"<",saveFeatureDomains:"&",isValid:"=",freeze:"&",storageType:"<"},template:`
                <div ng-switch="type">
                    <numerical-constraint-card ng-switch-when="NUMERICAL"/>
                    <categorical-constraint-card ng-switch-when="CATEGORICAL"/>
                </div>`,controller:function($scope){const constraintHelper=ConstraintHelper.init($scope.distribution,$scope.storageType);$scope.feature=$scope.featureDomain.name;$scope.type=constraintHelper.emuType;$scope.setIsValid=isValid=>{$scope.isValid=isValid};$scope.getConstraintDescription=()=>constraintHelper.getConstraintDescription($scope.featureDomain);$scope.reset=callback=>{const newConstraint=constraintHelper.getDefaultConstraint();angular.extend($scope.featureDomain,newConstraint);$scope.saveFeatureDomains();$scope.setIsValid(true);callback()};$scope.chart={feature:$scope.feature,handle:undefined,options:{toolbox:{show:false},brush:{xAxisIndex:0,brushStyle:{color:getDigitalBlueRGBA(.1),borderColor:getDigitalBlueRGBA(.5)}},grid:[{top:15,bottom:20,left:24,right:24}],xAxis:{type:"category",data:undefined},yAxis:{type:"value",show:false},series:[{name:$scope.feature,type:"bar",data:undefined}]}}}}});app.directive("numericalConstraintCard",function($filter){return{scope:true,template:`
                <constraint-card-skeleton>
                    <block-inputs class="exploration-constraints__numeric-input-box">
                        <div class="flex">
                            <label for="min-{{ feature }}" class="exploration-constraints__numeric-labels">Min</label>
                            <input id="min-{{ feature }}" type="number" max="{{ featureDomain.maxValue }}" step="any"
                                class="exploration-constraints__numeric-input" ng-model="featureDomain.minValue" ng-change="updateConstraint()">
                        </div>
                        <div>
                            <label for="max-{{ feature }}" class="exploration-constraints__numeric-labels">Max</label>
                            <input id="max-{{ feature }}" type="number" min="{{ featureDomain.minValue }}" step="any"
                                class="exploration-constraints__numeric-input" ng-model="featureDomain.maxValue" ng-change="updateConstraint()">
                        </div>
                    </block-inputs>
                </constraint-card-skeleton>`,controller:function($scope){const{chart,distribution,featureDomain,reference}=$scope;const scale=distribution.scale;function enrichBaseChart(){const distributionValues=distribution.distribution;chart.options.xAxis.data=scale.map($filter("smartNumber")).slice(0,distributionValues.length);const isReferenceIndex=i=>scale.length===distributionValues.length?reference===scale[i]:scale[i]<=reference&&reference<scale[i+1];chart.options.series[0].data=distributionValues.map((value,i)=>({name:isReferenceIndex(i)?"ref.":"",itemStyle:{color:getDigitalBlueRGBA(1),decal:{color:`rgba(0, 0, 0, ${isReferenceIndex(i)?"0.3":"0"})`,dashArrayX:[1,0],dashArrayY:[4,3],rotation:-Math.PI/4}},value:value}));chart.options.series[0].label={show:true,formatter:"{b}",position:"top"};chart.options.series[0].barWidth="95%";chart.options.series[0].silent=true}enrichBaseChart();const pixelFromIndex=binIndex=>chart.handle.convertToPixel({seriesIndex:0},[binIndex,undefined])[0];const indexFromPixel=x=>chart.handle.convertFromPixel({seriesIndex:0},[x,undefined])[0];const halfDistanceBetweenTwoBars=()=>(pixelFromIndex(1)-pixelFromIndex(0))/2;function updateBrushRange(){if(!$scope.isValid||featureDomain.minValue>scale[scale.length-1]||featureDomain.maxValue<scale[0]){chart.handle.dispatchAction({type:"brush",areas:[{brushType:"lineX",range:[Infinity,Infinity]}]});return}const minValue=Math.max(featureDomain.minValue,scale[0]);const maxValue=Math.min(featureDomain.maxValue,scale[scale.length-1]);const minValueIndex=distribution.getBinIndex(minValue);const maxValueIndex=distribution.getBinIndex(maxValue)-(distribution.shouldBeRepresentedWithHistograms?1:0);const minPosition=pixelFromIndex(minValueIndex)-halfDistanceBetweenTwoBars();const maxPosition=pixelFromIndex(maxValueIndex)+halfDistanceBetweenTwoBars();chart.handle.dispatchAction({type:"brush",areas:[{brushType:"lineX",range:[minPosition,maxPosition]}]})}$scope.onChartInit=$event=>{chart.handle=$event;chart.handle.one("rendered",$scope.updateConstraint);chart.handle.on("brushEnd",params=>{const minValue=params.areas[0].range[0];const maxValue=params.areas[0].range[1];let minValueIndex=Math.max(indexFromPixel(minValue-halfDistanceBetweenTwoBars())+1,0);let maxValueIndex=Math.min(indexFromPixel(maxValue+halfDistanceBetweenTwoBars())-1,scale.length-1);if(minValueIndex>maxValueIndex){const isMinInLeftPartOfBar=indexFromPixel(minValue+halfDistanceBetweenTwoBars())===indexFromPixel(minValue+2);const isMaxInLeftPartOfBar=indexFromPixel(maxValue+halfDistanceBetweenTwoBars())===indexFromPixel(maxValue-2);minValueIndex=Math.max(minValueIndex-(isMinInLeftPartOfBar?0:1),0);maxValueIndex=maxValueIndex+(isMaxInLeftPartOfBar?1:0)}maxValueIndex=Math.min(maxValueIndex+(distribution.shouldBeRepresentedWithHistograms?1:0),scale.length-1);featureDomain.minValue=scale[minValueIndex];featureDomain.maxValue=scale[maxValueIndex];updateBrushRange();const round=val=>Math.round((val+Number.EPSILON)*1e3)/1e3;featureDomain.minValue=round(featureDomain.minValue);featureDomain.maxValue=round(featureDomain.maxValue);$scope.saveFeatureDomains();updateValidity();$scope.$apply()})};$scope.updateConstraint=()=>{updateValidity();updateBrushRange();$scope.saveFeatureDomains()};const updateValidity=()=>$scope.setIsValid(featureDomain.minValue<=featureDomain.maxValue&&![null,undefined].includes(featureDomain.minValue)&&![null,undefined].includes(featureDomain.maxValue));updateValidity()}}});app.directive("categoricalConstraintCard",function(ExplorationChartsConfig){return{scope:true,template:`
                <constraint-card-skeleton>
                    <block-inputs>
                        <select dku-bs-select="{selectedTextFormat:'count > 1', countSelectedText:'{0}/{1} enabled', actionsBox: true}"
                            multiple
                            ng-options="category for category in distribution.allCategories"
                            ng-model="featureDomain.categories"
                            data-count-selected-text="count"
                            data-live-search="true"
                            class="padleft16"></select>
                    </block-inputs>
                </constraint-card-skeleton>`,controller:function($scope){const{chart,distribution,featureDomain,reference}=$scope;const scale=distribution.scale;function enrichBaseChart(){const getDisplayName=category=>category===ExplorationChartsConfig.OTHER_CATEGORY_INTERNAL_NAME?ExplorationChartsConfig.OTHER_CATEGORY_NAME:category;chart.options.tooltip={position:"top",formatter:"{b0}",backgroundColor:"rgba(0, 0, 0, 0.9)",borderWidth:0,padding:6,textStyle:{color:"#ffffff",fontSize:12}};chart.options.xAxis.data=scale.map(getDisplayName);chart.options.series[0].data=distribution.distribution.map((value,i)=>({value:value,emphasis:{itemStyle:{color:getDigitalBlueRGBA(1)}},itemStyle:{color:"#dddddd",decal:{color:`rgba(0, 0, 0, ${reference===scale[i]?"0.3":"0"})`,dashArrayX:[1,0],dashArrayY:[4,3],rotation:-Math.PI/4}},isOtherCategory:scale[i]===ExplorationChartsConfig.OTHER_CATEGORY_INTERNAL_NAME}))}enrichBaseChart();const isDisplayed=category=>scale.includes(category);const isHidden=category=>!isDisplayed(category);$scope.onChartInit=$event=>{chart.handle=$event;chart.handle.one("rendered",()=>$scope.updateConstraint());chart.handle.on("click",params=>{const oldVal=[...featureDomain.categories];if(params.data.isOtherCategory){const atLeastOneHiddenCategoryIsEnabled=oldVal.some(isHidden);const hiddenCategories=distribution.allCategories.filter(isHidden);if(atLeastOneHiddenCategoryIsEnabled){const enabledHiddenCategories=hiddenCategories.filter(category=>oldVal.includes(category));const enabledHiddenCategoriesIndices=enabledHiddenCategories.map(category=>oldVal.indexOf(category));enabledHiddenCategoriesIndices.sort((a,b)=>a-b).reverse().forEach(index=>{featureDomain.categories.splice(index,1)})}else{const disabledHiddenCategories=hiddenCategories.filter(category=>!oldVal.includes(category));disabledHiddenCategories.forEach(category=>{featureDomain.categories.push(category)})}}else{const index=featureDomain.categories.indexOf(params.name);if(index===-1){featureDomain.categories.push(params.name)}else{featureDomain.categories.splice(index,1)}}featureDomain.categories=[...featureDomain.categories];$scope.updateConstraint(oldVal);$scope.$apply()})};$scope.updateConstraint=oldVal=>{if(!chart.handle){return}const newVal=featureDomain.categories;if(oldVal===undefined){oldVal=distribution.allCategories.filter(category=>!newVal.includes(category))}const addedCategories=newVal.filter(category=>!oldVal.includes(category));const removedCategories=oldVal.filter(category=>!newVal.includes(category));const displayedAddedCategories=addedCategories.filter(isDisplayed);const displayedRemovedCategories=removedCategories.filter(isDisplayed);function setHighlightForDisplayedCategory(actionType,category){chart.handle.dispatchAction({type:actionType,seriesIndex:0,name:category})}displayedAddedCategories.forEach(setHighlightForDisplayedCategory.bind(null,"highlight"));displayedRemovedCategories.forEach(setHighlightForDisplayedCategory.bind(null,"downplay"));if(distribution.allCategories.some(isHidden)){const setHighlightForOtherCategory=actionType=>{chart.handle.dispatchAction({type:actionType,seriesIndex:0,dataIndex:scale.length-1})};const atLeastOneHiddenCategoryIsEnabled=newVal.some(isHidden);setHighlightForOtherCategory(atLeastOneHiddenCategoryIsEnabled?"highlight":"downplay")}$scope.saveFeatureDomains();updateValidity()};const updateValidity=()=>$scope.setIsValid(featureDomain.categories.length);updateValidity();$scope.$watch("featureDomain.categories",(_,oldVal)=>$scope.updateConstraint(oldVal))}}});app.directive("constraintCardSkeleton",function(){return{transclude:{inputs:"blockInputs"},templateUrl:"/templates/ml/prediction-model/exploration/exploration-constraint-card.html"}});app.directive("counterfactualsFeatureEnablerItem",function(){return{scope:{featureName:"<",reference:"<",trainType:"<",isDisabled:"<",isActionable:"<",toggleCallback:"&",constraintDescription:"<"},templateUrl:"/templates/ml/prediction-model/exploration/exploration-feature-enabler-item.html"}});app.component("featureTypeIcon",{template:`
            <div class="feature-type-icon feature-type-icon__{{ $ctrl.trainType.toLowerCase() }}-icon" ng-switch="$ctrl.trainType">
                <span ng-switch-when="NUMERIC">#</span>
                <i ng-switch-when="CATEGORY" class="icon-font"/>
                <i ng-switch-when="VECTOR" class="icon-dku-array"/>
                <i ng-switch-when="TEXT" class="icon-italic"/>
            </div>
        `,bindings:{trainType:"<"}});app.controller("ExplorationTargetSelectorController",function($scope,childCtrl){$scope.target=childCtrl.target;$scope.prediction=childCtrl.prediction;$scope.updateTarget=target=>{if(childCtrl.sanitizeTarget){target=childCtrl.sanitizeTarget(target)}childCtrl.callback(target);childCtrl.target=target;$scope.target=target}});app.component("counterfactualsTargetSelector",{templateUrl:"/templates/ml/prediction-model/exploration/counterfactuals-target-selector.html",bindings:{target:"=ngModel",callback:"=ngChange",prediction:"<",classes:"<"},controller:function($scope,$controller,NO_TARGET_CLASS){this.$onInit=function(){$scope.possibleTargets=this.classes.filter(cat=>cat!==this.prediction);angular.extend(this,$controller("ExplorationTargetSelectorController",{$scope:$scope,childCtrl:this}))};$scope.NO_TARGET_CLASS=NO_TARGET_CLASS}});app.component("outcomeOptimizationTargetSelector",{templateUrl:"/templates/ml/prediction-model/exploration/outcome-optimization-target-selector.html",bindings:{target:"=ngModel",callback:"=ngChange",prediction:"<"},controller:function($scope,$controller,OutcomeOptimizationSpecialTarget){this.$onInit=function(){angular.extend(this,$controller("ExplorationTargetSelectorController",{$scope:$scope,childCtrl:this}))};$scope.isTargetMinOrMax=target=>Object.values(OutcomeOptimizationSpecialTarget).includes(target);this.sanitizeTarget=target=>!$scope.isTargetMinOrMax(target)?Number(target):target;$scope.OutcomeOptimizationSpecialTarget=OutcomeOptimizationSpecialTarget}});app.controller("CounterfactualsConstraintsHelpController",function($scope){$scope.title="Counterfactual explanations";$scope.imageUrl="/static/dataiku/images/exploration/counterfactual-explanations.svg";$scope.resultDescription="counterfactual examples";$scope.descriptionParagraphs="Generate records similar to the reference example, striving to follow the train data distribution, that would result <strong>in a different predicted class</strong>.<br>Counterfactual samples can help interpret the model's decision making, as well as identify actions of recourse for achieving <strong>alternate outcomes</strong>."});app.controller("OutcomeOptimizationConstraintsHelpController",function($scope){$scope.title="Outcome optimization";$scope.imageUrl="/static/dataiku/images/exploration/outcome-optimization.svg";$scope.resultDescription="near-optimal points";$scope.descriptionParagraphs="Generate records, striving to follow the train data distribution, that would result in either a <strong>minimal</strong>, <strong>maximal</strong>, or <strong>specific prediction</strong>."});app.component("counterfactualsConstraintsEmptyState",{templateUrl:"/templates/ml/prediction-model/exploration/exploration-constraints-empty-state.html",controller:"CounterfactualsConstraintsHelpController"});app.component("outcomeOptimizationConstraintsEmptyState",{templateUrl:"/templates/ml/prediction-model/exploration/exploration-constraints-empty-state.html",controller:"OutcomeOptimizationConstraintsHelpController"});app.component("counterfactualsConstraintsPopover",{templateUrl:"/templates/ml/prediction-model/exploration/exploration-constraints-popover.html",controller:"CounterfactualsConstraintsHelpController"});app.component("outcomeOptimizationConstraintsPopover",{templateUrl:"/templates/ml/prediction-model/exploration/exploration-constraints-popover.html",controller:"OutcomeOptimizationConstraintsHelpController"})})();(function(){"use strict";const app=angular.module("dataiku.ml.explainability");app.factory("WhatIfFeaturesSortingFactory",function(){class FeaturesSortingService{constructor(){this._selection={};this._perFeatureIndex=null;this._perFeatureDistributionType=null;this._perFeatureImportance=null}cleanSelection(){const keysToKeep=["orderQuery","filterParams","orderReversed"];Object.keys(this._selection).filter(key=>!keysToKeep.includes(key)).forEach(key=>{delete this._selection[key]});if(this._selection.orderQuery&&!["name","index","importance","distributionType"].includes(this._selection.orderQuery)){angular.extend(this._selection,this.getDefaultSelection())}return this._selection}setPerFeatureIndex(schemaColumns){this._perFeatureIndex=Object.fromEntries(schemaColumns.map((x,i)=>[x.name,i]))}setPerFeatureDistributionType(distributions){this._perFeatureDistributionType=Object.fromEntries(distributions.getNames().map(name=>[name,distributions.getSingle(name).type]))}setPerFeatureImportance(perFeatureImportance){this._perFeatureImportance=perFeatureImportance}hasIndex(){return!!this._perFeatureIndex}hasDistributionType(){return!!this._perFeatureDistributionType}hasImportance(){return!!this._perFeatureImportance}enrichWithSortingAttributes(features){if(this.hasIndex()){features.forEach(feature=>feature.index=this._perFeatureIndex[feature.name])}if(this.hasDistributionType()){features.forEach(feature=>feature.distributionType=this._perFeatureDistributionType[feature.name])}if(this.hasImportance()){features.forEach(feature=>feature.importance=this._perFeatureImportance[feature.name])}}getSortOptions(){return[{value:"name",label:"Name"},{value:"index",label:"Dataset"},{value:"distributionType",label:"Type"}].concat(this.hasImportance()?[{value:"importance",label:"Importance"}]:[])}getDefaultSelection(){return{orderQuery:this.hasImportance()?"importance":"index",filterParams:{userQueryTargets:["name"]},orderReversed:this.hasImportance()}}updateSortOrderAfterOptionChange(nv,ov){if(ov=="importance"&&nv!="importance"){this._selection.orderReversed=false}else if(ov!="importance"&&nv=="importance"){this._selection.orderReversed=true}}}return{init:()=>new FeaturesSortingService}})})();(function(){"use strict";const app=angular.module("dataiku.ml.explainability");app.component("explorationResults",{bindings:{isClassification:"<",isRegression:"<",whatIfRouter:"<",fmi:"<",explorationLocalStore:"<",modelData:"<",storageTypes:"<",featuresSortingService:"<"},templateUrl:"/templates/ml/prediction-model/exploration/exploration-results.html",controller:function($scope,DataikuAPI,OutcomeOptimizationSpecialTarget,ExplorationWT1Service,FeaturesDistributionAdapter,ExplorationChartsConfig,FutureProgressModal,EmuType,ConstraintHelper,NO_TARGET_CLASS,LoggerProvider,InteractiveModelCommand,ExportUtils){const logger=LoggerProvider.getLogger("ml.exploration.results");this.$onInit=function(){$scope.sortOptions=this.featuresSortingService.getSortOptions();$scope.selection=this.featuresSortingService.cleanSelection();$scope.$watch("selection.orderQuery",this.featuresSortingService.updateSortOrderAfterOptionChange.bind(this.featuresSortingService));if(!this.explorationLocalStore.canUseResultsPage()){logger.warn("Cannot open results: some variables are missing in the local storage");this.whatIfRouter.openConstraints();return}$scope.NO_TARGET_CLASS=NO_TARGET_CLASS;FeaturesDistributionAdapter.init(this.fmi,this.storageTypes).then(distributions=>{angular.copy(this.explorationLocalStore.getFeatureDomains().filter(feature=>feature.type!==EmuType.FROZEN),$scope.unlockedFeatures);$scope.unlockedFeatures.forEach(feature=>{const distributionAdapter=distributions.getSingle(feature.name,ExplorationChartsConfig.OTHER_CATEGORY_NAME);const scale=distributionAdapter.scale;const distribution=distributionAdapter.distribution;feature.constraintHelper=ConstraintHelper.init(distributionAdapter);feature.distribution=distribution.map((d,i)=>{return{tick:scale[i],width:d}});if(feature.type===EmuType.NUMERICAL){feature.shouldBeRepresentedWithHistograms=distributionAdapter.shouldBeRepresentedWithHistograms}});angular.copy($scope.unlockedFeatures.map(feature=>feature.name),$scope.shownFeatures);$scope.unlockedFeaturesNames=$scope.unlockedFeatures.map(feature=>feature.name);const isLocked=featureName=>$scope.unlockedFeatures.find(feature=>feature.name===featureName)===undefined;$scope.lockedFeatureNames=Object.keys($scope.reference).filter(isLocked);$scope.startExploration()});const computationCallback=(results,duration)=>{const result=results[0];wt1Service.emitComputationSucceeded(result.syntheticData.length,duration);if(!result.syntheticData||result.syntheticData.length===0){$scope.searchFailed=true;return}const getProbas=metadataRow=>{if(this.isClassification){return Object.fromEntries(this.modelData.classes.map(cat=>[cat,metadataRow[`proba_${cat}`]]))}else{return undefined}};const initLoss=point=>{if(this.isClassification){point.loss=point.plausibility===undefined?Number.NEGATIVE_INFINITY:-point.plausibility}else if($scope.target===OutcomeOptimizationSpecialTarget.MIN){point.loss=point.prediction}else if($scope.target===OutcomeOptimizationSpecialTarget.MAX){point.loss=-point.prediction}else{point.loss=Math.abs($scope.target-point.prediction)}return point};angular.copy(result["syntheticData"].map((e,i)=>({values:e,plausibility:result["syntheticMetadata"][i].plausibility,prediction:result["syntheticMetadata"][i].prediction,probas:getProbas(result["syntheticMetadata"][i]),isReference:false,isHovered:false,isShown:false,loss:undefined,overrideInfoString:result["syntheticMetadata"][i].override})),$scope.records);$scope.records.forEach(initLoss);const sortByLoss=(a,b)=>(a.loss>b.loss)-(a.loss<b.loss);$scope.records.sort(sortByLoss);const nbRecords=$scope.records.length;const nbShownByDefault=nbRecords>10?5:nbRecords;for(let i=0;i<nbShownByDefault;i++){$scope.records[i].isShown=true}const referenceRecord=initLoss({values:$scope.reference,plausibility:undefined,prediction:this.isClassification?score.prediction:Number(score.prediction),probas:getProbas(score),isReference:true,isHovered:false,isShown:true,loss:undefined,overrideInfoString:JSON.stringify(score.override)});$scope.records.push(referenceRecord);const enrichRecordWithWarning=point=>{if(this.isClassification){return}if(point.loss>referenceRecord.loss){if($scope.target===OutcomeOptimizationSpecialTarget.MIN){point.warning="Greater than reference prediction"}else if($scope.target===OutcomeOptimizationSpecialTarget.MAX){point.warning="Less than reference prediction"}else{point.warning="Farther from target than reference prediction"}}};$scope.records.forEach(enrichRecordWithWarning);if(this.isClassification){const predictionColorMap=this.explorationLocalStore.getPredictionColorMap();const OTHERS_COLOR="#dddddd";const getColor=prediction=>Object.keys(predictionColorMap).includes(prediction)?predictionColorMap[prediction]:OTHERS_COLOR;$scope.records.forEach(record=>{record.color=getColor(record.prediction)})}$scope.searchFailed=false;this.featuresSortingService.enrichWithSortingAttributes($scope.unlockedFeatures)};$scope.startExploration=(computeEvenIfCached=false)=>{const{reference,target,unlockedFeatures}=$scope;const explorationParams={featureDomains:this.explorationLocalStore.getFeatureDomains()};if(this.isClassification){explorationParams["target"]=target===NO_TARGET_CLASS?undefined:target;explorationParams["type"]=InteractiveModelCommand.COUNTERFACTUALS}else{explorationParams["target"]=target;explorationParams["type"]=InteractiveModelCommand.OUTCOME_OPTIMIZATION}wt1Service.emitComputationStarted(explorationParams,unlockedFeatures);const computationStartTime=performance.now();DataikuAPI.interactiveModel.compute(this.fmi,explorationParams,[reference],computeEvenIfCached).success(initialResponse=>{const modalTitle=this.isClassification?"Computing counterfactual explanations":"Looking for optima";FutureProgressModal.show($scope,initialResponse,modalTitle,undefined,"static",false,true).then(futureResult=>{if(futureResult===undefined){this.whatIfRouter.openConstraints();return}const computationEndTime=performance.now();computationCallback(futureResult,Math.floor(computationEndTime-computationStartTime))}).catch(setErrorInScope.bind($scope))}).error(setErrorInScope.bind($scope))};$scope.exportResults=async()=>{wt1Service.emitExportClicked($scope.records.length);if(!$scope.records.length){logger.warn("Cannot export empty counterfactual explanations");return}const splitDescResp=await DataikuAPI.ml.prediction.getSplitDesc(this.fmi);const inputColumnsNames=Object.keys($scope.records[0].values);const columns=splitDescResp.data.schema.columns.filter(column=>inputColumnsNames.includes(column.name));const data=$scope.records.map(record=>columns.map(column=>record.values[column.name]));let name;if(this.isClassification){for(const category of Object.keys($scope.records[0].probas)){columns.push({name:`proba_${category}`,type:"double"});data.forEach((record,i)=>record.push($scope.records[i].probas[category]))}columns.push({name:"prediction",type:"string"});name="Counterfactual explanations"}else{columns.push({name:"prediction",type:"double"});name="Outcome optimization results"}data.forEach((record,i)=>record.push($scope.records[i].prediction));if($scope.records.some(e=>e.plausibility!==undefined)){columns.push({name:"plausibility",type:"float"});data.forEach((record,i)=>{const plausibility=$scope.records[i].plausibility;record.push(plausibility!==undefined?Number(plausibility.toFixed(2)):undefined)})}columns.push({name:"record_type",type:"string"});data.forEach((record,i)=>{let recordType;if($scope.records[i].isReference){recordType="REFERENCE"}else if(this.isClassification){recordType="COUNTERFACTUAL_EXPLANATION"}else{recordType="OPTIMUM"}record.push(recordType)});const withOverrides=$scope.records.some(record=>!!record.overrideInfoString);if(withOverrides){columns.push({name:"override",type:"string"});data.forEach((record,i)=>{record.push($scope.records[i].overrideInfoString)})}ExportUtils.exportUIData($scope,{name:name,data:data,columns:columns},"Export records")};$scope.unlockedFeatures=[];$scope.shownFeatures=[];$scope.unlockedFeaturesNames=[];$scope.records=[];const score=this.explorationLocalStore.getScore();$scope.reference=this.explorationLocalStore.getReference();$scope.prediction=score.prediction;$scope.target=this.explorationLocalStore.getTarget();const wt1Service=ExplorationWT1Service.init(this.isClassification,Object.keys($scope.reference).length);$scope.searchFailed=false;$scope.close=()=>{this.whatIfRouter.openMainView()};$scope.editConstraints=()=>{this.whatIfRouter.openConstraints()}}}});app.component("explorationResultsTable",{templateUrl:"/templates/ml/prediction-model/exploration/exploration-results-table.html",bindings:{records:"<",features:"<",shownFeatures:"<",selection:"<"},controller:function($scope,$filter){this.$onInit=function(){$scope.reference=this.records.find(x=>x.isReference).values;$scope.selection=this.selection;$scope.shouldDisplayProbas=this.records.map(x=>x.probas).every(p=>p!==undefined);$scope.formatPrediction=prediction=>$scope.shouldDisplayProbas?prediction:$filter("smartNumber")(Number(prediction));$scope.plausibilityScale=getColorScale(this.records.map(x=>x.plausibility));if($scope.shouldDisplayProbas){$scope.probaScale=getColorScale(this.records.map(x=>x.probas[x.prediction]))}$scope.isShown=feature=>this.shownFeatures.includes(feature.name);$scope.atLeastOneRowIsShown=()=>this.records.some(record=>record.isShown);$scope.setVisibilityOfAllRows=isShown=>this.records.forEach(record=>{record.isShown=isShown})};const getColorScale=values=>{const min=d3.min(values);const max=d3.max(values);if(min===max){return()=>"green"}return d3.scale.linear().range(["red","orange","green"]).domain([min,(max+min)/2,max])};$scope.setHover=(record,value)=>{record.isHovered=value};$scope.getConstraintDescription=feature=>feature.constraintHelper.getConstraintDescription(feature);$scope.formatProba=proba=>d3.format(",.2f")(proba*100);$scope.formatProbas=probas=>{const MAX_NB_PROBAS_TO_DISPLAY=4;let sortedProps=Object.keys(probas).map(key=>({value:probas[key],key:key})).sort((a,b)=>b.value-a.value);if(sortedProps.length>MAX_NB_PROBAS_TO_DISPLAY){sortedProps=sortedProps.slice(0,MAX_NB_PROBAS_TO_DISPLAY-1);const sumTopProbas=sortedProps.reduce((acc,e)=>acc+e.value,0);sortedProps.push({key:"Others",value:1-sumTopProbas})}return sortedProps.map(e=>`${e.key}: ${d3.format(",.0f")(100*e.value)}%`).join(" - ")};$scope.sortColumn="loss";$scope.sortDescending=false;this.$onChanges=changes=>{if(changes.shownFeatures){this.shownFeatures=changes.shownFeatures.currentValue}}}});app.component("explorationResultsPlotRow",{templateUrl:"/templates/ml/prediction-model/exploration/exploration-results-plot-row.html",bindings:{records:"<",shownFeatures:"=",unlockedFeatures:"<"},controller:function($scope){$scope.getShownFeatures=()=>this.shownFeatures}});app.component("frozenFeaturesPopin",{bindings:{lockedFeatureNames:"<",reference:"<"},template:`
            <a class="exploration-results__popover-button">
                <span class="icon-info-sign"></span>
                {{ $ctrl.lockedFeatureNames.length }} Frozen {{'feature' | plurify: $ctrl.lockedFeatureNames.length}}
            </a>`,controller:function($scope,$element,openDkuPopin){const popinTemplate=`
                    <div class="popover dropdown-menu exploration-frozen-features" listen-keydown="{ 'esc': 'dismiss()' }">
                        <div class="arrow"></div>
                        <div class="popover-title">
                            Frozen {{'feature' | plurify: $ctrl.lockedFeatureNames.length}}
                        </div>
                        <ul class="exploration-frozen-features__list">
                            <li ng-repeat="lockedFeature in $ctrl.lockedFeatureNames" class="exploration-frozen-features__item">
                                <div class="exploration-frozen-features__item-name">
                                    {{ lockedFeature }}
                                </div>
                                <div class="exploration-frozen-features__item-value">
                                    {{ $ctrl.reference[lockedFeature] }}
                                </div>
                            </li>
                        </ul>
                    </div>`;let popinOpen=false;let dismissPopin=()=>void 0;function togglePopin($event){if(popinOpen===false){const dkuPopinOptions={template:popinTemplate,isElsewhere:(elt,e)=>$(e.target).parents(".dropdown-menu").length===0,onDismiss:()=>{popinOpen=false}};dismissPopin=openDkuPopin($scope,$event,dkuPopinOptions);popinOpen=true}else if(dismissPopin){dismissPopin()}}$element.on("click",togglePopin)}})})();(function(){"use strict";const app=angular.module("dataiku.ml.explainability");app.constant("ExplorationChartsConfig",{MAX_NB_CATEGORIES:8,OTHER_CATEGORY_NAME:"Other",OTHER_CATEGORY_INTERNAL_NAME:"__DKU__OTHER_HIDDEN_CATEGORIES__"});app.constant("InteractiveModelCommand",{COUNTERFACTUALS:"COUNTERFACTUALS",OUTCOME_OPTIMIZATION:"OUTCOME_OPTIMIZATION",SCORING:"SCORING",EXPLANATIONS:"EXPLANATIONS"});app.constant("EmuType",{NUMERICAL:"NUMERICAL",CATEGORICAL:"CATEGORICAL",FROZEN:"FROZEN"});app.constant("DistributionType",{NUMERIC:"NUMERIC",CATEGORY:"CATEGORY",VECTOR:"VECTOR",TEXT:"TEXT"});app.constant("OutcomeOptimizationSpecialTarget",{MIN:"MIN",MAX:"MAX"});app.constant("NO_TARGET_CLASS","__DKU_NO_TARGET_CLASS__");app.constant("WhatIfView",{MAIN:"MAIN",COMPARATOR:"COMPARATOR",EXPLORATION_CONSTRAINTS:"EXPLORATION_CONSTRAINTS",EXPLORATION_RESULTS:"EXPLORATION_RESULTS"});app.factory("WhatIfRouter",function(WhatIfView){class WhatIfRouter{constructor(){this._currentView=WhatIfView.MAIN}openMainView(){this._currentView=WhatIfView.MAIN}openComparator(){this._currentView=WhatIfView.COMPARATOR}openConstraints(){this._currentView=WhatIfView.EXPLORATION_CONSTRAINTS}openResults(){this._currentView=WhatIfView.EXPLORATION_RESULTS}getCurrentView(){return this._currentView}}return{build:()=>new WhatIfRouter}});app.factory("ExplorationLocalStore",["LocalStorage","NO_TARGET_CLASS","OutcomeOptimizationSpecialTarget",LocalStorage=>(fmi,insight)=>{const storeId=insight?insight.id:fmi;const mandatoryVariablesForConstraintsPage=["reference","score"];const mandatoryVariablesForResultsPage=["featureDomains","reference","score"];const areVariablesStored=keys=>keys.map(key=>LocalStorage.get(getKey(key))).every(e=>e!==undefined);const noVersion="v2";const getKey=variable=>`dku.ml.interactivescoring.exploration.${noVersion}.${storeId}.${variable}`;return{setPredictionColorMap:predictionColorMap=>LocalStorage.set(getKey("predictionColorMap"),JSON.stringify(predictionColorMap)),setTarget:target=>LocalStorage.set(getKey("target"),target),setReference:reference=>LocalStorage.set(getKey("reference"),reference),setFeatureDomains:featureDomains=>LocalStorage.set(getKey("featureDomains"),featureDomains),setScore:score=>LocalStorage.set(getKey("score"),JSON.stringify(score)),getPredictionColorMap:()=>JSON.parse(LocalStorage.get(getKey("predictionColorMap"))||"{}"),getTarget:()=>LocalStorage.get(getKey("target")),getReference:()=>LocalStorage.get(getKey("reference"))||{},getFeatureDomains:()=>LocalStorage.get(getKey("featureDomains"))||[],getScore:()=>JSON.parse(LocalStorage.get(getKey("score"))),canUseConstraintsPage:()=>areVariablesStored(mandatoryVariablesForConstraintsPage),canUseResultsPage:()=>areVariablesStored(mandatoryVariablesForResultsPage)}}]);app.factory("ConstraintHelper",(EmuType,DistributionType,$filter,DatasetTypesService)=>({init:(distribution,storageType)=>{const emuType=distribution.type===DistributionType.NUMERIC?EmuType.NUMERICAL:EmuType.CATEGORICAL;const shouldAlwaysBeFrozen=()=>{const isNumericOrCategorical=[DistributionType.NUMERIC,DistributionType.CATEGORY].includes(distribution.type);return DatasetTypesService.isTemporalType(storageType)||!isNumericOrCategorical};const getDefaultConstraint=()=>{const featureDomain={name:distribution.featureName};if(shouldAlwaysBeFrozen()){featureDomain.type=EmuType.FROZEN;if(distribution.type===DistributionType.NUMERIC){featureDomain.minValue=0;featureDomain.maxValue=0}else{featureDomain.categories=[]}}else if(distribution.type===DistributionType.NUMERIC){featureDomain.type=EmuType.NUMERICAL;featureDomain.minValue=Math.min(...distribution.scale);featureDomain.maxValue=Math.max(...distribution.scale)}else{featureDomain.type=EmuType.CATEGORICAL;featureDomain.categories=[...distribution.allCategories]}return featureDomain};const getConstraintDescription=featureDomain=>{switch(emuType){case EmuType.NUMERICAL:return`Between ${$filter("smartNumber")(featureDomain.minValue)} and ${$filter("smartNumber")(featureDomain.maxValue)}`;case EmuType.CATEGORICAL:{const{nbDistinct,missingCount}=distribution.rawData;const nbCategories=nbDistinct-(missingCount>0?1:0);const nbEnabled=featureDomain.categories.length;return nbEnabled===nbCategories?"All enabled":`${nbEnabled}/${nbCategories} enabled`}}};return{shouldAlwaysBeFrozen:shouldAlwaysBeFrozen,getDefaultConstraint:getDefaultConstraint,getConstraintDescription:getConstraintDescription,emuType:emuType}}}));app.factory("FeaturesDistributionAdapter",(ExplorationChartsConfig,DataikuAPI,DistributionType)=>{const _getTopNValuesAndIndices=(values,n)=>{const topValues=values.slice(0,n).map((v,i)=>({value:v,index:i}));topValues.sort((a,b)=>a.value-b.value);for(let i=n;i<values.length;i++){if(values[i]>topValues[0].value){topValues.shift();const insertAt=topValues.findIndex(v=>values[i]<v.value);topValues.splice(insertAt===-1?topValues.length:insertAt,0,{value:values[i],index:i})}}return topValues};let featuresDistributionCache={};return{init:(fmi,storageTypes=undefined)=>new Promise((resolve,reject)=>{const getSingle=(featureName,otherCategorySecretName=ExplorationChartsConfig.OTHER_CATEGORY_INTERNAL_NAME)=>{const rawData=featuresDistributionCache[fmi][featureName];const type=rawData.type;let adapter={featureName:featureName,type:type,rawData:rawData};if(type===DistributionType.NUMERIC){const shouldBeRepresentedWithHistograms=()=>{if(storageTypes&&["float","double"].includes(storageTypes[featureName])){return true}const{nbDistinct,histogram}=rawData;const minValue=histogram.scale[0];const maxValue=histogram.scale[histogram.scale.length-1];const rangeSize=1+maxValue-minValue;return nbDistinct>50||rangeSize>50};adapter.getBinIndex=x=>{const bins=adapter.scale;const index=bins.findIndex(bin=>x<bin);return index>-1?index-1:x?bins.length-1:undefined};adapter.shouldBeRepresentedWithHistograms=shouldBeRepresentedWithHistograms()}else{adapter.allCategories=rawData.values.scale}function _getCleanScaleAndDistribution(){if(type===DistributionType.NUMERIC){const{histogram,topValues}=rawData;if(adapter.shouldBeRepresentedWithHistograms){return histogram}const minValue=histogram.scale[0];const maxValue=histogram.scale[histogram.scale.length-1];const rangeSize=1+maxValue-minValue;const distribution=_.range(0,rangeSize,0);topValues.forEach(({value,count})=>{distribution[value-minValue]+=count});return{scale:_.range(minValue,maxValue+1,1),distribution:distribution}}else{const categories=rawData.values;if(categories.scale.length<=ExplorationChartsConfig.MAX_NB_CATEGORIES){return categories}const topValues=_getTopNValuesAndIndices(categories.distribution,ExplorationChartsConfig.MAX_NB_CATEGORIES-1);const sumOfDisplayedDistributions=topValues.map(e=>e.value).reduce((a,b)=>a+b,0);return{scale:topValues.map(e=>categories.scale[e.index]).concat(otherCategorySecretName),distribution:topValues.map(e=>e.value).concat(1-sumOfDisplayedDistributions)}}}adapter={...adapter,..._getCleanScaleAndDistribution()};return adapter};const methods={getNames:()=>Object.keys(featuresDistributionCache[fmi]),getSingle:getSingle};if(featuresDistributionCache[fmi]){resolve(methods)}else if(featuresDistributionCache[fmi]===null){reject()}else{DataikuAPI.ml.prediction.getFeaturesDistribution(fmi).success(function(data){if(data){featuresDistributionCache[fmi]=data.featuresDistribution;resolve(methods)}else{featuresDistributionCache[fmi]=null;reject()}})}})}});app.factory("ExplorationWT1Service",function(WT1,EmuType,InteractiveModelCommand,OutcomeOptimizationSpecialTarget){const _getExplorationType=isClassification=>{return isClassification?InteractiveModelCommand.COUNTERFACTUALS:InteractiveModelCommand.OUTCOME_OPTIMIZATION};const init=(isClassification,nFeatures)=>{const explorationType=_getExplorationType(isClassification);return{emitConstraintsOpened:()=>{WT1.event("ml-exploration-constraints-opened",{explorationType:explorationType,nFeatures:nFeatures})},emitComputationStarted:(explorationParams,unlockedFeatures)=>{let targetDescription;if(explorationType===InteractiveModelCommand.COUNTERFACTUALS){targetDescription=explorationParams.target!==undefined?"SPECIFIC_CLASS":"NO_SPECIFIC_CLASS"}else{targetDescription=Object.values(OutcomeOptimizationSpecialTarget).includes(explorationParams.target)?explorationParams.target:"SPECIFIC_TARGET"}let nFeaturesWithCustomConstraints=0;for(const unlockedFeature of unlockedFeatures){const defaultConstraint=unlockedFeature.constraintHelper.getDefaultConstraint();const actualConstraint=angular.copy(explorationParams.featureDomains.find(featureDomain=>featureDomain.name===unlockedFeature.name));for(const key in defaultConstraint){if(angular.isArray(defaultConstraint[key])){actualConstraint[key].sort();defaultConstraint[key].sort()}}if(!angular.equals(actualConstraint,defaultConstraint)){nFeaturesWithCustomConstraints++}}const countNFeaturesForType=type=>explorationParams.featureDomains.filter(featureDomain=>featureDomain.type===type).length;WT1.event("ml-exploration-computation-started",{nFrozenFeatures:countNFeaturesForType(EmuType.FROZEN),nNumericalFeatures:countNFeaturesForType(EmuType.NUMERICAL),nCategoricalFeatures:countNFeaturesForType(EmuType.CATEGORICAL),target:targetDescription,explorationType:explorationType,nFeatures:nFeatures,nFeaturesWithCustomConstraints:nFeaturesWithCustomConstraints})},emitComputationSucceeded:(nResults,duration)=>{WT1.event("ml-exploration-computation-succeeded",{explorationType:explorationType,nFeatures:nFeatures,nResults:nResults,duration:duration})},emitExportClicked:nRows=>{WT1.event("ml-exploration-export",{explorationType:explorationType,nFeatures:nFeatures,nRows:nRows})}}};return{init:init}});app.service("WhatIfFormattingService",function(ModelDataUtils){const getSmartNumberDigits=function(min,max){if(min===max){return 0}const absoluteMin=Math.min(Math.abs(min),Math.abs(max));const differenceOrderOfMagnitude=Math.floor(Math.log10(max-min));if(differenceOrderOfMagnitude<0){return-differenceOrderOfMagnitude+1}else{return Math.max(max-min<10?1:0,-Math.floor(Math.log10(absoluteMin||10)))}};const getComplexPredictionFormatForRegression=function(modelData,prediction){let min,max;if(modelData.predictionInfo&&modelData.predictionInfo.predictions&&modelData.predictionInfo.predictions.length>0){const predictions=modelData.predictionInfo.predictions;min=d3.min(predictions);max=d3.max(predictions)}else if(modelData.perf&&modelData.perf.scatterPlotData&&modelData.perf.scatterPlotData.y&&modelData.perf.scatterPlotData.y.length>0){const predictions=modelData.perf.scatterPlotData.y;min=d3.min(predictions);max=d3.max(predictions)}else{if(prediction===undefined){return"f"}min=prediction-Math.abs(prediction);max=prediction+Math.abs(prediction)}return`.${getSmartNumberDigits(min,max)}f`};return{formatPrediction:(modelData,prediction)=>{if(ModelDataUtils.isRegression(modelData)){if(modelData.perf&&modelData.perf.scatterPlotData&&modelData.perf.scatterPlotData.y){return d3.format(getComplexPredictionFormatForRegression(modelData,prediction))(prediction)}return prediction.toPrecision(5)}return prediction},formatProba:proba=>d3.format(",.2f")(proba*100),getSmartNumberDigits:getSmartNumberDigits,getComplexPredictionFormatForRegression:getComplexPredictionFormatForRegression}})})();(function(){"use strict";const app=angular.module("dataiku.ml.report");app.service("PerformanceMetricsDataComposer",function($filter,PartitionedModelsService,BinaryClassificationModelsService,ModelDataUtils){function _withCustomMetrics(metricsData,customMetricsResults){if(!customMetricsResults){return metricsData}customMetricsResults.forEach(metricResult=>{const metric=metricResult.metric;metricsData.push({name:"CUSTOM",displayName:metric.name,info:`Description: ${metric.description||"N/A"} – ${metric.greaterIsBetter?"Greater":"Lower"} values are better`,value:metricResult.value,std:metricResult.valuestd,isCustom:true,code:metric.metricCode,didSucceed:metricResult.didSucceed,error:metricResult.error});if(metricResult.worstValue!=null){metricsData.push({name:"CUSTOM",displayName:"Worst "+metric.name,info:`Worst (${metric.greaterIsBetter?"Minimum":"Maximum"}) value of ${metric.name} across all time series.`,value:metricResult.worstValue,isCustom:true,code:metric.metricCode,didSucceed:metricResult.didSucceed,error:metricResult.error})}});return metricsData}function _getMetricDataWithAggregationExplanation(metricData,modelData){if(!ModelDataUtils.isPartitionedBaseModel(modelData)){return metricData}metricData.info=PartitionedModelsService.getAggregationExplanation(metricData.name,metricData.displayName,metricData.isCustom,modelData.coreParams.prediction_type==="TIMESERIES_FORECAST")+` — ${metricData.info}`;return metricData}function _getFormattedValue(metricData,modelData){const precision=null;const isRegression=modelData.coreParams.prediction_type==="REGRESSION";const canUseScientificNotation=isRegression&&!metricData.isCustom;const isMultiCustomTrainTestSplit=modelData.coreParams.customTrainTestSplit&&modelData.coreParams.customTrainTestIntervals.length>1;const isKfold=!modelData.coreParams.customTrainTestSplit&&modelData.trainInfo.kfold;const isApproximateInterval=isKfold||isMultiCustomTrainTestSplit;const approximateInterval=isApproximateInterval?metricData.std:false;return $filter("mlMetricFormat")(metricData.value,metricData.name,precision,approximateInterval,canUseScientificNotation)}function _getPolishedMetricsDataForGivenPerf(getMetricsDataFunction,modelData,perf){const hasProbasIfRequired=metricData=>ModelDataUtils.hasProbas(modelData)||!metricData.needsProbability;const withFormattedValue=metricData=>({formattedValue:_getFormattedValue(metricData,modelData),...metricData});const withAggregationExplanation=metricData=>_getMetricDataWithAggregationExplanation(metricData,modelData);return getMetricsDataFunction(modelData,perf).filter(hasProbasIfRequired).map(withFormattedValue).map(withAggregationExplanation)}function _getPolishedMetricsData(getMetricsDataFunction,modelData,perfVariants){const metricsVariantData=perfVariants.map(function(variant){if(!variant.perf){return[]}return _getPolishedMetricsDataForGivenPerf(getMetricsDataFunction,modelData,variant.perf)});function isEvaluationMetric(modelingMetrics,metricName){if(modelingMetrics.evaluationMetric!=="CUSTOM"){return modelingMetrics.evaluationMetric===metricName}return modelingMetrics.customEvaluationMetricName===metricName}function isThresholdOptimizationMetric(modelingMetrics,metricName){return modelingMetrics.thresholdOptimizationMetric===metricName}const firstVariantData=metricsVariantData[0];return{columns:perfVariants.map(variant=>variant.label),rows:firstVariantData.map((metric,i)=>{const metricDesc={name:metric.name,displayName:metric.displayName,info:metric.info,isCustom:metric.isCustom,code:metric.code,isEvaluationMetric:isEvaluationMetric(modelData.modeling.metrics,metric.name==="CUSTOM"?metric.displayName:metric.name),isThresholdOptimizationMetric:isThresholdOptimizationMetric(modelData.modeling.metrics,metric.name),isOneVsAll:!!metric.isOneVsAll&&!metric.isCustom};return{variants:metricsVariantData.map(metricVariantData=>metricVariantData[i]),...metricDesc}})}}function _getRegressionMetricsData(modelData,perf){const metrics=perf.metrics;const metricsData=[{name:"EVS",displayName:"Explained Variance Score",info:"Best possible score is 1.0, lower values are worse",value:metrics.evs,std:metrics.evsstd,yAxisMax:1},{name:"MAPE",displayName:"Mean Absolute Percentage Error (MAPE)",info:"Average of the absolute value of the relative regression error",value:metrics.mape,std:metrics.mapestd},{name:"MAE",displayName:"Mean Absolute Error (MAE)",info:"Average of the absolute value of the regression error",value:metrics.mae,std:metrics.maestd},{name:"MSE",displayName:"Mean Squared Error (MSE)",info:"Average of the squares of the errors",value:metrics.mse,std:metrics.msestd},{name:"RMSE",displayName:"Root Mean Squared Error (RMSE)",info:"Square root of the MSE",value:metrics.rmse,std:metrics.rmsestd},{name:"RMSLE",displayName:"Root Mean Squared Logarithmic Error (RMSLE)",info:"Root of the average of the squares of the natural log of the regression error",value:metrics.rmsle,std:metrics.rmslestd},{name:"R2",displayName:"R2 Score",info:"(Coefficient of determination) regression score function",value:metrics.r2,std:metrics.r2std,yAxisMax:1,yAxisMin:0},{name:"PEARSON",displayName:"Pearson Coefficient",info:"Correlation coefficient between actual and predicted values. +1 = perfect correlation, 0 =  no correlation, -1 = perfect anti-correlation",value:metrics.pearson,std:metrics.pearsonstd,yAxisMax:1,yAxisMin:0}];return _withCustomMetrics(metricsData,metrics.customMetricsResults)}function _getMulticlassMetricsData(modelData,perf){const metrics=perf.metrics;const metricsData=[{name:"ACCURACY",displayName:"Accuracy",info:"Proportion of correctly-classified observations",value:metrics.accuracy,std:metrics.accuracystd,yAxisMax:1,yAxisMin:0,isOneVsAll:false},{name:"PRECISION",displayName:"Precision",info:"Unweighted average of precision for all classes (Proportion of predicted X that were indeed X)",value:metrics.precision,std:metrics.precisionstd,yAxisMax:1,yAxisMin:0,isOneVsAll:true},{name:"RECALL",displayName:"Recall",info:"Unweighted average of recall for all classes (Proportion of actual class X found by the classifier)",value:metrics.recall,std:metrics.recallstd,yAxisMax:1,yAxisMin:0,isOneVsAll:true},{name:"F1",displayName:"F1-score",info:"Harmonic mean between Precision and Recall",value:metrics.f1,std:metrics.f1std,yAxisMax:1,yAxisMin:0,isOneVsAll:true},{name:"HAMMINGLOSS",displayName:"Hamming Loss",info:"Fraction of labels that are incorrectly predicted (the lower the better)",value:metrics.hammingLoss,std:metrics.hammingLossstd,yAxisMax:1,yAxisMin:0,isOneVsAll:false},{name:"ROC_AUC",displayName:"ROC MAUC",info:"Area under the ROC — From 0.5 (random model) to 1 (perfect model)",value:metrics.mrocAUC,std:metrics.mrocAUCstd,needsProbability:true,yAxisMax:1,yAxisMin:.5,isOneVsAll:true},{name:"AVERAGE_PRECISION",displayName:"Average Precision",info:"Summarizes a precision-recall curve - 1 (perfect model), positive-rate (random model)",value:metrics.averagePrecision,std:metrics.averagePrecisionstd,needsProbability:true,yAxisMax:1,yAxisMin:0,isOneVsAll:true},{name:"LOG_LOSS",displayName:"Log Loss",info:"Error metric that takes into account the predicted probabilities (the lower the better)"+(ModelDataUtils.hasCalibration(modelData)?" — Calibration might change the log loss as it modifies the predicted probabilities":""),value:metrics.logLoss,std:metrics.logLossstd,needsProbability:true,yAxisMin:0,isOneVsAll:false}];if(!ModelDataUtils.isPartitionedBaseModel(modelData)){metricsData.push({name:"CALIBRATION_LOSS",displayName:"Calibration Loss",info:"Average distance between calibration curve and diagonal — From 0 (perfectly calibrated) up to 0.5",value:metrics.mcalibrationLoss,std:metrics.mcalibrationLossstd,needsProbability:true,yAxisMax:.5,yAxisMin:0,isOneVsAll:true})}return _withCustomMetrics(metricsData,metrics.customMetricsResults)}function _getThresholdIndependentBinaryClassifMetricsData(modelData,perf){const metrics=perf.tiMetrics;const metricsData=[];metricsData.push({name:"ROC_AUC",displayName:"ROC AUC",info:"Area under the ROC — From 0.5 (random model) to 1 (perfect model)",value:metrics.auc,std:metrics.aucstd,needsProbability:true,yAxisMax:1,yAxisMin:.5});if(!ModelDataUtils.isPartitionedBaseModel(modelData)){metricsData.push({name:"CUMULATIVE_LIFT",displayName:$filter("mlMetricName")("CUMULATIVE_LIFT",modelData.modeling.metrics),info:"Ratio between the true positive rate of this model and the one of a random model",value:metrics.lift,std:metrics.liftstd,needsProbability:true})}metricsData.push({name:"AVERAGE_PRECISION",displayName:"Average Precision",info:"Summarizes a precision-recall curve - 1 (perfect model), positive-rate (random model)",value:metrics.averagePrecision,std:metrics.averagePrecisionstd,needsProbability:true,yAxisMax:1,yAxisMin:0});metricsData.push({name:"LOG_LOSS",displayName:"Log Loss",info:"Error metric that takes into account the predicted probabilities (the lower the better)"+(ModelDataUtils.hasCalibration(modelData)?" — Calibration might change the log loss as it modifies the predicted probabilities":""),value:metrics.logLoss,std:metrics.logLossstd,needsProbability:true,yAxisMin:0});if(!ModelDataUtils.isPartitionedBaseModel(modelData)){metricsData.push({name:"CALIBRATION_LOSS",displayName:"Calibration Loss",info:"Average distance between calibration curve and diagonal — From 0 (perfectly calibrated) up to 0.5",value:metrics.calibrationLoss,std:metrics.calibrationLossstd,needsProbability:true,yAxisMax:.5,yAxisMin:0})}return _withCustomMetrics(metricsData,metrics.customMetricsResults)}function _getThresholdDependentBinaryClassifMetricsData(modelData,perf){const metrics=BinaryClassificationModelsService.findCutData(perf,modelData.userMeta.activeClassifierThreshold);const metricsData=[{name:"ACCURACY",displayName:"Accuracy",info:"Proportion of correct predictions (positive and negative) in the test set",value:metrics.Accuracy,std:metrics.accuracystd,yAxisMax:1,yAxisMin:0},{name:"PRECISION",displayName:"Precision",info:"Proportion of positive predictions that were indeed positive (in the test set)",value:metrics.Precision,std:metrics.precisionstd,yAxisMax:1,yAxisMin:0},{name:"RECALL",displayName:"Recall",info:"Proportion of actual positive values found by the classifier",value:metrics.Recall,std:metrics.recallstd,yAxisMax:1,yAxisMin:0},{name:"F1",displayName:"F1-score",info:"Harmonic mean between Precision and Recall",value:metrics["F1-Score"],std:metrics.f1std,yAxisMax:1,yAxisMin:0},{name:"COST_MATRIX",displayName:"Cost Matrix Gain",info:`Average gain per record that the test set `+`(${modelData.trainInfo.kfold?modelData.trainInfo.fullRows:modelData.trainInfo.testRows} rows) `+`would yield given the specified gain for each outcome. Specified gains: TP = ${modelData.headTaskCMW.tpGain}, `+`TN = ${modelData.headTaskCMW.tnGain}, FP = ${modelData.headTaskCMW.fpGain}, FN = ${modelData.headTaskCMW.fnGain}.`,value:metrics.cmg},{name:"HAMMINGLOSS",displayName:"Hamming Loss",info:"Fraction of labels that are incorrectly predicted (the lower the better)",value:metrics.hammingLoss,std:metrics.hammingLossstd,yAxisMax:1,yAxisMin:0},{name:"MCC",displayName:"Matthews Correlation Coefficient",info:"Correlation coefficient between actual and predicted values. +1 = perfect, 0 = no correlation, -1 = perfect anti-correlation",value:metrics.mcc,std:metrics.mccstd,yAxisMax:1,yAxisMin:0}];return _withCustomMetrics(metricsData,metrics.customMetricsResults).map(metricData=>{return{...metricData,isThresholdDependent:true}})}function _getTimeSeriesMetricsModelEvaluationData(modelData,perf){const metricsData=_getTimeSeriesMetricsData(modelData,perf);const metrics=perf.aggregatedMetrics;metricsData.push({name:"WORST_MASE",displayName:"Worst MASE",info:"Worst (maximum) of the MASE metrics across all identifiers",value:metrics.worstMase},{name:"WORST_MAPE",displayName:"Worst MAPE",info:"Worst (maximum) of the MAPE metrics across all identifiers",value:metrics.worstMape},{name:"WORST_SMAPE",displayName:"Worst SMAPE",info:"Worst (maximum) of the SMAPE metrics across all identifiers",value:metrics.worstSmape},{name:"WORST_MAE",displayName:"Worst MAE",info:"Worst (maximum) of the MAE metrics across all identifiers",value:metrics.worstMae},{name:"WORST_MSE",displayName:"Worst MSE",info:"Worst (maximum) of the MSE metrics across all identifiers",value:metrics.worstMse},{name:"WORST_MSIS",displayName:"Worst MSIS",info:"Worst (maximum) of the MSIS metrics across all identifiers",value:metrics.worstMsis});return metricsData}function _getTimeSeriesMetricsData(modelData,perf){const metrics=perf.aggregatedMetrics;const metricsData=[{name:"MASE",displayName:"Mean Absolute Scaled Error (MASE)",info:"Ratio between the mean absolute error of the forecast values and the mean absolute error of one-step naive forecast values",value:metrics.mase,std:metrics.masestd},{name:"MAPE",displayName:"Mean Absolute Percentage Error (MAPE)",info:"Average of the absolute value of the relative forecast error",value:metrics.mape,std:metrics.mapestd},{name:"SMAPE",displayName:"Symmetric MAPE",info:"Average of the absolute forecast error divided by the half-sum of the actual value and the forecast value",value:metrics.smape,std:metrics.smapestd},{name:"MAE",displayName:"Mean Absolute Error (MAE)",info:"Average of the absolute value of the forecast error",value:metrics.mae,std:metrics.maestd},{name:"MEAN_ABSOLUTE_QUANTILE_LOSS",displayName:"Mean Absolute Quantile Loss",info:"Average of the quantile losses, where a quantile loss is the sum of the absolute quantile forecast error weighted by the quantile value",value:metrics.meanAbsoluteQuantileLoss,std:metrics.meanAbsoluteQuantileLossstd},{name:"MEAN_WEIGHTED_QUANTILE_LOSS",displayName:"Mean Weighted Quantile Loss",info:"Mean Absolute Quantile Loss divided by the sum of the actual values",value:metrics.meanWeightedQuantileLoss,std:metrics.meanWeightedQuantileLossstd},{name:"MSE",displayName:"Mean Squared Error (MSE)",info:"Average of the squares of the forecast errors",value:metrics.mse,std:metrics.msestd},{name:"RMSE",displayName:"Root Mean Squared Error (RMSE)",info:"Square root of the MSE",value:metrics.rmse,std:metrics.rmsestd},{name:"MSIS",displayName:"Mean Scaled Interval Score (MSIS)",info:"Average of the squares of the forecast errors",value:metrics.msis,std:metrics.msisstd},{name:"ND",displayName:"Normalized Deviation",info:"Average of the squares of the forecast errors",value:metrics.nd,std:metrics.ndstd}];return _withCustomMetrics(metricsData,metrics.customMetricsResults)}function _getCausalMetricsData(modelData,metrics){const metricsData=[{name:"AUUC",displayName:"Area Under the Uplift Curve",info:"Area between the cumulative uplift curve and the random assignment line, see 'Uplift charts'",value:metrics.auuc,std:metrics.auucstd},{name:"QINI",displayName:"Qini Score",info:"Area between the Qini curve and the random assignment line, see 'Uplift charts'",value:metrics.qini,std:metrics.qinistd},{name:"NET_UPLIFT",displayName:$filter("mlMetricName")("NET_UPLIFT",modelData.modeling.metrics),info:"Value of the cumulative uplift curve subtracted by the value of the random assignment line for a given % of the test population, see 'Uplift charts'",value:metrics.netUplift,std:metrics.netUpliftstd}];return _withCustomMetrics(metricsData,metrics.customMetricsResults)}function _getOverrideVariants(modelData,withAndWithoutOverrides){if(withAndWithoutOverrides){return[{label:"no overrides",perf:modelData.perfWithoutOverrides},{label:"with overrides",perf:modelData.perf}]}return[{label:"__single_variant__",perf:modelData.perf}]}return{getRegressionMetricsData:(modelData,withAndWithoutOverrides=false)=>{let metricsAndVariants=_getOverrideVariants(modelData,withAndWithoutOverrides);return _getPolishedMetricsData(_getRegressionMetricsData,modelData,metricsAndVariants)},getMulticlassMetricsData:(modelData,withAndWithoutOverrides=false)=>{let metricsAndVariants=_getOverrideVariants(modelData,withAndWithoutOverrides);return _getPolishedMetricsData(_getMulticlassMetricsData,modelData,metricsAndVariants)},getThresholdIndependentBinaryClassifMetricsData:(modelData,withAndWithoutOverrides=false)=>{let metricsAndVariants=_getOverrideVariants(modelData,withAndWithoutOverrides);return _getPolishedMetricsData(_getThresholdIndependentBinaryClassifMetricsData,modelData,metricsAndVariants)},getThresholdDependentBinaryClassifMetricsData:(modelData,withAndWithoutOverrides=false)=>{let metricsAndVariants=_getOverrideVariants(modelData,withAndWithoutOverrides);return _getPolishedMetricsData(_getThresholdDependentBinaryClassifMetricsData,modelData,metricsAndVariants)},getTimeSeriesMetricsData:modelData=>_getPolishedMetricsData(_getTimeSeriesMetricsData,modelData,[{label:"__single_variant__",perf:modelData.perf}]),getTimeSeriesMetricsModelEvaluationData:modelData=>_getPolishedMetricsData(_getTimeSeriesMetricsModelEvaluationData,modelData,[{label:"__single_variant__",perf:modelData.perf}]),getCausalMetricsData:modelData=>_getPolishedMetricsData(_getCausalMetricsData,modelData,[{label:"raw",perf:modelData.perf.causalPerf.raw},{label:"normalized by absolute value of ATE",perf:modelData.perf.causalPerf.normalized}])}});app.component("detailedMetricsTable",{bindings:{metrics:"<",modelData:"<",puppeteerHookName:"@?"},templateUrl:"/templates/ml/prediction-model/detailed-metrics/detailed-metrics-table.html",controller:function($scope,$element,ModelDataUtils){this.$onInit=()=>{if(this.puppeteerHookName){$element.children().first().attr(this.puppeteerHookName,"");$scope[this.puppeteerHookName]=true}$scope.isWeighted=ModelDataUtils.areMetricsWeighted(this.modelData)}}});app.component("customMetricDetailsButton",{bindings:{metricData:"<"},templateUrl:"/templates/ml/prediction-model/detailed-metrics/custom-metric-details-button.html"});app.component("classificationMetricsExplanation",{bindings:{isOnPartitionedBaseModel:"<",classAveragingMethod:"<",modelData:"<",hasOptimalThreshold:"<",evaluationDetails:"<"},templateUrl:"/templates/ml/prediction-model/detailed-metrics/classification-metrics-explanation.html"});app.component("bcDetailedMetrics",{bindings:{modelData:"<",hasOptimalThreshold:"<",evaluationDetails:"<",withAndWithoutOverrides:"@?"},templateUrl:"/templates/ml/prediction-model/bc_detailed_metrics.html",controller:function($scope,PerformanceMetricsDataComposer,ModelDataUtils){this.$onInit=()=>{$scope.isOnPartitionedBaseModel=ModelDataUtils.isPartitionedBaseModel(this.modelData);const updateMetricsData=()=>{$scope.tiMetricsData=PerformanceMetricsDataComposer.getThresholdIndependentBinaryClassifMetricsData(this.modelData,this.withAndWithoutOverrides);$scope.tdMetricsData=PerformanceMetricsDataComposer.getThresholdDependentBinaryClassifMetricsData(this.modelData,this.withAndWithoutOverrides)};const thresholdUpdateChecker=ModelDataUtils.createThresholdUpdateChecker();this.$doCheck=()=>thresholdUpdateChecker.executeIfUpdated(this.modelData,updateMetricsData)}}});app.component("mcDetailedMetrics",{bindings:{modelData:"<",evaluationDetails:"<",withAndWithoutOverrides:"@?"},templateUrl:"/templates/ml/prediction-model/mc_detailed_metrics.html",controller:function($scope,PerformanceMetricsDataComposer,ModelDataUtils){this.$onInit=()=>{$scope.metricsData=PerformanceMetricsDataComposer.getMulticlassMetricsData(this.modelData,this.withAndWithoutOverrides);$scope.oneVsAllMetricsData={...$scope.metricsData};$scope.oneVsAllMetricsData.rows=$scope.metricsData.rows.filter(metric=>!!metric.isOneVsAll);$scope.notOneVsAllMetricsData={...$scope.metricsData};$scope.notOneVsAllMetricsData.rows=$scope.metricsData.rows.filter(metric=>!metric.isOneVsAll);$scope.isOnPartitionedBaseModel=ModelDataUtils.isPartitionedBaseModel(this.modelData);$scope.classAveragingMethod=this.modelData.modeling.metrics.classAveragingMethod}}});app.component("rDetailedMetrics",{bindings:{modelData:"<",evaluationDetails:"<",withAndWithoutOverrides:"@?"},templateUrl:"/templates/ml/prediction-model/r_detailed_metrics.html",controller:function($scope,PerformanceMetricsDataComposer,ModelDataUtils){this.$onInit=()=>{$scope.metricsData=PerformanceMetricsDataComposer.getRegressionMetricsData(this.modelData,this.withAndWithoutOverrides);$scope.isOnPartitionedBaseModel=ModelDataUtils.isPartitionedBaseModel(this.modelData)}}});app.component("tsDetailedMetrics",{bindings:{modelData:"<",evaluationDetails:"<"},templateUrl:"/templates/ml/prediction-model/ts_detailed_metrics.html",controller:function($scope,PerformanceMetricsDataComposer,ModelDataUtils){this.$onInit=()=>{if(this.evaluationDetails){$scope.metricsData=PerformanceMetricsDataComposer.getTimeSeriesMetricsModelEvaluationData(this.modelData)}else{$scope.metricsData=PerformanceMetricsDataComposer.getTimeSeriesMetricsData(this.modelData)}$scope.isOnPartitionedBaseModel=ModelDataUtils.isPartitionedBaseModel(this.modelData)}}});app.component("causalDetailedMetrics",{bindings:{modelData:"<"},templateUrl:"/templates/ml/prediction-model/causal_detailed_metrics.html",controller:function($scope,PerformanceMetricsDataComposer){this.$onInit=()=>{$scope.testAte=this.modelData.perf.causalPerf.testATE;$scope.metricsData=PerformanceMetricsDataComposer.getCausalMetricsData(this.modelData)}}});app.component("assertionsMetrics",{bindings:{modelData:"<",evaluationDetails:"<"},templateUrl:"/templates/ml/prediction-model/detailed-metrics/assertions-metrics.html",controller:function($scope,BinaryClassificationModelsService,ModelDataUtils,SavedModelsService,ModelEvaluationUtils){const updateAssertionResult=()=>{if(!$scope.modelData)return;let assertionsMetrics;if($scope.isBinaryClassification){$scope.currentCutData=BinaryClassificationModelsService.findCutData($scope.modelData.perf,$scope.modelData.userMeta.activeClassifierThreshold);if($scope.modelData.perf.perCutData.assertionsMetrics){assertionsMetrics=$scope.modelData.perf.perCutData.assertionsMetrics[$scope.currentCutData.index]}}else{assertionsMetrics=$scope.modelData.perf.metrics&&$scope.modelData.perf.metrics.assertionsMetrics}if(assertionsMetrics){$scope.assertionsResult={hasAnyDroppedRows:false};for(let assertionMetric of assertionsMetrics.perAssertion){$scope.assertionsResult[assertionMetric.name]=assertionMetric;let nbDropped=assertionMetric.nbDroppedRows;if(nbDropped>0){$scope.assertionsResult.hasAnyDroppedRows=true}let nbMatchingRows=assertionMetric.nbMatchingRows;let nbPassing=Math.round(assertionMetric.validRatio*(nbMatchingRows-nbDropped));let nbFailing=Math.round(nbMatchingRows-nbDropped-nbPassing);$scope.assertionsResult[assertionMetric.name].nbPassing=nbPassing;$scope.assertionsResult[assertionMetric.name].nbFailing=nbFailing;$scope.assertionsResult[assertionMetric.name].passingPercentage=Math.round(100*nbPassing/nbMatchingRows);$scope.assertionsResult[assertionMetric.name].failingPercentage=Math.round(100*nbFailing/nbMatchingRows);$scope.assertionsResult[assertionMetric.name].droppedPercentage=Math.round(100*nbDropped/nbMatchingRows)}}};$scope.getAssertionsDisabledReason=()=>{const canHaveAssertions=ModelDataUtils.getAlgorithm(this.modelData)&&!ModelDataUtils.isEnsemble(this.modelData)&&this.modelData.backendType==="PY_MEMORY"&&!SavedModelsService.isExternalMLflowModel(this.modelData);if(!!this.evaluationDetails&&!!this.evaluationDetails.evaluation){return"No Assertions were configured"}if(canHaveAssertions){return"No assertions were configured. Set them in Design > Debugging."}if(ModelDataUtils.isEnsemble(this.modelData)){return"Assertions not available for ensemble models"}if(SavedModelsService.isMLflowModel(this.modelData)){return"Assertions not available for MLflow models"}if(SavedModelsService.isProxyModel(this.modelData)){return"Assertions not available for External Models"}if(!this.modelData.backendType){return ModelEvaluationUtils.hasNoAssociatedModelText(this.evaluationDetails)}if(this.modelData.backendType!=="PY_MEMORY"){return"Assertions are only available for in-memory python backend"}};this.$onInit=()=>{$scope.modelData=this.modelData;$scope.isOnPartitionBaseModel=ModelDataUtils.isPartitionedBaseModel(this.modelData);$scope.isRegression=ModelDataUtils.isRegression(this.modelData);$scope.isClassification=ModelDataUtils.isClassification(this.modelData);$scope.isBinaryClassification=ModelDataUtils.isBinaryClassification(this.modelData);if($scope.isBinaryClassification){const thresholdUpdateChecker=ModelDataUtils.createThresholdUpdateChecker();this.$doCheck=()=>thresholdUpdateChecker.executeIfUpdated(this.modelData,updateAssertionResult)}updateAssertionResult()}}});app.component("computeLearningCurveForm",{bindings:{computeCurveFn:"<",alreadyComputedNumberOfPoints:"<"},template:`
        <div class="learning-curves-form__wrapper">
            <button class="btn btn--primary btn--contained" ng-click="$ctrl.onComputeButtonClick(numberOfPoints)">
                Compute learning curves
            </button>
            <button class="btn btn--secondary btn--outline" ng-click="$ctrl.openModal()">
                <i class="icon-gear mright0"></i>
            </button>
        </div>
    `,controller:function($scope,CreateModalFromTemplate){const $ctrl=this;$scope.numberOfPoints=4;$ctrl.$onChanges=function(){setNumberOfPoints()};function setNumberOfPoints(){if($ctrl.alreadyComputedNumberOfPoints){$scope.numberOfPoints=$ctrl.alreadyComputedNumberOfPoints;$scope.currentNumberOfPoints=$ctrl.alreadyComputedNumberOfPoints}}$ctrl.onComputeButtonClick=function(){$ctrl.computeCurveFn($scope.numberOfPoints)};$ctrl.openModal=function(){CreateModalFromTemplate("/templates/ml/prediction-model/detailed-metrics/learning-curves-modal.html",$scope,null,function(newScope){newScope.save=()=>{$scope.numberOfPoints=newScope.numberOfPoints;newScope.dismiss()}},false,false,true)}}});app.component("learningCurves",{bindings:{modelData:"<",activeClassifierThreshold:"<"},templateUrl:"/templates/ml/prediction-model/detailed-metrics/learning-curves.html",controller:function($scope,DataikuAPI,FutureProgressModal,PerformanceMetricsDataComposer,ModelDataUtils,PMLSettings,WT1){const $ctrl=this;$ctrl.learningCurvePoints=[];$ctrl.availableMetrics=[];$ctrl.modelData={};$ctrl.trainRows=0;$ctrl.kfold=false;$ctrl.showCurve=false;$ctrl.showEmptyState=false;$ctrl.displayedTrainPoints=[];$ctrl.displayedTestPoints=[];$ctrl.$onInit=()=>{$ctrl.predictionType=$ctrl.modelData.coreParams.prediction_type;$ctrl.kfold=$ctrl.modelData.trainInfo.kfold;$ctrl.fullModelId=$ctrl.modelData.fullModelId;if($ctrl.kfold){$ctrl.trainRows=$ctrl.modelData.trainInfo.fullRows}else{$ctrl.trainRows=$ctrl.modelData.trainInfo.trainRows}getExistingLearningCurveData()};$ctrl.$onChanges=()=>{if($ctrl.metric&&$ctrl.metric.isThresholdDependent){setLearningCurvesAndMetrics($ctrl.rawLearningCurveResult)}};function getMetricsData(perf){const fakeModelData=angular.copy({...$ctrl.modelData,perf:perf});switch($ctrl.predictionType){case"BINARY_CLASSIFICATION":fakeModelData.userMeta.activeClassifierThreshold=$ctrl.activeClassifierThreshold;fakeModelData.perf.perCutData.cmg=ModelDataUtils.computeCmgForGivenPerf($ctrl.modelData,perf);return[...PerformanceMetricsDataComposer.getThresholdIndependentBinaryClassifMetricsData(fakeModelData,false).rows,...PerformanceMetricsDataComposer.getThresholdDependentBinaryClassifMetricsData(fakeModelData,false).rows];case"MULTICLASS":return PerformanceMetricsDataComposer.getMulticlassMetricsData(fakeModelData,false).rows;case"REGRESSION":return PerformanceMetricsDataComposer.getRegressionMetricsData(fakeModelData,false).rows}}function getAvailableMetrics(learningCurvePoint){const rawMetrics=learningCurvePoint.train_metrics;return rawMetrics.map(metric=>{return{name:metric.name,displayName:metric.displayName,isThresholdDependent:!!metric.variants[0].isThresholdDependent,isEvaluationMetric:metric.isEvaluationMetric,lowerBetter:PMLSettings.sort.lowerBetter.includes(metric.name),yAxisMax:metric.variants[0].yAxisMax,yAxisMin:metric.variants[0].yAxisMin}})}function setLearningCurvesAndMetrics(rawLearningCurveResult){if(!rawLearningCurveResult||!rawLearningCurveResult.perf_points){return}const learningCurvePoints=[];for(const point of rawLearningCurveResult.perf_points){learningCurvePoints.push({...point,train_metrics:getMetricsData(point.train_metrics),test_metrics:getMetricsData(point.test_metrics)})}$ctrl.learningCurvePoints=learningCurvePoints;if(!($ctrl.availableMetrics&&$ctrl.availableMetrics.length)){$ctrl.availableMetrics=getAvailableMetrics(learningCurvePoints[0])}if(!$ctrl.metric&&$ctrl.availableMetrics){const evaluationMetric=$ctrl.availableMetrics.find(metric=>metric.isEvaluationMetric);$ctrl.metric=evaluationMetric?evaluationMetric:$ctrl.availableMetrics[0]}$ctrl.setCurrentMetricPoints();$ctrl.alreadyComputedNumberOfPoints=$ctrl.learningCurvePoints.length;$ctrl.showEmptyState=false}function getMetricScore(point,metricName,metricDisplayName,isTrainScore){const pointMetrics=isTrainScore?point.train_metrics:point.test_metrics;const metric=pointMetrics.find(metric=>metric.name===metricName&&metric.displayName===metricDisplayName);if(metric&&metric.variants&&metric.variants.length){return metric.variants[0].value}}$ctrl.setCurrentMetricPoints=function(){if($ctrl.metric&&$ctrl.metric.name){$ctrl.currentMetricPoints=$ctrl.learningCurvePoints.map(point=>{return{trainSize:point.train_size,testSize:point.test_size,trainScore:getMetricScore(point,$ctrl.metric.name,$ctrl.metric.displayName,true),testScore:getMetricScore(point,$ctrl.metric.name,$ctrl.metric.displayName,false),trainTime:point.train_time}})}};const getExistingLearningCurveData=()=>{DataikuAPI.ml.prediction.getLearningCurves($ctrl.fullModelId).success(rawLearningCurveResult=>{if(rawLearningCurveResult&&rawLearningCurveResult.perf_points&&rawLearningCurveResult.perf_points.length){$ctrl.rawLearningCurveResult=rawLearningCurveResult;setLearningCurvesAndMetrics($ctrl.rawLearningCurveResult)}else{$ctrl.showEmptyState=true}}).error((data,status,headers)=>{$ctrl.showEmptyState=true;setErrorInScope.bind($scope)(data,status,headers)})};$ctrl.computeLearningCurves=numberOfPoints=>{DataikuAPI.ml.prediction.learningCurvesStart($ctrl.fullModelId,numberOfPoints).success(result=>{FutureProgressModal.show($scope,result,"Computing learning curve").then(rawLearningCurveResult=>{$ctrl.rawLearningCurveResult=rawLearningCurveResult;setLearningCurvesAndMetrics($ctrl.rawLearningCurveResult)})}).error(setErrorInScope.bind($scope));WT1.event("learning-curves-compute",{predictionType:$ctrl.predictionType})}}});app.component("learningCurvesPlot",{bindings:{points:"<",yAxisMin:"<",yAxisMax:"<",initialTrainRows:"<",kfold:"<"},template:`
        <div>
            <div block-api-error />
            <ng2-lazy-echart [options]="$ctrl.chartOptions" ng-if="$ctrl.chartOptions"></ng2-lazy-echart>
        </div>
    `,controller:function(){const $ctrl=this;$ctrl.initialTrainRows=0;$ctrl.kfold=false;function getSizeRatio(trainSize,testSize,initialTrainSize,kfold){if(kfold){return 100*trainSize/(initialTrainSize-testSize)}else{return 100*trainSize/initialTrainSize}}$ctrl.$onChanges=function(){if($ctrl.points&&$ctrl.points.length){$ctrl.chartOptions=buildChartOptions($ctrl.points,$ctrl.initialTrainRows,$ctrl.yAxisMin,$ctrl.yAxisMax)}};function timeFormatter(seconds){if(seconds<1){const miliseconds=Math.round(seconds*1e3);return`${miliseconds}ms`}if(seconds<10){return`${seconds.toFixed(3)}s`}if(seconds<60){return`${Math.round(seconds)}s`}else{const minutes=Math.floor(seconds/60);const remaining_seconds=Math.round(seconds%60);if(seconds===0){return`${minutes}min`}return`${minutes}min ${remaining_seconds}s`}}function getLegendMarker(color){return`<span style="display:inline-block;margin-right:5px;border-radius:10px;width:10px;height:10px;background-color:${color};"></span>`}function buildChartOptions(dataPoints,initialTrainSize,yAxisMin,yAxisMax){const trainColour="#4CAF50";const testColour="#3B99FC";const trainData=dataPoints.map(({trainSize,trainScore})=>[trainSize,trainScore]);const testData=dataPoints.map(({trainSize,testScore})=>[trainSize,testScore]);return{textStyle:{fontFamily:"SourceSansPro"},tooltip:{trigger:"item",borderColor:"#999999",textStyle:{color:"#000"},formatter:params=>{const point=$ctrl.points[params.dataIndex];const trainSize=point.trainSize;const trainRatio=getSizeRatio(point.trainSize,point.testSize,initialTrainSize,$ctrl.kfold);return`
                        <span>Model trained using ${sanitize(trainSize)} rows (${sanitize(trainRatio.toFixed(0))}% of the train dataset)</span>
                        <br/>
                        Train time: ${sanitize(timeFormatter(point.trainTime))}
                        <br/>
                        ${getLegendMarker(trainColour)}Train Score: ${sanitize(point.trainScore)}
                        <br/>
                        ${getLegendMarker(testColour)}Test Score: ${sanitize(point.testScore)}
                    `}},grid:{top:32,right:32,left:32,bottom:24,height:330,containLabel:true},xAxis:{type:"value",scale:false,name:"Training examples",nameLocation:"center",nameGap:24,min:0,max:"dataMax",axisLine:{lineStyle:{color:"#000"}}},yAxis:[{type:"value",scale:true,position:"left",name:"Score",nameLocation:"center",nameGap:40,axisLine:{lineStyle:{color:"#000"}},min:function(value){if(typeof yAxisMin!=="number"){return}if(yAxisMin<=value.min){return yAxisMin}else{return}},max:function(value){if(typeof yAxisMax!=="number"){return}if(yAxisMax>=value.max){return yAxisMax}else{return}}}],legend:{show:true,right:32,icon:"circle"},series:[{data:trainData,color:trainColour,name:"train",type:"line",yAxisIndex:0},{data:testData,color:testColour,name:"test",type:"line",symbolSize:4,yAxisIndex:0}]}}}})})();(function(){"use strict";const app=angular.module("dataiku.ml.report");app.component("globalExplanationsNavtool",{templateUrl:"/templates/ml/prediction-model/feature-importance/global_explanations_navtool.html",bindings:{showPartialDependencePlot:"<"},controller:function(){const $ctrl=this;$ctrl.scrollToGraph=function(selectedGraph){if(!selectedGraph){return}const selectedGraphDOM=document.getElementById(selectedGraph);if(selectedGraphDOM){selectedGraphDOM.scrollIntoView({behavior:"smooth"})}}}});app.component("featureFacts",{templateUrl:"/templates/ml/prediction-model/feature-importance/facts/feature_facts.html",bindings:{featureFacts:"<",selectedClass:"<",selectedColumn:"<"},controller:function($filter){const $ctrl=this;$ctrl.facts=[];$ctrl.buildFactNumericInfo=fact=>{let tooltipText=`Feature impact: ${$filter("nicePrecision")(fact.impact,2)}.`;if(fact.type==="CATEGORICAL"){tooltipText+=` Information gain: ${$filter("nicePrecision")(fact.infoGain,2)}`}else{tooltipText+=` Correlation: ${$filter("nicePrecision")(fact.correlation,2)}`}return tooltipText};function buildTopFacts(perClassFacts){const topFacts={};Object.keys(perClassFacts).map(klass=>{topFacts[klass]=Object.entries(perClassFacts[klass]).map(f=>f[1]).sort((factA,factB)=>factA.rank-factB.rank).slice(0,3)});return topFacts}function selectFacts(){if(!$ctrl.featureFacts)return;if(!$ctrl.selectedColumn){$ctrl.topFacts=buildTopFacts($ctrl.featureFacts);$ctrl.facts=$ctrl.topFacts[$ctrl.selectedClass]}else{$ctrl.facts=$ctrl.featureFacts[$ctrl.selectedClass][$ctrl.selectedColumn]&&[$ctrl.featureFacts[$ctrl.selectedClass][$ctrl.selectedColumn]]||[]}}$ctrl.onInit=function(){selectFacts()};$ctrl.$onChanges=function(){selectFacts()}}})})();(function(){"use strict";const app=angular.module("dataiku.ml.report");app.controller("DecisionTreeController",function($scope,DataikuAPI,$stateParams){DataikuAPI.ml.prediction.getTreeSummary($stateParams.fullModelId||$scope.fullModelId).success(function(data){if($.isEmptyObject(data)){$scope.noTreesFound=true;return}$scope.treeData=data;if(!!$scope.treeData.classes){$scope.classes=$scope.treeData.classes}else if($scope.modelData.preprocessing&&$scope.modelData.preprocessing.target_remapping){$scope.classes=$scope.modelData.preprocessing.target_remapping.map(x=>x.sourceValue)}}).error(function(){$scope.uiState.noTreesFound=true;setErrorInScope.apply($scope,arguments)})});app.controller("TreeEnsembleController",function($scope,DataikuAPI,$stateParams,Throttle){$scope.uiState={i:-1,nTrees:0,warningHidden:false,wasClipped:false,selectedPartition:$scope.uiState?$scope.uiState.selectedPartition:null};$scope.setIndex=function(i){$scope.uiState.i=i};$scope.nextTree=function(){if($scope.uiState.i<$scope.uiState.nTrees)$scope.uiState.i++};$scope.previousTree=function(){if($scope.uiState.i>1)$scope.uiState.i--};$scope.hideWarning=function(){$scope.uiState.warningHidden=true};var throttled=Throttle().withScope($scope).withDelay(500).wrap(function(){if($scope.uiState.i<=0)return;$scope.currentTree={featureNames:$scope.treeData.featureNames,tree:$scope.treeData.trees[$scope.uiState.i-1]}});$scope.$watch("uiState.i",function(nv,ov){if(nv<=0)return;throttled()});var p=DataikuAPI.ml.prediction.getEnsembleSummary($scope.uiState.selectedPartition||$stateParams.fullModelId||$scope.fullModelId).success(function(data){if($.isEmptyObject(data)){$scope.uiState.noTreesFound=true;return}$scope.treeData=data;if(!!$scope.treeData.classes){$scope.classes=$scope.treeData.classes}else if($scope.modelData.preprocessing&&$scope.modelData.preprocessing.target_remapping){$scope.classes=$scope.modelData.preprocessing.target_remapping.map(x=>x.sourceValue)}$scope.uiState.i=1;$scope.uiState.nTrees=data.trees.length;$scope.uiState.wasClipped=data.was_clipped;$scope.puppeteerHook_elementContentLoaded=true}).error(function(){$scope.uiState.noTreesFound=true;setErrorInScope.apply($scope,arguments)});if($scope.noSpinner)p.noSpinner()});app.directive("decisionTreeControl",function(FeatureNameUtils){return{replace:true,templateUrl:"/templates/ml/prediction-model/tree_summary_view.html",scope:{data:"=",classes:"=",coreParams:"=",disableTransitions:"=?"},link:function($scope,element,attrs){var i=0;var duration=200;var squareSize=30;var linkWidth=function(proportion){return.5+30*proportion};var diagonal=d3.svg.diagonal().projection(function(d){return[d.x,d.y]});var container=$(element[0]).find("#treeContainer svg");var svg=d3.select(element[0]).select("#treeContainer svg > g");var tree=d3.layout.tree();var height;var width;var nodeIntervalHeight=100;var depth=function(node){if(node.children){return 1+Math.max(depth(node.children[0]),depth(node.children[1]))}else{return 1}};var computeDimensions=function(){height=nodeIntervalHeight*depth(root);width=container.width();tree.size([width,height]);container.height(height)};var argmax=function(a){var max=a[0];var arg=0;for(var i=1;i<a.length;i++){if(a[i]>max){arg=i;max=arg}}return arg};var root={};var nodeColor={};$scope.colors={};var createNodeColor=function(root){var reduce=function(n,reducer,accessor){if(n.children){return reducer(reduce(n.children[0],reducer,accessor),reduce(n.children[1],reducer,accessor))}else{return accessor(n)}};if(root.predict||root.predict==0){var acc=function(d){return d.predict};nodeColor=d3.scale.linear().domain([reduce(root,Math.min,acc),root.predict,reduce(root,Math.max,acc)]).range(["blue","#f2f2f2","red"])}else if(root.probabilities.length==2){let acc=function(d){return d.probabilities[0]};var scale=d3.scale.linear().domain([reduce(root,Math.min,acc),root.probabilities[0],reduce(root,Math.max,acc)]).range(["blue","#f2f2f2","red"]);nodeColor=function(probabilities){return scale(probabilities[0])};$scope.colors=function(c){if(c==0){return"red"}else{return"blue"}}}else{var nFeat=root.probabilities.length;var globalScale=d3.scale.category10();var localScales=[];for(var i=0;i<nFeat;i++){var col=globalScale(i%10);let acc=function(d){return d.probabilities[i]};var local=d3.scale.linear().domain([1/nFeat,Math.max(reduce(root,Math.max,acc),.001+1/nFeat)]).range(["#f2f2f2",col]);localScales.push(local)}nodeColor=function(probabilities){var winner=argmax(probabilities);return localScales[winner](probabilities[winner])};$scope.colors=function(c){return globalScale(c%10)}}};var createGradients=function(root){var makeArray=function(node){var res=[];if(node.children){var left=makeArray(node.children[0]);var right=makeArray(node.children[1]);res=left.concat(right)}res.push({color:nodeColor(node.probabilities||node.predict)});return res};var gradients=svg.append("defs").selectAll("linearGradient").data(makeArray(root)).enter().append("linearGradient").attr("id",function(d){return"gradient-"+d.color}).attr("spreadMethod","pad").attr("x1","0%").attr("x2","0%").attr("x1","0%").attr("y2","100%");gradients.append("stop").attr("offset","0%").attr("stop-color",function(d){return d.color}).attr("stop-opacity",1);gradients.append("stop").attr("offset","100%").attr("stop-color","white").attr("stop-opacity",0)};var updateNodeInformation=function(node,updateScope){if(node.probabilities){$scope.probabilities=node.probabilities;$scope.predict=$scope.classes[argmax(node.probabilities)];$scope.currentNodeColor=nodeColor(node.probabilities);$scope.targetClassesProportions=node.targetClassesProportions}else{$scope.predict=node.predict.toFixed(2);$scope.currentNodeColor=nodeColor($scope.predict)}$scope.nSamples=node.nSamples;$scope.nSamplesWeighted=node.nSamplesWeighted;$scope.proportion=(node.proportion*100).toFixed(2)+"%";$scope.proportionWeighted=(node.proportionWeighted*100).toFixed(2)+"%";updateBreadcrumb(node);if(updateScope){$scope.$apply()}};var nodify=function(data,index,maxSamples,maxSamplesWeighted){var node={};var tree=data.tree;$scope.warningMessage=tree.warningMessage;if(tree.nSamples){node.nSamples=tree.nSamples[index];node.proportion=tree.nSamples[index]/parseFloat(maxSamples)}if(tree.nSamplesWeighted){node.nSamplesWeighted=tree.nSamplesWeighted[index];node.proportionWeighted=tree.nSamplesWeighted[index]/parseFloat(maxSamplesWeighted)}if(node.proportionWeighted&&!node.proportion){node.proportion=node.proportionWeighted}if(tree.leftChild[index]>0){node.feature=data.featureNames[tree.feature[index]];node.threshold=tree.threshold[index]}if(tree.probas){node.probabilities=tree.probas[index];if(tree.targetClassesProportions){node.targetClassesProportions=tree.targetClassesProportions[index]}}else{node.predict=tree.predict[index]}return node};var treeify=function(data,index){index=typeof index!=="undefined"?index:0;var maxSamples=data.tree.nSamples?data.tree.nSamples[0]:null;var maxSamplesWeighted=data.tree.nSamplesWeighted?data.tree.nSamplesWeighted[0]:null;var result=nodify(data,index,maxSamples,maxSamplesWeighted);if(data.tree.leftChild[index]>0){var left=treeify(data,data.tree.leftChild[index]);left.isLeftChild=true;var right=treeify(data,data.tree.rightChild[index]);right.isLeftChild=false;result.children=[left,right]}return result};var collapse=function(d,height){if(d.children){if(height==0){d._children=d.children;d._children.forEach(function(node){collapse(node,0)});d.children=null}else{d.children.forEach(function(node){collapse(node,height-1)})}}else if(d._children&&height>0){d.children=d._children;d.children.forEach(function(node){collapse(node,height-1)})}};const splitDescription=function(feature,threshold,isTrue){const result={};const featureElements=FeatureNameUtils.getAsTextElements(feature);if(featureElements.type=="countvec"){let level=featureElements.value;if(level==""){level="empty"}result.left=featureElements.feature+" contains "+level;result.right=threshold.toFixed(2)+" times";result.operator=isTrue?" ≤ ":" > "}else if(featureElements.type=="tfidfvec"){let level=featureElements.rawValue;if(level==""){level="empty"}result.left=featureElements.feature+": tfidf of "+level;result.right=threshold.toFixed(2);result.operator=isTrue?" ≤ ":" > "}else if(featureElements.value!=null){let level=featureElements.value;if(level==""){level="empty"}result.left=featureElements.feature;result.right=level;if(featureElements.type==="hashing"&&threshold<0){result.operator=isTrue?featureElements.operator:featureElements.no_operator;result.right="-"+result.right}else{result.operator=isTrue?featureElements.no_operator:featureElements.operator}}else{result.left=featureElements.feature;result.right=threshold.toFixed(2);result.operator=isTrue?" ≤ ":" > "}return result};var buildBreadcrumb=function(node,from){var isTrue=node.children[0]==from;var bcElem={rule:splitDescription(node.feature,node.threshold,isTrue)};if(node.parent){var bc=buildBreadcrumb(node.parent,node);bc.push(bcElem);return bc}else{return[bcElem]}};var updateBreadcrumb=function(from){if(from.parent){var bc=buildBreadcrumb(from.parent,from);$scope.breadcrumb=bc}else{$scope.breadcrumb=[]}};var expandAll=function(node,shouldUpdate){if(node._children){node.children=node._children;node._children=null}if(node.children){expandAll(node.children[0],false);expandAll(node.children[1],false)}if(shouldUpdate){update(node)}};$scope.expandAll=function(){expandAll(root,true)};$scope.reset=function(){collapse(root,3);update(root,true)};$scope.$watch("data",function(){if($scope.data){root=treeify($scope.data);createNodeColor(root);createGradients(root);root.x0=width/2;root.y0=0;collapse(root,3);updateNodeInformation(root,false);update(root);$scope.puppeteerHook_elementContentLoaded=true}});computeDimensions();d3.select(window).on("resize.dtc",function(){update()});var update=function(source,noAnimation){var actualDuration=noAnimation||$scope.disableTransitions?0:duration;computeDimensions();var nodes=tree.nodes(root).reverse();var links=tree.links(nodes);var levelWidth=10;nodes.forEach(function(d){d.y=d.depth*nodeIntervalHeight});var node=svg.selectAll("g.node").data(nodes,function(d){return d.id||(d.id=++i)});var nodeEnter=node.enter().append("g").attr("class","node").attr("transform",function(d){return"translate("+source.x0+","+source.y0+")"}).style("cursor",function(d){if(d._children||d.children){return"pointer"}else{return"default"}}).on("click",click).on("mouseover",function(d){updateNodeInformation(d,true)});nodeEnter.append("rect").attr("width","1px").attr("height","1px").style("fill",function(d){return nodeColor(d.probabilities?d.probabilities:d.predict)});node.selectAll("text").remove();node.selectAll("rect.tree-text-backdrop").remove();node.selectAll("rect.edge-fade").remove();node.append("text").text(function(d){if(d.children){var desc=splitDescription(d.feature,d.threshold,false);return desc.left+" "+desc.operator+" "+desc.right}else{return""}}).attr("text-anchor",function(d){return d.children||d._children?"middle":"middle"}).attr("x",function(d){return d.children?60:15}).attr("y",function(d){return d.children?80:45}).call(function(selection){selection.each(function(d){d.bbox=this.getBBox()})});node.insert("rect","text").classed("tree-text-backdrop",true).attr("x",function(d){return d.bbox.x}).attr("y",function(d){return d.bbox.y}).attr("width",function(d){return d.bbox.width}).attr("height",function(d){return d.bbox.height}).style("fill","rgba(255,255,255,0.7)");node.filter(function(d){return d._children}).append("rect").classed("edge-fade",true).attr("x",function(d){return squareSize/2-linkWidth(d.proportion)/2}).attr("y",function(d){return squareSize}).attr("width",function(d){return linkWidth(d.proportion)}).attr("height",20).style("fill",function(d){return"url(#gradient-"+nodeColor(d.probabilities||d.predict)+")"});var nodeUpdate=node.transition().duration(actualDuration).attr("transform",function(d){return"translate("+(d.x-squareSize/2)+","+(d.y-squareSize/2)+")"});nodeUpdate.select("rect").attr("width","30px").attr("height","30px");nodeUpdate.select("text").style("fill-opacity",1);var nodeExit=node.exit().transition().duration(actualDuration).attr("transform",function(d){return"translate("+source.x+","+source.y+")"}).remove();nodeExit.select("rect").attr("width","1px").attr("height","1px");nodeExit.select("text").style("fill-opacity",1e-6);var link=svg.selectAll("path.link").data(links,function(d){return d.target.id});var linkEnter=link.enter().insert("path","g").attr("class","link").attr("d",function(d){var o={x:source.x0,y:source.y0};return diagonal({source:o,target:o})}).style("fill","none").style("stroke",function(d){return nodeColor(d.target.probabilities?d.target.probabilities:d.target.predict)}).style("stroke-width",function(d){return linkWidth(d.target.proportion)});link.transition().duration(actualDuration).attr("d",function(d){var parentWidth=linkWidth(d.source.proportion);var width=linkWidth(d.target.proportion);var dy;if(d.target.isLeftChild){dy=(width-parentWidth)/2}else{dy=(parentWidth-width)/2}var src={x:d.source.x+dy,y:d.source.y};var coords={source:src,target:d.target};return diagonal(coords)});link.exit().transition().duration(actualDuration).attr("d",function(d){var o={x:source.x,y:source.y};return diagonal({source:o,target:o})}).remove();nodes.forEach(function(d){d.x0=d.x;d.y0=d.y})};function click(d){if(d.children){d._children=d.children;d.children=null}else{d.children=d._children;d._children=null}update(d)}$scope.$on("$destroy",function(){d3.select(window).on("resize.dtc",null)})}}})})();(function(){"use strict";var app=angular.module("dataiku.ml.report");app.controller("_ClusteringModelReportController",function($scope,$controller,DataikuAPI,Debounce,$stateParams,ActivityIndicator,categoricalPalette,CMLFilteringService,$q,CachedAPICalls){$controller("_ModelReportControllerBase",{$scope:$scope});$scope.fetchModelDetails=function(){const getModelP=DataikuAPI.ml.clustering.getModelDetails($stateParams.fullModelId||$scope.fullModelId);if($scope.noSpinner){getModelP.noSpinner()}return getModelP.then(({data})=>{$scope.modelData=data;CachedAPICalls.cmlDiagnosticsDefinition.then(cmlDiagnosticsDefinition=>{$scope.diagnosticsDefinition=cmlDiagnosticsDefinition($scope.modelData.coreParams.backendType)})})};$scope.fetchModelIfNotInScope=function(){if($scope.modelData)return $q.when(null);else{return $scope.fetchModelDetails()}};$scope.configureAfterModelFetch=function(){onModelLoaded();if($scope.mlTasksContext)$scope.mlTasksContext.model=$scope.modelData;if($scope.smContext)$scope.smContext.model=$scope.modelData;if($scope.onLoadSuccess)$scope.onLoadSuccess()};$scope.deferredAfterInitCModelReportDataFetch=$scope.fetchModelIfNotInScope().then($scope.configureAfterModelFetch).catch(err=>{setErrorInScope.bind($scope)(err);if($scope.onLoadError&&err.status)$scope.onLoadError(err.data,err.status,err.headers,err.config,err.statusText)});function saveMeta(){if($scope.readOnly)return;DataikuAPI.ml.saveModelUserMeta($stateParams.fullModelId||$scope.fullModelId,$scope.modelData.userMeta).success(function(){ActivityIndicator.success("Saved")}).error(setErrorInScope.bind($scope))}var debouncedSaveMeta=Debounce().withDelay(400,1e3).wrap(saveMeta);$scope.$watch("modelData.userMeta",function(nv,ov){if(!nv||!ov||_.isEqual(nv,ov))return;debouncedSaveMeta()},true);var onModelLoaded=function(){const{clusterMetas}=$scope.modelData.userMeta;$scope.clusterMetasSize=0;if(clusterMetas){$scope.clusterMetasSize=Object.keys(clusterMetas).length}};var generateClusterColor=function(clusterId,i){var algo=$scope.modelData.modeling.algorithm;if(algo=="PY_ISOLATION_FOREST"||algo=="MLLIB_ISOLATION_FOREST"){if(clusterId=="regular"){return"green"}else if(clusterId=="anomalies"){return"orange"}}return categoricalPalette(i)};$scope.getClusterMeta=function(clusterId){const{clusterMetas}=$scope.modelData.userMeta;if(!clusterMetas){return null}if(clusterMetas[clusterId]===undefined){clusterMetas[clusterId]={name:clusterId,color:generateClusterColor(clusterId,$scope.clusterMetasSize),colors:window.dkuColorPalettes.discrete.find(palette=>palette.id==="dku_font").colors};$scope.clusterMetasSize+=1}return clusterMetas[clusterId]};$scope.hasHierarchy=function(){return["PY_TWO_STEP","MLLIB_TWO_STEP"].indexOf($scope.getAlgorithm())>-1};$scope.hasAnomalies=function(){return["PY_ISOLATION_FOREST","MLLIB_ISOLATION_FOREST"].indexOf($scope.getAlgorithm())>-1};$scope.isInertiaAvailable=function(){return["KMEANS","MLLIB_KMEANS","MiniBatchKMeans","SCIKIT_MODEL","MLLIB_CUSTOM","MLLIB_GAUSSIAN_MIXTURE","MLLIB_TWO_STEP","MLLIB_ISOLATION_FOREST"].indexOf($scope.getAlgorithm())>=0};$scope.getMetricNameFromModel=CMLFilteringService.getMetricNameFromModel.bind(CMLFilteringService);$scope.getMetricValueFromModel=CMLFilteringService.getMetricValueFromModel.bind(CMLFilteringService)});app.controller("CMLReportTrainController",function($scope,CMLSettings,MLDiagnosticsService){$scope.mti=$scope.modelData.trainInfo;$scope.reduce=$scope.modelData.preprocessing.reduce;$scope.outliers=angular.extend({},$scope.modelData.preprocessing.outliers);$scope.outliers.nope=$scope.outliers.method==="NONE";$scope.outliers.method=arr2obj(CMLSettings.task.outliersMethods)[$scope.outliers.method]||$scope.outliers.method;$scope.diagnostics=MLDiagnosticsService.groupByType($scope.modelData.mlDiagnostics);$scope.isMLBackendType=function(mlBackendType){return $scope.modelData.coreParams.backendType===mlBackendType};$scope.canDisplayDiagnostics=function(){return true}});app.controller("ClusterEditController",function($scope){$scope.$watch("meta",function(){if($scope.meta){$scope.details={name:$scope.meta.name,description:$scope.meta.description,color:$scope.meta.color,colors:window.dkuColorPalettes.discrete.find(palette=>palette.id==="dku_font").colors}}});$scope.confirm=function(){$scope.meta.name=$scope.details.name;$scope.meta.description=$scope.details.description;$scope.meta.color=$scope.details.color;$scope.dismiss();if($scope.callback)$scope.callback()}});app.controller("CMLModelFactsController",function($scope,$controller,$state,$stateParams,categoricalPalette,Dialogs,DataikuAPI,CreateModalFromTemplate,WT1){$scope.colors=window.dkuColorPalettes.discrete.find(palette=>palette.id==="dku_font").colors;$controller("_MLReportSummaryController",{$scope:$scope});$controller("EvaluationLabelUtils",{$scope:$scope});$scope.$watch("modelData",function(nv,ov){if(nv)$scope.facts=nv.facts;main()});var computeObservations=function(clusterLabel){var observations;for(var i=0;i<$scope.facts.clusters.length;i++){var cluster_facts=$scope.facts.clusters[i];if(cluster_facts.cluster==clusterLabel){observations=cluster_facts.facts;break}}if(observations){observations.forEach(function(obs){if(obs.type=="numerical"){obs.sameSign=obs.mean/obs.global_mean>0;if(obs.sameSign){obs.negative=obs.global_mean<0;obs.relative_diff=Math.abs((obs.mean-obs.global_mean)*100/obs.global_mean);obs.polarity=obs.mean>obs.global_mean?"greater":"smaller"}else{}}else if(obs.type=="categorical"){obs.polarity=obs.current_ratio>obs.global_ratio?"greater":"smaller"}});return observations}};var main=function(){if(!$scope.selectedCluster&&$scope.facts.clusters.length){$scope.selectCluster($scope.facts.clusters[0])}};$scope.selectCluster=function(cluster){$scope.selectedCluster=cluster;$scope.observations=computeObservations($scope.selectedCluster.cluster)};$scope.editClusterDetails=function(meta){WT1.event("clustering-facts-edit-node");CreateModalFromTemplate("/templates/ml/clustering-model/cluster-details-edit.html",$scope,"ClusterEditController",function(newScope){newScope.meta=meta})}});app.factory("ClusteringHeatmapUtils",function(ExportUtils){var utils={};utils.numericalWelchTStat=function(m1,m2,s1,s2,n1,n2){var denom=Math.sqrt(s1*s1/n1+s2*s2/n2);if(denom==0){return m1>m2?100:m1<m2?-100:0}return(m1-m2)/denom};utils.categoricalWelchTStat=function(p1,p2,n1,n2){var denom=Math.sqrt(p1*(1-p1)/n1+p2*(1-p2)/n2);if(denom==0){return p1>p2?100:p1<p2?-100:0}return(p1-p2)/denom};utils.exportStacked=function(scope,data){var columns=[];var exportData=[];for(var j=0;j<data.cluster_labels.length;j++){var cluster=scope.getClusterMeta(data.cluster_labels[j]).name;columns.push({name:cluster+"_feature",type:"string"});columns.push({name:cluster+"_is_numeric_feature",type:"boolean"});columns.push({name:cluster+"_global_mean",type:"double"});columns.push({name:cluster+"_mean",type:"double"});columns.push({name:cluster+"_global_std",type:"double"});columns.push({name:cluster+"_std",type:"double"});columns.push({name:cluster+"_relative_importance",type:"double"});var cluster_data=[];for(let i=0;i<data.num_names.length;i++){var global_avg=data.num_averages[i];var avg=data.cluster_num_averages[j][i];var std=data.cluster_num_std_devs[j][i];var global_std=data.num_std_devs[i];let tStat=utils.numericalWelchTStat(avg,global_avg,std,global_std,data.cluster_sizes[j],data.total_size);cluster_data.push([data.num_names[i],true,global_avg,avg,global_std,std,tStat])}for(let i=0;i<data.cat_names.length;i++){for(var k=0;k<data.levels[i].length;k++){var name=data.cat_names[i]+"="+data.levels[i][k];var prop=data.cluster_proportions[j][i][k];var global_prop=data.proportions[i][k];let tStat=utils.categoricalWelchTStat(prop,global_prop,data.cluster_sizes[j],data.total_size);cluster_data.push([name,false,global_prop,prop,null,null,tStat])}}cluster_data.sort(function(a,b){var da=Math.abs(a[6]);var db=Math.abs(b[6]);if(da[6]<db[6]){return 1}else if(da[6]>db[6]){return-1}else{return 0}});for(var t=0;t<cluster_data.length;t++){if(!exportData[t]){exportData.push(cluster_data[t])}else{exportData[t]=exportData[t].concat(cluster_data[t])}}}ExportUtils.exportUIData(scope,{name:"Stacked columns clustering report for "+scope.modelData.userMeta.name,columns:columns,data:exportData},"Export stacked data")};utils.exportTabular=function(scope,data){var exportData=[];for(var j=0;j<data.cluster_labels.length;j++){var cluster_label=scope.getClusterMeta(data.cluster_labels[j]).name;for(let i=0;i<data.num_names.length;i++){var global_avg=data.num_averages[i];var avg=data.cluster_num_averages[j][i];var std=data.cluster_num_std_devs[j][i];var global_std=data.num_std_devs[i];let tStat=utils.numericalWelchTStat(avg,global_avg,std,global_std,data.cluster_sizes[j],data.total_size);exportData.push([cluster_label,data.num_names[i],true,global_avg,avg,global_std,std,null,null,tStat])}for(let i=0;i<data.cat_names.length;i++){for(var k=0;k<data.levels[i].length;k++){var name=data.cat_names[i]+"="+data.levels[i][k];var prop=data.cluster_proportions[j][i][k];var global_prop=data.proportions[i][k];let tStat=utils.categoricalWelchTStat(prop,global_prop,data.cluster_sizes[j],data.total_size);exportData.push([cluster_label,name,false,null,null,null,null,prop,global_prop,tStat])}}}exportData.sort(function(v1,v2){if(v1[0]<v2[0]){return-1}else if(v1[0]>v2[0]){return 1}else{var d1=Math.abs(v1[9]);var d2=Math.abs(v2[9]);if(d1<d2){return 1}else if(d1>d2){return-1}else{return 0}}});ExportUtils.exportUIData(scope,{name:"Tabular clustering report for "+scope.modelData.userMeta.name,columns:[{name:"cluster_label",type:"string"},{name:"feature",type:"string"},{name:"is_numeric_feature",type:"boolean"},{name:"global_mean",type:"double"},{name:"mean",type:"double"},{name:"global_std",type:"double"},{name:"std",type:"double"},{name:"proportion",type:"double"},{name:"global_proportion",type:"double"},{name:"relative_importance",type:"double"}],data:exportData},"Export tabular data")};return utils});app.controller("ClusteringHeatmapController",function($scope,Dialogs,ClusteringHeatmapUtils,CreateModalFromTemplate,WT1){var data=$scope.modelData.heatmap;$scope.clusters=data.cluster_labels;var square=function(x){return x*x};var selectNum=function(index){for(let i=0;i<data.num_names.length;i++){$scope.featureIndex.push(index);$scope.featureInfo.push({numerical:true,name:data.num_names[i]});index++;var dat=[];for(var j=0;j<data.cluster_labels.length;j++){var global_avg=data.num_averages[i];var avg=data.cluster_num_averages[j][i];var std=data.cluster_num_std_devs[j][i];var global_std=data.num_std_devs[i];var tStat=ClusteringHeatmapUtils.numericalWelchTStat(avg,global_avg,std,global_std,data.cluster_sizes[j],data.total_size);dat.push({avg:avg,std:std,global_std:global_std,global_avg:global_avg,tStat:tStat})}$scope.data.push(dat)}return index};$scope.cat_names=[];for(var i=0;i<data.cat_names.length;i++){$scope.cat_names.push({index:i,name:data.cat_names[i]})}$scope.cat_names.sort(function(a,b){var l1=data.levels[a.index].length;var l2=data.levels[b.index].length;if(l1==l2)return 0;return l1<l2?-1:1});var selectCat=function(f,index){for(var lev=0;lev<data.levels[f].length;lev++){$scope.featureIndex.push(index);$scope.featureInfo.push({numerical:false,name:data.cat_names[f]+"="+data.levels[f][lev]});index++;var dat=[];for(var c=0;c<data.cluster_labels.length;c++){var prop=data.cluster_proportions[c][f][lev];var global_prop=data.proportions[f][lev];var tStat=ClusteringHeatmapUtils.categoricalWelchTStat(prop,global_prop,data.cluster_sizes[c],data.total_size);dat.push({proportion:prop,global_proportion:global_prop,tStat:tStat})}$scope.data.push(dat)}return index};var selectAllCat=function(index){for(var f=0;f<data.cat_names.length;f++){index=selectCat(f,index)}return index};var init=function(){$scope.selectedFeature=-1;$scope.selectedCluster=-1;$scope.featureIndex=[];$scope.data=[];$scope.featureInfo=[]};var createColors=function(){var max=0;for(let i=0;i<$scope.data.length;i++){for(var j=0;j<$scope.data[i].length;j++){var a=Math.abs($scope.data[i][j].tStat);if(a>max){max=a}}}var globalScale=d3.scale.linear().domain([-max,-10,-2,0,2,10,max]).range(["#4285f4","#92abf9","#ccd4fc","#ffffff","#fbbab2","#ea746a","#ce1329"]);$scope.getElementColor=function(fi,ci){return globalScale($scope.data[fi][ci].tStat)}};var totalFeatures=data.num_names.length;for(let i=0;i<data.levels.length;i++){totalFeatures+=data.levels[i].length}var featureLimit=100;$scope.selectAllFeatures=function(){var selection=function(){var index=0;init();index=selectNum(index);selectAllCat(index);$scope.selectionMode="ALL";createColors()};if(totalFeatures>featureLimit){Dialogs.confirm($scope,"View all","There are "+totalFeatures+" features, viewing them all may cause poor performance.").then(selection)}else{selection()}};$scope.selectOnlyNumeric=function(){init();selectNum(0);$scope.selectionMode="NUMERIC";createColors()};$scope.selectSpecificCat=function(f){var selection=function(){init();selectCat(f,0);$scope.selectedCategorical=f;$scope.selectionMode="CAT";createColors()};var nLevels=data.levels[f].length;if(nLevels>featureLimit){Dialogs.confirm($scope,"View categorical feature","There are "+nLevels+" categories, viewing them all may cause poor performance.").then(selection)}else{selection()}};$scope.clusterIndex=[];for(let i=0;i<$scope.clusters.length;i++){$scope.clusterIndex.push(i)}if(totalFeatures>featureLimit){$scope.selectOnlyNumeric()}else{$scope.selectAllFeatures()}$scope.selectedCluster=-1;$scope.selectedFeature=-1;$scope.tableWidth=50*$scope.clusters.length;$scope.additionalWidth=0;if($scope.tableWidth>400){$scope.additionalWidth=220}$scope.clusterOffset=function(){return-($scope.selectedFeature==-1?0:50*$scope.featureIndex.indexOf($scope.selectedFeature))};$scope.featureOffset=function(){return $scope.selectedCluster==-1?0:50*$scope.clusterIndex.indexOf($scope.selectedCluster)+1};$scope.sortDescending=true;$scope.sortFeatures=function(index){if(index!=$scope.selectedCluster){$scope.sortDescending=true}else{$scope.sortDescending=!$scope.sortDescending}$scope.selectedCluster=index;$scope.selectedFeature=-1;$scope.featureIndex.sort(function(i,j){var x1=Math.abs($scope.data[i][index].tStat);var x2=Math.abs($scope.data[j][index].tStat);if(x1==x2){return 0}else{var s=x1<x2?1:-1;return $scope.sortDescending?s:-s}})};$scope.sortClusters=function(index){if(index!=$scope.selectedFeature){$scope.sortDescending=true}else{$scope.sortDescending=!$scope.sortDescending}$scope.selectedFeature=index;$scope.selectedCluster=-1;$scope.clusterIndex.sort(function(i,j){var x1=Math.abs($scope.data[index][i].tStat);var x2=Math.abs($scope.data[index][j].tStat);if(x1==x2){return 0}else{var s=x1<x2?1:-1;return $scope.sortDescending?s:-s}})};$scope.reset=function(){$scope.selectedFeature=-1;$scope.selectedCluster=-1;var ftSize=$scope.featureIndex.length;$scope.featureIndex=[];for(let i=0;i<ftSize;i++){$scope.featureIndex.push(i)}$scope.clusterIndex=[];for(let i=0;i<$scope.clusters.length;i++){$scope.clusterIndex.push(i)}};$scope.editClusterDetails=function(ci){WT1.event("clustering-heatmap-edit-node");CreateModalFromTemplate("/templates/ml/clustering-model/cluster-details-edit.html",$scope,"ClusterEditController",function(newScope){newScope.meta=$scope.getClusterMeta($scope.clusters[ci])})};$scope.tooltipHtml=function(fi,ci){var cluster=$scope.getClusterMeta($scope.clusters[ci]).name;var info=$scope.featureInfo[fi];var html="<strong>Cluster: </strong>"+sanitize(cluster)+"<br/>"+"<strong>Feature: </strong>"+sanitize(info.name)+"<br/>";var d=$scope.data[fi][ci];let diff;if(info.numerical){diff=(d.avg-d.global_avg)/d.global_avg}else{diff=(d.proportion-d.global_proportion)/d.global_proportion}const percentageWithSign=value=>(value>0?"+":"")+(value*100).toFixed(2)+"%";if(info.numerical){var stdDiff=(d.std-d.global_std)/d.std;html+=`<strong>Average:</strong> ${d.avg.toFixed(2)} <em>(${d.global_avg.toFixed(2)} globally, ${percentageWithSign(diff)})</em><br>`;html+=`<strong>Std. Dev.:</strong> ${d.std.toFixed(2)} <em>(${d.global_std.toFixed(2)} globally, ${percentageWithSign(stdDiff)})</em><br>`}else{html+=`<strong>${(d.proportion*100).toFixed(2)}% of cluster</strong> <em>(${(d.global_proportion*100).toFixed(2)}% globally, ${percentageWithSign(diff)})</em><br>`}html+=`<strong>Relative importance:</strong> ${d.tStat.toFixed(2)}`;return"<div style='position: relative; background: white; z-index: 5'>"+html+"</div>"};$scope.exportTabular=function(){ClusteringHeatmapUtils.exportTabular($scope,data)};$scope.exportStacked=function(){ClusteringHeatmapUtils.exportStacked($scope,data)};$scope.puppeteerPrepareForExport=function(){$scope.modelDocumentExport=true;$scope.$apply()}});app.directive("sortableHeatmap",function(){return{template:"<div id='content'></div>",scope:{data:"=data"},link:function(scope,element){var width=800;var height=800;var tileSize=50}}});(function(){var BRICK_STRIDE=24;var BRICK_WIDTH=22;var BRICK_MARGIN_TOP=15;var BRICK_MAX_HEIGHT=120;var LEFT_MARGIN_TO_CHART=66;var RIGHT_MARGIN=10;var possibleNumberOfBricks=[5,6,10,12,15,20,30,60];app.directive("stackedHistograms",function(categoricalPalette,Dialogs,CreateModalFromTemplate,WT1){return{restrict:"E",templateUrl:"/templates/ml/clustering-model/cluster-profiling-stacked.html",link:function(scope,element){scope.profilingUI={profilingMode:"average",variables:[],selectedVariable:null};var refresh=function(){scope.profilingUI.variables=scope.modelData.clustersProfiling;if(scope.profilingUI.selectedVariable){var found=false;for(var k in scope.profilingUI.variables){var v=scope.profilingUI.variables[k];if(v.variable==scope.profilingUI.selectedVariable.variable){scope.profilingUI.selectedVariable=v;found=true;break}}if(!found){scope.profilingUI.selectedVariable=null}}};scope.$watch("profilingUI.profilingMode",refresh,true);scope.hover={id:-1};scope.editClusterDetails=function(meta){WT1.event("clustering-profiling-edit-node");CreateModalFromTemplate("/templates/ml/clustering-model/cluster-details-edit.html",scope,"ClusterEditController",function(newScope){newScope.meta=meta})};scope.$watch("modelData",function(nv,ov){refresh();if(nv!=null&&!scope.profilingUI.selectedVariable&&scope.profilingUI.variables.length>0){scope.profilingUI.selectedVariable=scope.profilingUI.variables[0]}});scope.categoricalPalette=categoricalPalette;var brickDataNumerical=function(per_cluster_data,nbBricks){if(per_cluster_data.distribution===undefined){return undefined}var brickData=[];for(let i=0;i<nbBricks;i++){brickData.push({x:LEFT_MARGIN_TO_CHART+BRICK_STRIDE*i,y:0})}var groupSize=60/nbBricks;for(let i=0;i<60;i++){var bucketId=i/groupSize|0;brickData[bucketId].y+=per_cluster_data.distribution[i]}for(let i=0;i<brickData.length;i++){var ratio=brickData[i].y/per_cluster_data.total_no_nan;scope.max_ratio=Math.max(ratio,scope.max_ratio);brickData[i].ratio=ratio}return brickData};var brickDataCategorical=function(per_cluster_data,nbBricks){if(per_cluster_data.distribution===undefined){return undefined}var brickData=[];nbBricks=Math.min(nbBricks,per_cluster_data.distribution.length);for(var i=0;i<nbBricks;i++){var p=per_cluster_data.distribution[i];scope.max_ratio=Math.max(scope.max_ratio,p.ratio);brickData.push({x:LEFT_MARGIN_TO_CHART+BRICK_STRIDE*i,y:p.count,ratio:p.ratio})}return brickData};var aggregateData=function(){if(!scope.profilingUI.selectedVariable.global)return;scope.max_ratio=0;var W=element.find(".right-area").first().innerWidth();var maxNbBricks=(W-LEFT_MARGIN_TO_CHART-RIGHT_MARGIN)/24;var nbBricks=5;for(var i=0;i<possibleNumberOfBricks.length;i++){var nbBricksCandidate=possibleNumberOfBricks[i];if(maxNbBricks>=nbBricksCandidate){nbBricks=nbBricksCandidate}else{break}}var makeBrickData={numerical:brickDataNumerical,categorical:brickDataCategorical}[scope.profilingUI.selectedVariable.type];scope.profilingUI.selectedVariable.global.brickData=makeBrickData(scope.profilingUI.selectedVariable.global,nbBricks);for(var k=0;k<scope.profilingUI.selectedVariable.per_cluster.length;k++){var per_cluster_data=scope.profilingUI.selectedVariable.per_cluster[k];per_cluster_data.brickData=makeBrickData(per_cluster_data,nbBricks)}scope.profilingUI.selectedVariable.scale.max_ratio=scope.max_ratio};scope.$watch("profilingUI.selectedVariable",aggregateData);scope.$on("reflow",aggregateData);$(window).on("resize",aggregateData);scope.$on("$destroy",function(){$(window).off("resize",aggregateData)})}}});function horizontalLine(x1,x2){return"M"+x1+","+0+"L"+x2+","+0}function whiskerPlot(g,whiskerData,xScale){var height=18;var halfHeight=height/2;var median=whiskerData.median;var whiskerPlot=g.append("g").attr("class","whiskerPlot").attr("transform","translate(0,"+halfHeight+")");whiskerPlot.append("path").attr("d",horizontalLine(xScale(whiskerData.percentile9),xScale(whiskerData.percentile91)));whiskerPlot.append("rect").attr("x",xScale(whiskerData.percentile25)).attr("y",-halfHeight).attr("width",Math.max(2,xScale(whiskerData.percentile75)-xScale(whiskerData.percentile25))).attr("height",height).attr("rx",6).attr("ry",4);whiskerPlot.append("circle").attr("cx",xScale(whiskerData.percentile9)).attr("cy",0).attr("r",2);whiskerPlot.append("circle").attr("cx",xScale(whiskerData.percentile91)).attr("cy",0).attr("r",2);whiskerPlot.append("circle").attr("cx",xScale(whiskerData.median)).attr("cy",0).attr("r",2);return whiskerPlot}app.directive("bzHistogram",function(){return{restrict:"E",template:'<svg>                                <defs>                <pattern id="diagonalHatch" patternUnits="userSpaceOnUse" width="8" height="8">                    <path d="M-2,2 l4,-4 M0,8 l8,-8 M6,10 l4,-4" stroke="#feffff" stroke-width="1.5"></path>                </pattern>            </defs>            <g id="chart"></g>            <rect class="stripe" style="fill: url(#diagonalHatch)"></rect>            </svg>',scope:{data:"=data",color:"=color",scale:"=scale",categorical:"=categorical",showScale:"=showScale",hover:"=hover",whiskerData:"=whiskerData",nbBricks:"=nbBricks"},link:function(scope,element){var svg=d3.select(element[0]).select("svg");var yScale,xScale;var refreshHistogram=function(){if(scope.data===undefined||scope.data.length==0){return}xScale=d3.scale.linear().range([0,BRICK_STRIDE*scope.data.length]).domain([scope.scale.min,scope.scale.max]);yScale=d3.scale.linear().domain([0,scope.scale.max_ratio]).range([BRICK_MAX_HEIGHT,0]);scope.hover.id=-1;scope.W=element.width();scope.max_ratio=scope.scale.max_ratio;var brickNodes=svg.select("#chart").selectAll("rect.brick").data(scope.data);brickNodes.exit().remove();brickNodes.enter().append("rect").attr("fill",scope.color).attr("width",BRICK_WIDTH).attr("class","brick").attr("height",function(val){return BRICK_MAX_HEIGHT-yScale(val.ratio)}).on("mouseover",function(val,hoverId){scope.hover.id=hoverId;scope.$apply()});brickNodes.attr("x",function(val){return val.x}).attr("fill",scope.color).attr("y",function(val){return BRICK_MARGIN_TOP+yScale(val.ratio)}).attr("height",function(val){return BRICK_MAX_HEIGHT-yScale(val.ratio)});scope.hover.id=-1;updateHover();svg.select("g.whisker-container").remove();var whiskerContainer=svg.append("g").attr("class","whisker-container").attr("transform","translate("+LEFT_MARGIN_TO_CHART+", "+(BRICK_MAX_HEIGHT+(scope.showScale?35:15)+BRICK_MARGIN_TOP+8)+")");var yAxis=d3.svg.axis().scale(yScale).ticks(3).orient("left").tickFormat(function(d){return(d*100|0)+"%"});svg.select("g.yaxis").remove();svg.append("g").attr("class","yaxis").attr("transform","translate("+(LEFT_MARGIN_TO_CHART-26)+", "+BRICK_MARGIN_TOP+")").call(yAxis);svg.select("g.xaxis").remove();var svgAxis=svg.append("g").attr("class","xaxis").attr("transform","translate("+LEFT_MARGIN_TO_CHART+", "+(BRICK_MAX_HEIGHT+BRICK_MARGIN_TOP+7)+")");if(scope.categorical){if(scope.showScale){svgAxis.selectAll("text.histogram-label").data(scope.scale.categories).enter().append("text").attr("class","histogram-label").text(function(d){return d}).attr("text-anchor","end").attr("transform",function(data,i){var rotation="rotate(-45) ";var x=13+BRICK_STRIDE*i;var y=0;var translation="translate("+x+","+y+")";return translation+rotation})}svgAxis.append("line").attr("x1","0").attr("y1","-6").attr("x2",BRICK_STRIDE*scope.data.length).attr("y2","-6").attr("stroke","black").attr("shape-rendering","crispEdges")}else{whiskerPlot(whiskerContainer,scope.whiskerData,xScale);var xAxis=d3.svg.axis().scale(xScale).ticks(3).orient("bottom");if(!scope.showScale){svgAxis.attr("class","xaxis hide-labels")}svgAxis.call(xAxis)}};function updateHover(){svg.select("rect.stripe").attr("height",0).attr("width",0);if(scope.hover.id!==undefined&&scope.hover.id>=0&&scope.data!==undefined&&scope.hover.id<scope.data.length){var val=scope.data[scope.hover.id];if(val!=undefined){svg.select("rect.stripe").attr("x",val.x).attr("y",BRICK_MARGIN_TOP+yScale(val.ratio)).attr("height",BRICK_MAX_HEIGHT-yScale(val.ratio)).attr("width",BRICK_WIDTH)}}}scope.$watch("data",refreshHistogram);scope.$watch("hover",updateHover,true)}}})})();app.directive("clusteringScatterControl",function(Assert,DataikuAPI,$filter,$stateParams){return{scope:{result:"=",getClusterMeta:"=getClusterMeta",fullModelId:"="},templateUrl:"/templates/ml/clustering-model/scatterplot.html",link:function($scope,element){$scope.scatterShowOutliers=true;$scope.waiting=true;Assert.inScope($scope,"result");Assert.trueish($scope.result.perf,"No performance metrics");$scope.params={};$scope.refreshForm=function(){$scope.scatterVars=arrayDedup($.grep($scope.result.perf.cluster_description,function(elt){return elt.variable!="cluster_size"}).map(function(x){return x.variable}).concat($scope.result.perf.reduce_vars));if($scope.params.scatterVar1===undefined&&$scope.params.scatterVar2===undefined){if($scope.result.perf.reduce_vars.length>=2){$scope.params.scatterVar1=$scope.result.perf.reduce_vars[0];$scope.params.scatterVar2=$scope.result.perf.reduce_vars[1]}else{$scope.params.scatterVar1=$scope.scatterVars[Math.min(1,$scope.scatterVars.length-1)];$scope.params.scatterVar2=$scope.scatterVars[0]}}};$scope.refreshGraph=function(){$scope.waiting=true;DataikuAPI.ml.clustering.getScatterPlot($stateParams.projectKey,$scope.fullModelId,$scope.params.scatterVar2,$scope.params.scatterVar1).success(function(data){$scope.scatterData=data.points;$scope.waiting=false}).error(function(data,status,headers){setErrorInScope.bind($scope)(data,status,headers);$scope.waiting=false})};$scope.refreshForm();$scope.refreshGraph();$scope.$watch("params",$scope.refreshGraph.bind($scope),true)}}});app.directive("scatterClusterPlot",function($timeout){return{scope:{data:"=",axisX:"=",axisY:"=",showOutliers:"=",getClusterMeta:"=getClusterMeta",puppeteerLoadedStateField:"@"},template:"<svg />",link:function(scope,element){const puppeteerSelectorName=scope.puppeteerLoadedStateField;element.attr(puppeteerSelectorName,true);var tooltip;function redrawAll(){$timeout(function(){scope[puppeteerSelectorName]=false;var svg=element.find("svg").get(0);$(svg).empty();var width=$(element).width();var height=$(element).height();scope.chart=window.DKUCharts.basicChart(width,height);scope.g=scope.chart.makeTopG(d3.select(svg));updateData();scope[puppeteerSelectorName]=true})}function updateData(){var data=scope.values;var g=scope.g;var chart=scope.chart;var xmin=Infinity,xmax=-Infinity,ymin=Infinity,ymax=-Infinity;for(var idx in data){xmin=Math.min(xmin,data[idx].x);xmax=Math.max(xmax,data[idx].x);ymin=Math.min(ymin,data[idx].y);ymax=Math.max(ymax,data[idx].y)}var axX=scope.axisX;var axY=scope.axisY;var xAxis=d3.svg.axis().scale(chart.xscale).orient("bottom").ticks(10);var yAxis=d3.svg.axis().scale(chart.yscale).orient("left").ticks(10);chart.xscale.domain([xmin,xmax]);chart.yscale.domain([ymin,ymax]);g.append("g").attr("class","x axis").attr("transform","translate(0,"+chart.height+")").call(xAxis).append("text").attr("class","label").attr("x",chart.width).attr("y",-6).style("text-anchor","end").text(axX);g.append("g").attr("class","y axis").call(yAxis).append("text").attr("class","label").attr("transform","rotate(-90)").attr("y",6).attr("dy",".71em").style("text-anchor","end").text(axY);window.DKUCharts.drawGrid(g,chart.xscale,chart.yscale,chart.width,chart.height);$(".regression-scatter-plot-tooltip").remove();var color=d3.scale.category10().domain(d3.range(0,10));$(".regression-scatter-plot-tooltip").remove();tooltip=d3.select("body").append("div").attr("class","regression-scatter-plot-tooltip").style("left","0").style("top","0").style("opacity",0).style("pointer-events","none");g.selectAll(".dot").data(data).enter().append("circle").attr("r",3).attr("cx",function(d){return chart.xscale(d.x)}).attr("cy",function(d){return chart.yscale(d.y)}).style("fill",function(d){return scope.getClusterMeta(d.cluster).color}).on("mouseover",function(d){var col=scope.getClusterMeta(d.cluster).color;tooltip.transition().duration(300).style("opacity",1);tooltip.html("<table><tr><td>Cluster</td><th>{0}</th></tr><tr><td>{3}</td><th>{1}</th></tr><tr><td>{4}</td><th>{2}</th></tr></table>".format(sanitize(scope.getClusterMeta(d.cluster).name),sanitize(d.x),sanitize(d.y),sanitize(axX),sanitize(axY))).style("left",d3.event.pageX+"px").style("top",d3.event.pageY-28+"px").style("border","2px "+col+" solid")}).on("mouseout",function(d){tooltip.transition().duration(300).style("opacity",0)})}scope.$watch("[data, showOutliers]",function(nval,ov){if(nval[0]==null)return;if(!scope.showOutliers){scope.values=scope.data.filter(function(el){return el.cluster!="cluster_outliers"})}else{scope.values=scope.data}redrawAll()},true);$(window).on("resize",redrawAll);scope.$on("$destroy",function(){tooltip.remove();$(window).off("resize",redrawAll)})}}});app.controller("ClusteringVariableImportanceController",function($scope,$filter,FeatureImportanceService,ExportUtils){$scope.colors=window.dkuColorPalettes.discrete[0].colors.filter(function(c,i){return i%2===0});var arr=FeatureImportanceService.build($scope.modelData.perf.variables_importance,$scope.colors);$scope.importances=arr[0];$scope.fades=arr[1];$scope.unfilteredImportances=arr[2];$scope.exportImportance=function(){var f=$filter("mlFeature");var data=$scope.unfilteredImportances.map(function(x){return[x.rawVarName,x.varName,x.impVal]});ExportUtils.exportUIData($scope,{name:"Variable importance for model:"+$scope.modelData.userMeta.name,columns:[{name:"feature_name",type:"string"},{name:"feature_description",type:"string"},{name:"importance",type:"double"}],data:data},"Export variable importances")}});app.directive("heatGradient",function(){return{template:"<div class='heat-gradient'>"+"<div id='text'><div>Low</div><div>High</div></div>"+"<div id='gradient'></div></div>",replace:true,restrict:"E"}});app.controller("AnomalyController",function($scope,DataikuAPI,$stateParams,$filter,Dialogs){$scope.features=null;$scope.data=null;$scope.index=0;var cellScale=d3.scale.linear().domain([-3,0,3]).range(["#323dff","#f2f2f2","#e22828"]);var cleanData=function(data){var toKeep=[];var keepAll=true;for(var i=0;i<data.averages.length;i++){if(data.standard_deviations[i]>0){toKeep.push(i)}else{keepAll=false}}if(!keepAll){var prune=function(arr){var newArr=[];toKeep.forEach(function(i){newArr.push(arr[i])});return newArr};for(i=0;i<data.data.length;i++){data.data[i]=prune(data.data[i])}if(data.regular_data){for(i=0;i<data.regular_data.length;i++){data.regular_data[i]=prune(data.regular_data[i])}}data.columns=prune(data.columns);data.averages=prune(data.averages);data.standard_deviations=prune(data.standard_deviations)}};var nVar=0;var maxScore=0;var scoreSd=0;var computeScoreStats=function(scores){var scoreMean=0;scores.forEach(function(s){scoreMean+=s;scoreSd+=s*s});scoreMean/=scores.length;scoreSd/=scores.length;scoreSd=Math.sqrt(Math.max(0,scoreSd-scoreMean*scoreMean));if(scoreSd==0){scoreSd=1}maxScore=Math.max.apply(Math,$scope.data.scores)};var columnIndex=[];var initColumnIndex=function(){var imps=$scope.modelData.perf.variables_importance;var importanceMapping={};for(var i=0;i<imps.variables.length;i++){importanceMapping[imps.variables[i]]=imps.importances[i]}for(i=0;i<nVar;i++){columnIndex.push(i)}var importance=function(i){var fi=$scope.data.columns[i];if(fi in importanceMapping){return importanceMapping[fi]}else{return 0}};columnIndex.sort(function(i,j){return importance(j)-importance(i)})};$scope.pagination=[];var pageSize=10;var initPageSize=20;var initPagination=function(){for(var i=0;i<Math.min(initPageSize,nVar);i++){$scope.pagination.push(columnIndex[i])}};$scope.seeMore=function(){var start=$scope.pagination.length;for(var i=start;i<Math.min(start+pageSize,nVar);i++){$scope.pagination.push(columnIndex[i])}};$scope.isMore=function(){return $scope.pagination.length<nVar};var initExtra=function(){$scope.isExtra=$scope.data.extra_profiling_columns!==undefined&&$scope.data.extra_profiling_columns.length>0;$scope.displayExtra=false;$scope.setDisplayExtra=function(b){$scope.displayExtra=b}};var tScoreRenorm=[];var initRenorm=function(){var nCats={};var cols=$scope.data.columns;for(var i=0;i<nVar;i++){if(cols[i].startsWith("dummy")){var els=cols[i].split(":");var name=els[1];if(name in nCats){nCats[name]=nCats[name]+1}else{nCats[name]=1}}}for(i=0;i<nVar;i++){if(cols[i].startsWith("dummy")){els=cols[i].split(":");name=els[1];tScoreRenorm.push(1/nCats[name])}else{tScoreRenorm.push(1)}}};var init=function(){nVar=$scope.data.averages.length;computeScoreStats($scope.data.scores);initColumnIndex();initPagination();initRenorm();initExtra()};DataikuAPI.ml.clustering.getAnomalies($stateParams.fullModelId||$scope.fullModelId).success(function(data){var setData=function(){cleanData(data);$scope.data=data;init()};var nCells=(data.data.length+10)*pageSize;if(nCells>1e4){Dialogs.confirm($scope,"Large number of cells","The number of cells to display initially is very large ("+nCells+"). "+"Displaying them all may lead to poor performance or even a browser crash. Do you wish to continue ?").then(function(){setData()})}else{setData()}});$scope.nIcons=function(i){var tScore=Math.abs((maxScore-$scope.data.scores[i])/scoreSd);var n;if(tScore>3){n=5}else if(tScore>2){n=4}else if(tScore>1.5){n=3}else if(tScore>1){n=2}else{n=1}return new Array(n)};$scope.getCellColor=function(featureIndex,value){var tScore=tScoreRenorm[featureIndex]*(value-$scope.data.averages[featureIndex])/$scope.data.standard_deviations[featureIndex];return cellScale(tScore)};$scope.cleanValue=function(x){const asNumber=parseFloat(x);if(isNaN(asNumber)){return x}else{return $filter("smartNumber")(x)}};var namer=$filter("mlFeature");$scope.tooltipHtml=function(featureIndex,value){var avg=$scope.cleanValue($scope.data.averages[featureIndex]);value=$scope.cleanValue(value);return"<div><strong>"+sanitize(namer($scope.data.columns[featureIndex]))+"</strong>: "+value+" (vs. "+avg+" globally)"+"</div>"}})})();(function(){"use strict";var app=angular.module("dataiku.ml.report");app.controller("CoefficientPathController",function($scope,DataikuAPI,$stateParams){$scope.data=[];$scope.uiModel={dataIndex:0};DataikuAPI.ml.prediction.getCoefPath($stateParams.fullModelId||$scope.fullModelId).success(function(data){if($.isEmptyObject(data)){$scope.noPathFound=true;return}if(!$scope.isRegression()){$scope.data=[];for(var i=0;i<$scope.modelData.classes.length;i++){$scope.data.push(data.path.map(function(a){return a[i]}))}$scope.selectedClass=$scope.modelData.classes[0];$scope.classes=$scope.modelData.classes;$scope.uiModel.dataIndex=0}else{$scope.data=[data.path.map(function(a){return a.map(function(x){return x[0]})})]}$scope.features=data.features;$scope.currentIndex=data.currentIndex}).error(setErrorInScope.bind($scope))});app.directive("coefficientPath",function(){return{replace:true,templateUrl:"/templates/ml/prediction-model/coef_path_view.html",scope:{data:"=",features:"=",currentIndex:"="},link:function($scope,element,attrs){$scope.slide=300;$scope.windowParams={displayHelp:true};$scope.hideHelp=function(){$scope.windowParams.displayHelp=false};var slideUnwatch=function(){};$scope.$watch("data",function(){slideUnwatch();var width=700;var height=400;d3.select(element[0]).select("#coef-path-container").attr("width",width).attr("height",height);var graphSvg=d3.select(element[0]).select("#graph");var xValues=[];var norm=0;for(var i=0;i<$scope.data[0].length;i++){var t=$scope.data[$scope.data.length-1][i];norm+=t*t}for(i=0;i<$scope.data.length;i++){var normI=0;for(var j=0;j<$scope.data[i].length;j++){t=$scope.data[i][j];normI+=t*t}xValues.push(Math.sqrt(normI/norm))}var sliderIndex=function(){var index=[];var currentMapped=0;for(var i=0;i<=299;i++){var x=i*1/300;if(x>xValues[currentMapped]){currentMapped++}index.push(currentMapped)}index.push(xValues.length-1);return index}();var nCoef=function(x){var n=0;for(var i=0;i<x.length;i++){if(Math.abs(x[i])>1e-6){n++}}return n};var cutoffs=function(){var res=[];var cur=nCoef($scope.data[0]);for(var i=1;i<xValues.length;i++){var n=nCoef($scope.data[i]);if(n!=cur){cur=n;res.push(xValues[i])}}return res}();var updateSlider=function(){$scope.selectedIndex=sliderIndex[$scope.slide];$scope.coefs=$scope.data[$scope.selectedIndex];$scope.nCoefs=nCoef($scope.coefs)};var series=[];for(i=0;i<$scope.data[0].length;i++){var arr=[];for(j=0;j<$scope.data.length;j++){arr.push($scope.data[j][i])}series.push(arr)}var maxY=d3.max($scope.data.map(function(a){return d3.max(a)}));var minY=d3.min($scope.data.map(function(a){return d3.min(a)}));var y=d3.scale.linear().domain([minY,maxY]).range([0,height]);var x=d3.scale.linear().domain([0,1]).range([0,width]);$scope.coefWidth=function(c){return 35*Math.abs(c)/Math.max(Math.abs(maxY),Math.abs(minY))};$scope.coefIndex=[];for(i=0;i<$scope.data[0].length;i++){$scope.coefIndex.push(i)}$scope.coefIndex.sort(function(i,j){var t=$scope.data.length-1;return Math.abs($scope.data[t][j])-Math.abs($scope.data[t][i])});var index=[];for(i=0;i<$scope.data.length;i++){index.push(i)}$scope.selectedFeature=null;$scope.colorScales=d3.scale.category10();$scope.featureTextColor=function(i){return $scope.selectedFeature==null||$scope.selectedFeature==i?$scope.colorScales(i):"rgba(0,0,0,0.25)"};$scope.mouseoverCurve=function(i,apply){$scope.selectedFeature=i;graphSvg.selectAll("path").filter(function(d){return!d[0].fake&&d[0].feature!=i}).attr("stroke-opacity",.25).attr("stroke","black");if(apply){$scope.$apply()}};$scope.mouseoutCurve=function(i,apply){$scope.selectedFeature=null;graphSvg.selectAll("path").filter(function(d){return!d[0].fake}).attr("stroke-opacity",1).attr("stroke",function(d){return d[0].color});if(apply){$scope.$apply()}};var update=function(){graphSvg.selectAll("path").remove();graphSvg.selectAll("rect").remove();graphSvg.selectAll("line").remove();graphSvg.selectAll("polyline").remove();graphSvg.selectAll("text").remove();var paintCurve=function(i,index,color,fake){var curve=graphSvg.append("path").datum(index.map(function(d){return{feature:i,ix:d,fake:fake,color:color}})).attr("fill","none").attr("stroke",color).attr("stroke-linejoin","round").attr("stroke-linecap","round").attr("stroke-width",fake?10:1.5).attr("stroke-opacity",fake?0:1).attr("d",d3.svg.line().x(function(d){return x(xValues[d.ix])}).y(function(d){return y(series[i][d.ix])}));if(fake){curve.on("mouseover",function(d){$scope.mouseoverCurve(d[0].feature,true)}).on("mouseout",function(d){$scope.mouseoutCurve(d[0].feature,true)})}};var leftIndex=[];var rightIndex=[];for(var i=0;i<$scope.data.length;i++){if(i<=$scope.selectedIndex){leftIndex.push(i)}if(i>=$scope.selectedIndex){rightIndex.push(i)}}graphSvg.append("rect").attr("height",height).attr("width",(1-xValues[$scope.selectedIndex])*width).attr("x",xValues[$scope.selectedIndex]*width).attr("fill","#eaeaea").attr("fill-opacity","0.2");for(i=0;i<cutoffs.length;i++){graphSvg.append("line").attr("id","sep-line").attr("stroke-dasharray","5, 10").attr("x1",cutoffs[i]*width).attr("x2",cutoffs[i]*width).attr("y1",0).attr("y2",height).attr("stroke","#666666").attr("stroke-width","0.3px")}var paintRight=xValues[$scope.currentIndex]*width+80<width;var x1=xValues[$scope.currentIndex]*width;var y1=0;var x2=xValues[$scope.currentIndex]*width;var y2=height+30;var x3=xValues[$scope.currentIndex]*width+(paintRight?40:-40);var y3=y2;var textX=xValues[$scope.currentIndex]*width+(paintRight?55:-130);var textY=height+35;graphSvg.append("polyline").attr("points",x1+","+y1+" "+x2+","+y2+" "+x3+","+y3).attr("stroke","black").attr("stroke-dasharray","8, 6").attr("stroke-width",$scope.currentIndex==$scope.selectedIndex?"3px":"1.5px").attr("fill","none");graphSvg.append("text").text("Current model").attr("x",textX).attr("y",textY).attr("font-weight",$scope.currentIndex==$scope.selectedIndex?"bold":"regular");graphSvg.append("line").attr("id","sep-line").attr("stroke-dasharray","5, 10").attr("x1",xValues[$scope.selectedIndex]*width).attr("x2",xValues[$scope.selectedIndex]*width).attr("y1",0).attr("y2",height).attr("stroke",$scope.selectedIndex==$scope.currentIndex?"none":"#666666").attr("stroke-width","2.5px");for(i=0;i<series.length;i++){paintCurve(i,leftIndex,$scope.colorScales(i),false);paintCurve(i,leftIndex,"black",true);paintCurve(i,rightIndex,d3.hcl($scope.colorScales(i)).brighter(3).rgb(),false);paintCurve(i,rightIndex,"black",true)}graphSvg.append("line").attr("x1",0).attr("x2",width).attr("y1",y(0)).attr("y2",y(0)).attr("stroke","black").attr("stroke-width","1.5px")};updateSlider();update();slideUnwatch=$scope.$watch("slide",function(){var indexBefore=$scope.selectedIndex;updateSlider();if(indexBefore!=$scope.selectedIndex){update()}})})}}})})();(function(){"use strict";var app=angular.module("dataiku.ml.report");app.controller("ClusterHierarchyController",function($scope,$controller,$stateParams,Dialogs,DataikuAPI,FutureProgressModal,ActivityIndicator,CreateModalFromTemplate,WT1){WT1.event("clustering-hierarchy-page-open");$scope.hierarchyData=null;var retrieveData=function(){$scope.waiting=true;DataikuAPI.ml.clustering.getClusterHierarchy($stateParams.fullModelId||$scope.fullModelId).success(function(data){$scope.hierarchyData=data;var registerNode=function(node){$scope.getClusterMeta("node_"+node.id);if(node.left_son){registerNode(node.left_son);registerNode(node.right_son)}};var rootNodeKey="node_"+$scope.hierarchyData.root.id;const{clusterMetas}=$scope.modelData.userMeta;if(!(rootNodeKey in(clusterMetas||{}))){$scope.getClusterMeta(rootNodeKey).name="root"}registerNode($scope.hierarchyData.root);$scope.waiting=false}).error(function(data,status,headers){setErrorInScope.bind($scope)(data,status,headers);$scope.waiting=false})};retrieveData();$scope.canCommit=true;$scope.hooks.dirty=function(){return $scope.diff};$scope.$on("$destroy",function(){delete $scope.hooks.dirty});$scope.diff=false;$scope.commit=function(leafIds){WT1.event("clustering-hierarchy-commit");var warning="Are you sure you want to save this new clustering?";if($scope.getAlgorithm().startsWith("MLLIB"))warning+=" This will trigger a Spark job.";Dialogs.confirm($scope,"Save clustering",warning).then(function(){WT1.event("clustering-hierarchy-commit-confirmed");$scope.modelData.userMeta.kept_hierarchy_node_ids=leafIds;DataikuAPI.ml.saveModelUserMeta($stateParams.fullModelId||$scope.fullModelId,$scope.modelData.userMeta).then(()=>{ActivityIndicator.success("Saved");return DataikuAPI.ml.clustering.rescore($stateParams.fullModelId||$scope.fullModelId)}).then(({data})=>{$scope.canCommit=false;return FutureProgressModal.show($scope,data,"Rescoring cluster hierarchy")}).then($scope.fetchModelDetails).then(()=>{$scope.configureAfterModelFetch();retrieveData();$scope.canCommit=true}).catch(setErrorInScope.bind($scope))})};$scope.edit=function(node,svgUpdateCallback){WT1.event("clustering-hierarchy-edit-node");CreateModalFromTemplate("/templates/ml/clustering-model/cluster-details-edit.html",$scope,"ClusterEditController",function(newScope){newScope.meta=$scope.getClusterMeta("node_"+node.id);newScope.callback=svgUpdateCallback})}});app.directive("clusterHierarchy",function(Dialogs,ClusteringHeatmapUtils,WT1,getNameValueFromMLFeatureFilter){return{replace:true,templateUrl:"/templates/ml/clustering-model/cluster-hierarchy.html",scope:{data:"=",getClusterMeta:"=",edit:"=",commit:"=",canCommit:"=",readOnly:"=",diff:"="},link:function($scope,element){var width=null;var height=null;var treeWidth=null;var container=$(element[0]).find("#container");d3.select(container[0]).select("svg").attr("height",1e5).append("defs");var svg=d3.select(container[0]).select("svg > g");var tree=d3.layout.cluster();var clusterWidth=95;var clusterHeight=18;var computeDimensions=function(){var leafCount=function(node){if(node.collapsed||!node.left_son){return 1}else{return leafCount(node.left_son)+leafCount(node.right_son)}};width=container.width();height=Math.max(400,(clusterHeight+20)*leafCount(root));treeWidth=width-100;tree.size([height,treeWidth]);container.height(height+100)};tree.children(function(d){if(d.collapsed||!d.left_son){return null}else{return[d.left_son,d.right_son]}});tree.sort(function(a,b){return d3.ascending(a.id,b.id)});$scope.editCluster=function(c){$scope.edit(c,function(){update(root)})};var hasClusterParent=function(d){if(!d.parent){return false}else if(isCluster(d)){return true}else{return hasClusterParent(d.parent)}};var click=function(d){if(hasClusterParent(d)){d.collapsed=!d.collapsed;update(d);$scope.$apply()}};var root=null;var collapseAll=function(node){if(node.left_son){node.collapsed=true;collapseAll(node.left_son);collapseAll(node.right_son)}else{node.collapsed=false}};var collapseInit=function(node){if(isCluster(node)){collapseAll(node)}else if(node.left_son){node.collapsed=false;collapseInit(node.left_son);collapseInit(node.right_son)}else{node.collapsed=false}};$scope.selectedNode=null;$scope.normalizeFeature=function(f){if(f===undefined)return;var splitedFeature=getNameValueFromMLFeatureFilter(f);if(splitedFeature.value){return splitedFeature.name+" = "+splitedFeature.value}else{return f}};$scope.featureSort={sortBy:"default",sortDesc:false};$scope.featureIndex=[];var initFeatureIndex=function(){$scope.featureIndex=[];for(var i=0;i<root.representative.length;i++){$scope.featureIndex.push(i)}};var getParentChildScore=function(node){return function(i){var parentValue=node.parent.representative[i];var parentStd=node.parent.stds[i];var parentWeight=node.parent.weight[i];var value=node.representative[i];var ratio;if(parentStd==0||Number.isNaN(parentStd)){ratio=value==0?0:value>0?2:-2}else{ratio=(value-parentValue)/parentStd}return Math.abs(ratio)}};var getGlobalScore=function(node){return function(i){return Math.abs(computeGlobalImportance(node,i))}};var applySorting=function(scoreFeature){var eps=$scope.featureSort.sortDesc?-1:1;$scope.featureIndex.sort(function(a,b){var aScore=scoreFeature(a);var bScore=scoreFeature(b);return eps*(aScore<bScore?-1:aScore>bScore?1:0)})};var sortDefault=function(){if($scope.featureSort.sortDesc){$scope.featureIndex.reverse()}};var sortFeatureIndex=function(){initFeatureIndex();switch($scope.featureSort.sortBy){case"global":applySorting(getGlobalScore($scope.selectedNode),root);break;case"parent":applySorting(getParentChildScore($scope.selectedNode));break;default:sortDefault()}};var initDesc=function(){switch($scope.featureSort.sortBy){case"global":case"parent":$scope.featureSort.sortDesc=true;break;default:$scope.featureSort.sortDesc=false;break}};$scope.$watch("featureSort",function(nv,ov){if(nv&&ov&&nv.sortDesc===ov.sortDesc){initDesc()}WT1.event("clustering-hierarchy-sort-features",{sortBy:$scope.featureSort?$scope.featureSort.sortBy:"??",sortDesc:$scope.featureSort?$scope.featureSort.sortDesc:"??"});if(root)sortFeatureIndex()},true);var ratioScales=d3.scale.linear().domain([-2,0,2]).range(["#0d52c1","white","#CE1329"]);$scope.arrowUp=function(featureIndex){return $scope.selectedNode.representative[featureIndex]>$scope.selectedNode.parent.representative[featureIndex]};$scope.arrowColor=function(featureIndex){var value=$scope.selectedNode.representative[featureIndex];var parentValue=$scope.selectedNode.parent.representative[featureIndex];var parentStd=$scope.selectedNode.parent.stds[featureIndex];var ratio;if(parentStd==0||Number.isNaN(parentStd)){ratio=value==0?0:value>0?2:-2}else{ratio=(value-parentValue)/parentStd}return ratioScales(ratio)};$scope.normalizeFeatureValue=function(feature,value){if(feature===undefined)return;if(feature.startsWith("dummy")){return(Math.abs(value)*100).toFixed(2)+"%"}else if(Math.abs(value)<.1||Math.abs(value)>=1e6){return value.toExponential(2)}else{return value.toFixed(2)}};var reduce=function(node,accessor,reducer){if(!node.left_son){return accessor(node)}else{var a=reduce(node.left_son,accessor,reducer);var b=reduce(node.right_son,accessor,reducer);return reducer(a,b)}};var featureScales=[];var globalScale;var computeColorScales=function(data){var max=0;for(var i=0;i<data.variable_names.length;i++){max=Math.max(max,reduce(data.root,function(d){return Math.abs(computeGlobalImportance(d,i))},Math.max))}max=Math.max(max,10);globalScale=d3.scale.linear().domain([-max,-10,-2,0,2,10,max]).range(["#4285f4","#92abf9","#ccd4fc","#ffffff","#fbbab2","#ea746a","#ce1329"])};var standardifyNode=function(n){n.stds=zip(n.representative,n.squares).map(x=>Math.sqrt(Math.abs(x[1]/n.weight-x[0]*x[0])));if(n.left_son){standardifyNode(n.left_son);standardifyNode(n.right_son)}};var computeGlobalImportance=function(node,featureIndex){var x=node.representative[featureIndex];var gx=root.representative[featureIndex];var importance;if($scope.features[featureIndex].startsWith("dummy:")){importance=ClusteringHeatmapUtils.categoricalWelchTStat(x,gx,node.weight,root.weight)}else{importance=ClusteringHeatmapUtils.numericalWelchTStat(x,gx,node.stds[featureIndex],root.stds[featureIndex],node.weight,root.weight)}return importance};$scope.featureColor=function(featureIndex){if(featureIndex===undefined)return;var importance=computeGlobalImportance($scope.selectedNode,featureIndex);var col=globalScale(importance);return col};var isCluster=function(d){return d&&d.id in $scope.clusters};$scope.isCluster=isCluster;var computeClusterParents=function(node){var labelAll=function(n,i){n.parent_cluster=i;if(n.left_son){labelAll(n.left_son,i);labelAll(n.right_son,i)}};if(isCluster(node)){labelAll(node,node.id)}else if(node.left_son){computeClusterParents(node.left_son);computeClusterParents(node.right_son)}};$scope.expandAll=function(){WT1.event("clustering-hierarchy-expand-all");var expandAll=function(node){node.collapsed=false;if(node.left_son){expandAll(node.left_son);expandAll(node.right_son)}};expandAll(root);update(root)};$scope.collapse=function(){WT1.event("clustering-hierarchy-collapse");collapseInit(root);$scope.selectedNode=null;update(root)};$scope.reset=function(){Dialogs.confirm($scope,"Reset clusters","Do you want to reset the clustering to its current saved state ?").then(function(){WT1.event("clustering-hierarchy-reset");$scope.selectedNode=null;initClusters();$scope.diff=false;svg.selectAll("rect.temporary").remove();collapseInit(root);computeClusterParents(root);update(root)})};$scope.getName=function(nodeId){return $scope.getClusterMeta("node_"+nodeId).name};var leaves=function(node){if(node.collapsed||!node.left_son){return[node.id]}else{return leaves(node.left_son).concat(leaves(node.right_son))}};$scope.clusters={};var computeDiff=function(){if(Object.keys($scope.clusters).length!=$scope.data.active_ids.length){$scope.diff=false}for(var i=0;i<$scope.data.active_ids.lenght;i++){if(!($scope.data.active_ids[i]in $scope.clusters)){$scope.diff=false}}$scope.diff=true};checkChangesBeforeLeaving($scope,function(_scope){return function(){return _scope.diff}}($scope));$scope.setAsCluster=function(node){if(hasClusterParent(node)){WT1.event("clustering-hierarchy-set-as-cluster-has-cluster-parents");var warning="Setting this node as a cluster will also set its siblings as clusters.";Dialogs.confirm($scope,"Set as cluster",warning).then(function(){var n=node;var toAdd=[node];do{if(n.parent.left_son==n){toAdd.push(n.parent.right_son)}else{toAdd.push(n.parent.left_son)}n=n.parent}while(!isCluster(n));delete $scope.clusters[n.id];toAdd.forEach(function(c){$scope.clusters[c.id]={}});computeDiff();computeClusterParents(n);svg.selectAll("rect.temporary").remove();update(root)})}else{WT1.event("clustering-hierarchy-set-as-cluster-hasnt-cluster-parents");var clusterSons=[];var collectClusterSons=function(n){if(isCluster(n)){clusterSons.push(n)}else{collectClusterSons(n.left_son);collectClusterSons(n.right_son)}};collectClusterSons(node);clusterSons.forEach(function(c){delete $scope.clusters[c.id]});$scope.clusters[node.id]={};computeDiff();computeClusterParents(node);svg.selectAll("rect.temporary").remove();update(root)}};$scope.commitClustering=function(){$scope.commit(Object.keys($scope.clusters))};var nLeaves=function(node){if(node.collapsed||!node.left_son){return 1}else{return nLeaves(node.left_son)+nLeaves(node.right_son)}};$scope.nodeProportion=function(d){return(100*(d.weight+0)/root.weight).toFixed(2)};var maxDepth=function(node,isLeaf){if(!isLeaf(node)){return 1+Math.max(maxDepth(node.children[0],isLeaf),maxDepth(node.children[1],isLeaf))}else{return 0}};var minLeafSeparation=10;var postOrderList=function(tree,isLeaf){var node=tree,nodes=[node],next=[],children,i,n;while(node=nodes.pop()){next.push(node);if(!isLeaf(node)){nodes.push(node.left_son);nodes.push(node.right_son)}}return next.reverse()};var isTerminalNode=function(n){return n.collapsed||!n.left_son};var computeBaseLayout=function(tree,treatAsLeaf,positionLeaves,width){var m=1*maxDepth(tree,treatAsLeaf);if(!width){width=m}var previousNode;var x=0;postOrderList(tree,treatAsLeaf).forEach(function(node){if(!treatAsLeaf(node)){node.y=(node.left_son.y+node.right_son.y)/2;node.x=Math.min(node.left_son.x,node.right_son.x)-width/m}else if(positionLeaves){node.y=previousNode?x+=(node.parent===previousNode.parent?1:2)*minLeafSeparation:0;node.x=m;previousNode=node}})};var computeBoundingBox=function(tree){var maxY=Number.NEGATIVE_INFINITY;var maxX=Number.NEGATIVE_INFINITY;var minY=Number.POSITIVE_INFINITY;var minX=Number.POSITIVE_INFINITY;var updateBoundingBox=function(node){maxY=Math.max(node.y,maxY);maxX=Math.max(node.x,maxX);minY=Math.min(node.y,minY);minX=Math.min(node.x,minX);if(!isTerminalNode(node)){updateBoundingBox(node.left_son);updateBoundingBox(node.right_son)}};updateBoundingBox(tree);return{maxX:maxX,maxY:maxY,minX:minX,minY:minY}};var rescale=function(tree,x_scale,y_scale,x_offset,y_offset){let bb=computeBoundingBox(tree);var renormalizeNode=function(node){node.x=x_offset+width*x_scale*(node.x-bb.minX);node.y=y_offset+height*y_scale*(node.y-bb.minY);if(!isTerminalNode(node)){renormalizeNode(node.left_son);renormalizeNode(node.right_son)}};renormalizeNode(tree)};var renormalize=function(tree,width,height,x_offset,y_offset){var bb=computeBoundingBox(tree);var xScale=bb.maxX==bb.minX?1:1/(bb.maxX-bb.minX);var yScale=bb.maxY==bb.minY?1:1/(bb.maxY-bb.minY);var renormalizeNode=function(node){node.x=x_offset+width*xScale*(node.x-bb.minX);node.y=y_offset+height*yScale*(node.y-bb.minY);if(!isTerminalNode(node)){renormalizeNode(node.left_son);renormalizeNode(node.right_son)}};renormalizeNode(tree)};var computeLayout=function(root,width,height,padding,clusterWidth){var subtrees=[];var collectSubtrees=function(node){if(isCluster(node)){subtrees.push(node)}else{collectSubtrees(node.right_son);collectSubtrees(node.left_son)}};collectSubtrees(root);subtrees.forEach(function(tree){computeBaseLayout(tree,function(node){return!node.children},true)});var y_offset=0;for(var i=0;i<subtrees.length;i++){let bb=computeBoundingBox(subtrees[i]);var subtreeHeight=bb.maxY-bb.minY;renormalize(subtrees[i],width/2-clusterWidth,subtreeHeight,width/2,y_offset);y_offset+=subtreeHeight+2*clusterHeight}computeBaseLayout(root,function(node){return isCluster(node)},false,width/2);let bb=computeBoundingBox(root);var h=padding+bb.maxY-bb.minY;var nodeList=postOrderList(root,function(n){return isTerminalNode(n)});if(!padding){padding=0}if(h>0&&h<height){var scale=1*height/h;nodeList.forEach(function(n){n.y=scale*n.y});bb.maxY*=scale}var x_scale=(width-2*padding)/width;var y_scale=(h-2*padding)/height;nodeList.forEach(function(node){node.x=padding+node.x*x_scale;node.y=padding+node.y});var scaleRatio=(.5*width-padding-.5*clusterWidth)/(.5*width-padding);var rescaleLeft=function(x){return(x-padding)*scaleRatio+padding};nodeList.forEach(function(node){if(isCluster(node)){return}else if(hasClusterParent(node)){node.x=width-rescaleLeft(width-node.x)}else{node.x=rescaleLeft(node.x)}})};var initClusters=function(){$scope.clusters={};for(var i=0;i<$scope.data.active_ids.length;i++){$scope.clusters[$scope.data.active_ids[i]]={}}};$scope.$watch("data",function(){if($scope.data){root=$scope.data.root;$scope.features=$scope.data.variable_names;initClusters();$scope.activeIds=$scope.data.active_ids;collapseInit(root);standardifyNode(root);computeColorScales($scope.data);computeClusterParents(root);$scope.diff=false;initFeatureIndex();update(root)}});var update=function(source){$scope.nLeaves=nLeaves(root);computeDimensions();var nodeRadius=function(d){return 20*Math.pow(d.weight/root.weight,.3)};var maxCurveLength=40;var linkShape=function(d){var sourceX=d.source.x;var targetX=d.target.x;if(isCluster(d.source)){sourceX+=clusterWidth/2}else if(isCluster(d.target)){targetX-=clusterWidth/2}var xDiff=targetX-sourceX;var curveLength=Math.min(maxCurveLength,xDiff);var diag=d3.svg.diagonal().source(function(d){return{x:d.source.y,y:sourceX}}).target(function(d){return{x:d.target.y,y:sourceX+curveLength}}).projection(function(d){return[d.y,d.x]});var line;if(curveLength<xDiff){line="L "+d.target.x+","+d.target.y}else{line=""}return diag(d)+line};$scope.nodeColor=function(node){return $scope.getClusterMeta("node_"+node.id).color};var inactiveLinkColor="#CCCCCC";var activeLinkColor="#999999";var colorLeadingLinks=function(node,color){if(node.parent){svg.select("#link_"+node.parent.id+"_"+node.id).style("stroke",function(d){return color});colorLeadingLinks(node.parent,color)}};var appendLeadingNames=function(node){if(!isCluster(node)){var name=$scope.getName(node.id);if(name.length>10){name=name.substring(0,8)+"..."}svg.select("#nodegroup_"+node.id).append("text").attr("id","text_"+node.id).text(name).attr("fill",node==$scope.selectedNode?"#666":"#CCC").attr("dx",20).attr("dy",4).on("mouseover",onNodeHover)}if(node.parent){appendLeadingNames(node.parent)}};var removeLeadingNames=function(node){if(!isCluster(node)){svg.select("#text_"+node.id).remove()}if(node.parent){removeLeadingNames(node.parent)}};var onNodeHover=function(d){if(!$scope.selectedNode||$scope.selectedNode.id!=d.id){if($scope.selectedNode){colorLeadingLinks($scope.selectedNode,inactiveLinkColor);removeLeadingNames($scope.selectedNode);svg.selectAll("rect.temporary").remove();svg.selectAll("text.caret").remove()}$scope.selectedNode=d;sortFeatureIndex();showSelected(d)}};var showSelected=function(node){var nodeGroup=svg.select("#nodegroup_"+node.id);if(!$scope.readOnly){nodeGroup.append("rect").attr("x",isCluster(node)?clusterWidth/2-22:clusterWidth-25).attr("y",-clusterHeight/2).attr("width",clusterHeight+5).attr("height",clusterHeight).attr("fill-opacity",0).attr("class","temporary cursor-pointer").on("click",showNodeMenu);nodeGroup.append("text").attr("class","caret cursor-pointer").style("font-family","FontAwesome").text(String.fromCharCode(parseInt("F0D7",16))).attr("x",isCluster(node)?clusterWidth/2-15:clusterWidth-25).attr("y",5).attr("fill",isCluster(node)?"white":"#333").attr("pointer-events","none")}if(!isCluster(node)){nodeGroup.insert("rect",":first-child").attr("class","temporary").attr("width",clusterWidth).attr("height",clusterHeight).attr("rx",clusterHeight/2).attr("y",-clusterHeight/2).attr("x",-10).attr("fill","#E2E2E2")}colorLeadingLinks(node,activeLinkColor);appendLeadingNames(node);safeApply($scope)};var $nodeMenu=container.find("ul.dropdown-menu");var showNodeMenu=function(d){$nodeMenu.css("left",d.x-clusterWidth/2+5);$nodeMenu.css("top",d.y+clusterHeight/2+2);$nodeMenu.css("display","block")};var hideNodeMenu=function(e){if(e.target.classList[0]!="caret"&&e.target.classList[0]!="temporary"){$nodeMenu.css("display","none")}};$("body").on("click",hideNodeMenu);$scope.$on("$destroy",function(){$("body").off("click",null,hideNodeMenu)});var nodes=tree.nodes(root);var links=tree.links(nodes);var padding=20;computeLayout(root,width,height,padding,clusterWidth);var node=svg.selectAll(".node").data(nodes,function(d){return d.id});var link=svg.selectAll(".link").data(links);node.exit().remove();link.exit().remove();svg.selectAll("text").remove();link.enter().insert("path",":first-child").attr("class","link");link.attr("d",linkShape).attr("id",function(d){return"link_"+d.source.id+"_"+d.target.id}).style("fill","none").style("stroke",inactiveLinkColor).style("stroke-width",function(d){return Math.max(2,15*d.target.weight/root.weight)}).on("mouseover",function(d){onNodeHover(d.target)});if($scope.selectedNode){showSelected($scope.selectedNode)}var nodeEntered=node.enter().append("g").attr("class","node").attr("id",function(d){return"nodegroup_"+d.id});nodeEntered.append("rect");nodeEntered.attr("transform",function(d){return"translate("+0+", "+d.x+")"});node.attr("transform",function(d){return"translate("+d.x+", "+d.y+")"});node.select("rect").attr("width",function(d){return isCluster(d)?clusterWidth:nodeRadius(d)}).attr("height",function(d){return isCluster(d)?clusterHeight:nodeRadius(d)}).attr("rx",function(d){return(isCluster(d)?clusterHeight:nodeRadius(d))/2}).attr("y",function(d){return-(isCluster(d)?clusterHeight:nodeRadius(d))/2}).attr("x",function(d){return-(isCluster(d)?clusterWidth:nodeRadius(d))/2}).attr("fill",function(d){if(isCluster(d)){return $scope.nodeColor(d)}else if(!d.left_son){return inactiveLinkColor}else{return"white"}}).style("stroke",function(d){return"#666666"}).style("stroke-width",function(d){if(isCluster(d)||!d.left_son){return 0}else if($scope.selectedNode&&$scope.selectedNode.id==d.id){return 3}else{return 1}}).style("cursor",function(d){return hasClusterParent(d)&&d.left_son?"pointer":"default"}).attr("id",function(d){return"node_"+d.id}).on("click",click).on("mouseover",onNodeHover);node.filter(function(d){return isCluster(d)}).append("text").text(function(d){var name=$scope.getName(d.id);if(name.length>10){return name.substring(0,8)+"..."}else{return name}}).attr("text-anchor","middle").attr("fill",function(d){return"white"}).style("pointer-events","none").attr("dy",4);var linkExit=link.exit().remove();var nodeExit=node.exit().remove();node.exit().remove()}}}})})();(function(){"use strict";const app=angular.module("dataiku.ml.predicted",[]);app.directive("predictedTableBase",function($q,WT1,Assert,DataikuAPI,TopNav,MonoFuture,Logger){return{scope:true,priority:50,controller:function($scope,$stateParams,$state){$scope.shakerHooks.saveForAuto=function(){Assert.inScope($scope,"mlTaskDesign");var deferred=$q.defer();var toSave=angular.copy($scope.mlTaskDesign);toSave.predictedScript=$scope.getShakerData();var fn=null;if($scope.mlTaskDesign.taskType=="PREDICTION"){fn=DataikuAPI.analysis.pml.saveSettings}else if($scope.mlTaskDesign.taskType=="CLUSTERING"){fn=DataikuAPI.analysis.cml.saveSettings}else{throw"Unexpected taskType"}fn($stateParams.projectKey,$stateParams.analysisId,toSave).success(function(data){$scope.originalShaker=toSave.script;$scope.invalidScriptError={};for(var stepIdx in $scope.shaker.steps){var step=$scope.shaker.steps[stepIdx];var err=$scope.validateStep(step);if(err!=null){$scope.invalidScriptError={index:stepIdx,type:step.type,message:err};Logger.info("script is invalid, not refreshing");deferred.reject("Script is invalid");return}}deferred.resolve()}).error(setErrorInScope.bind($scope));return deferred.promise};var monoFuturizedRefresh=MonoFuture($scope).wrap(DataikuAPI.analysis.predicted.predictedRefreshTable);$scope.shakerHooks.getRefreshTablePromise=function(filtersOnly,filterRequest){return monoFuturizedRefresh($stateParams.fullModelId,$scope.shaker,filtersOnly,filterRequest)};$scope.shakerHooks.shakerForQuery=function(){var queryObj=angular.copy($scope.shaker);if($scope.isRecipe){queryObj.recipeSchema=$scope.recipeOutputSchema}queryObj.contextProjectKey=$stateParams.projectKey;return queryObj};$scope.shakerHooks.fetchDetailedAnalysis=function(setAnalysis,handleError,columnName,alphanumMaxResults,fullSamplePartitionId,withFullSampleStatistics){DataikuAPI.analysis.predicted.detailedColumnAnalysis($stateParams.fullModelId,$scope.shakerHooks.shakerForQuery(),columnName,alphanumMaxResults).success(function(data){setAnalysis(data)}).error(function(a,b,c){if(handleError){handleError(a,b,c)}setErrorInScope.bind($scope)(a,b,c)})};$scope.shakerHooks.getTableChunk=function(firstRow,nbRows,firstCol,nbCols,filterRequest){return DataikuAPI.analysis.predicted.predictedGetTableChunk($stateParams.fullModelId,$scope.shaker,firstRow,nbRows,firstCol,nbCols,filterRequest)};$scope.loadMLTask=function(){Assert.inScope($scope,"shakerState");Assert.inScope($scope,"shakerHooks");$scope.shakerWithSteps=false;DataikuAPI.analysis.mlcommon.getCurrentSettings($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId).success(function(data){$scope.mlTaskDesign=data;$scope.baseInit();$scope.shaker=data.predictionDisplayScript;$scope.originalShaker=angular.copy($scope.shaker);$scope.fixupShaker();$scope.refreshTable(false)}).error(setErrorInScope.bind($scope))}}}});app.directive("predictedChartsBase",function(){return{scope:true,priority:50,controller:function(){}}})})();(function(){"use strict";var app=angular.module("dataiku.ml.core",[]);app.constant("worstPrefixName","Worst ");app.factory("_MLFilteringServicePrototype",function(Fn){const computeMetric=(model,prop,currentMetric,customMetrics,currentMetricIsCustom,parentService)=>{var modelProp=Fn.prop(prop)(model);if(currentMetricIsCustom){modelProp.mainMetric=null;modelProp.mainMetricStd=null;modelProp.sortMainMetric=-1*Number.MAX_VALUE;if(modelProp.customMetricsResults){const foundCustomMetricResult=modelProp.customMetricsResults.filter(cmr=>cmr.metric.name===currentMetric)[0];if(foundCustomMetricResult){modelProp.mainMetric=foundCustomMetricResult.value;const lib=!foundCustomMetricResult.metric.greaterIsBetter?-1:1;if(modelProp.mainMetric){modelProp.sortMainMetric=lib*modelProp.mainMetric}modelProp.mainMetricStd=foundCustomMetricResult.valuestd}}}else{const lib=parentService.MLSettings.sort.lowerIsBetter(currentMetric,customMetrics)?-1:1;modelProp.mainMetric=modelProp[parentService.metricMap[currentMetric]];modelProp.sortMainMetric=modelProp.mainMetric?lib*modelProp.mainMetric:-1*Number.MAX_VALUE;if(parentService.getMetricStdFromSnippet){modelProp.mainMetricStd=parentService.getMetricStdFromSnippet(modelProp,currentMetric)}}if(modelProp.partitions&&modelProp.partitions.summaries){Object.values(modelProp.partitions.summaries).forEach(summary=>summary.snippet&&computeMetric(summary.snippet,[],currentMetric,customMetrics,currentMetricIsCustom,parentService))}};return{setMainMetric:function(modelsList,rootProp,currentMetric,customMetrics,currentMetricIsCustom=false){if(!rootProp)rootProp=[];modelsList.forEach(m=>{computeMetric(m,rootProp,currentMetric,customMetrics,currentMetricIsCustom,this)})},getMetricFromSnippet:function(model,metric){return model[this.metricMap[metric]]}}});app.factory("AlgorithmsSettingsService",function(){function getCustomAlgorithmSettings(mlTaskDesign,algorithmKey){if(algorithmKey.startsWith("custom_python_")){return mlTaskDesign.modeling.custom_python[algorithmKey.slice(14)]}else if(algorithmKey.startsWith("custom_mllib_")){return mlTaskDesign.modeling.custom_mllib[algorithmKey.slice(13)]}}function getPluginAlgorithmSettings(mlTaskDesign,algorithmKey){return mlTaskDesign.modeling.plugin_python[algorithmKey]||{}}function getAlgorithmSettings(mlTaskDesign,algorithm){if(algorithm.isCustom){return getCustomAlgorithmSettings(mlTaskDesign,algorithm.algKey)}else if(algorithm.algKey.startsWith("CustomPyPredAlgo_")){return getPluginAlgorithmSettings(mlTaskDesign,algorithm.algKey)}else{return mlTaskDesign.modeling[algorithm.hpSpaceName||algorithm.algKey]}}function getDefaultAlgorithm(mlTaskDesign,algorithms){const filteredAlgorithms=algorithms.filter(function(o){return!o.condition||o.condition()});return(filteredAlgorithms.find(algorithm=>getAlgorithmSettings(mlTaskDesign,algorithm).enabled)||filteredAlgorithms[0]).algKey}function addCustomAlgorithmsToBaseAlgorithms(baseAlgorithms,customAlgorithms,isPythonBackend){(customAlgorithms||[]).forEach(function(customAlgo,idx){const newAlgo={name:customAlgo.name||(isPythonBackend?"Custom python model":"Custom mllib model"),algKey:(isPythonBackend?"custom_python_":"custom_mllib_")+idx,isCustom:true};if(isPythonBackend)newAlgo.supportedCausalMethod="META_LEARNER";baseAlgorithms.push(newAlgo)})}return{getAlgorithmSettings:getAlgorithmSettings,getCustomAlgorithmSettings:getCustomAlgorithmSettings,getPluginAlgorithmSettings:getPluginAlgorithmSettings,getDefaultAlgorithm:getDefaultAlgorithm,addCustomAlgorithmsToBaseAlgorithms:addCustomAlgorithmsToBaseAlgorithms}});app.factory("CustomMetricIDService",function(worstPrefixName){return{checkMetricIsCustom:function(metricId){if(!metricId)return"";return metricId.substring(0,2)==="!!"||metricId.substring(0,8)==="WORST_!!"},checkMetricIsWorst:function(metricId){if(!metricId)return"";return metricId.substring(0,5)==="WORST"},getCustomMetricId:function(metricName){if(!metricName)return"";return"!!"+metricName},getCustomMetricName:function(metricId){if(!metricId)return"";if(metricId.substring(0,2)==="!!"){return metricId.substring(2)}else if(metricId.substring(0,8)==="WORST_!!"){return worstPrefixName+metricId.substring(8)}},getCustomMetricBaseName:function(metricId){if(!metricId)return"";if(metricId.substring(0,2)==="!!"){return metricId.substring(2)}else if(metricId.substring(0,8)==="WORST_!!"){return metricId.substring(8)}}}});app.factory("FinetuningUtilsService",function(){function supportsModelDeployment(llmType){return["BEDROCK","AZURE_OPENAI_MODEL","SAVED_MODEL_FINETUNED_AZURE_OPENAI","SAVED_MODEL_FINETUNED_BEDROCK"].includes(llmType)}return{supportsModelDeployment:supportsModelDeployment,getNewDeploymentMessage:function(llmType,checked){const suffix=(checked?"will":"would")+" be created.";const count=supportsModelDeployment(llmType)?1:0;return`${count===0?"No":count} ${count===1?"deployment":"deployments"} ${suffix}`},getDeletedDeploymentsCountMessage:function(deployments,savedModel,newVersionId,manualActivation,checked){const suffix=(checked?"will":"would")+" be deleted.";let count;if(manualActivation){count=deployments.length-!!deployments.find(d=>d.versionId===newVersionId)}else{const deploymentsVersionIds=deployments.map(d=>d.versionId);count=deployments.length-(savedModel.publishPolicy==="MANUAL"&&deploymentsVersionIds.includes(savedModel.activeVersion))}return`${count===0?"No":count} ${count===1?"deployment":"deployments"} ${suffix}`}}});app.factory("DeepHubMetricsService",function(){const allMetricsInfo={DEEP_HUB_IMAGE_OBJECT_DETECTION:[{name:"AVERAGE_PRECISION_IOU50",default:true,fieldName:"averagePrecisionIOU50",description:"Average Precision (IoU=0.5)",explanation:"Average Precision for IoU set to 0.5"},{name:"AVERAGE_PRECISION_IOU75",fieldName:"averagePrecisionIOU75",description:"Average Precision (IoU=0.75)",explanation:"Average Precision for IoU set to 0.75"},{name:"AVERAGE_PRECISION_ALL_IOU",fieldName:"averagePrecisionAllIOU",description:"Average Precision (all IoUs)",explanation:"Average Precision, averaged over all IoUs between 0.5 and 0.95 (with a 0.05 step)"}],DEEP_HUB_IMAGE_CLASSIFICATION:[{name:"ROC_AUC",default:true,fieldName:"auc",description:"ROC AUC",perfFieldName:"mrocAUC"},{name:"AVERAGE_PRECISION",fieldName:"averagePrecision",description:"Average Precision"},{name:"PRECISION",fieldName:"precision",description:"Precision"},{name:"RECALL",fieldName:"recall",description:"Recall"},{name:"F1",fieldName:"f1",description:"F1-score"},{name:"ACCURACY",fieldName:"accuracy",description:"Accuracy"},{name:"LOG_LOSS",fieldName:"logLoss",description:"Log Loss"}]};const confidenceScoreThresholdOptimMetrics=[{name:"F1",description:"F1 Score"},{name:"PRECISION",description:"Precision"},{name:"RECALL",description:"Recall"}];return{objectDetectionMetricsInfo:()=>{return allMetricsInfo.DEEP_HUB_IMAGE_OBJECT_DETECTION},metricNameToFieldNameMap:()=>{const map={};for(const metricsForPredictionType of Object.values(allMetricsInfo)){for(const metric of metricsForPredictionType){map[metric.name]=metric.fieldName}}return map},metricNameToPerfFieldNameMap:()=>{const map={};for(const metricsForPredictionType of Object.values(allMetricsInfo)){for(const metric of metricsForPredictionType){map[metric.name]=metric.perfFieldName?metric.perfFieldName:metric.fieldName}}return map},metricNameToDescriptionMap:()=>{const map={};for(const metricsForPredictionType of Object.values(allMetricsInfo)){for(const metric of metricsForPredictionType){map[metric.name]=metric.description}}return map},getPossibleMetricsNames:predictionType=>{if(!(predictionType in allMetricsInfo)){throw new Error("Unsupported prediction type: "+predictionType)}return allMetricsInfo[predictionType].map(metricsForPredictionType=>metricsForPredictionType.name)},metricNameToDescriptionMapPerPrediction:predictionType=>{if(!(predictionType in allMetricsInfo)){throw new Error("Unsupported prediction type: "+predictionType)}const map={};for(const metric of allMetricsInfo[predictionType]){map[metric.name]=metric.description}return map},getDefaultMetricName:predictionType=>{if(!(predictionType in allMetricsInfo)){throw new Error("Unsupported prediction type: "+predictionType)}const defaultMetric=allMetricsInfo[predictionType].find(m=>m.default);if(defaultMetric!==undefined){return defaultMetric.name}throw new Error("Prediction type '"+predictionType+"' must have a default metric")},confidenceScoreThresholdOptimMetricNameToDescription:()=>{return confidenceScoreThresholdOptimMetrics.map(e=>[e.name,e.description])}}});app.factory("PMLFilteringService",function(_MLFilteringServicePrototype,Assert,PMLSettings,BinaryClassificationModelsService,DeepHubMetricsService,CustomMetricIDService,$filter){var svc=Object.create(_MLFilteringServicePrototype);svc.MLSettings=PMLSettings;svc.metricMap={ACCURACY:"accuracy",PRECISION:"precision",RECALL:"recall",F1:"f1",CALIBRATION_LOSS:"calibrationLoss",COST_MATRIX:"costMatrixGain",CUMULATIVE_LIFT:"lift",LOG_LOSS:"logLoss",ROC_AUC:"auc",AVERAGE_PRECISION:"averagePrecision",EVS:"evs",MAPE:"mape",MAE:"mae",MSE:"mse",RMSE:"rmse",RMSLE:"rmsle",R2:"r2",PEARSON:"pearson",CUSTOM:"customScore",DATA_DRIFT:"dataDrift",DATA_DRIFT_PVALUE:"dataDriftPValue",AUUC:"auuc",QINI:"qini",NET_UPLIFT:"netUplift",MASE:"mase",SMAPE:"smape",MEAN_ABSOLUTE_QUANTILE_LOSS:"meanAbsoluteQuantileLoss",MEAN_WEIGHTED_QUANTILE_LOSS:"meanWeightedQuantileLoss",MSIS:"msis",ND:"nd",WORST_MASE:"worstMase",WORST_MAPE:"worstMape",WORST_SMAPE:"worstSmape",WORST_MSE:"worstMse",WORST_MSIS:"worstMsis",WORST_MAE:"worstMae",MIN_KS:"minKs",MIN_CHISQUARE:"minChiSquare",MAX_PSI:"maxPsi",PREDICTION_DRIFT_KS:"predictionDrift_KS",PREDICTION_DRIFT_PSI:"predictionDrift_PSI",PREDICTION_DRIFT_CHISQUARE:"predictionDrift_ChiSquare",FAITHFULNESS:"faithfulness",MULTIMODAL_FAITHFULNESS:"multimodalFaithfulness",ANSWER_RELEVANCY:"answerRelevancy",MULTIMODAL_RELEVANCY:"multimodalRelevancy",ANSWER_CORRECTNESS:"answerCorrectness",ANSWER_SIMILARITY:"answerSimilarity",CONTEXT_RECALL:"contextRecall",CONTEXT_PRECISION:"contextPrecision",BERT_SCORE_PRECISION:"bertScorePrecision",BERT_SCORE_RECALL:"bertScoreRecall",BERT_SCORE_F1:"bertScoreF1",BLEU:"bleu",ROUGE_1_PRECISION:"rouge1Precision",ROUGE_1_RECALL:"rouge1Recall",ROUGE_1_F1:"rouge1F1",ROUGE_2_PRECISION:"rouge2Precision",ROUGE_2_RECALL:"rouge2Recall",ROUGE_2_F1:"rouge2F1",ROUGE_L_PRECISION:"rougeLPrecision",ROUGE_L_RECALL:"rougeLRecall",ROUGE_L_F1:"rougeLF1",INPUT_TOKENS_PER_ROW:"inputTokensPerRow",OUTPUT_TOKENS_PER_ROW:"outputTokensPerRow",AVERAGE_TOOL_EXECUTIONS_PER_ROW:"averageToolExecutionsPerRow",AVERAGE_FAILED_TOOL_EXECUTIONS_PER_ROW:"averageFailedToolExecutionsPerRow",AVERAGE_TOOL_EXECUTION_TIME_SECONDS_PER_ROW:"averageToolExecutionTimeSecondsPerRow",P95_TOTAL_AGENT_CALL_EXECUTION_TIME_SECONDS_PER_ROW:"p95TotalAgentCallExecutionTimeSecondsPerRow",SAMPLE_ROW_COUNT:"sampleRowCount",TOOL_CALL_EXACT_MATCH:"toolCallExactMatch",TOOL_CALL_PARTIAL_MATCH:"toolCallPartialMatch",TOOL_CALL_PRECISION:"toolCallPrecision",TOOL_CALL_RECALL:"toolCallRecall",TOOL_CALL_F1:"toolCallF1",AGENT_GOAL_ACCURACY_WITH_REFERENCE:"agentGoalAccuracyWithReference",AGENT_GOAL_ACCURACY_WITHOUT_REFERENCE:"agentGoalAccuracyWithoutReference"};Object.assign(svc.metricMap,DeepHubMetricsService.metricNameToFieldNameMap());svc.getPossibleMetrics=function(mlTask){const ret=[];switch(mlTask.predictionType){case"BINARY_CLASSIFICATION":ret.push("ACCURACY","PRECISION","RECALL","F1","COST_MATRIX","ROC_AUC","CUMULATIVE_LIFT","AVERAGE_PRECISION","LOG_LOSS","CALIBRATION_LOSS");break;case"MULTICLASS":ret.push("ACCURACY","PRECISION","RECALL","F1","ROC_AUC","AVERAGE_PRECISION","LOG_LOSS","CALIBRATION_LOSS");break;case"REGRESSION":ret.push("EVS","MAPE","MAE","MSE","RMSE","RMSLE","R2","PEARSON");break;case"TIMESERIES_FORECAST":ret.push("MASE","MAPE","SMAPE","MAE","MEAN_ABSOLUTE_QUANTILE_LOSS","MEAN_WEIGHTED_QUANTILE_LOSS","MSE","RMSE","MSIS","ND");break;case"DEEP_HUB_IMAGE_OBJECT_DETECTION":case"DEEP_HUB_IMAGE_CLASSIFICATION":ret.push(...DeepHubMetricsService.getPossibleMetricsNames(mlTask.predictionType));break;case"CAUSAL_BINARY_CLASSIFICATION":case"CAUSAL_REGRESSION":ret.push("AUUC","QINI","NET_UPLIFT");break}return ret.map(function(m){return[m,PMLSettings.names.evaluationMetrics[m]]})};svc.getPossibleCustomMetrics=function(modelSnippets){const metricMap=new Map;for(const[_,snippet]of Object.entries(modelSnippets)){if(snippet&&snippet.customMetricsResults){const snippetDate=snippet.trainDate;snippet.customMetricsResults.forEach(customMetricResult=>{const metricName=customMetricResult.metric.name;if(!metricMap.has(metricName)||snippetDate>metricMap.get(metricName)[0]){metricMap.set(metricName,[snippetDate,customMetricResult.metric])}})}}const ret=[];metricMap.forEach(function(data){const metric=data[1];metric.id=CustomMetricIDService.getCustomMetricId(metric.name);ret.push(metric)});return ret};svc.getMetricStdFromSnippet=function(model,metric){switch(metric){case"LOG_LOSS":return model.logLossstd;case"CUSTOM":return model.customScorestd;default:return model[svc.metricMap[metric]+"std"]}};svc.getMetricValueFromModelWithCurrentCut=function(modelData,metric){const pcd=BinaryClassificationModelsService.findCutData(modelData.perf,modelData.userMeta.activeClassifierThreshold);return svc.getMetricValueFromModel(modelData,metric,pcd)};svc.getMetricValueFromModel=function(modelData,metric,currentCutData){function getFromTIMetrics(){if(!(modelData.perf&&modelData.perf.tiMetrics)){return"<No metric available>"}if(!modelData.perf.tiMetrics[svc.metricMap[metric]]){return"<"+metric+" not available>"}return modelData.perf.tiMetrics[svc.metricMap[metric]]}function getFromCurrentCutData(key){Assert.trueish(currentCutData,"no currentCutData");return currentCutData[key]}function extractFromCustomMetrics(customMetricName,modelData){const customMetric=modelData.modeling.metrics.customMetrics.find(customMetric=>customMetric.name===customMetricName);let customMetricsResults;if(customMetric.needsProbability){customMetricsResults=modelData.perf.tiMetrics.customMetricsResults}else{Assert.trueish(currentCutData,"no currentCutData");customMetricsResults=currentCutData.customMetricsResults}return customMetricsResults.filter(item=>item.metric.name===customMetric.name)[0].value}function getMetricForNonBinaryClassifPredictions(metrics,metricMap,metricField){Assert.trueish(metricField,"metric not specified");const metricName=metricMap[metricField];Assert.trueish(metricName,"cannot display metric "+metricField);if(!metrics)return"<No metric available>";if(!(metricName in metrics)||metrics[metricName]==undefined){return"<"+metricName+" not available>"}return metrics[metricName]}const metricIsCustom=CustomMetricIDService.checkMetricIsCustom(metric);if(metric==="DATA_DRIFT"&&modelData.dataEvaluationMetrics&&modelData.dataEvaluationMetrics.driftModelAccuracy){return modelData.dataEvaluationMetrics.driftModelAccuracy.value}Assert.trueish(modelData,"no modelData");Assert.trueish(modelData.coreParams,"no coreParams");switch(modelData.coreParams.prediction_type){case"BINARY_CLASSIFICATION":Assert.trueish(metric,"metric not specified");if(metricIsCustom){return extractFromCustomMetrics(CustomMetricIDService.getCustomMetricName(metric),modelData)}switch(metric){case"F1":Assert.trueish(currentCutData,"no currentCutData");return getFromCurrentCutData("F1-Score");case"RECALL":Assert.trueish(currentCutData,"no currentCutData");return getFromCurrentCutData("Recall");case"PRECISION":Assert.trueish(currentCutData,"no currentCutData");return getFromCurrentCutData("Precision");case"ACCURACY":Assert.trueish(currentCutData,"no currentCutData");return getFromCurrentCutData("Accuracy");case"COST_MATRIX":Assert.trueish(currentCutData,"no currentCutData");return getFromCurrentCutData("cmg");case"LOG_LOSS":case"ROC_AUC":case"AVERAGE_PRECISION":case"CUMULATIVE_LIFT":return getFromTIMetrics();case"CUSTOM":return extractFromCustomMetrics(modelData.modeling.metrics.customEvaluationMetricName,modelData)}Assert.fail("Unknown metric "+metric);case"MULTICLASS":{if(metricIsCustom){const metricName=CustomMetricIDService.getCustomMetricName(metric);return modelData.perf&&modelData.perf.metrics&&modelData.perf.metrics.customMetricsResults.filter(item=>item.metric.name===metricName)[0].value}else{const multiclassMetricMap={...svc.metricMap,ROC_AUC:"mrocAUC"};return getMetricForNonBinaryClassifPredictions(modelData.perf&&modelData.perf.metrics,multiclassMetricMap,metric)}}case"DEEP_HUB_IMAGE_OBJECT_DETECTION":case"DEEP_HUB_IMAGE_CLASSIFICATION":return getMetricForNonBinaryClassifPredictions(modelData.perf&&modelData.perf.metrics,DeepHubMetricsService.metricNameToPerfFieldNameMap(),metric);case"REGRESSION":{if(metricIsCustom){const metricName=CustomMetricIDService.getCustomMetricName(metric);return modelData.perf&&modelData.perf.metrics&&modelData.perf.metrics.customMetricsResults.filter(item=>item.metric.name===metricName)[0].value}else{return getMetricForNonBinaryClassifPredictions(modelData.perf&&modelData.perf.metrics,svc.metricMap,metric)}}case"CAUSAL_BINARY_CLASSIFICATION":case"CAUSAL_REGRESSION":return modelData.perf.causalPerf.normalized[svc.metricMap[metric]];case"TIMESERIES_FORECAST":return getMetricForNonBinaryClassifPredictions(modelData.perf&&modelData.perf.aggregatedMetrics,svc.metricMap,metric)}};const imageMetricToSuffixMap=[{name:"meanRedPerFeature",suffix:"_Mean_Red_KS"},{name:"meanGreenPerFeature",suffix:"_Mean_Green_KS"},{name:"meanBluePerFeature",suffix:"_Mean_Blue_KS"},{name:"meanSaturationPerFeature",suffix:"_Mean_Saturation_KS"},{name:"rmsContrastPerFeature",suffix:"_Contrast_RMS_KS"},{name:"laplacianVarPerFeature",suffix:"_Sharpness_Laplacian_KS"},{name:"tenengradPerFeature",suffix:"_Sharpness_Tenengrad_KS"},{name:"entropyPerFeature",suffix:"_Entropy_Complexity_KS"},{name:"edgeDensityPerFeature",suffix:"_Edge_Density_KS"},{name:"areaPerFeature",suffix:"_Area_KS"},{name:"aspectRatioPerFeature",suffix:"_Aspect_Ratio_KS"}];svc.isEmbeddingMetric=function(metric){return metric.endsWith("_ED")||metric.endsWith("_CS")||metric.endsWith("_Classifier_gini")};svc.isImageMetric=function(metric){return imageMetricToSuffixMap.some(config=>metric.endsWith(config.suffix))};svc.isUnivariateMetric=function(metric){return metric.endsWith("_KS")&&metric!=="MIN_KS"&&metric!=="PREDICTION_DRIFT_KS"&&metric!=="predictionDrift_KS"&&!svc.isImageMetric(metric)||metric.endsWith("_PSI")&&metric!=="MAX_PSI"&&metric!=="PREDICTION_DRIFT_PSI"&&metric!=="predictionDrift_PSI"||metric.endsWith("_Chi-square")&&metric!=="predictionDrift_ChiSquare"};svc.univariateMetrics=["ksPerFeature","psiPerFeature","chiSquarePerFeature"];svc.embeddingMetrics=["euclidianDistancePerFeature","cosineSimilarityPerFeature","classifierGiniPerFeature"];svc.imageMetrics=imageMetricToSuffixMap.map(config=>config.name);svc.dataDriftMetrics=["DATA_DRIFT","DATA_DRIFT_PVALUE","MIN_KS","MIN_CHISQUARE","MAX_PSI","dataDrift","dataDriftPValue","minKs","minChiSquare","maxPsi","dataDriftDeviation",...svc.univariateMetrics,...svc.embeddingMetrics,...svc.imageMetrics];svc.predictionDriftMetrics=["PREDICTION_DRIFT_KS","PREDICTION_DRIFT_CHISQUARE","PREDICTION_DRIFT_PSI","predictionDrift_KS","predictionDrift_ChiSquare","predictionDrift_PSI"];svc.driftMetrics=svc.dataDriftMetrics.concat(svc.predictionDriftMetrics);svc.isDataDriftMetric=metric=>svc.dataDriftMetrics.includes(metric)||svc.isUnivariateMetric(metric)||svc.isEmbeddingMetric(metric)||svc.isImageMetric(metric);svc.isPredictionDriftMetric=metric=>svc.predictionDriftMetrics.includes(metric);svc.isDriftMetric=metric=>svc.isDataDriftMetric(metric)||svc.isPredictionDriftMetric(metric);svc.univariateMetric=function(metric,metrics){if(metric.endsWith("_KS")){return metrics.ksPerFeature[metric.split("_KS")[0]]}if(metric.endsWith("_PSI")){return metrics.psiPerFeature[metric.split("_PSI")[0]]}if(metric.endsWith("_Chi-square")){return metrics.chiSquarePerFeature[metric.split("_Chi-square")[0]]}return undefined};svc.embeddingMetric=function(metric,metrics){if(metric.endsWith("_ED")){return metrics.euclidianDistancePerFeature[metric.split("_ED")[0]]}if(metric.endsWith("_CS")){return metrics.cosineSimilarityPerFeature[metric.split("_CS")[0]]}if(metric.endsWith("_Classifier_gini")){return metrics.classifierGiniPerFeature[metric.split("_Classifier_gini")[0]]}return undefined};svc.imageMetric=function(metric,metrics){const config=imageMetricToSuffixMap.find(c=>metric.endsWith(c.suffix));if(config){const baseKey=metric.split(config.suffix)[0];return metrics[config.name][baseKey]}return undefined};svc.getDataDriftWithDeviation=function(metrics,metric,precision){let ret=$filter("mlMetricFormat")(metrics[svc.metricMap[metric]],metric,precision);if(metrics["dataDriftDeviation"]){ret=ret.toString()+" ± ("+$filter("mlMetricFormat")(metrics["dataDriftDeviation"],metric,precision)+")"}return ret};svc.getEvaluationMetricName=function(metric){if("DATA_DRIFT"===metric){return"Data drift"}else if(svc.isUnivariateMetric(metric)||svc.isEmbeddingMetric(metric)||svc.isImageMetric(metric)){return metric}else if(CustomMetricIDService.checkMetricIsCustom(metric)){return CustomMetricIDService.getCustomMetricName(metric)}else{return PMLSettings.names.evaluationMetrics[metric]}};return svc});app.factory("MLContainerInfoService",function(DataikuAPI){function inContainer($scope,projectKey){let listContainersWithDefault=null;DataikuAPI.containers.listNamesWithDefault(projectKey,null,"USER_CODE").success(function(data){listContainersWithDefault=data}).error(setErrorInScope.bind($scope));return function(selectedContainer){if(selectedContainer.containerMode==="NONE"||listContainersWithDefault===null){return false}else if(selectedContainer.containerMode==="INHERIT"){return listContainersWithDefault.resolvedInheritValue!=null}else{return true}}}return{inContainer:inContainer}});app.factory("CMLFilteringService",function(_MLFilteringServicePrototype,Assert,CMLSettings,Fn){var svc=Object.create(_MLFilteringServicePrototype);svc.MLSettings=CMLSettings;svc.metricMap={SILHOUETTE:"silhouette",INERTIA:"inertia",NB_CLUSTERS:"nbClusters"};svc.getPossibleMetrics=Fn.cst(CMLSettings.task.evaluationMetrics);svc.getPossibleCustomMetrics=Fn.cst([]);svc.getMetricNameFromModel=function(modelData){Assert.trueish(modelData,"no modelData");return modelData.actualParams.resolved.metrics.evaluationMetric};svc.getMetricValueFromModel=function(modelData){Assert.trueish(modelData,"no modelData");let metricName=modelData.actualParams.resolved.metrics.evaluationMetric;metricName=svc.metricMap[metricName];let metricValue=modelData.perf.metrics[metricName];return metricValue};return svc});app.service("MLExportService",function(DataikuAPI,WT1,$stateParams,Dialogs,CreateModalFromTemplate,SpinnerService,FutureWatcher,FullModelLikeIdUtils,SavedModelsService){this.downloadFile=(scope,generateFile,getUrl)=>{generateFile().success(data=>{SpinnerService.lockOnPromise(FutureWatcher.watchJobId(data.jobId).success(data=>{downloadURL(getUrl(data.result.exportId));scope.dismiss()}).error(error=>{Dialogs.error(scope,"An error occured while exporting file",error.message)}))}).error(error=>{Dialogs.error(scope,"An error occured while exporting file",error.message)})};this.showExportModel=function(appConfig){if(!appConfig.licensedFeatures){return false}else{return appConfig.licensedFeatures.modelsExport}};this.downloadDocForbiddenReason=function(appConfig,model){if(!appConfig.graphicsExportsEnabled){return"Graphics export must be enabled in order to use this feature. Your administrator needs to intervene to fix the issue."}if(!model)return null;if(model.backendType==="KERAS"){return"Deep learning models are not compatible with documentation export"}if(model.backendType==="DEEP_HUB"){return"Computer vision models are not compatible with documentation export"}if(["CAUSAL_REGRESSION","CAUSAL_BINARY_CLASSIFICATION"].includes(model.coreParams.prediction_type)){return"Causal prediction models are not compatible with documentation export"}if(model&&model.modeling.algorithm==="VIRTUAL_PROXY_MODEL"){return"External Models are not compatible with documentation export"}if(model.modeling.algorithm.endsWith("_ENSEMBLE")){return"Ensemble models are not compatible with documentation export."}return null};this.downloadDoc=function(scope){CreateModalFromTemplate("/templates/analysis/prediction/model/download-documentation-modal.html",scope,"DownloadModelDocumentationController",undefined,undefined,"static")};this.mayExportModel=function(model,type){switch(type){case"pmml":return model&&model.pmmlCompatibility.compatible;case"python":return model&&model.pythonCompatibility.compatible;case"jar":return model&&model.javaExportCompatibility.compatible;case"snowflake":return model&&model.javaExportCompatibility.compatible;default:return model&&(model.pmmlCompatibility.compatible||model.pythonCompatibility.compatible||model.javaExportCompatibility.compatible)}};this.exportModelModal=function(scope,model,cantExportToSnowflake){scope.exportType=model.javaExportCompatibility.compatible?cantExportToSnowflake?"jar":"snowflake":model.pythonCompatibility.compatible?"python":null;CreateModalFromTemplate("/templates/analysis/prediction/model/export-model-modal.html",scope,"ExportModelController",function(modalScope){modalScope.cantExportToSnowflake=cantExportToSnowflake;modalScope.model=model;modalScope.exportType=scope.exportType;DataikuAPI.connections.getNames("Snowflake").success(function(connectionNames){scope.snowflakeConnectionNames=connectionNames}).error(setErrorInScope.bind(scope));DataikuAPI.connections.getNames("DatabricksModelDeployment").success(function(connectionNames){scope.databricksConnectionNames=connectionNames}).error(setErrorInScope.bind(scope))})};this.disableExportModelModalReason=function(model){if(model&&model.backendType==="KERAS"){return"Export of Deep Learning models is not supported"}if(model&&model.backendType==="DEEP_HUB"){return"Export of Computer vision models is not supported"}if(model&&model.coreParams&&model.coreParams.prediction_type==="TIMESERIES_FORECAST"){return"Export of Time series forecasting models is not supported"}if(model&&model.coreParams&&["CAUSAL_BINARY_CLASSIFICATION","CAUSAL_REGRESSION"].includes(model.coreParams.prediction_type)){return"Export of Causal prediction models is not supported"}if(SavedModelsService.isProxyModel(model)){return"Export of External Models is not supported"}return null};this.exportModel=function(scope,model,type,partitionName){if(type=="docgen"){if(scope.appConfig.graphicsExportsEnabled){if(["KERAS_CODE","DEEP_HUB"].includes(model.backendType)){Dialogs.error(scope,"Model is not compatible","Model backend not supported: "+model.backendType)}else if(model.modeling.algorithm==="VIRTUAL_MLFLOW_PYFUNC"){Dialogs.error(scope,"Model is not compatible","Documentation export of MLflow imported models is not supported")}else if(model.modeling.algorithm==="VIRTUAL_PROXY_MODEL"){Dialogs.error(scope,"Model is not compatible","Documentation export of External Models is not supported")}else if(!model.modeling.algorithm.endsWith("_ENSEMBLE")){CreateModalFromTemplate("/templates/analysis/prediction/model/download-documentation-modal.html",scope,"DownloadModelDocumentationController",undefined,undefined,"static")}else{Dialogs.error(scope,"Model is not compatible","Documentation export of ensembled models is not supported")}}else{CreateModalFromTemplate("/templates/exports/graphics-export-disabled-modal.html",scope)}}else if(type==="jar-thin"||type==="jar-fat"){if(model.javaExportCompatibility.compatible){const downloadPrompt=id=>{Dialogs.prompt(scope,"Download model JAR","Fully-qualified class name for the model","com.company.project.Model",{pattern:"^((?:[a-z]\\w*\\.)*)?([A-Z]\\w*)$"}).then(name=>{WT1.event("model-export",{exportType:type});this.downloadFile(scope,()=>DataikuAPI.ml.prediction.createScoringModelFile(type,id,"&fullClassName="+encodeURIComponent(name)),exportId=>DataikuAPI.ml.prediction.getScoringModelDownloadURL(type,exportId))})};if(!partitionName){downloadPrompt(model.fullModelId)}else{const choices=[{id:FullModelLikeIdUtils.getBase(model.fullModelId),title:"Full model, with all partitions"},{id:model.fullModelId,title:"Single model partition",desc:partitionName}];Dialogs.select(scope,"Export partitioned model","Do you want to export the full model or just the current partition?",choices,choices[0]).then(selected=>{downloadPrompt(selected.id)})}}else{Dialogs.error(scope,"Model is not compatible with Java export",model.javaExportCompatibility.reason)}}else if(type==="pmml"&&!model.pmmlCompatibility.compatible){Dialogs.error(scope,"Model is not compatible with PMML export",model.pmmlCompatibility.reason)}else if(type==="python"&&!model.pythonCompatibility.compatible){Dialogs.error(scope,"Model is not compatible with Python export",model.pythonCompatibility.reason)}else if(type==="mlflow"&&!model.pythonCompatibility.compatible){Dialogs.error(scope,"Model is not compatible with MLflow export",model.pythonCompatibility.reason)}else{WT1.event("model-export",{exportType:type});this.downloadFile(scope,()=>DataikuAPI.ml.prediction.createScoringModelFile(type,model.fullModelId),exportId=>DataikuAPI.ml.prediction.getScoringModelDownloadURL(type,exportId))}}});app.factory("ExportModelDatasetService",function(DataikuAPI,$stateParams,$state,Dialogs,CreateExportModal,FutureProgressModal,FullModelLikeIdUtils){const service={exportTrainTestSets:exportTrainTestSets,exportTrainTestSetsForbiddenReason:exportTrainTestSetsForbiddenReason,exportPredictedData:exportPredictedData,exportPredictedDataForbiddenReason:exportPredictedDataForbiddenReason};return service;function exportTrainTestSets(scope,fullModelId){const datasetDialog={title:"Export the train and test sets"};const features={hideDestinationTabs:true,hideAdvancedParameters:true};CreateExportModal(scope,datasetDialog,features,{destinationType:"DATASET"}).then(function(params){DataikuAPI.ml.exportModelDataset(fullModelId,params).then(function(response){showProgressDialog(scope,response.data.futureResponse,params.destinationDatasetName,"train and test sets")}).catch(function(response){Dialogs.error(scope,"An error occurred while exporting the train and test sets",response.data.detailedMessageHTML)})})}function exportPredictedData(scope,fullModelId){const datasetDialog={title:"Export the predicted data"};const features={hideDestinationTabs:true,hideAdvancedParameters:true};CreateExportModal(scope,datasetDialog,features,{destinationType:"DATASET"}).then(function(params){DataikuAPI.ml.exportModelPredictedData(fullModelId,params).then(function(response){showProgressDialog(scope,response.data.futureResponse,params.destinationDatasetName,"predicted data")}).catch(function(response){Dialogs.error(scope,"An error occurred while exporting the predicted data",response.data.detailedMessageHTML)})})}function showProgressDialog(scope,futureResponse,destinationDatasetName,dataTypeName,warningMessage){FutureProgressModal.show(scope,futureResponse,"Exporting the "+dataTypeName).then(function(result){if(result){const datasetPage="projects.project.datasets.dataset.explore";const datasetPageParams={projectKey:$stateParams.projectKey,datasetName:destinationDatasetName};const datasetLink=`<a href="`+$state.href(datasetPage,datasetPageParams)+`">`+sanitize(destinationDatasetName)+"</a>";let message;if(warningMessage){message=`<p class="alert alert-warning">Dataset `+datasetLink+` has been created.<br />`+sanitize(warningMessage)+`</p>`}else{message=`<p class="alert alert-success">Dataset `+datasetLink+` has been created successfully.</p>`}Dialogs.confirm(scope,"Exported the "+dataTypeName,message,{btnCancel:"Close",btnConfirm:"View dataset",positive:true}).then(function(){$state.go(datasetPage,datasetPageParams)},function(){})}})}function exportTrainTestSetsForbiddenReason(model,canWriteProject){if(!model){return null}if(model.coreParams.prediction_type==="TIMESERIES_FORECAST"){return"Not available for time series forecasting. Export the resampled data from the Predicted data tab."}if(model.trainInfo.kfold){return"Export of train and test sets not supported for models evaluated using kfold"}const isPartitionedModel=model.coreParams.partitionedModel&&model.coreParams.partitionedModel.enabled;const isIndividualPartitionedModel=!!FullModelLikeIdUtils.parse(model.fullModelId).partitionName;if(isPartitionedModel&&!isIndividualPartitionedModel){return"Export of train and test sets for overall model is not supported (only available for individual partitions)"}if(model.modeling&&model.modeling.algorithm&&model.modeling.algorithm=="VIRTUAL_MLFLOW_PYFUNC"){return"Models imported from mlflow do not have train and test data to export"}if(!(model.splitDesc&&model.splitDesc.testPath&&model.splitDesc.trainPath)){return"No train and test sets to export for this model"}if(typeof canWriteProject!=="undefined"&&!canWriteProject){return"You don't have write permissions for this project"}}function exportPredictedDataForbiddenReason(model){if(!model){return null}if(model.coreParams.partitionedModel&&model.coreParams.partitionedModel.enabled&&model.splitDesc&&model.splitDesc.params&&model.splitDesc.params.ssdSelection&&model.splitDesc.params.ssdSelection.partitionSelectionMethod=="ALL"){return"Export of predicted data for overall model is not supported (only available for individual partitions)"}}});app.filter("gridParameter",function(){return function(par){if(par.vals){return par.vals.join(", ")}else if(par.val){return par.val}else if(par.cnt){return par.cnt+" value(s)"}else if(par.min&&par.max){return"("+par.min+", "+par.max+")"}}});app.directive("gridDescription",function(){return{scope:{desc:"=",trained:"=",gridsearchData:"=",filterPostTrainParams:"="},restrict:"A",templateUrl:"/templates/ml/model-snippet-grid-description.html",link:function(scope){scope.filterPostTrainParams=scope.filterPostTrainParams||(param=>true)}}});app.directive("modelSnippet",function($state,$rootScope,$filter,PMLSettings,MLModelsUIRouterStates,ModelDataUtils,CustomMetricIDService,FullModelLikeIdUtils,CreateModalFromTemplate,DataikuAPI,$stateParams,AnyLoc,PromptUtils){return{scope:{snippetData:"=",snippetSource:"@",taskType:"=",smData:"=",makeActive:"=",deleteModel:"=",currentMetric:"=",hideOptions:"<"},templateUrl:"/templates/ml/model-snippet.html",link:function($scope){$scope.$state=$state;$scope.appConfig=$rootScope.appConfig;$scope.out=$scope.$parent;$scope.ModelDataUtils=ModelDataUtils;let defaultTab=".report";if(["TOOLS_USING_AGENT","PLUGIN_AGENT","PYTHON_AGENT","RETRIEVAL_AUGMENTED_LLM"].includes($scope.snippetData.savedModelType)){defaultTab=".design"}$scope.baseRef=$scope.out.sRefPrefix+($scope.snippetSource==="SAVED"?"":".model")+defaultTab;$scope.displayMainMetric=function(snippetData,currentMetric){if(!currentMetric)return"";return $scope.out.isModelDone(snippetData)&&(snippetData.mainMetric||CustomMetricIDService.checkMetricIsCustom(currentMetric))};$scope.getDeploymentStatus=function(snippetData,deployments){if(!snippetData.deployment||!deployments)return;const deployment=deployments.find(d=>d.versionId==snippetData.deployment.versionId);return deployment&&deployment.status};$scope.getTabForDiagnostic=()=>{if($scope.taskType==="CLUSTERING"){return"train"}const isDeephubPrediction=$scope.snippetData.backendType==="DEEPHUB";if($scope.snippetData.partitionedModelEnabled){return MLModelsUIRouterStates.getPredictionReportSummaryTab(isDeephubPrediction,false)}return MLModelsUIRouterStates.getPredictionReportTrainTab(isDeephubPrediction)};$scope.getTabForOverrideMetrics=()=>MLModelsUIRouterStates.getPredictionReportOverridesMetricsTab();if($scope.snippetData.predictionType==="TIMESERIES_FORECAST"){$scope.algosWithoutQuantiles=PMLSettings.algorithmCategories("TIMESERIES_FORECAST")["Baseline Models"];$scope.$watch("snippetData.forecasts",function(){if(!$scope.snippetData.forecasts)return;$scope.$selectedTimeseries=Object.keys($scope.snippetData.forecasts.perTimeseries)[0];$scope.filterImportantParamPerTs=function(param){return!param.id||param.id&&param.id===$scope.$selectedTimeseries}})}$scope.openExternalModelSetupMonitoringModal=function(proxyModelEndpointInfo,versionId){return CreateModalFromTemplate("/templates/savedmodels/external-model-setup-monitoring.html",$scope,"ExternalModelSetupMonitoringModalController",function(modalScope){modalScope.createMes=true;modalScope.createOutputDataset=true;modalScope.predictionLogsUri=proxyModelEndpointInfo.predictionLogsUri;modalScope.versionId=versionId})};$scope.getSummariesAsArray=function(snippetData){if(snippetData&&snippetData.partitions&&snippetData.partitions.summaries){return Object.entries(snippetData.partitions.summaries).map(s=>({name:s[0],summary:s[1]}))}else{return[]}};$scope.getLLMIcon=function(llmType,size){return PromptUtils.getLLMIcon(llmType,size)};$scope.uiState=$scope.uiState||{};if($scope.snippetData){$scope.uiState.parsedFMI=FullModelLikeIdUtils.parse($scope.snippetData.fullModelId);if($scope.snippetData.proxyModelConfiguration&&$scope.snippetData.proxyModelEndpointInfo){switch($scope.snippetData.proxyModelConfiguration.protocol){case"vertex-ai":$scope.uiState.proxyModelConfigurationUIInfo={protocol:$scope.snippetData.proxyModelConfiguration.protocol,project_id:$scope.snippetData.proxyModelConfiguration.project_id,region:$scope.snippetData.proxyModelConfiguration.region,endpoint_id:$scope.snippetData.proxyModelEndpointInfo.name?$scope.snippetData.proxyModelEndpointInfo.name.split("/").pop():"",prediction_type:$filter("mlModelType")($scope.snippetData.predictionType)};break;case"sagemaker":$scope.uiState.proxyModelConfigurationUIInfo={protocol:$scope.snippetData.proxyModelConfiguration.protocol,region:$scope.snippetData.proxyModelConfiguration.region,endpoint_name:$scope.snippetData.proxyModelEndpointInfo.arn?$scope.snippetData.proxyModelEndpointInfo.arn.split("/").pop():"",prediction_type:$filter("mlModelType")($scope.snippetData.predictionType)};break;case"azure-ml":$scope.uiState.proxyModelConfigurationUIInfo={protocol:$scope.snippetData.proxyModelConfiguration.protocol,subscription_id:$scope.snippetData.proxyModelConfiguration.subscription_id,resource_group:$scope.snippetData.proxyModelConfiguration.resource_group,workspace:$scope.snippetData.proxyModelConfiguration.workspace,endpoint_name:$scope.snippetData.proxyModelEndpointInfo.endpointInfo&&$scope.snippetData.proxyModelEndpointInfo.endpointInfo.id?$scope.snippetData.proxyModelEndpointInfo.endpointInfo.id.split("/").pop():"",prediction_type:$filter("mlModelType")($scope.snippetData.predictionType)};break;case"databricks":$scope.uiState.proxyModelConfigurationUIInfo={protocol:$scope.snippetData.proxyModelConfiguration.protocol,endpoint_name:$scope.snippetData.proxyModelEndpointInfo.endpointName,prediction_type:$filter("mlModelType")($scope.snippetData.predictionType)};break}}if($scope.snippetData.savedModelType&&$scope.snippetData.savedModelType==="TOOLS_USING_AGENT"){let allUsedToolRefs=$scope.snippetData.toolsUsingAgentSettings.tools.filter(tool=>tool.toolRef).map(tool=>AnyLoc.getLocFromSmart($stateParams.projectKey,tool.toolRef).fullId);DataikuAPI.agentTools.listAvailable($stateParams.projectKey).success(function(data){const toolLookup={};data.forEach(item=>{toolLookup[`${item.projectKey}.${item.id}`]=item});$scope.snippetData.fullTools=allUsedToolRefs.map(toolRefId=>{const item=toolLookup[toolRefId];if(item){const isForeign=item.projectKey!==$stateParams.projectKey;return angular.extend({},item,{foreign:isForeign,name:isForeign?`${item.projectKey}.${item.name}`:item.name})}else{return null}}).filter(item=>item!==null)}).error(setErrorInScope.bind($scope));DataikuAPI.pretrainedModels.listAvailableLLMs($stateParams.projectKey,"GENERIC_COMPLETION").success(function(data){$scope.snippetData.llm=data.identifiers.find(llm=>llm.id===$scope.snippetData.toolsUsingAgentSettings.llmId)}).error(setErrorInScope.bind($scope))}else if($scope.snippetData.savedModelType&&$scope.snippetData.savedModelType==="RETRIEVAL_AUGMENTED_LLM"){DataikuAPI.pretrainedModels.listAvailableLLMs($stateParams.projectKey,"GENERIC_COMPLETION").success(function(data){$scope.snippetData.llm=data.identifiers.find(llm=>llm.id===$scope.snippetData.ragllmSettings.llmId)}).error(setErrorInScope.bind($scope));DataikuAPI.retrievableknowledge.get($stateParams.projectKey,$scope.snippetData.ragllmSettings.kbRef).success(knowledgeBank=>{$scope.snippetData.kb=knowledgeBank}).error(setErrorInScope.bind($scope))}}else{$scope.uiState.parsedFMI=null}}}});app.directive("externalEndpointSync",function(DataikuAPI,FutureProgressModal,InfoMessagesModal){return{bindings:{projectKey:"<",smId:"<",versionId:"<"},scope:{projectKey:"<",smId:"<",versionId:"<"},replace:false,template:`
            <a ng-click="checkEndpoint()" toggle="tooltip" title="{{uiState.endpointCheckProgress}}">
                <i class="{{uiState.endpointStatusIcon}}" style="vertical-align: {{uiState.verticalAlign}};"></i> Check Endpoint
            </a>
        `,link:function($scope){$scope.uiState={endpointCheckProgress:"Sync with remote endpoint not checked",endpointStatusIcon:"dku-icon-question-circle-outline-16",endpointStatusBtn:null,verticalAlign:"bottom"};$scope.checkEndpoint=function(){$scope.uiState.endpointStatusIcon="dku-icon-arrow-clockwise-dashes-12 icon-spin";$scope.uiState.endpointStatusBtn=null;$scope.uiState.verticalAlign="middle";DataikuAPI.savedmodels.prediction.checkProxyModelVersionEndpoint($scope.projectKey,$scope.smId,$scope.versionId).then(function(resp){FutureProgressModal.show($scope,resp.data,"Checking endpoint").then(function(result){$scope.uiState.verticalAlign="bottom";if(result){let subHeader="Differences were found between the current endpoint and the endpoint when"+" this Saved Model Version was created. If those differences impact the model"+" predictions, we recommend creating a new Saved Model Version to materialize"+" this change.";if(result.maxSeverity=="INFO"){$scope.uiState.endpointStatusIcon="dku-icon-checkmark-circle-outline-16";$scope.uiState.endpointCheckProgress="Online endpoint matches active version";subHeader=null}else if(result.maxSeverity=="WARNING"){$scope.uiState.endpointStatusIcon="dku-icon-arrow-circular-strike-16";$scope.uiState.endpointCheckProgress="Online endpoint does not fully match this version"}else{$scope.uiState.endpointStatusIcon="dku-icon-error-circle-outline-16";$scope.uiState.endpointCheckProgress="Online endpoint differs from this version";$scope.uiState.endpointStatusBtn="btn--danger"}InfoMessagesModal.showIfNeeded($scope,result,"Endpoint check result",subHeader)}else{$scope.uiState.endpointCheckProgress="Sync with remote endpoint not checked";$scope.uiState.endpointStatusIcon="dku-icon-question-circle-outline-16";$scope.uiState.endpointStatusBtn=null}})},setErrorInScope.bind($scope))}}}});app.filter("safeTemplateUrl",function(LoggerProvider){const logger=LoggerProvider.getLogger("ml.core");const safeTemplateUrlRegex=/^\/(templates|static\/dataiku)(\/[-\w]+)+\.html$/;return path=>{if(safeTemplateUrlRegex.test(path)){return path}else{logger.warn("Invalid template url: "+path);return"invalid_template_url"}}});app.filter("niceModelState",function($filter){return function(state,source){if(!state){return"-"}if(state.startsWith("REUSED_")){return"Re-used"}else if(state==="DONE"){return"Trained"}return $filter("niceConst")(state)}});app.directive("modelState",function($state,MLModelsUIRouterStates){return{scope:{state:"=",model:"=",sRefPrefix:"=",displayDiagnostics:"="},templateUrl:"/templates/ml/model-snippet-state.html",link:function($scope){$scope.$state=$state;$scope.getTrainTab=()=>{return MLModelsUIRouterStates.getPredictionReportTrainTab($scope.model.backendType==="DEEPHUB")}}}});app.directive("modelsTable",function($state,DataikuAPI){return{scope:true,link:function($scope,element){$scope.saveMeta=function(snippetData){DataikuAPI.ml.saveModelUserMeta(snippetData.fullModelId,snippetData.userMeta).error(setErrorInScope.bind($scope.$parent))}}}});app.filter("mlMetricFormat",function(){var ignoreZerosForMetrics=["INERTIA","RMSLE"];var usePercentageForMetrics=["MAPE","SMAPE"];return function(metricValue,metricName,precision,sigma,exp){if(metricValue===undefined||metricValue===null||"<No metric available>"==metricValue||metricValue=="<"+metricName+" not available>"){return"-"}if(ignoreZerosForMetrics.indexOf(metricName)>=0&&metricValue==0){return"-"}var percent=usePercentageForMetrics.indexOf(metricName)>=0;var sigmaPrecision;var pc="";if(typeof precision==="number"){sigmaPrecision=precision}else{precision=4;sigmaPrecision=2}if(percent){pc="%";metricValue*=100;sigma=(sigma||0)*100;precision=Math.max(1,precision-2);sigmaPrecision=Math.max(1,sigmaPrecision-2);exp=false}var abs=Math.abs(metricValue);if(isNaN(abs)){return"-"}else if(abs>=1e4&&!percent){exp=true}else if(abs>=100){precision=0;exp=false}return(metricValue||0)[exp?"toPrecision":"toFixed"](precision)+pc+(sigma?' <span class="sigma">(± '+(2*sigma)[exp?"toPrecision":"toFixed"](sigmaPrecision)+pc+")</span>":"")}});app.filter("mlMetricName",function($filter,PMLSettings,CMLSettings,Fn){var allMetrics=angular.extend({},PMLSettings.names.evaluationMetrics,CMLSettings.names.evaluationMetrics);return function(input,snippetData){if(input=="CUMULATIVE_LIFT"){return $.isNumeric(snippetData.liftPoint)?"Lift at "+Math.round(snippetData.liftPoint*100)+"%":"Lift"}else if(input=="NET_UPLIFT"){return $.isNumeric(snippetData.netUpliftPoint)?"Net Uplift at "+Math.round(snippetData.netUpliftPoint*100)+"%":"Net Uplift"}return allMetrics[input]||$filter("niceConst")(input)}});app.filter("mlScoreAssess",function(){var SCORES={auc:[["...too good to be true?",1],["excellent",.9],["very good",.8],["good",.7],["fair",.6],["not very good...",.5],["worse than random guess :("]],pearson:[["...too good to be true?",1],["very good",.8],["good",.7],["fair",.5],["not very good..."]],pvalue:[["★★★",.001],["★★☆",.01],["★☆☆",.05],["☆☆☆",1]]},LOWER_BETTER=["pvalue"];function test(k){if(k.length===1||(this.lt?this.score<=k[1]:this.score>=k[1])){this.ret=k[0];return true}return false}return function(score,metric){metric=metric.toLowerCase().split("_").join("");if(!metric in SCORES){throw"Unkown metric: "+metric}var ctx={score:+score,grades:SCORES[metric],ret:null,lt:LOWER_BETTER.indexOf(metric)!==-1};return ctx.grades.some(test,ctx)?ctx.ret:""}});app.filter("mlFeature",function($filter,Fn,FeatureNameUtils){return function(input,asHtml){if(asHtml){return FeatureNameUtils.getAsHtmlString(input)}else{return FeatureNameUtils.getAsText(input)}}});app.filter("mlModelType",function(){return function(predictionType){if(!predictionType){return"-"}const predictionTypeToLabel={BINARY_CLASSIFICATION:"Two-class classification",MULTICLASS:"Multiclass classification",REGRESSION:"Regression",CLUSTERING:"Clustering",DEEP_HUB_IMAGE_CLASSIFICATION:"Image classification",DEEP_HUB_IMAGE_OBJECT_DETECTION:"Object detection",TIMESERIES_FORECAST:"Time Series Forecasting",CAUSAL_BINARY_CLASSIFICATION:"Causal classification",CAUSAL_REGRESSION:"Causal regression"};return predictionTypeToLabel[predictionType]||predictionType}});app.filter("weightMethod",function(){return function(weightMethod){if(!weightMethod){return"-"}const weightMethodToLabel={NO_WEIGHTING:"No weighting",SAMPLE_WEIGHT:"Sample weights",CLASS_WEIGHT:"Class weights",CLASS_AND_SAMPLE_WEIGHT:"Class and sample weights"};return weightMethodToLabel[weightMethod]||weightMethod}});app.service("FullModelLikeIdUtils",function($stateParams){function parseAnalysisModel(fullIdString){const analysisPattern=/^A-(\w+)-(\w+)-(\w+)-(s[0-9]+)-(pp[0-9]+(?:-part-(\w+)|-base)?)-(m[0-9]+)$/;const matchingResult=fullIdString.match(analysisPattern);if(!matchingResult){throw new Error("Invalid analysis model id: "+fullIdString)}else{const[_,projectKey,analysisId,mlTaskId,sessionId,ppsId,partitionName,modelId]=matchingResult;return{projectKey:projectKey,analysisId:analysisId,mlTaskId:mlTaskId,sessionId:sessionId,ppsId:ppsId,partitionName:partitionName,modelId:modelId,partitionedBase:ppsId.endsWith("-base")}}}function parseSavedModel(fullIdString){const savedModelPattern=/^S-(\w+)-(\w+)-(\w+)(?:-part-(\w+)-(v?\d+))?$/;const matchingResult=fullIdString.match(savedModelPattern);if(!matchingResult){throw new Error("Invalid saved model id: "+fullIdString)}else{const[_,projectKey,savedModelId,versionId,partitionName,partitionVersion]=matchingResult;return{projectKey:projectKey,savedModelId:savedModelId,versionId:versionId,partitionName:partitionName,partitionVersion:partitionVersion}}}function parseModelEvaluation(fullIdString){const modelEvaluationPattern=/^ME-(\w+)-(\w+)-(\w+)$/;const matchingResult=fullIdString.match(modelEvaluationPattern);if(!matchingResult){throw new Error("Invalid model evaluation id: "+fullIdString)}else{const[_,projectKey,id,evaluationId]=matchingResult;return{projectKey:projectKey,id:id,evaluationId:evaluationId}}}function buildAnalysisModelFmi(fmiComponents){return"A-{0}-{1}-{2}-{3}-{4}-{5}".format(fmiComponents.projectKey,fmiComponents.analysisId,fmiComponents.mlTaskId,fmiComponents.sessionId,fmiComponents.ppsId,fmiComponents.modelId)}function buildSavedModelFmi(fmiComponents){let fmi;const idComponents=fmiComponents.savedModelId.split(".");if(idComponents.length>2){throw new Error("Invalid savedModelID")}else if(idComponents.length==2){fmi="S-{0}-{1}-{2}".format(idComponents[0],idComponents[1],fmiComponents.versionId)}else{fmi="S-{0}-{1}-{2}".format(fmiComponents.projectKey,fmiComponents.savedModelId,fmiComponents.versionId)}if(fmiComponents.partitionName){fmi+="-part-{0}-{1}".format(fmiComponents.partitionName,fmiComponents.partitionVersion)}return fmi}function buildModelEvaluationFmeFromComponents(projectKey,id,evaluationId){const idComponents=id.split(".");if(idComponents.length>2){throw new Error("Invalid FME ID")}else if(idComponents.length==2){return"ME-{0}-{1}-{2}".format(idComponents[0],idComponents[1],evaluationId)}else{return"ME-{0}-{1}-{2}".format(projectKey,id,evaluationId)}}function buildModelEvaluationFme(fmeComponents){return buildModelEvaluationFmeFromComponents(fmeComponents.projectKey,fmeComponents.id,fmeComponents.evaluationId)}function isAnalysis(fullId){return fullId.startsWith("A")}function isSavedModel(fullId){return fullId.startsWith("S")}function isModelEvaluation(fullId){return fullId.startsWith("ME")}function parse(fullIdString){if(isAnalysis(fullIdString)){return parseAnalysisModel(fullIdString)}else if(isSavedModel(fullIdString)){return parseSavedModel(fullIdString)}else if(isModelEvaluation(fullIdString)){return parseModelEvaluation(fullIdString)}else{throw new Error("Invalid id: "+fullIdString)}}function parseWithEnforcedProjectKey(fmi,projectKey){const elements=parse(fmi);elements.projectKey=projectKey;return{elements:elements,fullModelId:buildAnalysisModelFmi(elements)}}function getFmi(scope){let fmi=$stateParams.fullModelId;if(scope.evaluation){fmi=scope.evaluation.evaluation.fullId||fmi}return fmi||scope.fullModelId}return{parse:parse,getBase:function(fullModelId){if(isAnalysis(fullModelId)){const fmiComponents=parseAnalysisModel(fullModelId);fmiComponents.ppsId=fmiComponents.ppsId.replace(/-part-(\w+)/,"-base");return buildAnalysisModelFmi(fmiComponents)}else if(isSavedModel(fullModelId)){const fmiComponents=parseSavedModel(fullModelId);delete fmiComponents.partitionName;return buildSavedModelFmi(fmiComponents)}else{throw new Error("Invalid model id: "+fullModelId)}},buildAnalysisModelFmi:buildAnalysisModelFmi,buildSavedModelFmi:buildSavedModelFmi,buildModelEvaluationFme:buildModelEvaluationFme,buildModelEvaluationFmeFromComponents:buildModelEvaluationFmeFromComponents,parseWithEnforcedProjectKey:parseWithEnforcedProjectKey,isAnalysisPartitionBaseModel:function(fullModelId){if(isAnalysis(fullModelId)){const parts=parse(fullModelId);return parts.partitionedBase}return false},isPartition:function(fullModelId){const parts=parse(fullModelId);return!angular.isUndefined(parts.partitionName)},getFmi:getFmi,isAnalysis:isAnalysis,isSavedModel:isSavedModel,isModelEvaluation:isModelEvaluation}});app.service("ModelDataUtils",function(FullModelLikeIdUtils){function areMetricsWeighted(modelData){return modelData&&modelData.coreParams&&!!modelData.coreParams.weight&&(modelData.coreParams.weight.weightMethod==="SAMPLE_WEIGHT"||modelData.coreParams.weight.weightMethod==="CLASS_AND_SAMPLE_WEIGHT")}function getAlgorithm(modelData){if(modelData&&modelData.actualParams&&modelData.actualParams.resolved&&modelData.actualParams.resolved.algorithm){return modelData.actualParams.resolved.algorithm}else if(modelData&&modelData.modeling&&modelData.modeling.algorithm){return modelData.modeling.algorithm}}function hasCalibration(modelData){return modelData&&modelData.coreParams&&modelData.coreParams.calibration&&modelData.coreParams.calibration.calibrationMethod!=="NO_CALIBRATION"}function isPartitionedBaseModel(modelData){return modelData&&modelData.coreParams&&modelData.coreParams.partitionedModel&&modelData.coreParams.partitionedModel.enabled&&!FullModelLikeIdUtils.isPartition(modelData.fullModelId)}function isBinaryClassification(modelData){return modelData&&modelData.coreParams&&modelData.coreParams.prediction_type==="BINARY_CLASSIFICATION"}function isMulticlass(modelData){return modelData&&modelData.coreParams&&["MULTICLASS","DEEP_HUB_IMAGE_CLASSIFICATION"].includes(modelData.coreParams.prediction_type)}function isClassification(modelData){return isBinaryClassification(modelData)||isMulticlass(modelData)}function isRegression(modelData){return modelData&&modelData.coreParams&&modelData.coreParams.prediction_type==="REGRESSION"}function countOverrides(modelData){if(!modelData||!modelData.overridesParams||!modelData.overridesParams.overrides){return 0}return modelData.overridesParams.overrides.length}function getUncertaintySettings(modelData){return modelData&&modelData.coreParams&&modelData.coreParams.uncertainty}function hasOverrides(modelData){return countOverrides(modelData)>0}function isEnsemble(modelData){const algorithm=getAlgorithm(modelData);return algorithm&&algorithm.endsWith("_ENSEMBLE")}function hasProbas(modelData){const isProbaAware=modelData&&modelData.iperf&&modelData.iperf.probaAware;const isDeephubImageClassif=modelData&&modelData.modeling&&modelData.modeling.type&&modelData.modeling.type==="DEEP_HUB_IMAGE_CLASSIFICATION";return!!(isProbaAware||isDeephubImageClassif)}function createThresholdUpdateChecker(){const ret={_oldThreshold:null,executeIfUpdated:undefined};ret.executeIfUpdated=(modelData,callback)=>{const threshold=modelData.userMeta.activeClassifierThreshold;if(threshold!==ret._oldThreshold){ret._oldThreshold=threshold;callback()}};return ret}function getPredictionType(modelData){if(modelData&&modelData.coreParams&&modelData.coreParams.prediction_type){return modelData.coreParams.prediction_type}}function isPartitionedModel(modelData){return modelData&&modelData.coreParams&&modelData.coreParams.partitionedModel&&modelData.coreParams.partitionedModel.enabled}function getTargetVariable(modelData){if(modelData&&modelData.coreParams&&modelData.coreParams.target_variable){return modelData.coreParams.target_variable}}function isFromModelEvaluation(modelData){return modelData&&modelData.modelEvaluation}function computeCmgForGivenPerf(modelData,perf){if(!perf||!perf.perCutData)return;return perf.perCutData.cut.map((_,i)=>{const fn=perf.perCutData.fn[i];const tn=perf.perCutData.tn[i];const fp=perf.perCutData.fp[i];const tp=perf.perCutData.tp[i];const weights=modelData.headTaskCMW;return(weights.fnGain*fn+weights.tnGain*tn+weights.fpGain*fp+weights.tpGain*tp)/(fn+tn+fp+tp)})}return{areMetricsWeighted:areMetricsWeighted,getAlgorithm:getAlgorithm,hasCalibration:hasCalibration,isPartitionedBaseModel:isPartitionedBaseModel,isEnsemble:isEnsemble,hasProbas:hasProbas,isBinaryClassification:isBinaryClassification,isMulticlass:isMulticlass,isClassification:isClassification,isRegression:isRegression,hasOverrides:hasOverrides,countOverrides:countOverrides,getUncertaintySettings:getUncertaintySettings,createThresholdUpdateChecker:createThresholdUpdateChecker,getPredictionType:getPredictionType,isPartitionedModel:isPartitionedModel,getTargetVariable:getTargetVariable,isFromModelEvaluation:isFromModelEvaluation,computeCmgForGivenPerf:computeCmgForGivenPerf}});app.service("MLTaskDesignUtils",function(){function isBinaryClassification(mltaskDesign){return mltaskDesign&&mltaskDesign.predictionType==="BINARY_CLASSIFICATION"}function isMulticlass(mltaskDesign){return mltaskDesign&&["MULTICLASS","DEEP_HUB_IMAGE_CLASSIFICATION"].includes(mltaskDesign.predictionType)}function isClassification(mltaskDesign){return isBinaryClassification(mltaskDesign)||isMulticlass(mltaskDesign)}function getUncertaintySettings(mltaskDesign){return mltaskDesign&&mltaskDesign.uncertainty}return{isBinaryClassification:isBinaryClassification,isMulticlass:isMulticlass,isClassification:isClassification,getUncertaintySettings:getUncertaintySettings}});app.controller("_ModelUtilsController",function($scope,$q,ModelDataUtils,DataikuCloudService){$scope.getPredictionType=()=>ModelDataUtils.getPredictionType($scope.modelData);$scope.isPartitionedModel=()=>ModelDataUtils.isPartitionedModel($scope.modelData);$scope.getTargetVariable=()=>ModelDataUtils.getTargetVariable($scope.modelData);$scope.getAlgorithm=()=>ModelDataUtils.getAlgorithm($scope.modelData);$scope.getTreatmentVariable=function(){return $scope.modelData&&$scope.modelData.coreParams&&$scope.modelData.coreParams.treatment_variable};$scope.fetchCloudInfo=()=>{if($scope.cloudInfo)return $q.when(null);else{return DataikuCloudService.getCloudInfo().then(cloudInfo=>{$scope.cloudInfo=cloudInfo})}};$scope.isNotStaticModelSkin=skin=>!$scope.staticModelSkins.some(modelSkin=>skin.id===modelSkin.id)});app.controller("_ModelReportControllerBase",function($scope,$rootScope,$controller,PluginsService){$controller("_ModelUtilsController",{$scope:$scope});$scope.hooks={};$scope.staticModelSkins=[];$scope.fetchCloudInfo().then(()=>{$scope.addModelViewsLabel="Add views";$scope.pluginStoreLink=PluginsService.getPluginStoreLink($scope.cloudInfo);if($scope.cloudInfo.isDataikuCloud){$scope.addModelViewTooltipText=($scope.cloudInfo.isSpaceAdmin?"You can install plugins on the Launchpad":"Ask your administrator to install plugins")+" to have more model views";if(!$scope.cloudInfo.isSpaceAdmin){$scope.addModelViewsLabel="See views"}}else{$scope.addModelViewTooltipText=`You can ${$rootScope.appConfig.admin?"install":"request"} plugins from the store to have more model views`}})});app.controller("MLReportPreparationController",function($scope,Assert,ShakerProcessorsUtils){Assert.inScope($scope,"modelData");var tmpFindGroupIndex=Array.prototype.indexOf.bind($scope.modelData.trainedWithScript.steps.filter(function(s){return s.metaType==="GROUP"}));$scope.findGroupIndex=function(step){const groupIndex=tmpFindGroupIndex(step);return groupIndex<0?"":groupIndex+1};$scope.getGroupName=function(step){if(step.metaType=="GROUP"){return step.name&&step.name.length>0?step.name:"GROUP "+$scope.findGroupIndex(step)}else{return"Invalid group"}};var stepsWithSubSteps=[];$scope.modelData.trainedWithScript.steps.forEach(function(step,index){step["mainStep"]=true;stepsWithSubSteps.push(step);if(step.metaType==="GROUP"){step.steps.forEach(function(subStep,index){subStep["mainStep"]=false;stepsWithSubSteps.push(subStep)})}});$scope.steps=stepsWithSubSteps;$scope.getStepDescription=ShakerProcessorsUtils.getStepDescription;$scope.getStepIcon=ShakerProcessorsUtils.getStepIcon;$scope.puppeteerHook_elementContentLoaded=true});app.controller("_MLReportSummaryController",function($scope){$scope.editState={editing:false};$scope.userMeta=function(){if($scope.evaluationDetails){return $scope.evaluationDetails.evaluation.userMeta}else{return $scope.modelData.userMeta}};$scope.startEdit=function(){$scope.editState.editing=true;$scope.editState.name=$scope.userMeta().name;$scope.editState.description=$scope.userMeta().description};$scope.cancelEdit=function(){$scope.editState.editing=false};$scope.validateEdit=function(){$scope.userMeta().name=$scope.editState.name;$scope.userMeta().description=$scope.editState.description;$scope.editState.editing=false}});app.controller("_ModelViewsController",function($scope,$rootScope,$state,$stateParams,$controller,DataikuAPI,PluginsService){$scope.uiState={};$scope.appConfig=$rootScope.appConfig;$scope.$state=$state;$scope.webAppConfig={};$scope.webAppType=null;$scope.runningWebAppId=null;$scope.getBackendLogURL=function(projectKey,webAppId){return DataikuAPI.webapps.getBackendLogURL(projectKey,webAppId)};if($stateParams.analysisId){$controller("TrainedModelSkinsController",{$scope:$scope})}else{$controller("SavedModelVersionSkinsController",{$scope:$scope})}if($scope.modelViewsSkin){$scope.uiState.skin=$scope.modelViewsSkin}$scope.fetchCloudInfo().then(()=>{$scope.canAddModelView=!$scope.cloudInfo.isDataikuCloud||$scope.cloudInfo.isSpaceAdmin;$scope.pluginUrl=PluginsService.getPluginStoreLink($scope.cloudInfo,($scope.uiState.skin||{}).ownerPluginId)})});app.controller("EvaluationLabelUtils",function($scope){const DATASET_RE=/^[^:]*dataset:/i;const MODEL_RE=/^[^:]*model:/i;const EVALUATION_RE=/^[^:]*evaluation:/i;const DOMAIN_MAPPING=[{re:DATASET_RE,icon:"icon-dataset universe-color dataset"},{re:MODEL_RE,icon:"icon-machine_learning_regression universe-color saved_model"},{re:EVALUATION_RE,icon:"icon-model-evaluation-store universe-color saved_model"}];$scope.setIcon=function(label){if(label.key){for(const mapping of DOMAIN_MAPPING){if(mapping.re.test(label.key)){return mapping.icon}}}return"icon-dku-edit"}});app.controller("MLBaseRouteReportController",function($scope){$scope.uiState=$scope.uiState||{};$scope.setSettingsPane=(pane,skinId)=>{$scope.uiState.settingsPane=skinId?pane+"-"+skinId:pane;$scope.uiState.skinId=skinId}});app.controller("_PMLReportSummaryController",function($scope,$controller,DataikuAPI,PMLFilteringService,PerformanceMetricsDataComposer,MetricsUtils,$stateParams,ActiveProjectKey,$filter,FullModelLikeIdUtils,ATSurveyService,$interval){$controller("_MLReportSummaryController",{$scope:$scope});$controller("EvaluationLabelUtils",{$scope:$scope});const fullModelId=$stateParams.fullModelId||$scope.fullModelId;const predictionType=$scope.modelData.coreParams.prediction_type;var metricsInfo;switch(predictionType){case"BINARY_CLASSIFICATION":metricsInfo=[...PerformanceMetricsDataComposer.getThresholdIndependentBinaryClassifMetricsData($scope.modelData).rows,...PerformanceMetricsDataComposer.getThresholdDependentBinaryClassifMetricsData($scope.modelData).rows];break;case"MULTICLASS":metricsInfo=PerformanceMetricsDataComposer.getMulticlassMetricsData($scope.modelData).rows;break;case"REGRESSION":metricsInfo=PerformanceMetricsDataComposer.getRegressionMetricsData($scope.modelData).rows;break;case"TIMESERIES_FORECAST":metricsInfo=PerformanceMetricsDataComposer.getTimeSeriesMetricsModelEvaluationData($scope.modelData).rows;countTsATF();break;default:metricsInfo=null;break}$scope.refreshCurrentMetricNames=function(){if($scope.uiState.currentMetrics){$scope.uiState.currentFormattedNames=$scope.uiState.currentMetrics.filter(m=>m).map(cur=>{return{key:PMLFilteringService.metricMap[cur],label:$scope.possibleMetrics.find(x=>x[0]===cur)[1],code:cur,short_description:metricsInfo?.find(x=>x["name"]===cur)?.info,isEvaluationMetric:$scope.modelData.modeling.metrics.evaluationMetric===cur?true:false,isThresholdOptimizationMetric:$scope.modelData.modeling.metrics.thresholdOptimizationMetric===cur?true:false}})}else{$scope.uiState.currentFormattedNames=[]}$scope.refreshMetricsValues()};$scope.refreshMetricsValues=function(){let metrics=$scope.evaluationDetails&&$scope.evaluationDetails.metrics?$scope.evaluationDetails.metrics:null;$scope.uiState.$formattedMetrics={};if(!metrics||!Object.keys(metrics).length){$scope.uiState.noperf=true;return}$scope.uiState.noperf=false;for(let metricCode of $scope.uiState.currentMetrics){$scope.uiState.$formattedMetrics[metricCode]=MetricsUtils.getMetricValue(metrics,metricCode,3)}};$scope.getMetricValueFromModel=PMLFilteringService.getMetricValueFromModel.bind(PMLFilteringService);if($scope.versionsContext){$scope.$watch("versionsContext.activeMetric",function(){$scope.activeMetric=$scope.versionsContext.activeMetric});$scope.activeMetric=$scope.versionsContext.activeMetric}else if($scope.mlTasksContext){$scope.$watch("mlTasksContext.activeMetric",function(){$scope.activeMetric=$scope.mlTasksContext.activeMetric});$scope.activeMetric=$scope.mlTasksContext.activeMetric}function countTsATF(){var intervalPromise=$interval(()=>{ATSurveyService.updateCounter("TimeseriesAnalysisUsage")},1e3,60);$scope.$on("$destroy",function(){if(angular.isDefined(intervalPromise)){$interval.cancel(intervalPromise)}})}});app.controller("PMLReportSummaryController",function($scope,$controller,SmartId,StateUtils,Debounce,TimeseriesForecastingUtils,PMLSettings,Assert,$stateParams,$state,PMLFilteringService,MetricsUtils,worstPrefixName){$controller("_PMLReportSummaryController",{$scope:$scope});$scope.FilteringService=PMLFilteringService;$scope.SmartId=SmartId;$scope.StateUtils=StateUtils;$scope.prettyTimeSteps=TimeseriesForecastingUtils.prettyTimeSteps;$scope.$watch("modelData",()=>{if($scope.evaluationDetails&&$scope.evaluationDetails.evaluation){$scope.refreshMetrics($scope.evaluationDetails.evaluation.predictionType)}else if($scope.modelData){$scope.refreshMetrics($scope.modelData.coreParams.prediction_type)}$scope.puppeteerHook_elementContentLoaded=true});$scope.$watch("currentPartitionedModel",()=>{if($scope.currentPartitionedModel){$scope.possibleCustomMetrics=$scope.FilteringService.getPossibleCustomMetrics([$scope.currentPartitionedModel]);if($scope.uiState.display){$scope.uiState.display.customMetrics=$scope.possibleCustomMetrics.map(item=>{item.displayed=false;item.getMetricFromPerf=function(perf){const foundValues=perf.singleMetrics.customMetricsResults.filter(result=>result.metric.name===item.name);if(foundValues){return foundValues[0].value}else{return null}};return item})}}});$scope.refreshMetrics=function(predictionType){$scope.possibleMetrics=MetricsUtils.getDefaultMesMetrics(predictionType,$scope.evaluationDetails)||[];if($scope.uiState.currentMetric&&$scope.possibleMetrics.filter(_=>_[0]==$scope.uiState.currentMetric).length==0){$scope.uiState.currentMetric=null}if($scope.uiState.currentMetric==null){if("BINARY_CLASSIFICATION"===predictionType){$scope.uiState.currentMetric="ROC_AUC"}if("MULTICLASS"===predictionType){$scope.uiState.currentMetric="ROC_AUC"}if("REGRESSION"===predictionType){$scope.uiState.currentMetric="R2"}if("TIMESERIES_FORECAST"===predictionType){$scope.uiState.currentMetric="MASE"}}$scope.uiState.currentMetrics=$scope.possibleMetrics.map(pm=>pm[0]).filter(x=>x);if($scope.modelData&&$scope.modelData.modelEvaluation){if(!$scope.modelData.modelEvaluation.hasModel){$scope.uiState.currentMetrics=$scope.uiState.currentMetrics.filter(PMLFilteringService.isDataDriftMetric)}else if($scope.modelData.modelEvaluation.evaluateRecipeParams&&$scope.modelData.modelEvaluation.evaluateRecipeParams.dontComputePerformance){$scope.uiState.currentMetrics=$scope.uiState.currentMetrics.filter(PMLFilteringService.isDriftMetric)}}$scope.refreshCurrentMetricNames()};$scope.getSimpleCustomMetricsResults=function(){const customMetricsResults=[];if($scope.evaluationDetails&&$scope.evaluationDetails.metrics&&$scope.evaluationDetails.metrics.customMetricsResults){$scope.evaluationDetails.metrics.customMetricsResults.forEach(item=>{customMetricsResults.push({name:item.metric.name,value:item.value,description:item.metric.description,displayName:item.metric.name,code:item.metric.metricCode,isEvaluationMetric:$scope.modelData.modeling.metrics.customEvaluationMetricName===item.metric.name?true:false});if(item.worstValue){customMetricsResults.push({name:worstPrefixName+item.metric.name,value:item.worstValue,description:`Worst value of ${item.metric.name} across all time series.`,displayName:worstPrefixName+item.metric.name,code:item.metric.metricCode,isEvaluationMetric:false})}})}return customMetricsResults};$scope.getGoToExperimentRun=function(){Assert.trueish($scope.modelData,"no model data");Assert.trueish($scope.modelData.mlflowOrigin,"no MLflow origin");Assert.trueish($scope.modelData.mlflowOrigin.type==="EXPERIMENT_TRACKING_RUN","MLflow origin not from experiment/run");Assert.trueish($scope.modelData.mlflowOrigin.runId,"MLflow origin malformed (no runId)");const origin=$scope.modelData.mlflowOrigin;const params={projectKey:$stateParams.projectKey,runId:origin.runId};return $state.href("projects.project.experiment-tracking.run-details",params)};$scope.getGoToExperimentRunArtifact=function(){Assert.trueish($scope.modelData,"no model data");Assert.trueish($scope.modelData.mlflowOrigin,"no MLflow origin");Assert.trueish($scope.modelData.mlflowOrigin.type==="EXPERIMENT_TRACKING_RUN","MLflow origin not from experiment/run");Assert.trueish($scope.modelData.mlflowOrigin.runId,"MLflow origin malformed (no runId)");Assert.trueish($scope.modelData.mlflowOrigin.modelSubfolder,"MLflow origin malformed (no modelSubfolder)");const origin=$scope.modelData.mlflowOrigin;const params={projectKey:$stateParams.projectKey,runId:origin.runId,subfolder:origin.modelSubfolder};return $state.href("projects.project.experiment-tracking.run-artifacts",params)};$scope.getGoToExperiment=function(){Assert.trueish($scope.modelData,"no model data");Assert.trueish($scope.modelData.mlflowOrigin,"no MLflow origin");Assert.trueish($scope.modelData.mlflowOrigin.type==="EXPERIMENT_TRACKING_RUN","MLflow origin not from experiment/run");Assert.trueish($scope.modelData.mlflowOrigin.experimentId,"MLflow origin malformed (no experimentId)");const origin=$scope.modelData.mlflowOrigin;const params={projectKey:$stateParams.projectKey,experimentIds:origin.experimentId};return $state.href("projects.project.experiment-tracking.runs-list",params)}});app.component("displayJsonModal",{bindings:{modalControl:"<",title:"<",json:"<"},template:`
    <div>
        <div dku-modal-header-with-totem modal-title="{{$ctrl.title}}"/>
        <form name="displayJson" class="dkuform-modal-horizontal dkuform-modal-wrapper">
            <div class="modal-body">
                <pre>{{$ctrl.json|prettyjson}}</pre>
            </div>
            <div class="modal-footer">
            <button type="button" class="btn btn--secondary" ng-click="$ctrl.copyToClipboard()">Copy</button>
            <button type="button" class="btn btn--primary" ng-click="$ctrl.modalControl.dismiss()">Close</button>
            </div>
        </form>
    </div>`,controller:function(ClipboardUtils){const $ctrl=this;$ctrl.copyToClipboard=function(){ClipboardUtils.copyToClipboard(JSON.stringify($ctrl.json,null,4));$ctrl.modalControl.dismiss()}}});app.component("displayTextModal",{bindings:{modalControl:"<",title:"<",text:"<"},template:`
    <div>
        <div dku-modal-header-with-totem modal-title="{{$ctrl.title}}"/>
        <form name="displayText" class="dkuform-modal-horizontal dkuform-modal-wrapper">
            <div class="modal-body">
                <pre>{{$ctrl.text}}</pre>
            </div>
            <div class="modal-footer">
            <button type="button" class="btn btn--secondary" ng-click="$ctrl.copyToClipboard()">Copy</button>
            <button type="button" class="btn btn--primary" ng-click="$ctrl.modalControl.dismiss()">Close</button>
            </div>
        </form>
    </div>`,controller:function(ClipboardUtils){const $ctrl=this;$ctrl.copyToClipboard=function(){ClipboardUtils.copyToClipboard($ctrl.text);$ctrl.modalControl.dismiss()}}});app.component("showEllipsedTextAndCopy",{bindings:{text:"<",tooltip:"<?",maxWidthPx:"<?"},template:`
    <div show-tooltip-on-text-overflow
        text-tooltip="$ctrl.tooltip?$ctrl.tooltip:$ctrl.text" style="display:inline-block; max-width: {{$ctrl.maxWidthPx?$ctrl.maxWidthPx:330}}px;">
    </div>
    <a ng-click="$ctrl.copyToClipboard()"><i class="dku-icon-copy-16"/></a>`,controller:function(ClipboardUtils){const $ctrl=this;$ctrl.copyToClipboard=function(){ClipboardUtils.copyToClipboard($ctrl.text)}}});app.component("externalEndpointInfo",{bindings:{fullModelId:"<",proxyModelConfiguration:"<",proxyModelEndpointInfo:"<"},templateUrl:"/templates/ml/prediction-model/external_endpoint_info.html",controller:function(CreateModalFromComponent,displayJsonModalDirective,ClipboardUtils,FullModelLikeIdUtils,RemoteResourcesLinksUtils){const $ctrl=this;$ctrl.uiState={parsedFMI:null};$ctrl.showOpenAPIJson=function(){CreateModalFromComponent(displayJsonModalDirective,{title:"OpenAPI definition retrieved at version creation",json:JSON.parse($ctrl.proxyModelEndpointInfo.openAPI)},["modal-wide"])};$ctrl.showInputParameters=function(){CreateModalFromComponent(displayJsonModalDirective,{title:"Input parameters",json:$ctrl.proxyModelEndpointInfo.input},["modal-wide"])};$ctrl.$onChanges=function(){if($ctrl.proxyModelConfiguration&&$ctrl.proxyModelConfiguration.protocol==="vertex-ai"){$ctrl.deploymentCount=$ctrl.proxyModelEndpointInfo.models.length}else if($ctrl.proxyModelConfiguration&&$ctrl.proxyModelConfiguration.protocol==="azure-ml"&&$ctrl.proxyModelEndpointInfo&&$ctrl.proxyModelEndpointInfo.modelByDeployment){$ctrl.deploymentCount=Object.keys($ctrl.proxyModelEndpointInfo.modelByDeployment).length}else{$ctrl.deploymentCount=0}if($ctrl.fullModelId){$ctrl.uiState.parsedFMI=FullModelLikeIdUtils.parse($ctrl.fullModelId)}else{$ctrl.uiState.parsedFMI=null}};$ctrl.copyInputToClipboard=function(){ClipboardUtils.copyToClipboard(JSON.stringify($ctrl.proxyModelEndpointInfo.input,undefined,4))};$ctrl.extractVertexAIEndpointId=function(fullEndpointName){return fullEndpointName.split("/").pop()};$ctrl.tryGetResourceLink=function(){try{return $ctrl.getResourceLink()}catch(e){return null}};$ctrl.getResourceLink=function(){if($ctrl.proxyModelConfiguration&&$ctrl.proxyModelConfiguration.protocol==="sagemaker"){return RemoteResourcesLinksUtils.getSageMakerResourceLink("endpoints",$ctrl.proxyModelConfiguration.region,$ctrl.proxyModelEndpointInfo.endpointName)}if($ctrl.proxyModelConfiguration&&$ctrl.proxyModelConfiguration.protocol==="vertex-ai"){return RemoteResourcesLinksUtils.getVertexAIResourceLink("endpoints",$ctrl.proxyModelConfiguration.project_id,$ctrl.proxyModelConfiguration.region,$ctrl.extractVertexAIEndpointId($ctrl.proxyModelEndpointInfo.name))}if($ctrl.proxyModelConfiguration&&$ctrl.proxyModelConfiguration.protocol==="azure-ml"){const endpointInfo={azWorkspace:$ctrl.proxyModelEndpointInfo.endpointInfo.workspace,azResourceGroup:$ctrl.proxyModelEndpointInfo.endpointInfo.resourceGroup,azSubscription:$ctrl.proxyModelEndpointInfo.endpointInfo.subscription,azTenantId:$ctrl.proxyModelEndpointInfo.retrievedByTenantId,azOnlineEndpointName:$ctrl.proxyModelEndpointInfo.endpointInfo.name};return RemoteResourcesLinksUtils.getAzureMLOnlineEndpointLink(endpointInfo)}return null}}});app.controller("PartPMLReportSummaryController",function($scope,$controller,$stateParams,DataikuAPI){$controller("PMLReportSummaryController",{$scope:$scope});$controller("_SubpopTableUtilsController",{$scope:$scope});$scope.dimensionsList=function(){return $scope.modelData.coreParams.partitionedModel.dimensionNames.map(dim=>`<b>${sanitize(dim)}</b>`).join(" and ")};$scope.getCurrentFeatureData=()=>{return $scope.partitionsPerf};const mergeSnippetsWithModalities=(data,snippets)=>{data.modalities.forEach(modality=>{let snippet;if(modality.value&&modality.value in snippets.partitions.summaries){snippet=snippets.partitions.summaries[modality.value].snippet;snippet["status"]=snippets.partitions.summaries[modality.value].state;modality.snippet=snippet}});data.allDatasetModality.snippet=snippets};const getThreshold=snippets=>mod=>{if(mod.value&&mod.value in snippets.partitions.summaries){const partSnippet=snippets.partitions.summaries[mod.value].snippet;if(partSnippet&&partSnippet.userMeta){return partSnippet.userMeta.activeClassifierThreshold}}return snippets.baseModel};const preparePartitionsPerf=partSnippets=>{DataikuAPI.ml.prediction.getPartitionsPerf(partSnippets.fullModelId).then(resp=>{$scope.formatTableResults(resp.data,resp.data.allDatasetPerf,getThreshold(partSnippets));mergeSnippetsWithModalities(resp.data,partSnippets);$scope.partitionsPerf=resp.data},setErrorInScope.bind($scope))};$scope.$watch("partitionedModelSnippets",function(partSnippets){if(!partSnippets){return}preparePartitionsPerf(partSnippets)})});app.controller("PMLReportDriftController",function($scope,$controller,$stateParams,DataikuAPI,ActiveProjectKey,FutureProgressModal,ModelEvaluationUtils){$scope.fullModelId=$stateParams.fullModelId||$scope.fullModelId;if($stateParams.mesId){$scope.mesId=$stateParams.mesId;$scope.evaluationId=$stateParams.evaluationId}$scope.uiState=$scope.uiState||{driftState:{selectedReference:null},driftParams:angular.copy(ModelEvaluationUtils.defaultDriftParams),refProbabilityDensities:null,pdd:null,currentClass:null,refPredValueCount:null,curPredValueCount:null,pdfs:null};$scope.wt1Properties=ModelEvaluationUtils.wt1Properties;$scope.colors=window.dkuColorPalettes.discrete[0].colors.filter((_,idx)=>idx%2===0);$scope.isPvalueRejected=function(pvalue){const confidenceLevel=$scope.uiState.driftState.driftParamsOfResult&&$scope.uiState.driftState.driftParamsOfResult.confidenceLevel;if(confidenceLevel==null){return false}const significanceLevel=1-confidenceLevel;if(pvalue!=null){return pvalue<=significanceLevel}return false};$scope.hasNewValues=function(newValuesPercentage){return newValuesPercentage&&newValuesPercentage!==0};$scope.isPSIAboveThreshold=function(psi){const threshold=$scope.uiState.driftState.driftParamsOfResult&&$scope.uiState.driftState.driftParamsOfResult.psiThreshold;if(threshold!=null&&psi!=null){return psi>threshold}return false};$scope.showUnivariateMetric=function(metric){if(metric==="KS"){return $scope.displayParams.predictionType==="REGRESSION"}if(metric==="Chi-square"){return["BINARY_CLASSIFICATION","MULTICLASS"].includes($scope.displayParams.predictionType)}};$scope.isDriftDetected=function(){return $scope.uiState.driftState.driftResult&&$scope.uiState.driftState.driftResult.driftModelResult.driftModelAccuracy.pvalue<=1-$scope.uiState.driftParams.confidenceLevel};DataikuAPI.modelevaluationstores.listWithAccessible(ActiveProjectKey.get()).success(function(data){$scope.storeList=data}).error(setErrorInScope.bind($scope));DataikuAPI.savedmodels.listWithAccessible($stateParams.projectKey).success(function(data){$scope.modelList=data}).error(setErrorInScope.bind($scope));if(!$scope.readOnly){DataikuAPI.analysis.listHeads($stateParams.projectKey,true).success(function(data){$scope.analysesWithHeads=data}).error(setErrorInScope.bind($scope))}$scope.getColumnParams=function(columnName){const params=$scope.uiState.driftParams.columns[columnName];return params?params:{handling:"AUTO",enabled:true}};$scope.changeColumnEnabled=function(columnName,enabled){const previousColumnParams=$scope.getColumnParams(columnName);const newColumnParams={...previousColumnParams,enabled:enabled};$scope.changeColumnParams(columnName,newColumnParams)};$scope.changeColumnParams=function(columnName,newColumnParams){$scope.uiState.driftParams.columns[columnName]=newColumnParams;$scope.computeDriftAndGenerateTabs({from:$scope.wt1Properties.INPUT_DATA_DRIFT_TYPE,driftType:$scope.wt1Properties.CHANGE_COLUMN_PARAMS})};$scope.changeColumnHandling=function(columnName,handling){const previousColumnParams=$scope.getColumnParams(columnName);const newColumnParams={...previousColumnParams,handling:handling};$scope.changeColumnParams(columnName,newColumnParams)};$scope.driftingColumns=function(){let driftingColumns=[];for(const[columnName,columnDrift]of Object.entries($scope.uiState.driftState.driftResult.univariateDriftResult.columns)){if($scope.isPvalueRejected(columnDrift.chiSquareTestPvalue)||$scope.isPvalueRejected(columnDrift.ksTestPvalue)||$scope.isPSIAboveThreshold(columnDrift.populationStabilityIndex)){driftingColumns.push(columnName)}}return driftingColumns};$scope.sortUnivariateValue=function(sortColumn){return columnSettings=>{const univariateResult=$scope.uiState.driftState.driftResult.univariateDriftResult.columns[columnSettings.name];if(univariateResult&&univariateResult[sortColumn]!=null){return univariateResult[sortColumn]}return columnSettings[sortColumn]}};$scope.$watch("uiState.driftState.currentClass",function(nv,ov){if(!angular.equals(nv,ov)){$scope.computePddForClass(nv)}});$scope.perfDriftLabel=function(item){return item.perfDriftLabel};$scope.displayParams=null;$scope.cloneDisplayParams=function(){$scope.displayParams=angular.copy($scope.modelEvaluationStore.displayParams)};$scope.$watch("modelEvaluationStore.displayParams",$scope.cloneDisplayParams)});app.component("embeddingDriftTable",{bindings:{embeddingType:"<",modelRefId:"<",modelEvaluationCurId:"<",modelEvaluationRefId:"<",generalDriftResult:"<",embeddingDriftResult:"<",hasDrift:"<"},templateUrl:"/templates/ml/prediction-model/fragments/input_data_drift_embedding_drift_table.html",controller:function(){const $ctrl=this;$ctrl.sortEmbeddingValue=function(sortColumn,driftResultValue){return columnSettings=>{if(driftResultValue){const embeddingResult=driftResultValue.columns[columnSettings.name];if(embeddingResult&&embeddingResult[sortColumn]!=null){return embeddingResult[sortColumn]}}return columnSettings[sortColumn]}}}});app.component("imageQualityDrift",{bindings:{modelRefId:"<",modelEvaluationCurId:"<",modelEvaluationRefId:"<",generalDriftResult:"<",embeddingDriftResult:"<",hasDrift:"<",confidenceLevel:"<",colors:"<"},templateUrl:"/templates/ml/prediction-model/fragments/input_data_drift_image_quality_drift.html",controller:function(){const $ctrl=this;$ctrl.sortImageQualityMetricsValue=function(sortColumn,driftResultValue){return columnSettings=>{if(sortColumn==="name")return $ctrl.imageQualityDriftNameMap[driftResultValue[columnSettings][sortColumn]];return columnSettings[sortColumn]}};$ctrl.isPvalueRejected=function(pvalue){if($ctrl.confidenceLevel==null){return false}const significanceLevel=1-$ctrl.confidenceLevel;if(pvalue!=null){return pvalue<=significanceLevel}return false};$ctrl.driftingColumns=function(columns){let driftingColumns=[];for(const[columnName,columnDrift]of Object.entries(columns)){if($ctrl.isPvalueRejected(columnDrift.ksTestPvalue)){driftingColumns.push(columnName)}}return driftingColumns};$ctrl.imageQualityDriftNameMap={meanRed:"Mean Red (R)",meanGreen:"Mean Green (G)",meanBlue:"Mean Blue (B)",meanSaturation:"Mean Saturation",rmsContrast:"Contrast (RMS)",laplacianVar:"Sharpness (Laplacian)",tenengrad:"Sharpness (Tenengrad)",entropy:"Entropy (Complexity)",edgeDensity:"Edge Density",area:"Area",aspectRatio:"Aspect Ratio"};$ctrl.imageQualityDriftDescriptionMap={meanRed:"Measures the average intensity of the red color channel",meanGreen:"Measures the average intensity of the green color channel",meanBlue:"Measures the average intensity of the blue color channel",meanSaturation:"Measures color intensity to detect if images are washed-out or vibrant",rmsContrast:"Measures the overall contrast to see if images are becoming flat or harsh",laplacianVar:"Measures sharpness to identify blurry or out-of-focus images",tenengrad:"Measures sharpness by quantifying the strength of edges in the image",entropy:"Measures the amount of texture and detail to track overall image complexity",edgeDensity:"Measures the density of edges, which relates to object presence and focus",area:"Measures the pixel size of the image",aspectRatio:"Measures the shape of the image to detect stretching or cropping"};$ctrl.imageQualityDriftCategoryMap={Colorimetry:["meanRed","meanGreen","meanBlue","meanSaturation"],"Sharpness And Contrast":["rmsContrast","laplacianVar","tenengrad"],"Texture And Geometry":["entropy","edgeDensity","area","aspectRatio"]}}});app.component("imageDriftGraph",{bindings:{modelRefId:"<",modelEvaluationCurId:"<",modelEvaluationRefId:"<",generalDriftResult:"<",embeddingDriftResult:"<",hasDrift:"<",colors:"<"},templateUrl:"/templates/ml/prediction-model/fragments/input_data_drift_image_drift_graph.html",controller:function(){const $ctrl=this;$ctrl.$onChanges=function(changes){const currentEmbeddingDriftResultColumns=changes.embeddingDriftResult?.currentValue?.columns;if(!currentEmbeddingDriftResultColumns){return}$ctrl.pdfs={};$ctrl.imageSettingsRef={};$ctrl.imageSettingsCur={};$ctrl.resultsRef={};$ctrl.resultsCur={};$ctrl.combinedColors=[...$ctrl.colors.slice(0,2),...$ctrl.colors.slice(0,2)];for(const[columnName,columnMetrics]of Object.entries(currentEmbeddingDriftResultColumns)){if(!columnMetrics)return;setupGraphForColumn(columnMetrics,columnName);setupImageCardsForColumn(columnMetrics,columnName)}};function setupGraphForColumn(columnMetrics,columnName){const xs=[];const ys=[];const labels=[];xs.push(columnMetrics.curPredictionInfos.x);ys.push(columnMetrics.curPredictionInfos.pdf);labels.push("Current");xs.push(columnMetrics.refPredictionInfos.x);ys.push(columnMetrics.refPredictionInfos.pdf);labels.push("Reference");$ctrl.pdfs[columnName]={xs:xs,ys:ys,colors:$ctrl.colors.slice(0,2),labels:labels}}function setupImageCardsForColumn(columnMetrics,columnName){$ctrl.imageSettingsRef[columnName]={managedFolderSmartName:columnMetrics.refPredictionInfos.managedFolderSmartName};$ctrl.imageSettingsCur[columnName]={managedFolderSmartName:columnMetrics.curPredictionInfos.managedFolderSmartName};$ctrl.resultsRef[columnName]=getResultsForImageCards(columnMetrics.refPredictionInfos.top5,true);$ctrl.resultsCur[columnName]=getResultsForImageCards(columnMetrics.curPredictionInfos.top5,false);$ctrl.xMarks=[$ctrl.resultsCur[columnName]["predictions"].at(-1),$ctrl.resultsRef[columnName]["predictions"].at(-1)];$ctrl.explanations={};$ctrl.explanations["index"]=[0,1,2,3,4]}function getResultsForImageCards(predictionInfos,isAscending){predictionInfos.sort((a,b)=>{if(isAscending){return a.predictions-b.predictions}else{return b.predictions-a.predictions}});const predictionInfosArrays=predictionInfos.reduce((accumulator,currentObject)=>{for(const key in currentObject){if(!accumulator[key]){accumulator[key]=[]}accumulator[key].push(currentObject[key])}return accumulator},{});const{predictions,...observations}=predictionInfosArrays;return{observations:observations,predictions:predictions}}$ctrl.evaluatedImageColumnName="Most Drifted Evaluated Images";$ctrl.referenceImageColumnName="Most Normal Reference Images"}});app.controller("ExportModelController",function($scope,DataikuAPI,FutureProgressModal,ActivityIndicator,WT1,MLExportService,FutureWatcher,LocalStorage){$scope.mayExportModel=type=>MLExportService.mayExportModel($scope.model,type);$scope.exportParams={snowflake:{functionName:""},jar:{functionName:"com.company.project.Model",type:"jar-fat"},mlflow:{modelName:null,type:"zip",useUnityCatalog:true,useOriginalMLflowModel:false}};$scope.uiState={...$scope.uiState,fromDatabricks:{loadingModelList:false,loadingExperimentList:false},collapsedInfo:LocalStorage.get("dss.MLExportService.exportExplanation.shown")||false};$scope.resetDatabricksModel=function(){$scope.uiState.fromDatabricks.loadingModelList=false;$scope.uiState.fromDatabricks.models=null;$scope.exportParams.mlflow.modelName=null};$scope.resetDatabricksParams=function(){$scope.resetDatabricksModel();$scope.uiState.fromDatabricks.loadingExperimentList=false;$scope.uiState.fromDatabricks.experiments=null;$scope.exportParams.mlflow.experimentName=null};$scope.selectExportType=function(type){$scope.exportType=type};$scope.expandOrCollapseInfo=function(){$scope.uiState.collapsedInfo=!$scope.uiState.collapsedInfo;LocalStorage.set("dss.MLExportService.exportExplanation.shown",$scope.uiState.collapsedInfo)};$scope.export=function(){const model=$scope.model;const type=$scope.exportType;switch($scope.exportType){case"snowflake":DataikuAPI.ml.prediction.exportToSnowflakeFunction($scope.exportParams.snowflake.connectionName,model.fullModelId,$scope.exportParams.snowflake.functionName).success(function(data){FutureProgressModal.show($scope,data,"Exporting to Snowflake").then(()=>{ActivityIndicator.success("Successfully exported to Snowflake function");$scope.dismiss()})}).error(setErrorInScope.bind($scope));break;case"jar":if($scope.exportParams.jar.type=="jar-thin"||$scope.exportParams.jar.type=="jar-fat"){MLExportService.downloadFile($scope,()=>DataikuAPI.ml.prediction.createScoringModelFile($scope.exportParams.jar.type,model.fullModelId,"&fullClassName="+encodeURIComponent($scope.exportParams.jar.functionName)),exportId=>DataikuAPI.ml.prediction.getScoringModelDownloadURL($scope.exportParams.jar.type,exportId))}else{MLExportService.downloadFile($scope,()=>DataikuAPI.ml.prediction.createScoringModelFile($scope.exportParams.jar.type,model.fullModelId),exportId=>DataikuAPI.ml.prediction.getScoringModelDownloadURL($scope.exportParams.jar.type,exportId))}break;case"mlflow":MLExportService.downloadFile($scope,()=>DataikuAPI.ml.prediction.createScoringModelFile("python",model.fullModelId,`&exportMlflow=true&useOriginalMLflowModel=${$scope.exportParams.mlflow.useOriginalMLflowModel}`),exportId=>DataikuAPI.ml.prediction.getScoringModelDownloadURL("python",exportId));break;case"databricks":DataikuAPI.ml.prediction.exportToDatabricksRegistry($scope.exportParams.mlflow.connectionName,model.fullModelId,$scope.exportParams.mlflow.useUnityCatalog,$scope.exportParams.mlflow.modelName,$scope.exportParams.mlflow.experimentName).success(function(data){FutureProgressModal.show($scope,data,"Exporting to Databricks Registry").then(()=>{ActivityIndicator.success("Successfully exported "+$scope.exportParams.mlflow.modelName+" to Databricks Registry");$scope.dismiss()})}).error(setErrorInScope.bind($scope));break;case"python":MLExportService.downloadFile($scope,()=>DataikuAPI.ml.prediction.createScoringModelFile("python",model.fullModelId,"&exportMlflow=false"),exportId=>DataikuAPI.ml.prediction.getScoringModelDownloadURL("python",exportId));break;default:MLExportService.downloadFile($scope,()=>DataikuAPI.ml.prediction.createScoringModelFile(type,model.fullModelId),exportId=>DataikuAPI.ml.prediction.getScoringModelDownloadURL(type,exportId))}WT1.event("model-export",{exportType:type})};$scope.downloadJavaScoringLibrary=function(){MLExportService.downloadFile($scope,()=>DataikuAPI.ml.prediction.createScoringModelFile("jar-lib",$scope.model.fullModelId),exportId=>DataikuAPI.ml.prediction.getScoringModelDownloadURL($scope.exportParams.jar.type,exportId));WT1.event("model-export",{exportType:"jar-lib"});$scope.dismiss()};$scope.getDatabricksModels=()=>{if($scope.uiState.fromDatabricks.loadingModelList){return}$scope.uiState.fromDatabricks.models=null;DataikuAPI.externalinfras.infos.listDatabricksRegisteredModels($scope.exportParams.mlflow.connectionName,$scope.exportParams.mlflow.useUnityCatalog).success(function(resp){$scope.$applyAsync(()=>{$scope.uiState.fromDatabricks.loadingModelList=true});FutureWatcher.watchJobId(resp.jobId).success(function(resp2){$scope.uiState.fromDatabricks.models=resp2.result.sort((a,b)=>a.name.localeCompare(b.name))}).error(setErrorInScope.bind($scope)).finally(()=>{$scope.uiState.fromDatabricks.loadingModelList=false})}).error(setErrorInScope.bind($scope)).finally(()=>{$scope.uiState.fromDatabricks.loadingModelList=false})};$scope.getDatabricksExperiments=()=>{if($scope.uiState.fromDatabricks.loadingExperimentList){return}$scope.uiState.fromDatabricks.experiments=null;DataikuAPI.externalinfras.infos.listDatabricksExperiments($scope.exportParams.mlflow.connectionName).success(function(resp){$scope.$applyAsync(()=>{$scope.uiState.fromDatabricks.loadingExperimentList=true});FutureWatcher.watchJobId(resp.jobId).success(function(resp2){$scope.uiState.fromDatabricks.experiments=resp2.result.sort((a,b)=>a.name.localeCompare(b.name))}).error(setErrorInScope.bind($scope)).finally(()=>{$scope.uiState.fromDatabricks.loadingExperimentList=false})}).error(setErrorInScope.bind($scope)).finally(()=>{$scope.uiState.fromDatabricks.loadingExperimentList=false})}});app.directive("puppeteerHookLoaded",function(){return{scope:false,restrict:"A",link:function($scope,element,attributes){const selectorName=attributes.puppeteerHookLoaded;element.attr(selectorName,true);$scope[selectorName]=true}}});app.component("sampleSizeSummary",{templateUrl:"/templates/ml/prediction-model/fragments/sample_size_summary.html",bindings:{actualCurrentSampleSize:"<",actualReferenceSampleSize:"<",requestedCurrentSampleSize:"<",requestedReferenceSampleSize:"<",isReferenceAModel:"<",canHaveDifferentRequestAndActualSampleSize:"<"},controller:function($filter){const $ctrl=this;function getDisplayState(){let validDifferentSampleSize=$ctrl.canHaveDifferentRequestAndActualSampleSize&&$ctrl.actualCurrentSampleSize&&$ctrl.requestedCurrentSampleSize&&$ctrl.actualReferenceSampleSize&&$ctrl.requestedReferenceSampleSize;let validSameSampleSize=!$ctrl.canHaveDifferentRequestAndActualSampleSize&&$ctrl.actualCurrentSampleSize&&$ctrl.actualReferenceSampleSize;return{shouldDisplay:!!validSameSampleSize||!!validDifferentSampleSize,useDetailedTooltips:!!validDifferentSampleSize}}function generateTooltipText(actualSampleSize,requestedSampleSize,isAModel){let modelOrigin="";if(isAModel){modelOrigin="from the Test set "}let text=`${actualSampleSize} out of ${requestedSampleSize} `+`rows had available ground truth ${modelOrigin}and were used for the calculation.`;const percentage=actualSampleSize/requestedSampleSize*100;const formattedPercentage=$filter("nicePrecision")(percentage,1);text+=` (${formattedPercentage}% of the sample)`;return text}function updateComponentState(){const displayState=getDisplayState();$ctrl.displaySampleSizes=displayState.shouldDisplay;$ctrl.tooltipCurrentText="";$ctrl.tooltipReferenceText="";if(displayState.useDetailedTooltips){$ctrl.tooltipCurrentText=generateTooltipText($ctrl.actualCurrentSampleSize,$ctrl.requestedCurrentSampleSize,false);$ctrl.tooltipReferenceText=generateTooltipText($ctrl.actualReferenceSampleSize,$ctrl.requestedReferenceSampleSize,$ctrl.isReferenceAModel)}}$ctrl.$onInit=function(){$ctrl.isInitialized=true;updateComponentState()};$ctrl.$onChanges=function(changesObj){if($ctrl.isInitialized){updateComponentState()}}}})})();(function(){"use strict";var app=angular.module("dataiku.ml.core");app.factory("MLChartsCommon",function(){function linspace(start,end,n){if(n===1){return[start]}return Array.from(Array(n),(_,i)=>start+i*(end-start)/(n-1))}function trimTrailingZeros(s){out:for(var n=s.length,i=1,i0=-1,i1;i<n;++i){switch(s[i]){case".":i0=i1=i;break;case"0":if(i0===0)i0=i;i1=i;break;default:if(!+s[i])break out;if(i0>0)i0=0;break}}return i0>0?s.slice(0,i0)+s.slice(i1+1):s}function exponentFormat(fractionDigits){return _=>trimTrailingZeros(d3.format(`.${fractionDigits}e`)(_))}function fixedPointFormat(fractionDigits){return _=>trimTrailingZeros(d3.format(`.${fractionDigits}f`)(_))}function decimalRoundedFormat(significantDigits){return _=>trimTrailingZeros(d3.format(`.${significantDigits}r`)(_))}function makeAxisNumericFormatter(min,max,exponentThreshold,exponentFractionDigits){const absoluteMin=Math.min(Math.abs(min),Math.abs(max));const absoluteMax=Math.max(Math.abs(min),Math.abs(max));if(absoluteMin!==0&&absoluteMin<=10**-exponentThreshold||absoluteMax>=10**exponentThreshold){return exponentFormat(exponentFractionDigits)}else{const differenceOrderOfMagnitude=Math.floor(Math.log10(max-min));if(differenceOrderOfMagnitude<0){return fixedPointFormat(-differenceOrderOfMagnitude+1)}else{return fixedPointFormat(Math.max(0,-Math.floor(Math.log10(absoluteMin))))}}}return{installRedrawListener:function installRedrawListener(scope,redrawFn){$(window).on("resize",redrawFn);scope.$on("$destroy",function(){$(window).off("resize",redrawFn)});scope.$on("reflow",redrawFn);scope.$on("resize",redrawFn)},makeSvgAreaCallback:function makeSvgAreaCallback(computeAreas){return function svgAreaCallback(svg,scope){const areas=computeAreas(scope);const area=(xScale,yScale)=>d3.svg.area().x(_=>xScale(_.x)).y0(_=>yScale(_.y0)).y1(_=>yScale(_.y1));if(svg.select(".tubes").empty()){svg.append("g").attr("class","tubes").attr("transform",`translate(${scope.margin.left}, ${scope.margin.top+20})`)}const areaFn=_=>area(scope.chart.xScale(),_.yScale||scope.chart.yScale())(_.values),paths=svg.select(".tubes").selectAll("path").data(areas);paths.transition().duration(scope.chart.duration()).attr("d",areaFn);paths.enter().append("path").attr("d",areaFn).attr("fill",_=>_.color);paths.exit().remove();function setAreaOpacity(fadeDelay){let disabled=[];svg.selectAll(".nv-legend .nv-legend-symbol").each(function(_,i){disabled[i]=this.style.fillOpacity==="0"});let paths_=svg.select(".tubes").selectAll("path");if(fadeDelay){paths_=paths_.transition().duration(fadeDelay)}paths_.attr("style",(_,i)=>`opacity: ${disabled[i]?"0":".3"}`)}setAreaOpacity(0);scope.chart.dispatch.on("stateChange.tubes",function(e){setTimeout(setAreaOpacity.bind(null,0),0)})}},makeColorScale:function(svg,width,height,margins,nTicks,colorScaleArray,minValue,maxValue,isLog,label,hideLabel){let numericFormat=makeAxisNumericFormatter(minValue,maxValue,2,1);if(isLog){minValue=Math.log10(minValue);maxValue=Math.log10(maxValue)}svg=svg.append("g").attr("transform",`translate(${margins.left}, ${margins.top})`);let gradientUUID=window.crypto.getRandomValues(new Uint32Array(1))[0].toString(16);let gradient=svg.append("defs").append("linearGradient").attr("id",`gradient-${gradientUUID}`).attr("x1","0%").attr("y1","100%").attr("x2","0%").attr("y2","0%").attr("spreadMethod","pad");let pct=linspace(0,100,colorScaleArray.length).map(function(d){return Math.round(d)+"%"});let colourPct=d3.zip(pct,colorScaleArray);colourPct.forEach(function(d){gradient.append("stop").attr("offset",d[0]).attr("stop-color",d[1]).attr("stop-opacity",1)});svg.append("rect").attr("x1",0).attr("y1",0).attr("width",width).attr("height",height).style("fill",`url(#gradient-${gradientUUID})`);var scale=d3.scale.linear().domain([minValue,maxValue]).range([height,0]);let axis=d3.svg.axis().scale(scale).orient("right").ticks(nTicks).tickSize(width);if(isLog){axis.tickFormat(_=>numericFormat(10**_))}else{axis.tickFormat(numericFormat)}svg.append("g").call(axis).selectAll("line").style("fill","none").style("stroke","black");if(!hideLabel){svg.append("g").attr("transform",`translate(-5, ${.2*height})`).append("text").style("text-anchor","middle").style("font-weight","bold").attr("transform","rotate(-90)").text(isLog?`${label} (log)`:label)}svg.select(".domain").remove()},makeTooltipNumericFormatter:function(exponentThreshold,precision){return function(value){const absValue=Math.abs(value);if(absValue!==0&&absValue<=10**-exponentThreshold||absValue>=10**exponentThreshold){return exponentFormat(precision)(value)}else{return decimalRoundedFormat(precision+1)(value)}}},linspace:linspace,trimTrailingZeros:trimTrailingZeros,decimalRoundedFormat:decimalRoundedFormat,exponentFormat:exponentFormat,fixedPointFormat:fixedPointFormat,makeAxisNumericFormatter:makeAxisNumericFormatter}});function chartDirective(name,scopeDef,watch,watcher,draw,ext,destroy){app.directive(name,function($timeout,$injector,MLChartsCommon,Debounce){return angular.extend({restrict:"A",scope:scopeDef,link:function(scope,element,attrs,ctrl){var locals={scope:scope,element:element,attrs:attrs,ctrl:ctrl},locals2=angular.extend({},locals),redrawLater=Debounce().withDelay(100,100).wrap($timeout.bind(app,function(){if(scope.theData){$injector.invoke(draw,this,locals);const loadedStateField=scope.loadedStateField?scope.loadedStateField:"puppeteerHook_elementContentLoaded";console.info("Marking chart as loaded using "+loadedStateField+" scope field");scope[loadedStateField]=true;if(scope.loadedStateField){element.attr(scope.loadedStateField,true)}if(scope.$parent){scope.$parent[loadedStateField]=true}}},10));function addWatcher(w){scope.$watch(w,function(newValue,oldValue){if(!newValue){return}locals2.newValue=newValue;locals2.oldValue=oldValue;scope.theData=$injector.invoke(watcher,this,locals2);redrawLater()},true)}if($.isArray(watch)){for(var i=0;i<watch.length;i++){addWatcher(watch[i])}}else{addWatcher(watch)}MLChartsCommon.installRedrawListener(scope,redrawLater);if(typeof destroy==="function"){scope.$on("$destroy",destroy)}}},ext||{})})}chartDirective("discreteBarChart",{data:"=",colors:"=",format:"@",tooltip:"@",horizontal:"=?",loadedStateField:"=?",disableTransitions:"=?"},"data",function(scope,attrs,Fn,StringUtils){const LABELS_MIN_WIDTH=10;const LABELS_MAX_WIDTH=200;const LABELS_MARGIN=8;const isHorizontal=!!scope.horizontal;const color=attrs.color;const useKey=!Array.isArray(scope.colors);const data=(Array.isArray(scope.data)?scope.data:obj2arr(scope.data)).map((k,i)=>{return{value:k[1],label:k[0],color:color||scope.colors[useKey||typeof k==="number"?k:i]}});scope.settings=angular.extend({maxLabel:30},scope.$eval(attrs.discreteBarChart)||{});scope.maxLength=Math.min(scope.settings.maxLabel,Math.max.apply(Math,data.map(Fn(Fn.prop("label"),Fn.prop("length")))));scope.margins={};if(isHorizontal){scope.margins.top=0;scope.margins.bottom=20;const longestLabelWidth=Math.max(...data.map(d=>StringUtils.getTextWidth(d.label)));scope.margins.left=Math.max(LABELS_MIN_WIDTH,Math.min(LABELS_MAX_WIDTH,longestLabelWidth))+LABELS_MARGIN}else{scope.margins.top=10;scope.margins.bottom=30;scope.margins.left=50}return[{values:data}]},function(scope,element,attrs,ctrl,Fn){const width=element.width();const height=element.height();const isHorizontal=!!scope.horizontal;const chart=nv.models[isHorizontal?"multiBarHorizontalChart":"discreteBarChart"]().height(height).width(width).margin(scope.margins).x(Fn.prop("label")).y(Fn.prop("value")).color(Fn.prop("color")).showValues(true);const fmt=d3.format(scope.format);const svg=d3.select(element.get(0));let transitionDuration=500;if(scope.disableTransitions){console.info("Disabling chart transitions");chart.duration(0);transitionDuration=0}function formatPercentage(value){return d3.format(".2%")(value)}chart.tooltip.enabled(scope.tooltip);chart.tooltip.contentGenerator(selection=>{return`
                <div class="pad8">
                    ${sanitize(formatPercentage(selection.data.value))}
                </div>
            `});if(chart.staggerLabels){chart.staggerLabels(false)}chart.valueFormat(fmt);chart.yAxis.tickFormat(fmt);if(scope.settings.scale){chart.forceY(scope.settings.scale)}svg.datum(scope.theData).transition().duration(transitionDuration).call(chart);if("svgTitles"in attrs&&scope.maxLength>=scope.settings.maxLabel){svg.selectAll(".nv-axis.nv-"+(isHorizontal?"x":"y")+" .tick text")[0].forEach(text=>{var elt=d3.select(text),t=elt.text();if(t.length>scope.settings.maxLabel){elt.attr("data-title",sanitize(t));elt.text(t.substr(0,scope.settings.maxLabel-2)+"…")}});ctrl.update()}if(isHorizontal){svg.selectAll(".nv-bar rect").each(function(d,i){d3.select(this).style("fill",d.color)})}},{require:"?svgTitles"});chartDirective("predictionBarChart",{data:"=",colors:"=",threshold:"=?"},"data",function(scope,attrs,Fn){return scope.data.map((d,i)=>({key:d.name,values:[{x:"",y:d.value*100,color:d.color}]}))},function(scope,element,$filter,$timeout){const width=element.width();const height=element.height();const margin=200;const tickFormat=d3.format("d");const chart=nv.models["multiBarHorizontalChart"]().height(height).width(width-margin).forceY([0,1]).showLegend(false).showControls(false).showValues(true).groupSpacing(.4);const svg=d3.select(element.get(0)).attr("class","prediction-chart");svg.select(".prediction-chart__legend").remove();svg.select(".prediction-chart__threshold").remove();d3.selectAll(".nvtooltip").remove();chart.yAxis.tickFormat(tickFormat);chart.yAxis.ticks(6,"d");chart.tooltip.enabled(true);chart.multibar.stacked(true);const RECT_SIZE=16;const RECT_SPACING=24;const legend=svg.append("g").attr("class","prediction-chart__legend").attr("transform",`translate(${width-margin+20}, ${height-margin})`);legend.selectAll("rect").data(scope.theData).enter().append("rect").attr("width",RECT_SIZE).attr("height",RECT_SIZE).attr("y",(d,i)=>{return i*RECT_SPACING}).style("fill",function(d){return d.values[0].color});const legendText=legend.selectAll("text").data(scope.theData).enter().append("text").attr("class","prediction-chart__legend-label").attr("dx",RECT_SPACING).attr("dy",(d,i)=>{return i*RECT_SPACING+RECT_SPACING/2});legendText.append("tspan").attr("style","font-weight: 500;").text(function(d){return $filter("gentleTruncate")(d.key,30)+" - "});legendText.append("tspan").text(function(d){return formatPercentage(d.values[0].y)});legendText.append("title").text(function(d){return d.key});chart.tooltip.contentGenerator(selection=>{return`
                <div class="prediction-chart__tooltip">
                    ${sanitize(selection.data.key)} - ${sanitize(formatPercentage(selection.data.y))}
                </div>
            `});svg.datum(scope.theData).transition().duration(500).call(chart);if(typeof scope.threshold!=="undefined"){$timeout(()=>{const barHeight=d3.select(".nv-bar rect").node().getBoundingClientRect().height;const THRESHOLD_MARGIN=20;const thresholdPercentage=scope.threshold*100;svg.append("rect").attr("class","prediction-chart__threshold").attr("x",chart.margin().left+chart.yAxis.scale()(thresholdPercentage)).attr("y",chart.margin().top+chart.xAxis.scale()("")-THRESHOLD_MARGIN/2).attr("width",1).attr("height",barHeight+THRESHOLD_MARGIN)});legend.append("line").attr("class","prediction-chart__legend-threshold").attr("x1",RECT_SIZE/2).attr("x2",RECT_SIZE/2).attr("y1",-RECT_SIZE/2).attr("y2",-RECT_SIZE-RECT_SIZE/2);legend.append("text").attr("class","prediction-chart__legend-label").attr("dx",RECT_SPACING).attr("dy",(d,i)=>{return-RECT_SPACING/2}).text("Threshold - "+d3.format(".1f")(scope.threshold*100)+"%")}svg.selectAll(".nv-group rect").each(function(d){d3.select(this).style("fill",d.color)});function formatPercentage(value){return d3.format(".2f")(value)+"%"}});chartDirective("multiGroupedHBarChartWithHBarChart",{chart1Data:"=",chart2Data:"=",chart1SvgId:"=",chart2SvgId:"=",chart1Title:"=",chart2Title:"="},"chart1Data",function(scope){return scope.chart1Data},function(scope){d3.selectAll(".nvtooltip").remove();const nbOfGroups=scope.chart1Data[0].values.length;const groupSpacing=.2;const fmt=d3.format(".3n");const defaultMarginTop=50;const marginBottom=50;const chart2Svg=d3.select(`#${scope.chart2SvgId}`);const chart2Format=d3.format(",.1%");const mainChart=nv.models.multiBarHorizontalChart().groupSpacing(groupSpacing).x(d=>d.label).y(d=>d.value).margin({top:scope.legendHeight||defaultMarginTop,right:20,bottom:marginBottom,left:175}).showValues(false).showControls(false).valueFormat(fmt);mainChart.yAxis.tickFormat(fmt);mainChart.yAxis.axisLabel(scope.chart1Title);const svg=d3.select(`#${scope.chart1SvgId}`);if(scope.height){mainChart.height(scope.height)}svg.datum(scope.chart1Data).transition().call(mainChart).each("end",()=>{scope.legendHeight=mainChart.legend.height();mainChart.margin({top:scope.legendHeight});mainChart.update();buildHBarChart(scope.chart2Title,chart2Svg,scope.chart2Data,scope.height,scope.legendHeight,chart2Format);const maxHeight=parseInt(svg.style("height").split("px")[0]);const height=scope.height||maxHeight;translateTicksVertically(svg,height-marginBottom-scope.legendHeight,nbOfGroups,groupSpacing);mainChart.dispatch.on("stateChange",function(e){const numberSelectedClasses=e.disabled.filter(d=>!d).length;scope.height=numberSelectedClasses*nbOfGroups*15+400;translateTicksVertically(svg,scope.height-scope.legendHeight-marginBottom,nbOfGroups,groupSpacing);mainChart.height(scope.height);mainChart.update();buildHBarChart(scope.chart2Title,chart2Svg,scope.chart2Data,scope.height,scope.legendHeight,chart2Format)})})});function translateTicksVertically(svg,innerChartHeight,nbOfGroup,groupSpacing){const spaceSize=innerChartHeight*groupSpacing/nbOfGroup;const groupSize=innerChartHeight*(1-groupSpacing)/nbOfGroup;const yTranslation=(spaceSize+groupSize)/2;svg.selectAll(".tick line").attr("transform","translate(0, "+yTranslation+")")}function buildHBarChart(title,svg,data,height,marginTop,format){const chart=nv.models.multiBarHorizontalChart().groupSpacing(.2).margin({top:marginTop,bottom:50,left:15}).showValues(true).x(d=>d.label).y(d=>d.value).showXAxis(false).showLegend(false).showControls(false);if(height){chart.height(height)}chart.yAxis.axisLabel(title);chart.yAxis.tickFormat(format);chart.tooltip.enabled(false);chart.valueFormat(format);svg.datum(data).transition().duration(500).call(chart)}chartDirective("multiLinesWithBarChart",{data:"=",xlabel:"=",isDate:"=",y1Label:"=",y2Label:"="},"data",function(scope){return scope.data},function(scope,element){d3.selectAll(".nvtooltip").remove();const svg=d3.select(element.get(0));const distanceBetweenXTicks=scope.data[0].values[1][0]-scope.data[0].values[0][0];const chart=nv.models.multiChart().margin({top:0,right:50,bottom:100,left:100}).x(d=>d[0]).y(d=>d[1]).height(svg.style.height);const numberIsAlmostZero=number=>Math.abs(number)<Number.EPSILON;const yAxis1Fmt=number=>numberIsAlmostZero(number)?"0":d3.format(".3n")(number);const yAxis2Fmt=d3.format(".1%");chart.bars2.id(CSS.escape(scope.xlabel));chart.tooltip.contentGenerator(data=>{let yvalue,xvalue=data.value;const color=data.series[0].color;const key=data.series[0].key;if(data.point){xvalue=formatFloat(scope.isDate,xvalue);yvalue=yAxis1Fmt(data.series[0].value)}else{xvalue="[{0}, {1})".format(formatFloat(scope.isDate,xvalue),formatFloat(scope.isDate,xvalue+distanceBetweenXTicks));yvalue=yAxis2Fmt(data.series[0].value)}return tooltipHTML(xvalue,color,key,yvalue)});chart.bars2.groupSpacing(0);chart.legendRightAxisHint("");chart.xAxis.axisLabel(scope.xlabel||"Values").showMaxMin(false).axisLabelDistance(40).tickFormat(d=>formatFloatForAxisLabel(scope.isDate,d));if(scope.isDate){chart.xAxis.rotateLabels(-45)}chart.yAxis1.axisLabel(scope.y1Label).tickFormat(yAxis1Fmt).showMaxMin(false).axisLabelDistance(40);chart.yAxis2.axisLabel(scope.y2Label).tickFormat(yAxis2Fmt).showMaxMin(true).tickValues([0]);svg.datum(scope.data).transition().duration(500).call(chart).each("end",()=>{chart.margin({top:chart.legend.height()});chart.update()})});function formatFloat(isDate,d){if(isDate){return d3.time.format("%Y-%m-%d %H:%M")(new Date(d))}else{return d3.format(".n")(d)}}function formatFloatForAxisLabel(isDate,d){if(isDate){return d3.time.format("%Y-%m-%d %H:%M")(new Date(d))}else{return d3.format(",g")(d).replace(/\.0+$/,"")}}function tooltipHTML(xvalue,color,key,yvalue){return`
    <table>
        <thead>
            <tr>
                <td colspan="3">
                    <strong class="x-value">${xvalue}</strong>
                </td>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td class="legend-color-guide">
                    <div style="background-color:${color}"></div>
                </td>
                <td class="key">${key}</td>
                <td class="value">${yvalue}</td>
            </tr>
        </tbody>
    </table>`}chartDirective("multiLineChart",{ys:"=",x:"=?",xs:"=?",labels:"=",legendTexts:"=",colors:"=",format:"=",ys2:"=?",ys2Series:"=?",xMarks:"=?",xMarkLabelPosition:"=?",xTicks:"=?",options:"=?",axes:"=?",scale:"=?",scale2:"=?",xScale:"=?",callback:"=?",disableInteractiveLayer:"=?",hideLegend:"=?",loadedStateField:"=?",disableTransitions:"=?",disableInteractiveGuideline:"=?"},"[ys, ys2, axes, xScale]",function(scope,attrs,Fn){if(scope.x&&scope.x.length){scope.xs=[scope.x]}if(!scope.xs||!scope.xs.length||!scope.ys||!scope.ys.length||!scope.labels||!scope.labels.length){return null}scope.scale=scope.scale||function(_){return[d3.min(_),d3.max(_)]}([].concat.apply([],scope.ys));if(scope.ys2&&scope.ys2.length&&scope.ys2[0]&&scope.ys2[0].length){var y2=[].concat.apply([],scope.ys2),scale2;scope.ys2.scale=scale2=d3.scale.linear().range(scope.scale).domain(scope.scale2||[Math.min.apply(null,y2),Math.max.apply(null,y2)])}if(scope.xScale==null){scope.xScale=d3.scale.linear().domain(function(_){return[d3.min(_),d3.max(_)]}([].concat.apply([],scope.xs)))}scope.callback=typeof scope.callback==="function"?scope.callback:Fn.NOOP;return scope.ys.concat(scope.ys2||[]).map(function(ys,i){var t=i<scope.ys.length?Fn.SELF:scale2;return angular.extend({key:scope.labels[i],legendText:scope.legendTexts?scope.legendTexts[i]:"",values:ys.map(function(y,j){return{x:scope.xs[i%scope.xs.length][j],y:t(y)}}),color:scope.colors[i]},!this?{}:Array.isArray(this)?this[i]:this)},scope.options)},function(scope,element,Fn){var width=element.width(),height=element.height(),scale2=scope.ys2&&scope.ys2.scale.copy(),margin={top:10,right:scale2?80:20,bottom:60,left:70},cw=width-margin.left-margin.right,ch=height-margin.top-margin.bottom-(scope.hideLegend?0:20),axes=(Array.isArray(scope.axes)?scope.axes:[]).concat(["","",""]),fmts=Array.isArray(scope.format)?scope.format:[scope.format],chart=nv.models.lineChart().margin(margin),elt=element.get(0),par=elt.parentElement,svg=d3.select(elt);chart.useInteractiveGuideline(!scope.disableInteractiveGuideline);chart.interactiveLayer.tooltip.enabled(!scope.disableInteractiveLayer);chart.interactiveLayer.showGuideLine(!scope.disableInteractiveLayer);chart.showLegend(!scope.hideLegend);if(scope.legendTexts){chart.legend.key(function(d){return d.legendText})}svg.select(".secondary-axis").remove();svg.selectAll(".x.mark").remove();fmts=fmts.map(_=>typeof _==="function"?_:d3.format(_));chart.forceY(scope.scale);if(scope.disableTransitions){console.info("Disabling chart transitions");chart.duration(0)}chart.forceX(scope.xScale.domain());chart.xDomain(scope.xScale.domain());chart.xScale(scope.xScale.copy().range([0,cw]));chart.xAxis.axisLabel(axes[0]).tickFormat(fmts[0]);chart.yAxis.axisLabel(axes[1]).tickFormat(fmts[1%fmts.length]);if(scope.xTicks){chart.xAxis.tickValues(scope.xTicks)}svg.datum(scope.theData).call(chart);if(scale2){var format2=fmts.length>2?fmts[2]:chart.yAxis.tickFormat();svg.select(".nv-lineChart").append("g").attr("class","y axis secondary-axis").style("fill",scope.colors[scope.ys.length]).attr("transform","translate("+cw+", 0)").call(d3.svg.axis().scale(scale2.range([ch,0])).tickFormat(format2).orient("right"));if(axes.length>2){svg.select(".secondary-axis").append("text").text(axes[2]).attr("text-anchor","middle").attr("x",0-ch/2).attr("y",60).attr("transform","rotate(-90)")}var tt=chart.interactiveLayer.tooltip,vf=tt.valueFormatter();scale2=scope.ys2.scale.copy().range(scale2.domain()).domain(scope.scale);if(fmts.length>3){format2=fmts[3]}tt.valueFormatter(function(y,i,p){return scope.ys2Series.includes(p.key)?format2(scale2(y)):vf(y,i)});tt.valueFormatter=function(_){if(_){vf=_;return tt}return vf}}(scope.xMarks||[]).filter(Fn.unique()).forEach(function(xMark,i){scope.xMarkLabelPosition=scope.xMarkLabelPosition||"bottom";const xMarkColor=scope.colors[scope.theData.length+i];const xMarkG=svg.select(".nv-lineChart").append("g").attr("class","x mark").attr("transform","translate("+chart.xScale()(xMark)+", 0)");const xMarkLabelXOffset=scope.xMarkLabelPosition==="bottom"?0:4;const xMarkLabelYOffset=(scope.xMarkLabelPosition==="bottom"?ch:0)+16;const textAnchor=scope.xMarkLabelPosition==="bottom"?"middle":"start";xMarkG.append("path").attr("d","M0,0 V"+ch).attr("stroke-width",1).attr("stroke",xMarkColor).attr("stroke-dasharray","5,3");xMarkG.append("text").attr("x",xMarkLabelXOffset).attr("y",xMarkLabelYOffset).attr("text-anchor",textAnchor).attr("fill",xMarkColor).text(chart.xAxis.tickFormat()(xMark))});var parStyle=window.getComputedStyle(par);if(parStyle.position==="relative"&&!par.querySelector("style.nvTooltipFix")){var st=document.createElement("style");if(!par.id){par.id=chart.interactiveLayer.tooltip.id()+"p"}st.innerHTML=["#",par.id," .nvtooltip { margin-left: -",par.offsetLeft,"px; }"].join("");par.insertBefore(st,null)}scope.callback(svg,angular.extend(scope,{chart:chart,margin:margin,axisHeight:ch}))});chartDirective("distributionChart",{data:"=",xMarks:"=?",hideZero:"=?",colors:"=",xFormat:"@?",yFormat:"@?",axes:"=?"},"data",function(scope,element,Fn){return{xScale:d3.scale.linear().domain([scope.data[0].min,scope.data[scope.data.length-1].max]),yScale:d3.scale.linear().domain([0,d3.max(scope.data,Fn.prop("count"))]).nice()}},function(scope,element,Fn){const xTickValues=scope.data.map(Fn.prop("max"));xTickValues.push(scope.data[0].min);if(!scope.hideZero){xTickValues.push(0)}const margin={top:20,right:20,bottom:40,left:40},gap=6,w=element.width()-margin.left-margin.right,h=element.height()-margin.top-margin.bottom,xs=scope.theData.xScale.range([margin.left,w+margin.left]),ys=scope.theData.yScale.range([h+margin.top,margin.top]),bw=xs(scope.data[0].max)-xs(scope.data[0].min),y0=ys(0),xFormat=scope.xFormat?d3.format(scope.xFormat):scope.theData.xScale.tickFormat(),yFormat=scope.yFormat?d3.format(scope.yFormat):scope.theData.yScale.tickFormat(),xAxis=d3.svg.axis().scale(xs).orient("bottom").tickFormat(xFormat).tickValues(xTickValues),yAxis=d3.svg.axis().scale(ys).orient("left").tickFormat(yFormat).tickValues(ys.ticks(10)).tickSize(w),svg=d3.select(element.get(0)).html("");if(scope.axes){margin.left+=5;margin.bottom+=5;let xAxisLabel=scope.axes[0];svg.append("g").attr("class","x-axis-labels").append("text").style("font-size","13px").attr("text-anchor","middle").attr("x",margin.left+w/2).attr("y",35+h+margin.top).text(xAxisLabel);let yAxisLabel=scope.axes[1];svg.append("g").attr("class","y-axis-labels").append("text").attr("transform","rotate(-90, 12, "+(margin.top+h/2)+")").attr("text-anchor","middle").style("font-size","13px").attr("x",12).attr("y",margin.top+h/2).text(yAxisLabel)}svg.append("g").attr("class","x axis").attr("transform","translate(0, "+(h+margin.top)+")").call(xAxis);svg.append("g").attr("class","y axis").attr("transform","translate("+(w+margin.left)+", 0)").call(yAxis).select(".domain").attr("d","M-"+w+","+margin.top+"v"+h);svg.append("g").attr("class","bars").selectAll(".bar").data(scope.data).enter().append("rect").attr("class","bar").attr("x",function(d){return xs(d.min)+gap/2}).attr("width",bw-gap).attr("y",Fn(Fn.prop("count"),ys)).attr("height",function(d){return y0-ys(d.count)}).attr("fill",scope.colors[0]);svg.append("g").attr("class","labels").selectAll(".label").data(scope.data).enter().append("text").attr("class","label").attr("x",Fn(Fn.prop("min"),xs)).attr("dx",bw/2).attr("y",Fn(Fn.prop("count"),ys)).attr("dy",-6).attr("text-anchor","middle").text(Fn(Fn.prop("count"),yFormat));svg.append("g").attr("class","marks").selectAll(".mark").data((scope.xMarks||[]).filter(Fn.unique())).enter().append("path").attr("class","mark").attr("stroke",Fn.from(scope.colors.slice(1),1)).attr("stroke-dasharray","5,3").attr("d",function(d){return["M",xs(0),",",margin.top,"v",h].join("")})});chartDirective("bcPerBinLiftChart",{data:"=",loadedStateField:"=?",disableTransitions:"=?"},"data",function(scope,element){return[{key:"Per-bin lift chart",values:scope.data.bins.map(function(p){return{x:p.percentile_idx+1,y:p.bin_lift}})}]},function(scope,element,Fn){var width=element.width(),height=element.height(),margin={top:10,right:20,bottom:60,left:70},max=Math.ceil(d3.max(scope.theData[0].values,Fn.prop("y"))),chart=nv.models.discreteBarChart().width(width).height(height).margin(margin).color(function(d){return d.y>1?"steelblue":"lightblue"}).showValues(true).staggerLabels(false).forceY([0,max]),svg=d3.select(element.get(0)).html("");chart.tooltip.enabled(false);chart.xAxis.axisLabel("Observations by decreasing probability decile");chart.yAxis.axisLabel("Lift on bin");let transitionDuration=500;if(scope.disableTransitions){console.info("Disabling chart transitions");chart.duration(0);transitionDuration=0}svg.datum(scope.theData).transition().duration(transitionDuration).call(chart);var heightOfOne=chart.yAxis.scale()(1);svg.append("g").attr("class","mlchart-defaultbaseline").append("path").attr("d",["M",margin.left,",",heightOfOne+margin.top," H",width-margin.right].join(""))});chartDirective("explorationParallelCoordinatesPlot",{records:"=",features:"=",shownFeatures:"="},["records","features","shownFeatures"],function(scope,element,Fn){return{}},function(scope,element,Fn,MLChartsCommon){const SYNTHETIC_SEGMENT_COLOR="#3B99FC";const REFERENCE_SEGMENT_COLOR="#000000";const DISTRIBUTION_COLOR="#DDDDDD";const features=scope.features.filter(f=>scope.shownFeatures.includes(f.name));const records=scope.records.filter(record=>record.isShown);const minWidthPerFeature=110;const margin={top:40,right:20,bottom:20,left:20};const svgContainer=angular.element(".exploration-results__svg-container");const scrollLeftValue=svgContainer.scrollLeft();d3.select(element.get(0)).style("min-width","0");const width=Math.max(element.width()-margin.left-margin.right,minWidthPerFeature*features.length);const height=element.height()-margin.top-margin.bottom;const svg=d3.select(element.get(0)).style("min-width",`${width+margin.left+margin.right}px`).html("").append("g").attr("transform",`translate(${margin.left}, ${margin.top})`);svgContainer.scrollLeft(scrollLeftValue);const x=d3.scale.ordinal().rangePoints([0,width],1).domain(features.map(feature=>feature.name));const getNbCharsBetweenTwoAxis=()=>{return 12+Math.floor((width/features.length-minWidthPerFeature)/8)};const cropText=(text,maxNbCharacters)=>text.length>maxNbCharacters?text.substring(0,maxNbCharacters)+"...":text;const limitLength=e=>cropText(e,getNbCharsBetweenTwoAxis());const limitLengthForFirstFeature=e=>cropText(e,Math.ceil(getNbCharsBetweenTwoAxis()/2));const formatters={};const y={};for(const feature of features){switch(feature.type){case"NUMERICAL":{const distributionValues=feature.distribution.map(e=>e.tick);const recordsValues=records.map(record=>record.values[feature.name]);const domain=d3.extent(distributionValues.concat(recordsValues));const rangeSize=domain[1]-domain[0];if(feature.shouldBeRepresentedWithHistograms){formatters[feature.name]=MLChartsCommon.makeAxisNumericFormatter(domain[0],domain[1],3,1);domain[1]+=rangeSize/feature.distribution.length;y[feature.name]=d3.scale.linear().range([height,0]).domain(domain);break}else{formatters[feature.name]=e=>rangeSize>15&&e%5?"":e;y[feature.name]=d3.scale.ordinal().rangeBands([0,height]).domain(feature.distribution.map(e=>e.tick));break}}case"CATEGORICAL":formatters[feature.name]=feature.name===features[0].name?limitLengthForFirstFeature:limitLength;y[feature.name]=d3.scale.ordinal().rangeBands([0,height]).domain(feature.distribution.map(e=>e.tick))}}for(const feature of features){svg.selectAll("rect_"+feature.name.dkuHashCode()).data(feature.distribution).enter().append("rect").attr("x",x(feature.name)).attr("y",feature.type==="NUMERICAL"&&feature.shouldBeRepresentedWithHistograms?-height/feature.distribution.length:0).attr("transform",d=>`translate(0, ${y[feature.name](d.tick)})`).attr("width",d=>.5*width/features.length*(d.width/d3.max(feature.distribution.map(e=>e.width)))).attr("height",height/feature.distribution.length).style("fill",DISTRIBUTION_COLOR)}let segments=[];for(let i=0;i<features.length-1;i++){for(let j=0;j<records.length;j++){const record=records[j];const getX=feature=>Math.round(x(feature.name));const getY=feature=>{let tmp=y[feature.name](record.values[feature.name]);if(feature.type==="CATEGORICAL"||!feature.shouldBeRepresentedWithHistograms){if(tmp===undefined){tmp=y[feature.name]("Other")}tmp+=.5*height/feature.distribution.length}return Math.round(tmp)};segments.push({points:{x1:getX(features[i]),x2:getX(features[i+1]),y1:getY(features[i]),y2:getY(features[i+1])},recordIndex:j})}}segments=Object.values(segments.reduce((acc,item)=>{const key=Object.values(item.points);acc[key]={points:item.points,count:(acc[key]?acc[key].count:0)+1,recordIndices:(acc[key]?acc[key].recordIndices:[]).concat([item.recordIndex])};return acc},{}));const containsReference=segment=>segment.recordIndices.some(recordIndex=>records[recordIndex].isReference);const containsHovered=segment=>segment.recordIndices.some(recordIndex=>records[recordIndex].isHovered);svg.selectAll("segment").data(segments).enter().append("line").attr({x1:segment=>segment.points.x1,y1:segment=>segment.points.y1,x2:segment=>segment.points.x2,y2:segment=>segment.points.y2,stroke:segment=>containsReference(segment)?REFERENCE_SEGMENT_COLOR:SYNTHETIC_SEGMENT_COLOR,"stroke-width":segment=>1+segment.count,opacity:segment=>containsHovered(segment)?1:containsReference(segment)?.5:.3}).on("mouseover",segment=>{segment.recordIndices.forEach(recordIndex=>records[recordIndex].isHovered=true);scope.$apply()}).on("mouseout",_=>{records.forEach(record=>record.isHovered=false);scope.$apply()});svg.selectAll("axis").data(features).enter().append("g").attr("class","axis").attr("transform",feature=>`translate(${x(feature.name)})`).each(function(feature){d3.select(this).call(d3.svg.axis().scale(y[feature.name]).orient("left").ticks(4).tickFormat(formatters[feature.name]))}).append("text").style("text-anchor","middle").attr("y",-9).text(feature=>limitLength(feature.name)).append("svg:title").text(feature=>feature.name);svg.selectAll(".axis>.tick").append("title").text(d=>d)});chartDirective("bcPerBinProbaDistribChart",{data:"=",bins:"=",threshold:"=",modelClasses:"=",colors:"="},"data",function(scope){return{probaDistribs:scope.data.probaDistribs.map((probaDistrib,i)=>{return{key:"actual "+scope.modelClasses[i],values:probaDistrib.map(d=>({value:d})),color:scope.colors[i]}}),bins:scope.data.bins,threshold:scope.threshold}},function(scope,element){let width=element.width(),height=element.height(),margin={top:25,right:20,bottom:40,left:60},max=scope.theData.probaDistribs.reduce((acc,curr)=>Math.max(acc,curr.values.reduce((acc2,curr2)=>Math.max(acc2,curr2.value),0)),0);let chart=nv.models.multiBarChart().width(width).height(height).margin(margin).x((_,i)=>{return((scope.theData.bins[i]+scope.theData.bins[i+1])/2).toFixed(2)}).y(d=>d.value).staggerLabels(false).showControls(false).forceY([0,max]);let svg=d3.select(element.get(0)).html("");chart.xAxis.axisLabel("Predicted probability");chart.yAxis.axisLabel("# of rows");chart.tooltip.contentGenerator(function(data){var index=data.index;return["<p><strong>"+data.data.key+"</strong></p>","<p>Predicted probability: "+scope.theData.bins[index]+" - "+scope.theData.bins[index+1]+"</p>","<p># of rows: "+data.data.value].join("")});chart.options({tooltip:{chartContainer:document.body}});svg.datum(scope.theData.probaDistribs).transition().duration(500).call(chart);let chartHeight=height-margin.top-margin.bottom,chartWidth=width-margin.left-margin.right;let xScale=d3.scale.linear().domain([scope.theData.bins[0],scope.theData.bins[scope.theData.bins.length-1]]).range([0,chartWidth]);var thresholdMarkColor="#9467bd";var thresholdMarkG=svg.select(".nv-multibar").append("g").attr("class","threshold mark").attr("transform","translate("+xScale(scope.theData.threshold)+", 0)");thresholdMarkG.append("path").attr("d","M0,0 V"+chartHeight).attr("stroke-width",1).attr("stroke",thresholdMarkColor).attr("stroke-dasharray","5,3");thresholdMarkG.append("text").attr("x",0).attr("y",chartHeight+15).attr("text-anchor","middle").text(scope.theData.threshold.toFixed(2)).attr("fill",thresholdMarkColor)});app.directive("bcGainChart",function(Fn){return{priority:10,scope:false,link:function(scope,elt,attrs){scope.$watch(attrs.data,function(data){if(!data)return;var ys=data.folds&&data.folds.length?data.folds:[data.bins];function remap(y){return[0].concat(y.map(this))}scope.xs=ys.map(remap,Fn.prop("cum_size"));scope.ys=ys.map(remap,Fn.prop("cum_lift"));var wizSlope=data.wizard.total/data.wizard.positives,wizard=scope.xs[0].map(function(x,i){return Math.min(x*wizSlope,1)}),wizX=scope.xs[0].slice(0),x1=wizard.indexOf(1);wizard.splice(x1,0,1);wizX.splice(x1,0,1/wizSlope);scope.ys.push(wizard);scope.xs.push(wizX);scope.ys.push(scope.xs[0].map(Fn.SELF));scope.labels=ys.length===1?["Cumulative Gain","Wizard (perfect model)","Random model"]:ys.map(function(_,i){return"Cumul. Gain, fold "+(i+1)}).concat("Wizard","Random model")})}}});app.controller("CMLTaskModelsRankingController",function($scope,CMLSettings){$scope.isBestModelGroup=function(modelGroup,metric){if(!$scope.modelGroups)return;return $scope.orderGroups($scope.modelGroups,metric)[0]===modelGroup};$scope.getGroupBestValue=function(modelGroup,metric){if(!metric){metric="SILHOUETTE"}if(!modelGroup.models.length)return"-";const lib=CMLSettings.sort.lowerIsBetter(metric);const cmp=lib?Math.min:Math.max;return cmp(...modelGroup.models.map(snippet=>snippet[metric.toLowerCase()]))};$scope.orderGroups=function(groups,metric){const lib=CMLSettings.sort.lowerIsBetter(metric);const filteredGroups=groups.filter(g=>CMLSettings.supportsInertia.includes(g.algorithm)||metric==="SILHOUETTE");const metricField=metric.toLowerCase();if(lib){return filteredGroups.sort((a,b)=>Math.min(...a.models.map(snippet=>snippet[metricField]))-Math.min(...b.models.map(snippet=>snippet[metricField])))}else{return filteredGroups.sort((a,b)=>Math.max(...b.models.map(snippet=>snippet[metricField]))-Math.max(...a.models.map(snippet=>snippet[metricField])))}};function getAlgoGroupDisplayName(snippet){return CMLSettings.algoDisplayNames[snippet.algorithm]+(snippet.usesPCA?" (PCA)":"")}function sortModelsForDisplay(){$scope.modelGroups=Object.entries(Object.groupBy($scope.selection.sessionModels,snippet=>`${snippet.algorithm}-${snippet.usesPCA}`)).map(([algorithmKey,snippetsByAlgoAndPCA])=>{const firstSnippet=snippetsByAlgoAndPCA.sort((a,b)=>a.nbClusters-b.nbClusters)[0];const models=snippetsByAlgoAndPCA.filter(snippet=>snippet.inertia||snippet.silhouette);return{displayName:getAlgoGroupDisplayName(firstSnippet),algorithm:firstSnippet.algorithm,color:firstSnippet.color,usesPCA:firstSnippet.usesPCA,models:models,clusters:models.map(snippet=>snippet.nbClusters)}})}$scope.$watch("selection.sessionModels",sortModelsForDisplay,true)});app.controller("PMLTaskModelsRankingController",function($scope){function sortModelsForDisplay(){$scope.orderedModels=($scope.selection.sessionModels||[]).map(x=>{if(x.trainInfo&&x.trainInfo.state!=="DONE"){x.sortMainMetric=-999999999}return x}).sort((a,b)=>-(a.sortMainMetric-b.sortMainMetric))}$scope.$watch("selection.sessionModels",sortModelsForDisplay,true)});chartDirective("gridsearchResults",{selectedModel:"=",allModels:"=",currentMetric:"=",sessionId:"="},["selectedModel","allModels","currentMetric","sessionId"],function(scope,Collections){return scope.allModels.filter(function(model){return model.sessionId===scope.sessionId&&model.mainMetric})},function(scope,element,$filter,Fn){var changeSelectedModel=function(nv){scope.selectedModel=nv;scope.$apply()};var margin={top:0,right:0,bottom:50,left:5},width=element.width()-margin.left-margin.right,height=element.height()-margin.top-margin.bottom,chart=d3.select(element.get(0)).html(""),miny=d3.min(scope.theData.map(function(c){return c.mainMetric})),maxy=d3.max(scope.theData.map(function(c){return c.mainMetric})),ydiff=Math.max(maxy-miny,Math.abs(.01*miny));maxy=maxy+.15*ydiff;chart.attr("viewBox","0 0 "+width+" "+height);var main=chart.append("g").attr("transform","translate("+margin.left+","+margin.top+")").attr("width",width).attr("height",height).attr("class","main");var y=d3.scale.linear().domain([miny,maxy]).range([height,0]);var threshold=10;scope.theData=scope.theData.sort(function(a,b){return b.mainMetric-a.mainMetric});var dists=[],i;for(i=1;i<scope.theData.length;i++){dists.push(y(scope.theData[i].mainMetric)-y(scope.theData[i-1].mainMetric))}var distToGet=0;dists=dists.map(function(o){distToGet+=Math.max(threshold-o,0);return Math.max(threshold,o)});var totalOverDist=dists.filter(function(o){return o>threshold}).reduce(Fn.SUM,0);dists=dists.map(function(o){return o>threshold?o-o/totalOverDist*distToGet:o});if(scope.theData.length>0){scope.theData[0].y=y(scope.theData[0].mainMetric)}for(i=1;i<scope.theData.length;i++){scope.theData[i].y=scope.theData[i-1].y+dists[i-1]}var textx=width-20,mins=d3.min(scope.theData.map(function(c){return c.mainMetric})),maxs=d3.max(scope.theData.map(function(c){return c.mainMetric}));main.append("line").attr({x1:textx,x2:textx,y1:height-10,y2:10,class:"domain","stroke-dasharray":"2,5"});main.append("text").attr({x:textx,y:0}).style("text-anchor","middle").text(maxs?maxs.toFixed(2):"");main.append("text").attr({x:textx,y:height+10}).style("text-anchor","middle").text(mins?mins.toFixed(2):"");main.append("text").attr({x:0,y:height+20}).text(function(d){var txt="Final model score on test set";txt+=scope.theData.length==0?"":" ("+$filter("mlMetricName")(scope.currentMetric,scope.theData[0])+")";return txt});var div=d3.select("body").selectAll("div.gridsearch.tooltip").data([0]);div.enter().append("div").attr("class","tooltip gridsearch").style("opacity",0);var pointlines=main.selectAll("g.doctor-results-graph-line").data(scope.theData).enter().append("g").attr("transform",function(d){return"translate(0 "+d.y+")"}).attr("class",function(d){return d.fullModelId===(scope.selectedModel||{}).fullModelId?"selected doctor-results-graph-line":"doctor-results-graph-line"});var showPopup=function(d){changeSelectedModel(d);div.transition().duration(200).style("opacity",1);div.html(d.mainMetric.toFixed(3)).style("left",d3.event.pageX-22+"px").style("top",d3.event.pageY-32+"px")};var hidePopup=function(d){div.transition().duration(500).style("opacity",0)};pointlines.append("line").attr({x1:0,y1:0,x2:20,y2:0,fill:"#2d2d2d"}).attr("stroke",function(d){return d.color}).on("mouseover",showPopup).on("mouseout",hidePopup);pointlines.append("circle").attr({cx:0,cy:0,r:3}).attr("fill","#2d2d2d").attr("stroke",function(d){return d.color}).on("mouseover",showPopup).on("mouseout",hidePopup);pointlines.append("circle").attr({cx:20,cy:0,r:3,fill:"#2d2d2d"}).attr("stroke",function(d){return d.color}).on("mouseover",showPopup).on("mouseout",hidePopup);pointlines.append("text").attr({x:30,y:4}).text(function(d){return d.userMeta.name}).attr("fill",function(d){return d.color}).on("mouseover",function(d){changeSelectedModel(d)})},{},function(){d3.select("body").selectAll("div.gridsearch.tooltip").remove()});function objdiff(a,b){var diff={};angular.forEach(a,function(v,k){if(a[k]!=b[k]&&a[k]!==undefined&&b[k]!==undefined){diff[k]=[a[k],b[k]]}});return diff}chartDirective("clusteringPerfCurve",{sessionId:"=",selectedModel:"=",modelGroups:"<",currentMetric:"=",currentMetricLowerIsBetter:"=",showEveryResult:"="},["sessionId","selectedModel","modelGroups","currentMetric","currentMetricLowerIsBetter"],function(scope,CMLSettings){return scope.modelGroups.filter(modelGroup=>{return modelGroup.models.map(snippet=>snippet[scope.currentMetric.toLowerCase()]).every(v=>v&&v!=0)}).filter(g=>CMLSettings.supportsInertia.includes(g.algorithm)||scope.currentMetric==="SILHOUETTE").map(modelGroup=>{const metricValues=modelGroup.models.map(snippet=>snippet[scope.currentMetric.toLowerCase()]);let values=[];for(let i=0;i<metricValues.length;i++){values.push({x:modelGroup.clusters[i],y:metricValues[i],model:modelGroup.models[i]})}values=values.sort((a,b)=>a.x-b.x);return{values:values,xLast:values.length>0?values[values.length-1].x:0,yLast:values.length>0?values[values.length-1].y:0,...modelGroup}})},function(scope,element,$filter){const changeSelectedModel=function(newSelectedModel){scope.selectedModel=newSelectedModel;scope.$apply()};const tooltipScope=scope.$parent;const groupsClusters=scope.theData.map(modelGroup=>modelGroup.clusters);const groupsMetrics=scope.theData.map(modelGroup=>modelGroup.values.map(v=>v.y));const minY=scope.currentMetric==="SILHOUETTE"?-1:d3.min(groupsMetrics.map(groupMetrics=>d3.min(groupMetrics)));const maxY=scope.currentMetric==="SILHOUETTE"?1:d3.max(groupsMetrics.map(groupMetrics=>d3.max(groupMetrics)));const minX=d3.min(groupsClusters.map(groupClusters=>d3.min(groupClusters)));const maxX=d3.max(groupsClusters.map(groupClusters=>d3.max(groupClusters)));const chart=d3.select(element.get(0)).html("");const yAxisFormatFn=scope.currentMetric==="SILHOUETTE"?d3.format(".3"):d3.format(".0f");const yAxisLabelChars=Math.max(yAxisFormatFn(maxY).length,yAxisFormatFn(minY).length);const margin={top:5,right:10,bottom:15,left:23+Math.round(yAxisLabelChars*5.5)};const width=element.width()-margin.left-margin.right;const height=element.height()-margin.top-margin.bottom;const main=chart.append("g").attr("transform","translate("+margin.left+","+margin.top+")").attr("width",width).attr("height",height).attr("class","main");const showPopup=function(d){changeSelectedModel(d.model||d3.select(this.parentNode).datum().model);let html='<table class="tooltip-table"><tr><td></td><td>'+sanitize($filter("mlMetricName")(scope.currentMetric,d.model))+"</td><td>"+sanitize(d.y.toFixed(3))+"</td></tr>";html+="<tr><td></td><td>Clusters</td><td>"+sanitize(d.x)+"</td></tr>";html+="<tr><td></td><td>Model name</td><td>"+sanitize(d.model.userMeta.name)+"</td></tr>";html+="</table>";tooltipScope.setTooltipContent(html);tooltipScope.showTooltip(margin.left+x(d.xlast||d.x),margin.top+y(d.ylast||d.y))};const hidePopup=function(){tooltipScope.hideTooltip()};chart.append("text").attr("text-anchor","middle").attr("transform","rotate(-90, 12, "+height/2+")").attr("fill","#9d9d9d").attr("x",12).attr("y",height/2).text(function(){return $filter("capitalizeWord")(scope.currentMetric)});main.append("text").attr("text-anchor","end").attr("fill","#9d9d9d").attr("x",width).attr("y",height-8).text("Number of clusters");const x=d3.scale.linear().domain([minX,maxX]).range([0,width]);const xAxis=d3.svg.axis().scale(x.nice()).tickSize(1).tickFormat(d3.format("d")).orient("bottom");main.append("g").attr("transform","translate(0,"+height+")").attr("class","main axis clusters").call(xAxis);const y=d3.scale.linear().domain([minY,maxY]).range([height,0]);const yAxis=d3.svg.axis().scale(y).orient("left").ticks(4).tickSize(0,0).tickFormat(yAxisFormatFn);main.append("g").attr("transform","translate(0,0)").attr("class","main axis date").call(yAxis);d3.selectAll(".axis").style("fill","#9d9d9d");const line=d3.svg.line().x(function(d){return x(d.x)}).y(function(d){return y(d.y)});var pointLines=main.append("svg:g").selectAll("g").data(scope.theData.filter(function(modelGroup){return modelGroup.values&&modelGroup.values.every(a=>a)})).enter().append("g");pointLines.selectAll("circle").data(function(modelGroup){return modelGroup.values}).enter().append("circle").attr("stroke",function(d){return d3.select(this.parentNode).datum().models[0].color}).attr("fill",function(d){return d3.select(this.parentNode).datum().color}).attr("r",3).attr("cx",function(e){return x(e.x)}).attr("cy",function(e){return y(e.y)}).attr("stroke-width","2px").on("mouseover",showPopup).on("mouseout",hidePopup);pointLines.append("path").datum(function(d){return d.values}).attr("d",line).attr("fill","none").attr("stroke",function(d){return d3.select(this.parentNode).datum().color})},{},function(){d3.select("body").selectAll("div.gridsearch.tooltip").remove()});chartDirective("gridsearchCurve",{sessionId:"=",selectedModel:"=",allModels:"=",evaluationMetricLowerIsBetter:"=",showEveryResult:"="},["sessionId","selectedModel","allModels"],function(scope,Collections){return Object.values(scope.allModels).filter(function(snippet){return snippet.sessionId===scope.sessionId&&snippet.gridsearchData&&snippet.gridsearchData.gridPoints.length>0}).map(function(snippet){var values=[],cumTime=0,bestParams={},lastbestParams={};var metric=snippet.gridsearchData.metric;var maxScore=scope.evaluationMetricLowerIsBetter?Number.MAX_VALUE:-1*Number.MAX_VALUE;snippet.gridsearchData.gridPoints.sort(function(a,b){return a.finishedAt-b.finishedAt}).forEach(function(gridPoint){const thisPointTrainTime=gridPoint.time/1e3/snippet.gridsearchData.nSplits||1;cumTime+=thisPointTrainTime;if(gridPoint.score||gridPoint.score===0){if(scope.showEveryResult){maxScore=gridPoint.score}else{maxScore=scope.evaluationMetricLowerIsBetter?Math.min(maxScore,gridPoint.score):Math.max(maxScore,gridPoint.score)}lastbestParams=bestParams;if(values.length==0){values.push({x:0,y:maxScore,p:{},pd:{}})}bestParams=maxScore==gridPoint.score?gridPoint.parameters:bestParams;values.push({x:cumTime,y:maxScore,time:thisPointTrainTime,p:angular.copy(bestParams),pd:objdiff(lastbestParams,bestParams)})}});return{values:values,metric:metric,model:snippet,xlast:values.length>0?values[values.length-1].x:0,ylast:values.length>0?values[values.length-1].y:0}})},function(scope,element,$filter){var changeSelectedModel=function(nv){scope.selectedModel=nv;scope.$apply()};let maxx=d3.max(scope.theData.map(function(c){return d3.max(c.values,function(d){return d.x})})),maxy=d3.max(scope.theData.map(function(c){return d3.max(c.values,function(d){return d.y})})),miny=d3.min(scope.theData.map(function(c){return d3.min(c.values,function(d){return d.y})})),yAxisFormatFn=d3.format("04.3f"),yAxisLabelChars=Math.max(yAxisFormatFn(maxy).length,yAxisFormatFn(miny).length),margin={top:0,right:10,bottom:15,left:23+Math.round(yAxisLabelChars*5.5)},width=element.width()-margin.left-margin.right,height=element.height()-margin.top-margin.bottom,chart=d3.select(element.get(0)).html(""),baseTime=30,powTime=2,minx=-1,ydiff=Math.max(maxy-miny,Math.abs(.01*miny)),tooltipScope=scope.$parent;maxy=maxy+.3*ydiff;miny=miny-.3*ydiff;maxx=Math.pow(powTime,Math.max(0,Math.ceil(log10(maxx/baseTime)/log10(powTime))))*baseTime;var minFormat=maxx>120;var main=chart.append("g").attr("transform","translate("+margin.left+","+margin.top+")").attr("width",width).attr("height",height).attr("class","main");var x=d3.scale.linear().domain([minx,maxx]).range([0,width]);var xAxis=d3.svg.axis().scale(x).orient("bottom").ticks(8).tickSize(0,0).tickFormat(function(d){var m=Math.floor(d/60),s=Math.floor(d)%60;if(!minFormat&&m<1){return s+"s"}else if(!minFormat&&m<2){return m+":"+("0"+s).slice(-2)}else{return m}});main.append("g").attr("transform","translate(0,"+height+")").attr("class","main axis date").call(xAxis);var y=d3.scale.linear().domain([miny,maxy]).range([height,0]);var yAxis=d3.svg.axis().scale(y).orient("left").ticks(4).tickSize(0,0).tickFormat(yAxisFormatFn);main.append("g").attr("transform","translate(0,0)").attr("class","main axis date").call(yAxis);if(scope.theData.length){chart.append("text").attr("text-anchor","middle").attr("transform","rotate(-90, 12, "+height/2+")").attr("fill","#9d9d9d").attr("x",12).attr("y",height/2).text(function(){let txt=$filter("mlMetricName")(scope.theData[0].metric,scope.theData[0].model);if(!txt.toLowerCase().endsWith("score")){txt+=" score"}if(scope.theData[0].model.sampleWeightsEnabled)txt+=" (weighted)";return txt})}main.selectAll("line.horizontalGrid").data(y.ticks(6)).enter().append("line").attr({class:"horizontalGrid",x1:x(minx),x2:width,y1:y,y2:y});main.selectAll("line.verticalGrid").data(x.ticks(6)).enter().append("line").attr({class:"verticalGrid",x1:x,x2:x,y1:y(maxy),y2:y(miny)});main.append("text").attr("text-anchor","end").attr("x",width).attr("y",height-8).text("Time "+(minFormat?"(min)":"(s)"));var pointlines=main.append("svg:g").selectAll("g").data(scope.theData.filter(function(d){return d.values.length})).enter().append("g").attr("class",function(d){return d.model.fullModelId===(scope.selectedModel||{}).fullModelId?"selected gridsearch-scores-graph-line":"gridsearch-scores-graph-line"});var line=d3.svg.line().interpolate("monotone").x(function(d){return x(d.x)}).y(function(d){return y(d.y)});var showPopup=function(d,model){changeSelectedModel(model||d3.select(this.parentNode).datum().model);var html='<p class="mbot0">Best so far:</p><table class="tooltip-table"><tr><td></td><td>'+sanitize($filter("mlMetricName")(scope.theData[0].metric,scope.theData[0].model))+"</td><td>"+sanitize((d.y||d.ylast||0).toFixed(3))+"</td></tr>";angular.forEach(d.p,function(v,k){if(d.pd[k]){html+="<tr><td></td><td>"+sanitize(k)+"</td><td>"+sanitize(v)+"<span style='font-weight: normal'> (was "+sanitize(d.pd[k][0])+")</span></td></tr>"}else{html+="<tr><td></td><td>"+sanitize(k)+"</td><td>"+sanitize(v)+"</td></tr>"}});html+="<tr><td></td><td>Train time</td><td>"+sanitize(durationHHMMSS(d.time))+"</td></tr>";html+="</table>";tooltipScope.setTooltipContent(html);tooltipScope.showTooltip(margin.left+x(d.xlast||d.x),margin.top+y(d.ylast||d.y))};var hidePopup=function(){tooltipScope.hideTooltip()};pointlines.append("path").datum(function(d){return d.values}).attr("d",line).attr("fill","none").attr("stroke",function(d){return d3.select(this.parentNode).datum().model.color}).on("mouseover",function(d){changeSelectedModel(d3.select(this.parentNode).datum().model)});pointlines.selectAll("circle").data(function(d){return d.values}).enter().append("circle").attr("opacity",function(d,i){var p=d3.select(this.parentNode).datum();return i===p.values.length-1&&p.model.trainInfo.state==="FAILED"?0:1}).attr("stroke",function(d){return d3.select(this.parentNode).datum().model.color}).attr("fill",function(d){return d3.select(this.parentNode).datum().model.color}).attr("r",(d,i)=>i==0?0:3).attr("cx",function(e){return x(e.x)}).attr("cy",function(e){return y(e.y)}).attr("stroke-width","2px").on("mouseover",showPopup).on("mouseout",hidePopup);pointlines.append("g").each(function(d){var g=d3.select(this);if(d.model.trainInfo.state==="FAILED"){g.append("line").attr("x1",-5).attr("y1",5).attr("x2",5).attr("y2",-5).attr("stroke",function(d){return d.model.color}).attr("stroke-width","3px");g.append("line").attr("x1",-5).attr("y1",-5).attr("x2",5).attr("y2",5).attr("stroke",function(d){return d.model.color}).attr("stroke-width","3px");g.attr("transform",function(d){return"translate("+x(d.xlast)+","+y(d.ylast)+")"})}else{g.append("circle").attr("cx",function(d){return x(d.xlast)}).attr("cy",function(d){return y(d.ylast)}).attr("stroke",function(d){return d.model.color}).attr("fill",function(d){return d.model.color}).attr("stroke-width","2px").attr("r",5).attr("class",function(d){return"end-circle "+d.model.trainInfo.state}).on("mouseover",function(d){showPopup(d.values[d.values.length-1],d.model)}).on("mouseout",hidePopup)}})},{},function(){d3.select("body").selectAll("div.gridsearch.tooltip").remove()});function drawKerasCurve(scope,element){let maxx=d3.max(scope.theData.map(function(c){return d3.max(c.values,function(d){return d.x})})),maxy=d3.max(scope.theData.map(function(c){return d3.max(c.values,function(d){return d.y})})),miny=d3.min(scope.theData.map(function(c){return d3.min(c.values,function(d){return d.y})})),yAxisFormatFn=d3.format("04.3f"),yAxisLabelChars=Math.max(yAxisFormatFn(maxy).length,yAxisFormatFn(miny).length),margin={top:0,right:10,bottom:15,left:23+Math.round(yAxisLabelChars*5.5)},width=element.width()-margin.left-margin.right,height=element.height()-margin.top-margin.bottom,chart=d3.select(element.get(0)).html(""),minx=-1,ydiff=Math.max(maxy-miny,Math.abs(.01*miny)),tooltipScope=scope.$parent,numEpochs=scope.theData&&scope.theData.length>0?scope.theData[0].values.length:0;maxy=maxy+.3*ydiff;miny=miny-.3*ydiff;maxx=maxx==0?1:maxx+1;var main=chart.append("g").attr("transform","translate("+margin.left+","+margin.top+")").attr("width",width).attr("height",height).attr("class","main");var x=d3.scale.linear().domain([minx,maxx]).range([0,width]);var xAxis=d3.svg.axis().scale(x).orient("bottom").ticks(Math.min(numEpochs+1,8)).tickSize(0,0).tickFormat(function(d){return d});main.append("g").attr("transform","translate(0,"+height+")").attr("class","main axis date").call(xAxis);var y=d3.scale.linear().domain([miny,maxy]).range([height,0]);var yAxis=d3.svg.axis().scale(y).orient("left").ticks(4).tickSize(0,0).tickFormat(yAxisFormatFn);main.append("g").attr("transform","translate(0,0)").attr("class","main axis date").call(yAxis);chart.append("text").attr("text-anchor","middle").attr("transform","rotate(-90, 12, "+height/2+")").attr("x",12).attr("y",height/2).text(scope.theData[0].xlegend);main.selectAll("line.horizontalGrid").data(y.ticks(6)).enter().append("line").attr({class:"horizontalGrid",x1:x(minx),x2:width,y1:y,y2:y});main.selectAll("line.verticalGrid").data(x.ticks(6)).enter().append("line").attr({class:"verticalGrid",x1:x,x2:x,y1:y(maxy),y2:y(miny)});main.append("text").attr("text-anchor","end").attr("x",width).attr("y",height-8).text("Epoch #");var pointlines=main.append("svg:g").selectAll("g").data(scope.theData).enter().append("g").attr("class","keras-epoch-scores-graph-line");var line=d3.svg.line().interpolate("monotone").x(function(d){return x(d.x)}).y(function(d){return y(d.y)});var showPopup=function(d){var html='<table class="tooltip-table"><tr><td></td><td><strong style="color: #333">'+d.type+"</strong></td></tr>";html+="<tr><td></td><td>"+sanitize(scope.theData[0].xlegend)+"</td><td>"+sanitize((d.y||d.ylast||0).toFixed(3))+"</td></tr>";html+="<tr><td></td><td>Epoch #</td><td>"+sanitize(d.epoch)+"</td></tr>";html+="<tr><td></td><td>Train time</td><td>"+sanitize(durationHHMMSS(d.time))+"</td></tr>";html+="</table>";tooltipScope.setTooltipContent(html);let xTooltip=margin.left+x(d.xlast||d.x);const yTooltip=margin.top+y(d.ylast||d.y);const tooltipWidth=$(".svg-tooltip").outerWidth();const svgWidth=$("svg.keras-epoch-curve").width();if(xTooltip+tooltipWidth>svgWidth){xTooltip-=$(".svg-tooltip").outerWidth()+3}tooltipScope.showTooltip(xTooltip,yTooltip)};var hidePopup=function(){tooltipScope.hideTooltip()};scope.theData.forEach(function(d){d.values.forEach(function(e){if(e.keptModel){main.append("foreignObject").html('<i class="dku-icon-trophy-16 keras-epoch-curve__trophy"></i>').attr("x",x(e.x)-8).attr("y",y(e.y)-10).attr("width",20).attr("height",20).attr("class","pointer-events-none").on("mouseover",function(d){showPopup(e)}).on("mouseout",hidePopup)}})});pointlines.append("path").datum(function(d){return d.values}).attr("d",line).attr("fill","none").attr("stroke",function(d){return d3.select(this.parentNode).datum().color}).attr("stroke-width","2px").attr("stroke-opacity","1");pointlines.selectAll("circle").data(function(d){return d.values}).enter().append("circle").attr("opacity",function(d,i){var p=d3.select(this.parentNode).datum();return i===p.values.length-1&&p.modelState==="FAILED"?0:1}).attr("stroke",function(d){return d3.select(this.parentNode).datum().color}).attr("r",function(e){return e.keptModel?10:3}).attr("cx",function(e){return x(e.x)}).attr("cy",function(e){return y(e.y)}).attr("fill",function(d){return d3.select(this.parentNode).datum().color}).attr("stroke-width","2px").on("mouseover",showPopup).on("mouseout",hidePopup).attr("stroke-opacity","1");pointlines.append("g").each(function(d){var g=d3.select(this);if(d.modelState==="FAILED"){g.append("line").attr("x1",-5).attr("y1",5).attr("x2",5).attr("y2",-5).attr("stroke",function(d){return d.color}).attr("stroke-width","3px");g.append("line").attr("x1",-5).attr("y1",-5).attr("x2",5).attr("y2",5).attr("stroke",function(d){return d.color}).attr("stroke-width","3px");g.attr("transform",function(d){return"translate("+x(d.xlast)+","+y(d.ylast)+")"})}else{if(!d.values[d.values.length-1].keptModel){g.append("circle").attr("cx",function(d){return x(d.xlast)}).attr("cy",function(d){return y(d.ylast)}).attr("stroke",function(d){return d.color}).attr("fill",function(d){return d.color}).attr("stroke-width","2px").attr("r",5).attr("class",function(d){return"end-circle "+d.modelState}).on("mouseover",function(d){showPopup(d.values[d.values.length-1])}).on("mouseout",hidePopup)}}})}function destroyKerasCurve(){d3.select("body").selectAll("div.gridsearch.tooltip").remove()}chartDirective("kerasEpochPerfCurve",{sessionId:"=",selectedModel:"=",evaluationMetricLowerIsBetter:"="},["sessionId","selectedModel"],function(scope,$filter){let testValues=[];let trainValues=[];let metric=scope.selectedModel.modelTrainingInfo.metric;scope.selectedModel.modelTrainingInfo.epochs.sort(function(a,b){return a.epoch-b.epoch}).forEach(function(epochPoint){const thisPointTrainTime=epochPoint.time/1e3;if(epochPoint.trainScore!==undefined){const trainScoreWithSign=scope.evaluationMetricLowerIsBetter?-epochPoint.trainScore:epochPoint.trainScore;trainValues.push({x:parseInt(epochPoint.epoch),y:trainScoreWithSign,time:thisPointTrainTime,epoch:epochPoint.epoch,type:"Train"})}if(epochPoint.testScore!==undefined){const testScoreWithSign=scope.evaluationMetricLowerIsBetter?-epochPoint.testScore:epochPoint.testScore;testValues.push({x:parseInt(epochPoint.epoch),y:testScoreWithSign,time:thisPointTrainTime,epoch:epochPoint.epoch,type:"Validation"})}});const modelState=scope.selectedModel.trainInfo.state;const data=[];let xlegend=$filter("mlMetricName")(metric,scope.selectedModel);if(!xlegend.toLowerCase().endsWith("score")&&!(xlegend.length>20)){xlegend+=" score"}if(trainValues.length){data.push({xlegend:xlegend,modelState:modelState,values:trainValues,xlast:trainValues[trainValues.length-1].x,ylast:trainValues[trainValues.length-1].y,color:"#00bcd4"})}if(testValues.length){let keptModelEpoch=modelState!=="ABORTED"&&modelState!=="FAILED"?scope.selectedModel.modelTrainingInfo.keptModelEpoch:-1;if(keptModelEpoch!==-1){testValues[keptModelEpoch].keptModel=true}data.push({xlegend:xlegend,modelState:modelState,values:testValues,xlast:testValues[testValues.length-1].x,ylast:testValues[testValues.length-1].y,color:"#4caf50"})}return data},drawKerasCurve,{},destroyKerasCurve);chartDirective("kerasEpochLossCurve",{sessionId:"=",selectedModel:"="},["sessionId","selectedModel"],function(scope){let testValues=[];let trainValues=[];scope.selectedModel.modelTrainingInfo.epochs.sort(function(a,b){return a.epoch-b.epoch}).forEach(function(epochPoint){const thisPointTrainTime=epochPoint.time/1e3;if(epochPoint.trainLoss!==undefined){trainValues.push({x:parseInt(epochPoint.epoch),y:epochPoint.trainLoss,time:thisPointTrainTime,epoch:epochPoint.epoch,type:"Train"})}if(epochPoint.testLoss!==undefined){testValues.push({x:parseInt(epochPoint.epoch),y:epochPoint.testLoss,time:thisPointTrainTime,epoch:epochPoint.epoch,type:"Validation"})}});const data=[];if(trainValues.length){data.push({xlegend:"Loss",modelState:scope.selectedModel.trainInfo.state,values:trainValues,xlast:trainValues[trainValues.length-1].x,ylast:trainValues[trainValues.length-1].y,color:"#00bcd4"})}if(testValues.length){data.push({xlegend:"Loss",modelState:scope.selectedModel.trainInfo.state,values:testValues,xlast:testValues[testValues.length-1].x,ylast:testValues[testValues.length-1].y,color:"#4caf50"})}return data},drawKerasCurve,{},destroyKerasCurve);app.directive("kerasEpochProgress",function(Fn,MLChartsCommon){return{scope:{sessionId:"=",allModels:"="},link:function(scope,element,attrs){let width,height,main,gradientArcIntervalID=null;const perEpochArc={radius:57,arcWidth:2,startAngle:0,endAngle:2*Math.PI};const globalArc={radius:68,arcWidth:4,startAngle:230*Math.PI/180,endAngle:2*Math.PI+130*Math.PI/180};function buildGraph(){let chart=d3.select(element.get(0)).html("");width=element.width();height=element.height();main=chart.append("g").attr("transform","translate("+width/2+","+height/2+")").attr("class","main");let text=main.append("text").attr("class","epoch-number").attr("fill","#ffffff").attr("text-anchor","middle");text.append("tspan").text("Epoch").attr("style","font-size: 18px;").attr("y",-15);text.append("tspan").attr("class","epoch-number").attr("style","font-size: 18px;").attr("y",5).attr("x",0);text.append("tspan").attr("class","epoch-progress").attr("style","font-size: 14px;").attr("y",25).attr("x",0);let backgroundArc=d3.svg.arc().innerRadius(function(d){return d.radius-d.arcWidth}).outerRadius(function(d){return d.radius}).startAngle(function(d){return d.startAngle}).endAngle(function(d){return d.endAngle});main.append("path").attr("class","arc-complementary").attr("fill","#708a97").attr("d",backgroundArc(globalArc));function getGradientArcData(numArcs,arc){const colorScale=d3.scale.linear().domain([0,.25,.5,.75,1]).range(["#5F7D8C","#AABFCA","#5F7D8C","#AABFCA","#5F7D8C"]);let data=[];for(let i=0;i<numArcs-1;i++){data[i]={i:i,radius:arc.radius,arcWidth:arc.arcWidth,color:colorScale(i/numArcs)}}return data}const numArcsInGradient=200;const gradientData=getGradientArcData(numArcsInGradient,perEpochArc);let gradientArc=d3.svg.arc().innerRadius(function(d){return d.radius-d.arcWidth}).outerRadius(function(d){return d.radius}).startAngle(function(d){return d.i/numArcsInGradient*2*Math.PI}).endAngle(function(d){return 1.01*(d.i+1)/numArcsInGradient*2*Math.PI});main.selectAll("path.gradient-arc").data(gradientData,function(d){return d.i}).enter().append("path").attr("class","gradient-arc").attr("fill",function(d){return d.color}).attr("d",gradientArc);if(gradientArcIntervalID!==null){clearInterval(gradientArcIntervalID)}gradientArcIntervalID=setInterval(function(){gradientData.forEach(function(d){d.i=(d.i+1)%numArcsInGradient});main.selectAll("path.gradient-arc").data(gradientData,function(d){return d.i}).attr("fill",function(d){return d.color}).attr("d",gradientArc)},10)}function getData(){let selectedModel=Object.values(scope.allModels).filter(function(snippet){return snippet.sessionId===scope.sessionId&&snippet.modelTrainingInfo})[0];const currentTraining=selectedModel.modelTrainingInfo.currentNumStepsTraining;const totalTraining=selectedModel.modelTrainingInfo.nbStepsTrainingPerEpoch;const currentScoring=selectedModel.modelTrainingInfo.currentNumStepsScoring;const totalScoring=selectedModel.modelTrainingInfo.nbStepsScoringPerEpoch;const shareTraining=90;const percentagePerEpoch=Math.floor(shareTraining*currentTraining/totalTraining+(100-shareTraining)*currentScoring/totalScoring);const currentEpoch=selectedModel.modelTrainingInfo.currentEpoch+1;const totalEpochs=selectedModel.modelTrainingInfo.nbEpochs;const percentageGlobal=Math.floor(100*(currentEpoch-1+percentagePerEpoch/100)/totalEpochs);return{currentEpoch:currentEpoch,totalEpochs:totalEpochs,percentagePerEpoch:percentagePerEpoch,percentageGlobal:percentageGlobal}}function customInterpolate(startArc,endArc){const start=startArc.percentage;let end=endArc.percentage;if(start>end){end+=100}const i=d3.interpolate(start,end);const newArcValue=angular.copy(startArc);return function(t){const newPercentage=i(t);newArcValue.percentage=newPercentage!=100?newPercentage%100:100;return newArcValue}}function arcTween(d){let interpolator=customInterpolate(this._current,d);this._current=interpolator(0);return function(t){return progressArc(interpolator(t))}}let progressArc=d3.svg.arc().innerRadius(function(d){return d.radius-d.arcWidth}).outerRadius(function(d){return d.radius}).startAngle(function(d){return d.minAngle}).endAngle(function(d){return d.minAngle+(d.maxAngle-d.minAngle)*d.percentage/100});const textPercentFormat=d3.format("02f");function drawMovingArcs(data){const arcs=[{type:"perEpoch",radius:57,arcWidth:2,minAngle:0,maxAngle:2*Math.PI,percentage:data.percentagePerEpoch},{type:"global",radius:68,arcWidth:4,minAngle:230*Math.PI/180,maxAngle:2*Math.PI+130*Math.PI/180,percentage:data.percentageGlobal}];main.selectAll("path.arc").data(arcs,function(d){return d.type}).enter().append("path").attr("class","arc").attr("fill","#ffffff").attr("d",progressArc).each(function(d){this._current=d});main.selectAll("path.arc").data(arcs,function(d){return d.type}).transition().duration(500).attrTween("d",arcTween);main.select("tspan.epoch-number").text(data.currentEpoch+"/"+data.totalEpochs);main.select("tspan.epoch-progress").text(textPercentFormat(data.percentagePerEpoch)+"%")}buildGraph();scope.$watch("allModels",function(nv){let data=getData();drawMovingArcs(data)},true);scope.$watch("sessionId",function(nv){let data=getData();drawMovingArcs(data)},true);MLChartsCommon.installRedrawListener(scope,function(){let data=getData();buildGraph();drawMovingArcs(data)})}}});chartDirective("bcRocCurve",{data:"=",colors:"=",loadedStateField:"=?",disableTransitions:"=?"},"data",function(scope){return scope.data.map(function(d,i,a){return{values:d,key:"Fold #"+(i+1),color:a.length>1?scope.colors[i]:"url(#ppg)"}})},function(scope,element){d3.selectAll(".nvtooltip").style("opacity","0");var width=element.width(),height=element.height(),margin={top:10,right:20,bottom:50,left:60},folds=scope.theData.length>1,chart=nv.models.lineChart().width(width).height(height).margin(margin).forceX([0,1]).forceY([0,1]).showLegend(false);chart.tooltip.contentGenerator(function(data){var p=parseFloat(data.point.p);return["<p>",folds?"<strong>"+data.series[0].key+"</strong><br>":"","At p = "+Math.round(p*100)/100,"</p>",'<ul class="unstyled" style="padding-left: 0.8em; padding-right: 0.8em;">',"  <li>",Math.round(parseFloat(data.point.y)*100),"% true  positive</li>","  <li>",Math.round(parseFloat(data.point.x)*100),"% false positive</li>","</ul>"].join("")});const svg=d3.select(element.get(0)).html("");chart.xAxis.axisLabel(scope.data.xlabel).tickFormat(d3.format("%"));chart.yAxis.axisLabel(scope.data.ylabel).tickFormat(d3.format("%"));chart.options({tooltip:{chartContainer:document.body}});svg.append("g").attr("class","mlchart-defaultbaseline").append("path").attr("d",["M",margin.left,",",height-margin.bottom," L",width-margin.right,",",margin.top].join(""));if(!folds){var colorScale=d3.scale.linear().range(scope.colors.slice(0,2));svg.append("linearGradient").attr("id","ppg").attr("gradientUnits","userSpaceOnUse").attr("x1","0%").attr("y1","100%").attr("x2","100%").attr("y2","0%").selectAll("stop").data(scope.theData[0].values).enter().append("stop").attr("offset",function(d){return Math.round((d.x+d.y)*(1-d.p)*50)+"%"}).attr("stop-color",function(d){return colorScale(d.p)})}let transitionDuration=500;if(scope.disableTransitions){console.info("Disabling chart transitions");chart.duration(0);transitionDuration=0}svg.datum(scope.theData).transition().duration(transitionDuration).call(chart);if(!folds){var legend=svg.append("g"),llg=legend.append("linearGradient").attr("id","ppgl");llg.append("stop").attr("offset","0%").attr("stop-color",colorScale(0));llg.append("stop").attr("offset","100%").attr("stop-color",colorScale(1));legend.attr("transform","translate("+(width-200)+","+(height-100)+")");legend.append("rect").attr("x",10).attr("y",5).attr("width",100).attr("height",20).attr("fill","url(#ppgl)");legend.append("text").text("Predicted proba.").attr("x",60).attr("text-anchor","middle");legend.append("text").text("0").attr("y",20);legend.append("text").text("1").attr("y",20).attr("x",115)}});chartDirective("bcPrCurve",{data:"=",colors:"=",loadedStateField:"=?",disableTransitions:"=?"},"data",function(scope){return scope.data.map(function(d,i,a){return{values:d.bins,key:"Fold #"+(i+1),color:a.length>1?scope.colors[i]:"url(#ppg)"}})},function(scope,element){d3.selectAll(".nvtooltip").style("opacity","0");var width=element.width(),height=element.height(),margin={top:10,right:20,bottom:50,left:60},folds=scope.theData.length>1,chart=nv.models.lineChart().width(width).height(height).margin(margin).forceX([0,1]).forceY([0,1]).showLegend(false);chart.tooltip.contentGenerator(function(data){var p=parseFloat(data.point.p);return["<p>",folds?"<strong>"+data.series[0].key+"</strong><br>":"","At p = "+Math.round(p*100)/100,"</p>",'<ul class="unstyled" style="padding-left: 0.8em; padding-right: 0.8em;">',"  <li>",Math.round(parseFloat(data.point.y)*100),"% Precision</li>","  <li>",Math.round(parseFloat(data.point.x)*100),"% Recall</li>","</ul>"].join("")});const svg=d3.select(element.get(0)).html("");chart.xAxis.axisLabel(scope.data.xlabel).tickFormat(d3.format("%"));chart.yAxis.axisLabel(scope.data.ylabel).tickFormat(d3.format("%"));chart.options({tooltip:{chartContainer:document.body}});for(let foldIndex=0;foldIndex<scope.data.length;foldIndex++){const positiveRate=scope.data[foldIndex].positiveRate;const xMin=margin.left,xMax=width-margin.right;const yMin=height-margin.bottom,yMax=margin.top;const yBaseline=yMin+(yMax-yMin)*positiveRate;const path=svg.append("g").attr("class","mlchart-defaultbaseline").append("path").attr("d",["M",xMin,",",yBaseline," L",xMax,",",yBaseline].join(""));if(folds){path.style("stroke",scope.colors[foldIndex])}}if(!folds){var colorScale=d3.scale.linear().range(scope.colors.slice(0,2));svg.append("linearGradient").attr("id","ppg").attr("x1","1").attr("y1","0").attr("x2","0").attr("y2","0").selectAll("stop").data(scope.theData[0].values).enter().append("stop").attr("offset",function(d,i){return Math.round((1-d.x)*100)+"%"}).attr("stop-color",function(d){return colorScale(d.p)})}let transitionDuration=500;if(scope.disableTransitions){console.info("Disabling chart transitions");chart.duration(0);transitionDuration=0}svg.datum(scope.theData).transition().duration(transitionDuration).call(chart);if(!folds){var legend=svg.append("g"),llg=legend.append("linearGradient").attr("id","ppgl");llg.append("stop").attr("offset","0%").attr("stop-color",colorScale(0));llg.append("stop").attr("offset","100%").attr("stop-color",colorScale(1));legend.attr("transform","translate("+(width-200)+","+(height-100)+")");legend.append("rect").attr("x",10).attr("y",5).attr("width",100).attr("height",20).attr("fill","url(#ppgl)");legend.append("text").text("Predicted proba.").attr("x",60).attr("text-anchor","middle");legend.append("text").text("0").attr("y",20);legend.append("text").text("1").attr("y",20).attr("x",115)}});chartDirective("calibrationScatterPlot",{data:"=",colors:"=",loadedStateField:"=?",disableTransitions:"=?"},"data",function(scope){var colorScale=d3.scale.linear().range(scope.colors.slice(0,2)).domain([0,1]);return[{values:scope.data[0].map(d=>{return{x:d.x,y:d.y,n:d.n,size:d.n,color:colorScale(Math.abs(2*(d.y-d.x)))}})}]},function(scope,element,$timeout){var width=element.width(),height=element.height(),margin={top:10,right:20,bottom:40,left:60},domain=[0,1],colorScale=d3.scale.linear().range(scope.colors.slice(0,2)).domain([0,1]),smoothLine=nv.models.lineChart().interpolate("basis").width(width).height(height).margin(margin).forceX(domain).forceY(domain).showLegend(false),scatterPlot=nv.models.scatterChart().width(width).height(height).margin(margin).forceX(domain).forceY(domain).showLegend(false).showXAxis(false).showYAxis(false),elt=element.get(0),svg=d3.select(elt).html("");let transitionDuration=500;if(scope.disableTransitions){console.info("Disabling chart transitions x2");scatterPlot.duration(0);smoothLine.duration(0);scatterPlot.xAxis.duration(0);smoothLine.xAxis.duration(0);scatterPlot.yAxis.duration(0);smoothLine.yAxis.duration(0);scatterPlot.distX.duration(0);scatterPlot.distY.duration(0);scatterPlot.scatter.duration(0);transitionDuration=0}const smoothData=scope.theData[0].values.map((d,i)=>{return{x:d.x,y:(d.n*d.y+10*d.x)/(d.n+10)}});smoothLine.tooltip.enabled(false);smoothLine.xAxis.axisLabel("Predicted probabilities");smoothLine.yAxis.axisLabel("Actual frequencies");svg.append("g").datum([{values:smoothData}]).transition().duration(transitionDuration).call(smoothLine);d3.selectAll("path").style("stroke-width","1");d3.selectAll(".nv-point-clips").style("visibility","hidden");scatterPlot.tooltip.contentGenerator(function(data){return['<ul class="unstyled" style="padding-left: 0.8em; padding-right: 0.8em; margin-top: 10px;">',"  <li><b>",Math.round(parseFloat(data.point.y)*100),"% </b> frequency of positives</li>","  <li><b>",Math.round(parseFloat(data.point.x)*100),"% </b> average probability of predicted positive</li>","  <li><b>",Math.round(parseFloat(data.point.n)),"</b> test elements in bin</li>","</ul>"].join("")});svg.datum(scope.theData).transition().duration(transitionDuration).call(scatterPlot);svg.append("g").datum(scope.theData).transition().duration(transitionDuration).call(scatterPlot);d3.selectAll(".nv-point").attr({fill:d=>d[0].color}).style("stroke-width","0").attr("stroke","url(#gradient)");svg.append("g").attr("class","calmedline").append("path").attr("d",["M",margin.left,",",height-margin.bottom," L",width-margin.right,",",margin.top].join("")).style("stroke",scope.colors[0]).style("stroke-width","1").style("stroke-dasharray","3");var legend=svg.append("g"),llg=legend.append("linearGradient").attr("id","ppgl");llg.append("stop").attr("offset","0%").attr("stop-color",colorScale(0));llg.append("stop").attr("offset","100%").attr("stop-color",colorScale(1));legend.attr("transform","translate("+(width-200)+","+(height-100)+")");legend.append("rect").attr("x",10).attr("y",5).attr("width",100).attr("height",20).attr("fill","url(#ppgl)");legend.append("text").text("Calibration loss").attr("x",60).attr("text-anchor","middle");legend.append("text").text("0").attr("y",20);legend.append("text").text("0.5").attr("y",20).attr("x",115)});chartDirective("rScatterPlot",{data:"=",colors:"=",loadedStateField:"=?",disableTransitions:"=?"},"data",function(scope){var errors=scope.data.x.map(function(x,i){return Math.abs(x-this[i])},scope.data.y),maxErr=d3.max(errors),colorScale=d3.scale.linear().range(["green","orange","red"]).domain([0,maxErr/2,maxErr]);return[{key:"Values",values:scope.data.x.map((x,i)=>{return{x:x,y:scope.data.y[i],error:errors[i],color:colorScale(errors[i])}})}]},function(scope,element,$timeout){var all=[].concat.apply(scope.data.x,scope.data.y);var width=element.width(),height=element.height(),margin={top:10,right:20,bottom:40,left:60},fmt=d3.format(".3s"),domain=[d3.min(all),d3.max(all)],chart=nv.models.scatterChart().width(width).height(height).margin(margin).forceX(domain).forceY(domain).showLegend(false),elt=element.get(0),svg=d3.select(elt).html("");chart.tooltip.contentGenerator(function(data){return["<p>Error = "+fmt(data.point.error),"</p>"].join("")});chart.xAxis.axisLabel("Actual values").tickFormat(fmt);chart.yAxis.axisLabel("Predicted values").tickFormat(fmt);let transitionDuration=500;if(scope.disableTransitions){console.info("Disabling chart transitions x2");chart.duration(0);chart.xAxis.duration(0);chart.yAxis.duration(0);chart.distX.duration(0);chart.distY.duration(0);chart.scatter.duration(0);transitionDuration=0}svg.datum(scope.theData).transition().duration(transitionDuration).call(chart);svg.append("g").datum(scope.theData).transition().duration(transitionDuration).call(chart);svg.append("g").attr("class","mlchart-defaultbaseline").append("path").attr("d",["M",margin.left,",",height-margin.bottom,"L",width-margin.right,",",margin.top].join(""));d3.selectAll(".nv-point").attr({fill:d=>d[0].color})});chartDirective("categoriesHeatmap",{x:"=",y:"=",values:"=",xLabel:"=",yLabel:"=",valuesLabel:"=",callback:"=?",hideTooltip:"=?",hideLegend:"=?",hideXLabel:"=?",hideYLabel:"=?",hideValuesLabel:"=?"},"[x, y, values]",function(scope,Fn){if(!scope.x||!scope.y||!scope.values||!scope.xLabel||!scope.yLabel||!scope.valuesLabel){return null}scope.callback=typeof scope.callback==="function"?scope.callback:Fn.NOOP;return scope.x.map((xVal,i)=>({x:xVal,y:scope.y[i],value:scope.values[i]}))},function(scope,element,MLChartsCommon){element.css("position","relative");let minValue=Math.min(...scope.values),maxValue=Math.max(...scope.values);let fullWidth=element.width();let fullHeight=element.height();let legendFullWidth=!scope.hideLegend?57:0;let margin={top:15,right:15,bottom:40,left:55};let width=fullWidth-margin.left-margin.right-legendFullWidth;let height=fullHeight-margin.top-margin.bottom;let elt=element.get(0);let containerSvg=d3.select(elt).html("").append("svg").attr("width",fullWidth).attr("height",fullHeight);let svg=containerSvg.append("g").attr("transform",`translate(${margin.left}, ${margin.top})`);let xScale=buildXScaleAxis();let yScale=buildYScaleAxis();let colorScaleArray=["#f7fcf0","#e0f3db","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe","#0868ac","#084081"];const valueslog=minValue>0&&maxValue/minValue>10;let colorScale=d3.scale.linear().range(colorScaleArray);if(valueslog){colorScale.domain(MLChartsCommon.linspace(Math.log10(minValue),Math.log10(maxValue),colorScaleArray.length))}else{colorScale.domain(MLChartsCommon.linspace(minValue,maxValue,colorScaleArray.length))}if(!scope.hideLegend){let legendMargin={top:25,right:37,bottom:50,left:12};let legendWidth=legendFullWidth-legendMargin.left-legendMargin.right;let legendHeight=fullHeight-legendMargin.top-legendMargin.bottom;let legendSvg=containerSvg.append("g").attr("transform",`translate(${margin.left+width+margin.right}, 0)`);let nVerticalTicks=Math.floor(fullHeight/100)+3;MLChartsCommon.makeColorScale(legendSvg,legendWidth,legendHeight,legendMargin,nVerticalTicks,colorScaleArray,minValue,maxValue,valueslog,scope.valuesLabel,scope.hideValuesLabel)}drawRectsAndTooltip(svg,scope.xLabel,scope.yLabel,scope.valuesLabel,scope.theData,xScale,yScale,colorScale,margin,scope.hideTooltip);scope.callback(svg,scope);function buildXScaleAxis(){let xUnique=d3.map(scope.theData,d=>d.x).keys();let xScale=d3.scale.ordinal().domain(xUnique).rangeRoundBands([0,width],.05);let xAxis=svg.append("g").attr("transform",`translate(0, ${height})`).call(d3.svg.axis().scale(xScale).orient("bottom").tickSize(0));xAxis.selectAll("text").style("text-anchor","middle");xAxis.select(".domain").remove();if(!scope.hideXLabel){svg.append("text").style("text-anchor","middle").attr("x",.5*width).attr("y",height+30).style("font-weight","bold").text(scope.xLabel)}return xScale}function buildYScaleAxis(){let yUnique=d3.map(scope.theData,d=>d.y).keys();let yScale=d3.scale.ordinal().domain(yUnique).rangeRoundBands([height,0],.05);let yAxis=svg.append("g").attr("transform","translate(-7, 0)").call(d3.svg.axis().scale(yScale).orient("left").tickSize(0));yAxis.selectAll("text").attr("transform","rotate(-90)").style("text-anchor","middle");yAxis.select(".domain").remove();if(!scope.hideYLabel){svg.append("g").attr("transform",`translate(${-.5*margin.left}, ${.5*height})`).append("text").style("text-anchor","middle").style("font-weight","bold").attr("transform","rotate(-90)").text(scope.yLabel)}return yScale}function drawRectsAndTooltip(svg,xLabel,yLabel,valuesLabel,theData,xScale,yScale,colorScale,margin,hideTooltip){svg.selectAll().data(theData,function(d){return d.x+":"+d.y}).enter().append("rect").attr("x",function(d){return xScale(d.x)}).attr("y",function(d){return yScale(d.y)}).attr("rx",4).attr("ry",4).attr("width",xScale.rangeBand()).attr("height",yScale.rangeBand()).style("fill",function(d){return colorScale(d.value)}).style("stroke-width",4).style("stroke","none").style("opacity",.8);if(!hideTooltip){const tooltipNumericFormat=MLChartsCommon.makeTooltipNumericFormatter(3,4);const tooltip=d3.select(elt).append("div").style("opacity",0).style("background-color","rgba(255,255,255,0.9)").style("border","solid").style("border-width","1px").style("border-radius","5px").style("position","absolute").style("padding","5px");const getTooltipHtml=function(x,y,value,xLabel,yLabel,valuesLabel){return`
                        <table class="mlchart-tooltip__table">
                            <tr>
                                <td class="mlchart-tooltip__label">${valuesLabel}</td>
                                <td class="mlchart-tooltip__value">${value}</td>
                            </tr>
                            <tr>
                                <td class="mlchart-tooltip__label">${xLabel}</td>
                                <td class="mlchart-tooltip__value">${x}</td>
                            </tr>
                            <tr>
                                <td class="mlchart-tooltip__label">${yLabel}</td>
                                <td class="mlchart-tooltip__value">${y}</td>
                            </tr>
                        </table>`};const mouseover=function(d){tooltip.html(getTooltipHtml(d.x,d.y,tooltipNumericFormat(d.value),xLabel?xLabel:"x",yLabel?yLabel:"y",valuesLabel?valuesLabel:"value")).style("opacity",1);d3.select(this).style("stroke","black")};const mousemove=function(d){let mousePosition=d3.mouse(this);let distance=5;let leftOffset=-.7*tooltip.node().offsetWidth+margin.left-distance;let topOffset=-tooltip.node().offsetHeight+margin.top-distance;if(mousePosition[0]+leftOffset<0){leftOffset=-.3*tooltip.node().offsetWidth+margin.left+distance}if(mousePosition[1]+topOffset<0){topOffset=margin.top+distance}tooltip.style("left",mousePosition[0]+leftOffset+"px").style("top",mousePosition[1]+topOffset+"px")};const mouseleave=function(d){tooltip.style("opacity",0).style("left","0").style("top","0").html("");d3.select(this).style("stroke","none")};svg.selectAll("rect").on("mouseover",mouseover).on("mousemove",mousemove).on("mouseleave",mouseleave)}}});chartDirective("contourPlot",{x:"=",y:"=",values:"=",xLabel:"=",yLabel:"=",valuesLabel:"=",nContours:"=?",callback:"=?",hideLegend:"=?",hidePoints:"=?",hideXLabel:"=?",hideYLabel:"=?",hideValuesLabel:"=?"},"[x, y, values]",function(scope,Fn){if(!scope.x||!scope.y||!scope.values||!scope.xLabel||!scope.yLabel||!scope.valuesLabel){return null}scope.nContours=typeof scope.nContours==="number"?scope.nContours:15;scope.callback=typeof scope.callback==="function"?scope.callback:Fn.NOOP;return scope.x.map((xVal,i)=>({x:xVal,y:scope.y[i],value:scope.values[i]}))},function(scope,element,ContourPlotFactory,MLChartsCommon){element.css("position","relative");let minValue=Math.min(...scope.values);let maxValue=Math.max(...scope.values);let fullWidth=element.width();let fullHeight=element.height();let legendFullWidth=!scope.hideLegend?57:0;let margin={top:15,right:15,bottom:40,left:55};let width=fullWidth-margin.left-margin.right-legendFullWidth;let height=fullHeight-margin.top-margin.bottom;let elt=element.get(0);let containerSvg=d3.select(elt).html("").append("svg").attr("width",fullWidth).attr("height",fullHeight);let svg=containerSvg.append("g").attr("transform",`translate(${margin.left}, ${margin.top})`);let nHorizontalTicks=Math.floor(fullWidth/100)+2;let nVerticalTicks=Math.floor(fullHeight/100)+3;let buildAxis=function(data,nTicks,size,vertical){const min=Math.min(...data);const max=Math.max(...data);const numericFormat=MLChartsCommon.makeAxisNumericFormatter(min,max,3,1);const isLog=min>0&&max/min>10;const rangeInterval=vertical?[size,0]:[0,size];const domainInterval=isLog?[Math.log10(min),Math.log10(max)]:[min,max];const scale=d3.scale.linear().range(rangeInterval).domain(domainInterval);const tickFormat=isLog?_=>numericFormat(10**_):numericFormat;let axis=d3.svg.axis().scale(scale).tickSize(4).ticks(nTicks).tickFormat(tickFormat);if(vertical){axis.orient("left")}return{axis:axis,isLog:isLog,scale:scale}};const xAxis=buildAxis(scope.x,nHorizontalTicks,width,false);let xAxisSvg=svg.append("g").attr("transform",`translate(0, ${height})`).call(xAxis.axis);xAxisSvg.select(".domain").remove();xAxisSvg.selectAll("line").style("stroke","black");if(!scope.hideXLabel){svg.append("text").style("text-anchor","middle").attr("x",.5*width).attr("y",height+30).style("font-weight","bold").text(xAxis.isLog?`${scope.xLabel} (log)`:scope.xLabel)}const yAxis=buildAxis(scope.y,nVerticalTicks,height,true);let yAxisSvg=svg.append("g").attr("transform","translate(0, 0)").call(yAxis.axis);yAxisSvg.select(".domain").remove();yAxisSvg.selectAll("line").style("stroke","black");if(!scope.hideYLabel){svg.append("g").attr("transform",`translate(-43, ${.5*height})`).append("text").style("text-anchor","middle").style("font-weight","bold").attr("transform","rotate(-90)").text(yAxis.isLog?`${scope.yLabel} (log)`:scope.yLabel)}let colorScaleArray=["#f7fcf0","#e0f3db","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe","#0868ac","#084081"];const valueslog=minValue>0&&maxValue/minValue>10;let colorScale=d3.scale.linear().range(colorScaleArray);if(valueslog){colorScale.domain(MLChartsCommon.linspace(Math.log10(minValue),Math.log10(maxValue),colorScaleArray.length))}else{colorScale.domain(MLChartsCommon.linspace(minValue,maxValue,colorScaleArray.length))}if(!scope.hideLegend){let legendMargin={top:25,right:37,bottom:50,left:12};let legendWidth=legendFullWidth-legendMargin.left-legendMargin.right;let legendHeight=fullHeight-legendMargin.top-legendMargin.bottom;let legendSvg=containerSvg.append("g").attr("transform",`translate(${margin.left+width+margin.right}, 0)`);MLChartsCommon.makeColorScale(legendSvg,legendWidth,legendHeight,legendMargin,nVerticalTicks,colorScaleArray,minValue,maxValue,valueslog,scope.valuesLabel,scope.hideValuesLabel)}ContourPlotFactory.drawContours(svg,scope.x,scope.y,scope.values,xAxis.isLog,yAxis.isLog,valueslog,width,height,colorScale,scope.nContours);if(!scope.hidePoints){let tooltip=d3.select(elt).append("div").style("opacity",0).style("background-color","rgba(255,255,255,0.9)").style("border","solid").style("border-width","1px").style("border-radius","5px").style("position","absolute").style("padding","5px");drawPointsWithTooltip(svg,tooltip,scope.xLabel,scope.yLabel,scope.valuesLabel,scope.theData,margin,xAxis,yAxis)}scope.callback(svg,scope);function drawPointsWithTooltip(svg,tooltip,xLabel,yLabel,valuesLabel,theData,margin,xAxis,yAxis){let tooltipNumericFormat=MLChartsCommon.makeTooltipNumericFormatter(3,4);let getTooltipHtml=function(x,y,value,xLabel,yLabel,valuesLabel){return`
                    <table class="mlchart-tooltip__table">
                        <tr>
                            <td class="mlchart-tooltip__label">${valuesLabel}</td>
                            <td class="mlchart-tooltip__value">${value}</td>
                        </tr>
                        <tr>
                            <td class="mlchart-tooltip__label">${xLabel}</td>
                            <td class="mlchart-tooltip__value">${x}</td>
                        </tr>
                        <tr>
                            <td class="mlchart-tooltip__label">${yLabel}</td>
                            <td class="mlchart-tooltip__value">${y}</td>
                        </tr>
                    </table>`};let mouseover=function(d){tooltip.html(getTooltipHtml(tooltipNumericFormat(d.x),tooltipNumericFormat(d.y),tooltipNumericFormat(d.value),xLabel?xLabel:"x",yLabel?yLabel:"y",valuesLabel?valuesLabel:"value")).style("opacity",1);d3.select(this).attr("r",5).style("stroke","white")};let mousemove=function(d){let mousePosition=d3.mouse(this);let distance=5;let leftOffset=-.7*tooltip.node().offsetWidth+margin.left-distance;let topOffset=-tooltip.node().offsetHeight+margin.top-distance;if(mousePosition[0]+leftOffset<0){leftOffset=-.3*tooltip.node().offsetWidth+margin.left+distance}if(mousePosition[1]+topOffset<0){topOffset=margin.top+distance}tooltip.style("left",mousePosition[0]+leftOffset+"px").style("top",mousePosition[1]+topOffset+"px")};let mouseleave=function(d){tooltip.style("opacity",0).style("left","0").style("top","0").html("");d3.select(this).attr("r",3).style("stroke","none")};svg.selectAll(".dot").data(theData).enter().append("circle").attr("r",3).attr("cx",d=>xAxis.isLog?xAxis.scale(Math.log10(d.x)):xAxis.scale(d.x)).attr("cy",d=>yAxis.isLog?yAxis.scale(Math.log10(d.y)):yAxis.scale(d.y)).style("fill","black").style("opacity",.7).style("stroke-width",1.5).on("mouseover",mouseover).on("mousemove",mousemove).on("mouseleave",mouseleave)}});chartDirective("univariateDataDistributionChart",{data:"=",colors:"="},"data",function(scope){let binNames;if(scope.data.binNames){binNames=scope.data.binNames.slice();binNames.push("Others")}return{binNames:binNames,binCounts:[scope.data.binCountsCurrent,scope.data.binCountsReference].map((serial,i)=>{let sum=serial.reduce((acc,curr)=>acc+curr,0);return{values:serial.map((v,j)=>{return{value:v/sum,count:v,category:binNames?binNames[j]:undefined,binIndex:j}}),key:i?"Reference":"Current",color:scope.colors[i]}}),binEdges:scope.data.binEdges}},function(scope,element){let width=element.width(),height=element.height(),margin={top:5,right:5,bottom:5,left:5},max=scope.theData.binCounts.reduce((acc,curr)=>Math.max(acc,curr.values.reduce((acc2,curr2)=>Math.max(acc2,curr2.value),0)),0);let binX;if(scope.theData.binNames){binX=scope.theData.binNames}else{binX=[];for(let i=0;i<scope.theData.binEdges.length-1;i++){binX.push(((scope.theData.binEdges[i]+scope.theData.binEdges[i+1])/2).toFixed(2))}}let chart=nv.models.multiBarChart().width(width).height(height).margin(margin).x((_,i)=>binX[i]).y(d=>d.value).staggerLabels(false).showControls(false).showLegend(false).forceY([0,max]).showXAxis(false).showYAxis(false).wrapLabels(true);let svg=d3.select(element.get(0)).html("");chart.tooltip.contentGenerator(function(data){if(scope.theData.binNames){return["<p><strong>Origin:</strong>&nbsp;"+data.data.key+"</p>","<p><strong>Category:</strong>&nbsp;"+data.data.category+"</p>","<p><strong>Count:</strong>&nbsp;"+data.data.count+"</p>","<p><strong>%:</strong>&nbsp;"+(data.data.value*100).toFixed(2)+"</p>"].join("")}else{return["<p><strong>Origin:</strong>&nbsp;"+data.data.key+"</p>","<p><strong>Bin:</strong>&nbsp;"+scope.theData.binEdges[data.data.binIndex]+" - "+scope.theData.binEdges[data.data.binIndex+1]+"</p>","<p><strong>Count:</strong>&nbsp;"+data.data.count+"</p>","<p><strong>%:</strong>&nbsp;"+(data.data.value*100).toFixed(2)+"</p>"].join("")}});chart.options({tooltip:{chartContainer:document.body}});svg.datum(scope.theData.binCounts).transition().duration(100).call(chart)})})();(function(){"use strict";const app=angular.module("dataiku.ml.gpuexecution",[]);app.constant("GPU_SUPPORTING_CAPABILITY",{KERAS:"KERAS",GLUONTS:"GLUONTS",DEEP_HUB:"DEEP_HUB",DEEP_NN:"DEEP_NN",XGBOOST:"XGBOOST",SENTENCE_EMBEDDING:"SENTENCE_EMBEDDING",TABICL:"TABICL"});app.service("GpuUsageService",function($filter,DataikuAPI,$stateParams,GPU_SUPPORTING_CAPABILITY,$q){this.getEnvSupportsGpu=getEnvSupportsGpu;this.checkGpuUsability=checkGpuUsability;this.getCurrentEnvName=getCurrentEnvName;this.getAvailableGpuCapabilities=getAvailableGpuCapabilities;this.allowChangingMode=allowChangingMode;const CAPABILITIES={[GPU_SUPPORTING_CAPABILITY.KERAS]:{supportsMultiple:true,name:"Deep Learning Training",supportsDeviceTypeChange:true},[GPU_SUPPORTING_CAPABILITY.GLUONTS]:{supportsMultiple:false,name:"Time Series Training",supportsDeviceTypeChange:false},[GPU_SUPPORTING_CAPABILITY.DEEP_HUB]:{supportsMultiple:true,name:"Computer Vision Training",supportsDeviceTypeChange:true},[GPU_SUPPORTING_CAPABILITY.DEEP_NN]:{supportsMultiple:false,name:"Deep Neural Network Training",supportsDeviceTypeChange:false},[GPU_SUPPORTING_CAPABILITY.XGBOOST]:{supportsMultiple:false,name:"XGBoost Training",supportsDeviceTypeChange:false},[GPU_SUPPORTING_CAPABILITY.SENTENCE_EMBEDDING]:{supportsMultiple:false,name:"Text Embedding (Code env based)",supportsDeviceTypeChange:false},[GPU_SUPPORTING_CAPABILITY.TABICL]:{supportsMultiple:false,name:"TabICL Training",supportsDeviceTypeChange:false}};this.CAPABILITIES=CAPABILITIES;function getAvailableGpuCapabilities(backendType,predictionType){const availableGpuCapabilities=[];if(backendType==="KERAS"){availableGpuCapabilities.push(GPU_SUPPORTING_CAPABILITY.KERAS,GPU_SUPPORTING_CAPABILITY.SENTENCE_EMBEDDING)}else if(backendType==="DEEP_HUB"){availableGpuCapabilities.push(GPU_SUPPORTING_CAPABILITY.DEEP_HUB)}else if(backendType==="PY_MEMORY"){if(predictionType==="TIMESERIES_FORECAST"){availableGpuCapabilities.push(GPU_SUPPORTING_CAPABILITY.GLUONTS)}else{availableGpuCapabilities.push(GPU_SUPPORTING_CAPABILITY.DEEP_NN);availableGpuCapabilities.push(GPU_SUPPORTING_CAPABILITY.XGBOOST);availableGpuCapabilities.push(GPU_SUPPORTING_CAPABILITY.TABICL)}availableGpuCapabilities.push(GPU_SUPPORTING_CAPABILITY.SENTENCE_EMBEDDING)}return availableGpuCapabilities}function allowChangingMode(isScoreOrEval,gpuCapabilities){if(isScoreOrEval){return gpuCapabilities.every(capability=>CAPABILITIES[capability].supportsDeviceTypeChange)}return true}function getCurrentEnvName(selectedEnvName,envMode,defaultEnvName){let currentEnvName=null;if(envMode){if(envMode==="INHERIT"){currentEnvName=defaultEnvName}else if(envMode==="EXPLICIT_ENV"){currentEnvName=selectedEnvName}}else{currentEnvName=selectedEnvName}return currentEnvName}function checkGpuUsability(gpuCapabilities,forceSingleGpu){const singleGpuCapabilities=[];const multipleGpuCapabilities=[];let possibleUsageWarning="";if(gpuCapabilities.length===0){return{singleGpuOnly:false,possibleUsageWarning:possibleUsageWarning}}gpuCapabilities.forEach(key=>{const multiple=CAPABILITIES[key].supportsMultiple;if(multiple){multipleGpuCapabilities.push(CAPABILITIES[key].name)}else{singleGpuCapabilities.push(CAPABILITIES[key].name)}});if(singleGpuCapabilities.length&&multipleGpuCapabilities.length&&!forceSingleGpu){const multiString=$filter("andList")(multipleGpuCapabilities);const singleString=$filter("andList")(singleGpuCapabilities);possibleUsageWarning=`Multiple GPU's are only supported for ${multiString}. ${singleString} will use the first selected GPU.`}return{singleGpuOnly:forceSingleGpu||!multipleGpuCapabilities.length,possibleUsageWarning:possibleUsageWarning}}function getEnvSupportsGpu(isAutomationNode,gpuCapabilities,currentEnvName){const deferred=$q.defer();const isKeras=gpuCapabilities.includes(GPU_SUPPORTING_CAPABILITY.KERAS);const isTimeseries=gpuCapabilities.includes(GPU_SUPPORTING_CAPABILITY.GLUONTS);const isXgboost=gpuCapabilities.includes(GPU_SUPPORTING_CAPABILITY.XGBOOST);if(isAutomationNode){deferred.resolve(true);return deferred.promise}if(isKeras||isTimeseries){if(currentEnvName){DataikuAPI.codeenvs.listWithVisualMlPackages($stateParams.projectKey).then(function({data}){let envSupportsGpu=true;const env=data.envs.find(el=>el.envName===currentEnvName);if(isKeras){envSupportsGpu=env&&env.keras.supportsGpu}else if(isTimeseries){envSupportsGpu=env&&(env.timeseries.supportsGpu||env.mxnetTimeseries.supportsGpu||env.torchTimeseries.supportsGpu)}deferred.resolve(envSupportsGpu)})}else{deferred.resolve(false)}}else{deferred.resolve(true)}return deferred.promise}});app.component("gpuCapabilityForm",{templateUrl:"/templates/analysis/mlcommon/settings/gpu-capability-form.html",bindings:{availableGpuCapabilities:"<",usedGpuCapabilities:"<",gpuConfig:"=",onSelectedChange:"&?"},controller:function($scope,GpuUsageService){const $ctrl=this;$ctrl.GpuUsageService=GpuUsageService;$ctrl.toggleSelection=function(item){const disabledCapabilitiesSet=new Set($ctrl.gpuConfig.disabledCapabilities);if(disabledCapabilitiesSet.has(item)){disabledCapabilitiesSet.delete(item)}else{disabledCapabilitiesSet.add(item)}$ctrl.gpuConfig.disabledCapabilities=[...disabledCapabilitiesSet];if(angular.isFunction($ctrl.onSelectedChange)){$ctrl.onSelectedChange()}};$ctrl.capabilityToId=function(gpuCapability){let idString="gpu_control_"+gpuCapability.toLowerCase();idString.replace("_","-");return idString};$ctrl.isUsed=function(gpuCapability){const usedGpuCapabilitiesSet=new Set($ctrl.usedGpuCapabilities);return usedGpuCapabilitiesSet.has(gpuCapability)}}})})();(function(){"use strict";var app=angular.module("dataiku.ml.core");app.factory("ContourPlotFactory",function(){let contourPlotFactory={drawContours:drawContours};function drawContours(svg,x,y,z,xlog,ylog,zlog,width,height,colorScale,nContours){if(xlog){x=x.map(Math.log10)}if(ylog){y=y.map(Math.log10)}if(zlog){z=z.map(Math.log10)}let{xUnique,yUnique,zGrid}=interpolateGrid(x,y,z);let contours=setContours(Math.min(...z),Math.max(...z),nContours);let xaxis={width:width,range:[Math.min(...xUnique),Math.max(...xUnique)],letter:"x"};let yaxis={height:height,range:[Math.min(...yUnique),Math.max(...yUnique)],letter:"y"};let pathinfo=emptyPathinfo(contours,xaxis,yaxis,xUnique,yUnique,zGrid,1);makeCrossings(pathinfo);findAllPaths(pathinfo);let leftedge=c2p(xaxis)(xUnique[0],true);let rightedge=c2p(xaxis)(xUnique[xUnique.length-1],true);let bottomedge=c2p(yaxis)(yUnique[0],true);let topedge=c2p(yaxis)(yUnique[yUnique.length-1],true);let perimeter=[[leftedge,topedge],[rightedge,topedge],[rightedge,bottomedge],[leftedge,bottomedge]];makeBackground(svg,perimeter);makeFills(svg,pathinfo,perimeter,colorScale)}function interpolateGrid(x,y,z){let xUnique=x.concat().sort((a,b)=>a-b).filter(function(el,i,a){return i===a.indexOf(el)}),yUnique=y.concat().sort((a,b)=>a-b).filter(function(el,i,a){return i===a.indexOf(el)}),zGrid=new Array(yUnique.length),xHash={},yHash={};for(let row=0;row<zGrid.length;row++){zGrid[row]=new Array(xUnique.length)}for(let idx=0;idx<x.length;idx++){xHash[x[idx]]=xHash[x[idx]]!==undefined?xHash[x[idx]]:xUnique.indexOf(x[idx]);yHash[y[idx]]=yHash[y[idx]]!==undefined?yHash[y[idx]]:yUnique.indexOf(y[idx]);let row=yHash[y[idx]],col=xHash[x[idx]];zGrid[row][col]=z[idx]}let empties=findEmpties(zGrid);return{xUnique:xUnique,yUnique:yUnique,zGrid:interp2d(zGrid,empties)}}function findEmpties(z){var empties=[];var neighborHash={};var noNeighborList=[];var nextRow=z[0];var row=[];var blank=[0,0,0];var rowLength=z[0].length;var prevRow;var i;var j;var thisPt;var p;var neighborCount;var newNeighborHash;var foundNewNeighbors;for(i=0;i<z.length;i++){prevRow=row;row=nextRow;nextRow=z[i+1]||[];for(j=0;j<rowLength;j++){if(row[j]===undefined){neighborCount=(row[j-1]!==undefined?1:0)+(row[j+1]!==undefined?1:0)+(prevRow[j]!==undefined?1:0)+(nextRow[j]!==undefined?1:0);if(neighborCount){if(i===0)neighborCount++;if(j===0)neighborCount++;if(i===z.length-1)neighborCount++;if(j===row.length-1)neighborCount++;if(neighborCount<4){neighborHash[[i,j]]=[i,j,neighborCount]}empties.push([i,j,neighborCount])}else noNeighborList.push([i,j])}}}while(noNeighborList.length){newNeighborHash={};foundNewNeighbors=false;for(p=noNeighborList.length-1;p>=0;p--){thisPt=noNeighborList[p];i=thisPt[0];j=thisPt[1];neighborCount=((neighborHash[[i-1,j]]||blank)[2]+(neighborHash[[i+1,j]]||blank)[2]+(neighborHash[[i,j-1]]||blank)[2]+(neighborHash[[i,j+1]]||blank)[2])/20;if(neighborCount){newNeighborHash[thisPt]=[i,j,neighborCount];noNeighborList.splice(p,1);foundNewNeighbors=true}}if(!foundNewNeighbors){throw"findEmpties iterated with no new neighbors"}for(thisPt in newNeighborHash){neighborHash[thisPt]=newNeighborHash[thisPt];empties.push(newNeighborHash[thisPt])}}return empties.sort(function(a,b){return b[2]-a[2]})}var INTERPTHRESHOLD=.01;var NEIGHBORSHIFTS=[[-1,0],[1,0],[0,-1],[0,1]];function correctionOvershoot(maxFractionalChange){return.5-.25*Math.min(1,maxFractionalChange*.5)}function interp2d(z,emptyPoints){var maxFractionalChange=1;var i;iterateInterp2d(z,emptyPoints);for(i=0;i<emptyPoints.length;i++){if(emptyPoints[i][2]<4)break}emptyPoints=emptyPoints.slice(i);for(i=0;i<100&&maxFractionalChange>INTERPTHRESHOLD;i++){maxFractionalChange=iterateInterp2d(z,emptyPoints,correctionOvershoot(maxFractionalChange))}return z}function iterateInterp2d(z,emptyPoints,overshoot){var maxFractionalChange=0;var thisPt;var i;var j;var p;var q;var neighborShift;var neighborRow;var neighborVal;var neighborCount;var neighborSum;var initialVal;var minNeighbor;var maxNeighbor;for(p=0;p<emptyPoints.length;p++){thisPt=emptyPoints[p];i=thisPt[0];j=thisPt[1];initialVal=z[i][j];neighborSum=0;neighborCount=0;for(q=0;q<4;q++){neighborShift=NEIGHBORSHIFTS[q];neighborRow=z[i+neighborShift[0]];if(!neighborRow)continue;neighborVal=neighborRow[j+neighborShift[1]];if(neighborVal!==undefined){if(neighborSum===0){minNeighbor=maxNeighbor=neighborVal}else{minNeighbor=Math.min(minNeighbor,neighborVal);maxNeighbor=Math.max(maxNeighbor,neighborVal)}neighborCount++;neighborSum+=neighborVal}}if(neighborCount===0){throw"iterateInterp2d order is wrong: no defined neighbors"}z[i][j]=neighborSum/neighborCount;if(initialVal===undefined){if(neighborCount<4)maxFractionalChange=1}else{z[i][j]=(1+overshoot)*z[i][j]-overshoot*initialVal;if(maxNeighbor>minNeighbor){maxFractionalChange=Math.max(maxFractionalChange,Math.abs(z[i][j]-initialVal)/(maxNeighbor-minNeighbor))}}}return maxFractionalChange}function setContours(zmin,zmax,ncontours){function roundUp(val,arrayIn,reverse){var low=0;var high=arrayIn.length-1;var mid;var c=0;var dlow=reverse?0:1;var dhigh=reverse?1:0;var rounded=reverse?Math.ceil:Math.floor;while(low<high&&c++<100){mid=rounded((low+high)/2);if(arrayIn[mid]<=val)low=mid+dlow;else high=mid-dhigh}return arrayIn[low]}let roundBase10=[2,5,10];let contours={};let roughContourSize=(zmax-zmin)/ncontours;let base=Math.pow(10,Math.floor(Math.log(roughContourSize)/Math.LN10));contours.size=base*roundUp(roughContourSize/base,roundBase10);contours.start=zmin-contours.size;contours.end=zmax+contours.size/1e6;if(contours.start>contours.end){contours.start=contours.end=(contours.start+contours.end)/2}return contours}function emptyPathinfo(contours,xaxis,yaxis,xUnique,yUnique,zGrid,smoothing){setScale(xaxis);setScale(yaxis);var pathinfo=[];for(var ci=contours.start;ci<contours.end;ci+=contours.size){pathinfo.push({level:ci,crossings:{},starts:[],edgepaths:[],paths:[],x:xUnique,y:yUnique,xaxis:xaxis,yaxis:yaxis,z:zGrid,smoothing:smoothing});if(pathinfo.length>1e3){break}}return pathinfo}var constants={BOTTOMSTART:[1,9,13,104,713],TOPSTART:[4,6,7,104,713],LEFTSTART:[8,12,14,208,1114],RIGHTSTART:[2,3,11,208,1114],NEWDELTA:[null,[-1,0],[0,-1],[-1,0],[1,0],null,[0,-1],[-1,0],[0,1],[0,1],null,[0,1],[1,0],[1,0],[0,-1]],CHOOSESADDLE:{104:[4,1],208:[2,8],713:[7,13],1114:[11,14]},SADDLEREMAINDER:{1:4,2:8,4:1,7:13,8:2,11:14,13:7,14:11}};function makeCrossings(pathinfo){var z=pathinfo[0].z;var m=z.length;var n=z[0].length;var twoWide=m===2||n===2;var xi;var yi;var startIndices;var ystartIndices;var label;var corners;var mi;var pi;var i;for(yi=0;yi<m-1;yi++){ystartIndices=[];if(yi===0)ystartIndices=ystartIndices.concat(constants.BOTTOMSTART);if(yi===m-2)ystartIndices=ystartIndices.concat(constants.TOPSTART);for(xi=0;xi<n-1;xi++){startIndices=ystartIndices.slice();if(xi===0)startIndices=startIndices.concat(constants.LEFTSTART);if(xi===n-2)startIndices=startIndices.concat(constants.RIGHTSTART);label=xi+","+yi;corners=[[z[yi][xi],z[yi][xi+1]],[z[yi+1][xi],z[yi+1][xi+1]]];for(i=0;i<pathinfo.length;i++){pi=pathinfo[i];mi=getMarchingIndex(pi.level,corners);if(!mi)continue;pi.crossings[label]=mi;if(startIndices.indexOf(mi)!==-1){pi.starts.push([xi,yi]);if(twoWide&&startIndices.indexOf(mi,startIndices.indexOf(mi)+1)!==-1){pi.starts.push([xi,yi])}}}}}}function getMarchingIndex(val,corners){var mi=(corners[0][0]>val?0:1)+(corners[0][1]>val?0:2)+(corners[1][1]>val?0:4)+(corners[1][0]>val?0:8);if(mi===5||mi===10){var avg=(corners[0][0]+corners[0][1]+corners[1][0]+corners[1][1])/4;if(val>avg)return mi===5?713:1114;return mi===5?104:208}return mi===15?0:mi}function c2p(axis){function l2p(v){return d3.round(axis._b+axis._m*v,2)}return l2p}function setScale(axis){let rl0=axis.range[0],rl1=axis.range[1],axLetter=axis.letter;if(axLetter==="y"){axis._m=axis.height/(rl0-rl1);axis._b=-axis._m*rl1}else{axis._m=axis.width/(rl1-rl0);axis._b=-axis._m*rl0}}function findAllPaths(pathinfo,xtol,ytol){var cnt,startLoc,i,pi,j;xtol=xtol||.01;ytol=ytol||.01;for(i=0;i<pathinfo.length;i++){pi=pathinfo[i];for(j=0;j<pi.starts.length;j++){startLoc=pi.starts[j];makePath(pi,startLoc,"edge",xtol,ytol)}cnt=0;while(Object.keys(pi.crossings).length&&cnt<1e4){cnt++;startLoc=Object.keys(pi.crossings)[0].split(",").map(Number);makePath(pi,startLoc,undefined,xtol,ytol)}}}function equalPts(pt1,pt2,xtol,ytol){return Math.abs(pt1[0]-pt2[0])<xtol&&Math.abs(pt1[1]-pt2[1])<ytol}function ptDist(pt1,pt2){var dx=pt1[2]-pt2[2];var dy=pt1[3]-pt2[3];return Math.sqrt(dx*dx+dy*dy)}function makePath(pi,loc,edgeflag,xtol,ytol){var locStr=loc.join(",");var mi=pi.crossings[locStr];var marchStep=getStartStep(mi,edgeflag,loc);var pts=[getInterpPx(pi,loc,[-marchStep[0],-marchStep[1]])];var m=pi.z.length;var n=pi.z[0].length;var startLoc=loc.slice();var startStep=marchStep.slice();var cnt;for(cnt=0;cnt<1e4;cnt++){if(mi>20){mi=constants.CHOOSESADDLE[mi][(marchStep[0]||marchStep[1])<0?0:1];pi.crossings[locStr]=constants.SADDLEREMAINDER[mi]}else{delete pi.crossings[locStr]}marchStep=constants.NEWDELTA[mi];if(!marchStep){break}pts.push(getInterpPx(pi,loc,marchStep));loc[0]+=marchStep[0];loc[1]+=marchStep[1];locStr=loc.join(",");if(equalPts(pts[pts.length-1],pts[pts.length-2],xtol,ytol))pts.pop();var atEdge=marchStep[0]&&(loc[0]<0||loc[0]>n-2)||marchStep[1]&&(loc[1]<0||loc[1]>m-2);var closedLoop=loc[0]===startLoc[0]&&loc[1]===startLoc[1]&&marchStep[0]===startStep[0]&&marchStep[1]===startStep[1];if(closedLoop||edgeflag&&atEdge)break;mi=pi.crossings[locStr]}var closedpath=equalPts(pts[0],pts[pts.length-1],xtol,ytol);var totaldist=0;var distThresholdFactor=.2*pi.smoothing;var alldists=[];var cropstart=0;var distgroup,cnt2,cnt3,newpt,ptcnt,ptavg,thisdist,i,j,edgepathi,edgepathj;for(cnt=1;cnt<pts.length;cnt++){thisdist=ptDist(pts[cnt],pts[cnt-1]);totaldist+=thisdist;alldists.push(thisdist)}var distThreshold=totaldist/alldists.length*distThresholdFactor;function getpt(i){return pts[i%pts.length]}for(cnt=pts.length-2;cnt>=cropstart;cnt--){distgroup=alldists[cnt];if(distgroup<distThreshold){cnt3=0;for(cnt2=cnt-1;cnt2>=cropstart;cnt2--){if(distgroup+alldists[cnt2]<distThreshold){distgroup+=alldists[cnt2]}else break}if(closedpath&&cnt===pts.length-2){for(cnt3=0;cnt3<cnt2;cnt3++){if(distgroup+alldists[cnt3]<distThreshold){distgroup+=alldists[cnt3]}else break}}ptcnt=cnt-cnt2+cnt3+1;ptavg=Math.floor((cnt+cnt2+cnt3+2)/2);if(!closedpath&&cnt===pts.length-2)newpt=pts[pts.length-1];else if(!closedpath&&cnt2===-1)newpt=pts[0];else if(ptcnt%2)newpt=getpt(ptavg);else{newpt=[(getpt(ptavg)[0]+getpt(ptavg+1)[0])/2,(getpt(ptavg)[1]+getpt(ptavg+1)[1])/2]}pts.splice(cnt2+1,cnt-cnt2+1,newpt);cnt=cnt2+1;if(cnt3)cropstart=cnt3;if(closedpath){if(cnt===pts.length-2)pts[cnt3]=pts[pts.length-1];else if(cnt===0)pts[pts.length-1]=pts[0]}}}pts.splice(0,cropstart);for(cnt=0;cnt<pts.length;cnt++)pts[cnt].length=2;if(pts.length<2)return;else if(closedpath){pts.pop();pi.paths.push(pts)}else{var merged=false;for(i=0;i<pi.edgepaths.length;i++){edgepathi=pi.edgepaths[i];if(!merged&&equalPts(edgepathi[0],pts[pts.length-1],xtol,ytol)){pts.pop();merged=true;var doublemerged=false;for(j=0;j<pi.edgepaths.length;j++){edgepathj=pi.edgepaths[j];if(equalPts(edgepathj[edgepathj.length-1],pts[0],xtol,ytol)){doublemerged=true;pts.shift();pi.edgepaths.splice(i,1);if(j===i){pi.paths.push(pts.concat(edgepathj))}else{if(j>i)j--;pi.edgepaths[j]=edgepathj.concat(pts,edgepathi)}break}}if(!doublemerged){pi.edgepaths[i]=pts.concat(edgepathi)}}}for(i=0;i<pi.edgepaths.length;i++){if(merged)break;edgepathi=pi.edgepaths[i];if(equalPts(edgepathi[edgepathi.length-1],pts[0],xtol,ytol)){pts.shift();pi.edgepaths[i]=edgepathi.concat(pts);merged=true}}if(!merged)pi.edgepaths.push(pts)}}function getStartStep(mi,edgeflag,loc){var dx=0;var dy=0;if(mi>20&&edgeflag){if(mi===208||mi===1114){dx=loc[0]===0?1:-1}else{dy=loc[1]===0?1:-1}}else if(constants.BOTTOMSTART.indexOf(mi)!==-1)dy=1;else if(constants.LEFTSTART.indexOf(mi)!==-1)dx=1;else if(constants.TOPSTART.indexOf(mi)!==-1)dy=-1;else dx=-1;return[dx,dy]}function getInterpPx(pi,loc,step){var locx=loc[0]+Math.max(step[0],0);var locy=loc[1]+Math.max(step[1],0);var zxy=pi.z[locy][locx];var xa=pi.xaxis;var ya=pi.yaxis;if(step[1]){var dx=(pi.level-zxy)/(pi.z[locy][locx+1]-zxy);return[c2p(xa)((1-dx)*pi.x[locx]+dx*pi.x[locx+1],true),c2p(ya)(pi.y[locy],true),locx+dx,locy]}else{var dy=(pi.level-zxy)/(pi.z[locy+1][locx]-zxy);return[c2p(xa)(pi.x[locx],true),c2p(ya)((1-dy)*pi.y[locy]+dy*pi.y[locy+1],true),locx,locy+dy]}}function closeBoundaries(pathinfo){var pi0=pathinfo[0];var z=pi0.z;var i;var edgeVal2=Math.min(z[0][0],z[0][1]);for(i=0;i<pathinfo.length;i++){var pi=pathinfo[i];pi.prefixBoundary=!pi.edgepaths.length&&(edgeVal2>pi.level||pi.starts.length&&edgeVal2===pi.level)}}var CatmullRomExp=.5;function smoothopen(pts,smoothness){if(pts.length<3){return"M"+pts.join("L")}var path="M"+pts[0];var tangents=[];var i;for(i=1;i<pts.length-1;i++){tangents.push(makeTangent(pts[i-1],pts[i],pts[i+1],smoothness))}path+="Q"+tangents[0][0]+" "+pts[1];for(i=2;i<pts.length-1;i++){path+="C"+tangents[i-2][1]+" "+tangents[i-1][0]+" "+pts[i]}path+="Q"+tangents[pts.length-3][1]+" "+pts[pts.length-1];return path}function smoothclosed(pts,smoothness){if(pts.length<3){return"M"+pts.join("L")+"Z"}var path="M"+pts[0];var pLast=pts.length-1;var tangents=[makeTangent(pts[pLast],pts[0],pts[1],smoothness)];var i;for(i=1;i<pLast;i++){tangents.push(makeTangent(pts[i-1],pts[i],pts[i+1],smoothness))}tangents.push(makeTangent(pts[pLast-1],pts[pLast],pts[0],smoothness));for(i=1;i<=pLast;i++){path+="C"+tangents[i-1][1]+" "+tangents[i][0]+" "+pts[i]}path+="C"+tangents[pLast][1]+" "+tangents[0][0]+" "+pts[0]+"Z";return path}function makeTangent(prevpt,thispt,nextpt,smoothness){var d1x=prevpt[0]-thispt[0];var d1y=prevpt[1]-thispt[1];var d2x=nextpt[0]-thispt[0];var d2y=nextpt[1]-thispt[1];var d1a=Math.pow(d1x*d1x+d1y*d1y,CatmullRomExp/2);var d2a=Math.pow(d2x*d2x+d2y*d2y,CatmullRomExp/2);var numx=(d2a*d2a*d1x-d1a*d1a*d2x)*smoothness;var numy=(d2a*d2a*d1y-d1a*d1a*d2y)*smoothness;var denom1=3*d2a*(d1a+d2a);var denom2=3*d1a*(d1a+d2a);return[[d3.round(thispt[0]+(denom1&&numx/denom1),2),d3.round(thispt[1]+(denom1&&numy/denom1),2)],[d3.round(thispt[0]-(denom2&&numx/denom2),2),d3.round(thispt[1]-(denom2&&numy/denom2),2)]]}function ensureSingle(parent,nodeType,className){var sel=parent.select(nodeType+(className?"."+className:""));if(sel.size())return sel;var layer=parent.append(nodeType);if(className)layer.classed(className,true);return layer}function makeBackground(plotgroup,perimeter){var bggroup=ensureSingle(plotgroup,"g","contourbg");var bgfill=bggroup.selectAll("path").data([0]);bgfill.enter().append("path");bgfill.exit().remove();bgfill.attr("d","M"+perimeter.join("L")+"Z").style("stroke","none")}function makeFills(plotgroup,pathinfo,perimeter,colorScale){var boundaryPath="M"+perimeter.join("L")+"Z";closeBoundaries(pathinfo);var fillgroup=ensureSingle(plotgroup,"g","contourfill");var fillitems=fillgroup.selectAll("path").data(pathinfo);fillitems.enter().append("path");fillitems.exit().remove();fillitems.each(function(pi){var fullpath=(pi.prefixBoundary?boundaryPath:"")+joinAllPaths(pi,perimeter);if(!fullpath){d3.select(this).remove()}else{d3.select(this).attr("d",fullpath).style("stroke","none").style("fill",function(d){return colorScale(d.level)})}});let clipPathUUID=window.crypto.getRandomValues(new Uint32Array(1))[0].toString(16);fillgroup.style("clip-path",`url(#${clipPathUUID})`).append("clipPath").attr("id",clipPathUUID).append("path").attr("d",boundaryPath)}function joinAllPaths(pi,perimeter){var fullpath="";var i=0;var startsleft=pi.edgepaths.map(function(v,i){return i});var newloop=true;var endpt;var newendpt;var cnt;var nexti;var possiblei;var addpath;function istop(pt){return Math.abs(pt[1]-perimeter[0][1])<.01}function isbottom(pt){return Math.abs(pt[1]-perimeter[2][1])<.01}function isleft(pt){return Math.abs(pt[0]-perimeter[0][0])<.01}function isright(pt){return Math.abs(pt[0]-perimeter[2][0])<.01}while(startsleft.length){addpath=smoothopen(pi.edgepaths[i],pi.smoothing);fullpath+=newloop?addpath:addpath.replace(/^M/,"L");startsleft.splice(startsleft.indexOf(i),1);endpt=pi.edgepaths[i][pi.edgepaths[i].length-1];nexti=-1;for(cnt=0;cnt<4;cnt++){if(!endpt||endpt.length<2){break}if(istop(endpt)&&!isright(endpt))newendpt=perimeter[1];else if(isleft(endpt))newendpt=perimeter[0];else if(isbottom(endpt))newendpt=perimeter[3];else if(isright(endpt))newendpt=perimeter[2];else newendpt=[];for(possiblei=0;possiblei<pi.edgepaths.length;possiblei++){var ptNew=pi.edgepaths[possiblei][0];if(newendpt.length){if(Math.abs(endpt[0]-newendpt[0])<.01){if(Math.abs(endpt[0]-ptNew[0])<.01&&(ptNew[1]-endpt[1])*(newendpt[1]-ptNew[1])>=0){newendpt=ptNew;nexti=possiblei}}else if(Math.abs(endpt[1]-newendpt[1])<.01){if(Math.abs(endpt[1]-ptNew[1])<.01&&(ptNew[0]-endpt[0])*(newendpt[0]-ptNew[0])>=0){newendpt=ptNew;nexti=possiblei}}}}endpt=newendpt;if(nexti>=0)break;fullpath+="L"+newendpt}if(nexti===pi.edgepaths.length){break}i=nexti;newloop=startsleft.indexOf(i)===-1;if(newloop){i=startsleft[0];fullpath+="Z"}}for(i=0;i<pi.paths.length;i++){fullpath+=smoothclosed(pi.paths[i],pi.smoothing)}return fullpath}return contourPlotFactory})})();(function(){"use strict";var app0=angular.module("dataiku.analysis",[]);var app=angular.module("dataiku.analysis.core",[]);app.controller("AnalysesListController",function($scope,$controller,$stateParams,$filter,DataikuAPI,CreateModalFromTemplate,DatasetUtils,$state,TopNav){$controller("_TaggableObjectsListPageCommon",{$scope:$scope});$controller("AnalysisCoreController",{$scope:$scope});$scope.sortBy=[{value:"name",label:"Name"},{value:"inputDatasetSmartName",label:"Dataset"},{value:"-lastModifiedOn",label:"Last modified"}];$scope.selection=$.extend({filterQuery:{userQuery:"",tags:[],interest:{starred:""},inputDatasetSmartName:[]},filterParams:{userQueryTargets:["name","tags","inputDatasetSmartName"],propertyRules:{tag:"tags",dataset:"inputDatasetSmartName"},exactMatch:["inputDatasetSmartName"]},orderQuery:"-lastModifiedOn",orderReversed:false},$scope.selection||{});if($stateParams.datasetId){$scope.selection.filterQuery.inputDatasetSmartName.push($stateParams.datasetId)}$scope.maxItems=20;$scope.list=function(){DataikuAPI.analysis.listHeads($stateParams.projectKey,true).success(function(data){$scope.listItems=data;$scope.listItems.forEach(item=>{item.nbModels=item.mlTasks.reduce((sum,task)=>sum+task.modelCount,0);item.nbSessions=item.mlTasks.reduce((sum,task)=>sum+task.sessionCount,0);item.computedIcon=item.nbMLTasks===1?$filter("analysisTypeToIcon")(item.mlTasks[0].taskType,item.mlTasks[0].backendType,item.mlTasks[0].predictionType,24):"icon-dku-nav_analysis"});$scope.restoreOriginalSelection()}).error(setErrorInScope.bind($scope))};TopNav.setLocation(TopNav.TOP_ANALYSES,TopNav.LEFT_ANALYSES,TopNav.TABS_NONE,null);TopNav.setNoItem();$scope.list();$scope.$on("selectedIndex",function(e,index){$scope.$broadcast("clearMultiSelect")});$scope.goToItem=function(data){$state.go("projects.project.analyses.analysis.script",{projectKey:$stateParams.projectKey,analysisId:data.id})};$scope.newAnalysis=function(){CreateModalFromTemplate("/templates/analysis/new-analysis-modal.html",$scope,"NewAnalysisModalController")};DatasetUtils.listDatasetsUsabilityForAny($stateParams.projectKey).success(data=>{data.forEach(x=>{x.usable=x.usableAsInput;x.usableReason=x.inputReason});$scope.availableDatasets=data}).error(setErrorInScope.bind($scope))});app.controller("NewAnalysisModalController",function($scope,$state,$stateParams,DataikuAPI,DatasetUtils){DatasetUtils.listDatasetsUsabilityForAny($stateParams.projectKey).success(function(data){data.forEach(function(x){x.usable=x.usableAsInput;x.usableReason=x.inputReason});$scope.availableDatasets=data;angular.forEach($scope.availableDatasets,function(x){x.usable=true})}).error(setErrorInScope.bind($scope));$scope.newAnalysis={};$scope.$watch("newAnalysis.datasetSmartName",function(nv,ov){if(nv&&!$scope.newAnalysis.name){$scope.newAnalysis.name="Analyze "+$scope.newAnalysis.datasetSmartName}});$scope.create=function(){DataikuAPI.analysis.create($stateParams.projectKey,$scope.newAnalysis.datasetSmartName,$scope.newAnalysis.name).success(function(data){$state.go("projects.project.analyses.analysis.script",{projectKey:$stateParams.projectKey,analysisId:data.id})}).error(setErrorInScope.bind($scope))}});app.controller("NewAnalysisOnDatasetModalController",function($scope,$state,$stateParams,DataikuAPI,DatasetUtils,$timeout,Fn){var focus1stInput=$timeout.bind(null,function(){$(".modal").find("input").focus()},0);$scope.$watch("datasetSmartName",function(nv){if(!nv)return;DataikuAPI.analysis.listOnDataset($stateParams.projectKey,$scope.datasetSmartName,!!$scope.forMLTask).success(function(data){$scope.existingAnalyses=data;$scope.hasMLTasks=!!$scope.forMLTask&&data.map(Fn.propStr("mlTasks.length")).reduce(Fn.SUM,0)>0;$scope.newData.name="Analyze "+$scope.datasetSmartName;if(data.length==0){focus1stInput()}}).error(setErrorInScope.bind($scope))});$scope.newData={};$scope.createAnother=function(){$scope.existingAnalyses.length=0;focus1stInput()};$scope.create=function(){DataikuAPI.analysis.create($stateParams.projectKey,$scope.datasetSmartName,$scope.newData.name).success(function(data){$state.go("projects.project.analyses.analysis."+($scope.forMLTasks?"ml.list":"script"),{projectKey:$stateParams.projectKey,analysisId:data.id})}).error(setErrorInScope.bind($scope))}});app.controller("AnalysisCoreController",function($scope,$stateParams,$rootScope,WT1,TopNav,DataikuAPI,CreateModalFromTemplate,CreateExportModal,ExportUtils,Dialogs,$state,$q,DatasetUtils,CreateModalFromComponent,createOrAppendMELikeToModelComparisonModalDirective,createOrAppendModelsToExperimentTrackingModalDirective,RatingFeedbackParams){$scope.ratingFeedbackParams=RatingFeedbackParams;$scope.$on("$stateChangeStart",()=>{$scope.ratingFeedbackParams.showRatingFeedback=false});if($state.is("projects.project.analyses.list")){let selectedObjectListener=$scope.$watch("selection.selectedObject",nv=>{if(nv){$stateParams.analysisId=$scope.selection.selectedObject.id;$scope.analysisDataContext.inputDatasetLoc=DatasetUtils.getLocFromSmart($stateParams.projectKey,$scope.selection.selectedObject.inputDatasetSmartName)}});$scope.$on("$destroy",selectedObjectListener)}$scope.analysisId=$stateParams.analysisId;$scope.analysisDataContext={};$scope.mlTasksContext={};$scope.appConfig=$rootScope.appConfig;$scope.createShakerRecipe=function(){CreateModalFromTemplate("/templates/shaker/add-to-flow.html",$scope,"AddAnalysisToFlowController")};$scope.exportProcessedData=function(){DataikuAPI.analysis.getCore($stateParams.projectKey,$stateParams.analysisId).success(function(acp){var datasetLoc=DatasetUtils.getLocFromSmart($stateParams.projectKey,acp.inputDatasetSmartName);DataikuAPI.datasets.get(datasetLoc.projectKey,datasetLoc.name,$stateParams.projectKey).success(function(dataset){var partitionLoader=!dataset.partitioning.dimensions.length?null:function(){var deferred=$q.defer();DataikuAPI.datasets.listPartitions(dataset).success(function(data){deferred.resolve(data)}).error(function(){deferred.reject()});return deferred.promise};var features={advancedSampling:true,partitionListLoader:partitionLoader,isDownloadable:true};var dialog={title:'Prepared Dataset "'+dataset.name+'"',warn:null};CreateExportModal($scope,dialog,features).then(function(params){DataikuAPI.analysis.exportProcessedData($stateParams.projectKey,$stateParams.analysisId,params).success(function(data){ExportUtils.defaultHandleExportResult($scope,params,data)}).error(setErrorInScope.bind($scope))})}).error(setErrorInScope.bind($scope))}).error(setErrorInScope.bind($scope))};$scope.clearMLTasksContext=function(){$scope.mlTasksContext.type=null;$scope.mlTasksContext.activeMetric=null};$scope.changeDataset=function(){DataikuAPI.analysis.getCore($stateParams.projectKey,$stateParams.analysisId).success(function(acp){var newScope=$scope.$new();newScope.analysisCoreParams=acp;CreateModalFromTemplate("/templates/analysis/change-dataset-modal.html",newScope,"ChangeDatasetOnAnalysisModalController")}).error(setErrorInScope.bind($scope))};$scope.saveCustomFields=function(analysis,newCustomFields){WT1.event("custom-fields-save",{objectType:"ANALYSIS"});let oldCustomFields=angular.copy(analysis.customFields);analysis.customFields=newCustomFields;return DataikuAPI.analysis.saveCore(analysis,{summaryOnly:true}).success(function(){$rootScope.$broadcast("customFieldsSaved",TopNav.getItem(),analysis.customFields)}).error(function(a,b,c){analysis.customFields=oldCustomFields;setErrorInScope.bind($scope)(a,b,c)})};$scope.editCustomFields=function(editingTabIndex=0){DataikuAPI.analysis.getSummary($stateParams.projectKey,$stateParams.analysisId).success(function(data){let analysisCoreParams=data.object;let modalScope=angular.extend($scope,{objectType:"ANALYSIS",objectName:analysisCoreParams.name,objectCustomFields:analysisCoreParams.customFields,editingTabIndex:editingTabIndex});CreateModalFromTemplate("/templates/taggable-objects/custom-fields-edit-modal.html",modalScope).then(function(customFields){$scope.saveCustomFields(analysisCoreParams,customFields)})}).error(setErrorInScope.bind($scope))};$scope.compareModel=function(type){CreateModalFromComponent(createOrAppendMELikeToModelComparisonModalDirective,{fullIds:[$scope.mlTasksContext.model.fullModelId],modelTaskType:$scope.mlTasksContext.model.coreParams.prediction_type,allowImportOfRelatedEvaluations:true,suggestedMCName:`Compare 1 model version from ${$scope.mlTasksContext.model.userMeta.name}`,projectKey:$stateParams.projectKey,trackFrom:"lab-model-page"})};$scope.compareWithExperimentTracking=function(){DataikuAPI.experimenttracking.getExperiments($stateParams.projectKey).success(function(data){CreateModalFromComponent(createOrAppendModelsToExperimentTrackingModalDirective,{experiments:data,fmis:[$scope.mlTasksContext.model.fullModelId],projectKey:$stateParams.projectKey,trackFrom:"lab-model-page"})})};$scope.comparisonForbiddenReason=function(){if(!$scope.mlTasksContext.model){return null}if($scope.mlTasksContext.model.coreParams.backendType==="DEEP_HUB"){return"Comparison of Computer vision models is not supported"}if($scope.mlTasksContext.model.coreParams.taskType!=="PREDICTION"){return"Only prediction models can be compared"}if($scope.mlTasksContext.model.trainInfo.state!=="DONE"){return"Cannot compare a model being trained or that failed"}if($scope.mlTasksContext.model.coreParams.partitionedModel&&$scope.mlTasksContext.model.coreParams.partitionedModel.enabled){return"Comparison of partitioned models is not supported"}if($scope.mlTasksContext.model.modeling.ensemble_params){return"Comparison of ensembled models is not supported"}if(!$scope.canWriteProject()){return"You don't have write permissions for this project"}};$scope.compareWithExperimentTrackingForbiddenReason=function(){if(!$scope.mlTasksContext.model){return null}if(!["PY_MEMORY","KERAS"].includes($scope.mlTasksContext.model.coreParams.backendType)||!(["MULTICLASS","BINARY_CLASSIFICATION","REGRESSION"].includes($scope.mlTasksContext.model.coreParams.prediction_type)||$scope.mlTasksContext.model.coreParams.taskType==="CLUSTERING")){return"This type of model cannot be compared in Experiment Tracking."}if(!$scope.mlTasksContext.model.trainInfo.state==="DONE"){return"Only successfully trained models can be compared"}if(!$scope.canWriteProject()){return"You don't have write permissions for this project"}};$scope.deletionForbiddenReason=function(){if(!$scope.canWriteProject()){return"You don't have write permissions for this project"}}});app.controller("ChangeDatasetOnAnalysisModalController",function($scope,$state,$stateParams,DataikuAPI,DatasetUtils,$timeout,Fn,Dialogs,DKUtils){DatasetUtils.listDatasetsUsabilityForAny($stateParams.projectKey).success(function(data){$scope.availableDatasets=data;angular.forEach($scope.availableDatasets,function(x){x.usable=x.smartName!=$scope.analysisCoreParams.inputDatasetSmartName})}).error(setErrorInScope.bind($scope));$scope.change=function(datasetSmartName){var usableDataset=null;angular.forEach($scope.availableDatasets,function(x){if(x.smartName==datasetSmartName){usableDataset=x}});Dialogs.confirm($scope,"Change input to "+usableDataset.name,"Are you sure you want to use  as input to this analysis? Columns and features might be different "+"and prevent some script steps and/or models from functioning.").then(function(){$scope.analysisCoreParams.inputDatasetSmartName=datasetSmartName;DataikuAPI.analysis.saveCore($scope.analysisCoreParams).success(function(data){DKUtils.reloadState()}).error(setErrorInScope.bind($scope))})}});app.controller("AddAnalysisToFlowController",function($scope,$controller,$stateParams,$state,DataikuAPI,$q,DatasetUtils){$scope.recipeType="shaker";$controller("SingleOutputDatasetRecipeCreationController",{$scope:$scope});$scope.io.inputDataset=DatasetUtils.makeSmart($scope.analysisDataContext.inputDatasetLoc,$stateParams.projectKey);$scope.$watch("io.inputDataset",function(nv,ov){if(!nv)return;var datasetLoc=DatasetUtils.getLocFromSmart($stateParams.projectKey,$scope.io.inputDataset);DataikuAPI.datasets.get(datasetLoc.projectKey,datasetLoc.name,$stateParams.projectKey).success(function(dataset){$scope.dataset=dataset;$scope.dataset.partitioned=dataset.partitioning&&dataset.partitioning.dimensions&&dataset.partitioning.dimensions.length}).error(setErrorInScope.bind($scope))});$scope.options={fallbackToString:true,cleanupColumnNames:true,exportCharts:true};$scope.buildAfterCreation=false;$scope.showOutputPane=function(){return true};$scope.autosetName=function(){var niceInputName=$scope.analysisDataContext.inputDatasetLoc.name.replace(/[A-Z]*\./,"");$scope.maybeSetNewDatasetName(niceInputName+"_prepared")};function buildDataset(projectKey,outputDataset){var deferred=$q.defer();var jd={};jd.type="NON_RECURSIVE_FORCED_BUILD";jd.refreshHiveMetastore=true;jd.projectKey=projectKey;jd.outputs=[{targetDataset:outputDataset,targetDatasetProjectKey:projectKey}];DataikuAPI.flow.jobs.start(jd).success(function(data){deferred.resolve()}).error(function(a,b,c){setErrorInScope.bind($scope)(a,b,c);$scope.recipeWT1Event("recipe-run-start-failed");deferred.reject()});return deferred.promise}$scope.createRecipe=function(){var createOutput=$scope.io.newOutputTypeRadio=="create";var outputName=createOutput?$scope.newOutputDataset.name:$scope.io.existingOutputDataset;$scope.options.inputDataset=$scope.io.inputDataset;DataikuAPI.analysis.addToFlow($stateParams.projectKey,$stateParams.analysisId,createOutput,outputName,$scope.getDatasetCreationSettings(),$scope.options).success(function(data){$scope.dismiss();if($scope.buildAfterCreation){buildDataset($stateParams.projectKey,outputName).then(function(){$state.transitionTo("projects.project.flow",{projectKey:$stateParams.projectKey,id:"dataset_"+$stateParams.projectKey+"."+outputName})})}else{$state.transitionTo("projects.project.recipes.recipe",{projectKey:$stateParams.projectKey,recipeName:data.id,newlyCreated:true})}}).error(setErrorInScope.bind($scope))}});app.directive("analysisRightColumnSummary",function(DataikuAPI,$state,$stateParams,$rootScope,$controller,$filter,GlobalProjectActions,QuickView,ActiveProjectKey,ActivityIndicator,MLTasksNavService){return{templateUrl:"/templates/analysis/right-column-summary.html",link:function($scope){$controller("_TaggableObjectsMassActions",{$scope:$scope});$scope.QuickView=QuickView;function setUIState(){$scope.analysisData.uiState=$scope.analysisData.uiState||{showAllMLTasks:false,showAllSavedModels:false}}function prepareMLTasks(){$scope.analysisData.mlTasks.forEach(mlTask=>{mlTask.computedIcon=$filter("analysisTypeToIcon")(mlTask.taskType,mlTask.backendType,mlTask.predictionType,16)});$scope.analysisData.mlTasks.sort((a,b)=>{return a.lastModifiedOn-b.lastModifiedOn});const activeMLTaskId=MLTasksNavService.getActiveMLTaskId($scope.selection.selectedObject.id);if(activeMLTaskId){const activeMLTaskIndex=$scope.analysisData.mlTasks.findIndex(mlTask=>mlTask.mlTaskId===activeMLTaskId);Array.move($scope.analysisData.mlTasks,activeMLTaskIndex,0)}}function prepareSavedModels(){$scope.analysisData.savedModels.forEach(savedModelData=>{const savedModel=savedModelData.savedModel||{};const miniTask=savedModel.miniTask||{};savedModelData.computedIcon=$filter("savedModelSubtypeToIcon")(miniTask.taskType,miniTask.backendType,miniTask.predictionType,savedModel.savedModelType,(savedModel.proxyModelConfiguration||{}).protocol,16)})}$scope.refreshData=function(){$scope.insight=$scope.selection.selectedObject;DataikuAPI.analysis.getSummary($scope.selection.selectedObject.projectKey,$scope.selection.selectedObject.id,true).success(data=>{$scope.analysisData={analysis:data.object,mlTasks:data.mlTasks,savedModels:data.savedModels,interest:data.interest};$scope.analysis=$scope.analysisData.analysis;setUIState();prepareMLTasks();prepareSavedModels();$rootScope.$broadcast("objectMetaDataRefresh",{tags:$scope.analysis.tags,shortDesc:$scope.analysis.shortDesc,description:$scope.analysis.description,checklists:$scope.analysis.checklists,customFields:$scope.analysis.customFields})})};$scope.$on("objectSummaryEdited",function(){DataikuAPI.analysis.saveCore($scope.analysis,{summaryOnly:true}).success(function(data){ActivityIndicator.success("Saved")}).error(setErrorInScope.bind($scope))});$scope.refreshTimeline=function(){DataikuAPI.timelines.getForObject(ActiveProjectKey.get(),"ANALYSIS",$scope.selection.selectedObject.id).success(function(data){$scope.objectTimeline=data}).error(setErrorInScope.bind($scope))};$scope.deleteAnalysis=function(){GlobalProjectActions.deleteTaggableObject($scope,"ANALYSIS",$scope.selection.selectedObject.id,$scope.selection.selectedObject.name)};$scope.duplicate=function(){DataikuAPI.analysis.duplicate(ActiveProjectKey.get(),$scope.selection.selectedObject.id).success(function(data){if($scope.list){$scope.list();$scope.selection.selectedObject=null}else{$state.transitionTo("projects.project.analyses.analysis.script",{projectKey:$stateParams.projectKey,analysisId:data.id})}}).error(setErrorInScope.bind($scope))};$scope.$watch("selection.selectedObject",function(nv,ov){if(!nv)return;$scope.analysisData={analysis:nv,mlTasks:[]};if(!$scope.selection.selectedObject){$scope.objectTimeline=null;$scope.acp=null}});$scope.$watch("selection.confirmedItem",function(nv,ov){if(!nv)return;$scope.refreshData()});const customFieldsListener=$rootScope.$on("customFieldsSaved",$scope.refreshData);$scope.$on("$destroy",customFieldsListener)}}});app.controller("AnalysisPageRightColumnActions",async function($controller,$scope,$rootScope,$stateParams,DataikuAPI,ActiveProjectKey){$controller("_TaggableObjectPageRightColumnActions",{$scope:$scope});$scope.data=(await DataikuAPI.analysis.getSummary(ActiveProjectKey.get(),$stateParams.analysisId)).data;const analysis=$scope.data.object;analysis.nodeType="ANALYSIS";analysis.interest=$scope.data.interest;$scope.selection={selectedObject:analysis,confirmedItem:analysis};function updateUserInterests(){DataikuAPI.interests.getForObject($rootScope.appConfig.login,"ANALYSIS",ActiveProjectKey.get(),$stateParams.analysisId).success(function(data){$scope.selection.selectedObject.interest=data;$scope.analysisData.interest=data}).error(setErrorInScope.bind($scope))}$scope.renameObjectAndSave=function(newName){return DataikuAPI.analysis.saveCore(Object.assign({},$scope.selection.selectedObject,{name:newName}),{summaryOnly:true})};updateUserInterests();const interestsListener=$rootScope.$on("userInterestsUpdated",updateUserInterests);$scope.$on("$destroy",interestsListener)});app.service("MLTaskInformationService",function(Fn){function isSessionRunning($scope,sessionId){if(!$scope.selection||!$scope.selection.allObjects){return false}return $scope.selection.allObjects.filter(function(o){return o.sessionId===sessionId}).map(function(m){return m.trainInfo.state==="RUNNING"||m.trainInfo.state==="PENDING"}).reduce(Fn.OR,false)}return{isSessionRunning:isSessionRunning}})})();(function(){"use strict";const app=angular.module("dataiku.analysis.script",[]);app.directive("analysisScript",function($q,Assert,DataikuAPI,WT1,TopNav,DatasetUtils,computeColumnWidths){return{scope:true,controller:function($scope,$stateParams,$state){var savedParams;$scope.shakerHooks.saveForAuto=function(){Assert.inScope($scope,"analysisCoreParams");var deferred=$q.defer();var toSave=angular.copy($scope.analysisCoreParams);toSave.script=$scope.getShakerData();savedParams.script=savedParams.script||{};savedParams.script.origin="ANALYSIS";if(angular.equals($scope.analysisCoreParams.script,savedParams.script)){deferred.resolve();return deferred.promise}DataikuAPI.analysis.saveCore(toSave).success(function(data){$scope.originalShaker=toSave.script;deferred.resolve()}).error(setErrorInScope.bind($scope));return deferred.promise};$scope.shakerHooks.setColumnMeaning=function(column,newMeaning){Assert.inScope($scope,"shaker");Assert.trueish($scope.shaker.analysisColumnData,"analysisColumnData is null");var colData=$scope.shaker.analysisColumnData[column.name];if(!colData){colData={};$scope.shaker.analysisColumnData[column.name]=colData}colData.meaning=newMeaning;$scope.autoSaveAutoRefresh()};$scope.shakerHooks.updateColumnDetails=function(column){Assert.inScope($scope,"shaker");Assert.trueish($scope.shaker.analysisColumnData,"analysisColumnData is null");$scope.shaker.analysisColumnData[column.name]=column;$scope.autoSaveAutoRefresh()};$scope.shakerHooks.updateColumnWidth=function(name,width){Assert.inScope($scope,"shaker");Assert.trueish($scope.shaker.columnWidthsByName,"columnWidthsByName is null");$scope.shaker.columnWidthsByName[name]=width;$scope.autoSaveAutoRefresh()};$scope.clearResize=function(){Assert.inScope($scope,"shaker");Assert.trueish($scope.shaker.columnWidthsByName,"columnWidthsByName is null");const minColumnWidth=100;$scope.shaker.columnWidthsByName=computeColumnWidths($scope.table.initialChunk,$scope.table.headers,minColumnWidth,$scope.hasAnyFilterOnColumn,$scope.shaker.columnWidthsByName,$scope.shaker.columnUseScientificNotationByName,true)[1];$scope.autoSaveAutoRefresh()};$scope.$watch("projectSummary",function(nv,ov){$scope.shakerWritable=$scope.isProjectAnalystRW();$scope.shakerState.writeAccess=$scope.isProjectAnalystRW()});WT1.event("analysis-script-open");TopNav.setLocation(TopNav.TOP_ANALYSES,TopNav.LEFT_ANALYSES,TopNav.TABS_ANALYSIS,"script");TopNav.setItem(TopNav.ITEM_ANALYSIS,$stateParams.analysisId);Assert.inScope($scope,"shakerState");Assert.inScope($scope,"shakerHooks");$scope.shakerState.isInAnalysis=true;$scope.shakerState.origin="ANALYSIS";DataikuAPI.analysis.getCore($stateParams.projectKey,$stateParams.analysisId).success(function(data){var inputDatasetLoc=DatasetUtils.getLocFromSmart($stateParams.projectKey,data.inputDatasetSmartName);$scope.inputDatasetProjectKey=inputDatasetLoc.projectKey;$scope.inputDatasetName=inputDatasetLoc.name;$scope.inputDatasetSmartName=data.inputDatasetSmartName;$scope.analysisDataContext.inputDatasetLoc=inputDatasetLoc;$scope.baseInit();$scope.analysisCoreParams=data;savedParams=angular.copy(data);TopNav.setItem(TopNav.ITEM_ANALYSIS,$stateParams.analysisId,{name:data.name,dataset:data.inputDatasetSmartName});TopNav.setPageTitle(data.name);$scope.shaker=data.script;$scope.shaker.origin="ANALYSIS";$scope.originalShaker=angular.copy($scope.shaker.script);$scope.fixupShaker();$scope.requestedSampleId=null;$scope.refreshTable(false)}).error(setErrorInScope.bind($scope))}}});app.directive("visualMlAccessCheck",function($rootScope,OpalsService,CreateModalFromTemplate,DataikuAPI,ActivityIndicator,RequestCenterService,WT1){return{restrict:"A",transclude:true,templateUrl:"/templates/analysis/visual-ml-access-check.html",link:function($scope){$scope.openProfileUpgradeModal=function(fromErrorPopup){if(fromErrorPopup){$scope.sendWT1RequestUpgradeProfileOpenModal()}CreateModalFromTemplate("/templates/request-profile-upgrade-modal.html",$scope,null,function(newScope){newScope.profileUpgradeText="Your current profile does not give access to all Dataiku capabilities.";newScope.requestMessage="";DataikuAPI.requests.getLatestRequestForCurrentUser("","PROFILE","").then(response=>{newScope.hasPreviousRequest=response.data.status==="PENDING"},error=>{newScope.hasPreviousRequest=false;if(error.status!==404){setErrorInScope.bind(newScope)(error)}});newScope.requestProfileUpgrade=function(){DataikuAPI.requests.createProfileUpgradeRequest(newScope.requestMessage).success(data=>{RequestCenterService.WT1Events.onRequestSent("PROFILE",null,null,newScope.requestMessage,data.id);ActivityIndicator.success("Profile upgrade request sent!",5e3);newScope.dismiss()}).error(setErrorInScope.bind(newScope))}})};$scope.openHelpCenterDoc=function(event,href){OpalsService.isEnabled().then(function(isOpalsEnabled){if(isOpalsEnabled&&$(".modal-container").length===0){OpalsService.navigateToAndShowDrawer(OpalsService.PAGES.EMBEDDED_BROWSER,{href:href})}else{window.open(href,"_blank")}});event.preventDefault()}},controller:function($scope){this.$onInit=function(){if(!$scope.appConfig.userProfile.mayVisualML){$scope.sendWT1RequestUpgradeProfileShow()}}}}});app.directive("advancedVisualMlAccessCheck",function($rootScope,OpalsService,CreateModalFromTemplate,DataikuAPI,ActivityIndicator,RequestCenterService,WT1){return{restrict:"A",transclude:true,templateUrl:"/templates/analysis/advanced-visual-ml-access-check.html",link:function($scope){$scope.openProfileUpgradeModal=function(fromErrorPopup){if(fromErrorPopup){$scope.sendWT1RequestUpgradeProfileOpenModal()}CreateModalFromTemplate("/templates/request-profile-upgrade-modal.html",$scope,null,function(newScope){newScope.profileUpgradeText="Your current profile does not give access to all Dataiku capabilities.";newScope.requestMessage="";DataikuAPI.requests.getLatestRequestForCurrentUser("","PROFILE","").then(response=>{newScope.hasPreviousRequest=response.data.status==="PENDING"},error=>{newScope.hasPreviousRequest=false;if(error.status!==404){setErrorInScope.bind(newScope)(error)}});newScope.requestProfileUpgrade=function(){DataikuAPI.requests.createProfileUpgradeRequest(newScope.requestMessage).success(data=>{RequestCenterService.WT1Events.onRequestSent("PROFILE",null,null,newScope.requestMessage,data.id);ActivityIndicator.success("Profile upgrade request sent!",5e3);newScope.dismiss()}).error(setErrorInScope.bind(newScope))}})};$scope.openHelpCenterDoc=function(event,href){OpalsService.isEnabled().then(function(isOpalsEnabled){if(isOpalsEnabled&&$(".modal-container").length===0){OpalsService.navigateToAndShowDrawer(OpalsService.PAGES.EMBEDDED_BROWSER,{href:href})}else{window.open(href,"_blank")}});event.preventDefault()}},controller:function($scope){this.$onInit=function(){if(!$scope.appConfig.userProfile.mayAdvancedVisualML){$scope.sendWT1RequestUpgradeProfileShow()}}}}});app.directive("datasetColumnsViewColumn",function(Assert,CreateModalFromTemplate,ContextualMenu,$state,DataikuAPI,WT1,$stateParams){return{restrict:"A",replace:false,scope:false,link:function(scope,element,attrs){const getOutputDatasetOrSmartName=(scope,datasetSmartName)=>{if(scope&&scope.recipe&&scope.recipe.outputs&&scope.recipe.outputs.main&&Array.isArray(scope.recipe.outputs.main.items)&&scope.recipe.outputs.main.items.length>0){return scope.recipe.outputs.main.items[0].ref}return datasetSmartName};scope.buildDataLineageRoute=function(column,datasetSmartName){return $state.href("datalineage.graph",{contextProjectKey:$stateParams.projectKey,smartName:getOutputDatasetOrSmartName(scope,datasetSmartName),columnName:column})};scope.selectedShakerOrigin=function(shakerOrigin){switch(shakerOrigin){case"DATASET_EXPLORE":return"dataset";case"PREPARE_RECIPE":return"prepare-recipe";case"ANALYSIS":return"analysis";default:return undefined}};scope.buildDataLineageRouteWT1Event=function(datasetSmartName){WT1.tryEvent("data-lineage-access",()=>({from:`${scope.selectedShakerOrigin(scope.shaker.origin)}-shaker-columns-view`,dataseth:md5($stateParams.projectKey+"."+getOutputDatasetOrSmartName(scope,datasetSmartName))}))};scope.isType=function(x){return this.column.selectedType.name==x};scope.possibleMeanings=[];scope.$watch("column.possibleTypes",function(){if(scope.column.possibleTypes==null)return;scope.possibleMeanings=$.map(scope.column.possibleTypes,function(t){return t.name})});scope.setColumnMeaning=function(newMeaning){Assert.trueish(scope.shakerHooks.setColumnMeaning,"no setColumnMeaning function");scope.shakerHooks.setColumnMeaning(scope.column,newMeaning)};scope.editColumnUDM=function(){CreateModalFromTemplate("/templates/meanings/column-edit-udm.html",scope,null,function(newScope){newScope.initModal(scope.column.name,scope.setColumnMeaning)})}}}});app.directive("analysisColumns",function(Fn,ListFilter,DataikuAPI,Logger,CreateModalFromDOMElement,CreateModalFromTemplate,Debounce,MonoFuture,$filter,ShakerSuggestionsEngine,$stateParams){var extractName=Fn.prop("name"),compInfos=["cardinality","mode","min","max","mean","sum","median","stddev"],validInfos=["okPercentage","nokPercentage","emptyPercentage","nonemptyPercentage"],extraInfos=["missingCount","presentCount","invalidCount"];function refreshColumns($scope){var cf=$scope.columnFilter;cf._cols=$scope.table.headers;cf.types=cf._cols.map(Fn.prop(["selectedType","name"])).filter(Fn.unique()).sort();cf.hasFetchedInfos=false;cf.hasFetchedFullInfos=false;cf.hasFetchedFullInfosForPartitionId=null;updateColumnsInfo($scope);if($scope.clearQuickColumnsCache){$scope.clearQuickColumnsCache()}}function copyPropFromData(data,fromProp,c,toProp){c[toProp]=c.name in data&&fromProp in data[c.name]?data[c.name][fromProp]:null}function fetchFullInfo($scope,callback){var cf=$scope.columnFilter;cf.hasFetchedFullInfos=null;var partitionId=$scope.uiState.fullPartitionId;DataikuAPI.shakers.multiColumnFullAnalysis($stateParams.projectKey,$scope.inputDatasetProjectKey,$scope.inputDatasetName,$scope.shakerHooks.shakerForQuery(),partitionId,cf._cols.map(extractName)).success(function(data){compInfos.forEach([].forEach.bind(cf._cols,function(c){copyPropFromData(data,this,c,"full_comp_"+this);copyPropFromData(data,this+"_current",c,"full_comp_"+this+"_current");copyPropFromData(data,this+"_reason",c,"full_comp_"+this+"_reason")}));validInfos.forEach([].forEach.bind(cf._cols,function(c){copyPropFromData(data,this,c,"full_"+this);copyPropFromData(data,this+"_current",c,"full_"+this+"_current");copyPropFromData(data,this+"_reason",c,"full_"+this+"_reason")}));extraInfos.forEach([].forEach.bind(cf._cols,function(c){copyPropFromData(data,this,c,"full_"+this)}));cf.hasFetchedFullInfos=true;cf.hasFetchedFullInfosForPartitionId=partitionId;callback($scope)}).error(setErrorInScope.bind($scope))}function fetchInfo($scope,callback){var cf=$scope.columnFilter;cf.hasFetchedInfos=null;$scope.monoFetch.exec(DataikuAPI.shakers.multiColumnAnalysis($stateParams.projectKey,$scope.inputDatasetProjectKey,$scope.inputDatasetName,$scope.inputStreamingEndpointId,$scope.shakerHooks.shakerForQuery(),$scope.requestedSampleId,cf._cols.map(extractName),"*")).success(function(data){if(!data.hasResult)return;data=data.result;compInfos.forEach([].forEach.bind(cf._cols,function(c){copyPropFromData(data,this,c,"comp_"+this)}));cf.hasFetchedInfos=true;callback($scope)}.bind(this)).error(setErrorInScope.bind($scope))}function prepareInfoValuesForDisplay(cf){var comp=cf.info.substr(0,5)==="comp_";if(comp){cf._cols.forEach(function(c){if(c.info===null||this==="comp_cardinality"){}else switch(c.selectedType.name){case"DoubleMeaning":c.info=c.info.toFixed(4);break;case"Date":case"DateOnly":case"DatetimeNoTz":if(this=="comp_sum"){c.info=null}else{c.info=$filter(this==="comp_stddev"?"friendlyDurationShort":"date")(c.info)}break;default:if(["comp_mean","comp_sum","comp_average","comp_stddev"].indexOf(this)>-1){c.info=c.info.toFixed(4)}}},cf.info)}else{if(cf.info.substr(-10)==="Percentage"){cf._cols.forEach(function(c){c.info=c.info!=null?c.info.toFixed(2)+"%":null})}}}function updateColumnsInfo($scope){var cf=$scope.columnFilter;if(!cf._cols||cf._cols.length===0){return}if($scope.uiState.useFullSampleStatistics){if(cf.hasFetchedFullInfos==false||cf.hasFetchedFullInfos==true&&cf.hasFetchedFullInfosForPartitionId!=$scope.uiState.fullPartitionId){fetchFullInfo($scope,function(){updateColumnsInfo($scope)})}else if(cf.hasFetchedFullInfos==true){cf._cols.forEach(Fn.assign("info",Fn.prop("full_"+cf.info)));cf._cols.forEach(Fn.assign("info_current",Fn.prop("full_"+cf.info+"_current")));cf._cols.forEach(Fn.assign("info_reason",Fn.prop("full_"+cf.info+"_reason")));prepareInfoValuesForDisplay(cf)}}else{if(cf.hasFetchedInfos==false){fetchInfo($scope,function(){updateColumnsInfo($scope)})}else if(cf.hasFetchedInfos==true){cf._cols.forEach(Fn.assign("info",Fn.prop(cf.info)));prepareInfoValuesForDisplay(cf)}}}function selectActions($scope){if($scope.selection===undefined||$scope.selection.selectedObjects===undefined){return}var selectedObjects=$scope.selection.selectedObjects;if(selectedObjects.length===0){$scope.massColumnActions=$scope.massColumnActions2=$scope.hasMoreMassColumnActions=$scope.suggestedTypes=$scope.otherTypes=null;return}var maps=ShakerSuggestionsEngine.computeColumnSuggestions(selectedObjects,CreateModalFromDOMElement,CreateModalFromTemplate,undefined,undefined,$scope.appConfig),colTypes=selectedObjects.map(Fn.prop("possibleTypes")).filter(Array.isArray).map(function(pts){return pts.map(extractName)});$scope.massColumnActions=maps[0];$scope.massColumnActions2=maps[1];$scope.hasMoreMassColumnActions=maps[2]>0;var suggestedTypesNames=colTypes.slice(1).reduce(function(ts,ts2){return ts.filter(Fn.inArray(ts2))},colTypes[0]);$scope.otherTypes=[];$scope.suggestedTypes=[];angular.forEach($scope.types,function(v,k){if(Fn.not(Fn.inArray(suggestedTypesNames))(k)){$scope.otherTypes.push({id:k,name:v})}else{$scope.suggestedTypes.push({id:k,name:v})}})}return{scope:false,controller:function($scope){$scope.uiState={};$scope.monoFetch=MonoFuture($scope);$scope.columnFilter={_cols:$scope.table.headers,info:"okPercentage",types:[],validity:{valid:false,invalid:false,missing:false},meaning:null};function customFilter(objects){var cf=$scope.columnFilter;if(cf.validity.valid||cf.validity.invalid||cf.validity.missing){objects=objects.filter(function(v,i,m,o){return v&&o.selectedType.nbNOK+o.selectedType.nbEmpty===0||i&&o.selectedType.nbNOK>0||m&&o.selectedType.nbEmpty>0}.bind(null,cf.validity.valid,cf.validity.invalid,cf.validity.missing))}if($scope.columnFilter.meaning){objects=objects.filter(object=>object.selectedType.name===$scope.columnFilter.meaning)}return objects}$scope.selection={customFilter:customFilter,customFilterWatch:["columnFilter.validity","columnFilter.meaning"],orderQuery:"$idx"};$scope.$watch("table.headers",function(newVal,oldVal){if(angular.equals(newVal,oldVal))return;refreshColumns($scope)});$scope.$watch("columnFilter.info",updateColumnsInfo.bind(null,$scope));$scope.$watch("uiState.useFullSampleStatistics",updateColumnsInfo.bind(null,$scope));$scope.$watch("uiState.fullPartitionId",updateColumnsInfo.bind(null,$scope));$scope.$watch("selection.selectedObjects",selectActions.bind(null,$scope));$scope.deleteColumns=function(selectedColumns){var colNames=selectedColumns.map(Fn.prop("name"));$scope.addStepNoPreview("ColumnsSelector",{keep:false,appliesTo:"COLUMNS",columns:colNames});$scope.mergeLastColumnDeleters();$scope.autoSaveForceRefresh()};$scope.renameColumns=function(selectedColumns){var colNames=selectedColumns.map(Fn.prop("name"));CreateModalFromTemplate("/templates/shaker/modals/shaker-rename-columns.html",$scope,"MassRenameColumnsController",function(newScope){newScope.$apply(function(){newScope.setColumns(colNames)});newScope.doRenameColumns=function(renamings){var cols=$scope.table.headers;renamings.forEach(function(renaming){cols.forEach(function(h){if(h.name===renaming.from)h.name=renaming.to})});$scope.addStepNoPreview("ColumnRenamer",{renamings:renamings});$scope.mergeLastColumnRenamers();$scope.autoSaveForceRefresh()}})};$scope.changeType=function changeType(selectedColumns,typeName){var colNames=selectedColumns.map(Fn.prop("name"));Logger.info("Set meaning",typeName,"on ",colNames);colNames.forEach(function(c){$scope.shakerHooks.setColumnMeaning({name:c},typeName)});$scope.autoSaveForceRefresh()};$scope.blur=function(){if(document.activeElement.tagName==="INPUT"){document.activeElement.blur()}};$scope.renameColumn=function(column,name){if(column.name!==name){var old=column.name;column.name=name;$scope.addStepNoPreviewAndRefresh("ColumnRenamer",{renamings:[{from:old,to:name}]});$scope.mergeLastColumnRenamers()}};$scope.analyzeColumn=function(column){$scope.analyseColumn(column,$scope.selection.filteredObjects)};$scope.initColumn=function(columnScope){if(columnScope.column){var maps=ShakerSuggestionsEngine.computeColumnSuggestions(columnScope.column,CreateModalFromDOMElement,CreateModalFromTemplate,undefined,undefined,$scope.appConfig);columnScope.actions=maps[0];columnScope.actions2=maps[1];columnScope.name=columnScope.column.name}};$scope.massColumnActions=$scope.massColumnActions2=[];$scope.types=$scope.appConfig.meanings.labelsMap;$scope.columnTypes=function columnTypes(col,probable){var f=Fn.inArray((col.possibleTypes||[]).map(extractName));f=probable?f:Fn.not(f);var ret={};angular.forEach($scope.types,function(v,k){if(f(k)){ret[k]=v}});return ret};$scope.refreshColumnsInfo=function(){$scope.columnFilter.hasFetchedFullInfos=false;updateColumnsInfo($scope)};const keyCodes={del:8};$scope.keydown=function(event){if(event.keyCode==keyCodes.del&&$scope.selection.selectedObjects.length>0){$scope.deleteColumns($scope.selection.selectedObjects)}}}}})})();(function(){"use strict";const app=angular.module("dataiku.analysis.script");app.directive("analysisCharts",function($q,$timeout,Logger,Assert,DataikuAPI,WT1,ActivityIndicator,TopNav,DatasetUtils,ChartsContext,ChartCustomMeasures,ChartTypeChangeHandler,ATSurveyService,DSSVisualizationThemeUtils,ChartNavigationService){return{scope:true,controller:function($scope,$stateParams,$rootScope){$scope.getDataSpec=function(){const currentChart=$scope.charts[$scope.currentChart.index];Assert.trueish(currentChart,"No current chart");const dataSpec={datasetProjectKey:$scope.inputDatasetProjectKey,datasetName:$scope.inputDatasetName,script:angular.copy($scope.shaker),copySelectionFromScript:currentChart.copySelectionFromScript,sampleSettings:currentChart.refreshableSelection,engineType:"LINO"};dataSpec.script.origin="ANALYSIS";return dataSpec};$scope.getExecutePromise=function(request,saveShaker=true,noSpinner=false,requiredSampleId=undefined,dataSpec=$scope.getDataSpec()){const currentChart=$scope.charts[$scope.currentChart.index];Assert.trueish(currentChart,"No current chart");Assert.trueish(currentChart.summary,"Current chart summary is not ready");saveShaker!==false&&$scope.saveShaker();if(request){if(requiredSampleId===undefined){requiredSampleId=currentChart.summary.requiredSampleId}let promise=DataikuAPI.shakers.charts.getPivotResponse($stateParams.projectKey,dataSpec,request,requiredSampleId);if(noSpinner===true){promise=promise.noSpinner()}return promise}};$scope.getLLMChartContext=function(){const spec=$scope.getDataSpec();const datasetProjectKey=spec.datasetProjectKey;const datasetName=spec.datasetName;return{context:"analysis",datasetProjectKey:datasetProjectKey,spec:spec,datasetName:datasetName,getSuggestionsCacheKey(chartDefCacheKey){return chartDefCacheKey?datasetProjectKey+datasetName+chartDefCacheKey:datasetProjectKey+datasetName}}};$scope.saveChart=function(){$scope.saveShaker()};const unregisterChartSamplingChangedEvent=$rootScope.$on("chartSamplingChanged",function(event,opts){if(angular.equals($scope.charts[$scope.currentChart.index],opts.chart)){$scope.clearCachedSummaries();$scope.fetchColumnsSummaryForCurrentChart().then(function(){Logger.info("Sample reloaded, executing chart");$scope.$broadcast("forceExecuteChart")})}});$scope.getDefaultNewChart=function(){var newChart=null;const defaultTheme=DSSVisualizationThemeUtils.getThemeOrDefault($rootScope.appConfig.selectedDSSVisualizationTheme);if($scope.charts.length>0){newChart=angular.copy($scope.charts[$scope.charts.length-1]);newChart.theme=defaultTheme;newChart.def=ChartTypeChangeHandler.defaultNewChart(newChart.theme)}else{newChart={def:ChartTypeChangeHandler.defaultNewChart(defaultTheme),copySelectionFromScript:true,theme:defaultTheme}}newChart.engineType="LINO";return newChart};function acpIsDirty(ignoreThumbnailChanges){try{var savedACP2=angular.copy(savedACP);var acp=angular.copy($scope.acp);if(ignoreThumbnailChanges){acp.charts.forEach(function(chart){chart.def.thumbnailData=null});savedACP2.charts.forEach(function(chart){chart.def.thumbnailData=null})}return!angular.equals(acp,savedACP2)}catch(e){Logger.error(e);return true}}$scope.saveShaker=function(){Logger.info("Save ACP");var ignoreThumbnailChanges=!$scope.isProjectAnalystRW();if(!acpIsDirty(ignoreThumbnailChanges)){Logger.info("No changes: don't save shaker");return}if($scope.isProjectAnalystRW()){DataikuAPI.analysis.saveCore($scope.acp).success(function(data){if(!ActivityIndicator.isDisplayed()){ActivityIndicator.success("Charts saved")}}).error(setErrorInScope.bind($scope)).noSpinner()}else{ActivityIndicator.warning("You don't have write access - not saving")}};var cachedColumnSummaries={};$scope.clearCachedSummaries=function(){$scope.charts.forEach(function(x){x.summary=null});cachedColumnSummaries={}};$scope.fetchColumnsSummaryForCurrentChart=function(forceRefresh){var currentChart=$scope.charts[$scope.currentChart.index];var dataSpec=$scope.getDataSpec();var cacheKey=JSON.stringify(dataSpec).dkuHashCode();var promise=null;if(cachedColumnSummaries[cacheKey]!=null&&!forceRefresh){Logger.info("Already cached for",dataSpec);promise=$q.when(cachedColumnSummaries[cacheKey])}else{Logger.info("No cache for",dataSpec);promise=DataikuAPI.shakers.charts.getColumnsSummary($stateParams.projectKey,dataSpec).error(setErrorInScope.bind($scope)).then(function(response){cachedColumnSummaries[cacheKey]=response.data;return response.data})}return promise.then(function(data){currentChart.summary=data;$scope.makeUsableColumns(data)})};$scope.overrideFormattingWithTheme=function(theme){const currentChart=$scope.charts[$scope.currentChart.index];const currentChartCopy=angular.copy(currentChart);const formerTheme=currentChart.theme;currentChart.theme=theme;DSSVisualizationThemeUtils.applyToChart({chart:currentChart.def,theme:theme,formerTheme:formerTheme});DSSVisualizationThemeUtils.showThemeAppliedSnackbar(currentChart,currentChartCopy)};$scope.$on("$destroy",()=>{DSSVisualizationThemeUtils.hideThemeAppliedSnackbar();unregisterChartSamplingChangedEvent()});var savedACP;var main=function(){WT1.event("analysis-charts-open");ATSurveyService.updateCounter("ChartsOpen");TopNav.setLocation(TopNav.TOP_ANALYSES,TopNav.LEFT_ANALYSES,TopNav.TABS_ANALYSIS,"charts");TopNav.setItem(TopNav.ITEM_ANALYSIS,$stateParams.analysisId);ChartNavigationService.bindCurrentChartWithUrl();$scope.$on("$destroy",()=>{ChartNavigationService.unbindCurrentChartWithUrl()});$scope.$watchGroup(ChartNavigationService.getCurrentChartWatchers($scope),function(chartName){if(chartName){ChartNavigationService.updateCurrentChart($scope.charts,$scope.currentChart.index)}});DataikuAPI.analysis.getCore($stateParams.projectKey,$stateParams.analysisId).success(function(data){$scope.acp=data;$scope.shaker=data.script;$scope.charts=data.charts;$scope.currentChart.index=ChartNavigationService.getChartIndexFromId($scope.charts.map(chart=>chart.def),$stateParams.chartId);savedACP=angular.copy(data);TopNav.setItem(TopNav.ITEM_ANALYSIS,$stateParams.analysisId,{name:data.name,dataset:data.inputDatasetSmartName});TopNav.setPageTitle(data.name);var inputDatasetLoc=DatasetUtils.getLocFromSmart($stateParams.projectKey,data.inputDatasetSmartName);$scope.analysisDataContext.inputDatasetLoc=inputDatasetLoc;$scope.inputDatasetProjectKey=inputDatasetLoc.projectKey;$scope.inputDatasetName=inputDatasetLoc.name;DataikuAPI.datasets.get($scope.inputDatasetProjectKey,$scope.inputDatasetName,$stateParams.projectKey).success(function(data){$scope.dataset=data}).error(setErrorInScope.bind($scope));if($scope.charts.length===0){$scope.addChart({datasetName:$scope.inputDatasetName})}$scope.addCustomMeasuresToScopeAndCache($scope.acp.customMeasures);$scope.addBinnedDimensionToScopeAndCache($scope.acp.reusableDimensions);$scope.addHierarchiesToScopeAndCache($scope.acp.hierarchies);$scope.$watch("charts[currentChart.index]",function(nv){Logger.info("Chart changed, fetching summary and executing");if(nv){$scope.fetchColumnsSummaryForCurrentChart().then(function(){$scope.forceExecuteChartOrWait()})}})}).error(setErrorInScope.bind($scope))};main()}}});app.directive("analysisChartSamplingEditor",function(DataikuAPI,$controller,$rootScope,$stateParams,$timeout,WT1,$q,CreateModalFromTemplate,DatasetUtils){return{scope:{dataset:"=",chart:"=",script:"="},templateUrl:"/templates/analysis/charts-sampling-editor-tab.html",controller:function($scope){$scope.canCopySelectionFromScript=true;$controller("_ChartOnDatasetSamplingEditorBase",{$scope:$scope});$scope.save=function(){if($scope.chart.refreshableSelection){if(!$scope.chart.copySelectionFromScript){WT1.event("chart-sample-setting-update",{chartId:`${$scope.dataset.projectKey.dkuHashCode()}.${$scope.dataset.name.dkuHashCode()}.${$scope.chart.def.name.dkuHashCode()}`,analysis:true,reuseFromExplore:false,samplingMethod:$scope.chart.refreshableSelection.selection.samplingMethod,recordsNumber:$scope.chart.refreshableSelection.selection.maxRecords,targetRatio:$scope.chart.refreshableSelection.selection.targetRatio,filtersNumber:$scope.chart.refreshableSelection.selection.filter&&$scope.chart.refreshableSelection.selection.filter.enabled&&$scope.chart.refreshableSelection.selection.filter.uiData&&$scope.chart.refreshableSelection.selection.filter.uiData.conditions?$scope.chart.refreshableSelection.selection.filter.uiData.conditions.length:0})}else{WT1.event("chart-sample-setting-update",{chartId:`${$scope.dataset.projectKey.dkuHashCode()}.${$scope.dataset.name.dkuHashCode()}.${$scope.chart.def.name.dkuHashCode()}`,analysis:true,reuseFromExplore:true})}$scope.chart.refreshableSelection._refreshTrigger=(new Date).getTime()}$rootScope.$emit("chartSamplingChanged",{chart:$scope.chart})};$scope.saveNoRefresh=function(){$rootScope.$emit("chartSamplingChanged",{chart:$scope.chart})}}}});app.component("columnAnalysis",{bindings:{columnAnalysis:"<",isNumeric:"<?",isDate:"<?",asList:"<?"},templateUrl:"/templates/analysis/column-analysis.html",controller:function(){const $ctrl=this;$ctrl.$onChanges=()=>{$ctrl.data=null;if(!$ctrl.columnAnalysis){return}if($ctrl.isNumeric){$ctrl.data=$ctrl.columnAnalysis.numericalAnalysis}else{$ctrl.data=$ctrl.columnAnalysis.alphanumFacet}}}})})();(function(){"use strict";var app=angular.module("dataiku.analysis.mlcore",["dataiku.ml.core","dataiku.ml.report"]);app.factory("MLTasksNavService",function($state,$stateParams,Fn,Assert,localStorageService){const ret={getActiveMLTaskId:analysisId=>localStorageService.get("analysis."+analysisId+".activeMLTask"),setMlTaskIdToGo:function(analysisId,mlTaskId){return localStorageService.set("analysis."+analysisId+".activeMLTask",mlTaskId)},mlTaskIdToGo:function(analysisMLTasks,analysisId){Assert.trueish(analysisMLTasks.length,"No ML task");var goTo=ret.getActiveMLTaskId(analysisId);if(!goTo||!analysisMLTasks.some(Fn(Fn.prop("mlTaskId"),Fn.eq(goTo)))){goTo=analysisMLTasks[0].mlTaskId}Assert.trueish(goTo,"No ML task to go to");return goTo},link:Fn.dict({PREDICTION:"predmltask",CLUSTERING:"clustmltask"},false),goToCorrectMLTask:function(analysisMLTasks,analysisId){var goTo=ret.mlTaskIdToGo(analysisMLTasks,analysisId),mlTask=analysisMLTasks.filter(Fn(Fn.prop("mlTaskId"),Fn.eq(goTo)))[0],link=mlTask&&ret.link(mlTask.taskType);Assert.trueish(link,"cannot resolve ML task link from taskType");$state.go("projects.project.analyses.analysis.ml."+link+".list.results.sessions",{projectKey:$stateParams.projectKey,analysisId:$stateParams.analysisId,mlTaskId:goTo},{location:"replace"})}};return ret});app.controller("AnalysisMLTasksController",function($scope,DataikuAPI,$q,CreateModalFromTemplate,$state,$stateParams,TopNav,MLTasksNavService){TopNav.setLocation(TopNav.TOP_ANALYSES,TopNav.LEFT_ANALYSES,TopNav.TABS_ANALYSIS,"models");TopNav.setItem(TopNav.ITEM_ANALYSIS,$stateParams.analysisId);DataikuAPI.analysis.getCore($stateParams.projectKey,$stateParams.analysisId).success(function(data){$scope.analysisCoreParams=data;TopNav.setItem(TopNav.ITEM_ANALYSIS,$stateParams.analysisId,{name:data.name,inputDatasetSmartName:data.inputDatasetSmartName});TopNav.setPageTitle(data.name+" - Analysis");DataikuAPI.analysis.listMLTasks($stateParams.projectKey,$stateParams.analysisId).success(function(data){$scope.analysisMLTasks=data;if($scope.analysisMLTasks.length){MLTasksNavService.goToCorrectMLTask($scope.analysisMLTasks,$stateParams.analysisId)}})}).error(setErrorInScope.bind($scope));$scope.createNewMLTask=CreateModalFromTemplate.bind(null,"/templates/analysis/new-mltask-modal.html",$scope,"AnalysisNewMLTaskController")});app.directive("iframeOnload",[function(){return{scope:{callBack:"&iframeOnload"},link:function(scope,element,attrs){element.on("load",function(){scope.$apply(function(){scope.callBack({element:element[0]})})})}}}]);app.controller("AnalysisNewMLTaskController",function($scope,$rootScope,$controller,$state,$location,$timeout,DataikuAPI,FeatureFlagsService){$controller("DatasetLabController",{$scope:$scope});$scope.datasetSmartName=$scope.analysisCoreParams.inputDatasetSmartName;$scope.useCurrentAnalysisForNewMlTask=true;$scope.createClusteringTemplate=function(){DataikuAPI.analysis.cml.createAndGuess($scope.analysisCoreParams.projectKey,$scope.analysisCoreParams.id,$scope.clusteringTaskData.backendType,$scope.clusteringTaskData.backendName,$scope.clusteringTaskData.selectedPolicy.id).success(data=>{$rootScope.mlTaskJustCreated=true;if($scope.clusteringTaskData.selectedPolicy.id==="ALGORITHMS"||$scope.clusteringTaskData.selectedPolicy.id==="CUSTOM"){$state.go("projects.project.analyses.analysis.ml.clustmltask.list.design.clustering-algorithms",{mlTaskId:data.id})}else{$state.go("projects.project.analyses.analysis.ml.clustmltask.list.results.sessions",{mlTaskId:data.id})}}).error(setErrorInScope.bind($scope))};$scope.mlTaskTypes=[{name:"AutoML Prediction",description:"Understand and predict what is next.",img:"icon-dku-automl-prediction",openSpecificModal:datasetSmartName=>$scope.newPrediction(undefined,datasetSmartName)},{name:"Time Series Forecasting",description:"Predict future data based on existing data.",img:"icon-dku-timeseries-forecasting",openSpecificModal:$scope.newTimeseriesForecastPrediction},{name:"Causal Prediction",description:"Predict the effect of a treatment on an outcome",img:"icon-dku-causal",openSpecificModal:$scope.newCausalPrediction},{name:"AutoML Clustering",description:"Look for patterns in data.",img:"icon-dku-automl-clustering",openSpecificModal:$scope.newClustering},{name:"Object Detection",description:"Locate objects in images.",img:"icon-dku-deephub-object-detection",openSpecificModal:datasetSmartName=>$scope.newDeepHubPrediction(datasetSmartName,"DEEP_HUB_IMAGE_OBJECT_DETECTION")},{name:"Image Classification",description:"Label images into specific classes.",img:"icon-dku-deephub-image-classification",openSpecificModal:datasetSmartName=>$scope.newDeepHubPrediction(datasetSmartName,"DEEP_HUB_IMAGE_CLASSIFICATION")}]})})();(function(){"use strict";const app=angular.module("dataiku.analysis.mlcore");app.controller("MLTaskFeaturesController",function($scope,$controller,$timeout,$stateParams,$rootScope,Assert,ColumnAnalysesService,DataikuAPI,Fn,Dialogs,PMLSettings,$q,VisualMlCodeEnvCompatibility,CreateModalFromTemplate,Logger,DatasetUtils,MLFeaturesService){Assert.inScope($scope,"analysisCoreParams");$scope.columnAnalysesService=ColumnAnalysesService.init($scope.analysisCoreParams,setErrorInScope.bind($scope));const PROTECTED_ROLES=["TARGET","WEIGHT"];$scope.featureAutoHandlingReason={REJECT_ZERO_VARIANCE:"DSS has rejected this feature because all values of this feature are equal.",REJECT_MISSING:"DSS has rejected this feature because too many values are missing in this feature.",REJECT_IDENTIFIER:"DSS has rejected this feature because this feature looks like a unique identifier.",REJECT_DEFAULT_TEXT_HANDLING:"DSS rejects text features by default.",REJECT_CARDINALITY:"DSS has rejected this feature because it had too many categories for the task at hand."};$scope.featureAutoHandlingShortReason={REJECT_ZERO_VARIANCE:"too many equal values",REJECT_MISSING:"too many missing values",REJECT_IDENTIFIER:"unique ID",REJECT_DEFAULT_TEXT_HANDLING:"text feature",REJECT_CARDINALITY:"too many categories"};$scope.categoryHandlingModes=function(){if($scope.isMLBackendType("H2O")){return[["NONE","H2O feature handling"],["DUMMIFY","Dummy encoding (vectorization)"]]}const categoryHandlingModes=[["DUMMIFY","Dummy encoding (vectorization)"],["FLAG_PRESENCE","Replacing by 0/1 flag indicating presence"]];if($scope.isMLBackendType("PY_MEMORY")||$scope.isMLBackendType("KERAS")){if($scope.mlTasksContext.activeMLTask.taskType==="PREDICTION"){categoryHandlingModes.push(["IMPACT","Target encoding"])}categoryHandlingModes.push(["ORDINAL","Ordinal encoding"],["FREQUENCY","Frequency encoding"],["HASHING","Feature hashing (for high cardinality)"],["CUSTOM","Custom preprocessing"])}return categoryHandlingModes}();$scope.numericalHandlingModes=function(){const numericalHandlingModes=[["REGULAR","Keeping as a regular numerical feature"],["FLAG_PRESENCE","Replacing by 0/1 flag indicating presence"],["BINARIZE","Binarization based on a threshold"],["QUANTILE_BIN","Quantization"]];if($scope.isMLBackendType("PY_MEMORY")||$scope.isMLBackendType("KERAS")){numericalHandlingModes.push(["DATETIME_CYCLICAL","Cyclical datetime encoding"],["CUSTOM","Custom preprocessing"])}return numericalHandlingModes}();$scope.textHandlingModes=function(){const textHandlingModes=[["TOKENIZE_HASHING","Tokenization and hashing"],["TOKENIZE_HASHING_SVD","Tokenization, hashing and SVD"],["TOKENIZE_COUNTS","Count vectorization"],["TOKENIZE_TFIDF","TF/IDF vectorization"]];if($scope.isMLBackendType("PY_MEMORY")||$scope.isMLBackendType("KERAS")){textHandlingModes.push(["SENTENCE_EMBEDDING","Text embedding"]);textHandlingModes.push(["CUSTOM","Custom preprocessing"])}return textHandlingModes}();$scope.vectorHandlingModes=[["UNFOLD","Unfolding (creating one column per element)"]];$scope.imageHandlingModes=function(){const imageHandlingModes=[];if($scope.isMLBackendType("KERAS")){imageHandlingModes.push(["CUSTOM","Custom preprocessing"])}if($scope.isMLBackendType("PY_MEMORY")&&$scope.mlTasksContext.activeMLTask.taskType==="PREDICTION"){imageHandlingModes.push(["EMBEDDING_EXTRACTION","Image embedding"])}return imageHandlingModes}();$scope.dummyClippingModes=[["MAX_NB_CATEGORIES","Max nb. categories"],["CUMULATIVE_PROPORTION","Cumulative proportion"],["MIN_SAMPLES","Minimum samples"]];$scope.dummyDrops=[["AUTO","Let DSS decide"],["NONE","Don't drop"],["DROP","Drop one dummy"]];$scope.setMissingValuesModes=function(feature){switch(feature.type){case"CATEGORY":$scope.missingValuesModes=[["NONE","Treat as a regular value"],["IMPUTE","Impute ..."],["DROP_ROW","Drop rows (don't predict them either)"]];break;case"NUMERIC":if(feature.numerical_handling==="BINARIZE"||feature.numerical_handling==="QUANTILE_BIN"){$scope.missingValuesModes=[["IMPUTE","Impute ..."]]}else if(feature.numerical_handling==="DATETIME_CYCLICAL"){$scope.missingValuesModes=[["DROP_ROW","Drop rows (don't predict them either)"]]}else{$scope.missingValuesModes=[["IMPUTE","Impute ..."],["DROP_ROW","Drop rows (don't predict them either)"]];let isCompatibleWithNans=$scope.mlTaskDesign.backendType=="PY_MEMORY"&&$scope.mlTaskDesign.taskType=="PREDICTION"&&!$scope.isTimeseriesPrediction()&&!$scope.isCausalPrediction();if(isCompatibleWithNans){$scope.missingValuesModes.push(["KEEP_NAN_OR_IMPUTE","Keep empty | Impute for incompatible algorithms"]);$scope.missingValuesModes.push(["KEEP_NAN_OR_DROP","Keep empty | Drop rows for incompatible algorithms"])}};break;case"VECTOR":$scope.missingValuesModes=[["DROP_ROW","Drop rows (don't predict them either)"],["IMPUTE","Impute ..."],["NONE","Fail if missing values found"]];break;case"IMAGE":$scope.missingValuesModes=[["DROP_ROW","Drop rows (don't predict them either)"],["NONE","Fail if missing values found"]];if(!$scope.isMLBackendType("KERAS")){$scope.missingValuesModes.push(["IMPUTE","Impute missing values with empty embeddings (zeros)"])}break;case"TEXT":break;default:Logger.info("Invalid feature type: ",feature.type)}};$scope.categoryMissingHandlingImputeWithModes=[["MODE","Most frequent value"],["CONSTANT","A constant value"]];$scope.vectorMissingHandlingImputeWithModes=[["MODE","Most frequent value"],["CONSTANT","A vector filled with a single value"]];$scope.numericalMissingHandlingImputeWithModes=[["MEAN","Average of values"],["MEDIAN","Median of values"],["CONSTANT","A constant value"]];$scope.rescalingModes=[["NONE","No rescaling"],["MINMAX","Min-max rescaling"],["AVGSTD","Standard rescaling"]];$scope.monotonicModes=[["NONE","No Constraint"],["INCREASE","Increasing"],["DECREASE","Decreasing"]];$scope.binarizeThresholdModes=[["MEAN","Average of values"],["MEDIAN","Median of values"],["CONSTANT","A constant value"]];$scope.categoryOrdinalOrders=[["COUNT","Row count"],["LEXICOGRAPHIC","Lexicographic"]];$scope.categoryOrdinalDefaultModes=[["HIGHEST","Highest value (maximum + 1)"],["MEDIAN","Median of values"],["EXPLICIT","A constant value"]];$scope.categoryFrequencyDefaultModes=[["MIN","Minimum computed value"],["MEDIAN","Median of computed values"],["MAX","Maximum computed value"],["EXPLICIT","A constant value"]];$scope.sendToInputModes=[["MAIN","Main input"],["OTHER","Other input"]];function fillInitialCustomHandlingCode(nv,ov){if(nv=="CUSTOM"&&($scope.selection.selectedObject.customHandlingCode==null||$scope.selection.selectedObject.customHandlingCode.length==0)){if($scope.isMLBackendType("KERAS")&&$scope.selection.selectedObject.type==="TEXT"){$scope.selection.selectedObject.customHandlingCode="from dataiku.doctor.deep_learning.preprocessing import TokenizerProcessor\n\n"+"# Defines a processor that tokenizes a text. It computes a vocabulary on all the corpus.\n"+"# Then, each text is converted to a vector representing the sequence of words, where each \n"+"# element represents the index of the corresponding word in the vocabulary. The result is \n"+"# padded with 0 up to the `max_len` in order for all the vectors to have the same length.\n\n"+"#   num_words  - maximum number of words in the vocabulary\n"+"#   max_len    - length of each sequence. If the text is longer,\n"+"#                it will be truncated, and if it is shorter, it will be padded\n"+"#                with 0.\n"+"processor = TokenizerProcessor(num_words=10000, max_len=32)"}else if($scope.selection.selectedObject.type==="CATEGORY"||$scope.selection.selectedObject.type==="TEXT"){$scope.selection.selectedObject.customHandlingCode="from sklearn.feature_extraction import text\n\n"+"# Applies count vectorization to the feature\n"+"processor = text.CountVectorizer()\n"}else if($scope.selection.selectedObject.type=="NUMERIC"){$scope.selection.selectedObject.customHandlingCode="from sklearn import preprocessing\nimport numpy as np\n\n"+"# Applies log transformation to the feature\n"+"processor = preprocessing.FunctionTransformer(np.log1p)\n";$scope.selection.selectedObject.customProcessorWantsMatrix=true}$timeout(function(){$rootScope.$broadcast("reflow")})}}function onNumericalHandlingChange(oldVersion,newVersion){fillInitialCustomHandlingCode(oldVersion,newVersion);const selectedFeature=$scope.selection.selectedObject;if(selectedFeature){$scope.setMissingValuesModes(selectedFeature);fixupDatetimeParamsIfNeeded(selectedFeature)}}function fixupDatetimeParamsIfNeeded(selectedFeature){if(selectedFeature&&selectedFeature.numerical_handling=="DATETIME_CYCLICAL"){$scope.columnAnalysesService.fetchColumnAnalysisIfNeeded(selectedFeature._name).then(columnAnalysis=>{const numericalAnalysis=(columnAnalysis||{}).numericalAnalysis||{};if(!selectedFeature.datetime_cyclical_periods||selectedFeature.datetime_cyclical_periods.length==0){selectedFeature.datetime_cyclical_periods=numericalAnalysis.relevantPeriods||[]}$scope.periodHistograms=numericalAnalysis.periodHistograms})}}$scope.$watch("selection.selectedObject.category_handling",fillInitialCustomHandlingCode);$scope.$watch("selection.selectedObject.text_handling",fillInitialCustomHandlingCode);$scope.$watch("selection.selectedObject.numerical_handling",onNumericalHandlingChange);$scope.$watch("selection.selectedObject",function(nv,ov){$timeout(function(){$rootScope.$broadcast("reflow")});if(nv){$scope.columnAnalysesService.fetchColumnAnalysisIfNeeded(nv._name);$scope.fixupFeatureConfiguration(nv,ov);if(ov===null||nv?.$idx!==ov?.$idx){$scope.setMissingValuesModes(nv)}if($scope.missingValuesModes&&nv.missing_handling&&!$scope.missingValuesModes.some(mode=>mode[0]===nv.missing_handling)){nv.missing_handling=$scope.missingValuesModes[0][0]}}},true);$scope.fixupFeatureConfiguration=function(feature,oldFeature){if(feature.role=="REJECT"||PROTECTED_ROLES.includes(feature.role)){if($scope.isMLBackendType("KERAS")){handleSwitchingToSpecialFeature(feature,oldFeature)}return}if(feature.type=="CATEGORY"){if(!feature.category_handling){feature.category_handling="DUMMIFY"}if(feature.category_handling=="DUMMIFY"&&!feature.max_nb_categories){feature.max_nb_categories=100}if(feature.category_handling=="DUMMIFY"&&!feature.max_cat_safety){feature.max_cat_safety=200}if(feature.category_handling=="DUMMIFY"&&!feature.dummy_drop){feature.dummy_drop="AUTO"}if(feature.category_handling=="DUMMIFY"&&!feature.cumulative_proportion){feature.cumulative_proportion=.95}if(feature.category_handling=="DUMMIFY"&&!feature.min_samples){feature.min_samples=10}if(feature.category_handling=="DUMMIFY"&&!feature.dummy_clip){feature.dummy_clip="CUMULATIVE_PROPORTION"}if(feature.category_handling=="HASHING"&&!feature.nb_bins_hashing){feature.nb_bins_hashing=1048576}if(feature.category_handling=="IMPACT"&&feature.impact_method===undefined){feature.impact_method="M_ESTIMATOR"}if(feature.category_handling=="IMPACT"&&feature.impact_m===undefined){feature.impact_m=10}if(feature.category_handling=="IMPACT"&&feature.impact_kfold===undefined){feature.impact_kfold=true}if(feature.category_handling=="IMPACT"&&feature.impact_kfold_k===undefined){feature.impact_kfold_k=5}if(feature.category_handling=="IMPACT"&&feature.impact_kfold_seed===undefined){feature.impact_kfold_seed=1337}if(feature.category_handling=="IMPACT"&&feature.categorical_rescaling===undefined){feature.categorical_rescaling="AVGSTD"}if(feature.category_handling=="ORDINAL"&&feature.ordinal_order===undefined){feature.ordinal_order="COUNT"}if(feature.category_handling=="ORDINAL"&&feature.ordinal_ascending===undefined){feature.ordinal_ascending=false}if(feature.category_handling=="ORDINAL"&&feature.ordinal_default_mode===undefined){feature.ordinal_default_mode="HIGHEST"}if(feature.category_handling=="ORDINAL"&&feature.ordinal_default_value===undefined){feature.ordinal_default_value=-1}if(feature.category_handling=="FREQUENCY"&&feature.frequency_default_mode===undefined){feature.frequency_default_mode="EXPLICIT"}if(feature.category_handling=="FREQUENCY"&&feature.frequency_default_value===undefined){feature.frequency_default_value=0}if(feature.category_handling=="FREQUENCY"&&feature.frequency_normalized===undefined){feature.frequency_normalized=true}if(feature.category_handling=="FREQUENCY"&&feature.categorical_rescaling===undefined){feature.categorical_rescaling="AVGSTD"}if(!feature.missing_handling){feature.missing_handling="IMPUTE"}if(feature.missing_handling==="IMPUTE"&&!["MODE","CONSTANT"].includes(feature.missing_impute_with)){feature.missing_impute_with="MODE"}}else if(feature.type=="NUMERIC"){if(!feature.numerical_handling){feature.numerical_handling="REGULAR";feature.rescaling="AVGSTD"}if(!feature.missing_handling){feature.missing_handling="IMPUTE"}if(feature.missing_handling==="IMPUTE"&&!["MEAN","MEDIAN","CONSTANT"].includes(feature.missing_impute_with)){feature.missing_impute_with="MEDIAN"}if(feature.numerical_handling==="BINARIZE"&&!["MEAN","MEDIAN","CONSTANT"].includes(feature.binarize_threshold_mode)){feature.binarize_threshold_mode="MEDIAN"}if(feature.numerical_handling==="QUANTILE_BIN"&&feature.quantile_bin_nb_bins===undefined){feature.quantile_bin_nb_bins=4}if(feature.numerical_handling==="DATETIME_CYCLICAL"&&!feature.datetime_cyclical_periods){feature.datetime_cyclical_periods=[]}feature.category_handling=undefined}else if(feature.type=="TEXT"){if(!feature.text_handling){feature.text_handling="TOKENIZE_HASHING_SVD"}if(!feature.hashSize){feature.hashSize=2e5}if(!feature.hashSVDSVDLimit){feature.hashSVDSVDLimit=5e4}if(!feature.hashSVDSVDComponents){feature.hashSVDSVDComponents=100}if(!feature.minRowsRatio){feature.minRowsRatio=.001}if(!feature.maxRowsRatio){feature.maxRowsRatio=.8}if(!feature.maxWords){feature.maxWords=0}if(!feature.ngramMinSize){feature.ngramMinSize=1}if(!feature.ngramMaxSize){feature.ngramMaxSize=1}if(!feature.stopWordsMode){feature.stopWordsMode="NONE"}if(!feature.maxSequenceLength){feature.maxSequenceLength=128}if(!feature.sentenceEmbeddingBatchSize){feature.sentenceEmbeddingBatchSize=32}}else if(feature.type=="VECTOR"){if(!feature.vector_handling){feature.vector_handling="UNFOLD"}if(feature.missing_handling==="IMPUTE"){if(!["MODE","CONSTANT"].includes(feature.missing_impute_with)){feature.missing_impute_with="MODE"}else if(feature.missing_impute_with==="CONSTANT"&&!feature.impute_constant_value){feature.impute_constant_value="0"}}else if(!feature.missing_handling){feature.missing_handling="DROP_ROW"}}else if(feature.type==="IMAGE"){if(!feature.image_handling){if($scope.isMLBackendType("KERAS")){feature.image_handling="CUSTOM"}else{feature.image_handling="EMBEDDING_EXTRACTION"}}if(feature.image_handling==="CUSTOM"&&feature.customHandlingCode===""){feature.customHandlingCode=getCustomImageHandlingCode()}if(!feature.missing_handling){feature.missing_handling="DROP_ROW"}}if($scope.isMLBackendType("KERAS")){handleSwitchingToSpecialFeature(feature,oldFeature)}};MLFeaturesService.getDatasetColumns($scope.analysisCoreParams).then(function(datasetColumns){function addDataSetColumnId(){MLFeaturesService.addDataSetColumnId($scope.mlTaskDesign.preprocessing.per_feature,datasetColumns);if($scope.updateSorted){$scope.updateSorted()}}addDataSetColumnId();$scope.$watch("mlTaskDesign.preprocessing.per_feature",addDataSetColumnId)}).catch(setErrorInScope.bind($scope));$scope.acceptDSSChange=function(feature){Assert.trueish(feature.state.dssWantsToSet,"unexpected call to acceptDSSChange");var oldState=feature.state;$.each(feature.state.dssWantsToSet,function(k,v){feature[k]=v});feature.state={userModified:false,recordedMeaning:oldState.recordedMeaning}};$scope.isMonotonicityCompatible=function(featureSettings){return featureSettings.type=="NUMERIC"&&featureSettings.numerical_handling=="REGULAR"};$scope.someMonotonicConstraints=function(){return Object.values($scope.uiState.preprocessingPerFeature).some(x=>x.role=="INPUT"&&x.type=="NUMERIC"&&x.numerical_handling=="REGULAR"&&x.monotonic!="NONE")};$scope.warnMonotonicConstraintsIncompatibility=function(){if(!$scope.someMonotonicConstraints()){return false}else{const algosWithoutMonotonicConstraintSupport=new Set(["gbt_classification","gbt_regression","ridge_regression","lasso_regression","leastsquare_regression","sgd_regression","sgd_classifier","knn","logistic_regression","neural_network","svc_classifier","svm_regression","lars_params","deep_neural_network_regression","deep_neural_network_classification"]);$scope.uiState.selectedAlgorithmsWithMonotonicConstraintsIncompatibility=[];const modeling=$scope.mlTaskDesign.modeling;$scope.base_algorithms[$scope.mlTaskDesign.backendType].forEach(function(x){if(modeling[x.algKey]&&modeling[x.algKey].enabled&&algosWithoutMonotonicConstraintSupport.has(x.algKey)||modeling.plugin_python&&modeling.plugin_python[x.algKey]&&modeling.plugin_python[x.algKey].enabled){$scope.uiState.selectedAlgorithmsWithMonotonicConstraintsIncompatibility.push(x.name)}});if(modeling.custom_python.some(x=>x.enabled)){$scope.uiState.selectedAlgorithmsWithMonotonicConstraintsIncompatibility.push("Custom Python model")}return $scope.uiState.selectedAlgorithmsWithMonotonicConstraintsIncompatibility.length>0}};$scope.groupSet=function(newContent){for(let i in $scope.selection.selectedObjects){let feature=$scope.selection.selectedObjects[i];if(PROTECTED_ROLES.includes(feature.role)){continue}let modified=false;for(let k in newContent){if(feature[k]!==newContent[k]){feature[k]=newContent[k];modified=true}}if(modified){if(!feature.state)feature.state={};feature.state.userModified=true;$scope.fixupFeatureConfiguration(feature)}}};$scope.isGroupSetUseful=function(newContent){for(let i in $scope.selection.selectedObjects){let feature=$scope.selection.selectedObjects[i];if(PROTECTED_ROLES.includes(feature.role)){continue}for(let k in newContent){if(feature[k]!==newContent[k]){return true}}}return false};$scope.groupCheck=function(newContent){return!$scope.isGroupSetUseful(newContent)};$scope.supportsImagePreprocessing=function(){return $scope.imageHandlingModes.length>0};$scope.imputeWithConstant=function(){var options={type:"text"};if($scope.selection.selectedObjects.some(function(f){return f.role!=="TARGET"&&f.type==="NUMERIC"})){options.type="number"}Dialogs.prompt($scope,"Impute with constant "+options.type,"Imputed value","",options).then(function(value){$scope.groupSet({missing_handling:"IMPUTE",missing_impute_with:"CONSTANT",impute_constant_value:options.type==="number"?parseFloat(value):value})})};$scope.sendToDeepLearningInput=function(){var inputs=$scope.mlTaskDesign.modeling.keras.kerasInputs.filter(function(input){return!PMLSettings.isSpecialInput(input,$scope.mlTaskDesign.preprocessing.per_feature)}).map(function(input){return{title:input}});Dialogs.select($scope,"Send to Deep Learning input","Please select the input",inputs,inputs[0]).then(function(selectedInput){$scope.selection.selectedObjects.forEach(function(featParams){if(featParams.role=="TARGET"){return}if(!PMLSettings.isSpecialFeature(featParams)){featParams.sendToInput=selectedInput.title}})})};function getNewInputName(featureName,currentInputs){var newInputName=featureName+"_preprocessed";if(currentInputs.indexOf(newInputName)==-1){return newInputName}else{var i=1;while(true){var suffix="_"+i;if(currentInputs.indexOf(newInputName+suffix)==-1){return newInputName+suffix}i+=1}}}function handleSwitchingToSpecialFeature(nv,ov){if(nv==ov||!nv||!ov||nv._name!==ov._name){return}const nvSpecial=PMLSettings.isSpecialFeature(nv);const ovSpecial=PMLSettings.isSpecialFeature(ov);if(nv.role!==ov.role&&nvSpecial&&ovSpecial){if(nv.role==="INPUT"&&ov.role==="REJECT"){createNewSpecialInputAndAssignToFeature(nv)}if(nv.role==="REJECT"&&ov.role==="INPUT"){deleteSpecialInputAndSendFeatureToMain(nv)}return}if(nvSpecial===ovSpecial){return}if(nvSpecial){createNewSpecialInputAndAssignToFeature(nv)}else{deleteSpecialInputAndSendFeatureToMain(nv)}}function createNewSpecialInputAndAssignToFeature(feature){var newInputName=getNewInputName(feature._name,$scope.mlTaskDesign.modeling.keras.kerasInputs);$scope.mlTaskDesign.modeling.keras.kerasInputs.push(newInputName);feature.sendToInput=newInputName}function deleteSpecialInputAndSendFeatureToMain(feature){var inputTodelete=feature.sendToInput;var inputIndex=$scope.mlTaskDesign.modeling.keras.kerasInputs.indexOf(inputTodelete);$scope.mlTaskDesign.modeling.keras.kerasInputs.splice(inputIndex,1);feature.sendToInput="main"}function getCustomImageHandlingCode(){const importPrefix=VisualMlCodeEnvCompatibility.isEnvAtLeastTensorflow2_2($scope.mlTaskDesign,$scope.codeEnvsCompat)?"from tensorflow.keras.":"from keras.";const prepImgCode=importPrefix+"applications.imagenet_utils import preprocess_input\n"+"from dataiku.doctor.deep_learning.keras_utils import load_img\n\n"+"resized_width = 197\n"+"resized_height = 197\n\n"+"# Must return a numpy ndarray representing the image.\n"+"#  - image_file is a file like object\n"+"def preprocess_image(image_file):\n"+"    # This will give you an input shape of (resized_height, resized_width, channels_number)\n"+"    # resized_dims - a tuple (width, height)\n"+"    # channels     - 'L', 'RGB' or 'CMYK'\n"+"    # data_format  - 'channels_last' or 'channels_first'\n"+"    array = load_img(image_file, resized_dims=(resized_width, resized_height), channels='RGB', data_format='channels_last')\n"+"    # Define the actual preprocessing here, for example:\n\n"+"    array = preprocess_input(array, mode='tf')\n"+"    return array\n";return prepImgCode}$scope.isSpecialFeature=function(){var featureData=$scope.selection.selectedObject;return PMLSettings.isSpecialFeature(featureData)};$scope.isNotSpecialInputOrIsSpecialSelection=function(input){var featureData=$scope.selection.selectedObject;return PMLSettings.isSpecialFeature(featureData)||!PMLSettings.isSpecialInput(input,$scope.mlTaskDesign.preprocessing.per_feature)};$scope.setSubsampleFit=function(){let deferred=$q.defer();let newScope=$scope.$new();newScope.uiState={preprocessingFitSampleRatio:$scope.mlTaskDesign.preprocessing.preprocessingFitSampleRatio,preprocessingFitSampleSeed:$scope.mlTaskDesign.preprocessing.preprocessingFitSampleSeed};CreateModalFromTemplate("templates/analysis/prediction/set-subsample-fit-modal.html",newScope,null,function(scope){scope.acceptDeferred=deferred;scope.validate=function(){scope.acceptDeferred.resolve(scope.uiState);scope.dismiss()};scope.showHideMore=function(){scope.uiState.showMore=!scope.uiState.showMore}});deferred.promise.then(function(data){$scope.mlTaskDesign.preprocessing.preprocessingFitSampleRatio=data.preprocessingFitSampleRatio;$scope.mlTaskDesign.preprocessing.preprocessingFitSampleSeed=data.preprocessingFitSampleSeed})};$scope.togglePeriod=function(period){const feature=$scope.selection.selectedObject;const idx=feature.datetime_cyclical_periods.indexOf(period);if(idx>-1){feature.datetime_cyclical_periods.splice(idx,1)}else{feature.datetime_cyclical_periods.push(period)}};$scope.selection={orderQuery:"datasetColumnId"};Object.defineProperty($scope,"roleIsSelected",{get:function(){return $scope.feature.role==="INPUT"||$scope.feature.role==="INPUT_PAST_ONLY"},set:function(value){$scope.feature.role=value?"INPUT":"REJECT"}});$scope.setFeatureRole=function(featureRole){const feature=$scope.selection.filteredObjects.filter(o=>o._name===featureRole._name)[0];let state;if(["INPUT","INPUT_PAST_ONLY"].includes(featureRole.role)){state="REJECT"}else{state="INPUT"}if(feature){feature.role=state}};$scope.hasShiftFromHorizon=function(feature){return $scope.mlTaskDesign.preprocessing.feature_generation.shifts[feature._name]!==undefined&&$scope.mlTaskDesign.preprocessing.feature_generation.shifts[feature._name].from_horizon&&$scope.mlTaskDesign.preprocessing.feature_generation.shifts[feature._name].from_horizon.length>0};$scope.handleChangeInputMode=function(feature,newRole){if(feature.role===newRole){return}feature.role=newRole;if(feature.role==="REJECT"){$scope.selection.selectedObject=undefined;$scope.selection.selectedObjects=[];return}else{$scope.selection.selectedObject=feature;$scope.selection.selectedObjects=[feature]}const oldFeature=angular.copy(feature);$scope.fixupFeatureConfiguration(feature,oldFeature);if($scope.hasShiftFromHorizon(feature)){CreateModalFromTemplate("/templates/analysis/mlcommon/settings/time-series-reset-shift-modal.html",$scope,"PMLChangeBasicParamsModal",function(newScope){newScope.feature=feature})}};$scope.handleMultipleInputChange=function(features,newRole){if($scope.mlTaskDesign.predictionType!=="TIMESERIES_FORECAST"){$scope.groupSet({role:newRole});return}let shouldOpenModal=false;for(let feature of features.filter(feature=>feature.role!==newRole)){const oldFeature=angular.copy(feature);feature.role=newRole;$scope.fixupFeatureConfiguration(feature,oldFeature);if($scope.hasShiftFromHorizon(feature)){shouldOpenModal=true}}if(shouldOpenModal){CreateModalFromTemplate("/templates/analysis/mlcommon/settings/time-series-reset-shift-modal.html",$scope,"PMLChangeBasicParamsModal",function(newScope){newScope.features=features})}};$scope.handleMultipleTypeChange=function(features,targetType){if($scope.mlTaskDesign.predictionType!=="TIMESERIES_FORECAST"){$scope.groupSet({type:targetType});return}let shouldOpenModal=false;for(let feature of features.filter(feature=>feature.type!==targetType)){feature.type=targetType;if($scope.hasShiftFromHorizon(feature)){shouldOpenModal=true}}if(shouldOpenModal){CreateModalFromTemplate("/templates/analysis/mlcommon/settings/time-series-reset-shift-modal.html",$scope,"PMLChangeBasicParamsModal",function(newScope){newScope.features=features})}}});app.controller("MLTaskOneFeatureController",function($scope,PMLSettings,$stateParams,$filter,DataikuAPI,VisualMlCodeEnvCompatibility,Dialogs){$scope.onVariableTypeChange=function(){const featureData=$scope.selection.selectedObject;if(featureData.type==="VECTOR"){if(featureData.vector_handling===undefined){featureData.vector_handling="UNFOLD";featureData.missing_impute_with="MODE"}}$scope.setMissingValuesModes(featureData);if(!$scope.missingValuesModes.some(mode=>mode[0]===featureData.missing_handling)){featureData.missing_handling=$scope.missingValuesModes[0][0]}if(!$scope.featureSupportsAutoShifts(featureData)){$scope.mlTaskDesign.preprocessing.feature_generation.shifts[featureData._name].from_horizon_mode="FIXED"}};$scope.onVariableRoleChange=function(){console.debug("onVariableRoleChange",$scope.feature)};$scope.$watch("uiState.managedFolderSmartId",function(newValue){if($scope.mlTaskDesign.managedFolderSmartId!==newValue){if(!$scope.mlTaskDesign.managedFolderSmartId){onChangeManagedFolder()}else{const featuresUsingManagedFolder=getFeaturesUsingManagedFolder();const currentFeatureName=$scope.selection.selectedObject._name;if(featuresUsingManagedFolder.includes(currentFeatureName)){featuresUsingManagedFolder.splice(featuresUsingManagedFolder.indexOf(currentFeatureName),1)}if(featuresUsingManagedFolder.length>0){Dialogs.confirm($scope,"Changing the image location",`Image location folder is currently used for the following features preprocessings: ${featuresUsingManagedFolder}.
                         Changing the image location will update the current feature preprocessing as well as those of the above features.`).then(onChangeManagedFolder,onAbortChangeManagedFolder)}else{onChangeManagedFolder()}}}},true);function onChangeManagedFolder(){$scope.mlTaskDesign.managedFolderSmartId=$scope.uiState.managedFolderSmartId}function onAbortChangeManagedFolder(){$scope.uiState.managedFolderSmartId=$scope.mlTaskDesign.managedFolderSmartId}function getFeaturesUsingManagedFolder(){if($scope.isMLBackendType("KERAS")){return[]}var featuresUsingManagedFolder=[];for(const feature of $scope.selection.allObjects){if(feature.role=="INPUT"&&feature.type=="IMAGE"){featuresUsingManagedFolder.push(feature._name)}}return featuresUsingManagedFolder}$scope.puppeteerHook_elementContentLoaded=true;$scope.$watch("selection.selectedObject",function(newValue,oldValue){if(newValue){$scope.canPreprocess=newValue.role!="TARGET"&&newValue.role!="REJECT"&&newValue.role!="WEIGHT"&&newValue.role!="TREATMENT"}},true);let hasFetchedImageEmbeddingModelOptions=false;function setImageEmbeddingModelsOptions(){if(hasFetchedImageEmbeddingModelOptions){return}hasFetchedImageEmbeddingModelOptions=true;DataikuAPI.pretrainedModels.getImageEmbeddingModels().success(modelList=>{modelList.sort((a,b)=>a.modelFriendlyName.localeCompare(b.modelFriendlyName,"en",{sensitivity:"base"}));$scope.imageEmbeddingModelsOptions=modelList}).error(setErrorInScope.bind($scope))}function sortSentenceEmbeddingModels(sentenceEmbeddingModels){sentenceEmbeddingModels.sort((a,b)=>a.modelFriendlyName.localeCompare(b.modelFriendlyName,"en",{sensitivity:"base"}));return sentenceEmbeddingModels}$scope.sentenceEmbeddingModelsOptions=[];$scope.sentenceEmbeddingModelsList=[];$scope.$watchCollection("scope.mlTaskDesign.envSelection",()=>{DataikuAPI.pretrainedModels.getSentenceEmbeddingModels($scope.mlTaskDesign.envSelection,$stateParams.projectKey).success(sentenceEmbeddingModels=>{$scope.sentenceEmbeddingModelsList=sentenceEmbeddingModels;$scope.sentenceEmbeddingModelsOptions=sortSentenceEmbeddingModels($scope.sentenceEmbeddingModelsList)}).error(setErrorInScope.bind($scope));setImageEmbeddingModelsOptions()});$scope.getMaxTokensLimit=function(){if($scope.selection.selectedObject==null){return null}const selectedModel=$scope.sentenceEmbeddingModelsList.find(m=>m.modelRefId==$scope.selection.selectedObject.sentenceEmbeddingModel);if(selectedModel){return selectedModel.maxTokensLimit}return null};$scope.getTextOverflowWarning=function(){if($scope.selection.selectedObject==null){return null}const selectedModel=$scope.sentenceEmbeddingModelsList.find(m=>m.modelRefId==$scope.selection.selectedObject.sentenceEmbeddingModel);if(!selectedModel){return null}const tokensLimit=$scope.isCodeEnvResourceModelSelected()?$scope.selection.selectedObject.maxSequenceLength:selectedModel.maxTokensLimit;const overflowBehavior=selectedModel.modelType=="HUGGINGFACE_TRANSFORMER_LOCAL"?"be truncated.":"fail the training.";if(tokensLimit==undefined||selectedModel.maxTokensLimit==undefined){return"Texts longer than 'model.max_seq_length' tokens will "+overflowBehavior}return"The selected model supports up to "+selectedModel.maxTokensLimit+" tokens per row, texts longer than "+tokensLimit+" tokens will "+overflowBehavior};$scope.checkSentenceEmbeddingModelCompatible=function(){$scope.selectedModelType="";if($scope.selection.selectedObject==null){return false}const selectedModel=$scope.sentenceEmbeddingModelsList.find(m=>m.modelRefId==$scope.selection.selectedObject.sentenceEmbeddingModel);if(selectedModel){return selectedModel.compat}return false};$scope.isCodeEnvResourceModelSelected=function(){if(!$scope.selection.selectedObject||!$scope.selection.selectedObject.sentenceEmbeddingModel){return false}return!$scope.selection.selectedObject.isStructuredRef};$scope.enrichSentenceEmbPreprocessingParams=function(selectedModelId){const selectedModel=$scope.sentenceEmbeddingModelsList.find(m=>m.modelRefId==selectedModelId);if(selectedModel){$scope.selection.selectedObject.isStructuredRef=selectedModel.isStructuredRef;$scope.selection.selectedObject.embeddingSize=selectedModel.embeddingSize}};function getCurrentEnvCompatibility(){if(!$scope.mlTaskDesign||!$scope.mlTaskDesign.envSelection){return null}return VisualMlCodeEnvCompatibility.getCodeEnvCompat($scope.mlTaskDesign.envSelection,$scope.codeEnvsCompat)}$scope.isCodeEnvCompatibleWithSentenceEmbedding=function(){const envCompat=getCurrentEnvCompatibility();return envCompat&&envCompat.sentenceEmbedding&&envCompat.sentenceEmbedding.compatible}});app.component("pretrainedModelSelector",{bindings:{modelRefId:"=",onChange:"<",modelOptions:"<",embeddingType:"<"},template:`
<div class="control-group">
    <label class="control-label">Pre-trained model</label>
    <div class="controls">
        <basic-select
            items="$ctrl.modelOptions"
            bind-label="modelFriendlyName"
            bind-value="modelRefId"
            bind-annotation="type"
            bind-disabled="disabled"
            group-by-fn="$ctrl.niceModelType"
            searchable="true"
            actions-box="false"
            placeholder="{{ $ctrl.placeholder }}"
            invalidate-on-ghosts="true"
            ghost-items-tooltip="The selected model is not available anymore."
            multiple="false"
            ng-model="$ctrl.modelRefId"
            ng-change="$ctrl.onChange($ctrl.modelRefId)"
        />
        <div class="help-inline" ng-if="$ctrl.modelLibrary == 'SentenceTransformers'">
            Model used to extract the text embeddings.
        </div>
        <div class="help-inline" ng-if="$ctrl.embeddingType">
            Model used to extract the {{ $ctrl.embeddingType }} embeddings.
        </div>
        <div class="help-inline" ng-if="$ctrl.embeddingType == null">
            Model used to extract the embeddings.
        </div>
    </div>
</div>
`,controller:function($filter){const ctrl=this;ctrl.$onInit=()=>{ctrl.modelOptions=ctrl.modelOptions==null?[]:ctrl.modelOptions;ctrl.placeholder="Nothing selected";ctrl.niceModelType=modelOption=>{return $filter("niceLLMType")(modelOption.modelType)}};ctrl.$onChanges=()=>{if(ctrl.modelOptions){if(ctrl.modelOptions.length==0){ctrl.placeholder="No available models."}}}}});app.service("ColumnAnalysesService",function($stateParams,DataikuAPI){function init(analysisCoreParams,onError){const analyses={};const alphanumMaxResults=50,fullSamplePartitionId=null,withFullSampleStatistics=null,forceTimePeriodAnalysis=null;function fetchColumnAnalysisIfNeeded(column){return new Promise((resolve,_)=>{if(analyses[column]){resolve(analyses[column])}else{DataikuAPI.shakers.detailedColumnAnalysis($stateParams.projectKey,analysisCoreParams.projectKey,analysisCoreParams.inputDatasetSmartName,analysisCoreParams.script,null,column,alphanumMaxResults,fullSamplePartitionId,withFullSampleStatistics,forceTimePeriodAnalysis).then(columnAnalysisResult=>{analyses[column]=columnAnalysisResult.data;resolve(analyses[column])}).catch(onError)}})}return{fetchColumnAnalysisIfNeeded:fetchColumnAnalysisIfNeeded,analyses:analyses}}return{init:init}});app.component("tooManyDroppedRowsWarning",{bindings:{columnAnalysis:"<"},template:`
        <p ng-if="$ctrl.displayWarning" class="mleftright8 mbot8 alert alert-warning">
            Dropping rows with missing values could remove around {{$ctrl.columnAnalysis.alphanumFacet.missing | smartPercentage:1}} of the input data (based on design sample).
        </p>
    `,controller:function(){const ctrl=this;const DROPPED_ROW_WARNING_THRESHOLD=.5;ctrl.$onChanges=()=>{ctrl.displayWarning=ctrl.columnAnalysis&&ctrl.columnAnalysis.alphanumFacet&&ctrl.columnAnalysis.alphanumFacet.missing>DROPPED_ROW_WARNING_THRESHOLD}}});app.service("TimeseriesFeatureGenerationService",function($timeout){this.cleanUpSettings=function(mlTaskDesign){if(mlTaskDesign.predictionType!=="TIMESERIES_FORECAST"){return}for(var featureName in mlTaskDesign.preprocessing.feature_generation.shifts){const toCheckFromForecast=mlTaskDesign.preprocessing.feature_generation.shifts[featureName].from_forecast;mlTaskDesign.preprocessing.feature_generation.shifts[featureName].from_forecast=this.parseArrayFromStringIfNeeded(toCheckFromForecast);const toCheckFromHorizon=mlTaskDesign.preprocessing.feature_generation.shifts[featureName].from_horizon;mlTaskDesign.preprocessing.feature_generation.shifts[featureName].from_horizon=this.parseArrayFromStringIfNeeded(toCheckFromHorizon)}};this.parseArrayFromStringIfNeeded=function(input){if(typeof input==="string"){return[...new Set(Array.from(input.split(",")).map(x=>parseInt(x)).filter(x=>!isNaN(x)))]}return input};this.isMassEditMode=function(scope,selection){let newState=selection.selectedObjects&&selection.selectedObjects.length>0;if(scope._isMassEditMode&&!newState){if(scope.shouldRerender){$timeout(function(){scope.$broadcast("redrawFatTable")},0);scope.shouldRerender=false}}scope._isMassEditMode=newState;return newState};this.getTableSize=function(numberOfElements,rowHeight){return Math.min(numberOfElements,10)*rowHeight+10}});app.controller("FeatureGenerationController",function($scope,CreateModalFromTemplate){$scope.openWindowsSettingsModal=function(){CreateModalFromTemplate("/templates/analysis/mlcommon/settings/time-series-windows-settings-modal.html",$scope,null,function(newScope){newScope.windows_rescale_numericals=$scope.mlTaskDesign.preprocessing.feature_generation.windows_rescale_numericals;newScope.windows_max_categories=$scope.mlTaskDesign.preprocessing.feature_generation.windows_max_categories;newScope.save=()=>{$scope.mlTaskDesign.preprocessing.feature_generation.windows_rescale_numericals=newScope.windows_rescale_numericals;$scope.mlTaskDesign.preprocessing.feature_generation.windows_max_categories=newScope.windows_max_categories;newScope.dismiss()}},false,false,true)}});app.controller("FeatureGenerationShiftController",function($scope,CreateModalFromTemplate,TimeseriesFeatureGenerationService){$scope._isMassEditMode=false;$scope.massEditInputIsDirty=false;$scope.$watch("selection",function(){if($scope.selection.selectedObjects&&$scope.selection.selectedObjects.length===0){$scope.massEditInputIsDirty=false}$scope.initMassEditValues()},true);$scope.setMassEditDirty=function(){$scope.massEditInputIsDirty=true};let redrawFn=function(){$scope.shouldRerender=true};$scope.setMassEditTargetShiftMode=function(target){$scope.massEditTargetShiftMode=target};$scope.applyMassEditShifts=function(){$scope.setSelectedFeaturesShifts();if($scope.massEditTargetShiftMode==="AUTO"){$scope.setSelectedFeaturesToAutoShift()}if($scope.massEditTargetShiftMode==="FIXED"){$scope.setSelectedFeaturesToFixedShifts()}$scope.massEditInputIsDirty=false;$scope.initMassEditValues()};$(window).on("resize",redrawFn);$scope.$on("$destroy",function(){$(window).off("resize",redrawFn)});$scope.isMassEditMode=function(selection){return TimeseriesFeatureGenerationService.isMassEditMode($scope,selection)};$scope.getTableSize=function(numberOfElements,rowHeight){return TimeseriesFeatureGenerationService.getTableSize(numberOfElements,rowHeight)};$scope.initMassEditValues=function(){if(!$scope.selection.selectedObjects||$scope.selection.selectedObjects.length===0){return}if(!$scope.massEditInputIsDirty){$scope.initMassEditShifts();$scope.initMassEditTargetShiftMode()}$scope.validateMassEditShifts()};$scope.initMassEditShifts=function(){let forecastShifts=$scope.mlTaskDesign.preprocessing.feature_generation.shifts[$scope.selection.selectedObjects[0]._name].from_forecast;forecastShifts=TimeseriesFeatureGenerationService.parseArrayFromStringIfNeeded(forecastShifts);let forecastShiftsAreIdentical=$scope.selection.selectedObjects.every(feature=>{let featureShifts=$scope.mlTaskDesign.preprocessing.feature_generation.shifts[feature._name].from_forecast;featureShifts=TimeseriesFeatureGenerationService.parseArrayFromStringIfNeeded(featureShifts);return featureShifts.length===forecastShifts.length&&forecastShifts.every(v=>featureShifts.includes(v))});if(forecastShiftsAreIdentical){$scope.uiState.massActionForecastShifts=forecastShifts}else{$scope.uiState.massActionForecastShifts=[]}let horizonShifts=$scope.mlTaskDesign.preprocessing.feature_generation.shifts[$scope.selection.selectedObjects[0]._name].from_horizon;horizonShifts=TimeseriesFeatureGenerationService.parseArrayFromStringIfNeeded(horizonShifts);let horizonShiftsAreIdentical=$scope.selection.selectedObjects.every(feature=>{let featureShifts=$scope.mlTaskDesign.preprocessing.feature_generation.shifts[feature._name].from_horizon;featureShifts=TimeseriesFeatureGenerationService.parseArrayFromStringIfNeeded(featureShifts);return featureShifts.length===horizonShifts.length&&horizonShifts.every(v=>featureShifts.includes(v))});if(horizonShiftsAreIdentical){$scope.uiState.massActionHorizonShifts=horizonShifts}else{$scope.uiState.massActionHorizonShifts=[]}};$scope.initMassEditTargetShiftMode=function(){let autoShiftMode=$scope.mlTaskDesign.preprocessing.feature_generation.shifts[$scope.selection.selectedObjects[0]._name].from_horizon_mode;let autoShiftModesAreIdentical=$scope.selection.selectedObjects.every(feature=>{return autoShiftMode===$scope.mlTaskDesign.preprocessing.feature_generation.shifts[feature._name].from_horizon_mode});$scope.massEditTargetShiftMode=autoShiftModesAreIdentical?autoShiftMode:null};$scope.getFeatureHavingShiftModeNumber=function(autoShiftMode){if(!$scope.massEditTargetShiftMode){return $scope.someSelectedFeaturesAreInMode(autoShiftMode)}if(autoShiftMode!==$scope.massEditTargetShiftMode){if(autoShiftMode==="FIXED"){return $scope.someSelectedFeaturesDontSupportAutoShift()}}return false};$scope.autoShiftModeShouldBeStriped=function(autoShiftMode){if(!$scope.massEditTargetShiftMode){return $scope.someSelectedFeaturesAreInMode(autoShiftMode)}if(autoShiftMode!==$scope.massEditTargetShiftMode){if(autoShiftMode==="FIXED"){return $scope.someSelectedFeaturesDontSupportAutoShift()}}return false};$scope.selectedFeaturesContainsPastCovariate=function(){return $scope.selection.selectedObjects.some(feature=>$scope.isPastOnlyFeature(feature._name))};$scope.someSelectedFeaturesSupportAutoShift=function(){return $scope.selection.selectedObjects.some(feature=>$scope.featureSupportsAutoShifts(feature))};$scope.someSelectedFeaturesDontSupportAutoShift=function(){return $scope.selection.selectedObjects.some(feature=>!$scope.featureSupportsAutoShifts(feature))};$scope.someSelectedFeaturesArePastOnly=function(){return $scope.selection.selectedObjects.some(feature=>$scope.isPastOnlyFeature(feature._name))};$scope.setSelectedFeaturesToAutoShift=function(){$scope.selection.selectedObjects.forEach(feature=>{if($scope.featureSupportsAutoShifts(feature)){$scope.mlTaskDesign.preprocessing.feature_generation.shifts[feature._name].from_horizon_mode="AUTO"}});if(document.activeElement){document.activeElement.blur()}};$scope.allSelectedFeaturesAreInMode=function(mode){return $scope.selection.selectedObjects.every(feature=>{return $scope.mlTaskDesign.preprocessing.feature_generation.shifts[feature._name].from_horizon_mode===mode})};$scope.someSelectedFeaturesAreInMode=function(mode){return $scope.selection.selectedObjects.some(feature=>{return $scope.mlTaskDesign.preprocessing.feature_generation.shifts[feature._name].from_horizon_mode===mode})};$scope.setSelectedFeaturesToFixedShifts=function(){$scope.selection.selectedObjects.forEach(feature=>{$scope.mlTaskDesign.preprocessing.feature_generation.shifts[feature._name].from_horizon_mode="FIXED"})};$scope.getFeatureSupportingAutoShiftNumber=function(){return $scope.selection.selectedObjects.filter(feature=>$scope.featureSupportsAutoShifts(feature)).length};$scope.setSelectedFeaturesShifts=function(){$scope.selection.selectedObjects.forEach(function(feature){if(!$scope.mlTaskDesign.preprocessing.feature_generation.shifts[feature._name]){$scope.mlTaskDesign.preprocessing.feature_generation.shifts[feature._name]={}}$scope.mlTaskDesign.preprocessing.feature_generation.shifts[feature._name].from_forecast=$scope.uiState.massActionForecastShifts||"";if($scope.massEditTargetShiftMode!=="AUTO"){$scope.mlTaskDesign.preprocessing.feature_generation.shifts[feature._name].from_horizon=$scope.uiState.massActionHorizonShifts||""}});$scope.validateShifts();$scope.validateMassEditShifts()};$scope.validateMassEditShifts=function(){$scope.uiState.massEditShiftsValidationErrors={};let shiftFromForecastAsString=($scope.uiState.massActionForecastShifts||"").toString();let shiftFromHorizonAsString=($scope.uiState.massActionHorizonShifts||"").toString();let hasPastOnlyFeature=$scope.someSelectedFeaturesArePastOnly();$scope.uiState.massEditShiftsValidationErrors=$scope.validateShiftsAsString(shiftFromForecastAsString,shiftFromHorizonAsString,hasPastOnlyFeature);$scope.updateSelectedAlgosMissingRequiredExternalFeature()};$scope.setFeatureAutoShiftsParams=function(maxSelectedHorizonShifts,minHorizonShiftPastOnly,maxHorizonShiftPastOnly,minHorizonShiftKnownInAdvance,maxHorizonShiftKnownInAdvance){if(!$scope.mlTaskDesign.preprocessing.feature_generation.auto_shifts_params){$scope.mlTaskDesign.preprocessing.feature_generation.auto_shifts_params={}}$scope.mlTaskDesign.preprocessing.feature_generation.auto_shifts_params.max_selected_horizon_shifts=maxSelectedHorizonShifts||1;$scope.mlTaskDesign.preprocessing.feature_generation.auto_shifts_params.min_horizon_shift_past_only=minHorizonShiftPastOnly;$scope.mlTaskDesign.preprocessing.feature_generation.auto_shifts_params.max_horizon_shift_past_only=maxHorizonShiftPastOnly;$scope.mlTaskDesign.preprocessing.feature_generation.auto_shifts_params.min_horizon_shift_known_in_advance=minHorizonShiftKnownInAdvance;$scope.mlTaskDesign.preprocessing.feature_generation.auto_shifts_params.max_horizon_shift_known_in_advance=maxHorizonShiftKnownInAdvance};$scope.validateAutoShiftsParams=function(){let autoShiftsParams=$scope.mlTaskDesign.preprocessing?.feature_generation?.auto_shifts_params;$scope.hasAutoShiftsParamsValidationErrors=autoShiftsParams===undefined||typeof autoShiftsParams.max_selected_horizon_shifts!=="number"||autoShiftsParams.max_selected_horizon_shifts<1||$scope.validatePastOnlyAutoHorizonShiftRange(autoShiftsParams.min_horizon_shift_past_only,autoShiftsParams.max_horizon_shift_past_only)!==""||$scope.validateKnownInAdvanceAutoHorizonShiftRange(autoShiftsParams.min_horizon_shift_known_in_advance,autoShiftsParams.max_horizon_shift_known_in_advance)!==""};$scope.openAutoShiftsModal=function(){CreateModalFromTemplate("/templates/analysis/mlcommon/settings/time-series-edit-auto-shift-modal.html",$scope,null,function(newScope){if($scope.mlTaskDesign.preprocessing.feature_generation?.auto_shifts_params){newScope.maxSelectedHorizonShifts=$scope.mlTaskDesign.preprocessing.feature_generation.auto_shifts_params.max_selected_horizon_shifts;newScope.minHorizonShiftPastOnly=$scope.mlTaskDesign.preprocessing.feature_generation.auto_shifts_params.min_horizon_shift_past_only;newScope.maxHorizonShiftPastOnly=$scope.mlTaskDesign.preprocessing.feature_generation.auto_shifts_params.max_horizon_shift_past_only;newScope.minHorizonShiftKnownInAdvance=$scope.mlTaskDesign.preprocessing.feature_generation.auto_shifts_params.min_horizon_shift_known_in_advance;newScope.maxHorizonShiftKnownInAdvance=$scope.mlTaskDesign.preprocessing.feature_generation.auto_shifts_params.max_horizon_shift_known_in_advance}else{newScope.maxSelectedHorizonShifts=3;newScope.minHorizonShiftPastOnly=-$scope.mlTaskDesign.predictionLength-35;newScope.maxHorizonShiftPastOnly=-$scope.mlTaskDesign.predictionLength;newScope.minHorizonShiftKnownInAdvance=-35;newScope.maxHorizonShiftKnownInAdvance=0}newScope.inputPastOnlyHorizonShiftsRangeValidationError=newScope.validatePastOnlyAutoHorizonShiftRange(newScope.minHorizonShiftPastOnly,newScope.maxHorizonShiftPastOnly);newScope.inputHorizonShiftsRangeValidationError=newScope.validateKnownInAdvanceAutoHorizonShiftRange(newScope.minHorizonShiftKnownInAdvance,newScope.maxHorizonShiftKnownInAdvance);newScope.save=()=>{$scope.setFeatureAutoShiftsParams(newScope.maxSelectedHorizonShifts,newScope.minHorizonShiftPastOnly,newScope.maxHorizonShiftPastOnly,newScope.minHorizonShiftKnownInAdvance,newScope.maxHorizonShiftKnownInAdvance);$scope.validateAutoShiftsParams();newScope.dismiss()}},false,false,true)};$scope.$on("$destroy",function(){TimeseriesFeatureGenerationService.cleanUpSettings($scope.mlTaskDesign)})});app.controller("FeatureGenerationWindowController",function($scope,CreateModalFromTemplate,TimeseriesFeatureGenerationService,TimeseriesForecastingUtils){$scope._isMassEditMode=false;$scope.initMassEditTargetOperations=function(){$scope.massEditTargetOperations={numerical:[],categorical:[]}};$scope.initMassEditTargetOperations();let redrawFn=function(){$scope.shouldRerender=true};$(window).on("resize",redrawFn);$scope.$on("$destroy",function(){$(window).off("resize",redrawFn)});$scope.$watch("selection",function(){if($scope.selection.selectedObjects&&$scope.selection.selectedObjects.length===0){$scope.initMassEditTargetOperations()}$scope.getMassEditOperations()},true);$scope.isOperationTargetSet=function(operationName,operationType){return $scope.massEditTargetOperations[operationType].some(operation=>operation.operation===operationName)};$scope.getOperationTarget=function(operationName,operationType){if($scope.isOperationTargetSet(operationName,operationType)){return $scope.massEditTargetOperations[operationType].filter(operation=>operation.operation===operationName)[0]}};$scope.isMassEditMode=function(selection){return TimeseriesFeatureGenerationService.isMassEditMode($scope,selection)};$scope.getTableSize=function(numberOfElements,rowHeight){return TimeseriesFeatureGenerationService.getTableSize(numberOfElements,rowHeight)};$scope.addToTargetOperations=function(operationName,enabled,operationType){if(!$scope.isOperationTargetSet(operationName,operationType)){$scope.massEditTargetOperations[operationType].push({operation:operationName,enabled:enabled})}else{$scope.getOperationTarget(operationName,operationType).enabled=enabled}};$scope.setWindowOperations=function(numOperations,catOperations,windowIndex){let selectedAndValidFeatures=$scope.uiState.windows[windowIndex].operations_list.filter(el=>{return el.$selected&&$scope.uiState.windowableFeatures.map(feature=>feature._name).includes(el[0])});for(let el of selectedAndValidFeatures){if(el[2].type==="NUMERIC"){el[1]=angular.copy(numOperations)}else if(el[2].type==="CATEGORY"){el[1]=angular.copy(catOperations)}}$scope.validateWindows()};$scope.getMassEditOperations=function(){let per_feature=$scope.mlTaskDesign.preprocessing.per_feature;let selectedFeaturesNumerical=$scope.window.operations_list.filter(x=>per_feature[x[0]].type==="NUMERIC"&&x.$selected&&TimeseriesForecastingUtils.isWindowCompatible(per_feature[x[0]]));if(selectedFeaturesNumerical.length===0){$scope.massEditTargetOperations["numerical"]=[]}let someDisabledOperationsNumerical=new Set(selectedFeaturesNumerical.map(x=>x[1]).flatMap(x=>x.filter(y=>!y.enabled).map(y=>y.operation)));let allEnabledOperationsNumerical=new Set(["MEAN","MEDIAN","STD","MIN","MAX"]).difference(someDisabledOperationsNumerical);let partiallyEnabledOperationsNumerical=new Set(selectedFeaturesNumerical.map(x=>x[1]).flatMap(x=>x.filter(y=>y.enabled).map(y=>y.operation))).difference(allEnabledOperationsNumerical);$scope.massEditOperationsNumerical=[{operation:"MEAN",enabled:$scope.isOperationTargetSet("MEAN","numerical")?$scope.getOperationTarget("MEAN","numerical").enabled:allEnabledOperationsNumerical.has("MEAN"),partiallyEnabled:partiallyEnabledOperationsNumerical.has("MEAN")},{operation:"MEDIAN",enabled:$scope.isOperationTargetSet("MEDIAN","numerical")?$scope.getOperationTarget("MEDIAN","numerical").enabled:allEnabledOperationsNumerical.has("MEDIAN"),partiallyEnabled:partiallyEnabledOperationsNumerical.has("MEDIAN")},{operation:"STD",enabled:$scope.isOperationTargetSet("STD","numerical")?$scope.getOperationTarget("STD","numerical").enabled:allEnabledOperationsNumerical.has("STD"),partiallyEnabled:partiallyEnabledOperationsNumerical.has("STD")},{operation:"MIN",enabled:$scope.isOperationTargetSet("MIN","numerical")?$scope.getOperationTarget("MIN","numerical").enabled:allEnabledOperationsNumerical.has("MIN"),partiallyEnabled:partiallyEnabledOperationsNumerical.has("MIN")},{operation:"MAX",enabled:$scope.isOperationTargetSet("MAX","numerical")?$scope.getOperationTarget("MAX","numerical").enabled:allEnabledOperationsNumerical.has("MAX"),partiallyEnabled:partiallyEnabledOperationsNumerical.has("MAX")}];let selectedFeaturesCategorical=$scope.window.operations_list.filter(x=>per_feature[x[0]].type==="CATEGORY"&&x.$selected&&TimeseriesForecastingUtils.isWindowCompatible(per_feature[x[0]]));if(selectedFeaturesCategorical.length===0){$scope.massEditTargetOperations["categorical"]=[]}let someDisabledOperationsCategorical=new Set(selectedFeaturesCategorical.map(x=>x[1]).flatMap(x=>x.filter(y=>!y.enabled).map(y=>y.operation)));let allEnabledOperationsCategorical=new Set(["FREQUENCY"]).difference(someDisabledOperationsCategorical);let partiallyEnabledOperationsCategorical=new Set(selectedFeaturesCategorical.map(x=>x[1]).flatMap(x=>x.filter(y=>y.enabled).map(y=>y.operation))).difference(allEnabledOperationsCategorical);$scope.massEditOperationsCategorical=[{operation:"FREQUENCY",enabled:$scope.isOperationTargetSet("FREQUENCY","categorical")?$scope.getOperationTarget("FREQUENCY","categorical").enabled:allEnabledOperationsCategorical.has("FREQUENCY"),partiallyEnabled:partiallyEnabledOperationsCategorical.has("FREQUENCY")}];$scope.numericalSelectedFeaturesNb=selectedFeaturesNumerical.length;$scope.categoricalSelectedFeaturesNb=selectedFeaturesCategorical.length};$scope.setMassEditOperations=function(){for(let targetOperation of $scope.massEditTargetOperations["numerical"].concat($scope.massEditTargetOperations["categorical"])){let selectedFeature=$scope.selection.selectedObjects.map(feature=>feature[0]);$scope.window.operations_list.forEach(function(feature){if(selectedFeature.includes(feature[0])){for(let operation of feature[1]){if(operation.operation===targetOperation.operation){operation.enabled=targetOperation.enabled;break}}}})}$scope.getMassEditOperations()};$scope.hasAnyEnabledOperation=function(window){return window.operations_list.some(operations=>operations[1].some(operation=>operation.enabled))}});app.component("cyclicalEncodingWarning",{bindings:{datetimeCyclicalPeriods:"<",columnAnalysis:"<"},template:`
        <div ng-show="$ctrl.warningOnSelectedPeriods" class="doctor-explanation alert-warning mtop8 mright16">
            <span>{{ $ctrl.warningOnSelectedPeriods }}</span>
        </div>
    `,controller:function(){const $ctrl=this;let _prevData=null;$ctrl.$doCheck=()=>{const newData={datetimeCyclicalPeriods:angular.copy($ctrl.datetimeCyclicalPeriods),columnAnalysis:angular.copy($ctrl.columnAnalysis)};if(!angular.equals(_prevData,newData)){_prevData=newData;updateWarning()}};function updateWarning(){if(!$ctrl.datetimeCyclicalPeriods.length){$ctrl.warningOnSelectedPeriods="At least one period should be selected to enable cyclical encoding.";return}const numericalAnalysis=$ctrl.columnAnalysis&&$ctrl.columnAnalysis.numericalAnalysis;if(!numericalAnalysis){delete $ctrl.warningOnSelectedPeriods;return}if(numericalAnalysis.relevantPeriods&&!numericalAnalysis.relevantPeriods.length){$ctrl.warningOnSelectedPeriods="According to the sample data on this feature, cyclical encoding"+" does not seem to yield enough distinct values for any period.";return}const irrelevantSelectedPeriods=$ctrl.datetimeCyclicalPeriods.filter(period=>numericalAnalysis.irrelevantPeriods.includes(period));if(!irrelevantSelectedPeriods.length){delete $ctrl.warningOnSelectedPeriods}else{$ctrl.warningOnSelectedPeriods="According to the sample data on this feature, some of the selected"+" periods ("+irrelevantSelectedPeriods.map(period=>period.toLowerCase()).join(", ")+") might not be relevant for the feature."}}}});app.service("MLFeaturesService",function($q,$stateParams,DataikuAPI,DatasetUtils,Fn){const service={};let datasetColumnsPromise=null;let analysisId=null;let datasetName=null;service.getDatasetColumns=function(analysisCoreParams){if(!analysisCoreParams||!analysisCoreParams.inputDatasetSmartName){return $q.reject("analysisCoreParams are not available")}if(datasetColumnsPromise&&analysisId&&analysisId===analysisCoreParams.id&&datasetName&&datasetName===analysisCoreParams.inputDatasetSmartName){return datasetColumnsPromise}const datasetLoc=DatasetUtils.getLocFromSmart($stateParams.projectKey,analysisCoreParams.inputDatasetSmartName);datasetColumnsPromise=DataikuAPI.datasets.get(datasetLoc.projectKey,datasetLoc.name,$stateParams.projectKey).then(function(response){return response.data.schema.columns.map(Fn.prop("name"))});analysisId=analysisCoreParams.id;datasetName=analysisCoreParams.inputDatasetSmartName;return datasetColumnsPromise};service.addDataSetColumnId=function(features,datasetColumns){if(!features)return;angular.forEach(features,function(feature){feature.datasetColumnId=datasetColumns.indexOf(feature._name)})};return service})})();(function(){"use strict";var app=angular.module("dataiku.analysis.mlcore");app.directive("modelTrainProgress",function(ProgressStackMessageBuilder,MLDiagnosticsService){return{scope:{progress:"=",gridsearchData:"=",mlDiagnostics:"="},templateUrl:"/templates/analysis/mlcommon/train-progress.html",link:function(scope){scope.$watch("mlDiagnostics",()=>{scope.groupedDiagnostics=MLDiagnosticsService.groupByStepAndType(scope.mlDiagnostics)},true);scope.$watch("progress",()=>{if(scope.progress&&scope.progress.stack){scope.stackMessage=ProgressStackMessageBuilder.buildFull(scope.progress.stack)}else{scope.stackMessage=""}scope.allProgress=[];scope.progress.top_level_done.forEach(item=>{item.type="DONE";scope.allProgress.push(item)});scope.allProgress.push({type:"CURRENT",message:scope.stackMessage});scope.progress.top_level_todo.forEach(item=>{scope.allProgress.push({type:"TODO",str:item})})},true);scope.displaySearchProgress=item=>{const searchingSteps=["Hyperparameter searching","Fitting global model"];return searchingSteps.includes(item.message)&&scope.gridsearchData&&scope.gridsearchData.gridPoints.length};scope.displaySearchTimeProgress=item=>{return scope.displaySearchProgress(item)&&scope.gridsearchData.gridSize===0};scope.getSearchProgress=()=>{const gsd=scope.gridsearchData;if(!gsd){return""}let gridProgress="("+gsd.gridPoints.length+"/"+(gsd.gridSize!==0?gsd.gridSize:"?")+")";return gridProgress};scope.getSearchTimeProgress=()=>{return durationHHMMSS(Math.max(0,(now-parseInt(scope.progress.stack[0].startTimestamp,10))/1e3))+" / "+durationHHMM(scope.gridsearchData.timeout*60)}}}});app.directive("analysisPredictedTableBase",function($q,Assert,DataikuAPI,Logger){return{scope:true,priority:30,controller:function($scope,$stateParams,$state){Logger.info("APTB");$scope.shakerHooks.saveForAuto=function(){Assert.inScope($scope,"mlTaskDesign");var deferred=$q.defer();var toSave=angular.copy($scope.mlTaskDesign);toSave.predictedScript=$scope.getShakerData();var fn=null;if($scope.mlTaskDesign.taskType=="PREDICTION"){fn=DataikuAPI.analysis.pml.saveSettings}else if($scope.mlTaskDesign.taskType=="CLUSTERING"){fn=DataikuAPI.analysis.cml.saveSettings}else{throw"Unexpected taskType"}fn($stateParams.projectKey,$stateParams.analysisId,toSave).success(function(data){$scope.originalShaker=toSave.script;$scope.invalidScriptError={};for(var stepIdx in $scope.shaker.steps){var step=$scope.shaker.steps[stepIdx];var err=$scope.validateStep(step);if(err!=null){$scope.invalidScriptError={index:stepIdx,type:step.type,message:err};Logger.info("script is invalid, not refreshing");deferred.reject("Script is invalid");return}}deferred.resolve()}).error(setErrorInScope.bind($scope));return deferred.promise};$scope.loadMLTask=function(){Assert.inScope($scope,"shakerState");Assert.inScope($scope,"shakerHooks");DataikuAPI.analysis.mlcommon.getCurrentSettings($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId).success(function(data){$scope.mlTaskDesign=data;$scope.baseInit();$scope.shaker=data.predictionDisplayScript;$scope.originalShaker=angular.copy($scope.shaker);$scope.fixupShaker();$scope.refreshTable(false)}).error(setErrorInScope.bind($scope))};$scope.shakerReadOnlyActions=true;$scope.shakerState.isPredictedDataTable=true;$scope.shakerState.filtersExplicitlyAllowed=true}}});app.directive("analysisPredictedChartsBase",function($q,$timeout,Assert,DataikuAPI,Logger,ActivityIndicator,ChartTypeChangeHandler,$rootScope,DSSVisualizationThemeUtils){return{scope:true,priority:30,controller:function($scope,$stateParams){$scope.getDataSpec=()=>{return{datasetProjectKey:$scope.analysisCoreParams.projectKey,datasetName:$scope.analysisCoreParams.inputDatasetSmartName}};$scope.fixExpression=(expression,fixName="plus")=>{return DataikuAPI.analysis.predicted.fixExpression($stateParams.fullModelId,expression,fixName)};$scope.getRequiredSampleId=()=>{return $scope.summary.requiredSampleId};$scope.getExecutePromise=function(request,saveShaker=true,noSpinner=false,requiredSampleId=undefined){if(saveShaker!==false){$scope.saveShaker()}if(request){if(requiredSampleId===undefined){requiredSampleId=$scope.summary?$scope.summary.requiredSampleId:null}let promise=DataikuAPI.analysis.predicted.chartsGetPivotResponse($stateParams.fullModelId,request,requiredSampleId);if(noSpinner===true){promise=promise.noSpinner()}return promise}};$scope.getLLMChartContext=function(){return{context:"predicted",fullModelId:$stateParams.fullModelId,getSuggestionsCacheKey(chartDefCacheKey){return chartDefCacheKey?$stateParams.fullModelId+chartDefCacheKey:$stateParams.fullModelId}}};$scope.getDefaultNewChart=function(){const defaultTheme=DSSVisualizationThemeUtils.getThemeOrDefault($rootScope.appConfig.selectedDSSVisualizationTheme);return{theme:defaultTheme,def:ChartTypeChangeHandler.defaultNewChart(defaultTheme)}};$scope.saveShaker=function(){$scope.shaker.charts=$scope.charts;Assert.inScope($scope,"mlTaskDesign");var toSave=angular.copy($scope.mlTaskDesign);toSave.predictedScript=$scope.shaker;var fn=null;if($scope.mlTaskDesign.taskType=="PREDICTION"){fn=DataikuAPI.analysis.pml.saveSettings}else if($scope.mlTaskDesign.taskType=="CLUSTERING"){fn=DataikuAPI.analysis.cml.saveSettings}else{throw"Unexpected taskType"}if($scope.isProjectAnalystRW()){fn($stateParams.projectKey,$stateParams.analysisId,toSave).success(function(data){if(!ActivityIndicator.isDisplayed()){ActivityIndicator.success("Charts saved")}}).error(setErrorInScope.bind($scope)).noSpinner()}else{ActivityIndicator.warning("You don't have write access - not saving")}};$scope.overrideFormattingWithTheme=function(theme){const currentChart=$scope.charts[$scope.currentChart.index];const currentChartCopy=angular.copy(currentChart);const formerTheme=currentChart.theme;currentChart.theme=theme;DSSVisualizationThemeUtils.applyToChart({chart:currentChart.def,theme:theme,formerTheme:formerTheme});DSSVisualizationThemeUtils.showThemeAppliedSnackbar(currentChart,currentChartCopy)};$scope.$on("$destroy",()=>DSSVisualizationThemeUtils.hideThemeAppliedSnackbar());$scope.saveChart=$scope.saveShaker;$scope.fetchColumnsSummary=function(){return DataikuAPI.analysis.predicted.chartsGetColumnsSummary($stateParams.fullModelId).success(function(data){$scope.summary=data;$scope.makeUsableColumns(data)}).error(setErrorInScope.bind($scope))};$scope.onSettingsLoaded=function(){if($scope.charts.length===0){$scope.addChart()}if($scope.mlTaskDesign&&$scope.mlTaskDesign.customMeasures){$scope.addCustomMeasuresToScopeAndCache($scope.mlTaskDesign.customMeasures);$scope.addBinnedDimensionToScopeAndCache($scope.mlTaskDesign.reusableDimensions);$scope.addHierarchiesToScopeAndCache($scope.mlTaskDesign.hierarchies)}Logger.info("Data loaded, get summary");$scope.fetchColumnsSummary().then(function(){$scope.$watch("charts[currentChart.index]",function(nv){Logger.info("Chart changed, executing");$q.when($scope.summary).then(data=>{$scope.charts[$scope.currentChart.index].summary=data;$scope.forceExecuteChartOrWait()})})})}}}});app.controller("_MLModelBaseController",function($scope,$stateParams,DataikuAPI,TopNav,$state,Dialogs){TopNav.setItem(TopNav.ITEM_ANALYSIS,$stateParams.analysisId);DataikuAPI.analysis.getCore($stateParams.projectKey,$stateParams.analysisId).success(function(data){$scope.analysisCoreParams=data;TopNav.setItem(TopNav.ITEM_ANALYSIS,$stateParams.analysisId,{name:data.name,dataset:data.inputDatasetSmartName})}).error(setErrorInScope.bind($scope));$scope.$on("$destroy",function(){$scope.clearMLTasksContext()});$scope.deleteTrainedAnalysisModel=function(){if($scope.modelData){Dialogs.confirm($scope,"Model deletion","Are you sure you want to delete this model?").then(function(){DataikuAPI.ml.deleteModels([$stateParams.fullModelId]).success(function(data){$state.go("projects.project.analyses.analysis.ml.list")}).error(setErrorInScope.bind($scope))})}}});app.controller("TrainedModelSkinsController",function($scope,$rootScope,$state,VirtualWebApp){$scope.$watch("uiState.skin",function(){VirtualWebApp.changeSkin($scope,"ANALYSIS",$scope.uiState.skin,$scope.uiState,"skin-holder",$scope.modelData.fullModelId,null,true)},true)})})();(function(){"use strict";const app=angular.module("dataiku.analysis.mlcore");app.component("diagnosticsIcon",{bindings:{noBorder:"@?"},template:`<div class="feature-badge-icon-wrapper feature-badge-icon-wrapper--diagnostics" ng-class="{'feature-badge-icon-wrapper--no-border': $ctrl.noBorder}"><div class="feature-badge-icon"><i class="dku-icon-stethoscope-12"></i></div></div>`});app.component("overridesIcon",{template:`<div class="feature-badge-icon-wrapper feature-badge-icon-wrapper--overrides"><div class="feature-badge-icon"><i class="icon-dku-override"></i></div></div>`});app.component("customMetricFailurePopup",{bindings:{error:"<",fmi:"<"},templateUrl:"templates/ml/prediction-model/fragments/custom_metric_failed_button.html",controller:function($scope,$state,$stateParams,FullModelLikeIdUtils){$scope.$state=$state;const hasLinks=()=>this.fmi&&!$stateParams.evaluationId&&!$stateParams.dashboardId&&!$stateParams.insightId;$scope.hasDesignLink=()=>hasLinks()&&FullModelLikeIdUtils.isAnalysis(this.fmi);$scope.hasLogLink=()=>hasLinks()&&(FullModelLikeIdUtils.isAnalysis(this.fmi)||FullModelLikeIdUtils.isSavedModel(this.fmi))}});app.directive("diagnosticsModal",function(){return{scope:{diagnostics:"=",textContent:"@",popupContent:"@",iconWithoutBorder:"@?"},templateUrl:"/templates/ml/diagnostics-modal.html",link:($scope,element,attrs)=>{$scope.maxLength=attrs.maxLength||120;$scope.maxDiagnostics=5;const firstNDiagnostics=firstN=>{if(!$scope.diagnostics){return null}const diagnostics={};let total=0;for(const diagnostic of $scope.diagnostics){if(attrs.state&&attrs.state!==diagnostic.step){continue}diagnostics[diagnostic.displayableType]=diagnostics[diagnostic.displayableType]||[];diagnostics[diagnostic.displayableType].push(diagnostic.message);total++;if(total>=firstN){return diagnostics}}return diagnostics};$scope.$watch("diagnostics",()=>{$scope.filteredDiagnostics=firstNDiagnostics($scope.maxDiagnostics)},true)}}});app.component("modelName",{template:`
        <span title="{{ $ctrl.name }}">
            {{ $ctrl.nameStart }} <span class="text-prompt">{{ $ctrl.nameEnd}}</span>
        </span>
    `,controller:function(){const $ctrl=this;$ctrl.$onChanges=function(changesObj){if(changesObj.name&&changesObj.name.currentValue){[,$ctrl.nameStart,$ctrl.nameEnd]=changesObj.name.currentValue.match(/^(.+)\s+(\([^()]+\))$/)||[null,$ctrl.name,""]}}},bindings:{name:"<"}});app.controller("EnsembleModalController",function($scope){$scope.params={};$scope.getMethod=function(){return $scope.params.method}});app.controller("MLDiagnosticsSettingsController",function($scope,CachedAPICalls,Logger,$translate){$scope.addNewDiagnosticSettings=function(diagnosticSettings){const settingsTypeSet=new Set;diagnosticSettings.settings.forEach(setting=>{settingsTypeSet.add(setting.type)});for(const diagnosticType of Object.keys($scope.diagnosticsDefinition)){if(!settingsTypeSet.has(diagnosticType)){settingsTypeSet.add(diagnosticType);const newSetting={type:diagnosticType,enabled:true};Logger.log("Adding new missing diagnostic type:"+diagnosticType);diagnosticSettings.settings.push(newSetting)}}};$scope.isBackendDiagsCompatible=function(){return $scope.isMLBackendType("PY_MEMORY")||$scope.isMLBackendType("KERAS")||$scope.isMLBackendType("DEEP_HUB")};$scope.isDiagnosticEnabled=function(diagnosticSettings,type){const setting=$scope.getDiagnosticSetting(diagnosticSettings,type);return setting&&setting.enabled};$scope.isDiagnosticUnavailable=function(type){return!$scope.mlTaskDesign.diagnosticsSettings.enabled||["ML_DIAGNOSTICS_CAUSAL_TREATMENT_CHECKS","ML_DIAGNOSTICS_CAUSAL_PROPENSITY_CHECKS"].includes(type)&&!$scope.mlTaskDesign.modeling.propensityModeling.enabled};$scope.getDiagnosticUnavailableMessage=function(type){if(["ML_DIAGNOSTICS_CAUSAL_TREATMENT_CHECKS","ML_DIAGNOSTICS_CAUSAL_PROPENSITY_CHECKS"].includes(type)&&!$scope.mlTaskDesign.modeling.propensityModeling.enabled){return"This diagnostic relies on a propensity model. You can enable it in the Treatment Analysis tab."}return};$scope.getDiagnosticSetting=function(diagnosticSettings,type){for(const setting of diagnosticSettings.settings){if(type===setting.type){return setting}}return null}});app.controller("_MLTaskDesignController",function($scope,$stateParams,DataikuAPI,CreateModalFromTemplate,Collections,CodeMirrorSettingService,AlgorithmsSettingsService,WT1){DataikuAPI.analysis.listHeads($stateParams.projectKey).success(function(data){$scope.analyses=data});$scope.backendTypeNames={PY_MEMORY:"Python in-memory",MLLIB:"MLLib",H20:"H20",VERTICA:"Vertica",KERAS:"Keras"};$scope.displayTypes={CLUSTERING:"Clustering",BINARY_CLASSIFICATION:"Classification",MULTICLASS:"Classification",REGRESSION:"Regression",CAUSAL_BINARY_CLASSIFICATION:"Causal Classification",CAUSAL_REGRESSION:"Causal Regression",TIMESERIES_FORECAST:"Forecasting"};$scope.showAlgorithm=function(algo){if($scope.isCausalPrediction!==undefined&&$scope.isCausalPrediction()&&algo.supportedCausalMethod!==$scope.uiState.selectedCausalMethod)return false;return!algo.condition||algo.condition()};$scope.hasAlgoDisplayGroup=function(displayGroup){return function(item){return $scope.showAlgorithm(item)&&item.displayGroups&&item.displayGroups.includes(displayGroup)}};$scope.isAlgoWithoutDisplayGroup=function(){return function(item){return $scope.showAlgorithm(item)&&(!item.displayGroups||item.displayGroups.length===0)}};$scope.getCustomAlgorithm=function(custom_id){if(custom_id.startsWith("custom_python_")){return $scope.mlTaskDesign.modeling.custom_python[custom_id.slice(14)]}else if(custom_id.startsWith("custom_mllib_")){return $scope.mlTaskDesign.modeling.custom_mllib[custom_id.slice(13)]}};$scope.isPluginAlgorithm=function(alg){return alg.algKey.startsWith("CustomPyPredAlgo_")};$scope.getPluginAlgorithm=function(algKey){return $scope.algorithms["PY_MEMORY"].find(alg=>alg.algKey===algKey)};$scope.getAlgorithmModeling=function(algKey){const alg=Collections.indexByField($scope.algorithms[$scope.mlTaskDesign.backendType],"algKey")[algKey];if(!alg){throw new Error("Algorithm not found: "+algKey)}else if(alg.isCustom){return AlgorithmsSettingsService.getCustomAlgorithmSettings($scope.mlTaskDesign,algKey)}else if($scope.isPluginAlgorithm(alg)){return AlgorithmsSettingsService.getPluginAlgorithmSettings($scope.mlTaskDesign,alg.algKey)}else{return $scope.mlTaskDesign.modeling[alg.hpSpaceName||algKey]}};$scope.hasActiveMLTask=function(){return $scope.mlTasksContext&&!!$scope.mlTasksContext.activeMLTask};$scope.isBayesianSearchWithSkopt=function(){if(!$scope.mlTaskDesign||!$scope.mlTaskDesign.modeling||!$scope.mlTaskDesign.modeling.gridSearchParams){return false}const gridSearchParams=$scope.mlTaskDesign.modeling.gridSearchParams;return gridSearchParams.strategy==="BAYESIAN"&&gridSearchParams.bayesianOptimizer==="SCIKIT_OPTIMIZE"};$scope.removeCustomAlgorithm=function(custom_id){var idx;if(custom_id.startsWith("custom_python_")){idx=parseInt(custom_id.slice(14));$scope.mlTaskDesign.modeling.custom_python.splice(idx,1)}else if(custom_id.startsWith("custom_mllib_")){idx=parseInt(custom_id.slice(13));$scope.mlTaskDesign.modeling.custom_mllib.splice(idx,1)}$scope.setAlgorithms($scope.mlTaskDesign);$scope.setSelectedAlgorithm(AlgorithmsSettingsService.getDefaultAlgorithm($scope.mlTaskDesign,$scope.algorithms[$scope.mlTaskDesign.backendType]))};$scope.copyFeaturesHandling=function(exportSettings){if($scope.dirtySettings()){$scope.saveSettings()}DataikuAPI.projects.listHeads(exportSettings?"WRITE_CONF":null).success(function(projectData){CreateModalFromTemplate("/templates/analysis/mlcommon/settings/copy-settings.html",$scope,null,function(newScope){newScope.title="Copy features handling "+(exportSettings?"to":"from");newScope.totem="icon-"+(exportSettings?"copy":"paste");newScope.infoMessages=["Features handling will be copied based on their names"];if($scope.mlTaskDesign.taskType==="PREDICTION"){newScope.infoMessages.push(`Pasting features handling on the ${exportSettings?"selected":"current"}
                        model will not change the features handling of its ${$scope.isCausalPrediction()?"outcome":"target"}
                        ${$scope.isSampleWeightEnabled()?" nor of its sample weight":""}`)}newScope.projects=projectData;newScope.selectProject=function(){DataikuAPI.analysis.listHeads(newScope.selectedProjectKey).success(function(analysisData){newScope.analyses=analysisData;newScope.selectedAnalysisId=undefined;newScope.selectedTask=undefined}).error(setErrorInScope.bind($scope))};newScope.selectAnalysis=function(){DataikuAPI.analysis.listMLTasks(newScope.selectedProjectKey,newScope.selectedAnalysisId).success(function(taskData){newScope.tasks=taskData;newScope.descriptions=[];newScope.tasks.forEach(task=>{task.isNotSelectable=task.mlTaskId===$stateParams.mlTaskId&&newScope.selectedAnalysisId===$stateParams.analysisId&&newScope.selectedProjectKey===$stateParams.projectKey;newScope.descriptions.push($scope.displayTypes[task.predictionType||task.taskType]+" ("+($scope.backendTypeNames[task.backendType]||$scope.mlTaskDesign.backendType)+")")});newScope.selectedTask=undefined}).error(setErrorInScope.bind($scope))};if(newScope.projects.some(_=>_.projectKey===$stateParams.projectKey)){newScope.selectedProjectKey=$stateParams.projectKey;newScope.analyses=$scope.analyses;newScope.selectedAnalysisId=$stateParams.analysisId;newScope.selectAnalysis()}newScope.confirm=function(){const currentIds=[$stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId];const selectedIds=[newScope.selectedProjectKey,newScope.selectedAnalysisId,newScope.selectedTask.mlTaskId];const originIds=exportSettings?currentIds:selectedIds;const destinationIds=exportSettings?selectedIds:currentIds;DataikuAPI.analysis.mlcommon.copyFeatureSettings(...originIds,...destinationIds).success(function(data){if(!exportSettings){for(let featureName in $scope.mlTaskDesign.preprocessing.per_feature){Object.assign($scope.mlTaskDesign.preprocessing.per_feature[featureName],data.preprocessing.per_feature[featureName])}}newScope.dismiss()}).error(setErrorInScope.bind($scope));WT1.event("mltask-copy-features-handling",{export:exportSettings,sameProject:$stateParams.projectKey===newScope.selectedProjectKey,sameAnalysis:$stateParams.analysisId===newScope.selectedAnalysisId,typeDest:newScope.selectedTask.taskType==="CLUSTERING"?"CLUSTERING":newScope.selectedTask.predictionType,typeSrc:$scope.mlTaskDesign.taskType==="CLUSTERING"?"CLUSTERING":$scope.mlTaskDesign.predictionType})};newScope.cancel=function(){newScope.dismiss()}})}).error(setErrorInScope.bind($scope))}});app.controller("_MLTaskBaseController",function($scope,$state,$filter,Collections,DataikuAPI,TopNav,$stateParams,$location,CreateModalFromTemplate,Dialogs,ActivityIndicator,Fn,$q,Throttle,MLTasksNavService,$rootScope,$timeout,CAUSAL_META_LEARNERS,algorithmsPalette,COLOR_PALETTES,gradientGenerator,DatasetUtils,WT1,PartitionedModelsService,ModelLabelUtils,CustomMetricIDService,MLModelsUIRouterStates,AlgorithmsSettingsService,CodeMirrorSettingService,CachedAPICalls){TopNav.setLocation(TopNav.TOP_ANALYSES,TopNav.LEFT_ANALYSES,TopNav.TABS_ANALYSIS,"models");TopNav.setItem(TopNav.ITEM_ANALYSIS,$stateParams.analysisId);$scope.selection={partialProperty:"sessionId"};$scope.sessionInfo={};$scope.hooks={};$scope.uiState={currentMetric:"",currentMetricIsCustom:false};$scope.setAlgorithms=function(mlTaskDesign){$scope.algorithms=angular.copy($scope.base_algorithms);const isPythonBackend=mlTaskDesign.backendType==="PY_MEMORY";const customAlgos=isPythonBackend?mlTaskDesign.modeling.custom_python:mlTaskDesign.modeling.custom_mllib;$scope.editorOptionsCustom=isPythonBackend?CodeMirrorSettingService.get("text/x-python"):CodeMirrorSettingService.get("text/x-scala");AlgorithmsSettingsService.addCustomAlgorithmsToBaseAlgorithms($scope.algorithms[mlTaskDesign.backendType],customAlgos,isPythonBackend)};$scope.setSelectedAlgorithm=function(algorithm){$scope.uiState.algorithm=algorithm;$scope.uiState.scrollToMeAlgorithm=$scope.uiState.algorithm};$scope.isMLBackendType=function(mlBackendType){if($scope.mlTasksContext&&$scope.mlTasksContext.activeMLTask){return $scope.mlTasksContext.activeMLTask.backendType===mlBackendType}};$scope.backendIsPythonBased=function(){return $scope.isMLBackendType("KERAS")||$scope.isMLBackendType("PY_MEMORY")};$scope.isPythonClassicalMl=function(){const isPythonBackend=$scope.isMLBackendType("PY_MEMORY");if(!$scope.mlTaskDesign)return isPythonBackend;return isPythonBackend&&($scope.mlTaskDesign.taskType==="CLUSTERING"||$scope.isClassicalPrediction())};$scope.listMLTasks=function(){return DataikuAPI.analysis.listMLTasks($stateParams.projectKey,$stateParams.analysisId).success(function(data){$scope.mlTasksContext.type="mltasks";$scope.mlTasksContext.analysisMLTasks=data;$scope.mlTasksContext.activeMLTask=null;for(var i in data){if(data[i].mlTaskId==$stateParams.mlTaskId){$scope.mlTasksContext.activeMLTask=data[i];break}}})};$scope.createNewMLTask=function(){CreateModalFromTemplate("/templates/analysis/new-mltask-modal.html",$scope,"AnalysisNewMLTaskController")};$scope.renameMLTask=function(){DataikuAPI.analysis.mlcommon.getCurrentSettings($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId).success(function(mlTaskDesign){Dialogs.prompt($scope,"Rename modeling task","Rename modeling task",mlTaskDesign.name).then(function(newName){var fn;if(mlTaskDesign.taskType=="PREDICTION"){fn=DataikuAPI.analysis.pml.saveSettings}else if(mlTaskDesign.taskType=="CLUSTERING"){fn=DataikuAPI.analysis.cml.saveSettings}else{throw"Unknown mlTaskDesign Type"}mlTaskDesign.name=newName;fn($stateParams.projectKey,$stateParams.analysisId,mlTaskDesign).success(function(data){$state.go("projects.project.analyses.analysis.ml.list")})})}).error(setErrorInScope.bind($scope))};$scope.deleteMLTask=function(){Dialogs.confirm($scope,"Delete modeling task","Do you want to delete this modeling task ?").then(function(data){DataikuAPI.analysis.mlcommon.deleteMLTask($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId).success(function(data){$state.go("projects.project.analyses.analysis.ml.list")}).error(setErrorInScope.bind($scope))})};$scope.duplicateMLTask=function(){const DEFAULT_ANALYSIS={id:"new",name:"Create a new analysis…"};if($scope.dirtySettings()){$scope.saveSettings()}DataikuAPI.projects.listHeads("WRITE_CONF").success(function(writableProjects){if(writableProjects.length==0){Dialogs.error($scope,"No writable project","You don't have write access to any project, can't duplicate model.");return}const currentProjectWritable=writableProjects.some(_=>_.projectKey===$stateParams.projectKey);CreateModalFromTemplate("/templates/analysis/mlcommon/duplicate-mltask.html",$scope,null,function(newScope){newScope.totem="icon-machine_learning_"+($scope.mlTaskDesign.taskType==="CLUSTERING"?"clustering":"regression");newScope.projects=writableProjects;newScope.selectedProject=currentProjectWritable?$stateParams.projectKey:writableProjects[0].projectKey;newScope.$watch("selectedProject",function(project){if(!project)return;DatasetUtils.listDatasetsUsabilityForAny(project).success(function(datasets){newScope.availableDatasets=datasets;newScope.selectedDataset=project==$stateParams.projectKey?$scope.analysisCoreParams.inputDatasetSmartName:undefined}).error(setErrorInScope.bind(newScope))});newScope.$watch("selectedDataset",function(dataset){newScope.analyses=undefined;if(!dataset)return;const selectedDataset=newScope.availableDatasets.find(_=>_.smartName===dataset);DataikuAPI.datasets.get(newScope.selectedProject,selectedDataset.name,newScope.selectedProject).then(({data})=>newScope.columnNames=data.schema.columns.map(_=>_.name)).then(()=>DataikuAPI.analysis.listOnDataset(newScope.selectedProject,dataset)).then(({data})=>{const analyses=data;analyses.unshift(Object.assign({newName:"Analyze "+newScope.selectedDataset},DEFAULT_ANALYSIS));newScope.analyses=analyses;newScope.selectedAnalysis=analyses[0];if(newScope.selectedProject==$stateParams.projectKey&&newScope.selectedDataset==$scope.analysisCoreParams.inputDatasetSmartName){newScope.selectedAnalysis=analyses.find(_=>_.id===$scope.analysisCoreParams.id)}}).catch(setErrorInScope.bind(newScope))});function checkDatasetContainsTarget(){newScope.features={};if($scope.mlTaskDesign.taskType=="CLUSTERING"||!newScope.selectedAnalysis||newScope.selectedAnalysis.id===$stateParams.analysisId){return}if(newScope.selectedAnalysis.id=="new"||newScope.selectedAnalysis.nbSteps===0){if(!newScope.columnNames.includes($scope.mlTaskDesign.targetVariable)){newScope.features.available=newScope.columnNames}}}newScope.$watch("selectedAnalysis",checkDatasetContainsTarget);function duplicate(){if($scope.mlTaskDesign.taskType=="PREDICTION"){DataikuAPI.analysis.pml.duplicate($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId,newScope.selectedProject,newScope.selectedAnalysis.id,newScope.features.selected).success(function(result){if(result.success){$state.go("projects.project.analyses.analysis.ml.predmltask.list.design",{projectKey:newScope.selectedProject,analysisId:newScope.selectedAnalysis.id,mlTaskId:result.newMlTaskId.id})}else{newScope.features.available=result.possibleTargets}}).error(setErrorInScope.bind(newScope))}else{DataikuAPI.analysis.cml.duplicate($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId,newScope.selectedProject,newScope.selectedAnalysis.id).success(function(data){$state.go("projects.project.analyses.analysis.ml.clustmltask.list.design",{projectKey:newScope.selectedProject,analysisId:newScope.selectedAnalysis.id,mlTaskId:data.id})}).error(setErrorInScope.bind(newScope))}}newScope.confirm=function(){if(newScope.selectedAnalysis.id=="new"){DataikuAPI.analysis.create(newScope.selectedProject,newScope.selectedDataset,newScope.selectedAnalysis.newName).success(function(data){newScope.selectedAnalysis.id=data.id;duplicate()}).error(setErrorInScope.bind(newScope))}else{duplicate()}WT1.event("mltask-duplicate",{sameProject:$stateParams.projectKey==newScope.selectedProject,sameDataset:$scope.analysisCoreParams.inputDatasetSmartName==newScope.selectedDataset,sameAnalysis:$stateParams.analysisId==newScope.selectedAnalysis.id,taskType:$scope.mlTaskDesign.taskType=="CLUSTERING"?"CLUSTERING":$scope.mlTaskDesign.predictionType})}})}).error(setErrorInScope.bind($scope))};$scope.mlTaskFeatures=function(features,roles){if(!features)return 0;return $.map(features,function(v,k){v._name=k;return v}).filter(f=>!roles||roles&&roles.includes(f.role))};$scope.getEnabledModels=function(models){var enabledModels=[];for(var name in models){if(name==="custom_mllib"||name==="custom_python"){const enabledCustomModels=models[name].filter(m=>m.enabled);enabledModels=enabledModels.concat(enabledCustomModels)}else if(name.startsWith("plugin_python")){const enabledPluginModels=Object.values(models[name]).filter(m=>m.enabled);enabledModels=enabledModels.concat(enabledPluginModels)}else if(name==="propensityModeling"){continue}else if(models[name].enabled){enabledModels.push(models[name])}}return enabledModels};$scope.dirtySettings=function(){return!angular.equals($scope.savedSettings,dkuDeepCopy($scope.mlTaskDesign,$scope.SettingsService.noDollarKey))};const getEvaluationMetricId=function(modelingMetrics){if(modelingMetrics.evaluationMetric==="CUSTOM"){return CustomMetricIDService.getCustomMetricId(modelingMetrics.customEvaluationMetricName)}else{return modelingMetrics.evaluationMetric}};$scope.isSparkBased=function(){return $scope.mlTaskDesign.backendType=="MLLIB"||$scope.mlTaskDesign.backendType=="H2O"};$scope.isStandardBuiltinMetric=function(metric){return!$scope.isSparkBased()||metric[0]!=="CUSTOM"};$scope.hasFeatureReductionIncompatibleWithSparse=function(){return["ICA","PCA"].includes($scope?.mlTaskDesign?.preprocessing?.feature_selection_params?.method)};$scope.setMlTaskDesign=function(mlTaskDesign){$scope.mlTaskDesign=mlTaskDesign;$scope.uiState.preprocessingPerFeature=$scope.mlTaskDesign.preprocessing&&$scope.mlTaskDesign.preprocessing.per_feature;$scope.uiState.evaluationMetricId=getEvaluationMetricId(mlTaskDesign.modeling.metrics);$scope.selectCustomAlgo();$scope.retrieveCodeEnvsInfo();if(mlTaskDesign.taskType==="PREDICTION"){$scope.uiState.targetVariable=mlTaskDesign.targetVariable;$scope.uiState.splitMethodDesc=(mlTaskDesign.splitParams&&mlTaskDesign.splitParams.ssdSplitMode)==="SORTED"?"Based on time variable":"Randomly";CachedAPICalls.pmlDiagnosticsDefinition.then(pmlDiagnosticsDefinition=>{$scope.diagnosticsDefinition=pmlDiagnosticsDefinition(mlTaskDesign.backendType,mlTaskDesign.predictionType)})}else if(mlTaskDesign.taskType==="CLUSTERING"){CachedAPICalls.cmlDiagnosticsDefinition.then(cmlDiagnosticsDefinition=>{$scope.diagnosticsDefinition=cmlDiagnosticsDefinition(mlTaskDesign.backendType)})}};$scope.retrieveCodeEnvsInfo=function(){if($scope.appConfig.isAutomation){return}if($scope.isMLBackendType("PY_MEMORY")||$scope.isMLBackendType("KERAS")){DataikuAPI.codeenvs.listWithVisualMlPackages($stateParams.projectKey).success(function(data){$scope.codeEnvsCompat=data}).error(setErrorInScope.bind($scope))}};$scope.selectCustomAlgo=function(){if($scope.mlTaskDesign.guessPolicy!=="CUSTOM")return;if($scope.mlTaskDesign.backendType==="PY_MEMORY"&&$scope.mlTaskDesign.modeling.custom_python.length>0){const expectedAlgKeyPython="custom_python_"+($scope.mlTaskDesign.modeling.custom_python.length-1);$scope.uiState.algorithm=expectedAlgKeyPython}if($scope.mlTaskDesign.backendType==="MLLIB"&&$scope.mlTaskDesign.modeling.custom_mllib.length>0){const expectedAlgKeyMllib="custom_mllib_"+($scope.mlTaskDesign.modeling.custom_mllib.length-1);$scope.uiState.algorithm=expectedAlgKeyMllib}};$scope.beforeUpdateSettingsCallback=function(settings){};$scope.updateSettings=function(settings){$scope.beforeUpdateSettingsCallback(settings);$scope.setMlTaskDesign(settings);$scope.saveSettings()};$scope.revertScriptToSession=function(projectKey,analysisId,mlTaskDesignId,sessionId){return DataikuAPI.analysis.mlcommon.revertScriptToSession(projectKey,analysisId,mlTaskDesignId,sessionId).then(function(response){return response.data},setErrorInScope.bind($scope))};$scope.revertDesignToSession=function(sessionId){$scope.MLAPI.getSessionTask($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId,sessionId).success(function(sessionDesign){CreateModalFromTemplate("/templates/analysis/mlcommon/dump-session-design-modal.html",$scope,null,function(newScope){newScope.sessionId=sessionId.slice(1);newScope.sessionDesign=sessionDesign;newScope.algorithms={};newScope.selectAlgorithms=false;const algByKey=Collections.indexByField($scope.base_algorithms[$scope.mlTaskDesign.backendType],"algKey");algByKey["xgboost"]={name:"XGBoost"};angular.forEach(sessionDesign.modeling,function(v,k){if(v.enabled&&algByKey[k]){newScope.algorithms[k]={enabled:true,name:algByKey[k].name}}});angular.forEach(sessionDesign.modeling.custom_mllib,function(v,k){if(v.enabled){newScope.algorithms["custom_mllib_"+k]={enabled:true,name:"Custom MLLIB algorithm #"+k}}});angular.forEach(sessionDesign.modeling.custom_python,function(v,k){if(v.enabled){newScope.algorithms["custom_python_"+k]={enabled:true,name:v.name!=="Custom Python model"?v.name:"Custom python algorithm #"+k}}});newScope.noEnabledAlgorithms=function(){return $.map(newScope.algorithms,function(v,k){return!v.enabled}).reduce(Fn.AND,true)};newScope.confirm=function(){$scope.revertScriptToSession(newScope.projectSummary.projectKey,newScope.analysisId,newScope.mlTaskDesign.id,sessionId).then(function(scriptFile){$scope.analysisCoreParams.script=scriptFile;if(newScope.selectAlgorithms){angular.forEach(newScope.algorithms,function(v,k){if(k.startsWith("custom_mllib_")){newScope.sessionDesign.modeling.custom_mllib[parseInt(k.slice(13))].enabled=v.enabled}else if(k.startsWith("custom_python_")){newScope.sessionDesign.modeling.custom_python[parseInt(k.slice(14))].enabled=v.enabled}else{newScope.sessionDesign.modeling[k].enabled=v.enabled}})}$scope.updateSettings(newScope.sessionDesign);$state.go("^.^.design");newScope.dismiss()})}})})};$scope.removeTaskStatus=function(){$scope.mlTaskStatus=null};$scope.trainDirectly=function(){$scope.touchMlTask();$scope.mlTaskStatus=null;$scope.MLAPI.trainStart($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId,null,null,null,true).success(function(){$scope.initialRefreshAndAutoRefresh()}).error(setErrorInScope.bind($scope))};function updateSessionModels(){if($scope.selection&&$scope.selection.allObjects&&$scope.sessionTask&&$scope.sessionTask.sessionId){$scope.selection.sessionModels=$scope.selection.allObjects.filter(function(x){return x.sessionId==$scope.sessionTask.sessionId})}}$scope.getSessionName=function(sessionId,sessionType){let name="Session "+$filter("onlyNumbers")(sessionId);if(sessionType==="QUEUED"){const queueInfo=$scope.queueMap[`QUEUED-${sessionId}`];if(queueInfo&&queueInfo.userMeta&&queueInfo.userMeta.name){name=`${queueInfo.userMeta.name} (${sessionId})`}}else if($scope.modelSnippets){const sessionModel=Object.values($scope.modelSnippets||[]).find(ms=>ms.sessionId===sessionId&&ms.userMeta&&ms.userMeta.sessionName);if(sessionModel){name=sessionModel.userMeta.sessionName}}return name};$scope.$watch("selection.allObjects",updateSessionModels,true);$scope.$watch("sessionTask",updateSessionModels,true);$scope.abortTraining=function(){CreateModalFromTemplate("/templates/analysis/mlcommon/abort-train-modal.html",$scope,null,function(newScope){newScope.uiState={pauseQueue:false};newScope.nextSession=$scope.mlTaskStatus.queueStatus==="RUNNING"&&$scope.queuedSessionIds?$scope.queuedSessionIds[0]:null;newScope.confirm=function(){var toAbort=$scope.selection.allObjects.filter(function(o){return o.trainInfo.state==="PENDING"||o.trainInfo.state==="RUNNING"});DataikuAPI.analysis.mlcommon.trainAbort($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId,newScope.uiState.pauseQueue).success(function(){ActivityIndicator.success("Abort requested");toAbort.map(function(o){o.trainInfo.$userRequestedState="ABORTED"});refreshStatusAndModelSnippets()}).error(setErrorInScope.bind($scope));newScope.dismiss();WT1.event("mltask-abort",{taskType:$scope.mlTaskDesign.taskType,pauseQueue:newScope.uiState.pauseQueue,isPartialAbort:false})};newScope.finalize=function(){var toAbort=$scope.selection.allObjects.filter(function(o){return o.trainInfo.state==="RUNNING"||o.trainInfo.state==="PENDING"});DataikuAPI.analysis.mlcommon.stopGridSearchSession($scope.analysisCoreParams.projectKey,$scope.analysisCoreParams.id,$scope.sessionTask.id,$scope.sessionTask.sessionId).success(function(data){toAbort.map(function(o){o.trainInfo.$userRequestedState="FINALIZE"});$scope.refreshStatus()}).error(setErrorInScope.bind($scope));newScope.dismiss()}})};$scope.selectRunningOrFirstSession=function(){if($scope.mlTaskStatus.fullModelIds.length>0){var sids=$scope.mlTaskStatus.fullModelIds.filter(function(o){return o.training});if(sids.length===0){sids=$scope.mlTaskStatus.fullModelIds}sids=sids.map(Fn.propStr("fullModelId.sessionId")).map(function(sid){return parseInt(sid.slice(1))}).sort(function(a,b){return b-a});$scope.getSessionTaskIfChanged("s"+sids[0],true)}};$scope.refreshStatus=function(){return $scope.MLAPI.getTaskStatus($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId).success(function(data){$scope.mlTaskStatus=data;$scope.$broadcast("mlTaskStatusRefresh")}).error(setErrorInScope.bind($scope))};let recentlyTrainingModelIds=[];const refreshStatusAndModelSnippets=function(){return $scope.refreshStatus().then(function(){const modelIdsCurrentlyTraining=$scope.mlTaskStatus.fullModelIds.filter(function(o){return o.training}).map(function(o){return o.id});const noLongerTraining=recentlyTrainingModelIds.filter(id=>!modelIdsCurrentlyTraining.includes(id));recentlyTrainingModelIds=modelIdsCurrentlyTraining;getModelSnippets(modelIdsCurrentlyTraining.concat(noLongerTraining));if(!$scope.mlTaskStatus.training&&!$scope.mlTaskStatus.guessing){$scope.listQueuedSessions();if($scope.modelSnippets){getModelSnippets(Object.values($scope.modelSnippets).filter(function(o){return o.trainInfo.state==="RUNNING"||o.trainInfo.state==="PENDING"}).map(Fn.prop("fullModelId"))).then(()=>{setPossibleCustomMetrics();$scope.$broadcast("snippetUpdate")})}}})};$scope.initialRefreshAndAutoRefresh=function(){const afterGuessingDeffered=$q.defer(),refreshStartDate=new Date,refreshFirstDelay=1e3,refreshLastDelay=15*1e3,refreshGrowLength=120*1e3,throttle=Throttle().withScope($scope).withDelay(refreshFirstDelay);const autoRefresh=throttle.wrap(function(){refreshStatusAndModelSnippets().then(()=>{if(!$scope.mlTaskStatus.guessing){afterGuessingDeffered.resolve()}if($scope.mlTaskStatus.training||$scope.mlTaskStatus.guessing||$scope.mlTaskStatus.queueStatus==="RUNNING"){const newDelay=refreshFirstDelay+Math.round((refreshLastDelay-refreshFirstDelay)*Math.min((new Date-refreshStartDate)/refreshGrowLength)**2,1);throttle.withDelay(newDelay);autoRefresh()}})});$scope.refreshStatus().then($scope.selectRunningOrFirstSession).then(autoRefresh);return afterGuessingDeffered.promise};$scope.$watchCollection("modelSnippets",()=>{setAllSnippets();$scope.listQueuedSessions()});$scope.$watchCollection("queuedSessionIds",setAllSnippets);function setAllSnippets(){if(!$scope.modelSnippets&&$scope.queuedSessionIds)return;const modelSnippets=$scope.modelSnippets||{};const queuedSnippets=($scope.queuedSessionIds||[]).reduce((obj,sessionId)=>({...obj,[`QUEUED-${sessionId}`]:$scope.queueMap[`QUEUED-${sessionId}`]}),{});$scope.allModelSnippets={...modelSnippets,...queuedSnippets};setPossibleCustomMetrics();setMetricScales()}const setPossibleMetrics=function(){$scope.possibleMetrics=$scope.FilteringService.getPossibleMetrics($scope.mlTaskStatus.headSessionTask);$scope.allMetrics=[...$scope.possibleMetrics||[]];$scope.allMetricsHooks=$scope.allMetrics.map(m=>m[0])};const setUICurrentMetric=function(headSessionTask){if(headSessionTask&&headSessionTask.modeling&&headSessionTask.modeling.metrics){$scope.uiState.currentMetric=getEvaluationMetricId(headSessionTask.modeling.metrics)}};const setPossibleCustomMetrics=function(){if($scope.allModelSnippets){$scope.possibleCustomMetrics=$scope.FilteringService.getPossibleCustomMetrics($scope.allModelSnippets).map(item=>{return[item.id,item]});if($scope.possibleMetrics){$scope.allMetrics=[...$scope.possibleMetrics]}else{$scope.allMetrics=[]}$scope.possibleCustomMetrics.forEach(customMetric=>{$scope.allMetrics.push([customMetric[0],CustomMetricIDService.getCustomMetricName(customMetric[0])])});$scope.allMetricsHooks=$scope.allMetrics.map(m=>m[0]);$scope.$broadcast("redrawFatTable")}if(!$scope.uiState.currentMetric){setUICurrentMetric($scope.mlTaskStatus.headSessionTask)}};const sessions={};$scope.getSessionTaskIfChanged=function(newSessionId,dropCache){if(!newSessionId||!dropCache&&$scope.sessionTask&&$scope.sessionTask.sessionId===newSessionId)return;if(!dropCache&&sessions[newSessionId]){$scope.sessionTask=sessions[newSessionId];$scope.setAdditionalSnippetParams&&$scope.setAdditionalSnippetParams();return}$scope.MLAPI.getSessionTask($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId,newSessionId).success(function(sessionTask){$scope.sessionTask=sessionTask;$scope.sessionTask.sessionId=newSessionId;$scope.setAdditionalSnippetParams&&$scope.setAdditionalSnippetParams();setPossibleMetrics();setPossibleCustomMetrics();if($scope.uiState.evaluationMetricId===undefined){$scope.uiState.evaluationMetricId=getEvaluationMetricId(sessionTask.modeling.metrics)}sessions[newSessionId]=$scope.sessionTask}).error(setErrorInScope.bind($scope))};$scope.openDeleteModelAndSessionModal=function(fullModelIds,queuedSessionIds){const hasModels=fullModelIds&&fullModelIds.length;const hasQueuedSessions=queuedSessionIds&&queuedSessionIds.length;let dialogTitle="Delete ";let dialogText="Are you sure you want to delete ";if(hasModels){dialogTitle+=fullModelIds.length+" model"+(fullModelIds.length>1?"s":"");dialogText+=fullModelIds.length>1?"these models":"this model";if(hasQueuedSessions){dialogTitle+=" and ";dialogText+=" and "}}if(hasQueuedSessions){dialogTitle+=queuedSessionIds.length+" queued session"+(queuedSessionIds.length>1?"s":"");dialogText+=queuedSessionIds.length>1?"these queued sessions":"this queued session"}dialogText+="?";Dialogs.confirm($scope,dialogTitle,dialogText).then(function(){if(hasModels){DataikuAPI.ml.deleteModels(fullModelIds).success(function(){fullModelIds.forEach(function(fmi){delete $scope.modelSnippets[fmi]});if(Object.values($scope.modelSnippets).filter(function(s){return s.sessionId===$scope.sessionTask.sessionId}).length===0){$scope.refreshStatus().then($scope.selectRunningOrFirstSession)}})}if(hasQueuedSessions){DataikuAPI.analysis.mlcommon.deleteQueuedSessions($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId,queuedSessionIds).success(()=>{$scope.listQueuedSessions()}).error(setErrorInScope.bind($scope));WT1.event("mltask-delete-queued-session",{taskType:$scope.mlTaskDesign.taskType})}})};$scope.queuedSessionIds=[];$scope.queueMap={};$scope.listQueuedSessions=function(){DataikuAPI.analysis.mlcommon.listQueuedSessions($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId).success(function(queuedSessions){$scope.queuedSessionIds=queuedSessions.map(session=>session.id);queuedSessions.forEach(queuedSession=>{const id=queuedSession.id;$scope.queueMap[`QUEUED-${id}`]=Collections.updateNoDereference($scope.queueMap[`QUEUED-${id}`],queuedSessionToSnippet(queuedSession))})}).error(setErrorInScope.bind($scope))};function queuedSessionToSnippet(session){return{sessionId:session.id,trainInfo:{state:"QUEUED"},userMeta:{starred:false,name:session.metadata.userSessionName,description:session.metadata.userSessionDescription}}}function pauseQueue(){DataikuAPI.analysis.mlcommon.pauseQueue($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId).error(setErrorInScope.bind($scope)).finally(()=>{$scope.listQueuedSessions()})}$scope.openPauseQueueDialog=function(){Dialogs.confirm($scope,"Pause queue","Are you sure you want to pause the queue? The queue will be paused once the current session has finished training.").then(function(){pauseQueue()})};$scope.deleteQueuedSessions=function(sessionIds){$scope.openDeleteModelAndSessionModal(null,sessionIds)};$scope.listQueuedSessions();const setContainerUsageMetrics=function(){if(!$scope.mlTaskStatus||!$scope.modelSnippets||!$scope.mlTaskDesign||!$scope.mlTaskDesign.modeling||!$scope.mlTaskDesign.modeling.gridSearchParams||!$scope.mlTaskDesign.modeling.gridSearchParams.distributed){return}angular.forEach($scope.modelSnippets,function(snippet){snippet.maxKubernetesContainers=$scope.mlTaskDesign.modeling.gridSearchParams.nContainers;if(snippet.partitionedModelEnabled){snippet.maxKubernetesContainers*=PartitionedModelsService.getPartitionsSnippetStateSize(snippet,"RUNNING")}snippet.containerUsageMetrics=$scope.mlTaskStatus.fullModelIds.filter(_=>_.id===snippet.fullModelId)[0].containerUsageMetrics})};const setAlgorithmColors=function(){if(!($scope.mlTasksContext.activeMLTask.backendType in $scope.base_algorithms)){return}const algList=$scope.base_algorithms[$scope.mlTasksContext.activeMLTask.backendType].filter(function(o){return!o.condition||o.condition()});if($scope.mlTaskDesign&&$scope.mlTaskDesign.taskType==="CLUSTERING"){const actualAlgListKeys=new Set(Object.values($scope.modelSnippets).map(snippet=>`${snippet.algorithm}-${snippet.usesPCA}`));const colorByAlg={};angular.forEach(Array.from(actualAlgListKeys).sort(),function(algKey,idx){colorByAlg[algKey]=algorithmsPalette(idx)});let offsetOrderIdx=0;Object.entries(Object.values($scope.modelSnippets).groupBy(snippet=>`${snippet.algorithm}-${snippet.usesPCA}`)).map(([algorithmGroupKey,snippetsByKey],groupIdx)=>{const algorithmColor=colorByAlg[algorithmGroupKey];const snippetsColors=gradientGenerator(algorithmColor,snippetsByKey.length);angular.forEach(snippetsByKey.sort((a,b)=>a.nbClusters-b.nbClusters),function(snippet,k){snippet.color=snippetsColors[k];snippet.algorithmOrder=offsetOrderIdx+k});offsetOrderIdx+=snippetsByKey.length})}else{const algKeyList=algList.map(alg=>alg.algEnumName||alg.algKey);let offset=1;angular.forEach($scope.modelSnippets,function(snippet,k){let idx=-1;if(snippet.algorithm){idx=algKeyList.indexOf(snippet.algorithm.toLowerCase())}if(idx===-1){idx=algKeyList.length+offset;offset++}if(snippet.metaLearner){idx+=CAUSAL_META_LEARNERS.displayNames.indexOf(snippet.metaLearner)}if(snippet.predictionType==="TIMESERIES_FORECAST"&&algList[idx]){let displayGroups=algList[idx].displayGroups;if(displayGroups.includes("statistical")){}else if(displayGroups.includes("deepLearning")){}else if(displayGroups.includes("classicalML")){idx+=20*COLOR_PALETTES.algorithms.length+4}else if(displayGroups.includes("baseline")){idx+=40*COLOR_PALETTES.algorithms.length+3}else if(displayGroups.includes("legacy")){idx+=40*COLOR_PALETTES.algorithms.length+3}}snippet.color=algorithmsPalette(idx);snippet.algorithmOrder=idx})}};const setMainMetric=function(){if(!$scope.mlTaskStatus||!$scope.modelSnippets||!$scope.mlTaskDesign||!$scope.mlTaskDesign.modeling||!$scope.uiState.currentMetric){return}$scope.uiState.currentMetricIsCustom=CustomMetricIDService.checkMetricIsCustom($scope.uiState.currentMetric);$scope.FilteringService.setMainMetric(Object.values($scope.modelSnippets),[],$scope.uiState.currentMetricIsCustom?CustomMetricIDService.getCustomMetricName($scope.uiState.currentMetric):$scope.uiState.currentMetric,$scope.mlTaskDesign.modeling.metrics.customMetrics,$scope.uiState.currentMetricIsCustom)};$scope.libMetric=function(metricName,customMetrics,customEvaluationMetricName=""){return $scope.SettingsService.sort.lowerIsBetter(metricName,customMetrics,customEvaluationMetricName)};const setMetricScales=function(){if($scope.sessionTask&&$scope.sessionTask.modeling){$scope.metricScales={};$scope.possibleMetrics.map(Fn.prop(0)).forEach(function(metric){const metrics=Object.values($scope.modelSnippets).map(Fn.prop(this.metricMap[metric]));$scope.metricScales[metric]=calculateMetricScales(metrics,$scope.libMetric(metric,[]))},$scope.FilteringService);$scope.possibleCustomMetrics.forEach(function(metricItem){var metricId=metricItem[0],metric=metricItem[1];var greaterIsBetter=metric.greaterIsBetter;var metricName=CustomMetricIDService.getCustomMetricName(metricId);var metrics=Object.values($scope.modelSnippets).map(snippet=>{if(snippet.customMetricsResults){var filteredMetrics=snippet.customMetricsResults.filter(customMetricResult=>customMetricResult.metric.name===metricName);if(filteredMetrics[0]){return filteredMetrics[0].value}}});$scope.metricScales[metricId]=calculateMetricScales(metrics,!greaterIsBetter)},$scope.FilteringService)}};const calculateMetricScales=function(metrics,lowerIsBetter){var min=d3.min(metrics),max=d3.max(metrics);return min===max?Fn.cst("grey"):d3.scale.linear().range(["red","orange","green"]).domain([lowerIsBetter?max:min,(max+min)/2,lowerIsBetter?min:max])};const getModelSnippets=function(fullModelIds,getAll){if(!$scope.modelSnippets){$scope.modelSnippets={}}if(!getAll&&fullModelIds.length==0){return $q.when(null)}return $scope.MLAPI.getModelSnippets($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId,fullModelIds,getAll).then(function(response){angular.forEach(response.data,function(model,fmi){$scope.modelSnippets[fmi]=Collections.updateNoDereference($scope.modelSnippets[fmi],model)});$scope.setAdditionalSnippetParams&&$scope.setAdditionalSnippetParams();setAlgorithmColors();setMainMetric();setContainerUsageMetrics()}).catch(setErrorInScope.bind($scope))};$scope.deferredAfterInitMlTaskDesign=DataikuAPI.analysis.getCore($stateParams.projectKey,$stateParams.analysisId).then(({data})=>{$scope.analysisCoreParams=data;TopNav.setItem(TopNav.ITEM_ANALYSIS,$stateParams.analysisId,{name:data.name,dataset:data.inputDatasetSmartName});TopNav.setPageTitle(data.name+" - Analysis")}).then($scope.listMLTasks).then($scope.initialRefreshAndAutoRefresh).then($scope.initMlTaskDesign).then(()=>{const compareFMIs=function(b,a){const af=a.fullModelId,bf=b.fullModelId;if(af.sessionId!==bf.sessionId)return parseInt(af.sessionId.slice(1))-parseInt(bf.sessionId.slice(1));if(af.preprocessingId!==bf.preprocessingId)return parseInt(af.preprocessingId.slice(2))-parseInt(bf.preprocessingId.slice(2));return parseInt(af.modelId.slice(1))-parseInt(bf.modelId.slice(1))};const headIds=$scope.mlTaskStatus.fullModelIds.sort(compareFMIs).map(o=>o.id).slice(0,1);getModelSnippets([],true);getModelSnippets(headIds)}).catch(setErrorInScope.bind($scope));$scope.$on("$destroy",$scope.clearMLTasksContext);MLTasksNavService.setMlTaskIdToGo($stateParams.analysisId,$stateParams.mlTaskId);checkChangesBeforeLeaving($scope,$scope.dirtySettings,null,MLModelsUIRouterStates.getAllowedTransitions());if($rootScope.mlTaskJustCreated===true){delete $rootScope.mlTaskJustCreated;$scope.mlTaskJustCreated=true;$scope.touchMlTask=function(){delete $scope.mlTaskJustCreated}}else{$scope.touchMlTask=function(){}}$scope.prepareGuessPolicies=function(policies){policies.forEach(policy=>{if(!policy.supported_backends.includes($scope.mlTaskDesign.backendType)){policy.disabled=true}if(policy.id==="CUSTOM"){policy.description=`Train your own ${$scope.mlTaskDesign.backendType==="PY_MEMORY"?"Python":"Scala"} models.`}});return policies};$scope.switchGuessPolicy=function(policy){if(policy.disabled){return}if($scope.dirtySettings()){$scope.saveSettings()}CreateModalFromTemplate("/templates/analysis/mlcommon/settings/change-algorithm-presets-modal.html",$scope,null,function(newScope){newScope.taskType=$scope.mlTaskDesign.taskType.toLowerCase();newScope.confirm=function(){$scope.MLAPI.changeGuessPolicy($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId,policy.id).then(function(response){$scope.setMlTaskDesign(response.data);$scope.saveSettings();$scope.setAlgorithms($scope.mlTaskDesign);$scope.setSelectedAlgorithm(AlgorithmsSettingsService.getDefaultAlgorithm($scope.mlTaskDesign,$scope.algorithms[$scope.mlTaskDesign.backendType]))},setErrorInScope.bind($scope));newScope.dismiss()};newScope.cancel=function(){newScope.dismiss()}})};$scope.$watch("selection.selectedObject",function(nv){$scope.getSessionTaskIfChanged((nv||{}).sessionId)});$scope.$watch("uiState.currentMetric",setMainMetric);$scope.canSave=function(){return ModelLabelUtils.validateLabels($scope.mlTaskDesign)}});app.controller("_MLTaskResultsController",function($scope,$timeout,$state,$stateParams,ActivityIndicator,CreateModalFromTemplate,DataikuAPI,Fn,Dialogs,PartitionedModelsService,FullModelLikeIdUtils,MetricsUtils,MLDiagnosticsService,createOrAppendMELikeToModelComparisonModalDirective,createOrAppendModelsToExperimentTrackingModalDirective,CreateModalFromComponent,WT1,MLTaskInformationService){angular.extend($scope,PartitionedModelsService);angular.extend($scope,MLDiagnosticsService);$scope.partiallyAbortTraining=function(fullModelIds){var gsModels;if(!$scope.isModelOptimizing){gsModels=[]}else{gsModels=fullModelIds.map(function(o){return $scope.modelSnippets[o]}).filter($scope.isModelOptimizing).map(Fn.prop("fullModelId"))}CreateModalFromTemplate("/templates/analysis/mlcommon/abort-train-modal.html",$scope,null,function(newScope){newScope.gsModels=gsModels;newScope.nextSession=$scope.mlTaskStatus.queueStatus==="RUNNING"&&$scope.queuedSessionIds&&($scope.selection.sessionModels||[]).filter(function(model){return $scope.isModelRunning(model)}).length===1?$scope.queuedSessionIds[0]:null;newScope.confirm=function(){DataikuAPI.analysis.mlcommon.trainAbortPartial($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId,fullModelIds,newScope.uiState.pauseQueue).success(function(){ActivityIndicator.success("Abort requested");fullModelIds.forEach(function(fmi){$scope.modelSnippets[fmi].trainInfo.$userRequestedState="ABORTED"})}).error(setErrorInScope.bind($scope));WT1.event("mltask-abort",{taskType:$scope.mlTaskDesign.taskType,pauseQueue:newScope.uiState.pauseQueue,isPartialAbort:true});newScope.dismiss()};newScope.finalize=function(){DataikuAPI.analysis.mlcommon.stopGridSearch(gsModels).success(function(data){gsModels.map(function(fmi){$scope.modelSnippets[fmi].trainInfo.$userRequestedState="FINALIZE"});$scope.refreshStatus()}).error(setErrorInScope.bind($scope));newScope.dismiss()}})};$scope.revertDesignToModel=function(fullModelId,algorithm){const idTokens=FullModelLikeIdUtils.parse(fullModelId);const sessionId=idTokens.sessionId;CreateModalFromTemplate("/templates/analysis/mlcommon/dump-model-design-modal.html",$scope,null,function(newScope){newScope.sessionId=sessionId.slice(1);newScope.canChoose="SCIKIT_MODEL"!==algorithm&&!$scope.isPartitionedSession(sessionId);if(newScope.canChoose){newScope.dumpMode="OPTIMIZED"}else{newScope.dumpMode="INITIAL"}newScope.confirm=function(){$scope.revertScriptToSession(newScope.projectSummary.projectKey,newScope.analysisId,newScope.mlTaskDesign.id,sessionId).then(function(scriptFile){$scope.analysisCoreParams.script=scriptFile;if(newScope.dumpMode=="OPTIMIZED"){$scope.revertDesignToGridsearchedModel(fullModelId);newScope.dismiss()}else{$scope.revertDesignToPretrainModel(fullModelId);newScope.dismiss()}})}})};$scope.downloadTrainDiagnosis=function(fullModelId){CreateModalFromTemplate("/templates/analysis/mlcommon/download-train-diagnosis-modal.html",$scope,null,function(newScope){newScope.includeTrainingData=false;if($scope.isSparkBased()){newScope.includeTrainingDataDisabledMessage="Training data can't be downloaded for Spark-based models."}else if(!$scope.projectSummary||!$scope.projectSummary.canExportDatasetsData){newScope.includeTrainingDataDisabledMessage="You don't have the permission to download training data"}newScope.confirm=function(){ActivityIndicator.success("Preparing train diagnosis ...");downloadURL(DataikuAPI.analysis.mlcommon.getTrainDiagnosisURL(fullModelId,newScope.includeTrainingData));newScope.dismiss()}})};const getPretrainEquivalentMLTask=function(fullModelId,usePostTrain){return $scope.MLAPI.getPretrainEquivalentMLTask(fullModelId,usePostTrain).then(response=>{return response.data},setErrorInScope.bind($scope))};$scope.revertDesignToPretrainModel=function(fullModelId){getPretrainEquivalentMLTask(fullModelId,false).then(function(sessionDesign){$scope.updateSettings(sessionDesign);$state.go("^.^.design")})};$scope.revertDesignToGridsearchedModel=function(fullModelId){getPretrainEquivalentMLTask(fullModelId,true).then(function(sessionDesign){$scope.updateSettings(sessionDesign);$state.go("^.^.design")})};$scope.updateOrderQueryMetric=function(metric){var ss=$scope.selection;ss.orderQuery="-sortMainMetric";if($scope.uiState.currentMetric===metric){ss.orderReversed=!ss.orderReversed}else{ss.orderReversed=false}$scope.uiState.currentMetric=metric;$timeout($scope.updateSorted)};$scope.forbiddenModelDeletionReason=function(models){if(models.length<1){return"At least one model must be selected"}if(models.some(model=>model.trainInfo.state==="RUNNING"||model.trainInfo.state==="PENDING"||$scope.isSessionRunning(model.sessionId))){return"Cannot delete models belonging to a running session"}if(!$scope.canWriteProject()){return"You don't have write permissions for this project"}};$scope.forbiddenRevertDesignToThisModelReason=function(model){if(model.isEnsembled){return"Cannot revert design to an Ensemble model"}if(!$scope.canWriteProject()){return"You don't have write permissions for this project"}};$scope.isEnsembleModel=function(sessionId){return $scope.selection&&$scope.selection.allObjects&&$scope.selection.allObjects.some(model=>model.sessionId===sessionId&&model.isEnsembled)};$scope.comparisonForbiddenReason=function(){if($scope.mlTasksContext.activeMLTask.backendType==="DEEP_HUB"){return"Computer vision model comparison is not supported"}if($scope.mlTasksContext.activeMLTask.taskType!=="PREDICTION"){return"Only prediction models can be compared"}if(!$scope.selection||!$scope.selection.selectedObjects||$scope.selection.selectedObjects.length<1){return"At least one model must be selected"}if(!$scope.selection.selectedObjects.every(model=>model.predictionType===$scope.selection.selectedObjects[0].predictionType)){return"Compared models must have the same prediction type"}if(!$scope.selection.selectedObjects.every(model=>model.trainInfo.state==="DONE")){return"Only successfully trained models can be compared"}if($scope.selection.selectedObjects.some(model=>model.partitionedModelEnabled)){return"Partitioned models cannot be compared"}if($scope.selection.selectedObjects.some(model=>model.isEnsembled)){return"Ensembled models cannot be compared"}if(!$scope.canWriteProject()){return"You don't have write permissions for this project"}};$scope.compareWithExperimentTrackingForbiddenReason=function(){if(!["PY_MEMORY","KERAS"].includes($scope.mlTasksContext.activeMLTask.backendType)||!(["MULTICLASS","BINARY_CLASSIFICATION","REGRESSION"].includes($scope.mlTasksContext.activeMLTask.predictionType)||$scope.mlTasksContext.activeMLTask.taskType==="CLUSTERING")){return"This type of model cannot be compared in Experiment Tracking."}if(!$scope.selection||!$scope.selection.selectedObjects||$scope.selection.selectedObjects.length<1){return"At least one model must be selected"}if(!$scope.selection.selectedObjects.every(model=>model.trainInfo.state==="DONE")){return"Only successfully trained models can be compared"}if(!$scope.canWriteProject()){return"You don't have write permissions for this project"}};$scope.createModelComparison=function(){const nbModels=$scope.selection.selectedObjects.length;const predictionType=$scope.selection.selectedObjects[0].predictionType;const mlTaskName=$scope.mlTaskDesign.name;CreateModalFromComponent(createOrAppendMELikeToModelComparisonModalDirective,{fullIds:$scope.selection.selectedObjects.map(model=>model.fullModelId),modelTaskType:predictionType,suggestedMCName:`Compare ${nbModels} models from ${mlTaskName}`,projectKey:$stateParams.projectKey,trackFrom:"lab-sessions-list"})};$scope.compareWithExperimentTracking=function(){DataikuAPI.experimenttracking.getExperiments($stateParams.projectKey).success(function(data){CreateModalFromComponent(createOrAppendModelsToExperimentTrackingModalDirective,{experiments:data,fmis:$scope.selection.selectedObjects.map(o=>o.fullModelId),projectKey:$stateParams.projectKey,trackFrom:"lab-sessions-list"})}).error(setErrorInScope.bind($scope))};$scope.ensembleCreationForbiddenReason=function(){if($scope.mlTasksContext.activeMLTask.backendType==="DEEP_HUB"){return"Computer vision models cannot be used to create an ensemble model"}if($scope.mlTasksContext.activeMLTask.backendType==="KERAS"){return"Deep learning models cannot be used to create an ensemble model"}if($scope.mlTasksContext.activeMLTask.predictionType==="TIMESERIES_FORECAST"){return"Time series forecasting models cannot be used to create an ensemble model"}if(["CAUSAL_REGRESSION","CAUSAL_BINARY_CLASSIFICATION"].includes($scope.mlTasksContext.activeMLTask.predictionType)){return"Causal prediction models cannot be used to create an ensemble model"}if($scope.mlTasksContext.activeMLTask.taskType!=="PREDICTION"){return"Only prediction models can be used to create an ensemble model"}if(!$scope.selection||!$scope.selection.selectedObjects||$scope.selection.selectedObjects.length<2){return"At least two models must be selected"}if(!$scope.selection.selectedObjects.every(model=>model.trainInfo.state=="DONE")){return"Only successfully trained models can be part of an ensemble model"}if(!$scope.canWriteProject()){return"You don't have write permissions for this project"}};$scope.createEnsemble=function(){var fmis=$scope.selection.selectedObjects.map(function(o){return o.fullModelId});DataikuAPI.analysis.pml.checkCanEnsemble(fmis).success(function(data){CreateModalFromTemplate("/templates/analysis/prediction/create-ensemble-modal.html",$scope,"EnsembleModalController",function(newScope){newScope.fmis=fmis;newScope.params.method=data.availableMethods&&data.availableMethods.length?data.availableMethods[0].method:null;newScope.cannotEnsembleReason=data.cannotEnsembleReason;newScope.availableMethods=data.availableMethods;const methodMap={};newScope.availableMethods.forEach(par=>{methodMap[par.method]=par.description});newScope.getSelectedMethodDescription=function(){return methodMap[newScope.getMethod()]};newScope.showTiesWarning=function(){if(newScope.getMethod()==="VOTE"){if($scope.mlTaskDesign.predictionType==="BINARY_CLASSIFICATION"){return fmis.length%2===0}else{return $scope.mlTaskDesign.predictionType==="MULTICLASS"}}else{return false}};newScope.submit=function(){DataikuAPI.analysis.pml.createEnsemble($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId,fmis,newScope.getMethod()).success(function(){$scope.removeTaskStatus();$scope.initialRefreshAndAutoRefresh();newScope.dismiss()}).error(setErrorInScope.bind($scope))}})}).error(setErrorInScope.bind($scope))};$scope.allStarredModels=function(){var selectedObjects=$scope.selection.selectedObjects.filter(function(o){return o.trainInfo.state==="DONE"});return selectedObjects.map(Fn.prop("userMeta")).map(Fn.prop("starred")).reduce(function(a,b){return a&&b},true)};$scope.canStarSelectedModels=function(){return $scope.selection.selectedObjects.map(Fn.prop("trainInfo")).map(function(o){return o.state=="DONE"}).reduce(function(a,b){return a&&b},true)};$scope.starSelectedModels=function(star){var selectedObjects=$scope.selection.selectedObjects.filter(function(o){return o.trainInfo.state==="DONE"});selectedObjects.map(function(m){m.userMeta.starred=star})};$scope.isModelFinalizing=function(model){let key=$scope.isMLBackendType("KERAS")?"modelTrainingInfo":"gridsearchData";if(!model||!model[key]){return false}return model[key].isFinalizing&&$scope.isModelRunning(model)};$scope.isModelOptimizing=function(model){if(model.partitionedModelEnabled){return false}if($scope.isMLBackendType("KERAS")||$scope.isMLBackendType("DEEP_HUB")){if(!model||!model.modelTrainingInfo){return false}return!model.modelTrainingInfo.isFinalizing&&$scope.anySessionModelHasOptimizationResults()&&!$scope.anyModelHasAllEpochsFinished()&&$scope.isModelRunning(model)}else{if(!model){return false}const doingGridSearch=model.gridsearchData&&!model.gridsearchData.isFinalizing&&model.gridsearchData.gridPoints.length>0;return doingGridSearch&&$scope.isModelRunning(model)}};$scope.hasOptimizingModels=function(sessionId){return $scope.selection&&$scope.selection.allObjects&&$scope.selection.allObjects.some(function(model){return model.sessionId===sessionId&&$scope.isModelOptimizing(model)})};$scope.stopGridSearch=function(fullModelIds,setUiState=false){Dialogs.confirm($scope,"Suspend optimization for this model","Do you want to suspend the optimization for this model?").then(function(){WT1.event("stop-grid-search",{});DataikuAPI.analysis.mlcommon.stopGridSearch(fullModelIds).success(()=>{fullModelIds.forEach(fmi=>{$scope.modelSnippets[fmi].trainInfo.$userRequestedState="FINALIZE"});if(setUiState){$scope.uiState.$userRequestedState="FINALIZE"}$scope.refreshStatus()}).error(setErrorInScope.bind($scope))})};$scope.stopGridSearchSession=function(sessionId){const fullModelIds=$scope.selection.allObjects.filter(model=>model.sessionId===sessionId&&$scope.isModelOptimizing(model)).map(Fn.prop("fullModelId"));$scope.stopGridSearch(fullModelIds,true)};$scope.isModelOptimizationResumable=function(model){if($scope.isMLBackendType("KERAS")||$scope.isMLBackendType("DEEP_HUB")){return false}if(model.partitionedModelEnabled){return false}const searchProgress=$scope.getModelSearchProgress(model);return $scope.isModelDone(model)&&($scope.isModelOptimizationBoundByTimeout(model)||searchProgress!==undefined&&searchProgress<1)};$scope.isModelOptimizationBoundByTimeout=function(model){const gsd=model.gridsearchData;if(!gsd){return false}return gsd.gridSize===0&&gsd.timeout>0};$scope.getModelSearchProgress=function(model){const gsd=model.gridsearchData;if(!gsd){return undefined}if(gsd.gridSize!==0){return model.gridsearchData.gridPoints.length/model.gridsearchData.gridSize}else if(gsd.timeout>0){return Math.min(1,model.trainInfo.hyperparamsSearchTime/1e3/(gsd.timeout*60))}return 0};$scope.isModelDone=function(model){if(!model||!model.trainInfo){return false}return model.trainInfo.state==="DONE"};$scope.isModelPending=function(model){if(!model||!model.trainInfo){return false}return model.trainInfo.state==="PENDING"};$scope.isModelFailedOrAborted=function(model){if(!model||!model.trainInfo){return false}return model.trainInfo.state==="FAILED"||model.trainInfo.state==="ABORTED"};$scope.isMetricFailed=MetricsUtils.isMetricFailed;$scope.getSpecificCustomMetricResult=MetricsUtils.getSpecificCustomMetricResult;$scope.isModelFailed=function(model){if(!model||!model.trainInfo){return false}return model.trainInfo.state==="FAILED"};$scope.isModelRetrainable=function(model){return!$scope.mlTaskStatus.training&&$scope.mlTasksContext.activeMLTask.taskType==="PREDICTION"&&!($scope.isMLBackendType("KERAS")||$scope.isMLBackendType("DEEP_HUB"))&&($scope.isModelAborted(model)||model.partitionedModelEnabled&&$scope.getPartitionsSnippetStateSize(model,"ABORTED")>0)};$scope.hasResumableModels=function(sessionId){return $scope.selection&&$scope.selection.allObjects&&$scope.selection.allObjects.some(function(model){return model.sessionId===sessionId&&($scope.isModelOptimizationResumable(model)||$scope.isModelRetrainable(model))})};$scope.isModelAborted=function(model){if(!model||!model.trainInfo){return false}return model.trainInfo.state==="ABORTED"};$scope.isModelRunning=function(model){if(!model||!model.trainInfo){return false}return model.trainInfo.state==="RUNNING"||model.trainInfo.state==="PENDING"};$scope.isBestModelScore=function(model,sameSession){if(!model.mainMetric)return false;return model.sortMainMetric>=$scope.selection.allObjects.filter(o=>!sameSession||o.sessionId===model.sessionId).map(Fn.prop("sortMainMetric")).reduce(Fn.MAX,-Number.MAX_VALUE)};$scope.sessionRunningCount=function(sessionId){if(!$scope.selection||!$scope.selection.allObjects){return false}return $scope.selection.allObjects.filter(function(o){return o.sessionId===sessionId}).map($scope.isModelRunning).map(function(o){return o?1:0}).reduce(Fn.SUM,0)};$scope.isSessionRunning=sessionId=>MLTaskInformationService.isSessionRunning($scope,sessionId);$scope.isPartitionedSession=function(sessionId){if(!$scope.selection||!$scope.selection.allObjects){return false}return $scope.selection.allObjects.filter(o=>o.sessionId===sessionId).every(m=>m.partitionedModelEnabled)};$scope.getAggregationExplanation=function(metricName){const hideTestWeightMention=$scope.mlTaskDesign&&$scope.mlTaskDesign.predictionType==="TIMESERIES_FORECAST";if($scope.uiState.currentMetricIsCustom){return PartitionedModelsService.getAggregationExplanation(metricName,metricName,true,hideTestWeightMention)}else{const displayName=$scope.allMetrics.find(_=>_[0]===metricName)[1];return PartitionedModelsService.getAggregationExplanation(metricName,displayName,false,hideTestWeightMention)}};$scope.getSessionStartDate=function(sessionId){var minDate=0;$scope.getSessionModels($scope.selection.allObjects,sessionId).forEach(function(x){if(x&&x.trainInfo&&x.trainInfo.startTime){minDate=Math.max(minDate,x.trainInfo.startTime)}});if(minDate==0){return null}else{return new Date(minDate)}};$scope.getSessionEndDate=function(sessionId){var maxDate=0;$scope.getSessionModels($scope.selection.allObjects,sessionId).forEach(function(x){if(x&&x.trainInfo&&x.trainInfo.endTime){maxDate=Math.max(maxDate,x.trainInfo.endTime)}});if(maxDate==0){return null}else{return new Date(maxDate)}};$scope.deleteSession=function(sessionId){const models=$scope.selection.allObjects.filter(function(o){return!$scope.isModelRunning(o)&&o.sessionId===sessionId});const queuedSessionIds=models.length&&models[0].trainInfo&&models[0].trainInfo.state==="QUEUED"?[sessionId]:[];const fullModelIds=!queuedSessionIds.length?models.map(Fn.prop("fullModelId")):[];$scope.openDeleteModelAndSessionModal(fullModelIds,queuedSessionIds)};$scope.deleteModel=function(model){if($scope.isModelRunning(model)){return}$scope.openDeleteModelAndSessionModal([model.fullModelId])};$scope.deleteSelectedModelsAndQueuedSessions=function(includeQueuedSessionIds){const queuedSessionIds=includeQueuedSessionIds?$scope.selection.selectedObjects.filter(o=>o.trainInfo.state==="QUEUED").map(Fn.prop("sessionId")):[];const fullModelIds=$scope.selection.selectedObjects.filter(o=>o.trainInfo.state!=="RUNNING"&&o.trainInfo.state!=="PENDING"&&o.trainInfo.state!=="QUEUED").map(Fn.prop("fullModelId"));$scope.openDeleteModelAndSessionModal(fullModelIds,queuedSessionIds)};$scope.toggleStarred=function(snippetData){snippetData.userMeta.starred=!snippetData.userMeta.starred;DataikuAPI.ml.saveModelUserMeta(snippetData.fullModelId,snippetData.userMeta).error(setErrorInScope.bind($scope.$parent));$scope.$emit("refresh-list")};function getSessions(models,states,excludedSessions=[],orderByRecent=true){return(models||[]).filter(m=>states.includes(m.trainInfo.state)&&!(excludedSessions.length&&excludedSessions.includes(m.sessionId))).map(m=>m.sessionId).filter((value,index,self)=>self.indexOf(value)===index).sort((a,b)=>parseInt((orderByRecent?b:a).slice(1))-parseInt((orderByRecent?a:b).slice(1)))}$scope.getSessionModels=function(models,sessionId){return(models||[]).filter(m=>m.sessionId===sessionId&&!(m.trainInfo&&m.trainInfo.state==="QUEUED"))};$scope.sessionGroups=[];function setSessionGroups(sessions){const training={type:"TRAINING",sessions:getSessions(sessions,["RUNNING","PENDING"])};$scope.sessionGroups=[{type:"QUEUED",sessions:getSessions(sessions,["QUEUED"],training.sessions)},training,{type:"OTHER",sessions:getSessions(sessions,["DONE","ABORTED","FAILED"],training.sessions)}]}let alreadyScrolled=false;$scope.$watch("selection.filteredObjects",nv=>{setSessionGroups(nv);$scope.scrollToMe=false;if($scope.mlTaskStatus.training&&!alreadyScrolled){$scope.scrollToMe=true;alreadyScrolled=true}});$scope.$on("snippetUpdate",()=>{setSessionGroups($scope.selection.filteredObjects)});$scope.$watch("mlTaskStatus.training",()=>{if($scope.mlTaskStatus&&!$scope.mlTaskStatus.training){alreadyScrolled=false}});$scope.$watch("uiState.viewMode",function(nv){if(nv==="sessions"){$scope.selection.orderQuery=["-sessionDate","algorithmOrder"]}else{$timeout(function(){$scope.$broadcast("redrawFatTable")});$scope.selection.orderQuery=[]}});$scope.scrollToModel=selectedModel=>{if(!selectedModel){return}const selectedModelDOM=document.getElementById(selectedModel.fullModelId);if(selectedModelDOM){selectedModelDOM.scrollIntoView()}};$scope.selection.filterCategory={};$scope.clearModelsListFilters=function(){$scope.clearFilters();$scope.selection.filterCategory={}};$scope.getModelCount=function(models){return models.filter(model=>model.trainInfo.state!=="QUEUED").length};$scope.isModel=function(model){return model.trainInfo.state!=="QUEUED"}});app.component("algorithmModelFilter",{templateUrl:"/templates/ml/advanced-models-filter.html",controller:function($scope){const $ctrl=this;function getAllAlgorithmTypes(){let allAlgorithmTypes=[];Object.keys($ctrl.algorithmCategories).forEach((key,index)=>{allAlgorithmTypes=allAlgorithmTypes.concat($ctrl.algorithmCategories[key])});return allAlgorithmTypes}$ctrl.resetCategories=function(){for(let key of $ctrl.extendedAlgorithmCategories){$ctrl.filterCategory[key]=false}};$ctrl.algorithmsFilter=function(filteredObjects){if($ctrl.filterCategory){for(let key of Object.keys($ctrl.filterCategory)){if(key==="Others"&&$ctrl.filterCategory["Others"]){filteredObjects=filteredObjects.filter(x=>getAllAlgorithmTypes().includes(x.algorithm))}else if($ctrl.filterCategory[key]){filteredObjects=filteredObjects.filter(x=>!$ctrl.algorithmCategories[key].includes(x.algorithm))}}}return filteredObjects};$ctrl.$onChanges=function(changesObj){$ctrl.filterAlgorithms=false;if(changesObj.algorithmCategories&&changesObj.algorithmCategories.currentValue){$ctrl.extendedAlgorithmCategories=Object.keys(changesObj.algorithmCategories.currentValue);if($ctrl.algorithmCategories.others){$ctrl.extendedAlgorithmCategories.push("Others")}}if($ctrl.extendedAlgorithmCategories){$ctrl.resetCategories()}}},bindings:{selection:"=",algorithmCategories:"<",filterCategory:"<"}});app.service("MLDiagnosticsService",()=>{return{groupByStepAndType:mlDiagnostics=>{if(!mlDiagnostics||!mlDiagnostics.diagnostics){return{}}const groupedDiagnostics={};for(const diagnostic of mlDiagnostics.diagnostics){groupedDiagnostics[diagnostic.step]=groupedDiagnostics[diagnostic.step]||{};const groupedStep=groupedDiagnostics[diagnostic.step];groupedStep[diagnostic.displayableType]=groupedStep[diagnostic.displayableType]||[];const messages=groupedStep[diagnostic.displayableType];messages.push(diagnostic.message)}return groupedDiagnostics},groupByType:mlDiagnostics=>{if(!mlDiagnostics||!mlDiagnostics.diagnostics){return{}}const groupedDiagnostics={};for(const diagnostic of mlDiagnostics.diagnostics){groupedDiagnostics[diagnostic.type]=groupedDiagnostics[diagnostic.type]||[];const messages=groupedDiagnostics[diagnostic.type];messages.push(diagnostic.message)}return groupedDiagnostics},hasDiagnostics:model=>{if(!model){return false}const _hasDiagnostics=model=>(model.mlDiagnostics&&model.mlDiagnostics.diagnostics||[]).length>0;if(!model.partitionedModelEnabled){return _hasDiagnostics(model)}else{return model.partitions&&Object.values(model.partitions.summaries).map(s=>s.snippet).some(_hasDiagnostics)}},countDiagnostics:model=>{if(!model){return 0}const _countDiagnostics=model=>{if(!model.mlDiagnostics||!model.mlDiagnostics.diagnostics){return 0}return model.mlDiagnostics.diagnostics.length};let total=0;if(!model.partitionedModelEnabled){total=_countDiagnostics(model)}else{for(const s of Object.values(model.partitions.summaries)){if(s.state==="FAILED"){continue}total+=_countDiagnostics(s.snippet)}}return total},getDiagnosticsTextForPartitions:model=>{if(!model||!model.partitionedModelEnabled){return null}let countWithDiagnostics=0;for(const s of Object.values(model.partitions.summaries)){if(s.state!=="FAILED"&&Object.keys(s.snippet.mlDiagnostics&&s.snippet.mlDiagnostics.diagnostics||[]).length>0){countWithDiagnostics++}}const totalPartitions=Object.values(model.partitions.summaries).length;if(countWithDiagnostics===1){return`On one partition out of ${totalPartitions}`}else{return`On ${countWithDiagnostics} out of ${totalPartitions} partitions`}}}});app.factory("VisualMlCodeEnvCompatibility",function(){const service={getCodeEnvCompat:getCodeEnvCompat,isEnvAtLeastTensorflow2_2:isEnvAtLeastTensorflow2_2};return service;function getCodeEnvCompat(envSelection,envCompatList){if(!envSelection)return;let envCompat;switch(envSelection.envMode){case"USE_BUILTIN_MODE":envCompat=envCompatList.builtinEnvCompat;break;case"INHERIT":{if(!envCompatList.resolvedInheritDefault){envCompat=envCompatList.builtinEnvCompat}else{envCompat=envCompatList.envs.find(env=>env.envName===envCompatList.resolvedInheritDefault)}break}case"EXPLICIT_ENV":envCompat=envCompatList.envs.find(env=>env.envName===envSelection.envName);break}return envCompat}function isEnvAtLeastTensorflow2_2(mlTaskDesign,codeEnvsCompat){if(!mlTaskDesign||!codeEnvsCompat)return false;const envCompat=getCodeEnvCompat(mlTaskDesign.envSelection,codeEnvsCompat);return envCompat&&envCompat.keras&&envCompat.keras.isAtLeastTensorflow2_2}});app.component("codeEnvSelectionWithMlPackagesForm",{bindings:{mltaskDesign:"="},templateUrl:"/templates/analysis/mlcommon/code-env-selection-with-ml-packages-form.html",controller:function($scope,$stateParams,DataikuAPI){const $ctrl=this;$ctrl.$onInit=()=>{$ctrl.envModes=[["USE_BUILTIN_MODE","Use DSS builtin env"],["INHERIT","Inherit project default"],["EXPLICIT_ENV","Select an environment"]];fetchAndFormatEnvs($ctrl.mltaskDesign)};let currentEnvSelection=null;let currentContainerSelection=null;$ctrl.$doCheck=()=>{const envSelectionChanged=!angular.equals(currentEnvSelection,$ctrl.mltaskDesign.envSelection);const containerSelectionChanged=!angular.equals(currentContainerSelection,$ctrl.mltaskDesign.containerSelection);if($ctrl.envsCompatInfo&&(envSelectionChanged||containerSelectionChanged)){updateInformation();currentEnvSelection=angular.copy($ctrl.mltaskDesign.envSelection);currentContainerSelection=angular.copy($ctrl.mltaskDesign.containerSelection)}};function fetchAndFormatEnvs(mltaskDesign){DataikuAPI.codeenvs.listCompatibilityWithMLTask($stateParams.projectKey,mltaskDesign).then(function(response){$ctrl.envsCompatInfo=response.data;updateInformation();if(response.data.resolvedInheritDefaultCodeEnv==null){$ctrl.envModes[1][1]="Inherit project default (DSS builtin env)"}else{$ctrl.envModes[1][1]="Inherit project default ("+response.data.resolvedInheritDefaultCodeEnv+")"}}).catch(setErrorInScope.bind($scope))}function updateInformation(){if(!$ctrl.envsCompatInfo||!$ctrl.envsCompatInfo.envs){return}$ctrl.usedContainerConfName=getUsedContainerConfName();$ctrl.envsInfo=$ctrl.envsCompatInfo.envs.map(env=>formatCompatInfo(env.envName,$ctrl.usedContainerConfName)).sort((env1,env2)=>Number(env1.hasAnyIncompatibilities)-Number(env2.hasAnyIncompatibilities));setDefaultExplicitEnvIfNone($ctrl.envsInfo);const usedEnvName=getUsedEnvName();$ctrl.usedEnvInfo=formatCompatInfo(usedEnvName,$ctrl.usedContainerConfName);$ctrl.envDescriptions=$ctrl.envsInfo.map(envInfo=>envInfo.formattedDescription);$ctrl.compatibilityDescription=$ctrl.usedEnvInfo.compatibilityDescription}function setDefaultExplicitEnvIfNone(envsInfo){let envSelection=$ctrl.mltaskDesign.envSelection;if(envSelection.envMode=="EXPLICIT_ENV"&&!envSelection.envName){const firstCompatibleEnv=(envsInfo.find(e=>!e.hasAnyIncompatibilities)||{}).envName;if(firstCompatibleEnv){envSelection.envName=firstCompatibleEnv}}if(envSelection.envMode=="INHERIT"&&$ctrl.envsCompatInfo.resolvedInheritDefaultCodeEnv){envSelection.defaultEnvName=$ctrl.envsCompatInfo.resolvedInheritDefaultCodeEnv}}function formatCompatInfo(envName,containerConfName){let envIncompatibilityReasons;let builtForContainerConf;let compatibilityDescription;if(!envName){envIncompatibilityReasons=$ctrl.envsCompatInfo.builtinIncompatibilityReasons;compatibilityDescription=$ctrl.envsCompatInfo.builtinEnvDescription;builtForContainerConf=true}else{const envInfo=$ctrl.envsCompatInfo.envs.find(env=>env.envName===envName)||{};envIncompatibilityReasons=envInfo.incompatibilityReasons;compatibilityDescription=envInfo.description;builtForContainerConf=containerConfName?(envInfo.builtForContainerConfs||[]).indexOf(containerConfName)>-1:true}const allIncompatibilityReasons=angular.copy(envIncompatibilityReasons||[]);if(containerConfName&&!builtForContainerConf){allIncompatibilityReasons.push("Code-env was not built for containerized execution "+containerConfName)}let formattedDescription;if(hasIncompatibilities(allIncompatibilityReasons)){formattedDescription=getIncompatibleDesc(allIncompatibilityReasons)}else{formattedDescription="has required packages for "+compatibilityDescription+"."}const hasEnvIncompatibilities=hasIncompatibilities(envIncompatibilityReasons);const hasAnyIncompatibilities=hasIncompatibilities(allIncompatibilityReasons);return{envName:envName,builtForContainerConf:builtForContainerConf,formattedDescription:formattedDescription,compatibilityDescription:compatibilityDescription,hasEnvIncompatibilities:hasEnvIncompatibilities,hasAnyIncompatibilities:hasAnyIncompatibilities}}function getIncompatibleDesc(reasons){if(reasons.length===1){return`<span class='text-warning'>${reasons[0]}.</span>`}else{return reasons.map(r=>`<div class='text-warning'>${r}.</div>`).join("")}}function hasIncompatibilities(reasons){return reasons&&reasons.length>0}function getUsedContainerConfName(){switch($ctrl.mltaskDesign.containerSelection.containerMode){case"INHERIT":return $ctrl.envsCompatInfo.resolvedInheritDefaultContainer;case"EXPLICIT_CONTAINER":return $ctrl.mltaskDesign.containerSelection.containerConf;default:return undefined}}function getUsedEnvName(){switch($ctrl.mltaskDesign.envSelection.envMode){case"USE_BUILTIN_MODE":return undefined;case"INHERIT":{return $ctrl.envsCompatInfo.resolvedInheritDefaultCodeEnv}case"EXPLICIT_ENV":return $ctrl.mltaskDesign.envSelection.envName}}}});app.directive("modelsTableData",["computeColumnWidths","$window","CustomMetricIDService",function(computeColumnWidths,$window,CustomMetricIDService){return{scope:false,restrict:"A",link:function($scope,element){$scope.displayedTableColumns=[];$scope.displayedTableRows=[];angular.element($window).on("resize",function(){$scope.$apply($scope.adjustColumnWidths)});$scope.$on("$destroy",function(){angular.element($window).off("resize")});$scope.adjustColumnWidths=function(){let maxWidth=element.prop("clientWidth")-16;if($scope.computedTableWidth<maxWidth){$scope.displayedColumnsWidths=[];let totalWidth=0;$scope.computedColumnWidths.forEach(function(width){let newWidth=Math.round(width*maxWidth/$scope.computedTableWidth);totalWidth+=newWidth;$scope.displayedColumnsWidths.push(newWidth)});if(totalWidth>maxWidth){$scope.displayedColumnsWidths.push($scope.displayedColumnsWidths.splice(-1,1)[0]-(totalWidth-maxWidth))}}else{$scope.displayedColumnsWidths=$scope.computedColumnWidths}};var refreshDisplayedColumns=function(){$scope.displayedTableColumns=[{isModelSel:true},{isModelName:true},{isModelTrainTime:true},{isModelTrainTimeMetric:true}];let header=[{name:"sel",ncharsToShow:5},{name:"Name",ncharsToShow:25},{name:"Trained",ncharsToShow:20},{name:"Train time",ncharsToShow:6}];if($scope.mlTaskDesign.backendType==="PY_MEMORY"&&$scope.mlTaskDesign.taskType==="PREDICTION"&&["BINARY_CLASSIFICATION","MULTICLASS","REGRESSION"].includes($scope.mlTaskDesign.predictionType)){$scope.displayedTableColumns.push({isSampleWeights:true});header.push({name:"Sample weights",ncharsToShow:5})}if($scope.possibleMetrics){$scope.possibleMetrics.forEach(function(metric){$scope.displayedTableColumns.push({isModelMetric:true,metric:metric,isEvaluationMetric:$scope.uiState.evaluationMetricId===metric[0]});header.push({name:"MMMMM MMMMM",ncharsToShow:10})})}if($scope.possibleCustomMetrics){$scope.possibleCustomMetrics.forEach(function(metric){$scope.displayedTableColumns.push({isCustomMetric:true,metric:metric,isEvaluationMetric:metric[0]===$scope.uiState.evaluationMetricId});header.push({name:"Custom Metric #X",ncharsToShow:14})})}$scope.displayedTableColumns.push({isModelStarred:true});header.push({name:"star",ncharsToShow:1});$scope.computedColumnWidths=computeColumnWidths([],header,30,()=>false,{},{},true)[0];$scope.computedTableWidth=$scope.computedColumnWidths.reduce((a,b)=>a+b);$scope.adjustColumnWidths()};var refreshDisplayedRows=function(){$scope.displayedTableRows=[];if($scope.selection.filteredObjects){$scope.selection.filteredObjects.forEach(function(summ){if(summ.trainInfo.state==="QUEUED"){return}var row=[{isModelSel:true,summ:summ},{isModelName:true,summ:summ},{isModelTrainTime:true,summ:summ},{isModelTrainTimeMetric:true,summ:summ}];if($scope.mlTaskDesign.backendType==="PY_MEMORY"&&$scope.mlTaskDesign.taskType==="PREDICTION"&&["BINARY_CLASSIFICATION","MULTICLASS","REGRESSION"].includes($scope.mlTaskDesign.predictionType)){row.push({isSampleWeights:true,summ:summ})}if($scope.possibleMetrics){$scope.possibleMetrics.forEach(function(metric){row.push({isModelMetric:true,metric:metric,summ:summ,isEvaluationMetric:metric[0]===summ.evaluationMetric})})}if($scope.possibleCustomMetrics){$scope.possibleCustomMetrics.forEach(function(metric){const result=(summ.customMetricsResults||[]).filter(result=>result.metric.name===CustomMetricIDService.getCustomMetricName(metric[0]))[0];row.push({isCustomMetric:true,metric:metric,summ:summ,result:result,isEvaluationMetric:CustomMetricIDService.getCustomMetricName(metric[0])===summ.evaluationMetric})})}row.push({isModelStarred:true,summ:summ});$scope.displayedTableRows.push(row)})}};refreshDisplayedColumns();$scope.$watchCollection("selection.filteredObjects",function(){refreshDisplayedRows()});var refreshDisplayedColumnsAndRows=function(){refreshDisplayedColumns();refreshDisplayedRows()};$scope.$on("redrawFatTable",refreshDisplayedColumnsAndRows);$scope.$on("reflow",refreshDisplayedColumnsAndRows)}}}])})();(function(){"use strict";var app=angular.module("dataiku.analysis.mlcore")})();(function(){"use strict";let app=angular.module("dataiku.analysis.mlcore");app.service("PMLTrainTestPolicies",function(){return{trainTestPolicies:[["SPLIT_MAIN_DATASET","Split the dataset"],["EXPLICIT_FILTERING_SINGLE_DATASET_MAIN","Explicit extracts from the dataset"],["EXPLICIT_FILTERING_TWO_DATASETS","Explicit extracts from two datasets"],["SPLIT_OTHER_DATASET","Split another dataset"],["EXPLICIT_FILTERING_SINGLE_DATASET_OTHER","Explicit extracts from another dataset"]],trainTestPoliciesDesc:function(inputDatasetSmartName){return[`Split a subset of ${inputDatasetSmartName}`,`Use two extracts from ${inputDatasetSmartName}, one for train, one for test`,`Use two extracts from two different datasets, one for train, one for test`,`Split a subset of another dataset, compatible with ${inputDatasetSmartName}`,`Use two extracts from another dataset, one for train, one for test`]}}});app.service("EmbeddingService",function(ActiveProjectKey,DataikuAPI){const _getAvailableModels=(purpose,onError)=>{return new Promise((resolve,_)=>{DataikuAPI.pretrainedModels.listAvailableLLMs(ActiveProjectKey.get(),purpose).then(function(data){resolve(data.data)}).catch(onError)})};const metadataFetcher=onError=>{let availableTextEmbeddingModels=null;let availableImageEmbeddingModels=null;_getAvailableModels("TEXT_EMBEDDING_EXTRACTION",onError).then(function(available){availableTextEmbeddingModels=available});_getAvailableModels("IMAGE_EMBEDDING_EXTRACTION",onError).then(function(available){availableImageEmbeddingModels=available});function getSentenceEmbedding(featurePreprocessing){if(!availableTextEmbeddingModels){return null}const llm=availableTextEmbeddingModels.identifiers.find(llm=>llm.id===featurePreprocessing.sentenceEmbeddingModel);if(llm){return{friendlyName:llm.friendlyName,tokensLimit:llm.maxTokensLimit}}else{return{friendlyName:featurePreprocessing.sentenceEmbeddingModel+" (Code env based)",tokensLimit:featurePreprocessing.maxSequenceLength}}}function getImageEmbedding(featurePreprocessing){if(!availableImageEmbeddingModels){return null}const model=availableImageEmbeddingModels.identifiers.find(model=>model.id===featurePreprocessing.pretrainedModelsParams.structureRefId);if(model){return{friendlyName:model.friendlyName}}else{return{friendlyName:featurePreprocessing.pretrainedModelsParams.structureRefId}}}return{getSentenceEmbedding:getSentenceEmbedding,getImageEmbedding:getImageEmbedding}};return{metadataFetcher:metadataFetcher}});app.service("PMLSettings",function($filter,PMLTrainTestPolicies,DeepHubMetricsService,CustomMetricIDService,Logger){const cst={taskF:function(backend){return{bcEvaluationMetrics:[["ACCURACY","Accuracy"],["PRECISION","Precision"],["RECALL","Recall"],["F1","F1-score"],["COST_MATRIX","Cost Matrix"],["ROC_AUC","ROC AUC"],["CUMULATIVE_LIFT","Lift"],["AVERAGE_PRECISION","Average Precision"],["LOG_LOSS","Log Loss"]],mcEvaluationMetrics:[["ACCURACY","Accuracy"],["PRECISION","Precision"],["RECALL","Recall"],["F1","F1-score"],["ROC_AUC","ROC AUC"],["AVERAGE_PRECISION","Average Precision"],["LOG_LOSS","Log Loss"]],regressionEvaluationMetrics:[["EVS","Explained Variance Score"],["MAPE","Mean Absolute Percentage Error"],["MAE","Mean Absolute Error"],["MSE","Mean Squared Error"],["RMSE","Root Mean Square Error"],["RMSLE","Root Mean Square Logarithmic Error"],["R2","R2 Score"]],timeseriesEvaluationMetrics:[["MASE","Mean Absolute Scaled Error"],["MAPE","Mean Absolute Percentage Error"],["SMAPE","Symmetric Mean Absolute Percentage Error"],["MAE","Mean Absolute Error"],["MEAN_ABSOLUTE_QUANTILE_LOSS","Mean Absolute Quantile Loss"],["MEAN_WEIGHTED_QUANTILE_LOSS","Mean Weighted Quantile Loss"],["MSE","Mean Squared Error"],["RMSE","Root Mean Square Error"],["MSIS","Mean Scaled Interval Score"],["ND","Normalized Deviation"]],causalEvaluationMetrics:[["AUUC","Area Under the Uplift Curve"],["NET_UPLIFT","Net Uplift at Specified Level"],["QINI","Qini Score"]],crossvalModesRandom:function(backend){var base=[["SHUFFLE","Simple train/validation split"],["KFOLD","K-fold"]];if(backend==="PY_MEMORY"){base.push(["CUSTOM","Custom code"])}return base}(backend),getCrossvalModesRandomForDocumentation(crossValidationStrategy,mlTaskDesign){let crossvalModeDoc;switch(crossValidationStrategy){case"SHUFFLE":crossvalModeDoc="Simple train/validation split";break;case"KFOLD":crossvalModeDoc=`${mlTaskDesign.modeling.gridSearchParams.nFolds}-fold cross-validation`;break;case"CUSTOM":crossvalModeDoc="Custom Code";break}return crossvalModeDoc},crossvalModesWithTime:[["TIME_SERIES_SINGLE_SPLIT","Time-based train/validation split"],["TIME_SERIES_KFOLD","Time-based K-fold (with overlap)"],["CUSTOM","Custom code"]],getCrossvalModesWithTimeForDocumentation(crossValidationStrategy,mlTaskDesign){let crossvalModeDoc;switch(crossValidationStrategy){case"TIME_SERIES_SINGLE_SPLIT":crossvalModeDoc="Simple train/validation split";break;case"TIME_SERIES_KFOLD":crossvalModeDoc=`Time-based ${mlTaskDesign.modeling.gridSearchParams.nFolds}-fold (with overlap)`;break;case"CUSTOM":crossvalModeDoc="Custom code";break}return crossvalModeDoc}}},task:{predictionTypes:[{type:"BINARY_CLASSIFICATION",fullName:"Two-class classification",shortName:"binary",classical:true},{type:"MULTICLASS",fullName:"Multiclass classification",shortName:"multiclass",classical:true},{type:"REGRESSION",fullName:"Regression",shortName:"regression",classical:true},{type:"TIMESERIES_FORECAST",fullName:"Time series forecast",shortName:"forecast",forecast:true},{type:"CAUSAL_BINARY_CLASSIFICATION",fullName:"Causal Classification",shortName:"causal classification",causal:true},{type:"CAUSAL_REGRESSION",fullName:"Causal Regression",shortName:"causal regression",causal:true},{type:null,fullName:"Other prediction",shortName:"other",other:true}],isClassification:function(predictionType){return["BINARY_CLASSIFICATION","MULTICLASS","CAUSAL_BINARY_CLASSIFICATION"].includes(predictionType)},getDefaultEvaluationMetric:function(predictionType){switch(predictionType){case"BINARY_CLASSIFICATION":case"MULTICLASS":return"ROC_AUC";case"REGRESSION":return"R2";case"TIMESERIES_FORECAST":return"MASE"}},thresholdOptimizationMetrics:[["ACCURACY","Accuracy"],["F1","F1-score"],["COST_MATRIX","Cost Matrix"]],trainTestPolicies:PMLTrainTestPolicies.trainTestPolicies,trainTestPoliciesDesc:PMLTrainTestPolicies.trainTestPoliciesDesc,splitModes:[["RANDOM","Randomly"],["SORTED","Based on time variable"]],calibrationMethods:[["NO_CALIBRATION","None"],["SIGMOID","Sigmoid (Platt scaling)"],["ISOTONIC","Isotonic Regression"]]},names:{evaluationMetrics:function(){const metrics={PRECISION:"Precision",RECALL:"Recall",F1:"F1-score",ACCURACY:"Accuracy",EVS:"EVS",MAPE:"MAPE",MAE:"MAE",MSE:"MSE",RMSE:"RMSE",RMSLE:"RMSLE",R2:"R2 Score",PEARSON:"Correlation",COST_MATRIX:"Cost Matrix Gain",LOG_LOSS:"Log Loss",ROC_AUC:"ROC AUC",AVERAGE_PRECISION:"Average Precision",CALIBRATION_LOSS:"Calibration Loss",CUMULATIVE_LIFT:"Lift",DATA_DRIFT:"Data drift",DATA_DRIFT_PVALUE:"Data drift p-value",AUUC:"Area under Uplift Curve",QINI:"Qini Score",NET_UPLIFT:"Net Uplift at Specified Level",MASE:"MASE",SMAPE:"Symmetric MAPE",MEAN_ABSOLUTE_QUANTILE_LOSS:"Mean Absolute Quantile Loss",MEAN_WEIGHTED_QUANTILE_LOSS:"Mean Weighted Quantile Loss",MSIS:"MSIS",ND:"Normalized Deviation",WORST_MASE:"Worst MASE",WORST_MAPE:"Worst MAPE",WORST_SMAPE:"Worst SMAPE",WORST_MAE:"Worst MAE",WORST_MSE:"Worst MSE",WORST_MSIS:"Worst MSIS",MIN_KS:"Min KS",MIN_CHISQUARE:"Min Chi-square",MAX_PSI:"Max PSI",PREDICTION_DRIFT_PSI:"Prediction drift PSI",PREDICTION_DRIFT_KS:"Prediction drift KS",PREDICTION_DRIFT_CHISQUARE:"Prediction drift Chi-square",FAITHFULNESS:"Faithfulness",MULTIMODAL_FAITHFULNESS:"Multimodal faithfulness",ANSWER_RELEVANCY:"Answer relevancy",MULTIMODAL_RELEVANCY:"Multimodal relevancy",ANSWER_SIMILARITY:"Answer similarity",ANSWER_CORRECTNESS:"Answer correctness",CONTEXT_RECALL:"Context recall",CONTEXT_PRECISION:"Context precision",BERT_SCORE_PRECISION:"BERT Score - Precision",BERT_SCORE_RECALL:"BERT Score - Recall",BERT_SCORE_F1:"BERT Score - F1 Score",BLEU:"BLEU",ROUGE_1_PRECISION:"ROUGE-1 - Precision",ROUGE_1_RECALL:"ROUGE-1 - Recall",ROUGE_1_F1:"ROUGE-1 - F1 Score",ROUGE_2_PRECISION:"ROUGE-2 - Precision",ROUGE_2_RECALL:"ROUGE-2 - Recall",ROUGE_2_F1:"ROUGE-2 - F1 Score",ROUGE_L_PRECISION:"ROUGE-L - Precision",ROUGE_L_RECALL:"ROUGE-L - Recall",ROUGE_L_F1:"ROUGE-L - F1 Score",INPUT_TOKENS_PER_ROW:"Average Input tokens",OUTPUT_TOKENS_PER_ROW:"Average Output tokens",AVERAGE_TOOL_EXECUTIONS_PER_ROW:"Average number of tool calls",AVERAGE_FAILED_TOOL_EXECUTIONS_PER_ROW:"Average number of failed tool calls",AVERAGE_TOOL_EXECUTION_TIME_SECONDS_PER_ROW:"Average tool call execution time (s)",P95_TOTAL_AGENT_CALL_EXECUTION_TIME_SECONDS_PER_ROW:"P95 total agent call execution time (s)",SAMPLE_ROW_COUNT:"Sample row count",TOTAL_TOOL_EXECUTIONS:"Total tool calls",TOTAL_FAILED_TOOL_EXECUTIONS:"Total failed tool calls",TOTAL_TOOL_EXECUTION_TIME_SECONDS:"Total tool calls execution time (s)",TOTAL_AGENT_CALL_EXECUTION_TIME_SECONDS:"Total agent execution time",TOOL_CALL_EXACT_MATCH:"Median of Tool Call Exact match",TOOL_CALL_PARTIAL_MATCH:"Median of Tool Call Partial match",TOOL_CALL_PRECISION:"Median of Tool Call Precision",TOOL_CALL_RECALL:"Median of Tool Call Recall",TOOL_CALL_F1:"Median of Tool Call F1 Score",AGENT_GOAL_ACCURACY_WITH_REFERENCE:"Average Agent Goal Accuracy with reference",AGENT_GOAL_ACCURACY_WITHOUT_REFERENCE:"Average Agent Goal Accuracy without reference"};Object.entries(DeepHubMetricsService.metricNameToDescriptionMap()).forEach(element=>{if(element[0]in metrics){if(metrics[element[0]]!==element[1]){Logger.warn(`Deephub description for ${element[0]} (${element[1]}) does not match metrics (${metrics[element[0]]})`)}}else{metrics[element[0]]=element[1]}});return metrics}()},sort:{lowerBetter:["MAE","MSE","RMSE","RMSLE","LOG_LOSS","HAMMINGLOSS","MAPE","MASE","SMAPE","MEAN_ABSOLUTE_QUANTILE_LOSS","MEAN_WEIGHTED_QUANTILE_LOSS","MSIS","ND","CALIBRATION_LOSS"]},normalizedMetrics:["ROC_AUC","AVERAGE_PRECISION","PRECISION","RECALL","F1","ACCURACY","EVS","R2","CALIBRATION_LOSS"],algorithmCategories:function(predictionType){if(["BINARY_CLASSIFICATION","MULTICLASS","REGRESSION","CAUSAL_BINARY_CLASSIFICATION","CAUSAL_REGRESSION"].includes(predictionType)){return{"Linear Models":["RIDGE_REGRESSION","LASSO_REGRESSION","LEASTSQUARE_REGRESSION","LOGISTIC_REGRESSION","GLM_H2O","MLLIB_LOGISTIC_REGRESSION","MLLIB_LINEAR_REGRESSION","SPARKLING_GLM"],"Random Forests":["RANDOM_FOREST_REGRESSION","RANDOM_FOREST_CLASSIFICATION","DISTRIBUTED_RF_H2O","MLLIB_RANDOM_FOREST","SPARKLING_RF"],"Support Vector Machines":["SVC_CLASSIFICATION","SVM_REGRESSION"],"Stochastic Gradient Descent":["SGD_CLASSIFICATION","SGD_REGRESSION"],"Gradient Boosting":["GBM_H2O","GBT_CLASSIFICATION","GBT_REGRESSION","LIGHTGBM_CLASSIFICATION","LIGHTGBM_REGRESSION","XGBOOST_CLASSIFICATION","XGBOOST_REGRESSION","SPARKLING_GBM","MLLIB_GBT"],"Decision Tree":["DECISION_TREE_CLASSIFICATION","DECISION_TREE_REGRESSION","MLLIB_DECISION_TREE"],Others:true}}if(predictionType==="TIMESERIES_FORECAST"){return{"Baseline Models":["TRIVIAL_IDENTITY_TIMESERIES","SEASONAL_NAIVE"],"Statistical Models":["AUTO_ARIMA","CROSTON","SEASONAL_LOESS","PROPHET","GLUONTS_NPTS_FORECASTER"],"Deep Learning Models":["GLUONTS_SIMPLE_FEEDFORWARD","GLUONTS_DEEPAR","GLUONTS_TRANSFORMER","GLUONTS_MQCNN"]}}},noDollarKey:function(k){return!k.startsWith("$")&&k!="_name"&&k!="datasetColumnId"&&k!="userModified"},defaultCustomCode:function(backendType,isRegression,targetVariable){let code;if(backendType==="PY_MEMORY"){if(isRegression){code="# This sample code uses a standard scikit-learn algorithm, the Adaboost regressor.\n\n"+"# Your code must create a 'clf' variable. This clf must be a scikit-learn compatible\n"+"# model, ie, it should:\n"+"#  1. have at least fit(X,y) and predict(X) methods\n"+"#  2. inherit sklearn.base.BaseEstimator\n"+"#  3. handle the attributes in the __init__ function\n"+"#     See: https://doc.dataiku.com/dss/latest/machine-learning/custom-models.html\n\n"+"from sklearn.ensemble import AdaBoostRegressor\n\n"+"clf = AdaBoostRegressor(n_estimators=20)\n"}else{code="# This sample code uses a standard scikit-learn algorithm, the Adaboost classifier.\n\n"+"# Your code must create a 'clf' variable. This clf must be a scikit-learn compatible\n"+"# classifier, ie, it should:\n"+"#  1. have at least fit(X,y) and predict(X) methods\n"+"#  2. inherit sklearn.base.BaseEstimator\n"+"#  3. handle the attributes in the __init__ function\n"+"#  4. have a classes_ attribute\n"+"#  5. have a predict_proba method (optional)\n"+"#     See: https://doc.dataiku.com/dss/latest/machine-learning/custom-models.html\n\n"+"from sklearn.ensemble import AdaBoostClassifier\n\n"+"clf = AdaBoostClassifier(n_estimators=20)\n"}}else if(backendType==="MLLIB"){if(isRegression){code="// This sample code uses a standard MLlib algorithm, the RandomForestRegressor.\n\n"+"// import the Estimator from spark.ml\n"+"import org.apache.spark.ml.regression.RandomForestRegressor\n\n"+"// instantiate the Estimator\n"+"new RandomForestRegressor()\n"+'   .setLabelCol("'+targetVariable+'")  // Must be the target column\n'+'   .setFeaturesCol("__dku_features")  // Must always be __dku_features\n'+'   .setPredictionCol("prediction")  // Must always be prediction\n'+"   .setNumTrees(50)\n"+"   .setMaxDepth(8)"}else{code="// This sample code uses a standard MLlib algorithm, the RandomForestClassifier.\n\n"+"// import the Estimator from spark.ml\n"+"import org.apache.spark.ml.classification.RandomForestClassifier\n\n"+"// instantiate the Estimator\n"+"new RandomForestClassifier()\n"+'   .setLabelCol("'+targetVariable+'")  // Must be the target column\n'+'   .setFeaturesCol("__dku_features")  // Must always be __dku_features\n'+'   .setPredictionCol("prediction")    // Must always be prediction\n'+"   .setNumTrees(50)\n"+"   .setMaxDepth(8)"}}return code},isSpecialFeature:function(featParams){if(!featParams||featParams.role==="REJECT"){return false}var featType=featParams.type;if(featType==="TEXT"){let handling=featParams.text_handling;if(handling==="CUSTOM"){return true}}if(featType==="IMAGE"){let handling=featParams.image_handling;if(handling==="CUSTOM"){return true}}return false},hpPrettyName:function(hpAlgorithm,hpName){const prettyNames={logit:{penalty:"Penalty",multi_class:"Multi class mode",C:"C"},rf:{estimators:"Number of trees",max_tree_depth:"Max trees depth",selection_mode:"Feature sampling strategy",min_samples_leaf:"Min samples per leaf",max_features:"Used features",max_feature_prop:"Used features",allow_sparse_matrices:"Sparse matrices allowed"},extra_trees:{estimators:"Number of trees",max_tree_depth:"Max trees depth",selection_mode:"Feature sampling strategy",min_samples_leaf:"Min samples per leaf",max_features:"Used features",max_feature_prop:"Used features"},xgboost:{missing:"Value treated as missing",booster:"Booster",silent:"Silent",objective:"Objective function",nthread:"Number of threads",seed:"Seed",impute_missing:"Custom missing value",n_estimators:"Actual number of trees",max_depth:"Max trees depth",learning_rate:"Eta (learning rate)",alpha:"Alpha (L1 regularization)",lambda:"Lambda (L2 regularization)",gamma:"Gamma (Min loss reduction to split a leaf)",min_child_weight:"Min sum of instance weight in a child",max_delta_step:"Max delta step",subsample:"Subsample ratio of the training instance",colsample_bytree:"Columns subsample ratio for trees",colsample_bylevel:"Columns subsample ratio for splits / levels",scale_pos_weight:"Balancing of positive and negative weights",base_score:"Global bias (initial prediction score)",enable_early_stopping:"Early stopping",early_stopping_rounds:"Early stopping: max rounds before early stop",allow_sparse_matrices:"Sparse matrices allowed",tweedie_variance_power:"Tweedie variance power"},svm:{kernel:"Kernel",C:"C",coef0:"Independent kernel term",tol:"Stopping tolerance",max_iter:"Max iterations",custom_gamma:"Kernel coef (gamma)",gamma:"Kernel coef (gamma)"},dt:{max_depth:"Maximum depth",criterion:"Split criterion",min_samples_leaf:"Min. samples per leaf",splitter:"Split strategy"},ridge:{alpha:"Alpha"},lasso:{alpha:"Alpha"},mllib_logit:{reg_param:"Lambda (regularization param)",enet_param:"Alpha (Elastic net param)"},mllib_linreg:{reg_param:"Lambda (regularization param)",enet_param:"Alpha (Elastic net param)"},mllib_rf:{num_trees:"Number of trees",impurity:"Impurity function",max_bins:"Max. bin used",min_info_gain:"Min. information increment",max_depth:"Maximum depth of tree",step_size:"Step size",subsample_rate:"Ratio data used",subset_strategy:"Subset strategy",min_instance_per_node:"Min. instance per node"},mllib_gbt:{num_trees:"Number of trees",impurity:"Impurity function",max_bins:"Max. bin used",min_info_gain:"Min. information increment",max_depth:"Maximum depth of tree",step_size:"Step size",subsample_rate:"Ratio data used",min_instance_per_node:"Min. instance per node"},mllib_dt:{max_depth:"Max. depth of tree",max_bins:"Max. bin used",min_info_gain:"Mim. information increment",min_instance_per_node:"Min. instance per node"},mllib_naive_bayes:{lambda:"Lambda"},gbt:{n_estimators:"Number of boosting stages",learning_rate:"Eta (learning rate)",max_depth:"Max trees depth",max_features:"Number of features",max_features_prop:"Number of features",min_samples_leaf:"Minimum samples per leaf",loss:"Loss",selection_mode:"Feature sampling strategy",allow_sparse_matrices:"Sparse matrices allowed"},knn:{k:"K",leaf_size:"Leaf size",p:"p",distance_weighting:"Distance weighting",algorithm:"Algorithm"},sgd_grid:{tol:"Stopping tolerance",max_iter:"Max iterations",alpha:"Alpha",l1_ratio:"L1 mixim parameter",loss:"Loss",penalty:"Regularization",n_iter:"Number of iterations",epsilon:"Epsilon"},sgd:{alpha:"Alpha",l1_ratio:"L1 mixim parameter",loss:"Loss",penalty:"Regularization",n_iter:"Number of iterations",epsilon:"Epsilon"},mllib_logit_grid:{max_iter:"Max iterations"},mllib_linreg_grid:{max_iter:"Max iterations"},mllib_rf_grid:{subset_strategy:"Feature subset strategy",impurity:"Impurity",max_bins:"Maximum number of bins",max_memory_mb:"Maximum memory",checkpoint_interval:"Check point interval",cache_node_ids:"Cache node IDs",min_info_gain:"Minimum information gain",min_instance_per_node:"Minimum instance per node",subsampling_rate:"Subsampling rate",seed:"Subsampling seed"},keras:{epochs:"Number of epochs",oneDimensionalOutput:"1-D output"},mllib_gbt_grid:{impurity:"Impurity",max_bins:"Maximum number of bins",max_memory_mb:"Maximum memory",checkpoint_interval:"Check point interval",cache_node_ids:"Cache node IDs",min_info_gain:"Minimum information gain",min_instance_per_node:"Minimum instance per node",subsampling_rate:"Subsampling rate",step_size:"Step size",seed:"Subsampling seed"},mllib_dt_grid:{cache_node_ids:"Ids of cache nodes",checkpoint_interval:"Checkpoint interval",max_bins:"Maximum number of bins",max_memory_mb:"Maximum memory",min_info_gain:"Minimum information gain",min_instance_per_node:"Minimum instance per node"},neural_network_grid:{alpha:"Alpha",max_iter:"Max iterations",tol:"Convergence tolerance",validation_fraction:"Validation fraction",learning_rate_init:"Intial Learning Rate",batch_size:"Batch size",beta_1:"beta_1",beta_2:"beta_2",epsilon:"epsilon",power_t:"power_t",momentum:"Momentum",activation:"Activation",early_stopping:"Early stopping",solver:"Solver",shuffle:"Shuffle data",auto_batch:"Automatic batching",learning_rate:"Learning rate annealing",nesterovs_momentum:"Use Nesterov momentum"},lars_grid:{max_features:"Max number of features"},lars:{max_features:"Max number of features",K:"K"},vertica_linreg_grid:{maxIterations:"Max number of iterations"},lightgbm:{boosting_type:"Booster",n_estimators:"Actual number of trees",max_depth:"Maximum Tree Depth",num_leaves:"Maximum number of leaves",learning_rate:"Learning rate",reg_alpha:"Alpha (L1 regularization)",reg_lambda:"Lambda (L2 regularization)",min_split_gain:"Minimal gain to perform a split",min_child_weight:"Min sum of instance child weight",subsample:"Ratio of the training instance",objective:"Objective function",subsample_freq:"Frequency for bagging",subsample_for_bin:"Ratio for each discrete feature bin",colsample_bytree:"Columns subsample ratio for trees",random_state:"Random State",n_jobs:"Number of jobs",importance_type:"Feature importance type",early_stopping:"Early stopping",early_stopping_rounds:"Early stopping: max rounds before early stop",allow_sparse_matrices:"Sparse matrices allowed"},auto_arima_timeseries_params:{m:"Season length"},seasonal_loess_timeseries_params:{period:"Season length"},deep_neural_network:{batch_size:"Batch size",device:"Device",epochs:"Number of epochs",hidden_layers:"Hidden layers",learning_rate:"Learning rate",max_epochs:"Max number of epochs",units:"Units per layer",reg_l2:"Lambda (L2 regularization)",reg_l1:"Alpha (L1 regularization)",early_stopping_enabled:"Early stopping",early_stopping_patience:"Early stopping: max rounds before early stop",early_stopping_threshold:"Early stopping: threshold"},tabicl:{norm_methods:"Normalization methods",n_jobs:"Parallelism",n_estimators:"Number of estimators"}};return(prettyNames[hpAlgorithm]||{})[hpName]||$filter("niceConst")(hpName)}};cst.sort.lowerIsBetter=function(metricId,customMetrics,customEvaluationMetricName=""){if("CUSTOM"===metricId){metricId=CustomMetricIDService.getCustomMetricId(customEvaluationMetricName)}const isCustomMetric=CustomMetricIDService.checkMetricIsCustom(metricId);if(isCustomMetric){const metric=customMetrics.find(customMetric=>customMetric.name===CustomMetricIDService.getCustomMetricName(metricId));return metric?!metric.greaterIsBetter:false}return cst.sort.lowerBetter.indexOf(metricId)!==-1};cst.isSpecialInput=function(inputName,perFeature){if(!inputName||!perFeature){return false}return Object.values(perFeature).some(f=>f.sendToInput==inputName&&cst.isSpecialFeature(f))};return cst});app.service("PartitionedModelsService",function(PMLSettings,Logger){let cst={getPartitionsSnippetStateSize:(snippetData,...states)=>{if(!snippetData||!snippetData.partitions||!snippetData.partitions.states){return 0}return Object.entries(snippetData.partitions.states).reduce((total,pair)=>{const[state,amount]=pair;if(states.includes(state)){return total+amount}return total},0)},getTotalAmountOfPartitions:snippetData=>{if(!snippetData||!snippetData.partitions||!snippetData.partitions.states){return 0}return Object.values(snippetData.partitions.states).reduce((total,amount)=>total+amount,0)},getCurrentStep:snippetData=>{if(!snippetData||!snippetData.trainInfo||!snippetData.trainInfo.progress){return 0}return(snippetData.trainInfo.progress.top_level_done||[]).length+((snippetData.trainInfo.progress.stack||[]).length?1:0)},getStepCount:snippetData=>{if(!snippetData||!snippetData.trainInfo||!snippetData.trainInfo.progress){return 0}return cst.getCurrentStep(snippetData)+(snippetData.trainInfo.progress.top_level_todo||[]).length},getPartitionResultMetricGradient:(snippetData,sortMainMetric,currentMetric)=>{if(sortMainMetric===undefined||Math.abs(sortMainMetric)===Number.MAX_VALUE){return"none"}let ratio;if(PMLSettings.normalizedMetrics.includes(currentMetric)&&!PMLSettings.sort.lowerBetter.includes(currentMetric)){ratio=sortMainMetric}else{const existingMetricsList=Object.values(snippetData.partitions.summaries).map(summary=>summary.snippet.sortMainMetric).filter(m=>Math.abs(m)<Number.MAX_VALUE);const metricsMax=Math.max(...existingMetricsList);const metricsMin=Math.min(...existingMetricsList);const minRatio=.05;const maxRatio=1;if(metricsMax===metricsMin){ratio=maxRatio}else{ratio=minRatio+maxRatio*(sortMainMetric-metricsMin)/(metricsMax-metricsMin)}}const greenBaseColor="#29AF5D";return"linear-gradient(to right, "+greenBaseColor+" 0%, "+greenBaseColor+" "+ratio*100+"%,rgba(0, 0, 0, 0) "+ratio*100+"%, rgba(0, 0, 0, 0) 100%)"},getAggregationExplanation:(metricId,displayName,isCustom=false,hideTestWeightMention)=>{switch(isCustom?"CUSTOM":metricId){case"ACCURACY":case"PRECISION":case"RECALL":case"F1":case"COST_MATRIX":case"MCC":case"HAMMINGLOSS":return"{0} of the global model, using optimal threshold for each partition.".format(displayName);case"LOG_LOSS":return"Log loss of the global model (equal to the average log loss per partition, weighted by test weight).";case"ROC_AUC":return"Average ROC AUC per partition weighted by test weight as an approximation of the true ROC AUC.";case"AVERAGE_PRECISION":case"CUMULATIVE_LIFT":case"CALIBRATION_LOSS":{const displayNameLowerCase=displayName.toLowerCase();return"Average {0} per partition weighted by test weight as an approximation of the true {1}.".format(displayNameLowerCase,displayNameLowerCase)}case"CUSTOM":return"Average custom score per partition weighted by test weight.\n"+"It may be an approximation of the true custom score depending on the way it has been defined.";case"MSE":case"MAPE":case"MAE":if(!hideTestWeightMention){return"{0} of the global model (equal to the average {1} per partition, weighted by test weight).".format(displayName,displayName)}case"RMSE":case"RMSLE":case"R2":case"EVS":case"PEARSON":case"MASE":case"SMAPE":case"MEAN_ABSOLUTE_QUANTILE_LOSS":case"MEAN_WEIGHTED_QUANTILE_LOSS":case"MSIS":case"ND":return"{0} of the global model.".format(displayName);default:Logger.error("Metric name is not valid")}},isPartitionedModel:modelData=>{return modelData&&modelData.coreParams&&modelData.coreParams.partitionedModel&&modelData.coreParams.partitionedModel.enabled}};return cst});app.service("BinaryClassificationModelsService",function(){function getPercentString(p){if(p<.01){return"< 1 %"}else if(p>1){return"100 %"}else{return Math.round(p*100)+" %"}}function roundCutValue(v){return Math.round(1e3*v)/1e3}function findCut(cuts,cutToFind){cutToFind=roundCutValue(cutToFind);let i=0;for(i=0;i<cuts.length-1;i++){if(roundCutValue(cuts[i])>=cutToFind){break}}return i}return{findCut:findCut,findCutData:(modelDataPerf,cutToFind)=>{let pcd=modelDataPerf&&modelDataPerf.perCutData;if(!pcd){return}let i=findCut(pcd.cut,cutToFind);var tp=pcd.tp[i],tn=pcd.tn[i],fp=pcd.fp[i],fn=pcd.fn[i];var actPos=tp+fn;var actNeg=tn+fp;var predPos=tp+fp;var predNeg=tn+fn;var eps=.01;let ret={index:i,cut:roundCutValue(pcd.cut[i]),tp:{records:tp,actual:getPercentString(tp/(actPos+eps)),predicted:getPercentString(tp/(predPos+eps))},tn:{records:tn,actual:getPercentString(tn/(actNeg+eps)),predicted:getPercentString(tn/(predNeg+eps))},fp:{records:fp,actual:getPercentString(fp/(actNeg+eps)),predicted:getPercentString(fp/(predPos+eps))},fn:{records:fn,actual:getPercentString(fn/(actPos+eps)),predicted:getPercentString(fn/(predNeg+eps))},actPos:{records:tp+fn,actual:"100 %",ratio:actPos/(actPos+actNeg)},actNeg:{records:tn+fp,actual:"100 %",ratio:actNeg/(actPos+actNeg)},predPos:{records:tp+fp,predicted:"100 %",ratio:predPos/(predPos+predNeg)},predNeg:{records:tn+fn,predicted:"100 %",ratio:predNeg/(predPos+predNeg)},Accuracy:pcd.accuracy[i],mcc:pcd.mcc[i],hammingLoss:pcd.hammingLoss[i],Precision:pcd.precision[i],Recall:pcd.recall[i],"F1-Score":pcd.f1[i],customMetricsResults:pcd.customMetricsResults?pcd.customMetricsResults.map(item=>{return{metric:item.metric,didSucceed:item.didSucceed,error:item.error,value:item.didSucceed?item.values[i]:null,valuestd:item.valuesstd&&item.valuesstd[i]?item.valuesstd[i]:null}}):null};const additionalFields=["cmg","accuracystd","mccstd","hammingLossstd","precisionstd","recallstd","f1std"];additionalFields.forEach(key=>{if(pcd[key]){ret[key]=pcd[key][i]}});return ret}}});app.controller("DeepLearningPMLController",function($scope,$timeout,$interval,$controller,DataikuAPI,PMLSettings,PMLFilteringService,VisualMlCodeEnvCompatibility,$state,$stateParams,TopNav,Dialogs,CreateModalFromTemplate,Fn,Logger,$q,CodeBasedEditorUtils){const inputsShown={};$controller("_MLTaskDesignController",{$scope:$scope});$scope.deferredAfterInitMlTaskDesign.then(()=>$scope.retrieveCodeEnvsInfo());function insertCode(codeToInsert){$timeout(function(){$scope.cm.replaceSelection(`${codeToInsert}\n`,"around")});$scope.cm.focus()}function fillFitCodeKeras(){if($scope.mlTaskDesign.modeling.keras.fitCode===undefined){const stepsPerEpochCode=$scope.mlTaskDesign.modeling.keras.trainOnAllData?"":"                        steps_per_epoch="+$scope.mlTaskDesign.modeling.keras.stepsPerEpoch+",\n";const fitCode="# A function that builds train and validation sequences.\n"+"# You can define your custom data augmentation based on the original train and validation sequences\n\n"+"#   build_train_sequence_with_batch_size        - function that returns train data sequence depending on\n"+"#                                                 batch size\n"+"#   build_validation_sequence_with_batch_size   - function that returns validation data sequence depending on\n"+"#                                                 batch size\n"+"def build_sequences(build_train_sequence_with_batch_size, build_validation_sequence_with_batch_size):\n"+"    \n"+"    batch_size = "+$scope.mlTaskDesign.modeling.keras.batchSize+"\n"+"    \n"+"    train_sequence = build_train_sequence_with_batch_size(batch_size)\n"+"    validation_sequence = build_validation_sequence_with_batch_size(batch_size)\n"+"    \n"+"    return train_sequence, validation_sequence\n\n\n"+"# A function that contains a call to fit a model.\n\n"+"#   model                 - compiled model\n"+"#   train_sequence        - train data sequence, returned in build_sequence\n"+"#   validation_sequence   - validation data sequence, returned in build_sequence\n"+"#   base_callbacks        - a list of Dataiku callbacks, that are not to be removed. User callbacks can be added to this list\n"+"def fit_model(model, train_sequence, validation_sequence, base_callbacks):\n"+"    epochs = "+$scope.mlTaskDesign.modeling.keras.epochs+"\n"+"    fitfunc = getattr(model, 'fit_generator', model.fit) \n"+"    fitfunc(train_sequence,\n"+"            epochs=epochs,\n"+stepsPerEpochCode+"            callbacks=base_callbacks,\n"+"            shuffle="+($scope.mlTaskDesign.modeling.keras.shuffleData?"True":"False")+")\n";$scope.mlTaskDesign.modeling.keras.fitCode=fitCode}}$scope.addEventOnTransition=function(){$(".keras-inputs__wrapper").on("transitionend",function(){$scope.uiState.canTransition=false})};$scope.showHideInputs=function(){$scope.uiState.canTransition=true;$scope.uiState.displayInput=!$scope.uiState.displayInput};$scope.startEditInput=function(input){$scope.uiState.currentlyEditing=input;$scope.uiState.newEditInputName=input};$scope.isBeingEdited=function(input){return $scope.uiState.currentlyEditing===input};$scope.editInputIfValid=function(){if(!$scope.isValidEditInput()){return}var inputIndex=$scope.mlTaskDesign.modeling.keras.kerasInputs.indexOf($scope.uiState.currentlyEditing);$scope.mlTaskDesign.modeling.keras.kerasInputs[inputIndex]=$scope.uiState.newEditInputName;Object.values($scope.mlTaskDesign.preprocessing.per_feature).forEach(function(featParams){if(featParams["sendToInput"]===$scope.uiState.currentlyEditing){featParams["sendToInput"]=$scope.uiState.newEditInputName}});$scope.uiState.currentlyEditing=null;$scope.uiState.newEditInputName=""};$scope.isValidEditInput=function(){if($scope.uiState.newEditInputName===$scope.uiState.currentlyEditing){return true}if($scope.uiState.newEditInputName===""){return false}if($scope.mlTaskDesign.modeling.keras.kerasInputs.indexOf($scope.uiState.newEditInputName)>-1){return false}return true};$scope.cancelEditInput=function(){$scope.uiState.currentlyEditing=null;$scope.uiState.newEditInputName=""};$scope.deleteInput=function(input){Dialogs.confirm($scope,"Delete Deep Learning Input","Do you want to delete this input ? All its features will be sent to the 'main' input").then(function(data){const inputIndex=$scope.mlTaskDesign.modeling.keras.kerasInputs.indexOf(input);$scope.mlTaskDesign.modeling.keras.kerasInputs.splice(inputIndex,1);Object.values($scope.mlTaskDesign.preprocessing.per_feature).forEach(function(featParams){if(featParams["sendToInput"]===input){featParams["sendToInput"]="main"}})})};$scope.createInputIfValid=function(){if(!$scope.isValidNewInput()){return}$scope.mlTaskDesign.modeling.keras.kerasInputs.push($scope.uiState.newInputName);$scope.uiState.creatingNewInput=false;$scope.uiState.newInputName=""};$scope.isValidNewInput=function(){if(!$scope.uiState.newInputName){return false}return $scope.mlTaskDesign.modeling.keras.kerasInputs.indexOf($scope.uiState.newInputName)<=-1};$scope.isCreatingInput=function(){return $scope.uiState.creatingNewInput};$scope.startCreatingInput=function(){$scope.uiState.creatingNewInput=true};$scope.cancelCreateInput=function(){$scope.uiState.creatingNewInput=false;$scope.uiState.newInputName=""};$scope.insertInput=function(input){if(!$scope.isSpecialInput(input)){var code="input_"+input+' = Input(shape=input_shapes["'+input+'"], name="'+input+'")';insertCode(code)}else{let deferred=$q.defer();let newScope=$scope.$new();newScope.input=input;newScope.uiState={processorCodeShown:true};newScope.perFeature=$scope.mlTaskDesign.preprocessing.per_feature;newScope.insertReadOnlyOptions=$scope.codeMirrorSettingService.get("text/x-python");newScope.insertReadOnlyOptions["readOnly"]="nocursor";newScope.insertReadOnlyOptions["lineNumbers"]=false;newScope.insertReadOnlyOptions["foldGutter"]=false;CreateModalFromTemplate("templates/analysis/prediction/insert-special-input-modal.html",newScope,null,function(scope){scope.acceptDeferred=deferred;scope.uiState.insertInput=input;scope.uiState.insertFeature=Object.keys(scope.perFeature).find(featName=>scope.perFeature[featName]["sendToInput"]===input);scope.uiState.insertFeatParams=scope.perFeature[scope.uiState.insertFeature];scope.uiState.insertStartInputCode="input_"+input+" = Input(shape=";scope.uiState.insertEndInputCode=', name="'+input+'")';scope.insertSpecialInput=function(){const inputCode=scope.uiState.insertStartInputCode+scope.uiState.insertInputShape+scope.uiState.insertEndInputCode;scope.acceptDeferred.resolve(inputCode);scope.dismiss()};scope.showHideProcessorCode=function(){scope.uiState.processorCodeShown=!scope.uiState.processorCodeShown}});deferred.promise.then(function(inputCode){insertCode(inputCode)})}};$scope.showHideInput=function(input){inputsShown[input]=!inputsShown[input]};$scope.isShown=function(input){return inputsShown[input]};$scope.getNumFeatures=function(input){return Object.values($scope.mlTaskDesign.preprocessing.per_feature).filter(function(p){return p["sendToInput"]===input&&p["role"]==="INPUT"}).length};$scope.filterFeatures=function(input){return function(feat){return feat.sendToInput===input&&feat.role==="INPUT"}};$scope.isSpecialInput=function(input){return $scope.SettingsService.isSpecialInput(input,$scope.mlTaskDesign.preprocessing.per_feature)};function getSpecialInputType(input){const specialFeature=Object.values($scope.mlTaskDesign.preprocessing.per_feature).find(function(p){return p["sendToInput"]===input&&p["role"]==="INPUT"});return specialFeature.type}$scope.getSpecialInputIcon=function(input){const specialInputType=getSpecialInputType(input);let iconClass;if(specialInputType==="TEXT"){iconClass="icon-italic"}else if(specialInputType==="IMAGE"){iconClass="icon-picture"}else{iconClass=""}return iconClass};$scope.isMainInput=function(input){return input==="main"};$scope.isEditable=function(input){return!$scope.isSpecialInput(input)&&!$scope.isMainInput(input)};$scope.getEditTitle=function(input){if($scope.isMainInput(input)){return"Main input cannot be edited"}else if($scope.isSpecialInput(input)){return"Special input cannot be edited"}else{return"Edit input"}};$scope.getInsertTitle=function(input){if($scope.getNumFeatures(input)===0){return"Empty Input cannot be inserted"}else{return"Insert"}};$scope.isInsertable=function(input){return $scope.getNumFeatures(input)>0};function getTextNetworkAndAddInput(input,inputInNetworks){let inputVarName="input_"+input;const feature=Object.keys($scope.mlTaskDesign.preprocessing.per_feature).find(featName=>$scope.mlTaskDesign.preprocessing.per_feature[featName]["sendToInput"]===input);inputInNetworks.push(inputVarName);return"    # This input will receive preprocessed text from '"+feature+"' column\n"+"    "+inputVarName+' = Input(shape=(32,), name="'+input+'")\n'+"    x_"+input+" = Embedding(output_dim=512, input_dim=10000, input_length=32)(input_"+input+")\n"+"    x_"+input+" = Reshape((32 * 512,))(x_"+input+")\n\n"}$scope.fillBuildCodeKeras=function(keepAndCommentPrevious){if(keepAndCommentPrevious||$scope.mlTaskDesign.modeling.keras.buildCode===undefined){let predictionLine;let lossFunction;let problemType;if($scope.mlTaskDesign.predictionType==="REGRESSION"){predictionLine="    predictions = Dense(1)(x)";lossFunction="mse";problemType="regression"}else{predictionLine="    predictions = Dense(n_classes, activation='softmax')(x)";if($scope.mlTaskDesign.predictionType==="BINARY_CLASSIFICATION"){lossFunction="binary_crossentropy";problemType="binary classification"}else{lossFunction="categorical_crossentropy";problemType="multiclass classification"}}const specialTextInputNames=$scope.mlTaskDesign.modeling.keras.kerasInputs.filter(x=>$scope.isSpecialInput(x)&&getSpecialInputType(x)==="TEXT");const hasSpecialTextInputs=specialTextInputNames.length>=1;const hasMain=$scope.getNumFeatures("main")>=1;const numRealInputs=$scope.mlTaskDesign.modeling.keras.kerasInputs.length-(hasMain?0:1);let actualInputsInNetwork=[];let startNetwork="";let lastLayerSoFar;if(hasMain||numRealInputs===0){const mainInputVarName="input_main";startNetwork+="    # This input will receive all the preprocessed features\n"+"    # sent to 'main'\n"+"    "+mainInputVarName+' = Input(shape=input_shapes["main"], name="main")\n\n';lastLayerSoFar=mainInputVarName;actualInputsInNetwork.push(mainInputVarName)}if(hasSpecialTextInputs){specialTextInputNames.forEach(input=>{startNetwork+=getTextNetworkAndAddInput(input,actualInputsInNetwork);lastLayerSoFar="x_"+input})}if(numRealInputs>1){const concatLayers=[];if(hasMain){concatLayers.push("input_main")}specialTextInputNames.forEach(input=>{concatLayers.push("x_"+input)});startNetwork+="    x = concatenate(["+concatLayers.join(", ")+"])\n\n";lastLayerSoFar="x"}const importPrefix=VisualMlCodeEnvCompatibility.isEnvAtLeastTensorflow2_2($scope.mlTaskDesign,$scope.codeEnvsCompat)?"from tensorflow.keras.":"from keras.";let layerImportLine=importPrefix+"layers import Input, Dense";if(hasSpecialTextInputs){layerImportLine+=", Embedding, Reshape"}if(numRealInputs>1){layerImportLine+=", concatenate"}let buildCode=layerImportLine+"\n"+importPrefix+"models import Model\n\n"+"# Define the keras architecture of your model in 'build_model' and return it. Compilation must be done in 'compile_model'.\n"+"#   input_shapes  - dictionary of shapes per input as defined in features handling\n"+"#   n_classes - For classification, number of target classes\n"+"def build_model(input_shapes, n_classes=None):\n\n"+startNetwork+"    x = Dense(64, activation='relu')("+lastLayerSoFar+")\n"+"    x = Dense(64, activation='relu')(x)\n"+"\n"+predictionLine+"\n"+"\n"+"    # The 'inputs' parameter of your model must contain the\n"+"    # full list of inputs used in the architecture\n"+"    model = Model(inputs=["+actualInputsInNetwork.join(", ")+"], outputs=predictions)\n"+"\n"+"    return model\n"+"\n"+"# Compile your model and return it\n"+"#   model   - model defined in 'build_model'\n"+"def compile_model(model):\n"+"    \n"+"    # The loss function depends on the type of problem you solve.\n"+"    # '"+lossFunction+"' is appropriate for a "+problemType+".\n"+"    model.compile(optimizer='rmsprop',\n"+"                  loss='"+lossFunction+"')\n"+"\n"+"    return model";if(keepAndCommentPrevious&&$scope.mlTaskDesign.modeling.keras.buildCode){buildCode=buildCode+"\n\n### PREVIOUS CODE\n"+$scope.mlTaskDesign.modeling.keras.buildCode.replace(/^/gm,"# ")}$scope.mlTaskDesign.modeling.keras.buildCode=buildCode;$scope.saveSettings()}};$scope.switchFitMode=function(){if(!$scope.mlTaskDesign.modeling.keras.advancedFitMode){fillFitCodeKeras()}$scope.mlTaskDesign.modeling.keras.advancedFitMode=!$scope.mlTaskDesign.modeling.keras.advancedFitMode};$scope.editorOptions=CodeBasedEditorUtils.editorOptions("text/x-python",$scope,true);$scope.validateRecipe=function(){const deferred=$q.defer();try{$scope.runningValidation=true;DataikuAPI.analysis.pml.validateArchitecture($scope.mlTaskDesign.modeling.keras.buildCode,$scope.mlTaskDesign.envSelection,$stateParams.projectKey).success(data=>{$scope.valCtx.showPreRunValidationError=false;$scope.valCtx.validationResult=data;deferred.resolve(data)}).error(setErrorInScope.bind($scope))}finally{$scope.runningValidation=false}return deferred.promise};$scope.gotoLine=function(cm,line){if(cm&&line>0){var pos={ch:0,line:line-1};cm.scrollIntoView(pos);cm.setCursor(pos);cm.focus()}};$scope.$watch("mlTaskDesign",nv=>{if(nv){$scope.fillBuildCodeKeras();if($scope.mlTaskDesign&&$scope.mlTaskDesign.modeling.keras&&$scope.mlTaskDesign.modeling.keras.kerasInputs.length>1){$scope.uiState.displayInput=true}}});$scope.valCtx={};$scope.recipe={type:"python",params:{}}});app.controller("PMLTaskBaseController",function($scope,$controller,DataikuAPI,PMLSettings,PMLFilteringService,CustomMetricIDService,$stateParams,Dialogs,Fn,Logger,WT1,CodeMirrorSettingService,Assert,FeatureFlagsService,MLModelsUIRouterStates,GPU_SUPPORTING_CAPABILITY,GpuUsageService,MLContainerInfoService,MLTaskInformationService,TimeseriesFeatureGenerationService){$scope.MLAPI=DataikuAPI.analysis.pml;$scope.FilteringService=PMLFilteringService;$scope.SettingsService=PMLSettings;$scope.codeMirrorSettingService=CodeMirrorSettingService;$scope.CustomMetricIDService=CustomMetricIDService;$scope.sRefPrefix="projects.project.analyses.analysis.ml.predmltask";$scope.uiSplitParams={};$scope.getPredictionDesignTabPrefix=()=>MLModelsUIRouterStates.getPredictionDesignTabPrefix($scope);$scope.initMlTaskDesign=function(){return DataikuAPI.analysis.pml.getUpdatedSettings($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId).then(({data})=>{$scope.setMlTaskDesign(data);$scope.fillUISplitParams($scope.mlTaskDesign.splitParams);$scope.savedSettings=dkuDeepCopy($scope.mlTaskDesign,PMLSettings.noDollarKey)}).then($scope.refreshStatus).catch(setErrorInScope.bind($scope))};$scope.fillUISplitParams=function(splitParams){if(!splitParams){throw new Error("No split params")}if(splitParams.ttPolicy=="SPLIT_SINGLE_DATASET"){if(splitParams.ssdDatasetSmartName==null){$scope.uiSplitParams.policy="SPLIT_MAIN_DATASET"}else{$scope.uiSplitParams.policy="SPLIT_OTHER_DATASET"}}else if(splitParams.ttPolicy=="EXPLICIT_FILTERING_SINGLE_DATASET"){if(splitParams.efsdDatasetSmartName==null){$scope.uiSplitParams.policy="EXPLICIT_FILTERING_SINGLE_DATASET_MAIN"}else{$scope.uiSplitParams.policy="EXPLICIT_FILTERING_SINGLE_DATASET_OTHER"}}else{$scope.uiSplitParams.policy=splitParams.ttPolicy}};$scope.isClassification=function(){if(!$scope.mlTaskDesign)return false;return PMLSettings.task.isClassification($scope.mlTaskDesign.predictionType)};$scope.h2oEnabled=function(){if(!$scope.appConfig)return false;return $scope.appConfig.h2oEnabled};$scope.isRegression=function(){if(!$scope.mlTaskDesign)return false;return["REGRESSION","CAUSAL_REGRESSION"].includes($scope.mlTaskDesign.predictionType)};$scope.isBinaryClassification=function(){if(!$scope.mlTaskDesign)return false;return["BINARY_CLASSIFICATION","CAUSAL_BINARY_CLASSIFICATION"].includes($scope.mlTaskDesign.predictionType)};$scope.isMulticlass=function(){if(!$scope.mlTaskDesign)return false;return $scope.mlTaskDesign.predictionType=="MULTICLASS"};$scope.isClassicalPrediction=function(){return $scope.mlTaskDesign&&["REGRESSION","BINARY_CLASSIFICATION","MULTICLASS"].includes($scope.mlTaskDesign.predictionType)};$scope.isTimeseriesPrediction=function(){if(!$scope.mlTaskDesign)return false;return $scope.mlTaskDesign.predictionType==="TIMESERIES_FORECAST"};$scope.isGpuCompatibleTimeseriesPrediction=function(){if(!$scope.mlTaskDesign||!$scope.mlTaskDesign.modeling)return false;return $scope.isTimeseriesPrediction()&&($scope.mlTaskDesign.modeling.gluonts_deepar_timeseries.enabled||$scope.mlTaskDesign.modeling.gluonts_mqcnn_timeseries.enabled||$scope.mlTaskDesign.modeling.gluonts_simple_feed_forward_timeseries.enabled||$scope.mlTaskDesign.modeling.gluonts_transformer_timeseries.enabled||$scope.mlTaskDesign.modeling.gluonts_torch_simple_feed_forward_timeseries&&$scope.mlTaskDesign.modeling.gluonts_torch_simple_feed_forward_timeseries.enabled||$scope.mlTaskDesign.modeling.gluonts_torch_deepar_timeseries&&$scope.mlTaskDesign.modeling.gluonts_torch_deepar_timeseries.enabled)};$scope.supportsCustomMetrics=function(){return $scope.backendIsPythonBased()};$scope.isPartitioned=function(){return $scope.mlTaskDesign.partitionedModel&&$scope.mlTaskDesign.partitionedModel.enabled};$scope.supportsUncertainty=function(){return $scope.isMLBackendType("PY_MEMORY")&&$scope.isRegression()&&!$scope.isPartitioned()};$scope.isCausalPrediction=function(){if(!$scope.mlTaskDesign)return false;return $scope.mlTaskDesign.predictionType==="CAUSAL_REGRESSION"||$scope.mlTaskDesign.predictionType==="CAUSAL_BINARY_CLASSIFICATION"};$scope.isDeepHubPrediction=function(){if(!$scope.mlTaskDesign)return false;return $scope.isMLBackendType("DEEP_HUB")};$scope.isPreprocessingUsed=function(checkHandlingFct){if(!$scope.mlTaskDesign||!$scope.mlTaskDesign.preprocessing||!$scope.mlTaskDesign.preprocessing.per_feature){return false}return Object.values($scope.mlTaskDesign.preprocessing.per_feature).some(featPreproc=>featPreproc.role==="INPUT"&&checkHandlingFct(featPreproc))};$scope.usesCodeEnvSentenceEmbedding=function(){return $scope.isPreprocessingUsed(featPreproc=>featPreproc.type=="TEXT"&&featPreproc.text_handling==="SENTENCE_EMBEDDING"&&featPreproc.sentenceEmbeddingModel!=null&&!featPreproc.isStructuredRef)};$scope.usesLLMmeshPreprocessing=function(){return $scope.isPreprocessingUsed(featPreproc=>featPreproc.type=="TEXT"&&featPreproc.text_handling==="SENTENCE_EMBEDDING"&&featPreproc.isStructuredRef||featPreproc.type=="IMAGE"&&featPreproc.image_handling==="EMBEDDING_EXTRACTION")};$scope.isDeepNeuralNetworkEnabled=function(){if(!$scope.mlTaskDesign||!$scope.mlTaskDesign.modeling){return false}return $scope.mlTaskDesign.modeling.deep_neural_network_regression&&$scope.mlTaskDesign.modeling.deep_neural_network_regression.enabled||$scope.mlTaskDesign.modeling.deep_neural_network_classification&&$scope.mlTaskDesign.modeling.deep_neural_network_classification.enabled};$scope.isTabICLEnabled=function(){if(!$scope.mlTaskDesign||!$scope.mlTaskDesign.modeling){return false}return $scope.mlTaskDesign.modeling.tabicl_classification&&$scope.mlTaskDesign.modeling.tabicl_classification.enabled};$scope.isXGBoostEnabled=function(){if(!$scope.mlTaskDesign||!$scope.mlTaskDesign.modeling){return false}return $scope.mlTaskDesign.modeling.xgboost&&$scope.mlTaskDesign.modeling.xgboost.enabled};$scope.isMetricSupportedByXGBoostForEarlyStopping=function(){return $scope.isXGBoostEnabled()&&(!$scope.mlTaskDesign.modeling.xgboost.enable_early_stopping||["RMSE","MAE"].includes($scope.mlTaskDesign.modeling.metrics.evaluationMetric))};$scope.canUseGpu=function(){return $scope.isMLBackendType("KERAS")||$scope.isMLBackendType("DEEP_HUB")||$scope.isMLBackendType("PY_MEMORY")};$scope.getTrainingGPUParams=function(){return $scope.sessionTask.gpuConfig.params};$scope.inContainer=MLContainerInfoService.inContainer($scope,$stateParams.projectKey);$scope.isCurrentSessionRunning=function(){const currentSessionId=($scope.selection&&$scope.selection.sessionModels&&$scope.selection.sessionModels[0]||{}).sessionId;if(!currentSessionId)return false;return MLTaskInformationService.isSessionRunning($scope,currentSessionId)};$scope.shouldShowGpuUsage=function(){if($scope.mlTaskStatus.training&&$scope.isCurrentSessionRunning()){return $scope.getTrainingGPUParams()&&$scope.getTrainingGPUParams().useGpu&&!$scope.inContainer($scope.sessionTask.containerSelection)}return false};$scope.isGridSearchStrategy=function(){if(!$scope.mlTaskDesign)return true;return $scope.mlTaskDesign.modeling.gridSearchParams.strategy==="GRID"};$scope.base_algorithms={PY_MEMORY:[{name:"Random Forest",algKey:"random_forest_classification",condition:$scope.isClassification,supportedCausalMethod:"META_LEARNER",type:"classicalML",displayGroups:["classicalML"]},{name:"Random Forest",algKey:"random_forest_regression",condition:function(){return $scope.isRegression()||$scope.isTimeseriesPrediction()},supportedCausalMethod:"META_LEARNER",type:"classicalML",displayGroups:["classicalML"]},{name:"Gradient tree boosting",algKey:"gbt_classification",condition:$scope.isClassification,supportedCausalMethod:"META_LEARNER",type:"classicalML",displayGroups:["classicalML"]},{name:"Gradient tree boosting",algKey:"gbt_regression",condition:$scope.isRegression,supportedCausalMethod:"META_LEARNER",type:"classicalML",displayGroups:["classicalML"]},{name:"Logistic Regression",algKey:"logistic_regression",condition:$scope.isClassification,supportedCausalMethod:"META_LEARNER",type:"classicalML",displayGroups:["classicalML"]},{name:"Ordinary Least Squares",algKey:"leastsquare_regression",condition:$scope.isRegression,supportedCausalMethod:"META_LEARNER",type:"classicalML",displayGroups:["classicalML"]},{name:"Ridge Regression",algKey:"ridge_regression",condition:function(){return $scope.isRegression()||$scope.isTimeseriesPrediction()},supportedCausalMethod:"META_LEARNER",type:"classicalML",displayGroups:["classicalML"]},{name:"Lasso Regression",algKey:"lasso_regression",condition:$scope.isRegression,supportedCausalMethod:"META_LEARNER",type:"classicalML",displayGroups:["classicalML"]},{name:"LightGBM",algKey:"lightgbm_classification",condition:$scope.isClassification,supportedCausalMethod:"META_LEARNER",templateName:"lightgbm",type:"classicalML",displayGroups:["classicalML"]},{name:"LightGBM",algKey:"lightgbm_regression",condition:function(){return $scope.isRegression()||$scope.isTimeseriesPrediction()},supportedCausalMethod:"META_LEARNER",templateName:"lightgbm",type:"classicalML",displayGroups:["classicalML"]},{name:"XGBoost",algKey:"xgboost_classification",condition:$scope.isClassification,supportedCausalMethod:"META_LEARNER",templateName:"xgboost",hpSpaceName:"xgboost",type:"classicalML",displayGroups:["classicalML"]},{name:"XGBoost",algKey:"xgboost_regression",condition:function(){return $scope.isRegression()||$scope.isTimeseriesPrediction()},supportedCausalMethod:"META_LEARNER",templateName:"xgboost",hpSpaceName:"xgboost",type:"classicalML",displayGroups:["classicalML"]},{name:"Decision Tree",algKey:"decision_tree_classification",condition:$scope.isClassification,supportedCausalMethod:"META_LEARNER",type:"classicalML",displayGroups:["classicalML"]},{name:"Decision Tree",algKey:"decision_tree_regression",condition:$scope.isRegression,supportedCausalMethod:"META_LEARNER",type:"classicalML",displayGroups:["classicalML"]},{name:"Support Vector Machine",algKey:"svc_classifier",condition:$scope.isClassification,supportedCausalMethod:"META_LEARNER",type:"classicalML",displayGroups:["classicalML"]},{name:"Support Vector Machine",algKey:"svm_regression",condition:$scope.isRegression,supportedCausalMethod:"META_LEARNER",type:"classicalML",displayGroups:["classicalML"]},{name:"Stochastic Gradient Descent",algKey:"sgd_classifier",condition:$scope.isClassification,supportedCausalMethod:"META_LEARNER",type:"classicalML",displayGroups:["classicalML"]},{name:"Stochastic Gradient Descent",algKey:"sgd_regression",condition:$scope.isRegression,supportedCausalMethod:"META_LEARNER",type:"classicalML",displayGroups:["classicalML"]},{name:"KNN",algKey:"knn",condition:Fn.not($scope.isTimeseriesPrediction),supportedCausalMethod:"META_LEARNER",type:"classicalML",displayGroups:["classicalML"]},{name:"Extra Random Trees",algKey:"extra_trees",condition:Fn.not($scope.isTimeseriesPrediction),supportedCausalMethod:"META_LEARNER",type:"classicalML",displayGroups:["classicalML"]},{name:"Single Layer Perceptron",algKey:"neural_network",condition:Fn.not($scope.isTimeseriesPrediction),supportedCausalMethod:"META_LEARNER",type:"classicalML",displayGroups:["classicalML"]},{name:"Lasso Path",algKey:"lars_params",condition:Fn.not($scope.isTimeseriesPrediction),supportedCausalMethod:"META_LEARNER",type:"classicalML",displayGroups:["classicalML"]},{name:"Deep Neural Network",algKey:"deep_neural_network_classification",condition:function(){return $scope.isClassification()},supportedCausalMethod:"META_LEARNER",templateName:"deep_neural_network",type:"classicalML",displayGroups:["classicalML"]},{name:"Deep Neural Network",algKey:"deep_neural_network_regression",condition:function(){return $scope.isRegression()},supportedCausalMethod:"META_LEARNER",templateName:"deep_neural_network",type:"classicalML",displayGroups:["classicalML"]},{name:"Deep Learning (H2O)",algKey:"deep_learning_h2o",condition:$scope.h2oEnabled,type:"classicalML",displayGroups:["classicalML"]},{name:"GLM (H2O)",algKey:"glm_h2o",condition:function(){return $scope.h2oEnabled()&&$scope.isRegression()},type:"classicalML",displayGroups:["classicalML"]},{name:"Gradient Boosting (H2O)",algKey:"gbm_h2o",condition:$scope.h2oEnabled,type:"classicalML",displayGroups:["classicalML"]},{name:"Random Forest (H2O)",algKey:"distributed_rf_h2o",condition:$scope.h2oEnabled,type:"classicalML",displayGroups:["classicalML"]},{name:"AutoARIMA",algKey:"autoarima_timeseries",algEnumName:"auto_arima",condition:$scope.isTimeseriesPrediction,type:"statistical",displayGroups:["statistical"]},{name:"ARIMA",algKey:"arima_timeseries",algEnumName:"arima",condition:$scope.isTimeseriesPrediction,type:"statistical",displayGroups:["statistical"]},{name:"Croston",algKey:"croston_timeseries",algEnumName:"croston",condition:$scope.isTimeseriesPrediction,type:"statistical",displayGroups:["statistical"]},{name:"Seasonal trend",algKey:"seasonal_loess_timeseries",algEnumName:"seasonal_loess",condition:$scope.isTimeseriesPrediction,type:"statistical",displayGroups:["statistical"]},{name:"ETS",algKey:"ets_timeseries",algEnumName:"ets",condition:$scope.isTimeseriesPrediction,type:"statistical",displayGroups:["statistical"]},{name:"Prophet",algKey:"prophet_timeseries",algEnumName:"prophet",condition:$scope.isTimeseriesPrediction,type:"statistical",displayGroups:["statistical"]},{name:"NPTS",algKey:"gluonts_npts_timeseries",algEnumName:"gluonts_npts_forecaster",condition:$scope.isTimeseriesPrediction,type:"statistical",displayGroups:["statistical"]},{name:"Simple Feed Forward - Torch",algKey:"gluonts_torch_simple_feed_forward_timeseries",algEnumName:"gluonts_torch_simple_feedforward",condition:$scope.isTimeseriesPrediction,type:"deep_learning",displayGroups:["deepLearning"]},{name:"DeepAR - Torch",algKey:"gluonts_torch_deepar_timeseries",algEnumName:"gluonts_torch_deepar",condition:$scope.isTimeseriesPrediction,type:"deep_learning",displayGroups:["deepLearning"]},{name:"NHITS",algKey:"nhits_timeseries",algEnumName:"nhits",condition:$scope.isTimeseriesPrediction,type:"deep_learning",displayGroups:["deepLearning"]},{name:"TFT",algKey:"tft_timeseries",algEnumName:"tft",condition:$scope.isTimeseriesPrediction,type:"deep_learning",displayGroups:["deepLearning"]},{name:"Trivial identity",algKey:"trivial_identity_timeseries",condition:$scope.isTimeseriesPrediction,type:"baseline",displayGroups:["baseline"]},{name:"Seasonal naive",algKey:"seasonal_naive_timeseries",algEnumName:"seasonal_naive",condition:$scope.isTimeseriesPrediction,type:"baseline",displayGroups:["baseline"]},{name:"Simple Feed Forward - MXNet",algKey:"gluonts_simple_feed_forward_timeseries",algEnumName:"gluonts_simple_feedforward",condition:$scope.isTimeseriesPrediction,type:"deep_learning",displayGroups:["legacy"]},{name:"DeepAR - MXNet",algKey:"gluonts_deepar_timeseries",algEnumName:"gluonts_deepar",condition:$scope.isTimeseriesPrediction,type:"deep_learning",displayGroups:["legacy"]},{name:"Transformer",algKey:"gluonts_transformer_timeseries",algEnumName:"gluonts_transformer",condition:$scope.isTimeseriesPrediction,type:"deep_learning",displayGroups:["legacy"]},{name:"MQ-CNN",algKey:"gluonts_mqcnn_timeseries",algEnumName:"gluonts_mqcnn",condition:$scope.isTimeseriesPrediction,type:"deep_learning",displayGroups:["legacy"]},{name:"Causal Forest",algKey:"causal_forest",condition:$scope.isCausalPrediction,supportedCausalMethod:"CAUSAL_FOREST",type:"classicalML",displayGroups:["classicalML"]},{name:"TabICL",algKey:"tabicl_classification",condition:$scope.isClassification,supportedCausalMethod:"META_LEARNER",templateName:"tabicl",type:"classicalML",displayGroups:["classicalML"]}],MLLIB:[{name:"Linear Regression",algKey:"mllib_linreg",algEnumName:"mllib_linear_regression",condition:$scope.isRegression},{name:"Logistic Regression",algKey:"mllib_logit",algEnumName:"mllib_logistic_regression",condition:$scope.isClassification},{name:"Decision Tree",algKey:"mllib_dt",algEnumName:"mllib_decision_tree"},{name:"Random Forest",algKey:"mllib_rf",algEnumName:"mllib_random_forest"},{name:"Gradient tree boosting",algKey:"mllib_gbt",algEnumName:"mllib_gbt",condition:Fn.not($scope.isMulticlass)},{name:"Naive Bayes",algKey:"mllib_naive_bayes",algEnumName:"mllib_naive_bayes",condition:$scope.isMulticlass}],H2O:[{name:"Deep Learning",algKey:"deep_learning_sparkling",algEnumName:"sparkling_deep_learning"},{name:"Generalized Linear Model",algKey:"glm_sparkling",algEnumName:"sparkling_glm"},{name:"Gradient Boosting",algKey:"gbm_sparkling",algEnumName:"sparkling_gbm"},{name:"Random Forest",algKey:"rf_sparkling",algEnumName:"sparkling_rf"},{name:"Naive Bayes",algKey:"nb_sparkling",algEnumName:"sparkling_nb",condition:$scope.isClassification}],KERAS:[{name:"Deep Learning with Keras",algKey:"keras"}],DEEP_HUB:[{name:"Computer vision",algKey:"deephub-computer-vision"}]};$scope.setAdditionalSnippetParams=function(){if(!$scope.modelSnippets||!$scope.sessionTask)return;if(!$scope.isTimeseriesPrediction())return;if($scope.sessionTask.partitionedModel&&$scope.sessionTask.partitionedModel.enabled)return;if($scope.sessionTask.$forecastRange&&$scope.sessionTask.$forecastRange.final)return;const doneSessionSnippets=Object.values($scope.modelSnippets).filter(snippet=>snippet.trainInfo.state==="DONE"&&snippet.sessionId===$scope.sessionTask.sessionId);if(doneSessionSnippets.length<2)return;$scope.sessionTask.$forecastRange={final:!$scope.mlTaskStatus.training,...doneSessionSnippets.reduce(function(currentMinMax,snippet){const firstTimeseries=Object.values(snippet.forecasts.perTimeseries)[0];const sortedQuantiles=firstTimeseries.quantiles.sort((a,b)=>a.quantile-b.quantile);const[lowerQuantile,upperQuantile]=[sortedQuantiles[0],sortedQuantiles[sortedQuantiles.length-1]];if(lowerQuantile.quantile!==upperQuantile.quantile){currentMinMax.min=Math.min(currentMinMax.min,...lowerQuantile.forecast);currentMinMax.max=Math.max(currentMinMax.max,...upperQuantile.forecast)}const displayedGroundTruth=firstTimeseries.groundTruth.slice(-firstTimeseries.forecast.length-2);return{min:Math.min(...displayedGroundTruth,...firstTimeseries.forecast,currentMinMax.min),max:Math.max(...displayedGroundTruth,...firstTimeseries.forecast,currentMinMax.max)}},{min:Number.MAX_VALUE,max:-Number.MAX_VALUE})}};$controller("_MLTaskBaseController",{$scope:$scope});$scope.dumpUISplitParams=function(){const sp=$scope.mlTaskDesign.splitParams;if(!sp){throw new Error("No split params")}if($scope.uiSplitParams.policy=="SPLIT_MAIN_DATASET"){sp.ttPolicy="SPLIT_SINGLE_DATASET";sp.ssdDatasetSmartName=null}else if($scope.uiSplitParams.policy=="SPLIT_OTHER_DATASET"){sp.ttPolicy="SPLIT_SINGLE_DATASET"}else if($scope.uiSplitParams.policy=="EXPLICIT_FILTERING_SINGLE_DATASET_MAIN"){sp.ttPolicy="EXPLICIT_FILTERING_SINGLE_DATASET";sp.efsdDatasetSmartName=null}else if($scope.uiSplitParams.policy=="EXPLICIT_FILTERING_SINGLE_DATASET_OTHER"){sp.ttPolicy="EXPLICIT_FILTERING_SINGLE_DATASET"}else{sp.ttPolicy=$scope.uiSplitParams.policy}Logger.info("DUMP UI SPLIT",sp,$scope.uiSplitParams)};$scope.saveSettings=function(){Assert.inScope($scope,"mlTaskDesign");$scope.dumpUISplitParams();TimeseriesFeatureGenerationService.cleanUpSettings($scope.mlTaskDesign);return DataikuAPI.analysis.pml.saveSettings($stateParams.projectKey,$stateParams.analysisId,$scope.mlTaskDesign).then(({data})=>{resetErrorInScope($scope);$scope.savedSettings=dkuDeepCopy($scope.mlTaskDesign,PMLSettings.noDollarKey)}).then($scope.refreshStatus).then($scope.listMLTasks).catch(setErrorInScope.bind($scope))};$scope.checkSplitParams=function(splitParams,checkSingle){if(!splitParams){throw new Error("No split params")}var error=null;if(splitParams.ttPolicy==="EXPLICIT_FILTERING_TWO_DATASETS"){if(!splitParams.eftdTest||!splitParams.eftdTest.datasetSmartName){error="No test dataset specified."}if(!splitParams.eftdTrain||!splitParams.eftdTrain.datasetSmartName){error=error?"No train nor test dataset specified.":"No train dataset specified."}}else if(checkSingle){if("ssdDatasetSmartName"in splitParams&&!splitParams.ssdDatasetSmartName||"efsdDatasetSmartName"in splitParams&&!splitParams.efsdDatasetSmartName){error="No dataset specified."}}else if($scope.uiSplitParams.policy==="SPLIT_OTHER_DATASET"&&!splitParams.ssdDatasetSmartName||$scope.uiSplitParams.policy==="EXPLICIT_FILTERING_SINGLE_DATASET_OTHER"&&!splitParams.efsdDatasetSmartName){error="No dataset specified."}if(error){Dialogs.ack($scope,"Incorrect Train/Test settings",error);return false}return true};$scope.isSampleWeightEnabled=function(){const weightMethod=$scope.mlTaskDesign.weight&&$scope.mlTaskDesign.weight.weightMethod;return weightMethod==="SAMPLE_WEIGHT"||weightMethod==="CLASS_AND_SAMPLE_WEIGHT"};$scope.multiclassAveragingAndWeightingInconsistent=function(){const weightMethod=$scope.mlTaskDesign.weight&&$scope.mlTaskDesign.weight.weightMethod;const classAveragingMethod=$scope.mlTaskDesign.modeling.metrics.classAveragingMethod;if(["CLASS_WEIGHT","CLASS_AND_SAMPLE_WEIGHT"].includes(weightMethod)){return classAveragingMethod==="WEIGHTED"}else if(["NO_WEIGHTING","SAMPLE_WEIGHT"].includes(weightMethod)){return classAveragingMethod==="MACRO"}else return false};$scope.getAvailableGpuCapabilities=function(){return GpuUsageService.getAvailableGpuCapabilities($scope.mlTaskDesign.backendType,$scope.mlTaskDesign.predictionType)};$scope.getUsedGpuCapabilities=function(){const gpuCapabilities=[];if($scope.isMLBackendType("KERAS")){gpuCapabilities.push(GPU_SUPPORTING_CAPABILITY.KERAS)}else if($scope.isGpuCompatibleTimeseriesPrediction()){gpuCapabilities.push(GPU_SUPPORTING_CAPABILITY.GLUONTS)}else if($scope.isMLBackendType("DEEP_HUB")){gpuCapabilities.push(GPU_SUPPORTING_CAPABILITY.DEEP_HUB)}if($scope.isDeepNeuralNetworkEnabled()){gpuCapabilities.push(GPU_SUPPORTING_CAPABILITY.DEEP_NN)}if($scope.isTabICLEnabled()){gpuCapabilities.push(GPU_SUPPORTING_CAPABILITY.TABICL)}if($scope.isXGBoostEnabled()){gpuCapabilities.push(GPU_SUPPORTING_CAPABILITY.XGBOOST)}if($scope.usesCodeEnvSentenceEmbedding()){gpuCapabilities.push(GPU_SUPPORTING_CAPABILITY.SENTENCE_EMBEDDING)}return gpuCapabilities};$scope.getUsedGpuCapabilitiesWithGpuOn=function(){if(!$scope.mlTaskDesign)return[];const usedGpuCapabilities=$scope.getUsedGpuCapabilities();const usedGpuCapabilitiesWithGpuOn=usedGpuCapabilities.filter(item=>{return $scope.mlTaskDesign.gpuConfig.disabledCapabilities.indexOf(item)===-1});return usedGpuCapabilitiesWithGpuOn}});app.controller("_PMLTrainSessionController",function($scope,DataikuAPI,PMLSettings,CodeMirrorSettingService,$state,$stateParams,CreateModalFromTemplate,MLContainerInfoService,WT1,ActivityIndicator){$scope.newTrainSessionModalDisplayed=false;$scope.refreshMLTaskSessions=function(willBeQueued){$scope.newTrainSessionModalDisplayed=false;$scope.uiState.$userRequestedState=false;$scope.initialRefreshAndAutoRefresh();if(!willBeQueued){if(!$state.current.name.startsWith($scope.sRefPrefix+".list.results")){$state.go($scope.sRefPrefix+".list.results.sessions")}}else{ActivityIndicator.success("Session added to queue")}};function newTrainSessionCallback(willBeQueued){return DataikuAPI.analysis.pml.getUpdatedSettings($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId).then(function(response){if($scope.checkSplitParams(response.data.splitParams,true)){DataikuAPI.analysis.pml.saveSettings($stateParams.projectKey,$stateParams.analysisId,response.data).success(function(data){$scope.savedSettings=dkuDeepCopy($scope.mlTaskDesign,PMLSettings.noDollarKey);if(!$scope.newTrainSessionModalDisplayed){$scope.newTrainSessionModalDisplayed=true;let createFromModal;$scope.willBeQueued=willBeQueued;if($scope.isDeepHubPrediction()){createFromModal=CreateModalFromTemplate("/templates/analysis/prediction/deephub/pre-train-modal.html",$scope,"DeepHubPMLTaskPreTrainModal")}else if($scope.isTimeseriesPrediction()){createFromModal=CreateModalFromTemplate("/templates/analysis/prediction/pre-train-modal.html",$scope,"TimeseriesPMLTaskPreTrainModal")}else if($scope.isClassicalPrediction()){createFromModal=CreateModalFromTemplate("/templates/analysis/prediction/pre-train-modal.html",$scope,"ClassicalPMLTaskPreTrainModal")}else if($scope.isCausalPrediction()){createFromModal=CreateModalFromTemplate("/templates/analysis/prediction/pre-train-modal.html",$scope,"CausalPMLTaskPreTrainModal")}else{throw new Error("Unknown prediction type "+$scope.mlTaskDesign.predictionType)}createFromModal.then(function(){$scope.refreshMLTaskSessions(willBeQueued)},function(){$scope.newTrainSessionModalDisplayed=false})}}).error(setErrorInScope.bind($scope))}},setErrorInScope.bind($scope))}$scope.newTrainSession=function(willBeQueued){if($scope.dirtySettings()){$scope.saveSettings().then(()=>newTrainSessionCallback(willBeQueued))}else{newTrainSessionCallback(willBeQueued)}};$scope.trainQueue=function(){DataikuAPI.analysis.pml.trainQueue($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId).success(()=>{$scope.refreshMLTaskSessions()}).error((data,status,headers)=>{setErrorInScope.bind($scope)(data,status,headers);$scope.listQueuedSessions()});WT1.event("mltask-train-queue",{taskType:$scope.mlTaskDesign.taskType})};$scope.inContainer=MLContainerInfoService.inContainer($scope,$stateParams.projectKey)});app.controller("ClassicalPMLTaskBaseController",function($scope,$controller,DataikuAPI,$stateParams,CreateModalFromTemplate,Debounce,$q,$rootScope,PMLSettings,AlgorithmsSettingsService,Dialogs,$filter,CachedAPICalls){$controller("_PMLTrainSessionController",{$scope:$scope});$controller("PMLTaskCrossvalController",{$scope:$scope});$scope.deferredAfterInitMlTaskDesign.then(()=>CachedAPICalls.pmlGuessPolicies).then(pmlGuessPolicies=>{$scope.guessPolicies=pmlGuessPolicies.auto.concat(pmlGuessPolicies.expert).filter(policy=>policy!==undefined).filter(policy=>!["ALGORITHMS","DEEP"].includes(policy.id));$scope.guessPolicies=$scope.prepareGuessPolicies($scope.guessPolicies)}).then(()=>$scope.enrichBaseAlgorithmsWithPlugins).then(()=>{$scope.setAlgorithms($scope.mlTaskDesign);$scope.setSelectedAlgorithm(AlgorithmsSettingsService.getDefaultAlgorithm($scope.mlTaskDesign,$scope.algorithms[$scope.mlTaskDesign.backendType]));if($scope.mlTaskDesign.backendType==="KERAS"){$controller("DeepLearningPMLController",{$scope:$scope})}}).catch(setErrorInScope.bind($scope));$scope.enrichBaseAlgorithmsWithPlugins=DataikuAPI.analysis.pml.listCustomPythonAlgos($stateParams.projectKey).success(function(data){data.map(alg=>{return{algKey:alg.pyPredAlgoType,name:alg.desc.meta.label,customInfo:alg,pluginDesc:$rootScope.appConfig.loadedPlugins.find(plugin=>plugin.id===alg.ownerPluginId),condition:function(){const regCond=alg.desc.predictionTypes.includes("REGRESSION")&&$scope.isRegression();const binCond=alg.desc.predictionTypes.includes("BINARY_CLASSIFICATION")&&$scope.isBinaryClassification();const multCond=alg.desc.predictionTypes.includes("MULTICLASS")&&$scope.isMulticlass();return regCond||binCond||multCond}}}).filter(alg=>!$scope.base_algorithms["PY_MEMORY"].map(_=>_.algKey).includes(alg.algKey)).forEach(alg=>{$scope.base_algorithms["PY_MEMORY"].push(alg);if(!alg.customInfo.desc.supportsSampleWeights){$scope.algosWithoutWeightSupport.add(alg.algKey)}})}).error(setErrorInScope.bind($scope));$scope.algosWithoutWeightSupport=new Set(["lasso_regression","knn","neural_network","lars_params","deep_neural_network_regression","deep_neural_network_classification","tabicl_classification"]);$scope.beforeUpdateSettingsCallback=function(settings){$scope.fillUISplitParams(settings.splitParams)};$scope.setWeightOptions=function(){if($scope.isRegression()){$scope.uiState.weightMethods=[["NO_WEIGHTING","No weighting"],["SAMPLE_WEIGHT","Sample weights"]]}else{$scope.uiState.weightMethods=[["NO_WEIGHTING","No weighting"],["SAMPLE_WEIGHT","Sample weights"],["CLASS_WEIGHT","Class weights"],["CLASS_AND_SAMPLE_WEIGHT","Class and sample weights"]]}};$scope.$watch("mlTaskDesign.predictionType",nv=>{if(nv){$scope.setWeightOptions()}});$scope.$watch("mlTaskDesign.partitionedModel",Debounce().withScope($scope).withDelay(300,300).wrap((nv,ov)=>{if(nv){if(nv.enabled){const sampleSelection=$scope.mlTaskDesign.splitParams.ssdSelection;const partitionSelection=nv.ssdSelection;const partitionModelSettings={partitionSelectionMethod:partitionSelection.partitionSelectionMethod,selectedPartitions:partitionSelection.selectedPartitions,latestPartitionsN:partitionSelection.latestPartitionsN};Object.assign(sampleSelection,partitionModelSettings)}else if(ov&&ov.enabled&&!nv.enabled){$scope.mlTaskDesign.splitParams.ssdSelection.partitionSelectionMethod="ALL"}}}),true);$scope.classAveragingMethods=[["WEIGHTED","Weighted"],["MACRO","Unweighted"]];$scope.onChangeWeightMethod=function(){if(!$scope.isMulticlass()){if(($scope.uiState.weightMethod==="NO_WEIGHTING"||$scope.uiState.weightMethod==="CLASS_WEIGHT")&&$scope.mlTaskDesign.weight.sampleWeightVariable){Dialogs.confirm($scope,"Removing weight variable",`The former weight variable <strong>${$filter("escapeHtml")($scope.mlTaskDesign.weight.sampleWeightVariable)}</strong> will be set as a numerical input to the models.`).then(onChangeWeightMethod,()=>{$scope.uiState.weightMethod=$scope.mlTaskDesign.weight.weightMethod})}else{onChangeWeightMethod()}}else{const warningChangeAveragingMethodToUnweighted="The <strong> unweighted</strong> averaging method will be set for computing the one-vs-all multiclass metrics. "+"The metrics will be computed for each class and the global metrics will be their unweighted average.";const warningChangeAveragingMethodToWeighted="The <strong>weighted</strong> averaging method will be set for computing the one-vs-all multiclass metrics. ";if($scope.uiState.weightMethod==="NO_WEIGHTING"||$scope.uiState.weightMethod==="CLASS_WEIGHT"){const shouldDisplayWarningOnMetricsWeightingStrategy=$scope.uiState.weightMethod==="NO_WEIGHTING"&&$scope.mlTaskDesign.modeling.metrics.classAveragingMethod==="MACRO"||$scope.uiState.weightMethod==="CLASS_WEIGHT"&&$scope.mlTaskDesign.modeling.metrics.classAveragingMethod==="WEIGHTED";if($scope.mlTaskDesign.weight.sampleWeightVariable){Dialogs.confirm($scope,"Removing weight variable",`The former weight variable <strong>${$filter("escapeHtml")($scope.mlTaskDesign.weight.sampleWeightVariable)}</strong> will be set as a numerical input to the models. <br> <br>`+(shouldDisplayWarningOnMetricsWeightingStrategy?$scope.mlTaskDesign.modeling.metrics.classAveragingMethod==="MACRO"?warningChangeAveragingMethodToWeighted+"The metrics will be computed for each class and the global metrics will be their average weighted by the sum of the sample weights.":warningChangeAveragingMethodToUnweighted:"")).then(onChangeWeightMethod,()=>{$scope.uiState.weightMethod=$scope.mlTaskDesign.weight.weightMethod})}else{if(shouldDisplayWarningOnMetricsWeightingStrategy){Dialogs.confirm($scope,"Changing averaging method for metrics",$scope.mlTaskDesign.modeling.metrics.classAveragingMethod==="MACRO"?warningChangeAveragingMethodToWeighted+"The metrics will be computed for each class and the global metrics will be will be their average weighted by their cardinality.":warningChangeAveragingMethodToUnweighted).then(onChangeWeightMethod,()=>{$scope.uiState.weightMethod=$scope.mlTaskDesign.weight.weightMethod})}else{onChangeWeightMethod()}}}else{const shouldDisplayWarningOnMetricsWeightingStrategy=$scope.uiState.weightMethod==="CLASS_AND_SAMPLE_WEIGHT"&&$scope.mlTaskDesign.modeling.metrics.classAveragingMethod==="WEIGHTED"||$scope.uiState.weightMethod==="SAMPLE_WEIGHT"&&$scope.mlTaskDesign.modeling.metrics.classAveragingMethod==="MACRO";if(shouldDisplayWarningOnMetricsWeightingStrategy){Dialogs.confirm($scope,"Changing averaging method for metrics",$scope.mlTaskDesign.modeling.metrics.classAveragingMethod==="MACRO"?warningChangeAveragingMethodToWeighted+"The metrics will be computed for each class and the global metrics will be their average weighted by the sum of the sample weights.":warningChangeAveragingMethodToUnweighted).then(onChangeWeightMethod,()=>{$scope.uiState.weightMethod=$scope.mlTaskDesign.weight.weightMethod})}else{onChangeWeightMethod()}}}};function onChangeWeightMethod(){if($scope.uiState.weightMethod==="NO_WEIGHTING"||$scope.uiState.weightMethod==="CLASS_WEIGHT"){if($scope.mlTaskDesign.weight.sampleWeightVariable){if($scope.mlTaskDesign.preprocessing.per_feature[$scope.mlTaskDesign.weight.sampleWeightVariable]){$scope.mlTaskDesign.preprocessing.per_feature[$scope.mlTaskDesign.weight.sampleWeightVariable].role="INPUT"}}$scope.uiState.sampleWeightVariable=null;$scope.mlTaskDesign.weight.sampleWeightVariable=null}if($scope.isMulticlass()){if($scope.uiState.weightMethod==="NO_WEIGHTING"||$scope.uiState.weightMethod==="SAMPLE_WEIGHT"){$scope.mlTaskDesign.modeling.metrics.classAveragingMethod="WEIGHTED"}else{$scope.mlTaskDesign.modeling.metrics.classAveragingMethod="MACRO"}}$scope.mlTaskDesign.weight.weightMethod=$scope.uiState.weightMethod;$scope.saveSettings()}$scope.onChangeSampleWeightVariable=function(){if($scope.uiState.sampleWeightVariable){var deferred=$q.defer();CreateModalFromTemplate("/templates/analysis/prediction/change-weight-modal.html",$scope,null,function(newScope){newScope.deferred=deferred;newScope.confirm=function(){if($scope.mlTaskDesign.weight.sampleWeightVariable){if($scope.mlTaskDesign.preprocessing.per_feature[$scope.mlTaskDesign.weight.sampleWeightVariable]){$scope.mlTaskDesign.preprocessing.per_feature[$scope.mlTaskDesign.weight.sampleWeightVariable].role="INPUT"}}$scope.mlTaskDesign.weight.sampleWeightVariable=$scope.uiState.sampleWeightVariable;let featureData=$scope.mlTaskDesign.preprocessing.per_feature[$scope.uiState.sampleWeightVariable];featureData.role="WEIGHT";if(featureData.type!="NUMERIC"||featureData.autoReason){featureData.missing_handling="IMPUTE";featureData.missing_impute_with="MEAN";featureData.numerical_handling="REGULAR";featureData.rescaling="AVGSTD";featureData.type="NUMERIC"}$scope.saveSettings();newScope.deferred.resolve("changed");newScope.dismiss()};newScope.cancel=function(){newScope.deferred.reject("cancelled");newScope.dismiss()};newScope.$on("$destroy",function(){if(newScope.deferred){newScope.deferred.reject("destroyed")}newScope.deferred=null})});deferred.promise.then(function(a){},function(a){$scope.uiState.sampleWeightVariable=$scope.mlTaskDesign.weight.sampleWeightVariable})}};$scope.potentialWeightFeatures=function(){var per_feature=$scope.mlTaskDesign.preprocessing.per_feature;return Object.keys(per_feature).filter(x=>per_feature[x].role!=="TARGET")};$scope.uiState.calibrationMethods=PMLSettings.task.calibrationMethods;$scope.isCalibrationEnabled=function(){return $scope.mlTaskDesign.calibration.calibrationMethod!="NO_CALIBRATION"};$scope.uiState.gsModes=[["TIME_SERIES_SINGLE_SPLIT","Time-based train/validation split"],["TIME_SERIES_KFOLD","Time-based K-fold (with overlap)"]];$scope.isTimeOrderingEnabled=function(){return!!$scope.mlTaskDesign.time&&$scope.mlTaskDesign.time.enabled};$scope.isTimeVariable=function(feature){return!!$scope.mlTaskDesign.time&&$scope.mlTaskDesign.time.enabled&&$scope.mlTaskDesign.time.timeVariable==feature._name};function isKFoldSplit(){return $scope.mlTaskDesign&&$scope.mlTaskDesign.splitParams&&$scope.mlTaskDesign.splitParams.kfold}$scope.isCompatibleWithStratifiedSplitting=function(){return $scope.isMLBackendType("PY_MEMORY")&&isKFoldSplit()&&$scope.isClassification()&&!$scope.isTimeOrderingEnabled()};$scope.isCompatibleWithGroupKFold=function(){return $scope.isMLBackendType("PY_MEMORY")&&isKFoldSplit()};$scope.getCalibrationSetWidth=function(){if($scope.mlTaskDesign.splitParams.kfold){return Math.max($scope.mlTaskDesign.calibration.calibrationDataRatio*100,1)}else{return Math.max($scope.mlTaskDesign.calibration.calibrationDataRatio*$scope.mlTaskDesign.splitParams.ssdTrainingRatio*100,1)}};$scope.getKFoldEvalCalibrationSetWidth=function(){if(!$scope.isCalibrationEnabled()||$scope.mlTaskDesign.calibration.calibrateOnTestSet){return 0}else{return $scope.mlTaskDesign.calibration.calibrationDataRatio*($scope.mlTaskDesign.splitParams.nFolds-1)/$scope.mlTaskDesign.splitParams.nFolds*100}};$scope.isKFoldEvalCalibrationSetOverflowing=function(fold){return $scope.getKFoldEvalCalibrationSetWidth()>=100*(1-fold/$scope.mlTaskDesign.splitParams.nFolds)};$scope.getKFoldEvalCalibrationSetOverflowingWidth=function(fold){return $scope.isKFoldEvalCalibrationSetOverflowing(fold)?$scope.getKFoldEvalCalibrationSetWidth()-100*(1-fold/$scope.mlTaskDesign.splitParams.nFolds):0}});app.controller("_PMLTaskResultController",function($scope,DataikuAPI,$stateParams,WT1){$scope.retrainModel=function(sessionId,fullModelIds,setUiState=false){WT1.event("start-retrain-model",{});return DataikuAPI.analysis.pml.retrainStart($scope.analysisCoreParams.projectKey,$scope.analysisCoreParams.id,$stateParams.mlTaskId,sessionId,fullModelIds).success(()=>{fullModelIds.forEach(fmi=>{$scope.modelSnippets[fmi].trainInfo.$userRequestedState=false});if(setUiState){$scope.uiState.$userRequestedState=false}$scope.initialRefreshAndAutoRefresh()}).error(setErrorInScope.bind($scope))}});app.controller("_TabularPMLTaskResultController",function($scope,$controller,PMLSettings,PMLFilteringService,Fn){$controller("_MLTaskResultsController",{$scope:$scope});$controller("_PMLTaskResultController",{$scope:$scope});angular.extend($scope,PMLSettings.taskF($scope.mlTasksContext.activeMLTask.backendType));angular.extend($scope,PMLSettings.task);$scope.algorithmCategories=PMLSettings.algorithmCategories($scope.mlTasksContext.activeMLTask.predictionType);$scope.metricMap=PMLFilteringService.metricMap;$scope.anySessionModelNeedsHyperparameterSearch=function(){return($scope.selection.sessionModels||[]).some(function(x){return(x.gridLength!=1||x.pluginAlgoCustomGridSearch)&&!x.partitionedModelEnabled})};$scope.anySessionModelHasOptimizationResults=function(){if($scope.isMLBackendType("KERAS")){return($scope.selection.sessionModels||[]).some(function(x){return x.modelTrainingInfo})}else{return($scope.selection.sessionModels||[]).some(function(x){return x.gridsearchData&&x.gridsearchData.gridPoints&&x.gridsearchData.gridPoints.length>0})}};$scope.retrainSession=function(sessionId){const fullModelIds=$scope.selection.allObjects.filter(function(model){return model.sessionId===sessionId&&($scope.isModelOptimizationResumable(model)||$scope.isModelRetrainable(model))}).map(Fn.prop("fullModelId"));$scope.retrainModel(sessionId,fullModelIds,true)}});app.controller("ClassicalPMLTaskResultController",function($scope,$timeout,$controller,DataikuAPI,$stateParams,FutureWatcher){$controller("_TabularPMLTaskResultController",{$scope:$scope});$controller("_DeepLearningPMLTaskResultController",{$scope:$scope});$scope.tensorboardUrls={};$scope.initializeTensorboardUrl=function(sessionId){let webAppId=`TENSORBOARD_${$scope.analysisCoreParams.projectKey}-${$stateParams.analysisId}-${$stateParams.mlTaskId}-${sessionId}`;DataikuAPI.webapps.getBackendUrl($scope.analysisCoreParams.projectKey,webAppId,null).success(function(data){$timeout(function(){$scope.tensorboardUrls[sessionId]=data.location})}).error(setErrorInScope.bind($scope))};$scope.canShowTensorboard=function(){return $scope.sessionTask.backendType==="KERAS"};$scope.$watch("sessionTask",nv=>{if(nv){if(nv.tensorboardStatus===undefined){nv.tensorboardStatus={isShown:false,isBackendReady:false,isFrontendReady:false,showIfFrontIsNotReady:false,fullScreen:false}}else{nv.tensorboardStatus.isFrontendReady=false;nv.tensorboardStatus.showIfFrontIsNotReady=true}}});$scope.showHideTensorboard=function(){$scope.sessionTask.tensorboardStatus.showIfFrontIsNotReady=false;$scope.sessionTask.tensorboardStatus.fullScreen=false;$scope.sessionTask.tensorboardStatus.isBackendReady=false;$scope.sessionTask.tensorboardStatus.isFrontendReady=false;$scope.sessionTask.tensorboardStatus.isShown=!$scope.sessionTask.tensorboardStatus.isShown;if($scope.sessionTask.tensorboardStatus.isShown){let sessionId=$scope.selection.sessionModels[0].sessionId;DataikuAPI.webapps.startTensorboard($scope.analysisCoreParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId,sessionId).success(function(result){if(result&&result.jobId&&!result.hasResult){FutureWatcher.watchJobId(result.jobId).success(function(data){$scope.sessionTask.tensorboardStatus.isBackendReady=true}).error(function(data,status,headers,config,statusText,xhrStatus){$scope.sessionTask.tensorboardStatus.isShown=false;setErrorInScope.bind($scope)(data,status,headers,config,statusText,xhrStatus)})}else{$scope.sessionTask.tensorboardStatus.isBackendReady=true}}).error(setErrorInScope.bind($scope))}}});app.controller("_TabularPMLTaskDesignController",function($scope,$controller,$stateParams,Dialogs,DataikuAPI,Assert,WT1,Collections,CreateModalFromTemplate,PMLSettings,VisualMlCodeEnvCompatibility,StringUtils,CustomMetricIDService,AlgorithmsSettingsService){angular.extend($scope,PMLSettings.taskF($scope.mlTasksContext.activeMLTask.backendType));angular.extend($scope,PMLSettings.task);$scope.AlgorithmsSettingsService=AlgorithmsSettingsService;$controller("_MLTaskDesignController",{$scope:$scope});$scope.reguessAll=function(){Dialogs.confirm($scope,"Re-detect settings","Are you sure you want to re-detect all settings? Your changes will be lost.").then(function(){DataikuAPI.analysis.pml.reguess($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId).then(function({data}){$scope.setMlTaskDesign(data);$scope.savedSettings=dkuDeepCopy($scope.mlTaskDesign,PMLSettings.noDollarKey);$scope.fillUISplitParams($scope.mlTaskDesign.splitParams)}).then($scope.refreshStatus).catch(setErrorInScope.bind($scope))})};$scope.onChangeTargetFeature=function(){if($scope.dirtySettings()){$scope.saveSettings()}CreateModalFromTemplate("/templates/analysis/prediction/change-core-params-modal.html",$scope,"PMLChangeBasicParamsModal",function(newScope){newScope.paramKey="targetVariable"})};$scope.onChangePredictionType=function(){if($scope.dirtySettings()){$scope.saveSettings()}CreateModalFromTemplate("/templates/analysis/prediction/change-core-params-modal.html",$scope,"PMLChangeBasicParamsModal",function(newScope){newScope.paramKey="predictionType"})};$scope.displayAlgosAsBaseLearners=function(){return $scope.isCausalPrediction()&&$scope.uiState.selectedCausalMethod==="META_LEARNER"};$scope.getAlgorithmTemplate=function(){Assert.inScope($scope,"algorithms");const algorithm=$scope.uiState&&$scope.uiState.algorithm;if(!algorithm)return null;const templatePathPrefix="/templates/analysis/prediction/settings/algorithms/"+$scope.mlTaskDesign.backendType.toLowerCase();if(algorithm.startsWith("CustomPyPredAlgo_")){return templatePathPrefix+"/plugin-model.html"}if(algorithm.startsWith("custom")){return templatePathPrefix+"/custom.html"}const availableAlgorithms=$scope.algorithms[$scope.mlTaskDesign.backendType];const{templateName}=Collections.indexByField(availableAlgorithms,"algKey")[algorithm];return templatePathPrefix+"/"+(templateName||algorithm)+".html"};$scope.addCustomPython=function(){$scope.mlTaskDesign.modeling.custom_python=$scope.mlTaskDesign.modeling.custom_python||[];let code=PMLSettings.defaultCustomCode($scope.mlTaskDesign.backendType,$scope.isRegression(),$scope.mlTaskDesign.targetColumn);$scope.mlTaskDesign.modeling.custom_python.push({enabled:true,name:"Custom Python model",code:code});$scope.setAlgorithms($scope.mlTaskDesign);$scope.uiState.algorithm="custom_python_"+($scope.mlTaskDesign.modeling.custom_python.length-1);$scope.uiState.scrollToMeAlgorithm=$scope.uiState.algorithm};$scope.canAddCustomPython=function(){if($scope.isCausalPrediction()&&$scope.uiState.selectedCausalMethod!=="META_LEARNER")return false;return $scope.mlTaskDesign.backendType==="PY_MEMORY"&&!$scope.isTimeseriesPrediction()};$scope.addCustomMLLib=function(){$scope.mlTaskDesign.custom_mllib=$scope.mlTaskDesign.custom_mllib||[];let initializationCode=PMLSettings.defaultCustomCode($scope.mlTaskDesign.backendType,$scope.isRegression(),$scope.mlTaskDesign.targetVariable);$scope.mlTaskDesign.modeling.custom_mllib.push({enabled:true,name:"Custom MLlib model",initializationCode:initializationCode});$scope.setAlgorithms($scope.mlTaskDesign);$scope.uiState.algorithm="custom_mllib_"+($scope.mlTaskDesign.modeling.custom_mllib.length-1);$scope.uiState.scrollToMeAlgorithm=$scope.uiState.algorithm};$scope.getCrossvalModes=function(){if($scope.mlTaskDesign.time&&$scope.mlTaskDesign.time.enabled){return $scope.crossvalModesWithTime}else{return $scope.crossvalModesRandom}};$scope.copyAlgorithmSettings=function(exportSettings){if($scope.dirtySettings()){$scope.saveSettings()}DataikuAPI.projects.listHeads(exportSettings?"WRITE_CONF":null).success(function(projectData){CreateModalFromTemplate("/templates/analysis/mlcommon/settings/copy-settings.html",$scope,null,function(newScope){newScope.projects=projectData;newScope.title="Copy "+($scope.mlTaskDesign.backendType==="KERAS"?"architecture ":" algorithms ")+(exportSettings?"to":"from");newScope.totem="icon-"+(exportSettings?"copy":"paste");newScope.infoMessages=["You can only choose a "+$scope.displayTypes[$scope.mlTaskDesign.predictionType]+" model using a "+($scope.backendTypeNames[$scope.mlTaskDesign.backendType]||$scope.mlTaskDesign.backendType)+" engine"];newScope.selectProject=function(){DataikuAPI.analysis.listHeads(newScope.selectedProjectKey).success(function(analysisData){newScope.analyses=analysisData;newScope.selectedAnalysisId=undefined;newScope.selectedTask=undefined}).error(setErrorInScope.bind($scope))};newScope.selectAnalysis=function(){DataikuAPI.analysis.listMLTasks(newScope.selectedProjectKey,newScope.selectedAnalysisId).success(function(taskData){newScope.descriptions=[];newScope.tasks=taskData;newScope.tasks.forEach(task=>{task.isNotSelectable=task.mlTaskId===$stateParams.mlTaskId&&newScope.selectedAnalysisId===$stateParams.analysisId&&newScope.selectedProjectKey===$stateParams.projectKey||task.backendType!==$scope.mlTaskDesign.backendType||task.taskType!=="PREDICTION"||$scope.displayTypes[$scope.mlTaskDesign.predictionType]!==$scope.displayTypes[task.predictionType];newScope.descriptions.push($scope.displayTypes[task.predictionType||task.taskType]+" ("+($scope.backendTypeNames[task.backendType]||task.backendType)+")")});newScope.selectedTask=undefined}).error(setErrorInScope.bind($scope))};if(newScope.projects.some(_=>_.projectKey===$stateParams.projectKey)){newScope.selectedProjectKey=$stateParams.projectKey;newScope.analyses=$scope.analyses;newScope.selectedAnalysisId=$stateParams.analysisId;newScope.selectAnalysis()}newScope.confirm=function(){const currentIds=[$stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId];const selectedIds=[newScope.selectedProjectKey,newScope.selectedAnalysisId,newScope.selectedTask.mlTaskId];const originIds=exportSettings?currentIds:selectedIds;const destinationIds=exportSettings?selectedIds:currentIds;DataikuAPI.analysis.pml.copyAlgorithmSettings(...originIds,...destinationIds).success(function(data){if(!exportSettings){$scope.setMlTaskDesign(data);$scope.setAlgorithms($scope.mlTaskDesign)}newScope.dismiss()}).error(setErrorInScope.bind($scope));WT1.event("mltask-copy-algorithms",{export:exportSettings,sameProject:$stateParams.projectKey===newScope.selectedProjectKey,sameAnalysis:$stateParams.analysisId===newScope.selectedAnalysisId,typeDest:newScope.selectedTask.predictionType,typeSrc:$scope.mlTaskDesign.predictionType})};newScope.cancel=function(){newScope.dismiss()}})}).error(setErrorInScope.bind($scope))};$scope.displayDeepNeuralNetworkCodeEnvWarning=function(algorithm){if(!($scope.isClassicalPrediction()||$scope.isCausalPrediction())||!AlgorithmsSettingsService.getAlgorithmSettings($scope.mlTaskDesign,algorithm).enabled||!["deep_neural_network_regression","deep_neural_network_classification"].includes(algorithm.algKey)){return false}const envCompat=VisualMlCodeEnvCompatibility.getCodeEnvCompat($scope.mlTaskDesign.envSelection,$scope.codeEnvsCompat);const isEnvDeepNeuralNetworkCompatible=envCompat&&envCompat.deepNeuralNetwork&&envCompat.deepNeuralNetwork.compatible;return!isEnvDeepNeuralNetworkCompatible};$scope.displayWeightWarning=function(algorithm){return $scope.isClassicalPrediction()&&AlgorithmsSettingsService.getAlgorithmSettings($scope.mlTaskDesign,algorithm).enabled&&$scope.isSampleWeightEnabled()&&$scope.algosWithoutWeightSupport.has(algorithm.algKey)};$scope.displayTabICLExperimentalIcon=function(algorithm){return $scope.isClassicalPrediction()&&AlgorithmsSettingsService.getAlgorithmSettings($scope.mlTaskDesign,algorithm).enabled&&algorithm.algKey==="tabicl_classification"};$scope.displayTabICLEncodingWarning=function(algorithm){if(algorithm.algKey!=="tabicl_classification"||!$scope.isClassicalPrediction()||!AlgorithmsSettingsService.getAlgorithmSettings($scope.mlTaskDesign,algorithm).enabled){return false}const featuresConfig=$scope.mlTaskDesign.preprocessing&&$scope.mlTaskDesign.preprocessing.per_feature||{};return Object.values(featuresConfig).some(config=>config.role==="INPUT"&&config.type==="CATEGORY"&&config.category_handling!=="ORDINAL")};$scope.displayTabICLCodeEnvWarning=function(algorithm){if(!AlgorithmsSettingsService.getAlgorithmSettings($scope.mlTaskDesign,algorithm).enabled||!(algorithm.algKey==="tabicl_classification")||!$scope.isClassicalPrediction()){return false}const envCompat=VisualMlCodeEnvCompatibility.getCodeEnvCompat($scope.mlTaskDesign.envSelection,$scope.codeEnvsCompat);const isTabICLCompatible=envCompat&&envCompat.tabicl&&envCompat.tabicl.compatible;return!isTabICLCompatible};let customMetricDefaultCode;if($scope.isTimeseriesPrediction()){customMetricDefaultCode=`def score(y_valid, y_pred):
    """
    Custom scoring function.
    Must return a float quantifying the estimator prediction quality.
    - y_valid is a pandas Series
    - y_pred is a numpy ndarray with shape (nb_records,)

    This function is applied to each time series and then averaged over all time series.
    """`}else{customMetricDefaultCode=`def score(y_valid, y_pred):
    """
    Custom scoring function.
    Must return a float quantifying the estimator prediction quality.
    - y_valid is a pandas Series
    - y_pred is a numpy ndarray with shape:
        - (nb_records,) for regression problems and classification problems
            where 'needs probas' (see below) is false
            (for classification, the values are the numeric class indexes)
        - (nb_records, nb_classes) for classification problems where
            'needs probas' is true`;if($scope.mlTaskDesign.backendType!=="KERAS"){customMetricDefaultCode+=`
    - [optional] X_valid is a dataframe with shape (nb_records, nb_input_features)
    - [optional] sample_weight is a numpy ndarray with shape (nb_records,)
        NB: this option requires a variable set as "Sample weights"`}customMetricDefaultCode+=`
    """
        `}$scope.getNewMetricTemplate=function(){let name=StringUtils.transmogrify("Custom Metric #"+($scope.mlTaskDesign.modeling.metrics.customMetrics.length+1).toString(),$scope.mlTaskDesign.modeling.metrics.customMetrics.map(a=>a.name),function(i){return"Custom Metric #"+(i+1).toString()});const template={name:name,metricCode:customMetricDefaultCode,description:"",type:"MODEL",$foldableOpen:true,greaterIsBetter:true,needsProbability:false};return template};$scope.snippetCategory="py-scoringfunc";$scope.addNewCustomMetric=function(){if(!("customMetrics"in $scope.mlTaskDesign.modeling.metrics)){$scope.mlTaskDesign.modeling.metrics.customMetrics=[]}$scope.mlTaskDesign.modeling.metrics.customMetrics.push($scope.getNewMetricTemplate());$scope.fireCustomMetricAddedWT1Event()};$scope.fireCustomMetricAddedWT1Event=function(){WT1.event("clicked-item",{"item-id":"mltask-add-custom-metric"})};$scope.fireCustomMetricRemovedWT1Event=function(){WT1.event("clicked-item",{"item-id":"mltask-remove-custom-metric"})};$scope.toggleFoldable=function(index){if($scope.mlTaskDesign.modeling.metrics.customMetrics[index]){$scope.mlTaskDesign.modeling.metrics.customMetrics[index].$foldableOpen=!$scope.mlTaskDesign.modeling.metrics.customMetrics[index].$foldableOpen}};$scope.setEvaluationMetric=function(){let metric=$scope.uiState.evaluationMetricId;if(!metric){$scope.uiState.evaluationMetricId=PMLSettings.task.getDefaultEvaluationMetric($scope.mlTaskDesign.predictionType);metric=$scope.uiState.evaluationMetricId}if(CustomMetricIDService.checkMetricIsCustom(metric)){$scope.mlTaskDesign.modeling.metrics.customEvaluationMetricName=CustomMetricIDService.getCustomMetricName(metric);$scope.mlTaskDesign.modeling.metrics.evaluationMetric="CUSTOM"}else{$scope.mlTaskDesign.modeling.metrics.customEvaluationMetricName=undefined;$scope.mlTaskDesign.modeling.metrics.evaluationMetric=metric}}});app.controller("_DeepLearningPMLTaskResultController",function($scope){$scope.anyModelHasOneEpochFinished=function(){return($scope.selection.sessionModels||[]).some(function(model){return model.modelTrainingInfo&&model.modelTrainingInfo.epochs&&model.modelTrainingInfo.epochs.length>0})};$scope.modelEpochHasSavedModel=function(){return($scope.selection.sessionModels||[]).some(function(model){return model.modelTrainingInfo&&model.modelTrainingInfo.keptModelEpoch!==undefined&&model.modelTrainingInfo.keptModelEpoch>=0&&model.trainInfo&&model.trainInfo.state!=="ABORTED"&&model.trainInfo.state!=="FAILED"})};$scope.modelEpochHasTrainSet=function(){return modelEpochHasValue("trainScore")||modelEpochHasValue("trainLoss")};$scope.modelEpochHasValidationSet=function(){return modelEpochHasValue("testScore")||modelEpochHasValue("testLoss")};$scope.modelEpochHasLossScore=function(){return modelEpochHasValue("trainLoss")||modelEpochHasValue("testLoss")};function modelEpochHasValue(scoreName){return($scope.selection.sessionModels||[]).some(function(model){return model.modelTrainingInfo&&model.modelTrainingInfo.epochs&&model.modelTrainingInfo.epochs.some(epoch=>epoch[scoreName]!==undefined)})}$scope.anyModelHasAllEpochsFinished=function(){return($scope.selection.sessionModels||[]).some(function(model){return model.modelTrainingInfo&&model.modelTrainingInfo.nbEpochs==model.modelTrainingInfo.epochs.length||model.trainInfo&&model.trainInfo.state==="DONE"})};$scope.anyModelHasFailedOrAborted=function(){return $scope.anyModelHasFailed()||anyModelAborted()};$scope.anyModelHasFailed=function(){return($scope.selection.sessionModels||[]).some(function(model){return model.trainInfo.state==="FAILED"})};const anyModelAborted=function(){return($scope.selection.sessionModels||[]).some(function(model){return model.trainInfo.state==="ABORTED"})}});app.controller("ClassicalPMLTaskDesignController",function($scope,Fn,$controller,$state,PMLSettings){$scope.$state=$state;$controller("_TabularPMLTaskDesignController",{$scope:$scope});$scope.predictionTypes=$scope.predictionTypes.filter(type=>type.classical);$scope.isClassification=function(){if(!$scope.mlTaskDesign)return false;return PMLSettings.task.isClassification($scope.mlTaskDesign.predictionType)};$scope.uiState.generatorPage="manual_interactions";$scope.countNumericCombinations=function(){var n=Object.keys($scope.mlTaskDesign.preprocessing.per_feature).map(Fn(Fn.dict($scope.mlTaskDesign.preprocessing.per_feature),Fn.prop("type"))).filter(Fn.eq("NUMERIC")).length;return n<2?0:n*(n-1)/2};$scope.addInteraction=function(){var prep=$scope.mlTaskDesign.preprocessing;var fs=Object.keys(prep.per_feature).filter(function(f){return prep.per_feature[f].role=="INPUT"});var interaction={column_1:fs[0],column_2:fs.length>1?fs[1]:fs[0],rescale:true,max_features:100};var ints=prep.feature_generation.manual_interactions.interactions;if(!ints){ints=[];prep.feature_generation.manual_interactions.interactions=ints}ints.push(interaction)};$scope.activeFeatures=function(){var feats=[];for(var f in $scope.mlTaskDesign.preprocessing.per_feature){if($scope.mlTaskDesign.preprocessing.per_feature[f].role=="INPUT"){feats.push(f)}}feats.sort();return feats};$scope.keepNanFeatures=function(){return Object.keys($scope.mlTaskDesign.preprocessing.per_feature).filter(x=>$scope.mlTaskDesign.preprocessing.per_feature[x].role=="INPUT"&&$scope.mlTaskDesign.preprocessing.per_feature[x].type=="NUMERIC"&&["KEEP_NAN_OR_IMPUTE","KEEP_NAN_OR_DROP"].includes($scope.mlTaskDesign.preprocessing.per_feature[x].missing_handling))};$scope.removeInteraction=function(i){$scope.mlTaskDesign.preprocessing.feature_generation.manual_interactions.interactions.splice(i,1)};$scope.willDummify=function(interaction){var isNumeric=function(f){return $scope.mlTaskDesign.preprocessing.per_feature[f].type=="NUMERIC"};return!(isNumeric(interaction.column_1)&&isNumeric(interaction.column_2))};$scope.$watch("mlTaskDesign",function(nv){if(nv){$scope.uiState.predictionType=nv.predictionType;$scope.uiState.sampleWeightVariable=nv.weight.sampleWeightVariable?nv.weight.sampleWeightVariable:null;$scope.uiState.weightMethod=nv.weight.weightMethod?nv.weight.weightMethod:null;$scope.uiState.managedFolderSmartId=nv.managedFolderSmartId;if(nv.backendType==="PY_MEMORY"){$scope.uiState.hyperparamSearchStrategies=[["GRID","Grid search"],["RANDOM","Random search"],["BAYESIAN","Bayesian search"]]}else{$scope.uiState.hyperparamSearchStrategies=[["GRID","Grid search"]]}}});$scope.$watch("mlTaskDesign.time",function(nv,ov){if(nv&&ov&&nv!==ov){const splitSingleDataset=$scope.mlTaskDesign.splitParams.ttPolicy==="SPLIT_SINGLE_DATASET";if(nv.timeVariable&&nv.timeVariable!==ov.timeVariable){let featureData=$scope.mlTaskDesign.preprocessing.per_feature[nv.timeVariable];featureData.missing_handling="DROP_ROW";featureData.autoReason=null;if(splitSingleDataset){$scope.mlTaskDesign.splitParams.ssdColumn=nv.timeVariable}}if(nv.ascending!==ov.ascending&&splitSingleDataset){$scope.mlTaskDesign.splitParams.testOnLargerValues=nv.ascending}if(nv.enabled!==ov.enabled){if(nv.enabled){$scope.mlTaskDesign.splitParams.ssdSplitMode="SORTED";$scope.uiState.splitMethodDesc="Based on time variable";switch($scope.mlTaskDesign.modeling.gridSearchParams.mode){case"KFOLD":$scope.mlTaskDesign.modeling.gridSearchParams.mode="TIME_SERIES_KFOLD";break;case"SHUFFLE":$scope.mlTaskDesign.modeling.gridSearchParams.mode="TIME_SERIES_SINGLE_SPLIT";break;default:break}$scope.mlTaskDesign.splitParams.kfold=false}else{$scope.mlTaskDesign.splitParams.ssdSplitMode="RANDOM";$scope.uiState.splitMethodDesc="Randomly";switch($scope.mlTaskDesign.modeling.gridSearchParams.mode){case"TIME_SERIES_KFOLD":$scope.mlTaskDesign.modeling.gridSearchParams.mode="KFOLD";break;case"TIME_SERIES_SINGLE_SPLIT":$scope.mlTaskDesign.modeling.gridSearchParams.mode="SHUFFLE";break;default:break}$scope.mlTaskDesign.time.timeVariable=null;if($scope.mlTaskDesign.splitParams.ssdColumn){$scope.mlTaskDesign.splitParams.ssdColumn=null}}}}},true)});app.controller("PMLChangeBasicParamsModal",function($scope,$stateParams,DataikuAPI,StringUtils,Logger,AlgorithmsSettingsService){const deregister=$scope.$watch("paramKey",function(nv){if(!nv)return;$scope.recommendRedetect=false;$scope.recommendKeepSettings=true;$scope.redetectedSettings="all your design settings";let reguessMethod;switch($scope.paramKey){case"predictionType":$scope.changedParamName="prediction type";reguessMethod=DataikuAPI.analysis.pml.reguessWithType;break;case"targetVariable":$scope.changedParamName=$scope.isCausalPrediction()?"outcome":"target";reguessMethod=DataikuAPI.analysis.pml.reguessWithTarget;break;case"timeseriesIdentifiers":$scope.changedParamName="time series identifiers";reguessMethod=DataikuAPI.analysis.pml.reguessWithTimeseriesIdentifiers;break;case"timeVariable":$scope.changedParamName="time variable";reguessMethod=DataikuAPI.analysis.pml.reguessWithTimeVariable;break;case"timestepParams":$scope.changedParamName="time steps";$scope.recommendRedetect=true;$scope.recommendKeepSettings=false;$scope.redetectedSettings="the season lengths (for algorithms Seasonal naive, AutoARIMA, Seasonal trend)";reguessMethod=function(projectKey,analysisId,mlTaskId,changedParam,redetect){return DataikuAPI.analysis.pml.reguessWithTimestepParams(projectKey,analysisId,mlTaskId,changedParam,null,redetect)};break;case"predictionLength":$scope.changedParamName="forecast horizon";$scope.recommendRedetect=true;$scope.recommendKeepSettings=false;$scope.redetectedSettings="the context lengths (for algorithms NPTS, Simple Feed Forward, DeepAR, Transformer, MQ-CNN)";reguessMethod=function(projectKey,analysisId,mlTaskId,changedParam,redetect){return DataikuAPI.analysis.pml.reguessWithTimestepParams(projectKey,analysisId,mlTaskId,null,changedParam,redetect)};break;case"treatmentVariable":$scope.changedParamName="treatment variable";reguessMethod=DataikuAPI.analysis.pml.reguessWithTreatmentVariable;break;default:Logger.error("Wrong prediction parameter key: "+$scope.paramKey);return}const changedParam=$scope.uiState[$scope.paramKey];$scope.shouldRenameMLTask=$scope.paramKey==="targetVariable"||$scope.paramKey==="treatmentVariable";if($scope.shouldRenameMLTask){let suggestedName;if($scope.isTimeseriesPrediction()){suggestedName="Forecast "+changedParam}else if($scope.isCausalPrediction()){if($scope.paramKey==="targetVariable"){suggestedName=`Predict effect of ${$scope.mlTaskDesign.treatmentVariable} on `+changedParam}else if($scope.paramKey==="treatmentVariable"){suggestedName=`Predict effect of ${changedParam} on ${$scope.mlTaskDesign.targetVariable}`}}else{suggestedName="Predict "+changedParam}$scope.newName=StringUtils.transmogrify(suggestedName,$scope.mlTasksContext.analysisMLTasks.map(_=>_.name))}const classicalPredictionTypes=["BINARY_CLASSIFICATION","MULTICLASS","REGRESSION"];$scope.loseMetrics=classicalPredictionTypes.includes($scope.mlTaskDesign.predictionType)&&$scope.paramKey==="predictionType";$scope.loseAssertions=classicalPredictionTypes.includes($scope.mlTaskDesign.predictionType)&&($scope.paramKey==="predictionType"||$scope.paramKey==="targetVariable");$scope.loseOverrides=classicalPredictionTypes.includes($scope.mlTaskDesign.predictionType)&&($scope.paramKey==="predictionType"||$scope.paramKey==="targetVariable");$scope.loseAlgo=$scope.paramKey==="predictionType"&&$scope.mlTaskDesign.backendType!=="KERAS"&&["CAUSAL_REGRESSION","REGRESSION"].includes(changedParam)!==$scope.isRegression();$scope.loseArchitecture=$scope.mlTaskDesign.backendType==="KERAS";if($scope.paramKey==="targetVariable"&&$scope.mlTaskDesign.weight){$scope.loseWeight=$scope.mlTaskDesign.weight.sampleWeightVariable===changedParam}if($scope.paramKey==="predictionType"){$scope.loseWeight=$scope.mlTaskDesign.weight&&["CLASS_WEIGHT","CLASS_AND_SAMPLE_WEIGHT"].includes($scope.mlTaskDesign.weight.weightMethod)&&$scope.loseAlgo}$scope.loseGapSize=$scope.paramKey==="predictionLength"&&$scope.mlTaskDesign.evaluationParams.gapSize>changedParam-1;$scope.swapTreatmentAndOutcome=$scope.paramKey==="targetVariable"&&$scope.mlTaskDesign.treatmentVariable===changedParam;$scope.loseSomeSettings=$scope.loseMetrics||$scope.loseAlgo||$scope.loseWeight||$scope.loseArchitecture||$scope.loseAssertions||$scope.loseOverrides||$scope.loseGapSize||$scope.swapTreatmentAndOutcome;$scope.confirm=function(redetect){reguessMethod($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId,changedParam,redetect).then(function(response){$scope.setMlTaskDesign(response.data);if($scope.shouldRenameMLTask){$scope.mlTaskDesign.name=$scope.newName}if($scope.mlTaskDesign.backendType==="KERAS"){$scope.fillBuildCodeKeras(true)}$scope.setAlgorithms($scope.mlTaskDesign);$scope.setSelectedAlgorithm(AlgorithmsSettingsService.getDefaultAlgorithm($scope.mlTaskDesign,$scope.algorithms[$scope.mlTaskDesign.backendType]));$scope.fillUISplitParams($scope.mlTaskDesign.splitParams);$scope.saveSettings().then($scope.dismiss)},function(data,status,headers){setErrorInScope.bind($scope)(data,status,headers)})};$scope.$on("$destroy",function(){const getUIStateParam=$scope.getUIStateParam||(param=>param);$scope.uiState[$scope.paramKey]=getUIStateParam($scope.mlTaskDesign[$scope.paramKey]);$scope.onCloseCallback&&$scope.onCloseCallback()});deregister()})});app.controller("PMLTaskPreTrainModal",function($scope,$stateParams,$controller,$filter,DataikuAPI,GPU_SUPPORTING_CAPABILITY,GpuUsageService){$controller("_PMLTaskWithK8sContainerInformationController",{$scope:$scope});$scope.GPU_SUPPORTING_CAPABILITY=GPU_SUPPORTING_CAPABILITY;$scope.uiState={confirmRun:false,gpu:{name:getGpuTitle()}};$scope.getPreTrainStatus=function(){DataikuAPI.analysis.pml.getPreTrainStatus($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId).success(function(data){$scope.preTrainStatus=data;$scope.splitStatus=data.splitStatus;$scope.uiState.anyError=data.messages.some(x=>x.severity=="ERROR");$scope.uiState.anyWarning=data.messages.some(x=>x.severity=="WARNING")}).error(setErrorInScope.bind($scope))};$scope.updatePreTrainStatus=function(){$scope.saveSettings().then(x=>{$scope.getPreTrainStatus()})};$scope.getPreTrainStatus();$scope._doTrainThenResolveModal=function(){$scope._doTrain().then($scope.resolveModal)};$scope.useExtracts=function(){return $scope.splitStatus.isKFold||$scope.isTimeseriesPrediction()};$scope.shouldDisableTrain=function(gpuCapability){return gpuCapability&&$scope.mlTaskDesign.gpuConfig.params.useGpu&&!$scope.mlTaskDesign.gpuConfig.params.gpuList.length};$scope.availableGpuCapabilities=$scope.getAvailableGpuCapabilities();$scope.usedGpuCapabilities=$scope.getUsedGpuCapabilities();$scope.usedGpuCapabilitiesWithGpuOn=$scope.getUsedGpuCapabilitiesWithGpuOn();$scope.showGpuCapabilityWarning=function(){return $scope.mlTaskDesign.gpuConfig.params.useGpu&&$scope.usedGpuCapabilitiesWithGpuOn.length===0&&$scope.usedGpuCapabilities.length>0};function getGpuTitle(){let title="Activate GPU";const usedGpuCapabilitiesWithGpuOn=$scope.getUsedGpuCapabilitiesWithGpuOn();if(usedGpuCapabilitiesWithGpuOn.length>0){title+=" for ";title+=$filter("andList")(getGpuCapabilityActivityNames(usedGpuCapabilitiesWithGpuOn))}return title}function getGpuCapabilityActivityNames(gpuCapabilities){const formattedNames=[];for(const item of gpuCapabilities){formattedNames.push(GpuUsageService.CAPABILITIES[item].name)}return formattedNames}});app.controller("_ClassicalPMLTaskPreTrainBase",function($scope,$stateParams,$controller,WT1,Logger,DataikuAPI){$controller("_TabularPMLTaskPreTrainBase",{$scope:$scope});$scope._doTrain=function(){try{const algorithms={};$.each($scope.mlTaskDesign.modeling,function(alg,params){if(params.enabled){algorithms[alg]=params}});$.each($scope.mlTaskDesign.modeling.custom_python,function(algNum,params){if(params.enabled){algorithms["CUSTOM_PYTHON_"+algNum]=params}});$.each($scope.mlTaskDesign.modeling.custom_mllib,function(algNum,params){if(params.enabled){algorithms["CUSTOM_MLLIB_"+algNum]=params}});$.each($scope.mlTaskDesign.modeling.plugin_python,function(alg,params){if(params.enabled){algorithms[alg]=params}});function redactSensitiveInformation(eventContent){const redacted=dkuDeepCopy(eventContent,$scope.SettingsService.noDollarKey);if(redacted.metrics){if(redacted.metrics.customMetrics){redacted.metrics.customMetrics.forEach(item=>{delete item.name;delete item.description;delete item.metricCode})}}if(redacted.algorithms){if(redacted.algorithms.keras){delete redacted.algorithms.keras.buildCode;delete redacted.algorithms.keras.fitCode;delete redacted.algorithms.keras.kerasInputs}for(const algorithm in redacted.algorithms){if(algorithm.includes("CUSTOM_PYTHON_")){delete redacted.algorithms[algorithm].name;delete redacted.algorithms[algorithm].code}else if(algorithm.includes("CUSTOM_MLLIB_")){delete redacted.algorithms[algorithm].initializationCode}}}if(redacted.feature_selection_params&&redacted.feature_selection_params.custom_params){delete redacted.feature_selection_params.custom_params.code}if(redacted.feature_generation&&redacted.feature_generation.manual_interactions&&redacted.feature_generation.manual_interactions.interactions){for(const interaction of redacted.feature_generation.manual_interactions.interactions){delete interaction.column_1;delete interaction.column_2}}return redacted}let wt1Content=redactSensitiveInformation({backendType:$scope.mlTaskDesign.backendType,taskType:$scope.mlTaskDesign.taskType,predictionType:$scope.mlTaskDesign.predictionType,guessPolicy:$scope.mlTaskDesign.guessPolicy,feature_generation:$scope.mlTaskDesign.preprocessing.feature_generation,feature_selection_params:$scope.mlTaskDesign.preprocessing.feature_selection_params,algorithms:algorithms,metrics:$scope.mlTaskDesign.modeling.metrics,weightMethod:$scope.mlTaskDesign.weight.weightMethod,hasSessionName:!!$scope.uiState.userSessionName,hasSessionDescription:!!$scope.uiState.userSessionDescription,calibrationMethod:$scope.mlTaskDesign.calibration.calibrationMethod,hasTimeOrdering:$scope.mlTaskDesign.time.enabled,gridSearchParams:$scope.mlTaskDesign.modeling.gridSearchParams,runsOnKubernetes:$scope.hasSelectedK8sContainer(),assertionsParams:aggregateAssertionsParams(),overridesParams:aggregateOverridesParams(),monotonicConstraintParams:aggregateMonotonicConstraintParams()});WT1.event("prediction-train",wt1Content)}catch(e){Logger.error("Failed to report mltask info",e)}return DataikuAPI.analysis.pml.trainStart($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId,$scope.uiState.userSessionName,$scope.uiState.userSessionDescription,$scope.uiState.forceRefresh,true).error(setErrorInScope.bind($scope))};function aggregateConditionsParams(params,modesKey){let modes={};params.map(a=>a.filter.uiData.mode).forEach(val=>modes[val]=(modes[val]||0)+1);let out={count:params.length||0};out[modesKey]=modes;return out}function aggregateAssertionsParams(){return aggregateConditionsParams($scope.mlTaskDesign.assertionsParams.assertions,"assertionsConditionsModes")}function aggregateOverridesParams(){return aggregateConditionsParams($scope.mlTaskDesign.overridesParams.overrides,"overridesConditionsModes")}function aggregateMonotonicConstraintParams(){const perFeatureParams=$scope.mlTaskDesign.preprocessing.per_feature;const increaseConstraints=Object.keys(perFeatureParams).filter(col=>perFeatureParams[col].role==="INPUT"&&perFeatureParams[col].monotonic&&perFeatureParams[col].monotonic==="INCREASE");const decreaseConstraints=Object.keys(perFeatureParams).filter(col=>perFeatureParams[col].role==="INPUT"&&perFeatureParams[col].monotonic&&perFeatureParams[col].monotonic==="DECREASE");return{total:increaseConstraints.length+decreaseConstraints.length,increase:increaseConstraints.length,decrease:decreaseConstraints.length}}$scope.displayMessages=function(){return $scope.preTrainStatus.messages.length||$scope.mlTaskDesign.modeling.xgboost.enable_cuda||$scope.uiState.selectedAlgorithmsWithWeightIncompatibility.length}});app.controller("_TabularPMLTaskPreTrainBase",function($scope,$stateParams,DataikuAPI){$scope.enqueue=function(){DataikuAPI.analysis.pml.enqueueSession($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId,!$scope.mlTaskStatus.training,$scope.uiState.userSessionName,$scope.uiState.userSessionDescription,$scope.uiState.forceRefresh).success(function(){$scope.resolveModal();$scope.listQueuedSessions()}).error(setErrorInScope.bind($scope))};$scope.getModelStr=pluralize=>{let modelStr;if($scope.preTrainStatus&&$scope.preTrainStatus.partitionedModelEnabled){modelStr="partitioned model"}else{modelStr="model"}if(pluralize){modelStr+="s"}return modelStr}});app.controller("ClassicalPMLTaskPreTrainModal",function($scope,$state,$controller){$controller("PMLTaskPreTrainModal",{$scope:$scope});$controller("_ClassicalPMLTaskPreTrainBase",{$scope:$scope});$scope.train=function(){if(!$scope.isMLBackendType("KERAS")){if($scope.dirtySettings()){$scope.saveSettings().then(()=>$scope._doTrainThenResolveModal())}else{$scope._doTrainThenResolveModal()}return}$scope.saveSettings().then(function(){if($scope.recipe.params&&$scope.recipe.params.skipPrerunValidate){$scope._doTrainThenResolveModal()}else{$scope.validateRecipe().then(function(validationResult){if(!validationResult.topLevelMessages||!validationResult.topLevelMessages.maxSeverity||validationResult.topLevelMessages.maxSeverity==="OK"){$scope._doTrainThenResolveModal()}else{$state.go("projects.project.analyses.analysis.ml.predmltask.list.design.classical-keras-build",{projectKey:$scope.projectSummary.projectKey,analysisId:$scope.analysisCoreParams.id,mlTaskId:$scope.mlTaskDesign.id}).then(()=>{$scope.valCtx.showPreRunValidationError=true;$scope.dismiss()})}})}})};$scope.uiState.selectedAlgorithmsWithWeightIncompatibility=[];if($scope.isSampleWeightEnabled()){$scope.base_algorithms[$scope.mlTaskDesign.backendType].forEach(function(x){const unsupportedAlgo=$scope.algosWithoutWeightSupport&&$scope.algosWithoutWeightSupport.has(x.algKey);if($scope.mlTaskDesign.modeling[x.algKey]&&$scope.mlTaskDesign.modeling[x.algKey].enabled&&unsupportedAlgo){$scope.uiState.selectedAlgorithmsWithWeightIncompatibility.push(x.name)}const algoInPluginsAndEnabled=$scope.mlTaskDesign.modeling["plugin_python"]&&$scope.mlTaskDesign.modeling["plugin_python"][x.algKey]&&$scope.mlTaskDesign.modeling["plugin_python"][x.algKey].enabled;if(algoInPluginsAndEnabled&&unsupportedAlgo){$scope.uiState.selectedAlgorithmsWithWeightIncompatibility.push(x.name)}})}});app.controller("KerasPMLTaskPreTrain",function($scope,$controller){$controller("_ClassicalPMLTaskPreTrainBase",{$scope:$scope});$scope.forceKerasTrain=function(){$scope._doTrain().then(function(){$scope.refreshMLTaskSessions()})}});app.directive("mlParamWithFilterCard",function(){return{scope:{it:"=",delete:"&",recipeVariables:"<",postScriptFeaturesSchema:"<",sortable:"<"},transclude:true,templateUrl:"/templates/analysis/mlcommon/settings/ml-param-with-filter-card.html"}});app.component("mlRangeCondition",{bindings:{minValue:"=",maxValue:"="},templateUrl:"/templates/analysis/mlcommon/settings/ml-range-condition.html",controller:function(){const $ctrl=this;$ctrl.isInvalidMinMax=function(){if(angular.isUndefined($ctrl.minValue)||angular.isUndefined($ctrl.maxValue)){return false}return $ctrl.minValue>=$ctrl.maxValue}}});app.component("mlAssertionCondition",{bindings:{condition:"=",isClassification:"&",classes:"<",percentage:"<"},templateUrl:"/templates/analysis/mlcommon/settings/ml-assertion-condition.html",controller:function(){const $ctrl=this}});app.component("mlOverrideCondition",{bindings:{outcome:"=",targetVariable:"<",isClassification:"<",classes:"<"},templateUrl:"/templates/analysis/mlcommon/settings/ml-override-condition.html",controller:function(){const $ctrl=this;$ctrl.$onInit=function(){$ctrl.policies={DECLINED:"Declined"};if($ctrl.isClassification){$ctrl.policies["CATEGORY"]="Enforced Category"}else{$ctrl.policies["INTERVAL"]="Enforced Interval"}}}});app.service("MlParamsWithFilterService",function(DataikuAPI,StringUtils,Logger){const svc=this;svc.prepare=function(scope,projectKey,analysisId,extraColumns=[]){scope.isClassification=()=>{return scope.mlTaskDesign&&scope.mlTaskDesign.predictionType!=="REGRESSION"};DataikuAPI.analysis.getPostScriptSchema(projectKey,analysisId).success(function(data){scope.postScriptFeaturesSchema=data;scope.postScriptFeaturesSchema.columns.splice(scope.postScriptFeaturesSchema.columns.map(column=>column.name).indexOf(scope.mlTaskDesign.targetVariable),1);svc.enrichPostScriptSchemaWithExtraColumns(scope.postScriptFeaturesSchema,extraColumns)});scope.classes=scope.mlTaskDesign.preprocessing.target_remapping.map(clss=>clss.sourceValue)};svc.enrichPostScriptSchemaWithExtraColumns=function(postScriptSchema,extraColumns){if(!extraColumns||!extraColumns.length){return}const group_computed="Computed";const group_features="Features";const extraColumnsWithGroup=extraColumns.map(col=>({...col,$$groupKey:group_computed}));const featuresWithGroup=postScriptSchema.columns.map(col=>({...col,$$groupKey:group_features}));postScriptSchema.columns=extraColumnsWithGroup.concat(featuresWithGroup);postScriptSchema.columns.sort((a,b)=>{if(a.$$groupKey===group_computed&&b.$$groupKey!==group_computed)return-1;if(b.$$groupKey===group_computed&&a.$$groupKey!==group_computed)return 1;return 0})};svc.columnAnalysis=function(scope,projectKey){return DataikuAPI.shakers.detailedColumnAnalysis(projectKey,scope.analysisCoreParams.projectKey,scope.analysisCoreParams.inputDatasetSmartName,scope.analysisCoreParams.script,null,scope.mlTaskDesign.targetVariable,50)};svc.createAddNewParamWithFilterCallback=function(paramName,paramsWithFilter,isClassification,targetColumnAnalysisCallback,setupDefaultClassifParamCallback,setupDefaultRegressionParamCallback){let minValueTarget=0;let maxValueTarget=100;if(!isClassification){targetColumnAnalysisCallback().success(function(data){minValueTarget=data.numericalAnalysis.min;maxValueTarget=data.numericalAnalysis.max}).error(function(error){Logger.error("Failed to compute min and max of target variable. Putting arbitrary values for override",error)})}return function(){let newParamWithFilter={filter:{enabled:true},name:StringUtils.transmogrify(`${paramName} ${paramsWithFilter.length+1}`,paramsWithFilter.map(a=>a.name),function(i){return`${paramName} ${i+1}`}),outcome:{}};if(isClassification){setupDefaultClassifParamCallback(newParamWithFilter)}else{setupDefaultRegressionParamCallback(newParamWithFilter,minValueTarget,maxValueTarget)}paramsWithFilter.push(newParamWithFilter)}};svc.createAddNewOverrideParamCallback=function(overrides,isClassification,targetColumnAnalysisCallback,classes){return svc.createAddNewParamWithFilterCallback("Override",overrides,isClassification,targetColumnAnalysisCallback,newOverride=>{newOverride.outcome={type:"CATEGORY",category:classes[0]}},(newOverride,minValueTarget,maxValueTarget)=>{newOverride.outcome={type:"INTERVAL",minValue:Math.round(minValueTarget),maxValue:Math.round(maxValueTarget)}})}});app.controller("PMLTaskAssertionsController",function($scope,StringUtils,$stateParams,MlParamsWithFilterService){MlParamsWithFilterService.prepare($scope,$stateParams.projectKey,$stateParams.analysisId);$scope.addNewMlAssertion=MlParamsWithFilterService.createAddNewParamWithFilterCallback("Assertion",$scope.mlTaskDesign.assertionsParams&&$scope.mlTaskDesign.assertionsParams.assertions,$scope.isClassification(),()=>MlParamsWithFilterService.columnAnalysis($scope,$stateParams.projectKey),newAssertion=>{newAssertion.assertionCondition={expectedValidRatio:.9,expectedClass:$scope.classes[0]}},(newAssertion,minValueTarget,maxValueTarget)=>{newAssertion.assertionCondition={expectedValidRatio:.9,expectedMinValue:Math.round(minValueTarget),expectedMaxValue:Math.round(maxValueTarget)}})});app.component("modelOverridesInfoBox",{bindings:{isClassification:"<"},templateUrl:"/templates/analysis/prediction/settings/model-overrides-info-box.html"});app.controller("PMLModelOverridesController",function($scope,$stateParams,MlParamsWithFilterService,OverridesExtraColumnsService){const extraColumns=OverridesExtraColumnsService.getExtraColumnsFromMLTaskDesign($scope.mlTaskDesign);MlParamsWithFilterService.prepare($scope,$stateParams.projectKey,$stateParams.analysisId,extraColumns);$scope.getOverridesNotAvailableReason=function(){if(typeof $scope.mlTaskDesign.partitionedModel!=="undefined"&&$scope.mlTaskDesign.partitionedModel.enabled){return"Overrides are not available for partitioned models"}if($scope.mlTaskDesign.taskType==="CLUSTERING"){return"Overrides are not available for clustering"}if($scope.isMLBackendType("KERAS")){return"Overrides are not available for KERAS models"}if($scope.isMLBackendType("DEEP_HUB")){return"Overrides are not available for computer vision models"}};$scope.addNewMlOverride=MlParamsWithFilterService.createAddNewOverrideParamCallback($scope.mlTaskDesign.overridesParams.overrides,$scope.isClassification(),()=>MlParamsWithFilterService.columnAnalysis($scope,$stateParams.projectKey),$scope.classes)});app.controller("_K8sConfigurationCheckerController",($scope,$stateParams,DataikuAPI)=>{let k8sContainerNames=[];let defaultContainerName=null;DataikuAPI.containers.listNamesWithDefault($stateParams.projectKey,"KUBERNETES","USER_CODE").success(data=>{k8sContainerNames=data.containerNames;defaultContainerName=data.resolvedInheritValue}).error(setErrorInScope.bind($scope));$scope.isK8sContainer=(backendType,containerSelection)=>{if(!["PY_MEMORY","KERAS"].includes(backendType)){return false}switch(containerSelection.containerMode){case"EXPLICIT_CONTAINER":return k8sContainerNames.includes(containerSelection.containerConf);case"INHERIT":return k8sContainerNames.includes(defaultContainerName);default:return false}}});app.controller("_PMLTaskWithK8sContainerInformationController",($scope,$controller)=>{$controller("_K8sConfigurationCheckerController",{$scope:$scope});$scope.hasSelectedK8sContainer=()=>{const{backendType,containerSelection}=$scope.mlTaskDesign;return $scope.isK8sContainer(backendType,containerSelection)}});app.controller("PMLTaskHyperparametersController",($scope,$controller,DataikuAPI,$stateParams,VisualMlCodeEnvCompatibility,Debounce)=>{$controller("PMLTaskCrossvalController",{$scope:$scope});$controller("_PMLTaskWithK8sContainerInformationController",{$scope:$scope});$scope.$watch("mlTaskDesign.modeling.gridSearchParams.mode",function(nv,ov){if(nv==="CUSTOM"&&!$scope.mlTaskDesign.modeling.gridSearchParams.code){$scope.mlTaskDesign.modeling.gridSearchParams.code="# Define an object named cv that follows the scikit-learn splitter protocol\n"+"# This example uses the 'repeated K-fold' splitter of scikit-learn\n"+"from sklearn.model_selection import RepeatedKFold\n"+"\n"+"cv = RepeatedKFold(n_splits=3, n_repeats=5)"}});$scope.onChangeSearchConstraints=Debounce().withDelay(0,400).wrap(function(searchConstraint){if(searchConstraint===null||searchConstraint===undefined)return;$scope.checkIfHPSearchIsNeeded()})});app.component("searchStrategyWarnings",{bindings:{mlTaskDesign:"<",codeEnvsCompat:"<",runtimeEnvironmentUiSref:"@"},templateUrl:"/templates/analysis/prediction/settings/search-strategy-warnings.html",controller:function($scope,$rootScope,$stateParams,DataikuAPI,VisualMlCodeEnvCompatibility){const ctrl=this;ctrl.showBayesianSearchWarning=showBayesianSearchWarning;let previousStrategy=null;ctrl.$onInit=()=>{previousStrategy=ctrl.mlTaskDesign.modeling.gridSearchParams.strategy;ctrl.algosIncompatibleWithSearchStrategy=[];retrieveAlgosIncompatibleWithSearchStrategy()};ctrl.$doCheck=()=>{if(!angular.equals(ctrl.mlTaskDesign.modeling.gridSearchParams.strategy,previousStrategy)){retrieveAlgosIncompatibleWithSearchStrategy();previousStrategy=ctrl.mlTaskDesign.modeling.gridSearchParams.strategy}};function showBayesianSearchWarning(){if(!ctrl.mlTaskDesign||!ctrl.mlTaskDesign.envSelection||!ctrl.codeEnvsCompat)return false;const envCompat=VisualMlCodeEnvCompatibility.getCodeEnvCompat(ctrl.mlTaskDesign.envSelection,ctrl.codeEnvsCompat);const isCodeEnvCompatibleWithBayesian=envCompat&&envCompat.bayesianSearch&&envCompat.bayesianSearch.compatible;return!$rootScope.appConfig.isAutomation&&ctrl.mlTaskDesign.modeling.gridSearchParams.strategy==="BAYESIAN"&&!isCodeEnvCompatibleWithBayesian}function retrieveAlgosIncompatibleWithSearchStrategy(){if(!ctrl.mlTaskDesign){return}DataikuAPI.analysis.pml.listAlgosIncompatibleWithSearchStrategy($stateParams.projectKey,ctrl.mlTaskDesign).then(response=>{ctrl.algosIncompatibleWithSearchStrategy=Object.entries(response.data).map(([name,strategy])=>{return{name:name,strategy:strategy}})}).catch(setErrorInScope.bind($scope))}}});app.constant("DEEPHUB_PREDICTION_TYPE_CODE_ENV_TYPE",{DEEP_HUB_IMAGE_OBJECT_DETECTION:"DEEP_HUB_IMAGE_OBJECT_DETECTION_CODE_ENV",DEEP_HUB_IMAGE_CLASSIFICATION:"DEEP_HUB_IMAGE_CLASSIFICATION_CODE_ENV"});app.controller("PMLTaskRuntimeController",($scope,$controller,DataikuAPI,DEEPHUB_PREDICTION_TYPE_CODE_ENV_TYPE)=>{$controller("_PMLTaskWithK8sContainerInformationController",{$scope:$scope});const updateHpSearchDistribution=(newSelection,oldSelection)=>{if(angular.equals(newSelection,oldSelection)){return}const searchParams=$scope.mlTaskDesign.modeling.gridSearchParams;if(!searchParams){return}searchParams.distributed=searchParams.distributed&&$scope.hasSelectedK8sContainer()};$scope.$watch("mlTaskDesign.containerSelection",updateHpSearchDistribution,true);$scope.checkDeepHubCodeEnvCallback=function(scope){scope.deepHubCodeEnv=undefined;scope.isDeepHubCodeEnvAvailable=()=>scope.deepHubCodeEnv!==undefined;scope.getHumanReadablePredictionType=function(){switch($scope.mlTaskDesign.predictionType){case"DEEP_HUB_IMAGE_OBJECT_DETECTION":return"object detection";case"DEEP_HUB_IMAGE_CLASSIFICATION":return"image classification"}return $scope.mlTaskDesign.predictionType};function checkDeepHubCodeEnv(codeEnvVersion){DataikuAPI.codeenvs.checkDSSInternalCodeEnv(DEEPHUB_PREDICTION_TYPE_CODE_ENV_TYPE[$scope.mlTaskDesign.predictionType],codeEnvVersion).then(function({data}){if(Object.keys(data).length>0){scope.deepHubCodeEnv=data.value}}).catch(setErrorInScope.bind(scope))}const isDeepHubTask=$scope.mlTaskDesign.predictionType.startsWith("DEEP_HUB_");scope.showDeepHubCodeEnvWarning=function(){return isDeepHubTask&&(scope.envSelection.envMode!=="EXPLICIT_ENV"||scope.isDeepHubCodeEnvAvailable()&&scope.envSelection.envName!==scope.deepHubCodeEnv.envName||!scope.isDeepHubCodeEnvAvailable())};if(isDeepHubTask){checkDeepHubCodeEnv()}};$scope.availableGpuCapabilities=$scope.getAvailableGpuCapabilities();$scope.usedGpuCapabilities=$scope.getUsedGpuCapabilities();$scope.usedGpuCapabilitiesWithGpuOn=$scope.getUsedGpuCapabilitiesWithGpuOn();$scope.refreshEnabledGpuCapabilities=function(){$scope.usedGpuCapabilitiesWithGpuOn=$scope.getUsedGpuCapabilitiesWithGpuOn()};$scope.isProphetEnabled=function(){if(!$scope.mlTaskDesign||!$scope.mlTaskDesign.modeling)return false;return $scope.mlTaskDesign.modeling.prophet_timeseries&&$scope.mlTaskDesign.modeling.prophet_timeseries.enabled}});app.controller("PMLTaskCrossvalController",function($scope,$stateParams,DataikuAPI,DatasetUtils,Dialogs,SamplingData,TimeseriesForecastingUtils,$timeout,TimeseriesForecastingCustomTrainTestFoldsUtils){var datasetLoc=DatasetUtils.getLocFromSmart($stateParams.projectKey,$scope.analysisCoreParams.inputDatasetSmartName);DataikuAPI.datasets.get(datasetLoc.projectKey,datasetLoc.name,$stateParams.projectKey).success(function(data){$scope.analysisDataset=data}).error(setErrorInScope.bind($scope));let resamplingParams=$scope.mlTaskDesign.preprocessing.timeseriesSampling;$scope.propagateCustomStartDateUpdate=function(){$timeout(function(){$scope.mlTaskDesign.preprocessing.timeseriesSampling.customStartDate=$scope.customStartDate?$scope.formatDateWithoutTimezone($scope.customStartDate):undefined})};$scope.propagateCustomEndDateUpdate=function(){$timeout(function(){$scope.mlTaskDesign.preprocessing.timeseriesSampling.customEndDate=$scope.customEndDate?$scope.formatDateWithoutTimezone($scope.customEndDate):undefined})};if(resamplingParams!=null){$scope.customStartDate=resamplingParams.customStartDate&&TimeseriesForecastingCustomTrainTestFoldsUtils.forceConvertToUTCTimezoneDate(resamplingParams.customStartDate)||new Date;$scope.customEndDate=resamplingParams.customEndDate&&TimeseriesForecastingCustomTrainTestFoldsUtils.forceConvertToUTCTimezoneDate(resamplingParams.customEndDate)||new Date}$scope.getPartitionsList=function(){return DataikuAPI.datasets.listPartitionsWithName(datasetLoc.projectKey,datasetLoc.name).error(setErrorInScope.bind($scope)).then(function(ret){return ret.data})};$scope.checkIfHPSearchIsNeeded=function(){DataikuAPI.analysis.pml.isHPSearchNeeded($stateParams.projectKey,$scope.mlTaskDesign).then(function(response){$scope.isHPSearchNeeded=response.data.isHPSearchNeeded}).catch(setErrorInScope.bind($scope))};$scope.checkIfHPSearchIsNeeded();$scope.isTimeseriesForecastWithBothKFold=function(){if(!$scope.isTimeseriesPrediction())return false;return $scope.isHPSearchNeeded&&!$scope.mlTaskDesign.customTrainTestSplit&&$scope.mlTaskDesign.splitParams.kfold&&$scope.mlTaskDesign.modeling.gridSearchParams.mode==="TIME_SERIES_KFOLD"};$scope.prettyTimeSteps=TimeseriesForecastingUtils.prettyTimeSteps;$scope.$watch("uiSplitParams.policy",function(nv,ov){if(!nv)return;if(nv=="EXPLICIT_FILTERING_TWO_DATASETS"){if(!$scope.mlTaskDesign.splitParams.eftdTrain){$scope.mlTaskDesign.splitParams.eftdTrain={datasetSmartName:$scope.analysisCoreParams.inputDatasetSmartName,selection:DatasetUtils.makeHeadSelection(1e5)}}if(!$scope.mlTaskDesign.splitParams.eftdTest){$scope.mlTaskDesign.splitParams.eftdTest={selection:DatasetUtils.makeHeadSelection(1e5)}}}else if(nv.indexOf("EXPLICIT_FILTERING_SINGLE_DATASET")==0){if(!$scope.mlTaskDesign.splitParams.efsdTrain){$scope.mlTaskDesign.splitParams.efsdTrain={selection:DatasetUtils.makeHeadSelection(1e5)}}if(!$scope.mlTaskDesign.splitParams.efsdTest){$scope.mlTaskDesign.splitParams.efsdTest={selection:DatasetUtils.makeHeadSelection(1e5)}}}else if(nv=="SPLIT_OTHER_DATASET"){if(!$scope.mlTaskDesign.splitParams.ssdDatasetSmartName){$scope.mlTaskDesign.splitParams.ssdDatasetSmartName=$scope.analysisCoreParams.inputDatasetSmartName}}if(nv!="SPLIT_MAIN_DATASET"&&$scope.mlTaskDesign.partitionedModel&&$scope.mlTaskDesign.partitionedModel.enabled){const choices=[{revert:false,title:"Disable partitioning & keep this policy",desc:($scope.trainTestPolicies.find(_=>_[0]===nv)||[_,nv])[1]},{revert:true,title:"Keep partitioning & revert policy",desc:$scope.trainTestPolicies[0][1]}];function act(choice){if(choice.revert){$scope.uiSplitParams.policy="SPLIT_MAIN_DATASET"}else{$scope.mlTaskDesign.partitionedModel.enabled=false}}Dialogs.select($scope,"Change train/test policy","Model partitioning is enabled, but not compatible with this policy.",choices,choices[0]).then(act,act.bind(null,choices[1]))}});$scope.canCustomizeResamplingDates=function(){return $scope.mlTaskDesign.preprocessing.timeseriesSampling.numericalExtrapolateMethod!=="NO_EXTRAPOLATION"};DatasetUtils.listDatasetsUsabilityForAny($stateParams.projectKey).success(function(data){$scope.availableDatasets=data;$scope.availableDatasetsExceptForInputDataset=$scope.availableDatasets.filter(function(d){return d.smartName!==$scope.analysisCoreParams.inputDatasetSmartName});data.forEach(function(ds){ds.usable=true})});$scope.potentialTimeFeatures=function(){const per_feature=$scope.mlTaskDesign.preprocessing.per_feature;if($scope.analysisDataset){const inputColumns=$scope.analysisDataset.schema.columns.map(col=>col.name);return inputColumns.filter(col=>per_feature[col]&&per_feature[col].role!=="TARGET")}};$scope.getSamplingMethodLabel=function(){return SamplingData.getSamplingMethodForDocumentation($scope.mlTaskDesign.splitParams.ssdSelection)};$scope.getCrossValidationLabel=function(){let crossValidationLabel;if($scope.mlTaskDesign.time&&$scope.mlTaskDesign.time.enabled){crossValidationLabel=$scope.getCrossvalModesWithTimeForDocumentation($scope.mlTaskDesign.modeling.gridSearchParams.mode,$scope.mlTaskDesign)}else{crossValidationLabel=$scope.getCrossvalModesRandomForDocumentation($scope.mlTaskDesign.modeling.gridSearchParams.mode,$scope.mlTaskDesign)}return crossValidationLabel};$scope.getHyperparametersBarsMaxWidth=function(){return $scope.mlTaskDesign.splitParams.kfold?1:$scope.mlTaskDesign.splitParams.ssdTrainingRatio};$scope.deferredAfterInitMlTaskDesign.then(()=>{$scope.groupKFoldColumnNames=Object.keys($scope.mlTaskDesign.preprocessing.per_feature).filter(function(name){if($scope.isCausalPrediction()&&name===$scope.mlTaskDesign.treatmentVariable){return false}return $scope.mlTaskDesign.targetVariable!==name})})});app.controller("PMLTaskFeatureSelectionController",function($scope,$controller,$timeout,$stateParams,DataikuAPI,Dialogs){$scope.featureSelectionKinds=[["NONE","No reduction"],["CORRELATION","Correlation with target"],["RANDOM_FOREST","Tree-based"],["PCA","Principal Component Analysis"],["ICA","Independent Component Analysis"]];if(!$scope.isMulticlass()&&$scope.mlTasksContext&&$scope.mlTasksContext.activeMLTask&&$scope.mlTasksContext.activeMLTask.backendType=="PY_MEMORY"){$scope.featureSelectionKinds.push(["LASSO","LASSO regression"])}$scope.puppeteerHook_elementContentLoaded=true});app.controller("_PMLTargetRemappingController",function($scope,Assert,Fn){Assert.inScope($scope,"mlTaskDesign");function updateGraph(){try{const totalCount=$scope.mlTaskDesign.preprocessing.target_remapping.map(Fn.prop("sampleFreq")).reduce(Fn.SUM);$scope.graphData=$scope.mlTaskDesign.preprocessing.target_remapping.map(function(x){return[x.sourceValue,x.sampleFreq/totalCount]})}catch(e){}}$scope.$watch("mlTaskDesign.preprocessing.target_remapping",updateGraph,false);$scope.editMapping={active:false,value:null};$scope.startEditMapping=function(){$scope.editMapping.active=true;$scope.editMapping.value=$scope.mlTaskDesign.preprocessing.target_remapping};$scope.$watch("editMapping.value",function(nv,ov){if(!nv)$scope.editMapping.error=true;else $scope.editMapping.error=false},true);$scope.okEditMapping=function(){$scope.editMapping.active=false;$scope.mlTaskDesign.preprocessing.target_remapping=$scope.editMapping.value;updateGraph()};$scope.cancelEditMapping=function(){$scope.editMapping.active=false};updateGraph();$scope.hasManyCategories=function(){return $scope.mlTaskDesign.preprocessing.target_remapping.length>=50}});app.controller("TabularPMLTargetRemappingController",function($scope,$controller){$scope.colors=window.dkuColorPalettes.discrete[0].colors.filter(function(c,i){return i%2===0});$controller("_PMLTargetRemappingController",{$scope:$scope})});app.controller("PMLSparkConfigController",function($scope,Assert,DataikuAPI,Fn){Assert.inScope($scope,"mlTaskDesign");$scope.sparkConfs=["default"];DataikuAPI.admin.getGeneralSettings().success(function(data){$scope.sparkConfs=data.sparkSettings.executionConfigs.map(Fn.prop("name"))})});app.directive("tensorboardDestroyHandler",function(){return{link:function($scope,elem,attr){elem.on("$destroy",function(){$scope.sessionTask.tensorboardStatus.isFrontendReady=false;$scope.sessionTask.tensorboardStatus.showIfFrontIsNotReady=true})}}});app.controller("LightGBMHyperparametersController",function($scope){const{lightgbm_regression,lightgbm_classification}=$scope.mlTaskDesign.modeling;$scope.hpSpace=$scope.isRegression()||$scope.isTimeseriesPrediction()?lightgbm_regression:lightgbm_classification});app.controller("TabICLHyperparametersController",function($scope){const{tabicl_classification}=$scope.mlTaskDesign.modeling;$scope.hpSpace=tabicl_classification;$scope.noNormalizationSelected=function(){const methods=["norm_none","norm_power","norm_quantile","norm_quantile_rtdl","norm_robust"];return methods.every(m=>!$scope.hpSpace[m])};$scope.noClassShiftSelected=function(){return $scope.hpSpace.class_shift.values.true.enabled===false&&$scope.hpSpace.class_shift.values.false.enabled===false};$scope.isGpuActivated=function(){return $scope.mlTaskDesign.gpuConfig.params.useGpu}});app.controller("DeepNeuralNetworkHyperparametersController",function($scope){const{deep_neural_network_regression,deep_neural_network_classification}=$scope.mlTaskDesign.modeling;$scope.hpSpace=$scope.isRegression()?deep_neural_network_regression:deep_neural_network_classification});app.controller("DesignEvaluationMetricController",function($scope){$scope.baseEvaluationMetrics=[];if($scope.isBinaryClassification()){$scope.baseEvaluationMetrics=$scope.bcEvaluationMetrics}else if($scope.isMulticlass()){$scope.baseEvaluationMetrics=$scope.mcEvaluationMetrics}else if($scope.isRegression()){$scope.baseEvaluationMetrics=$scope.regressionEvaluationMetrics}else if($scope.isTimeseriesPrediction()){$scope.baseEvaluationMetrics=$scope.timeseriesEvaluationMetrics}})})();(function(){"use strict";const app=angular.module("dataiku.analysis.mlcore");app.factory("DeepHubParamsService",function(){const defaultOptimizers=[{value:"ADAM",description:"Adam"},{value:"SGD",description:"Stochastic Gradient Descent"},{value:"RMSPROP",description:"RMSprop"},{value:"ADAMAX",description:"Adamax"},{value:"ADAGRAD",description:"Adagrad"},{value:"ADADELTA",description:"Adadelta"}];const defaultLRSchedulers=[{value:"PLATEAU",description:"On plateau"},{value:"STEP",description:"Step"},{value:"EXPONENTIAL",description:"Exponential"}];const paramsOptionsPerPredictionType={DEEP_HUB_IMAGE_OBJECT_DETECTION:{OPTIMIZERS:defaultOptimizers,LR_SCHEDULERS:defaultLRSchedulers,PRETRAINED_MODELS:[{value:"FASTERRCNN",description:"Faster R-CNN",nbLayers:5}]},DEEP_HUB_IMAGE_CLASSIFICATION:{OPTIMIZERS:defaultOptimizers,LR_SCHEDULERS:defaultLRSchedulers,PRETRAINED_MODELS:[{value:"EFFICIENTNET_B0",description:"Lighter / Faster (EfficientNet B0)",nbLayers:8},{value:"EFFICIENTNET_B4",description:"Balanced (EfficientNet B4)",nbLayers:8},{value:"EFFICIENTNET_B7",description:"Performance-oriented (EfficientNet B7)",nbLayers:8}]}};return{getParamsOptions:predictionType=>{if(!(predictionType in paramsOptionsPerPredictionType)){throw new Error("Unsupported prediction type: "+predictionType)}return paramsOptionsPerPredictionType[predictionType]},getNbTrainableLayers:predictionType=>{if(!(predictionType in paramsOptionsPerPredictionType)){throw new Error("Unsupported prediction type: "+predictionType)}return paramsOptionsPerPredictionType[predictionType]["PRETRAINED_MODELS"].reduce(function(map,obj){map[obj.value]=obj.nbLayers;return map},{})},getParamDescription:(predictionType,paramType,paramValue)=>{if(!(predictionType in paramsOptionsPerPredictionType)){throw new Error("Unsupported prediction type: "+predictionType)}if(!(paramType in paramsOptionsPerPredictionType[predictionType])){throw new Error("Unsupported param type: "+paramType+" in prediction type "+predictionType)}for(const paramOption of paramsOptionsPerPredictionType[predictionType][paramType]){if(paramOption.value===paramValue){return paramOption.description}}throw new Error(`Unsupported param value ${paramValue} for type: ${paramType} in prediction type ${predictionType}`)}}});app.controller("DeepHubPMLTaskDesignController",function($scope,$controller,CreateModalFromTemplate,PMLTrainTestPolicies,DeepHubMetricsService,DeepHubParamsService,$timeout){$controller("_MLTaskDesignController",{$scope:$scope});$scope.evaluationMetrics=Object.entries(DeepHubMetricsService.metricNameToDescriptionMapPerPrediction($scope.mlTaskDesign.predictionType));$scope.confidenceScoreThresholdOptimMetrics=DeepHubMetricsService.confidenceScoreThresholdOptimMetricNameToDescription();$scope.trainTestPolicies=PMLTrainTestPolicies.trainTestPolicies;$scope.trainTestPoliciesDesc=PMLTrainTestPolicies.trainTestPoliciesDesc;$scope.uiState=$scope.uiState||{};$scope.uiState.selectedCategories=[];$scope.deephubParamsOptions=DeepHubParamsService.getParamsOptions($scope.mlTaskDesign.predictionType);$scope.deephubNbLayersPerModel=DeepHubParamsService.getNbTrainableLayers($scope.mlTaskDesign.predictionType);$scope.setSelectedCategories=function(category){$scope.uiState.selectedCategories=[category]};$scope.onChangeTargetFeature=function(){if($scope.dirtySettings()){$scope.saveSettings()}CreateModalFromTemplate("/templates/analysis/prediction/change-core-params-modal.html",$scope,"PMLChangeBasicParamsModal",function(newScope){newScope.paramKey="targetVariable"})};$scope.augmentationParamsChange=function(augmentationParams){$timeout(function(){Object.assign($scope.mlTaskDesign.modeling.augmentationParams,augmentationParams)})};$scope.$watch("mlTaskDesign",function(nv,ov){if(nv){$scope.uiState.targetVariable=nv.targetVariable;$scope.uiState.splitMethodDesc=nv.splitParams.ssdSplitMode==="SORTED"?"Based on time variable":"Randomly";$scope.retrieveCodeEnvsInfo()}})});app.controller("DeepHubPMLTargetRemappingController",function($scope,$controller,COLOR_PALETTES){$scope.colors=COLOR_PALETTES.highContrast;$controller("_PMLTargetRemappingController",{$scope:$scope})});app.controller("DeepHubPMLTaskPreTrainModal",function($scope,$stateParams,$controller,DataikuAPI,WT1,Logger){$controller("PMLTaskPreTrainModal",{$scope:$scope});$scope.train=()=>{$scope.saveSettings().then($scope._doTrainThenResolveModal)};$scope._doTrain=function(){try{WT1.event("deephub-prediction-train",{backendType:$scope.mlTaskDesign.backendType,taskType:$scope.mlTaskDesign.taskType,predictionType:$scope.mlTaskDesign.predictionType,metrics:$scope.mlTaskDesign.modeling.metrics,hasSessionName:!!$scope.uiState.userSessionName,hasSessionDescription:!!$scope.uiState.userSessionDescription,dataAugmentationParams:$scope.mlTaskDesign.modeling.augmentationParams})}catch(e){Logger.error("Failed to report mltask info",e)}return DataikuAPI.analysis.pml.trainStart($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId,$scope.uiState.userSessionName,$scope.uiState.userSessionDescription,$scope.uiState.forceRefresh,false).error(setErrorInScope.bind($scope))}});app.controller("DeepHubPMLTaskResultController",function($scope,$controller,PMLSettings,PMLFilteringService){angular.extend($scope,PMLSettings.taskF($scope.mlTasksContext.activeMLTask.backendType));angular.extend($scope,PMLSettings.task);$scope.metricMap=PMLFilteringService.metricMap;$controller("_MLTaskResultsController",{$scope:$scope});$controller("_PMLTaskResultController",{$scope:$scope});$controller("_DeepLearningPMLTaskResultController",{$scope:$scope});$scope.canShowTensorboard=function(){return false};$scope.anySessionModelHasOptimizationResults=function(){return($scope.selection.sessionModels||[]).some(function(x){return x.modelTrainingInfo})}});app.controller("DeepHubPMLTaskBaseController",function($scope,$controller){$controller("_PMLTrainSessionController",{$scope:$scope})});app.controller("DeepHubPMLModelReportController",function($scope){$scope.uiState=$scope.uiState||{};$scope.uiState.iou=.5});app.controller("DeepHubPMLReportSummaryController",function($scope,$controller,DeepHubParamsService){$controller("_PMLReportSummaryController",{$scope:$scope});$scope.getParamDescription=DeepHubParamsService.getParamDescription;$scope.deephubNbLayersPerModel=DeepHubParamsService.getNbTrainableLayers($scope.modelData.coreParams.prediction_type)});app.component("objectDetectionMetricsReport",{bindings:{perf:"<",targetRemapping:"<"},templateUrl:"/templates/ml/prediction-model/deephub/object-detection-metrics.html",controller:function($scope,DeepHubMetricsService){const ctrl=this;let categories;function buildMetricsTabData(perf){const metricsResultTabData=[];metricsResultTabData.push({allClasses:true,category:"All classes",metrics:perf.metrics});perf.perCategoryMetrics.forEach((categoryMetrics,categoryIndex)=>{metricsResultTabData.push({category:categories[categoryIndex],metrics:categoryMetrics})});return metricsResultTabData}$scope.isSortMetric=metricInfo=>$scope.uiState.sortMetric===metricInfo.name;$scope.sortByMetric=metricInfo=>{const ss=$scope.selection;if($scope.isSortMetric(metricInfo)){ss.orderReversed=!ss.orderReversed}else{ss.orderReversed=false;$scope.uiState.sortMetric=metricInfo.name;$scope.metricsResultTabData.forEach(categoryData=>{categoryData.sortMetric=categoryData.metrics[metricInfo.fieldName]})}$scope.$emit("refresh-list")};ctrl.$onInit=()=>{categories=ctrl.targetRemapping.map(mapping=>mapping.sourceValue);$scope.metricsResultTabData=buildMetricsTabData(ctrl.perf);$scope.metricsInfo=DeepHubMetricsService.objectDetectionMetricsInfo();$scope.uiState={};$scope.selection=$.extend({filterParams:{userQueryTargets:["category"]},orderQuery:"-sortMetric"},$scope.selection||{})}}})})();(function(){"use strict";const app=angular.module("dataiku.analysis.mlcore");app.component("timeseriesIdentifiersFilters",{bindings:{objectId:"@",identifiers:"<",multiple:"<?"},templateUrl:"/templates/ml/prediction-model/timeseries/identifiers-filters.html",controller:function($scope,LocalStorage){const $ctrl=this;$ctrl.$onInit=function(){const storedSelectionKey=$ctrl.getStoredSelectionKey();$ctrl.filtersModel=JSON.parse(sessionStorage.getItem(storedSelectionKey)||"{}");if(JSON.stringify($ctrl.filtersModel)==="{}"){$ctrl.filtersModel=LocalStorage.get(storedSelectionKey)||{}}if(this.multiple===undefined){$ctrl.multiple=true}$ctrl.emit($ctrl.filtersModel)};$ctrl.onChange=function(){$ctrl.emit($ctrl.filtersModel);const storedSelectionKey=$ctrl.getStoredSelectionKey();LocalStorage.set(storedSelectionKey,$ctrl.filtersModel);sessionStorage.setItem(storedSelectionKey,JSON.stringify($ctrl.filtersModel))};$ctrl.emit=function(filtersModel){$scope.$emit("timeseriesIdentifiersFiltersUpdated",filtersModel)};$ctrl.getStoredSelectionKey=function(){return"dss.ml.forecastChart."+$ctrl.objectId+".filters"}}})})();(function(){"use strict";const app=angular.module("dataiku.analysis.mlcore");app.constant("SINGLE_TIMESERIES_IDENTIFIER","__single_timeseries_identifier");app.controller("TimeseriesPMLTaskBaseController",function($scope,$controller,DataikuAPI,TimeseriesForecastingUtils,VisualMlCodeEnvCompatibility,AlgorithmsSettingsService,FeatureFlagsService,CachedAPICalls){$controller("_PMLTrainSessionController",{$scope:$scope});$scope.legacyAlgorithms=["gluonts_mqcnn_timeseries","gluonts_transformer_timeseries","gluonts_deepar_timeseries","gluonts_simple_feed_forward_timeseries"];$scope.deferredAfterInitMlTaskDesign.then(()=>CachedAPICalls.pmlGuessPolicies).then(pmlGuessPolicies=>{$scope.guessPolicies=$scope.prepareGuessPolicies(pmlGuessPolicies["timeseries-forecasting"])}).then(()=>{$scope.setAlgorithms($scope.mlTaskDesign);$scope.setSelectedAlgorithm(AlgorithmsSettingsService.getDefaultAlgorithm($scope.mlTaskDesign,$scope.base_algorithms[$scope.mlTaskDesign.backendType]))}).catch(setErrorInScope.bind($scope));$scope.hasExternalFeatures=per_feature=>!!$scope.mlTaskFeatures(per_feature,["INPUT","INPUT_PAST_ONLY"]).length;$scope.hasKnownInAdvanceFeatures=per_feature=>!!$scope.mlTaskFeatures(per_feature,["INPUT"]).length;function getModelingForAlgKey(algKey){const safe_alg_key=algKey.startsWith("xgboost")?"xgboost":algKey;return $scope.mlTaskDesign?.modeling[safe_alg_key]}$scope.listAlgosWithoutExternalFeatures=function(algos){if(!algos||!$scope.mlTaskDesign||!$scope.hasExternalFeatures($scope.mlTaskDesign.preprocessing.per_feature))return[];return algos.filter(algo=>getModelingForAlgKey(algo.algKey)?.enabled&&TimeseriesForecastingUtils.ALGOS_WITHOUT_EXTERNAL_FEATURES.keys.includes(algo.algKey))};$scope.countEnabledAlgos=function(algos){if(!$scope.mlTaskDesign?.modeling||!algos)return 0;return Object.keys($scope.mlTaskDesign.modeling).filter(key=>algos.some(algo=>algo.templateName===key||algo.algKey===key)&&$scope.mlTaskDesign.modeling[key].enabled).length};$scope.listAlgosWithKnownInAdvanceExternalFeaturesSupportNames=function(){const algos=$scope?.mlTaskDesign?.backendType&&$scope?.algorithms?$scope.algorithms[$scope.mlTaskDesign.backendType]:[];const compatList=algos.filter(algo=>algo.templateName&&$scope.mlTaskDesign?.modeling[algo.templateName]?.enabled||$scope.mlTaskDesign?.modeling[algo.algKey]?.enabled).filter(algo=>(!algo.templateName||!TimeseriesForecastingUtils.ALGOS_WITHOUT_EXTERNAL_FEATURES.keys.includes(algo.templateName))&&!TimeseriesForecastingUtils.ALGOS_WITHOUT_EXTERNAL_FEATURES.keys.includes(algo.algKey)).map(x=>x.name);return[...new Set(compatList)]};$scope.cachedAlgoLists={enabledCount:0,shiftsWindowsCompatible:[],pastOnlyCompatible:[],knownInAdvanceCompatible:[]};$scope.updateCachedAlgoLists=function(){const algos=$scope?.mlTaskDesign?.backendType&&$scope?.algorithms?$scope.algorithms[$scope.mlTaskDesign.backendType]:[];if(algos.length===0){$scope.cachedAlgoLists.enabledCount=0;$scope.cachedAlgoLists.shiftsWindowsCompatible=[];$scope.cachedAlgoLists.pastOnlyCompatible=[];$scope.cachedAlgoLists.knownInAdvanceCompatible=[]}else{$scope.cachedAlgoLists.enabledCount=$scope.countEnabledAlgos(algos);$scope.cachedAlgoLists.shiftsWindowsCompatible=$scope.listAlgosCompatibleWithShiftsWindows();$scope.cachedAlgoLists.pastOnlyCompatible=$scope.listAlgosCompatibleWithPastOnlyFeatures();$scope.cachedAlgoLists.knownInAdvanceCompatible=$scope.listAlgosWithKnownInAdvanceExternalFeaturesSupportNames()}};$scope.listAlgosSlowOnMultipleTimeseries=function(algos){if(!$scope.mlTaskDesign||!$scope.mlTaskDesign.timeseriesIdentifiers.length)return[];return algos.filter(algo=>getModelingForAlgKey(algo.algKey)?.enabled&&TimeseriesForecastingUtils.ALGOS_SLOW_ON_MULTIPLE_TIMESERIES.includes(algo.algKey))};$scope.listAlgosIncompatibleWithMs=function(algos){if($scope.mlTaskDesign?.timestepParams?.timeunit!=="MILLISECOND")return[];return algos.filter(algo=>getModelingForAlgKey(algo.algKey)?.enabled&&TimeseriesForecastingUtils.ALGOS_INCOMPATIBLE_WITH_MS.includes(algo.algKey))};$scope.listEnabledAlgosWithKeysInList=function(algoList){if(!$scope.mlTaskDesign||!$scope.mlTaskDesign.modeling||!$scope.algorithms)return[];const algos=$scope.algorithms["PY_MEMORY"];const compatList=algos.filter(algo=>algo.templateName&&$scope.mlTaskDesign?.modeling[algo.templateName]?.enabled||$scope.mlTaskDesign?.modeling[algo.algKey]?.enabled).filter(algo=>algo.templateName&&algoList.includes(algo.templateName)||algoList.includes(algo.algKey)).map(x=>x.name);return[...new Set(compatList)]};$scope.listAlgosCompatibleWithShiftsWindows=()=>$scope.listEnabledAlgosWithKeysInList(TimeseriesForecastingUtils.ALGOS_COMPATIBLE_WITH_SHIFTS_AND_WINDOWS);$scope.listAlgosCompatibleWithPastOnlyFeatures=()=>$scope.listEnabledAlgosWithKeysInList(TimeseriesForecastingUtils.ALGOS_COMPATIBLE_WITH_PAST_ONLY_FEATURES.keys);$scope.validateHorizonShift=function(shiftFromHorizonValues,fieldName,isPastOnlyFeature){if(shiftFromHorizonValues.some(x=>x===null||x===undefined||isNaN(x))){return fieldName+" must be integer."}else if(shiftFromHorizonValues.some(x=>!Number.isInteger(x))){return fieldName+" must be integer, float values will be truncated."}else if(isPastOnlyFeature&&shiftFromHorizonValues.some(x=>x>-$scope.mlTaskDesign.predictionLength)){return fieldName+" must be smaller or equal to -"+$scope.mlTaskDesign.predictionLength+" (forecast horizon timesteps) for target and past-only external features."}else if(shiftFromHorizonValues.some(x=>x>0)){return fieldName+" must not be positive."}return""};$scope.validateForecastShift=function(shiftFromForecastValues,fieldName){if(shiftFromForecastValues.some(x=>x===null||x===undefined||isNaN(x))){return fieldName+" must be integer."}else if(shiftFromForecastValues.some(x=>!Number.isInteger(x))){return fieldName+" must be integer, float values will be truncated."}else if(shiftFromForecastValues.some(x=>x>0)){return fieldName+" must not be in the future."}return""};$scope.validateShiftsAsString=function(shiftFromForecastAsString,shiftFromHorizonAsString,isPastOnlyFeature){const shiftFromForecastValues=shiftFromForecastAsString!==""?Array.from(shiftFromForecastAsString.split(",")).map(x=>Number(x)):[];const shiftFromHorizonValues=shiftFromHorizonAsString!==""?Array.from(shiftFromHorizonAsString.split(",")).map(x=>Number(x)):[];let forecastShiftErrorMessage="";if(shiftFromForecastAsString.includes(" ")||shiftFromForecastValues.some(x=>isNaN(x))){forecastShiftErrorMessage="Must contain only comma separated list of integers."}else{forecastShiftErrorMessage=$scope.validateForecastShift(shiftFromForecastValues,"Forecast origin shift values")}let horizonShiftErrorMessage="";if(shiftFromHorizonAsString.includes(" ")||shiftFromHorizonValues.some(x=>isNaN(x))){horizonShiftErrorMessage="Must contain only comma separated list of integers."}else{horizonShiftErrorMessage=$scope.validateHorizonShift(shiftFromHorizonValues,"Forecasted point shift values",isPastOnlyFeature)}return{from_forecast:forecastShiftErrorMessage,from_horizon:horizonShiftErrorMessage}};$scope.validatePastOnlyAutoHorizonShiftRange=function(minHorizonShiftPastOnly,maxHorizonShiftPastOnly){let validationError="";if(minHorizonShiftPastOnly>=maxHorizonShiftPastOnly){validationError="Range length must be positive."}if(validationError===""){validationError=$scope.validateHorizonShift([minHorizonShiftPastOnly],"Past only features minimum shift",true)}if(validationError===""){validationError=$scope.validateHorizonShift([maxHorizonShiftPastOnly],"Past only features maximum shift",true)}if(validationError===""){const rangeLength=maxHorizonShiftPastOnly-minHorizonShiftPastOnly;if(rangeLength>1e3){validationError="Range length is very large, this can significantly increase preprocessing time."}}return validationError};$scope.validateKnownInAdvanceAutoHorizonShiftRange=function(minHorizonShiftKnownInAdvance,maxHorizonShiftKnownInAdvance){let validationError="";if(minHorizonShiftKnownInAdvance>=maxHorizonShiftKnownInAdvance){validationError="Range length must be positive."}if(validationError===""){validationError=$scope.validateHorizonShift([minHorizonShiftKnownInAdvance],"Known in advance features minimum shift",false)}if(validationError===""){validationError=$scope.validateHorizonShift([maxHorizonShiftKnownInAdvance],"Known in advance features maximum shift",false)}if(validationError===""){const rangeLength=maxHorizonShiftKnownInAdvance-minHorizonShiftKnownInAdvance;if(rangeLength>1e3){validationError="Range length is very large, this can significantly increase preprocessing time."}}return validationError};$scope.$watch("uiState.laggableFeatures",function(nv){$scope.validateShifts()},true);$scope.validateShifts=function(){$scope.shiftsValidationErrors={};if(!$scope.uiState||!$scope.uiState.laggableFeatures){return}for(const feature of $scope.uiState.laggableFeatures){let featureName=feature._name;let shiftFromForecastAsString=($scope.mlTaskDesign.preprocessing.feature_generation.shifts[featureName].from_forecast||"").toString();let shiftFromHorizonAsString=($scope.mlTaskDesign.preprocessing.feature_generation.shifts[featureName].from_horizon||"").toString();let isPastOnlyFeature=$scope.isPastOnlyFeature(featureName);$scope.shiftsValidationErrors[featureName]=$scope.validateShiftsAsString(shiftFromForecastAsString,shiftFromHorizonAsString,isPastOnlyFeature)}$scope.updateSelectedAlgosMissingRequiredExternalFeature()};$scope.windowHasAnyEnabledOperation=function(window){return window.operations_list.some(operations=>operations[1].some(operation=>operation.enabled))};$scope.isPastOnlyFeature=function(featureName){return["INPUT_PAST_ONLY","TARGET"].includes($scope.mlTaskDesign.preprocessing.per_feature[featureName].role)};$scope.updateWindowLength=function(windowIndex,startShift,shift){$scope.uiState.windows[windowIndex].length=-(startShift-shift)};$scope.$watch("uiState.windows",function(nv){$scope.validateWindows()},true);$scope.validateWindows=function(){$scope.windowsValidationErrors=[];if(!$scope.uiState||!$scope.uiState.windows){return}for(let windowIndex=0;windowIndex<$scope.uiState.windows.length;windowIndex++){let window=$scope.uiState.windows[windowIndex];let shiftMessage="";if(window.length<=0){shiftMessage="The window length must be positive."}else if(window.length<2){shiftMessage="Window length must be at least 2 timesteps"}else if(window.is_from_forecast){shiftMessage=$scope.validateForecastShift([window.shift],"Window end")}else{let windowHasPastCovariateFeatureEnabled=Object.keys(window.operations_map).filter(featureName=>window.operations_map[featureName].some(x=>x.enabled)).some(featureName=>$scope.isPastOnlyFeature(featureName));shiftMessage=$scope.validateHorizonShift([window.shift],"Window end",windowHasPastCovariateFeatureEnabled)}let operationsMessage="";if(!$scope.windowHasAnyEnabledOperation($scope.uiState.windows[windowIndex])){operationsMessage="The window doesn't have any aggregation method."}$scope.windowsValidationErrors.push({shift:shiftMessage,operations:operationsMessage})}$scope.updateSelectedAlgosMissingRequiredExternalFeature()};$scope.updateSelectedAlgosMissingRequiredExternalFeature=function(){$scope.selectedAlgosMissingRequiredExternalFeature=[];const algosRequiringExternalFeature=$scope.listAlgosCompatibleWithShiftsWindows();if(algosRequiringExternalFeature.length>0){let hasGeneratedFeature=$scope.mlTaskDesign.preprocessing.feature_generation.windows.length>0;for(const feature of $scope.uiState.laggableFeatures){let featureName=feature._name;const hasForecastShift=$scope.mlTaskDesign.preprocessing.feature_generation.shifts[featureName].from_forecast.length>0;const hasHorizonShift=$scope.mlTaskDesign.preprocessing.feature_generation.shifts[featureName].from_horizon_mode=="FIXED"&&$scope.mlTaskDesign.preprocessing.feature_generation.shifts[featureName].from_horizon.length>0;const isAutoHorizonShift=$scope.mlTaskDesign.preprocessing.feature_generation.shifts[featureName].from_horizon_mode=="AUTO";if(hasForecastShift||hasHorizonShift||isAutoHorizonShift){hasGeneratedFeature=true;break}}if(!hasGeneratedFeature){$scope.selectedAlgosMissingRequiredExternalFeature=algosRequiringExternalFeature}}};$scope.displayProphetCodeEnvWarning=function(algorithm){if(algorithm.algKey!=="prophet_timeseries"||!getModelingForAlgKey(algorithm.algKey)?.enabled){return false}const envCompat=VisualMlCodeEnvCompatibility.getCodeEnvCompat($scope.mlTaskDesign.envSelection,$scope.codeEnvsCompat);const isEnvProphetCompatible=envCompat&&envCompat.prophet&&envCompat.prophet.compatible;return!isEnvProphetCompatible};$scope.displayGluontsCodeEnvWarning=function(algorithm){const gluonts_algs=["trivial_identity_timeseries","seasonal_naive_timeseries","gluonts_npts_timeseries","gluonts_simple_feed_forward_timeseries","gluonts_deepar_timeseries","gluonts_transformer_timeseries","gluonts_mqcnn_timeseries"];if(!$scope.isAlgoEnabledAndInList(algorithm.algKey,gluonts_algs)){return false}const envCompat=VisualMlCodeEnvCompatibility.getCodeEnvCompat($scope.mlTaskDesign.envSelection,$scope.codeEnvsCompat);const isEnvGluontsTorchCompatible=envCompat&&envCompat.gluonts&&envCompat.gluonts.compatible;return!isEnvGluontsTorchCompatible};$scope.displayNeuralforecastCodeEnvWarning=function(algorithm){const neuralforecastAlgs=["tft_timeseries","nhits_timeseries"];if(!$scope.isAlgoEnabledAndInList(algorithm.algKey,neuralforecastAlgs)){return false}const envCompat=VisualMlCodeEnvCompatibility.getCodeEnvCompat($scope.mlTaskDesign.envSelection,$scope.codeEnvsCompat);const isEnvNeuralforecastCompatible=envCompat?.neuralforecast?.compatible;return!isEnvNeuralforecastCompatible};$scope.displayPmdarimaCodeEnvWarning=function(algorithm){if(algorithm.algKey!=="autoarima_timeseries"||!getModelingForAlgKey(algorithm.algKey)?.enabled){return false}const envCompat=VisualMlCodeEnvCompatibility.getCodeEnvCompat($scope.mlTaskDesign.envSelection,$scope.codeEnvsCompat);const isEnvArimaCompatible=envCompat&&envCompat.pmdarima&&envCompat.pmdarima.compatible;return!isEnvArimaCompatible};$scope.displayStatsmodelCodeEnvWarning=function(algorithm){const statsmodelsAlgs=["arima_timeseries","ets_timeseries","seasonal_loess_timeseries"];if(!$scope.isAlgoEnabledAndInList(algorithm.algKey,statsmodelsAlgs)){return false}const envCompat=VisualMlCodeEnvCompatibility.getCodeEnvCompat($scope.mlTaskDesign.envSelection,$scope.codeEnvsCompat);const isEnvStatsmodelCompatible=envCompat&&envCompat.statsmodel&&envCompat.statsmodel.compatible;return!isEnvStatsmodelCompatible};$scope.displayStatsforecastCodeEnvWarning=function(algorithm){const statsforecastAlgs=["croston_timeseries"];if(!$scope.isAlgoEnabledAndInList(algorithm.algKey,statsforecastAlgs)){return false}const envCompat=VisualMlCodeEnvCompatibility.getCodeEnvCompat($scope.mlTaskDesign.envSelection,$scope.codeEnvsCompat);const isEnvStatsforecastCompatible=envCompat&&envCompat.statsforecast&&envCompat.statsforecast.compatible;return!isEnvStatsforecastCompatible};$scope.displayClassicalMLCodeEnvWarning=function(algorithm){if(!$scope.isAlgoEnabledAndInList(algorithm.algKey,TimeseriesForecastingUtils.ALGOS_TIMESERIES_CLASSICAL_ML)){return false}const envCompat=VisualMlCodeEnvCompatibility.getCodeEnvCompat($scope.mlTaskDesign.envSelection,$scope.codeEnvsCompat);const isClassicalMlCompatible=envCompat&&envCompat.classicalMLTs&&envCompat.classicalMLTs.compatible;return!isClassicalMlCompatible};$scope.displayMXNetAlgLegacyWarning=function(algorithm){return $scope.isAlgoEnabledAndInList(algorithm.algKey,$scope.legacyAlgorithms)};$scope.isAlgoEnabledAndInList=function(algKey,algList){return algList.includes(algKey)&&getModelingForAlgKey(algKey)?.enabled};$scope.displayMXNetAlgCodeEnvWarning=function(algorithm){if(!$scope.isAlgoEnabledAndInList(algorithm.algKey,$scope.legacyAlgorithms)){return false}const envCompat=VisualMlCodeEnvCompatibility.getCodeEnvCompat($scope.mlTaskDesign.envSelection,$scope.codeEnvsCompat);const isEnvMXNetCompatible=envCompat&&envCompat.mxnetTimeseries&&envCompat.mxnetTimeseries.compatible;return!isEnvMXNetCompatible};$scope.displayGluontsTorchAlgCodeEnvWarning=function(algorithm){const torch_algs=["gluonts_torch_deepar_timeseries","gluonts_torch_simple_feed_forward_timeseries"];if(!$scope.isAlgoEnabledAndInList(algorithm.algKey,torch_algs)){return false}const envCompat=VisualMlCodeEnvCompatibility.getCodeEnvCompat($scope.mlTaskDesign.envSelection,$scope.codeEnvsCompat);const isEnvGluontsTorchCompatible=envCompat&&envCompat.torchTimeseries&&envCompat.torchTimeseries.compatible;return!isEnvGluontsTorchCompatible}});app.controller("TimeseriesPMLTaskDesignController",function($scope,$controller,CreateModalFromTemplate,$timeout,TimeseriesForecastingUtils,TimeseriesForecastingCustomTrainTestFoldsUtils,$filter,MLFeaturesService){$controller("_TabularPMLTaskDesignController",{$scope:$scope});$scope.prettyTimeUnit=TimeseriesForecastingUtils.prettyTimeUnit;$scope.prettyTimeSteps=TimeseriesForecastingUtils.prettyTimeSteps;$scope.plurifiedTimeUnits=TimeseriesForecastingUtils.plurifiedTimeUnits;$scope.timeseriesImputeMethods=function(featureType,interpolation,extrapolation){return TimeseriesForecastingUtils.TIMESERIES_IMPUTE_METHODS.filter(imputeMethod=>(featureType!==undefined?imputeMethod.featureTypes.includes(featureType):true)&&(interpolation!==undefined?imputeMethod.interpolation===interpolation:true)&&(extrapolation!==undefined?imputeMethod.extrapolation===extrapolation:true))};$scope.timeseriesImputeMethodsDescriptions=function(featureType,interpolation,extrapolation){return $scope.timeseriesImputeMethods(featureType,interpolation,extrapolation).map(imputeMethod=>imputeMethod.description)};$scope.duplicateTimestampsHandlingMethods=TimeseriesForecastingUtils.DUPLICATE_TIMESTAMPS_HANDLING_METHODS;$scope.getWeekDayName=TimeseriesForecastingUtils.getWeekDayName;$scope.getDayNumber=TimeseriesForecastingUtils.getDayNumber;$scope.daysInMonth=Array.from({length:31},(_,index)=>index+1);$scope.getMonthName=TimeseriesForecastingUtils.getMonthName;$scope.getQuarterName=TimeseriesForecastingUtils.getQuarterName;$scope.getHalfYearName=TimeseriesForecastingUtils.getHalfYearName;$scope.togglePartitioningSection=function(){$scope.partitioningSectionOpened=!$scope.partitioningSectionOpened};$scope.addWindow=function(){var newWindowParams={length:Math.max($scope.mlTaskDesign.predictionLength,2),shift:0,is_from_forecast:true,operations_map:{}};for(let feature of $scope.uiState.windowableFeatures||[]){if(feature.type==="NUMERIC"){newWindowParams.operations_map[feature._name]=[{operation:"MEAN",enabled:true},{operation:"MEDIAN",enabled:false},{operation:"STD",enabled:true},{operation:"MIN",enabled:false},{operation:"MAX",enabled:false}]}else if(feature.type==="CATEGORY"){newWindowParams.operations_map[feature._name]=[{operation:"FREQUENCY",enabled:true}]}}$scope.mlTaskDesign.preprocessing.feature_generation.windows.push(newWindowParams)};$scope.deleteWindow=function(windowIndex){$scope.mlTaskDesign.preprocessing.feature_generation.windows.splice(windowIndex,1)};$scope.getValidOperations=function(window,windowableFeature){const unfilteredOperations=window.operations_map[windowableFeature._name];if(windowableFeature.type==="NUMERIC"){return unfilteredOperations.filter(op=>["MIN","MAX","MEAN","MEDIAN","SUM","STD"].includes(op.operation))}else if(windowableFeature.type==="CATEGORY"){return unfilteredOperations.filter(op=>op.operation==="FREQUENCY")}};$scope.$watch("mlTaskDesign",function(nv){if(!nv)return;$scope.uiState.timeVariable=nv.timeVariable;$scope.uiState.timeseriesIdentifiers=[].concat(nv.timeseriesIdentifiers);$scope.uiState.multipleTimeSeries=nv.timeseriesIdentifiers[0]!==undefined;$scope.uiState.predictionLength=nv.predictionLength;$scope.uiState.timestepParams=Object.assign({},nv.timestepParams);$scope.setDefaultMonthlyAlignment(nv.timestepParams,false);$scope.setDefaultUnitAlignment(nv.timestepParams,false);$scope.partitioningSectionOpened=$scope.mlTaskDesign.partitionedModel&&$scope.mlTaskDesign.partitionedModel.enabled;$scope.uiState.numberOfHorizonsInTest=Math.floor($scope.mlTaskDesign.evaluationParams.testSize/$scope.mlTaskDesign.predictionLength);$scope.uiState.hyperparamSearchStrategies=[["GRID","Grid search"],["RANDOM","Random search"],["BAYESIAN","Bayesian search"]];$scope.uiState.crossValidationModes=[["TIME_SERIES_SINGLE_SPLIT","Simple split"],["TIME_SERIES_KFOLD","K-fold cross-validation"]];$scope.uiState.preprocessingPerFeature=$scope.mlTaskFeatures(nv.preprocessing.per_feature,["INPUT","INPUT_PAST_ONLY","REJECT"]);$scope.featuresWithDateMeaning=Object.fromEntries(Object.entries($scope.mlTaskDesign.preprocessing.per_feature).filter(function(entry){const feature=entry[1];return["Date","DateOnly","DatetimeNoTz"].indexOf(feature.state.recordedMeaning)>=0}))});$scope.$watch("mlTaskDesign.preprocessing.per_feature",function(nv){let features=$scope.mlTaskFeatures(nv,["INPUT","INPUT_PAST_ONLY","TARGET"]).map(x=>{let copy=angular.copy(x);copy.$selected=false;return copy});let targetIndex=features.findIndex(f=>f.role==="TARGET");if(targetIndex>-1){let target=features.splice(targetIndex,1)[0];features.unshift(target)}updateLaggableFeatures(features);updateWindowableFeatures(features)},true);$scope.$watchGroup(["algorithms","mlTaskDesign.preprocessing.feature_generation.windows.length","uiState.windowableFeatures","uiState.laggableFeatures"],function(nv,ov){$scope.updateSelectedAlgosMissingRequiredExternalFeature()},true);$scope.$watchGroup(["algorithms","mlTaskDesign.backendType"],function(nv,ov){$scope.updateCachedAlgoLists()});$scope.$watch("mlTaskDesign.modeling",function(nv,ov){$scope.updateCachedAlgoLists()},true);$scope.featureSupportsAutoShifts=function(feature){return feature?.type==="NUMERIC"};$scope.setDefaultShifts=function(feature,keepExisting=true){const shifts=$scope.mlTaskDesign.preprocessing.feature_generation.shifts;let from_forecast;let from_horizon;if(feature.role==="INPUT"){from_forecast=[];from_horizon=[-2,-1,0]}else{from_forecast=[-2,-1,0];from_horizon=[-$scope.mlTaskDesign.predictionLength-2,-$scope.mlTaskDesign.predictionLength-1,-$scope.mlTaskDesign.predictionLength]}if(!keepExisting||!(feature._name in shifts)){shifts[feature._name]={from_forecast:from_forecast,from_horizon:from_horizon,from_horizon_mode:$scope.featureSupportsAutoShifts(feature)?"AUTO":"FIXED"}}else{if(!$scope.featureSupportsAutoShifts(feature)){shifts[feature._name].from_horizon_mode="FIXED"}}};$scope.setDefaultShiftsMultipleFeatures=function(features,keepExisting=false){for(let feature of features){$scope.setDefaultShifts(feature,keepExisting)}};const featureSortingMethod=(a,b)=>a.datasetColumnId-b.datasetColumnId;function updateLaggableFeatures(features){const previousNames=($scope.uiState.laggableFeatures||[]).map(x=>x._name);const newlyAddedFeatures=features.filter(feature=>!previousNames.includes(feature._name));newlyAddedFeatures.forEach(feature=>$scope.setDefaultShifts(feature));$scope.uiState.laggableFeatures=[];MLFeaturesService.getDatasetColumns($scope.analysisCoreParams).then(function(datasetColumns){MLFeaturesService.addDataSetColumnId(newlyAddedFeatures,datasetColumns);$scope.uiState.laggableFeatures=features.sort(featureSortingMethod)}).catch(setErrorInScope.bind($scope))}function updateWindowableFeatures(features){const windowableFeatures=features.filter(feature=>TimeseriesForecastingUtils.isWindowCompatible(feature));const previousNamesAndTypes=($scope.uiState.windowableFeatures||[]).map(x=>[x._name,x.type]);const newNamesAndTypes=windowableFeatures.map(x=>[x._name,x.type]);const newlyAddedFeatures=newNamesAndTypes.filter(nameAndType=>!previousNamesAndTypes.includes(nameAndType));newlyAddedFeatures.forEach(nameAndType=>{const name=nameAndType[0];const type=nameAndType[1];$scope.mlTaskDesign.preprocessing.feature_generation.windows.forEach(window=>{if(!(name in window.operations_map)){if(type==="NUMERIC"){window.operations_map[name]=[{operation:"MEAN",enabled:false},{operation:"MEDIAN",enabled:false},{operation:"STD",enabled:false},{operation:"MIN",enabled:false},{operation:"MAX",enabled:false}]}else if(type==="CATEGORY"){window.operations_map[name]=[{operation:"FREQUENCY",enabled:false}]}}else{if(type==="NUMERIC"){let operations=window.operations_map[name].map(x=>x.operation);["MEAN","MEDIAN","STD","MIN","MAX"].filter(op=>!operations.includes(op)).forEach(op=>window.operations_map[name].push({operation:op,enabled:false}))}else if(type==="CATEGORY"){if(!window.operations_map[name].some(x=>x.operation==="FREQUENCY")){window.operations_map[name]=[{operation:"FREQUENCY",enabled:false}]}}}})});MLFeaturesService.getDatasetColumns($scope.analysisCoreParams).then(function(datasetColumns){MLFeaturesService.addDataSetColumnId(windowableFeatures,datasetColumns);$scope.uiState.windowableFeatures=windowableFeatures.sort(featureSortingMethod)}).catch(setErrorInScope.bind($scope))}$scope.$watchGroup(["mlTaskDesign.preprocessing.feature_generation.windows","mlTaskDesign.preprocessing.feature_generation.windows.length","uiState.windowableFeatures"],function(nv,ov){if(!nv[2]){return}$scope.uiState.windows=$scope.mlTaskDesign.preprocessing.feature_generation.windows.map((x,index)=>{let copy=angular.copy(x);copy.id=index;copy.operations_list=nv[2].filter(x=>copy.operations_map.hasOwnProperty(x._name)).map(x=>[x._name,copy.operations_map[x._name],x]);return copy})},true);$scope.$watch("uiState.windows",function(nv,ov){if(!nv||!ov)return;nv.forEach((window,index)=>{$scope.mlTaskDesign.preprocessing.feature_generation.windows[index].is_from_forecast=window.is_from_forecast;$scope.mlTaskDesign.preprocessing.feature_generation.windows[index].shift=window.shift;$scope.mlTaskDesign.preprocessing.feature_generation.windows[index].length=window.length;window.operations_list.forEach(([key,value])=>{$scope.uiState.windows[index].operations_map[key]=value;$scope.mlTaskDesign.preprocessing.feature_generation.windows[index].operations_map[key]=value})})},true);$scope.onChangeTimeVariable=function(){if(!$scope.uiState.timeVariable)return;if($scope.dirtySettings()){$scope.saveSettings()}CreateModalFromTemplate("/templates/analysis/prediction/change-core-params-modal.html",$scope,"PMLChangeBasicParamsModal",function(newScope){newScope.paramKey="timeVariable"})};$scope.changeTimeSeriesType=function(multiple){$scope.uiState.multipleTimeSeries=multiple;if(multiple||!$scope.mlTaskDesign.timeseriesIdentifiers.length)return;$scope.uiState.timeseriesIdentifiers=[];onChangeTimeseriesIdentifiers()};function haveTimeseriesIdentifiersChanged(){return $scope.mlTaskDesign.timeseriesIdentifiers.length!==$scope.uiState.timeseriesIdentifiers.length||$scope.mlTaskDesign.timeseriesIdentifiers.some(function(elem,idx){return elem!==$scope.uiState.timeseriesIdentifiers[idx]})}function onChangeTimeseriesIdentifiers(){if($scope.dirtySettings()){$scope.saveSettings()}CreateModalFromTemplate("/templates/analysis/prediction/change-core-params-modal.html",$scope,"PMLChangeBasicParamsModal",function(newScope){newScope.onCloseCallback=function(){$scope.uiState.preprocessingPerFeature=$scope.mlTaskFeatures($scope.mlTaskDesign.preprocessing.per_feature,["INPUT","INPUT_PAST_ONLY","REJECT"]);$scope.uiState.multipleTimeSeries=!!$scope.uiState.timeseriesIdentifiers.length};newScope.getUIStateParam=param=>[].concat(param);newScope.paramKey="timeseriesIdentifiers"})}$scope.newQuantileIsValid=function(newQuantile){const inRange=newQuantile>0&&newQuantile<1;if(!inRange)return false;return parseFloat(newQuantile.toFixed(4))===newQuantile};$scope.$on("$stateChangeStart",function(e){if(haveTimeseriesIdentifiersChanged()||hasNumberOfTimeunitsChanged()||hasPredictionLengthChanged()){e.preventDefault()}});$scope.onChangeTimeseriesIdentifiers=function(){$timeout(function(){if(haveTimeseriesIdentifiersChanged()){onChangeTimeseriesIdentifiers()}},100)};function onChangeTimestepParams(){if($scope.dirtySettings()){$scope.saveSettings()}CreateModalFromTemplate("/templates/analysis/prediction/change-core-params-modal.html",$scope,"PMLChangeBasicParamsModal",function(newScope){newScope.getUIStateParam=param=>Object.assign({},param);newScope.paramKey="timestepParams"})}function hasPredictionLengthChanged(){if(!$scope.uiState.predictionLength)return;return $scope.mlTaskDesign.predictionLength!==$scope.uiState.predictionLength}$scope.onChangePredictionLength=function(){if(!hasPredictionLengthChanged())return;if($scope.dirtySettings()){$scope.saveSettings()}const numberOfHorizonsInTest=$scope.uiState.numberOfHorizonsInTest;CreateModalFromTemplate("/templates/analysis/prediction/change-core-params-modal.html",$scope,"PMLChangeBasicParamsModal",function(newScope){newScope.onCloseCallback=function(){$scope.uiState.numberOfHorizonsInTest=numberOfHorizonsInTest;$scope.updateTimeseriesTestSize()};newScope.paramKey="predictionLength"})};$scope.setDefaultMonthlyAlignment=function(params,force){if(!params.monthlyAlignment||force){params.monthlyAlignment=31}};$scope.setDefaultUnitAlignment=function(params,force){if(!params.unitAlignment||force){if(params.timeunit==="QUARTER"){params.unitAlignment=3}else if(params.timeunit==="HALF_YEAR"){params.unitAlignment=6}else if(params.timeunit==="YEAR"){params.unitAlignment=12}}};$scope.onChangeTimestepUnit=function(){$scope.setDefaultMonthlyAlignment($scope.uiState.timestepParams,true);$scope.setDefaultUnitAlignment($scope.uiState.timestepParams,true);onChangeTimestepParams()};$scope.onChangeNumberOfTimeunits=function(){if(!hasNumberOfTimeunitsChanged())return;onChangeTimestepParams()};function hasNumberOfTimeunitsChanged(){if(!$scope.uiState.timestepParams.numberOfTimeunits)return;return $scope.uiState.timestepParams.numberOfTimeunits!==$scope.mlTaskDesign.timestepParams.numberOfTimeunits}$scope.hasRole=function(feature,roles){const role=$scope.mlTaskDesign.preprocessing.per_feature[feature].role;return roles.includes(role)};const randomUUID=function(){return window.crypto.getRandomValues(new Uint32Array(1))[0].toString(16)};$scope.updateTimeseriesTestSize=function(){$scope.mlTaskDesign.evaluationParams.testSize=$scope.uiState.predictionLength*$scope.uiState.numberOfHorizonsInTest};$scope.formatDateWithoutTimezone=function(uiDate){return moment(uiDate).utc().format("YYYY-MM-DD HH:mm:ss.SSS")};$scope.addCustomTestSplitInterval=function(){const defaultInterval=$scope.mlTaskDesign.customTrainTestIntervals[$scope.mlTaskDesign.customTrainTestIntervals.length-1];let newInterval={_id:randomUUID(),train:[new Date(defaultInterval["train"][0]),new Date(defaultInterval["train"][1])],test:[new Date(defaultInterval["test"][0]),new Date(defaultInterval["test"][1])]};$scope.uiState.fixedFoldIntervals=$scope.uiState.fixedFoldIntervals.concat([newInterval]);$scope.propagateFixedIntervalChangeFn()};$scope.removeCustomTestSplitInterval=function(intervalIndex){$scope.uiState.fixedFoldIntervals=$scope.uiState.fixedFoldIntervals.filter((_,index)=>index!=intervalIndex);$scope.propagateFixedIntervalChangeFn()};$scope.initTimeseriesFixedFoldUIState=function(){if(!$scope.mlTaskDesign.customTrainTestIntervals.length){$scope.mlTaskDesign.customTrainTestIntervals.push({train:[$scope.formatDateWithoutTimezone(new Date),$scope.formatDateWithoutTimezone(new Date)],test:[$scope.formatDateWithoutTimezone(new Date),$scope.formatDateWithoutTimezone(new Date)]})}$scope.uiState.fixedFoldIntervals=$scope.mlTaskDesign.customTrainTestIntervals.map((interval,index)=>({_id:randomUUID(),train:[TimeseriesForecastingCustomTrainTestFoldsUtils.forceConvertToUTCTimezoneDate(interval["train"][0]),TimeseriesForecastingCustomTrainTestFoldsUtils.forceConvertToUTCTimezoneDate(interval["train"][1])],test:[TimeseriesForecastingCustomTrainTestFoldsUtils.forceConvertToUTCTimezoneDate(interval["test"][0]),TimeseriesForecastingCustomTrainTestFoldsUtils.forceConvertToUTCTimezoneDate(interval["test"][1])],arrowDescriptions:{train:$scope.getIntervalArrowDescription(interval["train"]),test:$scope.getIntervalArrowDescription(interval["test"])}}));$scope.validateFixedFolds()};$scope.propagateFixedIntervalChangeFn=function(){$timeout(function(){$scope.mlTaskDesign.customTrainTestIntervals=$scope.uiState.fixedFoldIntervals.map(uiInterval=>{uiInterval["arrowDescriptions"]={train:$scope.getIntervalArrowDescription(uiInterval["train"]),test:$scope.getIntervalArrowDescription(uiInterval["test"])};return{train:[$scope.formatDateWithoutTimezone(uiInterval["train"][0]),$scope.formatDateWithoutTimezone(uiInterval["train"][1])],test:[$scope.formatDateWithoutTimezone(uiInterval["test"][0]),$scope.formatDateWithoutTimezone(uiInterval["test"][1])]}});$scope.validateFixedFolds()})};$scope.validateFixedFolds=function(){$scope.customTrainTestValidationErrors=[];for(let intervalIndex=0;intervalIndex<$scope.mlTaskDesign.customTrainTestIntervals.length;intervalIndex++){const intervalValidationError=TimeseriesForecastingCustomTrainTestFoldsUtils.validateCustomTrainTestFold($scope.mlTaskDesign.timestepParams,$scope.mlTaskDesign.customTrainTestIntervals[intervalIndex],$scope.mlTaskDesign.predictionLength);if(intervalValidationError){$scope.customTrainTestValidationErrors.push("Fold {0} - {1}".format(intervalIndex+1,intervalValidationError))}}};$scope.getIntervalArrowDescription=function(interval){const timestepsCount=TimeseriesForecastingCustomTrainTestFoldsUtils.getIntervalTimestepsCount(interval,$scope.mlTaskDesign.timestepParams);return`${timestepsCount} ${$filter("plurify")($scope.mlTaskDesign.timestepParams.timeunit.replace("_"," ").toLowerCase(),timestepsCount)} (${Math.floor(timestepsCount/$scope.mlTaskDesign.timestepParams["numberOfTimeunits"])} timesteps)`};$scope.resamplingMethodToGraph=function(method,prefix){switch(method){case"NEAREST":return prefix+"-nearest";case"PREVIOUS":return prefix+"-previous";case"NEXT":return prefix+"-next";case"STAIRCASE":return prefix+"-staircase";case"LINEAR":if(prefix==="left")return"left-next";return prefix+"-linear";case"QUADRATIC":return prefix+"-quadratic";case"CUBIC":return prefix+"-cubic";case"CONSTANT":return prefix+"-constant";case"PREVIOUS_NEXT":if(prefix==="left")return"left-next";return"right-previous";case"NO_EXTRAPOLATION":return prefix+"-dont"}};function isAutoArimaSearchExplicit(){if($scope.mlTaskDesign.modeling.gridSearchParams.strategy=="GRID"){return $scope.mlTaskDesign.modeling.autoarima_timeseries.m.gridMode=="EXPLICIT"}else{return $scope.mlTaskDesign.modeling.autoarima_timeseries.m.randomMode=="EXPLICIT"}}$scope.isAutoArimaSeasonal=function(){if(isAutoArimaSearchExplicit()){return Math.max(...$scope.mlTaskDesign.modeling.autoarima_timeseries.m.values)>1}else{return $scope.mlTaskDesign.modeling.autoarima_timeseries.m.range.max>1}};$scope.isAutoArimaSeasonLengthTooHigh=function(){if(isAutoArimaSearchExplicit()){return Math.max(...$scope.mlTaskDesign.modeling.autoarima_timeseries.m.values)>12}else{return $scope.mlTaskDesign.modeling.autoarima_timeseries.m.range.max>12}};$scope.isTrendValid=function(){let sum=$scope.mlTaskDesign.modeling.arima_timeseries.d+$scope.mlTaskDesign.modeling.arima_timeseries.D;switch($scope.mlTaskDesign.modeling.arima_timeseries.trend){case"n":return true;case"c":case"ct":return sum<=0;case"t":return sum<=1;default:return false}};$scope.getAutoArimaMaxOrderMinValue=function(){let minValue=$scope.mlTaskDesign.modeling.autoarima_timeseries.start_p+$scope.mlTaskDesign.modeling.autoarima_timeseries.start_q+1;if($scope.isAutoArimaSeasonal()){minValue+=$scope.mlTaskDesign.modeling.autoarima_timeseries.start_P+$scope.mlTaskDesign.modeling.autoarima_timeseries.start_Q}return minValue};$scope.isOdd=number=>number%2===1;$scope.isPositive=number=>number>0});app.directive("forecastExplanation",function(TimeseriesForecastingUtils){return{scope:{predictionLength:"<",gapSize:"<",numberOfHorizonsInTest:"<",timeUnit:"<",numberOfTimeunits:"<",loadedStateField:"<"},restrict:"A",templateUrl:"/templates/analysis/prediction/timeseries/forecasting-schema.html",link:function($scope,element){const MAX_NB_OF_HORIZONS_IN_SCHEMA=5;$scope.prettyTimeUnit=TimeseriesForecastingUtils.prettyTimeUnit;const puppeteerSelectorName=$scope.loadedStateField;element.attr(puppeteerSelectorName,true);$scope[puppeteerSelectorName]=true;$scope.forecastingSchemaHasEllipsis=function(){if(!$scope.predictionLength)return;return $scope.numberOfHorizonsInTest>MAX_NB_OF_HORIZONS_IN_SCHEMA};$scope.isEllipsedFromForecastingSchema=function(index){return $scope.forecastingSchemaHasEllipsis()&&index==Math.floor(MAX_NB_OF_HORIZONS_IN_SCHEMA/2)};$scope.maxNumberOfHorizonsInSchema=function(){if(!$scope.numberOfHorizonsInTest)return;return Math.min($scope.numberOfHorizonsInTest,MAX_NB_OF_HORIZONS_IN_SCHEMA)};$scope.getHorizonTickLabel=function(index){if($scope.forecastingSchemaHasEllipsis()&&index>=Math.floor(MAX_NB_OF_HORIZONS_IN_SCHEMA/2)){index=$scope.numberOfHorizonsInTest-(MAX_NB_OF_HORIZONS_IN_SCHEMA-index)}const nbHorizons=index+1;const nbTimeUnitsInHorizon=$scope.predictionLength*$scope.numberOfTimeunits;return nbHorizons*nbTimeUnitsInHorizon}}}});app.controller("TimeseriesPMLTaskPreTrainModal",function($scope,$controller,$stateParams,DataikuAPI,Logger,WT1){$controller("PMLTaskPreTrainModal",{$scope:$scope});$controller("_TabularPMLTaskPreTrainBase",{$scope:$scope});function redactSensitiveInformation(eventContent){const redacted=dkuDeepCopy(eventContent,$scope.SettingsService.noDollarKey);if(redacted.timeseriesSamplingParams){delete redacted.timeseriesSamplingParams.numericalInterpolateConstantValue;delete redacted.timeseriesSamplingParams.numericalExtrapolateConstantValue;delete redacted.timeseriesSamplingParams.categoricalConstantValue;redacted.timeseriesSamplingParams=JSON.stringify(redacted.timeseriesSamplingParams)}return redacted}$scope.algosWithoutExternalFeatures=$scope.listAlgosWithoutExternalFeatures($scope.base_algorithms[$scope.mlTaskDesign.backendType]);$scope.algosSlowOnMultipleTimeseries=$scope.listAlgosSlowOnMultipleTimeseries($scope.base_algorithms[$scope.mlTaskDesign.backendType]);$scope.train=()=>$scope.saveSettings().then($scope._doTrainThenResolveModal);$scope._doTrain=function(){try{const algorithms={};$.each($scope.mlTaskDesign.modeling,function(alg,params){if(params.enabled){algorithms[alg]=params}});let wt1Content=redactSensitiveInformation({backendType:$scope.mlTaskDesign.backendType,taskType:$scope.mlTaskDesign.taskType,predictionType:$scope.mlTaskDesign.predictionType,guessPolicy:$scope.mlTaskDesign.guessPolicy,algorithms:JSON.stringify(algorithms),predictionLength:$scope.mlTaskDesign.predictionLength,gapSize:$scope.mlTaskDesign.evaluationParams.gapSize,testSize:$scope.mlTaskDesign.evaluationParams.testSize,nbTimeseriesIdentifiers:$scope.mlTaskDesign.timeseriesIdentifiers.length,nbExternalFeatures:Object.values($scope.mlTaskDesign.preprocessing.per_feature).filter(feature=>feature.role==="INPUT").length,quantiles:JSON.stringify($scope.mlTaskDesign.quantilesToForecast),timestepParams:JSON.stringify($scope.mlTaskDesign.timestepParams),timeseriesSamplingParams:$scope.mlTaskDesign.preprocessing.timeseriesSampling,isPartitioned:$scope.mlTaskDesign.partitionedModel&&$scope.mlTaskDesign.partitionedModel.enabled,nFoldsEvaluation:$scope.mlTaskDesign.splitParams.kfold?$scope.mlTaskDesign.splitParams.nFolds:null,hasSessionName:!!$scope.uiState.userSessionName,hasSessionDescription:!!$scope.uiState.userSessionDescription,gridSearchParams:JSON.stringify($scope.mlTaskDesign.modeling.gridSearchParams),evaluationMetric:$scope.mlTaskDesign.modeling.metrics.evaluationMetric,runsOnKubernetes:$scope.hasSelectedK8sContainer(),usesCustomTrainTestSplit:$scope.mlTaskDesign.customTrainTestSplit,customTrainTestIntervals:$scope.mlTaskDesign.customTrainTestSplit?JSON.stringify($scope.mlTaskDesign.customTrainTestIntervals):null});WT1.event("prediction-train",wt1Content)}catch(e){Logger.error("Failed to report mltask info",e)}return DataikuAPI.analysis.pml.trainStart($stateParams.projectKey,$stateParams.analysisId,$stateParams.mlTaskId,$scope.uiState.userSessionName,$scope.uiState.userSessionDescription,$scope.uiState.forceRefresh,true).error(setErrorInScope.bind($scope))};$scope.displayMessages=function(){return $scope.preTrainStatus.messages.length||$scope.algosWithoutExternalFeatures.length||$scope.algosSlowOnMultipleTimeseries.length||$scope.selectedAlgosMissingRequiredExternalFeature?.length}});app.controller("TimeseriesPMLTaskResultController",function($scope,$controller,PMLSettings,PMLFilteringService){$scope.algorithmCategories=PMLSettings.algorithmCategories("TIMESERIES_FORECAST");$scope.metricMap=PMLFilteringService.metricMap;$controller("_TabularPMLTaskResultController",{$scope:$scope});$scope.uiState.tsSessionDetailView="METRICS";let metrics;let highestMetricValues;let default_displayed_metrics;$scope.$watch("selection.sessionModels",function(nv,ov){if(!nv||nv.length==0)return;metrics=$scope.timeseriesEvaluationMetrics.map(metric=>$scope.metricMap[metric[0]]);default_displayed_metrics=["RMSE","SMAPE","MAPE"];if(!default_displayed_metrics.includes(nv[0].evaluationMetric)){default_displayed_metrics.push(nv[0].evaluationMetric)}$scope.displayableMetrics=$scope.timeseriesEvaluationMetrics.map(function(metric){return{name:metric[0],$displayed:default_displayed_metrics.includes(metric[0])}});highestMetricValues=metrics.reduce(function(res,metric){res[metric]=Math.max(...$scope.selection.sessionModels.map(model=>model[metric]||0));return res},{});let customMetrics=new Set;nv.filter(model=>model.customMetricsResults).forEach(function(model){model.customMetricsResults.filter(customMetricResult=>customMetricResult.didSucceed).forEach(function(customMetricResult){customMetrics.add(customMetricResult.metric.name);if(!(customMetricResult.metric.name in highestMetricValues)||customMetricResult.value>highestMetricValues[customMetricResult.metric.name]){highestMetricValues[customMetricResult.metric.name]=customMetricResult.value}})});customMetrics.forEach(function(customMetric){$scope.displayableMetrics.push({name:customMetric,$displayed:default_displayed_metrics.includes(customMetric)});metrics.push(customMetric)});const newSessionId=(nv[0]||{}).sessionId;const oldSessionId=(ov&&ov[0]||{}).sessionId;if(newSessionId===oldSessionId)return;if($scope.isSessionRunning(newSessionId)&&$scope.anySessionModelNeedsHyperparameterSearch()){$scope.uiState.tsSessionDetailView="HP_SEARCH"}else{$scope.uiState.tsSessionDetailView="METRICS"}});let sessionIdThatWasRunning=null;$scope.$on("mlTaskStatusRefresh",function(){const currentSessionId=($scope.selection&&$scope.selection.sessionModels&&$scope.selection.sessionModels[0]||{}).sessionId;if(!currentSessionId)return;if(!sessionIdThatWasRunning&&$scope.mlTaskStatus.training&&$scope.isSessionRunning(currentSessionId)){sessionIdThatWasRunning=currentSessionId}if(currentSessionId===sessionIdThatWasRunning&&!$scope.mlTaskStatus.training){$scope.uiState.tsSessionDetailView="METRICS";sessionIdThatWasRunning=null}});$scope.anySessionModelHasMetrics=function(){return($scope.selection.sessionModels||[]).some(function(model){return metrics.some(metric=>model[metric])})};$scope.getModelMetric=function(model,metricName){if(metricName in $scope.metricMap){return model[$scope.metricMap[metricName]]}else{const customMetric=model.customMetricsResults.find(customMetric=>metricName==customMetric.metric.name);if(customMetric)return customMetric.value}};$scope.getModelMetricBarRatioHeight=function(model,metricName){const metric=$scope.metricMap[metricName]||metricName;const metricValueForModel=$scope.getModelMetric(model,metricName);if(!metricValueForModel)return 0;const highestMetricValue=highestMetricValues&&highestMetricValues[metric];if(!highestMetricValue)return 0;return metricValueForModel/highestMetricValue};$scope.selectMetric=function(metricIdx){$scope.displayableMetrics[metricIdx].$displayed=!$scope.displayableMetrics[metricIdx].$displayed};$scope.nbDisplayedMetrics=function(){return $scope.displayableMetrics.filter(metric=>metric.$displayed).length};$scope.$watch("uiState.currentMetric",function(nv){if(!nv||!$scope.displayableMetrics)return;const currentMetric=$scope.displayableMetrics.find(metric=>metric.name===$scope.uiState.currentMetric);if(currentMetric)currentMetric.$displayed=true})});app.controller("ExportTimeseriesDataController",function($scope,ExportUtils){$scope.$on("timeseriesTableEvent",function(event,timeseriesTable){$scope.tableHeaders=timeseriesTable.headers;$scope.allTableRows=timeseriesTable.rows});function getSingleTsData(withStats){return $scope.allTableRows.map(row=>{let newRow=[];row.forEach(x=>{newRow.push(x.rawValue||x.displayValue);if(withStats){if(x.rawStderr!==undefined){newRow.push(x.rawStderr)}if(x.rawPvalue!==undefined){newRow.push(x.rawPvalue)}if(x.rawTvalue!==undefined){newRow.push(x.rawTvalue)}}});return newRow})}function getMultipleTsData(){return $scope.allTableRows.map(row=>{let newRow=[];for(const header of $scope.tableHeaders){if(header.rawField){newRow.push(row[header.rawField].rawValue)}else{newRow.push(row[header.field])}}return newRow})}$scope.exportTimeseriesData=function(notAgGridRow,label,valueType,exportPerFold,withStats){let nbTimeseriesIdentifiers=$scope.modelData.coreParams.timeseriesIdentifiers.length;const columns=[];valueType=valueType||"double";exportPerFold=exportPerFold||false;withStats=withStats||false;nbTimeseriesIdentifiers=exportPerFold?nbTimeseriesIdentifiers+3:nbTimeseriesIdentifiers;$scope.tableHeaders.forEach(function(column,i){if(notAgGridRow){columns.push({name:column.rawName||column.displayName,type:i<nbTimeseriesIdentifiers?"string":valueType})}else{columns.push({name:column.headerName||column.field,type:i<nbTimeseriesIdentifiers?"string":valueType})}});let data;if(notAgGridRow){data=getSingleTsData(withStats)}else{data=getMultipleTsData()}ExportUtils.exportUIData($scope,{name:label+" of model "+$scope.modelData.userMeta.name,columns:columns,data:data},`Export model ${label}`)};$scope.noModelCoefficientExplanation=function(){let isArimaAndOrderIsZero=false;isArimaAndOrderIsZero=$scope.modelData.actualParams.resolved.algorithm==="ARIMA"&&["p","q","P","Q"].every(order=>{return $scope.modelData.actualParams.resolved.arima_timeseries_params[order]===0});if(isArimaAndOrderIsZero){return"No coefficients for the selected model since p, q, P and Q are equal to 0"}}});app.controller("InformationCriteriaController",function($scope,DataikuAPI,FutureProgressModal){$scope.retrieveInformationCriteria=function(fullModelId){DataikuAPI.ml.prediction.getInformationCriteria(fullModelId).then(function(res){FutureProgressModal.show($scope,res.data,"Retrieve information criteria").then(function(informationCriteria){if(informationCriteria){$scope.modelData.iperf.informationCriteria=informationCriteria}})}).catch(setErrorInScope.bind($scope))}});app.component("multipleTsInformationCriteria",{bindings:{informationCriteria:"<",timeseriesIdentifierColumns:"<",fullModelId:"<",insightId:"<"},template:`
            <table-manager
                class="h100 model-info-page__table-manager"
                get-rows-for-identifier="$ctrl.getRowsForIdentifier"
                get-headers="$ctrl.getHeaders"
                full-model-id="{{$ctrl.fullModelId}}"
                insight-id="$ctrl.insightId"
                unparsed-timeseries-identifiers="$ctrl.unparsedTimeseriesIdentifiers"
                timeseries-identifier-columns="$ctrl.timeseriesIdentifierColumns"
            ></table-manager>
        `,controller:function($scope,$stateParams,PerTimeseriesService,InformationCriteriaUtils){const $ctrl=this;$ctrl.$onInit=()=>{$ctrl.featureColumns=$ctrl.informationCriteria.map(ic=>{return{field:ic.displayName,rawField:ic.displayName,filter:"agNumberColumnFilter",valueGetter:p=>PerTimeseriesService.getDisplayValue(p,ic)}});$ctrl.unparsedTimeseriesIdentifiers=Object.keys($ctrl.informationCriteria[0].values)};$ctrl.getHeaders=function($scope){return PerTimeseriesService.initTimeseriesIdentifierTableColumns($scope.timeseriesIdentifierColumns,$ctrl.featureColumns)};$ctrl.getRowsForIdentifier=function(parsedTimeseriesIdentifier,unparsedTimeseriesIdentifier,uiState){const row={...parsedTimeseriesIdentifier};$ctrl.informationCriteria.forEach(function(criteria){const criteriaValue=unparsedTimeseriesIdentifier in criteria.values?criteria.values[unparsedTimeseriesIdentifier]:"";row[criteria["displayName"]]={displayValue:InformationCriteriaUtils.formatValue(criteriaValue),rawValue:InformationCriteriaUtils.formatValue(criteriaValue,false)}});return[row]}}});app.component("multipleTsAutoarimaOrders",{bindings:{postTrain:"<",timeseriesIdentifierColumns:"<",fullModelId:"<",insightId:"<"},template:`
            <table-manager
                class="h100 model-info-page__table-manager"
                get-rows-for-identifier="$ctrl.getRowsForIdentifier"
                get-headers="$ctrl.getHeaders"
                full-model-id="{{$ctrl.fullModelId}}"
                insight-id="$ctrl.insightId"
                unparsed-timeseries-identifiers="$ctrl.unparsedTimeseriesIdentifiers"
                timeseries-identifier-columns="$ctrl.timeseriesIdentifierColumns"
            ></table-manager>
        `,controller:function($scope,$stateParams,AutoArimaOrdersService,PerTimeseriesService){const $ctrl=this;$ctrl.$onInit=()=>{$ctrl.resolvedAlgoValues=$ctrl.postTrain.auto_arima_timeseries_params;$ctrl.autoArimaRelevantParams=AutoArimaOrdersService.ordersToDisplay($ctrl.resolvedAlgoValues);$ctrl.unparsedTimeseriesIdentifiers=Object.keys($ctrl.resolvedAlgoValues.p)};$ctrl.getHeaders=function($scope){return PerTimeseriesService.initTimeseriesIdentifierTableColumns($scope.timeseriesIdentifierColumns,$ctrl.autoArimaRelevantParams)};$ctrl.getRowsForIdentifier=function(parsedTimeseriesIdentifier,unparsedTimeseriesIdentifier,uiState){const row={...parsedTimeseriesIdentifier};$ctrl.autoArimaRelevantParams.forEach(function(algoParam){row[algoParam.displayName]=String($ctrl.resolvedAlgoValues[algoParam.fieldName][unparsedTimeseriesIdentifier])});return[row]}}});app.service("InformationCriteriaUtils",function(){this.formatValue=function(informationCriteriaValue,round=true){if(["+∞","-∞"].includes(informationCriteriaValue)){return informationCriteriaValue}if(informationCriteriaValue.value!==""){return round?String(informationCriteriaValue.toFixed(4)):String(informationCriteriaValue)}return informationCriteriaValue}});app.filter("formatFeatureType",function(){return function(featureType){if(!featureType){return}switch(featureType){case"NUMERIC":return"Numerical";case"CATEGORY":return"Categorical";case"TEXT":return"Text";case"VECTOR":return"Vector";case"IMAGE":return"Image"}}});app.filter("formatFeatureRole",function(){return function(featureRole){if(!featureRole){return}switch(featureRole){case"TARGET":return"Target";case"INPUT":return"Known in advance";case"INPUT_PAST_ONLY":return"Past only"}}});app.filter("displayTimeseriesWindowOperation",function(){return function(windowOperation){if(windowOperation==="MEAN"){return"Avg"}else if(windowOperation==="MEDIAN"){return"Median"}else if(windowOperation==="STD"){return"Std. dev."}else if(windowOperation==="MIN"){return"Min"}else if(windowOperation==="MAX"){return"Max"}else if(windowOperation==="FREQUENCY"){return"Frequency"}else{return windowOperation}}});app.component("singleTsInformationCriteria",{bindings:{informationCriteria:"<"},templateUrl:"/templates/ml/prediction-model/timeseries/single-ts-information-criteria.html",controller:function($scope,SINGLE_TIMESERIES_IDENTIFIER,InformationCriteriaUtils){const $ctrl=this;$ctrl.$onInit=()=>{$ctrl.headers=$ctrl.informationCriteria.map(criteria=>{return{displayName:criteria.displayName}});$ctrl.singleRow=$ctrl.informationCriteria.map(function(criteria){return{displayValue:InformationCriteriaUtils.formatValue(criteria.values[SINGLE_TIMESERIES_IDENTIFIER]),rawValue:InformationCriteriaUtils.formatValue(criteria.values[SINGLE_TIMESERIES_IDENTIFIER],false)}});$scope.$emit("timeseriesTableEvent",{headers:$ctrl.headers,rows:[$ctrl.singleRow]})}}});app.component("singleTsAutoarimaOrders",{bindings:{postTrain:"<"},templateUrl:"/templates/ml/prediction-model/timeseries/single-ts-autoarima-orders.html",controller:function($scope,SINGLE_TIMESERIES_IDENTIFIER,AutoArimaOrdersService){const $ctrl=this;$ctrl.$onInit=()=>{$ctrl.SINGLE_TIMESERIES_IDENTIFIER=SINGLE_TIMESERIES_IDENTIFIER;$ctrl.resolvedAutoArimaValues=$ctrl.postTrain.auto_arima_timeseries_params;$ctrl.autoArimaRelevantParams=AutoArimaOrdersService.ordersToDisplay($ctrl.resolvedAutoArimaValues);const singleRow=$ctrl.autoArimaRelevantParams.map(function(order){return{displayValue:$ctrl.resolvedAutoArimaValues[order.displayName][SINGLE_TIMESERIES_IDENTIFIER]}});$scope.$emit("timeseriesTableEvent",{headers:$ctrl.autoArimaRelevantParams,rows:[singleRow]})}}});app.service("AutoArimaOrdersService",function(){return{ordersToDisplay:ordersToDisplay};function ordersToDisplay(resolvedAutoArimaValues){const autoArimaRelevantParams=[{field:"p",displayName:"p",fieldName:"p",helper:"Auto-regressive model order"},{field:"q",displayName:"q",fieldName:"q",helper:"Moving-average model order"}];if(!resolvedAutoArimaValues.stationary){autoArimaRelevantParams.push({field:"d",displayName:"d",fieldName:"d",helper:"Differencing order"})}const isSeasonalAutoARIMA=resolvedAutoArimaValues.m>1;if(isSeasonalAutoARIMA){autoArimaRelevantParams.push({field:"P",displayName:"P",fieldName:"P",helper:"Seasonal auto-regressive model order"});autoArimaRelevantParams.push({field:"Q",displayName:"Q",fieldName:"Q",helper:"Seasonal moving-average model order"});if(!resolvedAutoArimaValues.stationary){autoArimaRelevantParams.push({field:"D",displayName:"D",fieldName:"D",helper:"Seasonal differencing order"})}}return autoArimaRelevantParams}});app.component("modelCoefficientsExplanation",{bindings:{algorithm:"<",predictionLength:"<"},templateUrl:"/templates/ml/prediction-model/timeseries/model-coefficients-explanation.html",controller:function(){const $ctrl=this;const algorithmTitles={ETS:"ETS coefficients",SEASONAL_LOESS:"Seasonal trend coefficients",AUTO_ARIMA:"Seasonal ARIMA coefficients",ARIMA:"Seasonal ARIMA coefficients",PROPHET:"Prophet coefficients",RIDGE_REGRESSION:"Ridge regression coefficients"};$ctrl.$onInit=()=>{$ctrl.title=algorithmTitles[$ctrl.algorithm]};$ctrl.foldableToggle=function(){$ctrl.foldableOpen=!$ctrl.foldableOpen}}});app.component("singleTsModelCoefficients",{bindings:{modelCoefficients:"<",algorithm:"<",predictionLength:"<"},templateUrl:"/templates/ml/prediction-model/timeseries/single-ts-model-coefficients.html",controller:function($scope,SINGLE_TIMESERIES_IDENTIFIER,PerTimeseriesService){const $ctrl=this;$ctrl.$onInit=()=>{$ctrl.modelCoefficientsHeader=PerTimeseriesService.initModelCoefficientsHeader($ctrl.modelCoefficients,false,false,false);$ctrl.canDisplayStatisticalValues=["AUTO_ARIMA","ARIMA","ETS","SEASONAL_LOESS"].includes($ctrl.algorithm);$ctrl.hasStderrs=$ctrl.modelCoefficients.some(coeff=>coeff.stderrs!==undefined&&Object.keys(coeff.stderrs).length>0);$ctrl.hasPvalues=$ctrl.modelCoefficients.some(coeff=>coeff.pvalues!==undefined&&Object.keys(coeff.pvalues).length>0);$ctrl.hasTvalues=$ctrl.modelCoefficients.some(coeff=>coeff.tvalues!==undefined&&Object.keys(coeff.tvalues).length>0);$ctrl.singleRow=$ctrl.modelCoefficients.map(coeff=>{const coefficientHasStderr=coeff.stderrs&&coeff.stderrs[SINGLE_TIMESERIES_IDENTIFIER]!==undefined;const coefficientHasPvalue=coeff.pvalues&&coeff.pvalues[SINGLE_TIMESERIES_IDENTIFIER]!==undefined;const coefficientHasTvalue=coeff.tvalues&&coeff.tvalues[SINGLE_TIMESERIES_IDENTIFIER]!==undefined;return{displayValue:coeff.values[SINGLE_TIMESERIES_IDENTIFIER]?String(coeff.values[SINGLE_TIMESERIES_IDENTIFIER].toFixed(4)):"-",rawValue:coeff.values[SINGLE_TIMESERIES_IDENTIFIER],displayStderr:coefficientHasStderr?String(coeff.stderrs[SINGLE_TIMESERIES_IDENTIFIER].toFixed(4)):"-",rawStderr:coefficientHasStderr?coeff.stderrs[SINGLE_TIMESERIES_IDENTIFIER]:$ctrl.hasStderrs?"-":undefined,displayPvalue:coefficientHasPvalue?String(coeff.pvalues[SINGLE_TIMESERIES_IDENTIFIER].toFixed(4)):"-",rawPvalue:coefficientHasPvalue?coeff.pvalues[SINGLE_TIMESERIES_IDENTIFIER]:$ctrl.hasPvalues?"-":undefined,displayTvalue:coefficientHasTvalue?String(coeff.tvalues[SINGLE_TIMESERIES_IDENTIFIER].toFixed(4)):"-",rawTvalue:coefficientHasTvalue?coeff.tvalues[SINGLE_TIMESERIES_IDENTIFIER]:$ctrl.hasTvalues?"-":undefined}});$scope.$emit("timeseriesTableEvent",{headers:PerTimeseriesService.initModelCoefficientsHeader($ctrl.modelCoefficients,$ctrl.hasStderrs,$ctrl.hasPvalues,$ctrl.hasTvalues),rows:[$ctrl.singleRow]})}}});app.component("multipleTsModelCoefficients",{bindings:{modelCoefficients:"<",postTrain:"<",timeseriesIdentifierColumns:"<",fullModelId:"<",insightId:"<"},template:`
            <table-manager
                class="h100 model-info-page__table-manager"
                get-rows-for-identifier="$ctrl.getRowsForIdentifier"
                get-headers="$ctrl.getHeaders"
                full-model-id="{{$ctrl.fullModelId}}"
                insight-id="$ctrl.insightId"
                unparsed-timeseries-identifiers="$ctrl.unparsedTimeseriesIdentifiers"
                set-flags="$ctrl.setFlags"
                timeseries-identifier-columns="$ctrl.timeseriesIdentifierColumns"
                hide-columns-with-field="$ctrl.getColumnsToHide"
            ></table-manager>
        `,controller:function($scope,$stateParams,PerTimeseriesService){const $ctrl=this;$ctrl.$onInit=function(){$ctrl.unparsedTimeseriesIdentifiers=PerTimeseriesService.retrieveUnparsedTimeseriesIdentifiers($ctrl.postTrain,$ctrl.modelCoefficients)};$ctrl.getColumnsToHide=function(uiState){const fieldsToHide=[];if(!uiState.timeseriesTableStatisticsDisplay.includes("stderr")){fieldsToHide.push("stderr")}if(!uiState.timeseriesTableStatisticsDisplay.includes("p-value")){fieldsToHide.push("pValue")}if(!uiState.timeseriesTableStatisticsDisplay.includes("t-stat")){fieldsToHide.push("tStat")}return fieldsToHide};$ctrl.setFlags=function(uiState){uiState.canDisplayStatisticalValues=["AUTO_ARIMA","ARIMA","ETS","SEASONAL_LOESS"].includes($ctrl.postTrain.algorithm);uiState.hasStderrs=$ctrl.modelCoefficients.some(coeff=>coeff.stderrs!==undefined&&Object.keys(coeff.stderrs).length>0);uiState.hasPvalues=$ctrl.modelCoefficients.some(coeff=>coeff.pvalues!==undefined&&Object.keys(coeff.pvalues).length>0);uiState.hasTvalues=$ctrl.modelCoefficients.some(coeff=>coeff.tvalues!==undefined&&Object.keys(coeff.tvalues).length>0);uiState.isModelCoefficient=true;uiState.hasStatistics=uiState.hasStderrs||uiState.hasPvalues||uiState.hasTvalues;uiState.timeseriesTableStatisticsDisplay=[]};$ctrl.getHeaders=function($scope){const modelCoefficientsHeader=PerTimeseriesService.initModelCoefficientsHeader($ctrl.modelCoefficients,true,true,true);return PerTimeseriesService.initTimeseriesIdentifierTableColumns($scope.timeseriesIdentifierColumns,modelCoefficientsHeader)};$ctrl.getRowsForIdentifier=function(parsedTimeseriesIdentifier,unparsedTimeseriesIdentifier,uiState){const row={...parsedTimeseriesIdentifier};$ctrl.modelCoefficients.forEach(function(coeff){const coefficientValue=unparsedTimeseriesIdentifier in coeff.values?coeff.values[unparsedTimeseriesIdentifier]:"";const displayName=coeff["displayName"];row[displayName]=$ctrl.formatValue(coefficientValue);if(uiState.hasStderrs){row[displayName+" stderr"]=$ctrl.formatValue(coeff.stderrs[unparsedTimeseriesIdentifier])}if(uiState.hasPvalues){row[displayName+" p-value"]=$ctrl.formatValue(coeff.pvalues[unparsedTimeseriesIdentifier])}if(uiState.hasTvalues){row[displayName+" t-stat"]=$ctrl.formatValue(coeff.tvalues[unparsedTimeseriesIdentifier])}});return[row]};$ctrl.formatValue=function(value){if(value&&value!==""){return{displayValue:String(value.toFixed(4)),rawValue:String(value)}}return""}}});app.component("granularTimeseriesMetrics",{bindings:{timeseriesIdentifierColumns:"<",fullModelId:"<",fullModelEvaluationId:"<?",insightId:"<",isKfold:"<",isCurrentlyDisplayingKfold:"="},template:`
            <table-manager
                class="h100 model-info-page__table-manager"
                get-rows-for-identifier="$ctrl.getRowsForIdentifier"
                get-headers="$ctrl.getHeaders"
                full-model-id="{{$ctrl.fullModelId}}"
                unparsed-timeseries-identifiers="$ctrl.unparsedTimeseriesIdentifiers"
                set-flags="$ctrl.setFlags"
                insight-id="$ctrl.insightId"
                timeseries-identifier-columns="$ctrl.timeseriesIdentifierColumns"
                on-ui-change="$ctrl.onUiChange"
                get-additional-filters="$ctrl.getAdditionalFilters"
                get-pinned-rows="$ctrl.calculateAverageRow"
            ></table-manager>
        `,controller:function($scope,$filter,DataikuAPI,PMLSettings,PMLFilteringService,PerTimeseriesService,TimeseriesTableService,$stateParams){const $ctrl=this;$ctrl.unparsedTimeseriesIdentifiers=[];$ctrl.calculateAverageRow=TimeseriesTableService.calculateAverageRow;$ctrl.foldHeaders=[{headerName:"Fold ID",field:"foldId",filter:"agNumberColumnFilter",type:"leftAligned",valueType:"int",pinned:"left"},{headerName:"Start Date",field:"startDate",type:"date"},{headerName:"End Date",field:"endDate",type:"date"}];$ctrl.showPerFold=false;$ctrl.hasIdentifiers=true;$ctrl.isGranularMetrics=true;$ctrl.couldNotLocatePerFoldMetrics=false;$ctrl.customMetricHeaders=[];function getDisplayValueFromMetricNode(params){const rawField=params.colDef.rawField;return params.data[rawField].displayValue}$ctrl.$onInit=function(){const PER_TIMESERIES_EVALUATION_METRICS=["MSE","MAPE","MASE","SMAPE","MAE","MSIS"];const timeseriesEvaluationMetrics=PMLSettings.taskF().timeseriesEvaluationMetrics;$ctrl.metricNameMap=timeseriesEvaluationMetrics.filter(metric=>PER_TIMESERIES_EVALUATION_METRICS.includes(metric[0])).map(function(metric){return{headerName:PMLSettings.names.evaluationMetrics[metric[0]],field:PMLFilteringService.metricMap[metric[0]]+".rawValue",rawField:PMLFilteringService.metricMap[metric[0]],rawName:metric[0],filter:"agNumberColumnFilter",valueFormatter:p=>getDisplayValueFromMetricNode(p)}});if($ctrl.timeseriesIdentifierColumns.length===0){$ctrl.showPerFold=true;$ctrl.isCurrentlyDisplayingKfold=$ctrl.showPerFold;$ctrl.hasIdentifiers=false}if($ctrl.showPerFold){$ctrl.getPerFoldData()}else{$ctrl.getPerTimeseriesData()}};$ctrl.setFlags=function(uiState){uiState.showPerFold=$ctrl.showPerFold;uiState.hasIdentifiers=$ctrl.hasIdentifiers;uiState.isGranularMetrics=$ctrl.isGranularMetrics;uiState.couldNotLocatePerFoldMetrics=$ctrl.couldNotLocatePerFoldMetrics;uiState.isKfold=$ctrl.isKfold;uiState.timeseriesTableFoldFilters=[];uiState.foldIds=$ctrl.foldIds};$ctrl.onUiChange=function(uiState){if($ctrl.showPerFold!==uiState.showPerFold){$ctrl.showPerFold=uiState.showPerFold;$ctrl.isCurrentlyDisplayingKfold=$ctrl.showPerFold;if($ctrl.showPerFold){$ctrl.getPerFoldData()}else{$ctrl.getPerTimeseriesData()}}};$ctrl.getAdditionalFilters=function(uiState){if(uiState.showPerFold){return{foldId:uiState.timeseriesTableFoldFilters.map(x=>Number(x))}}return{}};$ctrl.getPerFoldData=function(){if(!$ctrl.perFoldData){DataikuAPI.ml.prediction.getKfoldPerfs($ctrl.fullModelId).then(function(response){$ctrl.perFoldData=response.data.perFoldMetrics;$ctrl.foldIds=Object.values($ctrl.perFoldData)[0].map(x=>x["foldId"]);$ctrl.unparsedTimeseriesIdentifiers=Object.keys($ctrl.perFoldData)}).catch(response=>{if(response.status===404){$ctrl.unparsedTimeseriesIdentifiers=[];$ctrl.couldNotLocatePerFoldMetrics=true}else{setErrorInScope.bind($scope)}})}else{$ctrl.unparsedTimeseriesIdentifiers=Object.keys($ctrl.perFoldData)}};$ctrl.getPerTimeseriesData=function(){if(!$ctrl.perTimeseriesMetrics){if($ctrl.fullModelEvaluationId){DataikuAPI.modelevaluations.getPerTimeseriesMetrics($ctrl.fullModelEvaluationId).then(({data})=>{$ctrl.perTimeseriesMetrics=data.perTimeseries;$ctrl.unparsedTimeseriesIdentifiers=Object.keys($ctrl.perTimeseriesMetrics)}).catch(setErrorInScope.bind($scope))}else{DataikuAPI.ml.prediction.getPerTimeseriesMetrics($ctrl.fullModelId).then(({data})=>{$ctrl.perTimeseriesMetrics=data.perTimeseries;$ctrl.unparsedTimeseriesIdentifiers=Object.keys($ctrl.perTimeseriesMetrics)}).catch(setErrorInScope.bind($scope))}}else{$ctrl.unparsedTimeseriesIdentifiers=Object.keys($ctrl.perTimeseriesMetrics)}};$ctrl.getCustomMetricHeader=function(foundMetric){const customMetricResults=foundMetric.customMetricsResults||[];return customMetricResults.map(x=>{return{field:"CUSTOM_METRIC"+sanitize(x.metric.name),rawField:"CUSTOM_METRIC"+sanitize(x.metric.name),rawName:x.metric.name,headerName:sanitize(x.metric.name),valueFormatter:p=>getDisplayValueFromMetricNode(p)}})};$ctrl.getHeaders=function($scope){if($scope.uiState.showPerFold){$ctrl.customMetricHeaders=$ctrl.getCustomMetricHeader($ctrl.perFoldData[Object.keys($ctrl.perFoldData)[0]][0].metrics);return PerTimeseriesService.initTimeseriesIdentifierTableColumns($ctrl.timeseriesIdentifierColumns,[...$ctrl.foldHeaders,...$ctrl.metricNameMap,...$ctrl.customMetricHeaders])}else{$ctrl.customMetricHeaders=$ctrl.getCustomMetricHeader($ctrl.perTimeseriesMetrics[Object.keys($ctrl.perTimeseriesMetrics)[0]]);return PerTimeseriesService.initTimeseriesIdentifierTableColumns($ctrl.timeseriesIdentifierColumns,[...$ctrl.metricNameMap,...$ctrl.customMetricHeaders])}};$ctrl.getRowsForIdentifier=function(parsedTimeseriesIdentifier,unparsedTimeseriesIdentifier,uiState){if(uiState.showPerFold){const rows=[];const perTsMetrics=$ctrl.perFoldData[unparsedTimeseriesIdentifier];for(let foldMetric of perTsMetrics){const row={...parsedTimeseriesIdentifier};$ctrl.foldHeaders.forEach(function(header){if(header.valueType==="int"){row[header.field]=Number(foldMetric[header.field])}else{row[header.field]=foldMetric[header.field]}});const metrics=foldMetric.metrics;$ctrl.metricNameMap.filter(metricHeader=>!metricHeader.isCustom).forEach(function(metricHeader){row[metricHeader.rawField]={rawValue:metrics[metricHeader.rawField],displayValue:PerTimeseriesService.createMetricRow(metrics[metricHeader.rawField],metrics[metricHeader.rawField+"std"],metricHeader.rawName)}});if($ctrl.customMetricHeaders.length>0){foldMetric["metrics"].customMetricsResults.forEach(function(customMetric){row["CUSTOM_METRIC"+sanitize(customMetric.metric.name)]={rawValue:customMetric.value,displayValue:PerTimeseriesService.createMetricRow(customMetric.value,customMetric.valuestd,null),rawStd:customMetric.valuestd}})}rows.push(row)}return rows}else{const row={...parsedTimeseriesIdentifier};const data=$ctrl.perTimeseriesMetrics[unparsedTimeseriesIdentifier];$ctrl.metricNameMap.filter(metricHeader=>!metricHeader.isCustom).forEach(function(metricHeader){row[metricHeader.rawField]={rawValue:data[metricHeader.rawField],rawStd:data[metricHeader.rawField+"std"],displayValue:PerTimeseriesService.createMetricRow(data[metricHeader.rawField],data[metricHeader.rawField+"std"],metricHeader.rawName)}});if($ctrl.customMetricHeaders.length>0){data.customMetricsResults.forEach(function(customMetric){row["CUSTOM_METRIC"+sanitize(customMetric.metric.name)]={rawValue:customMetric.value,displayValue:PerTimeseriesService.createMetricRow(customMetric.value,customMetric.valuestd,null),rawStd:customMetric.valuestd}})}return[row]}}}});app.service("PerTimeseriesService",function($filter,SINGLE_TIMESERIES_IDENTIFIER){const COLUMN_WIDTH=160;return{removeDuplicatesAndSortIdentifierValuesForFilterDropdowns:removeDuplicatesAndSortIdentifierValuesForFilterDropdowns,addIdentifierValues:addIdentifierValues,initTimeseriesIdentifierTableColumns:initTimeseriesIdentifierTableColumns,initTimeseriesIdentifiersValues:initTimeseriesIdentifiersValues,initModelCoefficientsHeader: