(function(){"use strict";const app=angular.module("dataiku.flow.graph",[]);app.service("GraphZoomTrackerService",function($timeout,$stateParams,localStorageService){const svc=this;const lsKeyPrefix="zoomCtx-";let zoomCtxKeyLoaded="";let currentCtx={};let disabled=false;svc.initCtx=function(){currentCtx={}};svc.disable=function(disable=true){disabled=disable};svc.isEnabled=function(){return!disabled};function zoneId(){return $stateParams.zoneId?$stateParams.zoneId:""}function projectKey(){return $stateParams.projectKey}function zoomCtxKey(){return lsKeyPrefix+projectKey()+zoneId()}function ensureZoomCtxLoaded(){let isProjectContextLoaded=function(){return zoomCtxKey()==zoomCtxKeyLoaded};let isFocusItemCtxSet=function(){return currentCtx.focusItem&&currentCtx.focusItem.id&&currentCtx.focusItem.projectKey==projectKey()};let timeToCheckLocalStorageUsage=function(){return Date.now()%5==0};if(isProjectContextLoaded()&&isFocusItemCtxSet()){currentCtx={...blankCtx,...currentCtx};return}clearContext();const restored=localStorageService.get(zoomCtxKey());if(restored&&restored.panzoom){zoomCtxKeyLoaded=zoomCtxKey();currentCtx.focusItem=restored.focusItem?restored.focusItem:{};currentCtx.nodeCount=restored.nodeCount?restored.nodeCount:0;if(svc.isValidPanZoom(restored.panzoom)){angular.copy(restored.panzoom,currentCtx.panzoom)}else{currentCtx.panzoom={}}currentCtx.foldState=restored.foldState||[]}if(timeToCheckLocalStorageUsage())$timeout(()=>tidyLocalStorage(),2e3)}const blankCtx={focusItem:{},nodeCount:0,panzoom:{},foldState:[]};function clearContext(){zoomCtxKeyLoaded="";angular.copy(blankCtx,currentCtx)}function setLocalStorage(zoomKey){if(projectKey()==undefined||zoomKey!==zoomCtxKey()||currentCtx.isSaving){return}currentCtx.modified=Date.now();localStorageService.set(zoomKey,currentCtx)}function setPanzoom(pz){const pzToSave={};["x","y","height","width"].forEach(f=>pzToSave[f]=pz[f]);currentCtx.panzoom=angular.copy(pzToSave)}svc.hasPanzoom=function(){const restored=localStorageService.get(zoomCtxKey());if(restored&&restored.panzoom){zoomCtxKeyLoaded=zoomCtxKey();return svc.isValidPanZoom(restored.panzoom)}return false};svc.instantSavePanZoomCtx=function(pz){if(disabled===true){return}setPanzoom(pz);setLocalStorage(zoomCtxKey())};svc.lazySaveZoomCtx=function(pz){if(disabled===true){return}setPanzoom(pz);if(!currentCtx.isSaving){currentCtx.isSaving=true;const zoomKey=zoomCtxKey();$timeout(()=>{delete currentCtx.isSaving;setLocalStorage(zoomKey)},1e3)}};function tidyLocalStorage(){const numLsKeysToKeep=10;const maxNumLsKeysAllowed=15;let getLsDateModified=function(key){return new Date(localStorageService.get(key).modified)};const keys=localStorageService.keys().filter(k=>k.startsWith(lsKeyPrefix));if(keys.length>maxNumLsKeysAllowed){keys.sort((a,b)=>{const aDate=getLsDateModified(a);const bDate=getLsDateModified(b);return aDate>bDate?-1:aDate<bDate?1:0});const keysToDelete=keys.splice(numLsKeysToKeep);keysToDelete.forEach(k=>localStorageService.remove(k))}}function updateFoldStateList(foldStateList,foldCmd){const listLen=foldStateList.length;let foundFirstFold=false;if(foldCmd.action=="unfold"){foldStateList=foldStateList.filter(oldCmd=>{if(!foundFirstFold){foundFirstFold=oldCmd.action=="fold";if(!foundFirstFold)return false}return oldCmd.nodeId!=foldCmd.nodeId||oldCmd.direction!=foldCmd.direction})}if(listLen==foldStateList.length){foldStateList.push(foldCmd)}return foldStateList}svc.setFocusItemCtx=function(node,nodeChangedByName=false){if(disabled===true){return}currentCtx.focusItem={id:node.id,nodeChangedByName:nodeChangedByName,projectKey:projectKey()};ensureZoomCtxLoaded();setLocalStorage(zoomCtxKey())};svc.resetFocusItemCtx=function(){currentCtx.focusItem={};setLocalStorage(zoomCtxKey())};svc.setFocusItemByFullId=function(type,fullId){if(disabled===true){return}if(!fullId)return;ensureZoomCtxLoaded();currentCtx.focusItem.id=graphVizEscape(type+"_"+fullId);currentCtx.focusItem.nodeChangedByName=true;setLocalStorage(zoomCtxKey())};svc.setFocusItemById=function(type,id){if(disabled===true){return}let isIncludeProjRefInNodeId=function(type){return type!="recipe"};if(!id)return;const proj=isIncludeProjRefInNodeId(type)?projectKey()+".":"";svc.setFocusItemByFullId(type,proj+id)};svc.setFlowRedrawn=function(newNodeCount){currentCtx.focusItem.nodeChangedByName=false;currentCtx.nodeCount=newNodeCount};svc.setFoldCommand=function(foldCmd){currentCtx.foldState=updateFoldStateList(currentCtx.foldState,foldCmd);setLocalStorage(zoomCtxKey())};svc.resetFoldState=function(commands){currentCtx.foldState=commands||[];setLocalStorage(zoomCtxKey())};svc.removeLastFoldCommand=function(){currentCtx.foldState.pop();setLocalStorage(zoomCtxKey())};svc.restoreZoomCtx=function(activePz,defaultPz){if(disabled===true){return}ensureZoomCtxLoaded();if(currentCtx&&currentCtx.panzoom&&svc.isValidPanZoom(currentCtx.panzoom)&&activePz&&defaultPz){angular.copy(defaultPz,activePz);angular.extend(activePz,currentCtx.panzoom);return true}return false};svc.getSafeFocusItemId=function(flowGraph){if(disabled===true){return}if(flowGraph&&currentCtx.focusItem&&currentCtx.focusItem.id){if(!flowGraph.node(currentCtx.focusItem.id)){if(currentCtx.focusItem.nodeChangedByName){currentCtx.focusItem.id=svc.getZoomedName(flowGraph,currentCtx.focusItem.id)}if(!flowGraph.node(currentCtx.focusItem.id)){currentCtx.focusItem.id=""}}}return currentCtx.focusItem?currentCtx.focusItem.id:""};svc.getZoomedName=(flowGraph,id)=>{if(!id||id.startsWith("zone_")){return id}const graph=flowGraph.get();if(!graph.hasZones&&!$stateParams.zoneId){return id}const sharedBetweenZones=graph.zonesUsedByRealId[id];if(sharedBetweenZones){const node=flowGraph.node(graphVizEscape(`zone_${sharedBetweenZones[0]}_`)+id);if(node&&flowGraph.node(graphVizEscape(`zone_${node.ownerZone}_`)+id)){return graphVizEscape(`zone_${node.ownerZone}_`)+id}}const foundName=Object.keys(graph.nodes).find(it=>it.endsWith(id));if(foundName){return foundName}return id};svc.getNodeCount=function(){return currentCtx.nodeCount};function isValidDimension(d){return angular.isDefined(d)&&isFinite(d)&&d>0}svc.isValidPanZoom=function(pz){return isValidDimension(pz.width)&&isValidDimension(pz.height)};svc.wasNodeChangedOutsideFlow=function(){return!!currentCtx.focusItem.nodeChangedByName};svc.getFoldState=function(){return currentCtx.foldState};svc.getPreviewFoldState=function(foldCmd){const previewFoldState=angular.copy(currentCtx.foldState);return updateFoldStateList(previewFoldState,foldCmd)}});app.factory("FlowZoneMoveService",function(){const COLLAPSED_ZONE_WIDTH=300+2*64;const COLLAPSED_ZONE_HEIGHT=44;const service={setZoneEdges:setZoneEdges,updateZonesDimensions:updateZonesDimensions};return service;function setZoneEdges(svg,zoneId,nodesGraph){const edgesToZone=svg.find(`g[data-to="${zoneId}"]`);const edgesFromZone=svg.find(`g[data-from="${zoneId}"]`);const zonesFrom=[...new Set(edgesToZone.toArray().map(element=>element.getAttribute("data-from")))];const zonesTo=[...new Set(edgesFromZone.toArray().map(element=>element.getAttribute("data-to")))];const zone=nodesGraph.nodes[zoneId];const dispatchedZonesFrom=dispatchZones(zonesFrom,zone,nodesGraph,"TO");const dispatchedZonesTo=dispatchZones(zonesTo,zone,nodesGraph,"FROM");let rightZones=[...dispatchedZonesFrom.rightZones,...dispatchedZonesTo.rightZones];let leftZones=[...dispatchedZonesFrom.leftZones,...dispatchedZonesTo.leftZones];let topZones=[...dispatchedZonesFrom.topZones,...dispatchedZonesTo.topZones];let bottomZones=[...dispatchedZonesFrom.bottomZones,...dispatchedZonesTo.bottomZones];rightZones.sort(zonesSortingFunction(zoneId,false));leftZones.sort(zonesSortingFunction(zoneId,false));topZones.sort(zonesSortingFunction(zoneId,true));bottomZones.sort(zonesSortingFunction(zoneId,true));edgesToZone.find("path").remove();edgesFromZone.find("path").remove();const rightPositions=rightZones.map((otherZoneInfo,idx)=>{let x=zone.position.x+zone.position.width;if(otherZoneInfo.direction==="TO"){x+=2.8}const y=computeEdgePositionOnZoneSide(zone,idx,rightZones.length,true);return{info:otherZoneInfo,x:x,y:y}});const leftPositions=leftZones.map((otherZoneInfo,idx)=>{let x=zone.position.x;if(otherZoneInfo.direction==="TO"){x-=2.8}const y=computeEdgePositionOnZoneSide(zone,idx,leftZones.length,true);return{info:otherZoneInfo,x:x,y:y}});const topPositions=topZones.map((otherZoneInfo,idx)=>{const x=computeEdgePositionOnZoneSide(zone,idx,topZones.length,false);let y=zone.position.y;if(otherZoneInfo.direction==="TO"){y-=2.8}return{info:otherZoneInfo,x:x,y:y}});const bottomPositions=bottomZones.map((otherZoneInfo,idx)=>{const x=computeEdgePositionOnZoneSide(zone,idx,bottomZones.length,false);let y=zone.position.y+zone.position.height;if(otherZoneInfo.direction==="TO"){y+=2.8}return{info:otherZoneInfo,x:x,y:y}});const allPositions=[...rightPositions,...leftPositions,...topPositions,...bottomPositions];allPositions.forEach(position=>{if(position.info.direction==="FROM"){edgesFromZone.filter(`g[data-to="${position.info.id}"]`).each(function(){addOrUpdateLine($(this),position.x,position.y,"FROM")})}else{edgesToZone.filter(`g[data-from="${position.info.id}"]`).each(function(){addOrUpdateLine($(this),position.x,position.y,"TO");$(this).find("ellipse").attr("cx",`${position.x}`).attr("cy",`${position.y}`)})}})}function computeEdgePositionOnZoneSide(zone,edgeIdx,nEdges,isRightOrLeftSide){if(isRightOrLeftSide){return zone.position.y+.5*zone.position.height+(nEdges===1?0:(-1/2+edgeIdx/(nEdges-1))*.5*zone.position.height)}return zone.position.x+.5*zone.position.width+(nEdges===1?0:(-1/2+edgeIdx/(nEdges-1))*.5*zone.position.width)}function addOrUpdateLine(edgeGElt,x,y,direction){if(edgeGElt.find("line").length){if(direction==="FROM"){edgeGElt.find("line").attr("x1",`${x}`).attr("y1",`${y}`)}else{edgeGElt.find("line").attr("x2",`${x}`).attr("y2",`${y}`)}}else{edgeGElt[0].appendChild(makeSVG("line",{x1:`${direction==="FROM"?x:0}`,y1:`${direction==="FROM"?y:0}`,x2:`${direction==="TO"?x:0}`,y2:`${direction==="TO"?y:0}`,stroke:"black"}))}}function computeZoneHeight(height,zoneId,collapsedZones){if(!collapsedZones.includes(zoneId.replace(/^zone_/,""))){return height}else{return COLLAPSED_ZONE_HEIGHT}}function computeZoneWidth(width,zoneId,collapsedZones){if(!collapsedZones.includes(zoneId.replace(/^zone_/,""))){return width}else{return Math.min(COLLAPSED_ZONE_WIDTH,width)}}function updateZonesDimensions(nodesGraph,collapsedZones){Object.values(nodesGraph.nodes).filter(node=>node.nodeType==="ZONE").forEach(node=>{node.position.width=computeZoneWidth(node.position.width,node.id,collapsedZones);node.position.height=computeZoneHeight(node.position.height,node.id,collapsedZones)})}function dispatchZones(otherZones,referenceZone,nodesGraph,direction){const rightThreshold=referenceZone.position.x+referenceZone.position.width;const leftThreshold=referenceZone.position.x;const bottomThreshold=referenceZone.position.y+referenceZone.position.height;let rightZones=[];let leftZones=[];let topZones=[];let bottomZones=[];otherZones.forEach(otherZoneId=>{const otherZone=nodesGraph.nodes[otherZoneId];if(otherZone.position.x>rightThreshold){rightZones.push({id:otherZoneId,position:otherZone.position,direction:direction})}else if(otherZone.position.y>bottomThreshold){bottomZones.push({id:otherZoneId,position:otherZone.position,direction:direction})}else if(otherZone.position.x+otherZone.position.width<leftThreshold){leftZones.push({id:otherZoneId,position:otherZone.position,direction:direction})}else{topZones.push({id:otherZoneId,position:otherZone.position,direction:direction})}});return{rightZones:rightZones,bottomZones:bottomZones,leftZones:leftZones,topZones:topZones}}function zonesSortingFunction(referenceZoneId,onXAxis){return function(zoneInfo1,zoneInfo2){if(zoneInfo1.id===zoneInfo2.id){const fromBeforeTo=zoneInfo1.id<referenceZoneId;if(zoneInfo1.direction==="FROM"&&zoneInfo2.direction==="TO"){return fromBeforeTo?-1:1}else{return fromBeforeTo?1:-1}}else{if(onXAxis){return zoneInfo1.position.x-zoneInfo2.position.x}else{return zoneInfo1.position.y-zoneInfo2.position.y}}}}});app.service("RecipeFlowIconsService",function(){const DICT={sync:"recipe_sync_circle_fill",shaker:"recipe_prepare_circle_fill",update:"recipe_push_to_editable_circle_fill",sampling:"recipe_filter_circle_fill",grouping:"recipe_group_circle_fill",upsert:"recipe_upsert_circle_fill",distinct:"recipe_distinct_circle_fill",split:"recipe_split_circle_fill",topn:"recipe_top_n_circle_fill",sort:"recipe_sort_circle_fill",vstack:"recipe_stack_circle_fill",generate_features:"recipe_auto_feature_circle_fill",join:"recipe_join_with_circle_fill",fuzzyjoin:"recipe_fuzzy_join_circle_fill",geojoin:"recipe_geo_join_circle_fill",window:"recipe_window_circle_fill",export:"recipe_export_circle_fill",extract_failed_rows:"recipe_extract_failed_rows",pivot:"recipe_pivot_circle_fill",download:"recipe_download_circle_fill",merge_folder:"recipe_merge_folder_circle_fill",list_folder_contents:"recipe_list_folder_contents_circle_fill",list_access:"recipe_list_access_circle_fill",embed_documents:"recipe_embed_documents_circle_fill",extract_content:"recipe_extract_content_circle_fill",sql_script:"recipe_sql_circle_fill",sql_query:"recipe_sql_circle_fill",python:"recipe_python_circle_fill",julia:"recipe_julia_circle_fill",r:"recipe_r_circle_fill",shell:"recipe_shell_circle_fill",pig:"recipe_pig_circle_fill",hive:"recipe_hive_circle_fill",impala:"recipe_impala_circle_fill",pyspark:"recipe_sparkpython_circle_fill",sparkr:"recipe_sparkr_circle_fill",spark_scala:"recipe_sparkscala_circle_fill",spark_sql_query:"recipe_sparksql_circle_fill",clustering_cluster:"recipe_cluster_circle_fill",clustering_training:"recipe_train_circle_fill",clustering_scoring:"recipe_cluster_circle_fill",prediction_training:"recipe_train_circle_fill",prediction_scoring:"recipe_score_circle_fill",evaluation:"recipe_evaluation_circle_fill",standalone_evaluation:"recipe_standalone_evaluation_circle_fill",eda_pca:"recipe_principal_component_analysis_circle_fill",eda_stats:"recipe_statistical_test_circle_fill",eda_univariate:"recipe_univariate_analysis_circle_fill",csync:"recipe_sync_circle_fill",streaming_spark_scala:"recipe_sparkscala_circle_fill",cpython:"recipe_python_circle_fill",ksql:"recipe_ksql_circle_fill",prompt:"recipe_prompt_circle_fill",nlp_llm_user_provided_classification:"recipe_text_classification_circle_fill",nlp_llm_model_provided_classification:"recipe_text_classification_circle_fill",nlp_llm_summarization:"recipe_summarization_circle_fill",nlp_llm_finetuning:"recipe_fine_tuning_circle_fill",nlp_llm_rag_embedding:"recipe_rag_embedding_circle_fill",nlp_llm_evaluation:"recipe_evaluation_llm_circle_fill",nlp_agent_evaluation:"recipe_evaluation_agent_circle_fill",labeling_task:"recipe_labeling_circle_fill"};return{getRecipeFlowIcon:getRecipeFlowIcon};function getRecipeFlowIcon(recipeType){if(!!recipeType&&(recipeType.startsWith("CustomCode_")||recipeType.startsWith("App_"))){return"recipe_empty_circle_fill"}return DICT[recipeType]||"icon-"+(recipeType||"").toLowerCase()}});app.filter("recipeFlowIcon",function(RecipeFlowIconsService){return function(recipeType){return RecipeFlowIconsService.getRecipeFlowIcon(recipeType)}});app.directive("flowCommon",function($state,$stateParams,$rootScope,FlowGraphSelection,FlowGraph,GraphZoomTrackerService){return{restrict:"EA",scope:true,link:function(scope,element){function setRightColumnItem(){scope.rightColumnSelection=FlowGraphSelection.getSelectedNodes();if(scope.rightColumnSelection.length==0){scope.rightColumnItem=null;if($stateParams.zoneId){const node=FlowGraph.node(`zone_${$stateParams.zoneId}`);if(node){scope.rightColumnItem=node;scope.rightColumnSelection=[node];GraphZoomTrackerService.setFocusItemCtx(node)}}else if($state.current.name.startsWith("projects.project.flow")){scope.rightColumnItem={nodeType:"PROJECT"}}}else if(scope.rightColumnSelection.length==1){scope.rightColumnItem=scope.rightColumnSelection[0]}else if(scope.rightColumnSelection.every(node=>["DATASET","LOCAL_DATASET","FOREIGN_DATASET"].includes(node.nodeType))){scope.rightColumnItem={nodeType:"MULTI_DATASETS",selection:scope.rightColumnSelection}}else{scope.rightColumnItem={nodeType:"MULTI",selection:scope.rightColumnSelection}}}scope.focusLast=function(){if(scope.previousRightColumnItemId){FlowGraphSelection.clearSelection();scope.zoomGraph(scope.previousRightColumnItemId);FlowGraphSelection.onItemClick(scope.previousRightColumnItemId)}};const h=$rootScope.$on("flowSelectionUpdated",setRightColumnItem);scope.$on("$destroy",h)}}});app.directive("flowGraph",function($rootScope,$stateParams,Logger,FlowGraph,ProjectFlowGraphStyling,InterProjectGraphStyling,ProjectFlowGraphLayout,InterProjectGraphLayout,FlowGraphFiltering,FlowGraphSelection,JobFlowGraphSelection,FlowGraphFolding,GraphZoomTrackerService,Debounce,DataikuAPI,FlowZoneMoveService,DetectUtils){return{restrict:"EA",controller:function($scope,$element,$attrs){$scope.FlowGraph=FlowGraph;GraphZoomTrackerService.initCtx();GraphZoomTrackerService.disable(false);let nextResizeEnabled=true;function disableNextResize(disabled=true){nextResizeEnabled=disabled===false}$scope.$on("disableNextFlowResize",disableNextResize);$scope.setGraphData=function setGraphData(serializedGraph){if(serializedGraph){$scope.nodesGraph=serializedGraph;if($scope.zonesManualPositioning){FlowZoneMoveService.updateZonesDimensions($scope.nodesGraph,$scope.collapsedZones)}FlowGraph.set($scope.nodesGraph);$scope.nodesGraph.nodesOnGraphCount=Object.keys(serializedGraph.nodes).filter(it=>$stateParams.zoneId?it.startsWith(`zone__${$stateParams.zoneId}`):true).length;$scope.isFlowEmpty=!serializedGraph.hasZoneSharedObjects&&$scope.nodesGraph.nodesOnGraphCount===0;if($scope.FlowGraph.nodeCount()>100){$element.addClass("performance")}}};function setupZoomBehavior(){$scope.panzoom={x:0,y:0,width:undefined,height:undefined,maxWidth:undefined,maxHeight:undefined,WIDTH:$element.legacyWidth(),HEIGHT:$element.legacyHeight()};let h;const resizeStrategies={reinit:"reinit",usePanZoom:"zoom",zoomToFocusItem:"item",highlight:"highlight"};const smallFlowNodeCount=10;function getResizeStrategy(currentNodeCount){let strategy=resizeStrategies.reinit;if($scope.strategy){strategy=$scope.strategy}else{if($rootScope.appConfig.userSettings.disableFlowZoomTracking||!currentNodeCount){return strategy}if(GraphZoomTrackerService.isValidPanZoom($scope.panzoom)){const focusItemId=GraphZoomTrackerService.getSafeFocusItemId($scope.FlowGraph);if(focusItemId&&$scope.FlowGraph.node(focusItemId)&&GraphZoomTrackerService.wasNodeChangedOutsideFlow()){strategy=resizeStrategies.zoomToFocusItem}else{strategy=resizeStrategies.usePanZoom}}const previousNodeCount=GraphZoomTrackerService.getNodeCount();if(currentNodeCount<=smallFlowNodeCount&&currentNodeCount!=previousNodeCount){strategy=resizeStrategies.reinit}}return strategy}function setResizeStrategy(scope,strategy="reinit"){if(strategy&&resizeStrategies[strategy]){$scope.strategy=resizeStrategies[strategy]}}$scope.$on("setResizeStrategy",setResizeStrategy);function getFractionalDistOfItemToEdge(bbItem,bbFlow,dimension,viewBoxLength){const length=dimension=="x"?"width":"height";const start=dimension;let extentOfItem=bbItem[start]+bbItem[length];let extentOfFlow=bbFlow[start]+bbFlow[length];return(extentOfFlow-extentOfItem)/viewBoxLength}function normaliseAspectRatio(pz){const viewBoxAR=pz.width/pz.height;const elementAR=pz.WIDTH/pz.HEIGHT;if(viewBoxAR!=elementAR){pz.width=pz.height*elementAR}return pz}function resize(forcedReinit){let zoomTrackingEnabled=GraphZoomTrackerService.isEnabled();if($scope.isFlowEmpty||!$scope.svg||!$scope.svg.length){return false}$scope.panzoom.WIDTH=$element.legacyWidth();$scope.panzoom.HEIGHT=$element.legacyHeight();const bbFlow=$scope.svg.find("g.graph")[0].getBBox();const defaultPz=buildDefaultPanZoomSettings($scope.panzoom,bbFlow);let pz=$scope.panzoom;if(!GraphZoomTrackerService.isValidPanZoom($scope.panzoom)){pz=angular.copy(defaultPz)}let isReloadedZoomCtx;if(zoomTrackingEnabled){isReloadedZoomCtx=GraphZoomTrackerService.restoreZoomCtx(pz,defaultPz)}$scope.setPanZoom(normaliseAspectRatio(pz));const nodeCount=$scope.FlowGraph.nodeCount();let strategy=getResizeStrategy(nodeCount);let nodeIdToFocus=GraphZoomTrackerService.getSafeFocusItemId($scope.FlowGraph);if(forcedReinit===true){strategy=resizeStrategies.reinit;nodeIdToFocus=undefined;FlowGraphFolding.clearFoldState();FlowGraph.setGraphBBox(bbFlow)}if(strategy==resizeStrategies.usePanZoom){if(isReloadedZoomCtx)$scope.redraw()}else if(strategy==resizeStrategies.zoomToFocusItem){const wPrev=$scope.panzoom.width;const hPrev=$scope.panzoom.height;const node=$scope.nodesGraph.nodes[nodeIdToFocus];const selector=$scope.getSelector(nodeIdToFocus,node);let bb=FlowGraphFiltering.getBBoxFromSelector($scope.svg,selector);let xPosInCell=.5;let yPosInCell=.5;const centerOnItemX=bbFlow.width>wPrev;const centerOnItemY=bbFlow.height>hPrev;let boxToCentreForX=centerOnItemX?bb:bbFlow;let boxToCentreForY=centerOnItemY?bb:bbFlow;if(centerOnItemX){const edgeFraction=getFractionalDistOfItemToEdge(bb,bbFlow,"x",wPrev);if(edgeFraction<.25)xPosInCell=.8-edgeFraction;if((bb.x-bbFlow.x)/wPrev<.25)xPosInCell=.25}if(centerOnItemY){const edgeFraction=getFractionalDistOfItemToEdge(bb,bbFlow,"y",hPrev);if(edgeFraction<.2)yPosInCell=.8-edgeFraction;if((bb.y-bbFlow.y)/hPrev<.25)yPosInCell=.25}$scope.panzoom.x=boxToCentreForX.x+boxToCentreForX.width*xPosInCell-wPrev*xPosInCell;$scope.panzoom.y=boxToCentreForY.y+boxToCentreForY.height*yPosInCell-hPrev*yPosInCell;$scope.panzoom.height=hPrev;$scope.panzoom.width=wPrev;$scope.redraw()}else if(strategy===resizeStrategies.highlight){let bbox=FlowGraphFiltering.getBBoxFromSelector($scope.svg,".highlight");$scope.zoomToBbox(bbox)}else{$scope.setPanZoom(defaultPz);let paddingFactor=1.2;if(nodeCount)paddingFactor+=(smallFlowNodeCount-Math.min(nodeCount,smallFlowNodeCount))*.08;zoomTo(paddingFactor)}if(nodeIdToFocus){FlowGraph.indexNodesCoordinates($scope.svg,bbFlow);let selected=FlowGraphSelection.getSelectedNodes()||[];const selectedIdsWithNodeIdToFocus=Array.from(new Set([...selected.map(node=>node.id),nodeIdToFocus]));FlowGraphSelection.selectNodesFromIds(selectedIdsWithNodeIdToFocus);applyFlowFolding()}else{h&&clearTimeout(h);h=setTimeout(function(){FlowGraph.indexNodesCoordinates($scope.svg,bbFlow);applyFlowFolding()},500)}zoomTrackingEnabled===true&&GraphZoomTrackerService.setFlowRedrawn(nodeCount);return true}function applyFlowFolding(){if($attrs.showFolding)FlowGraphFolding.restoreState(GraphZoomTrackerService.getFoldState())}function resizeListener(){resize();if(!$scope.$$phase){$scope.$apply()}}var debouncedResizeListener=Debounce().withDelay(20,20).wrap(resizeListener);$(window).on("resize",debouncedResizeListener);$scope.$on("$destroy",param=>{if(!param.currentScope.projectFlow||!(param.currentScope.nodesGraph&&param.currentScope.nodesGraph.hasZones||param.currentScope.zoneIdLoaded)){GraphZoomTrackerService.instantSavePanZoomCtx($scope.panzoom)}$(window).off("resize",debouncedResizeListener)});$scope.$on("resizePane",resize);$scope.$watch("svg",function(){if(nextResizeEnabled){setTimeout(function(){if(resize($scope.isResetZoomNeeded))$rootScope.$emit("flowDisplayUpdated");$scope.isResetZoomNeeded=false})}else{nextResizeEnabled=true}});function keepPanZoomDimSane(pz,bbflow,start,length,nearFraction){if(pz[start]+(1-nearFraction)*pz[length]<bbflow[start]){pz[start]=(nearFraction-1)*pz[length]+bbflow[start]}if(bbflow[length]+bbflow[start]<pz[start]+nearFraction*pz[length]){pz[start]=bbflow[start]+bbflow[length]-nearFraction*pz[length]}return pz}function keepPanZoomSane(pz){const bbFlow=$scope.svg.find("g.graph")[0].getBBox();pz=keepPanZoomDimSane(pz,bbFlow,"x","width",.3);pz=keepPanZoomDimSane(pz,bbFlow,"y","height",.4);return pz}$scope.redraw=function(){if($scope.svg&&$scope.svg.length){$scope.panzoom=keepPanZoomSane($scope.panzoom);GraphZoomTrackerService.lazySaveZoomCtx($scope.panzoom);$scope.svg[0].setAttribute("viewBox",[$scope.panzoom.x,$scope.panzoom.y,$scope.panzoom.width,$scope.panzoom.height].join(", "))}};$scope.getPanZoom=function(){return angular.copy($scope.panzoom)};$scope.setPanZoom=function(panzoom){$scope.panzoom=angular.copy(panzoom);$scope.redraw()};$scope.bbox=function(bbox){$scope.panzoom.x=bbox.x;$scope.panzoom.y=bbox.y;if(bbox.width/bbox.height>$scope.panzoom.WIDTH/$scope.panzoom.HEIGHT){$scope.panzoom.width=bbox.width;$scope.panzoom.height=bbox.width*($scope.panzoom.HEIGHT/$scope.panzoom.WIDTH);$scope.panzoom.y=bbox.y-($scope.panzoom.height-bbox.height)/2}else{$scope.panzoom.width=bbox.height*($scope.panzoom.WIDTH/$scope.panzoom.HEIGHT);$scope.panzoom.height=bbox.height;$scope.panzoom.x=bbox.x-($scope.panzoom.width-bbox.width)/2}$scope.redraw()};const WHEEL_ZOOM_STEP=1.1;$element.on("mousewheel",function(e){let scale=1;if(e.originalEvent.wheelDeltaY!=0){scale=e.originalEvent.wheelDeltaY<0?WHEEL_ZOOM_STEP:1/WHEEL_ZOOM_STEP}const eOrig=e.originalEvent&&angular.isDefined(e.originalEvent.layerX)?e.originalEvent:undefined;zoomTo(scale,eOrig?eOrig.layerX:e.offsetX,eOrig?eOrig.layerY:e.offsetY);e.stopPropagation();e.preventDefault()});Mousetrap.bind("Z R",()=>$scope.resizeToShowAll());Mousetrap.bind("Z A",()=>$scope.resizeToShowAll());$scope.reinitGraph=()=>{resize(true)};$scope.$on("$destroy",_=>{Mousetrap.unbind("Z R");Mousetrap.unbind("Z A")});$scope.zoomIn=()=>{zoomTo(1/WHEEL_ZOOM_STEP,$scope.panzoom.WIDTH/2,$scope.panzoom.HEIGHT/2)};$scope.zoomOut=()=>{zoomTo(WHEEL_ZOOM_STEP,$scope.panzoom.WIDTH/2,$scope.panzoom.HEIGHT/2)};$scope.resizeToShowAll=()=>{$scope.resetPanZoom();$rootScope.$emit("drawGraph",true,true);FlowGraphSelection.refreshStyle(true)};$scope.resetPanZoom=function(){$scope.isResetZoomNeeded=true};if(isTouchDevice()){let onTouchStart=function(){let previousPinchDistance;function computePinchDistance(e){let t1=e.originalEvent.touches[0];let t2=e.originalEvent.touches[1];let distance=Math.sqrt(Math.pow(Math.max(t1.screenX,t2.screenX)-Math.min(t1.screenX,t2.screenX),2)+Math.pow(Math.max(t1.screenY,t2.screenY)-Math.min(t1.screenY,t2.screenY),2));return distance}function computePinchMiddle(e){let t1=e.originalEvent.touches[0];let t2=e.originalEvent.touches[1];let offset=$($element).offset();let c1={x:t1.pageX-offset.left,y:t1.pageY-offset.top};let c2={x:t2.pageX-offset.left,y:t2.pageY-offset.top};let middle={x:(c1.x+c2.x)/2,y:(c1.y+c2.y)/2};return middle}function onTouchMove(e){e.stopPropagation();e.preventDefault();let distance=computePinchDistance(e);if(!isNaN(previousPinchDistance)){let scale=previousPinchDistance/distance;let middle=computePinchMiddle(e);requestAnimationFrame(_=>zoomTo(scale,middle.x,middle.y))}previousPinchDistance=distance}function onTouchEnd(e){$element.off("touchmove",onTouchMove);$element.off("touchend",onTouchEnd);e.stopPropagation();e.preventDefault()}return function(e){e.stopPropagation();e.preventDefault();if(e.originalEvent.targetTouches.length!==2){return}previousPinchDistance=computePinchDistance(e);$element.on("touchmove",onTouchMove);$element.on("touchend",onTouchEnd)}}();$element.on("touchstart",onTouchStart)}$element.on("DOMMouseScroll",function(e){const scale=e.originalEvent.detail>0?WHEEL_ZOOM_STEP:1/WHEEL_ZOOM_STEP;const coordinates=mouseViewportCoordinates(e);zoomTo(scale,coordinates.x,coordinates.y);e.stopPropagation()});function zoomTo(scale,x,y){if(scale<1&&$scope.panzoom.width&&$scope.panzoom.width<=150){return}if(scale>1&&$scope.panzoom.width*scale>$scope.panzoom.maxWidth*2){return}if(angular.isUndefined(x)){x=$scope.panzoom.WIDTH/2}if(angular.isUndefined(y)){const menuH=$("#flow-editor-page .menu").legacyHeight();y=($scope.panzoom.HEIGHT-menuH)/2+menuH}$scope.panzoom.x=$scope.panzoom.x+x/$scope.panzoom.WIDTH*$scope.panzoom.width*(1-scale);$scope.panzoom.y=$scope.panzoom.y+y/$scope.panzoom.HEIGHT*$scope.panzoom.height*(1-scale);$scope.panzoom.width=$scope.panzoom.width*scale;$scope.panzoom.height=$scope.panzoom.height*scale;$scope.redraw()}}let original_coordinates;let original_graph_coordinates;let original_click;let currentZoneTranslation;let zoneId;function getEventWithCoordinates(evt){return angular.isUndefined(evt.originalEvent.changedTouches)?evt.originalEvent:evt.originalEvent.changedTouches[0]}const isFirefox=navigator.userAgent.toLowerCase().indexOf("firefox")>-1;function getOffsetXY(e){let offsets;if(isFirefox||angular.isUndefined(e.offsetX)){const target=e.target||e.srcElement;const rect=target.getBoundingClientRect();offsets={x:e.clientX-rect.left,y:e.clientY-rect.top}}else{offsets={x:e.offsetX,y:e.offsetY}}return offsets}function mouseViewportCoordinates(evt){const formattedEvt=getEventWithCoordinates(evt);if(angular.isUndefined(formattedEvt.offsetX)||!$scope.svg||formattedEvt.target!=$scope.svg[0]){const containerOffset=$element.offset();return{x:formattedEvt.pageX-containerOffset.left,y:formattedEvt.pageY-containerOffset.top}}else{return getOffsetXY(formattedEvt)}}let pt;function mouseGraphCoordinates(evt){let formattedEvt=getEventWithCoordinates(evt);pt=pt||$scope.svg[0].createSVGPoint();pt.x=formattedEvt.clientX;pt.y=formattedEvt.clientY;return pt.matrixTransform($scope.svg[0].getScreenCTM().inverse())}function setupMoveAndSelectBehavior(){$scope.rectangleSelection=false;function moveView(evt){if(!original_coordinates)return;const coordinates=mouseViewportCoordinates(evt);$scope.panzoom.x=original_coordinates.x-$scope.panzoom.width*(coordinates.x/$scope.panzoom.WIDTH);$scope.panzoom.y=original_coordinates.y-$scope.panzoom.height*(coordinates.y/$scope.panzoom.HEIGHT);$scope.redraw()}function applyMoveZone(evt){const translation=getTranslationCoordinates(evt);currentZoneTranslation=translation;$scope.svg.find(`g[data-id="${zoneId}"]`).attr("transform",`translate(${translation.x}, ${translation.y})`);const nodeGraphSvgElement=$("<div></div>").append($($scope.nodesGraph.svg)).find(">svg");nodeGraphSvgElement.find(`g[data-id="${zoneId}"], g[data-id="cluster_${zoneId}"]`).attr("transform",`translate(${translation.x}, ${translation.y})`);$scope.nodesGraph.svg=nodeGraphSvgElement[0].outerHTML;let nodeGraphZone=$scope.getNode(zoneId);nodeGraphZone.position.x=translation.x;nodeGraphZone.position.y=translation.y;FlowZoneMoveService.setZoneEdges($scope.svg,zoneId,$scope.nodesGraph);$scope.svg.find(`g[data-to="${zoneId}"]`).each(function(){FlowZoneMoveService.setZoneEdges($scope.svg,this.getAttribute("data-from"),$scope.nodesGraph)});$scope.svg.find(`g[data-from="${zoneId}"]`).each(function(){FlowZoneMoveService.setZoneEdges($scope.svg,this.getAttribute("data-to"),$scope.nodesGraph)})}function getTranslationCoordinates(evt){let oldX=null;let oldY=null;try{const parts=/translate\(\s*([^\s,)]+)[\s,]\s?([^\s,)]+)/.exec(evt.data.transformAttribute);oldX=parseFloat(parts[1]);oldY=parseFloat(parts[2])}catch(_){oldX=0;oldY=0}const coordinates=mouseViewportCoordinates(evt);return{x:oldX+(coordinates.x-original_click.x)*$scope.panzoom.width/$scope.panzoom.WIDTH,y:oldY+(coordinates.y-original_click.y)*$scope.panzoom.height/$scope.panzoom.HEIGHT}}function getBBoxFromPoints(p1,p2){return{x:Math.min(p1.x,p2.x),y:Math.min(p1.y,p2.y),width:Math.max(p1.x,p2.x)-Math.min(p1.x,p2.x),height:Math.max(p1.y,p2.y)-Math.min(p1.y,p2.y)}}function updateSelectionRectangle(evt){const svg=FlowGraph.getSvg();if(!svg)return;clearSelectionRectangle();const coords=mouseGraphCoordinates(evt);const rect=getBBoxFromPoints(coords,original_graph_coordinates);rect.id="flow-selection-rectangle";$(svg).append(makeSVG("rect",rect))}function clearSelectionRectangle(){const svg=FlowGraph.getSvg();$("#flow-selection-rectangle",svg).remove()}function commitRectangleSelection(evt){const coords=mouseGraphCoordinates(evt);const rect=getBBoxFromPoints(coords,original_graph_coordinates);const nodeIds=FlowGraph.getEnclosedNodesIds(rect);if(FlowGraph.isJobGraph()){JobFlowGraphSelection.rectangularSelectionStrategy($scope)(FlowGraph.nodes(nodeIds))}else{FlowGraphSelection.onRectangularSelection(nodeIds)}}function clearOriginalCoordinates(){original_coordinates=undefined;clearSelectionRectangle();$("#flow-editor-page .mainPane").removeClass("no-pointer-events")}$scope.isSavingZonePosition=false;const debouncedSaveZonePosition=Debounce().withDelay(400,400).wrap(saveZonePosition);function saveZonePosition(){if(zoneId&&currentZoneTranslation){const projectKey=$stateParams.projectKey;$scope.isSavingZonePosition=true;DataikuAPI.flow.zones.savePosition(projectKey,zoneId.replace(/^zone_/,""),currentZoneTranslation.x,currentZoneTranslation.y).catch(setErrorInScope.bind($scope)).finally(()=>{$scope.isSavingZonePosition=false})}currentZoneTranslation=undefined}function isLassoKeyPressed(evt){const isNotMac=!$("html").hasClass("macos");return evt.shiftKey||evt.metaKey||evt.ctrlKey&&isNotMac}$("body").on("keydown.rectangleSelection",function(e){if(isLassoKeyPressed(e)&&$stateParams.projectKey){$scope.$apply(()=>$scope.rectangleSelection=true)}}).on("keyup.rectangleSelection",function(e){if(!isLassoKeyPressed(e)&&$stateParams.projectKey){$scope.$apply(()=>$scope.rectangleSelection=false)}});$scope.$on("$destroy",function(){$("body").off("keydown.rectangleSelection").off("keyup.rectangleSelection")});function monoTouchCallBack(fn){return function(evt){if(evt.originalEvent.touches&&evt.originalEvent.touches.length==1){fn(evt)}}}let dragStart=function(){const applyMoveCursorSelector="svg, svg [class~=node], svg [class~=zone_cluster], svg [class~=folded-icon]";let $applyMoveCursorInitialItem=$element;function applyMoveCursor(evt){$(evt.target).addClass("moving");$(evt.target).parentsUntil($element).addClass("moving")}function cleanMoveCursor(){$element.find(".moving").removeClass("moving")}function removeListeners(){$(document).off("mousemove",drag);$(document).off("mousemove",moveZone);$element.off("mouseenter",applyMoveCursorSelector,applyMoveCursor);$element.off("mouseup","svg .node",releaseDragOnNode);$element.off("mouseup","svg .zone_cluster",releaseDragOnZone);$element.off("mouseup","svg .folded-icon",releaseDragOnUnfoldButton);$(document).off("mouseup",releaseDrag);if(isTouchDevice()){$(document).off("touchmove",monoTouchCallBack(drag));$element.off("touchend","svg .node",releaseDragOnNode);$element.off("touchend","svg .zone_cluster",releaseDragOnZone);$element.off("touchend","svg .folded-icon",releaseDragOnUnfoldButton);$(document).off("touchend",releaseDrag)}}function _dragCallback(evt,applyDragMethod){if(!$scope.svg)return;$applyMoveCursorInitialItem.addClass("moving");$applyMoveCursorInitialItem.closest("#flow-graph > svg").addClass("moving");if(!(isLassoKeyPressed(evt)&&$stateParams.projectKey)&&$scope.rectangleSelection){clearOriginalCoordinates()}if(!isLassoKeyPressed(evt)&&$scope.rectangleSelection){$scope.$apply(()=>$scope.rectangleSelection=false)}if(original_coordinates){if($scope.rectangleSelection){const coordinates=mouseViewportCoordinates(evt);if(original_click&&square_distance(coordinates,original_click)>16){$("#flow-editor-page .mainPane").addClass("no-pointer-events")}updateSelectionRectangle(evt)}else{requestAnimationFrame(_=>applyDragMethod(evt))}}evt.stopPropagation();if(!$rootScope.$$phase)$scope.$apply()}function moveZone(evt){_dragCallback(evt,applyMoveZone)}function drag(evt){_dragCallback(evt,moveView)}function releaseDragOnNode(e){if(e.button===2){return}cleanMoveCursor();const coordinates=mouseViewportCoordinates(e);if(original_click){if(square_distance(coordinates,original_click)<16){if(e.which==1||e.which==2||e.type=="touchend"){const nodeId=$(this).attr("data-id");const node=FlowGraph.node(nodeId);if(node){GraphZoomTrackerService.setFocusItemCtx(node);FlowGraphSelection.onItemClick(node,e);$scope.$apply()}}}else if($scope.rectangleSelection){commitRectangleSelection(e)}}clearOriginalCoordinates();debouncedSaveZonePosition();removeListeners();e.stopPropagation()}function releaseDragOnUnfoldButton(e){if(e.button===2){return}cleanMoveCursor();if(e.originalEvent&&e.originalEvent.detail==2){return}FlowGraphFolding.unfoldNode(this);clearOriginalCoordinates();debouncedSaveZonePosition();removeListeners();e.stopPropagation()}function releaseDragOnZone(e){if(e.button===2){return}cleanMoveCursor();if(e.originalEvent&&e.originalEvent.detail==2&&!FlowGraph.isJobGraph()){return}const coordinates=mouseViewportCoordinates(e);if(original_click){if(square_distance(coordinates,original_click)<16){if(e.which==1||e.which==2||e.type=="touchend"){const nodeId=$(this).attr("id").split(/_(.+)/)[1];const node=FlowGraph.node(nodeId);if(node){GraphZoomTrackerService.setFocusItemCtx(node);FlowGraphSelection.onItemClick(node,e);$scope.$apply()}}}else if($scope.rectangleSelection){commitRectangleSelection(e)}}clearOriginalCoordinates();debouncedSaveZonePosition();removeListeners();e.stopPropagation()}function releaseDrag(e){if(e.button===2){return}cleanMoveCursor();try{const coordinates=mouseViewportCoordinates(e);if(original_click){if(square_distance(coordinates,original_click)<16){const isTagEditPopoverOpened=$(".tag-edit-popover__popover")[0];if((e.which==1||e.which==2||e.type=="touchend")&&!(e.metaKey||e.shiftKey)&&!isTagEditPopoverOpened&&e.originalEvent.detail<=1&&!(e.ctrlKey&&DetectUtils.isMac())){if(FlowGraph.isJobGraph()){JobFlowGraphSelection.clearSelection($scope)}else{GraphZoomTrackerService.resetFocusItemCtx();FlowGraphSelection.clearSelection()}}}else if($scope.rectangleSelection){commitRectangleSelection(e)}}}catch(e){Logger.error(e)}clearOriginalCoordinates();debouncedSaveZonePosition();removeListeners();$scope.$apply()}return function(evt){const isZoneMove=(evt.data.isOnZoneHeader||evt.data.isOnZoneBody&&evt.altKey)&&$scope.zonesManualPositioning&&$scope.canMoveZones;const zoneElement=this.parentElement;if(isZoneMove){zoneId=zoneElement.getAttribute("data-id")}if(!$scope.svg){return}if(evt.which==1||evt.type=="touchstart"){const coordinates=mouseViewportCoordinates(evt);original_coordinates={x:$scope.panzoom.x+$scope.panzoom.width*(coordinates.x/$scope.panzoom.WIDTH),y:$scope.panzoom.y+$scope.panzoom.height*(coordinates.y/$scope.panzoom.HEIGHT)};original_graph_coordinates=mouseGraphCoordinates(evt);original_click={x:coordinates.x,y:coordinates.y}}$applyMoveCursorInitialItem=$(evt.target);if(isZoneMove){const transformAttribute=zoneElement.getAttribute("transform");$(document).on("mousemove",null,{transformAttribute:transformAttribute},moveZone)}else{$(document).on("mousemove",drag)}$element.on("mouseup","svg .node",releaseDragOnNode);$element.on("mouseup","svg .zone_cluster",releaseDragOnZone);$element.on("mouseup","svg .folded-icon",releaseDragOnUnfoldButton);$(document).on("mouseup",releaseDrag);if(isTouchDevice()){$(document).on("touchmove",monoTouchCallBack(drag));$element.on("touchend","svg .node",releaseDragOnNode);$element.on("touchend","svg .zone_cluster",releaseDragOnZone);$element.on("touchend","svg .folded-icon",releaseDragOnUnfoldButton);$(document).on("touchend",releaseDrag)}evt.stopPropagation();$scope.$apply()}}();$element.on("mousedown",'g[data-type="ZONE"] > .zone_header',{isOnZoneHeader:true,isOnZoneBody:false},dragStart);$element.on("mousedown",'g[data-type="ZONE"] > :not(.zone_header)',{isOnZoneHeader:false,isOnZoneBody:true},dragStart);$element.on("mousedown",':not(g[data-type="ZONE"], g[data-type="ZONE"] *)',{isOnZoneHeader:false,isOnZoneBody:false},dragStart);$element.on("mousedown",'g[data-type="ZONE"] > .zone_header',{isOnZoneHeader:true,isOnZoneBody:false},monoTouchCallBack(dragStart));$element.on("mousedown",'g[data-type="ZONE"] > :not(.zone_header)',{isOnZoneHeader:false,isOnZoneBody:true},monoTouchCallBack(dragStart));$element.on("mousedown",':not(g[data-type="ZONE"], g[data-type="ZONE"] *)',{isOnZoneHeader:false,isOnZoneBody:false},monoTouchCallBack(dragStart));$element.on("dblclick","svg [class~=node]:not(.zone)",function(e){const nodeId=$(this).attr("data-id");const node=FlowGraph.node(nodeId);clearOriginalCoordinates();$scope.onItemDblClick(node,e);e.stopPropagation()});const KEYBOARD_FACTOR=100;$scope.moveLeft=()=>{$scope.panzoom.x=$scope.panzoom.x+$scope.panzoom.width/2-$scope.panzoom.width*(($scope.panzoom.WIDTH/2+KEYBOARD_FACTOR)/$scope.panzoom.WIDTH);$scope.redraw()};$scope.moveRight=()=>{$scope.panzoom.x=$scope.panzoom.x+$scope.panzoom.width/2-$scope.panzoom.width*(($scope.panzoom.WIDTH/2-KEYBOARD_FACTOR)/$scope.panzoom.WIDTH);$scope.redraw()};$scope.moveUp=()=>{$scope.panzoom.y=$scope.panzoom.y+$scope.panzoom.height/2-$scope.panzoom.height*(($scope.panzoom.HEIGHT/2+KEYBOARD_FACTOR)/$scope.panzoom.HEIGHT);$scope.redraw()};$scope.moveDown=()=>{$scope.panzoom.y=$scope.panzoom.y+$scope.panzoom.height/2-$scope.panzoom.height*(($scope.panzoom.HEIGHT/2-KEYBOARD_FACTOR)/$scope.panzoom.HEIGHT);$scope.redraw()}}$scope.getNode=id=>{if(!id){return undefined}const item=$scope.nodesGraph.nodes[id];if(!item){return $scope.nodesGraph.nodes[id.replace("cluster_","")]}return item};$scope.getSelector=(id,node)=>{const item=node?node:$scope.getNode(id);let selector=id?`g[data-id=${id}]`:"g .highlight";if(item&&item.nodeType==="ZONE"){selector=`#cluster_${id}`}return selector};$scope.zoomGraph=(id,paddingFactor=3,item=null,offCenterShift=0)=>{FlowGraphFolding.ensureNodesNotFolded([id]);if(!item){item=$scope.getNode(id)}const selector=$scope.getSelector(id,item);if(item){if(item.nodeType==="ZONE"){paddingFactor=1.5}else if(item.nodeType==="RECIPE"){paddingFactor=5}}$scope.zoomToBbox(FlowGraphFiltering.getBBoxFromSelector($scope.svg,selector),paddingFactor,offCenterShift)};$scope.zoomToBbox=function(bbox,paddingFactor=1.5,offCenterShift=0){if(!$scope.svg||!bbox)return;$scope.panzoom.x=bbox.x;$scope.panzoom.y=bbox.y;if(bbox.width/bbox.height>$scope.panzoom.WIDTH/$scope.panzoom.HEIGHT){$scope.panzoom.width=bbox.width;$scope.panzoom.height=bbox.width/($scope.panzoom.WIDTH/$scope.panzoom.HEIGHT);$scope.panzoom.y=bbox.y-($scope.panzoom.height-bbox.height)/2}else{$scope.panzoom.width=bbox.height*($scope.panzoom.WIDTH/$scope.panzoom.HEIGHT);$scope.panzoom.height=bbox.height;$scope.panzoom.x=bbox.x-($scope.panzoom.width-bbox.width)/2}const menuHeight=$("#flow-editor-page .menu").legacyHeight();const x=$scope.panzoom.WIDTH/2;const y=($scope.panzoom.HEIGHT-menuHeight)/2+menuHeight;$scope.panzoom.x=$scope.panzoom.x+$scope.panzoom.width*(x/$scope.panzoom.WIDTH)*(1-paddingFactor);$scope.panzoom.y=$scope.panzoom.y+$scope.panzoom.height*(y/$scope.panzoom.HEIGHT)*(1-paddingFactor);$scope.panzoom.width=$scope.panzoom.width*paddingFactor;$scope.panzoom.height=$scope.panzoom.height*paddingFactor;d3.select($scope.svg[0]).transition(300).attr("viewBox",[$scope.panzoom.x,$scope.panzoom.y+offCenterShift,$scope.panzoom.width,$scope.panzoom.height].join(", "))};setupZoomBehavior();setupMoveAndSelectBehavior();Mousetrap.bind("Z S",_=>$scope.zoomToBbox(FlowGraphFiltering.getBBoxFromSelector($scope.svg,".selected")));$scope.$on("$destroy",_=>Mousetrap.unbind("Z S"));Mousetrap.bind("Z F",_=>$scope.zoomToBbox(FlowGraphFiltering.getBBoxFromSelector($scope.svg,".focus")));$scope.$on("$destroy",_=>Mousetrap.unbind("Z F"));Mousetrap.bind("Z U",_=>$scope.zoomToBbox(FlowGraphFiltering.getBBoxFromSelector($scope.svg,".usedDatasets .node")));$scope.$on("$destroy",_=>Mousetrap.unbind("Z U"));Mousetrap.bind("j e l l y",function(){let x=[];let y=[];let t=c=>(c||0)*.95+10*(Math.random()-.5);let d=9e3;window.setInterval(function(){d3.selectAll("g.node:not(.zone),g.edge").transition().duration(d).ease("elastic").attr("transform",function(d,i){[x[i],y[i]]=[t(x[i]),t(y[i])];return"translate("+x[i]+" , "+y[i]+")"})},d*.09)});$scope.$on("$destroy",_=>Mousetrap.unbind("j e l l y"));Mousetrap.bind("d i s c o",function(){let r={};let g={};let b={};let s=c=>(c===undefined?255*Math.random():c)+100*(Math.random()-.5);let bn=c=>Math.max(0,Math.min(255,c));let sb=c=>bn(s(c));let d=2e3;window.setInterval(function(){d3.selectAll("g.node,g.edge").transition().duration(d).ease("elastic").style("fill",function(d,i){let id=$(this).attr("id")+"";r[id]=sb(r[id]);g[id]=sb(g[id]);b[id]=sb(b[id]);return`rgb(${r[id]}, ${g[id]}, ${b[id]})`})},d*.09)});$scope.$on("$destroy",_=>Mousetrap.unbind("d i s c o"));Mousetrap.bind("b e r n a r d",function(){d3.select($scope.svg[0]).append("defs").append("pattern").attr("id","bp").attr("patternUnits","userSpaceOnUse").attr("width",120).attr("height",120).append("image").attr("xlink:href","https://dev.dataiku.com/egg/bp.jpg").attr("width",122).attr("height",110).attr("x",-11);d3.select($scope.svg[0]).selectAll("g[data-recipe-type='pivot']").selectAll("path").attr("fill","url(#bp)");d3.select($scope.svg[0]).selectAll("g[data-recipe-type='pivot']").style("opacity","1")});$scope.$on("$destroy",_=>Mousetrap.unbind("b e r n a r d"));let last_svg_str;let last_svg_element;let last_$svg;let last_nodes;let last_unread_ids;let deregister=$rootScope.$on("drawGraph",function(tgtScope,ignoreCache=false,indexNodes=false){if(!$scope.nodesGraph.nodes)return;let svgElement;let cachedSVG=!!$stateParams.projectKey&&!ignoreCache&&last_svg_str==$scope.nodesGraph.svg&&angular.equals($scope.nodesGraph.nodes,last_nodes)&&angular.equals(($rootScope.discussionsUnreadStatus||{}).unreadFullIds||[],last_unread_ids);if(cachedSVG){Logger.debug("use cached svg");svgElement=last_svg_element}else{svgElement=$($scope.nodesGraph.svg);$element.addClass("no-animation");last_svg_str=$scope.nodesGraph.svg;last_svg_element=svgElement;last_$svg=$element.find("svg");last_nodes=$scope.nodesGraph.nodes;last_unread_ids=angular.copy(($rootScope.discussionsUnreadStatus||{}).unreadFullIds||[])}if($stateParams.zoneId){svgElement=$(svgElement).find(`.zone#zone_${$stateParams.zoneId}>svg`).removeAttr("x").removeAttr("y")}if(cachedSVG){Logger.debug("Graph is ready, reset style");$("g",$scope.svg).removeAttr("style");$(".newG",$scope.svg).removeAttr("color");$(".tool-simple-zone",$scope.svg).empty();$(".node-label",$scope.svg).remove();$(".node-totem span",$scope.svg).removeAttr("style").removeClass();$(".nodecounter__text div span",$scope.svg).text("");$(".nodecounter__wrapper",$scope.svg).removeClass("nodecounter__wrapper--shown");$(".never-built-computable *",$scope.svg).removeAttr("style");$scope.svg=last_$svg}else{Logger.debug("Graph is not ready, add svg element",svgElement);var isReload=false;if($element.children().length>0){isReload=true;$element.append("<div style='visibility:hidden; width:100%; height:100%' id='hc-svnt-dracones'></div>");var $preloadedGraph=$element.find("#hc-svnt-dracones");$preloadedGraph.append(svgElement);$scope.svg=last_$svg=$preloadedGraph.find(">svg")}else{$element.children().remove();$element.find("svg").remove();$element.append(svgElement);$scope.svg=last_$svg=$element.find(">svg")}const bbFlow=$scope.svg.find("g.graph")[0].getBBox();const defaultPz=buildDefaultPanZoomSettings($scope.panzoom,bbFlow);if(!GraphZoomTrackerService.isValidPanZoom($scope.panzoom)){$scope.panzoom=defaultPz}$scope.svg.attr("height","100%").attr("width","100%");$scope.svg[0].setAttribute("viewBox","-10000 -10000 10 10");$scope.svg.find("g").first().attr("transform","").find("polygon").first().remove();d3.select($scope.svg[0]).selectAll("g.cluster:not(.zone_cluster)").remove();if($stateParams.projectKey){ProjectFlowGraphStyling.restyleGraph($scope.svg,$scope);ProjectFlowGraphLayout.relayout($scope.svg)}else{InterProjectGraphStyling.restyleGraph($scope.svg,$scope);InterProjectGraphLayout.relayout($scope.svg)}$scope.$emit("graphRendered")}FlowGraphSelection.refreshStyle();$("#flow-graph").attr("style","");$rootScope.$broadcast("reflow");if(isReload){const $newSvg=$preloadedGraph.children().first();const $origSvg=$element.children().first();$origSvg.children().remove();$origSvg.append($newSvg.children());$scope.svg=last_$svg=$element.find(">svg");$preloadedGraph.remove()}if(indexNodes===true){let graphDOM=$scope.svg.find("g.graph")[0];if(graphDOM){FlowGraph.indexNodesCoordinates($scope.svg,graphDOM.getBBox())}}},true);$scope.$on("$destroy",deregister);$element[0].oncontextmenu=function(evt){const itemElt=$(evt.target).parents("g[data-type]").first();let nodeId=$(itemElt).attr("data-id");if(itemElt.attr("data-type")==="ZONE"){nodeId=nodeId.replace("cluster_","")}const node=FlowGraph.node(nodeId);return $scope.onContextualMenu(node,evt)};$scope.$watchCollection("tool.user.state.focusMap",function(nv,ov){if(!nv)return;$scope.tool.drawHooks.updateFlowToolDisplay();$scope.tool.saveFocus()});$scope.$on("restyleGraph",function(){ProjectFlowGraphStyling.restyleGraph($scope.svg,$scope)});$scope.$on("graphRendered",function(){if(FlowGraph.get().nodes.length<200){Logger.debug("Reactivate animations");$("#flow-graph").toggleClass("no-animation",false)}})}}});app.directive("flowGraphWithTooltips",function($rootScope,FlowGraph,DatasetUtils,ChartTooltipsUtils,WatchInterestState){return{restrict:"EA",link:function(scope,element,attrs){let tooltip,tooltipScope;let timeout;const DEFAULT_DELAY=500;const SHORT_DELAY=250;function show(node,tooltipScope,evt,delay){timeout=setTimeout(function(){ChartTooltipsUtils.handleMouseOverElement(tooltipScope);tooltipScope.node=node;tooltipScope.$apply();ChartTooltipsUtils.appear(tooltip,"#777",evt,element)},delay)}function hide(digestInProgress){if(tooltipScope==null)return;clearTimeout(timeout);ChartTooltipsUtils.handleMouseOutElement(tooltip,tooltipScope,digestInProgress)}function addTooltipBehavior(elt,nodeId){const node=FlowGraph.node(nodeId);if(node){elt.on("mouseover",function(d,i){if(node.filterRemove||tooltipScope==null)return;if(scope.tool&&scope.tool.drawHooks&&scope.tool.drawHooks.setupTooltip){tooltipScope.tooltip=scope.tool.drawHooks.setupTooltip(node);show(node,tooltipScope,d3.event,SHORT_DELAY)}else if((node.nodeType.endsWith("DATASET")||node.nodeType.endsWith("ZONE"))&&!node.shortDesc&&!(node.tags&&node.tags.length)&&!node.veLoopDatasetRef){return}else{tooltipScope.tooltip={};show(node,tooltipScope,d3.event,DEFAULT_DELAY)}}).on("mouseout",hide)}}ChartTooltipsUtils.createWithStdAggr1DBehaviour(scope,attrs.tooltipType||"flow-tooltip",element).then(function(x){tooltip=x[0];tooltipScope=x[1]}).then(()=>{tooltipScope.isWatching=WatchInterestState.isWatching;tooltipScope.DatasetUtils=DatasetUtils});scope.setupTooltips=function(){$('[data-id][data-type]:not([data-type="ZONE"])').each(function(_,g){const nodeId=d3.select(g).attr("data-id");addTooltipBehavior(d3.select(g),nodeId)});$(".zone_cluster").each(function(_,g){const headers=$(g).find(".zone_header");const nodeId=d3.select(g).attr("data-id");if(headers.length===1){addTooltipBehavior(d3.select(headers[0]),nodeId)}else{addTooltipBehavior(d3.select(g),nodeId)}})};const h=$rootScope.$on("flowSelectionUpdated",_=>hide(true));scope.$on("$destroy",h);scope.$on("graphRendered",scope.setupTooltips)}}});app.directive("flowGraphWithDropFile",function($state,$stateParams,FlowGraph,FlowGraphSelection,FlowGraphHighlighting,$timeout){return{restrict:"EA",scope:{isDroppable:"=?",allowDropFile:"=?"},link:function(scope,element){const NODE_ID_UNINITIALIZED="__UNINITIALIZED__";const ZONE_ID_UNINITIALIZED="__UNINITIALIZED__";const ZONE_ID_DEFAULT="default";let lastNodeOverId=NODE_ID_UNINITIALIZED;let lastZoneOverId=ZONE_ID_UNINITIALIZED;function hasZones(){let graph=FlowGraph.get();return graph&&graph.hasZones}function getZoneId(nodeId,itemElt){if(nodeId!==undefined){if(itemElt.attr("data-type")==="ZONE"){return nodeId.replace("cluster_","").substring("zone_".length)}else if(nodeId.startsWith("zone__")){return nodeId.substring("zone__".length,nodeId.indexOf("__","zone__".length))}}return ZONE_ID_DEFAULT}function applyDragEnterLeave(e){e.stopPropagation();e.preventDefault();scope.candrop=false;lastNodeOverId=NODE_ID_UNINITIALIZED;lastZoneOverId=ZONE_ID_UNINITIALIZED;scope.$apply(function(){FlowGraphHighlighting.removeDropFeedbackFromZoneElements()})}function cancelEnterLeaveTimeout(){if(scope.enterLeaveTimeout){$timeout.cancel(scope.enterLeaveTimeout)}}function dragEnterLeave(e){cancelEnterLeaveTimeout();scope.enterLeaveTimeout=$timeout(function(){applyDragEnterLeave(e)},100)}const unwatch=scope.$watch("allowDropFile",()=>{if(scope.allowDropFile===undefined){return}unwatch();if(scope.allowDropFile===false){return}scope.candrop=false;scope.$watch("candrop",()=>{scope.isDroppable=scope.candrop});element.on("dragenter",dragEnterLeave);element.on("dragleave",dragEnterLeave);element.on("dragover",e=>{cancelEnterLeaveTimeout();e.stopPropagation();e.preventDefault();scope.$apply(()=>{var evt=e.originalEvent;if(evt.dataTransfer&&contains_item(evt.dataTransfer.types,"Files")){scope.candrop=true;if(!$stateParams.zoneId&&hasZones()){const itemElt=$(e.target).parents("g[data-type]").first();const nodeId=$(itemElt).attr("data-id");if(nodeId!==lastNodeOverId){lastNodeOverId=nodeId;const zoneId=getZoneId(nodeId,itemElt);if(zoneId!==lastZoneOverId){lastZoneOverId=zoneId;if(zoneId!==ZONE_ID_UNINITIALIZED){FlowGraphHighlighting.addDropFeedbackToZoneElement("zone_"+zoneId);let zone=FlowGraph.node("zone_"+zoneId);if(zone){FlowGraphSelection.onItemClick(zone)}}}}}}else{scope.candrop=false}})});element.on("drop",e=>{e.stopPropagation();e.preventDefault();lastNodeOverId=NODE_ID_UNINITIALIZED;lastZoneOverId=ZONE_ID_UNINITIALIZED;let zoneId;if(!$stateParams.zoneId){const itemElt=$(e.target).parents("g[data-type]").first();const nodeId=$(itemElt).attr("data-id");zoneId=getZoneId(nodeId,itemElt)}else{zoneId=$stateParams.zoneId}scope.$apply(()=>{let evt=e.originalEvent;if(evt.dataTransfer&&contains_item(evt.dataTransfer.types,"Files")){scope.$root.uploadedFiles=evt.dataTransfer.files;let params={type:"UploadedFiles"};if(zoneId!==ZONE_ID_UNINITIALIZED&&zoneId!==ZONE_ID_DEFAULT){params["zoneId"]=zoneId}$state.go("projects.project.datasets.new_with_type.settings",params)}scope.candrop=false})})})}}});app.directive("flowGraphPlaceholderWithDropFile",function($state,$stateParams,FlowGraph,FlowGraphSelection,FlowGraphHighlighting,$timeout){return{restrict:"EA",scope:{isDroppable:"=?",allowDropFile:"=?"},link:function(scope,element){function applyDragEnterLeave(e){e.stopPropagation();e.preventDefault();scope.candrop=false}function cancelEnterLeaveTimeout(){if(scope.enterLeaveTimeout){$timeout.cancel(scope.enterLeaveTimeout)}}function dragEnterLeave(e){cancelEnterLeaveTimeout();scope.enterLeaveTimeout=$timeout(function(){applyDragEnterLeave(e)},100)}const unwatch=scope.$watch("allowDropFile",()=>{if(scope.allowDropFile===undefined){return}unwatch();if(scope.allowDropFile===false){return}scope.candrop=false;scope.$watch("candrop",()=>{scope.isDroppable=scope.candrop});element.on("dragenter",dragEnterLeave);element.on("dragleave",dragEnterLeave);element.on("dragover",e=>{cancelEnterLeaveTimeout();e.stopPropagation();e.preventDefault();scope.$apply(()=>{const evt=e.originalEvent;scope.candrop=evt.dataTransfer&&contains_item(evt.dataTransfer.types,"Files")})});element.on("drop",function(e){e.stopPropagation();e.preventDefault();scope.$apply(()=>{let evt=e.originalEvent;if(evt.dataTransfer&&contains_item(evt.dataTransfer.types,"Files")){scope.$root.uploadedFiles=evt.dataTransfer.files;let params={type:"UploadedFiles"};if($stateParams.zoneId){params["zoneId"]=$stateParams.zoneId}$state.go("projects.project.datasets.new_with_type.settings",params)}scope.candrop=false})})})}}});app.service("FlowGraph",function($rootScope,$state,FlowGraphFiltering){const svc=this;let graph;let nodesElements;let edgesElementsTo;let edgesElementsFrom;let nodesCoordinates;let zonesElements;let graphBBox;this.set=function(g){graph=g};this.get=function(){return graph};this.node=function(nodeId){return graph.nodes[nodeId]};this.nodes=nodesId=>nodesId.map(nodeId=>this.node(nodeId));this.nodesByZones=postProcessNode=>{const itemsByZones={};for(const nodeId in graph.nodes){const node=graph.nodes[nodeId];if(nodeId.startsWith("zone__")&&node.nodeType!=="ZONE"&&(!node.isSource||node.isSink||node.nodeType==="RECIPE")){const zoneId=nodeId.substring("zone__".length,node.id.length-node.realId.length-2);if(node.ownerZone===zoneId){if(!itemsByZones[zoneId]){itemsByZones[zoneId]=[]}const zoneContent=itemsByZones[zoneId];if(postProcessNode){zoneContent.push(postProcessNode(node))}else{zoneContent.push(node)}}}}return itemsByZones};this.zonesIdFromRealId=nodeRealId=>{if(!graph.hasZones)return[];const zonesId=graph.realNodesZones[nodeRealId];return zonesId?zonesId:[]};this.nodesIdFromRealId=nodeRealId=>{if(!graph.hasZones)return[nodeRealId];const zonesId=this.zonesIdFromRealId(nodeRealId);return zonesId.map(zoneId=>`zone__${zoneId}__${nodeRealId}`)};this.nodeCount=function(){return graph.nodesOnGraphCount};this.getDOMElement=function(){return $("#flow-graph")};this.getSvg=function(){return $("#flow-graph > svg")};this.rawNodeWithId=function(nodeId){if(!nodesElements)return;return nodesElements[nodeId]};this.d3NodeWithId=function(nodeId){if(!nodesElements)return;return d3.select(svc.rawNodeWithId(nodeId))};this.d3ZoneNodeWithId=function(nodeId){if(!zonesElements)return;return d3.select(zonesElements[nodeId])};this.d3NodeWithIdFromType=function(nodeId,nodeType){if(nodeType.toLowerCase()==="zone"){return this.d3ZoneNodeWithId(nodeId)}else{return this.d3NodeWithId(nodeId)}};this.rawZoneNodeWithId=function(nodeId){if(!zonesElements)return;return zonesElements[nodeId]};this.rawEdgesWithFromId=function(nodeId){if(!edgesElementsFrom)return[];return edgesElementsFrom[nodeId]||[]};this.rawEdgesWithToId=function(nodeId){if(!edgesElementsTo)return[];return edgesElementsTo[nodeId]||[]};this.getEnclosedNodesIds=function(rect){if(!nodesCoordinates)return[];const bounds={x1:rect.x,y1:rect.y,x2:rect.x+rect.width,y2:rect.y+rect.height};return nodesCoordinates.filter(c=>c.middlePoint.x>=bounds.x1&&c.middlePoint.x<=bounds.x2&&c.middlePoint.y>=bounds.y1&&c.middlePoint.y<=bounds.y2).map(c=>c.nodeId)};this.getGraphBBox=function(){return graphBBox};this.setGraphBBox=function(newBBox){graphBBox=newBBox};this.indexNodesCoordinates=function indexNodesCoordinates(globalSvg,svgBBox){nodesElements={};edgesElementsTo={};edgesElementsFrom={};zonesElements={};nodesCoordinates=[];function getAbsoluteBBox(element,svg){if(svg){const bbox=element.getBBox();let topLeft=svg.createSVGPoint();topLeft.x=bbox.x;topLeft.y=bbox.y;topLeft=topLeft.matrixTransform(element.getTransformToElement(svg));bbox.x=topLeft.x;bbox.y=topLeft.y;return bbox}return null}function pushEltToEdgeMap(nodeId,elt,edgeMap){if(nodeId){if(!edgeMap[nodeId])edgeMap[nodeId]=[];edgeMap[nodeId].push(elt)}}this.setGraphBBox(svgBBox);const svg=$("#flow-graph > svg")[0];$(".usedDatasets .node, .connectedProjects .node",globalSvg).each(function(_,elt){const bbox=getAbsoluteBBox(elt,svg);if(bbox){const middlePoint={x:bbox.x+bbox.width/2,y:bbox.y+bbox.height/2};const nodeId=$(elt).attr("data-id");nodesElements[nodeId]=elt;nodesCoordinates.push({nodeId:nodeId,middlePoint:middlePoint})}});$(".edge",globalSvg).each(function(_,elt){pushEltToEdgeMap($(elt).attr("data-from"),elt,edgesElementsFrom);pushEltToEdgeMap($(elt).attr("data-to"),elt,edgesElementsTo)});$(".draftDatasets > .node",globalSvg).each(function(_,elt){let bbox;if($(elt).closest("svg").is(globalSvg)){bbox=elt.getBBox();bbox.x+=svgBBox.x;bbox.y+=svgBBox.y}else{bbox=getAbsoluteBBox(elt,svg)}if(bbox){const middlePoint={x:bbox.x+bbox.width/2,y:bbox.y+bbox.height/2};const nodeId=$(elt).attr("data-id");nodesElements[nodeId]=elt;nodesCoordinates.push({nodeId:nodeId,middlePoint:middlePoint})}});$(".zone_cluster",globalSvg).each(function(_,elt){const nodeId=$(elt).attr("id").replace("cluster_","");zonesElements[nodeId]=elt});$rootScope.$emit("flowDisplayUpdated");$rootScope.$broadcast("indexNodesDone")};this.ready=function(){return!!graph&&!!nodesCoordinates};this.setError=function(){const flowGraphScope=angular.element("#flow-graph").scope();return setErrorInScope.bind(flowGraphScope)};this.nodeSharedBetweenZones=node=>{if(!graph.zonesUsedByRealId){return null}const found=graph.zonesUsedByRealId[node.realId];if(found){const set=new Set(found);set.delete(node.ownerZone);return set}return null};this.zoomOnSelectedActivities=function(singleSelection,factor=1){const scope=$("#flow-graph").scope();if(scope===undefined){return}const paddingFactor=(singleSelection?3:2)*factor;scope.zoomToBbox(FlowGraphFiltering.getBBoxFromSelector(scope.svg,".selected:not(.zone_cluster)"),paddingFactor)};this.recipeNodeFromName=recipeName=>Object.values(graph.nodes).find(node=>node.nodeType==="RECIPE"&&node.name===recipeName);this.isJobGraph=()=>Boolean($state.$current.includes["projects.project.jobs"])});function contains_item(collection,item){return collection&&collection.includes(item)}function square_distance(A,B){const dx=A.x-B.x;const dy=A.y-B.y;return dx*dx+dy*dy}function buildDefaultPanZoomSettings(currentPz,bbFlow){const pz=angular.copy(currentPz);pz.width=bbFlow.width;pz.height=bbFlow.height;pz.x=bbFlow.x;pz.y=bbFlow.y;if(bbFlow.width/bbFlow.height>pz.WIDTH/pz.HEIGHT){pz.width=bbFlow.width;pz.height=bbFlow.width*(pz.HEIGHT/pz.WIDTH);pz.y=bbFlow.y-(pz.height-bbFlow.height)/2}else{pz.width=bbFlow.height*(pz.WIDTH/pz.HEIGHT);pz.height=bbFlow.height;pz.x=bbFlow.x-(pz.width-bbFlow.width)/2}pz.maxHeight=pz.height;pz.maxWidth=pz.width;return pz}})();(function(){"use strict";const app=angular.module("dataiku.flow.graph");app.service("ProjectFlowGraphStyling",function($filter,FlowGraph,CachedAPICalls,LoggerProvider,TimingService,DataikuAPI,$rootScope,$q,objectTypeFromNodeFlowType,$state,$compile,FlowZoneMoveService){const SIZE=100;const logger=LoggerProvider.getLogger("flow");let flowIconset;CachedAPICalls.flowIcons.success(function(data){flowIconset=data});const formatters={RECIPE:restyleRunnableNode("recipe"),LABELING_TASK:restyleRunnableNode("labeling_task"),LOCAL_DATASET:restyleDatasetNode(true),FOREIGN_DATASET:restyleDatasetNode(false),LOCAL_SAVEDMODEL:restyleModelNode(true),FOREIGN_SAVEDMODEL:restyleModelNode(false),LOCAL_MODELEVALUATIONSTORE:restyleEvaluationStoreNode(true),FOREIGN_MODELEVALUATIONSTORE:restyleEvaluationStoreNode(false),LOCAL_GENAIEVALUATIONSTORE:restyleEvaluationStoreNode(true),FOREIGN_GENAIEVALUATIONSTORE:restyleEvaluationStoreNode(false),LOCAL_RETRIEVABLE_KNOWLEDGE:restyleRetrievableKnowledgeNode(true),FOREIGN_RETRIEVABLE_KNOWLEDGE:restyleRetrievableKnowledgeNode(false),LOCAL_MANAGED_FOLDER:restyleFolderNode(true),FOREIGN_MANAGED_FOLDER:restyleFolderNode(false),LOCAL_STREAMING_ENDPOINT:restyleStreamingEndpointNode(true),FOREIGN_STREAMING_ENDPOINT:restyleStreamingEndpointNode(false)};this.restyleGraph=TimingService.wrapInTimePrinter("ProjectFlowGraphStyling::restyleGraph",function(svg,$scope){const zones=svg.find(".zone_cluster");if(zones){for(let i=0;i<zones.length;i++){const zone=zones[i];try{restyleZone(svg,zone,$scope)}catch(e){logger.error("Failed to restyle flow zone: ",e)}}}svg.find(".zone_label_remove").remove();svg.find("text").remove();svg.find("title").remove();const nodes=$(".node:not(.zone)",svg);if(nodes){for(let i=0;i<nodes.length;i++){const g=nodes[i];try{restyleNode(g)}catch(e){logger.error("Failed to restyle flow node: ",e)}}}svg.find(".node.zone>svg g polygon").remove()});function drawRepeatedObjectSticker(svg,coords){svg.appendChild(makeSVG("ellipse",{class:"flow-information-sticker__background",cx:coords.cx,cy:coords.cy,rx:coords.rx,ry:coords.ry}));svg.appendChild(makeForeignObject({x:coords.indicatorX,y:coords.indicatorY,width:20,height:20,class:"flow-repeated-object__indicator"},$(`<span size="32" class="dku-icon-arrow-repeat-16">`)))}function drawInformationSticker(svg,coords,offset={x:0,y:0}){svg.appendChild(makeSVG("ellipse",{class:"flow-information-sticker__background",cx:coords.cx-offset.x,cy:coords.cy-offset.y,rx:coords.rx,ry:coords.ry}));svg.appendChild(makeForeignObject({x:coords.indicatorX-offset.x,y:coords.indicatorY-offset.y,width:20,height:20,class:"flow-information-sticker__indicator"},$(`<span size="32" class="icon-info-sign">`)))}function drawFeatureGroupSticker(svg,coords){svg.appendChild(makeSVG("ellipse",{class:"flow-information-sticker__background",cx:coords.cx,cy:coords.cy,rx:coords.rx,ry:coords.ry}));svg.appendChild(makeForeignObject({x:coords.indicatorX,y:coords.indicatorY,width:20,height:20,class:"flow-feature-group__indicator"},$(`<span size="32" class="icon-dku-label-feature-store">`)))}function drawDiscussionSticker(svg,discussionCount,has_unread_discussions,coords,offset={x:0,y:0},indicatorOffset={x:0,y:0}){svg.appendChild(makeSVG("ellipse",{class:"flow-discussions-sticker__background",cx:coords.cx-offset.x,cy:coords.cy-offset.y,rx:coords.rx,ry:coords.ry}));svg.appendChild(makeForeignObject({x:coords.indicatorX-offset.x-indicatorOffset.x,y:coords.indicatorY-offset.y-indicatorOffset.y,width:20,height:20,class:"flow-discussions-sticker__indicator"+(has_unread_discussions?" flow-discussions-sticker__indicator--unread":"")},$(`<span size="32" class="icon-dku-discussions">`)));svg.appendChild(makeForeignObject({x:coords.contentX-offset.x,y:coords.contentY-offset.y,width:40,height:20,class:"flow-discussions-sticker__content"},$(`<span>`+(discussionCount>9?"9+":discussionCount)+`</span>`)))}function hasUnreadDiscussion(flowNode){return(($rootScope.discussionsUnreadStatus||{}).unreadFullIds||[]).find(discuId=>(flowNode.discussionsFullIds||[]).includes(discuId))}function restyleNode(g){const element=$(g);const nodeType=element.attr("data-type");if(formatters[nodeType]){formatters[nodeType](element,g)}}function restyleZone(svg,zone_cluster,$scope){const jZone_cluster=$(zone_cluster);const cluster_polygon=jZone_cluster.find(">polygon");const text=jZone_cluster.find(">text");const id=zone_cluster.id.split("_").splice(2).join("");const sanitizedId=sanitize(id);const zone=svg.find(`.zone[id='zone_${id}']`);const zone_polygon=zone.find(">polygon");if(zone_polygon&&cluster_polygon){const zone_coords=polygonToRectData(zone_polygon);const cluster_coords=polygonToRectData(cluster_polygon);const zoneNode=FlowGraph.node(`zone_${id}`);const collapseIcon=zoneNode.customData.isCollapsed?"icon-resize-full":"icon-resize-small";let height=(zone_coords.y-cluster_coords.y)*2;if(!height>0){logger.warn("Calculated height is not a valid number, default to 44");height=44}const foreignObject=makeForeignObject({x:cluster_coords.x,y:cluster_coords.y,width:zone_coords.width,height:height,class:"zone_header"},$(`<div><p>${sanitize(text.text())}</p><span ng-if="zonesManualPositioning && canMoveZones" class="move-zone-shortcut">{{altKey}} + Click to drag</span><button ng-click="buildZone('${sanitizedId}')" class="btn btn--secondary" style="position: static" ><i class="icon-play" /> <span translate="PROJECT.FLOW.GRAPH.ZONE.HEADER.BUILD">Build</span></button><i ng-click="toggleZoneCollapse([{id:'${sanitizedId}'}])" class="${collapseIcon} cursor-pointer" id="collapse-button-zone-${sanitizedId}"/><i ng-click="zoomOnZone('${sanitizedId}')" class="icon-DKU_expand cursor-pointer"/></div>`));const color=d3.rgb(zoneNode.customData.color);const zoneTitleColor=color.r*.299+color.g*.587+color.b*.114>=128?"#000":"#FFF";foreignObject.style=`background-color: ${color}; color: ${zoneTitleColor}; border-bottom: none;`;zone_cluster.appendChild(makeSVG("g",{class:"tool-simple-zone",transform:`translate(${cluster_coords.x+cluster_coords.width}, ${cluster_coords.y+cluster_coords.height})`,"data-height":0}));zone_cluster.appendChild(foreignObject);$compile(foreignObject)($scope);zone_polygon.remove()}$(zone_cluster)[0].setAttribute("data-zone-title",sanitize(text[0].textContent));$(zone_cluster)[0].setAttribute("data-id","zone_"+sanitizedId);if($scope.zonesManualPositioning){FlowZoneMoveService.setZoneEdges(svg,`zone_${sanitizedId}`,$scope.nodesGraph)}}function restyleDatasetNode(local){return function(element){const nodeId=element.attr("data-id");const nodeZoneId=element.attr("data-zone-id");const dataset=FlowGraph.node(nodeId);const dotPolygon=element.find("polygon");if(dotPolygon.length){const coords=polygonToRectData(dotPolygon);let clazz="newG";if(dataset.neverBuilt){clazz+=" never-built-computable"}const newG=makeSVG("g",{class:clazz,transform:`translate(${coords.x} ${coords.y})`});d3.select(newG).classed("bzicon",true);const othersZones=FlowGraph.nodeSharedBetweenZones(dataset);const isExported=othersZones&&!othersZones.has(nodeZoneId);const isImported=othersZones&&othersZones.has(nodeZoneId);const margin=isExported&&othersZones.size>0?4:0;const counterBoxMargin=(isExported||isImported)&&othersZones.size>0?1:0;if(dataset.partitioned){newG.appendChild(makeSVG("rect",{x:-10,y:-10,width:coords.width,height:coords.height,class:"fill dataset-rectangle partitioning-indicator"+(isImported?" dataset-zone-imported":"")}));newG.appendChild(makeSVG("rect",{x:-5,y:-5,width:coords.width,height:coords.height,class:"fill dataset-rectangle partitioning-indicator"+(isImported?" dataset-zone-imported":"")}))}if(isExported){newG.appendChild(makeSVG("rect",{x:0,y:0,width:coords.width,height:coords.height,class:"fill dataset-zone-exported"}))}newG.appendChild(makeSVG("rect",{x:margin,y:margin,width:coords.width-margin*2,height:coords.height-margin*2,class:"fill dataset-rectangle main-dataset-rectangle"+(isImported?" dataset-zone-imported":"")}));newG.appendChild(makeSVG("rect",{x:counterBoxMargin,y:61,width:coords.width-counterBoxMargin*2,height:coords.height-counterBoxMargin-61,class:"nodecounter__wrapper"}));newG.appendChild(makeSVG("g",{class:"tool-simple-zone",transform:`translate(${coords.width}, 0)`,"data-height":"72"}));newG.appendChild(makeForeignObject({x:-30,y:56,width:coords.width+61,height:48,class:"nodecounter__text"},$("<div><span></span></div>")));newG.appendChild(makeForeignObject({x:-30,y:coords.height*1.07,width:coords.width+60,height:45,class:"nodelabel-wrapper"},$("<div><span>"+sanitize(dataset.description.replace(/([-_.])/g,"$1​"))+"</span></div>")));const icon=$filter("toModernIcon")($filter("datasetTypeToIcon")(dataset.datasetType,48),48);const iconElement=$(`<div class="flow-tile faic jcc h100 w100"><i class="${icon}" /></div>`);newG.appendChild(makeForeignObject({x:0,y:0,width:72,height:72,class:"nodeicon"+(isImported?"dataset-imported":"")},iconElement));newG.appendChild(makeSVG("rect",{class:"selection-outline",x:0,y:0,width:72,height:72}));newG.appendChild(makeForeignObject({x:56,y:-15,width:34,height:34,class:"node-totem"},$(`<span size="32">`)));let offset={x:0,y:0};if(dataset.veLoopDatasetRef){let coords={cx:1,cy:67,rx:10,ry:10,indicatorX:-9,indicatorY:57};drawRepeatedObjectSticker(newG,coords);offset.y+=18}if(angular.isDefined(dataset.shortDesc)&&dataset.shortDesc.length>0){let coords={cx:1,cy:67,rx:10,ry:10,indicatorX:-9,indicatorY:57};drawInformationSticker(newG,coords,offset);offset.y+=18}if(local&&dataset.discussionsFullIds&&dataset.discussionsFullIds.length>0){let unread=hasUnreadDiscussion(dataset);let coords={cx:0,cy:67.5,rx:10.5,ry:9,indicatorX:-10,indicatorY:57.5,contentX:-20,contentY:57.5};const isFirefox=navigator.userAgent.toLowerCase().indexOf("firefox")>-1;drawDiscussionSticker(newG,dataset.discussionsFullIds.length,unread,coords,offset,{x:0,y:isFirefox?-2:0})}if(angular.isDefined(dataset.featureGroup)&&dataset.featureGroup){let coords={cx:70,cy:67,rx:11,ry:11,indicatorX:60,indicatorY:58};drawFeatureGroupSticker(newG,coords)}$(dotPolygon).replaceWith(newG)}}}function restyleModelNode(local){const isLLMGenericSm=savedModel=>savedModel.savedModelType&&["LLM_GENERIC","PLUGIN_AGENT","PYTHON_AGENT","TOOLS_USING_AGENT","RETRIEVAL_AUGMENTED_LLM"].includes(savedModel.savedModelType);return function(element){const nodeId=element.attr("data-id");const nodeZoneId=element.attr("data-zone-id");const sm=FlowGraph.node(nodeId);if(isLLMGenericSm(sm)){element.addClass("fine-tuned-sm")}const dotPolygon=element.find("polygon");if(dotPolygon.length){element.find("text").remove();const coords=polygonToRectData(dotPolygon);const newG=makeSVG("g",{class:"newG",transform:`translate(${coords.x} ${coords.y-coords.height})`});newG.appendChild(makeSVG("rect",{x:0,y:0,width:coords.width*.707,height:coords.height*.707,transform:`translate(${coords.width/2}) rotate(45)`,opacity:0,class:"fill"}));const othersZones=FlowGraph.nodeSharedBetweenZones(sm);const isExported=othersZones&&!othersZones.has(nodeZoneId);const isImported=othersZones&&othersZones.has(nodeZoneId);const savedModelClass=isLLMGenericSm(sm)?" llm-model":"";if(sm.partitioned){for(let offset of[-10,-5,0]){newG.appendChild(makeSVG("rect",{x:offset,y:offset,width:coords.width*1.41421,height:coords.height*1.41421,transform:`translate(${coords.width}) rotate(45)`,class:"fill node__rectangle--partitioned partitioning-indicator"}))}newG.appendChild(makeSVG("rect",{x:0,y:0,width:coords.width*1.41421,height:coords.height*1.41421,transform:`translate(${coords.width}) rotate(45)`,class:"node__rectangle--blank"}))}if(isExported||isImported){newG.appendChild(makeSVG("rect",{x:0,y:0,width:coords.width*1.41421,height:coords.height*1.41421,transform:`translate(${coords.width}) rotate(45)`,class:"fill main-model-rectangle model-zone-"+(isExported?"exported":"imported")+savedModelClass}))}let iconText;if(sm.externalSavedModelType){const externalSmTypeToIcon={sagemaker:"model_amazon_sagemaker","azure-ml":"model_azureml","vertex-ai":"model_google_vertex",databricks:"model_databricks",mlflow:"model_mlflow"};iconText=flowIconset.icons[externalSmTypeToIcon[sm.externalSavedModelType]]}if(iconText===undefined){let iconKey="clustering";if(sm.taskType==="PREDICTION"){switch(sm.predictionType){case"TIMESERIES_FORECAST":iconKey="timeseries";break;case"DEEP_HUB_IMAGE_CLASSIFICATION":case"DEEP_HUB_IMAGE_OBJECT_DETECTION":iconKey="computer_vision";break;case"CAUSAL_REGRESSION":case"CAUSAL_BINARY_CLASSIFICATION":iconKey="causal";break;default:iconKey="regression";if(sm.backendType==="KERAS"){iconKey="deep_learning"}}}else if(sm.savedModelType==="PYTHON_AGENT"){iconKey="ai_agent_code"}else if(sm.savedModelType==="PLUGIN_AGENT"){iconKey="ai_agent_plugin"}else if(sm.savedModelType==="TOOLS_USING_AGENT"){iconKey="ai_agent_visual"}else if(sm.savedModelType==="RETRIEVAL_AUGMENTED_LLM"){iconKey="llm_augmented"}else if(isLLMGenericSm(sm)){iconKey="fine_tuning"}iconText=flowIconset.icons["model_"+iconKey]}const iconElt=d3.select($.parseXML(iconText)).select("svg").selectAll("path,rect");const newG2=makeSVG("g");iconElt[0].forEach(i=>newG2.appendChild(i));d3.select(newG2).attr("transform"," scale(0.707, 0.707) translate(1, 1)");let klass="bzicon sm-icon";klass+=isImported?" model-zone-imported":isExported?" model-zone-exported":"";klass+=savedModelClass;d3.select(newG2).classed(klass,true);newG.appendChild(newG2);newG.appendChild(makeSVG("g",{class:"tool-simple-zone",transform:`translate(${coords.width+26}, 24)`,"data-height":coords.height}));if(!sm.description){sm.description="Saved model..."}newG.appendChild(makeSVG("rect",{x:0,y:0,width:coords.width*1.41421,height:coords.height*1.41421,opacity:0,transform:`translate(${coords.width})  rotate(45)`}));newG.appendChild(makeSVG("rect",{class:"selection-outline",x:0,y:0,width:coords.width*1.41421,height:coords.height*1.41421,transform:`translate(${coords.width})  rotate(45)`}));newG.appendChild(makeForeignObject({x:-30,y:coords.height*2.07,width:coords.width*2+60,height:42,class:"nodelabel-wrapper"},$("<div><span>"+sanitize(sm.description.replace(/([-_.])/g,"$1​"))+"</span></div>")));newG.appendChild(makeForeignObject({x:45,y:-10,width:32,height:32,class:"node-totem"},$(`<span size="32">`)));let offset={x:0,y:0};if(angular.isDefined(sm.shortDesc)&&sm.shortDesc.length>0){let coords={cx:27,cy:63,rx:10,ry:10,indicatorX:17,indicatorY:53};drawInformationSticker(newG,coords);offset.x+=12;offset.y+=12}if(local&&sm.discussionsFullIds&&sm.discussionsFullIds.length>0){let unread=hasUnreadDiscussion(sm);let coords={cx:24,cy:64.5,rx:10.5,ry:9,indicatorX:14,indicatorY:55,contentX:4,contentY:55};const isFirefox=navigator.userAgent.toLowerCase().indexOf("firefox")>-1;drawDiscussionSticker(newG,sm.discussionsFullIds.length,unread,coords,offset,{x:0,y:isFirefox?-2:0})}$(dotPolygon).replaceWith(newG)}}}function restyleEvaluationStoreNode(local){return function(element){const nodeId=element.attr("data-id");const nodeZoneId=element.attr("data-zone-id");const mes=FlowGraph.node(nodeId);const dotPolygon=element.find("polygon");if(dotPolygon.length){element.find("text").remove();const coords=polygonToRectData(dotPolygon);const newG=makeSVG("g",{class:"newG bzicon",transform:`translate(${coords.x} ${coords.y-coords.height})`});newG.appendChild(makeSVG("rect",{x:0,y:0,width:coords.width*.707,height:coords.height*.707,transform:`translate(${coords.width/2}) rotate(45)`,opacity:0,class:"fill"}));const othersZones=FlowGraph.nodeSharedBetweenZones(mes);const isExported=othersZones&&!othersZones.has(nodeZoneId);const isImported=othersZones&&othersZones.has(nodeZoneId);if(mes.partitioned){for(let offset of[-10,-5,0]){newG.appendChild(makeSVG("rect",{x:offset,y:offset,width:coords.width*1.41421,height:coords.height*1.41421,transform:`translate(${coords.width}) rotate(45)`,class:"fill node__rectangle--partitioned partitioning-indicator"}))}newG.appendChild(makeSVG("rect",{x:0,y:0,width:coords.width*1.41421,height:coords.height*1.41421,transform:`translate(${coords.width}) rotate(45)`}))}else{newG.appendChild(makeSVG("rect",{x:0,y:0,width:coords.width*1.41421,height:coords.height*1.41421,transform:`translate(${coords.width}) rotate(45)`}))}if(isExported){newG.appendChild(makeSVG("rect",{x:0,y:0,width:coords.width*1.41421,height:coords.height*1.41421,transform:`translate(${coords.width}) rotate(45)`,class:"fill evaluation-store-zone-exported"}))}const icon="dku-icon-model-evaluation-store-48";newG.appendChild(makeForeignObject({x:12,y:12,width:48,height:48,class:"nodeicon"+(isImported?" evaluation-store-zone-imported":isExported?" evaluation-store-zone-exported":"")},$(`<div class="flow-tile" style="text-align: center"><i class="${icon}" /></div>`)));newG.appendChild(makeSVG("g",{class:"tool-simple-zone",transform:`translate(${coords.width+26}, 24)`,"data-height":coords.height}));if(!mes.description){mes.description="Model evaluation store..."}newG.appendChild(makeSVG("rect",{class:"selection-outline",x:0,y:0,width:coords.width*1.41421,height:coords.height*1.41421,transform:`translate(${coords.width})  rotate(45)`}));newG.appendChild(makeForeignObject({x:-30,y:coords.height*2.07,width:coords.width*2+60,height:42,class:"nodelabel-wrapper"},$("<div><span>"+sanitize(mes.description.replace(/([-_.])/g,"$1​"))+"</span></div>")));newG.appendChild(makeForeignObject({x:45,y:-10,width:32,height:32,class:"node-totem"},$(`<span size="32">`)));let offset={x:0,y:0};if(angular.isDefined(mes.shortDesc)&&mes.shortDesc.length>0){let coords={cx:27,cy:63,rx:10,ry:10,indicatorX:17,indicatorY:53};drawInformationSticker(newG,coords);offset.x+=12;offset.y+=12}if(local&&mes.discussionsFullIds&&mes.discussionsFullIds.length>0){let unread=hasUnreadDiscussion(mes);let coords={cx:24,cy:64.5,rx:10.5,ry:9,indicatorX:14,indicatorY:55,contentX:4,contentY:55};const isFirefox=navigator.userAgent.toLowerCase().indexOf("firefox")>-1;drawDiscussionSticker(newG,mes.discussionsFullIds.length,unread,coords,offset,{x:0,y:isFirefox?-2:0})}$(dotPolygon).replaceWith(newG)}}}function restyleRetrievableKnowledgeNode(local){return function(element){const nodeId=element.attr("data-id");const nodeZoneId=element.attr("data-zone-id");const rk=FlowGraph.node(nodeId);const dotPolygon=element.find("polygon");if(dotPolygon.length){element.find("text").remove();const coords=polygonToRectData(dotPolygon);let clazz="newG bzicon retrievable-knowledge";if(rk.neverBuilt){clazz+=" never-built-computable"}const newG=makeSVG("g",{class:clazz,transform:`translate(${coords.x} ${coords.y})`});const othersZones=FlowGraph.nodeSharedBetweenZones(rk);const isExported=othersZones&&!othersZones.has(nodeZoneId);const isImported=othersZones&&othersZones.has(nodeZoneId);const margin=isExported&&othersZones.size>0?4:0;if(isExported){newG.appendChild(makeSVG("rect",{x:0,y:0,width:coords.width,height:coords.height,class:"fill retrievable-knowledge-zone-exported"}))}newG.appendChild(makeSVG("rect",{x:margin,y:margin,width:coords.width-margin*2,height:coords.height-margin*2,class:"fill retrievable-knowledge-rectangle main-retrievable-knowledge-rectangle"+(isImported?" retrievable-knowledge-zone-imported":"")}));const icon="dku-icon-cards-stack-48";newG.appendChild(makeForeignObject({x:12,y:13,width:48,height:48,class:"nodeicon"+(isImported?" retrievable-knowledge-zone-imported":isExported?" retrievable-knowledge-zone-exported":"")},$(`<div class="flow-tile" style="text-align: center"><i class="${icon}" /></div>`)));newG.appendChild(makeSVG("g",{class:"tool-simple-zone",transform:`translate(${coords.width}, 0)`,"data-height":coords.height}));if(!rk.description){rk.description="Knowledge Bank..."}newG.appendChild(makeSVG("rect",{class:"selection-outline",x:0,y:0,width:coords.width,height:coords.height}));newG.appendChild(makeForeignObject({x:-30,y:coords.height*1.07,width:coords.width+60,height:45,class:"nodelabel-wrapper"},$("<div><span>"+sanitize(rk.description.replace(/([-_.])/g,"$1​"))+"</span></div>")));newG.appendChild(makeForeignObject({x:56,y:-15,width:34,height:34,class:"node-totem"},$(`<span size="32">`)));let offset={x:0,y:0};if(angular.isDefined(rk.shortDesc)&&rk.shortDesc.length>0){let coords={cx:1,cy:67,rx:10,ry:10,indicatorX:-9,indicatorY:57};drawInformationSticker(newG,coords);offset.y+=20}if(local&&rk.discussionsFullIds&&rk.discussionsFullIds.length>0){let unread=hasUnreadDiscussion(rk);let coords={cx:24,cy:64.5,rx:10.5,ry:9,indicatorX:14,indicatorY:55,contentX:4,contentY:55};const isFirefox=navigator.userAgent.toLowerCase().indexOf("firefox")>-1;drawDiscussionSticker(newG,rk.discussionsFullIds.length,unread,coords,offset,{x:0,y:isFirefox?-2:0})}$(dotPolygon).replaceWith(newG)}}}function restyleFolderNode(local){return function(element){const nodeId=element.attr("data-id");const nodeZoneId=element.attr("data-zone-id");const folder=FlowGraph.node(nodeId);const dotPolygon=element.find("polygon");if(dotPolygon.length){const coords=polygonToRectData(dotPolygon);const newG=makeSVG("g",{class:"newG",transform:`translate(${coords.x} ${coords.y})`});const othersZones=FlowGraph.nodeSharedBetweenZones(folder);const isExported=othersZones&&!othersZones.has(nodeZoneId);const isImported=othersZones&&othersZones.has(nodeZoneId);element.find("text").remove();const iconText=flowIconset.icons["folder"];let iconElt=d3.select($.parseXML(iconText)).select("svg").select("g");iconElt.attr("transform"," scale(0.57, 0.57) ");iconElt.classed("bzicon"+(isImported?" folder-zone-imported":""),true);newG.appendChild(iconElt[0][0]);newG.appendChild(makeSVG("g",{class:"tool-simple-zone",transform:`translate(${coords.width}, 0)`,"data-height":coords.height}));if(!folder.description){folder.description="Managed folder"}newG.appendChild(makeForeignObject({x:-30,y:coords.height*1.01,width:coords.width+60,height:42,class:"nodelabel-wrapper"},$("<div><span>"+sanitize(folder.description.replace(/([-_.])/g,"$1​"))+"</span></div>")));newG.appendChild(makeSVG("rect",{x:0,y:0,width:coords.width,height:coords.height,opacity:0}));newG.appendChild(makeForeignObject({x:48,y:-13,width:32,height:32,class:"node-totem"},$(`<span size="32">`)));let offset={x:0,y:0};if(angular.isDefined(folder.shortDesc)&&folder.shortDesc.length>0){let coords={cx:1,cy:55,rx:10,ry:10,indicatorX:-9,indicatorY:45};drawInformationSticker(newG,coords);offset.y+=13}if(local&&folder.discussionsFullIds&&folder.discussionsFullIds.length>0){let unread=hasUnreadDiscussion(folder);let coords={cx:0,cy:51.5,rx:10.5,ry:9,indicatorX:-10,indicatorY:42,contentX:-20,contentY:42};const isFirefox=navigator.userAgent.toLowerCase().indexOf("firefox")>-1;drawDiscussionSticker(newG,folder.discussionsFullIds.length,unread,coords,offset,{x:0,y:isFirefox?-2:0})}$(dotPolygon).replaceWith(newG)}}}function restyleStreamingEndpointNode(local){return function(element){const nodeId=element.attr("data-id");const sm=FlowGraph.node(nodeId);const streamingEndpoint=FlowGraph.node(nodeId);const dotPolygon=element.find("polygon");if(dotPolygon.length){element.find("text").remove();const coords=polygonToRectData(dotPolygon);const newG=makeSVG("g",{class:"newG bzicon",transform:`translate(${coords.x} ${coords.y})`});newG.appendChild(makeSVG("path",{d:"M0,0 L48,0 L64,29 L48,58 L0,58 Z",opacity:1,class:"fill"}));const icon=$filter("toModernIcon")($filter("datasetTypeToIcon")(streamingEndpoint.streamingEndpointType,48),48);newG.appendChild(makeForeignObject({x:5,y:5,width:48,height:48,class:"nodeicon"},$(`<div class="flow-tile" style="text-align: center"><i class="${icon}" /></div>`)));newG.appendChild(makeSVG("g",{class:"tool-simple-zone",transform:`translate(${coords.width+26}, 24)`,"data-height":coords.height}));newG.appendChild(makeSVG("path",{class:"selection-outline",d:"M-1,-1 L48.5,-1 L65,29 L48.5,59 L-1,59 Z"}));newG.appendChild(makeForeignObject({x:-30,y:coords.height*1.2,width:coords.width+60,height:42,class:"nodelabel-wrapper"},$("<div><span>"+sm.name.replace(/([-_.])/g,"$1​")+"</span></div>")));newG.appendChild(makeForeignObject({x:45,y:-10,width:32,height:32,class:"node-totem"},$(`<span size="32">`)));$(dotPolygon).replaceWith(newG)}}}function restyleRunnableNode(runnableType){return function(element,g){if(!["recipe","labeling_task"].includes(runnableType)){return}const isRecipe=runnableType==="recipe";const nodeId=element.attr("data-id");const runnable=FlowGraph.node(nodeId);const iconScale=.52;const dotEllipse=element.find("ellipse");if(dotEllipse.length){const coords=circleToRectData(dotEllipse);const newG=makeSVG("g",{class:"newG",transform:`translate(${coords.x} ${coords.y}) scale(${iconScale}, ${iconScale})`});const recipeType=isRecipe?runnable.recipeType:"labeling_task";const iconText=flowIconset.icons[$filter("recipeFlowIcon")(recipeType)];d3.select(newG).classed("bzicon recipeicon-"+recipeType,true);if(isRecipe&&(runnable.recipeType.startsWith("CustomCode_")||runnable.recipeType.startsWith("App_"))){const colorClass=$filter("recipeTypeToColorClass")(runnable.recipeType);d3.select(newG).classed("universe-fill "+colorClass,true)}d3.select(g).attr("data-recipe-type",isRecipe?runnable.recipeType:"Labeling");let iconElt=d3.select($.parseXML(iconText)).select("svg").selectAll("g");if(iconElt.length===0||iconElt[0].length===0){iconElt=d3.select($.parseXML(iconText)).select("svg").selectAll("path")}try{$(dotEllipse).replaceWith(newG);iconElt[0].forEach(function(x){newG.appendChild(x)});newG.appendChild(makeSVG("rect",{x:0,y:0,width:coords.width/iconScale,height:coords.height/iconScale,opacity:0}))}catch(e){logger.error("Failed patch recipe icon",e)}if(isRecipe&&(runnable.recipeType.startsWith("CustomCode_")||runnable.recipeType.startsWith("App_"))){const icon=$filter("toModernIcon")($filter("recipeTypeToIcon")(runnable.recipeType,48),48);newG.appendChild(makeForeignObject({x:0,y:0,width:SIZE,height:SIZE,class:"nodeicon"},$('<div class="recipe-custom-code-object"><i class="'+icon+'"></i></div>')))}newG.appendChild(makeSVG("g",{class:"tool-simple-zone",transform:`translate(${SIZE}, 0) scale(${1/iconScale}, ${1/iconScale})`,"data-height":SIZE*iconScale}));newG.appendChild(makeSVG("circle",{class:"selection-outline",r:50*iconScale,cx:50*iconScale,cy:50*iconScale,transform:`scale(${1/iconScale}, ${1/iconScale})`}));newG.appendChild(makeForeignObject({x:30,y:-17,width:32,height:32,class:"node-totem",transform:`scale(${1/iconScale}, ${1/iconScale})`},$(`<span size="32">`)));let offset={x:0,y:0};if(runnable.veLoopDatasetRef){let coords={cx:14,cy:86,rx:10/iconScale,ry:10/iconScale,indicatorX:-1.5,indicatorY:76};drawRepeatedObjectSticker(newG,coords);offset.x+=11;offset.y+=34}if(angular.isDefined(runnable.shortDesc)&&runnable.shortDesc.length>0){let coords={cx:14,cy:86,rx:10/iconScale,ry:10/iconScale,indicatorX:-.5,indicatorY:69};drawInformationSticker(newG,coords,offset);if(offset.x||offset.y){offset.x-=10;offset.y+=36.5}else{offset.x+=11;offset.y+=34}}if(runnable.discussionsFullIds.length>0){let unread=hasUnreadDiscussion(runnable);let coords={cx:7.5,cy:90.5,rx:10.5/iconScale,ry:9/iconScale,indicatorX:-10,indicatorY:75,contentX:-12,contentY:80};drawDiscussionSticker(newG,runnable.discussionsFullIds.length,unread,coords,offset)}}}}});app.service("ProjectFlowGraphLayout",function(FlowGraph,LoggerProvider){var logger=LoggerProvider.getLogger("flow");this.relayout=function(globalSvg){const zones=$(globalSvg).find("svg");if(zones&&zones.length>0){for(let i=0;i<zones.length;i++){this.relayoutSVG($(zones[i]),true)}}else{this.relayoutSVG(globalSvg,false)}};this.relayoutSVG=(svg,isZoneRelayout)=>{const usedDatasets=makeSVG("g",{class:"usedDatasets"});const inputDatasets=makeSVG("g",{class:"inputDatasets"});const draftDatasets=makeSVG("g",{class:"draftDatasets"});svg.find("g[class=graph]").append(usedDatasets);$(usedDatasets).append(inputDatasets);svg.find("g[class=graph]").append(draftDatasets);svg.find("g.edge").each((index,boxElement)=>{usedDatasets.appendChild(boxElement)});svg.find("g[data-type]").each(function(index,boxElement){const nodeId=$(boxElement).data("id");const node=FlowGraph.node(nodeId);if(!node){logger.warn("Graph node does not exist: ",nodeId);return}if(!node.predecessors.length&&!node.successors.length){draftDatasets.appendChild(boxElement)}else if(!node.predecessors.length){inputDatasets.appendChild(boxElement)}else{usedDatasets.appendChild(boxElement)}});let datasetsPerColumns=Math.max(inputDatasets.childNodes.length,Math.floor(Math.sqrt(draftDatasets.childNodes.length)),1);let gridWidth=180;let gridHeight=180;let columnHeight=gridHeight*datasetsPerColumns;if(inputDatasets.childNodes.length&&!isZoneRelayout){datasetsPerColumns=inputDatasets.childNodes.length;gridWidth=inputDatasets.childNodes[0].getBBox().width+50;columnHeight=inputDatasets.getBBox().height;gridHeight=columnHeight/datasetsPerColumns}let nbFullRows=Math.floor(draftDatasets.childNodes.length/datasetsPerColumns)||1;const DRAFT_DATASETS_MARGIN_X=20;const DRAFT_DATASETS_MARGIN_Y=50;for(let index=0;index<draftDatasets.childNodes.length;index++){let offset=0;if(nbFullRows>0&&index>=nbFullRows*datasetsPerColumns){offset=(columnHeight-gridHeight*(draftDatasets.childNodes.length%datasetsPerColumns))/2}let dx=Math.floor(index/datasetsPerColumns)*gridWidth+DRAFT_DATASETS_MARGIN_X;let dy=offset+index%datasetsPerColumns*gridHeight+DRAFT_DATASETS_MARGIN_Y;$(draftDatasets).children().eq(index).find("g").first().attr("transform",`translate(${dx}  ${dy})`)}setTimeout(function(){let usedDatasetsBB=usedDatasets.getBBox();let draftDatasetsBB=draftDatasets.getBBox();if(!isZoneRelayout){let translateX=usedDatasetsBB.x-draftDatasetsBB.x-draftDatasetsBB.width-200;let translateY=usedDatasetsBB.y-draftDatasetsBB.y;draftDatasets.setAttribute("transform","translate("+translateX+" "+translateY+")")}else{let translateGraphY=-draftDatasetsBB.y;if(inputDatasets.childNodes.length){translateGraphY=-usedDatasetsBB.y+1}svg.find("g[class=graph]")[0].setAttribute("transform","translate(32,"+translateGraphY+")")}})}});app.service("InterProjectGraphLayout",function(FlowGraph){this.relayout=function(svg){let connectedProjects=makeSVG("g",{class:"connectedProjects"});let inputProjects=makeSVG("g",{class:"inputProjects"});let standAloneProjects=makeSVG("g",{class:"standAloneProjects"});let projectFolders=makeSVG("g",{class:"projectFolders"});svg.find("g[class=graph]").append(projectFolders);svg.find("g[class=graph]").append(connectedProjects);$(connectedProjects).append(inputProjects);svg.find("g[class=graph]").append(standAloneProjects);svg.find("g[data-type]").each(function(index,boxElement){let node=FlowGraph.node($(boxElement).data("id"));if(node.nodeType=="PROJECT_FOLDER"){projectFolders.appendChild(boxElement)}else if(!node.predecessors.length&&!node.successors.length){standAloneProjects.appendChild(boxElement)}else if(!node.predecessors.length){inputProjects.appendChild(boxElement)}else{connectedProjects.appendChild(boxElement)}});let minProjectsPerRow=3;let maxProjecsPerRow=10;let projectsPerRows=Math.min(Math.max(minProjectsPerRow,Math.floor(Math.sqrt(standAloneProjects.childNodes.length))),maxProjecsPerRow);let cellMargin=20;let cellWidth=150+cellMargin;let cellHeight=100+cellMargin;let pfCellHeight=40+cellMargin;let rowWidth=cellWidth*projectsPerRows;if(inputProjects.childNodes.length){cellWidth=inputProjects.childNodes[0].getBBox().width+50;cellHeight=inputProjects.childNodes[0].getBBox().height+cellMargin;projectsPerRows=Math.min(Math.max(minProjectsPerRow,Math.floor(connectedProjects.getBBox().width/cellWidth)),maxProjecsPerRow)}if(projectFolders.childNodes.length){pfCellHeight=projectFolders.childNodes[0].getBBox().height+cellMargin}for(let index=0;index<standAloneProjects.childNodes.length;index++){let tr=index%projectsPerRows*cellWidth+" "+Math.floor(index/projectsPerRows)*cellHeight;$(standAloneProjects).children().eq(index).find("g").first().attr("transform","translate("+tr+")")}for(let index=0;index<projectFolders.childNodes.length;index++){let tr=index%projectsPerRows*cellWidth+" "+Math.floor(index/projectsPerRows)*pfCellHeight;$(projectFolders).children().eq(index).find("g").first().attr("transform","translate("+tr+")")}let connectedProjectsBB=connectedProjects.getBBox();let standAloneProjectsBB=standAloneProjects.getBBox();let sapTranslateX=connectedProjectsBB.x;let sapTranslateY=connectedProjectsBB.y+connectedProjectsBB.height+100;standAloneProjects.setAttribute("transform","translate("+sapTranslateX+" "+sapTranslateY+")");let projectFoldersBB=projectFolders.getBBox();let pfTranslateX=connectedProjectsBB.x;let pfTranslateY=connectedProjectsBB.y-(projectFoldersBB.height+100);projectFolders.setAttribute("transform","translate("+pfTranslateX+" "+pfTranslateY+")")}});app.service("InterProjectGraphStyling",function($filter,ImageUrl,FlowGraph,CachedAPICalls,LoggerProvider){const SIZE=100;const logger=LoggerProvider.getLogger("projectsGraph");const formatters={PROJECT_FOLDER:restyleNodeForProjectFolder,PROJECT:restyleNodeForProject,BUNDLE_EO:restyleNodeForExposedObject};let flowIconset;CachedAPICalls.flowIcons.success(function(data){flowIconset=data});this.restyleGraph=function(svg,graph){svg.find("title").remove();svg.find("g[data-type]").each(function(index,g){try{restyleNode(g)}catch(e){logger.error("Failed to restyle flow node: ",e)}})};function restyleNode(g){const element=$(g);const nodeType=element.attr("data-type");if(formatters[nodeType]){formatters[nodeType](element,g)}}function createExposedObjectSvg(nodeIcons,index,x,y,d){const g=makeSVG("g",{class:nodeIcons[index].type,transform:"translate("+x+" "+y+") scale("+d/SIZE+","+d/SIZE+")"});nodeIcons[index].elt[0].forEach(function(x){g.appendChild(x)});addCountToExposedObjectSvg(g,nodeIcons,index,x,y,d);return g}function addCountToExposedObjectSvg(g,nodeIcons,index,x,y,d){const r=SIZE/5;const cx=SIZE/2+SIZE/(2*Math.sqrt(2));const cy=SIZE/2+SIZE/(2*Math.sqrt(2));const circle=makeSVG("circle",{r:r,cx:cx,cy:cy,class:"count-circle"});const text=makeSVG("text",{x:cx,y:cy,class:"count-text"});text.textContent=nodeIcons[index].nbElements;g.appendChild(circle);g.appendChild(text)}function drawExposedObjectNodeIcons(newG,nodeIcons,coords){switch(nodeIcons.length){case 1:{const g0=createExposedObjectSvg(nodeIcons,0,1,1,coords.width-2);newG.appendChild(g0);break}case 2:{const diameter=(coords.width-2)/2;const x0=1;const y0=1+coords.height/4;const g0=createExposedObjectSvg(nodeIcons,0,x0,y0,diameter);newG.appendChild(g0);const x1=1+coords.width/2;const y1=1+coords.height/4;const g1=createExposedObjectSvg(nodeIcons,1,x1,y1,diameter);newG.appendChild(g1);break}case 3:{const diameter=(coords.width-2)/2;const x0=1;const y0=1+coords.height/4;const g0=createExposedObjectSvg(nodeIcons,0,x0,y0,diameter);newG.appendChild(g0);const x1=1+coords.width/2;const y1=1;const g1=createExposedObjectSvg(nodeIcons,1,x1,y1,diameter);newG.appendChild(g1);const x2=1+coords.width/2;const y2=1+coords.height/2;const g2=createExposedObjectSvg(nodeIcons,2,x2,y2,diameter);newG.appendChild(g2);break}case 4:{const diameter=(coords.width-2)/2;const x0=1;const y0=1;const g0=createExposedObjectSvg(nodeIcons,0,x0,y0,diameter);newG.appendChild(g0);const x1=1;const y1=1+coords.height/2;const g1=createExposedObjectSvg(nodeIcons,1,x1,y1,diameter);newG.appendChild(g1);const x2=1+coords.width/2;const y2=1;const g2=createExposedObjectSvg(nodeIcons,2,x2,y2,diameter);newG.appendChild(g2);const x3=1+coords.width/2;const y3=1+coords.height/2;const g3=createExposedObjectSvg(nodeIcons,3,x3,y3,diameter);newG.appendChild(g3);break}case 5:{const diameter=(coords.width-2)/3;const x0=1+coords.width/3;const y0=1;const g0=createExposedObjectSvg(nodeIcons,0,x0,y0,diameter);newG.appendChild(g0);const x1=1;const y1=1+coords.height/3;const g1=createExposedObjectSvg(nodeIcons,1,x1,y1,diameter);newG.appendChild(g1);const x2=1+coords.width/3;const y2=1+coords.height/3;const g2=createExposedObjectSvg(nodeIcons,2,x2,y2,diameter);newG.appendChild(g2);const x3=1+coords.width*2/3;const y3=1+coords.height/3;const g3=createExposedObjectSvg(nodeIcons,3,x3,y3,diameter);newG.appendChild(g3);const x4=1+coords.width/3;const y4=1+coords.height*2/3;const g4=createExposedObjectSvg(nodeIcons,4,x4,y4,diameter);newG.appendChild(g4)}}}function restyleNodeForProjectFolder(element){const nodeId=element.attr("data-id");const projectFolder=FlowGraph.node(nodeId);const dotPolygon=element.find("polygon");const coords=polygonToRectData(dotPolygon);const newG=makeSVG("g",{class:"newG",transform:"translate("+coords.x+" "+coords.y+")"});$(dotPolygon).replaceWith(newG);element.find("text").remove();newG.appendChild(makeSVG("rect",{x:0,y:0,width:coords.width,height:coords.height,class:"fill"}));newG.appendChild(makeForeignObject({x:0,y:0,width:coords.width,height:coords.height,class:"project-folder-meta nodelabel-wrapper"},$("<div>"+'<p class="single-line"><i class="icon-folder-close"></i>'+sanitize(projectFolder.description.replace(/([-_.])/g,"$1​"))+"</p>"+"</div>")))}function restyleNodeForProject(element){const nodeId=element.attr("data-id");const project=FlowGraph.node(nodeId);const dotPolygon=element.find("polygon");const coords=polygonToRectData(dotPolygon);const newG=makeSVG("g",{class:"newG",transform:"translate("+coords.x+" "+coords.y+")"});if(project.isArchived){d3.select(newG).classed("archived",true)}if(project.isForbidden){d3.select(newG).classed("forbidden",true)}if(project.isNotInFolder){d3.select(newG).classed("not-in-folder",true)}$(dotPolygon).replaceWith(newG);element.find("text").remove();newG.appendChild(makeSVG("rect",{x:0,y:0,width:coords.width,height:coords.height,class:"fill"}));newG.appendChild(makeForeignObject({x:0,y:0,width:coords.width,height:coords.height,class:"project-meta nodelabel-wrapper"},$("<div>"+'<i class="img-area">'+(project.isForbidden?"":'<img src="'+ImageUrl(project.name,project.projectKey,project.projectKey,"PROJECT",project.objectImgHash,"80x200",project.imgColor,project.imgPattern,project.showInitials)+'" />')+"</i>"+"<p>"+sanitize(project.description.replace(/([-_.])/g,"$1​"))+"</p>"+"</div>")));if(project.projectAppType==="APP_TEMPLATE"){const appIconSize=25;newG.appendChild(makeForeignObject({x:0,y:coords.height-appIconSize,width:appIconSize,height:appIconSize,class:"project-meta"},$(`
                    <div class="app-template-overlay app-template-overlay--graph" title="${project.isAppAsRecipe?"Application-as-recipe":"Visual application"} template">
                        <i class="${project.isAppAsRecipe?"icon-dku-application-as-recipe":"icon-project-app"}"></i>
                    </div>
                `)))}if(project.isForbidden){newG.appendChild(makeForeignObject({x:113,y:64,width:30,height:30,class:"forbidden-icon"},$('<div><i class="icon-lock" /></div>')))}if(project.isNotInFolder){newG.appendChild(makeForeignObject({x:35,y:63,width:30,height:30,class:"not-in-folder-icon"},$('<div><span class="icon-stack"><i class="icon-folder-close"></i><i class="icon-ban-circle icon-stack-base"></i></span></div>')))}}function restyleNodeForExposedObject(element){const icons=[];function addIcon(type,nbElements){const icon={};const iconText=flowIconset.icons[type];let iconElt=d3.select($.parseXML(iconText)).select("svg").selectAll("circle, path, rect");icon.elt=iconElt;icon.type=type;icon.nbElements=nbElements;icons.push(icon)}function addIcons(bundle){if(bundle.exposedDatasets.length>0){addIcon("eo_datasets",bundle.exposedDatasets.length)}if(bundle.exposedFolders.length>0){addIcon("eo_folders",bundle.exposedFolders.length)}if(bundle.exposedModels.length>0){addIcon("eo_models",bundle.exposedModels.length)}if(bundle.exposedNotebooks.length>0){addIcon("eo_notebooks",bundle.exposedNotebooks.length)}if(bundle.exposedWebApps.length>0){addIcon("eo_webapps",bundle.exposedWebApps.length)}if(bundle.exposedReports.length>0){addIcon("eo_reports",bundle.exposedReports.length)}if(bundle.errorMessages.length>0){addIcon("error",bundle.errorMessages.length)}}const nodeId=element.attr("data-id");const bundle=FlowGraph.node(nodeId);const dotEllipse=element.find("ellipse");const coords=circleToRectData(dotEllipse);const newG=makeSVG("g",{class:"newG",transform:`translate(${coords.x} ${coords.y})`});d3.select(newG).classed("bzicon",true);addIcons(bundle);if(icons.length==0){throw new Error("No icons for type",bundle)}drawExposedObjectNodeIcons(newG,icons,coords);try{$(dotEllipse).replaceWith(newG);newG.appendChild(makeSVG("rect",{x:0,y:0,width:coords.width,height:coords.height,opacity:0}))}catch(e){}const text=element.find("text:not(.count-text)");text.remove()}});app.service("FlowGraphFiltering",function(){function getBBoxAccountingForTranslation(svgElt){if(!svgElt.hasAttribute("transform")){return svgElt.getBBox()}const parent=svgElt.parentNode;const tmpGElt=makeSVG("g");parent.insertBefore(tmpGElt,svgElt);tmpGElt.appendChild(svgElt);const bbox=tmpGElt.getBBox();parent.insertBefore(svgElt,tmpGElt);tmpGElt.remove();return bbox}this.getBBoxFromSelector=function(globalSvg,selector){const svgs=$(selector).closest("svg");let gTopLeft,gBottomRight;svgs.each(function(){const svg=$(this);let topLeft,bottomRight;function addItemToBBox(refBBox){return function(){let bbox=getBBoxAccountingForTranslation(this);if(refBBox&&svg.is(globalSvg)){bbox={x:bbox.x+refBBox.x,y:bbox.y+refBBox.y,width:bbox.width,height:bbox.height}}if(topLeft===undefined){topLeft=svg[0].createSVGPoint();topLeft.x=bbox.x;topLeft.y=bbox.y;bottomRight=svg[0].createSVGPoint();bottomRight.x=bbox.x+bbox.width;bottomRight.y=bbox.y+bbox.height}else{topLeft.x=Math.min(topLeft.x,bbox.x);topLeft.y=Math.min(topLeft.y,bbox.y);bottomRight.x=Math.max(bottomRight.x,bbox.x+bbox.width);bottomRight.y=Math.max(bottomRight.y,bbox.y+bbox.height)}}}const graphBBox=svg.find("g.graph")[0].getBBox();const isZone=$(selector).parentsUntil(svg,".usedDatasets").length===0&&$(selector).parentsUntil(svg,".draftDatasets").length===0;const matrix=isZone?svg[0].getTransformToElement(globalSvg[0]):$(".usedDatasets",svg)[0].getTransformToElement(globalSvg[0]);if(isZone){svg.find(selector).each(addItemToBBox())}else{$(".usedDatasets",svg).find(selector).each(addItemToBBox());$(".draftDatasets",svg).find(selector).each(addItemToBBox(graphBBox))}if(topLeft===undefined){return undefined}topLeft=topLeft.matrixTransform(matrix);bottomRight=bottomRight.matrixTransform(matrix);if(gTopLeft===undefined){gTopLeft={x:topLeft.x,y:topLeft.y};gBottomRight={x:bottomRight.x,y:bottomRight.y}}else{gTopLeft.x=Math.min(gTopLeft.x,topLeft.x);gTopLeft.y=Math.min(gTopLeft.y,topLeft.y);gBottomRight.x=Math.max(gBottomRight.x,bottomRight.x);gBottomRight.y=Math.max(gBottomRight.y,bottomRight.y)}});if(gTopLeft===undefined){return undefined}return{x:gTopLeft.x,y:gTopLeft.y,width:gBottomRight.x-gTopLeft.x,height:gBottomRight.y-gTopLeft.y}};this.fadeOut=function(svg,filter){if(filter&&filter.doFading){let d3node=d3.select(svg[0]);d3node.selectAll(".node").classed("filter-faded",true);d3node.selectAll(".edge").classed("filter-faded",true);$.each(filter.nonFadedNodes,function(idx,nodeId){let elt=svg.find(' [data-id="'+nodeId+'"]')[0];if(elt==null){let savedmodel_nodeId="savedmodel"+nodeId.substring("dataset".length);elt=svg.find(' [data-id="'+savedmodel_nodeId+'"]')[0];if(elt==null){let modelevaluationstore_nodeId="modelevaluationstore"+nodeId.substring("dataset".length);elt=svg.find(' [data-id="'+modelevaluationstore_nodeId+'"]')[0];if(elt==null){let managedfolder_nodeId="managedfolder"+nodeId.substring("dataset".length);elt=svg.find(' [data-id="'+managedfolder_nodeId+'"]')[0];if(elt==null){return}}}}d3.select(elt).classed("filter-faded",false)});$.each(filter.nonFadedEdges,function(idx,toNodeId){svg.find(' [data-to="'+toNodeId+'"]').each(function(){d3.select(this).classed("filter-faded",false)});let savedmodel_nodeId="savedmodel"+toNodeId.substring("dataset".length);svg.find(' [data-to="'+savedmodel_nodeId+'"]').each(function(){d3.select(this).classed("filter-faded",false)});let modelevaluationstore_nodeId="modelevaluationstore"+toNodeId.substring("dataset".length);svg.find(' [data-to="'+modelevaluationstore_nodeId+'"]').each(function(){d3.select(this).classed("filter-faded",false)});let managedfolder_nodeId="managedfolder"+toNodeId.substring("dataset".length);svg.find(' [data-to="'+managedfolder_nodeId+'"]').each(function(){d3.select(this).classed("filter-faded",false)})})}}});function polygonToRectData(polygon){const points=$(polygon).attr("points").split(" ");return{x:parseFloat(points[1].split(",")[0]),y:parseFloat(points[1].split(",")[1]),width:parseFloat(points[0].split(",")[0],10)-parseFloat(points[1].split(",")[0],10),height:parseFloat(points[2].split(",")[1],10)-parseFloat(points[1].split(",")[1],10)}}function circleToRectData(ellipse){const el=$(ellipse);return{x:el.attr("cx")-el.attr("rx"),y:el.attr("cy")-el.attr("ry"),width:el.attr("rx")*2,height:el.attr("ry")*2}}function makeForeignObject(attrs,jq){const el=makeSVG("foreignObject",attrs);$(el).append(jq);return el}})();(function(){"use strict";const app=angular.module("dataiku.flow.project",["dataiku.flow.graph"]);const FLOW_NODE_STATUS={RUNNING:"RUNNING",NOT_STARTED:"NOT_STARTED",DONE:"DONE"};app.directive("flowRightColumn",function(QuickView,TaggableObjectsUtils,FlowGraphSelection,FlowGraph){return{scope:true,link:function(scope,element,attrs){scope.QuickView=QuickView;scope.$watch("rightColumnItem",function(){scope.context="FLOW";scope.selection={selectedObject:scope.rightColumnItem,confirmedItem:scope.rightColumnItem}});scope.getSelectedNodes=function(){return scope.rightColumnSelection||[]};scope.getSelectedTaggableObjectRefs=function(){return scope.getSelectedNodes().map(TaggableObjectsUtils.fromNode)};scope.computeMovingImpact=function(){const computedImpact=[];const movingItems=FlowGraphSelection.getSelectedTaggableObjectRefs();function addSuccessors(node,original){if(!["RECIPE","LABELING_TASK"].includes(node.nodeType))return;node.successors.forEach(function(successor){let newTaggableObjectRef=TaggableObjectsUtils.fromNode(FlowGraph.node(successor));if(original&&successor==original.id||movingItems.some(it=>it.id===newTaggableObjectRef.id)||computedImpact.some(it=>it.id===newTaggableObjectRef.id))return;computedImpact.push(newTaggableObjectRef)})}function computeImpact(node){let predecessor=node.predecessors[0];if(predecessor&&!["RECIPE","LABELING_TASK"].includes(node.nodeType)){let newTaggableObjectRef=TaggableObjectsUtils.fromNode(FlowGraph.node(predecessor));if(computedImpact.some(it=>it.id===newTaggableObjectRef.id))return;if(!movingItems.some(it=>it.id===newTaggableObjectRef.id)){computedImpact.push(newTaggableObjectRef)}addSuccessors(FlowGraph.node(predecessor),node)}addSuccessors(node)}FlowGraphSelection.getSelectedNodes().forEach(function(node){let realNode=node.usedByZones.length?FlowGraph.node(`zone__${node.ownerZone}__${node.realId}`):node;computeImpact(realNode)});return computedImpact}}}});app.controller("FlowMassActionsCallbacks",function($scope,$rootScope,FlowTool,FlowGraphSelection,ToolBridgeService,PIPELINEABILITY_ACTIONS,SummaryService){$scope.onAction=function(action){let affectedViews=[];switch(action){case"action-clear":case"action-build":case"action-change-connection":case"action-share":case"action-set-virtualizable":reloadGraph();break;case"action-delete":case"action-unshare":reloadGraph();FlowGraphSelection.clearSelection();break;case"action-tag":affectedViews=["TAGS"];break;case"action-watch":case"action-star":affectedViews=["WATCH"];$rootScope.$emit("userInterestsUpdated");break;case"action-update-status":affectedViews=["COUNT_OF_RECORDS","FILESIZE"];break;case"action-set-auto-count-of-records":affectedViews=["COUNT_OF_RECORDS"];break;case"action-add-to-scenario":affectedViews=["SCHEDULING"];break;case"action-change-spark-config":affectedViews=["SPARK_CONFIG"];break;case PIPELINEABILITY_ACTIONS.changeSpark:affectedViews=["SPARK_PIPELINES"];break;case PIPELINEABILITY_ACTIONS.changeSQL:affectedViews=["SQL_PIPELINES"];break;case"action-change-impala-write-mode":affectedViews=["IMPALA_WRITE_MODE"];break;case"action-change-hive-engine":affectedViews=["HIVE_MODE"];break;case"action-convert-to-hive":case"action-convert-to-impala":reloadGraph();break;default:break}FlowTool.refreshFlowStateWhenViewIsActive(affectedViews)};function reloadGraph(){$rootScope.$emit("reloadGraph")}});app.directive("flowEditor",function($stateParams,$timeout,$rootScope,$controller,$filter,translate,AI_EXPLANATION_MODAL_MODES,Debounce,GraphZoomTrackerService,Assert,TopNav,CreateModalFromTemplate,uiCustomizationService,DataikuAPI,ClipboardUtils,ContextualMenu,HistoryService,Logger,StateUtils,TaggableObjectsUtils,localStorageService,FlowGraphSelection,FlowToolsRegistry,FlowToolsUtils,FlowGraph,FlowGraphFiltering,FlowGraphFolding,executeWithInstantDigest,PageSpecificTourService,OpalsService,OpalsMessageService,Notification,$q,MessengerUtils,DatasetRenameService,FlowBuildService,AnyLoc,WatchInterestState,WT1,ZoneService,RecipeRenameService,ToolBridgeService,Dialogs){function drawExposedIndicators(svg,nodesGraph){svg.find(".exposed-indicator").remove();svg.find("g[data-type=LOCAL_DATASET], g[data-type=LOCAL_SAVEDMODEL], g[data-type=LOCAL_MODELEVALUATIONSTORE], g[data-type=LOCAL_GENAIEVALUATIONSTORE], g[data-type=LOCAL_MANAGED_FOLDER], g[data-type=LOCAL_RETRIEVABLE_KNOWLEDGE]").each(function(index,boxElement){const nodeId=$(boxElement).attr("data-id");const node=nodesGraph.nodes[nodeId];if(!node){Logger.warn("Graph node not found:",nodeId);return}if(node.isExposed){const type={LOCAL_DATASET:"dataset",LOCAL_SAVEDMODEL:"model",LOCAL_MODELEVALUATIONSTORE:"model evaluation store",LOCAL_GENAIEVALUATIONSTORE:"genai evaluation store",LOCAL_MANAGED_FOLDER:"folder",LOCAL_RETRIEVABLE_KNOWLEDGE:"knowledge bank"}[$(boxElement).data("type")];const exposedSVG=$(makeSVG("foreignObject",{x:2,y:2,width:20,height:20,class:"exposed-indicator nodeicon-small"+(type=="dataset"||type=="knowledge bank"?"":"-dark")})).append($(`<div><i class="icon-mail-forward" title="This ${type} is exposed in other projects"></i></div>`));if(type=="folder"){$(boxElement).find(">g").first().append(exposedSVG)}else{$(boxElement).find(">g").append(exposedSVG)}}})}function drawForbiddenIndicators(svg,nodesGraph){svg.find(".forbidden-indicator").remove();svg.find("g[data-type=FOREIGN_DATASET], g[data-type=FOREIGN_SAVEDMODEL], g[data-type=FOREIGN_RETRIEVABLE_KNOWLEDGE], g[data-type=FOREIGN_MODELEVALUATIONSTORE], g[data-type=FOREIGN_GENAIEVALUATIONSTORE], g[data-type=FOREIGN_MANAGED_FOLDER]").each(function(index,boxElement){const nodeId=$(boxElement).attr("data-id");const node=nodesGraph.nodes[nodeId];if(!node){Logger.warn("Graph node not found:",nodeId);return}if(node.isForbiddenObject){const type={FOREIGN_DATASET:"dataset",FOREIGN_SAVEDMODEL:"model",FOREIGN_MODELEVALUATIONSTORE:"model evaluation store",FOREIGN_GENAIEVALUATIONSTORE:"genai evaluation store",FOREIGN_MANAGED_FOLDER:"folder",FOREIGN_RETRIEVABLE_KNOWLEDGE:"knowledge bank"}[$(boxElement).data("type")];const svgY={FOREIGN_DATASET:50,FOREIGN_SAVEDMODEL:50,FOREIGN_MODELEVALUATIONSTORE:50,FOREIGN_GENAIEVALUATIONSTORE:50,FOREIGN_RETRIEVABLE_KNOWLEDGE:50,FOREIGN_MANAGED_FOLDER:35}[$(boxElement).data("type")];const exposedSVG=$(makeSVG("foreignObject",{x:2,y:svgY,width:20,height:20,class:"exposed-indicator nodeicon-small"+(type=="dataset"||type=="knowledge bank"?"":"-dark")})).append($(`<div><i class="icon-warning-sign" title="You don't have the rights to access this object"></i></div>`));if(type=="folder"){$(boxElement).find(">g").first().append(exposedSVG)}else{$(boxElement).find(">g").append(exposedSVG)}}})}function drawBuildInProgressIndicators(svg,nodesGraph){svg.find(".build-indicator").remove();svg.find("g[data-type=LOCAL_DATASET], g[data-type=LOCAL_SAVEDMODEL], g[data-type=LOCAL_MODELEVALUATIONSTORE], g[data-type=LOCAL_GENAIEVALUATIONSTORE], g[data-type=LOCAL_MANAGED_FOLDER], g[data-type=LOCAL_RETRIEVABLE_KNOWLEDGE]").each(function(index,boxElement){let nodeId=$(boxElement).attr("data-id");let node=nodesGraph.nodes[nodeId];if(!node){Logger.warn("Graph node not found:",nodeId);return}let iconDom=null;if(node.beingBuilt){iconDom=$('<div class="icon-being-built"><i class="icon-play" /></div>')}else if(node.aboutToBeBuilt){iconDom=$('<div class="icon-about-to-be-built"><i class="icon-spinner"></i></div>')}if(iconDom){let $pinSvg=$(makeSVG("foreignObject",{x:75,y:55,width:20,height:20,class:"build-indicator"})).append(iconDom);if($(boxElement).data("type")=="LOCAL_MANAGED_FOLDER"){$(boxElement).find(">g").first().append($pinSvg)}else{$(boxElement).find(">g").append($pinSvg)}}});svg.find("g[data-type=RECIPE]").each(function(index,boxElement){let nodeId=$(boxElement).attr("data-id");let node=nodesGraph.nodes[nodeId];if(!node){Logger.warn("Graph node not found:",nodeId);return}let iconDom=null;if(node.continuousActivityDone){iconDom=$('<div class="icon-continuous-activity-done"><i class="icon-warning-sign" /></div>')}else if(node.beingBuilt){iconDom=$('<div class="icon-being-built"><i class="icon-play" /></div>')}if(iconDom){let $pinSvg=$(makeSVG("foreignObject",{x:55,y:40,width:20,height:20,class:"build-indicator",transform:"scale(1.92 1.92)"})).append(iconDom);$(boxElement).find(">g").append($pinSvg)}})}return{restrict:"EA",scope:true,controller:function($scope,$rootScope,SummaryService,PageSpecificTourService,FlowTool){$controller("FlowMassActionsCallbacks",{$scope:$scope});TopNav.setLocation(TopNav.TOP_FLOW,TopNav.LEFT_FLOW,TopNav.TABS_NONE,null);TopNav.setNoItem();uiCustomizationService.getComputeDatasetTypesStatus($scope,$stateParams.projectKey).then(computeStatus=>{$scope.canCreateUploadedFilesDataset=computeStatus("UploadedFiles")===uiCustomizationService.datasetTypeStatus.SHOW});$scope.projectFlow=true;$scope.nodesGraph={flowFiltersAndSettings:{}};$scope.getZoneColor=zoneId=>{const nodeFound=$scope.nodesGraph.nodes?$scope.nodesGraph.nodes[`zone_${zoneId}`]:undefined;if(nodeFound&&nodeFound.customData){return nodeFound.customData.color}return"#ffffff"};function updateUserInterests(){DataikuAPI.interests.getUserInterests($rootScope.appConfig.login,0,1e4,{projectKey:$stateParams.projectKey}).success(function(data){$scope.userInterests=data.interests.filter(x=>["RECIPE","DATASET","SAVED_MODEL","MODEL_EVALUATION_STORE","MANAGED_FOLDER","STREAMING_ENDPOINT","LABELING_TASK","RETRIEVABLE_KNOWLEDGE"].includes(x.objectType));const indexedInterests={};$scope.userInterests.forEach(function(interest){indexedInterests[interest.objectType+"___"+interest.objectId]=interest});$.each($scope.nodesGraph.nodes,function(nodeId,node){const taggableType=TaggableObjectsUtils.fromNodeType(node.nodeType);const interest=indexedInterests[taggableType+"___"+node.name];if(interest){node.interest=interest}else{node.interest={starred:false,watching:WatchInterestState.values.ENO}}})}).error(setErrorInScope.bind($scope))}$scope.setErrorInScopeCallbackForAngular=error=>setErrorDetailsInScope.bind($scope)(error);$scope.isNotInGraph=function(item){return $scope.nodesGraph&&$scope.nodesGraph.nodes&&!$scope.nodesGraph.nodes.hasOwnProperty("dataset_"+item.name)};$scope.processSerializedFilteredGraphResponse=function processSerializedFilteredGraphResponse(serializedFilteredGraph,zoomTo,errorScope){$scope.setGraphData(serializedFilteredGraph.serializedGraph);if(typeof zoomTo==="string"){const deregisterListener=$scope.$root.$on("flowDisplayUpdated",function(){deregisterListener();setTimeout(()=>{let id=zoomTo;let node=$scope.nodesGraph.nodes[zoomTo];if(!node){id=graphVizEscape(zoomTo);node=$scope.nodesGraph.nodes[id]}if(!node&&$scope.nodesGraph.hasProjectZones){id=Object.values($scope.nodesGraph.nodes).filter(it=>it.realId==id&&!it.usedByZones.length)[0].id}$scope.zoomGraph(id);GraphZoomTrackerService.instantSavePanZoomCtx($scope.panzoom);GraphZoomTrackerService.setFocusItemCtx($scope.nodesGraph.nodes[id]);FlowGraphSelection.onItemClick($scope.nodesGraph.nodes[id])})})}$rootScope.$emit("drawGraph")};$scope.processLoadFlowResponse=function processLoadFlowResponse(resp,zoomTo,graphReloaded,resetZoom,errorScope=$scope){Assert.trueish(resp,"Received empty response");if(resp.serializedFilteredGraph){$scope.processSerializedFilteredGraphResponse(resp.serializedFilteredGraph,zoomTo,errorScope)}if(resetZoom)$scope.resetPanZoom();$scope.isFlowLoaded=true};$scope.updateGraph=function updateGraph(zoomTo,nospinner=false,shouldUpdateUserInterests=true){DataikuAPI.flow.recipes.getGraph($stateParams.projectKey,true,$scope.drawZones.drawZones,$stateParams.zoneId,$scope.collapsedZones,nospinner).success(function(response){$scope.zonesManualPositioning=response.zonesManualPositioning.projectSettingsValue;$scope.canMoveZones=response.zonesManualPositioning.canMove;$scope.zoneIdLoaded=$stateParams.zoneId;$scope.processLoadFlowResponse(response,zoomTo,true);if(shouldUpdateUserInterests){updateUserInterests()}$scope.isMoveFlowZonesToggleLoading=false;$scope.isSavingZonePosition=false}).error(setErrorInScope.bind($scope))};var storageKey=`dku.flow.drawZones.${$stateParams.projectKey}`;$scope.drawZones={drawZones:!!$stateParams.zoneId||JSON.parse(localStorageService.get(storageKey)||true)};var drawZonesSub=ToolBridgeService.drawZonesToggle$.subscribe(()=>{ToolBridgeService.emitShouldDrawZones(!$scope.drawZones.drawZones)});$scope.$on("$destroy",function(){if(drawZonesSub){drawZonesSub.unsubscribe()}});ToolBridgeService.emitShouldDrawZones($scope.drawZones.drawZones);$scope.redrawZone=function(){if(!$scope.inFlowExport){localStorageService.set(storageKey,$scope.drawZones.drawZones);$scope.resetPanZoom();$scope.updateGraph()}};var collapsedZonesStorageKey=`dku.flow.collapsedZones.${$stateParams.projectKey}`;$scope.cleanupCollapsedZones=(collapsedZones=$scope.collapsedZones)=>{let changed=false;[...collapsedZones].forEach(collapsedZone=>{const zoneFound=FlowGraph.node(`zone_${collapsedZone}`);if(!zoneFound){const index=collapsedZones.indexOf(collapsedZone);if(index!==-1){collapsedZones.splice(index,1);changed=true}}});if(changed){localStorageService.set(collapsedZonesStorageKey,JSON.stringify(collapsedZones))}return collapsedZones};$scope.collapsedZones=localStorageService.get(collapsedZonesStorageKey)||[];$scope.toggleZoneCollapse=(collapseItems,multiItemStrategy)=>{let zoneIds=collapseItems.map(it=>it.id);zoneIds.forEach(function(zoneId){let index=$scope.collapsedZones.findIndex(it=>it===zoneId);if(index>-1&&multiItemStrategy!=="collapseAll"){$scope.collapsedZones.splice(index,1)}else if(index<0&&multiItemStrategy!=="expandAll"){$scope.collapsedZones.push(zoneId)}});localStorageService.set(collapsedZonesStorageKey,JSON.stringify($scope.collapsedZones));$scope.updateGraph()};$scope.updateGraph($stateParams.id);$scope.nodeSelectorTooltip=function(type,count){const params={type:$filter("niceTaggableType")(type,count)};if(count>1){return translate("PROJECT.FLOW.GRAPH.SELECT_ALL_OBJECTS","Select all {{type}}",params)}else{return translate("PROJECT.FLOW.GRAPH.SELECT_AN_OBJECT","Select a {{type}}",params)}};$scope.copyNameToClipboard=function(name){ClipboardUtils.copyToClipboard(name)};$scope.renameDataset=function(datasetNode){DatasetRenameService.startRenaming($scope,datasetNode.projectKey,datasetNode.name,datasetNode.datasetType)};$scope.renameRecipe=function(recipeNode){RecipeRenameService.startRenamingRecipe($scope,recipeNode.projectKey,recipeNode.name)};const buildModalParams=(hasPredecessors,hasSuccessors)=>{return{upstreamBuildable:hasPredecessors,downstreamBuildable:hasSuccessors}};$scope.buildDataset=function(projectKey,name,hasPredecessors,hasSuccessors){FlowBuildService.openSingleComputableBuildModalFromObjectTypeAndLoc($scope,"DATASET",AnyLoc.makeLoc(projectKey,name),buildModalParams(hasPredecessors,hasSuccessors))};$scope.trainModel=function(projectKey,id,hasPredecessors,hasSuccessors){FlowBuildService.openSingleComputableBuildModalFromObjectTypeAndLoc($scope,"SAVED_MODEL",AnyLoc.makeLoc(projectKey,id),buildModalParams(hasPredecessors,hasSuccessors))};$scope.buildManagedFolder=function(projectKey,id,hasPredecessors,hasSuccessors){FlowBuildService.openSingleComputableBuildModalFromObjectTypeAndLoc($scope,"MANAGED_FOLDER",AnyLoc.makeLoc(projectKey,id),buildModalParams(hasPredecessors,hasSuccessors))};$scope.buildModelEvaluationStore=function(projectKey,id,hasPredecessors,hasSuccessors){FlowBuildService.openSingleComputableBuildModalFromObjectTypeAndLoc($scope,"MODEL_EVALUATION_STORE",AnyLoc.makeLoc(projectKey,id),buildModalParams(hasPredecessors,hasSuccessors))};$scope.buildRetrievableKnowledge=function(projectKey,id,hasPredecessors,hasSuccessors){FlowBuildService.openSingleComputableBuildModalFromObjectTypeAndLoc($scope,"RETRIEVABLE_KNOWLEDGE",AnyLoc.makeLoc(projectKey,id),buildModalParams(hasPredecessors,hasSuccessors))};$scope.startCopy=function(){$scope.startTool("COPY",{preselectedNodes:FlowGraphSelection.getSelectedNodes().map(n=>n.id)})};const interestsListener=$rootScope.$on("userInterestsUpdated",updateUserInterests);const TARGET_TYPES_TO_UPDATE={DATASET:"dataset",RETRIEVABLE_KNOWLEDGE:"retrievableknowledge"};function getNodeNameForItem(itemType,itemName){return itemType+"__"+graphVizEscape(itemName)}function updateNodeStatus(node,state){if(!node)return false;switch(state){case FLOW_NODE_STATUS.RUNNING:node.beingBuilt=true;node.aboutToBeBuilt=false;break;case FLOW_NODE_STATUS.DONE:node.beingBuilt=false;node.aboutToBeBuilt=false;break;case FLOW_NODE_STATUS.NOT_STARTED:node.aboutToBeBuilt=true;node.beingBuilt=false;break}return true}function updateNodeStatusFlowWithZones(message,state){let refresh=false;if(!message.status)return refresh;const selector=message.status.targets.filter(target=>target.type in TARGET_TYPES_TO_UPDATE).map(target=>{const realId=getNodeNameForItem(TARGET_TYPES_TO_UPDATE[target.type],target.id);return`svg [data-node-id="${realId}"]`}).join(", ");if(selector){d3.selectAll(selector).each(function(){const id=this.getAttribute("data-id");if(updateNodeStatus(FlowGraph.node(id),state)){refresh=true}})}return refresh}function updateNodeStatusFlowWithoutZones(message,state){let refresh=false;if(!message.status)return refresh;Object.values(message.status.targets).filter(target=>target.type in TARGET_TYPES_TO_UPDATE).forEach(target=>{const realId=getNodeNameForItem(TARGET_TYPES_TO_UPDATE[target.type],target.id);if(updateNodeStatus($scope.nodesGraph.nodes[realId],state)){refresh=true}});return refresh}function updateAndDrawActivityNodeStatus(message,state){let refreshGraph;if($scope.nodesGraph.hasProjectZones&&$scope.drawZones.drawZones){refreshGraph=updateNodeStatusFlowWithZones(message,state)}else{refreshGraph=updateNodeStatusFlowWithoutZones(message,state)}if(refreshGraph){drawBuildInProgressIndicators(FlowGraph.getSvg(),$scope.nodesGraph)}}const jobActivityStartedListener=Notification.registerEvent("job-activity-started",function(evt,message){updateAndDrawActivityNodeStatus(message,FLOW_NODE_STATUS.RUNNING)});const jobActivityDoneListener=Notification.registerEvent("job-activity-done",function(evt,message){updateAndDrawActivityNodeStatus(message,FLOW_NODE_STATUS.DONE)});const jobStatusUpdatedListener=Notification.registerEvent("job-status-updated-light",function(evt,message){let refreshGraph=false;function updateAllNodeStatusFlowWithZones(){let targets=[];Object.values(message.status.activities).forEach(activity=>{if(activity.state==="NOT_STARTED"&&!activity.skipExplicitOrWriteProtected){activity.targets.forEach(target=>{if(target.type in TARGET_TYPES_TO_UPDATE){const realId=getNodeNameForItem(TARGET_TYPES_TO_UPDATE[target.type],target.id);targets.push(`svg [data-node-id="${realId}"]`)}})}});const selector=targets.join(", ");if(selector){d3.selectAll(selector).each(function(){const id=this.getAttribute("data-id");if(updateNodeStatus(FlowGraph.node(id),FLOW_NODE_STATUS.NOT_STARTED)){refreshGraph=true}})}}function updateAllNodeStatusFlowWithoutZones(){if(!message.status||!message.status.activities)return;Object.values(message.status.activities).forEach(activity=>{if(activity.state==="NOT_STARTED"&&!activity.skipExplicitOrWriteProtected){activity.targets.forEach(target=>{if(target.type in TARGET_TYPES_TO_UPDATE){const realId=getNodeNameForItem(TARGET_TYPES_TO_UPDATE[target.type],target.id);if($scope.nodesGraph.nodes&&updateNodeStatus($scope.nodesGraph.nodes[realId],FLOW_NODE_STATUS.NOT_STARTED)){refreshGraph=true}}})}})}if($scope.nodesGraph.hasProjectZones&&$scope.drawZones.drawZones){updateAllNodeStatusFlowWithZones()}else{updateAllNodeStatusFlowWithoutZones()}if(refreshGraph){drawBuildInProgressIndicators(FlowGraph.getSvg(),$scope.nodesGraph)}});let continuousActivityStateChangeListener=Notification.registerEvent("continuous-activity-state-change",function(evt,message){let refreshGraph=false;function isRunning(message){if(message.state=="STOPPED")return false;if(message.state=="STARTED")return true;return undefined}function updateNodeStatus(isRunIcon,node){if(!node)return;if(isRunIcon&&!node.beingBuilt){refreshGraph=true;node.beingBuilt=true;node.continuousActivityDone=false;node.aboutToBeBuilt=false}else if(node.beingBuilt||node.aboutToBeBuilt){refreshGraph=true;node.beingBuilt=false;node.continuousActivityDone=false;node.aboutToBeBuilt=false}}let isRun=isRunning(message);if(isRun!==undefined){let nodeName=getNodeNameForItem("recipe",message.continuousActivityId);updateNodeStatus(isRun,$scope.nodesGraph.nodes[nodeName])}if(refreshGraph){drawBuildInProgressIndicators(FlowGraph.getSvg(),$scope.nodesGraph)}});$scope.$on("$destroy",function(){if($scope.svg){$scope.svg.empty();$scope.svg.remove();$scope.svg=null;jobActivityStartedListener();jobActivityDoneListener();jobStatusUpdatedListener()}interestsListener();continuousActivityStateChangeListener()});$scope.unfoldAll=function(){FlowGraphFolding.unfoldAll()};$scope.zoomOnSelection=function(paddingFactor){const selectedNodes=$(".selected",$scope.svg);if(paddingFactor==null){paddingFactor=1.2;if(selectedNodes&&selectedNodes.length===1){if(selectedNodes[0].classList.contains("zone_cluster")){paddingFactor=1.5}else{paddingFactor=3}}}$scope.zoomToBbox(FlowGraphFiltering.getBBoxFromSelector($scope.svg,".selected"),paddingFactor)};$scope.exportFlow=function(){const graphBBox=$scope.svg.find("g.graph")[0].getBBox();CreateModalFromTemplate("/templates/flow-editor/export-flow-modal.html",$scope,"ExportFlowModalController",function(newScope){newScope.init($stateParams.projectKey,graphBBox)})};$scope.generateFlowDocument=function(){CreateModalFromTemplate("templates/flow-editor/generate-flow-document-modal.html",$scope,"GenerateFlowDocumentModalController",function(newScope){newScope.init($stateParams.projectKey)},false,"static")};$scope.exportToolbox={checkLoading:function(){return $scope.httpRequests.length!==0||!$scope.isFlowLoaded||ToolBridgeService.isQueryLoading()||ToolBridgeService.isViewLoading()},removeDecorations:function(drawZones){executeWithInstantDigest(function(){$scope.hideForExport=true;$scope.fullScreen=true;$scope.inFlowExport=true},$scope)},getGraphBoundaries:function(){const graphBBox=$scope.svg.find("g.graph")[0].getBBox();return{x:graphBBox.x,y:graphBBox.y,width:graphBBox.width,height:graphBBox.height}},adjustViewBox:function(x,y,width,height){$scope.svg[0].setAttribute("viewBox",[x,y,width,height].join(", "))},configureZones:function(drawZones,collpasedZones){$scope.drawZones.drawZones=drawZones;$scope.collapsedZones=collpasedZones;$scope.isFlowLoaded=false;$scope.updateGraph()}};$scope.explainProject=function(){CreateModalFromTemplate("/static/dataiku/ai-explanations/explanation-modal/explanation-modal.html",$scope,"AIExplanationModalController",function(newScope){newScope.objectType="PROJECT";newScope.object=$scope.projectSummary;newScope.mode=AI_EXPLANATION_MODAL_MODES.EXPLAIN})};$scope.zoomOnZone=ZoneService.zoomOnZone;$scope.zoomOutOfZone=ZoneService.zoomOutOfZone;const hasPreviewKey=`dku.flow.hasPreview`;$scope.hasPreview=JSON.parse(localStorageService.get(hasPreviewKey))||false;$scope.togglePreview=()=>{$scope.hasPreview=!$scope.hasPreview;localStorageService.set(hasPreviewKey,$scope.hasPreview)};$scope.isMoveFlowZonesToggleLoading=false;$scope.toggleZonesManualPositioning=()=>{const projectSummary=$rootScope.projectSummary;$scope.isMoveFlowZonesToggleLoading=true;DataikuAPI.flow.zones.setManualPositioningSetting(projectSummary.projectKey,!projectSummary.zonesManualPositioning).then(()=>{projectSummary.zonesManualPositioning=!projectSummary.zonesManualPositioning;WT1.tryEvent("flow-toggle-zones-manual-positioning",()=>({enabled:projectSummary.zonesManualPositioning}));$scope.$emit("zonesManualPositioningChanged")}).catch(function(data,status,headers){$scope.isMoveFlowZonesToggleLoading=false;setErrorInScope.bind($scope)(data,status,headers)})};$scope.autoArrangeFlowZones=()=>{Dialogs.confirmAlert($scope,translate("PROJECT.FLOW.AUTO_ARRANGE_FLOW_ZONES.TITLE","Auto-arrange flow zones"),translate("PROJECT.FLOW.AUTO_ARRANGE_FLOW_ZONES.TEXT","Are you sure you want to continue?"),translate("PROJECT.FLOW.AUTO_ARRANGE_FLOW_ZONES.ALERT","This will reset all flow zones positions for this project"),"WARNING").then(function(){$scope.isSavingZonePosition=true;WT1.tryEvent("flow-auto-arrange-zones",()=>{});const projectSummary=$rootScope.projectSummary;DataikuAPI.flow.zones.resetPositions(projectSummary.projectKey).then(()=>$scope.$emit("zonesManualPositioningChanged")).catch(function(data,status,headers){$scope.isSavingZonePosition=false;setErrorInScope.bind($scope)(data,status,headers)})},function(){})};const checkIsFlowActionTool=function(){const tool=FlowTool.getCurrent();return tool&&tool.action};$scope.onFlowColor=flowColoring=>{$scope.flowColoring=flowColoring;if(checkIsFlowActionTool()){ToolBridgeService.queryLoaded();return}if(flowColoring===undefined){resetDefaultGraphColor();ToolBridgeService.queryLoaded();return}colorFlowNodes(flowColoring.coloring,flowColoring.matchedObjectsId);ToolBridgeService.queryLoaded()};$scope.onSuggestionFocus=flowItemColoring=>{if(checkIsFlowActionTool()){return}if(flowItemColoring===undefined){if($scope.flowColoring===undefined){return}colorFlowNodes($scope.flowColoring.coloring,$scope.flowColoring.matchedObjectsId);return}colorFlowNodes(flowItemColoring.coloring,flowItemColoring.matchedObjectsId)};$scope.onObjectSelect=function(objects){if(objects.length===0){FlowGraphSelection.clearSelection();return}FlowGraphSelection.clearSelection();FlowGraphSelection.selectMulti(objects);if(objects.length===1){const objectsByType=$scope.nodesGraph.includedObjectsByType;const hasOnlyFlowZone=objectsByType&&Object.keys(objectsByType).length===1&&objectsByType.hasOwnProperty("FLOW_ZONE");if(hasOnlyFlowZone){$scope.zoomGraph(objects[0].id,3,null,300)}else{$scope.zoomGraph(objects[0].id,3,null,-65)}}else{$scope.zoomOnSelection()}};let flowViewsSubscriptions=[];flowViewsSubscriptions.push(SummaryService.selectedObjects$.subscribe(obj=>{if(obj&&obj.length===0){FlowGraphSelection.clearSelection();return}FlowGraphSelection.clearSelection();FlowGraphSelection.selectMulti(obj)}));flowViewsSubscriptions.push(SummaryService.zoomOnSelection$.subscribe(paddingFactor=>{$scope.zoomOnSelection(paddingFactor)}));const flowDisplayUpdatedUnsubscribe=$rootScope.$on("flowDisplayUpdated",function(_,shouldResetDefault){if(checkIsFlowActionTool()){return}if($scope.flowColoring){colorFlowNodes($scope.flowColoring.coloring,$scope.flowColoring.matchedObjectsId)}else if(shouldResetDefault){resetDefaultGraphColor()}});$scope.$on("$destroy",function(){if(flowViewsSubscriptions){flowViewsSubscriptions.forEach(subs=>subs.unsubscribe())}flowDisplayUpdatedUnsubscribe()});function colorFlowNodes(coloring,matchedObjectsId){const graphSvg=FlowGraph.getSvg();if(!graphSvg)return;for(const nodeId of Object.keys($scope.nodesGraph.nodes)){const d3NodeElement=getD3Node(nodeId);if(d3NodeElement==null){continue}resetNodeStyle(nodeId,d3NodeElement);if(!matchedObjectsId.has(nodeId)){d3NodeElement.classed("filter-remove",true)}if(coloring){let color=coloring.get(nodeId);if(color!=null){colorNode($scope.nodesGraph.nodes[nodeId],d3NodeElement,color);d3NodeElement.classed("focus",true)}else{d3NodeElement.classed("filter-remove",true)}}}}function resetNodeStyle(nodeId,d3node){colorNode($scope.nodesGraph.nodes[nodeId],d3node,undefined);d3node.classed("focus",false).classed("filter-remove",false)}function resetDefaultGraphColor(){for(const nodeId of Object.keys($scope.nodesGraph.nodes)){const d3NodeElement=getD3Node(nodeId);if(d3NodeElement==null){continue}resetNodeStyle(nodeId,d3NodeElement)}}function colorNode(node,d3NodeElement,color){if(node.nodeType==="ZONE")return;FlowToolsUtils.colorNode(node,d3NodeElement,color)}function getD3Node(nodeId){const node=FlowGraph.node(nodeId);const d3Node=FlowGraph.d3NodeWithIdFromType(nodeId,node.nodeType);return d3Node}const unregisterFlowTourListener=$rootScope.$on("startFlowTour",function(){PageSpecificTourService.startFlowTour({scope:$scope,fromContext:"opals"})});$scope.$on("$destroy",function(){unregisterFlowTourListener()})},link:function(scope,element){function getLastItemInHistory(projectKey,zoneId){const items=HistoryService.getRecentlyViewedItems();const validItems=items.filter(it=>it.type!=="PROJECT"&&it.projectKey===projectKey);if(items&&items.length){if(!zoneId){return validItems[0]}const zoneName=graphVizEscape(`zone_${zoneId}`);const zoneContent=Object.keys(scope.nodesGraph.nodes).filter(it=>it.startsWith(zoneName)).map(it=>scope.nodesGraph.nodes[it]);return validItems.find(item=>zoneContent.find(it=>it.name===item.id))}return null}function getName(item){if(item.type==="RECIPE"||item.type==="LABELING_TASK"){return item.type.toLowerCase()+graphVizEscape(`_${item.id}`)}return item.type.toLowerCase().replace("_","")+graphVizEscape(`_${item.projectKey}.${item.id}`)}function zoomOnLast(){if(!scope.nodesGraph||!scope.nodesGraph.nodes){return}const itemFound=getLastItemInHistory($stateParams.projectKey,$stateParams.zoneId);if(itemFound){const id=GraphZoomTrackerService.getZoomedName(FlowGraph,getName(itemFound));Logger.info("zooming on "+id+"--\x3e ",scope.nodesGraph.nodes[id]);scope.zoomGraph(id);FlowGraphSelection.onItemClick(scope.nodesGraph.nodes[id]);scope.$apply()}}const lastUsedZoneKey=`dku.flow.lastUsedZone.${$stateParams.projectKey}`;scope.moveToFlowZone=(movingItems,forceCreation=false,computedImpact=[])=>{scope.movingItems=movingItems;scope.computedImpact=computedImpact;CreateModalFromTemplate("/templates/flow-editor/move-to-zone.html",scope,null,newScope=>{newScope.uiState={creationMode:forceCreation?"CREATE":"SELECT",forceCreation:forceCreation};newScope.onClick=()=>{let movingTo=newScope.uiState.selectedZone;let promise=null;movingItems=movingItems.concat(scope.computedImpact);if(newScope.uiState.creationMode==="CREATE"){promise=DataikuAPI.flow.zones.create($stateParams.projectKey,newScope.uiState.name,newScope.uiState.color).success(zoneCreated=>{movingTo=zoneCreated.id;$rootScope.$emit("zonesListChanged")}).error($q.reject)}else{promise=$q.resolve()}if(movingItems.length>0){promise=promise.then(()=>DataikuAPI.flow.zones.moveItems($stateParams.projectKey,movingTo,movingItems).error($q.reject))}promise.then(()=>{localStorageService.set(lastUsedZoneKey,movingTo);GraphZoomTrackerService.setFocusItemCtx({id:`zone_${movingTo}`},true);newScope.$emit("reloadGraph");newScope.dismiss()},setErrorInScope.bind(newScope))}})};scope.shareToFlowZone=(sharingItems,forceCreation=false)=>{CreateModalFromTemplate("/templates/flow-editor/share-to-zone.html",scope,null,newScope=>{newScope.uiState={creationMode:forceCreation?"CREATE":"SELECT",forceCreation:forceCreation};newScope.onClick=()=>{let sharedTo=newScope.uiState.selectedZone;let promise=null;if(newScope.uiState.creationMode==="CREATE"){promise=DataikuAPI.flow.zones.create($stateParams.projectKey,newScope.uiState.name,newScope.uiState.color).success(zoneCreated=>{sharedTo=zoneCreated.id;$rootScope.$emit("zonesListChanged")}).error($q.reject)}else{promise=$q.resolve()}if(sharingItems.length>0){promise=promise.then(()=>DataikuAPI.flow.zones.shareItems($stateParams.projectKey,sharedTo,sharingItems).error($q.reject))}promise.then(()=>{localStorageService.set(lastUsedZoneKey,sharedTo);newScope.$emit("reloadGraph");newScope.dismiss()},setErrorInScope.bind(newScope))}})};scope.unshareToFlowZone=(sharingItems,zoneIds)=>{if(sharingItems.length>0){DataikuAPI.flow.zones.unshareItems($stateParams.projectKey,zoneIds,sharingItems).success(scope.$emit("reloadGraph"))}};scope.onItemDblClick=function(item,evt){let destUrl=StateUtils.href.node(item);fakeClickOnLink(destUrl,evt)};scope.onContextualMenu=function(item,evt){let $itemEl=$(evt.target).parents("g[data-type]").first();if($itemEl.length>0){let x=evt.pageX;let y=evt.pageY;let ctxMenuScope=scope.$new();const selectedNodes=FlowGraphSelection.getSelectedNodes();let type=selectedNodes.length>1?"MULTI":item.nodeType;let controller={LOCAL_DATASET:"DatasetContextualMenuController",FOREIGN_DATASET:"ForeignDatasetContextualMenuController",LOCAL_STREAMING_ENDPOINT:"StreamingEndpointContextualMenuController",RECIPE:"RecipeContextualMenuController",LABELING_TASK:"LabelingTaskContextualMenuController",LOCAL_SAVEDMODEL:"SavedModelContextualMenuController",FOREIGN_SAVEDMODEL:"SavedModelContextualMenuController",LOCAL_MODELEVALUATIONSTORE:"ModelEvaluationStoreContextualMenuController",FOREIGN_MODELEVALUATIONSTORE:"ModelEvaluationStoreContextualMenuController",LOCAL_GENAIEVALUATIONSTORE:"ModelEvaluationStoreContextualMenuController",FOREIGN_GENAIEVALUATIONSTORE:"ModelEvaluationStoreContextualMenuController",LOCAL_MANAGED_FOLDER:"ManagedFolderContextualMenuController",FOREIGN_MANAGED_FOLDER:"ManagedFolderContextualMenuController",LOCAL_RETRIEVABLE_KNOWLEDGE:"KnowledgeBankContextualMenuController",FOREIGN_RETRIEVABLE_KNOWLEDGE:"KnowledgeBankContextualMenuController",ZONE:"ZoneContextualMenuController",MULTI:"MultiContextualMenuController"}[type];let template="/templates/flow-editor/"+{LOCAL_DATASET:"dataset-contextual-menu.html",FOREIGN_DATASET:"foreign-dataset-contextual-menu.html",LOCAL_STREAMING_ENDPOINT:"streaming-endpoint-contextual-menu.html",RECIPE:"recipe-contextual-menu.html",LABELING_TASK:"labeling-task-contextual-menu.html",LOCAL_SAVEDMODEL:"savedmodel-contextual-menu.html",FOREIGN_SAVEDMODEL:"savedmodel-contextual-menu.html",LOCAL_MODELEVALUATIONSTORE:"modelevaluationstore-contextual-menu.html",FOREIGN_MODELEVALUATIONSTORE:"modelevaluationstore-contextual-menu.html",LOCAL_GENAIEVALUATIONSTORE:"modelevaluationstore-contextual-menu.html",FOREIGN_GENAIEVALUATIONSTORE:"modelevaluationstore-contextual-menu.html",LOCAL_MANAGED_FOLDER:"managed-folder-contextual-menu.html",FOREIGN_MANAGED_FOLDER:"managed-folder-contextual-menu.html",LOCAL_RETRIEVABLE_KNOWLEDGE:"knowledge-bank-contextual-menu.html",FOREIGN_RETRIEVABLE_KNOWLEDGE:"knowledge-bank-contextual-menu.html",ZONE:"zone-contextual-menu.html",MULTI:"multi-contextual-menu.html"}[type];ctxMenuScope.object=item;ctxMenuScope.hasZone=[...selectedNodes,item].find(it=>it.nodeType==="ZONE")!==undefined;let menu=new ContextualMenu({template:template,scope:ctxMenuScope,contextual:true,controller:controller});menu.openAtXY(x,y);return false}else{ContextualMenu.prototype.closeAny();return true}};FlowGraphSelection.clearSelection();scope.flowViews=FlowToolsRegistry.getFlowViews();const togglePreviewShortcut="shift+p";Mousetrap.bind("z",zoomOnLast);Mousetrap.bind("left",scope.moveLeft);Mousetrap.bind("right",scope.moveRight);Mousetrap.bind("up",scope.moveUp);Mousetrap.bind("down",scope.moveDown);Mousetrap.bind("-",scope.zoomOut);Mousetrap.bind("+",scope.zoomIn);Mousetrap.bind("=",scope.zoomIn);Mousetrap.bind("shift+p",()=>{$timeout(scope.togglePreview)});Mousetrap.bind("mod+f",()=>{ToolBridgeService.emitOmniboxFocus();return false});Mousetrap.bind("mod+z",()=>{ToolBridgeService.emitOmniboxUndo();return false});Mousetrap.bind("mod+shift+z",()=>{ToolBridgeService.emitOmniboxRedo();return false});const updateGraphDebounced=Debounce().withDelay(200,200).wrap(scope.updateGraph);const updateGraphDebouncedShort=Debounce().withDelay(0,0).withSpinner(false).wrap(scope.updateGraph);const deregister1=$rootScope.$on("datasetsListChangedFromModal",updateGraphDebounced);const deregister2=$rootScope.$on("taggableObjectTagsChanged",updateGraphDebounced);const deregister3=$rootScope.$on("flowItemAddedOrRemoved",updateGraphDebounced);const deregister4=$rootScope.$on("reloadGraph",(event,{zoomTo}={})=>updateGraphDebounced(zoomTo));const deregister5=$rootScope.$on("objectMetaDataChanged",updateGraphDebounced);const deregister6=$rootScope.$on("discussionCountChanged",updateGraphDebounced);const deregister8=$rootScope.$on("featureGroupStatusChanged",updateGraphDebounced);const deregister9=$rootScope.$on("zonesManualPositioningChanged",(event,{zoomTo}={})=>updateGraphDebouncedShort(zoomTo,true,false));scope.$on("$destroy",function(){Mousetrap.unbind("z");Mousetrap.unbind("left");Mousetrap.unbind("right");Mousetrap.unbind("up");Mousetrap.unbind("down");Mousetrap.unbind("-");Mousetrap.unbind("+");Mousetrap.unbind("=");Mousetrap.unbind(togglePreviewShortcut);Mousetrap.unbind("mod+f");Mousetrap.unbind("mod+z");Mousetrap.unbind("mod+shift+z");deregister1();deregister2();deregister3();deregister4();deregister5();deregister6();deregister8();deregister9()});scope.$on("graphRendered",function graphRendered(){drawBuildInProgressIndicators(scope.svg,scope.nodesGraph);drawExposedIndicators(scope.svg,scope.nodesGraph);drawForbiddenIndicators(scope.svg,scope.nodesGraph);if(scope.nodesGraph){WT1.tryEvent("project-flow-rendered",()=>{let payload={hasZones:scope.nodesGraph.hasZones,isFlowEmpty:scope.isFlowEmpty,zonesManualPositioning:scope.zonesManualPositioning,canMoveZones:scope.canMoveZones,count_nodes:scope.nodesGraph.nodesOnGraphCount};if(scope.nodesGraph.includedObjectsByType){for(const[typeName,countForType]of Object.entries(scope.nodesGraph.includedObjectsByType)){payload[typeName.toLowerCase()]=countForType}}return payload});if(PageSpecificTourService.canStartFlowTour()){PageSpecificTourService.startFlowTour({scope:scope,fromContext:"flow"});OpalsService.sendPageSpecificTourRecommendation(OpalsMessageService.PAGE_SPECIFIC_TOURS_RECOMMENDATIONS.FLOW)}else{OpalsService.sendPageSpecificTourRecommendation(null)}}});scope.$on("indexNodesDone",function indexNodesDone(){scope.cleanupCollapsedZones()})}}});app.directive("lineageFlowExport",function(){return{restrict:"EA",scope:true,controller:function($scope){$scope.exportToolbox={checkLoading:function(){return!$scope.svg},removeDecorations:function(){},getGraphBoundaries:function(){const graphBBox=$scope.svg.querySelector("g.graph").getBBox();return{x:graphBBox.x,y:graphBBox.y,width:graphBBox.width,height:graphBBox.height}},adjustViewBox:function(x,y,width,height){$scope.svg.setAttribute("viewBox",[x,y,width,height].join(", "))},configureZones:function(){}}},link:function(){}}});app.directive("flowExportForm",function(GRAPHIC_EXPORT_OPTIONS,WT1,GraphicImportService){return{replace:false,require:"^form",restrict:"EA",scope:{params:"=",graphBoundaries:"="},templateUrl:"/templates/flow-editor/export-flow-form.html",link:function($scope,element,attrs,formCtrl){WT1.event("flow-export-form-displayed",{});$scope.exportFormController=formCtrl;$scope.paperSizeMap=GRAPHIC_EXPORT_OPTIONS.paperSizeMap;$scope.orientationMap=GRAPHIC_EXPORT_OPTIONS.orientationMap;$scope.ratioMap=GRAPHIC_EXPORT_OPTIONS.ratioMap;$scope.paperInchesMap=GRAPHIC_EXPORT_OPTIONS.paperInchesMap;$scope.fileTypes=GRAPHIC_EXPORT_OPTIONS.fileTypes;$scope.tileScaleModes=GRAPHIC_EXPORT_OPTIONS.tileScaleModes;$scope.minResW=500;$scope.minResH=500;$scope.maxResW=1e4;$scope.maxResH=1e4;$scope.maxDpi=300;let computeTileScale=function(tileScaleProps){if(!tileScaleProps.enabled||tileScaleProps.percentage===undefined){return 1}else{return Math.max(1,tileScaleProps.percentage/100)}};let computeBestTileScale=function(width,height){const targetFactor=1;const xFactor=$scope.graphBoundaries.width/width;const yFactor=$scope.graphBoundaries.height/height;return Math.max(1,Math.ceil(Math.max(xFactor,yFactor)/targetFactor))};let capWidth=function(width){return Math.min($scope.maxResW,Math.max($scope.minResW,width))};let capHeight=function(height){return Math.min($scope.maxResH,Math.max($scope.minResH,height))};let computeTileScaleSheets=function(width,height,tileScale){if(width===undefined||height===undefined||tileScale==undefined){return{x:0,y:0,count:0}}const sheetRatio=width/height;const graphRatio=$scope.graphBoundaries.width/$scope.graphBoundaries.height;let graphSheetWidth;let graphSheetHeight;if(sheetRatio<graphRatio){graphSheetWidth=$scope.graphBoundaries.width/tileScale;graphSheetHeight=graphSheetWidth/sheetRatio}else{graphSheetHeight=$scope.graphBoundaries.height/tileScale;graphSheetWidth=graphSheetHeight*sheetRatio}const x=Math.max(1,Math.ceil($scope.graphBoundaries.width/graphSheetWidth));const y=Math.max(1,Math.ceil($scope.graphBoundaries.height/graphSheetHeight));const count=x*y;return{x:x,y:y,count:count}};let setBestDimensions=function(authorizeTileScaling=true){let exportFormat=$scope.params.exportFormat;let width,height;const sheetRatio=exportFormat.orientation=="LANDSCAPE"?$scope.ratioMap[exportFormat.paperSize]:1/$scope.ratioMap[exportFormat.paperSize];const graphRatio=$scope.graphBoundaries.width/$scope.graphBoundaries.height;if(sheetRatio<graphRatio){width=$scope.graphBoundaries.width;height=width/sheetRatio}else{height=$scope.graphBoundaries.height;width=height*sheetRatio}let tileScale=1;let dpi=Math.max(width,height)/$scope.paperInchesMap[exportFormat.paperSize];if(authorizeTileScaling&&dpi>$scope.maxDpi){width=width*$scope.maxDpi/dpi;height=height*$scope.maxDpi/dpi;tileScale=computeBestTileScale(width,height)}exportFormat.width=capWidth(Math.round(width));exportFormat.height=capHeight(Math.round(height));exportFormat.tileScale=tileScale};$scope.params.exportFormat={paperSize:"A4",orientation:"LANDSCAPE",fileType:"PDF",width:1920,height:1358,tileScale:1};let exportFormat=$scope.params.exportFormat;let savedFileType=localStorage.getItem("dku.flow.export.fileType");if(savedFileType&&$scope.fileTypes.indexOf(savedFileType)>=0){exportFormat.fileType=savedFileType}let savedPaperSize=localStorage.getItem("dku.flow.export.paperSize");if(savedPaperSize&&$scope.paperSizeMap[savedPaperSize]){exportFormat.paperSize=savedPaperSize}if(savedPaperSize=="CUSTOM"){let savedWidth=localStorage.getItem("dku.flow.export.width");if(savedWidth&&!isNaN(Number(savedWidth))){exportFormat.width=capWidth(Number(savedWidth))}let savedHeight=localStorage.getItem("dku.flow.export.height");if(savedHeight&&!isNaN(Number(savedHeight))){exportFormat.height=capHeight(Number(savedHeight))}}else{let savedOrientation=localStorage.getItem("dku.flow.export.orientation");if(savedOrientation&&$scope.orientationMap[savedOrientation]){exportFormat.orientation=savedOrientation}}if(exportFormat.paperSize!="CUSTOM"){setBestDimensions()}$scope.tileScale={};$scope.tileScale.enabled=exportFormat.tileScale>1;$scope.tileScale.percentage=exportFormat.tileScale*100;$scope.tileScale.sheets=computeTileScaleSheets(exportFormat.width,exportFormat.height,exportFormat.tileScale);let onUpdatePaperSizeOrOrientation=function(){setBestDimensions();let exportFormat=$scope.params.exportFormat;$scope.tileScale.enabled=exportFormat.tileScale>1;$scope.tileScale.percentage=exportFormat.tileScale*100;$scope.tileScale.sheets=computeTileScaleSheets(exportFormat.width,exportFormat.height,exportFormat.tileScale)};$scope.$watch("params.exportFormat.paperSize",function(newVal,oldVal){if(newVal!==oldVal&&newVal!="CUSTOM"){onUpdatePaperSizeOrOrientation()}});$scope.$watch("params.exportFormat.orientation",function(newVal,oldVal){if(newVal!==oldVal){onUpdatePaperSizeOrOrientation()}});$scope.$watch("params.exportFormat.width",function(newVal,oldVal){if(newVal!==oldVal){let exportFormat=$scope.params.exportFormat;$scope.tileScale.sheets=computeTileScaleSheets(exportFormat.width,exportFormat.height,exportFormat.tileScale)}});$scope.$watch("params.exportFormat.height",function(newVal,oldVal){if(newVal!==oldVal){let exportFormat=$scope.params.exportFormat;$scope.tileScale.sheets=computeTileScaleSheets(exportFormat.width,exportFormat.height,exportFormat.tileScale)}});$scope.$watch("tileScale.enabled",function(newVal,oldVal){if(newVal!==oldVal){let exportFormat=$scope.params.exportFormat;if(newVal==true){if(exportFormat.paperSize!="CUSTOM"){let dpi=Math.max(exportFormat.width,exportFormat.height)/GRAPHIC_EXPORT_OPTIONS.paperInchesMap[exportFormat.paperSize];if(dpi>$scope.maxDpi){exportFormat.width=capWidth(Math.round(exportFormat.width*$scope.maxDpi/dpi));exportFormat.height=capHeight(Math.round(exportFormat.height*$scope.maxDpi/dpi))}}$scope.tileScale.percentage=computeBestTileScale(exportFormat.width,exportFormat.height)*100;exportFormat.tileScale=computeTileScale($scope.tileScale)}else{if(exportFormat.paperSize!="CUSTOM"){setBestDimensions(false)}else{exportFormat.tileScale=1}}}});$scope.$watch("tileScale.percentage",function(newVal,oldVal){if(newVal!==oldVal){let exportFormat=$scope.params.exportFormat;exportFormat.tileScale=computeTileScale($scope.tileScale);$scope.tileScale.sheets=computeTileScaleSheets(exportFormat.width,exportFormat.height,exportFormat.tileScale)}})}}});app.controller("ExportFlowModalController",function($scope,$stateParams,$rootScope,DataikuAPI,ActivityIndicator,FutureProgressModal,WT1,ViewsLocalStorage){$scope.init=function(projectKey,graphBoundaries){$scope.params={};$scope.modalTitle="Export Flow graph";$scope.projectKey=projectKey;$scope.graphBoundaries=graphBoundaries};$scope.doExportFlow=function(){WT1.event("flow-exported",{});let exportFormat=JSON.parse(JSON.stringify($scope.params.exportFormat));exportFormat.drawZones=$scope.drawZones.drawZones;exportFormat.collapsedZones=$scope.collapsedZones;const currentSearchQuery=ViewsLocalStorage.getQueryForProject($rootScope.appConfig.login,$stateParams.projectKey);if(currentSearchQuery&&currentSearchQuery.trim().length!==0){exportFormat.searchQuery=currentSearchQuery}localStorage.setItem("dku.flow.export.fileType",exportFormat.fileType);localStorage.setItem("dku.flow.export.paperSize",exportFormat.paperSize);if(exportFormat.paperSize==="CUSTOM"){localStorage.setItem("dku.flow.export.width",exportFormat.width);localStorage.setItem("dku.flow.export.height",exportFormat.height)}else{localStorage.setItem("dku.flow.export.orientation",exportFormat.orientation)}if(exportFormat.fileType==="PDF"){exportFormat.tileScale=1}DataikuAPI.flow.export($scope.projectKey,exportFormat).error(setErrorInScope.bind($scope)).success(function(resp){FutureProgressModal.show($scope,resp,"Export Flow graph").then(function(result){if(result){downloadURL(DataikuAPI.flow.getExportURL(result.projectKey,result.exportId));ActivityIndicator.success("Flow graph export downloaded!",5e3)}else{ActivityIndicator.error("Export Flow failed",5e3)}$scope.resolveModal()})})}});app.controller("ExportDataLineageModalController",function($scope,DataikuAPI,ActivityIndicator,FutureProgressModal,WT1){$scope.init=function(projectKey,graphBoundaries,datasetName,columnName){$scope.params={};$scope.modalTitle="Export Lineage graph";$scope.exportButtonText="Export";$scope.graphBoundaries=graphBoundaries;$scope.datasetName=datasetName;$scope.columnName=columnName;$scope.projectKey=projectKey};$scope.doExportFlow=function(){WT1.tryEvent("data-lineage-flow-exported",()=>({}));let exportFormat=JSON.parse(JSON.stringify($scope.params.exportFormat));localStorage.setItem("dku.datalineage.export.fileType",exportFormat.fileType);localStorage.setItem("dku.datalineage.export.paperSize",exportFormat.paperSize);if(exportFormat.paperSize==="CUSTOM"){localStorage.setItem("dku.datalineage.export.width",exportFormat.width);localStorage.setItem("dku.datalineage.export.height",exportFormat.height)}else{localStorage.setItem("dku.datalineage.export.orientation",exportFormat.orientation)}if(exportFormat.fileType==="PDF"){exportFormat.tileScale=1}DataikuAPI.datalineage.export($scope.projectKey,$scope.datasetName,$scope.columnName,exportFormat).error(setErrorInScope.bind($scope)).success(function(resp){FutureProgressModal.show($scope,resp,"Export Data Lineage graph").then(function(result){if(result){downloadURL(DataikuAPI.datalineage.getExportURL(result.projectKey,result.exportId));ActivityIndicator.success("Data Lineage graph export downloaded!",5e3)}else{ActivityIndicator.error("Export Data Lineage failed",5e3)}$scope.resolveModal()})})}});app.controller("GenerateFlowDocumentModalController",function($scope,DataikuAPI,WT1,FutureWatcher,ProgressStackMessageBuilder){$scope.init=function(projectKey){$scope.projectKey=projectKey;$scope.template={type:"DEFAULT"};$scope.newTemplate={};$scope.state="WAITING"};$scope.export=function(){if($scope.template.type=="DEFAULT"){WT1.event("render-flow-documentation",{type:"default"});DataikuAPI.flow.docGenDefault($scope.projectKey).success(watchFuture).error(setErrorInScope.bind($scope))}else{WT1.event("render-flow-documentation",{type:"custom"});DataikuAPI.flow.docGenCustom($scope.newTemplate.file,$scope.projectKey,e=>{}).then(watchFuture).catch(error=>{setErrorInScope2.call($scope,error)})}function watchFuture(initialResponse){$scope.initialResponse=angular.fromJson(initialResponse);$scope.data=undefined;$scope.state="LOADING";FutureWatcher.watchJobId($scope.initialResponse.jobId).success(function(response){let exportId=response.result.exportId;$scope.data=response.result.data;$scope.state="READY";$scope.text="The flow documentation is ready.";$scope.errorOccurred=false;if($scope.data.maxSeverity==="WARNING"){$scope.text+=" Be aware that the placeholders which couldn't be resolved are not shown in the flow documentation."}else if($scope.data.maxSeverity==="ERROR"){$scope.text="";$scope.errorOccurred=true}if(!$scope.errorOccurred){$scope.flowDocumentationURL=DataikuAPI.flow.getFlowDocumentationExportURL(exportId)}}).update(function(response){$scope.futureResponse=response;$scope.percentage=ProgressStackMessageBuilder.getPercentage(response.progress);$scope.stateLabels=ProgressStackMessageBuilder.build(response.progress,true)}).error(function(response,status,headers){setErrorInScope.bind($scope)(response,status,headers)})}};$scope.download=function(){downloadURL($scope.flowDocumentationURL);WT1.event("download-flow-documentation");$scope.state="DOWNLOADED"};$scope.abort=function(){DataikuAPI.futures.abort($scope.initialResponse.jobId).error(setErrorInScope.bind($scope));$scope.dismiss();WT1.event("abort-flow-documentation-rendering")}});app.directive("facetFilterableList",function($filter){return{scope:{items:"=",model:"=facetFilterableList",showAllItems:"=?",orderBy:"@"},transclude:true,link:function(scope,element,attr){if(attr.filterFunction){scope.filterFunction=scope.$parent.$eval(attr.filterFunction)}else{scope.filterFunction=$filter("filter")}scope.model=scope.model||[];scope.onFacetSearchKeyDown=function(e){if(e.keyCode===27){e.target.blur();angular.element(e.target).scope().$parent.showInput=false;angular.element(e.target).scope().$parent.facetValueSearch=""}}},templateUrl:"/templates/flow-editor/facet-filterable-list.html"}});app.directive("multiItemsRightColumnSummary",function($controller,$rootScope,$stateParams,DataikuAPI,Fn,TaggableObjectsUtils,RecipeDescService,CodeEnvsService,SavedModelsService,FlowGraphSelection,SelectablePluginsService,WatchInterestState,FlowGraph,SubFlowCopyService,WT1,translate,PluginCategoryService){return{templateUrl:"/templates/flow-editor/multi-items-right-column-summary.html",link:function(scope,element,attrs){$controller("_TaggableObjectsMassActions",{$scope:scope});$controller("_TaggableObjectsCapabilities",{$scope:scope});const getType=attrs.singleType?()=>attrs.singleType:item=>item.nodeType;const getSelectedItems=attrs.selectedItems?()=>scope.$eval(attrs.selectedItems):FlowGraphSelection.getSelectedNodes;const newItemsWatch=attrs.selectedItems?()=>scope.$eval(attrs.selectedItems):"rightColumnItem";scope.projectsWithManageExposedElementsPrivilege=null;if(!scope.canWriteProject()){DataikuAPI.projects.listHeads("MANAGE_EXPOSED_ELEMENTS").success(function(projects){scope.projectsWithManageExposedElementsPrivilege=projects}).error(setErrorInScope.bind(scope))}function getCountByNodeType(selectedNodes){let ret={};selectedNodes.forEach(function(item){const type=getType(item);ret[type]=(ret[type]||0)+1});return ret}function getCountByIndexableType(selectedNodes){return selectedNodes.reduce((acc,curr)=>{const indexableType=TaggableObjectsUtils.getIndexableTypeFromNode(curr,getType(curr));acc[indexableType]=(acc[indexableType]||0)+1;return acc},{})}scope.getTaggableTypeMap=function(){let ret={};scope.getSelectedNodes().forEach(function(item){let type=TaggableObjectsUtils.fromNodeType(getType(item));if(ret.hasOwnProperty(type)){ret[type].push(getSmartName(item))}else{ret[type]=[getSmartName(item)]}});return ret};function count(nodeType){return scope.selection.countByNodeType[nodeType]||0}function selectedNodes(){return scope.selection.selectedObjects}scope.getSelectedNodes=selectedNodes;function isAll(nodeTypes){return function(){const total=scope.selection.selectedObjects.length;return total>0&&nodeTypes.map(count).reduce(Fn.SUM)==total}}function containsNodeType(nodeTypes){return()=>scope.selection.selectedObjects.length>0&&nodeTypes.map(count).reduce(Fn.SUM)>0}function allHaveFlag(propName){return function(){const total=scope.selection.selectedObjects.length;return total>0&&scope.selection.selectedObjects.filter(Fn.prop(propName)).length==total}}scope.isAllRecipes=isAll(["RECIPE"]);scope.containsRecipes=containsNodeType(["RECIPE"]);scope.isAllContinuousRecipes=allHaveFlag("continuous");scope.isAllDatasets=isAll(["LOCAL_DATASET","FOREIGN_DATASET"]);scope.containsDatasets=containsNodeType(["LOCAL_DATASET","FOREIGN_DATASET"]);scope.isAllFolders=isAll(["LOCAL_MANAGED_FOLDER","FOREIGN_MANAGED_FOLDER"]);scope.isAllStreamingEndpoints=isAll(["LOCAL_STREAMING_ENDPOINT"]);scope.isAllModels=isAll(["LOCAL_SAVEDMODEL","FOREIGN_SAVEDMODEL"]);scope.isAllEvaluationStores=isAll(["LOCAL_MODELEVALUATIONSTORE","FOREIGN_MODELEVALUATIONSTORE","LOCAL_GENAIEVALUATIONSTORE","FOREIGN_GENAIEVALUATIONSTORE"]);scope.isAllCodeStudios=isAll(["CODE_STUDIO"]);scope.isAllZones=isAll(["ZONE"]);scope.isAllProjects=isAll(["PROJECT"]);scope.isAllLocal=isAll(["RECIPE","LOCAL_DATASET","LOCAL_MANAGED_FOLDER","LOCAL_SAVEDMODEL","LOCAL_MODELEVALUATIONSTORE","LOCAL_GENAIEVALUATIONSTORE","LOCAL_RETRIEVABLE_KNOWLEDGE"]);scope.isAllForeign=isAll(["FOREIGN_DATASET","FOREIGN_MANAGED_FOLDER","FOREIGN_SAVEDMODEL","FOREIGN_MODELEVALUATIONSTORE","FOREIGN_GENAIEVALUATIONSTORE","FOREIGN_RETRIEVABLE_KNOWLEDGE"]);scope.isAllComputables=isAll(["LOCAL_DATASET","FOREIGN_DATASET","LOCAL_MANAGED_FOLDER","FOREIGN_MANAGED_FOLDER","LOCAL_SAVEDMODEL","FOREIGN_SAVEDMODEL","LOCAL_MODELEVALUATIONSTORE","FOREIGN_MODELEVALUATIONSTORE","LOCAL_GENAIEVALUATIONSTORE","FOREIGN_GENAIEVALUATIONSTORE","LOCAL_RETRIEVABLE_KNOWLEDGE","FOREIGN_RETRIEVABLE_KNOWLEDGE"]);scope.isAllDatasetsAndFolders=isAll(["LOCAL_DATASET","FOREIGN_DATASET","LOCAL_MANAGED_FOLDER","FOREIGN_MANAGED_FOLDER"]);scope.isAllSharable=isAll(["LOCAL_DATASET","DASHBOARD","WEB_APP"]);scope.hasVisualSection=scope.isAllDatasets||scope.isAllFolders||scope.isDatasetAndFolder;scope.getSingleSelectedDataset=function(){const candidates=selectedNodes().filter(({nodeType})=>["LOCAL_DATASET","FOREIGN_DATASET"].includes(nodeType));return candidates.length==1?candidates[0]:null};scope.getSingleSelectedModel=function(){const candidates=selectedNodes().filter(({nodeType})=>["LOCAL_SAVEDMODEL","FOREIGN_SAVEDMODEL"].includes(nodeType));return candidates.length==1?candidates[0]:null};scope.getSingleSelectedFolder=function(){const candidates=selectedNodes().filter(({nodeType})=>["LOCAL_MANAGED_FOLDER","FOREIGN_MANAGED_FOLDER"].includes(nodeType));return candidates.length==1?candidates[0]:null};scope.isPredictionModel=function(){return scope.singleSelectedModelInfos&&scope.singleSelectedModelInfos.model.miniTask&&scope.singleSelectedModelInfos.model.miniTask.taskType=="PREDICTION"&&scope.singleSelectedModelInfos.model.miniTask.backendType!=="VERTICA"};scope.isClusteringModel=function(){return scope.singleSelectedModelInfos&&scope.singleSelectedModelInfos.model.miniTask&&scope.singleSelectedModelInfos.model.miniTask.taskType=="CLUSTERING"&&scope.singleSelectedModelInfos.model.miniTask.backendType!=="VERTICA"};scope.isLLM=function(){return scope.singleSelectedModelInfos&&(SavedModelsService.isAgent(scope.singleSelectedModelInfos.model)||SavedModelsService.isRetrievalAugmentedLLM(scope.singleSelectedModelInfos.model)||SavedModelsService.isLLMGeneric(scope.singleSelectedModelInfos.model))};scope.isDatasetAndModel=function(){return selectedNodes().length==2&&scope.getSingleSelectedDataset()&&scope.getSingleSelectedModel()};scope.isDatasetAndFolder=function(){return selectedNodes().length==2&&scope.getSingleSelectedDataset()&&scope.getSingleSelectedFolder()};scope.isTwoDatasets=function(){return selectedNodes().length==2&&scope.isAllDatasets()};scope.isAllMetastoreAware=function(){const total=selectedNodes().length;const hiveRecipes=selectedNodes().filter(n=>TaggableObjectsUtils.isHDFSAbleType(n.datasetType)).length;return total>0&&hiveRecipes==total};scope.isAllImpalaRecipes=function(){const total=selectedNodes().length;const impalaRecipes=selectedNodes().filter(n=>(n.recipeType||n.type)=="impala").length;return total>0&&impalaRecipes==total};scope.isAllPythonCodeEnvSelectableRecipes=function(){const total=selectedNodes().length;const codeEnvSelectableRecipes=selectedNodes().filter(n=>(n.recipeType||n.type)&&CodeEnvsService.canPythonCodeEnv(n)).length;return total>0&&codeEnvSelectableRecipes==total};scope.isAllRCodeEnvSelectableRecipes=function(){const total=selectedNodes().length;const codeEnvSelectableRecipes=selectedNodes().filter(n=>(n.recipeType||n.type)&&CodeEnvsService.canRCodeEnv(n)).length;return total>0&&codeEnvSelectableRecipes==total};scope.isAllHiveRecipes=function(){const total=selectedNodes().length;const hiveRecipes=selectedNodes().filter(n=>(n.recipeType||n.type)=="hive").length;return total>0&&hiveRecipes==total};scope.isAllManaged=function(){const total=selectedNodes().length;const managed=selectedNodes().filter(n=>n.managed).length;return total>0&&managed==total};scope.isAllWatched=function(){const total=selectedNodes().length;const watched=selectedNodes().filter(n=>n.interest&&WatchInterestState.isWatching(n.interest.watching)).length;return total>0&&watched==total};scope.isAllStarred=function(){const total=selectedNodes().length;const starred=selectedNodes().filter(n=>n.interest&&n.interest.starred).length;return total>0&&starred==total};scope.isAllVirtualizable=function(){return selectedNodes().map(x=>!!x.virtualizable).reduce((a,b)=>a&&b,true)};scope.canManageExposedElementsOnAllOriginalProjects=function(){if(scope.projectsWithManageExposedElementsPrivilege==null){return false}const projectKeysWithManageExposedElementsPrivilege=scope.projectsWithManageExposedElementsPrivilege.map(p=>p.projectKey);const originalProjectKeys=new Set(selectedNodes().map(n=>n.projectKey));return[...originalProjectKeys].every(key=>projectKeysWithManageExposedElementsPrivilege.includes(key))};scope.anyPipelineTypeEnabled=function(){return $rootScope.projectSummary.sparkPipelinesEnabled||$rootScope.projectSummary.sqlPipelinesEnabled};function showVirtualizationAction(showDeactivate){return function(){return scope.isProjectAnalystRW()&&scope.isAllDatasets()&&scope.isAllLocal()&&showDeactivate===scope.isAllVirtualizable()}}scope.showAllowVirtualizationAction=showVirtualizationAction(false);scope.showStopVirtualizationAction=showVirtualizationAction(true);scope.anyMultiEngineRecipe=function(){function isMultiEngine(recipeType){const desc=RecipeDescService.getDescriptor(recipeType);return!!desc&&desc.isMultiEngine}return!!selectedNodes().filter(node=>isMultiEngine(node.recipeType||node.type)).length};scope.anyImpala=function(){return!!selectedNodes().filter(n=>(n.recipeType||n.type)=="impala").length};scope.anyHive=function(){return!!selectedNodes().filter(n=>(n.recipeType||n.type)=="hive").length};scope.anyCanSpark=function(){return!!selectedNodes().filter(node=>scope.canSpark(node)).length};scope.allAreSparkNotSQLRecipes=function(){return selectedNodes().every(node=>["spark_scala","pyspark","sparkr"].indexOf(node.recipeType||node.type)>=0)};scope.anyCanSparkPipeline=function(){return selectedNodes().some(node=>scope.canSparkPipeline(node))};scope.anyCanSqlPipeline=function(){return selectedNodes().some(node=>scope.canSqlPipeline(node))};scope.allAutoTriggersDisabled=function(){return scope.getAutoTriggerDisablingReason($rootScope.appConfig,$rootScope.projectSummary)};scope.autoTriggersObjects=function(autoTriggerStatus,objects){objects.forEach(function(object){object.active=autoTriggerStatus;scope.toggleActive(object)})};scope.isAllUnshareable=function(){const total=selectedNodes().length;const unshareables=selectedNodes().filter(n=>n.usedByZones&&n.usedByZones.length&&!n.successors.length).length;return total>0&&unshareables==total};scope.canPublishAllToDataCollection=function(){return $rootScope.appConfig.globalPermissions.mayPublishToDataCollections&&(count("LOCAL_DATASET")===0||$rootScope.projectSummary.canPublishToDataCollections)};scope.getSelectedObjectsZones=function(){return getSelectedItems().map(n=>n.usedByZones[0])};scope.getCommonZone=function(){const nodesSelected=selectedNodes();return nodesSelected.length?(nodesSelected[0].usedByZones||[])[0]||nodesSelected[0].ownerZone:null};function getSmartName(it){return it.projectKey==$stateParams.projectKey?it.name:it.projectKey+"."+it.name}scope.getSmartNames=function(){return selectedNodes().map(getSmartName)};scope.clearSelection=function(){FlowGraphSelection.clearSelection()};scope.refreshData=function(){let selectedNodes=getSelectedItems();scope.selection={selectedObjects:selectedNodes,taggableType:TaggableObjectsUtils.getCommonType(selectedNodes,node=>TaggableObjectsUtils.fromNodeType(getType(node))),countByNodeType:getCountByNodeType(selectedNodes),indexableType:TaggableObjectsUtils.getCommonIndexableType(selectedNodes,node=>TaggableObjectsUtils.getIndexableTypeFromNode(node,getType(node))),countByIndexableType:getCountByIndexableType(selectedNodes)};scope.usability=scope.computeActionsUsability();scope.selectablePlugins=scope.isAllComputables(selectedNodes)?SelectablePluginsService.listSelectablePlugins(scope.selection.countByIndexableType):[];let availableCategories=[];if(scope.hasVisualSection){availableCategories.push("visual")}if(scope.isAllComputables){availableCategories.push("code")}scope.noRecipesCategoryPlugin=PluginCategoryService.standardCategoryPlugins(scope.selectablePlugins,availableCategories);scope.singleSelectedDataset=scope.getSingleSelectedDataset();scope.singleSelectedFolder=scope.getSingleSelectedFolder();scope.selectedFolderIsSharepoint=scope.singleSelectedFolder?.folderType==="SharePointOnline";scope.refreshSingleSelectedModelInfos()};scope.refreshSingleSelectedModelInfos=function(){if(!scope.getSingleSelectedModel()){scope.singleSelectedModelInfos=null;scope.singleSelectedModel=null}if(scope.getSingleSelectedModel()==scope.singleSelectedModel){return}scope.singleSelectedModel=scope.getSingleSelectedModel();scope.singleSelectedModelInfos=null;let projectKey=scope.singleSelectedModel.projectKey;let name=scope.singleSelectedModel.name;DataikuAPI.savedmodels.getFullInfo($stateParams.projectKey,getSmartName(scope.singleSelectedModel)).success(data=>{if(!scope.singleSelectedModel||scope.singleSelectedModel.projectKey!=projectKey||scope.singleSelectedModel.name!=name){return}scope.singleSelectedModelInfos=data;scope.singleSelectedModelInfos.zone=(scope.singleSelectedModel.usedByZones||[])[0]||scope.singleSelectedModel.ownerZone}).error(setErrorInScope.bind(scope))};scope.filterSelection=function(indexableType){FlowGraphSelection.filterByIndexableType(indexableType);scope.refreshData()};scope.refreshData();scope.$watchCollection(newItemsWatch,scope.refreshData);scope.collapseSelectedZones=()=>{scope.toggleZoneCollapse(FlowGraphSelection.getSelectedTaggableObjectRefs(),"collapseAll")};scope.expandSelectedZones=()=>{scope.toggleZoneCollapse(FlowGraphSelection.getSelectedTaggableObjectRefs(),"expandAll")};scope.isAllZonesExpanded=function(){const allZones=scope.selection.selectedObjects.filter(so=>getType(so)==="ZONE");return allZones.filter(z=>z.customData.isCollapsed===false).length===allZones.length};scope.isAllZonesCollapsed=function(){const allZones=scope.selection.selectedObjects.filter(so=>getType(so)==="ZONE");return allZones.filter(z=>z.customData.isCollapsed===true).length===allZones.length};scope.copyZone=()=>{const startCopyTool=scope.startTool("COPY",{preselectedNodes:FlowGraphSelection.getSelectedNodes().map(n=>n.id)});startCopyTool.then(()=>{const selectedTaggableObjectRefs=FlowGraphSelection.getSelectedTaggableObjectRefs();const itemsByZones=FlowGraph.nodesByZones(node=>TaggableObjectsUtils.fromNode(node));SubFlowCopyService.start(selectedTaggableObjectRefs,itemsByZones,scope.stopAction)})};scope.insertRecipeBetween=function(){scope.showInsertRecipeModal(scope.selectedDataset,scope.selectedRecipes).then(selectedRecipe=>WT1.event("rightpanelrecipe_actions_insertrecipe",{position:"between",recipe:selectedRecipe&&selectedRecipe.type||"Unknown"}))};scope.canInsertRecipeBetween=function(){const selectedNodes=getSelectedItems();const selectedDatasets=[];const selectedRecipes=[];for(const node of selectedNodes){if(node.nodeType==="LOCAL_DATASET"||node.nodeType==="FOREIGN_DATASET"){selectedDatasets.push(node)}else if(node.nodeType==="RECIPE"){selectedRecipes.push(node)}}scope.selectedDataset=selectedDatasets[0];scope.selectedRecipes=selectedRecipes;return FlowGraphSelection.canInsertRecipeBetweenSelection(selectedNodes,selectedDatasets,selectedRecipes)};scope.getInsertRecipeBetweenTooltip=function(){if(!scope.canWriteProject())return translate("PROJECT.PERMISSIONS.WRITE_ERROR","You don't have the permissions to write to this project");if(!scope.canInsertRecipeBetween())return translate("PROJECT.FLOW.RIGHT_PANEL.INSERT_RECIPE.ERROR","The current selection does not allow to insert a new recipe. Select a dataset and a specific downstream recipe to insert a recipe in between.");return translate("PROJECT.FLOW.RIGHT_PANEL.INSERT_RECIPE.TOOLTIP","Insert recipe (and corresponding output dataset) between selected items")}}}});app.controller("_FlowContextMenus",function($scope,$state,$stateParams,$controller,WT1,GlobalProjectActions,FlowGraph,FlowGraphSelection,FlowGraphFolding,FlowAssistantSelectionService,TaggableObjectsUtils,Logger){WT1.event("flow-context-menu-open");$controller("_TaggableObjectsCapabilities",{$scope:$scope});$controller("_TaggableObjectsMassActions",{$scope:$scope});$scope.toggleTab=tabName=>{FlowGraphSelection.clearSelection();FlowGraphSelection.onItemClick($scope.object);$scope.standardizedSidePanel.toggleTab(tabName)};$scope.activeTab=()=>$scope.standardizedSidePanel.activeTab;$scope.getSelectedTaggableObjectRefs=function(){return[TaggableObjectsUtils.fromNode($scope.object)]};$scope.computeMovingImpact=function(){let realNode=$scope.object.usedByZones.length?FlowGraph.node(`zone__${$scope.object.ownerZone}__${$scope.object.realId}`):$scope.object;var computedImpact=[];function addSuccessors(node){if(node.nodeType!="RECIPE")return;let successors=node.successors;successors.forEach(function(successor){if(successor==realNode.id)return;computedImpact.push(TaggableObjectsUtils.fromNode(FlowGraph.node(successor)))})}let predecessor=realNode.predecessors[0];if(predecessor&&realNode.nodeType!="RECIPE"&&!realNode.isHiddenLinkTarget){computedImpact.push(TaggableObjectsUtils.fromNode(FlowGraph.node(predecessor)));addSuccessors(FlowGraph.node(predecessor))}addSuccessors(realNode);return computedImpact};$scope.zoomToOtherZoneNode=function(zoneId){const otherNodeId=$scope.object.id.replace(/zone__.+?__/,"zone__"+zoneId+"__");if($stateParams.zoneId){$state.go("projects.project.flow",Object.assign({},$stateParams,{zoneId:zoneId,id:graphVizUnescape(otherNodeId)}))}else{$scope.zoomGraph(otherNodeId);FlowGraphSelection.clearSelection();FlowGraphSelection.onItemClick($scope.nodesGraph.nodes[otherNodeId])}};$scope.$state=$state;$scope.$stateParams=$stateParams;$scope.othersZones=FlowGraph.nodeSharedBetweenZones($scope.object)?Array.from(FlowGraph.nodeSharedBetweenZones($scope.object)):null;$scope.startPropagateToolFromRecipe=function(node){const predecessorNodeId=node.predecessors[0];const predecessorNode=FlowGraph.get().nodes[predecessorNodeId];$scope.startTool("PROPAGATE_SCHEMA",{projectKey:predecessorNode.projectKey,datasetName:predecessorNode.name})};$scope.selectSuccessors=function(){WT1.event("flow-context-menu-select-successors");FlowGraphSelection.selectSuccessors($scope.object)};$scope.selectPredecessors=function(){WT1.event("flow-context-menu-select-predecessors");FlowGraphSelection.selectPredecessors($scope.object)};$scope.hasPredecessorsInOtherZone=function(object){return!$stateParams.zoneId&&FlowGraphSelection.hasPredecessorsInOtherZone(object)};$scope.hasSuccessorsInOtherZone=function(object){return!$stateParams.zoneId&&FlowGraphSelection.hasSuccessorsInOtherZone(object)};$scope.foldSuccessors=function(){WT1.event("flow-context-menu-fold",{direction:"successors"});FlowGraphFolding.foldSuccessors($scope.object)};$scope.foldPredecessors=function(){WT1.event("flow-context-menu-fold",{direction:"predecessors"});FlowGraphFolding.foldPredecessors($scope.object)};$scope.previewSelectSuccessors=function(object){FlowGraphFolding.previewSelect($scope.object,"successors")};$scope.previewSelectPredecessors=function(object){FlowGraphFolding.previewSelect($scope.object,"predecessors")};$scope.previewFoldSuccessors=function(object){FlowGraphFolding.previewFold($scope.object,"successors")};$scope.previewFoldPredecessors=function(object){FlowGraphFolding.previewFold($scope.object,"predecessors")};$scope.endPreviewBranch=function(){FlowGraphFolding.endPreviewBranch()};$scope.deleteFlowItem=function(){WT1.event("flow-context-menu-delete");const type=TaggableObjectsUtils.fromNodeType($scope.object.nodeType);const id=$scope.object.name;const displayName=$scope.object.description;GlobalProjectActions.deleteTaggableObject($scope,type,id,displayName).then(FlowGraphSelection.clearSelection)};$scope.viewAiFlowAssistantRHP=function(){WT1.tryEvent("flow-assistant-open-tab",()=>({source:"flow-contextual-menu",isAlreadyOpened:$scope.activeTab()==="Flow Assistant"}));FlowAssistantSelectionService.addDatasetToChatContext($scope.selectedNodes,$scope.object);$scope.toggleTab("Flow Assistant")};$scope.canInsertRecipeAfter=function(){return $scope.object.successors&&$scope.object.successors.length&&$scope.object.successors.every(successor=>FlowGraph.node(successor).nodeType==="RECIPE")};$scope.insertRecipeAfter=function(){$scope.showInsertRecipeModal($scope.object).then(selectedRecipe=>WT1.event("flow-context-menu-insertrecipe",{position:"after",recipe:selectedRecipe&&selectedRecipe.type||"Unknown"}))};$scope.isDeleteAndReconnectAllowed=false;$scope.canDeleteAndReconnectObject($scope.object).then(function(result){$scope.isDeleteAndReconnectAllowed=result}).catch(function(error){Logger.warn(`Problem determining whether to show delete & reconnect option for ${$scope.object.id}:`,error)});$scope.deleteAndReconnectRecipe=function(wt1_event_name){$scope.doDeleteAndReconnectRecipe($scope.object,wt1_event_name)}});app.controller("SavedModelContextualMenuController",function($scope,$state,$controller,WT1,SavedModelRenameService){$controller("_FlowContextMenus",{$scope:$scope});$scope.renameSavedModel=function(savedModel){SavedModelRenameService.renameSavedModel({scope:$scope,state:$state,projectKey:savedModel.projectKey,savedModelId:savedModel.name,savedModelName:savedModel.description})};$scope.trainThisModel=function(){WT1.event("flow-context-menu-train");$scope.trainModel($scope.object.projectKey,$scope.object.name)}});app.controller("ModelEvaluationStoreContextualMenuController",function($scope,$controller,$state,ModelEvaluationStoreRenameService){$controller("_FlowContextMenus",{$scope:$scope});$scope.renameMES=function(modelEvaluationStore){ModelEvaluationStoreRenameService.renameModelEvaluationStore({scope:$scope,state:$state,projectKey:modelEvaluationStore.projectKey,modelEvaluationStoreId:modelEvaluationStore.name,modelEvaluationStoreName:modelEvaluationStore.description})}});app.controller("ManagedFolderContextualMenuController",function($scope,$controller,$state,WT1,ManagedFolderRenameService){$controller("_FlowContextMenus",{$scope:$scope});$scope.renameManagedFolder=function(managedFolder){const projectKey=managedFolder.projectKey;const managedFolderCurrentName=managedFolder.description;const scopeWithObjectType=$scope.$new();scopeWithObjectType.objectType="MANAGED_FOLDER";ManagedFolderRenameService.renameManagedFolder({scope:scopeWithObjectType,state:$state,projectKey:projectKey,managedFolderId:managedFolder.name,managedFolderCurrentName:managedFolderCurrentName})};$scope.buildThis=function(){WT1.event("flow-context-menu-build");$scope.buildManagedFolder($scope.object.projectKey,$scope.object.id)}});app.controller("KnowledgeBankContextualMenuController",function($scope,$controller,WT1,DatasetsService){$controller("_FlowContextMenus",{$scope:$scope})});app.controller("ZoneContextualMenuController",function($scope,$rootScope,$controller,DataikuAPI,TaggableObjectsUtils,$stateParams,CreateModalFromTemplate,FlowGraph,FlowGraphSelection){$controller("_FlowContextMenus",{$scope:$scope});$scope.deleteZone=()=>{DataikuAPI.flow.zones.delete($stateParams.projectKey,$scope.object.name).success(()=>{if($stateParams.zoneId){$scope.zoomOutOfZone()}else{$scope.$emit("reloadGraph")}}).error(setErrorInScope.bind($scope))};$scope.openZone=items=>{const zoneToOpen=items.map(ref=>ref.id)[0];$scope.zoomOnZone(zoneToOpen)};$scope.collapseAllZones=()=>{const allFlowZones=Object.values(FlowGraph.get().nodes).filter(it=>TaggableObjectsUtils.fromNodeType(it.nodeType)==="FLOW_ZONE");$scope.toggleZoneCollapse(allFlowZones.map(TaggableObjectsUtils.fromNode),"collapseAll")};$scope.expandAllZones=()=>{const allFlowZones=Object.values(FlowGraph.get().nodes).filter(it=>TaggableObjectsUtils.fromNodeType(it.nodeType)==="FLOW_ZONE");$scope.toggleZoneCollapse(allFlowZones.map(TaggableObjectsUtils.fromNode),"expandAll")};$scope.collapseSelectedZones=()=>{$scope.toggleZoneCollapse(FlowGraphSelection.getSelectedTaggableObjectRefs(),"collapseAll")};$scope.expandSelectedZones=()=>{$scope.toggleZoneCollapse(FlowGraphSelection.getSelectedTaggableObjectRefs(),"expandAll")};$scope.editZone=()=>{CreateModalFromTemplate("/templates/zones/edit-zone-modal.html",$scope,null,function(newScope){newScope.uiState={color:$scope.object.customData.color,name:$scope.object.description};newScope.go=function(){DataikuAPI.flow.zones.edit($stateParams.projectKey,$scope.object.name,newScope.uiState.name,newScope.uiState.color).success(function(){$scope.$emit("reloadGraph");if($stateParams.zoneId){$rootScope.$emit("zonesListChanged",newScope.uiState.name)}newScope.dismiss()}).error(setErrorInScope.bind(newScope))}})}});app.controller("DatasetContextualMenuController",function($scope,$rootScope,$controller,WT1,DataikuAPI,TaggableObjectsUtils){$controller("_FlowContextMenus",{$scope:$scope});$scope.buildThisDataset=function(){WT1.event("flow-context-menu-build");$scope.buildDataset($scope.object.projectKey,$scope.object.name,$scope.object.predecessors.length,$scope.object.successors.length)};$scope.reloadSchema=function(){WT1.event("flow-context-menu-dataset-reload-schema");DataikuAPI.datasets.reloadSchema($scope.object.projectKey,$scope.object.name).error(setErrorInScope.bind($scope))};$scope.markAsBuilt=function(){WT1.event("flow-context-menu-mark-as-built");DataikuAPI.datasets.markAsBuilt([TaggableObjectsUtils.fromNode($scope.object)]).then(function(){$rootScope.$emit("reloadGraph")},setErrorInScope.bind($scope))}});app.controller("ForeignDatasetContextualMenuController",function($scope,$controller,$state,WT1,DataikuAPI){$controller("_FlowContextMenus",{$scope:$scope})});app.controller("StreamingEndpointContextualMenuController",function($scope,$rootScope,$controller,WT1,DataikuAPI,TaggableObjectsUtils){$controller("_FlowContextMenus",{$scope:$scope})});app.controller("RecipeContextualMenuController",function($scope,$controller,$stateParams,WT1,ComputableSchemaRecipeSave){$controller("_FlowContextMenus",{$scope:$scope});$scope.propagateSchema=function(){WT1.event("flow-context-menu-propagate-schema");ComputableSchemaRecipeSave.handleSchemaUpdateFromAnywhere($scope,$stateParams.projectKey,$scope.object.name)}});app.controller("LabelingTaskContextualMenuController",function($scope,$controller,$stateParams,WT1,ComputableSchemaRecipeSave){$controller("_FlowContextMenus",{$scope:$scope})});app.controller("MultiContextualMenuController",function($scope,$controller,WT1,FlowGraphSelection,FlowAssistantSelectionService,TaggableObjectsService,TaggableObjectsUtils,FlowGraph){$controller("_FlowContextMenus",{$scope:$scope});$controller("_TaggableObjectsMassActions",{$scope:$scope});$controller("_TaggableObjectsCapabilities",{$scope:$scope});$scope.getSelectedTaggableObjectRefs=FlowGraphSelection.getSelectedTaggableObjectRefs;$scope.computeMovingImpact=function(){const computedImpact=[];const movingItems=FlowGraphSelection.getSelectedTaggableObjectRefs();function addSuccessors(node,original){if(!["RECIPE","LABELING_TASK"].includes(node.nodeType))return;node.successors.forEach(function(successor){let newTaggableObjectRef=TaggableObjectsUtils.fromNode(FlowGraph.node(successor));if(original&&successor===original.id||movingItems.some(it=>it.id===newTaggableObjectRef.id)||computedImpact.some(it=>it.id===newTaggableObjectRef.id))return;computedImpact.push(newTaggableObjectRef)})}function computeImpact(node){let predecessor=node.predecessors[0];if(predecessor&&!["RECIPE","LOCAL_SAVEDMODEL","LABELING_TASK"].includes(node.nodeType)){let newTaggableObjectRef=TaggableObjectsUtils.fromNode(FlowGraph.node(predecessor));if(computedImpact.some(it=>it.id===newTaggableObjectRef.id))return;if(!movingItems.some(it=>it.id===newTaggableObjectRef.id)){computedImpact.push(newTaggableObjectRef)}addSuccessors(FlowGraph.node(predecessor),node)}addSuccessors(node)}FlowGraphSelection.getSelectedNodes().forEach(function(node){let realNode=node.usedByZones.length?FlowGraph.node(`zone__${node.ownerZone}__${node.realId}`):node;computeImpact(realNode)});return computedImpact};$scope.selectedObjectsZones=FlowGraphSelection.getSelectedNodes().map(n=>n.usedByZones[0]);$scope.deleteFlowItems=function(){WT1.event("flow-context-menu-delete-multi");TaggableObjectsService.delete(FlowGraphSelection.getSelectedTaggableObjectRefs()).then(FlowGraphSelection.clearSelection)};$scope.viewAiFlowAssistantRHP=function(){WT1.tryEvent("flow-assistant-open-tab",()=>({source:"flow-multi-contextual-menu",isAlreadyOpened:$scope.activeTab()==="Flow Assistant",addedToContextCount:$scope.selectedNodes.length}));FlowAssistantSelectionService.addDatasetToChatContext($scope.selectedNodes,$scope.object);$scope.toggleTab("Flow Assistant");FlowGraphSelection.clearSelection()};$scope.selectSuccessors=function(){WT1.event("flow-context-menu-select-successors-multi");FlowGraphSelection.getSelectedNodes().forEach(FlowGraphSelection.selectSuccessors)};$scope.selectPredecessors=function(){WT1.event("flow-context-menu-select-predecessors-multi");FlowGraphSelection.getSelectedNodes().forEach(FlowGraphSelection.selectPredecessors)};$scope.startPropagate=function(){const items=FlowGraphSelection.getSelectedTaggableObjectRefs().map(r=>{return{projectKey:r.projectKey,id:r.id}});$scope.startTool("PROPAGATE_SCHEMA",{sources:items})};$scope.havePredecessors=false;$scope.haveSuccessors=false;$scope.anyLocalDataset=false;$scope.anyLocalFolder=false;$scope.anyLocalComputable=false;$scope.anyRecipe=false;$scope.anyNonVirtualizable=false;$scope.anyCanSpark=false;$scope.anyCanChangeConnection=false;$scope.allShareable=true;$scope.allUnshareable=true;$scope.isAllZonesCollapsed=true;$scope.isAllZonesExpanded=true;$scope.selectedDatasets=[];$scope.selectedRecipes=[];$scope.selectedNodes=[];$scope.selectedNodes=FlowGraphSelection.getSelectedNodes();$scope.selectedNodes.forEach(function(node){if(node.nodeType.startsWith("LOCAL")){$scope.anyLocalComputable=true}if(node.nodeType=="LOCAL_DATASET"){$scope.anyLocalDataset=true;if(!node.virtualizable){$scope.anyNonVirtualizable=true}}if(node.nodeType==="LOCAL_DATASET"||node.nodeType==="FOREIGN_DATASET"){$scope.selectedDatasets.push(node)}if(node.nodeType=="LOCAL_MANAGED_FOLDER"){$scope.anyLocalFolder=true}if(node.nodeType=="RECIPE"){$scope.anyRecipe=true;if($scope.canSpark(node)){$scope.anyCanSpark=true}$scope.selectedRecipes.push(node)}if(node.predecessors.length){$scope.havePredecessors=true}if(node.successors.length){$scope.haveSuccessors=true}if(["ZONE","RECIPE"].includes(node.nodeType)){$scope.allShareable=false}if(!node.usedByZones.length||node.successors.length){$scope.allUnshareable=false}if(node.nodeType=="ZONE"&&!node.customData.isCollapsed){$scope.isAllZonesCollapsed=false}if(node.nodeType=="ZONE"&&node.customData.isCollapsed){$scope.isAllZonesExpanded=false}$scope.anyCanChangeConnection=$scope.anyCanChangeConnection||$scope.canChangeConnection(node)});$scope.canInsertRecipeBetween=function(){return FlowGraphSelection.canInsertRecipeBetweenSelection($scope.selectedNodes,$scope.selectedDatasets,$scope.selectedRecipes)};$scope.insertRecipeBetween=function(){const selectedDataset=$scope.selectedDatasets[0];const selectedRecipes=$scope.selectedRecipes;$scope.showInsertRecipeModal(selectedDataset,selectedRecipes).then(selectedRecipe=>WT1.event("flow-context-menu-insertrecipe",{position:"between",recipe:selectedRecipe&&selectedRecipe.type||"Unknown"}))}});app.service("FlowFilterQueryService",function(){const svc=this;this.escapeStr=function(string){if(string.includes(" ")||string.includes('"')||string.includes(":")){return`"${string.replace(/"/g,'\\"')}"`}return string};function uiFilterArrayToQueryClause(elements,key){if(!elements)return;const resultString=elements.map(el=>key+svc.escapeStr(el)).join(" OR ");return elements.length>1?`(${resultString})`:resultString}this.pickerFormat="YYYY-MM-DD HH:mm";const queryClauseOrNull=(types,type)=>types&&types.includes(type)?uiFilterArrayToQueryClause([type],"type:"):null;this.uiFilterToQuery=function(structuredFlowObjectFilter){function formatDate(date){return moment(date).format(svc.pickerFormat)}const creationDate=structuredFlowObjectFilter.customCreationDateRange;const modificationDate=structuredFlowObjectFilter.customModificationDateRange;let createdRangeClause;let modifiedRangeClause;if(structuredFlowObjectFilter.creationDateRange){if(structuredFlowObjectFilter.creationDateRange==="CUSTOM"){createdRangeClause=creationDate&&creationDate.from&&creationDate.to?`createdBetween:${formatDate(creationDate.from)} / ${formatDate(creationDate.to)}`:null}else{createdRangeClause=`created:${structuredFlowObjectFilter.creationDateRange}`}}if(structuredFlowObjectFilter.modificationDateRange){if(structuredFlowObjectFilter.modificationDateRange==="CUSTOM"){modifiedRangeClause=modificationDate&&modificationDate.from&&modificationDate.to?`modifiedBetween:${formatDate(modificationDate.from)} / ${formatDate(modificationDate.to)}`:null}else{modifiedRangeClause=`modified:${structuredFlowObjectFilter.modificationDateRange}`}}const datasetTypeClause=uiFilterArrayToQueryClause(structuredFlowObjectFilter.datasetTypes,"datasetType:");const recipeTypeClause=uiFilterArrayToQueryClause(structuredFlowObjectFilter.recipeTypes,"recipeType:");const recipeClauseArr=[queryClauseOrNull(structuredFlowObjectFilter.types,"RECIPE"),recipeTypeClause].filter(e=>e);const recipeClause=recipeClauseArr.length>1?`(${recipeClauseArr.join(" AND ")})`:recipeClauseArr.join(" AND ");const datasetClauseArr=[queryClauseOrNull(structuredFlowObjectFilter.types,"DATASET"),datasetTypeClause].filter(e=>e);const datasetClause=datasetClauseArr.length>1?`(${datasetClauseArr.join(" AND ")})`:datasetClauseArr.join(" AND ");const typeClauses=structuredFlowObjectFilter.types.filter(e=>e!=="RECIPE"&&e!=="DATASET").map(e=>uiFilterArrayToQueryClause([e],"type:"));const typeWithRefinements=[...typeClauses,recipeClause,datasetClause].filter(e=>e);let typeWithRefinementClause=typeWithRefinements.join(" OR ");if(typeWithRefinements.length>1){typeWithRefinementClause=`(${typeWithRefinementClause})`}return[uiFilterArrayToQueryClause(structuredFlowObjectFilter.tags,"tag:"),uiFilterArrayToQueryClause(structuredFlowObjectFilter.creator,"user:"),typeWithRefinementClause,createdRangeClause,modifiedRangeClause].filter(e=>e).join(" AND ")}})})();(function(){"use strict";const app=angular.module("dataiku.flow.project");app.service("FlowGraphSelection",function($rootScope,FlowGraphFolding,TaggableObjectsUtils,FlowGraph,FlowGraphHighlighting){const svc=this;let selectedItems=[];function _isSelected(item){return selectedItems.includes(item)}function _hasOnlyZonesOrNone(item){return _isZone(item)&&selectedItems.find(elem=>!_isZone(elem))===undefined||!_isZone(item)&&selectedItems.find(elem=>_isZone(elem))===undefined}function _hasOnlyZones(){return selectedItems.every(_isZone)}function _hasOnlyNonZones(){return!selectedItems.some(_isZone)}function _clearSelection(){const element=FlowGraph.getDOMElement();if(!element)return;selectedItems.forEach(it=>it.selected=false);FlowGraphHighlighting.removeAllZoneClusterHighlights();d3.select("#flow-graph").classed("has-selection",false);d3.selectAll("#flow-graph .zone_cluster.selected").attr("style",null);d3.selectAll("#flow-graph .selected").classed("selected",false);selectedItems=[]}function _addToSelection(items){items=items.filter(it=>!_isSelected(it));_.uniqBy(items,it=>it.realId).forEach(it=>it.selected=true);var realIdsSelected=items.map(it=>it.realId);selectedItems=selectedItems.filter(it=>!it.realId||!realIdsSelected.includes(it.realId));if(!items.length){return}const selector=items.map(it=>_isZoned(it)?`svg [data-node-id="${it.realId}"]`:_isZone(it)?`svg [id="cluster_${it.id}"]`:`svg [data-id="${it.id}"]`).join(", ");d3.selectAll(selector).each(function(){const type=this.getAttribute("data-type");let key=this.getAttribute("data-id");if(type==="ZONE"){key=key.replace("cluster_","");FlowGraphHighlighting.highlightZoneCluster(this)}selectedItems.push(FlowGraph.node(key))}).classed("selected",true);if(selectedItems.length){$("#flow-graph").addClass("has-selection")}FlowGraphHighlighting.removeHighlights()}function _isZoned(item){return item.id&&item.realId&&item.id!==item.realId}function _isZone(item){return item&&item.nodeType==="ZONE"}function _removeFromSelection(item){const items=_isZoned(item)?selectedItems.filter(it=>it.realId===item.realId):[item];items.forEach(item=>{item.selected=false;const index=selectedItems.indexOf(item);if(index>-1){if(_isZone(item)){d3.select(`g[data-id="${item.id}"]`)[0][0].style=null;FlowGraph.d3ZoneNodeWithId(item.id).classed("selected",false)}else{FlowGraph.d3NodeWithId(item.id).classed("selected",false)}selectedItems.splice(index,1)}});if(!selectedItems.length){$("#flow-graph").removeClass("has-selection")}}function _selectedObjectMixTypes(item){if(selectedItems==0){return false}const itemIsZone=_isZone(item);return!itemIsZone&&_hasOnlyZones()||itemIsZone&&_hasOnlyNonZones()}const defaultSingleSelectionStrategy={onItemClick:function(item){_clearSelection();_addToSelection([item]);if(item.filterRemove){return}FlowGraphHighlighting.highlightPredecessors(item);FlowGraphHighlighting.highlightSuccessors(item);if(!_isZone(item)){FlowGraphHighlighting.highlightUsedZonesForSingleItem(item)}if(_hasOnlyZonesOrNone(item)){FlowGraphHighlighting.highlightZoneElements(item.name)}}};const defaultMultiSelectionStrategy={onItemClick:function(item,evt){if(_selectedObjectMixTypes(item)){return}if(!_isSelected(item)){_addToSelection([item])}else{_removeFromSelection(item)}if(new Set(selectedItems.map(item=>item.realId)).size==1){return selectionStrategies.SINGLE.onItemClick(selectedItems[0],evt)}else{svc.recomputeHighlight()}}};function recomputeHighlight(){FlowGraphHighlighting.removeAllZoneClusterHighlights();FlowGraphHighlighting.removeAllEdgesBetweenZonesHighlights();const zoneList=selectedItems.filter(_isZone).map(it=>it.name);zoneList.forEach(it=>{FlowGraphHighlighting.highlightZoneById(it);FlowGraphHighlighting.highlightZoneElements(it)});const links=d3.selectAll("#flow-graph g");links.filter(function(){const from=d3.select(this).attr("data-from");const to=d3.select(this).attr("data-to");if(from===to)return false;const fromId=from.replace("zone_","");const toId=to.replace("zone_","");return zoneList.includes(fromId)&&zoneList.includes(toId)}).classed("highlight",true);const zoneIdList=selectedItems.filter(_isZoned).map(it=>it.id.toString().split("__")[1]);const zoneIdSet=new Set(zoneIdList);zoneIdSet.forEach(it=>{FlowGraphHighlighting.highlightZoneById(it)})}svc.recomputeHighlight=recomputeHighlight;function withAllPredecessorsOrSuccessorsMultiItemSelectionStrategy(mode){if(mode!="predecessors"&&mode!="successors"){throw new Error("mode should be either 'predecessors' or 'successors'")}return{onItemClick:function(item,evt){const itemsToSelect=this._listPredecessorsOrSuccessors(item).map(FlowGraph.node);_addToSelection(itemsToSelect)},_listPredecessorsOrSuccessors:function(item,list){list=list||[];if(list.includes(item.id)){return list}list.push(item.id);const that=this;if(_isZoned(item)&&!(mode=="predecessors"&&item.usedByZones.length==0)){let zoneNode=FlowGraph.node("zone_"+(item.usedByZones[0]||item.ownerZone));if(zoneNode){$.each(zoneNode[mode],function(index,otherZoneNodeId){const otherNodeId=graphVizEscape(mode=="predecessors"?`zone_${item.ownerZone}`:otherZoneNodeId);const otherNode=FlowGraph.node(otherNodeId+"__"+item.realId);if(otherNode){list=that._listPredecessorsOrSuccessors(otherNode,list)}})}}$.each(item[mode],function(index,otherNodeId){const otherNode=FlowGraph.node(otherNodeId);list=that._listPredecessorsOrSuccessors(otherNode,list)});return list}}}const selectionStrategies={SINGLE:defaultSingleSelectionStrategy,MULTI:defaultMultiSelectionStrategy,MULTI_WITH_SUCCESSORS:withAllPredecessorsOrSuccessorsMultiItemSelectionStrategy("successors"),MULTI_WITH_PREDECESSORS:withAllPredecessorsOrSuccessorsMultiItemSelectionStrategy("predecessors")};let activeSingleSelectionStrategy=selectionStrategies.SINGLE;let activeMultiSelectionStrategy=selectionStrategies.MULTI;this.setSingleSelectionStrategy=strategy=>{activeSingleSelectionStrategy=strategy};this.setMultiSelectionStrategy=strategy=>{activeMultiSelectionStrategy=strategy};this.resetSelectionStrategies=()=>{activeSingleSelectionStrategy=selectionStrategies.SINGLE;activeMultiSelectionStrategy=selectionStrategies.MULTI};this.onRectangularSelection=function(nodeIds){const nodes=FlowGraph.nodes(nodeIds).filter(node=>!node.filterRemove);if(new Set(nodes.map(item=>item.realId)).size===1){activeSingleSelectionStrategy.onItemClick(nodes[0])}else{_clearSelection();_addToSelection(nodes);svc.recomputeHighlight()}d3.selectAll("#flow-graph .node:not(.highlight), #flow-graph .edge:not(.highlight)").classed("fade-out",true);$rootScope.$emit("flowSelectionUpdated");$rootScope.$emit("flowDisplayUpdated")};this.onItemClick=function(item,evt){if(evt&&(evt.shiftKey||evt.metaKey||evt.ctrlKey)){activeMultiSelectionStrategy.onItemClick(item,evt)}else{activeSingleSelectionStrategy.onItemClick(item,evt)}d3.selectAll("#flow-graph .node:not(.highlight), #flow-graph .edge:not(.highlight)").classed("fade-out",true);$rootScope.$emit("flowSelectionUpdated");$rootScope.$emit("flowDisplayUpdated");$rootScope.$emit("flowItemClicked",evt,item)};this.selectNodesFromIds=function(nodeIds){if(!nodeIds||nodeIds.length===0){return}_clearSelection();const nodes=FlowGraph.nodes(nodeIds).filter(node=>angular.isDefined(node));if(nodes.length===1){activeSingleSelectionStrategy.onItemClick(nodes[0])}else{nodes.forEach(item=>{activeMultiSelectionStrategy.onItemClick(item)})}d3.selectAll("#flow-graph .node:not(.highlight), #flow-graph .edge:not(.highlight)").classed("fade-out",true);$rootScope.$emit("flowSelectionUpdated");$rootScope.$emit("flowDisplayUpdated");nodes.forEach(item=>{$rootScope.$emit("flowItemClicked",null,item)})};this.clearSelection=function(){if(selectedItems.length){FlowGraphHighlighting.removeHighlights();_clearSelection();$rootScope.$emit("flowSelectionUpdated");$rootScope.$emit("flowDisplayUpdated")}};this.refreshStyle=function(redoSelection=false){const element=FlowGraph.getDOMElement();if(!element){return}d3.selectAll(element.find("svg .selected")).classed("selected",false);if(selectedItems.length){selectedItems=selectedItems.map(it=>Object.assign({},FlowGraph.node(it.id),{selected:it.selected})).filter(x=>!!x&&x.id);const selector=selectedItems.map(it=>_isZoned(it)?`svg [data-node-id="${it.realId}"]`:_isZone(it)?`svg [id="cluster_${it.id}"]`:`svg [data-id="${it.id}"]`).join(", ");if(selector.length){d3.selectAll(selector).each(function(){const type=this.getAttribute("data-type");if(type==="ZONE"){FlowGraphHighlighting.highlightZoneCluster(this)}}).classed("selected",true)}if(redoSelection){const oldSelection=[...selectedItems.filter(it=>it.selected)];const strategy=oldSelection.length>1?selectionStrategies.MULTI:selectionStrategies.SINGLE;oldSelection.forEach(item=>{strategy.onItemClick(item);if(oldSelection.length>1){strategy.onItemClick(item)}})}}$rootScope.$emit("flowSelectionUpdated")};function select(predicate1){return function(predicate){let toSelect=Object.values(FlowGraph.get().nodes);if(predicate1){toSelect=toSelect.filter(predicate1)}if(predicate){toSelect=toSelect.filter(predicate)}toSelect=toSelect.filter(node=>!FlowGraphFolding.isNodeFolded(node.id));_clearSelection();_addToSelection(toSelect);selectedItems.filter(_isZone).forEach(it=>FlowGraphHighlighting.highlightZoneElements(it.name));$rootScope.$emit("flowSelectionUpdated")}}this.select=select();this.selectAllByType=indexableType=>{select(it=>!it.filterRemove&&TaggableObjectsUtils.getIndexableTypeFromNode(it,it.nodeType)==indexableType)()};this.filterByIndexableType=function(indexableType){const selectedBefore=selectedItems.length;const toRemove=selectedItems.filter(it=>TaggableObjectsUtils.getIndexableTypeFromNode(it,it.nodeType)!=indexableType);toRemove.forEach(_removeFromSelection);const selectedAfter=selectedItems.length;if(selectedAfter!=selectedBefore){$rootScope.$emit("flowSelectionUpdated")}};this.getSelectedNodes=function(){return selectedItems.filter(it=>it.selected)};this.getSelectedTaggableObjectRefs=function(){return svc.getSelectedNodes().map(TaggableObjectsUtils.fromNode)};this.selectSuccessors=function(item,evt){$(".select-preview").removeClass("select-preview");selectionStrategies.MULTI_WITH_SUCCESSORS.onItemClick(item,evt);$rootScope.$emit("flowSelectionUpdated")};this.selectPredecessors=function(item,evt){$(".select-preview").removeClass("select-preview");selectionStrategies.MULTI_WITH_PREDECESSORS.onItemClick(item,evt);$rootScope.$emit("flowSelectionUpdated")};this.hasPredecessorsInOtherZone=function(item){return item.usedByZones.length>0};this.hasSuccessorsInOtherZone=function(item){let hasSuccessors=false;if(_isZoned(item)){let zoneNode=FlowGraph.node("zone_"+item.ownerZone);if(zoneNode){$.each(zoneNode["successors"],function(index,otherZoneNodeId){const otherNode=FlowGraph.node(graphVizEscape(otherZoneNodeId)+"__"+item.realId);if(otherNode){hasSuccessors=true;return false}})}}return hasSuccessors};this.canInsertRecipeBetweenSelection=(selectedNodes,selectedDatasets,selectedRecipes)=>{if(selectedDatasets.length!==1||!selectedRecipes.length||selectedNodes.length!==selectedDatasets.length+selectedRecipes.length)return false;const selectedDataset=selectedDatasets[0];return selectedRecipes.every(recipe=>recipe.predecessors.includes(selectedDataset.id))};this.selectMulti=function(nodes){_clearSelection();_addToSelection(nodes);svc.recomputeHighlight();d3.selectAll("#flow-graph .node:not(.highlight), #flow-graph .edge:not(.highlight)").classed("fade-out",true);$rootScope.$emit("flowSelectionUpdated");$rootScope.$emit("flowDisplayUpdated")}});app.service("FlowGraphHighlighting",function(FlowGraph){function removeHighlights(){d3.selectAll("#flow-graph .highlight, #flow-graph .fade-out").classed("highlight",false).classed("fade-out",false)}function highlightPredecessors(item){let element;let nodeElt;function _highlightPredecessorsRecursive(nodeType,nodeId){nodeElt=FlowGraph.d3NodeWithIdFromType(nodeId,nodeType);if(!nodeElt||!nodeElt.node()){console.debug("Graph node not found",nodeId);return}if(nodeElt.classed("filter-remove")){return}if(!nodeElt.classed("highlight")){nodeElt.classed("highlight",true).classed("fade-out",false);FlowGraph.rawEdgesWithToId(nodeId).forEach(function(elt){d3.select(elt).classed("highlight",true).classed("fade-out",false)});const node=FlowGraph.node(nodeId);if(node.usedByZones&&node.usedByZones.length){const originalNodeId=`zone__${node.ownerZone}__${node.realId}`;_highlightPredecessorsRecursive(nodeType,originalNodeId)}$.each(node.predecessors,function(index,id){_highlightPredecessorsRecursive(nodeType,id)})}}try{element=FlowGraph.getDOMElement();_highlightPredecessorsRecursive(item.nodeType,item.id);d3.selectAll("svg .node:not(.highlight), svg .edge:not(.highlight)").classed("fade-out",true)}catch(e){console.error("Failed to highlight items",nodeElt,e)}}function highlightSuccessors(item){let element;let nodeElt;function _highlightSuccessorsRecursive(nodeType,nodeId,force){nodeElt=FlowGraph.d3NodeWithIdFromType(nodeId,nodeType);if(!nodeElt||!nodeElt.node()){console.debug("Graph node not found",nodeId);return}if(nodeElt.classed("filter-remove")){return}if(force||!nodeElt.classed("highlight")){nodeElt.classed("highlight",true).classed("fade-out",false);FlowGraph.rawEdgesWithFromId(nodeId).forEach(function(elt){d3.select(elt).classed("highlight",true).classed("fade-out",false)});const node=FlowGraph.node(nodeId);const zonesUsingDataset=FlowGraph.nodeSharedBetweenZones(node);if(zonesUsingDataset!=null){zonesUsingDataset.forEach((index,zoneId)=>{const nodeIdForZone=`zone__${zoneId}__${node.realId}`;_highlightSuccessorsRecursive(nodeType,nodeIdForZone,false)})}$.each(node.successors,function(index,successorNodeId){_highlightSuccessorsRecursive(nodeType,successorNodeId,false)})}}try{element=FlowGraph.getDOMElement();_highlightSuccessorsRecursive(item.nodeType,item.id,true);d3.selectAll("svg .node:not(.highlight), svg .edge:not(.highlight)").classed("fade-out",true)}catch(e){console.error("Failed to highlight items",nodeElt,e)}}function highlightZoneElements(zoneId){d3.selectAll(`#flow-graph .node:not(.filter-remove)[data-zone-id="${zoneId}"]`).classed("highlight",true).classed("fade-out",false).each(function(){d3.selectAll(`#flow-graph .edge:not(.filter-remove)[data-to="${this.id}"]`).classed("highlight",true).classed("fade-out",false)})}function addDropFeedbackToZoneElement(zoneId){d3.selectAll(".zone_cluster.clusterDropFeedback").classed("clusterDropFeedback",false);let cluster=d3.select(`g[id="cluster_${zoneId}"]`)[0][0];$(cluster).toggleClass("clusterDropFeedback",true)}function removeDropFeedbackFromZoneElements(){d3.selectAll(".zone_cluster.clusterDropFeedback").classed("clusterDropFeedback",false)}function highlightUsedZonesForSingleItem(item){let zoneIdList=[...FlowGraph.nodeSharedBetweenZones(item)||[],item.ownerZone];zoneIdList.forEach(highlightZoneById);zoneIdList.filter(id=>id!==item.ownerZone).forEach(id=>d3.select(`#flow-graph g[data-to="zone_${id}"][data-from="zone_${item.ownerZone}"]`).classed("highlight",true))}function highlightZoneById(zoneId){const zone="zone_"+zoneId;highlightZoneCluster(d3.select(`#flow-graph g[id="cluster_${zone}"]`).node())}function removeAllZoneClusterHighlights(){d3.selectAll("#flow-graph .zone_cluster.clusterHighlight").classed("clusterHighlight",false).attr("style",null)}function removeAllEdgesBetweenZonesHighlights(){d3.selectAll(`#flow-graph g.edge[data-from^="zone_"]:not([data-from^="zone__"])`).classed("highlight",false)}function highlightZoneCluster(cluster,forcedColor){if(!cluster)return;let node=FlowGraph.node(cluster.getAttribute("data-id"));const color=d3.rgb(forcedColor||node.customData.color);let zoneTitleColor=color.r*.299+color.g*.587+color.b*.114>=128?"#000":"#FFF";$(cluster).toggleClass("clusterHighlight",true);cluster.style=`color:${zoneTitleColor};background-color:${color.toString()};stroke:${color.toString()}`}return{removeHighlights:removeHighlights,highlightPredecessors:highlightPredecessors,highlightSuccessors:highlightSuccessors,highlightZoneElements:highlightZoneElements,highlightUsedZonesForSingleItem:highlightUsedZonesForSingleItem,highlightZoneById:highlightZoneById,highlightZoneCluster:highlightZoneCluster,removeAllZoneClusterHighlights:removeAllZoneClusterHighlights,removeAllEdgesBetweenZonesHighlights:removeAllEdgesBetweenZonesHighlights,addDropFeedbackToZoneElement:addDropFeedbackToZoneElement,removeDropFeedbackFromZoneElements:removeDropFeedbackFromZoneElements}});app.directive("highlightDependenciesOnHover",function($rootScope,$timeout,FlowGraphSelection,FlowGraphHighlighting,FlowGraph){return{link:function(scope,element){let cur=null;const shouldSkipHighlight=event=>{const movingFlow=event.currentTarget.closest("#flow-graph > svg.moving");return movingFlow||FlowGraphSelection.getSelectedNodes().length};element.on("mouseenter","svg [class~=node]",function(e){if(shouldSkipHighlight(e)){return}let node=$(this);if(cur)$timeout.cancel(cur);cur=$timeout(function(){const nodeId=node.attr("data-id");const item=FlowGraph.node(nodeId);if(!item||item.filterRemove){return}FlowGraphHighlighting.highlightPredecessors(item);FlowGraphHighlighting.highlightSuccessors(item);cur=null},100);e.stopPropagation()});element.on("mouseleave","svg [class~=node]",function(e){if(shouldSkipHighlight(e)){return}if(cur)$timeout.cancel(cur);FlowGraphHighlighting.removeHighlights()})}}})})();(function(){"use strict";const app=angular.module("dataiku.flow.project");const FoldDirections={predecessors:"predecessors",successors:"successors",getOpposite(val){return val==this.predecessors?this.successors:this.predecessors}};const FoldActions={fold:"fold",unfold:"unfold"};app.service("FlowGraphFolding",function($rootScope,WT1,TaggableObjectsUtils,FlowGraph,FlowGraphHighlighting,GraphZoomTrackerService,$timeout,LoggerProvider){const Logger=LoggerProvider.getLogger("FlowGraphFolding");const svc=this;let foldedNodeCount=0;let activeFoldDomStatus;const FoldDomStatusMapIdx={node:0,edge:1,nestedBoundaryEdge:2,boundaryEdge:3};function getSelectorByIdFromList(list){const sel=list.map(id=>`svg [id="${id}"]`).join(", ");return sel==""?[]:sel}let FoldDomStatus=function(){return{maps:[{},{},{},{}],updateStatusList:function(newIdsList,mapIdx){const existingItemsMap=this.maps[mapIdx];newIdsList.forEach(id=>{existingItemsMap[id]=true});let newItemsMap={};let deactivateList=[];Object.keys(existingItemsMap).forEach(id=>{if(existingItemsMap[id]){newItemsMap[id]=false}else{deactivateList.push(id)}});this.maps[mapIdx]=newItemsMap;return deactivateList},update:function(listofListOfIds){const unFoldInfo=[];listofListOfIds.forEach((list,i)=>unFoldInfo.push(this.updateStatusList(list,i)));return unFoldInfo},previewStatusList:function(newIdsList,mapIdx){const existingItemsMap=this.maps[mapIdx];const differencesMap=angular.copy(existingItemsMap);newIdsList.forEach(id=>{if(differencesMap.hasOwnProperty(id)){differencesMap[id]=true}else{differencesMap[id]=false}});let differencesList=[];Object.keys(differencesMap).forEach(id=>{if(!differencesMap[id]){differencesList.push(id)}});return differencesList},getPreviewItems:function(listofListOfIds){const itemsToActivate=[];listofListOfIds.forEach((list,i)=>itemsToActivate.push(this.previewStatusList(list,i)));return itemsToActivate}}};let FoldReqst=function(rootItem,direction,isUseCssTransitions){return{direction:direction,rootItem:rootItem,idsToRemainShownList:[],nodeIdMap:{},nodeEls:[],edgeEls:[],edgeIdMap:{},branchEdgeIdMap:{},boundaryEdges:[],boundaryEdgeMap:{},boundaryEdgeMapByNode:{},nestedBoundaryEdgeIds:[],nestedBoundaryEdgeIdMap:{},isUseCssTransitions:isUseCssTransitions,copyFoldStateData:function(from,to){["nodeIdMap","edgeIdMap","branchEdgeIdMap","boundaryEdgeMap","boundaryEdgeMapByNode","nestedBoundaryEdgeIdMap"].forEach(key=>{to[key]=Object.assign({},from[key])});["nodeEls","edgeEls","boundaryEdges","nestedBoundaryEdgeIds"].forEach(key=>{to[key]=from[key].slice()});return to},backupFoldState:function(){this.foldStateBackup=this.copyFoldStateData(this,{})},restoreFoldState:function(){this.copyFoldStateData(this.foldStateBackup,this)},getRootNode:function(){return FlowGraph.rawNodeWithId(this.rootItem.Id)},getBoundaryEdgeDescr:function(edgeId){return this.boundaryEdgeMap.hasOwnProperty(edgeId)?this.boundaryEdgeMap[edgeId]:undefined},getBoundaryEdges:function(){return this.boundaryEdges.map(it=>it.el)},getNestedBoundaryEdgesSelector:function(){return getSelectorByIdFromList(this.nestedBoundaryEdgeIds)},isNodeFolded:function(nodeId){return this.nodeIdMap.hasOwnProperty(nodeId)},isEdgeFolded:function(edgeId){return this.edgeIdMap.hasOwnProperty(edgeId)},isBoundaryEdge:function(edgeId){return this.boundaryEdgeMap.hasOwnProperty(edgeId)},addNode:function(el,item){if(this.nodeIdMap[el.id])return;this.idsToRemainShownList.forEach(idToRemainShown=>{if(idToRemainShown==item.id){this.isItemToRemainShownWillBeHidden=true}});this.nodeEls.push(el);this.nodeIdMap[item.id]=item},addEdge:function(el,isMainBranch){if(this.edgeIdMap[el.id])return;this.edgeEls.push(el);this.edgeIdMap[el.id]=el;if(isMainBranch)this.branchEdgeIdMap[el.id]=el},addBoundaryEdge:function(newEdgeDescr){const mapKey=newEdgeDescr.boundaryNodeId+this.rootItem.id+this.direction;if(this.boundaryEdgeMapByNode.hasOwnProperty(mapKey))return;newEdgeDescr.rootItemId=this.rootItem.id;newEdgeDescr.direction=this.direction;this.boundaryEdgeMap[newEdgeDescr.el.id]=newEdgeDescr;this.boundaryEdgeMapByNode[mapKey]=newEdgeDescr;this.boundaryEdges.push(newEdgeDescr);this.addEdge(newEdgeDescr.el)},addNestedBoundaryEdge:function(edge){if(this.nestedBoundaryEdgeIds.hasOwnProperty(edge.id))return;this.nestedBoundaryEdgeIds.push(edge.id);this.nestedBoundaryEdgeIdMap[edge.id]=edge},isEdgeNeedsProcessing:function(edge){return!this.edgeIdMap[edge.id]}}};const FoldCommand=function(nodeId,direction,action){return{nodeId:nodeId,direction:direction,action:action}};const lineAnalyser={addXyDeltasToLineInfo:function(lineInfo){lineInfo.dX=lineInfo.endPoint.x-lineInfo.ctlPoint.x;lineInfo.dY=lineInfo.endPoint.y-lineInfo.ctlPoint.y;return lineInfo},addTrigToLineInfo:function(lineInfo){this.addXyDeltasToLineInfo(lineInfo);lineInfo.hypot=Math.sqrt(Math.pow(lineInfo.dX,2)+Math.pow(lineInfo.dY,2));lineInfo.angle=Math.asin(lineInfo.dY/lineInfo.hypot);return lineInfo},findIconCentre:function(lineInfo,distXFromEnd){const scalingFactor=distXFromEnd/lineInfo.hypot;return{x:lineInfo.endPoint.x-lineInfo.dX*scalingFactor,y:lineInfo.endPoint.y-lineInfo.dY*scalingFactor}},extendEndPoint:function(lineInfo,extendBy){lineInfo.endPoint.x=lineInfo.endPoint.x+extendBy*Math.cos(lineInfo.angle);lineInfo.endPoint.y=lineInfo.endPoint.y+extendBy*Math.sin(lineInfo.angle);return lineInfo},extractFoldingInfoFromEdgePath:function(el,direction){let info={};const dAttr=el.firstElementChild.getAttribute("d");let tokens=dAttr.split(/[ MC]/);if(tokens.length<2)return undefined;function buildCoord(s){const tokens=s.split(",");return tokens.length>1?{x:parseInt(tokens[0],10),y:parseInt(tokens[1],10)}:undefined}if(direction==FoldDirections.successors)info={endPoint:buildCoord(tokens[1]),ctlPoint:buildCoord(tokens[2])};else info={endPoint:buildCoord(tokens.pop()),ctlPoint:buildCoord(tokens.pop())};return this.addTrigToLineInfo(info)},initBoundaryEdgeData:function(el,direction){const distPlusIconFromEnd=60;const arrowTipWidth=5;let info=this.extractFoldingInfoFromEdgePath(el,direction);if(direction!=FoldDirections.successors)info=this.extendEndPoint(info,arrowTipWidth);info.iconCentre=this.findIconCentre(info,distPlusIconFromEnd);return info},getEdgeLineAngleForEl:function(el,direction){let info=this.extractFoldingInfoFromEdgePath(el,direction);return info.angle<0?-info.angle:info.angle}};function applyPreviewCssChangesToDom(previewItemsInfo,previewClass){d3.selectAll(previewItemsInfo[FoldDomStatusMapIdx.node].map(id=>FlowGraph.rawNodeWithId(id))).classed(previewClass,true);[FoldDomStatusMapIdx.edge,FoldDomStatusMapIdx.nestedBoundaryEdge].forEach(i=>d3.selectAll(getSelectorByIdFromList(previewItemsInfo[i])).classed(previewClass,true))}function removeAllPreviewStyling(){$(".fold-preview").removeClass("fold-preview");$(".unfold-preview").removeClass("unfold-preview");$(".select-preview").removeClass("select-preview")}function applyPreviewFoldReqstToDom(previewFoldReqst,previewClass){const itemsToPreview=activeFoldDomStatus.getPreviewItems([previewFoldReqst.nodeEls.map(el=>el.getAttribute("data-id")),previewFoldReqst.edgeEls.map(el=>el.id),previewFoldReqst.nestedBoundaryEdgeIds]);applyPreviewCssChangesToDom(itemsToPreview,previewClass)}function reShowFoldedDomItems(itemsToReShow){d3.selectAll(itemsToReShow[FoldDomStatusMapIdx.node].map(id=>FlowGraph.rawNodeWithId(id))).classed("folded-node",false);d3.selectAll(getSelectorByIdFromList(itemsToReShow[FoldDomStatusMapIdx.edge])).classed("folded-edge",false);d3.selectAll(getSelectorByIdFromList(itemsToReShow[FoldDomStatusMapIdx.nestedBoundaryEdge])).classed("folded-nested",false);d3.selectAll(getSelectorByIdFromList(itemsToReShow[FoldDomStatusMapIdx.boundaryEdge])).classed("folded-boundary-edge",false).attr("data-folded-boundary-node-id",null).select("g.folded-icon").remove()}function applyFoldReqstToDom(foldReqst){const radiusPlusIcon=16;const lenPlusArm=11;if(!activeFoldDomStatus)activeFoldDomStatus=new FoldDomStatus;removeAllPreviewStyling();d3.selectAll(foldReqst.nodeEls).classed("folded-node",true).classed("fold-transition",foldReqst.isUseCssTransitions);d3.selectAll(foldReqst.edgeEls).classed("folded-edge",true).classed("fold-transition",foldReqst.isUseCssTransitions);d3.selectAll(foldReqst.getNestedBoundaryEdgesSelector()).classed("folded-nested",true).classed("fold-transition",foldReqst.isUseCssTransitions);let boundaryEdges=foldReqst.boundaryEdges.map(item=>{item.data=lineAnalyser.initBoundaryEdgeData(item.el,item.direction);return item});let boundaryEdgesSelectionNew=d3.selectAll(foldReqst.getBoundaryEdges()).filter(":not(.folded-boundary-edge)").data(boundaryEdges,function(d){return d?d.el.id:this.id});let boundaryEdgesSelectionExisting=d3.selectAll(foldReqst.getBoundaryEdges()).filter(".folded-boundary-edge").data(boundaryEdges,function(d){return d?d.el.id:this.id});boundaryEdgesSelectionNew.classed("folded-boundary-edge",true).attr("data-folded-boundary-node-id",d=>d.boundaryNodeId);boundaryEdgesSelectionExisting.select("g.folded-icon").attr("data-folded-node-id",d=>d.rootItemId).attr("data-folded-direction",d=>d.direction).attr("data-folded-hidden-node-id",d=>d.hiddenNodeId);const boundaryEdgeMarker=boundaryEdgesSelectionNew.append("g").classed("folded-icon",true).attr("data-folded-node-id",d=>d.rootItemId).attr("data-folded-direction",d=>d.direction).attr("data-folded-hidden-node-id",d=>d.hiddenNodeId);const drawLine=d3.svg.line().x(function(d){return d.x}).y(function(d){return d.y}).interpolate("linear");boundaryEdgeMarker.append("path").attr("d",d=>drawLine([d.data.iconCentre,d.data.endPoint])).attr("stroke","#000000").attr("fill","none").classed("folded-boundary-marker-line",true);const boundaryEdgeMarkerIconG=boundaryEdgeMarker.append("g").attr("transform",d=>{return"translate("+d.data.iconCentre.x+","+d.data.iconCentre.y+")"});boundaryEdgeMarkerIconG.append("circle").attr("cx",0).attr("cy",0).attr("r",radiusPlusIcon).attr("class","folded-boundary-marker-circle").on("mouseover",d=>{const elG=$(d.el).find("g.folded-icon");return svc.previewUnfold(FlowGraph.node(elG.attr("data-folded-node-id")),elG.attr("data-folded-direction"),elG.attr("data-folded-hidden-node-id"))}).on("mouseleave",d=>svc.endPreviewBranch());boundaryEdgeMarkerIconG.append("path").attr("d",`M0,-${lenPlusArm} V${lenPlusArm} M-${lenPlusArm},0 H${lenPlusArm}`).attr("stroke","#000000").attr("fill","none").classed("folded-boundary-marker-plus",true);const itemsToReShow=activeFoldDomStatus.update([foldReqst.nodeEls.map(el=>el.getAttribute("data-id")),foldReqst.edgeEls.map(el=>el.id),foldReqst.nestedBoundaryEdgeIds,foldReqst.boundaryEdges.map(item=>item.el.id)]);reShowFoldedDomItems(itemsToReShow);$timeout(_=>{$(".fold-transition").removeClass("fold-transition")},2e3)}function getFuncEdgesAwayFromRoot(direction){return direction==FoldDirections.successors?FlowGraph.rawEdgesWithFromId:FlowGraph.rawEdgesWithToId}function getFuncEdgesTowardRoot(direction){return direction==FoldDirections.successors?FlowGraph.rawEdgesWithToId:FlowGraph.rawEdgesWithFromId}function isEdgeSuitableAsBoundaryMarker(foldReqst,edge){const existingDescr=foldReqst.getBoundaryEdgeDescr(edge.id);return!existingDescr||existingDescr.rootItemId==foldReqst.rootItem.id}function getDirectionForEdgeEl(foldReqst,edge){const existingDescr=foldReqst.getBoundaryEdgeDescr(edge.id);return existingDescr?existingDescr.direction:undefined}function updateMostLevelEdge(edge,mostLevelEdge,direction){edge.angle=lineAnalyser.getEdgeLineAngleForEl(edge,direction);if(!mostLevelEdge||mostLevelEdge.angle>edge.angle){mostLevelEdge=edge}return mostLevelEdge}function buildFoldReqst(foldReqst,item,idsToRemainShownList){let isRootItem=false;if(typeof item==="undefined"){item=foldReqst.rootItem;isRootItem=true}foldReqst.idsToRemainShownList=idsToRemainShownList||[];let inValidContext=!item||!item.id;inValidContext=inValidContext||foldReqst.nodeIdMap&&foldReqst.nodeIdMap.hasOwnProperty(item.id);inValidContext=inValidContext||!isRootItem&&foldReqst.rootItem.id==item.id;if(inValidContext){return foldReqst}const fEdgesAwayFromRoot=getFuncEdgesAwayFromRoot(foldReqst.direction);const fEdgesTowardRoot=getFuncEdgesTowardRoot(foldReqst.direction);const boundaryEdgeNodeAttr="data-"+(foldReqst.direction==FoldDirections.successors?"from":"to");const boundaryEdgeHiddenNodeAttr="data-"+(foldReqst.direction==FoldDirections.successors?"to":"from");const oppositeDirection=FoldDirections.getOpposite(foldReqst.direction);if(isRootItem){const rootEdgesArray=fEdgesAwayFromRoot(foldReqst.rootItem.id);let mostLevelEdge;foldReqst.isChangeMadeForCommand=false;rootEdgesArray.forEach(edge=>{if(foldReqst.isEdgeNeedsProcessing(edge)){foldReqst.isChangeMadeForCommand=true;foldReqst.addEdge(edge);if(isEdgeSuitableAsBoundaryMarker(foldReqst,edge)){mostLevelEdge=updateMostLevelEdge(edge,mostLevelEdge,foldReqst.direction)}}});if(mostLevelEdge){foldReqst.addBoundaryEdge({el:mostLevelEdge,data:{},boundaryNodeId:foldReqst.rootItem.id,hiddenNodeId:mostLevelEdge.getAttribute(boundaryEdgeHiddenNodeAttr)})}}else{foldReqst.addNode(FlowGraph.rawNodeWithId(item.id),item);fEdgesTowardRoot(item.id).forEach(edge=>{const remoteNodeId=edge.getAttribute(boundaryEdgeNodeAttr);const isBoundaryMarkerForNodeAlreadyBeingAdded=foldReqst.boundaryEdges.find(boundaryEdge=>boundaryEdge.el.id!=edge.id&&boundaryEdge.boundaryNodeId==remoteNodeId&&boundaryEdge.direction==foldReqst.direction);if(!isBoundaryMarkerForNodeAlreadyBeingAdded){if(getDirectionForEdgeEl(foldReqst,edge)==oppositeDirection){foldReqst.addNestedBoundaryEdge(edge)}if(!foldReqst.isEdgeFolded(edge.id)){foldReqst.addBoundaryEdge({el:edge,data:{},boundaryNodeId:remoteNodeId,hiddenNodeId:item.id})}}else{foldReqst.addEdge(edge)}});let isItemFolded=foldReqst.isNodeFolded(item.id);fEdgesAwayFromRoot(item.id).forEach(edge=>{if(foldReqst.isBoundaryEdge(edge.id)||isItemFolded){foldReqst.addNestedBoundaryEdge(edge)}foldReqst.addEdge(edge,true)})}$.each(item[foldReqst.direction],function(index,otherNodeId){if(!foldReqst.isNodeFolded(otherNodeId)){const otherNode=FlowGraph.node(otherNodeId);if(otherNode)foldReqst=buildFoldReqst(foldReqst,otherNode,idsToRemainShownList)}});foldReqst.boundaryEdges=foldReqst.boundaryEdges.filter(item=>!foldReqst.branchEdgeIdMap.hasOwnProperty(item.el.id));return foldReqst}function tidyFoldState(foldReqst){const allFoldedNodes=$(".folded-node");foldedNodeCount=allFoldedNodes.length;if(foldedNodeCount==0){GraphZoomTrackerService.resetFoldState()}else if(foldReqst&&!foldReqst.isChangeMadeForCommand){GraphZoomTrackerService.removeLastFoldCommand()}}function cleanRestoreState(commands){let origLen=commands.length;commands=commands.filter(cmd=>!!FlowGraph.node(cmd.nodeId));if(origLen!=commands.length){GraphZoomTrackerService.resetFoldState(commands)}return commands}function applyFoldCommandToReqst(foldReqst,foldCommand,idsToRemainShownList){const rootItem=FlowGraph.node(foldCommand.nodeId);foldReqst.rootItem=rootItem;foldReqst.direction=foldCommand.direction;foldReqst.action=foldCommand.action;foldReqst.isItemToRemainShownWillBeHidden=false;return buildFoldReqst(foldReqst,undefined,idsToRemainShownList)}function buildFoldReqstForCompleteState(commands,isInteractiveReqst,idsToRemainShownList){let foldReqst=new FoldReqst(null,FoldDirections.successors,isInteractiveReqst);let foldCmdsApplied=[];let isCmdSkipped=false;cleanRestoreState(commands).forEach(cmd=>{foldReqst.backupFoldState();foldReqst=applyFoldCommandToReqst(foldReqst,cmd,idsToRemainShownList);if(foldReqst.isItemToRemainShownWillBeHidden){foldReqst.restoreFoldState();isCmdSkipped=true}else{foldCmdsApplied.push(cmd)}});if(isCmdSkipped)foldReqst.revisedFoldCmds=foldCmdsApplied;return foldReqst}function applyFoldState(commands,isInteractiveReqst,idsToRemainShownList){const foldReqst=buildFoldReqstForCompleteState(commands,isInteractiveReqst,idsToRemainShownList);applyFoldReqstToDom(foldReqst);$rootScope.$emit("flowSelectionUpdated");if(foldReqst.revisedFoldCmds)GraphZoomTrackerService.resetFoldState(foldReqst.revisedFoldCmds);tidyFoldState(foldReqst)}function foldMultiItems(rootItem,direction,action,idsToRemainShownList){trackFoldCommand(rootItem.id,direction,action);applyFoldState(GraphZoomTrackerService.getFoldState(),true,idsToRemainShownList)}function trackFoldCommand(nodeId,direction,action){Logger.debug(action.toString().toUpperCase()+" - "+direction.toUpperCase()+" "+nodeId);GraphZoomTrackerService.setFoldCommand(new FoldCommand(nodeId,direction,action))}let foldStateRestored=false;$rootScope.$on("graphRendered",function(){foldStateRestored=false});this.unfoldNode=function(unFoldEl){const nodeId=unFoldEl.getAttribute("data-folded-node-id");const direction=unFoldEl.getAttribute("data-folded-direction");const idMustBeShown=unFoldEl.getAttribute("data-folded-hidden-node-id");foldMultiItems(FlowGraph.node(nodeId),direction,FoldActions.unfold,[idMustBeShown,nodeId])};this.foldSuccessors=function(item){foldMultiItems(item,FoldDirections.successors,FoldActions.fold)};this.foldPredecessors=function(item){foldMultiItems(item,FoldDirections.predecessors,FoldActions.fold)};this.previewSelect=function(item,direction){const previewSelectReqst=buildFoldReqst(new FoldReqst(item,direction,true));if(previewSelectReqst)applyPreviewFoldReqstToDom(previewSelectReqst,"select-preview")};function previewFoldOrUnfoldAction(item,direction,action,idsMustRemainShownList){const previewFoldState=GraphZoomTrackerService.getPreviewFoldState(new FoldCommand(item.id,direction,action));const previewFoldReqst=buildFoldReqstForCompleteState(previewFoldState,true,idsMustRemainShownList);if(previewFoldReqst)applyPreviewFoldReqstToDom(previewFoldReqst,action+"-preview")}this.previewFold=function(item,direction){previewFoldOrUnfoldAction(item,direction,FoldActions.fold)};this.previewUnfold=function(item,direction,idsMustRemainShownList){previewFoldOrUnfoldAction(item,direction,FoldActions.unfold,[idsMustRemainShownList,item.id])};this.endPreviewBranch=function(){removeAllPreviewStyling()};this.restoreState=function(commands){if(!foldStateRestored&&commands){applyFoldState(commands,false);foldStateRestored=true}};this.clearFoldState=function(){GraphZoomTrackerService.resetFoldState();foldStateRestored=false};this.unfoldAll=function(){GraphZoomTrackerService.resetFoldState();$rootScope.$emit("drawGraph",true);tidyFoldState()};this.ensureNodesNotFolded=function(idsToRemainShownList){applyFoldState(GraphZoomTrackerService.getFoldState(),true,idsToRemainShownList)};this.isNodeFolded=function(nodeId){return activeFoldDomStatus&&activeFoldDomStatus.maps[FoldDomStatusMapIdx.node].hasOwnProperty(nodeId)};this.getFoldedNodeCount=function(){return foldedNodeCount}})})();(function(){"use strict";var app=angular.module("dataiku.flow.project");app.directive("flowSearchPopover",function($stateParams,$rootScope,ContextualMenu,ListFilter,DataikuAPI,StateUtils,FlowGraphSelection){return{restrict:"A",scope:true,templateUrl:"/templates/flow-editor/search-popover.html",link:function($scope,element,attrs){function hide(){element.hide();$("html").unbind("click",hide);shown=false;$scope.shown=false}function show(){shown=true;$scope.shown=true;$(".flow-search-popover",element).css("left",$("#flow-search-input input").offset().left);$(element).show();element.off("click.dku-pop-over").on("click.dku-pop-over",function(e){if($(e.target).parents(".directlink").length)return;e.stopPropagation()});$("#flow-search-input").off("click.dku-pop-over").on("click.dku-pop-over",function(e){e.stopPropagation()});window.setTimeout(function(){$("html").on("click.dku-pop-over",hide)},0)}$scope.pommef=function(){$("#flow-search-input").focus()};$scope.hidePopover=function(){if(shown){hide()}};var shown=false;$(element).hide();$scope.$on("$destroy",function(){$("html").off("click.dku-pop-over",hide)});$scope.$watch("flowSearch.pattern",function(nv,ov){if(shown&&(!nv||nv.length===0)){hide()}if(!shown&&nv&&nv.length>0){show()}});$("#flow-search-input input").on("focus",function(){if(!shown&&$scope.flowSearch&&$scope.flowSearch.pattern.length){show()}});$scope.$watch("flowSearch.pattern",function(){$scope.onFlowSearchQueryChange()});var extraneous=[];var formerPattern;function isInZone(node,zoneId){if(!zoneId){return true}return node.id.startsWith(`zone__${zoneId}`)}const isInOwnerZone=node=>node&&node.ownerZone&&node.ownerZone!==""&&node.id.startsWith("zone")&&node.id.startsWith(`zone__${node.ownerZone}__`);const getNode=(realId,nodes,zoneId)=>{let node=nodes[realId];if(node){return node}for(let key in nodes){node=nodes[key];if(node.realId===realId&&(!zoneId?isInOwnerZone(node):isInZone(node,zoneId))){return node}}return undefined};$scope.onFlowSearchQueryChange=function(){if(!$scope.flowSearch)return;function getDatasets(){if(!filteredDatasets)return[];var results=ListFilter.filter(filteredDatasets.items,$scope.flowSearch.pattern);$.map(results,function(item){item.nodeType="LOCAL_DATASET";const potentialId=graphVizEscape("dataset_"+item.projectKey+"."+item.name);const foundNode=getNode(potentialId,$scope.nodesGraph.nodes,$stateParams.zoneId);item.id=foundNode?foundNode.id:potentialId});results=results.filter(node=>isInZone(node,$stateParams.zoneId));results=results.concat(getItemsFromGraph("FOREIGN_DATASET"));return results}function getItemsFromGraph(type){if(!$scope.nodesGraph)return[];var result=[];for(var key in $scope.nodesGraph.nodes){const node=$scope.nodesGraph.nodes[key];if(node.nodeType.endsWith(type)&&isInZone(node,$stateParams.zoneId)){if(isInOwnerZone(node,$stateParams.zoneId)||node.ownerZone===undefined){result.push(node)}}}return ListFilter.filter(result,$scope.flowSearch.pattern)}if(formerPattern!=$scope.flowSearch.pattern){formerPattern=$scope.flowSearch.pattern;const datasets=getDatasets(),labelingTasks=getItemsFromGraph("LABELING_TASK"),recipes=getItemsFromGraph("RECIPE"),folders=getItemsFromGraph("FOLDER"),models=getItemsFromGraph("MODEL"),mes=getItemsFromGraph("MODELEVALUATIONSTORE"),gaes=getItemsFromGraph("GENAIEVALUATIONSTORE"),zones=getItemsFromGraph("ZONE").map(item=>Object.assign(item,{zoneId:item.id.split("_").splice(1).join("")}));$scope.flowSearch.nbDatasets=datasets.length;$scope.flowSearch.nbRecipes=recipes.length;$scope.flowSearch.nbFolders=folders.length;$scope.flowSearch.nbModels=models.length;$scope.flowSearch.nbLabelingTasks=labelingTasks.length;$scope.flowSearch.nbMes=mes.length;$scope.flowSearch.nbGaes=gaes.length;$scope.flowSearch.items=datasets.concat(recipes).concat(folders).concat(models).concat(mes).concat(zones).concat(labelingTasks).sort(function(a,b){var aIsGood=a.name.startsWith($scope.flowSearch.pattern.toLowerCase())?"0":"1";var bIsGood=b.name.startsWith($scope.flowSearch.pattern.toLowerCase())?"0":"1";return(aIsGood+a.name).localeCompare(bIsGood+b.name)})}$scope.flowSearch.index=-1;$scope.currentlyDisplayedItems=20};$scope.currentlyDisplayedItems=20;$scope.loadMoreItems=function(){$scope.currentlyDisplayedItems+=20};let filteredDatasets;DataikuAPI.datasets.listHeads($stateParams.projectKey,$rootScope.tagFilter||{},false).success(function(data){filteredDatasets=data}).error(setErrorInScope.bind($scope));$scope.flowSearchSelectPrevious=function($event){if(!shown||!$scope.flowSearch.items.length){return}$scope.flowSearchSelectIndex(Math.max(0,$scope.flowSearch.index-1));if($event)$event.stopPropagation();const el=$("li",element)[$scope.flowSearch.index];if(el){const parent=$("ul",element).parent();ensureVisible(el,parent)}};$scope.flowSearchSelectNext=function($event){if(!shown||!$scope.flowSearch.items.length){return}$scope.flowSearchSelectIndex(Math.min($scope.flowSearch.items.length-1,$scope.flowSearch.index+1));if($event)$event.stopPropagation();const el=$("li",element)[$scope.flowSearch.index];if(el){const parent=$("ul",element).parent();ensureVisible(el,parent)}};$scope.flowSearchSelectIndex=function(index){if(!shown)return;if(!$scope.nodesGraph||!$scope.nodesGraph.nodes)return;$scope.flowSearch.index=index;const item=$scope.flowSearch.items[$scope.flowSearch.index];const id=item.id;FlowGraphSelection.clearSelection($scope.nodesGraph.nodes[id]);FlowGraphSelection.onItemClick($scope.nodesGraph.nodes[id],null);$scope.zoomGraph(id,item.nodeType=="RECIPE"?5:3,item)};$scope.flowSearchGo=function(){if(!shown)return;if($scope.flowSearch.index<0){return}if($scope.flowSearch.items.length){var item=$scope.flowSearch.items[$scope.flowSearch.index];StateUtils.go.node(item);$scope.flowSearch.pattern="";hide();$("#flow-search-input").blur()}};$scope.contextMenu=function(idx,$event){var x=$event.pageX;var y=$event.pageY;var newScope=$scope.$new();var item=$scope.flowSearch.items[idx];newScope.object=angular.copy(item);var menuParams={scope:newScope,template:"/templates/flow-editor/dataset-contextual-menu.html"};var menu=new ContextualMenu(menuParams);menu.openAtXY(x,y)};$scope.onFlowSearchQueryChange()}}})})();(function(){"use strict";var app=angular.module("dataiku.flow.project");app.directive("flowPreview",function($rootScope,$timeout,$stateParams,translate,FlowGraphSelection,Logger){return{restrict:"AE",scope:true,templateUrl:"/templates/flow-editor/flow-preview.html",controller:function($scope,WT1){$scope.previewContextProjectKey=$stateParams.projectKey;updatePreview();const deregisterFlowSelectionUpdated=$rootScope.$on("flowSelectionUpdated",()=>{const selectedNodes=FlowGraphSelection.getSelectedNodes();if(selectedNodes&&selectedNodes.length===1&&selectedNodes[0]&&$scope.previewProjectKey&&$scope.previewDatasetName&&selectedNodes[0].projectKey===$scope.previewProjectKey&&selectedNodes[0].name===$scope.previewDatasetName){return}$scope.showPreviewTable=false;$timeout(updatePreview)});$scope.$on("$destroy",deregisterFlowSelectionUpdated);$scope.$watch("hasPreview",updatePreview);$scope.reloadPreview=()=>{$scope.$broadcast("refresh-preview-table-without-cache")};function updatePreview(){if(!$scope.hasPreview)return;const selectedNodes=FlowGraphSelection.getSelectedNodes();let problem,solution;if(selectedNodes.length===0){problem=translate("PROJECT.FLOW.PREVIEW.NO_DATESET_SELECTED","No dataset selected");solution=translate("PROJECT.FLOW.PREVIEW.CLICK_DATASET_TO_PREVIEW","Click a dataset to preview its content")}else if(selectedNodes.length>1){problem=translate("PROJECT.FLOW.PREVIEW.MULTIPLE_ITEMS_SELECTED","Multiple items selected");solution=translate("PROJECT.FLOW.PREVIEW.CLICK_SINGLE_DATASET_TO_PREVIEW","Click a single dataset to preview its content")}else if(selectedNodes[0].nodeType&&!selectedNodes[0].nodeType.includes("DATASET")){problem=translate("PROJECT.FLOW.PREVIEW.NOT_DATASET_SELECTED","Selected item is not a dataset");solution=translate("PROJECT.FLOW.PREVIEW.CLICK_DATASET_TO_PREVIEW","Click a dataset to preview its content")}else if(selectedNodes[0].datasetType==="hiveserver2"){problem=translate("PROJECT.FLOW.PREVIEW.HIVE_NOT_SUPPORTED","Preview is not supported for Hive tables");solution=""}else if(selectedNodes[0].neverBuilt){problem=translate("PROJECT.FLOW.PREVIEW.DATASET_NOT_BUILT","Selected dataset is not built");solution=translate("PROJECT.FLOW.PREVIEW.CLICK_BUILT_DATASET_TO_PREVIEW","Click a built dataset to preview its content")}if(!problem&&!solution){$scope.previewProjectKey=selectedNodes[0].projectKey;$scope.previewDatasetName=selectedNodes[0].name;$scope.showPreviewTable=true;$scope.previewProblem=null;$scope.previewSolution=null;try{if(selectedNodes[0]){WT1.event("flow-preview-update",{nodeType:selectedNodes[0].nodeType,datasetType:selectedNodes[0].datasetType})}}catch(e){Logger.error("Failed to report flow dataset preview event",e)}}else{$scope.previewProjectKey=null;$scope.previewDatasetName=null;$scope.previewProblem=problem;$scope.previewSolution=solution}}}}})})();(function(){"use strict";angular.module("dataiku.flow.graph").factory("PageSpecificTourService",pageSpecificTourService);function pageSpecificTourService($rootScope,$timeout,translate,$filter,FlowGraphSelection,Dialogs,ContextualMenu,TopbarDrawersService,TOPBAR_DRAWER_IDS,WT1,QuestionnaireService,OpalsService,DataikuAPI,ProfileService){const BUILT_DATASET_SELECTOR='g[data-type="LOCAL_DATASET"] > g:not(.never-built-computable)';const TOUR_NAMES={FLOW:"flow",TUTORIAL:"tutorial",EXPLORE:"explore",PREPARE:"prepare"};function getTourCompletionSetting(tourName){switch(tourName){case TOUR_NAMES.FLOW:case TOUR_NAMES.TUTORIAL:return $rootScope.appConfig?.pageSpecificTourSettings?.flowTourCompleted;case TOUR_NAMES.EXPLORE:return $rootScope.appConfig?.pageSpecificTourSettings?.exploreTourCompleted;case TOUR_NAMES.PREPARE:return $rootScope.appConfig?.pageSpecificTourSettings?.prepareTourCompleted}}function setTourCompletionSetting(tourName,value){switch(tourName){case TOUR_NAMES.FLOW:case TOUR_NAMES.TUTORIAL:$rootScope.appConfig.pageSpecificTourSettings.flowTourCompleted=value;break;case TOUR_NAMES.EXPLORE:$rootScope.appConfig.pageSpecificTourSettings.exploreTourCompleted=value;break;case TOUR_NAMES.PREPARE:$rootScope.appConfig.pageSpecificTourSettings.prepareTourCompleted=value;break}}function checkFlowTourConditions(fromContext){if(!canStartFlowTour()){return Promise.resolve(false)}return checkContextAllowTour(TOUR_NAMES.FLOW,fromContext)}function startFlowTour({scope,fromContext}){return checkFlowTourConditions(fromContext).then(tourNeedToStart=>{if(!tourNeedToStart){return}TopbarDrawersService.getDrawer(TOPBAR_DRAWER_IDS.OPALS_HELP).hide(true);const isFromQuestionnaire=QuestionnaireService.isFromQuestionnaire();const tourName=isFromQuestionnaire?TOUR_NAMES.TUTORIAL:TOUR_NAMES.FLOW;const introJSInstance=initialTourSetup(scope,tourName,fromContext);const builtDatasets=$(BUILT_DATASET_SELECTOR);const builtDataset=builtDatasets[0].parentNode;let builtDatasetNodeId=builtDataset.id;const commonSteps=[{title:translate("PAGE_SPECIFIC_TOUR.FLOW.DATASET.TITLE","Everything in Dataiku begins with data"),intro:translate("PAGE_SPECIFIC_TOUR.FLOW.DATASET.DESCRIPTION","Datasets are always represented as blue squares on the Flow."),beforeChange:function(){hideHighlightDuringTransition(introJSInstance,400);this.element=document.querySelector(BUILT_DATASET_SELECTOR);this.position="right";scope.zoomGraph(builtDatasetNodeId,5);FlowGraphSelection.onItemClick(scope.nodesGraph.nodes[builtDatasetNodeId]);if(scope.standardizedSidePanel.opened){scope.standardizedSidePanel.toggleTab("actions")}}},{title:translate("PAGE_SPECIFIC_TOUR.FLOW.RIGHT_PANEL.TITLE","Start building your data pipeline from the right panel"),intro:translate("PAGE_SPECIFIC_TOUR.FLOW.RIGHT_PANEL.DESCRIPTION","The right panel is the main command center of the Flow.<br/><br/>It enables you to view information about your data, use pre-built transformation tools (known as Recipes), create ML models and more."),element:'[data-page-tour="right-panel"]',position:"left",beforeChange:function(){if(!scope.standardizedSidePanel.opened){scope.standardizedSidePanel.toggleTab("actions");hideHighlightDuringTransition(introJSInstance,300)}}},{title:translate("PAGE_SPECIFIC_TOUR.FLOW.PREVIEW.TITLE","View a preview of your data"),intro:translate("PAGE_SPECIFIC_TOUR.FLOW.PREVIEW.DESCRIPTION",'Quickly get a snapshot of your dataset in the preview panel.<br/><br/>You can minimize and reopen the preview tab at any time by clicking the "Hide Preview" button.'),element:'[data-page-tour="preview-button"]',position:"top",beforeChange:function(){if(!scope.hasPreview){scope.togglePreview();scope.$apply();hideHighlightDuringTransition(introJSInstance,400)}setTimeout(()=>{$('[data-page-tour="preview-pane"]').addClass("introjs-showElement")},0)}},{title:translate("PAGE_SPECIFIC_TOUR.FLOW.HOME_BUTTON.TITLE","Click the Home button to go to the home page"),intro:translate("PAGE_SPECIFIC_TOUR.FLOW.HOME_BUTTON.DESCRIPTION","View and create new projects, workspaces and more from the homepage."),element:'[data-page-tour="navbar-home-button"]',position:"bottom",beforeChange:function(){scope.togglePreview();scope.$apply()}},{title:translate("PAGE_SPECIFIC_TOUR.FLOW.TOP_NAV.TITLE","All your work, accessible in one place"),intro:translate("PAGE_SPECIFIC_TOUR.FLOW.TOP_NAV.DESCRIPTION","The navigation bar is essential to moving around the different areas of your Dataiku project.<br/><br/>Simply hover your cursor on a menu item to see a full list of the available functionalities."),element:'[data-page-tour="project-menus"]',position:"bottom"}];const tourOnlySteps=[{title:translate("PAGE_SPECIFIC_TOUR.FLOW.INTRO.TITLE","Take a quick tour of the Flow?"),intro:`<img src="static/dataiku/images/flow/flow-animation.gif"/>`+translate("PAGE_SPECIFIC_TOUR.FLOW.INTRO.DESCRIPTION","Learn how to build your data pipeline and navigate through the items in your project."),hideStepNumber:true},...commonSteps,{title:translate("PAGE_SPECIFIC_TOUR.FLOW.OUTRO.TITLE","✅ You've finished the Flow tour"),intro:translate("PAGE_SPECIFIC_TOUR.FLOW.OUTRO.DESCRIPTION",'That\'s all for now. You can re-activate the Flow tour or browse resources at any time through the Help Center <i class="dku-icon-question-circle-fill-16 vab"></i>'),hideStepNumber:true,element:'[data-page-tour="help-center-trigger"]',position:"bottom"}];if(fromContext==="opals"){tourOnlySteps.shift()}if(isFromQuestionnaire){introJSInstance.setOptions({nextLabel:translate("PAGE_SPECIFIC_TOUR.BUTTONS.NEXT","Next"),doneLabel:translate("PAGE_SPECIFIC_TOUR.BUTTONS.NEXT","Next")});introJSInstance.afterexit=()=>{displayTutorialPopup({scope:scope})}}introJSInstance.setOptions({steps:isFromQuestionnaire?commonSteps:tourOnlySteps});$timeout(()=>{introJSInstance.start()},100)})}function displayTutorialPopup({scope}){const tutorialPage=QuestionnaireService.getOpalsPage();const tutorialStartingStep=QuestionnaireService.getTutorialStartingStep();if(!tutorialPage){return}if(scope.standardizedSidePanel.opened){scope.standardizedSidePanel.slidePanel()}OpalsService.navigateToAndShowDrawer(tutorialPage,{number:tutorialStartingStep,numCompletedTasks:tutorialStartingStep-1});const introJSInstance=initialPopupSetup();introJSInstance.setOptions({steps:[{title:translate("PAGE_SPECIFIC_TOUR.FLOW.TUTORIAL.TITLE","Continue your tutorial here"),intro:translate("PAGE_SPECIFIC_TOUR.FLOW.TUTORIAL.DESCRIPTION","Follow the detailed step-by-step guideline to learn how to use Dataiku"),hideStepNumber:true,element:"opals-help-center-container",position:"left"}]});$timeout(()=>{introJSInstance.start()},0)}function displayReopenTutorialPopup(){if(!$rootScope.appConfig.opalsEnabled){return}if(!$rootScope.appConfig.onboardingExperience){return}if(ProfileService.isTechnicalAccount()){return}const introJSInstance=initialPopupSetup();introJSInstance.setOptions({steps:[{title:translate("PAGE_SPECIFIC_TOUR.TUTORIAL.INTRO.TITLE","You can re-open the tutorial from here"),intro:translate("PAGE_SPECIFIC_TOUR.TUTORIAL.INTRO.DESCRIPTION","Open the Help Center with this button and go to 'Onboarding' to find all the quick tutorials for your use case"),hideStepNumber:true,element:'[data-page-tour="help-center-trigger"]'}]});$timeout(()=>{introJSInstance.start()},0)}function startExploreTour({scope,fromContext}){if(!canStartExploreTour(scope)){return Promise.resolve()}return checkContextAllowTour(TOUR_NAMES.EXPLORE,fromContext).then(tourNeedToStart=>{if(!tourNeedToStart){return}const introJSInstance=initialTourSetup(scope,TOUR_NAMES.EXPLORE,fromContext);const steps=[{title:translate("PAGE_SPECIFIC_TOUR.EXPLORE.INTRO.TITLE","Take a quick tour of the Explore page ?"),intro:translate("PAGE_SPECIFIC_TOUR.EXPLORE.INTRO.DESCRIPTION","Learn how to analyze your data, adjust the sample, create charts and more.."),hideStepNumber:true},{title:translate("PAGE_SPECIFIC_TOUR.EXPLORE.SAMPLE.TITLE","Configure your dataset sample"),intro:translate("PAGE_SPECIFIC_TOUR.EXPLORE.SAMPLE.DESCRIPTION","For datasets larger than 10,000 rows, Dataiku shows only a sample of a dataset to enable efficient data exploration.<br/><br/>Use the sample settings panel to configure the sampling method, number of records and more."),element:'[data-page-tour="sampling-badge"]',position:"bottom"},{title:translate("PAGE_SPECIFIC_TOUR.EXPLORE.COLUMN.TITLE","Instantly check your column characteristics"),intro:translate("PAGE_SPECIFIC_TOUR.EXPLORE.COLUMN.DESCRIPTION","Beneath each column name, you will see that Dataiku automatically detects the storage type (shown in grey), the meaning (shown in blue) and data validity (red/green bar)."),beforeChange:function(){this.element=document.querySelector('[data-page-tour="column-header"]');this.position="right"}},{title:translate("PAGE_SPECIFIC_TOUR.EXPLORE.ANALYZE.TITLE","Analyze your columns at a glance"),intro:translate("PAGE_SPECIFIC_TOUR.EXPLORE.ANALYZE.DESCRIPTION","Click on the <i>Analyze</i> option in the drop-down menu to get some quick descriptive statistics on the contents of your column."),beforeChange:function(){document.querySelector('[data-page-tour="column-name"]').click();this.element=document.querySelector('[data-page-tour="analyze-column"]');this.position="right";closeContextualMenuOnlyOnNextButtonClick(scope)}},{title:translate("PAGE_SPECIFIC_TOUR.EXPLORE.CHARTS.TITLE","Visualize your data in a couple of clicks"),intro:translate("PAGE_SPECIFIC_TOUR.EXPLORE.CHARTS.DESCRIPTION","Visit the Charts tab to start visualizing your data with our drag-and-drop chart building interface."),element:'[data-page-tour="tab-charts"]',position:"bottom"},{title:translate("PAGE_SPECIFIC_TOUR.EXPLORE.OUTRO.TITLE","✅ You've finished the Explore tour"),intro:translate("PAGE_SPECIFIC_TOUR.EXPLORE.OUTRO.DESCRIPTION",'That\'s all for now. You can re-activate the Explore tour or browse resources at any time through the Help Center <i class="dku-icon-question-circle-fill-16 vab"></i>'),hideStepNumber:true,element:'[data-page-tour="help-center-trigger"]',position:"bottom"}];if(fromContext==="opals"){steps.shift()}introJSInstance.setOptions({helperElementPadding:5,steps:steps});$timeout(()=>{introJSInstance.start()},0)})}function startPrepareTour({scope,fromContext}){if(!canStartPrepareTour(scope)){return Promise.resolve()}return checkContextAllowTour(TOUR_NAMES.PREPARE,fromContext).then(tourNeedToStart=>{if(!tourNeedToStart){return}const introJSInstance=initialTourSetup(scope,TOUR_NAMES.PREPARE,fromContext);const steps=[{title:translate("PAGE_SPECIFIC_TOUR.PREPARE.INTRO.TITLE","Take a quick tour of the Prepare recipe?"),intro:translate("PAGE_SPECIFIC_TOUR.PREPARE.INTRO.DESCRIPTION","Learn how to cleanse, normalize and enrich your data in visual and interactive way."),hideStepNumber:true},{title:translate("PAGE_SPECIFIC_TOUR.PREPARE.NEW_STEP.TITLE","Add steps to your prepare script"),intro:translate("PAGE_SPECIFIC_TOUR.PREPARE.NEW_STEP.DESCRIPTION","Access hundreds of pre-made processors such as filtering rows, rounding numbers, splitting columns and more."),element:'[data-page-tour="shaker-new-step-btn"]',position:"bottom"},{title:translate("PAGE_SPECIFIC_TOUR.PREPARE.PROCESSORS.TITLE","Choose from a range of pre-made processors"),intro:translate("PAGE_SPECIFIC_TOUR.PREPARE.PROCESSORS.DESCRIPTION","Processors have been designed to handle one specific task, such as filtering rows, rounding numbers and more."),element:'[data-page-tour="processors-library"]',position:"top",beforeChange:function(){scope.toggleLibrary();hideHighlightDuringTransition(introJSInstance,400)}},{title:translate("PAGE_SPECIFIC_TOUR.PREPARE.COLUMN_SUGGESTIONS.TITLE","Get suggested preparation steps for each column"),intro:translate("PAGE_SPECIFIC_TOUR.PREPARE.COLUMN_SUGGESTIONS.DESCRIPTION","Get suggestions for processors that can be applied to each column of your dataset."),beforeChange:function(){scope.toggleLibrary(false);document.querySelector('[data-page-tour="column-name"]').click();this.element=document.querySelector('[data-page-tour="suggested-actions"]');this.position="bottom";closeContextualMenuOnlyOnNextButtonClick(scope);hideHighlightDuringTransition(introJSInstance,100)}},{title:translate("PAGE_SPECIFIC_TOUR.PREPARE.PREVIEW.TITLE","Preview your Prepare recipe script"),intro:translate("PAGE_SPECIFIC_TOUR.PREPARE.PREVIEW.DESCRIPTION","When new steps are added to the script, the step output is immediately visible thanks to the preview.<br/><br/>This preview is only computed on your sample dataset. The full script will be executed when you run the recipe."),element:'[data-page-tour="step-preview-button"]',position:"right"},{title:translate("PAGE_SPECIFIC_TOUR.PREPARE.OUTRO.TITLE","✅ You've finished the Prepare recipe tour"),intro:translate("PAGE_SPECIFIC_TOUR.PREPARE.OUTRO.DESCRIPTION",'That\'s all for now. You can re-activate the Prepare recipe tour or browse resources at any time through the Help Center <i class="dku-icon-question-circle-fill-16 vab"></i>'),hideStepNumber:true,element:'[data-page-tour="help-center-trigger"]',position:"bottom"}];const bypassPreviewStep=document.querySelectorAll('[data-page-tour="step-preview-button"]').length===0;if(bypassPreviewStep){steps.splice(4,1)}if(fromContext==="opals"){steps.shift()}introJSInstance.setOptions({helperElementPadding:5,steps:steps});$timeout(()=>{introJSInstance.start()},0)})}function onTourStarted(introJSInstance){if(introJSInstance.$tourName){WT1.tryEvent("page-tour-started",()=>({from:introJSInstance.$fromContext,scope:introJSInstance.$tourName}))}}function onTourDismissed(introJSInstance){introJSInstance.$skipped=true;if(introJSInstance.$tourName){WT1.tryEvent("page-tour-dismissed",()=>({from:introJSInstance.$fromContext,scope:introJSInstance.$tourName}))}}function onTourClosed(introJSInstance){if(introJSInstance.$tourName&&!introJSInstance.$skipped&&introJSInstance.currentStep()>=0){WT1.tryEvent("page-tour-closed",()=>({from:introJSInstance.$fromContext,scope:introJSInstance.$tourName,numberOfSteps:introJSInstance._options.steps.length,currentStep:introJSInstance.currentStep()+1}))}}function canStartFlowTour(){const builtDatasets=$(BUILT_DATASET_SELECTOR);if(!builtDatasets.length){return false}return checkGlobalSettingsAllowTour(TOUR_NAMES.FLOW)}function canStartExploreTour(scope){if(!scope.table||scope.table.headers.length===0){return}return checkGlobalSettingsAllowTour(TOUR_NAMES.EXPLORE)}function canStartPrepareTour(scope){if(!scope.projectSummary||!scope.projectSummary.canWriteProjectContent){return}if(!scope.table||scope.table.headers.length===0){return}if(!scope.shaker||scope.shaker.origin!=="PREPARE_RECIPE"){return}return checkGlobalSettingsAllowTour(TOUR_NAMES.PREPARE)}function checkGlobalSettingsAllowTour(tourName){if(!$rootScope.appConfig.opalsEnabled){recordTourCompleted(tourName);return false}if(!$rootScope.appConfig.onboardingExperience){recordTourCompleted(tourName);return false}if(ProfileService.isTechnicalAccount()){recordTourCompleted(tourName);return false}if(!$rootScope.appConfig.userProfile.mayWriteProjectContent){recordTourCompleted(tourName);return false}return true}function checkContextAllowTour(tourName,fromContext){if(fromContext==="opals"){return Promise.resolve(true)}if(getTourCompletionSetting(tourName)){return Promise.resolve(false)}if(TopbarDrawersService.getDrawer(TOPBAR_DRAWER_IDS.OPALS_HELP).isToggledOn()&&tourName!==TOUR_NAMES.FLOW){return Promise.resolve(false)}return OpalsService.getLocalStorage(tourName+"TourCompleted").then(tourCompleted=>{if(tourCompleted==="true"){recordTourCompleted(tourName);return false}return true})}function initialTourSetup(scope,tourName,fromContext){const introJSInstance=introJs();introJSInstance.$tourName=tourName;introJSInstance.$fromContext=fromContext;const unbindStateChangeListener=scope.$on("$stateChangeStart",()=>{introJSInstance.$forceExit=true;introJSInstance.exit()});const handlePageLeave=()=>{onTourClosed(introJSInstance)};window.addEventListener("beforeunload",handlePageLeave);scope.$on("$destroy",()=>{window.removeEventListener("beforeunload",handlePageLeave);unbindStateChangeListener()});introJSInstance.setOptions({disableInteraction:true,keyboardNavigation:false,buttonClass:"btn btn--primary",doneLabel:translate("PAGE_SPECIFIC_TOUR.BUTTONS.FINISH_TOUR","Finish Tour"),nextLabel:fromContext==="opals"?translate("PAGE_SPECIFIC_TOUR.BUTTONS.NEXT","Next"):translate("PAGE_SPECIFIC_TOUR.BUTTONS.LETS_GO","Let's go"),showBullets:false,helperElementPadding:0});introJSInstance.onstart(function(){onTourStarted(introJSInstance);Mousetrap.pause()});let skipped=false;introJSInstance.onskip(function(){skipped=true});introJSInstance.onbeforechange(function(){const currentStep=this._introItems[this._currentStep];if(currentStep.beforeChange){currentStep.beforeChange()}});introJSInstance.onafterchange(function(){restyleTour(introJSInstance);if(introJSInstance.currentStep()===introJSInstance._options.steps.length-1){recordTourCompleted(introJSInstance.$tourName);OpalsService.setLocalStorage(tourName+"TourCompleted","true")}});introJSInstance.onbeforeexit(function(){if(introJSInstance.currentStep()===introJSInstance._options.steps.length-1){return true}if(skipped){onTourClosed(introJSInstance);goToByeStep(introJSInstance);return false}if(!introJSInstance.$forceExit){pauseTour(introJSInstance);const tourNameTranslated=translate("PAGE_SPECIFIC_TOUR.TOUR_NAME."+$filter("uppercase")(tourName),$filter("capitalize")(tourName));return Dialogs.confirm(scope,translate("PAGE_SPECIFIC_TOUR.CONFIRM_MODAL.TITLE","👋 Are you sure you want to leave the tour?"),translate("PAGE_SPECIFIC_TOUR.REACTIVATE.DESCRIPTION",`You can re-activate the {{tourName}} tour or browse resources at any time through the Help Center <i class="dku-icon-question-circle-fill-16 vab"></i>`,{tourName:tourNameTranslated}),{confirmOnExit:true}).then(()=>{recordTourCompleted(introJSInstance.$tourName);OpalsService.setLocalStorage(tourName+"TourCompleted","true")},()=>{unpauseTour(introJSInstance);return false})}return true});introJSInstance.onexit(function(){if(!skipped){onTourClosed(introJSInstance)}window.removeEventListener("beforeunload",handlePageLeave);unbindStateChangeListener();ContextualMenu.prototype.closeAny();Mousetrap.unpause();if(introJSInstance.afterexit){introJSInstance.afterexit()}});return introJSInstance}function initialPopupSetup(){const introJSInstance=introJs();introJSInstance.setOptions({disableInteraction:true,keyboardNavigation:false,buttonClass:"btn btn--primary",doneLabel:"OK",nextLabel:translate("PAGE_SPECIFIC_TOUR.BUTTONS.NEXT","Next"),showBullets:false,helperElementPadding:0});introJSInstance.onstart(function(){Mousetrap.pause()});introJSInstance.onafterchange(function(){restyleTour(introJSInstance)});introJSInstance.onexit(function(){Mousetrap.unpause()});return introJSInstance}const recordTourCompleted=tourName=>{if(tourName){if(getTourCompletionSetting(tourName)){return}setTourCompletionSetting(tourName,true);DataikuAPI.profile.updatePageSpecificTourSettings($rootScope.appConfig.pageSpecificTourSettings)}};const closeContextualMenuOnlyOnNextButtonClick=()=>{window.setTimeout(()=>{$(document).off("click.closeMenu");$(document).on("click.closeMenu",function(evt){const isClickOnNextButton=$(evt.target).hasClass("introjs-nextbutton");if(isClickOnNextButton){ContextualMenu.prototype.closeAny()}})},0)};const hideHighlightDuringTransition=(introJSInstance,delay)=>{$timeout(()=>$(".introjs-helperLayer, .introjs-tooltipReferenceLayer").addClass("display-none"));$timeout(()=>{introJSInstance.refresh();$(".introjs-helperLayer, .introjs-tooltipReferenceLayer").removeClass("display-none")},delay)};let highlightedElements=[];const pauseTour=introJSInstance=>{$(".introjs-tooltipReferenceLayer, .introjs-helperLayer, .introjs-overlay, .introjs-disableInteraction").addClass("display-none");highlightedElements=$(".introjs-showElement");highlightedElements.removeClass("introjs-showElement");introJSInstance.refresh()};const unpauseTour=introJSInstance=>{$(".introjs-tooltipReferenceLayer, .introjs-helperLayer, .introjs-overlay, .introjs-disableInteraction").removeClass("display-none");highlightedElements.addClass("introjs-showElement");introJSInstance.refresh()};const restyleTour=introJSInstance=>{const currentStep=introJSInstance.currentStep();if(currentStep===0){restyleDismissButton();introJSInstance.setOption("nextLabel",translate("PAGE_SPECIFIC_TOUR.BUTTONS.NEXT","Next"));if(!QuestionnaireService.isFromQuestionnaire()&&introJSInstance.$fromContext!=="opals"){addNoThanksButton(introJSInstance)}}else if(currentStep===1){removeNoThanksButton()}restyleStepNumber(introJSInstance)};const restyleDismissButton=()=>{$(".introjs-skipbutton").addClass("dku-icon-dismiss-20");$(".introjs-skipbutton").text("")};const restyleStepNumber=introJSInstance=>{var stepNumberElements=document.getElementsByClassName("introjs-stepNumber");var helperNumberLayer;if(!stepNumberElements.length){helperNumberLayer=document.createElement("div");helperNumberLayer.className="introjs-stepNumber";const tooltipButtons=$(".introjs-tooltipbuttons");const parentNode=tooltipButtons[0];parentNode.insertBefore(helperNumberLayer,parentNode.firstChild)}else{helperNumberLayer=stepNumberElements[0]}const currentStep=introJSInstance._introItems[introJSInstance.currentStep()];const numberedSteps=introJSInstance._introItems.filter(item=>!item.hideStepNumber);const stepNumber=numberedSteps.indexOf(currentStep);helperNumberLayer.innerText=!currentStep.hideStepNumber?`${stepNumber+1} ${translate("PAGE_SPECIFIC_TOUR.STEP_NUMBER_LABEL","of")} ${numberedSteps.length}`:""};const goToByeStep=introJSInstance=>{removeNoThanksButton();const tourName=introJSInstance.$tourName;const tourNameTranslated=translate("PAGE_SPECIFIC_TOUR.TOUR_NAME."+$filter("uppercase")(tourName),$filter("capitalize")(tourName));const steps=introJSInstance._introItems;steps[steps.length-1]={title:translate("PAGE_SPECIFIC_TOUR.SKIPPED_OUTRO.TITLE","👋 Bye for now!"),intro:translate("PAGE_SPECIFIC_TOUR.REACTIVATE.DESCRIPTION",`You can re-activate the {{tourName}} tour or browse resources at any time through the Help Center <i class="dku-icon-question-circle-fill-16 vab"></i>`,{tourName:tourNameTranslated}),element:document.querySelector('[data-page-tour="help-center-trigger"]'),position:"bottom",hideStepNumber:true};introJSInstance.goToStep(steps.length)};const addNoThanksButton=introJSInstance=>{if($(".introjs-nothanksbutton").length){return}const tooltipButtons=$(".introjs-tooltipbuttons");var btn=document.createElement("button");btn.className="introjs-nothanksbutton btn btn--text btn--secondary";btn.innerText=translate("PAGE_SPECIFIC_TOUR.BUTTONS.NO_THANKS","No Thanks");btn.onclick=()=>{onTourDismissed(introJSInstance);goToByeStep(introJSInstance)};const parentNode=tooltipButtons[0];parentNode.insertBefore(btn,parentNode.firstChild)};const removeNoThanksButton=()=>{$(".introjs-nothanksbutton").remove()};return{TOUR_NAMES:TOUR_NAMES,checkFlowTourConditions:checkFlowTourConditions,canStartFlowTour:canStartFlowTour,startFlowTour:startFlowTour,canStartExploreTour:canStartExploreTour,startExploreTour:startExploreTour,canStartPrepareTour:canStartPrepareTour,startPrepareTour:startPrepareTour,displayReopenTutorialPopup:displayReopenTutorialPopup}}})();(function(){"use strict";const app=angular.module("dataiku.flow.graph");app.component("zoneEditor",{bindings:{name:"=",color:"=",disableCompactStyling:"<?"},templateUrl:"/templates/zones/edit-zone-box.html",controller:function zoneEditorCtrl($timeout){this.$onInit=function(){this.stockColors=["#C82423","#8C2DA7","#31439C","#087ABF","#0F786B","#4B8021","#F9BE40","#C54F00","#D03713","#465A64"];this.color=this.color===undefined?this.stockColors[Math.floor(Math.random()*this.stockColors.length)]:this.color;this.colors=window.dkuColorPalettes.discrete.find(palette=>palette.id==="dku_font").colors};this.pickStockColor=color=>{$timeout(()=>{this.color=color})}}});app.component("zoneSelector",{bindings:{name:"=",color:"=",creationMode:"=",selectedZone:"=",forceCreation:"<?",projectKey:"<?",disableCompactStyling:"<?"},templateUrl:"/templates/flow-editor/zone-selection-box.html",controller:["$scope","$rootScope","$stateParams","DataikuAPI","localStorageService","FlowGraphSelection",function zoneSelectionCtrl(scope,$rootScope,$stateParams,DataikuAPI,localStorageService,FlowGraphSelection){const ctrl=this;ctrl.$onInit=function(){ctrl.projectKey=ctrl.projectKey===undefined?$stateParams.projectKey:ctrl.projectKey;if(!ctrl.forceCreation){scope.$watch("$ctrl.projectKey",function(){listZones()},true);ctrl.selectedZone=preselectZone()}};ctrl.zoneComparator=(v1,v2)=>{if(v1.type!=="string"||v2.type!=="string"){return v1.index<v2.index?-1:1}if(ctrl.zones[v1.index].id==="default"){return 1}if(ctrl.zones[v2.index].id==="default"){return-1}return v1.value.localeCompare(v2.value)};const preselectZone=()=>{const lastUsedZoneKey=`dku.flow.lastUsedZone.${ctrl.projectKey}`;return localStorageService.get(lastUsedZoneKey)};function listZones(){DataikuAPI.flow.zones.list(ctrl.projectKey).success(zones=>{ctrl.zones=zones;ctrl.forceCreation=zones.length===0;ctrl.creationMode=!ctrl.forceCreation?"SELECT":"CREATE"}).error(setErrorInScope.bind(scope))}}]});app.directive("zoneRightColumnSummary",function($controller,$rootScope,$state,$stateParams,DataikuAPI,CreateModalFromTemplate,TaggableObjectsUtils,FlowGraph,ActivityIndicator,Dialogs,SubFlowCopyService,FlowGraphSelection,ZoneService){return{templateUrl:"/templates/zones/right-column-summary.html",link:function(scope,element,attrs){$controller("_TaggableObjectsMassActions",{$scope:scope});$controller("_TaggableObjectsCapabilities",{$scope:scope});scope.$stateParams=$stateParams;scope.zoomOnZone=ZoneService.zoomOnZone;scope.zoomOutOfZone=ZoneService.zoomOutOfZone;scope.$on("objectSummaryEdited",function(){const zone=scope.zoneFullInfo.zone;const tor={type:"FLOW_ZONE",projectKey:$stateParams.projectKey,id:zone.id};DataikuAPI.taggableObjects.getMetadata(tor).success(function(metadata){metadata.tags=zone.tags;DataikuAPI.taggableObjects.setMetaData(tor,metadata).success(function(){ActivityIndicator.success("Saved")})}).error(setErrorInScope.bind(scope))});scope.editZone=()=>{CreateModalFromTemplate("/templates/zones/edit-zone-modal.html",scope,null,function(newScope){newScope.uiState={color:scope.selection.selectedObject.color,name:scope.selection.selectedObject.name};newScope.go=function(){DataikuAPI.flow.zones.edit($stateParams.projectKey,scope.selection.selectedObject.id,newScope.uiState.name,newScope.uiState.color).success(function(){scope.$emit("reloadGraph");if($stateParams.zoneId){$rootScope.$emit("zonesListChanged",newScope.uiState.name)}newScope.dismiss()}).error(setErrorInScope.bind(newScope))}})};function openMultiBuildModal(errorMessage,defaultLimitToZone){return function(data){if(!data.length){Dialogs.error(scope,"Nothing to build",errorMessage)}else{CreateModalFromTemplate("/templates/flow-editor/tools/build-multiple-flow-computables-modal.html",scope,"BuildMultipleComputablesController",function(modalScope){modalScope.initModal(data,undefined,{origin:"FLOW_ZONE"});modalScope.jobOptions.stopAtFlowZoneBoundary=defaultLimitToZone})}}}scope.buildZone=function(zoneId){DataikuAPI.flow.listDownstreamComputables($stateParams.projectKey,{zoneId:scope.selection.selectedObject.id}).success(openMultiBuildModal("This zone has no buildable dataset.",true)).error(setErrorInScope.bind(scope))};scope.refreshData=function(){DataikuAPI.zones.getFullInfo(scope.selection.selectedObject.projectKey,scope.selection.selectedObject.cleanId).success(function(data){data.zone.cleanId=data.zone.id;scope.zoneFullInfo=data;if(scope.selection.selectedObject&&scope.selection.selectedObject.cleanId===data.zone.cleanId){scope.selection.selectedObject=data.zone;scope.selection.selectedObject.isCollapsed=scope.collapsedZones.find(it=>it===data.zone.id)!==undefined}}).error(setErrorInScope.bind(scope))};scope.deleteZone=()=>{let items=scope.getSelectedTaggableObjectRefs();let success=undefined;if($stateParams.zoneId){items=[TaggableObjectsUtils.fromNode(scope.nodesGraph.nodes[`zone_${$stateParams.zoneId}`])];success=()=>scope.zoomOutOfZone()}scope.deleteSelected(items,success)};scope.collapseAllZones=()=>{const allFlowZones=Object.values(FlowGraph.get().nodes).filter(it=>TaggableObjectsUtils.fromNodeType(it.nodeType)==="FLOW_ZONE");scope.toggleZoneCollapse(allFlowZones.map(TaggableObjectsUtils.fromNode),"collapseAll")};scope.expandAllZones=()=>{const allFlowZones=Object.values(FlowGraph.get().nodes).filter(it=>TaggableObjectsUtils.fromNodeType(it.nodeType)==="FLOW_ZONE");scope.toggleZoneCollapse(allFlowZones.map(TaggableObjectsUtils.fromNode),"expandAll")};scope.copyZone=()=>{const startCopyTool=scope.startTool("COPY",{preselectedNodes:FlowGraphSelection.getSelectedNodes().map(n=>n.id)});startCopyTool.then(()=>{const selectedTaggableObjectRefs=FlowGraphSelection.getSelectedTaggableObjectRefs();const itemsByZones=FlowGraph.nodesByZones(node=>TaggableObjectsUtils.fromNode(node));SubFlowCopyService.start(selectedTaggableObjectRefs,itemsByZones,scope.stopAction)})};scope.$watch("selection.selectedObject",function(nv){if(!scope.selection)scope.selection={};scope.zoneFullInfo={zone:scope.selection.selectedObject,timeline:{}}});scope.$watch("selection.confirmedItem",function(nv,ov){if(!nv)return;scope.selection.selectedObject.cleanId=scope.selection.selectedObject.id.split("_")[1];scope.refreshData()});const zonesListChangedListener=$rootScope.$on("zonesListChanged",scope.refreshData);scope.$on("$destroy",zonesListChangedListener)}}});app.service("ZoneService",function($stateParams,$state){this.zoomOnZone=zoneId=>{$state.go("projects.project.flow",Object.assign({},$stateParams,{zoneId:zoneId}))};this.zoomOutOfZone=(id=null)=>{$state.go("projects.project.flow",Object.assign({},$stateParams,{zoneId:null,id:id}))}})})();(function(){"use strict";const app=angular.module("dataiku.flow.tools",[]);app.factory("Ng1ToolBridgeService",function($injector){return()=>$injector.get("ToolBridgeService")});app.service("FlowToolsRegistry",function(){const flowViews={};const flowTools={};this.registerView=function(service){let def=service.getDefinition();def.isTool=false;flowViews[def.getName()]=def};this.registerFlowTool=function(service){let def=service.getDefinition();def.isTool=true;flowTools[def.getName()]=def};this.getDef=function(name){return flowViews[name]||flowTools[name]};this.getFlowViews=function(){return Object.values(flowViews)}});app.service("FlowToolsLoader",function(FlowToolsRegistry,FlowZonesView,TagsView,CustomFieldsView,ConnectionsView,FileformatsView,RecipesEnginesView,RecipesCodeEnvsView,PipelinesView,ImpalaWriteModeView,HiveModeView,SparkConfigView,PartitioningView,PartitionsView,ScenariosView,WatchView,CountOfRecordsView,FilesizeView,CreationView,LastModifiedView,LastBuildView,LastBuildDurationView,RecentActivityView,DataQualityView,CopyFlowTool,PropagateSchemaFlowTools,CheckConsistencyFlowTool,ColumnUsageView){FlowToolsRegistry.registerView(FlowZonesView);FlowToolsRegistry.registerView(TagsView);FlowToolsRegistry.registerView(CustomFieldsView);FlowToolsRegistry.registerView(ConnectionsView);FlowToolsRegistry.registerView(RecipesEnginesView);FlowToolsRegistry.registerView(RecipesCodeEnvsView);FlowToolsRegistry.registerView(ImpalaWriteModeView);FlowToolsRegistry.registerView(HiveModeView);FlowToolsRegistry.registerView(SparkConfigView);FlowToolsRegistry.registerView(PipelinesView.getService("SPARK_PIPELINES"));FlowToolsRegistry.registerView(PipelinesView.getService("SQL_PIPELINES"));FlowToolsRegistry.registerView(CreationView);FlowToolsRegistry.registerView(LastModifiedView);FlowToolsRegistry.registerView(LastBuildView);FlowToolsRegistry.registerView(LastBuildDurationView);FlowToolsRegistry.registerView(RecentActivityView);FlowToolsRegistry.registerView(PartitioningView);FlowToolsRegistry.registerView(PartitionsView);FlowToolsRegistry.registerView(ScenariosView);FlowToolsRegistry.registerView(DataQualityView);FlowToolsRegistry.registerView(CountOfRecordsView);FlowToolsRegistry.registerView(FilesizeView);FlowToolsRegistry.registerView(FileformatsView);FlowToolsRegistry.registerView(WatchView);FlowToolsRegistry.registerView(ColumnUsageView);FlowToolsRegistry.registerFlowTool(CopyFlowTool);FlowToolsRegistry.registerFlowTool(CheckConsistencyFlowTool);FlowToolsRegistry.registerFlowTool(PropagateSchemaFlowTools)});app.service("FlowTool",function($rootScope,Assert,Logger,FlowToolsRegistry,$injector){const svc=this;let currentTool={};this.setCurrent=function(tool){currentTool=tool};this.getCurrent=function(){return currentTool};this.unactivateCurrentTool=function(redraw=true){if(!currentTool.def)return;if(currentTool.def.destroyFlowTool){currentTool.def.destroyFlowTool()}svc.setCurrent({});if(redraw){$rootScope.$emit("drawGraph",false,false)}return currentTool};this.activateTool=function(currentToolSession,viewData){Assert.trueish(currentToolSession,"no currentToolSession");Logger.info("Activating tool",currentToolSession,FlowToolsRegistry.registry);svc.unactivateCurrentTool(false);let def=FlowToolsRegistry.getDef(currentToolSession.type);Assert.trueish(def,"no tool def");svc.setCurrent({drawHooks:{},actionHooks:{},type:currentToolSession.type,currentSession:currentToolSession,def:def});return def.initFlowTool(currentTool,viewData)};this.refreshFlowStateWhenViewIsActive=function(viewNames){const currentTool=svc.getCurrent();if(currentTool.def&&(!viewNames||!viewNames.length||viewNames.includes(currentTool.def.getName()))){currentTool.refreshState()}};$rootScope.$on("flowDisplayUpdated",function(){if(currentTool.drawHooks&&currentTool.drawHooks.updateFlowToolDisplay){currentTool.drawHooks.updateFlowToolDisplay()}});$rootScope.$on("flowItemClicked",function(evt,evt2,item){if(currentTool.actionHooks&&currentTool.actionHooks.onItemClick){currentTool.actionHooks.onItemClick(item,evt2)}})});app.service("FlowViewsUtils",function($stateParams,WT1,DataikuAPI,Logger,MonoFuture,ProgressStackMessageBuilder,FlowGraphSelection,FlowGraphFiltering,FlowGraphFolding){this.addFocusBehavior=function(tool){function isItemSelectedbyId(itemId){let val=tool.user.state.valueByNode[itemId];if(val===undefined){return false}if(angular.isArray(tool.getRepr(val))){for(let v of tool.getRepr(val)){if(tool.user.state.focusMap[v]){return true}}return false}return tool.user.state.focusMap[tool.getRepr(val)]}function isItemSelected(item){return isItemSelectedbyId(item.realId)}function getSelectedIdsList(){const selectedIdslist=[];Object.keys(tool.user.state.valueByNode).forEach(itemId=>{if(isItemSelectedbyId(itemId))selectedIdslist.push(itemId)});return selectedIdslist}tool.user.isFocused=function(val){if(typeof tool.colorScale=="function"&&tool.colorScale().continuous){return true}const repr=tool.getRepr(val);if(angular.isArray(repr)){let any=false;repr.forEach(function(it){if(tool.user.state.focusMap[it]){any=true}});return any}else{return tool.user.state.focusMap[repr]}};tool.user.getFocusedAsList=function(){return[]};tool.user.getSingleFocused=function(){for(let val in tool.user.state.focusMap){if(tool.user.state.focusMap[val]){return val}}};tool.user.zoomToFocused=function(){FlowGraphFolding.ensureNodesNotFolded(getSelectedIdsList());let scope=$("#flow-graph").scope();if($("#flow-graph svg .focus").length){scope.zoomToBbox(FlowGraphFiltering.getBBoxFromSelector(scope.svg,".focus"),1.2)}else{scope.zoomToBbox(FlowGraphFiltering.getBBoxFromSelector(scope.svg,".node"),1.2)}};tool.user.selectFocused=function(){WT1.event("flow-view-select-focused",{tool:tool.def.name});FlowGraphFolding.ensureNodesNotFolded(getSelectedIdsList());FlowGraphSelection.select(isItemSelected)}};this.addAsynchronousStateComputationBehavior=function(tool){tool.user.update=function(scope){tool.user.updateStatus.updating=true;tool.user.firstUpdateDone=true;return MonoFuture(scope).wrap(DataikuAPI.flow.tools.startUpdate)($stateParams.projectKey,tool.def.getName(),tool.user.updateOptions).success(function(data){tool.user.state=data.result;tool.drawHooks.updateFlowToolDisplay();tool.user.updateStatus.updating=false}).error(function(a,b,c){tool.user.updateStatus.updating=false;setErrorInScope.bind(scope)(a,b,c)}).update(function(data){tool.user.updateStatus.progress=data.progress;tool.user.updateStatus.totalPercent=ProgressStackMessageBuilder.getPercentage(data.progress)})}}});app.service("FlowToolsUtils",function(Logger,FlowGraph){const svc=this;this.notSoGrey=function(node,elt){svc.colorNode(node,elt,"#ACACAC")},this.greyOutNode=function(node,elt){svc.colorNode(node,elt,"#DADADA")},this.colorNode=function(node,elt,color){try{if(elt===undefined){return}if(node.nodeType=="LOCAL_DATASET"||node.nodeType=="FOREIGN_DATASET"){elt.style("fill",color);if(node.neverBuilt){elt.select(".never-built-computable .main-dataset-rectangle").style("stroke",color);elt.select(".never-built-computable .nodeicon").style("color",color);elt.select(".never-built-computable .nodelabel-wrapper").style("color",color)}}else if(node.nodeType=="LOCAL_MANAGED_FOLDER"||node.nodeType=="FOREIGN_MANAGED_FOLDER"){elt.style("fill",color)}else if(node.nodeType=="LOCAL_STREAMING_ENDPOINT"){elt.style("fill",color)}else if(node.nodeType=="LOCAL_SAVEDMODEL"||node.nodeType=="FOREIGN_SAVEDMODEL"){elt.style("fill",color)}else if(node.nodeType=="LOCAL_MODELEVALUATIONSTORE"||node.nodeType=="FOREIGN_MODELEVALUATIONSTORE"){elt.style("fill",color)}else if(node.nodeType=="LOCAL_GENAIEVALUATIONSTORE"||node.nodeType=="FOREIGN_GENAIEVALUATIONSTORE"){elt.style("fill",color)}else if(node.nodeType=="LOCAL_RETRIEVABLE_KNOWLEDGE"||node.nodeType=="FOREIGN_RETRIEVABLE_KNOWLEDGE"){elt.style("fill",color);if(node.neverBuilt){elt.select(".never-built-computable .main-retrievable-knowledge-rectangle").style("stroke",color);elt.select(".never-built-computable .nodeicon").style("color",color);elt.select(".never-built-computable .nodelabel-wrapper").style("color",color)}}else if(node.nodeType=="RECIPE"){elt.select(".bzicon").style("fill",color)}else if(node.nodeType=="LABELING_TASK"){elt.select(".bzicon").style("fill",color)}else if(node.nodeType=="ZONE"){elt.style("background-color",color);elt.style("stroke",color);const rgbColor=d3.rgb(color);const titleColor=rgbColor.r*.299+rgbColor.g*.587+rgbColor.b*.114>=128?"#000":"#FFF";elt.style("color",titleColor)}else{Logger.warn("Cannot color node",node)}elt.select("g, rect").attr("color",color)}catch(e){Logger.error("Failed to color node",e)}};const RADIUS=6;this.addViewValueIndicator=function(elt,color="rgba(0,0,0,0)",idx=0,onClick){let tsz=elt.select(".tool-simple-zone");if(!tsz.empty()){if(idx==0){tsz.selectAll("*").remove()}let tszHeight=tsz.attr("data-height");tsz.append("circle").attr("cx",RADIUS+2).attr("cy",tszHeight-RADIUS-idx*(RADIUS*2+2)).attr("r",RADIUS).attr("fill",color).on("click",onClick)}}});app.directive("flowToolSupport",function($rootScope,$stateParams,Assert,WT1,Logger,DataikuAPI,FlowToolsRegistry,FlowTool,FlowGraph,ToolBridgeService,$injector){return{restrict:"A",link:function(scope,element,attrs){function activateFromStateIfNeeded(){Assert.trueish(scope.toolsState,"no tool state");scope.toolsState.otherActive={};$.each(scope.toolsState.active,function(k,v){if(k!=scope.toolsState.currentId){scope.toolsState.hasOtherActive=true;scope.toolsState.otherActive[k]=v}});if(scope.toolsState.currentId){scope.tool=FlowTool.activateTool(scope.toolsState.active[scope.toolsState.currentId])}}scope.refreshToolsState=function(){DataikuAPI.flow.tools.getSessions($stateParams.projectKey).success(function(data){scope.toolsState=data;activateFromStateIfNeeded()}).error(setErrorInScope.bind(scope))};scope.startTool=function(type,data){WT1.event("flow-tool-start",{tool:type});if(!scope.drawZones.drawZones){scope.showZones()}return DataikuAPI.flow.tools.start($stateParams.projectKey,type,data).success(function(data){scope.toolsState=data;activateFromStateIfNeeded()}).error(setErrorInScope.bind(scope))};scope.$on("projectTagsUpdated",function(e,args){if(scope.tool&&scope.tool.type=="TAGS"){scope.tool.refreshState(false,args.updateGraphTags)}});scope.stopAction=function(){if(!scope.toolsState||!scope.toolsState.currentId){Logger.warn("no active tool, cannot stop");return}$.each(FlowGraph.get().nodes,function(nodeId){const nodeElt=FlowGraph.d3NodeWithId(nodeId);nodeElt.classed("focus",false).classed("out-of-focus",false)});if(scope.tool.type=="PROPAGATE_SCHEMA"){FlowGraph.getSvg().find(".grey-out-path").each(function(){d3.select(this).classed("grey-out-path",false)})}scope.tool=FlowTool.unactivateCurrentTool();$rootScope.$emit("flowDisplayUpdated",true);DataikuAPI.flow.tools.stop($stateParams.projectKey,scope.toolsState.currentId).success(function(data){scope.toolsState=data;if(!scope.drawZones.drawZones){scope.showZones()}activateFromStateIfNeeded()}).error(setErrorInScope.bind(scope))};scope.activateTool=function(toolId){DataikuAPI.flow.tools.setActive($stateParams.projectKey,toolId).success(function(data){scope.toolsState=data;activateFromStateIfNeeded()}).error(setErrorInScope.bind(scope))};const h=$rootScope.$on("stopAction",scope.stopAction);scope.$on("$destroy",h);scope.refreshToolsState();scope.showZones=function(){ToolBridgeService.emitShouldDrawZones(true)};scope.startView=function(view){const tool=FlowTool.getCurrent();if(tool&&tool.def&&tool.action){scope.stopAction()}const params=view.getViewParams();const options=params?params.toOptions():{};FlowTool.activateTool({type:view.getName(),options:options},view.latestData);if(!scope.drawZones.drawZones&&view.getName()!=="FLOW_ZONES"){scope.showZones()}scope.tool=FlowTool.getCurrent();ToolBridgeService.emitViewTool(scope.tool)};scope.stopView=function(){const tool=FlowTool.getCurrent();if(!tool||!tool.def||tool.action){return}scope.tool=FlowTool.unactivateCurrentTool();if(!scope.drawZones.drawZones){scope.showZones()}ToolBridgeService.emitViewTool(scope.tool)};var toolBridgeSubscriptions=[];toolBridgeSubscriptions.push(ToolBridgeService.viewActivation$.subscribe(view=>{if(view){scope.startView(view)}else{scope.stopView()}}));toolBridgeSubscriptions.push(ToolBridgeService.shouldDrawZones$.subscribe(shouldDrawZones=>{if(scope.drawZones.drawZones===shouldDrawZones){return}scope.drawZones.drawZones=shouldDrawZones;scope.redrawZone()}));scope.$on("$destroy",function(){if(toolBridgeSubscriptions){toolBridgeSubscriptions.forEach(subs=>subs.unsubscribe())}FlowTool.unactivateCurrentTool()})}}});app.directive("flowToolFacetElt",function(){return{template:`<label class="horizontal-flex" ng-class="{'single-focused': states[key]}">
                <input type="checkbox" ng-if="!singleFocused" ng-model="states[key]" ng-click="$event.stopPropagation()"/>
                <span class="dib flex horizontal-flex" ng-click="click(key, $event)">
                    <span class="bullet noflex" style="background-color: {{color}};" />
                    <span class="text flex">
                        <span ng-if="!displayGlobalTags">{{displayName ? displayName : (isNumber(key) ? (key | number) : key) }}</span>
                        <span ng-if="displayGlobalTags" ui-global-tag="displayName ? displayName : (isNumber(key) ? (key | number) : key)" object-type="'TAGGABLE_OBJECT'"/>
                    </span>
                    <span class="number noflex">{{number}}</span>
                </span>
            </label>`,scope:{color:"=",key:"=",displayName:"=",number:"=",singleFocused:"=",states:"=",displayGlobalTags:"="},link:function(scope,element,attr){scope.click=function(key,evt){if(!scope.states)return;$.each(scope.states,function(k){scope.states[k]=false});scope.states[key]=true;evt.preventDefault();evt.stopPropagation()};scope.isNumber=n=>angular.isNumber(n)}}})})();(function(){"use strict";const app=angular.module("dataiku.flow.tools");app.service("WatchView",function(StandardFlowViews){this.getDefinition=function(){return StandardFlowViews.getDefinition("WATCH","Watched and starred items",{getRepr:val=>val.w?"Watching":undefined,totem:function(val){return{class:val.s?"icon-star":"",style:val.s?"color: gold; font-size: 32px;":""}}})}});app.service("SparkConfigView",function(StandardFlowViews){this.getDefinition=function(){return StandardFlowViews.getDefinition("SPARK_CONFIG","Spark configurations",{getRepr:val=>val.inheritConf,totem:function(val){return{class:val.conf.length?"icon-plus flow-totem-ok":"",style:""}},tooltipTemplate:"/templates/flow-editor/tools/spark-config-view-tooltip.html"})}});app.service("ConnectionsView",function(StandardFlowViews){this.getDefinition=function(){return StandardFlowViews.getDefinition("CONNECTIONS","Connections",{getRepr:val=>val.connection,tooltipTemplate:"/templates/flow-editor/tools/connections-view-tooltip.html"})}});app.service("FlowZonesView",function(StandardFlowViews){this.getDefinition=function(){return StandardFlowViews.getDefinition("FLOW_ZONES","Flow Zones",{getRepr:function(val){return val.id},tooltipTemplate:"/templates/flow-editor/tools/flow-zones-view-tooltip.html",settingsTemplate:"/templates/flow-editor/tools/flow-zones-settings.html"})}});app.service("TagsView",function($rootScope,$filter,$injector,$stateParams,translate,DataikuAPI,CreateModalFromTemplate,TaggableObjectsUtils,TaggingService,FlowTool,FlowGraph,FlowToolsUtils,StandardFlowViews){this.getDefinition=function(){return StandardFlowViews.getDefinition("TAGS","Tags",{postInit:function(tool){tool.manageTags=function(){CreateModalFromTemplate("/templates/widgets/edit-tags-modal.html",$rootScope,null,function(modalScope){modalScope.translate=translate;modalScope.tagsDirty=angular.copy(TaggingService.getProjectTags());modalScope.save=function(){TaggingService.saveToBackend(modalScope.tagsDirty).then(modalScope.resolveModal).catch(setErrorInScope.bind(modalScope))};modalScope.cancel=function(){modalScope.dismiss()}})};tool.displayGlobalTags=true},getRepr:function(val){return val},postProcessNode:function(tags,nodeElt,tool){if(!tags)return;tags.forEach(function(tag,idx){function onClick(){tool.user.focus(tag);$rootScope.$digest();d3.event.stopPropagation();d3.event.preventDefault()}FlowToolsUtils.addViewValueIndicator(nodeElt,$filter("tagToColor")(tag),idx,onClick)})},actions:{setTags:function(tags,nodes,mode){const request={elements:nodes.map(TaggableObjectsUtils.fromNode),operations:[{mode:mode,tags:tags}]};DataikuAPI.taggableObjects.applyTagging($stateParams.projectKey,request).success(function(data){TaggingService.bcastTagUpdate(false,true)}).error(FlowGraph.setError())}},autoSelectFirstOnly:true,tooltipTemplate:"/templates/flow-editor/tools/tags-view-tooltip.html"})}});app.service("CustomFieldsView",function($rootScope,FlowTool,StandardFlowViews,objectTypeFromNodeFlowType){function getSelectedOption(value,fromLabel){if(!FlowTool.getCurrent().currentSession||!FlowTool.getCurrent().currentSession.options||FlowTool.getCurrent().currentSession.options.selectedCustomField){return null}let selectedCustomField=FlowTool.getCurrent().currentSession.options.selectedCustomField;for(let taggableType in $rootScope.appConfig.customFieldsMap){if($rootScope.appConfig.customFieldsMap.hasOwnProperty(taggableType)){let componentList=$rootScope.appConfig.customFieldsMap[taggableType];for(let i=0;i<componentList.length;i++){let paramDesc=(componentList[i].customFields.filter(cf=>cf.type=="SELECT"&&cf.selectChoices)||[]).find(cf=>cf.name==selectedCustomField);if(paramDesc){let selOpt=(paramDesc.selectChoices||[]).find(function(choice){if(fromLabel){return value&&choice.label==value}else{return value?choice.value==value:paramDesc.defaultValue&&choice.value==paramDesc.defaultValue}});if(selOpt){return selOpt}}}}}return null}this.getDefinition=function(){return StandardFlowViews.getDefinition("CUSTOM_FIELDS","Metadata fields",{getRepr:function(val){let selOpt=getSelectedOption(val);return selOpt&&(selOpt.label||selOpt.value)||val},postInit:function(tool){tool.objectTypeFromNodeFlowType=objectTypeFromNodeFlowType},tooltipTemplate:"/templates/flow-editor/tools/custom-fields-view-tooltip.html"})}});app.service("ScenariosView",function($rootScope,FlowToolsUtils,StandardFlowViews){const ACTIONS={build_flowitem:"Build",clear_items:"Clear",check_dataset:"Verify rules or run checks",compute_metrics:"Compute metrics",sync_hive:"Synchronize Hive",update_from_hive:"Update from Hive"};this.getDefinition=function(){return StandardFlowViews.getDefinition("SCENARIOS","Scenarios",{getRepr:function(uses){return uses.map(use=>use.scenarioName+" ("+use.scenarioId+")")},postProcessNode:function(uses,nodeElt,tool){if(!uses)return;uses.forEach(function(use,idx){function onClick(){tool.user.focus(use);$rootScope.$digest();d3.event.stopPropagation();d3.event.preventDefault()}const fullId=use.scenarioName+" ("+use.scenarioId+")";FlowToolsUtils.addViewValueIndicator(nodeElt,tool.user.getColor(fullId),idx,onClick)})},actions:{getActionsNames(actions){if(!actions)return;return actions.map(a=>ACTIONS[a])}},autoSelectFirstOnly:true,tooltipTemplate:"/templates/flow-editor/tools/scenarios-view-tooltip.html"})}});app.service("FileformatsView",function(StandardFlowViews){this.getDefinition=function(){return StandardFlowViews.getDefinition("FILEFORMATS","File format",{getRepr:val=>val.formatType,tooltipTemplate:"/templates/flow-editor/tools/fileformats-view-tooltip.html"})}});app.service("PipelinesView",function(StandardFlowViews){this.getService=function(toolName){let displayName;if(toolName==="SPARK_PIPELINES"){displayName="Spark pipelines"}else if(toolName==="SQL_PIPELINES"){displayName="SQL pipelines"}return{getDefinition:function(){return StandardFlowViews.getDefinition(toolName,displayName,{getRepr:function(val){if(val.pipelineId){return val.pipelineId}if(val.virtualizable){return null}return},totem:function(val){return{class:val.virtualizable?"icon-forward flow-totem-ok":"",style:""}},tooltipTemplate:"/templates/flow-editor/tools/pipeline-view-tooltip.html"})}}}});app.service("ImpalaWriteModeView",function(StandardFlowViews){this.getDefinition=function(){return StandardFlowViews.getDefinition("IMPALA_WRITE_MODE","Impala write mode",{getRepr:val=>val})}});app.service("HiveModeView",function(StandardFlowViews){this.getDefinition=function(){return StandardFlowViews.getDefinition("HIVE_MODE","Hive mode",{getRepr:function(val){if(val=="HIVECLI_LOCAL")return"Hive CLI (isolated metastore)";if(val=="HIVECLI_GLOBAL")return"Hive CLI (global metastore)";if(val=="HIVESERVER2")return"HiveServer2";return val}})}});app.service("PartitioningView",function(StandardFlowViews){this.getDefinition=function(){return StandardFlowViews.getDefinition("PARTITIONING","Partitioning schemes",{getRepr:function(val){if(val.dimensions.length){return val.dimensions.map(x=>x.name).sort().join(", ")}else{return"Not partitioned"}},tooltipTemplate:"/templates/flow-editor/tools/partitioning-view-tooltip.html"})}});app.service("PartitionsView",function(StandardFlowViews){this.getDefinition=function(){return StandardFlowViews.getDefinition("PARTITIONS","Partitions count",{getRepr:function(val){return val},tooltipTemplate:"/templates/flow-editor/tools/partitions-view-tooltip.html"})}});app.service("ColumnUsageView",function(StandardFlowViews,ColorPalettesService,FlowToolsUtils,$rootScope){this.getDefinition=function(){return StandardFlowViews.getDefinition("COLUMN_USAGE","Column usage",{getRepr:function(val){return val},postProcessNode:function(values,nodeElt,tool){if(!values)return;values.forEach(function(value,idx){function onClick(){tool.user.focus(value);$rootScope.$digest();d3.event.stopPropagation();d3.event.preventDefault()}FlowToolsUtils.addViewValueIndicator(nodeElt,tool.user.getColor(value),idx,onClick)})},tooltipTemplate:"/templates/flow-editor/tools/column-usage-tooltip.html"})}});app.service("DataQualityView",function(StandardFlowViews){this.getDefinition=function(){return StandardFlowViews.getDefinition("DATA_QUALITY","Data quality",{postInit:function(tool){tool.currentSession.options.includeForeignObjects=tool.currentSession.options.includeForeignObjects||false},getRepr:function(val){return{ERROR:"Error",WARNING:"Warning",OK:"OK",EMPTY:"Empty",_:"Not Computed"}[val.lastOutcome||"_"]},tooltipTemplate:"/templates/flow-editor/tools/data-quality-tooltip.html"})}});app.service("RecentActivityView",function(StandardFlowViews){this.getDefinition=function(){return StandardFlowViews.getDefinition("RECENT_ACTIVITY","Recent modifications",{getRepr:function(val){return val.numberOfModifications},tooltipTemplate:"/templates/flow-editor/tools/recent-activity-view-tooltip.html"})}});app.service("FilesizeView",function(StandardFlowViews){this.getDefinition=function(){return StandardFlowViews.getDefinition("FILESIZE","File size",{getRepr:function(val){let totalValue=parseFloat(val.size.totalValue);if(isNaN(totalValue)||totalValue<=0){return"Unknown"}return totalValue},tooltipTemplate:"/templates/flow-editor/tools/filesize-view-tooltip.html"})}});app.service("CountOfRecordsView",function($filter,StandardFlowViews,DataikuAPI,$stateParams,FlowGraph,$rootScope,DatasetsService,Dialogs){this.getDefinition=function(){return StandardFlowViews.getDefinition("COUNT_OF_RECORDS","Records count",{getRepr:function(val){let totalValue=parseFloat(val.countOfRecords.totalValue);if(totalValue==-1){return"Unknown"}return totalValue},postInit:function(tool){const listDatasetsToCompute=function(datasets,computeOnlyMissingRecordsCount){if(!computeOnlyMissingRecordsCount){return datasets}const datasetsToCount=[];for(const dataset of datasets){if(dataset.id){const datasetGraphId=graphVizEscape(`dataset_${dataset.id}`);const isRecordCountComputed=tool.user.state.valueByNode&&tool.user.state.valueByNode[datasetGraphId]&&tool.user.state.valueByNode[datasetGraphId].countOfRecords&&tool.user.state.valueByNode[datasetGraphId].countOfRecords.hasData;if(!isRecordCountComputed){datasetsToCount.push(dataset)}}}return datasetsToCount};tool.compute=function(computeOnlyMissingRecordsCount){DataikuAPI.flow.listUsableComputables($stateParams.projectKey,{datasetsOnly:true}).success(datasets=>{const datasetsToCount=listDatasetsToCompute(datasets,computeOnlyMissingRecordsCount);DatasetsService.refreshSummaries($rootScope,datasetsToCount,true,false,true).then(function(result){tool.refreshState();return result}).then(function(result){if(result&&result.anyMessage){Dialogs.infoMessagesDisplayOnly($rootScope,"Datasets statuses update results",result)}}).catch(FlowGraph.setError())}).error(FlowGraph.setError())}},totem:function(val){const countOfRecordsText=sanitize(val.countOfRecords.totalValue<0?"-":$filter("longSmartNumber")(val.countOfRecords.totalValue));return{class:"icon-refresh "+(val.autoCompute?"flow-totem-ok":"flow-totem-disabled"),style:"",text:countOfRecordsText}},tooltipTemplate:"/templates/flow-editor/tools/count-of-records-view-tooltip.html"})}});const DATE_REPR=["Just now","Past hour","Past 24h","Past week","Past month","Past year","More than a year ago","Unknown"];function simpleTimeDelta(timestamp){if(typeof timestamp=="string"&&!isNaN(parseFloat(timestamp))){timestamp=parseFloat(timestamp)}if(!timestamp||typeof timestamp!="number"){return DATE_REPR[7]}const seconds=((new Date).getTime()-timestamp)/1e3;if(seconds<60){return DATE_REPR[0]}if(seconds<3600){return DATE_REPR[1]}if(seconds<3600*24){return DATE_REPR[2]}if(seconds<3600*24*7){return DATE_REPR[3]}if(seconds<3600*24*30){return DATE_REPR[4]}if(seconds<3600*24*365){return DATE_REPR[5]}return DATE_REPR[6]}app.service("CreationView",function(StandardFlowViews,UserImageUrl,FlowTool){const viewByUser={getRepr:function(val){return val.userLogin}};const viewByDate={getRepr:function(val){const time=parseFloat(val.time);return simpleTimeDelta(time)}};function getSubview(){const mode=FlowTool.getCurrent().currentSession.options.mode;if(mode=="BY_USER"){return viewByUser}return viewByDate}this.getDefinition=function(){return StandardFlowViews.getDefinition("CREATION","Creation",{postInit:function(tool){tool.currentSession.options.mode=tool.currentSession.options.mode||"BY_DATE"},getRepr:function(val){if(!val)return;return getSubview().getRepr(val)},totem:function(val){return{class:"avatar32",style:"background-image: url('"+UserImageUrl(val.userLogin,128)+"'); box-sizing: border-box;"}},tooltipTemplate:"/templates/flow-editor/tools/creation-view-tooltip.html",settingsTemplate:"/templates/flow-editor/tools/creation-view-settings.html"})}});app.service("LastModifiedView",function(StandardFlowViews,UserImageUrl,FlowTool){const viewByUser={getRepr:function(val){return val.userLogin}};const viewByDate={getRepr:function(val){const time=parseFloat(val.time);return simpleTimeDelta(time)}};function getSubview(){const mode=FlowTool.getCurrent().currentSession.options.mode;if(mode=="BY_USER"){return viewByUser}return viewByDate}this.getDefinition=function(){return StandardFlowViews.getDefinition("LAST_MODIFICATION","Last modification",{postInit:function(tool){tool.currentSession.options.mode=tool.currentSession.options.mode||"BY_DATE"},getRepr:function(val){if(!val)return;return getSubview().getRepr(val)},totem:function(val){return{class:"avatar32",style:"background-image: url('"+UserImageUrl(val.userLogin,128)+"'); box-sizing: border-box;"}},tooltipTemplate:"/templates/flow-editor/tools/last-modification-view-tooltip.html"})}});app.service("LastBuildView",function(StandardFlowViews){this.getDefinition=function(){return StandardFlowViews.getDefinition("LAST_BUILD","Last build",{getRepr:function(val){if(!val)return;const time=parseFloat(val.buildEndTime);return simpleTimeDelta(time)},totem:function(val){return{class:val.buildSuccess?"icon-ok flow-totem-ok":"icon-remove flow-totem-error",style:""}},tooltipTemplate:"/templates/flow-editor/tools/last-build-view-tooltip.html"})}});app.service("LastBuildDurationView",function(StandardFlowViews){this.getDefinition=function(){return StandardFlowViews.getDefinition("LAST_BUILD_DURATION","Last build duration",{getRepr:function(val){if(val<0)return;return val},tooltipTemplate:"/templates/flow-editor/tools/last-build-duration-view-tooltip.html"})}});app.service("RecipesEnginesView",function($filter,StandardFlowViews){const RECIPE_ENGINE_NAMES={DSS:"DSS",USER_CODE:"User code",PLUGIN_CODE:"Plugin code",HADOOP_MAPREDUCE:"Hadoop MapReduce",SPARK:"Spark",PIG:"Pig",SQL:"SQL",HIVE:"Hive",IMPALA:"Impala",S3_TO_REDSHIFT:"S3 to Redshift",REDSHIFT_TO_S3:"Redshift to S3",AZURE_TO_SQLSERVER:"Azure to SQLServer",TDCH:"Teradata Hadoop Connector",GCS_TO_BIGQUERY:"GCS to BigQuery",BIGQUERY_TO_GCS:"BigQuery to GCS",S3_TO_SNOWFLAKE:"S3 to Snowflake",SNOWFLAKE_TO_S3:"Snowflake to S3",WASB_TO_SNOWFLAKE:"WASB to Snowflake",SNOWFLAKE_TO_WASB:"Snowflake to WASB",GCS_TO_SNOWFLAKE:"GCS to Snowflake",SNOWFLAKE_TO_GCS:"Snowflake to GCS",AZURE_TO_DATABRICKS:"Azure to Databricks",DATABRICKS_TO_AZURE:"Databricks to Azure",S3_TO_DATABRICKS:"S3 to Databricks",DATABRICKS_TO_S3:"Databricks to S3","DOCKER/KUBERNETES":"Docker/Kubernetes"};const RUN_IN_CONTAINER_SUFFIX=" in container";this.getDefinition=function(){return StandardFlowViews.getDefinition("RECIPES_ENGINES","Recipe engines",{getRepr:function(engineStatus){let engineType=engineStatus.type;let runInContainer=engineType.endsWith(RUN_IN_CONTAINER_SUFFIX);if(runInContainer){engineType=engineType.slice(0,-RUN_IN_CONTAINER_SUFFIX.length)}let result=RECIPE_ENGINE_NAMES[engineType];if(!result){return $filter("capitalize")(engineStatus.type.toLowerCase().replaceAll("_"," "))}return result+(runInContainer?RUN_IN_CONTAINER_SUFFIX:"")},totem:function(val){return{class:val.statusWarnLevel==="ERROR"?"icon-remove flow-totem-error":"",style:""}},tooltipTemplate:"/templates/flow-editor/tools/recipes-engines-view-tooltip.html"})}});app.service("RecipesCodeEnvsView",function(StandardFlowViews){this.getDefinition=function(){return StandardFlowViews.getDefinition("RECIPES_CODE_ENVS","Recipe code environments",{getRepr:function(codeEnvState){return codeEnvState.selectedEnvName||codeEnvState.envName||"DSS builtin env"},totem:function(val){return{class:val.preventedByProjectSettings?"icon-remove flow-totem-error":"",style:""}},tooltipTemplate:"/templates/flow-editor/tools/recipes-code-envs-view-tooltip.html"})}});app.service("StandardFlowViews",function($stateParams,Ng1ToolBridgeService,Debounce,FlowViewsUtils,FlowGraph,FlowGraphHighlighting){this.getDefinition=function(name,displayName,{getRepr,totem,tooltipTemplate,settingsTemplate,postInit,postProcessNode,actions}){return{getName:()=>name,getToolDisplayName:()=>displayName,initFlowTool:function(tool,viewData){tool.user={};tool.projectKey=$stateParams.projectKey;tool.update=viewData=>{tool.user.state=viewData;tool.currentSession.options.mode=tool.user.state.mode;const countByValue={};$.each(tool.user.state.valueByNode,function(nodeId,val){const repr=getRepr(val);if(angular.isArray(repr)){repr.forEach(function(it){countByValue[it]=(countByValue[it]||0)+1})}else if(repr!==null&&repr!==undefined){countByValue[repr]=(countByValue[repr]||0)+1}});tool.user.state.countByValue=countByValue;tool.user.state.values=Object.keys(countByValue);if(postInit){postInit(tool)}tool.drawHooks.updateFlowToolDisplay();Ng1ToolBridgeService().viewLoaded()};tool.refreshState=function(){Ng1ToolBridgeService().emitRefreshView()};tool.refreshStateLater=Debounce().withDelay(400,400).wrap(tool.refreshState);FlowViewsUtils.addFocusBehavior(tool,true);tool.user.getColor=function(repr){if(!repr||repr==="Unknown"||!Ng1ToolBridgeService().activeView){return"#333"}return Ng1ToolBridgeService().activeView.getColor(repr)};tool.drawHooks.updateFlowToolDisplay=function(){if(!tool.user.state)return;if(!FlowGraph.ready())return;$.each(FlowGraph.get().nodes,function(nodeId,node){let realNodeId=node.realId||nodeId;const nodeElt=FlowGraph.d3NodeWithId(nodeId);if(tool.user.state.valueByNode[realNodeId]===undefined){$(".node-totem span",nodeElt[0]).removeAttr("style").removeClass();$(".nodecounter__text div span",nodeElt[0]).text("");$(".never-built-computable *",nodeElt[0]).removeAttr("style")}$(".nodecounter__wrapper",nodeElt[0]).removeClass("nodecounter__wrapper--shown")});$(".tool-simple-zone",FlowGraph.getSvg()).empty();function styleNodes(recipesOnly){$.each(FlowGraph.get().nodes,function(nodeId,node){let val=tool.user.state.valueByNode[node.realId];if(!node){return}const isRecipe=node.nodeType=="RECIPE";if(recipesOnly!=isRecipe){return}const isZone=node.nodeType=="ZONE";if(isZone&&Ng1ToolBridgeService().activeView&&tool.user.state.focusMap&&tool.user.state.focusMap[node.name]&&!$stateParams.zoneId){FlowGraphHighlighting.highlightZoneCluster(d3.select(`g[id=cluster_zone_${node.name}]`)[0][0],Ng1ToolBridgeService().activeView.getColor(node.name))}if(val!==undefined){const nodeElt=FlowGraph.d3NodeWithIdFromType(nodeId,node.nodeType);if(!isZone&&FlowGraph.rawNodeWithId(nodeId)===undefined){return}const nodeTotem=$(".node-totem span",nodeElt[0]);nodeTotem.removeAttr("style").removeClass();if(totem&&totem(val)){nodeTotem.attr("style",totem(val).style).addClass(totem(val).class)}const nodeCounter=$(".nodecounter__text div span",nodeElt[0]);const nodeCounterWrapper=$(".nodecounter__wrapper",nodeElt[0]);nodeCounter.text("");if(totem&&totem(val)){if(totem(val).text!==undefined){const nodeCounterText=totem(val).text;nodeCounter.text(nodeCounterText);nodeCounterWrapper.addClass("nodecounter__wrapper--shown")}}if(postProcessNode){postProcessNode(val,nodeElt,tool)}}})}styleNodes(false);styleNodes(true)};tool.drawHooks.setupTooltip=function(node){const activeView=Ng1ToolBridgeService().activeView;if(!tool.user||!tool.user.state||!activeView)return;const tooltip={};tooltip.val=tool.user.state.valueByNode[node.realId];tooltip.template=tooltipTemplate||"/templates/flow-editor/tools/default-view-tooltip.html";const nodeViewCategories=activeView.getNodeCategories(node);if(!tooltip.val||nodeViewCategories.length===0){return tooltip}if(nodeViewCategories.length===1){const category=nodeViewCategories[0];let bulletText=tool.type=="FLOW_ZONES"?tooltip.val.name:category;tooltip.bullets=[{text:bulletText,color:activeView.getColor(category)}]}else if(nodeViewCategories.length>1){const focused=tool.user.getFocusedAsList();const matchedValues=nodeViewCategories.filter(_=>focused.indexOf(_)!==-1);if(matchedValues.length===1){tooltip.bullets=[{text:matchedValues[0],color:activeView.getColor(matchedValues[0])}]}else{tooltip.bullets=[];matchedValues.forEach(value=>{tooltip.bullets.push({text:value,color:activeView.getColor(value)})})}}return tooltip};tool.getRepr=getRepr;tool.def.settingsTemplate=settingsTemplate;tool.actions=actions;tool.update(viewData)}}}});app.controller("StandardFlowViewsMainController",function($scope,FlowTool){$scope.tool=FlowTool.getCurrent()})})();(function(){"use strict";const app=angular.module("dataiku.flow.tools");app.service("CopyFlowTool",function($rootScope,$stateParams,DataikuAPI,FlowToolsUtils,FlowGraph,Ng1ToolBridgeService){const NAME="COPY";const DISPLAY_NAME="Copy";this.getDefinition=function(){return{getName:()=>NAME,getToolDisplayName:()=>DISPLAY_NAME,initFlowTool:function(tool){tool.user={updateOptions:{recheckAll:false,datasets:{consistencyWithData:true},recipes:{schemaConsistency:true,otherExpensiveChecks:true}},updateStatus:{updating:false}};tool.action=true;Ng1ToolBridgeService().emitActionTool(true);function updateNodeStates(){tool.user.state.stateByNode={};tool.user.state.countByState={REQUESTED:0,REQUIRED:0,REUSED:0};const stateByNode=tool.user.state.stateByNode;$.each(FlowGraph.get().nodes,function(nodeId,node){if(tool.user.state.requested[nodeId]){if(node.projectKey===$stateParams.projectKey){stateByNode[nodeId]="REQUESTED"}else{stateByNode[nodeId]="REUSED"}}});$.each(FlowGraph.get().nodes,function(nodeId,node){if(tool.user.state.requested[nodeId]==="REQUESTED"&&node.nodeType!=="RECIPE"&&node.nodeType!=="LABELING_TASK"){for(let p of node.predecessors){if(stateByNode[p]){return}}let anyCopiedSuccessor=false;for(let p of node.successors){if(stateByNode[p]){anyCopiedSuccessor=true;break}}if(!anyCopiedSuccessor){return}stateByNode[nodeId]="REUSED"}});$.each(FlowGraph.get().nodes,function(nodeId,node){if(stateByNode[nodeId]){if(["RECIPE","LOCAL_SAVEDMODEL","LABELING_TASK"].includes(node.nodeType)){$.each(node.successors,function(index,nodeId2){if(!stateByNode[nodeId2]){stateByNode[nodeId2]="REQUIRED"}})}}});$.each(FlowGraph.get().nodes,function(nodeId,node){if(stateByNode[nodeId]){if(["RECIPE","LOCAL_SAVEDMODEL","LABELING_TASK"].includes(node.nodeType)){$.each(node.predecessors,function(index,nodeId2){if(!stateByNode[nodeId2]){stateByNode[nodeId2]="REUSED"}})}}});$.each(FlowGraph.get().nodes,function(nodeId,node){const nodeState=stateByNode[nodeId];if(nodeState){tool.user.state.countByState[nodeState]++}})}const COLORS={REQUESTED:"green",REQUIRED:"#41f544",REUSED:"#ffc500"};function colorNodes(){$.each(FlowGraph.get().nodes,function(nodeId,node){const nodeElt=FlowGraph.d3NodeWithIdFromType(nodeId,node.nodeType);const nodeState=tool.user.state.stateByNode[nodeId];nodeElt.classed("focus",false).classed("out-of-focus",false);$(".tool-simple-zone",FlowGraph.getSvg()).empty();$(".node-totem span",nodeElt[0]).removeAttr("style").removeClass();$(".never-built-computable *",nodeElt[0]).removeAttr("style");const color=COLORS[nodeState]||"#e2e2e2";FlowToolsUtils.colorNode(node,nodeElt,color)})}tool.drawHooks.updateFlowToolDisplay=function(){if(!tool.user.state)return;if(!FlowGraph.ready())return;updateNodeStates();colorNodes()};DataikuAPI.flow.tools.getState($stateParams.projectKey,NAME,{}).success(function(data){tool.user.state=data;tool.user.state.requested=tool.user.state.requested||[];if(tool.user.state.preselectedNodes){tool.user.state.preselectedNodes.forEach(function(nodeId){tool.user.state.requested[nodeId]="REQUESTED"})}tool.drawHooks.updateFlowToolDisplay()}).error(FlowGraph.setError());return tool},template:"/templates/flow-editor/tools/tool-copy.html"}}});app.controller("CopyToolController",function($scope,$stateParams,Assert,DataikuAPI,TaggableObjectsUtils,FlowGraphSelection,FlowGraph,FlowToolsUtils,SubFlowCopyService){Assert.inScope($scope,"tool");$scope.addSelected=function(forceAdd){const statesBefore=angular.copy($scope.tool.user.state.stateByNode);const requested=$scope.tool.user.state.requested;FlowGraphSelection.getSelectedNodes().forEach(function(it){if(requested[it.id]!="FORCED"){requested[it.id]=forceAdd?"FORCED":"REQUESTED"}});$scope.tool.drawHooks.updateFlowToolDisplay();if(!forceAdd&&angular.equals($scope.tool.user.state.stateByNode,statesBefore)){$scope.addSelected(true)}};$scope.removeSelected=function(){const requested=$scope.tool.user.state.requested;FlowGraphSelection.getSelectedNodes().forEach(function(it){delete requested[it.id]});$scope.tool.drawHooks.updateFlowToolDisplay()};$scope.reset=function(){$scope.tool.user.state.requested=[];$scope.tool.drawHooks.updateFlowToolDisplay()};function getSelectedTaggableObjectRefs(){const items=[];const itemsByZones={};$.each(FlowGraph.get().nodes,function(nodeId,node){if(nodeId.startsWith("zone__")&&node.nodeType!=="ZONE"&&(!node.isSource||node.isSink||node.nodeType==="RECIPE")){const zoneId=nodeId.substring("zone__".length,node.id.length-node.realId.length-2);if(node.ownerZone===zoneId){if(!itemsByZones[zoneId]){itemsByZones[zoneId]=[]}const zoneContent=itemsByZones[zoneId];zoneContent.push(TaggableObjectsUtils.fromNode(node))}}if(["REQUESTED","REQUIRED"].includes($scope.tool.user.state.stateByNode[nodeId])){items.push(TaggableObjectsUtils.fromNode(node))}});return{selectedTaggableObjectRefs:items,itemsByZones:itemsByZones}}$scope.go=function(){const{selectedTaggableObjectRefs,itemsByZones}=getSelectedTaggableObjectRefs();SubFlowCopyService.start(selectedTaggableObjectRefs,itemsByZones)}})})();(function(){"use strict";const app=angular.module("dataiku.flow.tools");app.service("PropagateSchemaFlowTools",function($rootScope,$stateParams,DataikuAPI,ContextualMenu,Logger,FlowGraph,FlowViewsUtils,FlowToolsUtils,$q,ComputableSchemaRecipeSave,Ng1ToolBridgeService){const NAME="PROPAGATE_SCHEMA";this.getDefinition=function(){return{getName:()=>NAME,getToolDisplayName:function(toolDef){return"Check schema from "+toolDef.toolInitialData.datasetName},initFlowTool:function(tool){tool.user={updateStatus:{updating:false},preconfiguredProfile:"AUTO_FAST",updateOptions:{performExpensive:true,doAnyRebuildingReqd:false,doBuildAll:false,recheckAll:false,markUncheckableAsOK:false,alwaysRebuildInputOfRecipesUsuallyComputingOutputSchemaBasedOnData:true,alwaysRebuildOutputOfRecipesUsuallyComputingOutputSchemaAtRuntime:true}};tool.action=true;Ng1ToolBridgeService().emitActionTool(true);tool.user.canMarkRecipeAsOK=function(recipeName){let nodeId=graphVizEscape("recipe_"+recipeName);if(tool.user.state&&tool.user.state.stateByNode[nodeId]){return tool.user.state.stateByNode[nodeId].state!="OK"}else{return false}};tool.user.markRecipeAsOK=function(recipeName){DataikuAPI.flow.tools.propagateSchema.markRecipeAsOKForced($stateParams.projectKey,recipeName).success(function(data){tool.user.state=data;tool.drawHooks.updateFlowToolDisplay()})};tool.drawHooks.updateFlowToolDisplay=function(){if(!tool.user.state)return;if(!FlowGraph.ready())return;let svg=FlowGraph.getSvg();tool.user.state.itemsToRebuild=[];$.each(FlowGraph.get().nodes,function(nodeId,node){const nodeElt=FlowGraph.d3NodeWithId(nodeId);const nodeState=tool.user.state.stateByNode[node.realId];nodeElt.classed("focus",false).classed("out-of-focus",false);$(".tool-simple-zone",FlowGraph.getSvg()).empty();$(".node-totem span",nodeElt[0]).removeAttr("style").removeClass();$(".never-built-computable *",nodeElt[0]).removeAttr("style");if(!nodeState){const color="#E9E9E9";FlowToolsUtils.colorNode(node,nodeElt,color);svg.find('[data-to="'+nodeId+'"]').each(function(){d3.select(this).classed("grey-out-path",true).selectAll("path, ellipse").classed("grey-out-path",true)});svg.find('[data-from="'+nodeId+'"]').each(function(){d3.select(this).classed("grey-out-path",true).selectAll("path, ellipse").classed("grey-out-path",true)})}else if(nodeState.state=="DATASET_NEEDS_REBUILD"){node.partitioning=nodeState.partitioning;node.buildPartitions=nodeState.buildPartitions;tool.user.state.itemsToRebuild.push({type:"DATASET",node:node});FlowToolsUtils.colorNode(node,nodeElt,"orange")}else if(nodeState.state=="UNCHECKABLE"){FlowToolsUtils.colorNode(node,nodeElt,"orange")}else if(nodeState.state=="EXCLUDED"){FlowToolsUtils.colorNode(node,nodeElt,"lightgrey")}else if(nodeState.state=="UNCHECKED"){FlowToolsUtils.colorNode(node,nodeElt,"grey")}else if(nodeState.state=="OK"){FlowToolsUtils.colorNode(node,nodeElt,"green")}else if(nodeState.state=="NOK"){FlowToolsUtils.colorNode(node,nodeElt,"red")}else if(nodeState.state=="FAILED_CHECK"){FlowToolsUtils.colorNode(node,nodeElt,"purple")}})};tool.user.ignoreAllSuggestionsWithState=function(parentScope,state){var promises=[];$.each(FlowGraph.get().nodes,function(nodeId,node){const nodeElt=FlowGraph.d3NodeWithId(nodeId);const nodeState=tool.user.state.stateByNode[node.realId];if(nodeState&&nodeState.state==state){Logger.info("Ignoring suggestion on node",nodeId);const recipeName=node.name;var deferred=$q.defer();DataikuAPI.flow.tools.propagateSchema.markRecipeAsOKForced($stateParams.projectKey,recipeName).success(function(data){deferred.resolve()}).error(FlowGraph.setError());promises.push(deferred.promise)}});Logger.info("Waiting on ",promises.length,"promises");$q.all(promises).then(function(){Logger.info("Done Waiting on ",promises.length,"promises");parentScope.update()})};tool.user.acceptAllRecipeSuggestions=function(parentScope){var promises=[];$.each(FlowGraph.get().nodes,function(nodeId,node){const nodeElt=FlowGraph.d3NodeWithId(nodeId);const nodeState=tool.user.state.stateByNode[node.realId];if(nodeState&&nodeState.state=="NOK"){Logger.info("Accepting suggestion on node",nodeId);const recipeName=node.name;var deferred=$q.defer();ComputableSchemaRecipeSave.handleSchemaUpdateWithPrecomputedUnattended(parentScope,nodeState.updateSolution).then(function(){Logger.info("Acceptance done on ",recipeName);DataikuAPI.flow.tools.propagateSchema.markRecipeAsOKAfterUpdate($stateParams.projectKey,recipeName).success(function(data){Logger.info("recipe marked as done, resolving deferred");deferred.resolve()}).error(FlowGraph.setError())});promises.push(deferred.promise)}});Logger.info("Waiting on ",promises.length,"promises");$q.all(promises).then(function(){Logger.info("Done Waiting on ",promises.length,"promises");parentScope.update()})};tool.actionHooks.onItemClick=function(node,evt){if(!tool.user.state)return;let nodeState=tool.user.state.stateByNode[node.realId];Logger.info("onItemClick nodeState ",nodeState);ContextualMenu.prototype.closeAny();if(nodeState&&["NOK","FAILED_CHECK","UNCHECKABLE"].indexOf(nodeState.state)>=0){let menuScope=$rootScope.$new();menuScope.nodeState=nodeState;menuScope.node=node;new ContextualMenu({template:"/templates/flow-editor/tools/propagate-schema-item-popup.html",scope:menuScope,contextual:false,controller:"FlowToolPropagateItemPopupController"}).openAtEventLoc(evt)}else if(nodeState&&nodeState.state=="DATASET_NEEDS_REBUILD"){let menuScope=$rootScope.$new();menuScope.nodeState=nodeState;menuScope.node=node;new ContextualMenu({template:"/templates/flow-editor/tools/propagate-dataset-needs-rebuild-popup.html",scope:menuScope,contextual:false,controller:"FlowToolPropagateDatasetNeedsRebuildPopupController"}).openAtEventLoc(evt)}};FlowViewsUtils.addAsynchronousStateComputationBehavior(tool);DataikuAPI.flow.tools.getState($stateParams.projectKey,NAME,{}).success(function(data){tool.user.state=data;tool.drawHooks.updateFlowToolDisplay()}).error(FlowGraph.setError());return tool},template:"/templates/flow-editor/tools/tool-propagate-schema.html"}}});app.controller("PropagateSchemaFlowToolMainController",function($scope,$q,Logger,DataikuAPI,$timeout,$stateParams,ActivityIndicator,Assert,JobDefinitionComputer,ComputableSchemaRecipeSave,PartitionSelection,CreateModalFromTemplate,$filter,AnyLoc){checkChangesBeforeLeaving($scope,function(){return $scope.tool.user.updateStatus.multiPhaseUpdating},"Schema propagation in progress.  Leaving will abort the operation");function getCountOfProblemItems(){let sum=$scope.tool.user.state.summary;return sum.NOK+sum.UNCHECKABLE+sum.UNCHECKED+sum.DATASET_NEEDS_REBUILD+sum.FAILED_CHECK}function isAnyRebuildingReqd(){let ret=$scope.tool.user.updateOptions.doAnyRebuildingReqd||$scope.tool.user.updateOptions.doBuildAll;Logger.info("isAnyRebuildingReqd:",ret);return ret}function getItemToRebuild(toDoList,doneList){let item=toDoList.find(item=>{return!doneList.includes(item.node.id)});if(item){doneList.push(item.node.id)}return item}function showIndicator(txt,isSuccess){Logger.info("Showing indicator text:",txt,"success:",isSuccess);$scope.updateText=txt;if(isSuccess){$timeout(()=>$scope.updateText="",4e3)}}function markDatasetAsOK(datasetName){return DataikuAPI.flow.tools.propagateSchema.markDatasetAsBeingRebuilt($stateParams.projectKey,datasetName)}$scope.$watch("tool.user.preconfiguredProfile",function(nv,ov){Logger.info("Update profile",nv);if(!nv)return;switch(nv){case"AUTO_FAST":$scope.tool.user.updateOptions.performExpensive=true;$scope.tool.user.updateOptions.doAnyRebuildingReqd=true;$scope.tool.user.updateOptions.markUncheckableAsOK=true;$scope.tool.user.updateOptions.doBuildAll=false;$scope.tool.user.updateOptions.alwaysRebuildInputOfRecipesUsuallyComputingOutputSchemaBasedOnData=false;$scope.tool.user.updateOptions.alwaysRebuildOutputOfRecipesUsuallyComputingOutputSchemaAtRuntime=false;break;case"AUTO_THOROUGH":$scope.tool.user.updateOptions.performExpensive=true;$scope.tool.user.updateOptions.doAnyRebuildingReqd=true;$scope.tool.user.updateOptions.markUncheckableAsOK=false;$scope.tool.user.updateOptions.doBuildAll=false;$scope.tool.user.updateOptions.alwaysRebuildInputOfRecipesUsuallyComputingOutputSchemaBasedOnData=true;$scope.tool.user.updateOptions.alwaysRebuildOutputOfRecipesUsuallyComputingOutputSchemaAtRuntime=true;break;case"INTERACTIVE_FAST":$scope.tool.user.updateOptions.performExpensive=true;$scope.tool.user.updateOptions.doAnyRebuildingReqd=false;$scope.tool.user.updateOptions.doBuildAll=false;$scope.tool.user.updateOptions.markUncheckableAsOK=true;$scope.tool.user.updateOptions.alwaysRebuildInputOfRecipesUsuallyComputingOutputSchemaBasedOnData=false;$scope.tool.user.updateOptions.alwaysRebuildOutputOfRecipesUsuallyComputingOutputSchemaAtRuntime=false;break;case"INTERACTIVE_THOROUGH":$scope.tool.user.updateOptions.performExpensive=true;$scope.tool.user.updateOptions.doAnyRebuildingReqd=false;$scope.tool.user.updateOptions.doBuildAll=false;$scope.tool.user.updateOptions.markUncheckableAsOK=false;$scope.tool.user.updateOptions.alwaysRebuildInputOfRecipesUsuallyComputingOutputSchemaBasedOnData=true;$scope.tool.user.updateOptions.alwaysRebuildOutputOfRecipesUsuallyComputingOutputSchemaAtRuntime=true;break}Logger.info("Set options to",$scope.tool.user.updateOptions)});function buildDataset(node){const deferred=$q.defer();let jd=JobDefinitionComputer.computeJobDefForSingleDataset($stateParams.projectKey,"RECURSIVE_BUILD",node,node.buildPartitions?node.buildPartitions:{});if(!$scope.isAborting){$scope.startedJob={nodeType:"DATASET",nodeName:node.name,nodeId:node.id};DataikuAPI.flow.jobs.start(jd).then(data=>{$scope.startedJob.jobId=data.data.id;waitForEndOfStartedJob().then(()=>{showIndicator("Marking dataset as OK: "+$scope.startedJob.nodeName);let stateInfo=$scope.tool.user.state.stateByNode[node.realId];if(stateInfo&&stateInfo.state==="OK"){deferred.resolve()}else{markDatasetAsOK($scope.startedJob.nodeName).finally(()=>{deferred.resolve()})}},deferred.reject)},data=>{setErrorInScope.bind($scope)(data.data,data.status,data.headers);deferred.reject()})}return deferred.promise}function rebuildNextAsReqd(){Logger.info("Making next step of auto-progress");if($scope.isAborting){return false}if($scope.tool.user.state.summary.UNCHECKABLE>0){Logger.info("I have some uncheckables, marking them as OK");showIndicator("Marking all uncheckable as OK");$scope.tool.user.ignoreAllSuggestionsWithState($scope,"UNCHECKABLE");return true}if($scope.tool.user.state.summary.NOK>0){Logger.info("I have some NOK, accepting suggestions");showIndicator("Accepting all suggestings");$scope.tool.user.acceptAllRecipeSuggestions($scope);return true}else{Logger.info("No NOK nor UNCHECKABLE, building items that need to be built");return startRebuildNextItem()}}function startRebuildNextItem(){if(!$scope.itemsRebuildAttempted){$scope.itemsRebuildAttempted=[]}const item=getItemToRebuild($scope.tool.user.state.itemsToRebuild,$scope.itemsRebuildAttempted);if(!item){return false}else{Assert.trueish(item.type==="DATASET");showIndicator("Rebuilding dataset "+item.node.name);buildDataset(item.node).finally($scope.update);return true}}function markRecipeAsOK(recipeName,nodeId){const nodeState=$scope.tool.user.state.stateByNode[nodeId];if(nodeState){Logger.info("Accepting node after update",nodeId);let deferred=$q.defer();if(nodeState.state=="OK"){deferred.resolve()}else{ComputableSchemaRecipeSave.handleSchemaUpdateWithPrecomputedUnattended($scope,nodeState.updateSolution).then(function(){Logger.info("Acceptance done on ",recipeName);DataikuAPI.flow.tools.propagateSchema.markRecipeAsOKAfterUpdate($stateParams.projectKey,recipeName).success(function(data){Logger.info("recipe marked as done, resolving deferred");deferred.resolve()}).error(setErrorInScope.bind($scope))})}return deferred.promise}}function waitForEndOfStartedJob(){const deferred=$q.defer();function poll(){DataikuAPI.flow.jobs.getJobStatus($stateParams.projectKey,$scope.startedJob.jobId).then(function(data){$scope.startedJob.jobStatus=data.data;let status=$scope.startedJob.jobStatus.baseStatus.state;if(status!="DONE"&&status!="ABORTED"&&status!="FAILED"&&!$scope.isAborting){$scope.jobCheckTimer=$timeout(function(){poll()},2e3)}else if(status=="DONE"){deferred.resolve()}else{deferred.reject()}},setErrorInScope.bind($scope))}poll();return deferred.promise}function getBuildAllJobDef(){var outputs=$scope.computables.filter(d=>!d.removed).map(function(d){const fullId=graphIdFor(d.type,AnyLoc.makeLoc(d.projectKey,d.id).fullId);const nodeFound=$scope.tool.user.state.stateByNode[fullId];if(d.type==="DATASET"){return JobDefinitionComputer.computeOutputForDataset(d.serializedDataset,nodeFound?nodeFound.buildPartitions:PartitionSelection.getBuildPartitions(d.serializedDataset.partitioning))}else if(d.type==="MANAGED_FOLDER"){return JobDefinitionComputer.computeOutputForBox(d.box,nodeFound?nodeFound.buildPartitions:PartitionSelection.getBuildPartitions(d.box.partitioning))}else{return{targetDataset:d.id,targetDatasetProjectKey:d.projectKey,type:d.type}}});return{type:"RECURSIVE_BUILD",refreshHiveMetastore:true,projectKey:$stateParams.projectKey,outputs:outputs}}function startBuildAllJob(computables){if($scope.isAborting){return}$scope.computables=computables;showIndicator("Starting to build all...");DataikuAPI.flow.jobs.start(getBuildAllJobDef()).then(data=>{$scope.startedJob={jobId:data.data.id};showIndicator("Build all started...");waitForEndOfStartedJob().then(()=>{showIndicator("Build all completed",true);$scope.tool.user.updateStatus.multiPhaseUpdating=false},()=>{showIndicator("Build all failed",true);$scope.tool.user.updateStatus.multiPhaseUpdating=false})},setErrorInScope.bind($scope))}$scope.update=function(isStart){const deferred=$q.defer();if(isStart){$scope.isAborting=false;$scope.itemsRebuildAttempted=[];$scope.tool.user.updateOptions.recheckAll=getCountOfProblemItems()==0;$scope.tool.user.partitionedObjects=Object.values($scope.tool.user.state.stateByNode).filter(e=>e.partitioning).map(e=>Object.assign(e,{buildPartitions:[],name:AnyLoc.getLocFromSmart($stateParams.projectKey,e.fullId).localId}));if($scope.tool.user.partitionedObjects&&$scope.tool.user.partitionedObjects.length>0&&isAnyRebuildingReqd()){CreateModalFromTemplate("templates/flow-editor/tools/tool-propagate-schema-partitioning.html",$scope,null,function(newScope){newScope.computables=$scope.tool.user.partitionedObjects;newScope.getIcon=computable=>{switch(computable.type){case"DATASET":return"dataset "+$filter("datasetTypeToIcon")(computable.subType);case"MANAGED_FOLDER":return"icon-folder-open";case"SAVED_MODEL":return"icon-machine_learning_regression"}};newScope.continue=()=>{newScope.dismiss();deferred.resolve()}})}else{deferred.resolve()}}else{$scope.tool.user.updateOptions.recheckAll=false;deferred.resolve()}deferred.promise.finally(()=>{if(!$scope.tool.user.updateStatus.multiPhaseUpdating){$scope.tool.user.updateStatus.multiPhaseUpdating=isAnyRebuildingReqd();$scope.totalItemsToProcess=getCountOfProblemItems()}$scope.tool.user.updateStatus.totalPercent=0;showIndicator("Propagating schema");$scope.tool.user.update($scope).then(()=>{let multiPhase=false;for(const partitionedObject of $scope.tool.user.partitionedObjects){const escapedId=graphIdFor(partitionedObject.type,partitionedObject.fullId);let node=$scope.tool.user.state.stateByNode[escapedId];if(node===undefined){node=Object.values($scope.tool.user.state.stateByNode).find(n=>n.type===partitionedObject.type&&n.fullId===partitionedObject.fullId)}if(node){node.buildPartitions=partitionedObject.buildPartitions;node.partitioning=partitionedObject.partitioning}}$scope.tool.drawHooks.updateFlowToolDisplay();if($scope.tool.user.updateOptions.recheckAll){$scope.totalItemsToProcess=getCountOfProblemItems()}if(isAnyRebuildingReqd()){multiPhase=rebuildNextAsReqd()}if(!multiPhase){if($scope.tool.user.updateOptions.doBuildAll&&!$scope.isAborting){$scope.buildAll();multiPhase=true}else{showIndicator($scope.isAborting?"Schema propagation aborted ":"Schema propagation complete",true)}}$scope.tool.user.updateStatus.multiPhaseUpdating=multiPhase});$scope.tool.drawHooks.updateFlowToolDisplay()})};let lastDoAnyRebuildingReqdValue;let lastMarkUncheckableAsOKValue;$scope.$watch(()=>$scope.tool.user.preconfiguredProfile==="CUSTOM",isCustom=>{if(!isCustom)return;if($scope.tool.user.updateOptions.doBuildAll){lastDoAnyRebuildingReqdValue=true;$scope.tool.user.updateOptions.doAnyRebuildingReqd=true}if($scope.tool.user.updateOptions.doAnyRebuildingReqd){lastMarkUncheckableAsOKValue=true;$scope.tool.user.updateOptions.markUncheckableAsOK=true}});$scope.$watch("tool.user.updateOptions.doBuildAll",function(newVal){if($scope.tool.user.preconfiguredProfile==="CUSTOM"){if(newVal){lastDoAnyRebuildingReqdValue=$scope.tool.user.updateOptions.doAnyRebuildingReqd;$scope.tool.user.updateOptions.doAnyRebuildingReqd=true}else{$scope.tool.user.updateOptions.doAnyRebuildingReqd=lastDoAnyRebuildingReqdValue}}});$scope.$watch("tool.user.updateOptions.doAnyRebuildingReqd",function(newVal){if($scope.tool.user.preconfiguredProfile==="CUSTOM"){if(newVal){lastMarkUncheckableAsOKValue=$scope.tool.user.updateOptions.markUncheckableAsOK;$scope.tool.user.updateOptions.markUncheckableAsOK=true}else{$scope.tool.user.updateOptions.markUncheckableAsOK=lastMarkUncheckableAsOKValue}}});$scope.acceptAllRecipeSuggestions=function(){$scope.tool.user.acceptAllRecipeSuggestions($scope)};$scope.ignoreAllRecipeSuggestions=function(){$scope.tool.user.ignoreAllSuggestionsWithState($scope,"NOK")};$scope.markAllUncheckableAsOK=function(){$scope.tool.user.ignoreAllSuggestionsWithState($scope,"UNCHECKABLE")};$scope.getTotalPercent=function(){if($scope.tool.user.updateStatus.multiPhaseUpdating){let fixedItemsToDo=1+($scope.tool.user.updateOptions.doBuildAll||0);return 100*(1+$scope.totalItemsToProcess-getCountOfProblemItems())/(fixedItemsToDo+Math.max($scope.totalItemsToProcess,1))}else{return $scope.tool.user.updateStatus.totalPercent}};$scope.abortUpdate=function(){$scope.isAborting=true;if($scope.startedJob&&$scope.startedJob.jobId){DataikuAPI.flow.jobs.abort($stateParams.projectKey,$scope.startedJob.jobId).error(setErrorInScope.bind($scope))}$scope.tool.user.updateStatus.multiPhaseUpdating=false;$scope.tool.user.updateStatus.updating=false;ActivityIndicator.hide()};$scope.buildAll=function(){DataikuAPI.flow.listDownstreamComputables($stateParams.projectKey,{computable:$scope.tool.currentSession.toolInitialData.datasetName}).success(computables=>{startBuildAllJob(computables)}).error(setErrorInScope.bind($scope))}});app.controller("FlowToolPropagateItemPopupController",function($scope,$controller,Assert,DataikuAPI,$stateParams,ComputableSchemaRecipeSave){$controller("StandardFlowViewsMainController",{$scope:$scope});Assert.inScope($scope,"tool");let recipeName=$scope.node.name;$scope.reviewSuggestion=function(){ComputableSchemaRecipeSave.handleSchemaUpdateWithPrecomputed($scope,$scope.nodeState.updateSolution).then(function(){DataikuAPI.flow.tools.propagateSchema.markRecipeAsOKAfterUpdate($stateParams.projectKey,recipeName).success(function(data){$scope.tool.user.state=data;$scope.tool.drawHooks.updateFlowToolDisplay()})})};$scope.ignoreSuggestion=function(){let recipeName=$scope.node.name;DataikuAPI.flow.tools.propagateSchema.markRecipeAsOKForced($stateParams.projectKey,recipeName).success(function(data){$scope.tool.user.state=data;$scope.tool.drawHooks.updateFlowToolDisplay()})}});app.controller("FlowToolPropagateDatasetNeedsRebuildPopupController",function($scope,$controller,Assert,DataikuAPI,$stateParams,ActivityIndicator,CreateModalFromTemplate,FlowBuildService,AnyLoc){$controller("StandardFlowViewsMainController",{$scope:$scope});Assert.inScope($scope,"tool");let datasetName=$scope.node.name;$scope.build=function(){const loc=AnyLoc.makeLoc($stateParams.projectKey,datasetName);FlowBuildService.openSingleComputableBuildModalFromObjectTypeAndLoc($scope,"DATASET",loc);$scope.$on("datasetBuildStarted",function(){ActivityIndicator.success("Dataset build started ... Please wait for end before continuing propagation");DataikuAPI.flow.tools.propagateSchema.markDatasetAsBeingRebuilt($stateParams.projectKey,datasetName).success(function(data){$scope.tool.user.state=data;$scope.tool.drawHooks.updateFlowToolDisplay()})})};$scope.ignoreSuggestion=function(){DataikuAPI.flow.tools.propagateSchema.markDatasetAsBeingRebuilt($stateParams.projectKey,datasetName).success(function(data){$scope.tool.user.state=data;$scope.tool.drawHooks.updateFlowToolDisplay()})}})})();(function(){"use strict";const app=angular.module("dataiku.flow.tools");app.service("CheckConsistencyFlowTool",function($rootScope,$stateParams,DataikuAPI,ContextualMenu,LoggerProvider,FlowToolsUtils,FlowViewsUtils,FlowGraph,Ng1ToolBridgeService){const NAME="CHECK_CONSISTENCY";const DISPLAY_NAME="Check consistency";this.getDefinition=function(){return{getName:()=>NAME,getToolDisplayName:()=>DISPLAY_NAME,initFlowTool:function(tool){tool.user={updateOptions:{recheckAll:false,datasets:{consistencyWithData:true},recipes:{schemaConsistency:true,otherExpensiveChecks:true}},updateStatus:{updating:false}};tool.action=true;Ng1ToolBridgeService().emitActionTool(true);tool.user.markAsOK=function(nodes){const nodeIds=nodes.map(n=>n.realId);DataikuAPI.flow.tools.checkConsistency.markAsOK($stateParams.projectKey,nodeIds).success(function(data){tool.user.state=data;tool.drawHooks.updateFlowToolDisplay()})};tool.user.recheck=function(nodes){const nodeIds=nodes.map(n=>n.realId);DataikuAPI.flow.tools.checkConsistency.recheck($stateParams.projectKey,nodeIds).success(function(data){tool.user.state=data;tool.drawHooks.updateFlowToolDisplay()})};tool.user.canRecheck=function(nodes){if(tool.user.state==null)return false;return!!nodes.filter(n=>tool.user.state.stateByNode[n.realId]!="UNCHECKED").length};function colorFromMessageHolder(holder,node,sel){if(holder.maxSeverity=="ERROR"){FlowToolsUtils.colorNode(node,sel,"red")}else if(holder.maxSeverity=="WARNING"){FlowToolsUtils.colorNode(node,sel,"orange")}else if(holder.maxSeverity=="INFO"){FlowToolsUtils.colorNode(node,sel,"lightblue")}else{FlowToolsUtils.colorNode(node,sel,"green")}}function needsPopup(nodeState){if(nodeState.state=="FAILED_CHECK")return true;if(nodeState.state=="CHECKED"){if(nodeState.recipeCheckResult&&nodeState.recipeCheckResult.maxSeverity)return true;if(nodeState.datasetCheckResult&&nodeState.datasetCheckResult.maxSeverity)return true}return false}tool.drawHooks.updateFlowToolDisplay=function(){if(!tool.user.state)return;if(!FlowGraph.ready())return;$.each(FlowGraph.get().nodes,function(nodeId,node){const nodeElt=FlowGraph.d3NodeWithId(nodeId);const nodeState=tool.user.state.stateByNode[node.realId];nodeElt.classed("focus",false).classed("out-of-focus",false);$(".tool-simple-zone",FlowGraph.getSvg()).empty();$(".node-totem span",nodeElt[0]).removeAttr("style").removeClass();$(".never-built-computable *",nodeElt[0]).removeAttr("style");if(!nodeState){FlowToolsUtils.colorNode(node,nodeElt,"#ccc")}else if(nodeState.state=="UNCHECKED"){FlowToolsUtils.colorNode(node,nodeElt,"#808080")}else if(nodeState.state=="CHECKED"){if(nodeState.recipeCheckResult){nodeState.errorHolder=nodeState.recipeCheckResult;colorFromMessageHolder(nodeState.recipeCheckResult,node,nodeElt)}else if(nodeState.labelingTaskCheckResult){nodeState.errorHolder=nodeState.labelingTaskCheckResult;colorFromMessageHolder(nodeState.labelingTaskCheckResult,node,nodeElt)}else if(nodeState.datasetCheckResult){nodeState.errorHolder=nodeState.datasetCheckResult;colorFromMessageHolder(nodeState.datasetCheckResult,node,nodeElt)}}else if(nodeState.state=="FAILED_CHECK"){FlowToolsUtils.colorNode(node,nodeElt,"purple")}})};tool.actionHooks.onItemClick=function(node,evt){if(!tool.user.state)return;let nodeState=tool.user.state.stateByNode[node.realId];ContextualMenu.prototype.closeAny();if(nodeState&&needsPopup(nodeState)){let menuScope=$rootScope.$new();menuScope.nodeState=nodeState;menuScope.node=node;menuScope.tool=tool;let menuParams={template:"/templates/flow-editor/tools/consistency-item-popup.html",scope:menuScope,contextual:false};let menu=new ContextualMenu(menuParams);menu.openAtEventLoc(evt)}};FlowViewsUtils.addAsynchronousStateComputationBehavior(tool);DataikuAPI.flow.tools.getState($stateParams.projectKey,NAME,{}).success(function(data){tool.user.state=data;tool.drawHooks.updateFlowToolDisplay()}).error(FlowGraph.setError());return tool},template:"/templates/flow-editor/tools/tool-check-consistency.html"}}});app.controller("ConsistencyFlowToolMainController",function($scope,Assert,DataikuAPI,$stateParams){Assert.inScope($scope,"tool");$scope.update=$scope.tool.user.update})})();(function(){"use strict";const app=angular.module("dataiku.recipes",["dataiku.common.lists","dataiku.aiSqlGeneration"]);app.directive("checkRecipeNameUnique",function(DataikuAPI,$stateParams){return{require:"ngModel",link:function(scope,elem,attrs,ngModel){DataikuAPI.flow.recipes.list($stateParams.projectKey).success(function(data){scope.unique_recipes_names=$.map(data,function(recipe){return recipe.name});apply_validation(ngModel.$modelValue)});var initialValue=null,initialValueInitialized=false;function apply_validation(value){if(initialValueInitialized==false&&value!=undefined&&value!=null&&value.length>0){initialValue=value;initialValueInitialized=true}if(value==null||value.length===0)return true;if(initialValueInitialized&&value==initialValue)return value;var valid=scope.unique_recipes_names?scope.unique_recipes_names.indexOf(value)===-1:true;ngModel.$setValidity("recipeNameUnique",valid);return valid?value:undefined}ngModel.$parsers.unshift(apply_validation);ngModel.$formatters.unshift(function(value){apply_validation(value);return value})}}});app.filter("buildModeDescription",function(){var dict={NON_RECURSIVE_FORCED_BUILD:"Build only this dataset",RECURSIVE_BUILD:"Build required datasets",RECURSIVE_FORCED_BUILD:"Force-rebuild dataset and dependencies",RECURSIVE_MISSING_ONLY_BUILD:"Build missing dependencies then this one"};return function(input){return dict[input]||input}});app.directive("recipePipelineConfig",function(){return{restrict:"E",templateUrl:"/templates/recipes/fragments/recipe-pipeline-config.html",scope:{config:"=",anyPipelineTypeEnabled:"&"}}});app.directive("otherActionListItem",function(){return{restrict:"E",templateUrl:"/templates/recipes/fragments/other-action-list-item.html",scope:{icon:"@",label:"@",onClick:"&",showCondition:"<?",enableCondition:"<?",disabledTooltip:"@?"},link:function(scope){if(scope.showCondition===undefined){scope.showCondition=true}if(scope.enableCondition===undefined){scope.enableCondition=true}}}});app.directive("sparkDatasetsReadParamsBehavior",function(Assert,$stateParams,RecipesUtils,Logger,DatasetUtils){return{scope:true,link:function($scope,element,attrs){Logger.info("Loading spark behavior");Assert.inScope($scope,"recipe");let contextProjectKey=$scope.context&&$scope.context.projectKey?$scope.context.projectKey:$scope.recipe.projectKey;$scope.readParams=$scope.$eval(attrs.readParams);Assert.inScope($scope,"readParams");function autocomplete(){RecipesUtils.getFlatInputsList($scope.recipe).forEach(function(input){Assert.inScope($scope,"computablesMap");const computable=$scope.computablesMap[input.ref];if(!computable){throw Error("dataset is not in computablesMap, try reloading the page")}const dataset=computable.dataset;if(dataset&&!$scope.readParams.map[input.ref]){$scope.readParams.map[input.ref]={repartition:["HDFS","hiveserver2"].includes(dataset.type)?1:10,cache:false}}});Logger.info("Updated map",$scope.readParams.map)}$scope.$watch("recipe.inputs",function(nv,ov){if(nv&&$scope.computablesMap){DatasetUtils.updateRecipeComputables($scope,$scope.recipe,$stateParams.projectKey,contextProjectKey).then(_=>autocomplete())}},true);$scope.$watch("computablesMap",function(nv,ov){if(nv){DatasetUtils.updateRecipeComputables($scope,$scope.recipe,$stateParams.projectKey,contextProjectKey).then(_=>autocomplete())}},true)}}});app.directive("sparkDatasetsReadParams",function(Assert,RecipesUtils){return{scope:true,templateUrl:"/templates/recipes/fragments/spark-datasets-read-params.html",link:function($scope,element,attrs){Assert.inScope($scope,"recipe");$scope.readParams=$scope.$eval(attrs.readParams);Assert.inScope($scope,"readParams")}}});app.service("RecipesCapabilities",function(RecipeDescService,CodeEnvsService,AppConfig,$rootScope){function getRecipeType(recipe){if(recipe){if(recipe.recipeType){return recipe.recipeType}else if(recipe.subType){return recipe.subType}else if(recipe.type){return recipe.type}}return undefined}this.isMultiEngine=function(recipe){const desc=RecipeDescService.getDescriptor(getRecipeType(recipe));return!!desc&&desc.isMultiEngine};this.canEngine=function(recipe,engine){if(!recipe){return false}const recipeType=getRecipeType(recipe);if(!recipeType){return false}if(recipeType.toLowerCase().includes(engine)){return true}const desc=RecipeDescService.getDescriptor(recipeType);return!!(desc&&desc.isMultiEngine)};this.isSparkEnabled=function(){return!AppConfig.get()||AppConfig.get().sparkEnabled};this.canSpark=function(recipe){return this.isSparkEnabled()&&this.canEngine(recipe,"spark")};this.canSparkPipeline=function(recipe){return $rootScope.projectSummary.sparkPipelinesEnabled&&this.canSpark(recipe)&&!["pyspark","sparkr"].includes(getRecipeType(recipe))};this.canSqlPipeline=function(recipe){const canEngine=this.canEngine(recipe,"sql");const b=!["spark_sql_query","sql_script"].includes(getRecipeType(recipe));return $rootScope.projectSummary.sqlPipelinesEnabled&&canEngine&&b};this.canChangeSparkPipelineability=function(recipe){if(recipe){if(getRecipeType(recipe)==="prediction_scoring"){return false}return this.canSpark(recipe)}return false};this.canChangeSqlPipelineability=function(recipe){const recipeType=getRecipeType(recipe);if(recipeType){if(["sync","shaker","sampling","grouping","upsert","distinct","window","join","split","topn","sort","pivot","vstack","sql_query","prediction_scoring"].includes(recipeType)){return true}}return false};this.canImpala=function(recipe){if(recipe){const recipeType=getRecipeType(recipe);if(recipeType==="impala"){return true}if(AppConfig.get()&&!AppConfig.get().sparkEnabled){return false}const desc=RecipeDescService.getDescriptor(recipeType);if(desc&&desc.isMultiEngine){return true}}return false};this.canHive=function(recipe){if(recipe){const recipeType=getRecipeType(recipe);if(recipeType==="hive"){return true}if(AppConfig.get()&&!AppConfig.get().sparkEnabled){return false}const desc=RecipeDescService.getDescriptor(recipeType);if(desc&&desc.isMultiEngine){return true}}return false};this.canPythonCodeEnv=function(recipe){return CodeEnvsService.canPythonCodeEnv(recipe)};this.canRCodeEnv=function(recipe){return CodeEnvsService.canRCodeEnv(recipe)}});app.controller("RecipePageRightColumnActions",async function($controller,$scope,$stateParams,ActiveProjectKey,DataikuAPI){$controller("_TaggableObjectPageRightColumnActions",{$scope:$scope});$controller("_RecipeWithEngineBehavior",{$scope:$scope});$scope.recipeData=(await DataikuAPI.flow.recipes.getFullInfo(ActiveProjectKey.get(),$stateParams.recipeName)).data;$scope.recipe=$scope.recipeData.recipe;$scope.recipe.recipeType=$scope.recipe.type;$scope.recipe.nodeType="RECIPE";$scope.recipe.id=$stateParams.recipeName;$scope.recipe.interest=$scope.recipeData.interest;$scope.selection={selectedObject:$scope.recipe,confirmedItem:$scope.recipe}});app.directive("recipeRightColumnSummary",function($controller,$stateParams,$state,$rootScope,RecipeRenameService,DataikuAPI,TopNav,CreateModalFromTemplate,ActiveProjectKey,ActivityIndicator,WT1,FlowBuildService,LambdaServicesService,Logger,translate){return{templateUrl:"/templates/recipes/right-column-summary.html",link:function(scope,element,attrs){$controller("_TaggableObjectsMassActions",{$scope:scope});$controller("_TaggableObjectsCapabilities",{$scope:scope});var enrichSelectedObject=function(selObj,recipe){selObj.tags=recipe.tags};scope.isDeleteAndReconnectAllowed=false;scope.$watch("selection",()=>{if(scope.selection&&scope.selection.selectedObject){scope.canDeleteAndReconnectObject(scope.selection.selectedObject).then(function(result){scope.isDeleteAndReconnectAllowed=result}).catch(function(error){Logger.warn(`Problem determining whether to show delete & reconnect option for ${scope.selection.selectedObject.id}:`,error)})}});scope.deleteAndReconnectRecipe=function(wt1_event_name){scope.doDeleteAndReconnectRecipe(scope.selection.selectedObject,wt1_event_name)};scope.getDeleteAndReconnectTooltip=function(){if(!scope.canWriteProject())return translate("FLOW.DELETE_AND_RECONNECT.NO_PERMISSIONS","You don't have write permissions for this project");if(!scope.isDeleteAndReconnectAllowed)return translate("FLOW.DELETE_AND_RECONNECT.ONLY_AVAILABLE","This feature is only available for single-input recipes before the flow's end where reconnection is possible");return translate("FLOW.DELETE_AND_RECONNECT.DELETE_THIS_RECIPE","Delete this recipe and its output datasets, relinking the upstream dataset as an input to the downstream recipes")};scope.getRunTooltip=function(){if(scope.isOutputEmpty)return scope.translate("PROJECT.RECIPE.RIGHT_PANEL.RUN.NO_OUTPUT_ERROR","Running a recipe that has no output is not possible");if(scope.payload?.backendType!==undefined&&scope.payload.backendType==="VERTICA")return scope.translate("PROJECT.PERMISSIONS.VERTICA_NOT_SUPPORTED","Vertica ML backend is no longer supported");if(!scope.canWriteProject())return scope.translate("PROJECT.PERMISSIONS.WRITE_ERROR","You don't have write permissions for this project");return null};scope.refreshData=function(){DataikuAPI.flow.recipes.getFullInfo(scope.selection.selectedObject.projectKey,scope.selection.selectedObject.name).success(function(data){scope.recipeData=data;scope.recipe=data.recipe;scope.recipeBeingDeselected=null;if(/^\s*\{/.test(data.script||"")){try{scope.payload={backendType:JSON.parse(data.script).backendType}}catch(ignored){}}enrichSelectedObject(scope.selection.selectedObject,scope.recipe);if(scope.selection.selectedObject.continuous){let selObj=scope.selection.selectedObject;let ps=data.continuousState;if(!selObj.continuousActivityDone){if(ps&&ps.mainLoopState!=null&&ps.mainLoopState.futureInfo!=null&&ps.desiredState=="STARTED"&&ps.mainLoopState.futureInfo.hasResult){selObj.continuousActivityDone=true;$rootScope.$broadcast("graphRendered")}}}scope.recipe.zone=(scope.selection.selectedObject.usedByZones||[])[0]||scope.selection.selectedObject.ownerZone;scope.outputs=data.outputs;scope.isOutputEmpty=scope.outputs===undefined||_.isEmpty(scope.outputs)}).error(setErrorInScope.bind(scope))};scope.$on("taggableObjectTagsChanged",()=>scope.refreshData());scope.$on("objectSummaryEdited",()=>{const editedRecipe=scope.recipe!==null?scope.recipe:scope.recipeBeingDeselected;if(editedRecipe){DataikuAPI.flow.recipes.save(ActiveProjectKey.get(),editedRecipe,{summaryOnly:true}).success(()=>ActivityIndicator.success("Saved")).error(setErrorInScope.bind(scope))}});scope.$watch("selection.selectedObject",function(nv,ov){if(!nv)return;scope.recipeData={recipe:nv,timeline:{}};if(scope.selection.confirmedItem!=scope.selection.selectedObject){scope.recipeBeingDeselected=scope.recipe;scope.recipe=null}scope.recipeType=nv.recipeType||nv.type});scope.$watch("selection.confirmedItem",function(nv,ov){if(!nv){return}scope.refreshData()});scope.saveCustomFields=function(newCustomFields){WT1.event("custom-fields-save",{objectType:"RECIPE"});const oldCustomFields=angular.copy(scope.recipe.customFields);scope.recipe.customFields=newCustomFields;return DataikuAPI.flow.recipes.save(ActiveProjectKey.get(),scope.recipe,{summaryOnly:true}).success(()=>$rootScope.$broadcast("customFieldsSaved",TopNav.getItem(),scope.recipe.customFields)).error((data,status,headers,config,statusText,xhrStatus)=>{scope.recipe.customFields=oldCustomFields;setErrorInScope.bind(scope)(data,status,headers,config,statusText,xhrStatus)})};scope.editCustomFields=function(editingTabIndex=0){if(!scope.recipe){return}let modalScope=angular.extend(scope,{objectType:"RECIPE",objectName:scope.recipe.name,objectCustomFields:scope.recipe.customFields,editingTabIndex:editingTabIndex});CreateModalFromTemplate("/templates/taggable-objects/custom-fields-edit-modal.html",modalScope).then(function(customFields){scope.saveCustomFields(customFields)})};scope.renameRecipe=function(){RecipeRenameService.startRenamingRecipe(scope,$stateParams.projectKey,scope.recipe.name)};scope.runRecipe=function(){FlowBuildService.openRecipeRunModal(scope,scope.recipe.projectKey,scope.recipe)};scope.startContinuous=function(){WT1.event("start-continuous",{from:"recipe"});CreateModalFromTemplate("/templates/continuous-activities/start-continuous-activity-modal.html",scope,"StartContinuousActivityController",function(newScope){newScope.recipeId=scope.recipe.name}).then(function(loopParams){DataikuAPI.continuousActivities.start($stateParams.projectKey,scope.recipe.name,loopParams).success(function(data){scope.refreshData()}).error(setErrorInScope.bind(scope))})};scope.stopContinuous=function(){WT1.event("stop-continuous",{from:"recipe"});DataikuAPI.continuousActivities.stop($stateParams.projectKey,scope.recipe.name).success(function(data){scope.refreshData()}).error(setErrorInScope.bind(scope))};scope.goToCurrentRun=function(){let recipeState=scope.recipeData.continuousState||{};let mainLoopState=recipeState.mainLoopState||{};$state.go("projects.project.continuous-activities.continuous-activity.runs",{continuousActivityId:recipeState.recipeId,runId:mainLoopState.runId,attemptId:mainLoopState.attemptId})};scope.updateUserInterests=function(){DataikuAPI.interests.getForObject($rootScope.appConfig.login,"RECIPE",ActiveProjectKey.get(),scope.selection.selectedObject.name).success(function(data){scope.selection.selectedObject.interest=data;scope.recipeData.interest=data}).error(setErrorInScope.bind(scope))};const interestsListener=$rootScope.$on("userInterestsUpdated",scope.updateUserInterests);scope.$on("$destroy",interestsListener)}}});app.controller("RecipeDetailsController",function($scope,$state,$filter,CachedAPICalls,ShakerProcessorsInfo,ShakerProcessorsUtils,Notification,RecipesUtils){if(!$scope.processors){CachedAPICalls.processorsLibrary.success(function(processors){$scope.processors=processors}).error(setErrorInScope.bind($scope))}$scope.getObjectType=function(object){switch(object.type){case"SAVED_MODEL":return"SAVED_MODEL";case"MANAGED_FOLDER":return"MANAGED_FOLDER";default:return"DATASET_CONTENT"}};$scope.isOnRecipeObjectPage=function(){return $state.includes("projects.project.recipes.recipe")};$scope.showCodeRecipeSummary=function(){if(!$scope.data){return false}const recipeHasLanguageAndScript=$filter("recipeTypeToLanguage")($scope.data.recipe.type)&&$scope.data.script;if(!recipeHasLanguageAndScript){return false}const recipeHasAssociatedNotebook=$scope.data.notebook&&$scope.data.notebook.projectKey&&$scope.data.notebook.name;if($scope.isOnRecipeObjectPage()&&!recipeHasAssociatedNotebook){return false}return true};$scope.getFlatAggregates=function(values){if(!values){return[]}var aggregates=[];values.forEach(function(value){if(value.customExpr){aggregates.push(value)}else{angular.forEach(value,function(x,agg){if(agg.startsWith("__"))return;if(x===true){aggregates.push({agg:agg,column:value.column,type:value.type})}})}});return aggregates};$scope.validateStep=function(step){return ShakerProcessorsUtils.validateStep(step,$scope.processors)};var tmpFindGroupIndex=[];$scope.findGroupIndex=function(step){const groupIndex=tmpFindGroupIndex(step);return groupIndex<0?"":groupIndex+1};$scope.$watch("data.script.steps",function(nv){if(!nv)return;tmpFindGroupIndex=Array.prototype.indexOf.bind($scope.data.script.steps.filter(function(s){return s.metaType==="GROUP"}));if($scope.data.recipe.type==="shaker"){const{flattenedEnabledSteps}=ShakerProcessorsUtils.getStepsWithSubSteps($scope.data.script.steps,$scope.processors);$scope.data.stepsWithSubSteps=flattenedEnabledSteps}});const recipeSaveListener=Notification.registerEvent("recipe-save",(type,data)=>{if(!$scope.data)$scope.data={};$scope.data.script=data.payloadData;$scope.data.recipe=data.recipe;RecipesUtils.parseScriptIfNeeded($scope.data)});$scope.$on("$destroy",recipeSaveListener)});app.controller("RecipeEditorController",function($scope,$rootScope,$timeout,$stateParams,$filter,$location,$state,$q,Assert,BigDataService,DataikuAPI,Dialogs,WT1,FutureProgressModal,TopNav,PartitionDeps,DKUtils,Logger,HistoryService,CreateModalFromTemplate,AnyLoc,JobDefinitionComputer,RecipeComputablesService,RecipesUtils,RecipeRunJobService,PartitionSelection,RecipeDescService,InfoMessagesUtils,StateUtils,GraphZoomTrackerService,DatasetUtils,CodeStudiosService,Notification,RecipeContextService,ActivityIndicator,ManualLineageModalService,RatingFeedbackParams){$scope.ratingFeedbackParams=RatingFeedbackParams;$scope.hasJobBanner=false;$scope.$on("$stateChangeSuccess",(event,toState,toParams)=>{if(toState.name==="projects.project.recipes.recipe"&&toParams.isAIGenerated===true&&!$rootScope.appConfig.isUsingLocalAIAssistant){$scope.ratingFeedbackParams.showRatingFeedback=true}});$scope.$on("$stateChangeStart",(event,toState,toParams,fromState,fromParams)=>{const outputDatasets=$scope.recipe?.outputs?.["main"]?.items.map(item=>item.ref)??[];if(!(toState.name==="projects.project.datasets.dataset.explore"&&outputDatasets.includes(toParams.datasetName)&&fromParams.isAIGenerated===true)){$scope.ratingFeedbackParams.showRatingFeedback=false}});$scope.onCloseRatingFeedbackBanner=function(){$scope.ratingFeedbackParams.showRatingFeedback=false};$scope.InfoMessagesUtils=InfoMessagesUtils;let contextProjectKey=$scope.context&&$scope.context.projectKey?$scope.context.projectKey:$stateParams.projectKey;$scope.recipeUpdateData=function(initialCall=false){return DataikuAPI.flow.recipes.getWithInlineScript($stateParams.projectKey,$scope.recipeName.name).success(function(data){RecipeContextService.setCurrentRecipe(data);$scope.recipe=data.recipe;$scope.script.data=data.script;$scope.canEditInCodeStudio=data.canEditInCodeStudio;$scope.origRecipe=angular.copy($scope.recipe);$scope.origScript=angular.copy($scope.script);$scope.recipeDesc=RecipeDescService.getDescriptor($scope.recipe.type);TopNav.setItem(TopNav.ITEM_RECIPE,data.recipe.name,{recipeType:data.recipe.type,name:data.recipe.name,inputs:data.recipe.inputs,outputs:data.recipe.outputs});RecipeComputablesService.getComputablesMap($scope.recipe,$scope).then(function(map){$scope.setComputablesMap(map);DatasetUtils.updateRecipeComputables($scope,$scope.recipe,$stateParams.projectKey,contextProjectKey).then(_=>{if(initialCall){$scope.onload()}$scope.$broadcast("computablesMapChanged")})});DataikuAPI.flow.zones.getZoneId($stateParams.projectKey,{id:data.recipe.name,type:"RECIPE",projectKey:data.recipe.projectKey}).success(zone=>{if(zone){$scope.zone=zone.id}})}).error(function(){HistoryService.notifyRemoved({type:"RECIPE",id:$scope.recipeName.name,projectKey:$stateParams.projectKey});setErrorInScope.apply($scope,arguments)})};function main(){$scope.uiState={editSummary:false};$scope.startedJob={};$scope.recipe=null;$scope.recipeStatus=null;$scope.payloadRequired=false;$scope.script={};$scope.creation=false;$scope.recipeName={name:$scope.$state.params.recipeName};$scope.projectKey=$stateParams.projectKey;$scope.hooks=$scope.hooks||{};GraphZoomTrackerService.setFocusItemById("recipe",$scope.recipeName.name);$scope.RecipesUtils=RecipesUtils;$scope.valCtx={};const tabToSelect=StateUtils.defaultTab("settings");TopNav.setLocation(TopNav.TOP_FLOW,"recipes",TopNav.TABS_RECIPE,tabToSelect);TopNav.setItem(TopNav.ITEM_RECIPE,$stateParams.recipeName);$scope.validations=[function(){return $scope.renaming.recipe_name.$valid&&$scope.recipeName.name.length}];$scope.PartitionDeps=PartitionDeps;addDatasetUniquenessCheck($scope,DataikuAPI,$stateParams.projectKey);$scope.computablesMap=null;$scope.$broadcast("computablesMapChanged");Assert.trueish($scope.recipeName.name,"no recipe name");$scope.recipeUpdateData(true);TopNav.setTab(tabToSelect);$scope.$watchGroup(["topNav.tab","valCtx.preRunValidationError","startedJob.jobId"],function([tab,preRunValidationError,jobId]){$scope.hasJobBanner=(["code","settings"].includes(tab)||$scope.recipe?.type==="sync"&&tab==="io")&&(preRunValidationError||jobId)})}main();function extractWT1EventParams(recipe,payload){try{if(recipe.type==="prediction_scoring"){const recipeParams=JSON.parse(payload.data);let eventParams={filterInputColumns:recipeParams.filterInputColumns,forceOriginalEngine:recipeParams.forceOriginalEngine,outputExplanations:recipeParams.outputExplanations,outputProbaPercentiles:recipeParams.outputProbaPercentiles,outputProbabilities:recipeParams.outputProbabilities,taskType:"PREDICTION",predictionType:recipeParams.predictionType,savedModelType:recipeParams.savedModelType,proxyModelProtocol:recipeParams.proxyModelProtocol};if(eventParams.outputExplanations){eventParams={individualExplMethod:recipeParams.individualExplanationParams.method,individualExplCount:recipeParams.individualExplanationParams.nbExplanations,...eventParams}}return eventParams}if(["clustering_scoring","clustering_training"].includes(recipe.type)){return{taskType:"CLUSTERING",savedModelType:"DSS_MANAGED"}}if(recipe.type==="eda_stats"){const recipeParams=JSON.parse(payload.data);return{recipeSubType:recipeParams.type}}if(recipe.type==="nlp_llm_finetuning"){const recipeParams=JSON.parse(payload.data);if(recipeParams.llmId!==undefined){const llmIdParts=recipeParams.llmId.split(":");return{inputModelType:llmIdParts[0]==="savedmodel"?llmIdParts[1]:llmIdParts[0]}}}if(recipe.type==="nlp_llm_evaluation"){const recipeParams=JSON.parse(payload.data);return{inputFormat:recipeParams.inputFormat,llmTaskType:recipeParams.llmTaskType}}if(recipe.type==="nlp_agent_evaluation"){const recipeParams=JSON.parse(payload.data);return{inputFormat:recipeParams.inputFormat,llmTaskType:recipeParams.llmTaskType}}if(recipe.type==="nlp_llm_rag_embedding"){const recipeParams=JSON.parse(payload.data);return{vectorStoreUpdateMethod:recipeParams.vectorStoreUpdateMethod}}if(recipe.type==="embed_documents"){const payloadData=JSON.parse(payload.data);const allOtherRuleAction=recipe.params.allOtherRule.actionToPerform;let vlms=recipe.params.rules.filter(r=>r.actionToPerform==="VLM").map(r=>r.vlmSettings.llmId);if(allOtherRuleAction==="VLM"){vlms.push(recipe.params.allOtherRule.vlmSettings.llmId)}let vlmConnectionsType=vlms.filter(fullId=>fullId!==undefined).map(fullId=>fullId.split(":")[0]);return{vectorStoreUpdateMethod:payloadData.vectorStoreUpdateMethod,rulesCount:recipe.params.rules.length+1,vlmRulesCount:recipe.params.rules.filter(r=>r.actionToPerform==="VLM").length+(allOtherRuleAction==="VLM"?1:0),structuredRulesCount:recipe.params.rules.filter(r=>r.actionToPerform==="STRUCTURED").length+(allOtherRuleAction==="STRUCTURED"?1:0),donotextractRulesCount:recipe.params.rules.filter(r=>r.actionToPerform==="DONOTEXTRACT").length+(allOtherRuleAction==="DONOTEXTRACT"?1:0),vlmConnectionTypes:Array.from(new Set(vlmConnectionsType)).join(",")}}if(recipe.type==="evaluation"){const recipeParams=JSON.parse(payload.data);return{taskType:recipeParams.taskType,predictionType:recipeParams.predictionType,savedModelType:recipeParams.savedModelType,proxyModelProtocol:recipeParams.proxyModelProtocol}}if(recipe.type==="prediction_training"){const recipeParams=JSON.parse(payload.data);return{taskType:recipeParams.core.taskType,predictionType:recipeParams.core.prediction_type,savedModelType:"DSS_MANAGED"}}return{}}catch(e){Logger.error("Failed to get wt1 loggable recipe event payload params",e);return{}}}const DEFAULT_WT1_EVENT_OPTS={withRecipeEventParamsEnrichment:false,withRecipeOutputAppendModeTracking:false};function enrichRecipeWT1Event(params,opts={}){if(params==null)params={};params.recipeId=$scope.recipeName&&$scope.recipeName.name?$scope.recipeName.name.dkuHashCode():"unknown";params.recipeType=$scope.recipe?$scope.recipe.type:"unknown";params.creation=$scope.creation;if($scope.recipe&&$scope.recipe.type){const extractParams=extractWT1EventParams($scope.recipe,$scope.script);params={...params,...extractParams}}const _opts={...DEFAULT_WT1_EVENT_OPTS,...opts};if(_opts.withRecipeEventParamsEnrichment){params={...params,...RecipesUtils.getWT1LoggableRecipeEventParams($scope.recipe,$scope.recipeDesc)}}if(_opts.withRecipeOutputAppendModeTracking){params={...params,...RecipesUtils.getWT1OutputAppendModeTracking($scope.recipe)}}return params}$scope.recipeWT1Event=function(type,params,opts){WT1.event(type,enrichRecipeWT1Event(params,opts))};$scope.tryRecipeWT1Event=function(type,paramsGetter,message){WT1.tryEvent(type,()=>enrichRecipeWT1Event(paramsGetter()),message)};$scope.canEditRecipeInNotebook=function(){return["python","pyspark","r","julia","sparkr","spark_scala","sql_query"].includes($scope.recipe.type)};$scope.editThisRecipeInNotebook=function(){$scope.recipeWT1Event("recipe-edit-in-notebook");if($scope.recipe.type==="sql_query"){$scope.saveRecipeIfPossible().then(()=>DataikuAPI.flow.recipes.editInSQLNotebook($stateParams.projectKey,$stateParams.recipeName)).then(({data})=>StateUtils.go.sqlNotebook(data.notebookId,$stateParams.projectKey,{cellId:data.cellId})).catch(setErrorInScope.bind($scope))}else{var editInNotebook=function(){DataikuAPI.flow.recipes.editInNotebook($stateParams.projectKey,$stateParams.recipeName,$scope.recipe.params.envSelection,$scope.recipe.params.containerSelection).success(function(data){StateUtils.go.jupyterNotebook(data.id,$stateParams.projectKey)}).error(setErrorInScope.bind($scope))};$scope.saveRecipeIfPossible().then(function(){DataikuAPI.flow.recipes.checkNotebookEdition($stateParams.projectKey,$stateParams.recipeName).success(function(data){if(!data||data.conflict!==true||!data.notebook){editInNotebook()}else{Dialogs.openEditInNotebookConflictDialog($scope).then(function(resolutionMethod){if(resolutionMethod=="erase"){editInNotebook()}else if(resolutionMethod=="ignore"){StateUtils.go.jupyterNotebook(data.notebook,$stateParams.projectKey)}})}}).error(setErrorInScope.bind($scope))}).catch(setErrorInScope.bind($scope))}};$scope.canEditRecipeInCodeStudio=function(){if(!$scope.canEditInCodeStudio)return false;return["python","r","sql_query","sql_script","spark_sql_query"].includes($scope.recipe.type)};const getExtension=function(){switch($scope.recipe.type){case"sql_query":case"sql_script":case"spark_sql_query":return".sql";case"python":return".py";case"r":return".r";default:throw Error("Edition of recipes of type "+$scope.recipe.type+"is not supported by Code Studio!")}};$scope.editThisRecipeInCodeStudio=function(){$scope.saveRecipeIfPossible().then(function(){CodeStudiosService.editFileInCodeStudio($scope,"recipes",$stateParams.recipeName+getExtension())}).catch(setErrorInScope.bind($scope))};$scope.saveCustomFields=function(newCustomFields){WT1.event("custom-fields-save",{objectType:"RECIPE"});let oldCustomFields=angular.copy($scope.recipe.customFields);$scope.recipe.customFields=newCustomFields;return $scope.hooks.save().then(function(){$rootScope.$broadcast("customFieldsSaved",TopNav.getItem(),$scope.recipe.customFields)},function(){$scope.recipe.customFields=oldCustomFields})};$scope.editCustomFields=function(editingTabIndex=0){if(!$scope.recipe){return}let modalScope=angular.extend($scope,{objectType:"RECIPE",objectName:$scope.recipe.name,objectCustomFields:$scope.recipe.customFields,editingTabIndex:editingTabIndex});CreateModalFromTemplate("/templates/taggable-objects/custom-fields-edit-modal.html",modalScope).then(function(customFields){$scope.saveCustomFields(customFields)})};$scope.gotoLine=function(cm,line){if(cm&&line>0){var pos={ch:0,line:line-1};cm.scrollIntoView(pos);cm.setCursor(pos);cm.focus()}};let lastVeLoopConfig=null;$scope.loadRecipeVariables=function(){const veLoopConfig=$scope.recipe.params&&$scope.recipe.params.variablesExpansionLoopConfig;if(!angular.equals(lastVeLoopConfig,veLoopConfig)||lastVeLoopConfig===null){lastVeLoopConfig=typeof veLoopConfig==="object"?JSON.parse(JSON.stringify(veLoopConfig)):veLoopConfig;DataikuAPI.flow.recipes.generic.getVariables($scope.recipe).success(function(data){$scope.recipeVariables=data}).error(setErrorInScope.bind($scope))}};$scope.specificControllerLoadedDeferred=$q.defer();var onloadcalled=false;$scope.onload=function(){Assert.inScope($scope,"recipe");Assert.trueish(!onloadcalled,"already loaded");onloadcalled=true;$scope.loadRecipeVariables();$scope.fixupPartitionDeps();$scope.recipeWT1Event("recipe-open");$scope.ioFilter={};$scope.testRun={build_partitions:{},runMode:"NON_RECURSIVE_FORCED_BUILD"};$scope.$watch("recipe.outputs",function(nv,ov){if(nv!=null){clear($scope.testRun.build_partitions);DatasetUtils.updateRecipeComputables($scope,$scope.recipe,$stateParams.projectKey,contextProjectKey).then(_=>{const definingOutputPartitioning=RecipeRunJobService.getOutputAndPartitioning($scope.recipe,$scope.computablesMap).partitioning;if(definingOutputPartitioning&&definingOutputPartitioning.dimensions.length){$scope.outputPartitioning=definingOutputPartitioning;$scope.testRun.build_partitions=PartitionSelection.getBuildPartitions($scope.outputPartitioning)}else{$scope.outputPartitioning={dimensions:[]}}})}else{$scope.testRun.build_partitions=null}},true);$scope.fixupPartitionDeps();$scope.specificControllerLoadedDeferred.promise.then(function(){if($scope.hooks&&$scope.hooks.onRecipeLoaded){$scope.hooks.onRecipeLoaded()}})};$scope.hooks.getRecipeSerialized=function(){var recipeSerialized=angular.copy($scope.recipe);PartitionDeps.prepareRecipeForSerialize(recipeSerialized);return recipeSerialized};$scope.hooks.resetScope=function(){clear($scope.startedJob);clear($scope.valCtx)};$scope.hooks.getPayloadData=function(){};$scope.hasAllRequiredOutputs=function(){if(!$scope.recipe||!$scope.recipe.outputs){return false}var out=$scope.recipe.outputs;if(out.main){return!!(out.main.items&&out.main.items.length)}return true};$scope.hasPartitionedInput=function(){return $scope.getInputDimensions().length>0};$scope.hasPartitionedOutput=function(){return $scope.getOutputDimensions().length>0};$scope.hasDangerousAllAvailablePartitioning=function(){const hasAllAvailableDependency=()=>{const recipeInputs=$scope.recipe.inputs||{};const inputValues=Object.values(recipeInputs);return inputValues.some(input=>input.items.some(item=>item.deps.some(dep=>dep.func==="all_available")))};return $scope.hasPartitionedInput()&&$scope.hasPartitionedOutput()&&hasAllAvailableDependency()};$scope.hasInvalidPartitionSelection=function(){if($scope.recipe&&$scope.recipe.redispatchPartitioning){return false}return $scope.getOutputDimensions().some(dimension=>{return!$scope.testRun||$scope.testRun.build_partitions[dimension.name]===void 0||$scope.testRun.build_partitions[dimension.name]===""})};$scope.fixupPartitionDeps=function(){if(!$scope.recipe||!$scope.computablesMap)return;var ret=PartitionDeps.fixup($scope.recipe,$scope.computablesMap);$scope.outputDimensions=ret[0];$scope.outputDimensionsWithNow=ret[1]};$scope.testPDep=function(inputRef,pdep){PartitionDeps.test($scope.recipe,inputRef,pdep,$scope)};$scope.refreshDatasetInComputablesMap=function(dataset){var found=null;$.each($scope.computablesMap,function(smartName,computable){if(computable.projectKey==dataset.projectKey&&computable.name==dataset.name)found=computable});Assert.trueish(found);found.dataset=dataset};$scope.$watch("recipe.params.variablesExpansionLoopConfig",function(){if(!$scope.recipe){return}const role="veloop";RecipesUtils.removeInputsForRole($scope.recipe,role);if(!$scope.recipe.params){return}const veLoopConfig=$scope.recipe.params.variablesExpansionLoopConfig;if(veLoopConfig&&veLoopConfig.enabled&&veLoopConfig.datasetRef){RecipesUtils.addInput($scope.recipe,role,veLoopConfig.datasetRef)}},true);$scope.enableAutoFixup=function(){$scope.$watch("recipe.inputs",function(){DatasetUtils.updateRecipeComputables($scope,$scope.recipe,$stateParams.projectKey,contextProjectKey).then(_=>$scope.fixupPartitionDeps())},true);$scope.$watch("recipe.outputs",function(){DatasetUtils.updateRecipeComputables($scope,$scope.recipe,$stateParams.projectKey,contextProjectKey).then(_=>$scope.fixupPartitionDeps())},true)};$scope.$watch("recipe.inputs",function(nv,ov){if(!nv)return;if(!$scope.outputDimensions)return;DatasetUtils.updateRecipeComputables($scope,$scope.recipe,$stateParams.projectKey,contextProjectKey).then(_=>{RecipesUtils.getFlatInputsList($scope.recipe).forEach(function(input){if(!input.deps)return;input.deps.forEach(function(pdep){PartitionDeps.autocomplete(pdep,$scope.outputDimensions,$scope.outputDimensionsWithNow)})})})},true);$scope.$watch("recipe.outputs",function(){DatasetUtils.updateRecipeComputables($scope,$scope.recipe,$stateParams.projectKey,contextProjectKey)},true);$scope.setComputablesMap=function(map){$scope.computablesMap=map;$scope.$broadcast("computablesMapChanged")};$scope.getInputDimensions=function(){if(!$scope.recipe||!$scope.computablesMap)return[];return RecipeRunJobService.getInputDimensions($scope.recipe,$scope.computablesMap)};$scope.getOutputDimensions=function(){if(!$scope.recipe||!$scope.computablesMap)return[];return RecipeRunJobService.getOutputDimensions($scope.recipe,$scope.computablesMap)};$scope.hasAnyPartitioning=function(){return RecipesUtils.hasAnyPartitioning($scope.recipe,$scope.computablesMap)};$scope.showManualLineageModal=function(){const recipeInfo={projectKey:$scope.recipe.projectKey,name:$scope.recipe.name,type:$scope.recipe.type};const datasetInfos=recipeIO=>{return Object.values(recipeIO).flatMap(inputs=>{return inputs.items.map(input=>{const datasetLoc=AnyLoc.getLocFromSmart(recipeInfo.projectKey,input.ref);const datasetInfo={projectKey:datasetLoc.projectKey,name:datasetLoc.localId};return datasetInfo})})};const inputs=datasetInfos($scope.recipe.inputs);const outputs=datasetInfos($scope.recipe.outputs);const showInCurrentLineageOnlyFilter=false;const wt1EventFrom="recipe-advanced-settings";ManualLineageModalService.openManualLineageModal(recipeInfo,inputs,outputs,showInCurrentLineageOnlyFilter,wt1EventFrom).then(function(saveInformation){if(saveInformation){DataikuAPI.dataLineage.saveManualLineage(saveInformation.projectKey,saveInformation.recipeName,saveInformation.manualDataLineages,saveInformation.ignoreAutoComputedLineage).then(({data})=>{ActivityIndicator.success("Updated lineage")}).catch(setErrorInScope.bind($scope))}})};$scope.hooks.save=function(){return $scope.baseSave($scope.hooks.getRecipeSerialized(),$scope.script?$scope.script.data:null)};$scope.hooks.origSaveHook=$scope.hooks.save;$scope.baseSave=function(recipeSerialized,payloadData){$scope.recipeWT1Event("recipe-save",null,{withRecipeEventParamsEnrichment:true,withRecipeOutputAppendModeTracking:true});Notification.publishToFrontend("recipe-save",{recipe:recipeSerialized,payloadData:payloadData});return DataikuAPI.flow.recipes.save($stateParams.projectKey,recipeSerialized,payloadData,$scope.currentSaveCommitMessage).success(function(savedRecipe){var newVersionTag=savedRecipe.versionTag;$scope.origRecipe=angular.copy($scope.recipe);$scope.origScript=angular.copy($scope.script);$scope.recipe.versionTag=newVersionTag;$scope.origRecipe.versionTag=newVersionTag;$scope.creation=false;$scope.currentSaveCommitMessage=null}).error(setErrorInScope.bind($scope))};$scope.canSave=function(){if(!$scope.creation)return true;return $scope.recipeName.name&&$scope.recipeName.name.length};$scope.hooks.recipeIsDirty=function(){if(!$scope.recipe)return false;if($scope.creation){return true}else{var recipeSerialized=angular.copy($scope.recipe);PartitionDeps.prepareRecipeForSerialize(recipeSerialized);var origRecipeSerialized=angular.copy($scope.origRecipe);PartitionDeps.prepareRecipeForSerialize(origRecipeSerialized,true);var dirty=!angular.equals(recipeSerialized,origRecipeSerialized);if($scope.script){dirty=dirty||!angular.equals($scope.origScript,$scope.script)}return dirty}};$scope.hooks.recipeContainsUnsavedFormulaChanges=function(){return false};checkChangesBeforeLeaving($scope,function(_scope){return function(){return _scope.hooks.recipeIsDirty()||_scope.hooks.recipeContainsUnsavedFormulaChanges()}}($scope));$scope.saveRecipe=function(commitMessage){var deferred=$q.defer();var saveAfterConflictCheck=function(){$scope.currentSaveCommitMessage=commitMessage;$scope.hooks.save().then(function(){$scope.$broadcast("recipeSaved");deferred.resolve("recipe saved")},function(){deferred.reject()})};DataikuAPI.flow.recipes.checkSaveConflict($stateParams.projectKey,$stateParams.recipeName,$scope.recipe).success(function(conflictResult){if(!conflictResult.canBeSaved){Dialogs.openConflictDialog($scope,conflictResult).then(function(resolutionMethod){if(resolutionMethod=="erase"){saveAfterConflictCheck()}else if(resolutionMethod=="ignore"){deferred.reject();DKUtils.reloadState()}})}else{saveAfterConflictCheck()}}).error(setErrorInScope.bind($scope));return deferred.promise};$scope.saveRecipeIfPossible=function(){if($scope.canSave()){return $scope.saveRecipe()}return $q.defer().promise};$scope.displayAllMessagesInModal=function(){Dialogs.infoMessagesDisplayOnly($scope,"Recipe validation",$scope.valCtx.validationResult.allMessagesForFrontend)};$scope.buildModes=[["NON_RECURSIVE_FORCED_BUILD",$scope.translate("RECIPE.RUN_OPTIONS.BUILD_MODE.NON_RECURSIVE_FORCED_BUILD","Run only this recipe")],["RECURSIVE_BUILD",$scope.translate("RECIPE.RUN_OPTIONS.BUILD_MODE.RECURSIVE_BUILD","Build required dependent datasets")],["RECURSIVE_FORCED_BUILD",$scope.translate("RECIPE.RUN_OPTIONS.BUILD_MODE.RECURSIVE_FORCED_BUILD","Force-rebuild all dependent datasets")],["RECURSIVE_MISSING_ONLY_BUILD",$scope.translate("RECIPE.RUN_OPTIONS.BUILD_MODE.RECURSIVE_MISSING_ONLY_BUILD","Build missing dependencies and run this recipe")]];$scope.jobCheckTimer=null;$scope.hooks.preRunValidate=function(){var deferred=$q.defer();DataikuAPI.flow.recipes.generic.validate($stateParams.projectKey,$scope.hooks.getRecipeSerialized()).success(function(data){deferred.resolve(data)}).error(function(a,b,c){setErrorInScope.bind($scope)(a,b,c);deferred.reject("Validation failed")});return deferred.promise};$scope.editRunOptions=function(){CreateModalFromTemplate("/templates/recipes/recipe-run-options-modal.html",$scope)};$scope.multipleLogsToDisplay=function(){let logsWantedForEngine="python"==$scope.recipe.type||"r"==$scope.recipe.type||"shell"==$scope.recipe.type;return $scope.startedJob.jobId&&$scope.startedJob.jobStatus&&logsWantedForEngine&&$scope.startedJob.jobStatus.manyLogs};$scope.selectLogType=function(logTypeKey){if(!$scope.startedJob||!$scope.startedJob.jobStatus||!$scope.startedJob.jobStatus.logsByType){return}let logType=$scope.startedJob.jobStatus.logsByType[logTypeKey];let updateChosenLogState=function(){$scope.startedJob.jobStatus.logTailHTML=logType.logHTML;$scope.startedJob.jobStatus.chosenLog=logTypeKey};if(logType){if(logType.logHTML){updateChosenLogState()}else{DataikuAPI.flow.jobs.smartTailActivityAdditionalLog($scope.projectKey,$scope.startedJob.jobId,logType.activityId,logType.logPath,500).success(function(data){logType.logHTML=smartLogTailToHTML(data,false);updateChosenLogState()}).error(setErrorInScope.bind($scope))}}};$scope.waitForEndOfStartedJob=function(){Logger.info("Wait for end of job:",$scope.startedJob.jobId);DataikuAPI.flow.jobs.getJobStatus($stateParams.projectKey,$scope.startedJob.jobId).success(function(data){$scope.startedJob.jobStatus=data;data.totalWarningsCount=0;if(data.logTail!=null){data.logTailHTML=smartLogTailToHTML(data.logTail,false)}for(var actId in data.baseStatus.activities){var activity=data.baseStatus.activities[actId];if(activity.warnings){data.totalWarningsCount+=activity.warnings.totalCount}}if(data.baseStatus.state!="DONE"&&data.baseStatus.state!="ABORTED"&&data.baseStatus.state!="FAILED"){$scope.jobCheckTimer=$timeout($scope.waitForEndOfStartedJob,2e3)}else{if(data.logTailHTML){let logsByType={};$scope.startedJob.jobStatus.logsByType=logsByType;const MAIN_LOG_KEY_LABEL="Main activity log";logsByType[MAIN_LOG_KEY_LABEL]={logHTML:data.logTailHTML};$scope.startedJob.jobStatus.chosenLog=MAIN_LOG_KEY_LABEL;$scope.startedJob.jobStatus.manyLogs=false;if(data.logTailActivityId){let failedActivity=data.baseStatus.activities[data.logTailActivityId];if(failedActivity&&failedActivity.statusOutputs&&failedActivity.statusOutputs.length>0){$scope.startedJob.jobStatus.manyLogs=true;for(let statusOutput of failedActivity.statusOutputs){logsByType[statusOutput.label]={activityId:failedActivity.activityId,logPath:statusOutput.path,logHTML:null}}}}}$scope.recipeWT1Event("recipe-run-finished",{state:data.baseStatus.state})}$timeout(function(){$rootScope.$broadcast("reflow")},50)}).error(setErrorInScope.bind($scope))};$scope.waitForEndOfStartedContinuousActivity=function(){Logger.info("Wait for end of continuous activity:",$scope.startedJob.jobId);DataikuAPI.continuousActivities.getState($stateParams.projectKey,$stateParams.recipeName).success(function(data){$scope.startedJob.persistent=data;$scope.startedJob.current=data.mainLoopState;if($scope.startedJob.current&&$scope.startedJob.current.futureInfo&&($scope.startedJob.current.futureInfo.alive||!$scope.startedJob.current.futureInfo.hasResult)){$scope.jobCheckTimer=$timeout($scope.waitForEndOfStartedContinuousActivity,2e3)}else{}$timeout(function(){$rootScope.$broadcast("reflow")},50)}).error(setErrorInScope.bind($scope))};$scope.discardStartedJob=function(){clear($scope.startedJob);if($scope.jobCheckTimer){$timeout.cancel($scope.jobCheckTimer);$scope.jobCheckTimer=null;$timeout(function(){$rootScope.$broadcast("redrawFatTable")})}};$scope.abortSingleRecipeExecution=function(){Dialogs.confirm($scope,"Aborting a job","Are you sure you want to abort this job?").then(function(){DataikuAPI.flow.jobs.abort($stateParams.projectKey,$scope.startedJob.jobId).success(function(data){$scope.discardStartedJob()}).error(function(e){Logger.error(e)});$scope.recipeWT1Event("recipe-running-abort")})};$scope.isJobRunning=function(){return RecipeRunJobService.isRunning($scope.startedJob)};$scope.isJobPending=function(){return RecipeRunJobService.isPending($scope.startedJob)};$scope.isContinuousActivityRunning=function(){return $scope.startedJob&&$scope.startedJob.jobId&&$scope.startedJob.current&&$scope.startedJob.current.futureInfo&&($scope.startedJob.current.futureInfo.alive||!$scope.startedJob.current.futureInfo.hasResult)};$scope.isJobRunningOrStarting=function(){return $scope.isJobRunning()||!!$scope.startedJob.starting||$scope.isJobPending()};$scope.isContinuousActivityRunningOrStarting=function(){return $scope.isContinuousActivityRunning()||!!$scope.startedJob.starting};$scope.startSingleRecipeExecution=function(forced){$scope.hooks.resetScope();$scope.startedJob.starting=true;$scope.currentSaveIsForAnImmediateRun=true;if($scope.recipe.redispatchPartitioning){$scope.testRun.build_partitions={}}function doIt(){const runRecipeOnlyRecipeTypes=["nlp_llm_finetuning"];RecipeRunJobService.run($scope.recipe,$scope.computablesMap,$scope.testRun,$scope.startedJob,$scope.waitForEndOfStartedJob,runRecipeOnlyRecipeTypes.includes($scope.recipe.type),$scope)}$scope.saveRecipe().then(function(){$scope.currentSaveIsForAnImmediateRun=false;if(forced){$scope.recipeWT1Event("recipe-run-start-forced");doIt()}else if($scope.recipe.params&&$scope.recipe.params.skipPrerunValidate){$scope.recipeWT1Event("recipe-run-start-no-validation");doIt()}else{$scope.recipeWT1Event("recipe-run-start");$scope.hooks.preRunValidate().then(function(validationResult){if(validationResult.ok==true||validationResult.error==false||validationResult.allMessagesForFrontend&&!validationResult.allMessagesForFrontend.error){$scope.recipeWT1Event("recipe-run-start-validated");doIt()}else{$scope.startedJob.starting=false;$scope.valCtx.preRunValidationError=validationResult;$scope.recipeWT1Event("recipe-run-start-blocked",{firstError:validationResult.allMessagesForFrontend&&validationResult.allMessagesForFrontend.messages.length?validationResult.allMessagesForFrontend.messages[0].message:"unknown"})}},function(error){$scope.startedJob.starting=false})}},function(error){$scope.currentSaveIsForAnImmediateRun=false;$scope.startedJob.starting=false})};$scope.startContinuousActivity=function(forced){$scope.hooks.resetScope();$scope.startedJob.starting=true;function doIt(){const onceLoopParams={abortAfterCrashes:0};DataikuAPI.continuousActivities.start($stateParams.projectKey,$stateParams.recipeName,onceLoopParams).success(function(data){FutureProgressModal.show($scope,data,"Starting continuous recipe...").then(function(data){$scope.startedJob.jobId=data.futureId;$scope.waitForEndOfStartedContinuousActivity()})}).error(setErrorInScope.bind($scope))}$scope.saveRecipe().then(function(){if(forced){$scope.recipeWT1Event("recipe-run-start-forced");doIt()}else if($scope.recipe.params&&$scope.recipe.params.skipPrerunValidate){$scope.recipeWT1Event("recipe-run-start-no-validation");doIt()}else{$scope.recipeWT1Event("recipe-run-start");$scope.hooks.preRunValidate().then(function(validationResult){if(validationResult.ok==true||validationResult.error==false||!validationResult.allMessagesForFrontend.error){$scope.recipeWT1Event("recipe-run-start-validated");doIt()}else{$scope.startedJob.starting=false;$scope.valCtx.preRunValidationError=validationResult;$scope.recipeWT1Event("recipe-run-start-blocked",{firstError:validationResult.allMessagesForFrontend&&validationResult.allMessagesForFrontend.messages.length?validationResult.allMessagesForFrontend.messages[0].message:"unknown"})}},function(error){$scope.startedJob.starting=false})}},function(error){$scope.startedJob.starting=false})};$scope.stopContinuousActivity=function(){$scope.continuousActivityState=null;DataikuAPI.continuousActivities.stop($stateParams.projectKey,$stateParams.recipeName).success(function(data){}).error(setErrorInScope.bind($scope))};$scope.openContinuousActivity=function(){$state.go("projects.project.continuous-activities.continuous-activity.runs",{continuousActivityId:$scope.recipe.name})};$scope.$on("$destroy",function(){if($scope.jobCheckTimer){$timeout.cancel($scope.jobCheckTimer);$scope.jobCheckTimer=null}Mousetrap.unbind("@ r u n");Mousetrap.unbind("shift+enter");$scope.hooks=null});Mousetrap.bind(["@ r u n","shift+enter"],function(){$scope.startSingleRecipeExecution()})});app.controller("_RecipeWithEngineBehavior",function($rootScope,$scope,$q,$stateParams,DataikuAPI,Dialogs,PartitionDeps,DKUtils,Logger,CreateModalFromTemplate,AnyLoc,ActivityIndicator,translate){$scope.setRecipeStatus=function(data){$scope.recipeStatus=data;const engineType=$scope.recipeStatus.selectedEngine&&$scope.recipeStatus.selectedEngine.type;if(engineType==="SPARK"){$scope.anyPipelineTypeEnabled=function(){return $rootScope.projectSummary.sparkPipelinesEnabled}}else if(engineType==="SQL"){$scope.anyPipelineTypeEnabled=function(){return $rootScope.projectSummary.sqlPipelinesEnabled}}};$scope.hooks.updateRecipeStatus=function(){};var requestsInProgress=0;var sendTime=0;var lastSequenceId=0;var lastPromise;var lastPayload;var lastRequestData;var lastRecipeSerialized;$scope.updateRecipeStatusBase=function(forceUpdate,payload,requestSettings){var recipeCopy=angular.copy($scope.recipe);PartitionDeps.prepareRecipeForSerialize(recipeCopy);var recipeSerialized=angular.toJson(recipeCopy);var requestData=angular.toJson(requestSettings||{});if(!forceUpdate&&lastPayload==payload&&lastRequestData==requestData&&lastRecipeSerialized==recipeSerialized){Logger.info("Update recipe: cache hit, not requesting");return lastPromise}lastPayload=payload;lastRequestData=requestData;lastRecipeSerialized=recipeSerialized;lastSequenceId++;requestsInProgress++;sendTime=(new Date).getTime();$scope.recipeStateUpdateInProgress=true;lastPromise=DataikuAPI.flow.recipes.generic.getStatus(recipeCopy,payload,lastSequenceId,requestSettings).catch(function(response){setErrorInScope.bind($scope)(response.data,response.status,response.headers);if(requestsInProgress==1){$scope.recipeStateUpdateInProgress=false}return response}).finally(function(){requestsInProgress--}).then(function(response){if(parseInt(response.data.sequenceId)<lastSequenceId){return}if((new Date).getTime()-sendTime>1500){aPreviousCallWasLong=true}$scope.recipeStateUpdateInProgress=false;$scope.setRecipeStatus(response.data);return response.data});return lastPromise};var timeout;$scope.updateRecipeStatusLater=function(){clearTimeout(timeout);timeout=setTimeout(function(){$(".CodeMirror").each(function(idx,el){Logger.debug(el.CodeMirror.refresh())});if(!$scope.hooks)return;$scope.hooks.updateRecipeStatus()},400)};var aPreviousCallWasLong=false;$scope.expectLongRecipeStatusComputation=function(){return!$scope.recipeStatus||!$scope.recipeStatus.selectedEngine||aPreviousCallWasLong};$scope.canChangeEngine=function(){if(!$scope.recipeStatus||!$scope.recipeStatus.engines){return false}if($scope.isJobRunningOrStarting()||$scope.recipeStateUpdateInProgress){return false}return true};$scope.convertToQueryRecipe=function(type,label){Dialogs.confirm($scope,translate("RECIPES.CONVERT_TO","Convert to "+label+" recipe",{recipeType:label}),translate("RECIPES.CONVERTING_TO","Converting the recipe to "+label+" will enable you to edit the query, but you will not be able to use the visual editor anymore.",{recipeType:label})+"<br/><strong>"+translate("RECIPES.THIS_OPERATION_IS_IRREVERSIBLE","This operation is irreversible.")+"</strong>").then(function(){var payloadData=$scope.hooks.getPayloadData();var recipeSerialized=angular.copy($scope.recipe);PartitionDeps.prepareRecipeForSerialize(recipeSerialized);$scope.hooks.save().then(function(){DataikuAPI.flow.recipes.visual.convert($stateParams.projectKey,recipeSerialized,payloadData,type).success(function(data){DKUtils.reloadState()}).error(setErrorInScope.bind($scope))})})};$scope.showSQLModal=function(){var newScope=$scope.$new();newScope.convert=$scope.convertToQueryRecipe;newScope.uiState={currentTab:"query"};$scope.hooks.updateRecipeStatus(false,true).then(function(){newScope.query=$scope.recipeStatus.sql;newScope.engine=$scope.recipeStatus.selectedEngine.type;newScope.executionPlan=$scope.recipeStatus.executionPlan;CreateModalFromTemplate("/templates/recipes/fragments/sql-modal.html",newScope)})};var save=$scope.baseSave;$scope.baseSave=function(){var p=save.apply(this,arguments);p.then($scope.updateRecipeStatusLater);return p};$scope.$watchCollection("recipe.inputs.main.items",()=>{Promise.resolve($scope.hooks.updateRecipeStatus()).catch(()=>{Logger.info("Failed to updateRecipeStatus. Likely due to result of backend call discarded due to multiple parallel calls.")})});$scope.$watchCollection("recipe.outputs.main.items",()=>{Promise.resolve($scope.hooks.updateRecipeStatus()).catch(()=>{Logger.info("Failed to updateRecipeStatus. Likely due to result of backend call discarded due to multiple parallel calls.")})});$scope.$watch("params.engineParams",$scope.updateRecipeStatusLater,true)});app.controller("SqlModalController",function($scope,CodeMirrorSettingService){$scope.editorOptions=CodeMirrorSettingService.get("text/x-sql2")});app.directive("recipeEnginesPreferenceConfig",function(){return{restrict:"A",templateUrl:"/templates/recipes/widgets/recipe-engines-preference-config.html",scope:{model:"="}}});app.service("RecipesEnginesService",function($rootScope,$q,Assert,CreateModalFromTemplate,DataikuAPI){this.startChangeEngine=function(selectedItems){return CreateModalFromTemplate("/templates/recipes/fragments/change-recipes-engines-modal.html",$rootScope,null,function(modalScope){modalScope.selectedRecipes=selectedItems.filter(it=>it.type=="RECIPE");modalScope.options={};modalScope.AUTO="__AUTO__";modalScope.getEngineShortStatus=function(engine){for(let msg of engine.messages.messages){if(msg.severity=="ERROR"){return msg.details}}for(let msg of engine.messages.messages){if(msg.severity=="WARNING"){return msg.details}}};DataikuAPI.flow.recipes.massActions.startChangeEngines(modalScope.selectedRecipes).success(function(data){Assert.trueish(data.engines,"no engines");modalScope.availableEngines=data.engines;modalScope.options.engine=data.currentEngine;modalScope.nUnselectableEngines=data.engines.filter(e=>!e.isSelectable).length;modalScope.messages=data.messages}).error(function(...args){modalScope.fatalError=true;setErrorInScope.apply(modalScope,args)});modalScope.test=function(){const deferred=$q.defer();delete modalScope.messages;delete modalScope.maxSeverity;resetErrorInScope(modalScope);DataikuAPI.flow.recipes.massActions.testChangeEngines(modalScope.selectedRecipes,modalScope.options.engine).success(function(data){modalScope.messages=data.messages;modalScope.maxSeverity=data.maxSeverity||"OK";if(modalScope.maxSeverity!="OK"){deferred.reject()}else{deferred.resolve(data)}}).error(setErrorInScope.bind(modalScope));return deferred.promise};modalScope.ok=function(force){if(force||modalScope.options.engine==modalScope.AUTO){performChange()}else{modalScope.test().then(performChange)}};function performChange(){DataikuAPI.flow.recipes.massActions.changeEngines(modalScope.selectedRecipes,modalScope.options.engine).success(function(data){modalScope.resolveModal()}).error(setErrorInScope.bind(modalScope))}})}});app.directive("codeEnvSelectionForm",function(DataikuAPI,$stateParams,translate){return{restrict:"A",templateUrl:"/templates/recipes/fragments/code-env-selection-form.html",scope:{envSelection:"=codeEnvSelectionForm",inPlugin:"=",isStep:"=",envLang:"=",selectionLabel:"=",callback:"=?",helpLabel:"=",checkCodeEnv:"=?",readOnly:"<"},link:function($scope,element,attrs){$scope.customWarningMessage=null;if($scope.inPlugin==true){$scope.envModes=[["USE_BUILTIN_MODE",translate("SCENARIO.SETTINGS.CODE_ENV.IN_PLUGIN.USE_BUILTIN_MODE","Use plugin environment")],["EXPLICIT_ENV",translate("SCENARIO.SETTINGS.CODE_ENV.IN_PLUGIN.EXPLICIT_ENV","Select an environment")]]}else{$scope.envModes=[["USE_BUILTIN_MODE",translate("SCENARIO.SETTINGS.CODE_ENV.USE_BUILTIN_MODE","Use DSS builtin env")],["INHERIT",translate("SCENARIO.SETTINGS.CODE_ENV.INHERIT","Inherit project default")],["EXPLICIT_ENV",translate("SCENARIO.SETTINGS.CODE_ENV.EXPLICIT_ENV","Select an environment")]]}function setDefaultValue(){if(!$scope.envSelection){return}if($scope.envSelection.envMode=="EXPLICIT_ENV"&&$scope.envSelection.envName==null&&$scope.envNamesWithDescs&&$scope.envNamesWithDescs.envs&&$scope.envNamesWithDescs.envs.length>0){$scope.envSelection.envName=$scope.envNamesWithDescs.envs[0].envName}}$scope.$watch("envSelection.envMode",setDefaultValue);$scope.envNamesWithDescs=[];DataikuAPI.codeenvs.listNamesWithDefault($scope.envLang,$stateParams.projectKey).success(function(data){$scope.envNamesWithDescs=data;data.envs.forEach(function(x){if(x.owner){x.envDesc=x.envName+" ("+x.owner+")"}else{x.envDesc=x.envName}});if(!$scope.inPlugin){if(data.resolvedInheritDefault==null){$scope.envModes[1][1]=translate("SCENARIO.SETTINGS.CODE_ENV.INHERIT_DSS_BUILTIN","Inherit project default (DSS builtin env)")}else{$scope.envModes[1][1]=translate("SCENARIO.SETTINGS.CODE_ENV.INHERIT_CUSTOM","Inherit project default ({{resolvedInheritDefault}})",{resolvedInheritDefault:data.resolvedInheritDefault});$scope.inheritedEnv=data.envs.filter(e=>e.envName===data.resolvedInheritDefault)[0]}}setDefaultValue()}).error(setErrorInScope.bind($scope));function setSelectedEnv(){if($scope.envNamesWithDescs.envs&&$scope.envSelection){$scope.selectedEnv=$scope.envNamesWithDescs.envs.filter(e=>e.envName===$scope.envSelection.envName)[0]}}$scope.$watchGroup(["envSelection.envName","envNamesWithDescs.envs"],setSelectedEnv);if(typeof $scope.callback==="function"){$scope.callback($scope)}if(typeof $scope.checkCodeEnv==="function"){$scope.$watch("envSelection",function(envSelection){$scope.customWarningMessage=$scope.checkCodeEnv(envSelection)},true)}}}});app.directive("containerSelectionForm",function(DataikuAPI,$stateParams){return{restrict:"A",templateUrl:"/templates/recipes/fragments/container-selection-form.html",scope:{containerSelection:"=containerSelectionForm",selectionLabel:"=",inPlugin:"=",workloadType:"=",hideInherit:"=",inheritedFrom:"<",readOnly:"<",inlineHelp:"<",containerSpecificContext:"=?"},link:{post:function($scope,element,attrs){if(!$scope.inheritedFrom){$scope.inheritedFrom="project"}if($scope.hideInherit){$scope.containerModes=[["NONE","None - Use backend to execute"],["EXPLICIT_CONTAINER","Select a container configuration"]]}else{$scope.containerModes=[["NONE","None - Use backend to execute"],["INHERIT","Inherit "+$scope.inheritedFrom+" default"],["EXPLICIT_CONTAINER","Select a container configuration"]]}$scope.containerNames=[];let workloadType=$scope.workloadType||"USER_CODE";if($stateParams.projectKey){DataikuAPI.containers.listNamesWithDefault($stateParams.projectKey,null,workloadType,$scope.containerSpecificContext).success(function(data){$scope.containerNames=data.containerNames;if(data.resolvedInheritValue){$scope.containerModes[1][1]+=" ("+data.resolvedInheritValue+")"}else{$scope.containerModes[1][1]+=" (local execution)"}}).error(setErrorInScope.bind($scope))}else{DataikuAPI.containers.listNames(null,workloadType).success(function(data){$scope.containerNames=data}).error(setErrorInScope.bind($scope))}}}}});app.component("mlHpDistribution",{templateUrl:"/templates/recipes/fragments/ml-hp-distribution.html",bindings:{searchParams:"=",hasSelectedK8sContainer:"<",k8sRuntimeEnvTooltip:"@?",isTimeseriesForecasting:"<"},controller:function(){const $ctrl=this;$ctrl.getK8sRuntimeEnvTooltip=()=>{if($ctrl.k8sRuntimeEnvTooltip){return $ctrl.k8sRuntimeEnvTooltip}return"Distributed search requires a Kubernetes container configuration to be selected"};$ctrl.showHpSearchNotReproducibleWarning=()=>{return $ctrl.isTimeseriesForecasting&&$ctrl.searchParams.nJobs!==1}}});app.controller("_ContinuousRecipeInitStartedJobBehavior",function($scope,$stateParams,DataikuAPI,Logger){DataikuAPI.continuousActivities.getState($stateParams.projectKey,$stateParams.recipeName).success(function(data){$scope.startedJob=$scope.startedJob||{};$scope.startedJob.persistent=data;$scope.startedJob.current=data.mainLoopState;if(data.mainLoopState){if(!data.mainLoopState.futureInfo||!data.mainLoopState.futureInfo.hasResult){$scope.startedJob.jobId=data.mainLoopState.futureId;$scope.waitForEndOfStartedContinuousActivity()}}}).error(function(){Logger.warn("Recipe "+$stateParams.recipeName+" doesn't have a continuous activity yet")})});app.component("aggregationOptionsPopover",{templateUrl:"/templates/recipes/fragments/aggregation-options-popover.html",bindings:{showOrderBy:"<",orderByColumnsGetter:"<?",showFirstLastNotNull:"<",engineCanAggrFirstNotNull:"<?",engineCanAggrConcatDistinct:"<",column:"="},controller:function(translate){const $ctrl=this;$ctrl.translate=translate}})})();(function(){"use strict";const app=angular.module("dataiku.recipes");app.controller("_RecipeCreationControllerBase",function($scope,WT1,Dialogs,PartitionDeps,DataikuAPI,RecipeDescService,RecipeComputablesService,SqlConnectionNamespaceService){$scope.setComputablesMap=function(map){$scope.computablesMap=map;$scope.$broadcast("computablesMapChanged")};$scope.recipeWT1Event=function(type,params){WT1.tryEvent(type,()=>{if(params==null)params={};params.recipeId=$scope.recipeName&&$scope.recipeName.name?$scope.recipeName.name.dkuHashCode():"unknown";params.recipeType=$scope.recipe?$scope.recipe.type:"unknown";params.creation=$scope.creation;return params})};$scope.doCreateRecipe=function(){var recipe=angular.copy($scope.recipe);if($scope.recipeName){recipe.name=$scope.recipeName.name}PartitionDeps.prepareRecipeForSerialize(recipe);const settings={script:$scope.script};if($scope.zone){settings.zone=$scope.zone}if($scope.recipeAdditionalParams){settings.originRecipes=$scope.recipeAdditionalParams.originRecipes;settings.originDataset=$scope.recipeAdditionalParams.originDataset}return DataikuAPI.flow.recipes.generic.create(recipe,settings)};$scope.createRecipe=function(){const isInsert=$scope.recipeAdditionalParams!=null&&$scope.recipeAdditionalParams.originDataset!=null&&$scope.recipeAdditionalParams.originRecipes!=null;const wt1EventParams={insert:isInsert,...$scope.wt1EventAdditionalParams||{}};if($scope.recipeSubType){wt1EventParams.recipeSubType=$scope.recipeSubType}$scope.recipeWT1Event("recipe-create-"+$scope.recipeType,wt1EventParams);var p=$scope.doCreateRecipe();if(p){$scope.creatingRecipe=true;p.success(function(data){if($scope.io&&$scope.io.newOutputTypeRadio=="create"){const fromElasticSearchExportQuery=$scope.recipeAdditionalParams&&!!$scope.recipeAdditionalParams.elasticSearchQuery;WT1.tryEvent("create-dataset",()=>({connectionType:$scope.newOutputDataset&&$scope.newOutputDataset.connectionOption?$scope.newOutputDataset.connectionOption.connectionType:"unknown",partitioningFrom:$scope.newOutputDataset?$scope.newOutputDataset.partitioningOption:"unknown",recipeType:$scope.recipeType,fromElasticSearchExportQuery:fromElasticSearchExportQuery,insert:isInsert}))}$scope.creatingRecipe=false;Dialogs.confirmInfoMessages($scope.$parent.$parent,"Recipe creation",data.messages,null,true).then(function(){$scope.$state.go("projects.project.recipes.recipe",{recipeName:data.id,recipeAdditionalParams:$scope.recipeAdditionalParams})});$scope.dismiss()}).error(function(a,b,c){$scope.creatingRecipe=false;setErrorInScope.bind($scope)(a,b,c)})}};$scope.cannotModifyInputDataset=function(){return $scope.recipeAdditionalParams&&$scope.recipeAdditionalParams.originDataset&&$scope.recipeAdditionalParams.originRecipes&&$scope.recipeAdditionalParams.originRecipes.length};$scope.getDatasetInputSelectorTooltip=function(){if($scope.cannotModifyInputDataset()){return $scope.translate("FLOW.CREATE_RECIPE.INSERT_NO_CHANGE_INPUT","You cannot change the input dataset when inserting a recipe into the flow")}return null};function updateRecipeDesc(){$scope.recipeDesc=RecipeDescService.getDescriptor($scope.recipe.type);const editableFilterLocation="modal";$scope.isSingleInputRecipe=RecipeDescService.isSingleInputRecipe($scope.recipe.type,editableFilterLocation)}if($scope.recipe&&$scope.recipe.type){updateRecipeDesc()}else{$scope.$watch("recipe.type",function(nv){nv&&updateRecipeDesc()})}$scope.$watch("newOutputDataset.connectionOption.connectionName",function(){if($scope.newOutputDataset&&$scope.newOutputDataset.connectionOption){SqlConnectionNamespaceService.setTooltips($scope,$scope.newOutputDataset.connectionOption.connectionType)}SqlConnectionNamespaceService.resetState($scope,$scope.newOutputDataset)})});app.controller("RecipeCopyController",function($scope,$controller,$stateParams,WT1,Assert,DataikuAPI,DatasetUtils,RecipeComputablesService,RecipeDescService,SavedModelsService,Logger){Assert.inScope($scope,"recipe");Assert.inScope($scope,"newInputs");Assert.inScope($scope,"newOutputs");$controller("_RecipeCreationControllerBase",{$scope:$scope});$controller("_RecipeOutputNewManagedBehavior",{$scope:$scope});addDatasetUniquenessCheck($scope,DataikuAPI,$stateParams.projectKey);$scope.setErrorInTopScope=function(scope){return setErrorInScope.bind($scope)};$scope.role=null;function endEditOutput(){$scope.uiState.editingOutput=null;$scope.role=null}$scope.isOutputRoleAvailableHook=function(role){return true};$scope.setupUsableOutputs=function(role,acceptedType){if(!$scope.computablesMap){return}Assert.trueish(role,"no role");$scope.role=role;var roleName=role.name;$scope.noDataset=acceptedType!="DATASET";$scope.noFolder=acceptedType!="MANAGED_FOLDER";$scope.noEvaluationStore=acceptedType!="MODEL_EVALUATION_STORE";$scope.noStreamingEndpoint=acceptedType!="STREAMING_ENDPOINT";if(!$scope.noDataset){$scope.io.newOutputTypeRadio="create"}else if(!$scope.noFolder){$scope.io.newOutputTypeRadio="new-odb"}else if(!$scope.noEvaluationStore){RecipeComputablesService.setMesFlavor($scope,$scope.role);$scope.io.newOutputTypeRadio="new-mes"}else if(!$scope.noStreamingEndpoint){$scope.io.newOutputTypeRadio="new-se"}var outputList=RecipeComputablesService.buildPossibleOutputList($scope.recipe,$scope.computablesMap,$scope.role,$scope.editOutput.filter).filter(function(item){return usableAsOutput(item)});function usableAsOutput(computable){return computable.usableAsOutput[roleName]&&computable.usableAsOutput[roleName].usable&&!computable.alreadyUsedAsOutputOf}outputList.sort(function(a,b){if(usableAsOutput(a)&&!usableAsOutput(b)){return-1}if(usableAsOutput(b)&&!usableAsOutput(a)){return 1}return(a.label||"").localeCompare(b.label||"")});$scope.editOutput.usable=outputList};$scope.startEditOutput=function(roleName,index){$scope.uiState.backendWarnings=null;$scope.uiState.editingOutput={role:roleName,index:index};var outputName=$scope.recipe.outputs[roleName].items[index].ref;var computableType=$scope.computablesMap[outputName].type;if($scope.outputRolesIndex==null||!$scope.outputRolesIndex[roleName]){throw new Error("Role not found in recipe descriptor, try reloading the page")}$scope.setupUsableOutputs($scope.outputRolesIndex[roleName],computableType);$scope.newOutputDataset.connectionOption=null;$scope.getManagedDatasetOptions($scope.role.name).then(function(data){$scope.setupManagedDatasetOptions(data)});$scope.getManagedFolderOptions($scope.role.name).then(function(data){$scope.setupManagedFolderOptions(data)});$scope.getModelEvaluationStoreOptions($scope.role.name).then(function(data){$scope.setupModelEvaluationStoreOptions(data)});$scope.getStreamingEndpointOptions($scope.role.name).then(function(data){$scope.setupStreamingEndpointOptions(data)})};$scope.cancelAddOutput=function(){endEditOutput()};$scope.acceptEdit=function(computable){var editingOutput=$scope.uiState.editingOutput;$scope.newOutputs[editingOutput.role].items[editingOutput.index]={ref:computable.smartName};endEditOutput()};$scope.formIsValid=function(){if($scope.isSingleOutputRecipe){if($scope.io.newOutputTypeRadio=="create"){return $scope.newOutputDataset&&$scope.newOutputDataset.name&&$scope.newOutputDataset.connectionOption&&$scope.isDatasetNameUnique($scope.newOutputDataset.name)}else if($scope.io.newOutputTypeRadio=="new-se"){return $scope.newOutputSE&&$scope.newOutputSE.name&&$scope.newOutputSE.connectionOption&&$scope.isStreamingEndpointNameUnique($scope.newOutputSE.name)}else if($scope.io.newOutputTypeRadio=="select"){return $scope.io.existingOutputDataset&&$scope.io.existingOutputDataset.length}else{return false}}else{var valid=true;$.each($scope.newInputs,function(roleName,role){role.items.forEach(function(input){if(!input||!input.ref){valid=false}})});$.each($scope.newOutputs,function(roleName,role){role.items.forEach(function(output){if(!output||!output.ref){valid=false}})});return valid}};$scope.copy=function(force){var doIt=function(){$scope.recipeWT1Event("recipe-copy-"+$scope.recipe.type);$scope.creatingRecipe=true;var copySettings;if($scope.isSingleOutputRecipe){var createOutput=$scope.io.newOutputTypeRadio=="create";var outputName=$scope.io.newOutputTypeRadio=="create"?$scope.newOutputDataset.name:$scope.io.newOutputTypeRadio=="new-se"?$scope.newOutputSE.name:$scope.io.existingOutputDataset;var singleOutputRoleName=Object.keys($scope.newOutputs)[0];var outputs={};outputs[singleOutputRoleName]={items:[{ref:outputName}]};copySettings={zone:$scope.zone,inputs:$scope.newInputs,outputs:outputs,createOutputDataset:$scope.io.newOutputTypeRadio=="create",createOutputStreamingEndpoint:$scope.io.newOutputTypeRadio=="new-se",outputDatasetSettings:$scope.getDatasetCreationSettings(),outputStreamingEndpointSettings:$scope.getStreamingEndpointCreationSettings()}}else{copySettings={zone:$scope.zone,inputs:$scope.newInputs,outputs:$scope.newOutputs}}DataikuAPI.flow.recipes.generic.copy($stateParams.projectKey,$scope.recipe.projectKey,$scope.recipe.name,copySettings).success(function(data){if(copySettings.createOutputDataset){WT1.event("create-dataset",{connectionType:$scope.newOutputDataset&&$scope.newOutputDataset.connectionOption?$scope.newOutputDataset.connectionOption.connectionType:"unknown",partitioningFrom:$scope.newOutputDataset?$scope.newOutputDataset.partitioningOption:"unknown",recipeType:$scope.recipe?$scope.recipe.type:"unknown"})}$scope.creatingRecipe=false;$scope.dismiss();$scope.$state.go("projects.project.recipes.recipe",{recipeName:data.id})}).error(function(a,b,c){$scope.creatingRecipe=false;setErrorInScope.bind($scope)(a,b,c)})};if(!$scope.isSingleOutputRecipe||["select","new-odb","new-se"].indexOf($scope.io.newOutputTypeRadio)>=0||force){doIt()}else{DataikuAPI.datasets.checkNameSafety($stateParams.projectKey,$scope.newOutputDataset.name,$scope.getDatasetCreationSettings()).success(function(data){$scope.uiState.backendWarnings=data.messages;if(!data.messages||!data.messages.length){doIt()}}).error(function(){Logger.error("Check name failed.",arguments);doIt()})}};$scope.editOutput={filter:""};$scope.uiState=$scope.uiState||{};$scope.uiState.editingOutput=null;var index=RecipeDescService.getRolesIndex($scope.recipe.type);$scope.inputRolesIndex=index.inputs;$scope.outputRolesIndex=index.outputs;var nOutputs=0;var nInputs=0;$.each($scope.recipe.outputs,function(roleName,role){$scope.newOutputs[roleName]={items:$scope.recipe.outputs[roleName].items.map(function(){return null})};nOutputs+=role.items.length});$.each($scope.recipe.inputs,function(roleName,role){nInputs+=role.items.length});$scope.hasSingleOutput=nOutputs==1;$scope.hasSingleInput=nInputs==1;$scope.isSingleOutputRecipe=RecipeDescService.isSingleOutputRecipe($scope.recipe.type);RecipeComputablesService.getComputablesMap($scope.recipe,$scope).then(function(map){$scope.setComputablesMap(map);DatasetUtils.listUsabilityInAndOut($scope.recipe.projectKey,$scope.recipe.type).then(function(data){$scope.availableInputDatasets={};$scope.availableInputFolders={};$scope.availableInputModels={};$scope.availableInputEndpoints={};$scope.availableInputMES={};$scope.recipeDesc.inputRoles.forEach(function(role){$scope.availableInputDatasets[role.name]=data[0].filter(function(computable){return computable.type=="DATASET"&&computable.usableAsInput[role.name]&&computable.usableAsInput[role.name].usable});$scope.availableInputFolders[role.name]=data[0].filter(function(computable){return computable.type=="MANAGED_FOLDER"&&computable.usableAsInput[role.name]&&computable.usableAsInput[role.name].usable});$scope.availableInputMES[role.name]=data[0].filter(function(computable){return computable.type=="MODEL_EVALUATION_STORE"&&computable.usableAsInput[role.name]&&computable.usableAsInput[role.name].usable});const savedModelInput=$scope.recipe.inputs.model&&$scope.recipe.inputs.model.items[0];const savedModelDetails=($scope.computablesMap[savedModelInput&&savedModelInput.ref]||{}).model;const originalInputModelPredType=savedModelDetails&&savedModelDetails.miniTask&&savedModelDetails.miniTask.predictionType;$scope.availableInputModels[role.name]=data[0].filter(function(computable){if(computable.type!="SAVED_MODEL"){return false}if($scope.recipe.type=="prediction_scoring"||$scope.recipe.type=="evaluation"){if(computable.model.miniTask&&computable.model.miniTask.taskType!="PREDICTION"){return false}if(computable.model.miniTask&&computable.model.miniTask.predictionType!==originalInputModelPredType){return false}}else if($scope.recipe.type=="clustering_scoring"&&computable.model.miniTask&&computable.model.miniTask.taskType!="CLUSTERING"){return false}return computable.usableAsInput[role.name]&&computable.usableAsInput[role.name].usable});$scope.availableInputEndpoints[role.name]=data[0].filter(function(computable){return computable.type=="STREAMING_ENDPOINT"&&computable.usableAsInput[role.name]&&computable.usableAsInput[role.name].usable})})})});$scope.$watch("editOutput.filter",function(){try{if(!$scope.uiState.editingOutput)return;var roleName=$scope.uiState.editingOutput.role;var index=$scope.uiState.editingOutput.index;var outputName=$scope.recipe.outputs[roleName].items[index].ref;var computableType=$scope.computablesMap[outputName].type;$scope.setupUsableOutputs($scope.role,computableType)}catch(e){Logger.error("Filter output failed",e)}})});app.controller("SingleOutputRecipeCopyController",function($scope,$controller,$stateParams,Assert,DataikuAPI,DatasetUtils,RecipeComputablesService){Assert.inScope($scope,"recipeDesc");Assert.trueish($scope.recipeDesc.outputRoles,"no output roles");$scope.role=$scope.recipeDesc.outputRoles[0];var updateUsableOutputs=function(){var outputName=$scope.recipe.outputs[$scope.role.name].items[0].ref;var computableType=$scope.computablesMap[outputName].type;$scope.setupUsableOutputs($scope.role,computableType)};var updateManagedDatasetOptions=function(forceUpdate){var fakeRecipe=angular.copy($scope.recipe);fakeRecipe.projectKey=$stateParams.projectKey;fakeRecipe.inputs=$scope.newInputs;DataikuAPI.datasets.getManagedDatasetOptions(fakeRecipe,$scope.role.name).success(function(data){$scope.setupManagedDatasetOptions(data,forceUpdate)});DataikuAPI.datasets.getManagedFolderOptions(fakeRecipe,$scope.role.name).success(function(data){$scope.setupManagedFolderOptions(data,forceUpdate)});DataikuAPI.datasets.getModelEvaluationStoreOptions(fakeRecipe,$scope.role.name).success(function(data){$scope.setupModelEvaluationStoreOptions(data,forceUpdate)});DataikuAPI.datasets.getStreamingEndpointOptions(fakeRecipe,$scope.role.name).success(function(data){$scope.setupStreamingEndpointOptions(data,forceUpdate)})};updateUsableOutputs();updateManagedDatasetOptions();$scope.$watch("sourceRecipe",function(nv){if(!nv)return;updateManagedDatasetOptions(true)});$scope.$watch("computablesMap",function(nv){if(!nv)return;updateUsableOutputs()})});app.controller("SingleOutputDatasetRecipeCreationController",function($scope,Fn,$stateParams,DataikuAPI,$q,Dialogs,DatasetsService,WT1,DatasetUtils,$controller,RecipeComputablesService,Logger,SmartId){$controller("_RecipeCreationControllerBase",{$scope:$scope});$controller("_RecipeOutputNewManagedBehavior",{$scope:$scope});addDatasetUniquenessCheck($scope,DataikuAPI,$stateParams.projectKey);$scope.setErrorInTopScope=function(scope){return setErrorInScope.bind($scope)};$scope.singleOutputRole={name:"main",arity:"UNARY",acceptsDataset:true};var updateManagedDatasetOptions=function(recipeType,inputRef,forceUpdate){var fakeRecipe={type:recipeType,projectKey:$stateParams.projectKey};if(inputRef){fakeRecipe.inputs={main:{items:[{ref:inputRef}]}}}DataikuAPI.datasets.getManagedDatasetOptions(fakeRecipe,"main").success(function(data){$scope.setupManagedDatasetOptions(data,forceUpdate)});DataikuAPI.datasets.getManagedFolderOptions(fakeRecipe,"main").success(function(data){$scope.setupManagedFolderOptions(data,forceUpdate)});DataikuAPI.datasets.getModelEvaluationStoreOptions(fakeRecipe,"main").success(function(data){$scope.setupModelEvaluationStoreOptions(data,forceUpdate)});DataikuAPI.datasets.getStreamingEndpointOptions(fakeRecipe,"main").success(function(data){$scope.setupStreamingEndpointOptions(data,forceUpdate)})};$scope.maybeSetNewDatasetName=function(newName){if($scope.newOutputDataset&&!$scope.newOutputDataset.name&&newName){$scope.newOutputDataset.name=newName}};var makeMainRole=function(refs){return{main:{items:refs.filter(function(ref){return!!ref}).map(function(ref){return{ref:ref}})}}};$scope.getCreationSettings=function(){return{}};$scope.doCreateRecipe=function(){var createOutput=$scope.io.newOutputTypeRadio=="create"||$scope.io.newOutputTypeRadio=="new-se";var outputName=$scope.io.newOutputTypeRadio=="create"?$scope.newOutputDataset.name:$scope.io.newOutputTypeRadio=="new-se"?$scope.newOutputSE.name:$scope.io.existingOutputDataset;var inputs=$scope.recipe&&$scope.recipe.inputs?$scope.recipe.inputs:$scope.inputFolderOnly?makeMainRole([$scope.io.inputFolder.smartName]):makeMainRole([$scope.io.inputDataset]);var recipe={type:$scope.recipeType,projectKey:$stateParams.projectKey,name:"compute_"+outputName,inputs:inputs,outputs:makeMainRole([outputName])};const settings=$scope.getCreationSettings();if($scope.zone){settings.zone=$scope.zone}settings.createOutputDataset=$scope.io.newOutputTypeRadio=="create";settings.createOutputStreamingEndpoint=$scope.io.newOutputTypeRadio=="new-se";settings.outputDatasetSettings=$scope.getDatasetCreationSettings();settings.outputStreamingEndpointSettings=$scope.getStreamingEndpointCreationSettings();if($scope.recipeAdditionalParams){settings.originRecipes=$scope.recipeAdditionalParams.originRecipes;settings.originDataset=$scope.recipeAdditionalParams.originDataset}return DataikuAPI.flow.recipes.generic.create(recipe,settings)};var createRecipeAndDoStuff=$scope.createRecipe;$scope.createRecipe=function(force){if(["select","new-odb","new-se"].indexOf($scope.io.newOutputTypeRadio)>=0||force){createRecipeAndDoStuff()}else{DataikuAPI.datasets.checkNameSafety($stateParams.projectKey,$scope.newOutputDataset.name,$scope.getDatasetCreationSettings()).success(function(data){$scope.uiState.backendWarnings=data.messages;if(!data.messages||!data.messages.length){createRecipeAndDoStuff()}}).error(function(){Logger.error("Check name failed.",arguments);createRecipeAndDoStuff()})}};$scope.showOutputPane=function(){return!!$scope.io.inputDataset||!!$scope.io.inputFolder};$scope.subFormIsValid=function(){return true};$scope.formIsValid=function(){if(!$scope.subFormIsValid())return false;if(!$scope.inputFolderOnly&&!($scope.io.inputDataset&&$scope.activeSchema&&$scope.activeSchema.columns&&$scope.activeSchema.columns.length))return false;if($scope.io.newOutputTypeRadio=="create"){return $scope.newOutputDataset&&$scope.newOutputDataset.name&&$scope.newOutputDataset.connectionOption&&$scope.isDatasetNameUnique($scope.newOutputDataset.name)}else if($scope.io.newOutputTypeRadio=="new-se"){return $scope.newOutputSE&&$scope.newOutputSE.name&&$scope.newOutputSE.connectionOption&&$scope.isStreamingEndpointNameUnique($scope.newOutputSE.name)}else if($scope.io.newOutputTypeRadio=="select"){return $scope.io.existingOutputDataset&&$scope.io.existingOutputDataset.length}else{return false}};let updateInputDatasetSchema=function(){if($scope.availableInputDatasets==null)return;if(!$scope.io.inputDataset)return;let resolvedSmartId=SmartId.resolve($scope.io.inputDataset,contextProjectKey);let availableInput=$scope.availableInputDatasets.filter(o=>o.name==resolvedSmartId.id&&o.projectKey==resolvedSmartId.projectKey)[0];if(availableInput==null||availableInput.type=="DATASET"){DataikuAPI.datasets.get(resolvedSmartId.projectKey,resolvedSmartId.id,contextProjectKey).success(function(data){$scope.activeSchema=data.schema}).error(setErrorInScope.bind($scope))}else if(availableInput.type=="STREAMING_ENDPOINT"){DataikuAPI.streamingEndpoints.get(resolvedSmartId.projectKey,resolvedSmartId.id).success(function(data){$scope.activeSchema=data.schema}).error(setErrorInScope.bind($scope))}else{$scope.activeSchema={columns:[]}}};var inputsIndex={};DatasetUtils.listDatasetsUsabilityInAndOut($stateParams.projectKey,$scope.recipeType,$scope.datasetsOnly).then(function(data){$scope.availableInputDatasets=data[0];if($scope.filterUsableInputsOn){$scope.availableInputDatasets.forEach(function(c){let usability=c.usableAsInput[$scope.filterUsableInputsOn]||{};c.usable=usability.usable;c.usableReason=usability.reason})}else if($scope.inputDatasetsOnly){$scope.availableInputDatasets=data[0].filter(function(computable){return computable.usableAsInput["main"]&&computable.usableAsInput["main"].usable})}$scope.availableOutputDatasets=data[1].filter(function(computable){return computable.usableAsOutput["main"]&&computable.usableAsOutput["main"].usable&&!computable.alreadyUsedAsOutputOf});$scope.availableInputDatasets.forEach(function(it){inputsIndex[it.id]=it});updateInputDatasetSchema()});let contextProjectKey=$scope.context&&$scope.context.projectKey?$scope.context.projectKey:$stateParams.projectKey;$scope.$on("preselectInputDataset",function(scope,preselectedInputDataset){$scope.preselectInputDataset(preselectedInputDataset)});$scope.preselectInputDataset=preselectedInputDataset=>{$scope.io.inputDataset=preselectedInputDataset;$scope.preselectedInputDataset=preselectedInputDataset};$scope.$watch("io.inputDataset",function(nv){updateManagedDatasetOptions($scope.recipeType,$scope.io.inputDataset,true);if(!nv)return;if($scope.preselectedInputDataset&&$scope.io.inputDataset!=$scope.preselectedInputDataset){$scope.zone=null}$scope.autosetName();updateInputDatasetSchema()});$scope.$watch("io.inputDataset2",Fn.doIfNv(function(){let resolvedSmartId=SmartId.resolve($scope.io.inputDataset2,contextProjectKey);DataikuAPI.datasets.get(resolvedSmartId.projectKey,resolvedSmartId.id,contextProjectKey).success(function(data){$scope.activeSchema2=data.schema}).error(setErrorInScope.bind($scope))}));$scope.$on("preselectInputFolder",function(scope,preselectedInputFolder){$scope.io.inputFolder=preselectedInputFolder;$scope.preselectedInputFolder=preselectedInputFolder});$scope.$watch("io.inputFolder",Fn.doIfNv(function(){if($scope.preselectedInputFolder&&$scope.io.inputFolder.smartName!=$scope.preselectedInputFolder.smartName){$scope.zone=null}$scope.autosetName();updateManagedDatasetOptions($scope.recipeType,$scope.io.inputFolder.smartName,true)}))})})();(function(){"use strict";const app=angular.module("dataiku.recipes");app.directive("engineSelectorButton",function(Assert,DataikuAPI,Dialogs,$stateParams,CreateModalFromTemplate){return{scope:{recipeType:"=",recipeStatus:"=",recipeParams:"=",updateStatus:"=",canChangeEngine:"=",hideStatus:"=",iconSize:"<"},templateUrl:"/templates/recipes/fragments/recipe-engine-selection-button.html",link:function($scope,element,attrs){Assert.inScope($scope,"recipeParams");var modalDisplayed=false;$scope.showEngineSelectionModal=function(){if(!modalDisplayed){modalDisplayed=true;var newScope=$scope.$new();CreateModalFromTemplate("/templates/recipes/fragments/recipe-engines-modal.html",newScope,null,function(modalScope){modalScope.nUnselectableEngines=modalScope.recipeStatus.engines.filter(e=>!e.isSelectable).length;modalScope.options={};modalScope.resetEngineType=function(){delete $scope.recipeParams.engineType;$scope.updateStatus();modalScope.dismiss()};modalScope.selectEngine=function(engineType){$scope.recipeParams.engineType=engineType;$scope.updateStatus();modalScope.dismiss()};modalScope.$on("$destroy",_=>modalDisplayed=false)})}}}}})})();(function(){"use strict";var app=angular.module("dataiku.recipes");app.factory("ComputableSchemaRecipeSave",function(DataikuAPI,CreateModalFromTemplate,$q,$stateParams,$rootScope,ActivityIndicator,Logger,Dialogs,RecipesUtils){const checkDropAndRecreateByDefault=incompatibilities=>{return incompatibilities&&incompatibilities.some(incompatibility=>!incompatibility.includes("Column description changed for"))};var setFlags=function(datasets,stricter){$.each(datasets,function(idx,val){if(!val){return}val.dropAndRecreate=checkDropAndRecreateByDefault(val.incompatibilities);val.synchronizeMetastore=val.incompatibilities.length>0&&val.isHDFS})};var getUpdatePromises=function(computables){var promises=[];$.each(computables,function(idx,val){let extraOptions={};if(val.type=="STREAMING_ENDPOINT"){extraOptions.ksqlParams=val.ksqlParams}promises.push(DataikuAPI.flow.recipes.saveOutputSchema($stateParams.projectKey,val.type,val.type=="DATASET"?val.datasetName:val.id,val.newSchema,val.dropAndRecreate,val.synchronizeMetastore,extraOptions))});return promises};var getRecipePromises=function(data){var promises=[];if(data.updatedRecipe&&data.updatedPayload){promises.push(DataikuAPI.flow.recipes.save($stateParams.projectKey,data.updatedRecipe,data.updatedPayload,"Accept recipe update suggestion"))}return promises};var displayPromisesError=function(errRet){var scope=this;let errDetails;if(errRet.data){errDetails=getErrorDetails(errRet.data,errRet.status,errRet.headers,errRet.statusText)}else{errDetails=getErrorDetails(errRet[0].data,errRet[0].status,errRet[0].headers,errRet[0].statusText)}Dialogs.displaySerializedError(scope,errDetails)};return{decorateChangedDatasets:setFlags,getUpdatePromises:getUpdatePromises,getRecipePromises:getRecipePromises,handleSave:function($scope,recipeSerialized,serializedData,deferred){var doSave=function(){$scope.baseSave(recipeSerialized,serializedData).then(function(){deferred.resolve("Save done")},function(error){Logger.error("Could not save recipe");deferred.reject("Could not save recipe")})};DataikuAPI.flow.recipes.getComputableSaveImpact($stateParams.projectKey,recipeSerialized,serializedData).success(function(data){const allPreviousSchemasWereEmpty=data.computables.every(x=>x.previousSchemaWasEmpty);if(data.totalIncompatibilities>0&&allPreviousSchemasWereEmpty){Logger.info("Schema incompatibilities, but all previous schemas were empty, updating and saving");setFlags(data.computables,true);$q.all(getUpdatePromises(data.computables)).then(function(){doSave()}).catch(displayPromisesError.bind($scope))}else if(data.totalIncompatibilities>0){$scope.schemaChanges=data;let outputContainsAppendMode=false;$.each($scope.recipe.outputs,function(x,outputRole){outputContainsAppendMode=outputContainsAppendMode||outputRole.items.some(output=>output.appendMode)});const partitioned=RecipesUtils.hasAnyPartitioning($scope.recipe,$scope.computablesMap);if($scope.currentSaveIsForAnImmediateRun&&!outputContainsAppendMode&&!partitioned){Logger.info("Schema incompatibilities detected, but we are about to run the recipe anyway, so propagate without asking");setFlags($scope.schemaChanges.computables,false);const promises=getUpdatePromises($scope.schemaChanges.computables);$q.all(promises).then(doSave).catch(setErrorInScope.bind($scope))}else if(!outputContainsAppendMode&&!partitioned&&$rootScope.appConfig.autoAcceptSchemaChangeAtEndOfFlow&&data.computables.every(x=>x.isLastInFlow&&!x.isPartitioned)){Logger.info("Schema incompatibilities detected, recipe at end of flow, auto-propagating schema",data);setFlags($scope.schemaChanges.computables,false);const promises=getUpdatePromises($scope.schemaChanges.computables);$q.all(promises).then(doSave).catch(setErrorInScope.bind($scope))}else{Logger.info("Schema incompatibilities detected, and some schemas were not empty, displaying modal",data);let closedWithButton=false;CreateModalFromTemplate("/templates/recipes/fragments/recipe-incompatible-schema-multi.html",$scope,null,function(newScope){setFlags($scope.schemaChanges.computables,false);newScope.cancelSave=function(){closedWithButton=true;newScope.dismiss();Logger.info("Save cancelled");deferred.reject("Save cancelled")};newScope.updateSchemaFromSuggestion=function(){closedWithButton=true;var promises=getUpdatePromises($scope.schemaChanges.computables);$q.all(promises).then(function(){newScope.dismiss();doSave()}).catch(function(data){setErrorInScope.bind($scope)(data.data,data.status,data.headers)})};newScope.ignoreSchemaChangeSuggestion=function(){closedWithButton=true;newScope.dismiss();doSave()}}).then(function(){},function(){if(!closedWithButton){deferred.reject("Modal closed impolitely")}})}}else{Logger.info("No incompatible change, saving");doSave()}}).error(function(data,status,header){Logger.error("Failed to compute recipe save impact");var closedWithButton=false;CreateModalFromTemplate("/templates/recipes/fragments/compute-save-impact-failed.html",$scope,null,function(newScope){setErrorInScope.bind(newScope)(data,status,header);newScope.cancelSave=function(){closedWithButton=true;newScope.dismiss();Logger.info("Save cancelled");deferred.reject("Save cancelled")};newScope.saveAnyway=function(){closedWithButton=true;newScope.dismiss();doSave()}}).then(function(){},function(){if(!closedWithButton){deferred.reject("Modal closed impolitely")}})})},handleSaveShaker:function($scope,recipeSerialized,shaker,recipeOutputSchema,deferred){const doSave=function(){$scope.baseSave(recipeSerialized,JSON.stringify(shaker)).then(function(){$scope.origShaker=angular.copy(shaker);$scope.schemaDirtiness.dirty=false;deferred.resolve("Save done")},function(error){Logger.error("Could not save recipe");deferred.reject("Could not save recipe")})};$scope.waitAllRefreshesDone().then(function(){DataikuAPI.flow.recipes.getShakerSaveImpact($stateParams.projectKey,$scope.recipe,shaker,$scope.recipeOutputSchema).success(function(data){var allPreviousSchemasWereEmpty=data.computables.every(x=>x.previousSchemaWasEmpty);if(data.totalIncompatibilities>0&&allPreviousSchemasWereEmpty){Logger.info("Schema incompatibilities, but all previous schemas were empty, updating and saving");setFlags(data.computables,true);$q.all(getUpdatePromises(data.computables)).then(function(){doSave()}).catch(displayPromisesError.bind($scope))}else if(data.totalIncompatibilities>0){$scope.schemaChanges=data;let outputContainsAppendMode=false;$.each($scope.recipe.outputs,function(x,outputRole){outputContainsAppendMode=outputContainsAppendMode||outputRole.items.some(output=>output.appendMode)});const partitioned=RecipesUtils.hasAnyPartitioning($scope.recipe,$scope.computablesMap);if($scope.currentSaveIsForAnImmediateRun&&!outputContainsAppendMode&&!partitioned){Logger.info("Schema incompatibilities detected, but we are about to run the recipe anyway, so propagate without asking");setFlags($scope.schemaChanges.computables,false);const promises=getUpdatePromises($scope.schemaChanges.computables);$q.all(promises).then(doSave).catch(setErrorInScope.bind($scope))}else if(!outputContainsAppendMode&&!partitioned&&$rootScope.appConfig.autoAcceptSchemaChangeAtEndOfFlow&&data.computables.every(x=>x.isLastInFlow&&!x.isPartitioned)){Logger.info("Schema incompatibilities detected, recipe at end of flow, auto-propagating schema",data);setFlags($scope.schemaChanges.computables,false);const promises=getUpdatePromises($scope.schemaChanges.computables);$q.all(promises).then(doSave).catch(setErrorInScope.bind($scope))}else{Logger.info("Schema incompatibilities detected, and some schemas were not empty, displaying modal",data);CreateModalFromTemplate("/templates/recipes/fragments/recipe-incompatible-schema-multi.html",$scope,null,function(newScope){setFlags($scope.schemaChanges.computables,false);newScope.cancelSave=function(){newScope.dismiss();Logger.info("Save cancelled");deferred.reject("Save cancelled")};newScope.updateSchemaFromSuggestion=function(){var promises=getUpdatePromises($scope.schemaChanges.computables);$q.all(promises).then(function(){newScope.dismiss();doSave()}).catch(function(data){setErrorInScope.bind($scope)(data.data,data.status,data.headers)})};newScope.ignoreSchemaChangeSuggestion=function(){newScope.dismiss();doSave()}})}}else{Logger.info("No incompatible change, saving");doSave()}}).error(function(data,status,header){setErrorInScope.bind($scope)(data,status,header);deferred.reject("failed to execute getComputableSaveImpact")})})},handleSchemaUpdateForDeleteAndReconnect:function(parentScope,recipeProjectKey,recipeName){this.handleSchemaUpdateFromAnywhere(parentScope,recipeProjectKey,recipeName,true)},handleSchemaUpdateFromAnywhere:function(parentScope,recipeProjectKey,recipeName,partOfReconnect){var serviceScope=parentScope.$new();DataikuAPI.flow.recipes.getSchemaUpdateResult(recipeProjectKey,recipeName).then(function(resp){const data=resp.data;var allPreviousSchemasWereEmpty=data.computables.every(x=>x.previousSchemaWasEmpty);if(data.totalIncompatibilities>0&&allPreviousSchemasWereEmpty){Logger.info("Schema incompatibilities, but all previous schemas were empty, updating and saving");setFlags(data.computables,true);$q.all(getUpdatePromises(data.computables)).then(function(){}).catch(displayPromisesError.bind(parentScope))}else if(data.totalIncompatibilities>0){Logger.info("Schema incompatibilities detected, and some schemas were not empty, displaying modal",data);serviceScope.schemaChanges=data;serviceScope.partOfReconnect=Boolean(partOfReconnect);serviceScope.recipeName=recipeName;CreateModalFromTemplate("/templates/recipes/incompatible-schema-external-modal.html",serviceScope,null,function(newScope){setFlags(serviceScope.schemaChanges.computables,true);newScope.updateSchemaFromSuggestion=function(){var promises=getUpdatePromises(serviceScope.schemaChanges.computables);$q.all(promises).then(function(){newScope.dismiss()}).catch(function(data){setErrorInScope.bind(newScope)(data.data,data.status,data.headers)})};newScope.ignoreSchemaChangeSuggestion=function(){newScope.dismiss()}})}else{if(!partOfReconnect){ActivityIndicator.success("Schema is already up-to-date")}}}).catch(function(data,status,header){if(!partOfReconnect){CreateModalFromTemplate("/templates/recipes/propagate-schema-changes-failed-modal.html",serviceScope,null,function(newScope){setErrorInScope.bind(newScope)(data,status,header)})}})},handleSchemaUpdateWithPrecomputedUnattended:function(parentScope,data){var deferred=$q.defer();if(data&&(data.totalIncompatibilities>0||data.recipeChanges.length>0)){Logger.info("Schema incompatibilities, unattended mode, updating and saving");setFlags(data.computables,true);$q.all(getUpdatePromises(data.computables).concat(getRecipePromises(data))).then(function(){deferred.resolve({changed:true})}).catch(displayPromisesError.bind(parentScope))}else{deferred.resolve({changed:false})}return deferred.promise},handleSchemaUpdateWithPrecomputed:function(parentScope,data){var deferred=$q.defer();var serviceScope=parentScope.$new();var allPreviousSchemasWereEmpty=data&&data.computables.every(x=>x.previousSchemaWasEmpty);if(data&&data.totalIncompatibilities>0&&allPreviousSchemasWereEmpty&&data.recipeChanges.length==0){Logger.info("Schema incompatibilities, but all previous schemas were empty, updating and saving");setFlags(data.computables,true);$q.all(getUpdatePromises(data.computables).concat(getRecipePromises(data))).then(function(){deferred.resolve({changed:true})}).catch(displayPromisesError.bind(parentScope))}else if(data&&(data.totalIncompatibilities>0||data.recipeChanges.length>0)){Logger.info("Schema incompatibilities detected, and some schemas were not empty, displaying modal",data);serviceScope.schemaChanges=data;CreateModalFromTemplate("/templates/recipes/incompatible-schema-external-modal.html",serviceScope,null,function(newScope){setFlags(serviceScope.schemaChanges.computables,true);newScope.updateSchemaFromSuggestion=function(){var promises=getUpdatePromises(serviceScope.schemaChanges.computables).concat(getRecipePromises(serviceScope.schemaChanges));$q.all(promises).then(function(){newScope.dismiss();deferred.resolve({changed:true})}).catch(function(data){setErrorInScope.bind(newScope)(data.data,data.status,data.headers);deferred.reject("Change failed")})};newScope.ignoreSchemaChangeSuggestion=function(){newScope.dismiss();deferred.resolve({changed:false})}})}else{deferred.resolve({changed:false})}return deferred.promise}}});app.directive("codeRecipeSchemaList",function(DataikuAPI,Dialogs,$stateParams,CreateModalFromTemplate){return{link:function($scope,element,attrs){$scope.beginEditSchema=function(datasetSmartName){const computable=$scope.computablesMap[datasetSmartName];if(!computable){throw new Error("Dataset not in computablesMap, try reloading the page")}const dataset=computable.dataset;DataikuAPI.datasets.get(dataset.projectKey,dataset.name,$stateParams.projectKey).success(function(data){CreateModalFromTemplate("/templates/recipes/code-edit-schema.html",$scope,null,function(newScope){newScope.dataset=data;newScope.showGenerateMetadata=false}).then(function(schema){dataset.schema=schema})}).error(setErrorInScope.bind($scope))}}}});app.directive("schemaEditorBase",function(DatasetUtils,$timeout,CreateModalFromTemplate,ContextualMenu,ExportUtils,ColumnTypeConstants,ActivityIndicator,DataikuAPI,ActiveProjectKey,translate){return{scope:true,link:function($scope,element,attrs){$scope.columnTypes=ColumnTypeConstants.types;$scope.columnTypesWithDefault=[{name:"",label:"All types"},...ColumnTypeConstants.types];$scope.translate=translate;$scope.meaningsWithDefault=Object.fromEntries([["","All meanings"],...Object.entries($scope.appConfig.meanings.labelsMap)]);$scope.menusState={meaning:false};$scope.startEditName=function(column,$event){$event.stopPropagation();$scope.dataset.schema.columns.forEach(function(x){x.$editingName=false;x.$editingComment=false});var grandpa=$($event.target.parentNode.parentNode.parentNode);$timeout(function(){grandpa.find("input").focus()})};$scope.handleInputClick=function($event){$event.stopPropagation()};$scope.blur=function(event){$timeout(function(){event.currentTarget.blur()})};$scope.setSchemaUserModifiedIfDirty=function(){if($scope.datasetIsDirty&&$scope.datasetIsDirty()){$scope.setSchemaUserModified()}};function arrayMove(arr,from,to){arr.splice(to,0,arr.splice(from,1)[0])}$scope.moveColumnUp=function(column){var index=$scope.dataset.schema.columns.indexOf(column);if(index>0){arrayMove($scope.dataset.schema.columns,index,index-1);$scope.setSchemaUserModified()}};$scope.moveColumnDown=function(column){var index=$scope.dataset.schema.columns.indexOf(column);if(index>=0&&index<$scope.dataset.schema.columns.length-1){arrayMove($scope.dataset.schema.columns,index,index+1);$scope.setSchemaUserModified()}};$scope.startEditComment=function(column,$event){$scope.dataset.schema.columns.forEach(function(x){x.$editingName=false;x.$editingComment=false});column.$editingComment=true;$timeout(function(){$($event.target).find("input").focus()},50)};$scope.addNew=function(){if($scope.dataset.schema==null){$scope.dataset.schema={columns:[]}}if($scope.dataset.schema.columns==null){$scope.dataset.schema.columns=[]}$scope.setSchemaUserModified();$scope.dataset.schema.columns.push({$editingName:true,name:"",type:"string",comment:"",maxLength:1e3});$scope.clearFilters();$timeout(function(){$scope.$broadcast("scrollToLine",-1)})};$scope.selection.orderQuery="$idx";$scope.openMeaningMenu=function($event,column){$scope.meaningMenu.openAtXY($event.pageX,$event.pageY);$scope.meaningColumn=column};$scope.openMassActionMenu=function(){$scope.meaningColumn=null};$scope.setColumnMeaning=function(meaningId){if($scope.meaningColumn==null){$scope.selection.selectedObjects.forEach(function(c){if(meaningId==null){delete c.meaning}else{c.meaning=meaningId}})}else{if(meaningId==null){delete $scope.meaningColumn.meaning}else{$scope.meaningColumn.meaning=meaningId}}$(".code-edit-schema-box").css("display","block");if($scope.setSchemaUserModified)$scope.setSchemaUserModified()};$scope.editColumnUDM=function(){CreateModalFromTemplate("/templates/meanings/column-edit-udm.html",$scope,null,function(newScope){var columnName;if($scope.meaningColumn==null){columnName=$scope.selection.selectedObjects[0].name}else{columnName=$scope.meaningColumn.name}newScope.initModal(columnName,$scope.setColumnMeaning)})};$scope.generateDatasetDescription=function(){DataikuAPI.datasets.get($scope.dataset.projectKey,$scope.dataset.name,ActiveProjectKey.get()).noSpinner().success(function(data){angular.extend($scope.dataset,data);CreateModalFromTemplate("/static/dataiku/ai-dataset-descriptions/generate-documentation-modal/generate-documentation-modal.html",$scope,"AIDatasetDescriptionsModalController",function(scope){scope.init($scope.dataset,$scope.canWriteProject)})}).error(setErrorInScope.bind($scope))};$scope.exportSchema=function(){if(!$scope.dataset.schema||!$scope.dataset.schema.columns){ActivityIndicator.error("Empty schema.");return}ExportUtils.exportUIData($scope,{name:"Schema of "+$scope.dataset.name,columns:[{name:"name",type:"string"},{name:"type",type:"string"},{name:"meaning_id",type:"string"},{name:"description",type:"string"},{name:"max_length",type:"int"}],data:$scope.dataset.schema.columns.map(function(c){return[c.name,c.type,c.meaning,c.comment,c.maxLength>=0?c.maxLength:""]})},"Export schema")};$scope.meaningMenu=new ContextualMenu({template:"/templates/shaker/edit-meaning-contextual-menu.html",cssClass:"column-header-meanings-menu pull-right",scope:$scope,contextual:false,onOpen:function(){},onClose:function(){}});var reNumberColumns=function(){var columns=$scope.$eval(attrs.ngModel);if(!columns)return};$scope.setColumnsType=function(columnType){$scope.selection.selectedObjects.forEach(function(c){c.type=columnType})};$scope.doRenameColumns=function(renamings){renamings.forEach(function(renaming){$scope.selection.selectedObjects.forEach(function(c){if(c.name==renaming.from){c.name=renaming.to}})})};$scope.renameColumns=function(){CreateModalFromTemplate("/templates/shaker/modals/shaker-rename-columns.html",$scope,"MassRenameColumnsController",function(newScope){newScope.setColumns($scope.selection.selectedObjects.map(function(c){return c.name}));newScope.doRenameColumns=function(renamings){$scope.doRenameColumns(renamings)}})};var commonBaseTypeChanged=function(){if(!$scope.selection||!$scope.selection.multiple)return;if(!$scope.multipleSelectionInfo||!$scope.multipleSelectionInfo.commonBaseType)return;var columns=$scope.selection.selectedObjects;columns.forEach(function(column){column.type=$scope.multipleSelectionInfo.commonBaseType.type})};var commonTypeChanged=function(){if(!$scope.selection||!$scope.selection.multiple)return;if(!$scope.multipleSelectionInfo||!$scope.multipleSelectionInfo.commonType)return;var columns=$scope.selection.selectedObjects;var setFullType=function(column,commonType){column.type=commonType.type;column.maxLength=commonType.maxLength;column.objectFields=commonType.objectFields?angular.copy(commonType.objectFields):null;column.arrayContent=commonType.arrayContent?angular.copy(commonType.arrayContent):null;column.mapKeys=commonType.mapKeys?angular.copy(commonType.mapKeys):null;column.mapValues=commonType.mapValues?angular.copy(commonType.mapValues):null};columns.forEach(function(column){setFullType(column,$scope.multipleSelectionInfo.commonType)})};var updateInfoForMultipleTab=function(){if($scope.commonTypeChangedDeregister){$scope.commonTypeChangedDeregister();$scope.commonTypeChangedDeregister=null}if($scope.commonBaseTypeChangedDeregister){$scope.commonBaseTypeChangedDeregister();$scope.commonBaseTypeChangedDeregister=null}if(!$scope.selection||!$scope.selection.multiple)return;var getFullType=function(column){return{type:column.type?column.type:null,maxLength:column.maxLength?column.maxLength:null,objectFields:column.objectFields?column.objectFields:null,arrayContent:column.arrayContent?column.arrayContent:null,mapKeys:column.mapKeys?column.mapKeys:null,mapValues:column.mapValues?column.mapValues:null}};var columns=$scope.selection.selectedObjects;var names=columns.map(function(column){return column.name});var meanings=columns.map(function(column){return column.meaning});var types=columns.map(function(column){return column.type});var fullTypes=columns.map(function(column){return getFullType(column)});var firstFullType=fullTypes[0];var sameTypes=fullTypes.map(function(t){return angular.equals(t,firstFullType)}).reduce(function(a,b){return a&&b});var commonType=sameTypes?firstFullType:null;$scope.multipleSelectionInfo={sameTypes:sameTypes,commonType:commonType,commonBaseType:null};$scope.commonBaseTypeChangedDeregister=$scope.$watch("multipleSelectionInfo.commonBaseType",commonBaseTypeChanged);$scope.commonTypeChangedDeregister=$scope.$watch("multipleSelectionInfo.commonType",commonTypeChanged,true)};$scope.$watch("selection.multiple",updateInfoForMultipleTab);$scope.$watch("selection.selectedObjects",updateInfoForMultipleTab,true);$scope.$watch(attrs.ngModel,reNumberColumns);$scope.$watch(attrs.ngModel,reNumberColumns,true)}}});app.directive("codeRecipeSchemaEditing",function(DataikuAPI,DatasetUtils,DatasetsService,Dialogs,$stateParams,$timeout,Logger){return{link:function($scope,element,attrs){$scope.overwriteSchema=function(newSchema){$scope.dataset.schema=angular.copy(newSchema);$scope.schemaJustModified=false;$scope.consistency=null};$scope.saveSchema=function(){DataikuAPI.datasets.save($scope.dataset.projectKey,$scope.dataset).success(function(data){$scope.resolveModal($scope.dataset.schema)}).error(setErrorInScope.bind($scope))};$scope.discardConsistencyError=function(){$scope.consistency=null};$scope.setSchemaUserModified=function(){$scope.schemaJustModified=true;$scope.dataset.schema.userModified=true;$scope.consistency=null};$scope.addColumn=function(){if($scope.dataset.schema==null){$scope.dataset.schema={columns:[]}}$scope.setSchemaUserModified();$scope.dataset.schema.columns.push({$editingName:true,name:"",type:"string",comment:"",maxLength:1e3})};$scope.checkConsistency=function(){Logger.info("Checking consistency");$scope.schemaJustModified=false;DataikuAPI.datasets.testSchemaConsistency($scope.dataset).success(function(data){Logger.info("Got consistency result",data);$scope.consistency=data;$scope.consistency.kind=DatasetUtils.getKindForConsistency($scope.dataset)})}}}})})();(function(){"use strict";const app=angular.module("dataiku.recipes");app.directive("recipeIoInputs",function(RecipesUtils,RecipeComputablesService,$stateParams){return{scope:true,templateUrl:function(element,attrs){return"/templates/recipes/io/"+attrs.location+"-inputs.html"},link:{pre:function($scope,element,attrs){$scope.roles=$scope.$eval(attrs.roles);$scope.uiState=$scope.uiState||{};$scope.uiState.warningMessages=$scope.uiState.warningMessages||{};$scope.location=attrs.location;$scope.longRoleList=$scope.roles.filter(role=>$scope.recipe.inputs[role.name]&&$scope.recipe.inputs[role.name].items.length>0).length>2;$scope.editInputs=[];if($scope.roles){$scope.roles.forEach(function(role){role.editing=false})}$scope.setErrorInTopScope=function(scope){return setErrorInScope.bind($scope.$parent)};$scope.isInputRoleAvailableHook=function(role){if(!role.availabilityDependsOnPayload){return true}if(!$scope.isInputRoleAvailableForPayload){throw new Error(`No rule defined for availability of input role "${role.name}"`)}else{return $scope.isInputRoleAvailableForPayload(role)}};function getEditableRoles(){if(!$scope.roles){return[]}const isRoleEditableFn=attrs.location==="modal"?role=>role.editableInModal:role=>role.editableInEditor;return $scope.roles.filter(isRoleEditableFn)}$scope.shouldDisplayDisabledCreateExplanation=function(){let roles=getEditableRoles();if(roles.length===0||(roles.some(role=>role.editing)||$scope.editInputs.length>0)){return false}if("shouldDisplayInputExplanation"in $scope){return $scope.shouldDisplayInputExplanation()}return roles.some(role=>$scope.isInputRoleAvailableHook(role)&&role.required&&(!$scope.recipe.inputs[role.name]||!$scope.recipe.inputs[role.name].items.length))};$scope.generateDisabledCreateExplanation=function(){if("generateInputExplanation"in $scope){return $scope.generateInputExplanation()}let roles=getEditableRoles();if(roles.length===0){return""}if(roles.length===1){return"This recipe requires at least one input."}else{const requiredRoles=roles.filter(role=>$scope.isInputRoleAvailableHook(role)&&role.required).map((role,inputRoleIdx)=>{if(role.name==="main"&&!role.label){return"main input"}else if(!role.name&&!role.label){return"input "+(inputRoleIdx+1)}else{return'"'+(role.label||role.name)+'"'}});return"This recipe requires at least one input in: "+requiredRoles.slice(0,-1).join(", ")+(requiredRoles.length===2?" and ":", and ")+requiredRoles.slice(-1)+"."}}}}}});app.directive("recipeIoOutputs",function(RecipesUtils,RecipeComputablesService,$stateParams){return{scope:true,templateUrl:function(element,attrs){return"/templates/recipes/io/"+attrs.location+"-outputs.html"},link:{pre:function($scope,element,attrs){$scope.roles=$scope.$eval(attrs.roles);$scope.location=attrs.location;$scope.longRoleList=$scope.roles.filter(role=>$scope.recipe.outputs[role.name]&&$scope.recipe.outputs[role.name].items.length>0).length>2;$scope.editOutputs=[];if($scope.roles){$scope.roles.forEach(function(role){role.editing=false})}$scope.canAppend=function(computable){if(computable.noAppend)return false;if(["cpython","ksql","csync","streaming_spark_scala"].indexOf($scope.recipe.type)>=0)return false;if(["upsert","extract_content"].indexOf($scope.recipe.type)>=0)return false;const selectedEngine=$scope.recipeStatus?$scope.recipeStatus.selectedEngine:null;if(computable.onlyAppendOnStreamOrSQLEngine&&selectedEngine){return!!selectedEngine.canEngineAppend}else{return true}};$scope.setErrorInTopScope=function(scope){return setErrorInScope.bind($scope.$parent)};$scope.isOutputRoleAvailableHook=function(role){if(!role.availabilityDependsOnPayload){return true}if(!$scope.isOutputRoleAvailableForPayload){throw new Error(`No rule defined for availability of output role "${role.name}"`)}else{return $scope.isOutputRoleAvailableForPayload(role)}};$scope.shouldDisplayDisabledCreateExplanation=function(){if(!$scope.roles||($scope.roles.some(role=>role.editing)||$scope.editOutputs.length>0)){return false}if("shouldDisplayOutputExplanation"in $scope){return $scope.shouldDisplayOutputExplanation()}return $scope.roles.some(role=>$scope.isOutputRoleAvailableHook(role)&&role.required&&(!$scope.recipe.outputs[role.name]||!$scope.recipe.outputs[role.name].items.length))};$scope.generateDisabledCreateExplanation=function(){if("generateOutputExplanation"in $scope){return $scope.generateOutputExplanation()}if($scope.roles.length===0){return""}if($scope.roles.length===1){return"This recipe requires at least one output."}else{const requiredRoles=$scope.roles.filter(role=>$scope.isOutputRoleAvailableHook(role)&&role.required).map((role,outputRoleIdx)=>{if(role.name==="main"&&!role.label){return"main output"}else if(!role.name&&!role.label){return"output "+(outputRoleIdx+1)}else{return'"'+(role.label||role.name)+'"'}});return"This recipe requires at least one output in: "+requiredRoles.slice(0,-1).join(", ")+(requiredRoles.length===2?" and ":", and ")+requiredRoles.slice(-1)+"."}};$scope.shouldDisplayConfigurationAlert=function(){return $scope.recipeAdditionalParams&&$scope.recipeAdditionalParams.originRecipes&&$scope.recipeAdditionalParams.originRecipes.length&&!($scope.roles&&$scope.roles.some(role=>role.editing))}}}}});app.directive("recipeIoInputList",function(RecipesUtils,RecipeComputablesService,$stateParams,$compile){return{scope:true,restrict:"E",link:function($scope,element,attrs){var roleElements=[];$scope.roles.forEach(function(role,index){roleElements.push('<div recipe-io-input-display-list role-index="'+index+'" location="'+$scope.location+'"/>');roleElements.push('<div recipe-io-input-add-list role-index="'+index+'"location="'+$scope.location+'"/>')});element.replaceWith($compile(roleElements.join("\n"))($scope))}}});app.directive("recipeIoOutputList",function(RecipesUtils,RecipeComputablesService,$stateParams,$compile,$rootScope){return{scope:true,restrict:"E",link:function($scope,element,attrs){var roleElements=[];$scope.roles.forEach(function(role,index){roleElements.push('<div recipe-io-output-display-list role-index="'+index+'" location="'+$scope.location+'"/>');roleElements.push('<div recipe-io-output-add-list role-index="'+index+'"location="'+$scope.location+'"/>')});element.replaceWith($compile(roleElements.join("\n"))($scope))}}});app.directive("recipeIoInputDisplayList",function(RecipesUtils){return{scope:true,replace:true,templateUrl:function(element,attrs){return"/templates/recipes/io/"+attrs.location+"-input-display-list.html"},link:function($scope,element,attrs){$scope.role=$scope.roles[parseInt(attrs.roleIndex)];$scope.hasAnyPartitioning=function(){return RecipesUtils.hasAnyPartitioning($scope.recipe,$scope.computablesMap)};$scope.canDeleteInput=function(role){return role.editableInEditor&&(role.arity!="UNARY"||!role.required)};$scope.cannotEditInputForInsert=function(dataset){return $scope.recipeAdditionalParams&&$scope.recipeAdditionalParams.originDataset&&$scope.recipeAdditionalParams.originDataset===dataset.ref&&$scope.recipeAdditionalParams.originRecipes&&$scope.recipeAdditionalParams.originRecipes.length};$scope.getDatasetInputTooltip=function(dataset){if($scope.cannotEditInputForInsert(dataset)){return"You cannot change this input dataset when inserting a recipe into the flow"}return null}}}});app.directive("recipeIoInputAddList",function(Assert,RecipesUtils,RecipeDescService,RecipeComputablesService,$stateParams,DKUtils,DataikuAPI,$q){return{scope:true,replace:true,templateUrl:function(element,attrs){return"/templates/recipes/io/"+attrs.location+"-input-add-list.html"},link:function($scope,element,attrs){$scope.role=$scope.roles[parseInt(attrs.roleIndex)];$scope.hasAnyPartitioning=function(){return RecipesUtils.hasAnyPartitioning($scope.recipe,$scope.computablesMap)};$scope.addInput={adding:false,role:null,filter:null};var beginEdition=function(){$scope.addInput.adding=true;$scope.role.editing=true;$scope.editInputs.push($scope.addInput)};var endEdition=function(){$scope.addInput.adding=false;$scope.role.editing=false;var idx=$scope.editInputs.indexOf($scope.addInput);if(idx>=0)$scope.editInputs.splice(idx,1)};var setUsable=function(list){var roleName=$scope.role.name;list.sort(function(a,b){var aIsUsable=a.usableAsInput[roleName]&&a.usableAsInput[roleName].usable;var bIsUsable=b.usableAsInput[roleName]&&b.usableAsInput[roleName].usable;if(aIsUsable&&!bIsUsable)return-1;if(!aIsUsable&&bIsUsable)return 1;return(a.label||"").localeCompare(b.label||"")});$scope.addInput.usable=list};$scope.$watch("addInput.filter",function(nv){if($scope.recipe&&$scope.computablesMap){setUsable(RecipeComputablesService.buildPossibleInputList($scope.recipe,$scope.computablesMap,$scope.addInput.role,$scope.addInput.filter))}});$scope.itemsWatchHooked=false;var hookItemsWatch=function(){$scope.itemsArray=$scope.recipe.inputs[$scope.role.name].items;$scope.$watchCollection("itemsArray",function(nv){if($scope.roleChanged){$scope.roleChanged($scope.role.name)}});$scope.itemsWatchHooked=true};if($scope.recipe.inputs[$scope.role.name]!=null){hookItemsWatch()}$scope.enterAddInput=function(role){beginEdition();$scope.addInput.role=role;setUsable(RecipeComputablesService.buildPossibleInputList($scope.recipe,$scope.computablesMap,role,$scope.addInput.filter))};$scope.cancelAddInput=function(){endEdition()};$scope.acceptAddInput=function(computable){Assert.trueish($scope.addInput.adding,"not adding inputs");var promise=$q.when(null);if(attrs.location=="modal"){if($scope.recipe.inputs[$scope.addInput.role]==null||$scope.role.arity=="UNARY"){$scope.recipe.inputs[$scope.addInput.role]={items:[]}}$scope.recipe.inputs[$scope.addInput.role].items.push({ref:computable.smartName,deps:[]})}else{var currentRecipeAndPayload={recipe:angular.copy($scope.recipe),payload:angular.copy($scope.script.data)};var newRecipeAndPayload={recipe:angular.copy($scope.recipe),payload:angular.copy($scope.script.data)};if(newRecipeAndPayload.recipe.inputs[$scope.addInput.role]==null||$scope.role.arity=="UNARY"){newRecipeAndPayload.recipe.inputs[$scope.addInput.role]={items:[]}}newRecipeAndPayload.recipe.inputs[$scope.addInput.role].items.push({ref:computable.smartName,deps:[]});promise=DataikuAPI.flow.recipes.getIOChangeResult($stateParams.projectKey,currentRecipeAndPayload,newRecipeAndPayload).error($scope.setErrorInTopScope($scope)).then(function(resp){var roleDesc=RecipeDescService.getInputRoleDesc($scope.recipe.type,$scope.addInput.role);$scope.recipe.inputs=resp.data.updated.recipe.inputs;$scope.recipe.outputs=resp.data.updated.recipe.outputs;const messages=resp.data.messages.messages||[];$scope.uiState.warningMessages[$scope.role.name]=messages.filter(x=>x.severity=="WARNING");if(roleDesc.saveAndReloadAfterEditInEditor){$scope.baseSave($scope.hooks.getRecipeSerialized(),$scope.script?$scope.script.data:null).then(function(){DKUtils.reloadState()})}return})}promise.then(function(){endEdition();if(!$scope.itemsWatchHooked){hookItemsWatch()}})}}}});app.controller("_RecipeOutputNewManagedBehavior",function($scope,WT1,Logger,DataikuAPI,$stateParams,RecipeComputablesService,$rootScope,SqlConnectionNamespaceService,ConnectionsService){$scope.newOutputDataset={};$scope.newOutputODB={};$scope.newOutputMES={};$scope.newOutputSE={};$scope.io=$scope.io||{};$scope.io.newOutputTypeRadio="create";$scope.forms={};$scope.uiState=$scope.uiState||{};delete $scope.uiState.backendWarnings;$scope.getManagedDatasetOptions=function(role){return DataikuAPI.datasets.getManagedDatasetOptions($scope.recipe,role).then(function(data){return data.data}).catch($scope.setErrorInTopScope($scope))};$scope.searchConnectionsWithDescriptions=ConnectionsService.searchConnectionsWithDescriptions;$scope.setupManagedDatasetOptions=function(data,forceUpdate){$scope.managedDatasetOptions=data;if(data.connections.length&&(!$scope.newOutputDataset.connectionOption||forceUpdate)){$scope.newOutputDataset.connectionOption=data.connections[0]}$scope.partitioningOptions=[{id:"NP",label:$scope.translate("FLOW.CREATE_RECIPE.PARTITIONING.NOT_PARTITIONED","Not partitioned")}];$scope.partitioningOptions=$scope.partitioningOptions.concat(data.inputPartitionings).concat(data.projectPartitionings);if(data.inputPartitionings.length){$scope.newOutputDataset.partitioningOption=data.inputPartitionings[0].id}else{$scope.newOutputDataset.partitioningOption="NP"}};$scope.getManagedFolderOptions=function(role){return DataikuAPI.datasets.getManagedFolderOptions($scope.recipe,role).then(function(data){return data.data}).catch($scope.setErrorInTopScope($scope))};$scope.getModelEvaluationStoreOptions=function(role){return DataikuAPI.datasets.getModelEvaluationStoreOptions($scope.recipe,role).then(function(data){return data.data}).catch($scope.setErrorInTopScope($scope))};$scope.getStreamingEndpointOptions=function(role){return DataikuAPI.datasets.getStreamingEndpointOptions($scope.recipe,role).then(function(data){return data.data}).catch($scope.setErrorInTopScope($scope))};var updateFolderConnection=function(){if($scope.newOutputODB.$connection==null)return;$scope.newOutputODB.connectionOption=$scope.newOutputODB.$connection.connectionName;$scope.newOutputODB.typeOption=$scope.newOutputODB.$connection.fsProviderTypes[0]};var updateStreamingEndpointConnection=function(){if($scope.newOutputSE.$connection==null)return;$scope.newOutputSE.connectionOption=$scope.newOutputSE.$connection.connectionName;if($scope.newOutputSE.$connection.formats&&$scope.newOutputSE.$connection.formats.length){$scope.newOutputSE.formatOptionId=$scope.newOutputSE.$connection.formats[0].id}};$scope.setupManagedFolderOptions=function(data,forceUpdate){$scope.managedFolderOptions=data;$scope.managedFolderOptions.connections=$scope.managedFolderOptions.connections.filter(function(c){return c.fsProviderTypes!=null});if(data.connections.length&&(!$scope.newOutputODB.connectionOption||forceUpdate)){$scope.newOutputODB.$connection=data.connections[0];updateFolderConnection()}$scope.partitioningOptions=[{id:"NP",label:$scope.translate("FLOW.CREATE_RECIPE.PARTITIONING.NOT_PARTITIONED","Not partitioned")}];$scope.partitioningOptions=$scope.partitioningOptions.concat(data.inputPartitionings).concat(data.projectPartitionings);if(data.inputPartitionings.length){$scope.newOutputODB.partitioningOption=data.inputPartitionings[0].id}else{$scope.newOutputODB.partitioningOption="NP"}};$scope.setupModelEvaluationStoreOptions=function(data,forceUpdate){$scope.modelEvaluationStoreOptions=data;$scope.partitioningOptions=[{id:"NP",label:$scope.translate("FLOW.CREATE_RECIPE.PARTITIONING.NOT_PARTITIONED","Not partitioned")}];$scope.partitioningOptions=$scope.partitioningOptions.concat(data.inputPartitionings).concat(data.projectPartitionings);$scope.newOutputMES.partitioningOption="NP"};$scope.setupStreamingEndpointOptions=function(data,forceUpdate){$scope.streamingEndpointOptions=data;if(data.connections.length&&(!$scope.newOutputSE.connectionOption||forceUpdate)){$scope.newOutputSE.$connection=data.connections[0];updateStreamingEndpointConnection()}};$scope.$watch("newOutputDataset.connectionOption",function(nv,ov){if(nv&&nv.formats&&nv.formats.length){$scope.newOutputDataset.formatOptionId=nv.formats[0].id}if(nv&&nv.fsProviderTypes&&nv.fsProviderTypes.length>1){$scope.newOutputDataset.typeOption=nv.fsProviderTypes[0]}if($scope.newOutputDataset.connectionOption){SqlConnectionNamespaceService.setTooltips($scope,$scope.newOutputDataset.connectionOption.connectionType)}SqlConnectionNamespaceService.resetState($scope,$scope.newOutputDataset)},true);function doCreateAndUseNewOutputDataset(projectKey,datasetName,settings){Logger.info("Create and use ",$scope);DataikuAPI.datasets.newManagedDataset(projectKey,datasetName,settings).success(function(dataset){RecipeComputablesService.getComputablesMap($scope.recipe,$scope).then(function(map){$scope.setComputablesMap(map);$scope.acceptEdit($scope.computablesMap[dataset.name]);$scope.newOutputDataset.name="";$scope.forms.newOutputDatasetForm.$setPristine(true);$rootScope.$emit("datasetsListChangedFromModal")});WT1.event("create-dataset",{connectionType:$scope.newOutputDataset&&$scope.newOutputDataset.connectionOption?$scope.newOutputDataset.connectionOption.connectionType:"unknown",partitioningFrom:$scope.newOutputDataset?$scope.newOutputDataset.partitioningOption:"unknown",recipeType:$scope.recipe?$scope.recipe.type:"unknown"})}).error($scope.setErrorInTopScope($scope))}$scope.getDatasetCreationSettings=function(){let datasetCreationSetting={connectionId:($scope.newOutputDataset.connectionOption||{}).id,specificSettings:{overrideSQLCatalog:$scope.newOutputDataset.overrideSQLCatalog,overrideSQLSchema:$scope.newOutputDataset.overrideSQLSchema,overrideIcebergNamespace:$scope.newOutputDataset.overrideIcebergNamespace,formatOptionId:$scope.newOutputDataset.formatOptionId},partitioningOptionId:$scope.newOutputDataset.partitioningOption,inlineDataset:$scope.inlineDataset,zone:$scope.zone};if($scope.newOutputDataset&&$scope.newOutputDataset.connectionOption&&$scope.newOutputDataset.connectionOption.fsProviderTypes&&$scope.newOutputDataset.connectionOption.fsProviderTypes.length>1){datasetCreationSetting["typeOptionId"]=$scope.newOutputDataset.typeOption}return datasetCreationSetting};$scope.getFolderCreationSettings=function(){return{partitioningOptionId:$scope.newOutputODB.partitioningOption,connectionId:$scope.newOutputODB.connectionOption,typeOptionId:$scope.newOutputODB.typeOption,zone:$scope.zone}};$scope.getEvaluationStoreCreationSettings=function(){return{mesFlavor:$scope.mesFlavor,partitioningOptionId:$scope.newOutputMES.partitioningOption,zone:$scope.zone}};$scope.getStreamingEndpointCreationSettings=function(){return{connectionId:$scope.newOutputSE.connectionOption,formatOptionId:$scope.newOutputSE.formatOptionId,typeOptionId:$scope.newOutputSE.typeOption,zone:$scope.zone}};$scope.$watch("newOutputODB.$connection",updateFolderConnection);$scope.$watch("newOutputSE.$connection",updateStreamingEndpointConnection);$scope.createAndUseNewOutputDataset=function(force){var projectKey=$stateParams.projectKey,datasetName=$scope.newOutputDataset.name,settings=$scope.getDatasetCreationSettings();if(force){doCreateAndUseNewOutputDataset(projectKey,datasetName,settings)}else{DataikuAPI.datasets.checkNameSafety(projectKey,datasetName,settings).success(function(data){$scope.uiState.backendWarnings=data.messages;if(!data.messages||!data.messages.length){doCreateAndUseNewOutputDataset(projectKey,datasetName,settings)}}).error($scope.setErrorInTopScope($scope))}};$scope.createAndUseManagedFolder=function(){Logger.info("Create and use managed folder",$scope);var settings=$scope.getFolderCreationSettings();DataikuAPI.datasets.newManagedFolder($stateParams.projectKey,$scope.newOutputODB.name,settings).success(function(odb){RecipeComputablesService.getComputablesMap($scope.recipe,$scope).then(function(map){$scope.setComputablesMap(map);$scope.acceptEdit($scope.computablesMap[odb.id]);$scope.newOutputODB.name="";$scope.forms.newOutputODBForm.$setPristine(true);$rootScope.$emit("datasetsListChangedFromModal")})}).error($scope.setErrorInTopScope($scope));$scope.recipeWT1Event("recipe-create-managed-folder",{})};$scope.createAndUseModelEvaluationStore=function(){Logger.info("Create and use model evaluation store",$scope);var settings=$scope.getEvaluationStoreCreationSettings();DataikuAPI.datasets.newModelEvaluationStore($stateParams.projectKey,$scope.newOutputMES.name,settings).success(function(mes){RecipeComputablesService.getComputablesMap($scope.recipe,$scope).then(function(map){$scope.setComputablesMap(map);$scope.acceptEdit($scope.computablesMap[mes.id]);$scope.newOutputMES.name="";$scope.forms.newOutputMESForm.$setPristine(true);$rootScope.$emit("datasetsListChangedFromModal")})}).error($scope.setErrorInTopScope($scope));$scope.recipeWT1Event("recipe-create-model-evaluation-store",{})};$scope.createAndUseStreamingEndpoint=function(){Logger.info("Create and use streaming endpoint",$scope);var settings=$scope.getStreamingEndpointCreationSettings();DataikuAPI.datasets.newStreamingEndpoint($stateParams.projectKey,$scope.newOutputSE.name,settings).success(function(se){RecipeComputablesService.getComputablesMap($scope.recipe,$scope).then(function(map){$scope.setComputablesMap(map);$scope.acceptEdit($scope.computablesMap[se.id]);$scope.newOutputSE.name="";$scope.forms.newOutputSEForm.$setPristine(true);$rootScope.$emit("datasetsListChangedFromModal")})}).error($scope.setErrorInTopScope($scope));$scope.recipeWT1Event("recipe-create-streaming-endpoint",{})};$scope.fetchNamespaces=function(origin,connectionType){SqlConnectionNamespaceService.listIcebergNamespaces($scope.newOutputDataset.connectionOption.connectionName,$scope,origin,connectionType)};$scope.fetchCatalogs=function(origin,connectionType){SqlConnectionNamespaceService.listSqlCatalogs($scope.newOutputDataset.connectionOption.connectionName,$scope,origin,connectionType)};$scope.fetchSchemas=function(origin,connectionType){const catalog=$scope.newOutputDataset.overrideSQLCatalog||($scope.newOutputDataset.connectionOption?$scope.newOutputDataset.connectionOption.unoverridenSQLCatalog:"");SqlConnectionNamespaceService.listSqlSchemas($scope.newOutputDataset.connectionOption.connectionName,$scope,catalog,origin,connectionType)}});app.directive("recipeIoOutputDisplayList",function(RecipesUtils,RecipeComputablesService,$stateParams){return{scope:true,replace:true,templateUrl:function(element,attrs){return"/templates/recipes/io/"+attrs.location+"-output-display-list.html"},link:function($scope,element,attrs){$scope.role=$scope.roles[parseInt(attrs.roleIndex)];$scope.hasAnyPartitioning=function(){return RecipesUtils.hasAnyPartitioning($scope.recipe,$scope.computablesMap)};$scope.canDeleteOutput=function(role,recipeType,recipeDesc){return role.editableInEditor&&(role.arity!="UNARY"||!role.required)}}}});app.directive("recipeIoOutputAddList",function($controller,Assert,RecipesUtils,RecipeComputablesService,Logger,DataikuAPI,$state,$stateParams,$q){return{scope:true,replace:true,templateUrl:function(element,attrs){return"/templates/recipes/io/"+attrs.location+"-output-add-list.html"},link:function($scope,elemnt,attrs){$controller("_RecipeOutputNewManagedBehavior",{$scope:$scope});$scope.role=$scope.roles[parseInt(attrs.roleIndex)];$scope.hasAnyPartitioning=function(){return RecipesUtils.hasAnyPartitioning($scope.recipe,$scope.computablesMap)};$scope.editOutput={adding:false,role:null};var beginEdition=function(){$scope.editOutput.adding=true;$scope.role.editing=true;$scope.editOutputs.push($scope.editOutput);var selectOption=function(role){if(role.acceptsDataset){return"create"}else if(role.acceptsManagedFolder){return"new-odb"}else if(RecipeComputablesService.acceptsEvaluationStore(role)){RecipeComputablesService.setMesFlavor($scope,role);return"new-mes"}else{return"select"}};if($scope.io.newOutputTypeRadio==null){$scope.io.newOutputTypeRadio=selectOption($scope.role)}else if($scope.io.newOutputTypeRadio=="create"&&!$scope.role.acceptsDataset){$scope.io.newOutputTypeRadio=selectOption($scope.role)}else if($scope.io.newOutputTypeRadio=="new-odb"&&!$scope.role.acceptsManagedFolder){$scope.io.newOutputTypeRadio=selectOption($scope.role)}else if($scope.io.newOutputTypeRadio=="new-mes"&&RecipeComputablesService.acceptsEvaluationStore($scope.role)){RecipeComputablesService.setMesFlavor($scope,$scope.role);$scope.io.newOutputTypeRadio=selectOption($scope.role)}};var endEdition=function(){$scope.editOutput.adding=false;$scope.role.editing=false;var idx=$scope.editOutputs.indexOf($scope.editOutput);if(idx>=0)$scope.editOutputs.splice(idx,1)};var setUsable=function(list){list.sort(function(a,b){if(a.usableAsOutput[$scope.role.name]&&a.usableAsOutput[$scope.role.name].usable&&!a.alreadyUsedAsOutputOf&&(!b.usableAsOutput[$scope.role.name]||!b.usableAsOutput[$scope.role.name].usable||b.alreadyUsedAsOutputOf))return-1;if((!a.usableAsOutput[$scope.role.name]||!a.usableAsOutput[$scope.role.name].usable||a.alreadyUsedAsOutputOf)&&b.usableAsOutput[$scope.role.name]&&b.usableAsOutput[$scope.role.name].usable&&!b.alreadyUsedAsOutputOf)return 1;return(a.label||"").localeCompare(b.label||"")});$scope.editOutput.usable=list};$scope.itemsWatchHooked=false;var hookItemsWatch=function(){$scope.itemsArray=$scope.recipe.outputs[$scope.role.name].items;$scope.$watchCollection("itemsArray",function(nv){if($scope.roleChanged){$scope.roleChanged($scope.role.name)}});$scope.itemsWatchHooked=true};if($scope.recipe.outputs[$scope.role.name]!=null){hookItemsWatch()}$scope.$watch("editOutput.filter",function(){setUsable(RecipeComputablesService.buildPossibleOutputList($scope.recipe,$scope.computablesMap,$scope.editOutput.role,$scope.editOutput.filter))});$scope.cleanInputs=function(){let cleaningNeeded=$scope.recipe&&($scope.recipe.type==="split"||$scope.recipe.type==="eda_pca")&&$scope.role.name&&$scope.recipe.inputs[$scope.role.name]&&$scope.recipe.inputs[$scope.role.name].items.length===1&&"ref"in $scope.recipe.inputs[$scope.role.name].items[0]&&$scope.recipe.inputs[$scope.role.name].items[0].ref==="";if(cleaningNeeded){$scope.recipe.inputs[$scope.role.name].items=[]}};$scope.enterAddOutput=function(role){$scope.cleanInputs();$scope.uiState.backendWarnings=null;beginEdition();$scope.editOutput.role=role;setUsable(RecipeComputablesService.buildPossibleOutputList($scope.recipe,$scope.computablesMap,role,$scope.editOutput.filter));$scope.newOutputDataset.connectionOption=null;$scope.getManagedDatasetOptions(role).then(function(data){$scope.setupManagedDatasetOptions(data)});$scope.getManagedFolderOptions(role).then(function(data){$scope.setupManagedFolderOptions(data)});$scope.getModelEvaluationStoreOptions(role).then(function(data){$scope.setupModelEvaluationStoreOptions(data)});$scope.getStreamingEndpointOptions(role).then(function(data){$scope.setupStreamingEndpointOptions(data)})};$scope.cancelAddOutput=function(){endEdition()};$scope.acceptEdit=function(computable){Assert.trueish($scope.editOutput.adding,"not adding inputs");var promise=$q.when(null);if(attrs.location=="modal"){if($scope.role.arity=="UNARY"){$scope.recipe.outputs[$scope.role.name]={items:[]}}RecipesUtils.addOutput($scope.recipe,$scope.role.name,computable.smartName)}else{var currentRecipeAndPayload={recipe:angular.copy($scope.recipe),payload:angular.copy($scope.script.data)};var newRecipeAndPayload={recipe:angular.copy($scope.recipe),payload:angular.copy($scope.script.data)};if($scope.role.arity=="UNARY"){newRecipeAndPayload.recipe.outputs[$scope.role.name]={items:[]}}RecipesUtils.addOutput(newRecipeAndPayload.recipe,$scope.role.name,computable.smartName);promise=DataikuAPI.flow.recipes.getIOChangeResult($stateParams.projectKey,currentRecipeAndPayload,newRecipeAndPayload).error($scope.setErrorInTopScope($scope)).then(function(resp){$scope.recipe.inputs=resp.data.updated.recipe.inputs;$scope.recipe.outputs=resp.data.updated.recipe.outputs;return})}promise.then(function(){endEdition();if(!$scope.itemsWatchHooked){hookItemsWatch()}})};$scope.showOnlyNewDataset=function(){return $scope.recipeAdditionalParams&&$scope.recipeAdditionalParams.originRecipes};if($scope.role.arity=="UNARY"&&attrs.location!="modal"){if($scope.isOutputRoleAvailableHook($scope.role)&&$scope.role.required&&(!$scope.recipe.outputs[$scope.role.name]||$scope.recipe.outputs[$scope.role.name].items.length==0)){beginEdition()}}}}})})();(function(){"use strict";var app=angular.module("dataiku.recipes");var PYTHON_SAMPLE_DEPENDENCY="def get_dependencies(target_partition_id):\n"+"    return [target_partition_id]";app.filter("retrievePartitioning",function(){return function(computable){if(!computable){return null}switch(computable.type){case"DATASET":return computable.dataset.partitioning;case"MANAGED_FOLDER":return computable.box.partitioning;case"SAVED_MODEL":return computable.model.partitioning}return null}});app.directive("partitionedByInfo",function(){return{templateUrl:"/templates/recipes/io/partitioned-by-info.html",scope:true,link:function($scope,element,attrs){$scope.lookupRef=$scope.$eval(attrs.ref)}}});app.directive("customPythonDependencyEditor",function(CreateModalFromTemplate,PartitionDeps,DataikuAPI,CodeMirrorSettingService){return{restrict:"E",template:'<button class="btn" ng-click="openDialog()" translate="GLOBAL.MENU.EDIT">Edit</button>',scope:{pdepIndex:"=",recipe:"=",input:"="},link:function(isolatedScope,element,attrs){isolatedScope.openDialog=function(){CreateModalFromTemplate("/templates/recipes/fragments/python-dep-editor.html",isolatedScope,null,function(scope){scope.localRecipe=angular.copy(isolatedScope.recipe);scope.localInput=angular.copy(isolatedScope.input);$.each(isolatedScope.recipe.inputs,function(roleName,inputRole){var inputIndex=inputRole.items.indexOf(isolatedScope.input);if(inputIndex>=0){scope.localRecipe.inputs[roleName].items[inputIndex]=scope.localInput}});scope.localPdep=scope.localInput.deps[isolatedScope.pdepIndex];if(!scope.localPdep.params){scope.localPdep.params={}}if(!scope.localPdep.params.code){scope.localPdep.params.code=PYTHON_SAMPLE_DEPENDENCY}scope.editorOptions=CodeMirrorSettingService.get("text/x-python");scope.saveAndClose=function(){isolatedScope.input.deps[isolatedScope.pdepIndex].params=angular.copy(scope.localPdep.params);scope.dismiss()};scope.test=function(){scope.testResult=undefined;DataikuAPI.flow.recipes.generic.pdepTest(scope.localRecipe,isolatedScope.input.ref,PartitionDeps.prepareForSerialize(scope.localPdep)).success(function(data){scope.testResults=data}).error(setErrorInScope.bind(scope))}})}}}});app.factory("PartitionDeps",function(Assert,DataikuAPI,Logger,RecipesUtils,$filter,translate){function neverNeedsOutput(pdep){return["values","all_available","latest_available"].indexOf(pdep.func)>=0}function mayWorkWithoutOutput(pdep){return["time_range"].indexOf(pdep.func)>=0}var svc={autocomplete:function(pdep,outputDimensions,outputDimensionsWithNow){Logger.info("Autocompleting pdep:"+JSON.stringify(pdep));if(pdep.func=="time_range"){if(!pdep.params)pdep.params={};if(!pdep.params.fromMode)pdep.params.fromMode="RELATIVE_OFFSET";if(!pdep.params.fromGranularity)pdep.params.fromGranularity="DAY";if(angular.isUndefined(pdep.params.fromOffset))pdep.params.fromOffset=0;if(!pdep.params.toGranularity)pdep.params.toGranularity=pdep.params.fromGranularity;if(angular.isUndefined(pdep.params.toOffset))pdep.params.toOffset=0;if(pdep.params.fromMode=="FIXED_DATE"&&!pdep.params.fromDate){pdep.params.fromDate="2024-01-01"}if(!pdep.$$output){if(outputDimensions.length){pdep.$$output=outputDimensions[0]}else{pdep.$$output=outputDimensionsWithNow[0]}}}else if(pdep.func=="custom_python"){if(!pdep.params)pdep.params={};if(!pdep.params.code)pdep.params.code=PYTHON_SAMPLE_DEPENDENCY}Logger.info("Autocompleted pdep:"+JSON.stringify(pdep))},fixup:function(recipe,computablesMap){Logger.info("fixup pdep, recipe is ",recipe);Assert.trueish(recipe,"no recipe");Assert.trueish(computablesMap,"no computablesMap");RecipesUtils.getFlatInputsList(recipe).forEach(function(input){Assert.trueish(computablesMap[input.ref],"input not in computablesMap")});RecipesUtils.getFlatOutputsList(recipe).forEach(function(output){Assert.trueish(computablesMap[output.ref],"output not in computablesMap")});RecipesUtils.getFlatInputsList(recipe).forEach(function(input){Logger.info("Cleaning up input deps",input.deps);input.deps=input.deps.filter(function(dep){var isTemp=dep.out==null&&dep.func=="values"&&!dep.values;return!isTemp});Logger.info("cleaned:",input.deps)});var outputDimensions=[];RecipesUtils.getFlatOutputsList(recipe).forEach(function(output){const computable=computablesMap[output.ref];const partitioning=$filter("retrievePartitioning")(computable);if(partitioning==null){return}partitioning.dimensions.forEach(function(dim){outputDimensions.push({out:output.ref,odim:dim.name,label:dim.name+translate("RECIPE.IO_SELECT.PARTITIONING.OF"," of ")+output.ref})})});Logger.info("Valid possible outputs",outputDimensions);var outputDimensionsWithNow=outputDimensions.slice();var currentTimeDep={label:translate("RECIPE.IO_SELECT.PARTITIONING.CURRENT_TIME","Current time")};outputDimensionsWithNow.push(currentTimeDep);RecipesUtils.getFlatInputsList(recipe).forEach(function(input){input.deps.forEach(function(pdep){if(neverNeedsOutput(pdep)){Logger.info("Pdep does not need an output",pdep);return}if(pdep.$$output!=null){var matchingOd;if(pdep.$$output.label==currentTimeDep.label){matchingOd=[currentTimeDep]}else{matchingOd=outputDimensions.filter(function(nod){return nod.out==pdep.$$output.out&&nod.odim==pdep.$$output.odim})}if(matchingOd.length==1){pdep.$$output=matchingOd[0]}else{pdep.$$output=null}}if(pdep.$$output==null){for(var i in outputDimensions){var od=outputDimensions[i];Logger.info("Compare ",od,pdep);if(od.out==pdep.out&&od.odim==pdep.odim){pdep.$$output=od;Logger.info("YES, matches");break}}}if(!pdep.$$output){if(mayWorkWithoutOutput(pdep)){Logger.info("Failed to find a matching output dimension for pdep ",pdep);pdep.$$output=currentTimeDep}else{Logger.error("Failed to find a matching output dimension for pdep ",pdep)}}})});RecipesUtils.getFlatInputsList(recipe).forEach(function(input){const computable=computablesMap[input.ref];const partitioning=$filter("retrievePartitioning")(computable);if(partitioning){for(var dimIdx in partitioning.dimensions){var dim=partitioning.dimensions[dimIdx];Logger.info("Searching for pdep setting ",dim.name,"in",angular.copy(input.deps));if($.grep(input.deps,dep=>dep.idim==dim.name).length===0){Logger.info("Will add new pdep ...");var recipeFirstOut=RecipesUtils.getFlatOutputsList(recipe)[0];var newPdep={out:recipeFirstOut?recipeFirstOut.ref:null,func:"equals",idim:dim.name};if(newPdep.out&&partitioning.dimensions.length){var outputDimensions=partitioning.dimensions;newPdep.odim=outputDimensions[0].name;outputDimensions.forEach(function(dim){if(dim.name==newPdep.idim){newPdep.odim=dim.name;return}});for(var i in outputDimensions){var od=outputDimensions[i];if(od.out==newPdep.out&&od.odim==newPdep.odim){newPdep.$$output=od;break}}}else{newPdep.func="values"}Logger.info("Creating missing pdep for ",input,dim.name,angular.copy(newPdep));input.deps.push(newPdep)}}}});RecipesUtils.getFlatInputsList(recipe).forEach(function(input){input.deps.forEach(function(pdep){if(neverNeedsOutput(pdep)){Logger.info("Pdep does not need an output",pdep);return}if(pdep.$$output==null){Logger.info("Pdep has no valid output",pdep);if(mayWorkWithoutOutput(pdep)){Logger.info("but it might work without ....");return}const recipeFirstOut=RecipesUtils.getFlatOutputsList(recipe)[0];const partitioning=$filter("retrievePartitioning")(computablesMap[recipeFirstOut.ref]);if(recipeFirstOut&&partitioning.dimensions.length){pdep.out=recipeFirstOut.ref;pdep.odim=partitioning.dimensions[0].name;Logger.info("Assign as output",pdep);for(var i in outputDimensions){var od=outputDimensions[i];if(od.out==pdep.out&&od.odim==pdep.odim){pdep.$$output=od;break}}}else{pdep.func="values"}}})});Logger.info("After fixup, inputs",recipe.inputs,outputDimensions,outputDimensionsWithNow);return[outputDimensions,outputDimensionsWithNow]},prepareForSerialize:function(pdep,notEdited){var ret=angular.copy(pdep);if(ret.$$output){if(ret.$$output.odim){ret.odim=ret.$$output.odim}else{delete ret.odim}if(ret.$$output.out){ret.out=ret.$$output.out}else{delete ret.out}}else if(neverNeedsOutput(ret)||mayWorkWithoutOutput(ret)){}else{if(!notEdited){Logger.warn("Saving incomplete pdep",ret)}}if(ret.func!="values")delete ret.values;if(ret.func=="values"||ret.func=="latest_available"||ret.func=="all_available"){delete ret.odim}if(ret.params){angular.forEach(ret.params,function(value,key){ret.params[key]=value==null?null:value.toString()})}return ret},prepareRecipeForSerialize:function(recipe,notEdited){RecipesUtils.getFlatInputsList(recipe).forEach(function(input){if(input.deps!=null){input.deps=input.deps.map(function(p){return svc.prepareForSerialize(p,notEdited)})}});return recipe},test:function(recipe,pdepInputRef,pdep,errorScope){var recipeSerialized=angular.copy(recipe);svc.prepareRecipeForSerialize(recipeSerialized);DataikuAPI.flow.recipes.generic.pdepTest(recipeSerialized,pdepInputRef,svc.prepareForSerialize(pdep)).success(function(data){pdep.$$testResult=data}).error(setErrorInScope.bind(errorScope))},timeRangeFromModes:[["RELATIVE_OFFSET",translate("RECIPE.IO_SELECT.PARTITIONING.OFFSET","Offset to reference time")],["FIXED_DATE",translate("RECIPE.IO_SELECT.PARTITIONING.FIXED_DATE","Fixed date")]],timeRangeGranularities:[["YEAR",translate("RECIPE.IO_SELECT.PARTITIONING.YEAR","Year(s)"),4],["MONTH",translate("RECIPE.IO_SELECT.PARTITIONING.MONTH","Month(s)"),3],["DAY",translate("RECIPE.IO_SELECT.PARTITIONING.DAY","Day(s)"),2],["HOUR",translate("RECIPE.IO_SELECT.PARTITIONING.HOUR","Hour(s)"),1]],getGranularities:function(input,partition,computables){const dim=computables[input].dataset.partitioning.dimensions.find(element=>element.name===partition.idim);const weight=this.timeRangeGranularities.find(element=>element[0]===dim.params.period)[2];const currentFromWeight=this.timeRangeGranularities.find(element=>element[0]===partition.params.fromGranularity)[2];const currentToWeight=this.timeRangeGranularities.find(element=>element[0]===partition.params.toGranularity)[2];if(currentFromWeight<weight){partition.params.fromGranularity=dim.params.period}if(currentToWeight<weight){partition.params.toGranularity=dim.params.period}return this.timeRangeGranularities.filter(element=>element[2]>=weight)},depFunctions:[["equals",translate("RECIPE.IO_SELECT.PARTITIONING.EQUALS","Equals")],["time_range",translate("RECIPE.IO_SELECT.PARTITIONING.TIME_RANGE","Time Range")],["current_week",translate("RECIPE.IO_SELECT.PARTITIONING.CURRENT_WEEK","Since beginning of week")],["current_month",translate("RECIPE.IO_SELECT.PARTITIONING.CURRENT_MONTH","Since beginning of month")],["whole_month",translate("RECIPE.IO_SELECT.PARTITIONING.WHOLE_MONTH","Whole month")],["values",translate("RECIPE.IO_SELECT.PARTITIONING.VALUES","Explicit values")],["latest_available",translate("RECIPE.IO_SELECT.PARTITIONING.LATEST_AVAILABLE","Latest available")],["all_available",translate("RECIPE.IO_SELECT.PARTITIONING.ALL_AVAILABLE","All available")],["custom_python",translate("RECIPE.IO_SELECT.PARTITIONING.CUSTOM_PYTHON","Python dependency function")],["sliding_days",translate("RECIPE.IO_SELECT.PARTITIONING.SLIDING_DAYS","Sliding days (deprecated, use Time Range)")]]};return svc})})();(function(){"use strict";var app=angular.module("dataiku.recipes");app.controller("VisualRecipeEditorController",function($scope,$stateParams,$q,$controller,DataikuAPI,PartitionDeps,CreateModalFromTemplate,ComputableSchemaRecipeSave,Dialogs,DKUtils,DatasetUtils,Logger,translate){$controller("_RecipeWithEngineBehavior",{$scope:$scope});var visualCtrl=this;$scope.hooks.preRunValidate=function(){var deferred=$q.defer();$scope.hooks.updateRecipeStatus().then(function(data){if(data&&data.invalid){Logger.info("preRunValidate failed",data);Dialogs.confirm($scope,"Recipe contains errors","The recipe contains errors. Are you sure you want to run it?").then(function(){deferred.resolve({ok:true})},function(){deferred.reject("Validation failed")})}else{deferred.resolve({ok:true})}},function(data){Logger.error("Error when getting status",data);setErrorInScope.bind($scope);deferred.reject("Validation failed")});return deferred.promise};var paramsSavedOnServer=undefined;visualCtrl.saveServerParams=function(){paramsSavedOnServer=angular.copy($scope.hooks.getPayloadData())};var superRecipeIsDirty=$scope.hooks.recipeIsDirty;$scope.hooks.recipeIsDirty=function(){var currentPayload=$scope.hooks.getPayloadData();if(currentPayload){currentPayload=angular.fromJson(currentPayload)}var savedPayload=paramsSavedOnServer;if(savedPayload){savedPayload=angular.fromJson(savedPayload)}return superRecipeIsDirty()||!angular.equals(currentPayload,savedPayload)};$scope.hooks.save=function(){var deferred=$q.defer();var recipeSerialized=angular.copy($scope.recipe);PartitionDeps.prepareRecipeForSerialize(recipeSerialized);var payloadData=$scope.hooks.getPayloadData();ComputableSchemaRecipeSave.handleSave($scope,recipeSerialized,payloadData,deferred);return deferred.promise.then(visualCtrl.saveServerParams)};$scope.showChangeInputModal=function(virtualInputIndex){var newScope=$scope.$new();newScope.virtualInputIndex=virtualInputIndex;CreateModalFromTemplate("/templates/recipes/visual-recipes-fragments/visual-recipe-change-input-modal.html",newScope)};$scope.convert=function(type,label){Dialogs.confirm($scope,translate("RECIPES.SQL_CONVERSION.CONVERT_TO","CONVERT To "+label+" recipe",{type:label}),translate("RECIPES.SQL_CONVERSION.CONVERTING_THE_RECIPE_TO","Converting the recipe to "+label+" will enable you to edit the query, but you will not be able to use the visual editor anymore.",{type:label})+"<br/><strong>"+translate("RECIPES.SQL_CONVERSION.THIS_OPERATION_IS_IRREVERSIBLE","This operation is irreversible.")+"</strong>").then(function(){var payloadData=$scope.hooks.getPayloadData();var recipeSerialized=angular.copy($scope.recipe);PartitionDeps.prepareRecipeForSerialize(recipeSerialized);$scope.hooks.save().then(function(){DataikuAPI.flow.recipes.visual.convert($stateParams.projectKey,recipeSerialized,payloadData,type).success(function(data){DKUtils.reloadState()}).error(setErrorInScope.bind($scope))})})};$scope.showSQLModal=function(){var newScope=$scope.$new();newScope.convert=$scope.convert;newScope.uiState={currentTab:"query"};$scope.hooks.updateRecipeStatus(false,true).then(function(){newScope.query=$scope.recipeStatus.sql;newScope.engine=$scope.recipeStatus.selectedEngine.type;newScope.executionPlan=$scope.recipeStatus.executionPlan;newScope.cannotConvert=$scope.hasMultipleOutputs();CreateModalFromTemplate("/templates/recipes/fragments/sql-modal.html",newScope)})};$scope.hasMultipleOutputs=function(){return $scope.recipeStatus.sqlWithExecutionPlanList&&$scope.recipeStatus.sqlWithExecutionPlanList.length>1};$scope.selectOutputForSql=outputName=>{let sqlWithExecutionPlan=$scope.recipeStatus.sqlWithExecutionPlanList.find(s=>s.outputName===outputName);if(sqlWithExecutionPlan===undefined){sqlWithExecutionPlan=$scope.recipeStatus.sqlWithExecutionPlanList[0]}$scope.selectedOutputName=sqlWithExecutionPlan.outputName;$scope.recipeStatus.sql=sqlWithExecutionPlan.sql;$scope.recipeStatus.executionPlan=sqlWithExecutionPlan.executionPlan};$scope.hasSchemaToDisplay=()=>{if(!$scope.recipeStatus)return false;const schema=$scope.selectedOutputSchema();return schema&&schema.columns.length>0};$scope.selectedOutputSchema=()=>{if(!$scope.recipeStatus)return;if($scope.hasMultipleOutputs()){const sqlWithExecutionPlan=$scope.recipeStatus.sqlWithExecutionPlanList.find(s=>s.outputName===$scope.selectedOutputName);if(sqlWithExecutionPlan&&sqlWithExecutionPlan.schema){return sqlWithExecutionPlan.schema}}return $scope.recipeStatus.outputSchema};$scope.getSingleInputName=function(){if($scope.recipe&&$scope.recipe.inputs&&$scope.recipe.inputs.main&&$scope.recipe.inputs.main.items.length){return $scope.recipe.inputs.main.items[0].ref}};$scope.getColumns=function(datasetName){var schema=DatasetUtils.getSchema($scope,datasetName||$scope.getSingleInputName());return schema?schema.columns:[]};$scope.getColumnNames=function(datasetName){return $scope.getColumns(datasetName).map(function(col){return col.name})};$scope.getColumn=function(datasetName,name){return $scope.getColumns(datasetName).filter(function(col){return col.name==name})[0]};$scope.datasetHasColumn=function(datasetName,columnName){return!!$scope.getColumn(datasetName,columnName)};$scope.columnTypes=[{name:"TINYINT",label:"tinyint (8 bit)"},{name:"SMALLINT",label:"smallint (16 bit)"},{name:"INT",label:"int"},{name:"BIGINT",label:"bigint (64 bit)"},{name:"FLOAT",label:"float"},{name:"DOUBLE",label:"double"},{name:"BOOLEAN",label:"boolean"},{name:"STRING",label:"string"},{name:"DATE",label:"datetime with tz"},{name:"DATEONLY",label:"date only"},{name:"DATETIMENOTZ",label:"Datetime no tz"},{name:"ARRAY",label:"array<...>"},{name:"MAP",label:"map<...>"},{name:"OBJECT",label:"object<...>"}]});app.controller("ChangeRecipeVirtualInputController",function($scope,DataikuAPI,$stateParams,DatasetUtils,RecipesUtils,translate){if($scope.recipe.type==="generate_features"){if($scope.virtualInputIndex===0){$scope.title="Replace primary dataset"}else{$scope.title="Replace enrichment dataset"}}else{$scope.title=translate("VISUAL_RECIPE.CHANGE_INPUT_MODAL.REPLACE_RECIPE_INPUT","Replace recipe input")}DatasetUtils.listDatasetsUsabilityInAndOut($stateParams.projectKey,$scope.recipe.type).then(function(data){$scope.availableInputDatasets=$scope.getAvailableReplacementDatasets(data[0])});$scope.replacement={};$scope.$watch("replacement.name",function(nv){if(nv){let payload=$scope.hooks.getPayloadData();let newInputName=nv;delete $scope.replacementImapact;resetErrorInScope($scope);DataikuAPI.flow.recipes.visual.testInputReplacement($stateParams.projectKey,$scope.recipe,payload,$scope.virtualInputIndex,newInputName).then(response=>$scope.replacementImapact=response.data).catch(setErrorInScope.bind($scope))}});$scope.ok=function(dismiss){if(RecipesUtils.getInput($scope.recipe,"main",$scope.replacement.name)==null){RecipesUtils.addInput($scope.recipe,"main",$scope.replacement.name)}$scope.onInputReplaced($scope.replacement,$scope.virtualInputIndex);dismiss();$scope.hooks.updateRecipeStatus()}});app.directive("fieldsForFilterDesc",function(){return{restrict:"A",scope:false,link:function($scope,element,attrs){$scope.distinctOptionDisabled=true;var updateFields=function(){if($scope.params==null||$scope.recipe==null||$scope.computablesMap==null){return}$scope.filterDesc=$scope.params.preFilter;$scope.dataset=$scope.recipe.inputs["main"].items[0].ref;$scope.schema=$scope.computablesMap[$scope.recipe.inputs["main"].items[0].ref].dataset.schema};$scope.$watch("params",updateFields);$scope.$watch("recipe",updateFields,true);$scope.$watch("computablesMap",updateFields)}}});app.directive("baseTypeSelector",function($timeout,ListFilter){return{restrict:"A",scope:{schemaColumn:"="},templateUrl:"/templates/recipes/visual-recipes-fragments/base-type-selector.html",link:function($scope,element,attrs){$scope.columnTypes=[{name:"tinyint",label:"tinyint (8 bit)"},{name:"smallint",label:"smallint (16 bit)"},{name:"int",label:"int"},{name:"bigint",label:"bigint (64 bit)"},{name:"float",label:"float"},{name:"double",label:"double"},{name:"boolean",label:"boolean"},{name:"string",label:"string"},{name:"date",label:"datetime with tz"},{name:"dateonly",label:"date only"},{name:"datetimenotz",label:"datetime no tz"},{name:"array",label:"array<...>"},{name:"map",label:"map<...>"},{name:"object",label:"object<...>"}];$scope.select=function(columnType){$scope.schemaColumn.type=columnType.name}}}});app.directive("aggregateTypeEditor",function(){return{restrict:"A",scope:{schemaColumn:"="},replace:true,templateUrl:"/templates/recipes/visual-recipes-fragments/aggregate-type-editor.html",link:function($scope,element,attrs){$scope.addObjectField=function(){$scope.schemaColumn.objectFields=$scope.schemaColumn.objectFields||[];$scope.schemaColumn.objectFields.push({name:"",type:"string"})};var ensureSubFields=function(){if($scope.schemaColumn.type=="array"){$scope.schemaColumn.arrayContent=$scope.schemaColumn.arrayContent||{name:"",type:"string"}}if($scope.schemaColumn.type=="map"){$scope.schemaColumn.mapKeys=$scope.schemaColumn.mapKeys||{name:"",type:"string"};$scope.schemaColumn.mapValues=$scope.schemaColumn.mapValues||{name:"",type:"string"}}if($scope.schemaColumn.type=="object"){$scope.schemaColumn.objectFields=$scope.schemaColumn.objectFields||[]}};$scope.$watch("schemaColumn.type",ensureSubFields)}}})})();(function(){"use strict";var app=angular.module("dataiku.recipes");app.controller("GroupingRecipeCreationController",function($scope,Fn,$stateParams,DataikuAPI,$controller){$scope.recipeType="grouping";$controller("SingleOutputDatasetRecipeCreationController",{$scope:$scope});$scope.autosetName=function(){if($scope.io.inputDataset&&$scope.io.targetVariable){var niceInputName=$scope.io.inputDataset.replace(/[A-Z]*\./,"");var niceTargetVariable=$scope.io.targetVariable.replace(/[^\w ]+/g,"").replace(/ +/g,"_");$scope.maybeSetNewDatasetName(niceInputName+"_by_"+niceTargetVariable)}};$scope.getCreationSettings=function(){return{groupKey:$scope.io.targetVariable}};var superFormIsValid=$scope.formIsValid;$scope.formIsValid=function(){return!!(superFormIsValid()&&$scope.io.targetVariable!==undefined)};$scope.showOutputPane=function(){return!!($scope.io.inputDataset&&$scope.io.targetVariable!==undefined)};$scope.$watch("io.targetVariable",Fn.doIfNv($scope.autosetName))});app.controller("GroupingRecipeController",function($scope,$stateParams,DataikuAPI,$q,Dialogs,ContextualMenu,PartitionDeps,$rootScope,$timeout,DKUtils,Expressions,Logger,$controller,RecipesUtils,Fn,DatasetUtils){var visualCtrl=$controller("VisualRecipeEditorController",{$scope:$scope});this.visualCtrl=visualCtrl;$scope.aggregateUsabilityFlag="usableInGroup";let contextProjectKey=$scope.context&&$scope.context.projectKey?$scope.context.projectKey:$stateParams.projectKey;$scope.hooks.getPayloadData=function(){return angular.toJson($scope.params)};$scope.hooks.updateRecipeStatus=function(forceUpdate,exactPlan){var payload=$scope.hooks.getPayloadData();if(!payload)return $q.reject("payload not ready");var deferred=$q.defer();$scope.updateRecipeStatusBase(forceUpdate,payload,{reallyNeedsExecutionPlan:exactPlan,exactPlan:exactPlan}).then(function(){if(!$scope.recipeStatus)return deferred.reject();var outputSchema=$scope.recipeStatus.outputSchema;var outputSchemaBO=$scope.recipeStatus.outputSchemaBeforeOverride;if(outputSchema){$scope.params.postFilter.$status=$scope.params.postFilter.$status||{};$scope.params.postFilter.$status.schema=outputSchemaBO;$scope.params.outputColumnNameOverrides=$scope.params.outputColumnNameOverrides||{};var columnsAO=outputSchema.columns;var columnsBO=outputSchemaBO&&outputSchemaBO.columns?outputSchemaBO.columns:outputSchema.columns;for(var i in columnsAO){if(columnsAO[i].name!=columnsBO[i].name){$scope.params.outputColumnNameOverrides[columnsBO[i].name]=columnsAO[i].name}columnsAO[i].$beforeOverride=columnsBO[i].name;columnsAO[i].name=$scope.params.outputColumnNameOverrides[columnsBO[i].name]||columnsBO[i].name}resyncWithEngine()}deferred.resolve($scope.recipeStatus)});return deferred.promise};$scope.updateColumnNameOverride=function(column){if(column.$beforeOverride!=column.name){$scope.params.outputColumnNameOverrides[column.$beforeOverride]=column.name}else{delete $scope.params.outputColumnNameOverrides[column.$beforeOverride]}};function validateFilters(){if(!$scope.params)return;var inputRef=RecipesUtils.getSingleInput($scope.recipe,"main").ref;var inputSchema=$scope.computablesMap[inputRef].dataset.schema;validateFilter($scope.params.preFilter,inputSchema);validateFilter($scope.params.postFilter)}function validateFilter(filterDesc,schema){var deferred=$q.defer();if(!filterDesc||!filterDesc.enabled)return;if(angular.isUndefined(filterDesc.expression))return;Expressions.validateExpression(filterDesc.expression,schema).success(function(data){if(data.ok&&$scope.mustRunInDatabase&&!data.fullyTranslated){data.ok=false}filterDesc.$status=data;filterDesc.$status.validated=true;deferred.resolve(data)}).error(function(data){setErrorInScope.bind($scope);deferred.reject("Error while validating filter")});return deferred.promise}$scope.onFilterUpdate=$scope.updateRecipeStatusLater;function computedColumnListUpdated(computedColumns){$scope.params.computedColumns=angular.copy(computedColumns);resyncWithInputSchema();$scope.updateRecipeStatusLater()}$scope.onComputedColumnListUpdate=computedColumnListUpdated;$scope.getColumnsWithComputed=function(){if(!$scope.uiState.columnsWithComputed){var columns=[].concat($scope.getColumns());for(var i=0;i<(($scope.params||{}).computedColumns||[]).length;i++){var computedCol=$scope.params.computedColumns[i];if(computedCol.name&&columns.map(function(col){return col.name}).indexOf(computedCol.name)==-1){columns.push({name:computedCol.name,type:computedCol.type})}}$scope.uiState.columnsWithComputed=columns}return $scope.uiState.columnsWithComputed};$scope.removeGroupKey=function(removedGroupKey){if(removedGroupKey.column){const presentColumns=$scope.params.values.map(Fn.prop("column"));presentColumns.push(removedGroupKey.column);const insertIndex=$scope.listColumnsForCumstomColumnsEditor().filter(Fn.inArray(presentColumns)).indexOf(removedGroupKey.column);$scope.params.values.splice(Math.max(insertIndex,0),0,removedGroupKey)}$scope.hooks.updateRecipeStatus()};$scope.addGroupKey=function(col){if(!col){return}const idx=$scope.params.values.map(Fn.prop("column")).indexOf(col.column);if(idx===-1){return}const key=angular.copy(col);key.$selected=false;$scope.params.keys.push(key);$scope.params.values.splice(idx,1);$scope.hooks.updateRecipeStatus();resyncWithInputSchema()};$scope.groupKeyFilter={};$scope.addCustomValue=function(){var newVal={customName:userFriendlyTransmogrify("custom_aggr",$scope.params.values.filter(function(v){return v.column==null}),"customName","_",true),customExpr:""};$scope.params.values.push(newVal);$timeout(function(){var el=angular.element("[computed-column-editor]").last();$timeout(function(){$(".name-editor",el).trigger("focus")});$scope.$apply()})};$scope.$watchCollection("params.values",function(nv){$scope.realValues=getRealValues()});var getRealValues=function(){var realValues=!$scope.params||!$scope.params.values?[]:$scope.params.values.filter(function(val){return!!val.column});var realValuesNames=realValues.map(function(rv){return rv.column});var newRealValues=[];var i;var oldRVIdx;var columns=$scope.getColumns();for(i=0;i<columns.length;i++){var col=columns[i];if(col.name&&col.name.length>0){oldRVIdx=realValuesNames.indexOf(col.name);if(oldRVIdx>=0){newRealValues.push(realValues[oldRVIdx])}}}var newRealValuesNames=newRealValues.map(function(rv){return rv.column});var computedColumns=($scope.params||{}).computedColumns||[];for(i=0;i<computedColumns.length;i++){var compCol=computedColumns[i];if(compCol.name&&compCol.name.length>0&&newRealValuesNames.indexOf(compCol.name)==-1){oldRVIdx=realValuesNames.indexOf(compCol.name);if(oldRVIdx>=0){newRealValues.push(realValues[oldRVIdx])}}}return newRealValues};$scope.getCustomValues=function(){if(!$scope.params||!$scope.params.values){return[]}return $scope.params.values.filter(function(val){return!val.column})};$scope.listColumnsForCumstomColumnsEditor=function(){return $scope.getColumns().map(function(col){return col.name})};$scope.aggregationTypes=[{name:"countDistinct",opType:"DISTINCT",label:$scope.translate("GROUP_RECIPE.GROUP.DISTINCT","Distinct"),tooltip:$scope.translate("GROUP_RECIPE.GROUP.COUNT_DISTINCT","Count distinct values")},{name:"min",label:$scope.translate("GROUP_RECIPE.GROUP.MIN","Min")},{name:"max",label:$scope.translate("GROUP_RECIPE.GROUP.MAX","Max")},{name:"avg",label:$scope.translate("GROUP_RECIPE.GROUP.AVG","Avg")},{name:"median",label:$scope.translate("GROUP_RECIPE.GROUP.MEDIAN","Median")},{name:"sum",label:$scope.translate("GROUP_RECIPE.GROUP.SUM","Sum")},{name:"stddev",label:$scope.translate("GROUP_RECIPE.GROUP.STD_DEV","Std. dev.")},{name:"count",label:$scope.translate("GROUP_RECIPE.GROUP.COUNT","Count"),tooltip:$scope.translate("GROUP_RECIPE.GROUP.COUNT_NON_NULL","Count non-null"),separatorAfter:true},{name:"first",label:$scope.translate("GROUP_RECIPE.GROUP.FIRST","First")},{name:"last",label:$scope.translate("GROUP_RECIPE.GROUP.LAST","Last")},{name:"concat",label:$scope.translate("GROUP_RECIPE.GROUP.CONCAT","Concat"),tooltip:$scope.translate("GROUP_RECIPE.GROUP.CONCAT_VALUES","Concatenate values in one string")}];$scope.columnHasSomeComputation=function(col){var ret=false;$scope.aggregationTypes.forEach(function(agg){ret=ret||col[agg.name]});return ret};$scope.colCanAggr=function(col,agg){if(!$scope.engineCanAggr(agg))return false;var opType=agg.opType||agg.name.toUpperCase();var aggregability=$scope.recipeStatus.selectedEngine.aggregabilities[opType];var typeCategory={string:"strings",date:"dates",dateonly:"dates",datetimenotz:"dates",boolean:"booleans",tinyint:"numerics",smallint:"numerics",int:"numerics",bigint:"numerics",float:"numerics",double:"numerics"}[col.type];return aggregability&&typeCategory&&aggregability[typeCategory]};$scope.engineCanAggrType=function(opType){if(!$scope.recipeStatus||!$scope.recipeStatus.selectedEngine)return false;var aggregability=$scope.recipeStatus.selectedEngine.aggregabilities[opType];return aggregability&&aggregability[$scope.aggregateUsabilityFlag]};$scope.engineCanAggr=function(agg){if(!$scope.recipeStatus||!$scope.recipeStatus.selectedEngine)return false;var opType=agg.opType||agg.name.toUpperCase();var aggregability=$scope.recipeStatus.selectedEngine.aggregabilities[opType];return aggregability&&aggregability[$scope.aggregateUsabilityFlag]};$scope.onAggregationChange=function(column,agg){if(column[agg.name]){if(["first","last"].includes(agg.name)){var cols=$scope.getColumns();column.orderColumn=column.orderColumn||(cols&&cols.length?cols[0].name:undefined)}else if("concat"===agg.name){column.concatSeparator=column.concatSeparator!=null?column.concatSeparator:",";column.concatDistinct=column.concatDistinct||false}}};$scope.aggregation={all:{},some:{},none:{},disabled:{}};function filterUnused(vals){return vals.filter(function(val){return!$scope.uiState.hideUseless||$scope.columnHasSomeComputation(val)})}$scope.shouldDisplayOptions=function(column){return column!==undefined&&(column.first||column.last||column.concat)};$scope.selection={customFilter:filterUnused,customFilterWatch:"uiState.hideUseless"};$scope.recomputeAggregationStates=function(cols){for(var k in $scope.aggregation){$scope.aggregation[k]={}}cols.forEach(function(column){$scope.aggregationTypes.forEach(function(agg){var colEnabled=$scope.colCanAggr(column,agg);$scope.aggregation.all[agg.name]=($scope.aggregation.all[agg.name]==undefined?true:$scope.aggregation.all[agg.name])&&(colEnabled?column[agg.name]:false);$scope.aggregation.some[agg.name]=$scope.aggregation.some[agg.name]||false||(colEnabled?column[agg.name]:false);$scope.aggregation.disabled[agg.name]=$scope.aggregation.disabled[agg.name]||false||colEnabled})});angular.forEach($scope.aggregationTypes,function(agg){$scope.aggregation.disabled[agg.name]=!$scope.aggregation.disabled[agg.name];$scope.aggregation.some[agg.name]=$scope.aggregation.some[agg.name]&&!$scope.aggregation.all[agg.name];$scope.aggregation.none[agg.name]=!$scope.aggregation.some[agg.name]&&!$scope.aggregation.all[agg.name]})};$scope.massAction=function(agg,selectedObjects){selectedObjects.forEach(function(val){if($scope.colCanAggr(val,agg)){val[agg.name]=$scope.aggregation.all[agg.name];$scope.onAggregationChange(val,agg)}});$scope.aggregation.some[agg.name]=false;$scope.aggregation.none[agg.name]=!$scope.aggregation.all[agg.name];$scope.hooks.updateRecipeStatus()};$scope.massUseAsKeys=function(){$scope.selection.selectedObjects.forEach(function(val){var key=angular.copy(val);key.$selected=false;$scope.params.keys.push(key)});$scope.params.values=$scope.selection.allObjects.filter(function(val){return!val.$selected});$scope.hooks.updateRecipeStatus();resyncWithInputSchema()};function loadParamsFromScript(scriptData){if(!scriptData)return;$scope.params=JSON.parse(scriptData);$scope.params.preFilter=$scope.params.preFilter||{};$scope.params.computedColumns=$scope.params.computedColumns||[];$scope.params.postFilter=$scope.params.postFilter||{};$scope.params.outputColumnNameOverrides=$scope.params.outputColumnNameOverrides||{};$scope.uiState.computedColumns=angular.copy($scope.params.computedColumns);visualCtrl.saveServerParams();resyncWithInputSchema();resyncWithEngine();var colsByName={};$scope.getColumns().forEach(function(col){colsByName[col.name]=col});$scope.params.values.forEach(function(gv){if(colsByName[gv.column]){gv.type=colsByName[gv.column].type}});$scope.params.keys.forEach(function(gv){if(colsByName[gv.column]){gv.type=colsByName[gv.column].type}})}function resyncWithInputSchema(){$scope.uiState.columnsWithComputed=undefined;var inputColumnsWithComputed=$scope.getColumnsWithComputed();var inputColumnsWithComputedNames=inputColumnsWithComputed.map(function(col){return col.name});var keys={};(($scope.params||{}).keys||[]).forEach(function(col,i){col.$$originalIndex=i;if(col.column&&inputColumnsWithComputedNames.indexOf(col.column)>=0){keys[col.column]=col}});var values={},customValues=[];(($scope.params||{}).values||[]).forEach(function(col){if(col.column){if(inputColumnsWithComputedNames.indexOf(col.column)>=0){values[col.column]=col}}else{customValues.push(col)}});var newKeys=[];var newValues=[];inputColumnsWithComputed.forEach(function(col){var newCol;if(keys[col.name]){newCol=keys[col.name]}else if(values[col.name]){newCol=values[col.name]}else{newCol={column:col.name,type:col.type}}angular.extend(newCol,{column:col.name,type:col.type});$scope.aggregationTypes.forEach(function(agg){newCol[agg.name]=newCol[agg.name]||false});if(keys[col.name]){newKeys.push(newCol)}else{newValues.push(newCol)}});customValues.forEach(function(val){newValues.push(val)});newKeys.sort((a,b)=>a.$$originalIndex-b.$$originalIndex);$scope.params=$scope.params||{};$scope.params.keys=newKeys;$scope.params.values=newValues;if($scope.onResyncWithInputSchema){$scope.onResyncWithInputSchema()}}function resyncWithEngine(){if(!$scope.recipeStatus||!$scope.recipeStatus.selectedEngine)return;$scope.params.values.forEach(function(val){$scope.aggregationTypes.forEach(function(agg){if(val[agg.name]&&!$scope.colCanAggr(val,agg)){val[agg.name]=false}})});if($scope.engineCanAggrType("CONCAT_DISTINCT")!=true){$scope.params.values.forEach(function(val){val.concatDistinct=false})}if($scope.engineCanAggrType("FIRST_NOTNULL")!=true){$scope.params.values.forEach(function(val){val.firstLastNotNull=false})}}function onScriptChanged(nv,ov){if(nv){loadParamsFromScript($scope.script.data);DKUtils.reflowNext();DKUtils.reflowLater();$scope.hooks.updateRecipeStatus()}}$scope.uiState={currentStep:"group",outputColumnNamesOverridable:true,computedColumns:[]};$scope.hooks.onRecipeLoaded=function(){Logger.info("On Recipe Loaded");validateFilters();$scope.$watch("script.data",onScriptChanged,true);$scope.$watchCollection("recipe.inputs.main.items",function(){DatasetUtils.updateRecipeComputables($scope,$scope.recipe,$stateParams.projectKey,contextProjectKey).then(_=>resyncWithInputSchema())})};$scope.$watch("topNav.tab",function(nv){if(nv=="settings"){$timeout(function(){$scope.$broadcast("redrawFatTable")})}});$scope.enableAutoFixup();$scope.specificControllerLoadedDeferred.resolve()})})();(function(){"use strict";var app=angular.module("dataiku.recipes");app.controller("UpsertRecipeCreationController",function($scope,Fn,$stateParams,DataikuAPI,$controller){$scope.recipeType="upsert";$controller("SingleOutputDatasetRecipeCreationController",{$scope:$scope});$scope.autosetName=function(){if($scope.io.inputDataset&&$scope.io.targetVariable){var niceInputName=$scope.io.inputDataset.replace(/[A-Z]*\./,"");var niceTargetVariable=$scope.io.targetVariable.replace(/[^\w ]+/g,"").replace(/ +/g,"_");$scope.maybeSetNewDatasetName(niceInputName+"_by_"+niceTargetVariable)}};$scope.getCreationSettings=function(){return{upsertKey:$scope.io.targetVariable}};var superFormIsValid=$scope.formIsValid;$scope.formIsValid=function(){return!!(superFormIsValid()&&$scope.io.targetVariable!==undefined)};$scope.showOutputPane=function(){return!!($scope.io.inputDataset&&$scope.io.targetVariable!==undefined)};$scope.$watch("io.targetVariable",Fn.doIfNv($scope.autosetName))});app.controller("UpsertRecipeController",function($scope,$stateParams,DataikuAPI,$q,Dialogs,ContextualMenu,PartitionDeps,$rootScope,$timeout,DKUtils,Expressions,Logger,$controller,RecipesUtils,Fn,DatasetUtils){var visualCtrl=$controller("VisualRecipeEditorController",{$scope:$scope});this.visualCtrl=visualCtrl;let contextProjectKey=$scope.context&&$scope.context.projectKey?$scope.context.projectKey:$stateParams.projectKey;$scope.hooks.getPayloadData=function(){return angular.toJson($scope.params)};$scope.hooks.updateRecipeStatus=function(forceUpdate,exactPlan){var payload=$scope.hooks.getPayloadData();if(!payload)return $q.reject("payload not ready");var deferred=$q.defer();$scope.updateRecipeStatusBase(forceUpdate,payload,{reallyNeedsExecutionPlan:exactPlan,exactPlan:exactPlan}).then(function(){if(!$scope.recipeStatus)return deferred.reject();deferred.resolve($scope.recipeStatus)});return deferred.promise};function validateFilters(){if(!$scope.params)return;var inputRef=RecipesUtils.getSingleInput($scope.recipe,"main").ref;var inputSchema=$scope.computablesMap[inputRef].dataset.schema;validateFilter($scope.params.preFilter,inputSchema)}function validateFilter(filterDesc,schema){var deferred=$q.defer();if(!filterDesc||!filterDesc.enabled)return;if(angular.isUndefined(filterDesc.expression))return;Expressions.validateExpression(filterDesc.expression,schema).success(function(data){if(data.ok&&$scope.mustRunInDatabase&&!data.fullyTranslated){data.ok=false}filterDesc.$status=data;filterDesc.$status.validated=true;deferred.resolve(data)}).error(function(data){setErrorInScope.bind($scope);deferred.reject("Error while validating filter")});return deferred.promise}$scope.onFilterUpdate=$scope.updateRecipeStatusLater;function computedColumnListUpdated(computedColumns){$scope.params.computedColumns=angular.copy(computedColumns);resyncWithInputSchema();$scope.updateRecipeStatusLater()}$scope.onComputedColumnListUpdate=computedColumnListUpdated;$scope.getColumnsWithComputed=function(){if(!$scope.uiState.columnsWithComputed){var columns=[].concat($scope.getColumns());for(var i=0;i<(($scope.params||{}).computedColumns||[]).length;i++){var computedCol=$scope.params.computedColumns[i];if(computedCol.name&&columns.map(function(col){return col.name}).indexOf(computedCol.name)==-1){columns.push({name:computedCol.name,type:computedCol.type})}}$scope.uiState.columnsWithComputed=columns}return $scope.uiState.columnsWithComputed};$scope.selectLine=function(event,col,ignore){event.preventDefault();var hasLastSelection=$scope.uiState.columnStatus.filter(function(c){return c.ignore==ignore&&!!c.$lastSelection}).length>0;if(event.shiftKey&&hasLastSelection){var selecting=false;for(var i=0;i<$scope.uiState.columnStatus.length;i++){var c=$scope.uiState.columnStatus[i];if(c.ignore!=ignore){continue}var bound=!!c.$lastSelection||c.name===col.name;var firstBound=!selecting&&bound;var lastBound=!!selecting&&bound;if(firstBound){selecting=true;c.$selected=true}c.$selected=selecting;if(lastBound){selecting=false}}}else{$scope.uiState.columnStatus.filter(function(c){return c.ignore==ignore}).forEach(function(c){c.$lastSelection=c.name===col.name});if(event.metaKey||event.ctrlKey){col.$selected=!col.$selected}else{$scope.uiState.columnStatus.filter(function(c){return c.ignore==ignore}).forEach(function(c){c.$selected=c.name===col.name})}}};function assignIgnoreSelected(ignore,selected){return function(col){col.ignore=ignore;col.$selected=selected;col.$lastSelection=false}}$scope.removeAllUpsertColumns=function(){if(!$scope.uiState.columnStatus){return}$scope.uiState.columnStatus.forEach(assignIgnoreSelected(true,false))};$scope.addAllUpsertColumns=function(){if(!$scope.uiState.columnStatus){return}$scope.uiState.columnStatus.forEach(assignIgnoreSelected(false,false))};$scope.removeUpsertColumns=function(col){if(col){assignIgnoreSelected(true,false)(col)}else if($scope.uiState.columnStatus){$scope.uiState.columnStatus.filter(function(col){return!col.ignore&&col.$selected}).forEach(assignIgnoreSelected(true,false))}};$scope.addUpsertColumns=function(col){if(col){assignIgnoreSelected(false,false)(col)}else if($scope.uiState.columnStatus){$scope.uiState.columnStatus.filter(function(col){return col.ignore&&col.$selected}).forEach(assignIgnoreSelected(false,false))}};function loadParamsFromScript(scriptData){if(!scriptData)return;$scope.params=JSON.parse(scriptData);$scope.params.preFilter=$scope.params.preFilter||{};$scope.params.computedColumns=$scope.params.computedColumns||[];$scope.uiState.computedColumns=angular.copy($scope.params.computedColumns);$scope.uiState.columnStatus=angular.copy($scope.getColumnsWithComputed());var keyColNames=$scope.params.keys.map(function(k){return k.column});$scope.uiState.columnStatus.forEach(function(col){col.ignore=keyColNames.indexOf(col.name)==-1});visualCtrl.saveServerParams();resyncWithInputSchema();onColumnStatusChanged()}function resyncWithInputSchema(){$scope.uiState.columnsWithComputed=undefined;var inputColumnsWithComputed=$scope.getColumnsWithComputed();var newColumnStatus=[];var oldColumnStatusNames=($scope.uiState.columnStatus||[]).map(function(col){return col.name});inputColumnsWithComputed.forEach(function(col){var oldCSNIdx=oldColumnStatusNames.indexOf(col.name);if(oldCSNIdx>=0){newColumnStatus.push(angular.extend($scope.uiState.columnStatus[oldCSNIdx],col))}else{var ncs=angular.copy(col);ncs.ignore=true;newColumnStatus.push(ncs)}});$scope.uiState.columnStatus=newColumnStatus;if($scope.onResyncWithInputSchema){$scope.onResyncWithInputSchema()}}function onScriptChanged(nv,ov){if(nv){loadParamsFromScript($scope.script.data);DKUtils.reflowNext();DKUtils.reflowLater();$scope.hooks.updateRecipeStatus()}}$scope.uiState={currentStep:"upsert",computedColumns:[]};$scope.hooks.onRecipeLoaded=function(){Logger.info("On Recipe Loaded");validateFilters();$scope.$watch("script.data",onScriptChanged,true);$scope.$watchCollection("recipe.inputs.main.items",function(){DatasetUtils.updateRecipeComputables($scope,$scope.recipe,$stateParams.projectKey,contextProjectKey).then(_=>resyncWithInputSchema())})};function onColumnStatusChanged(){if(!$scope.params){return}$scope.params.keys=($scope.uiState.columnStatus||[]).filter(function(col){return!col.ignore}).map(function(col){return{column:col.name}});$scope.updateRecipeStatusLater()}$scope.$watch("topNav.tab",function(nv){if(nv=="settings"){$timeout(function(){$scope.$broadcast("redrawFatTable")})}});$scope.enableAutoFixup();$scope.specificControllerLoadedDeferred.resolve();$scope.$watch("uiState.columnStatus",onColumnStatusChanged,true)})})();(function(){"use strict";var app=angular.module("dataiku.recipes");app.controller("DistinctRecipeCreationController",function($scope,$controller){$scope.recipeType="distinct";$controller("SingleOutputDatasetRecipeCreationController",{$scope:$scope});$scope.autosetName=function(){if($scope.io.inputDataset){var niceInputName=$scope.io.inputDataset.replace(/[A-Z]*\./,"");$scope.maybeSetNewDatasetName(niceInputName+"_distinct")}}});app.controller("DistinctRecipeController",function($scope,$stateParams,$q,DKUtils,Expressions,Logger,$controller,DatasetUtils,RecipesUtils){var visualCtrl=$controller("VisualRecipeEditorController",{$scope:$scope});this.visualCtrl=visualCtrl;let contextProjectKey=$scope.context&&$scope.context.projectKey?$scope.context.projectKey:$stateParams.projectKey;$scope.selectLine=function(event,col,ignore){event.preventDefault();var hasLastSelection=$scope.uiState.columnStatus.filter(function(c){return c.ignore==ignore&&!!c.$lastSelection}).length>0;if(event.shiftKey&&hasLastSelection){var selecting=false;for(var i=0;i<$scope.uiState.columnStatus.length;i++){var c=$scope.uiState.columnStatus[i];if(c.ignore!=ignore){continue}var bound=!!c.$lastSelection||c.name===col.name;var firstBound=!selecting&&bound;var lastBound=!!selecting&&bound;if(firstBound){selecting=true;c.$selected=true}c.$selected=selecting;if(lastBound){selecting=false}}}else{$scope.uiState.columnStatus.filter(function(c){return c.ignore==ignore}).forEach(function(c){c.$lastSelection=c.name===col.name});if(event.metaKey||event.ctrlKey){col.$selected=!col.$selected}else{$scope.uiState.columnStatus.filter(function(c){return c.ignore==ignore}).forEach(function(c){c.$selected=c.name===col.name})}}};function assignIgnoreSelected(ignore,selected){return function(col){col.ignore=ignore;col.$selected=selected;col.$lastSelection=false}}$scope.removeAllDistinctColumns=function(){if(!$scope.uiState.columnStatus){return}$scope.uiState.columnStatus.forEach(assignIgnoreSelected(true,false))};$scope.addAllDistinctColumns=function(){if(!$scope.uiState.columnStatus){return}$scope.uiState.columnStatus.forEach(assignIgnoreSelected(false,false))};$scope.removeDistinctColumns=function(col){if(col){assignIgnoreSelected(true,false)(col)}else if($scope.uiState.columnStatus){$scope.uiState.columnStatus.filter(function(col){return!col.ignore&&col.$selected}).forEach(assignIgnoreSelected(true,false))}};$scope.addDistinctColumns=function(col){if(col){assignIgnoreSelected(false,false)(col)}else if($scope.uiState.columnStatus){$scope.uiState.columnStatus.filter(function(col){return col.ignore&&col.$selected}).forEach(assignIgnoreSelected(false,false))}};$scope.hooks.getPayloadData=function(){return angular.toJson($scope.params)};$scope.hooks.updateRecipeStatus=function(forceUpdate,exactPlan){var payload=$scope.hooks.getPayloadData();if(!payload){return $q.reject("payload not ready")}var deferred=$q.defer();$scope.updateRecipeStatusBase(forceUpdate,payload,{reallyNeedsExecutionPlan:exactPlan,exactPlan:exactPlan}).then(function(){if(!$scope.recipeStatus){return deferred.reject()}var outputSchema=$scope.recipeStatus.outputSchema;var outputSchemaBO=$scope.recipeStatus.outputSchemaBeforeOverride;if(outputSchema){$scope.params.postFilter.$status=$scope.params.postFilter.$status||{};$scope.params.postFilter.$status.schema=outputSchemaBO;$scope.params.outputColumnNameOverrides=$scope.params.outputColumnNameOverrides||{};var columnsAO=outputSchema.columns;var columnsBO=outputSchemaBO&&outputSchemaBO.columns?outputSchemaBO.columns:outputSchema.columns;for(var i in columnsAO){if(columnsAO[i].name!=columnsBO[i].name){$scope.params.outputColumnNameOverrides[columnsBO[i].name]=columnsAO[i].name}columnsAO[i].$beforeOverride=columnsBO[i].name;columnsAO[i].name=$scope.params.outputColumnNameOverrides[columnsBO[i].name]||columnsBO[i].name}}deferred.resolve($scope.recipeStatus)});return deferred.promise};$scope.updateColumnNameOverride=function(column){if(column.$beforeOverride!=column.name){$scope.params.outputColumnNameOverrides[column.$beforeOverride]=column.name}else{delete $scope.params.outputColumnNameOverrides[column.$beforeOverride]}};function validateFilters(){if(!$scope.params){return}var inputRef=RecipesUtils.getSingleInput($scope.recipe,"main").ref;var inputSchema=$scope.computablesMap[inputRef].dataset.schema;validateFilter($scope.params.preFilter,inputSchema);validateFilter($scope.params.postFilter)}function validateFilter(filterDesc,schema){var deferred=$q.defer();if(!filterDesc.enabled){return}if(angular.isUndefined(filterDesc.expression)){return}Expressions.validateExpression(filterDesc.expression,schema).success(function(data){if(data.ok&&$scope.mustRunInDatabase&&!data.fullyTranslated){data.ok=false}filterDesc.$status=data;filterDesc.$status.validated=true;deferred.resolve(data)}).error(function(data){setErrorInScope.bind($scope);deferred.reject("Error while validating filter")});return deferred.promise}$scope.onFilterUpdate=$scope.updateRecipeStatusLater;function loadParamsFromScript(scriptData){if(!scriptData){return}$scope.params=JSON.parse(scriptData);$scope.params.keys=$scope.params.keys||[];$scope.params.preFilter=$scope.params.preFilter||{};$scope.params.postFilter=$scope.params.postFilter||{};$scope.params.outputColumnNameOverrides=$scope.params.outputColumnNameOverrides||{};$scope.uiState.columnStatus=angular.copy($scope.getColumns());var keyColNames=$scope.params.keys.map(k=>k.column);$scope.uiState.columnStatus.forEach(function(col){col.ignore=!$scope.params.selectAllColumns&&keyColNames.indexOf(col.name)==-1});visualCtrl.saveServerParams();resyncWithInputSchema();onColumnStatusChanged()}function resyncWithInputSchema(){var inputColumns=$scope.getColumns();var newColumnStatus=[];var oldColumnStatusNames=($scope.uiState.columnStatus||[]).map(function(col){return col.name});inputColumns.forEach(function(col){var oldCSNIdx=oldColumnStatusNames.indexOf(col.name);if(oldCSNIdx>=0){newColumnStatus.push(angular.extend($scope.uiState.columnStatus[oldCSNIdx],col))}else{newColumnStatus.push(angular.copy(col))}});$scope.uiState.columnStatus=newColumnStatus}function onColumnStatusChanged(){if(!$scope.params){return}if(!$scope.params.selectAllColumns){$scope.params.keys=($scope.uiState.columnStatus||[]).filter(function(col){return!col.ignore}).map(function(col){return{column:col.name}})}$scope.updateRecipeStatusLater()}function onScriptChanged(nv){if(nv){loadParamsFromScript($scope.script.data);DKUtils.reflowNext();DKUtils.reflowLater();$scope.hooks.updateRecipeStatus()}}$scope.uiState={currentStep:"group",outputColumnNamesOverridable:true};$scope.hooks.onRecipeLoaded=function(){Logger.info("On Recipe Loaded");validateFilters();$scope.$watch("script.data",onScriptChanged,true)};$scope.enableAutoFixup();$scope.specificControllerLoadedDeferred.resolve();$scope.$watchCollection("recipe.inputs.main.items",function(){DatasetUtils.updateRecipeComputables($scope,$scope.recipe,$stateParams.projectKey,contextProjectKey).then(_=>resyncWithInputSchema())});$scope.$watch("uiState.columnStatus",onColumnStatusChanged,true);$scope.$watch("params.globalCount",$scope.updateRecipeStatusLater);$scope.$watch("params.selectAllColumns",onColumnStatusChanged)})})();(function(){"use strict";var app=angular.module("dataiku.recipes");const SELECTION_MODE={ALL:"ALL",EXPLICIT:"EXPLICIT"};app.controller("WindowRecipeCreationController",function($scope,Fn,$stateParams,DataikuAPI,$controller){$scope.recipeType="window";$controller("SingleOutputDatasetRecipeCreationController",{$scope:$scope});$scope.autosetName=function(){if($scope.io.inputDataset){var niceInputName=$scope.io.inputDataset.replace(/[A-Z]*\./,"");$scope.maybeSetNewDatasetName(niceInputName+"_windows")}}});app.controller("WindowRecipeController",function($scope,$stateParams,DataikuAPI,$q,Dialogs,TopNav,ContextualMenu,PartitionDeps,$rootScope,$timeout,DKUtils,Expressions,Logger,$controller,RecipesUtils,CreateModalFromTemplate,Fn,DatasetTypesService,translate){var groupingCtrl=$controller("GroupingRecipeController",{$scope:$scope});var visualCtrl=groupingCtrl.visualCtrl;$scope.aggregateUsabilityFlag="usableInWindow";$scope.uiState=$scope.uiState||{};const scriptData=JSON.parse($scope.script.data);$scope.uiState.retrieveAll=scriptData.retrievedColumnsSelectionMode===SELECTION_MODE.ALL;$scope.$watch("selection.filteredObjects",function(){if($scope.uiState.retrieveAll&&$scope.selection.filteredObjects){$scope.selection.filteredObjects.forEach(obj=>obj.value=true)}});function filterUnused(vals){return vals.filter(function(val){return $scope.uiState.retrieveAll||!$scope.uiState.hideUseless||$scope.columnHasSomeComputation(val)})}$scope.selection={customFilter:filterUnused,customFilterWatch:["uiState.hideUseless","uiState.retrieveAll"]};$scope.simpleAggregationTypes=[{name:"value",opType:"RETRIEVE",label:translate("WINDOW_RECIPE.AGGREGATIONS.RETRIEVE","Retrieve"),tooltip:translate("WINDOW_RECIPE.AGGREGATIONS.RETRIEVE_DESCRIPTION","Retrieve original value")},{name:"min",label:translate("WINDOW_RECIPE.AGGREGATIONS.MIN","Min")},{name:"max",label:translate("WINDOW_RECIPE.AGGREGATIONS.MAX","Max")},{name:"avg",label:translate("WINDOW_RECIPE.AGGREGATIONS.AVG","Avg")},{name:"sum",label:translate("WINDOW_RECIPE.AGGREGATIONS.SUM","Sum")},{name:"stddev",label:translate("WINDOW_RECIPE.AGGREGATIONS.STD_DEV","Std. dev.")},{name:"count",label:translate("WINDOW_RECIPE.AGGREGATIONS.COUNT","Count"),tooltip:translate("WINDOW_RECIPE.AGGREGATIONS.COUNT_DESCRIPTION","Count non-null"),separatorAfter:true},{name:"first",label:translate("WINDOW_RECIPE.AGGREGATIONS.FIRST","First")},{name:"last",label:translate("WINDOW_RECIPE.AGGREGATIONS.LAST","Last")},{name:"concat",label:translate("WINDOW_RECIPE.AGGREGATIONS.CONCAT","Concat"),tooltip:translate("WINDOW_RECIPE.AGGREGATIONS.CONCAT_DESCRIPTION","Concatenate values in one string")}];$scope.lagAggregationTypes=[{name:"lag",label:translate("WINDOW_RECIPE.AGGREGATIONS.LAG","Lag"),tooltip:translate("WINDOW_RECIPE.AGGREGATIONS.LAG_DESCRIPTION","Value in a previous row")},{name:"lagDiff",opType:"LAG_DIFF",label:translate("WINDOW_RECIPE.AGGREGATIONS.LAD_DIFF","LagDiff"),tooltip:translate("WINDOW_RECIPE.AGGREGATIONS.LAG_DIFF_DESCRIPTION","Difference with a previous row")}];$scope.leadAggregationTypes=[{name:"lead",label:translate("WINDOW_RECIPE.AGGREGATIONS.LEAD","Lead"),tooltip:translate("WINDOW_RECIPE.AGGREGATIONS.LEAD_DESCRIPTION","Value in a following row")},{name:"leadDiff",opType:"LEAD_DIFF",label:translate("WINDOW_RECIPE.AGGREGATIONS.LEAD_DIFF","LeadDiff"),tooltip:translate("WINDOW_RECIPE.AGGREGATIONS.LEAD_DIFF_DESCRIPTION","Difference with a following row")}];$scope.filteredSimpleAggTypes=$scope.simpleAggregationTypes.filter(agg=>$scope.uiState.retrieveAll?agg.name!=="value":true);$scope.aggregationTypes=$scope.simpleAggregationTypes.concat($scope.lagAggregationTypes,$scope.leadAggregationTypes);function makeSelectionTest(f){return function(){if(!$scope.selection||!$scope.selection.allObjects){return false}return $scope.selection.allObjects.map(f).reduce(Fn.OR,false)}}$scope.shouldDisplayDateUnit=makeSelectionTest.call(null,function(o){return(o.leadDiff||o.lagDiff)&&DatasetTypesService.isTemporalType(o.type)});$scope.displayRetrieveAll=function(){$scope.filteredSimpleAggTypes=$scope.simpleAggregationTypes.filter(agg=>$scope.uiState.retrieveAll?agg.name!=="value":true);$scope.selection.filteredObjects.forEach(obj=>obj.value=true);$scope.params.retrievedColumnsSelectionMode=$scope.uiState.retrieveAll?SELECTION_MODE.ALL:SELECTION_MODE.EXPLICIT};$scope.addWindow=function(){$scope.params.windows=$scope.params.windows||[];$scope.params.windows.push({prefix:$scope.params.windows.length?"w"+($scope.params.windows.length+1):""})};$scope.removeWindow=function(index){$scope.params.windows.splice(index,1)};$scope.allWindowsOrdered=function(){var ret=true;(($scope.params||{}).windows||[]).forEach(function(w){ret=w.enableOrdering&&w.orders&&w.orders.length&&ret});return ret};$scope.addPartitioningColumn=function(win){win.partitioningColumns=win.partitioningColumns||[];var columns=$scope.getColumnsWithComputed();var colName;if(columns){var columnNames=columns.map(function(col){return col.name});for(var i=0;i<columns.length;++i){if(win.partitioningColumns.indexOf(columnNames[i])<0){colName=columnNames[i];break}}colName=colName||columnNames[0]}win.partitioningColumns.push(colName)};$scope.removePartitioningColumn=function(win,index){win.partitioningColumns.splice(index,1)};$scope.addOrderColumn=function(win){win.orders=win.orders||[];var columns=$scope.getColumnsWithComputed();var colName;if(columns){var columnNames=columns.map(function(col){return col.name});var orderColumns=win.orders.map(function(order){return order.column});for(var i=0;i<columns.length;++i){if(orderColumns.indexOf(columnNames[i])<0){colName=columnNames[i];break}}colName=colName||columnNames[0]}win.orders.push({column:colName})};$scope.getOrderColumnType=function(win){if(!win.orders||!win.orders.length){return}const colName=win.orders[0].column;const col=$scope.getColumnsWithComputed().find(c=>c.name==colName);return col&&col.type};$scope.removeOrderColumn=function(win,index){win.orders.splice(index,1)};$scope.onResyncWithInputSchema=function(){var inputColumnsWithComputed=$scope.getColumnsWithComputed(true);var inputColumnsWithComputedNames=inputColumnsWithComputed.map(function(col){return col.name});(($scope.params||{}).windows||[]).forEach(function(win){var i=(win.partitioningColumns||[]).length;while(i--){if(!win.partitioningColumns[i]||inputColumnsWithComputedNames.indexOf(win.partitioningColumns[i])==-1){win.partitioningColumns.splice(i,1)}}i=(win.orders||[]).length;while(i--){if(!win.orders[i]||!win.orders[i].column||inputColumnsWithComputedNames.indexOf(win.orders[i].column)==-1){win.orders.splice(i,1)}}})};$scope.isWindowFrameRowsLimitationInvalid=window=>window.limitFollowing&&window.limitPreceding&&window.followingRows+window.precedingRows<0;$scope.uiState.currentStep="windows";$scope.$watch("topNav.tab",function(nv){if(nv=="settings"){$timeout(function(){$scope.$broadcast("redrawFatTable")})}});$scope.$watch("params.windows",$scope.updateRecipeStatusLater,true)})})();(function(){"use strict";var app=angular.module("dataiku.recipes");app.controller("SamplingRecipeCreationController",function($scope,Fn,$stateParams,DataikuAPI,$controller){$scope.recipeType="sampling";$controller("SingleOutputDatasetRecipeCreationController",{$scope:$scope});$scope.autosetName=function(){if($scope.io.inputDataset){var niceInputName=$scope.io.inputDataset.replace(/[A-Z]*\./,"");$scope.maybeSetNewDatasetName(niceInputName+"_filtered")}}});app.controller("SamplingRecipeController",function($scope,$stateParams,WT1,$q,DataikuAPI,TopNav,Dialogs,PartitionDeps,RecipesUtils,$controller,Logger,SamplingData,CreateModalFromTemplate,DatasetUtils,RecipeComputablesService){var visualCtrl=$controller("VisualRecipeEditorController",{$scope:$scope});this.visualCtrl=visualCtrl;$scope.SamplingData=SamplingData;var defaultSampling={samplingMethod:"FULL",maxRecords:3e4,targetRatio:.1};$scope.hooks.getPayloadData=function(){return angular.toJson($scope.filter)};$scope.hooks.preRunValidate=function(){var deferred=$q.defer();$scope.hooks.updateRecipeStatus().then(function(data){if(data){Logger.info("preRunValidate failed",data);var validationData={error:false,messages:[]};if(data.filter.invalid){validationData.error=true;data.filter.errorMessages.forEach(function(m){validationData.messages.push({message:m})})}if(data.output.invalid){validationData.error=true;data.output.errorMessages.forEach(function(m){validationData.messages.push({message:m})})}deferred.resolve(validationData)}else{deferred.resolve({error:false})}},function(data){Logger.error("Error when getting status",data);setErrorInScope.bind($scope);deferred.reject("Validation failed")});return deferred.promise};var superSave=$scope.hooks.save;$scope.hooks.save=function(){return superSave().then(function(){origSelection=angular.copy($scope.selection)})};var superRecipeIsDirty=$scope.hooks.recipeIsDirty;var origSelection;$scope.hooks.recipeIsDirty=function(){if(superRecipeIsDirty())return true;var selectionEquals=angular.equals($scope.selection,origSelection);return!selectionEquals};$scope.hooks.onRecipeLoaded=function(){Logger.info("On Recipe Loaded");origSelection=angular.copy($scope.selection);visualCtrl.saveServerParams();$scope.hooks.updateRecipeStatus();$scope.$watch("recipe.params",$scope.updateRecipeStatusLater,true);$scope.$watch("filter",$scope.updateRecipeStatusLater,true)};$scope.hooks.updateRecipeStatus=function(){var deferred=$q.defer();var payload=$scope.hooks.getPayloadData();$scope.updateRecipeStatusBase(false,payload).then(function(){if(!$scope.recipeStatus)return deferred.reject();deferred.resolve($scope.recipeStatus)});return deferred.promise};$scope.resyncSchema=function(){Dialogs.confirmPositive($scope,"Resynchronize schema",'The schema of "'+$scope.recipe.inputs[0]+'" will be copied to "'+$scope.recipe.outputs[0]+'". Are you sure you want to continue ?').then(function(){DataikuAPI.flow.recipes.basicResyncSchema($stateParams.projectKey,$scope.hooks.getRecipeSerialized()).error(setErrorInScope.bind($scope))})};$scope.availableOutputDatasets=[];$scope.convertToSplitRecipe=function(){function doConvertToSplitRecipe(secondOutputDataset){DataikuAPI.flow.recipes.visual.convertSamplingRecipeToSplitRecipe($stateParams.projectKey,$scope.recipe,secondOutputDataset).then(function(){location.reload()},setErrorInScope.bind($scope))}if($scope.hooks.recipeIsDirty()){$scope.hooks.save()}CreateModalFromTemplate("/templates/recipes/io/output-selection-modal.html",$scope,null,function(modalScope){$controller("_RecipeOutputNewManagedBehavior",{$scope:modalScope});modalScope.singleOutputRole={name:"main",arity:"UNARY",acceptsDataset:true};DatasetUtils.listDatasetsUsabilityInAndOut($stateParams.projectKey,$scope.recipe.type).then(function(data){const alreadyInOutput=function(computable){if($scope.recipe&&$scope.recipe.outputs&&$scope.recipe.outputs.main&&$scope.recipe.outputs.main.items){return $scope.recipe.outputs.main.items.filter(item=>item.ref==computable.smartName).length>0}else{return false}};$scope.availableOutputDatasets=data[1].filter(function(computable){return computable.usableAsOutput["main"].usable&&!computable.alreadyUsedAsOutputOf&&!alreadyInOutput(computable)})});DataikuAPI.datasets.getManagedDatasetOptions($scope.recipe,"main").success(function(data){modalScope.setupManagedDatasetOptions(data)});modalScope.ok=function(_dismissModal,force=false){if(modalScope.io.newOutputTypeRadio=="select"){if(!modalScope.io.existingOutputDataset)return;doConvertToSplitRecipe(modalScope.io.existingOutputDataset)}else{const creationSettings={connectionId:modalScope.newOutputDataset.connectionOption.id,specificSettings:{formatOptionId:modalScope.newOutputDataset.formatOptionId,overrideSQLCatalog:modalScope.newOutputDataset.overrideSQLCatalog,overrideSQLSchema:modalScope.newOutputDataset.overrideSQLSchema,overrideIcebergNamespace:modalScope.newOutputDataset.overrideIcebergNamespace},partitioningOptionId:modalScope.newOutputDataset.partitioningOption};const checkPromise=force?$q.resolve({data:{messages:[]}}):DataikuAPI.datasets.checkNameSafety($stateParams.projectKey,modalScope.newOutputDataset.name,creationSettings);checkPromise.then(({data})=>{modalScope.uiState.backendWarnings=data.messages;return!data.messages||!data.messages.length}).then(proceed=>{if(proceed){return DataikuAPI.datasets.newManagedDataset($stateParams.projectKey,modalScope.newOutputDataset.name,creationSettings).then(({data:dataset})=>{RecipeComputablesService.getComputablesMap(modalScope.recipe,modalScope).then(function(map){modalScope.setComputablesMap(map);doConvertToSplitRecipe(dataset.name)},setErrorInScope.bind(modalScope));WT1.event("create-dataset",{connectionType:modalScope.newOutputDataset&&modalScope.newOutputDataset.connectionOption?modalScope.newOutputDataset.connectionOption.connectionType:"unknown",partitioningFrom:modalScope.newOutputDataset?modalScope.newOutputDataset.partitioningOption:"unknown",recipeType:modalScope.recipe?modalScope.recipe.type:"unknown"})})}}).catch(setErrorInScope.bind($scope))}}})};$scope.filter={};if($scope.script&&$scope.script.data){$scope.filter=JSON.parse($scope.script.data)}$scope.fromElasticSearchExportQuery=()=>$scope.recipeAdditionalParams&&!!$scope.recipeAdditionalParams.elasticSearchQuery;if($scope.fromElasticSearchExportQuery()){Logger.info("Enabling filter because it was created via 'export to filter recipe' from an ElasticSearch dataset");$scope.filter.enabled=true}$scope.params=$scope.recipe.params;$scope.selection=$scope.recipe.params.selection;$scope.$watch("selection",function(nv,ov){Logger.info("Selection changed",nv);if(nv){$scope.recipe.params.selection=nv}},true);$scope.$watch("filter.uiData.mode",function(nv,ov){Logger.info("Filter mode changed",nv);if(nv&&nv==="ES_QUERY_STRING"){$scope.selection.samplingMethod="FULL"}});$scope.enableAutoFixup();$scope.specificControllerLoadedDeferred.resolve()})})();(function(){"use strict";var app=angular.module("dataiku.recipes");app.controller("VStackRecipeCreationController",function($scope,$controller,$stateParams,DataikuAPI,Fn,RecipeComputablesService){$scope.recipeType="vstack";$scope.recipe={type:"vstack",projectKey:$stateParams.projectKey,inputs:{main:{items:[]}},outputs:{main:{items:[]}}};RecipeComputablesService.getComputablesMap($scope.recipe,$scope).then(function(map){$scope.setComputablesMap(map)});$controller("SingleOutputDatasetRecipeCreationController",{$scope:$scope});$scope.autosetName=function(){if($scope.io.inputDataset){var niceInputName=$scope.io.inputDataset.replace(/[A-Z]*\./,"");$scope.maybeSetNewDatasetName(niceInputName+"_stacked")}};$scope.getCreationSettings=function(){return{virtualInputs:$scope.recipe.inputs.main.items.map(input=>input.ref)}};$scope.formIsValid=function(){return $scope.recipe.inputs.main.items.length&&($scope.io.newOutputTypeRadio=="create"&&$scope.newOutputDataset&&$scope.newOutputDataset.name&&$scope.newOutputDataset.connectionOption&&$scope.isDatasetNameUnique($scope.newOutputDataset.name)||$scope.io.newOutputTypeRadio=="select"&&$scope.io.existingOutputDataset)};$scope.showOutputPane=function(){return $scope.recipe.inputs.main.items.length>0};$scope.$watchCollection("recipe.inputs.main.items",function(nv){if(nv&&nv.length){$scope.io.inputDataset=nv[0].ref}})});app.controller("VStackRecipeController",function($scope,$controller,$q,$stateParams,DataikuAPI,Dialogs,PartitionDeps,CreateModalFromTemplate,RecipesUtils,Logger,DatasetUtils){var visualCtrl=$controller("VisualRecipeEditorController",{$scope:$scope});$scope.hooks.updateRecipeStatus=function(forceUpdate,exactPlan){var payload=$scope.hooks.getPayloadData();if(!payload)return $q.reject("payload not ready");var deferred=$q.defer();$scope.updateRecipeStatusBase(forceUpdate,payload,{reallyNeedsExecutionPlan:exactPlan,exactPlan:exactPlan}).then(function(){if(!$scope.recipeStatus)return deferred.reject();if($scope.recipeStatus.outputSchema){$scope.params.postFilter=$scope.params.postFilter||{};$scope.params.postFilter.$status=$scope.params.postFilter.$status||{};$scope.params.postFilter.$status.schema=$scope.recipeStatus.outputSchema}deferred.resolve($scope.recipeStatus)});return deferred.promise};$scope.hooks.getPayloadData=function(){if(!$scope.params){return null}var us=$scope.unionSchema||[];if($scope.params.mode!="FROM_INDEX"&&$scope.params.mode!="REMAP"){$scope.params.selectedColumns=us.filter(function(column){return column.selected}).map(function(column){return column.name})}return angular.toJson($scope.params)};$scope.showNewInputModal=function(){CreateModalFromTemplate("/templates/recipes/fragments/virtual-input-modal.html",$scope)};$scope.selected={};$scope.selectedFromIndex={};$scope.addDataset=function(datasetName){if(RecipesUtils.getInput($scope.recipe,"main",datasetName)==null){RecipesUtils.addInput($scope.recipe,"main",datasetName)}var inputNames=RecipesUtils.getInputsForRole($scope.recipe,"main").map(function(input){return input.ref});var inputDesc={index:inputNames.indexOf(datasetName),originLabel:datasetName,preFilter:{},columnsMatch:[]};DatasetUtils.updateDatasetInComputablesMap($scope,datasetName,$stateParams.projectKey,$stateParams.projectKey).then(()=>{buildInitialColumnsMatchForInput(inputDesc);$scope.params.virtualInputs.push(inputDesc);$scope.updateColumnsSelection();$scope.updateRecipeStatusLater()})};$scope.removeDataset=function(index){removeDatasets([index])};$scope.updateSelectAllColumns=function(){for(let i=0;i<$scope.unionSchema.length;i++){if($scope.unionSchema[i]){$scope.unionSchema[i].selected=$scope.selected.all}}$scope.selected.any=$scope.selected.all};$scope.updateSelectAllColumnsFromIndex=function(){for(let i=0;i<$scope.getSelectableColumns.length;i++){if(!$scope.selectedColumns[i]){$scope.selectedColumns[i]={name:$scope.getSelectableColumns[i][0]}}$scope.selectedColumns[i].selected=$scope.selectedFromIndex.all}$scope.selectedFromIndex.any=$scope.selectedFromIndex.all};$scope.updateGlobalSelectionStatus=function(){var all=true,any=false;for(let i=0;i<$scope.unionSchema.length;i++){if($scope.unionSchema[i]&&$scope.unionSchema[i].selected){any=true}else{all=false}}$scope.selected={all:all,any:any};all=true;any=false;if($scope.params.mode=="FROM_INDEX"){for(let i=0;i<$scope.getSelectableColumns.length;i++){const selectableCol=$scope.getSelectableColumns[i];const selCol=$scope.selectedColumns.find(col=>col&&selectableCol.indexOf(col.name)>=0);if(selCol&&selCol.selected){any=true}else{all=false}}}else{for(let i=0;i<$scope.selectedColumns.length;i++){if($scope.selectedColumns[i]&&$scope.selectedColumns[i].selected){any=true}else{all=false}}}$scope.selectedFromIndex={all:all,any:any}};$scope.getDatasetName=function(virtualIndex){var dataset=$scope.params.virtualInputs[virtualIndex];return $scope.getDatasetNameFromRecipeInputIndex(dataset.index)};$scope.getColumnList=function(datasetIndex){var selectedColumns;if(datasetIndex!=null){selectedColumns=$scope.getColumns($scope.getDatasetNameFromRecipeInputIndex(datasetIndex))}else{selectedColumns=[]}return selectedColumns};$scope.selectedColumns=[];$scope.addColumn=function(){let newColumnName=null;$scope.params.virtualInputs.forEach(function(virtualInput){if(newColumnName)return;let inputColumns=$scope.getColumns(virtualInput.originLabel);for(const inputColumn of inputColumns){if(virtualInput.columnsMatch.indexOf(inputColumn.name)==-1){if(!newColumnName)newColumnName=inputColumn.name;break}}});if(!newColumnName){let idx=1;let possibleColName="Col-"+idx;while($scope.params.selectedColumns.indexOf(possibleColName)!=-1){idx++;possibleColName="Col-"+idx}newColumnName=possibleColName}$scope.params.selectedColumns=$scope.params.selectedColumns.slice();$scope.params.selectedColumns.push(newColumnName);$scope.unionSchema.push({name:newColumnName,selected:true});$scope.params.virtualInputs.forEach(function(virtualInput){const inputColumns=$scope.getColumns(virtualInput.originLabel);if(inputColumns.some(col=>col.name===newColumnName)){virtualInput.columnsMatch.push(newColumnName)}else{virtualInput.columnsMatch.push("")}})};$scope.removeColumn=function(columnIndex){if(columnIndex>-1){const colName=$scope.params.selectedColumns[columnIndex];($scope.unionSchema.find(col=>col.name==colName)||{}).selected=false;$scope.params.virtualInputs.forEach(virtualInput=>{virtualInput.columnsMatch.splice(columnIndex,1)})}};$scope.reorderColumns=function(event){$scope.params.virtualInputs.forEach(virtualInput=>{moveItemInArray(virtualInput.columnsMatch,event.previousIndex,event.currentIndex)})};$scope.removeAllColumns=function(){$scope.params.selectedColumns=[];$scope.params.selectedColumnsIndexes=[];$scope.params.virtualInputs.forEach(virtualInput=>{virtualInput.columnsMatch=[]});$scope.unionSchema.forEach(column=>{column.selected=false})};$scope.sortableOptions={stop:function(e,ui){if(ui.item.sortable.dropindex!=null){moveSelectableColumn(ui.item.sortable.index,ui.item.sortable.dropindex)}},axis:"y",cursor:"move",cancel:"",handle:".handle-row"};function moveSelectableColumn(initialIndex,targetIndex){function shiftArray(inputArray,initialIndex,targetIndex){if(inputArray)inputArray.splice(targetIndex,0,inputArray.splice(initialIndex,1)[0])}shiftArray($scope.params.selectedColumns,initialIndex,targetIndex);shiftArray($scope.params.selectedColumnsIndexes,initialIndex,targetIndex);shiftArray($scope.selectedColumns,initialIndex,targetIndex);for(const virtualInput of $scope.params.virtualInputs){shiftArray(virtualInput.columnsMatch,initialIndex,targetIndex)}}$scope.useAsReference=function(referenceIndex){let selectedColumnsNames=[];$scope.params.copySchemaFromDatasetWithName=referenceIndex;let selectedColumns=$scope.getColumns($scope.params.copySchemaFromDatasetWithName);selectedColumnsNames=selectedColumns.map(col=>col.name);updateSelectableColumns();$scope.params.selectedColumns=selectedColumnsNames;$scope.selectedColumns=[];$scope.params.selectedColumnsIndexes=[];for(let index in selectedColumnsNames){$scope.selectedColumns.push({name:selectedColumnsNames[index],selected:true});$scope.params.selectedColumnsIndexes.push(index)}$scope.updateGlobalSelectionStatus()};$scope.syncSelectedColumns=function(){$scope.params.selectedColumns=[];$scope.params.selectedColumnsIndexes=[];for(let columnIndex=0;columnIndex<$scope.selectedColumns.length;columnIndex++){if(($scope.selectedColumns[columnIndex]||{}).selected){$scope.selectedColumns[columnIndex].name=$scope.selectedColumns[columnIndex].name||$scope.getSelectableColumns[columnIndex][0];$scope.params.selectedColumns.push($scope.selectedColumns[columnIndex].name);$scope.params.selectedColumnsIndexes.push(columnIndex);$scope.unionSchema[columnIndex].selected=true}else if($scope.unionSchema[columnIndex]){$scope.unionSchema[columnIndex].selected=false}}};function syncSelectors(){$scope.selectedColumns=[];for(let columnIndex in $scope.params.selectedColumns){let targetColumn=$scope.params.selectedColumnsIndexes[columnIndex];$scope.selectedColumns[targetColumn]={};$scope.selectedColumns[targetColumn].selected=true;$scope.selectedColumns[targetColumn].name=$scope.params.selectedColumns[columnIndex]}}$scope.updateNewSchema=function(obj){$scope.params.selectedColumns=[]};$scope.columnsSelection={};$scope.getDatasetNameFromRecipeInputIndex=function(index){var input=$scope.recipe.inputs.main.items[index];return input?input.ref:""};$scope.getDatasetColorClass=function(datasetIndex){return"dataset-color-"+datasetIndex%6};$scope.updateColumnsSelection=function(){updateUnionSchema();if(!$scope.params){return}if($scope.params.mode!="REMAP"){$scope.params.virtualInputs.forEach(vi=>{delete vi.columnsMatch})}let selectedColumnsNames=[];if($scope.params.mode=="CUSTOM"){selectedColumnsNames=$scope.params.selectedColumns}else if($scope.params.mode=="UNION"){selectedColumnsNames=$scope.unionSchema.map(function(col){return col.name})}else if($scope.params.mode=="FROM_DATASET"){$scope.params.copySchemaFromDatasetWithName=$scope.params.copySchemaFromDatasetWithName||$scope.recipe.inputs.main.items[0].ref;let selectedColumns=$scope.getColumns($scope.params.copySchemaFromDatasetWithName);selectedColumnsNames=selectedColumns.map(col=>col.name)}else if($scope.params.mode=="FROM_INDEX"){if($scope.params.selectedColumnsIndexes&&$scope.params.selectedColumns&&$scope.params.selectedColumnsIndexes.length==$scope.params.selectedColumns.length){selectedColumnsNames=$scope.params.selectedColumns}else{$scope.params.copySchemaFromDatasetWithName=$scope.params.copySchemaFromDatasetWithName||$scope.recipe.inputs.main.items[0].ref;let selectedColumns=$scope.getColumns($scope.params.copySchemaFromDatasetWithName);selectedColumnsNames=selectedColumns.map(col=>col.name);$scope.useAsReference($scope.params.copySchemaFromDatasetWithName)}updateSelectableColumns();syncSelectors();let maxColNb=0;for(let i=0;i<$scope.recipe.inputs.main.items.length;i++){maxColNb=Math.max(maxColNb,$scope.getColumns($scope.recipe.inputs.main.items[i].ref).length)}$scope.selectedColumns.forEach((col,idx)=>{if(idx>=maxColNb){col.selected=false}})}else if($scope.params.mode=="REMAP"){$scope.params.copySchemaFromDatasetWithName=$scope.params.copySchemaFromDatasetWithName||$scope.recipe.inputs.main.items[0].ref;$scope.columnsSelection.possibleColumnNames=$scope.columnsSelection.possibleColumnNames||[];let selectedColumns=$scope.getColumns($scope.params.copySchemaFromDatasetWithName);if($scope.params.selectedColumns){selectedColumnsNames=$scope.params.selectedColumns;$scope.unionSchema.forEach(col=>{col.selected=false})}else{selectedColumnsNames=selectedColumns.map(col=>col.name)}buildInitialColumnsMatch(selectedColumnsNames)}else if($scope.params.mode=="INTERSECT"){let allInputs=RecipesUtils.getFlatInputsList($scope.recipe);let selectedColumns=$scope.getColumns(allInputs[0].ref);selectedColumnsNames=selectedColumns.map(col=>col.name);for(var i=1;i<allInputs.length;i++){var columnNames=$scope.getColumns(allInputs[i].ref).map(function(col){return col.name});for(var c=selectedColumnsNames.length-1;c>=0;c--){if(columnNames.indexOf(selectedColumnsNames[c])<0){selectedColumnsNames.splice(c,1)}}}}$scope.params.selectedColumns=selectedColumnsNames;updateSelectedColumns();$scope.updateGlobalSelectionStatus()};$scope.isColumnsMatch=function(referenceColumns,selectedColumns){if(referenceColumns.length!=selectedColumns.length){return false}else{for(let columnIndex in referenceColumns){if(!referenceColumns[columnIndex]||!selectedColumns[columnIndex]||!(selectedColumns[columnIndex]===referenceColumns[columnIndex].name)){return false}}return true}};function updateSelectableColumns(){let selectableColumns=[];for(const input of $scope.params.virtualInputs){var inputColumns=$scope.getColumns(input.originLabel);for(let columnIndex in inputColumns){let thisInput={};if(selectableColumns[columnIndex])thisInput=selectableColumns[columnIndex];thisInput[inputColumns[columnIndex].name]=1;selectableColumns[columnIndex]=thisInput}}$scope.getSelectableColumns=selectableColumns.map(record=>{let column=[];for(var key in record){column.push(key)}return column})}function buildInitialColumnsMatch(selectedColumnsNames){for(const input of $scope.params.virtualInputs){const inputColumns=$scope.getColumns(input.originLabel);let columnsMatch=[];for(let indexColumn in selectedColumnsNames){if(input.columnsMatch&&indexColumn<input.columnsMatch.length){columnsMatch.push(input.columnsMatch[indexColumn])}else if(indexColumn<inputColumns.length){columnsMatch.push(inputColumns[indexColumn].name)}else{columnsMatch.push("")}}input.columnsMatch=columnsMatch}}function buildInitialColumnsMatchForInput(input){const inputColumns=$scope.getColumns(input.originLabel);let columnsMatch=[];for(let indexColumn in $scope.params.selectedColumns){if(indexColumn<inputColumns.length){columnsMatch.push(inputColumns[indexColumn].name)}else{columnsMatch.push("")}}input.columnsMatch=columnsMatch}function removeDatasets(virtualIndices){var updateRecipeInputs=function(index){var used=false;$scope.params.virtualInputs.forEach(function(vi){if(vi.index==index){used=true}});if(!used){RecipesUtils.removeInput($scope.recipe,"main",$scope.getDatasetNameFromRecipeInputIndex(index));$scope.params.virtualInputs.forEach(function(vi){if(vi.index>index){vi.index--}})}};virtualIndices.sort().reverse();virtualIndices.forEach(function(virtualIndex){var recipeInputsIndex=$scope.params.virtualInputs[virtualIndex].index;$scope.params.virtualInputs.splice(virtualIndex,1);updateRecipeInputs(recipeInputsIndex)});$scope.updateColumnsSelection();if($scope.params.mode=="FROM_INDEX"){$scope.syncSelectedColumns()}updateSelectableColumns();updateSelectedColumns();$scope.hooks.updateRecipeStatus()}function updateSelectedColumns(){if($scope.params.selectedColumns){$scope.unionSchema.forEach(col=>{col.selected=$scope.params.selectedColumns.indexOf(col.name)>=0})}}function updateUnionSchema(){$scope.flatInputRefs=[];var columns=[];var columnNames=[];$scope.unionSchema=$scope.unionSchema||[];RecipesUtils.getFlatInputsList($scope.recipe).forEach(function(input){$scope.flatInputRefs.push(input.ref);$scope.getColumns(input.ref).forEach(function(column){if(columnNames.indexOf(column.name)<0){columns.push(column);columnNames.push(column.name)}})});$scope.unionSchema=columns}$scope.uiState={currentStep:"selectedColumns"};$scope.enableAutoFixup();function onScriptChanged(nv,ov){if(nv){if($scope.script.data){$scope.params=JSON.parse($scope.script.data);$scope.updateColumnsSelection();visualCtrl.saveServerParams();$scope.updateGlobalSelectionStatus();$scope.hooks.updateRecipeStatus()}}}$scope.hooks.onRecipeLoaded=function(){Logger.info("On Recipe Loaded");$scope.$watch("script.data",onScriptChanged);$scope.$watch("recipe.inputs",function(){DatasetUtils.updateRecipeComputables($scope,$scope.recipe,$stateParams.projectKey,$stateParams.projectKey).then(_=>()=>$scope.updateColumnsSelection())},true);$scope.$watch("params.postFilter",$scope.updateRecipeStatusLater,true);$scope.$watch("params.virtualInputs",$scope.updateRecipeStatusLater,true);$scope.$watch("params.selectedColumns",$scope.updateRecipeStatusLater,true);$scope.$watch("params.mode",()=>$scope.updateColumnsSelection(),true);$scope.$watch("unionSchema",function(){$scope.updateRecipeStatusLater()},true);$scope.$watch("recipe.outputs",function(){var outputs=RecipesUtils.getOutputsForRole($scope.recipe,"main");if(outputs.length==1){$scope.outputDatasetName=outputs[0].ref}$scope.updateRecipeStatusLater()},true);$scope.updateColumnsSelection();onScriptChanged($scope.script.data)};$scope.specificControllerLoadedDeferred.resolve()});app.controller("NewVirtualInputController",function($scope,$stateParams,DatasetUtils){$scope.newInput={};$scope.isValid=function(){return!!$scope.newInput.dataset};$scope.addInput=function(){$scope.addDataset($scope.newInput.dataset)};DatasetUtils.listDatasetsUsabilityInAndOut($stateParams.projectKey,"vstack").then(function(data){$scope.availableInputDatasets=data[0]})})})();(function(){"use strict";var app=angular.module("dataiku.recipes");app.controller("AfgRecipeCreationController",function($scope,$controller,$stateParams,RecipeComputablesService){$scope.recipeType="generate_features";$scope.recipe={type:"generate_features",projectKey:$stateParams.projectKey,inputs:{main:{items:[]}},outputs:{main:{items:[]}}};RecipeComputablesService.getComputablesMap($scope.recipe,$scope).then(function(map){$scope.setComputablesMap(map)});$scope.inputDatasetsOnly=true;$controller("SingleOutputDatasetRecipeCreationController",{$scope:$scope});$scope.autosetName=function(){if($scope.io.inputDataset){const niceInputName=$scope.io.inputDataset.replace(/[A-Z]*\./,"");$scope.maybeSetNewDatasetName(niceInputName+"_feats")}};$scope.getCreationSettings=function(){let inputs=[];if($scope.io.inputDataset!==undefined){inputs.push($scope.io.inputDataset)}return{virtualInputs:inputs}};$scope.showOutputPane=function(){return!!$scope.io.inputDataset};$scope.$watchCollection("recipe.inputs.main.items",function(nv){if(nv&&nv.length){$scope.io.inputDataset=nv[0].ref}})});app.controller("AfgRecipeController",function($scope,$controller,$q,$stateParams,Logger,$timeout,CreateModalFromTemplate,RecipesUtils,AutoFeatureGenerationRecipeService,Dialogs,DatasetUtils,DataikuAPI){$scope.hooks.onRecipeLoaded=function(){Logger.info("On Recipe Loaded");$scope.$watch("script.data",onScriptChanged)};var visualCtrl=$controller("VisualRecipeEditorController",{$scope:$scope});$scope.specificControllerLoadedDeferred.resolve();let contextProjectKey=$scope.context&&$scope.context.projectKey?$scope.context.projectKey:$stateParams.projectKey;$scope.hooks.getPayloadData=function(){if(!$scope.params||Object.keys($scope.params).length===0)return;return angular.toJson($scope.params)};$scope.fixUpParams=function(params){const allColumns={};for(let i=0;i<params.virtualInputs.length;i++){allColumns[i]=$scope.getAfgColumns(AutoFeatureGenerationRecipeService.getDatasetName(i,params.virtualInputs,$scope.recipe.inputs))}AutoFeatureGenerationRecipeService.filterSelectedColumns(params,allColumns)};function onScriptChanged(nv,ov){if(nv){$scope.params=JSON.parse($scope.script.data);visualCtrl.saveServerParams();$scope.fixUpParams($scope.params);$scope.hooks.updateRecipeStatus()}}$scope.uiState={currentStep:"dataRelationships"};$scope.hooks.updateRecipeStatus=function(forceUpdate,exactPlan){var payload=$scope.hooks.getPayloadData();if(!payload){return $q.reject("payload not ready")}var deferred=$q.defer();$scope.updateRecipeStatusBase(forceUpdate,payload,{reallyNeedsExecutionPlan:exactPlan,exactPlan:exactPlan}).then(function(){if(!$scope.recipeStatus){return deferred.reject()}deferred.resolve($scope.recipeStatus)});return deferred.promise};$scope.$watchCollection("recipe.outputs.main.items",function(){const outputs=RecipesUtils.getOutputsForRole($scope.recipe,"main");if(outputs.length===1){$scope.outputDatasetName=outputs[0].ref}$scope.updateRecipeStatusLater()});$scope.getDateColumnsFromDataset=function(datasetName){const allColumns=$scope.getColumns(datasetName);return AutoFeatureGenerationRecipeService.getDateColumns(allColumns)};$scope.showNewDatasetModal=function(virtualIndex){$scope.creation=!$scope.params.virtualInputs||!$scope.params.virtualInputs.length;$scope.editTimeSettings=false;$scope.tableOneIndex=virtualIndex;$scope.tableTwoIndex=$scope.params.virtualInputs.length;CreateModalFromTemplate("/static/dataiku/auto-feature-generation/dataset-modal/dataset-modal.component.html",$scope)};$scope.showEditCutoffTimeModal=function(){$scope.creation=!$scope.params.virtualInputs||!$scope.params.virtualInputs.length;CreateModalFromTemplate("/static/dataiku/auto-feature-generation/cutoff-time-modal/cutoff-time-modal.component.html",$scope)};$scope.showEditTimeSettingsModal=function(index){$scope.creation=!$scope.params.virtualInputs||!$scope.params.virtualInputs.length;$scope.editTimeSettings=true;$scope.tableOneIndex=null;$scope.tableTwoIndex=index;$scope.timeIndexMode=$scope.timeIndexColumn?AutoFeatureGenerationRecipeService.TIME_INDEX_MODE.DATE_COLUMN.name:AutoFeatureGenerationRecipeService.TIME_INDEX_MODE.DEFAULT.name;CreateModalFromTemplate("/static/dataiku/auto-feature-generation/dataset-modal/dataset-modal.component.html",$scope)};$scope.disableEditTimeSettingsModal=function(virtualInputIndex){const datasetName=$scope.getDatasetName(virtualInputIndex);const hasDateColumns=AutoFeatureGenerationRecipeService.hasDateColumns(datasetName,$scope.computablesMap);return AutoFeatureGenerationRecipeService.disableTimeIndexEdition($scope.params.cutoffTime.mode,hasDateColumns,$scope.params.virtualInputs[virtualInputIndex].timeIndexColumn)};$scope.disableEditCutoffTimeModal=function(){const primaryDatasetName=$scope.getDatasetName(0);return!AutoFeatureGenerationRecipeService.hasDateColumns(primaryDatasetName,$scope.computablesMap)&&$scope.params.cutoffTime.mode!==AutoFeatureGenerationRecipeService.CUTOFF_TIME_MODE.DATE_COLUMN.name};$scope.setCutoffTimeTooltip=function(){return $scope.disableEditCutoffTimeModal()?"No date columns found.":null};$scope.setTimeIndexTooltip=function(virtualInputIndex){const datasetName=$scope.getDatasetName(virtualInputIndex);const hasDateColumns=AutoFeatureGenerationRecipeService.hasDateColumns(datasetName,$scope.computablesMap);if(!hasDateColumns){return"No date columns found."}else if(!AutoFeatureGenerationRecipeService.isCutoffTimeDate($scope.params.cutoffTime.mode)){return"Cutoff time is required to configure enrichment dataset time settings."}return null};$scope.isCutoffTimeShown=function(){return AutoFeatureGenerationRecipeService.isCutoffTimeShown($scope.params.virtualInputs.length,$scope.params.cutoffTime.mode)};$scope.isTimeIndexDefined=function(index){if(index<$scope.params.virtualInputs.length&&$scope.params.virtualInputs[index].timeIndexColumn){return true}return false};$scope.getTimeIndexValue=function(index){if(index<$scope.params.virtualInputs.length&&$scope.params.virtualInputs[index].timeIndexColumn){return $scope.params.virtualInputs[index].timeIndexColumn}return AutoFeatureGenerationRecipeService.TIME_INDEX_MODE.DEFAULT.label};$scope.isTimeWindowDefined=function(index){return $scope.params.virtualInputs[index].timeWindows.length};$scope.getTimeWindowValue=function(index){const timeWindow=$scope.params.virtualInputs[index].timeWindows[0];return timeWindow.from+" to "+timeWindow.to+" "+AutoFeatureGenerationRecipeService.TIME_UNITS[timeWindow.windowUnit].label+" before cutoff time"};$scope.isCutoffTimeDefined=function(){if($scope.params.virtualInputs.length&&$scope.params.virtualInputs[0].timeIndexColumn){return true}return false};$scope.getCutoffTimeValue=function(){if($scope.params.virtualInputs.length&&$scope.params.virtualInputs[0].timeIndexColumn){return $scope.params.virtualInputs[0].timeIndexColumn}return AutoFeatureGenerationRecipeService.CUTOFF_TIME_MODE.DEFAULT.label};$scope.relationshipDesc=AutoFeatureGenerationRecipeService.relationshipDesc;$scope.getAfgColumns=function(datasetName){return angular.copy($scope.getColumns(datasetName))};$scope.getDatasetsList=function(){return AutoFeatureGenerationRecipeService.getUsedDatasets($scope.params.virtualInputs,$scope.recipe.inputs)};$scope.addEmptyCondition=function(relationship,current){const newCondition={column1:{table:relationship.table1,name:$scope.getAfgColumns($scope.getDatasetName(relationship.table1))[0].name},column2:{table:relationship.table2,name:$scope.getAfgColumns($scope.getDatasetName(relationship.table2))[0].name},type:"EQ"};relationship.on=relationship.on||[];relationship.on.push(newCondition);if(current){current.condition=newCondition}if(relationship.on.length===1){$scope.hooks.updateRecipeStatus()}};$scope.removeCondition=function(scope,relationship,condition){if(scope.current&&scope.current.condition===condition){scope.current.condition=null}const index=relationship.on.indexOf(condition);relationship.on.splice(index,1);$scope.hooks.updateRecipeStatus()};$scope.removeAllConditions=function(scope,relationship){if(scope.current!=null){scope.current.condition=null}relationship.on=[];$scope.hooks.updateRecipeStatus()};const removeDatasets=function(virtualIndexes,deletedDatasetVirtualIndex){AutoFeatureGenerationRecipeService.removeDatasets(virtualIndexes,deletedDatasetVirtualIndex,$scope.params,$scope.recipe,$scope.columnsTabData)};$scope.removeDataset=function(virtualIndex){let datasetsToBeRemoved=[];if($scope.params.virtualInputs.length>2){datasetsToBeRemoved=AutoFeatureGenerationRecipeService.getDependantDatasets(virtualIndex,$scope.params.relationships)}datasetsToBeRemoved.push(virtualIndex);if(datasetsToBeRemoved.length===1){removeDatasets(datasetsToBeRemoved,virtualIndex);if($scope.params.virtualInputs.length===0){$scope.showNewDatasetModal(0)}}else{const datasetList=datasetsToBeRemoved.map(function(index){return $scope.getDatasetName(index)});Dialogs.confirm($scope,"Remove datasets","The following datasets will be removed from the recipe:"+"<ul><li>"+datasetList.join("</li><li>")+"</li></ul>").then(function(){removeDatasets(datasetsToBeRemoved,virtualIndex);if($scope.params.virtualInputs.length===0){$scope.showNewDatasetModal(0)}})}$scope.hooks.updateRecipeStatus()};$scope.range=AutoFeatureGenerationRecipeService.range;$scope.getDatasetName=function(virtualIndex){return AutoFeatureGenerationRecipeService.getDatasetName(virtualIndex,$scope.params.virtualInputs,$scope.recipe.inputs)};$scope.showRelationshipEditModal=function(relationship,tab){const newScope=$scope.$new();newScope.relationship=relationship;newScope.current={};newScope.current.tab=tab||"conditions";newScope.current.condition=null;CreateModalFromTemplate("/templates/recipes/visual-recipes-fragments/relationship-edit-modal.html",newScope,"RelationshipEditController",(scope,el)=>{$timeout(()=>{scope.AfgBlockBodyEl=el[0].getElementsByClassName("modal-body")[0]})})};$scope.getDatasetColorClass=AutoFeatureGenerationRecipeService.getDatasetColorClass;$scope.getLeftSymbol=AutoFeatureGenerationRecipeService.getLeftSymbolFromRelationship;$scope.getRightSymbol=AutoFeatureGenerationRecipeService.getRightSymbolFromRelationship;$scope.getRelationshipStyle=AutoFeatureGenerationRecipeService.getRelationshipClass;$scope.params=$scope.params||{};$scope.columnsTabData=AutoFeatureGenerationRecipeService.getDefaultColumnsTabData($scope.recipe);$scope.toggleColumnsForComputation=function(datasetId){$scope.columnsTabData[datasetId].isSectionOpen=!$scope.columnsTabData[datasetId].isSectionOpen};$scope.updateSelectedColumns=function(datasetId,selectedColumns){$scope.columnsTabData[datasetId].selectedColumns=angular.copy(selectedColumns);$scope.updateRecipeStatusLater(700)};$scope.updateSelectedFeatures=function(){$scope.updateRecipeStatusLater(700)};$scope.getAvailableReplacementDatasets=function(datasets){const primaryDatasetName=AutoFeatureGenerationRecipeService.getDatasetName(0,$scope.params.virtualInputs,$scope.recipe.inputs);const primaryDataset=$scope.computablesMap[primaryDatasetName];return AutoFeatureGenerationRecipeService.checkDatasetsUsability(datasets,primaryDataset,$scope.outputDatasetName,$scope.recipe,$scope.appConfig&&$scope.appConfig.sparkEnabled?$scope.appConfig.sparkEnabled:false)};$scope.onInputReplaced=function(replacement,virtualIndex){const recipeInputs=$scope.recipe.inputs;const oldInput=angular.copy($scope.params.virtualInputs[virtualIndex]);const recipeSerialized=angular.copy($scope.recipe);const payload=$scope.hooks.getPayloadData();let columnsForComputation=[];DataikuAPI.flow.recipes.autofeaturegeneration.getDefaultColumns($stateParams.projectKey,replacement.name,recipeSerialized,payload).success(function(defaultColumns){columnsForComputation=defaultColumns}).error(setErrorInScope.bind($scope)).finally(function(){AutoFeatureGenerationRecipeService.replaceVirtualInput($scope.params,virtualIndex,replacement.name,$scope.computablesMap,recipeInputs);$scope.params.virtualInputs[virtualIndex].selectedColumns=columnsForComputation;$scope.columnsTabData=AutoFeatureGenerationRecipeService.getDefaultColumnsTabData($scope.recipe);DatasetUtils.updateRecipeComputables($scope,$scope.recipe,$stateParams.projectKey,contextProjectKey).then(function(){AutoFeatureGenerationRecipeService.resyncSchemas($scope.params,virtualIndex,$scope.computablesMap,recipeInputs,oldInput);$scope.hooks.updateRecipeStatus()})})};$scope.$watch("topNav.tab",function(nv,ov){if(nv==="settings"){$scope.$broadcast("repaintFatTable")}})});app.controller("RelationshipEditController",function($scope){$scope.uiState=$scope.uiState||{};if($scope.relationship.on.length===0){$scope.addEmptyCondition($scope.relationship);$scope.current.condition=$scope.relationship.on[0]}$scope.getColumn=function(condition,columnIdx){const col=!columnIdx||columnIdx===1?"column1":"column2";return $scope.getColumnFromName($scope.getDatasetName(condition[col].table),condition[col].name)};$scope.getColumnFromName=function(datasetName,name){return $scope.getAfgColumns(datasetName).filter(function(col){return col.name===name})[0]};$scope.ok=function(){$scope.dismiss();$scope.hooks.updateRecipeStatus()};$scope.$on("$destroy",function(){$scope.hooks.updateRecipeStatus()})});app.directive("afgBlockEmpty",function(){return{restrict:"EA",scope:true,templateUrl:"/templates/recipes/fragments/afg-block-empty.html"}});app.directive("afgBlockDropdownRelationship",function(AutoFeatureGenerationRecipeService){return{restrict:"EA",scope:true,templateUrl:"/templates/recipes/fragments/afg-block-dropdown-relationship.html",link:function(scope,element,attrs){scope.relationshipTypes=AutoFeatureGenerationRecipeService.SUPPORTED_RELATIONSHIP_TYPES;scope.relationshipIndex=attrs.relationshipIndex;scope.setRelationshipType=function(relationship,type){relationship.type=type;scope.hooks.updateRecipeStatus()};scope.getRelationshipTypeLabel=function(relationship){const relationshipDescription=AutoFeatureGenerationRecipeService.getRelationshipDescription(relationship);return relationshipDescription.type};scope.getRelationshipTypeDescription=function(relationship){const relationshipDescription=AutoFeatureGenerationRecipeService.getRelationshipDescription(relationship);return relationshipDescription.description};scope.getClass=function(type){return`{selected: relationship.type === '${type}'}`}}}});app.directive("afgConditionsEditor",function(){return{restrict:"EA",scope:true,templateUrl:"/templates/recipes/fragments/afg-conditions-editor.html"}});app.directive("afgCondition",function(){return{restrict:"EA",scope:true,templateUrl:"/templates/recipes/fragments/afg-condition.html",link:function(scope,element,attrs){scope.relationshipIndex=attrs.relationshipIndex;scope.displayRightActions=attrs.displayRightActions;scope.actOnConditionClicked=attrs.actOnConditionClicked;scope.toggleConditionFocus=function(condition){if(scope.current.condition===condition){scope.current.condition=null}else{scope.current.condition=condition}}}}});app.directive("afgBlockWithRelationship",function(){return{restrict:"EA",scope:true,templateUrl:"/templates/recipes/fragments/afg-block-with-relationship.html",link:function(scope,element,attrs){scope.relationshipIndex=attrs.relationshipIndex}}})})();(function(){"use strict";var services=angular.module("dataiku.services");services.factory("RangeExpressions",function(Expressions){var dateFormats={dateWithTimeFormat:"YYYY-MM-DD HH:mm",dateFormat:"YYYY-MM-DD"};function switchOpenCloseComparisonOperator(operator){if(!operator)return null;if(operator.search("<=")>-1)return operator.replace("<=","< ");if(operator.search(">=")>-1)return operator.replace(">=","> ");if(operator.search("<")>-1)return operator.replace("< ","<=");if(operator.search(">")>-1)return operator.replace("> ",">=");return null}function isOpenComparisonOperator(operator){if(!operator)return false;return operator.search("=")==-1}function getTypeComparisonOperator(operator){if(!operator)return;if(operator.search(">")>-1)return"min";if(operator.search("<")>-1)return"max"}function modifyColTypeInComparisonOperator(operator,colType){if(!operator)return;return initializeComparisonOperator(colType,getTypeComparisonOperator(operator),isOpenComparisonOperator(operator))}function initializeComparisonOperator(colType,comparisonType,open){var colGenericType=Expressions.genericType(colType);var initOperatorDic={min:">  ",max:"<  "};var genericTypeDic={num:"number",date:"date"};var operator=initOperatorDic[comparisonType]+"["+genericTypeDic[colGenericType]+"]";if(!open){operator=switchOpenCloseComparisonOperator(operator)}return operator}function setValuesFromOtherCondition(condition,otherCondition,colType){var colGenericType=Expressions.genericType(colType);var valuesToSet={num:["num"],date:["date","time"]};var fieldsToSet=valuesToSet[colGenericType];if(!fieldsToSet)return;fieldsToSet.forEach(function(field){condition[field]=otherCondition[field]})}function indexOfComparisonType(conditions,comparisonType){if(!conditions)return-1;for(var i=0;i<conditions.length;i++){var condition=conditions[i];if(!condition||!condition.operator)return;if(getTypeComparisonOperator(condition.operator)==comparisonType){return i}}return-1}function getRangeConditions(splits,splitIndex){if(!(splits&&splits[splitIndex]))return;var split=splits[splitIndex];if(!(split.filter&&split.filter.uiData&&split.filter.uiData.conditions))return;return split.filter.uiData.conditions}function indexOfMinCond(splits,splitIndex){var conditions=getRangeConditions(splits,splitIndex);if(!conditions)return-1;return indexOfComparisonType(conditions,"min")}function getMinCond(splits,splitIndex){var conditions=getRangeConditions(splits,splitIndex);var index=indexOfComparisonType(conditions,"min");if(index===-1||!conditions[index])return;return conditions[index]}function hasMinCond(splits,splitIndex){return indexOfMinCond(splits,splitIndex)>-1}function indexOfMaxCond(splits,splitIndex){var conditions=getRangeConditions(splits,splitIndex);if(!conditions)return-1;return indexOfComparisonType(conditions,"max")}function getMaxCond(splits,splitIndex){var conditions=getRangeConditions(splits,splitIndex);var index=indexOfComparisonType(conditions,"max");if(index===-1||!conditions[index])return;return conditions[index]}function hasMaxCond(splits,splitIndex){return indexOfMaxCond(splits,splitIndex)>-1}function createCondition(isOpen,comparisonType,colType,inputCol){var operator=initializeComparisonOperator(colType,comparisonType,isOpen);return{input:inputCol,operator:operator}}function getValuesFromCond(condition,colType){if(!condition)return;var colGenericType=Expressions.genericType(colType);if(colGenericType=="num"){return condition.num}else if(colGenericType=="date"){if(!condition.date||!condition.time)return;return moment(condition.date+" "+condition.time,"YYYY-MM-DD HH:mm").toDate()}}return{dateFormats:dateFormats,switchOpenCloseComparisonOperator:switchOpenCloseComparisonOperator,isOpenComparisonOperator:isOpenComparisonOperator,initializeComparisonOperator:initializeComparisonOperator,modifyColTypeInComparisonOperator:modifyColTypeInComparisonOperator,setValuesFromOtherCondition:setValuesFromOtherCondition,getTypeComparisonOperator:getTypeComparisonOperator,getRangeConditions:getRangeConditions,indexOfMaxCond:indexOfMaxCond,indexOfMinCond:indexOfMinCond,getMinCond:getMinCond,getMaxCond:getMaxCond,hasMinCond:hasMinCond,hasMaxCond:hasMaxCond,createCondition:createCondition,getValuesFromCond:getValuesFromCond}});services.factory("GaugeHelper",function(Fn){var spaceToInfinity=100;var spaceMinEqualsMax=10;function getValuesModified(data,index,getValuesFn,min,max){var values=getValuesFn(data,index);if(!values)return;var minMaxValue=getMinMaxValue(data,getValuesFn,min,max);if(!minMaxValue)return;var isArrayOfArrays=angular.isArray(values[0]);if(!isArrayOfArrays){return computeValues(values,minMaxValue)}else{return values.map(function(v){return computeValues(v,minMaxValue)})}}function computeValues(values,minMaxValue){var convertedValues=[];convertedValues[0]=values[0]==-Infinity?minMaxValue.min-spaceToInfinity:values[0];convertedValues[1]=values[1]==+Infinity?minMaxValue.max+spaceToInfinity:values[1];return convertedValues}function getMinMaxValue(data,getValuesFn,min,max){var mustFindMin=true;var mustFindMax=true;var hasInfinityMin=false;var hasInfinityMax=false;var maxValue=null;var minValue=null;if(min!=null){mustFindMin=false;minValue=min}if(max!=null){mustFindMax=false;maxValue=max}if(!data)return;if(mustFindMin||mustFindMax){for(var i=0;i<data.length;i++){var values=getValuesFn(data,i);if(!values)continue;values=[].concat.apply([],values);if(Fn.inArray(values)(-Infinity)){hasInfinityMin=true}if(Fn.inArray(values)(Infinity)){hasInfinityMax=true}values=values.filter(function(v){return Math.abs(v)!=Infinity});var tmpMax=Math.max(...values);var tmpMin=Math.min(...values);if(mustFindMax&&(maxValue==null||maxValue<tmpMax)){maxValue=tmpMax}if(mustFindMin&&(minValue==null||minValue>tmpMin)){minValue=tmpMin}}}return{min:minValue,max:maxValue,hasInfinityMin:hasInfinityMin,hasInfinityMax:hasInfinityMax}}function buildScale(extremities,width){var minValue=extremities.min;var maxValue=extremities.max;if(extremities.min!=null&&extremities.min==extremities.max){minValue-=spaceMinEqualsMax;maxValue+=spaceMinEqualsMax}var axisRange=[minValue,maxValue];var range=[0,width];if(extremities.hasInfinityMin){range.splice(1,0,width/4);axisRange.unshift(extremities.min-spaceToInfinity)}if(extremities.hasInfinityMax){range.splice(-1,0,3*width/4);axisRange.push(extremities.max+spaceToInfinity)}var scale=d3.scale.linear().domain(axisRange).range(range);return scale}return{getValuesModified:getValuesModified,getMinMaxValue:getMinMaxValue,buildScale:buildScale}})})();(function(){"use strict";var widgets=angular.module("dataiku.directives.widgets");widgets.directive("splitSharesSelector",function(){return{scope:true,templateUrl:"/templates/recipes/fragments/split-shares-selector.html",link:function($scope,element,attrs){$scope.getSelectedSplits=function(){return $scope.getSplits(attrs.selectedMode)};$scope.getMaxShare=function(currentIndex){var splits=$scope.getSelectedSplits();var cumulatedShare=0;for(var i=0;i<splits.length;i++){if(i!=currentIndex){cumulatedShare+=splits[i].share}}return cumulatedShare>100?0:100-cumulatedShare};$scope.addShare=function(splitIndex){var splits=$scope.getSelectedSplits();var share=100;for(var i=0;i<splitIndex;i++){share-=splits[i].share}share=Math.max(share,0);splits.splice(splitIndex,0,{share:share,outputIndex:0})};$scope.removeShare=function(splitIndex){var splits=$scope.getSelectedSplits();splits.splice(splitIndex,1)};$scope.getShareFromIndex=function(splits,splitIndex){if(!splits)return;if(splitIndex>-1||splits[splitIndex]){if(splits[splitIndex].share==null)return null;var previousCumulatedShare=0;for(var i=0;i<splitIndex;i++){previousCumulatedShare+=splits[i].share}return[previousCumulatedShare,previousCumulatedShare+splits[splitIndex].share]}if(splitIndex==-1){var totalShare=splits.reduce(function(memo,split){return memo+(split.share!=null?split.share:0)},0);return totalShare<100?[[totalShare,100]]:[[100,100]]}};$scope.getRemainingShare=function(){var splits=$scope.getSelectedSplits();if(!splits)return;var totalShare=splits.reduce(function(memo,split){return memo+(split.share!=null?split.share:0)},0);return Math.max(100-totalShare,0)};function getShareInInterval(newValue,splits,index){var totalShareWithoutIndex=splits.reduce(function(mem,split,i){if(i!=index){return mem+split.share}else{return mem}},0);return Math.max(Math.min(newValue,100-totalShareWithoutIndex),0)}$scope.updateShareFromIndex=function(splits,splitIndex,min,max){if(!splits||!splits[splitIndex])return;var newShare=Math.max(Math.floor(max-min),0);var previousTotalShare=splits.reduce(function(mem,split){return mem+split.share},0);var shareToDispatch=newShare-splits[splitIndex].share;splits[splitIndex].share=newShare;var numImpactedSplits=splits.length-splitIndex-1;if(numImpactedSplits>=1&&(previousTotalShare+shareToDispatch>100||shareToDispatch<0)){var impactShare=null;if(shareToDispatch>0){impactShare=Math.ceil(shareToDispatch/numImpactedSplits)}else{impactShare=-Math.floor(-shareToDispatch/numImpactedSplits)}var previousShare=null;var cumulatedImpactShare=0;for(var i=splitIndex+1;i<splits.length-1;i++){previousShare=splits[i].share;splits[i].share=getShareInInterval(splits[i].share-impactShare,splits,i);cumulatedImpactShare+=splits[i].share-previousShare}splits[splits.length-1].share=getShareInInterval(splits[splits.length-1].share-(shareToDispatch-cumulatedImpactShare),splits,splits.length-1)}}}}});widgets.directive("rangeBracket",function(RangeExpressions){return{scope:{type:"=",rangeIndex:"=",ranges:"=",isValidCol:"="},template:'<button class="btn btn--icon btn--secondary bracket" ng-click="switchExtremity()" ng-if="isOpeningBracket()" title="{{isOpenExtremity() ? \'Exclude\' : \'Include\'}}" data-toggle="tooltip" data-placement="top">[</button>'+'<button class="btn btn--icon btn--secondary bracket" ng-click="switchExtremity()" ng-if="isClosingBracket()" title="{{isOpenExtremity() ? \'Exclude\' : \'Include\'}}" data-toggle="tooltip" data-placement="top">]</button>',link:function($scope){function getExtremity(){return getExtremityFromIndexAndType($scope.rangeIndex,$scope.type)}function getExtremityFromIndexAndType(index,extremityType){if(extremityType=="min"){return RangeExpressions.getMinCond($scope.ranges,index)}if(extremityType=="max"){return RangeExpressions.getMaxCond($scope.ranges,index)}return null}function getConnectedExtremity(){if($scope.type=="min"){return getExtremityFromIndexAndType($scope.rangeIndex-1,"max")}if($scope.type=="max"){return getExtremityFromIndexAndType($scope.rangeIndex+1,"min")}return null}function isDefined(){if(!$scope.isValidCol)return false;if($scope.type=="min"){return RangeExpressions.hasMinCond($scope.ranges,$scope.rangeIndex)}if($scope.type=="max"){return RangeExpressions.hasMaxCond($scope.ranges,$scope.rangeIndex)}}$scope.switchExtremity=function(){var extremity=getExtremity();var connectedExtremity=getConnectedExtremity();if(extremity){extremity.operator=RangeExpressions.switchOpenCloseComparisonOperator(extremity.operator)}if(connectedExtremity){connectedExtremity.operator=RangeExpressions.switchOpenCloseComparisonOperator(connectedExtremity.operator)}};$scope.isOpenExtremity=function(){var extremity=getExtremity();return RangeExpressions.isOpenComparisonOperator(extremity.operator)};$scope.isOpeningBracket=function(){if(!isDefined())return false;var extremity=getExtremity();var hasExtremity=extremity&&extremity.operator;var isMinClosedExtremity=$scope.type==="min"&&!$scope.isOpenExtremity();var isMaxOpenExtremity=$scope.type==="max"&&$scope.isOpenExtremity();return hasExtremity&&(isMinClosedExtremity||isMaxOpenExtremity)};$scope.isClosingBracket=function(){if(!isDefined())return false;var extremity=getExtremity();var hasExtremity=extremity&&extremity.operator;var isMinOpenExtremity=$scope.type==="min"&&$scope.isOpenExtremity();var isMaxClosedExtremity=$scope.type==="max"&&!$scope.isOpenExtremity();return hasExtremity&&(isMinOpenExtremity||isMaxClosedExtremity)}}}});widgets.directive("splitRangesSelector",function(Assert,Expressions,RangeExpressions){return{scope:true,templateUrl:"/templates/recipes/fragments/split-ranges-selector.html",link:function($scope,element,attrs){$scope.getSelectedSplits=function(){return $scope.getSplits(attrs.selectedMode)};$scope.getRangeColType=function(){return $scope.getColType($scope.params.column)};$scope.getRangeColGenericType=function(){return Expressions.genericType($scope.getRangeColType())};$scope.rangeInputsClass=function(){return"input-"+$scope.getRangeColGenericType()};$scope.createMinCondition=function(isOpen){return RangeExpressions.createCondition(isOpen,"min",$scope.getRangeColType(),$scope.params.column)};$scope.createMaxCondition=function(isOpen){return RangeExpressions.createCondition(isOpen,"max",$scope.getRangeColType(),$scope.params.column)};$scope.addRangeSplit=function(splitIndex){let splits=$scope.getSelectedSplits();let conditions=[];let genericType=$scope.getRangeColGenericType();let maxPreviousCond=null;let isOpenPreviousCond=false;let minCondition;if(genericType==="date"){if(RangeExpressions.hasMaxCond(splits,splitIndex-1)){maxPreviousCond=RangeExpressions.getMaxCond(splits,splitIndex-1);isOpenPreviousCond=maxPreviousCond&&RangeExpressions.isOpenComparisonOperator(maxPreviousCond.operator)}minCondition=$scope.createMinCondition(!isOpenPreviousCond);var maxCondition=$scope.createMaxCondition(false);conditions=[minCondition,maxCondition]}else if(genericType==="num"&&splitIndex>0){if(!RangeExpressions.hasMaxCond(splits,splitIndex-1)){maxPreviousCond=$scope.createMaxCondition(false);var previousConditions=RangeExpressions.getRangeConditions(splits,splitIndex-1);previousConditions.push(maxPreviousCond)}else{maxPreviousCond=RangeExpressions.getMaxCond(splits,splitIndex-1)}isOpenPreviousCond=maxPreviousCond&&RangeExpressions.isOpenComparisonOperator(maxPreviousCond.operator);minCondition=$scope.createMinCondition(!isOpenPreviousCond);conditions=[minCondition]}let newRange=$scope.getNewRangeSplit(conditions);if(maxPreviousCond){RangeExpressions.setValuesFromOtherCondition(minCondition,maxPreviousCond,$scope.getRangeColType());if(genericType==="date"){RangeExpressions.setValuesFromOtherCondition(maxCondition,maxPreviousCond,$scope.getRangeColType())}}else if(genericType==="date"){Assert.trueish(minCondition,"minCondition");Assert.trueish(maxCondition,"maxCondition");let today=moment().format(RangeExpressions.dateFormats["dateFormat"]);let time="00:00";minCondition.date=today;minCondition.time=time;maxCondition.date=today;maxCondition.date=time}splits.splice(splitIndex,0,newRange)};$scope.removeRangeSplit=function(splitIndex){var splits=$scope.getSelectedSplits();splits.splice(splitIndex,1)};$scope.getRangeFromIndex=function(splits,splitIndex){if(splitIndex>-1){var minValue=-Infinity;if(RangeExpressions.hasMinCond(splits,splitIndex)){var minCond=RangeExpressions.getMinCond(splits,splitIndex);minValue=RangeExpressions.getValuesFromCond(minCond,$scope.getRangeColType());if(minValue==null){return null}}var maxValue=Infinity;if(RangeExpressions.hasMaxCond(splits,splitIndex)){var maxCond=RangeExpressions.getMaxCond(splits,splitIndex);maxValue=RangeExpressions.getValuesFromCond(maxCond,$scope.getRangeColType());if(maxValue==null){return null}}if(minValue>maxValue)return null;return[[minValue,maxValue]]}else if(splitIndex==-1){var ranges=[];for(var i=0;i<splits.length;i++){ranges.push($scope.getRangeFromIndex(splits,i))}ranges=ranges.filter(function(values){return values!=null}).map(function(values){return[].concat.apply([],values)}).sort(function(v1,v2){return v1[0]<v2[0]?-1:1});if(ranges.length==0)return;var disjointAggRanges=[];var currentAggRange=ranges[0];for(var j=1;j<ranges.length;j++){if(currentAggRange[1]>=ranges[j][0]){currentAggRange[1]=Math.max(currentAggRange[1],ranges[j][1])}else{disjointAggRanges.push(currentAggRange);currentAggRange=ranges[j]}}disjointAggRanges.push(currentAggRange);var remainingValues=[];for(var k=0;k<disjointAggRanges.length-1;k++){remainingValues.push([disjointAggRanges[k][1],disjointAggRanges[k+1][0]])}return remainingValues.length>0?remainingValues:null}};var unregisterDateRangeWatch=$scope.$watch(function(){var isDateColumn=Expressions.genericType($scope.getColType($scope.params.column))==="date";return $scope.params.mode==="RANGE"&&isDateColumn},function(shouldInitialize){if(!shouldInitialize)return;var hasMoreThanOneSplit=$scope.params.rangeSplits&&$scope.params.rangeSplits.length>1;var conditionsOfFirstSplit=RangeExpressions.getRangeConditions($scope.params.rangeSplits,0);var firstSplitHasConditions=conditionsOfFirstSplit&&conditionsOfFirstSplit.length>0;if(hasMoreThanOneSplit||firstSplitHasConditions){unregisterDateRangeWatch();return}var conditions=$scope.getConditionsForFirstDateSplit($scope.params.column);$scope.params.rangeSplits=[$scope.getNewRangeSplit(conditions)];unregisterDateRangeWatch()})}}});widgets.directive("rangeInputs",function(Expressions,RangeExpressions,$timeout){return{scope:{ranges:"=",rangeIndex:"=",column:"=",colType:"=",setTime:"=",isValidCol:"="},templateUrl:"/templates/recipes/fragments/range-inputs.html",link:function($scope,element){$scope.getDateFormat=function(){if($scope.setTime){return RangeExpressions.dateFormats["dateWithTimeFormat"]}else{return RangeExpressions.dateFormats["dateFormat"]}};$scope.hasMinCond=function(){return RangeExpressions.hasMinCond($scope.ranges,$scope.rangeIndex)};$scope.getMinCond=function(){return RangeExpressions.getMinCond($scope.ranges,$scope.rangeIndex)};$scope.getMaxCond=function(){return RangeExpressions.getMaxCond($scope.ranges,$scope.rangeIndex)};$scope.hasMaxCond=function(){return RangeExpressions.hasMaxCond($scope.ranges,$scope.rangeIndex)};$scope.getGenericColType=function(){return Expressions.genericType($scope.colType)};$scope.deleteMinIfNecessary=function(currentValue){var shouldDeleteMin=$scope.rangeIndex==0;if(shouldDeleteMin&&currentValue==null){var conditions=RangeExpressions.getRangeConditions($scope.ranges,$scope.rangeIndex);var index=RangeExpressions.indexOfMinCond($scope.ranges,$scope.rangeIndex);if(index>-1){conditions.splice(index,1)}}};$scope.deleteMaxIfNecessary=function(currentValue){var shouldDeleteMax=$scope.ranges&&$scope.rangeIndex==$scope.ranges.length-1;if(shouldDeleteMax&&currentValue==null){var conditions=RangeExpressions.getRangeConditions($scope.ranges,$scope.rangeIndex);var index=RangeExpressions.indexOfMaxCond($scope.ranges,$scope.rangeIndex);if(index>-1){conditions.splice(index,1)}}};$scope.createMinCondition=function(){var conditions=RangeExpressions.getRangeConditions($scope.ranges,$scope.rangeIndex);if(!$scope.hasMinCond()){var minCond=RangeExpressions.createCondition(false,"min",$scope.colType,$scope.column);conditions.unshift(minCond);$timeout(function(){$("#inputMin"+$scope.rangeIndex).focus()},0)}};$scope.createMaxCondition=function(){var conditions=RangeExpressions.getRangeConditions($scope.ranges,$scope.rangeIndex);if(!$scope.hasMaxCond()){var maxCond=RangeExpressions.createCondition(true,"max",$scope.colType,$scope.column);conditions.push(maxCond);$timeout(function(){$("#inputMax"+$scope.rangeIndex).focus()},0)}};function syncFrontDatesWithConditions(){var minCond=$scope.getMinCond();if(minCond&&minCond.frontDate){minCond.date=moment(minCond.frontDate,$scope.getDateFormat()).format("YYYY-MM-DD");minCond.time=$scope.setTime?moment(minCond.frontDate,$scope.getDateFormat()).format("HH:mm"):"00:00"}var maxCond=$scope.getMaxCond();if(maxCond&&maxCond.frontDate){maxCond.date=moment(maxCond.frontDate,$scope.getDateFormat()).format("YYYY-MM-DD");maxCond.time=$scope.setTime?moment(maxCond.frontDate,$scope.getDateFormat()).format("HH:mm"):"00:00"}}function syncConditionsWithFrontDates(){var minCond=$scope.getMinCond();if(minCond&&minCond.date&&minCond.time){minCond.frontDate=moment(minCond.date+" "+minCond.time,RangeExpressions.dateFormats["dateWithTimeFormat"]).format($scope.getDateFormat())}var maxCond=$scope.getMaxCond();if(maxCond&&maxCond.date&&maxCond.time){maxCond.frontDate=moment(maxCond.date+" "+maxCond.time,RangeExpressions.dateFormats["dateWithTimeFormat"]).format($scope.getDateFormat())}}$scope.$watch(function(){var toWatch={};var minCond=$scope.getMinCond();var maxCond=$scope.getMaxCond();if(minCond){toWatch.min=minCond.frontDate}if(maxCond){toWatch.max=maxCond.frontDate}return toWatch},syncFrontDatesWithConditions,true);syncConditionsWithFrontDates()}}});widgets.directive("splitGauge",function(GaugeHelper){return{restrict:"A",template:"<svg class='split-gauge'></svg>",scope:{data:"=",getValuesFn:"=",index:"=",max:"=",min:"="},replace:true,link:function($scope,element,attrs){var gaugeSvg=d3.select(element[0]);var gaugeG=gaugeSvg.append("g").attr("class","x brush");var width=$(element).innerWidth();var height=$(element).innerHeight();gaugeG.append("rect").attr("class","gauge-background").attr("width",width).attr("height",height).attr("fill","#f0f1f1");var xScale=null;function buildGauge(){if($scope.data==null||$scope.index==null)return;var rectData=GaugeHelper.getValuesModified($scope.data,$scope.index,$scope.getValuesFn,$scope.min,$scope.max);if(!rectData){gaugeG.selectAll(".extent").remove();return}width=$(element).innerWidth();var extremities=GaugeHelper.getMinMaxValue($scope.data,$scope.getValuesFn,$scope.min,$scope.max);xScale=GaugeHelper.buildScale(extremities,width);gaugeG.selectAll(".extent").data(rectData).enter().append("rect").attr("class","extent").attr("x",function(d){return xScale(d[0])}).attr("height",height).attr("width",function(d){return xScale(d[1])-xScale(d[0])});gaugeG.selectAll(".extent").data(rectData).attr("x",function(d){return xScale(d[0])}).attr("width",function(d){return xScale(d[1])-xScale(d[0])});gaugeG.selectAll(".extent").data(rectData).exit().remove();gaugeSvg.selectAll(".gauge-gradient").remove();var flattenRowValues=[].concat.apply([],$scope.getValuesFn($scope.data,$scope.index));if(Math.min(...flattenRowValues)==-Infinity){var leftGradient=gaugeSvg.append("defs").append("linearGradient").attr("id","leftGradient");leftGradient.append("stop").attr("offset","0%").attr("stop-color","#f0f1f1").attr("stop-opacity",1);leftGradient.append("stop").attr("offset","100%").attr("stop-color","rgba(255, 255, 255, 0)").attr("stop-opacity",1);gaugeSvg.append("rect").attr("class","gauge-gradient").attr("width",width/4).attr("height",height+2).attr("fill","url(#leftGradient)")}if(Math.max(...flattenRowValues)==Infinity){var rightGradient=gaugeSvg.append("defs").append("linearGradient").attr("id","rightGradient");rightGradient.append("stop").attr("offset","0%").attr("stop-color","rgba(255, 255, 255, 0)").attr("stop-opacity",1);rightGradient.append("stop").attr("offset","100%").attr("stop-color","#f0f1f1").attr("stop-opacity",1);gaugeSvg.append("rect").attr("x",3*width/4).attr("class","gauge-gradient").attr("width",width/4).attr("height",height+2).attr("fill","url(#rightGradient)")}}$scope.$watch("data",function(nv,ov){if(nv==null)return;buildGauge()},true)}}});widgets.directive("movingSplitGauge",function(GaugeHelper){return{restrict:"A",template:"<svg class='split-gauge'></svg>",scope:{data:"=",getValuesFn:"=",updateValuesFn:"=",index:"=",max:"=",min:"="},replace:true,link:function($scope,element,attrs){var handleWidth=5;var handleHeight=9;var gaugeSvg=d3.select(element[0]);var gaugeG=gaugeSvg.append("g").attr("class","x brush");var gaugeHandleG=gaugeSvg.append("g").attr("class","x gauge-handles");var xScale=null;$scope.refreshRange=function(){if($scope.data==null||$scope.index==null)return;var extentRange=GaugeHelper.getValuesModified($scope.data,$scope.index,$scope.getValuesFn,$scope.min,$scope.max);if(!extentRange){gaugeG.selectAll(".extent").remove();gaugeHandleG.selectAll(".resize").remove()}var width=$(element).innerWidth();var height=$(element).innerHeight();var extremities=GaugeHelper.getMinMaxValue($scope.data,$scope.getValuesFn,$scope.min,$scope.max);xScale=GaugeHelper.buildScale(extremities,width);function brushed(){var extent=gauge.extent();var currentValues=GaugeHelper.getValuesModified($scope.data,$scope.index,$scope.getValuesFn,$scope.min,$scope.max);if(extent[0]<currentValues[0]){extent=currentValues}d3.select(this).call(gauge.extent(extent));var xE=xScale(extent[1]);gaugeHandleG.selectAll(".e").attr("transform","translate("+xE+", 0)");$scope.updateValuesFn($scope.data,$scope.index,extent[0],extent[1]);$scope.$apply()}function addResizeE(){actualGauge.selectAll(".resize.e").style("display","initial")}if(extentRange&&extentRange[0]!=null&&extentRange[1]!=null){var gauge=d3.svg.brush().x(xScale).on("brush",brushed).on("brushend",addResizeE).extent(extentRange);var actualGauge=gaugeG.call(gauge);var xE=xScale(extentRange[1]);actualGauge.selectAll("rect").attr("y",0).attr("height",height);actualGauge.selectAll(".extent, .background, .resize").attr("pointer-events","none");gaugeHandleG.selectAll(".resize").remove();actualGauge.selectAll(".resize.e").attr("pointer-events","all");addResizeE();gaugeHandleG.append("g").classed("resize",true).classed("e",true).attr("transform","translate("+xE+", 0)");var gh=gaugeHandleG.selectAll(".resize");gh.append("rect").classed("separator",true).attr("y",0).attr("height",height).attr("x",-1.5).attr("width",3);gh.append("rect").classed("handle",true).attr("y",(height-handleHeight)/2).attr("height",handleHeight).attr("x",-(handleWidth/2)).attr("width",handleWidth)}};$scope.$watch("data",function(nv,ov){if(nv==null)return;$scope.refreshRange()},true)}}});widgets.directive("columnsSelect",function(Fn,$filter){return{scope:{title:"=",selectedColumns:"=",columns:"=",getColType:"=",hasOrder:"=",needsInfo:"=",isInfoOpen:"=",infoText:"@"},templateUrl:"/templates/recipes/fragments/columns-select.html",link:function($scope){$scope.addColumn=function(col){var formatedCol;if($scope.hasOrder){formatedCol={column:col.name,desc:false}}else{formatedCol=col.name}$scope.selectedColumns.push(formatedCol)};$scope.getColumn=function(col){if($scope.hasOrder){return col.column}else{return col}};$scope.removeColumn=function(idx){if(idx>-1){$scope.selectedColumns.splice(idx,1)}};$scope.isInColumns=function(col){var allColumnsNames=$scope.columns.map(Fn.prop("name"));return Fn.inArray(allColumnsNames)($scope.getColumn(col))};$scope.filterSelectedColumns=function(col){var selectedColumnsNames;if($scope.hasOrder&&$scope.selectedColumns){selectedColumnsNames=$scope.selectedColumns.map(Fn.prop("column"))}else{selectedColumnsNames=$scope.selectedColumns}return!selectedColumnsNames||!Fn.inArray(selectedColumnsNames)(col.name)};function computeTypes(){let typeToName=$filter("columnTypeToName");$scope.filteredTypeNames=$scope.columns.filter($scope.filterSelectedColumns).map(function(column){return typeToName(column.type)})}computeTypes();$scope.$watch(function(){return $scope.columns.filter($scope.filterSelectedColumns)},computeTypes,true);$scope.sortOptions={axis:"y",cursor:"move",cancel:"",handle:".handle-row",disable:!$scope.hasOrder}}}})})();(function(){"use strict";var app=angular.module("dataiku.recipes");app.controller("SplitRecipeCreationController",function($scope,$stateParams,$state,$controller,$q,Dialogs,DataikuAPI,WT1,PartitionDeps,RecipeComputablesService,RecipesUtils,DatasetUtils,Fn){$controller("_RecipeCreationControllerBase",{$scope:$scope});addDatasetUniquenessCheck($scope,DataikuAPI,$stateParams.projectKey);fetchManagedDatasetConnections($scope,DataikuAPI);$scope.recipe={projectKey:$stateParams.projectKey,type:"split",inputs:{main:{items:[{ref:"",deps:[]}]}},outputs:{},params:{}};DatasetUtils.listDatasetsUsabilityInAndOut($stateParams.projectKey,"split").then(function(data){$scope.availableInputDatasets=data[0]});RecipeComputablesService.getComputablesMap($scope.recipe,$scope).then(function(map){$scope.setComputablesMap(map)});$scope.$on("preselectInputDataset",function(scope,preselectedInputDataset){$scope.recipe.inputs.main.items[0].ref=preselectedInputDataset;$scope.preselectedInputDataset=preselectedInputDataset});$scope.$watch("recipe.inputs.main.items[0].ref",function(nv,ov){if(nv){$scope.recipe.name="split_"+nv.replace(/[A-Z]*\./,"");if($scope.preselectedInputDataset&&nv!=$scope.preselectedInputDataset){$scope.zone=null}}})});app.controller("SplitRecipeController",function($scope,WT1,$q,$stateParams,$controller,Assert,DataikuAPI,DKUtils,DatasetUtils,Dialogs,PartitionDeps,RecipeComputablesService,ComputableSchemaRecipeSave,CreateModalFromTemplate,RecipesUtils,Fn,Logger,Expressions,RangeExpressions){$controller("_RecipeOutputNewManagedBehavior",{$scope:$scope});var visualCtrl=$controller("VisualRecipeEditorController",{$scope:$scope});$scope.setErrorInTopScope=function(scope){return setErrorInScope.bind($scope)};$scope.hooks.save=function(){removeUnusedOutputs();var deferred=$q.defer();var recipeSerialized=angular.copy($scope.recipe);PartitionDeps.prepareRecipeForSerialize(recipeSerialized);var serializedScript=$scope.serializeScriptData();ComputableSchemaRecipeSave.handleSave($scope,recipeSerialized,serializedScript,deferred);return deferred.promise.then(visualCtrl.saveServerParams)};$scope.convert=function(type,label){Dialogs.confirm($scope,"Convert to "+label+" recipe","Converting the recipe to "+label+" will enable you to edit the query, but you will not be able to use the visual editor anymore."+"<br/><strong>This operation is irreversible.</strong>").then(function(){removeUnusedOutputs();var payloadData=$scope.hooks.getPayloadData();var recipeSerialized=angular.copy($scope.recipe);PartitionDeps.prepareRecipeForSerialize(recipeSerialized);$scope.hooks.save().then(function(){DataikuAPI.flow.recipes.visual.convert($stateParams.projectKey,recipeSerialized,payloadData,type).success(function(data){DKUtils.reloadState()}).error(setErrorInScope.bind($scope))})})};$scope.hooks.getPayloadData=function(){return angular.toJson($scope.params)};$scope.hooks.updateRecipeStatus=function(forceUpdate,exactPlan){var deferred=$q.defer();var payload=$scope.hooks.getPayloadData();$scope.updateRecipeStatusBase(false,payload,{reallyNeedsExecutionPlan:exactPlan,exactPlan:exactPlan}).then(function(){if(!$scope.recipeStatus)return deferred.reject();$scope.recipeStatus.multipleOutputs=true;if($scope.recipeStatus.sqlWithExecutionPlanList&&$scope.recipeStatus.sqlWithExecutionPlanList.length>0&&$scope.recipeStatus.sql===undefined){$scope.selectOutputForSql($scope.selectedOutputName)}deferred.resolve($scope.recipeStatus)});return deferred.promise};$scope.serializeScriptData=function(){return angular.toJson($scope.params)};$scope.resyncSchema=function(){var input=RecipesUtils.getSingleInput($scope.recipe,"main");Dialogs.confirm($scope,"Resynchronize schema",'The schema of "'+input.ref+'" will be copied to all output datasets. Are you sure you want to continue ?').then(function(){DataikuAPI.flow.recipes.basicResyncSchema($stateParams.projectKey,$scope.hooks.getRecipeSerialized()).error(setErrorInScope.bind($scope))})};$scope.addFilterSplit=function(){var outputs=$scope.recipe.outputs.main.items;$scope.params.filterSplits.push({filter:{enabled:true},outputIndex:0})};$scope.removeFilterSplit=function(splitIndex){$scope.params.filterSplits.splice(splitIndex,1)};$scope.addValueSplit=function(splitIndex){$scope.params.valueSplits.splice(splitIndex,0,{value:"",outputIndex:0})};$scope.removeValueSplit=function(splitIndex){$scope.params.valueSplits.splice(splitIndex,1)};$scope.onOutputDatasetChange=function(splitIndex){var splits=$scope.getActiveSplits();onOutputDatasetChange(splits,splitIndex)};$scope.initSeed=function(seed){if(seed==undefined){seed=null}};$scope.showSplitModal=function(){CreateModalFromTemplate("/templates/recipes/fragments/split-modal.html",$scope)};$scope.getTooltipTextColumnMode=function(){if(!$scope.isInColumns($scope.params.column)){return"Select a column"}else if(!$scope.numericalOrDate($scope.getColumn($scope.params.column))){var type=$scope.getColType($scope.params.column);return"Cannot select ranges with '"+$scope.params.column+"' ("+type+")"}else{return""}};$scope.isInColumns=function(colName){var allColumnsNames=$scope.getColumns().map(Fn.prop("name"));return Fn.inArray(allColumnsNames)(colName)};var columns=[];$scope.inputSchema={columns:columns};$scope.getColumns=function(){if(!$scope.computablesMap){Logger.error("Execution function before getting computablesMap");return}const input=RecipesUtils.getSingleInput($scope.recipe,"main");const computable=$scope.computablesMap[input.ref];if(!computable){throw new Error("Dataset is not in computablesMap, try reloading the page.")}Assert.trueish(computable.dataset,"expected a dataset");if(computable.dataset.schema)listCopyContent(columns,computable.dataset.schema.columns);if(hasComputedColumns()){$scope.params.computedColumns.forEach(function(cc){var replaced=false;for(var i=0;i<columns.length;++i){if(columns[i].name==cc.name){columns.splice(i,1,cc);replaced=true;break}}replaced||columns.push(cc)})}return columns};$scope.numericalOrDate=function(col){var allowedGenericTypes=["num","date"];var genericType=Expressions.genericType(col.type);return Fn.inArray(allowedGenericTypes)(genericType)};$scope.hasNumericalOrDateCols=function(){return $scope.getColumns().filter($scope.numericalOrDate).length>0};$scope.getColumn=function(name){var columns=$scope.getColumns();return columns.filter(function(col){return col.name==name})[0]};$scope.getColType=function(colName){if(!colName)return;var col=$scope.getColumns().filter(function(col){return col.name==colName})[0];if(!col)return;return col.type};$scope.genericType=function(type){return Expressions.genericType(type)};$scope.initColumn=function(){var col=$scope.getColumn($scope.params.column);if(!col)return;$scope.currentGenericType=Expressions.genericType(col.type)};$scope.updateOutputs=function(){var outputs=getOutputsRefs();var nOutputs=outputs.length;var allSplits=getAllSplits();allSplits.forEach(function(split){if(split.outputIndex>=nOutputs){split.outputIndex=-1}});$scope.outputsList=[];outputs.forEach(function(x,idx){$scope.outputsList.push({value:idx,label:x})});$scope.outputsList.push({value:"$dku_other",label:"Other dataset..."});$scope.outputsList.push({value:-1,label:"Drop data"})};$scope.onComputedColumnListUpdate=function(computedColumns){$scope.params.computedColumns=angular.copy(computedColumns);syncComputedColumns()};$scope.getActiveSplits=function(){return $scope.getSplits($scope.params.mode)};$scope.getSplits=function(mode){var splits;switch(mode){case"FILTERS":splits=$scope.params.filterSplits;break;case"VALUES":splits=$scope.params.valueSplits;break;case"RANDOM":splits=$scope.params.randomSplits;break;case"RANDOM_COLUMNS":splits=$scope.params.randomColumnsSplits;break;case"CENTILE":splits=$scope.params.centileSplits;break;case"RANGE":splits=$scope.params.rangeSplits;break;default:Logger.error("Unknown split mode : "+mode)}return splits};function getAllSplits(){var modesNames=$scope.splittingMethods.map(Fn.prop(0));var splits=[];modesNames.forEach(function(mode){splits.push.apply(splits,$scope.getSplits(mode))});return splits}function syncComputedColumns(){if(!$scope.computablesMap)return;var schema={columns:$scope.getColumns()||[]};$scope.params.filterSplits.forEach(function(fs){fs.filter.$status=fs.filter.$status||{};fs.filter.$status.schema=schema});if($scope.params.column){var columnGenericType=Expressions.genericType($scope.getColType($scope.params.column));var columnNotInColumns=!$scope.isInColumns($scope.params.column);var genericTypeChanged=columnGenericType!==$scope.currentGenericType;if(columnNotInColumns||genericTypeChanged){onColumnChange($scope.params.column)}}}$scope.getNewRangeSplit=function(conditions){return{filter:{uiData:{mode:"&&",conditions:conditions}},outputIndex:0}};$scope.getConditionsForFirstDateSplit=function(colName){var minCond=RangeExpressions.createCondition(true,"min","date",colName);minCond.date=moment().format(RangeExpressions.dateFormats["dateFormat"]);minCond.frontDate=minCond.date;var maxCond=RangeExpressions.createCondition(false,"max","date",colName);maxCond.date=moment().format(RangeExpressions.dateFormats["dateFormat"]);maxCond.frontDate=maxCond.date;return[minCond,maxCond]};var valueSplitsSave={num:[{outputIndex:0}],boolean:[{value:"true",outputIndex:0},{value:"false",outputIndex:1}],other:[{outputIndex:0}]};var rangeSplitsSave={num:[$scope.getNewRangeSplit([])],date:[$scope.getNewRangeSplit($scope.getConditionsForFirstDateSplit(undefined))]};function onColumnChange(columnName){if(!$scope.computablesMap||!columnName||!$scope.getColumn(columnName))return;var newGenericType=Expressions.genericType($scope.getColType(columnName));if($scope.params.mode==="RANGE"){if(!$scope.isInColumns(columnName)||!$scope.numericalOrDate($scope.getColumn(columnName))){$scope.params.mode="VALUES";onColumnChange(columnName);return}if($scope.currentGenericType&&$scope.currentGenericType!==newGenericType){rangeSplitsSave[$scope.currentGenericType]=$scope.params.rangeSplits;$scope.params.rangeSplits=rangeSplitsSave[newGenericType]}for(var i=0;i<$scope.params.rangeSplits.length;i++){var conditions=RangeExpressions.getRangeConditions($scope.params.rangeSplits,i);if(conditions){conditions.forEach(function(condition){condition.input=columnName;condition.operator=RangeExpressions.modifyColTypeInComparisonOperator(condition.operator,$scope.getColType(columnName))})}}}else if($scope.params.mode==="VALUES"){if(!$scope.currentGenericType&&newGenericType==="boolean"&&!isBooleanValueSplits()){$scope.params.valueSplits=valueSplitsSave["boolean"]}if($scope.currentGenericType&&newGenericType!==$scope.currentGenericType){if(["num","boolean"].indexOf($scope.currentGenericType)<0){valueSplitsSave["other"]=$scope.params.valueSplits}else{valueSplitsSave[$scope.currentGenericType]=$scope.params.valueSplits}if(newGenericType==="num"){$scope.params.valueSplits=valueSplitsSave["num"]}else if(newGenericType==="boolean"){if(valueSplitsSave["boolean"].length){$scope.params.valueSplits=valueSplitsSave["boolean"]}else{$scope.params.valueSplits=[{value:"true"},{value:"false"}]}}else{$scope.params.valueSplits=valueSplitsSave["other"]}}}$scope.currentGenericType=newGenericType}function isBooleanValueSplits(){var isDefinedAndLength2=$scope.params.valueSplits&&$scope.params.valueSplits.length===2;var isFirstTrue=$scope.params.valueSplits[0]&&$scope.params.valueSplits[0]["value"]==="true";var isSecondFalse=$scope.params.valueSplits[1]&&$scope.params.valueSplits[1]["value"]==="false";return isDefinedAndLength2&&isFirstTrue&&isSecondFalse}function removeUnusedOutputs(){if(!$scope.params||!$scope.params.mode){return}const outputs=$scope.recipe.outputs.main.items;const activeSplits=$scope.getActiveSplits();const usedOutputIndices=activeSplits.map(s=>s.outputIndex);usedOutputIndices.push($scope.params.defaultOutputIndex);const allSplits=getAllSplits();for(var i=outputs.length-1;i>=0;--i){if(usedOutputIndices.indexOf(i)<0){outputs.splice(i,1);allSplits.forEach(function(s){if(s.outputIndex>i){s.outputIndex--}});if($scope.params.defaultOutputIndex>i){$scope.params.defaultOutputIndex--}}}}function getOutputsRefs(){return $scope.recipe.outputs.main.items.map(function(o){return o.ref})}function refreshAvailableDatasets(){DatasetUtils.listDatasetsUsabilityInAndOut($stateParams.projectKey,$scope.recipe.type).then(function(data){var alreadyInOutput=function(computable){if($scope.recipe&&$scope.recipe.outputs&&$scope.recipe.outputs.main&&$scope.recipe.outputs.main.items){return $scope.recipe.outputs.main.items.filter(function(item){return item.ref==computable.smartName}).length>0}else{return false}};$scope.availableOutputDatasets=data[1].filter(function(computable){return computable.usableAsOutput["main"].usable&&!computable.alreadyUsedAsOutputOf&&!alreadyInOutput(computable)})})}function onOutputDatasetChange(splits,splitIndex){function getOutputIndex(splitIndex){if(splitIndex>=0){return splits[splitIndex].outputIndex}if(splitIndex==-1){return $scope.params.defaultOutputIndex}}function setOutput(splitIndex,outputIndex){if(splitIndex>=0){splits[splitIndex].outputIndex=outputIndex}if(splitIndex==-1){$scope.params.defaultOutputIndex=outputIndex}}function addAndSetOutput(datasetRef,dismissModalCallback){dismissModalCallback();if(getOutputsRefs().indexOf(datasetRef)<0){$scope.recipe.outputs.main.items.push({ref:datasetRef,appendMode:false})}setOutput(splitIndex,$scope.recipe.outputs.main.items.length-1)}if(getOutputIndex(splitIndex)=="$dku_other"){var newScope=$scope.$new();refreshAvailableDatasets();newScope.ok=function(dismissModalCallback,force=false){if($scope.io.newOutputTypeRadio=="select"){if(!$scope.io.existingOutputDataset)return;addAndSetOutput($scope.io.existingOutputDataset,dismissModalCallback)}else{var creationSettings={connectionId:$scope.newOutputDataset.connectionOption.id,specificSettings:{formatOptionId:$scope.newOutputDataset.formatOptionId,overrideSQLCatalog:$scope.newOutputDataset.overrideSQLCatalog,overrideSQLSchema:$scope.newOutputDataset.overrideSQLSchema,overrideIcebergNamespace:$scope.newOutputDataset.overrideIcebergNamespace},partitioningOptionId:$scope.newOutputDataset.partitioningOption,zone:$scope.zone};const checkPromise=force?$q.resolve({data:{messages:[]}}):DataikuAPI.datasets.checkNameSafety($stateParams.projectKey,$scope.newOutputDataset.name,creationSettings);checkPromise.then(({data})=>{newScope.uiState.backendWarnings=data.messages;return!data.messages||!data.messages.length}).then(proceed=>{if(proceed){return DataikuAPI.datasets.newManagedDataset($stateParams.projectKey,$scope.newOutputDataset.name,creationSettings).then(()=>{RecipeComputablesService.getComputablesMap($scope.recipe,$scope).then(function(map){$scope.setComputablesMap(map);addAndSetOutput($scope.newOutputDataset.name,dismissModalCallback)},setErrorInScope.bind(newScope));WT1.event("create-dataset",{connectionType:$scope.newOutputDataset&&$scope.newOutputDataset.connectionOption?$scope.newOutputDataset.connectionOption.connectionType:"unknown",partitioningFrom:$scope.newOutputDataset?$scope.newOutputDataset.partitioningOption:"unknown",recipeType:$scope.recipe?$scope.recipe.type:"unknown"})})}}).catch(setErrorInScope.bind(newScope))}};newScope.singleOutputRole={name:"main",arity:"UNARY",acceptsDataset:true};setOutput(splitIndex,-1);CreateModalFromTemplate("/templates/recipes/io/output-selection-modal.html",newScope)}}function hasComputedColumns(){return!!($scope.params&&$scope.params.computedColumns&&$scope.params.computedColumns.length)}function initDefaultOutputIndex(){var hasMoreThanOneOutput=$scope.recipe.outputs.main.items&&$scope.recipe.outputs.main.items.length>1;if($scope.params.defaultOutputIndex===1&&!hasMoreThanOneOutput){$scope.params.defaultOutputIndex=-1}}$scope.openCloseInfo=function(){$scope.randomColumnsInfoOpen=!$scope.randomColumnsInfoOpen};$scope.splittingMethods=[["VALUES","Map values of a single column to the outputs datasets"],["FILTERS","Define a filter for each output dataset"],["RANDOM","Randomly split to the output datasets with exact ratio"],["RANDOM_COLUMNS","Randomly split to the output datasets based on values of multiple columns"],["CENTILE","Sort-based / centile split"],["RANGE","Split on range of values for a column"]];$scope.randomSplittingMethods=[["RANDOM","Full random"],["RANDOM_COLUMNS","Random subset of column(s) values"]];$scope.randomSplittingMethodsDesc=["Randomly splits the dataset according to the provided ratios (exact when using DSS engine, approximate otherwise).","Randomly selects a subset of values of one or more columns and send all rows with these values to an output, in order to obtain approximately the provided ratio for this output. Two outputs cannot contain the same values."];$scope.valuesSplittingMethods=[["VALUES","Discrete values"],["RANGE","Ranges"]];$scope.columnTypes=[{name:"TINYINT",label:"tinyint (8 bit)"},{name:"SMALLINT",label:"smallint (16 bit)"},{name:"INT",label:"int"},{name:"BIGINT",label:"bigint (64 bit)"},{name:"FLOAT",label:"float"},{name:"DOUBLE",label:"double"},{name:"BOOLEAN",label:"boolean"},{name:"STRING",label:"string"},{name:"DATE",label:"date"},{name:"ARRAY",label:"array<...>"},{name:"MAP",label:"map<...>"},{name:"OBJECT",label:"object<...>"}];$scope.hooks.onRecipeLoaded=function(){Logger.info("On Recipe Loaded");$scope.updateOutputs();$scope.inputDatasetName=RecipesUtils.getSingleInput($scope.recipe,"main").ref;$scope.hooks.updateRecipeStatus();visualCtrl.saveServerParams();refreshAvailableDatasets();DataikuAPI.datasets.getManagedDatasetOptions($scope.recipe,"main").success(function(data){$scope.setupManagedDatasetOptions(data)});$scope.io=$scope.io||{};$scope.io.newOutputTypeRadio="select";$scope.$watch("recipe.params",$scope.updateRecipeStatusLater,true);$scope.$watch("params.column",onColumnChange);$scope.$watch("mode",DKUtils.reflowNext);$scope.$watchCollection("recipe.outputs.main.items",$scope.updateOutputs);$scope.$watchCollection("params.filterSplits",syncComputedColumns);$scope.$watch("params.computedColumns",syncComputedColumns,true);$scope.$watch("params",$scope.updateRecipeStatusLater,true)};$scope.params={};if($scope.script&&$scope.script.data){$scope.params=JSON.parse($scope.script.data)}var defaults={mode:null,filterSplits:[],valueSplits:[],randomSplits:[],randomColumnsSplits:[],centileSplits:[],randomColumns:[],rangeSplits:[],centileOrders:[],preFilter:{},defaultOutputIndex:-1};$scope.params=$.extend({},defaults,$scope.params);for(let vs of $scope.params.valueSplits||[]){if(vs.value==null){vs.value=""}}$scope.params.filterSplits.length||$scope.addFilterSplit();initDefaultOutputIndex();$scope.specificControllerLoadedDeferred.resolve();$scope.enableAutoFixup();$scope.uiState={currentStep:"splitting",outputColumnNamesOverridable:false,computedColumns:angular.copy($scope.params.computedColumns)};$scope.randomColumnsInfoOpen=false})})();(function(){"use strict";var app=angular.module("dataiku.recipes");app.controller("TopNRecipeCreationController",function($scope,$controller){$scope.recipeType="topn";$controller("SingleOutputDatasetRecipeCreationController",{$scope:$scope});$scope.autosetName=function(){if($scope.io.inputDataset){var niceInputName=$scope.io.inputDataset.replace(/[A-Z]*\./,"");$scope.maybeSetNewDatasetName(niceInputName+"_topn")}}});app.controller("TopNRecipeController",function($scope,$q,$controller,DKUtils,RecipesUtils,Logger,Expressions,DatasetUtils,$stateParams,translate){var visualCtrl=$controller("VisualRecipeEditorController",{$scope:$scope});this.visualCtrl=visualCtrl;$scope.addOrderColumn=function(col){var orderList=$scope.uiState.columnStatus.filter(function(c){return c.status=="S"}).map(function(c){return c.order||0});var nextOrder=orderList.length?Math.max.apply(null,orderList)+1:0;col.status="S";col.order=nextOrder};$scope.removeOrderColumn=function(col){var colOrder=col.order;col.status="X";$scope.uiState.columnStatus.forEach(function(c){if(c.status=="S"&&(c.order||0)>=colOrder){c.order=Math.max((c.order||0)-1,0)}})};$scope.selectLine=function(event,col,ignore){event.preventDefault();var hasLastSelection=$scope.uiState.columnStatus.filter(function(c){return c.ignore==ignore&&!!c.$lastSelection}).length>0;if(event.shiftKey&&hasLastSelection){var selecting=false;for(var i=0;i<$scope.uiState.columnStatus.length;i++){var c=$scope.uiState.columnStatus[i];if(c.ignore!=ignore){continue}var bound=!!c.$lastSelection||c.name===col.name;var firstBound=!selecting&&bound;var lastBound=!!selecting&&bound;if(firstBound){selecting=true;c.$selected=true}c.$selected=selecting;if(lastBound){selecting=false}}}else{$scope.uiState.columnStatus.filter(function(c){return c.ignore==ignore}).forEach(function(c){c.$lastSelection=c.name===col.name});if(event.metaKey||event.ctrlKey){col.$selected=!col.$selected}else{$scope.uiState.columnStatus.filter(function(c){return c.ignore==ignore}).forEach(function(c){c.$selected=c.name===col.name})}}};function assignIgnoreSelected(ignore,selected){return function(col){col.ignore=ignore;col.$selected=selected;col.$lastSelection=false}}$scope.removeAllRetrievedColumns=function(){if(!$scope.uiState.columnStatus){return}$scope.uiState.columnStatus.forEach(assignIgnoreSelected(true,false))};$scope.addAllRetrievedColumns=function(){if(!$scope.uiState.columnStatus){return}$scope.uiState.columnStatus.forEach(assignIgnoreSelected(false,false))};$scope.removeRetrievedColumns=function(col){if(col){assignIgnoreSelected(true,false)(col)}else if($scope.uiState.columnStatus){$scope.uiState.columnStatus.filter(function(col){return!col.ignore&&col.$selected}).forEach(assignIgnoreSelected(true,false))}};$scope.addRetrievedColumns=function(col){if(col){assignIgnoreSelected(false,false)(col)}else if($scope.uiState.columnStatus){$scope.uiState.columnStatus.filter(function(col){return col.ignore&&col.$selected}).forEach(assignIgnoreSelected(false,false))}};$scope.hooks.getPayloadData=function(){return angular.toJson($scope.params)};$scope.hooks.updateRecipeStatus=function(forceUpdate,exactPlan){var payload=$scope.hooks.getPayloadData();if(!payload){return $q.reject("payload not ready")}var deferred=$q.defer();$scope.updateRecipeStatusBase(forceUpdate,payload,{reallyNeedsExecutionPlan:exactPlan,exactPlan:exactPlan}).then(function(){if(!$scope.recipeStatus){return deferred.reject()}var outputSchema=$scope.recipeStatus.outputSchema;var outputSchemaBO=$scope.recipeStatus.outputSchemaBeforeOverride;if(outputSchema){$scope.params.outputColumnNameOverrides=$scope.params.outputColumnNameOverrides||{};var columnsAO=outputSchema.columns;var columnsBO=outputSchemaBO&&outputSchemaBO.columns?outputSchemaBO.columns:outputSchema.columns;for(var i in columnsAO){if(columnsAO[i].name!=columnsBO[i].name){$scope.params.outputColumnNameOverrides[columnsBO[i].name]=columnsAO[i].name}columnsAO[i].$beforeOverride=columnsBO[i].name;columnsAO[i].name=$scope.params.outputColumnNameOverrides[columnsBO[i].name]||columnsBO[i].name}}deferred.resolve($scope.recipeStatus)});return deferred.promise};$scope.updateColumnNameOverride=function(column){if(column.$beforeOverride!=column.name){$scope.params.outputColumnNameOverrides[column.$beforeOverride]=column.name}else{delete $scope.params.outputColumnNameOverrides[column.$beforeOverride]}};function validateFilters(){if(!$scope.params){return}var inputRef=RecipesUtils.getSingleInput($scope.recipe,"main").ref;var inputSchema=$scope.computablesMap[inputRef].dataset.schema;validateFilter($scope.params.preFilter,inputSchema)}function validateFilter(filterDesc,schema){if(!filterDesc||!filterDesc.enabled){return}if(angular.isUndefined(filterDesc.expression)){return}var deferred=$q.defer();Expressions.validateExpression(filterDesc.expression,schema).success(function(data){if(data.ok&&$scope.mustRunInDatabase&&!data.fullyTranslated){data.ok=false}filterDesc.$status=data;filterDesc.$status.validated=true;deferred.resolve(data)}).error(function(){setErrorInScope.bind($scope);deferred.reject("Error while validating filter")});return deferred.promise}$scope.onFilterUpdate=$scope.updateRecipeStatusLater;function computedColumnListUpdated(computedColumns){$scope.params.computedColumns=angular.copy(computedColumns);$scope.updateRecipeStatusLater()}$scope.onComputedColumnListUpdate=computedColumnListUpdated;function loadParamsFromScript(scriptData){if(!scriptData){return}$scope.params=JSON.parse(scriptData);$scope.params.keys=$scope.params.keys||[];$scope.params.orders=$scope.params.orders||[];$scope.params.preFilter=$scope.params.preFilter||{};$scope.params.computedColumns=$scope.params.computedColumns||[];$scope.params.outputColumnNameOverrides=$scope.params.outputColumnNameOverrides||{};$scope.params.retrievedColumns=$scope.params.retrievedColumns||[];var i;$scope.uiState.columnStatus=angular.copy($scope.getColumns());var columnStatusNames=$scope.uiState.columnStatus.map(function(col){return col.name});var addedComputedColumns=[];for(i=0;i<$scope.params.computedColumns.length;i++){var computedCol=$scope.params.computedColumns[i];if(computedCol.name&&computedCol.name.length>0&&columnStatusNames.indexOf(computedCol.name)==-1&&addedComputedColumns.indexOf(computedCol.name)==-1){addedComputedColumns.push(computedCol.name);$scope.uiState.columnStatus.push({name:computedCol.name,type:computedCol.type})}}$scope.uiState.columnStatus.forEach(function(col){col.ignore=$scope.params.retrievedColumnsSelectionMode=="EXPLICIT"&&$scope.params.retrievedColumns.indexOf(col.name)==-1;col.status="X"});columnStatusNames=($scope.uiState.columnStatus||[]).map(function(col){return col.name});var orderIdx=0;for(i=0;i<$scope.params.orders.length;i++){var order=$scope.params.orders[i];var csnIdx=columnStatusNames.indexOf(order.column);if(csnIdx>=0){$scope.uiState.columnStatus[csnIdx].status="S";$scope.uiState.columnStatus[csnIdx].desc=!!order.desc;$scope.uiState.columnStatus[csnIdx].order=orderIdx++}}var hasGroupKey=false;$scope.params.keys.forEach(function(column){var csnIdx=columnStatusNames.indexOf(column);if(csnIdx>=0){hasGroupKey=true;$scope.uiState.columnStatus[csnIdx].status="G"}});$scope.uiState.computedColumns=angular.copy($scope.params.computedColumns);$scope.uiState.fromSelection=hasGroupKey?"GROUPS":"WHOLE";visualCtrl.saveServerParams();resyncWithInputSchema();onColumnStatusChanged()}function resyncWithInputSchema(){var inputColumns=$scope.getColumns();var newColumnStatus=[];var oldColumnStatusNames=($scope.uiState.columnStatus||[]).map(function(col){return col.name});inputColumns.forEach(function(col){var oldCSNIdx=oldColumnStatusNames.indexOf(col.name);if(oldCSNIdx>=0){newColumnStatus.push(angular.extend($scope.uiState.columnStatus[oldCSNIdx],col))}else{newColumnStatus.push(angular.extend(col,{status:"X"}))}});var inputColumnNames=newColumnStatus.map(function(col){return col.name});var addedComputedColumns=[];if($scope.params&&$scope.params.computedColumns){for(var i=0;i<$scope.params.computedColumns.length;i++){var cc=$scope.params.computedColumns[i];if(cc.name&&cc.name.length>0&&inputColumnNames.indexOf(cc.name)==-1&&addedComputedColumns.indexOf(cc.name)==-1){addedComputedColumns.push(cc.name);var col={name:cc.name,type:cc.type};var oldCSNIdx=oldColumnStatusNames.indexOf(cc.name);if(oldCSNIdx>=0){newColumnStatus.push(angular.extend($scope.uiState.columnStatus[oldCSNIdx],col))}else{newColumnStatus.push(angular.extend(col,{status:"X"}))}}}}$scope.uiState.columnStatus=newColumnStatus}function onColumnStatusChanged(){if(!$scope.params){return}$scope.params.keys=($scope.uiState.columnStatus||[]).filter(function(col){return col.status=="G"}).map(function(col){return col.name});$scope.params.orders=($scope.uiState.columnStatus||[]).filter(function(col){return col.status=="S"}).sort(function(col1,col2){return col1.order-col2.order}).map(function(col){return{column:col.name,desc:!!col.desc}});$scope.params.retrievedColumns=($scope.uiState.columnStatus||[]).filter(function(col){return $scope.params.retrievedColumnsSelectionMode=="ALL"||!col.ignore}).map(function(col){return col.name});$scope.uiState.orderList=($scope.uiState.columnStatus||[]).filter(function(col){return col.status=="S"}).sort(function(col1,col2){return col1.order-col2.order});$scope.updateRecipeStatusLater()}function onRetrieveAllColumnsChanged(nv,ov){if(ov==="ALL"&&nv==="EXPLICIT"){$scope.addAllRetrievedColumns()}onColumnStatusChanged()}function onFromSelectionChanged(nv){if(nv){if(nv=="WHOLE"){($scope.uiState.columnStatus||[]).forEach(function(col){if(col.status=="G"){col.status="X"}})}}onColumnStatusChanged()}function onOrderListChanged(nv){if(nv){var orders={};($scope.uiState.orderList||[]).forEach(function(col,idx){orders[col.name]=idx});($scope.uiState.columnStatus||[]).forEach(function(col){col.order=orders[col.name]})}}function onScriptChanged(nv){if(nv){loadParamsFromScript($scope.script.data);DKUtils.reflowNext();DKUtils.reflowLater();$scope.hooks.updateRecipeStatus()}}$scope.uiState={currentStep:"topn",outputColumnNamesOverridable:true,computedColumns:[],fromSelection:"WHOLE"};$scope.getFullStatus=function(status){switch(status){case"G":return translate("TOPN_RECIPE.RETRIEVED_COLUMNS.GROUP","Group");case"S":return translate("TOPN_RECIPE.RETRIEVED_COLUMNS.SORT","Sort");default:return""}};$scope.getDsOrGrpLabel=function(){return $scope.uiState.columnStatus.filter(function(col){return col.status=="G"}).length==0?translate("TOPN_RECIPE.TOPN.THE_WHOLE_DATASET","the whole dataset"):translate("TOPN_RECIPE.TOPN.ITS_GROUP","its group")};$scope.hooks.onRecipeLoaded=function(){Logger.info("On Recipe Loaded");validateFilters();$scope.$watch("script.data",onScriptChanged,true)};$scope.enableAutoFixup();$scope.specificControllerLoadedDeferred.resolve();$scope.$watchCollection("recipe.inputs.main.items",function(){DatasetUtils.updateRecipeComputables($scope,$scope.recipe,$stateParams.projectKey,$stateParams.projectKey).then(_=>resyncWithInputSchema())});$scope.$watch("uiState.columnStatus",onColumnStatusChanged,true);$scope.$watch("uiState.orderList",onOrderListChanged,true);$scope.$watch("params.retrievedColumnsSelectionMode",onRetrieveAllColumnsChanged,true);$scope.$watch("uiState.fromSelection",onFromSelectionChanged);$scope.$watch("params.computedColumns",resyncWithInputSchema,true);$scope.$watch("params",$scope.updateRecipeStatusLater,true)})})();(function(){"use strict";var app=angular.module("dataiku.recipes");app.controller("SortRecipeCreationController",function($scope,$controller){$scope.recipeType="sort";$controller("SingleOutputDatasetRecipeCreationController",{$scope:$scope});$scope.autosetName=function(){if($scope.io.inputDataset){var niceInputName=$scope.io.inputDataset.replace(/[A-Z]*\./,"");$scope.maybeSetNewDatasetName(niceInputName+"_sorted")}}});app.controller("SortRecipeController",function($scope,$controller,$q,DKUtils,RecipesUtils,Logger,Expressions,DatasetUtils,$stateParams){var visualCtrl=$controller("VisualRecipeEditorController",{$scope:$scope});this.visualCtrl=visualCtrl;let contextProjectKey=$scope.context&&$scope.context.projectKey?$scope.context.projectKey:$stateParams.projectKey;$scope.addOrderColumn=function(col){var orderList=$scope.uiState.columnStatus.filter(function(c){return c.status=="S"}).map(function(c){return c.order||0});var nextOrder=orderList.length?Math.max.apply(null,orderList)+1:0;col.status="S";col.order=nextOrder};$scope.removeOrderColumn=function(col){var colOrder=col.order;col.status="X";$scope.uiState.columnStatus.forEach(function(c){if(c.status=="S"&&(c.order||0)>=colOrder){c.order=Math.max((c.order||0)-1,0)}})};$scope.hooks.getPayloadData=function(){return angular.toJson($scope.params)};$scope.hooks.updateRecipeStatus=function(forceUpdate,exactPlan){var payload=$scope.hooks.getPayloadData();if(!payload){return $q.reject("payload not ready")}var deferred=$q.defer();$scope.updateRecipeStatusBase(forceUpdate,payload,{reallyNeedsExecutionPlan:exactPlan,exactPlan:exactPlan}).then(function(){if(!$scope.recipeStatus){return deferred.reject()}var outputSchema=$scope.recipeStatus.outputSchema;var outputSchemaBO=$scope.recipeStatus.outputSchemaBeforeOverride;if(outputSchema){$scope.params.outputColumnNameOverrides=$scope.params.outputColumnNameOverrides||{};var columnsAO=outputSchema.columns;var columnsBO=outputSchemaBO&&outputSchemaBO.columns?outputSchemaBO.columns:outputSchema.columns;for(var i in columnsAO){if(columnsAO[i].name!=columnsBO[i].name){$scope.params.outputColumnNameOverrides[columnsBO[i].name]=columnsAO[i].name}columnsAO[i].$beforeOverride=columnsBO[i].name;columnsAO[i].name=$scope.params.outputColumnNameOverrides[columnsBO[i].name]||columnsBO[i].name}}deferred.resolve($scope.recipeStatus)});return deferred.promise};$scope.updateColumnNameOverride=function(column){if(column.$beforeOverride!=column.name){$scope.params.outputColumnNameOverrides[column.$beforeOverride]=column.name}else{delete $scope.params.outputColumnNameOverrides[column.$beforeOverride]}};function validateFilters(){if(!$scope.params){return}var inputRef=RecipesUtils.getSingleInput($scope.recipe,"main").ref;var inputSchema=$scope.computablesMap[inputRef].dataset.schema;validateFilter($scope.params.preFilter,inputSchema)}function validateFilter(filterDesc,schema){if(!filterDesc||!filterDesc.enabled){return}if(angular.isUndefined(filterDesc.expression)){return}var deferred=$q.defer();Expressions.validateExpression(filterDesc.expression,schema).success(function(data){if(data.ok&&$scope.mustRunInDatabase&&!data.fullyTranslated){data.ok=false}filterDesc.$status=data;filterDesc.$status.validated=true;deferred.resolve(data)}).error(function(){setErrorInScope.bind($scope);deferred.reject("Error while validating filter")});return deferred.promise}$scope.onFilterUpdate=$scope.updateRecipeStatusLater;function computedColumnListUpdated(computedColumns){$scope.params.computedColumns=angular.copy(computedColumns);$scope.updateRecipeStatusLater()}$scope.onComputedColumnListUpdate=computedColumnListUpdated;function loadParamsFromScripts(scriptData){if(!scriptData){return}$scope.params=JSON.parse(scriptData);$scope.params.orders=$scope.params.orders||[];$scope.params.preFilter=$scope.params.preFilter||{};$scope.params.outputColumnNameOverrides=$scope.params.outputColumnNameOverrides||{};$scope.params.computedColumns=$scope.params.computedColumns||[];var i;$scope.uiState.columnStatus=angular.copy($scope.getColumns());var columnStatusNames=($scope.uiState.columnStatus||[]).map(function(col){return col.name});var addedComputedColumns=[];for(i=0;i<$scope.params.computedColumns.length;i++){var computedCol=$scope.params.computedColumns[i];if(computedCol.name&&computedCol.name.length>0&&columnStatusNames.indexOf(computedCol.name)==-1&&addedComputedColumns.indexOf(computedCol.name)==-1){addedComputedColumns.push(computedCol.name);$scope.uiState.columnStatus.push({name:computedCol.name,type:computedCol.type})}}($scope.uiState.columnStatus||[]).forEach(function(col){col.status="X"});columnStatusNames=($scope.uiState.columnStatus||[]).map(function(col){return col.name});var orderIdx=0;for(i=0;i<$scope.params.orders.length;i++){var order=$scope.params.orders[i];var csnIdx=columnStatusNames.indexOf(order.column);if(csnIdx>=0){$scope.uiState.columnStatus[csnIdx].status="S";$scope.uiState.columnStatus[csnIdx].desc=!!order.desc;$scope.uiState.columnStatus[csnIdx].order=orderIdx++}}$scope.uiState.computedColumns=angular.copy($scope.params.computedColumns);visualCtrl.saveServerParams();resyncWithInputSchema();onColumnStatusChanged()}function resyncWithInputSchema(){var inputColumns=$scope.getColumns();var newColumnStatus=[];var oldColumnStatusNames=($scope.uiState.columnStatus||[]).map(function(col){return col.name});inputColumns.forEach(function(col){var oldCSNIdx=oldColumnStatusNames.indexOf(col.name);if(oldCSNIdx>=0){newColumnStatus.push(angular.extend($scope.uiState.columnStatus[oldCSNIdx],col))}else{newColumnStatus.push(angular.extend(col,{status:"X"}))}});var inputColumnNames=newColumnStatus.map(function(col){return col.name});var addedComputedColumns=[];if($scope.params&&$scope.params.computedColumns){for(var i=0;i<$scope.params.computedColumns.length;i++){var cc=$scope.params.computedColumns[i];if(cc.name&&cc.name.length>0&&inputColumnNames.indexOf(cc.name)==-1&&addedComputedColumns.indexOf(cc.name)==-1){addedComputedColumns.push(cc.name);var col={name:cc.name,type:cc.type};var oldCSNIdx=oldColumnStatusNames.indexOf(cc.name);if(oldCSNIdx>=0){newColumnStatus.push(angular.extend($scope.uiState.columnStatus[oldCSNIdx],col))}else{newColumnStatus.push(angular.extend(col,{status:"X"}))}}}}$scope.uiState.columnStatus=newColumnStatus}function onColumnStatusChanged(){if(!$scope.params){return}$scope.params.orders=($scope.uiState.columnStatus||[]).filter(function(col){return col.status=="S"}).sort(function(col1,col2){return col1.order-col2.order}).map(function(col){return{column:col.name,desc:!!col.desc}});$scope.uiState.orderList=($scope.uiState.columnStatus||[]).filter(function(col){return col.status=="S"}).sort(function(col1,col2){return col1.order-col2.order});$scope.updateRecipeStatusLater()}function onOrderListChanged(nv){if(nv){var orders={};($scope.uiState.orderList||[]).forEach(function(col,idx){orders[col.name]=idx});($scope.uiState.columnStatus||[]).forEach(function(col){col.order=orders[col.name]})}}function onScriptChanged(nv){if(nv){loadParamsFromScripts($scope.script.data);DKUtils.reflowNext();DKUtils.reflowLater();$scope.hooks.updateRecipeStatus()}}$scope.uiState={currentStep:"sort",outputColumnNamesOverridable:true,computedColumns:[]};$scope.hooks.onRecipeLoaded=function(){Logger.info("On Recipe Loaded");validateFilters();$scope.$watch("script.data",onScriptChanged,true)};$scope.showOrderPreservationMessage=function(messages){if(!messages)return;return messages.filter(msg=>msg.code=="SORT_OUTPUT_DS_ORDER_NOT_SUPPORTED").length};$scope.enableAutoFixup();$scope.specificControllerLoadedDeferred.resolve();$scope.$watchCollection("recipe.inputs.main.items",function(){DatasetUtils.updateRecipeComputables($scope,$scope.recipe,$stateParams.projectKey,contextProjectKey).then(_=>resyncWithInputSchema())});$scope.$watch("uiState.columnStatus",onColumnStatusChanged,true);$scope.$watch("uiState.orderList",onOrderListChanged,true);$scope.$watch("params.computedColumns",resyncWithInputSchema,true);$scope.$watch("params",$scope.updateRecipeStatusLater,true)})})();(function(){"use strict";var app=angular.module("dataiku.recipes");app.controller("PivotRecipeCreationController",function($scope,$controller,Fn){$scope.recipeType="pivot";$controller("SingleOutputDatasetRecipeCreationController",{$scope:$scope});$scope.autosetName=function(){if($scope.io.inputDataset&&$scope.io.targetVariable){var niceInputName=$scope.io.inputDataset.replace(/[A-Z]*\./,"");var niceTargetVariable=$scope.io.targetVariable.replace(/[^\w ]+/g,"").replace(/ +/g,"_");$scope.maybeSetNewDatasetName(niceInputName+"_by_"+niceTargetVariable)}};$scope.getCreationSettings=function(){return{key:$scope.io.targetVariable}};var superFormIsValid=$scope.formIsValid;$scope.formIsValid=function(){return!!(superFormIsValid()&&$scope.io.targetVariable!==undefined)};$scope.showOutputPane=function(){return!!($scope.io.inputDataset&&$scope.io.targetVariable!==undefined)};$scope.$watch("io.targetVariable",Fn.doIfNv($scope.autosetName))});app.controller("EditCustomAggregatesController",function($scope,$q,Logger,$timeout,Dialogs,DataikuAPI,$stateParams){$scope.commitAggregates=function(){$scope.doCommitAggregates($scope.customAggregates);$scope.dismiss()};$scope.addAggregate=function(){$scope.customAggregates.push({name:"custom_"+$scope.customAggregates.length,label:null,suffix:null,expression:"",type:"string"})};$scope.removeAggregate=function(aggregate){var idx=$scope.customAggregates.indexOf(aggregate);if(idx>=0){$scope.customAggregates.splice(idx,1)}}});app.controller("PivotRecipeController",function($scope,$rootScope,$q,$controller,DKUtils,Logger,RecipesUtils,RecipeStatusHelper,InfoMessagesUtils,$timeout,Dialogs,DataikuAPI,$stateParams,ComputableSchemaRecipeSave,CreateModalFromTemplate,$filter,translate){var visualCtrl=$controller("VisualRecipeEditorController",{$scope:$scope});this.visualCtrl=visualCtrl;$scope.hooks.getPayloadData=function(){var cleanuped=angular.copy($scope.params);if(cleanuped!=null){delete cleanuped.$candidateExplicitIdentifierColumns;cleanuped.pivots.forEach(function(pivot){delete pivot.$candidateKeyColumns;delete pivot.$status;delete pivot.$statusClass;delete pivot.$errors;delete pivot.$warnings;delete pivot.$confirmations;delete pivot.$currentModalities;pivot.valueColumns=pivot.valueColumns.filter(function(valueColumn){return $scope.columnHasSomeComputation(valueColumn)})});cleanuped.otherColumns=cleanuped.otherColumns.filter(function(otherColumn){return $scope.columnHasSomeComputation(otherColumn)})}return angular.toJson(cleanuped)};$scope.hooks.updateRecipeStatus=function(forceUpdate,exactPlan){var payload=$scope.hooks.getPayloadData();if(!payload){return $q.reject("payload not ready")}var deferred=$q.defer();$scope.updateRecipeStatusBase(forceUpdate,payload,{reallyNeedsExecutionPlan:exactPlan,exactPlan:exactPlan}).then(function(){if(!$scope.recipeStatus){return deferred.reject()}deferred.resolve($scope.recipeStatus)});return deferred.promise};$scope.hooks.save=function(){var deferred=$q.defer();if($scope.recipeStatus&&$scope.recipeStatus.outputSchema){var recipeSerialized=$scope.hooks.getRecipeSerialized();var payloadData=$scope.hooks.getPayloadData();ComputableSchemaRecipeSave.handleSave($scope,recipeSerialized,payloadData,deferred)}else{$scope.baseSave($scope.hooks.getRecipeSerialized(),$scope.hooks.getPayloadData()).then(function(){deferred.resolve("Save done")},function(error){Logger.error("Could not save recipe");deferred.reject("Could not save recipe")})}return deferred.promise.then(visualCtrl.saveServerParams)};var fixupFieldsForPivot=function(params){params.keyColumns=params.keyColumns||[];params.valueColumns=params.valueColumns||[];params.explicitValues=params.explicitValues||[];params.valueLimit=params.valueLimit||"TOP_N";params.topnLimit=params.topnLimit||20;params.valueColumns.forEach(function(valueColumn){angular.forEach($scope.aggregationTypes,function(agg){if(valueColumn[agg.name]==true){valueColumn.$agg=agg.name}});angular.forEach(params.customAggregates,function(agg){if(valueColumn.customAggr==agg.name){valueColumn.$agg=agg.name}})})};var fixupParamsFieldsForPivotSection=function(params){params.identifierColumnsSelection=params.identifierColumnsSelection||"EXPLICIT";params.customAggregates=params.customAggregates||[];params.explicitIdentifiers=params.explicitIdentifiers||[];params.pivots=params.pivots||[];if(params.pivots.length==0){params.pivots.push({globalCount:true})}params.pivots.forEach(function(pivot){fixupFieldsForPivot(pivot)})};var fixupParamsFieldsForComputedColumnsSection=function(params){params.computedColumns=params.computedColumns||[]};var fixupParamsFieldsForOtherColumnsSection=function(params){params.otherColumns=params.otherColumns||[]};var fixupParamsGeneric=function(params){params.enginesPreferences=params.enginesPreferences||{}};var indexOfValueColumn=function(pivot,name){var found=-1;pivot.valueColumns.forEach(function(valueColumn,i){if(valueColumn.column==name){found=i}});return found};var indexOfValueColumnObject=function(pivot,col){var found=-1;pivot.valueColumns.forEach(function(valueColumn,i){if(valueColumn==col){found=i}});return found};var indexOfKeyColumn=function(pivot,name){return pivot.keyColumns.indexOf(name)};var indexOfIdentifierColumn=function(name){return $scope.params.explicitIdentifiers.indexOf(name)};var indexOfOtherColumn=function(name){var found=-1;$scope.params.otherColumns.forEach(function(otherColumn,i){if(otherColumn.column==name){found=i}});return found};$scope.$candidateExplicitIdentifierColumns=[];var buildColumnListsForPivotSection=function(){if($scope.params==null){return}if($scope.recipeStatus==null||$scope.recipeStatus.pivotStageSchema==null){return}var notAlreadyInExplicitIdentifiers=[];$scope.recipeStatus.pivotStageSchema.columns.forEach(function(column){if(indexOfIdentifierColumn(column.name)<0){notAlreadyInExplicitIdentifiers.push(column)}});$scope.$candidateExplicitIdentifierColumns=notAlreadyInExplicitIdentifiers;$scope.params.pivots.forEach(function(pivot){pivot.$candidateKeyColumns=[];notAlreadyInExplicitIdentifiers.forEach(function(column){if(indexOfKeyColumn(pivot,column.name)<0){pivot.$candidateKeyColumns.push(column)}})});var otherColumns=[];$scope.recipeStatus.pivotStageSchema.columns.forEach(function(column){if(indexOfIdentifierColumn(column.name)<0){var oidx=indexOfOtherColumn(column.name);if(oidx>=0){otherColumns.push($scope.params.otherColumns[oidx])}else{otherColumns.push({column:column.name,type:column.type})}}});$scope.params.otherColumns=otherColumns};var associateStatusToPivotElements=function(){if($scope.params==null){return}$scope.params.pivots.forEach(function(pivot){pivot.$status=null});if($scope.recipeStatus==null||$scope.recipeStatus.pivot==null){return}var status=$scope.recipeStatus.pivot;for(let i=0;i<$scope.params.pivots.length;i++){let pivot=$scope.params.pivots[i];var filteredStatus=InfoMessagesUtils.filterForLine(status,i);pivot.$status=filteredStatus;pivot.$statusClass=RecipeStatusHelper.getStatusClass(filteredStatus);pivot.$errors=RecipeStatusHelper.getErrors(filteredStatus.messages);pivot.$warnings=RecipeStatusHelper.getWarnings(filteredStatus.messages);pivot.$confirmations=RecipeStatusHelper.getConfirmations(filteredStatus.messages)}if($scope.recipeStatus.pivotModalities){for(let i=0;i<$scope.params.pivots.length;i++){let pivot=$scope.params.pivots[i];var modalities=$scope.recipeStatus.pivotModalities[i];pivot.$currentModalities=modalities}}};$scope.$watch("recipeStatus.pivotStageSchema",buildColumnListsForPivotSection,true);$scope.$watch("recipeStatus.pivot",associateStatusToPivotElements);$scope.$watch("topNav.tab",function(nv,ov){if(nv==="settings"){$scope.$broadcast("repaintFatTable")}});$scope.removeIdentifier=function(col){var idx=indexOfIdentifierColumn(col);if(idx>=0){$scope.params.explicitIdentifiers.splice(idx,1);buildColumnListsForPivotSection()}};$scope.addIdentifier=function(col){var idx=indexOfIdentifierColumn(col);if(idx<0){$scope.params.explicitIdentifiers.push(col);$scope.params.pivots.forEach(function(pivot){var kidx=indexOfKeyColumn(pivot,col);if(kidx>=0){pivot.keyColumns.splice(kidx,1)}for(var vidx=indexOfValueColumn(pivot,col);vidx>=0;vidx=indexOfValueColumn(pivot,col)){pivot.valueColumns.splice(vidx,1)}});buildColumnListsForPivotSection()}};$scope.removeKeyColumn=function(pivot,col){var idx=indexOfKeyColumn(pivot,col);if(idx>=0){pivot.keyColumns.splice(idx,1);removeKeyColumnInExplicitValues(pivot,idx);buildColumnListsForPivotSection()}};$scope.addKeyColumn=function(pivot,col){var idx=indexOfKeyColumn(pivot,col);if(idx<0){pivot.keyColumns.push(col);addKeyColumnInExplicitValues(pivot);for(var vidx=indexOfValueColumn(pivot,col);vidx>=0;vidx=indexOfValueColumn(pivot,col)){pivot.valueColumns.splice(vidx,1)}buildColumnListsForPivotSection()}};$scope.removeValueColumn=function(pivot,col){var idx=indexOfValueColumnObject(pivot,col);if(idx>=0){$rootScope.$broadcast("dismissPopovers");pivot.valueColumns.splice(idx,1);buildColumnListsForPivotSection()}};$scope.addValueColumn=function(pivot,col){pivot.valueColumns.push({column:col.name,type:col.type,count:true,$agg:"count"});var idx=indexOfKeyColumn(pivot,col.name);if(idx>=0){$scope.removeKeyColumn(pivot,col.name)}buildColumnListsForPivotSection()};$scope.removePivot=function(pivot){var idx=$scope.params.pivots.indexOf(pivot);if(idx>=0){$scope.params.pivots.splice(idx,1);buildColumnListsForPivotSection()}};$scope.addPivot=function(){var pivot={};fixupFieldsForPivot(pivot);$scope.params.pivots.push(pivot);buildColumnListsForPivotSection()};$scope.listTypesOf=function(columns){let typeFilter=$filter("columnTypeToName");return columns?columns.map(function(c){return typeFilter(c.type)}):[]};function computedColumnListUpdated(computedColumns){$scope.params.computedColumns=angular.copy(computedColumns);$scope.updateRecipeStatusLater()}$scope.onComputedColumnListUpdate=computedColumnListUpdated;$scope.showEditCustomAggregatesModal=function(){var newScope=$scope.$new();newScope.customAggregates=angular.copy($scope.params.customAggregates);newScope.doCommitAggregates=function(customAggregates){$scope.params.customAggregates=customAggregates};CreateModalFromTemplate("/templates/recipes/visual-recipes-fragments/edit-custom-aggregates-modal.html",newScope,null,null)};$scope.aggregateUsabilityFlag="usableInGroup";$scope.aggregationTypes=[{name:"countDistinct",displayName:translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.NAME.COUNTDISTINCT","countDistinct"),opType:"DISTINCT",label:translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.DISTINCT","Distinct"),tooltip:translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.COUNT_DISTINCT_VALUES","Count distinct values")},{name:"min",displayName:translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.NAME.MIN","min"),label:translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.MIN","Min")},{name:"max",displayName:translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.NAME.MAX","max"),label:translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.MAX","Max")},{name:"avg",displayName:translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.NAME.AVG","avg"),label:translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.AVG","Avg")},{name:"sum",displayName:translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.NAME.SUM","sum"),label:translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.SUM","Sum")},{name:"stddev",displayName:translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.NAME.STDDEV","stddev"),label:translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.STD_DEV","Std. dev.")},{name:"count",displayName:translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.NAME.COUNT","count"),label:translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.COUNT","Count"),tooltip:translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.COUNT_NON_NULL","Count non-null"),separatorAfter:true},{name:"first",displayName:translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.NAME.FIRST","first"),label:translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.FIRST","First")},{name:"last",displayName:translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.NAME.LAST","last"),label:translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.LAST","Last")},{name:"concat",displayName:translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.NAME.CONCAT","concat"),label:translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.CONCAT","Concat"),tooltip:translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.CONCATENATE_VALUES_IN_ONE_STRING","Concatenate values in one string")}];$scope.getAggregationLabel=function(valueColumn,withHtmlTags){if(!valueColumn||!valueColumn?.$agg){return""}const aggregationTypes=Array.isArray($scope.aggregationTypes)?$scope.aggregationTypes:[];const customAggregates=Array.isArray($scope.params?.customAggregates)?$scope.params.customAggregates:[];const allAggregations=[...aggregationTypes,...customAggregates];const aggType=allAggregations.find(agg=>agg&&agg.name===valueColumn?.$agg);if(!aggType){return""}const displayName=aggType.displayName||aggType.label||aggType.name;var column=valueColumn.column;if(valueColumn.concat&&valueColumn.concatDistinct){column=translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.LABEL.DISTINCT_","distinct "+valueColumn.column,{labelCol:valueColumn.column})}var orderedBy="";if(valueColumn.first||valueColumn.last){const orderColumn=withHtmlTags?`<strong>${valueColumn.orderColumn}</strong>`:valueColumn.orderColumn;orderedBy=translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.LABEL._ORDERED_BY_"," ordered by "+orderColumn,{orderColumn:orderColumn});if(valueColumn.firstLastNotNull){orderedBy=translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.LABEL._ORDERED_BY_IGNORING_NULL"," ordered by "+orderColumn+" ignoring null values",{orderColumn:orderColumn})}}var usingSeparator="";if(valueColumn.concat&&valueColumn.concatSeparator&&valueColumn.concatSeparator.length>0){usingSeparator=translate("PIVOT_RECIPE.PIVOT.AGGREGATIONS.LABEL._USING_SEPARATOR"," using separator "+'"'+valueColumn.concatSeparator+'"',{separator:'"'+valueColumn.concatSeparator+'"'})}if(withHtmlTags){return`<strong>${displayName}(${column})</strong>${orderedBy}${usingSeparator}`}return`${displayName}(${column})${orderedBy}${usingSeparator}`};$scope.columnHasSomeComputation=function(col){var ret=false;$scope.aggregationTypes.forEach(function(agg){ret=ret||col[agg.name]});ret=ret||col.customAggr&&col.customAggr.length>0;return ret};$scope.colCanAggr=function(col,agg){if(!$scope.engineCanAggr(agg))return false;var opType=agg.opType||agg.name.toUpperCase();var aggregability=$scope.recipeStatus.selectedEngine.aggregabilities[opType];var typeCategory={string:"strings",date:"dates",dateonly:"dates",datetimenotz:"dates",boolean:"booleans",tinyint:"numerics",smallint:"numerics",int:"numerics",bigint:"numerics",float:"numerics",double:"numerics"}[col.type];return aggregability&&typeCategory&&aggregability[typeCategory]};$scope.engineCanAggrType=function(opType){if(!$scope.recipeStatus||!$scope.recipeStatus.selectedEngine)return false;var aggregability=$scope.recipeStatus.selectedEngine.aggregabilities[opType];return aggregability&&aggregability[$scope.aggregateUsabilityFlag]};$scope.engineCanAggr=function(agg){if(!$scope.recipeStatus||!$scope.recipeStatus.selectedEngine)return false;var opType=agg.opType||agg.name.toUpperCase();var aggregability=$scope.recipeStatus.selectedEngine.aggregabilities[opType];return aggregability&&aggregability[$scope.aggregateUsabilityFlag]};$scope.getColumnsForOrder=function(){if($scope.recipeStatus==null||$scope.recipeStatus.pivotStageSchema==null){return[]}else{return $scope.recipeStatus.pivotStageSchema.columns}};$scope.onAggregationChange=function(column,agg){if(column[agg.name]){if(["first","last"].includes(agg.name)){var cols=$scope.getColumns();column.orderColumn=column.orderColumn||(cols&&cols.length?cols[0].name:undefined)}else if("concat"===agg.name){column.concatSeparator=column.concatSeparator!=null?column.concatSeparator:",";column.concatDistinct=column.concatDistinct||false}}};$scope.aggregation={all:{},some:{},none:{},disabled:{}};$scope.shouldDisplayOptions=function(column){return column!==undefined&&(column.first||column.last||column.concat)};$scope.recomputeAggregationStates=function(cols){for(var k in $scope.aggregation){$scope.aggregation[k]={}}cols.forEach(function(column){$scope.aggregationTypes.forEach(function(agg){var colEnabled=$scope.colCanAggr(column,agg);$scope.aggregation.all[agg.name]=($scope.aggregation.all[agg.name]==undefined?true:$scope.aggregation.all[agg.name])&&(colEnabled?column[agg.name]:false);$scope.aggregation.some[agg.name]=$scope.aggregation.some[agg.name]||false||(colEnabled?column[agg.name]:false);$scope.aggregation.disabled[agg.name]=$scope.aggregation.disabled[agg.name]||false||colEnabled})});angular.forEach($scope.aggregationTypes,function(agg){$scope.aggregation.disabled[agg.name]=!$scope.aggregation.disabled[agg.name];$scope.aggregation.some[agg.name]=$scope.aggregation.some[agg.name]&&!$scope.aggregation.all[agg.name];$scope.aggregation.none[agg.name]=!$scope.aggregation.some[agg.name]&&!$scope.aggregation.all[agg.name]})};$scope.massAction=function(agg,selectedObjects){selectedObjects.forEach(function(val){if($scope.colCanAggr(val,agg)){val[agg.name]=$scope.aggregation.all[agg.name];$scope.onAggregationChange(val,agg)}});$scope.aggregation.some[agg.name]=false;$scope.aggregation.none[agg.name]=!$scope.aggregation.all[agg.name];$scope.hooks.updateRecipeStatus()};$scope.updateAgg=function(valueColumn){angular.forEach($scope.aggregationTypes,function(agg){valueColumn[agg.name]=false});valueColumn.customAggr=null;if(valueColumn.$agg){if($scope.params.customAggregates.map(function(a){return a.name}).indexOf(valueColumn.$agg)>=0){valueColumn.customAggr=valueColumn.$agg}else if($scope.aggregationTypes.map(function(a){return a.name}).indexOf(valueColumn.$agg)>=0){valueColumn[valueColumn.$agg]=true;$scope.onAggregationChange(valueColumn,{name:valueColumn.$agg})}else{Logger.error("Unknown aggregate",valueColumn.$agg)}}};var removeKeyColumnInExplicitValues=function(pivot,idx){pivot.explicitValues.forEach(function(keyValues){if(keyValues.length>idx){keyValues.splice(idx,1)}})};var addKeyColumnInExplicitValues=function(pivot){pivot.explicitValues.forEach(function(keyValues){keyValues.push(null)})};$scope.addModality=function(pivot){var keyValues=pivot.keyColumns.map(function(k){return null});pivot.explicitValues.push(keyValues)};$scope.removeModality=function(pivot,keyValues){var idx=pivot.explicitValues.indexOf(keyValues);if(idx>=0){pivot.explicitValues.splice(idx,1)}};$scope.loadModalitiesFromOutput=function(pivot){if(!pivot.$currentModalities)return;pivot.explicitValues=pivot.$currentModalities.map(function(o){return o.keyValues})};$scope.loadModalitiesFromDataset=function(pivot,smartName){DataikuAPI.flow.recipes.pivot.getDatasetModalities($stateParams.projectKey,smartName,pivot).success(function(data){pivot.explicitValues=data.explicitValues}).error(setErrorInScope.bind($scope))};$scope.dropOutputSchema=function(){var output=RecipesUtils.getSingleOutput($scope.recipe,"main");Dialogs.confirmPositive($scope,"Drop output schema",'The schema of "'+output.ref+'" will be cleared. Are you sure you want to continue ?').then(function(){DataikuAPI.flow.recipes.basicDropSchema($stateParams.projectKey,$scope.hooks.getRecipeSerialized()).success(function(){$scope.hooks.updateRecipeStatus(true)}).error(setErrorInScope.bind($scope))})};$scope.modalitySlugifications=[["NONE",translate("PIVOT_RECIPE.OUTPUT.NONE","None")],["SOFT_SLUGIFY",translate("PIVOT_RECIPE.OUTPUT.SOFT_SLUGIFICATION","Soft slugification")],["HARD_SLUGIFY",translate("PIVOT_RECIPE.OUTPUT.HARD_SLUGIFICATION","Hard slugification")],["NUMBER",translate("PIVOT_RECIPE.OUTPUT.NUMBERING","Numbering")]];$scope.modalitySlugificationsDesc=[translate("PIVOT_RECIPE.OUTPUT.COLUMN_NAMES_ARE_BUILT","Column names are built by concatenating the modality's values"),translate("PIVOT_RECIPE.OUTPUT.REPLACE_PUNCTUATION_AND_WHITESPACE_BY__","Replace punctuation and whitespace by _"),translate("PIVOT_RECIPE.OUTPUT.KEEP_ONLY_SAFE_CHARACTERS","Keep only safe characters (latin letters, numbers)"),translate("PIVOT_RECIPE.OUTPUT.NUMBER_MODALITIES","Number modalities instead of build a name from their values")];$scope.$watch("params.$withModalityMaxLength",function(){if($scope.params&&!$scope.params.$withModalityMaxLength){$scope.params.modalityMaxLength=null}});var onScriptChanged=function(nv){if(!nv){return}loadParamsFromScript($scope.script.data);DKUtils.reflowNext();DKUtils.reflowLater();$scope.hooks.updateRecipeStatus().then(function(){syncTypesFromPivotSchemaIntoParams();visualCtrl.saveServerParams()})};function syncTypesFromPivotSchemaIntoParams(){if(!$scope.recipeStatus||!$scope.recipeStatus.pivotStageSchema||!$scope.params){return}const typesMap={};($scope.recipeStatus.pivotStageSchema.columns||[]).forEach(c=>{if(c&&c.name){typesMap[c.name]=c.type}});($scope.params.pivots||[]).forEach(p=>{(p.valueColumns||[]).forEach(vc=>{if(typesMap[vc.column]){vc.type=typesMap[vc.column]}})})}var loadParamsFromScript=function(scriptData){if(!scriptData){return}$scope.params=JSON.parse(scriptData);fixupParamsGeneric($scope.params);fixupParamsFieldsForComputedColumnsSection($scope.params);fixupParamsFieldsForPivotSection($scope.params);fixupParamsFieldsForOtherColumnsSection($scope.params);buildColumnListsForPivotSection();$scope.uiState.computedColumns=angular.copy($scope.params.computedColumns);visualCtrl.saveServerParams()};$scope.uiState={currentStep:"pivot",modalitiesDatasetSmartName:null,computedColumns:[]};$scope.hooks.onRecipeLoaded=function(){Logger.info("On Recipe Loaded");$scope.$watch("script.data",onScriptChanged,true);onScriptChanged($scope.script.data)};$scope.enableAutoFixup();$scope.specificControllerLoadedDeferred.resolve();$scope.$watch("params",$scope.updateRecipeStatusLater,true)});app.directive("pivotHelp",function(translate){return{restrict:"A",scope:true,templateUrl:"/templates/recipes/fragments/pivot-help.html",link:function($scope,element,attrs){$scope.examples=[];$scope.examples.push({title:translate("PIVOT_RECIPE.PIVOT.SIMPLE_COUNT","Simple count"),column:"year",row:"—",hasIdentifier:false,content:translate("PIVOT_RECIPE.PIVOT.COUNT_OF_RECORDS","count of records"),input:{columns:[translate("PIVOT_RECIPE.PIVOT.ID","id"),translate("PIVOT_RECIPE.PIVOT.COUNTRY","country"),translate("PIVOT_RECIPE.PIVOT.YEAR","year"),translate("PIVOT_RECIPE.PIVOT.QUANTITY","qty")],rows:[["1","US","2016",7],["2","US","2017",12],["3","US","2017",23],["4","FR","2017",8]]},output:{title:translate("PIVOT_RECIPE.PIVOT.COUNT_OF_RECORDS_TITLE","Count of records"),columns:["2016","2017"],rows:[[1,3]]}});$scope.examples.push({title:translate("PIVOT_RECIPE.PIVOT.PIVOT_TABLE","Pivot table"),column:translate("PIVOT_RECIPE.PIVOT.YEAR","year"),row:translate("PIVOT_RECIPE.PIVOT.COUNTRY","country"),hasIdentifier:true,content:translate("PIVOT_RECIPE.PIVOT.SUM_OF_QTY","sum of qty"),input:{columns:[translate("PIVOT_RECIPE.PIVOT.ID","id"),translate("PIVOT_RECIPE.PIVOT.COUNTRY","country"),translate("PIVOT_RECIPE.PIVOT.YEAR","year"),translate("PIVOT_RECIPE.PIVOT.QUANTITY","qty")],rows:[["1","US","2016",7],["2","US","2017",12],["3","US","2017",23],["4","FR","2017",8]]},output:{title:translate("PIVOT_RECIPE.PIVOT.QTY_PER_COUNTRY_YEAR","Qty per country/year"),columns:["","2016","2017"],rows:[["US",7,35],["FR",null,8]]}});$scope.examples.push({title:translate("PIVOT_RECIPE.PIVOT.PIVOT_VALUES","Pivot values"),column:translate("PIVOT_RECIPE.PIVOT.METRIC","metric"),row:translate("PIVOT_RECIPE.PIVOT.ID","id"),hasIdentifier:true,content:translate("PIVOT_RECIPE.PIVOT.FIRST_OF_VALUES","first of values"),hint:translate("PIVOT_RECIPE.PIVOT.MOSTLY_USED_SINGLE_VALUE_PER_KEY","Mostly used on input with a single value per key combination"),input:{columns:[translate("PIVOT_RECIPE.PIVOT.ID","id"),translate("PIVOT_RECIPE.PIVOT.METRIC","metric"),translate("PIVOT_RECIPE.PIVOT.VALUES","values")],rows:[["1",translate("PIVOT_RECIPE.PIVOT.WEIGHT","weight"),2],["1",translate("PIVOT_RECIPE.PIVOT.HEIGHT","height"),4],["2",translate("PIVOT_RECIPE.PIVOT.WEIGHT","weight"),3],["2",translate("PIVOT_RECIPE.PIVOT.HEIGHT","height"),5],["3",translate("PIVOT_RECIPE.PIVOT.WEIGHT","weight"),8],["3",translate("PIVOT_RECIPE.PIVOT.HEIGHT","height"),5]]},output:{title:translate("PIVOT_RECIPE.PIVOT.PIVOTED_VALUES","Pivoted values"),columns:["",translate("PIVOT_RECIPE.PIVOT.WEIGHT","weight"),translate("PIVOT_RECIPE.PIVOT.HEIGHT","height")],rows:[["1",2,4],["2",3,5],["3",8,5]]}});$scope.examples.push({title:translate("PIVOT_RECIPE.PIVOT.FREQUENCY_TABLE","Frequency table"),column:translate("PIVOT_RECIPE.PIVOT.YEAR","year"),row:translate("PIVOT_RECIPE.PIVOT.COUNTRY","country"),hasIdentifier:true,content:translate("PIVOT_RECIPE.PIVOT.COUNT_OF_RECORDS","count of records"),input:{columns:[translate("PIVOT_RECIPE.PIVOT.ID","id"),translate("PIVOT_RECIPE.PIVOT.COUNTRY","country"),translate("PIVOT_RECIPE.PIVOT.YEAR","year"),translate("PIVOT_RECIPE.PIVOT.QUANTITY","qty")],rows:[["1","US","2016",7],["2","US","2017",12],["3","US","2017",23],["4","FR","2017",8]]},output:{title:translate("PIVOT_RECIPE.PIVOT.COUNT_OF_RECORDS","Count of records"),columns:["","2016","2017"],rows:[["US",1,2],["FR",null,1]]}});$scope.examples.push({title:translate("PIVOT_RECIPE.PIVOT.VARIOUS_STATISTICS","Various statistics"),column:translate("PIVOT_RECIPE.PIVOT.YEAR","year"),row:translate("PIVOT_RECIPE.PIVOT.COUNTRY","country"),hasIdentifier:true,content:translate("PIVOT_RECIPE.PIVOT.SUM_OF_QTY","sum of qty"),other:translate("PIVOT_RECIPE.PIVOT.AVERAGE_OF_QTY","average of qty"),input:{columns:[translate("PIVOT_RECIPE.PIVOT.ID","id"),translate("PIVOT_RECIPE.PIVOT.COUNTRY","country"),translate("PIVOT_RECIPE.PIVOT.YEAR","year"),translate("PIVOT_RECIPE.PIVOT.QUANTITY","qty")],rows:[["1","US","2016",7],["2","US","2017",12],["3","US","2017",23],["4","FR","2017",8]]},output:{title:translate("PIVOT_RECIPE.PIVOT.QTY_PER_COUNTRY_YEAR","Qty per country/year"),columns:["","2016","2017",translate("PIVOT_RECIPE.PIVOT.AVG_QTY","avg(qty)")],rows:[["US",7,35,14],["FR",null,8,8]]}});$scope.uiState={selected:$scope.examples[0],hovered:null};$scope.getDisplayed=function(){return $scope.uiState.hovered||$scope.uiState.selected}}}});app.controller("PivotRecipeOutputColumnsController",function($scope){$scope.selection=$.extend({filterQuery:{userQuery:"",tags:[],interest:{}},filterParams:{userQueryTargets:["name","type"],propertyRules:{}},orderQuery:null,orderReversed:false},$scope.selection||{})})})();(function(){"use strict";var app=angular.module("dataiku.recipes");const getIconType=function(type){switch(type){case"LEFT":return"icon-dku-left-join";case"LEFT_ANTI":return"icon-dku-left-unmatched-join";case"INNER":return"icon-dku-inner-join";case"FULL":return"icon-dku-outer-join";case"RIGHT":return"icon-dku-right-join";case"RIGHT_ANTI":return"icon-dku-right-unmatched-join";case"CROSS":return"icon-dku-cross-join";case"ADVANCED":return"icon-dku-advanced-join"}};const getRealColor=function(index){switch(index%6){case 0:return"#28A9DD";case 1:return"#29AF5D";case 2:return"#8541AA";case 3:return"#F44336";case 4:return"#4785A4";case 5:return"#F28C38"}};app.controller("JoinRecipeCreationController",function($scope,Fn,$stateParams,DataikuAPI,$controller,translate){$scope.recipeType="join";$controller("SingleOutputDatasetRecipeCreationController",{$scope:$scope});$scope.autosetName=function(){if($scope.io.inputDataset){var niceInputName=$scope.io.inputDataset.replace(/[A-Z]*\./,"");$scope.maybeSetNewDatasetName(niceInputName+"_joined")}};$scope.getCreationSettings=function(){return{virtualInputs:[$scope.io.inputDataset,$scope.io.inputDataset2]}};var superFormIsValid=$scope.formIsValid;$scope.formIsValid=function(){return!!(superFormIsValid()&&$scope.io.inputDataset2&&$scope.activeSchema2&&$scope.activeSchema2.columns&&$scope.activeSchema2.columns.length)};$scope.showOutputPane=function(){return!!($scope.io.inputDataset&&$scope.io.inputDataset2)}});app.controller("JoinRecipeController",function($scope,$timeout,$controller,$q,$stateParams,DataikuAPI,DKUtils,Dialogs,PartitionDeps,CreateModalFromTemplate,RecipesUtils,Logger,DatasetUtils,RecipeComputablesService,WT1,JoinDisplayNamesService,translate){$scope.joinRecipeType="REGULAR";$scope.distanceUnits={KILOMETER:{name:"Kilometers",simbol:"km"},METER:{name:"Meters",simbol:"m"},MILE:{name:"Miles",simbol:"mi"},YARD:{name:"Yards",simbol:"yd"},FOOT:{name:"Feet",simbol:"ft"},NAUTICAL_MILE:{name:"Nautical miles",simbol:"nmi"}};var visualCtrl=$controller("VisualRecipeEditorController",{$scope:$scope});let contextProjectKey=$scope.context&&$scope.context.projectKey?$scope.context.projectKey:$stateParams.projectKey;function computedColumnListUpdated(computedColumns){$scope.params.computedColumns=angular.copy(computedColumns);$scope.updateRecipeStatusLater()}const originalSaveHook=$scope.hooks.save;$scope.hooks.save=function(){if($scope.joinRecipeType==="REGULAR"){sendRecipeParamsToWT1()}if(originalSaveHook){return originalSaveHook()}};$scope.showDropDown=function(){return $("#join-condition-modal").parent().length==0};$scope.getJoinTypeName=function(type){return JoinDisplayNamesService.getJoinTypeName(type)};$scope.getIconType=getIconType;$scope.getRealColor=getRealColor;$scope.getDescriptionType=function(type){switch(type){case"LEFT":return translate("JOIN_RECIPE.JOIN_DESCRITION.LEFT_JOIN","Keep all rows of the left dataset and add information from the right dataset");case"INNER":return translate("JOIN_RECIPE.JOIN_DESCRITION.INNER_JOIN","Keep matches and drop rows without match from both datasets");case"FULL":return translate("JOIN_RECIPE.JOIN_DESCRITION.FULL_JOIN","Keep all matches and keep rows without match from both datasets");case"RIGHT":return translate("JOIN_RECIPE.JOIN_DESCRITION.RIGHT_JOIN","Keep all matches and keep rows without match from the right dataset");case"LEFT_ANTI":return translate("JOIN_RECIPE.JOIN_DESCRITION.LEFT_ANTI_JOIN","Keep rows of the left dataset without match from the right");case"RIGHT_ANTI":return translate("JOIN_RECIPE.JOIN_DESCRITION.RIGHT_ANTI_JOIN","Keep rows of the right dataset without match from the left");case"CROSS":return translate("JOIN_RECIPE.JOIN_DESCRITION.CARTESIAN_PRODUCT","Cartesian product : match all rows of the left dataset with all rows of the right dataset");case"ADVANCED":return translate("JOIN_RECIPE.JOIN_DESCRITION.ADVANCED_JOIN","Custom options for rows selection and deduplication")}};const conditionsNumOperand=[{label:"=",value:"EQ",enableIfCanNonEquiJoin:true,description:translate("JOIN_RECIPE.JOIN.CONDITIONS_MODAL.OPERATORS.EQUALITY","Equality")},{label:"~",value:"WITHIN_RANGE",enableIfCanNonEquiJoin:false,description:translate("JOIN_RECIPE.JOIN.CONDITIONS_MODAL.OPERATORS.MATCH_ALL","Match all values within range")},{label:"~",value:"K_NEAREST",enableIfCanNonEquiJoin:false,description:translate("JOIN_RECIPE.JOIN.CONDITIONS_MODAL.OPERATORS.MATCH_NEAREST","Match the nearest value(s)")},{label:"<",value:"LT",enableIfCanNonEquiJoin:true,description:translate("JOIN_RECIPE.JOIN.CONDITIONS_MODAL.OPERATORS.STRICTLY_INFERIOR","Strictly inferior")},{label:"<=",value:"LTE",enableIfCanNonEquiJoin:true,description:translate("JOIN_RECIPE.JOIN.CONDITIONS_MODAL.OPERATORS.INFERIOR_EQUAL","Inferior or equal")},{label:">",value:"GT",enableIfCanNonEquiJoin:true,description:translate("JOIN_RECIPE.JOIN.CONDITIONS_MODAL.OPERATORS.STRICTLY_SUPERIOR","Strictly superior")},{label:">=",value:"GTE",enableIfCanNonEquiJoin:true,description:translate("JOIN_RECIPE.JOIN.CONDITIONS_MODAL.OPERATORS.SUPERIOR_EQUAL","Superior or equal")},{label:"!=",value:"NE",enableIfCanNonEquiJoin:true,description:translate("JOIN_RECIPE.JOIN.CONDITIONS_MODAL.OPERATORS.DIFFERENT","Different")}];const conditionsDateOperand=[{label:"=",value:"EQ",enableIfCanNonEquiJoin:true,description:translate("JOIN_RECIPE.JOIN.CONDITIONS_MODAL.OPERATORS.EQUALITY","Equality")},{label:"~",value:"WITHIN_RANGE",enableIfCanNonEquiJoin:false,description:translate("JOIN_RECIPE.JOIN.CONDITIONS_MODAL.OPERATORS.MATCH_ALL_DATES","Match all dates within range")},{label:"~",value:"K_NEAREST",enableIfCanNonEquiJoin:false,description:translate("JOIN_RECIPE.JOIN.CONDITIONS_MODAL.OPERATORS.MATCH_NEAREST_DATES","Match the nearest date(s)")},{label:"<",value:"LT",enableIfCanNonEquiJoin:true,description:translate("JOIN_RECIPE.JOIN.CONDITIONS_MODAL.OPERATORS.STRICTLY_BEFORE","Strictly before")},{label:"<=",value:"LTE",enableIfCanNonEquiJoin:true,description:translate("JOIN_RECIPE.JOIN.CONDITIONS_MODAL.OPERATORS.BEFORE_EQUAL","Before or equal")},{label:">",value:"GT",enableIfCanNonEquiJoin:true,description:translate("JOIN_RECIPE.JOIN.CONDITIONS_MODAL.OPERATORS.STRICTLY_AFTER","Strictly after")},{label:">=",value:"GTE",enableIfCanNonEquiJoin:true,description:translate("JOIN_RECIPE.JOIN.CONDITIONS_MODAL.OPERATORS.AFTER_EQUAL","After or equal")},{label:"!=",value:"NE",enableIfCanNonEquiJoin:true,description:translate("JOIN_RECIPE.JOIN.CONDITIONS_MODAL.OPERATORS.DIFFERENT","Different")}];const conditionsStringOperand=[{label:"=",value:"EQ",enableIfCanNonEquiJoin:true,description:translate("JOIN_RECIPE.JOIN.CONDITIONS_MODAL.OPERATORS.EQUALITY","Equality")},{label:"~",value:"CONTAINS",enableIfCanNonEquiJoin:true,description:translate("JOIN_RECIPE.JOIN.CONDITIONS_MODAL.OPERATORS.CONTAINS","Contains")},{label:"~",value:"STARTS_WITH",enableIfCanNonEquiJoin:true,description:translate("JOIN_RECIPE.JOIN.CONDITIONS_MODAL.OPERATORS.STARTS_WITH","Starts with")},{label:"<",value:"LT",enableIfCanNonEquiJoin:true,description:translate("JOIN_RECIPE.JOIN.CONDITIONS_MODAL.OPERATORS.STRICTLY_BEFORE_AZ","Is strictly before (A-Z)")},{label:"<=",value:"LTE",enableIfCanNonEquiJoin:true,description:translate("JOIN_RECIPE.JOIN.CONDITIONS_MODAL.OPERATORS.BEFORE_EQUAL_AZ","Is before or equal (A-Z)")},{label:">",value:"GT",enableIfCanNonEquiJoin:true,description:translate("JOIN_RECIPE.JOIN.CONDITIONS_MODAL.OPERATORS.STRICTLY_AFTER_AZ","Is strictly after (A-Z)")},{label:">=",value:"GTE",enableIfCanNonEquiJoin:true,description:translate("JOIN_RECIPE.JOIN.CONDITIONS_MODAL.OPERATORS.AFTER_EQUAL_AZ","Is after or equal (A-Z)")},{label:"!=",value:"NE",enableIfCanNonEquiJoin:true,description:translate("JOIN_RECIPE.JOIN.CONDITIONS_MODAL.OPERATORS.IS_DIFFERENT","Is different")}];$scope.outputColumnsSelectionModes=[["AUTO_NON_CONFLICTING",translate("JOIN_RECIPE.SELECTED_COLUMNS.SELECT_ALL_NON_CONFLICTING","Select all non-conflicting columns")],["ALL",translate("JOIN_RECIPE.JOIN.SELECTED_COLUMNS.SELECT_ALL","Select all columns")],["MANUAL",translate("JOIN_RECIPE.JOIN.SELECTED_COLUMNS.MANUALLY_SELECT","Manually select columns")]];$scope.outputColumnsSelectionModeDesc=[translate("JOIN_RECIPE.JOIN.SELECTED_COLUMNS.SELECT_ALL_NON_CONFLICTING_DESCRIPTION","Select all columns that don’t conflict with a similarly named column from an earlier dataset in the join."),translate("JOIN_RECIPE.JOIN.SELECTED_COLUMNS.SELECT_ALL_DESCRIPTION","Select all columns from this dataset. Conflicts may occur, and can be mitigated with a prefix."),translate("JOIN_RECIPE.JOIN.SELECTED_COLUMNS.MANUALLY_SELECT_DESCRIPTION","Explicitly select columns.")];function updateDescription(list){return list.map(element=>{const updatedElement={...element};updatedElement.description=!(element.enableIfCanNonEquiJoin||$scope.canNonEquiJoin())?"Not available in the database":updatedElement.description;return updatedElement})}$scope.$watch("recipeStatus.selectedEngine.canNonEquiJoin",()=>{$scope.conditionsNumOperand=updateDescription(conditionsNumOperand);$scope.conditionsDateOperand=updateDescription(conditionsDateOperand);$scope.conditionsStringOperand=updateDescription(conditionsStringOperand)});$scope.getOperandDescriptionWithoutFilter=function(possibleSelection){return possibleSelection.map(x=>x.description)};$scope.isConditionExpanded=(condition,current)=>{return current&&current.condition&&current.condition===condition};$scope.getJoinColumns=function(virtualInputIndex){return $scope.getColumnsWithComputed(virtualInputIndex)};$scope.getColumnType=function(datasetVirtualIndex,columnName){const col=$scope.getJoinColumns(datasetVirtualIndex).find(col=>col.name===columnName);return col&&col.type};$scope.joinColumnsExist=function(join){return $scope.getJoinColumns(join.table1).length>0&&$scope.getJoinColumns(join.table2).length>0};$scope.getColumnsWithComputed=function(virtualInputIndex){if(!$scope.uiState.columnsWithComputed||!$scope.uiState.columnsWithComputed[virtualInputIndex]){const datasetName=$scope.getDatasetName(virtualInputIndex);const columns=angular.copy($scope.getColumns(datasetName));const hasVirtualInputs=$scope.params&&$scope.params.virtualInputs;if(hasVirtualInputs){const virtualInput=$scope.params.virtualInputs[virtualInputIndex];if(virtualInput){const computedColumns=virtualInput.computedColumns;if(computedColumns){for(let i=0;i<computedColumns.length;i++){columns.push({name:computedColumns[i].name,type:computedColumns[i].type,timestampNoTzAsDate:false,maxLength:-1})}}}}$scope.uiState.columnsWithComputed=$scope.uiState.columnsWithComputed||{};$scope.uiState.columnsWithComputed[virtualInputIndex]=columns}return $scope.uiState.columnsWithComputed[virtualInputIndex]};$scope.getColumnWithComputed=function(datasetVirtualIndex,name){return $scope.getColumnsWithComputed(datasetVirtualIndex).filter(function(col){return col.name===name})[0]};$scope.onComputedColumnListUpdate=computedColumnListUpdated;var savePayloadAsIsForDirtyness=true;$scope.hooks.getPayloadData=function(){if(!$scope.params)return;if(savePayloadAsIsForDirtyness){savePayloadAsIsForDirtyness=false}else{$scope.params.selectedColumns=$scope.getSelectedColumns()}var clean=angular.copy($scope.params);(clean.selectedColumns||[]).forEach(function(c){if(c.alias==null)delete c.alias});return angular.toJson(clean)};var applyEngineLimitations=function(){if($scope.params.joins){var eng=$scope.recipeStatus.selectedEngine;if(eng!=null&&eng.canDeduplicateJoinMatches===false){$scope.params.joins.forEach(function(join){if(join.rightLimit!=null&&join.rightLimit.enabled){Logger.warn("Deactivate rightLimit (deduplicate join matches) because of engine");join.rightLimit.enabled=false}})}$scope.params.joins.forEach(function(join){if(join.rightLimit!=null&&join.rightLimit.enabled&&$scope.hasNonSymmetricConditions(join)){Logger.warn("Deactivate rightLimit because (deduplicate join matches) of non equi-join");join.rightLimit.enabled=false}})}};var removeUnusedInputs=function(){if(!$scope.params.virtualInputs)return;var usedIndices=[];$scope.params.virtualInputs.forEach(function(vi){if(usedIndices.indexOf(vi.index)<0){usedIndices.push(vi.index)}});var newIndices={};for(var i=0;i<$scope.recipe.inputs.main.items.length;i++){newIndices[i]=usedIndices.filter(function(k){return k<i}).length}$scope.recipe.inputs.main.items=$scope.recipe.inputs.main.items.filter(function(input,idx){return usedIndices.indexOf(idx)>=0});$scope.params.virtualInputs.forEach(function(vi){vi.index=newIndices[vi.index]})};$scope.onInputReplaced=function(replacement,virtualIndex){var inputNames=RecipesUtils.getInputsForRole($scope.recipe,"main").map(function(input){return input.ref});$scope.params.virtualInputs[virtualIndex]={...$scope.params.virtualInputs[virtualIndex],index:inputNames.indexOf(replacement.name),originLabel:replacement.name};removeUnusedInputs();DatasetUtils.updateRecipeComputables($scope,$scope.recipe,$stateParams.projectKey,contextProjectKey).then(_=>$scope.resyncSchemas())};$scope.getAvailableReplacementDatasets=function(datasets){return DatasetUtils.setInputDatasetsUsability(datasets,$scope.recipe,$scope.outputDatasetName)};var updateCodeMirrorUI=function(){$(".CodeMirror").each(function(idx,el){el.CodeMirror.refresh()})};$scope.hooks.updateRecipeStatus=function(forceUpdate,exactPlan){var payload=$scope.hooks.getPayloadData();if(!payload)return $q.reject("payload not ready");var deferred=$q.defer();$scope.updateRecipeStatusBase(forceUpdate,payload,{reallyNeedsExecutionPlan:exactPlan,exactPlan:exactPlan}).then(function(){if(!$scope.recipeStatus)return deferred.reject();if($scope.recipeStatus.outputSchema){$scope.params.postFilter=$scope.params.postFilter||{};$scope.params.postFilter.$status=$scope.params.postFilter.$status||{};$scope.params.postFilter.$status.schema=$scope.recipeStatus.outputSchema}if(!$scope.recipeStatus.sqlWithExecutionPlanList){$scope.recipeStatus.sqlWithExecutionPlanList=[{outputName:$scope.outputDatasetName+translate("JOIN_RECIPE.OUTPUT.MAIN_JOIN_OUTPUT"," - (main join output)"),sql:$scope.recipeStatus.sql,executionPlan:$scope.recipeStatus.executionPlan,schema:$scope.recipeStatus.outputSchema}];if($scope.recipeStatus.leftUnmatchedStatus&&$scope.recipeStatus.leftUnmatchedStatus.sql){$scope.recipeStatus.sqlWithExecutionPlanList.push({...$scope.recipeStatus.leftUnmatchedStatus,outputName:unmatchedJoin.getCurrentOutputForRole(unmatchedJoin.ROLE_UNMATCHED_LEFT)+translate("JOIN_RECIPE.OUTPUT.LEFT_UNMATCHED_DATA"," - (left unmatched data)")})}if($scope.recipeStatus.rightUnmatchedStatus&&$scope.recipeStatus.rightUnmatchedStatus.sql){$scope.recipeStatus.sqlWithExecutionPlanList.push({...$scope.recipeStatus.rightUnmatchedStatus,outputName:unmatchedJoin.getCurrentOutputForRole(unmatchedJoin.ROLE_UNMATCHED_RIGHT)+translate("JOIN_RECIPE.OUTPUT.RIGHT_UNMATCHED_DATA"," - (right unmatched data)")})}}$scope.selectOutputForSql($scope.selectedOutputName);applyEngineLimitations();DKUtils.reflowLater();$timeout(updateCodeMirrorUI);deferred.resolve($scope.recipeStatus)});return deferred.promise};$scope.getSuggestionsFunction=DataikuAPI.flow.recipes.join.getSuggestions;$scope.getJoinSuggestions=function(){var payload=$scope.hooks.getPayloadData();var recipeSerialized=angular.copy($scope.recipe);PartitionDeps.prepareRecipeForSerialize(recipeSerialized);return $scope.getSuggestionsFunction($stateParams.projectKey,recipeSerialized,payload).success(function(suggestions){var lastJoin=$scope.params.joins[$scope.params.joins.length-1];if(suggestions.length>0){suggestions.forEach(function(condition){condition.selected=true});$scope.addConditions(lastJoin,suggestions);$scope.hooks.updateRecipeStatus()}}).error(setErrorInScope.bind($scope))};$scope.canNonEquiJoin=function(){return $scope.recipeStatus&&$scope.recipeStatus.selectedEngine!=null&&$scope.recipeStatus.selectedEngine.canNonEquiJoin};$scope.getTitleForJoinModal=function(join){if(join&&join.table1Index!=null){return translate("JOIN_RECIPE.DATASET.ADD_DATASET_MODAL.ADD_A_DATASET","Add a dataset to join with "+$scope.getDatasetName(join.table1Index),{dataset:$scope.getDatasetName(join.table1Index)})}else{return translate("JOIN_RECIPE.DATASET.ADD_DATASET_MODAL.ADD_INPUT_DATASET","Add an input dataset")}};$scope.showNewJoinModal=function(index){$scope.newDatasetIndex=index;CreateModalFromTemplate("/templates/recipes/visual-recipes-fragments/join-modal.html",$scope)};$scope.showJoinEditModal=function(join,tab){if(!$("#join-condition-modal").parent().hasClass("in")&&join.type!=="CROSS"){var newScope=$scope.$new();newScope.join=join;newScope.current={};newScope.current.tab=tab||"conditions";newScope.current.condition=null;newScope.showConditionRemove=true;CreateModalFromTemplate("/templates/recipes/visual-recipes-fragments/join-edit-modal.html",newScope,$scope.joinRecipeType==="FUZZY"?"FuzzyJoinEditController":"JoinEditController",(scope,el)=>{$timeout(()=>{scope.joinBlockBodyEl=el[0].getElementsByClassName("modal-body")[0]})})}};$scope.getSelectedColumns=function(){var outputSchema=[];if(!$scope.uiState||!$scope.uiState.selectedColumns)return;$scope.uiState.selectedColumns.forEach(function(datasetColumns,tableIndex){datasetColumns.forEach(function(column){if(column.selected){outputSchema.push({name:column.name,alias:column.alias,table:tableIndex,type:column.type})}})});return outputSchema};$scope.addDataset=function(datasetName){if(RecipesUtils.getInput($scope.recipe,"main",datasetName)==null){RecipesUtils.addInput($scope.recipe,"main",datasetName)}const inputNames=RecipesUtils.getInputsForRole($scope.recipe,"main").map(function(input){return input.ref});const inputDesc={index:inputNames.indexOf(datasetName),outputColumnsSelectionMode:"AUTO_NON_CONFLICTING",preFilter:{}};$scope.params.virtualInputs.push(inputDesc);$scope.uiState.currentStep="join"};$scope.autoSelectNonConflictingColumnsForManualMode=function(virtualInputIndex){const inputDesc=$scope.params.virtualInputs[virtualInputIndex];$scope.uiState.columnsWithComputed=undefined;$scope.params.selectedColumns=$scope.params.selectedColumns||[];var selectedNames=$scope.params.selectedColumns.map(function(col){return $scope.getColumnOutputName(inputDesc,col).toLowerCase()});var selectColumn=function(columnName){$scope.params.selectedColumns.push({name:columnName,table:$scope.params.virtualInputs.length-1})};var datasetName=$scope.outputDatasetName;var excludedColumnNames=[];if($scope.computablesMap&&datasetName&&$scope.computablesMap[datasetName]&&$scope.computablesMap[datasetName].dataset){var dataset=$scope.computablesMap[datasetName].dataset;if(dataset.type=="HDFS"){if(dataset.partitioning&&dataset.partitioning.dimensions.length>0){dataset.partitioning.dimensions.forEach(function(p){excludedColumnNames.push(p.name)})}}}$scope.getColumnsWithComputed(virtualInputIndex).forEach(function(column){var outputName=$scope.getColumnOutputName(inputDesc,{name:column.name});if(selectedNames.indexOf(outputName.toLowerCase())<0&&!excludedColumnNames.includes(column.name)){selectColumn(column.name)}});createColumnList()};var removeDatasets=function(indices){indices.sort().reverse();indices.forEach(function(index){$scope.params.joins=$scope.params.joins.filter(function(join){return join.table1!=index&&join.table2!=index});$scope.params.joins.forEach(function(join){if(join.table1>index){join.table1--;join.on.forEach(function(condition){condition.column1.table--})}if(join.table2>index){join.table2--;join.on.forEach(function(condition){condition.column2.table--})}});$scope.params.selectedColumns=$scope.params.selectedColumns.filter(function(column){return column.table!=index});$scope.params.selectedColumns.forEach(function(column){if(column.table>index){column.table--}});var datasetName=$scope.getDatasetNameFromRecipeInputIndex($scope.params.virtualInputs[index].index);var numberOfUses=$scope.params.virtualInputs.filter(function(table){return table.name==datasetName}).length;if(numberOfUses==1){RecipesUtils.removeInput($scope.recipe,"main",datasetName);$scope.params.virtualInputs.forEach(function(vi){if(vi.index>index){vi.index--}})}$scope.params.virtualInputs.splice(index,1);$scope.uiState.selectedColumns.splice(index,1)});$scope.hooks.updateRecipeStatus();if($scope.params.virtualInputs.length==0){$scope.showNewJoinModal()}};var getDependantDatasets=function(index){var dependantDatasets=[];for(var i=0;i<$scope.params.joins.length;i++){var join=$scope.params.joins[i];if(join.table1==index){dependantDatasets.push(join.table2);dependantDatasets=dependantDatasets.concat(getDependantDatasets(join.table2))}}return dependantDatasets};$scope.removeDataset=function(index){var datasetsToBeRemoved=getDependantDatasets(index);datasetsToBeRemoved.push(index);if(datasetsToBeRemoved.length==1){removeDatasets(datasetsToBeRemoved)}else{var datasetList=datasetsToBeRemoved.map(function(index){return $scope.getDatasetNameFromRecipeInputIndex($scope.params.virtualInputs[index].index)});Dialogs.confirm($scope,translate("JOIN_RECIPE.JOIN.REMOVE_DATASETS_MODAL.REMOVE_DATASETS","Remove datasets"),translate("JOIN_RECIPE.JOIN.REMOVE_DATASETS_MODAL.FOLLOWING_DATASETS_REMOVED","The following datasets will be removed from the recipe:")+"<ul><li>"+datasetList.join("</li><li>")+"</li></ul>").then(function(){removeDatasets(datasetsToBeRemoved)})}};$scope.getDatasetName=function(virtualIndex){var dataset=$scope.params.virtualInputs[virtualIndex];return $scope.getDatasetNameFromRecipeInputIndex(dataset.index)};$scope.getDatasetNameFromRecipeInputIndex=function(index){var input=$scope.recipe.inputs.main.items[index];return input?input.ref:""};var createColumnList=function(){var selectedColumns=(($scope.params||{}).virtualInputs||[]).map(function(){return{}});if($scope.params.selectedColumns){$scope.params.selectedColumns.forEach(function(column){selectedColumns[column.table][column.name]=column.alias||null})}var columnList=[];selectedColumns.forEach(function(selectedColumn,index){const inputColumns=$scope.getColumnsWithComputed(index).map(function(column){var alias=selectedColumn[column.name];return{name:column.name,type:column.type,maxLength:column.maxLength,selected:alias!==undefined,alias:alias}});columnList.push(inputColumns)});$scope.uiState.selectedColumns=columnList};$scope.resyncSchemas=function(){$scope.uiState.columnsWithComputed=undefined;$scope.uiState.joinableColumns=undefined;createColumnList();$scope.params.joins.forEach(function(join){const columns1=($scope.getColumnsWithComputed(join.table1)||[]).map(function(col){return col.name});const columns2=($scope.getColumnsWithComputed(join.table2)||[]).map(function(col){return col.name});join.on=join.on.filter(function(cond){if(!columns1||!columns2||columns1.indexOf(cond.column1.name)<0||columns2.indexOf(cond.column2.name)<0){return false}return true})})};$scope.getColumnList=function(index){return $scope.uiState.selectedColumns[index]};$scope.getColumnOutputName=function(inputDesc,column){if(column.alias){return column.alias}else if(inputDesc.prefix){return inputDesc.prefix+"_"+column.name}else{return column.name}};$scope.hasNonSymmetricConditions=function(join){if(!join||!join.on){return false}var asymetricConditions=["K_NEAREST","K_NEAREST_INFERIOR"];for(var i=0;i<join.on.length;++i){if(asymetricConditions.indexOf(join.on[i].type)>=0){return true}}return false};$scope.addEmptyCondition=function(join,current){var newCondition={column1:{table:join.table1,name:$scope.getColumnsWithComputed(join.table1)[0].name},column2:{table:join.table2,name:$scope.getColumnsWithComputed(join.table2)[0].name},type:"EQ"};join.on=join.on||[];join.on.push(newCondition);if(current){current.condition=newCondition}};$scope.addConditions=function(join,conditions){conditions.forEach(function(condition){if(condition.selected){delete condition.selected;join.on.push(condition)}});$scope.updateRecipeStatusLater(0)};$scope.removeCondition=function(scope,join,condition){if(scope.current!=null&&scope.current.condition==condition){scope.current.condition=null}var index=join.on.indexOf(condition);join.on.splice(index,1);$scope.hooks.updateRecipeStatus()};$scope.removeAllConditions=function(scope,join){if(scope.current!=null){scope.current.condition=null}join.on=[];$scope.hooks.updateRecipeStatus()};$scope.range=function(n){return Array.apply(null,Array(n)).map(function(_,i){return i})};$scope.getConditionString=function(condition){var col1=condition.column1.name,col2=condition.column2.name,dataset1=$scope.getDatasetNameFromRecipeInputIndex($scope.params.virtualInputs[condition.column1.table].index),dataset2=$scope.getDatasetNameFromRecipeInputIndex($scope.params.virtualInputs[condition.column2.table].index);switch(condition.type){case"EQ":return dataset1+"."+col1+" = "+dataset2+"."+col2;case"WITHIN_RANGE":return"abs("+dataset2+"."+col2+" - "+dataset1+"."+col1+") < "+condition.maxDistance;case"K_NEAREST":return dataset2+"."+col2+" is the nearest match for "+dataset1+"."+col1+(condition.strict?"(strict)":"");case"K_NEAREST_INFERIOR":return dataset2+"."+col2+" is the nearest match before "+dataset1+"."+col1+(condition.strict?"(strict)":"");case"CONTAINS":return dataset1+"."+col1+" contains "+dataset2+"."+col2;case"STARTS_WITH":return dataset1+"."+col1+" contains "+dataset2+"."+col2;case"LTE":return dataset1+"."+col1+" is before "+dataset2+"."+col2;case"GTE":return dataset1+"."+col1+" is after "+dataset2+"."+col2;case"NE":return dataset1+"."+col1+" different from "+dataset2+"."+col2}};$scope.onFilterUpdate=function(filterDesc){$scope.updateRecipeStatusLater()};$scope.listColumnsForCumstomColumnsEditor=function(){return $scope.getSelectedColumns().map(function(c){const inputDesc=$scope.params.virtualInputs[c.table];return $scope.getColumnOutputName(inputDesc,c)})};$scope.$watch("params.postFilter.expression",$scope.updateRecipeStatusLater);$scope.$watch("params.postFilter.enabled",$scope.updateRecipeStatusLater);$scope.$watch("params.virtualInputs",$scope.updateRecipeStatusLater,true);$scope.isRelativeDistance=function(condition){return angular.isNumber(condition.fuzzyMatchDesc.relativeTo)};$scope.getMatchingTypeDescription=function(condition){if($scope.joinRecipeType==="FUZZY"){return $scope.joinDistanceTypes[condition.fuzzyMatchDesc.distanceType]}else if($scope.joinRecipeType==="GEO"){if(["DWITHIN","BEYOND"].includes(condition.type)){return $scope.joinDistanceTypes[condition.type]}else{return null}}};$scope.getMatchingTypeSymbol=function(condition){function round(threshold,multiplier){return Math.round(threshold*(multiplier||1)*10**12)/10**12}if($scope.joinRecipeType==="FUZZY"){const fuzzyMatchDesc=condition.fuzzyMatchDesc;let threshold=fuzzyMatchDesc.threshold;if(!fuzzyMatchDesc||!angular.isNumber(threshold))return"?";if(fuzzyMatchDesc.distanceType==="EXACT")return"=";if($scope.isRelativeDistance(condition)){return`${round(threshold,100)} %`}else{return threshold.toString()}}else if($scope.joinRecipeType==="GEO"){if(condition.type==="DWITHIN"||condition.type==="BEYOND"){return`${round(condition.threshold)} ${$scope.distanceUnits[condition.unit].simbol}`}else{return $scope.joinDistanceTypes[condition.type].toLowerCase()}}else{return JoinDisplayNamesService.getMatchingTypeName(condition.type)}};$scope.getDatasetColorClass=function(datasetIndex){return"dataset-color-"+datasetIndex%6};function onScriptChanged(nv,ov){if(nv){$scope.params=JSON.parse($scope.script.data);$scope.params.computedColumns=$scope.params.computedColumns||[];$scope.uiState.computedColumns=angular.copy($scope.params.computedColumns);$scope.uiState.columnsWithComputed=undefined;savePayloadAsIsForDirtyness=true;visualCtrl.saveServerParams();createColumnList();$scope.hooks.updateRecipeStatus();DKUtils.reflowLater();let joins=$scope.params.joins;if(joins&&joins.length==1&&joins[0].type=="LEFT"&&joins[0].on.length==0){$scope.getJoinSuggestions();$scope.autoSelectNonConflictingColumnsForManualMode(joins[0].table2)}}}$scope.$watchCollection("recipe.outputs.main.items",function(){var outputs=RecipesUtils.getOutputsForRole($scope.recipe,"main");if(outputs.length==1){$scope.outputDatasetName=outputs[0].ref}$scope.updateRecipeStatusLater()});$scope.$watchCollection("params.virtualInputs",removeUnusedInputs);$scope.$watch("params.virtualInputs",function(){$scope.uiState.columnsWithComputed=undefined;DatasetUtils.updateRecipeComputables($scope,$scope.recipe,$stateParams.projectKey,contextProjectKey).then(_=>createColumnList())},true);$scope.hooks.onRecipeLoaded=function(){Logger.info("On Recipe Loaded");$scope.$watch("script.data",onScriptChanged)};$scope.specificControllerLoadedDeferred.resolve();$scope.params=$scope.params||{};$scope.enableAutoFixup();$scope.uiState={currentStep:"join",computedColumns:[]};const unmatchedJoin={ROLE_UNMATCHED_LEFT:"unmatchedLeft",ROLE_UNMATCHED_RIGHT:"unmatchedRight",roles:["unmatchedLeft","unmatchedRight"],unmatchedOutputModes:[{id:"DROP",label:translate("JOIN_RECIPE.JOIN.DROP_UNMATCHED","Drop unmatched rows")},{id:"SAVE",label:translate("JOIN_RECIPE.JOIN.SEND_UNMATCHED","Send unmatched rows to other output dataset(s)")}],savedUnmatchedOutputs:{},selectUnmatchedOutputMode:mode=>{switch(mode.id){case"DROP":unmatchedJoin.roles.forEach(role=>{unmatchedJoin.saveAndClearUnmatchedOutputsForRole(role)});break;case"SAVE":unmatchedJoin.restoreUnmatchedOutputs();break;default:throw"Unsupported unmatch output mode "+mode.id}},saveAndClearUnmatchedOutputsForRole:role=>{const currentOutput=unmatchedJoin.getCurrentOutputForRole(role);if(currentOutput){unmatchedJoin.savedUnmatchedOutputs[role]=currentOutput}unmatchedJoin.setOutputForRole(role,undefined)},restoreUnmatchedOutputs:()=>{unmatchedJoin.roles.forEach(role=>{if(unmatchedJoin.canUseRole(role)){const savedOutput=unmatchedJoin.savedUnmatchedOutputs[role];if(savedOutput){const currentOutput=unmatchedJoin.getCurrentOutputForRole(role);if(!currentOutput){unmatchedJoin.setOutputForRole(role,savedOutput)}}}else{unmatchedJoin.saveAndClearUnmatchedOutputsForRole(role)}})},hasAnyUnmatchedOutput:()=>{return unmatchedJoin.getCurrentOutputForRole(unmatchedJoin.ROLE_UNMATCHED_LEFT)!==undefined||unmatchedJoin.getCurrentOutputForRole(unmatchedJoin.ROLE_UNMATCHED_RIGHT)!==undefined},shouldShowUnmatchedOutputSection:()=>{return $scope.joinRecipeType==="REGULAR"},hasMultipleUnmatchedOutput:()=>{return $scope.params.joins[0].type==="INNER"},canUseUnmatchedOutputs:()=>{return $scope.params.joins&&$scope.params.joins.length===1&&["INNER","RIGHT","LEFT"].includes($scope.params.joins[0].type)},getShowUnmatchedDisabledReason:join=>{if($scope.params.joins.length>1){if(join===$scope.params.joins[0])return"several-joins";else return"hidden"}else{return"not-supported-join-type"}},canUseRole(role){if(role===unmatchedJoin.ROLE_UNMATCHED_LEFT){return $scope.params.joins&&$scope.params.joins.length===1&&["INNER","RIGHT"].includes($scope.params.joins[0].type)}else{return $scope.params.joins&&$scope.params.joins.length===1&&["INNER","LEFT"].includes($scope.params.joins[0].type)}},getCurrentOutputForRole:role=>{const output=RecipesUtils.getOutputsForRole($scope.recipe,role)[0];return output&&output.ref},getCurrentOutputTypeForRole(role){const outputRef=unmatchedJoin.getCurrentOutputForRole(role);return outputRef&&$scope.computablesMap[outputRef].datasetType},getInputDatasetNameForRole:role=>$scope.getDatasetName(role===unmatchedJoin.ROLE_UNMATCHED_LEFT?$scope.params.joins[0].table1:$scope.params.joins[0].table2),setOutputForRole(role,ref){RecipesUtils.removeOutputsForRole($scope.recipe,role);if(ref){RecipesUtils.addOutput($scope.recipe,role,ref)}$scope.updateRecipeStatusLater()},openNewOutputModalForRole(role){CreateModalFromTemplate("/templates/recipes/io/output-selection-modal.html",$scope,null,function(modalScope){$controller("_RecipeOutputNewManagedBehavior",{$scope:modalScope});modalScope.setErrorInTopScope=()=>setErrorInScope.bind($scope);modalScope.formIsValid=()=>{return modalScope.io.newOutputTypeRadio=="select"&&modalScope.io&&modalScope.io.existingOutputDataset||modalScope.io.newOutputTypeRadio=="create"&&modalScope.newOutputDataset&&modalScope.newOutputDataset.name&&modalScope.isDatasetNameUnique(modalScope.newOutputDataset.name)};DatasetUtils.listDatasetsUsabilityInAndOut($stateParams.projectKey,$scope.recipe.type).then(function(data){const thisRecipeOutputs=RecipesUtils.getFlatOutputsList($scope.recipe).map(o=>o.ref);const alreadyInThisRecipeOutput=computable=>thisRecipeOutputs.includes(computable.smartName);const alreadyInOtherRecipeOutput=computable=>computable.alreadyUsedAsOutputOf&&computable.alreadyUsedAsOutputOf!==$scope.recipe.name;return data[1].filter(computable=>computable.usableAsOutput[role].usable&&!alreadyInOtherRecipeOutput(computable)&&!alreadyInThisRecipeOutput(computable))}).then(val=>modalScope.availableOutputDatasets=val);modalScope.getManagedDatasetOptions(role).then(modalScope.setupManagedDatasetOptions);modalScope.singleOutputRole={name:role,arity:"UNARY",acceptsDataset:true};modalScope.ok=function(dismissModalCallback,force=false){return $q.resolve().then(()=>{if(modalScope.io.newOutputTypeRadio=="select"){return modalScope.io.existingOutputDataset}else{return $q(resolve=>{modalScope.acceptEdit=dataset=>resolve(dataset.name);modalScope.createAndUseNewOutputDataset(force)})}}).then(newOutputName=>{unmatchedJoin.setOutputForRole(role,newOutputName);dismissModalCallback()})}})},removeOutputForRole(role){unmatchedJoin.savedUnmatchedOutputs[role]=undefined;unmatchedJoin.setOutputForRole(role,undefined)}};$scope.unmatchedJoin=unmatchedJoin;$scope.$watch(()=>$scope.params.joins,nv=>{if(nv){if(!unmatchedJoin.unmatchedOutputMode){const mode=unmatchedJoin.hasAnyUnmatchedOutput()?"SAVE":"DROP";unmatchedJoin.unmatchedOutputMode=unmatchedJoin.unmatchedOutputModes.find(_=>_.id===mode)}unmatchedJoin.restoreUnmatchedOutputs()}});$scope.hooks.updateJoinUnmatchedOutputs=()=>{unmatchedJoin.restoreUnmatchedOutputs()};function sendRecipeParamsToWT1(){$scope.tryRecipeWT1Event("regular-join-params",()=>{function createFilterWT1Entry(filter){if(!filter){return undefined}return{enabled:filter.enabled,mode:filter.enabled?filter.uiData&&filter.uiData.mode:undefined,distinct:filter.distinct}}const leftUnmatched=unmatchedJoin.getCurrentOutputForRole(unmatchedJoin.ROLE_UNMATCHED_LEFT);const rightUnmatched=unmatchedJoin.getCurrentOutputForRole(unmatchedJoin.ROLE_UNMATCHED_RIGHT);const engine=$scope.recipeStatus&&$scope.recipeStatus.selectedEngine&&$scope.recipeStatus.selectedEngine.label;const recipeData={joins:$scope.params.joins.map(join=>{return{engine:engine,type:join.type,conditionsMode:join.conditionsMode,on:join.on.map(on=>{const column1=$scope.getColumnWithComputed(on.column1.table,on.column1.name);const column2=$scope.getColumnWithComputed(on.column2.table,on.column2.name);return{conditionsMode:on.conditionsMode,type:on.type,column1:column1?column1.type:null,column2:column2?column2.type:null}})}}),unmatchedOutput:{left:{enabled:leftUnmatched!==undefined,output:leftUnmatched?md5(leftUnmatched):undefined},right:{enabled:rightUnmatched!==undefined,output:rightUnmatched?md5(rightUnmatched):undefined}},postFilter:createFilterWT1Entry($scope.params.postFilter),preFilters:$scope.params.virtualInputs.map(i=>createFilterWT1Entry(i.preFilter))};return _.mapValues(recipeData,x=>JSON.stringify(x))},"Failed to report join params")}$scope.isAntiJoin=function(){if($scope.params.joins.length==1){const joinType=$scope.params.joins[0].type;if(joinType==="LEFT_ANTI"||joinType==="RIGHT_ANTI"){return true}}return false};$scope.areInputColumnsSelectable=function(virtualIndex){if(!$scope.isAntiJoin()){return true}const joinType=$scope.params.joins[0].type;return joinType==="LEFT_ANTI"&&virtualIndex===0||joinType==="RIGHT_ANTI"&&virtualIndex===1};$scope.getAntiJoinCannotSelectInfo=function(index){const left=translate("JOIN_RECIPE.JOIN.SELECTED_COLUMNS.LEFT","left");const right=translate("JOIN_RECIPE.JOIN.SELECTED_COLUMNS.RIGHT","right");const first=index===0?left:right;const second=index===0?right:left;return translate("JOIN_RECIPE.JOIN.SELECTED_COLUMNS.CANNOT_SELECT_ANTI_JOIN","Cannot select columns from "+first+" dataset with a "+second+" anti join.",{firstDataset:first,secondDataset:second})}});app.component("joinTypeIcon",{bindings:{type:"<",leftTableIdx:"<",rightTableIdx:"<"},template:`<i class="{{$ctrl.icon}}"><span class="path1" style="color: {{$ctrl.leftColor}};"></span><span class="path2" style="color: {{$ctrl.rightColor}};"></span><span class="path3"></span><span class="path4"></span><span class="path5"></span></i>
        `,controller:function(){const $ctrl=this;$ctrl.$onChanges=()=>{$ctrl.icon=getIconType($ctrl.type);$ctrl.leftColor=getRealColor($ctrl.leftTableIdx);$ctrl.rightColor=getRealColor($ctrl.rightTableIdx)}}});app.controller("NewJoinController",function($scope,$stateParams,DatasetUtils){$scope.params.virtualInputs=$scope.params.virtualInputs||[];$scope.creation=!$scope.params.virtualInputs||!$scope.params.virtualInputs.length;$scope.newJoin={table1Index:$scope.newDatasetIndex};$scope.joinIsValid=function(){return $scope.creation?!!($scope.newJoin.dataset1&&$scope.newJoin.dataset2):!!$scope.newJoin.dataset2};$scope.addJoin=function(){if($scope.creation){$scope.newJoin.table1Index=0;$scope.addDataset($scope.newJoin.dataset1)}let contextProjectKey=$scope.context&&$scope.context.projectKey?$scope.context.projectKey:$stateParams.projectKey;DatasetUtils.updateDatasetInComputablesMap($scope,$scope.newJoin.dataset2,$stateParams.projectKey,contextProjectKey).then(()=>{if(!$scope.dataset2IsValid($scope.newJoin.dataset2)){return}$scope.newJoin.table2Index=$scope.params.virtualInputs.length;$scope.addDataset($scope.newJoin.dataset2);var join={table1:$scope.newJoin.table1Index,table2:$scope.newJoin.table2Index,type:"LEFT",conditionsMode:"AND",on:[],outerJoinOnTheLeft:true,rightLimit:{}};$scope.params.joins=$scope.params.joins||[];$scope.params.joins.push(join);$scope.dismiss();$scope.getJoinSuggestions();$scope.autoSelectNonConflictingColumnsForManualMode($scope.newJoin.table2Index)})};$scope.dataset2IsValid=function(datasetName){if(!datasetName){return false}const computable=$scope.computablesMap[datasetName];if(!computable){$scope.error="Dataset "+datasetName+" does not seem to exist, try reloading the page.";return false}if(!computable.dataset){$scope.error=datasetName+" is not a dataset";return false}if(!computable.dataset.schema||!computable.dataset.schema.columns.length){$scope.error="Dataset "+datasetName+" has an empty schema";return false}return true};$scope.$on("$destroy",function(){$scope.updateRecipeStatusLater(0)});DatasetUtils.listDatasetsUsabilityInAndOut($stateParams.projectKey,"join").then(function(data){$scope.availableInputDatasets=DatasetUtils.setInputDatasetsUsability(data[0],$scope.recipe,$scope.outputDatasetName)})});app.controller("JoinEditController",function($scope,CodeMirrorSettingService,DatasetTypesService){$scope.uiState=$scope.uiState||{};if($scope.join.on.length==0&&!$scope.inFuzzy){$scope.addEmptyCondition($scope.join);$scope.current.condition=$scope.join.on[0]}$scope.sqlEditorOptions=CodeMirrorSettingService.get("text/x-sql");$scope.sqlEditorOptions.autofocus=true;$scope.getColumn=function(condition,columnIdx){const col=!columnIdx||columnIdx===1?"column1":"column2";return $scope.getColumnWithComputed(condition[col].table,condition[col].name)};$scope.hasStringOperand=function(condition,columnIdx){const col=$scope.getColumn(condition,columnIdx);return col&&col.type==="string"};$scope.hasNumOperand=function(condition,columnIdx){const col=$scope.getColumn(condition,columnIdx);return col&&["tinyint","smallint","int","bigint","float","double"].includes(col.type)};$scope.hasDateOperand=function(condition,columnIdx){const col=$scope.getColumn(condition,columnIdx);condition.dateDiffUnit=condition.dateDiffUnit||"SECOND";return col&&DatasetTypesService.isTemporalType(col.type)};$scope.hasGeoOperand=function(condition,columnIdx){const col=$scope.getColumn(condition,columnIdx);return col&&col.type==="geopoint"};$scope.setJoinType=function(join,type){join.type=type};var updateOperandType=function(){var condition=$scope.current.condition;if(!condition){return}var numOrDateJoinType=["EQ","K_NEAREST","K_NEAREST_INFERIOR","WITHIN_RANGE","LTE","GTE","NE"];var stringJoinType=["EQ","CONTAINS","STARTS_WITH","LTE","GTE","NE"];if(($scope.hasNumOperand(condition)||$scope.hasDateOperand(condition))&&numOrDateJoinType.indexOf(condition.type)<0){condition.type="EQ"}else if($scope.hasStringOperand(condition)&&stringJoinType.indexOf(condition.type)<0){condition.type="EQ"}};if($scope.joinRecipeType!=="FUZZY"){$scope.$watch("current.condition.column1.name",updateOperandType);$scope.$watch("current.condition.column2.name",updateOperandType)}$scope.$on("$destroy",function(){$scope.updateRecipeStatusLater(0)})});app=angular.module("dataiku.directives.widgets");app.directive("irregularJoinConditionSettings",function(){return{templateUrl:"templates/recipes/fragments/join-condition-settings.html",link:function($scope,element,attrs){$scope.model=$scope.$eval(attrs["ngModel"]);$scope.$watch("[current.condition.column1.name, current.condition.column2.name]",function(nv,ov){if(nv!==ov){$scope.guessDistanceType($scope.current.condition)}});if($scope.joinRecipeType==="FUZZY"){$scope.$watch("isRelativeDistance(current.condition)",function(nv,ov){if(angular.isDefined(nv)&&angular.isDefined(ov)&&nv!==ov){$scope.setInitialThreshold($scope.current.condition)}})}}}});app.directive("joinBlock",function(){return{restrict:"EA",scope:true,templateUrl:"/templates/recipes/fragments/join-block.html",link:function(scope,element,attrs){scope.onConditionClicked=function(join,condition){if(attrs.onConditionClicked){if(!scope.current||scope.current.condition!==condition){var newScope=scope.$new();newScope.join=join;newScope.condition=condition;newScope.$eval(attrs.onConditionClicked)}else{scope.current.condition=null}}}}}});app.directive("joinBlockDropdownJoin",function(CreateModalFromTemplate,translate){return{restrict:"EA",scope:true,templateUrl:"/templates/recipes/fragments/join-block-dropdown-join.html",link:function(scope,element,attrs){scope.getJoinTypes=function(){if(scope.joinRecipeType==="FUZZY"){return["LEFT","INNER","FULL","RIGHT"]}else if(scope.joinRecipeType==="GEO"){return["LEFT","INNER","FULL","RIGHT","CROSS"]}else{return["LEFT","INNER","FULL","RIGHT","LEFT_ANTI","RIGHT_ANTI","CROSS","ADVANCED"]}};scope.joinTypes=scope.getJoinTypes();scope.shouldDisableJoinType=type=>{switch(type){case"FULL":return scope.recipeStatus&&scope.recipeStatus.selectedEngine&&!scope.recipeStatus.selectedEngine.canFullOuterJoin;case"LEFT_ANTI":case"RIGHT_ANTI":return scope.params&&scope.params.joins&&scope.params.joins.length>1;default:return false}};scope.getDisabledText=type=>{switch(type){case"FULL":return translate("JOIN_RECIPE.JOIN.NOT_AVAILABLE_ENGINE","Not available with this engine");case"LEFT_ANTI":case"RIGHT_ANTI":return translate("JOIN_RECIPE.JOIN.NOT_AVAILABLE_MORE_JOIN","Not available when performing more than one join");default:return""}};scope.setJoinType=function(join,type){join.type=type;if(type==="ADVANCED"){scope.showAdvancedModal()}if(scope.hooks.updateJoinUnmatchedOutputs){scope.hooks.updateJoinUnmatchedOutputs()}scope.hooks.updateRecipeStatus()};scope.showAdvancedModal=function(){scope.join.rightLimit=scope.join.rightLimit||{decisionColumn:{}};const rl=scope.join.rightLimit;rl.maxMatches=rl.maxMatches===undefined||rl.maxMatches===null?1:rl.maxMatches;rl.enabled=rl.enabled===true||rl.enabled===false?rl.enabled:false;rl.type=rl.type||"KEEP_LARGEST";CreateModalFromTemplate("/templates/recipes/visual-recipes-fragments/join-advanced-modal.html",scope)};scope.updateDecisionColumn=function(){if(scope.join.rightLimit){scope.join.rightLimit.decisionColumn={name:scope.uiState.decisionColumnName,table:scope.join.table2};scope.hooks.updateRecipeStatus()}};scope.isSafari=function(){var ua=navigator.userAgent.toLowerCase();if(ua.indexOf("safari")!=-1){if(ua.indexOf("chrome")>-1){return false}else{return true}}else{return false}};scope.getCSSStyle=function(join){if(scope.isSafari()){return""}else{return"background-image: linear-gradient(to right, "+scope.getRealColor(join.table1)+" 50%,  "+scope.getRealColor(join.table2)+" 50%);"+"background-clip: text;"+"-webkit-background-clip: text;"+"-moz-background-clip: text;"+"-webkit-text-fill-color: transparent;"+"color: transparent;"+"display: inline;"}}}}});app.directive("joinBlockEmpty",function(){return{restrict:"EA",scope:true,templateUrl:"/templates/recipes/fragments/join-block-empty.html",link:function(scope,element,attrs){scope.onConditionClicked=function(join,condition){if(attrs.onConditionClicked){if(!scope.current||scope.current.condition!==condition){var newScope=scope.$new();newScope.join=join;newScope.condition=condition;newScope.$eval(attrs.onConditionClicked)}else{scope.current.condition=null}}}}}});app.directive("selectedColumnsEditor",function($timeout,translate){return{restrict:"EA",scope:true,link:function(scope,element,attrs){var getColumns=function(){return scope.$eval(attrs.columns)};scope.getExpectedFinalColumnName=function(name){if(scope.input&&scope.input.prefix){return scope.input.prefix+"_"+name}else{return name}};scope.editColumnAlias=function(columnIndex,column){column.$newName=column?scope.getColumnOutputName(scope.input,column):"";scope.currentEditedColumn=column;$timeout(function(){$(".alias-editor",element).get(columnIndex).focus()})};scope.validateColumnEdition=function(){var col=scope.currentEditedColumn;col.alias=col.$newName||null;var expected=scope.getExpectedFinalColumnName(col?col.name:"");if(col&&col.alias==expected){delete col.alias}scope.currentEditedColumn=null;scope.hooks.updateRecipeStatus()};scope.cancelColumnEdition=function(){scope.currentEditedColumn=null};scope.onBlurColumnEdition=function(){if(!scope.currentEditedColumn){scope.cancelColumnEdition()}else{scope.validateColumnEdition()}};scope.deleteColumnAlias=function(column){delete column.alias;scope.currentEditedColumn=null;scope.hooks.updateRecipeStatus()};scope.keyDownOnAliasBox=function(event){if(event.keyCode==13){scope.validateColumnEdition()}else if(event.keyCode==27){scope.cancelColumnEdition()}};scope.updateSelectAll=function(){$.each(getColumns(),function(idx,column){column.selected=scope.selected.all});scope.selected.any=scope.selected.all;scope.hooks.updateRecipeStatus()};var updateGlobalSelectionStatus=function(){var all=true,any=false;$.each(getColumns(),function(idx,column){if(column.selected){any=true}else{all=false}});scope.selected={all:all,any:any}};scope.onSelectionChange=function(){updateGlobalSelectionStatus();scope.hooks.updateRecipeStatus()};scope.hasDuplicates=function(datasetIndex,column){if(!scope.recipeStatus||!scope.recipeStatus.selectedColumns||!scope.recipeStatus.selectedColumns.duplicates)return false;if(!column.selected)return false;var duplicates=scope.recipeStatus.selectedColumns.duplicates;for(var i=0;i<duplicates.length;++i){var duplicate=duplicates[i];if(duplicate.dataset1==datasetIndex&&duplicate.column1==column.name||duplicate.dataset2==datasetIndex&&duplicate.column2==column.name){return true}}return false};updateGlobalSelectionStatus()}}})})();(function(){"use strict";var app=angular.module("dataiku.recipes");app.controller("FuzzyJoinRecipeCreationController",function($scope,Fn,$stateParams,DataikuAPI,$controller){$scope.recipeType="fuzzyjoin";$controller("SingleOutputDatasetRecipeCreationController",{$scope:$scope});$scope.autosetName=function(){if($scope.io.inputDataset){var niceInputName=$scope.io.inputDataset.replace(/[A-Z]*\./,"");$scope.maybeSetNewDatasetName(niceInputName+"_joined")}};$scope.getCreationSettings=function(){return{virtualInputs:[$scope.io.inputDataset,$scope.io.inputDataset2]}};var superFormIsValid=$scope.formIsValid;$scope.formIsValid=function(){return!!(superFormIsValid()&&$scope.io.inputDataset2&&$scope.activeSchema2&&$scope.activeSchema2.columns&&$scope.activeSchema2.columns.length)};$scope.showOutputPane=function(){return!!($scope.io.inputDataset&&$scope.io.inputDataset2)};$scope.showAdditionalInputsMessage=false});app.controller("FuzzyJoinEditController",function($scope,$controller,$timeout){$scope.inFuzzy=true;$controller("JoinEditController",{$scope:$scope});$scope.checkBothOperands=function(fn){return c=>{return fn(c,1)&&fn(c,2)}};const fuzzyJoinDistanceTypesAvailability={EXACT:()=>true,EUCLIDEAN:$scope.checkBothOperands($scope.hasNumOperand),LEVENSHTEIN:$scope.checkBothOperands($scope.hasStringOperand),HAMMING:$scope.checkBothOperands($scope.hasStringOperand),COSINE:$scope.checkBothOperands($scope.hasStringOperand),JACCARD:$scope.checkBothOperands($scope.hasStringOperand),GEO:$scope.checkBothOperands($scope.hasGeoOperand)};$scope.availableDistances=function(condition){return Object.entries(fuzzyJoinDistanceTypesAvailability).filter(([_,v])=>v(condition)).map(e=>e[0])};$scope.guessDistanceType=function(condition){const availableDistances=$scope.availableDistances(condition);const matchingAvailableDistance=availableDistances.find(e=>{return e&&e!=="EXACT"});if(matchingAvailableDistance){condition.fuzzyMatchDesc.distanceType=matchingAvailableDistance}else if(availableDistances.length){condition.fuzzyMatchDesc.distanceType=availableDistances[0]}};$scope.setInitialThreshold=function(condition){condition.fuzzyMatchDesc.threshold=$scope.isRelativeDistance(condition)?.5:1};$scope.addEmptyCondition=function(join,current,el){const newCondition={column1:{table:join.table1,name:$scope.getColumnsWithComputed(join.table1)[0].name},column2:{table:join.table2,name:$scope.getColumnsWithComputed(join.table2)[0].name},type:"EQ",fuzzyMatchDesc:{threshold:0}};$scope.guessDistanceType(newCondition);$scope.setInitialThreshold(newCondition);join.on=join.on||[];join.on.push(newCondition);current.condition=join.on[join.on.length-1];if(el){$timeout(()=>{el.scrollTop=el.scrollHeight})}};if($scope.join.on.length==0){$scope.addEmptyCondition($scope.join,$scope.current,null);$scope.current.condition=$scope.join.on[0]}});app.controller("FuzzyJoinRecipeController",function($scope,$controller,DataikuAPI,Logger){$controller("JoinRecipeController",{$scope:$scope});const originalSave=$scope.hooks.save;$scope.hooks.save=function(){const join=$scope.params.joins[0];$scope.tryRecipeWT1Event("fuzzy-join-params",()=>({type:join.type,on:JSON.stringify(join.on.map(on=>{const column1=$scope.getColumn($scope.getDatasetName(on.column1.table),on.column1.name);const column2=$scope.getColumn($scope.getDatasetName(on.column2.table),on.column2.name);return{fuzzyMatchDesc:on.fuzzyMatchDesc,normaliseDesc:on.normaliseDesc,column1:column1?column1.type:null,column2:column2?column2.type:null}}))}),"Failed to report Fuzzy join params");return originalSave()};$scope.hasNormalisationParams=function(normaliseDesc){return normaliseDesc&&Object.values(normaliseDesc).some(v=>v===true)};$scope.hasExtraInfoToShow=function(condition){return $scope.hasNormalisationParams(condition.normaliseDesc)||$scope.isRelativeDistance(condition)};$scope.joinDistanceTypes={EXACT:"Strict equality",EUCLIDEAN:"Euclidean",LEVENSHTEIN:"Damerau-Levenshtein",HAMMING:"Hamming",COSINE:"Cosine",JACCARD:"Jaccard",GEO:"Geospatial"};$scope.isFuzzy=true;$scope.joinRecipeType="FUZZY";$scope.getSuggestionsFunction=DataikuAPI.flow.recipes.fuzzyjoin.getSuggestions;$scope.normalisationParams={caseInsensitive:{label:"Case insensitive",desc:"Ignore case when matching characters"},normaliseText:{label:"Remove punctuation and extra spaces",desc:""},unicodeCasting:{label:"Unicode casting",desc:"Remove accents: cÁfé -> cAfe"},clearSalutations:{label:"Clear salutations",desc:"Remove English salutations, e.g. Miss, Sir, Dr"},clearStopWords:{label:"Clear stop words",desc:"Remove common stop words depending on the language"},transformToStem:{label:"Transform to stem",desc:"Transform words to base form (Snowball stemmer)"},sortAlphabetically:{label:"Alphabetic sorting of words",desc:""}};$scope.isNumber=angular.isNumber;$scope.isDefined=angular.isDefined;$scope.updateDebugMode=function(){$scope.params.withMetaColumn=$scope.params.debugMode;$scope.hooks.updateRecipeStatus()}});app.controller("NewFuzzyJoinController",function($scope,DataikuAPI,$q,$stateParams,Dialogs,DatasetUtils){$scope.params.virtualInputs=$scope.params.virtualInputs||[];$scope.creation=!$scope.params.virtualInputs||!$scope.params.virtualInputs.length;$scope.newJoin={table1Index:0};$scope.joinIsValid=function(){return $scope.creation?!!($scope.newJoin.dataset1&&$scope.newJoin.dataset2):!!$scope.newJoin.dataset2};$scope.addJoin=function(){if($scope.creation){$scope.newJoin.table1Index=0;$scope.addDataset($scope.newJoin.dataset1)}let contextProjectKey=$scope.context&&$scope.context.projectKey?$scope.context.projectKey:$stateParams.projectKey;DatasetUtils.updateDatasetInComputablesMap($scope,$scope.newJoin.dataset2,$stateParams.projectKey,contextProjectKey).then(()=>{if(!$scope.dataset2IsValid($scope.newJoin.dataset2)){return}$scope.newJoin.table2Index=$scope.params.virtualInputs.length;$scope.addDataset($scope.newJoin.dataset2);var join={table1:$scope.newJoin.table1Index,table2:$scope.newJoin.table2Index,type:"LEFT",conditionsMode:"AND",on:[],outerJoinOnTheLeft:true,rightLimit:{}};$scope.params.joins=$scope.params.joins||[];$scope.params.joins.push(join);$scope.dismiss();$scope.getJoinSuggestions();var table2Input=$scope.params.virtualInputs[$scope.newJoin.table2Index];$scope.autoSelectColumns(table2Input)})};$scope.dataset2IsValid=function(datasetName){if(!datasetName){return false}const computable=$scope.computablesMap[datasetName];if(!computable){$scope.error="Dataset "+datasetName+" does not seem to exist, try reloading the page.";return false}if(!computable.dataset){$scope.error=datasetName+" is not a dataset";return false}if(!computable.dataset.schema||!computable.dataset.schema.columns.length){$scope.error="Dataset "+datasetName+" has an empty schema";return false}return true};$scope.$on("$destroy",function(){$scope.updateRecipeStatusLater(0)});DatasetUtils.listDatasetsUsabilityInAndOut($stateParams.projectKey,"fuzzyjoin").then(function(data){$scope.availableInputDatasets=data[0]})})})();(function(){"use strict";var app=angular.module("dataiku.recipes");app.controller("GeoJoinRecipeCreationController",function($scope,$controller,$stateParams,DataikuAPI,Fn,RecipeComputablesService){$controller("JoinRecipeCreationController",{$scope:$scope});$scope.recipeType="geojoin";$scope.recipe={type:"geojoin",projectKey:$stateParams.projectKey,inputs:{main:{items:[]}},outputs:{main:{items:[]}}};$scope.autosetName=function(){if($scope.io.inputDataset){var niceInputName=$scope.io.inputDataset.replace(/[A-Z]*\./,"");$scope.maybeSetNewDatasetName(niceInputName+"_joined")}};$scope.$watchCollection("recipe.inputs.main.items",function(nv){if(nv&&nv.length){$scope.io.inputDataset=nv[0].ref}})});app.controller("GeoJoinRecipeController",["$scope","$controller","$q","$stateParams","DataikuAPI","Dialogs","PartitionDeps","CreateModalFromTemplate","RecipesUtils","Logger","CodeMirrorSettingService","$timeout",function($scope,$controller,$q,$stateParams,DataikuAPI,Dialogs,PartitionDeps,CreateModalFromTemplate,RecipesUtils,Logger,CodeMirrorSettingService,$timeout){$controller("JoinRecipeController",{$scope:$scope});$scope.uiState={currentStep:"join",computedColumns:[]};$scope.isGeo=true;$scope.joinRecipeType="GEO";$scope.distanceTypeHint={TOUCHES:"Geometries should not overlap"};$scope.joinDistanceTypes={DWITHIN:"Is within distance of",BEYOND:"Is beyond distance of",CONTAINS:"Contains",WITHIN:"Is contained within",INTERSECTS:"Intersects",DISJOINT:"Is disjoint to",TOUCHES:"Touches",EQ:"Is strictly equal to"};$scope.availableDistances=function(){return Object.keys($scope.joinDistanceTypes)};$scope.isThresholdNeeded=function(distanceType){return distanceType==="DWITHIN"||distanceType==="BEYOND"};$scope.getJoinColumns=function(virtualInputIndex){if(!$scope.uiState.joinableColumns||!$scope.uiState.joinableColumns[virtualInputIndex]){$scope.uiState.joinableColumns=$scope.uiState.joinableColumns||{};$scope.uiState.joinableColumns[virtualInputIndex]=$scope.getColumnsWithComputed(virtualInputIndex).filter(e=>e.type==="geopoint"||e.type==="geometry")}return $scope.uiState.joinableColumns[virtualInputIndex]};$scope.guessDistanceType=function(condition){if(condition.type){return}const availableDistances=$scope.availableDistances(condition);const matchingAvailableDistance=availableDistances.find(e=>{return e&&e!=="EXACT"});if(matchingAvailableDistance){condition.type=matchingAvailableDistance}else if(availableDistances.length){condition.type=availableDistances[0]}};$scope.addEmptyCondition=function(join,current,el){const table1JoinColumns=$scope.getJoinColumns(join.table1);const table2JoinColumns=$scope.getJoinColumns(join.table2);if(!table1JoinColumns.length||!table2JoinColumns.length){return}const newCondition={column1:{table:join.table1,name:table1JoinColumns[0].name},column2:{table:join.table2,name:table2JoinColumns[0].name},threshold:100,unit:"METER"};$scope.guessDistanceType(newCondition);join.on=join.on||[];join.on.push(newCondition);if(current){current.condition=join.on[join.on.length-1]}if(el){$timeout(()=>{el.scrollTop=el.scrollHeight})}};$scope.getSuggestionsFunction=DataikuAPI.flow.recipes.geojoin.getSuggestions;function sendRecipeParamsToWT1(){$scope.tryRecipeWT1Event("geo-join-params",()=>{function createFilterWT1Entry(filter){if(!filter){return undefined}return{enabled:filter.enabled,mode:filter.uiData&&filter.uiData.mode,distinct:filter.distinct,geoContains:filter.uiData&&filter.uiData.mode==="CUSTOM"&&filter.expression.includes("geoContains")}}return{joins:JSON.stringify($scope.params.joins.map(join=>{return{engine:$scope.recipeStatus&&$scope.recipeStatus.selectedEngine&&$scope.recipeStatus.selectedEngine.label,type:join.type,conditionsMode:join.conditionsMode,on:join.on.map(on=>{const column1=$scope.getColumn($scope.getDatasetName(on.column1.table),on.column1.name);const column2=$scope.getColumn($scope.getDatasetName(on.column2.table),on.column2.name);return{conditionsMode:on.conditionsMode,threshold:on.threshold,type:on.type,unit:on.unit,column1:column1?column1.type:null,column2:column2?column2.type:null}})}})),postFilter:JSON.stringify(createFilterWT1Entry($scope.params.postFilter)),preFilters:JSON.stringify($scope.params.virtualInputs.map(i=>createFilterWT1Entry(i.preFilter)))}},"Failed to report Geo join params")}const originalSave=$scope.hooks.save;$scope.hooks.save=function(){sendRecipeParamsToWT1();return originalSave()}}]);app.controller("NewVirtualInputController",function($scope,$stateParams,DatasetUtils){$scope.newInput={};$scope.isValid=function(){return!!$scope.newInput.dataset};$scope.addInput=function(){$scope.addDataset($scope.newInput.dataset)};DatasetUtils.listDatasetsUsabilityInAndOut($stateParams.projectKey,"geojoin").then(function(data){$scope.availableInputDatasets=data[0]})})})();(function(){"use strict";var app=angular.module("dataiku.recipes");app.controller("SyncRecipeCreationController",function($scope,$rootScope,Fn,$stateParams,DataikuAPI,$controller,FeatureFlagsService){$scope.recipeType="sync";if($rootScope.appConfig.streamingEnabled){$scope.datasetsOnly=false;$scope.inputDatasetsOnly=true}$controller("SingleOutputDatasetRecipeCreationController",{$scope:$scope});if($rootScope.appConfig.streamingEnabled){$scope.singleOutputRole.acceptsStreamingEndpoint=true}$scope.autosetName=function(){if($scope.io.inputDataset){var niceInputName=$scope.io.inputDataset.replace(/[A-Z]*\./,"");$scope.maybeSetNewDatasetName(niceInputName+"_copy")}}});app.controller("SyncRecipeController",function($scope,$stateParams,$q,$controller,Assert,StateUtils,DataikuAPI,Dialogs,TopNav,RecipesUtils,PartitionDeps,ComputableSchemaRecipeSave,Logger,translate){Assert.inScope($scope,"recipe");$controller("_RecipeWithEngineBehavior",{$scope:$scope});$scope.schemaModes=[["FREE_SCHEMA_NAME_BASED",translate("RECIPE.SCHEMA_MODE.FREE_SCHEMA_NAME_BASED","Free output schema (name-based matching)")],["STRICT_SYNC",translate("RECIPE.SCHEMA_MODE.STRICT_SYNC","Maintain strict schema equality")]];$scope.hooks.save=function(){if($scope.recipe.params.schemaMode=="FREE_SCHEMA_NAME_BASED"){return $scope.hooks.origSaveHook()}else{var deferred=$q.defer();var recipeSerialized=angular.copy($scope.recipe);PartitionDeps.prepareRecipeForSerialize(recipeSerialized);ComputableSchemaRecipeSave.handleSave($scope,recipeSerialized,null,deferred);return deferred.promise}};$scope.hooks.onRecipeLoaded=function(){Logger.info("On Recipe Loaded");$scope.hooks.updateRecipeStatus()};$scope.hooks.updateRecipeStatus=function(){var deferred=$q.defer();$scope.updateRecipeStatusBase(false).then(function(){if(!$scope.recipeStatus)return deferred.reject();deferred.resolve($scope.recipeStatus)});return deferred.promise};$scope.resyncSchema=function(){var input=RecipesUtils.getSingleInput($scope.recipe,"main");var output=RecipesUtils.getSingleOutput($scope.recipe,"main");Dialogs.confirmPositive($scope,translate("RECIPE.RESYNC_SCHEMA.CONFIRM.TITLE","Resynchronize schema"),translate("RECIPE.RESYNC_SCHEMA.CONFIRM.TEXT",'The schema of "{{input}}" will be copied to "{{output}}". Are you sure you want to continue?',{input:input.ref,output:output.ref})).then(function(){DataikuAPI.flow.recipes.basicResyncSchema($stateParams.projectKey,$scope.hooks.getRecipeSerialized()).error(setErrorInScope.bind($scope))})};TopNav.setTab(StateUtils.defaultTab("io"));$scope.recipe.params=$scope.recipe.params||{};$scope.recipe.params.schemaMode=$scope.recipe.params.schemaMode||"FREE_SCHEMA_NAME_BASED";$scope.params=$scope.recipe.params;$scope.$watch("recipe.params",$scope.updateRecipeStatusLater,true);$scope.enableAutoFixup();$scope.specificControllerLoadedDeferred.resolve()})})();(function(){"use strict";const app=angular.module("dataiku.recipes");app.controller("ExtractFailedRowsRecipeCreationController",function($scope,$controller){$scope.recipeType="extract_failed_rows";$scope.datasetsOnly=true;$scope.inputDatasetsOnly=true;$controller("SingleOutputDatasetRecipeCreationController",{$scope:$scope});$scope.autosetName=function(){if($scope.io.inputDataset){const niceInputName=$scope.io.inputDataset.replace(/[A-Z]*\./,"");$scope.maybeSetNewDatasetName(niceInputName+"_failed_rows")}}});app.controller("ExtractFailedRowsRecipeController",function($scope,$stateParams,$q,$timeout,DKUtils,Logger,$controller,DatasetUtils,translate,ActivityIndicator){const visualCtrl=$controller("VisualRecipeEditorController",{$scope:$scope});this.visualCtrl=visualCtrl;const contextProjectKey=$scope.context&&$scope.context.projectKey?$scope.context.projectKey:$stateParams.projectKey;$scope.hooks.getPayloadData=function(){return angular.toJson($scope.params)};$scope.hooks.updateRecipeStatus=function(forceUpdate,exactPlan){const payload=$scope.hooks.getPayloadData();if(!payload)return $q.reject("payload not ready");const deferred=$q.defer();$scope.updateRecipeStatusBase(forceUpdate,payload,{reallyNeedsExecutionPlan:exactPlan,exactPlan:exactPlan}).then(function(){if(!$scope.recipeStatus){return deferred.reject()}const outputSchema=$scope.recipeStatus.outputSchema;const outputSchemaBO=$scope.recipeStatus.outputSchemaBeforeOverride;if(outputSchema){$scope.params.outputColumnNameOverrides=$scope.params.outputColumnNameOverrides||{};const columnsAO=outputSchema.columns;const columnsBO=outputSchemaBO&&outputSchemaBO.columns?outputSchemaBO.columns:outputSchema.columns;for(const i in columnsAO){if(columnsAO[i].name!=columnsBO[i].name){$scope.params.outputColumnNameOverrides[columnsBO[i].name]=columnsAO[i].name}columnsAO[i].$beforeOverride=columnsBO[i].name;columnsAO[i].name=$scope.params.outputColumnNameOverrides[columnsBO[i].name]||columnsBO[i].name}}$scope.uiState.columnRules=angular.copy($scope.recipeStatus.consolidatedColumnRules);if(!angular.equals($scope.params.columnRules,$scope.getParamsColumnRulesFromUiStateColumnRules())){ActivityIndicator.success(translate("EXTRACT_FAILED_ROWS_RECIPE.STEPS.RULES.RULES_AUTO_FIXED","Recipe configuration has been updated to reflect changes on the dataset Data Quality rules"),5e3)}deferred.resolve($scope.recipeStatus)});return deferred.promise};function loadParamsFromScript(scriptData){if(!scriptData){return}$scope.params=JSON.parse(scriptData);$scope.params.outputColumnNameOverrides=$scope.params.outputColumnNameOverrides||{};$scope.uiState.selectAllValidRules=!$scope.params.explicitColumnSelection;visualCtrl.saveServerParams();resyncWithInputSchema()}function resyncWithInputSchema(){$scope.params=$scope.params||{};if($scope.onResyncWithInputSchema){$scope.onResyncWithInputSchema()}}function onScriptChanged(nv,ov){if(nv){loadParamsFromScript($scope.script.data);DKUtils.reflowNext();DKUtils.reflowLater();$scope.hooks.updateRecipeStatus()}}$scope.uiState={currentStep:"rules",outputColumnNamesOverridable:true,columnRules:[],selectAllValidRules:true};$scope.selectAllColumnRules=function(){$scope.uiState.columnRules.forEach(desc=>{if(!desc.isSelected&&desc.isSupported){desc.isSelected=true}})};$scope.updateColumnNameOverride=function(column){if(column.$beforeOverride!=column.name){$scope.params.outputColumnNameOverrides[column.$beforeOverride]=column.name}else{delete $scope.params.outputColumnNameOverrides[column.$beforeOverride]}};$scope.hooks.onRecipeLoaded=function(){Logger.info("On Recipe Loaded");$scope.$watch("script.data",onScriptChanged,true);$scope.$watchCollection("recipe.inputs.main.items",function(){DatasetUtils.updateRecipeComputables($scope,$scope.recipe,$stateParams.projectKey,contextProjectKey).then(_=>resyncWithInputSchema())})};$scope.$watch("topNav.tab",function(nv){if(nv=="settings"){$timeout(function(){$scope.$broadcast("redrawFatTable")})}});$scope.getParamsColumnRulesFromUiStateColumnRules=function(){return $scope.uiState.columnRules.map(uiDesc=>{return{ruleId:uiDesc.ruleId,ruleColumn:uiDesc.ruleColumn,isSelected:uiDesc.isSelected}})};$scope.$watch("uiState.columnRules",columnRules=>{if(!$scope.params){return}const numSelectedRules=$scope.uiState.columnRules.filter(desc=>desc.isSelected).length;const numTotalRules=$scope.uiState.columnRules.length;$scope.ruleCounters=translate("EXTRACT_FAILED_ROWS_RECIPE.STEPS.RULES.TO_BE_EXTRACTED","{{numSelectedRules}} / {{numTotalRules}} {{numSelectedRules == 1 ? 'rule' : 'rules'}} to be extracted",{numSelectedRules:numSelectedRules,numTotalRules:numTotalRules});$scope.params.columnRules=$scope.getParamsColumnRulesFromUiStateColumnRules();$scope.updateRecipeStatusLater()},true);$scope.$watch("uiState.selectAllValidRules",()=>{if(!$scope.params){return}$scope.params.explicitColumnSelection=!$scope.uiState.selectAllValidRules;$scope.updateRecipeStatusLater()});$scope.enableAutoFixup();$scope.specificControllerLoadedDeferred.resolve()})})();(function(){"use strict";var app=angular.module("dataiku.recipes");app.controller("UpdateRecipeCreationController",function($scope,Fn,$stateParams,DataikuAPI,$controller){$scope.recipeType="update";$controller("SingleOutputDatasetRecipeCreationController",{$scope:$scope});$scope.inlineDataset=true;$scope.autosetName=function(){if($scope.io.inputDataset){var niceInputName=$scope.io.inputDataset.replace(/[A-Z]*\./,"");$scope.maybeSetNewDatasetName(niceInputName+"_copy")}}});app.controller("UpdateRecipeController",function($scope,$stateParams,$q,$timeout,DataikuAPI,Dialogs,PartitionDeps,RecipesUtils,ActivityIndicator,ComputableSchemaRecipeSave){$scope.hooks.save=function(){var deferred=$q.defer();var recipeSerialized=angular.copy($scope.recipe);PartitionDeps.prepareRecipeForSerialize(recipeSerialized);var serializedPayload=angular.toJson($scope.recipe.params);ComputableSchemaRecipeSave.handleSave($scope,recipeSerialized,serializedPayload,deferred);return deferred.promise};$scope.hooks.preRunValidate=function(){var deferred=$q.defer();if(!$scope.recipe.params.uniqueKey||$scope.recipe.params.uniqueKey.length==0){ActivityIndicator.error("Unique key is required");deferred.reject("Unique key is required")}else{deferred.resolve({ok:true})}return deferred.promise};$scope.uiState={};$scope.recipe.params=$scope.recipe.params||{};$scope.recipe.params.uniqueKey=$scope.recipe.params.uniqueKey||[];$scope.recipe.params.filter=$scope.recipe.params.filter||{};$scope.recipe.params.addMissingRows=$scope.recipe.params.addMissingRows!==undefined?$scope.recipe.params.addMissingRows:true;$scope.recipe.params.deleteMissingCols=$scope.recipe.params.deleteMissingCols||false;$scope.recipe.params.deleteMissingRows=$scope.recipe.params.deleteMissingRows||false;$scope.recipe.params.addMissingCols=$scope.recipe.params.addMissingCols!==undefined?$scope.recipe.params.addMissingCols:true;$scope.getInputName=function(idx,role){idx=idx||0;role=role||"main";return $scope.recipe.inputs[role].items[idx].ref};$scope.getInputSchema=function(idx,role){if($scope.computablesMap){return $scope.computablesMap[$scope.getInputName(idx,role)].dataset.schema}};function getInputColumns(){return $scope.getInputSchema().columns.map(function(col){return col.name})}$scope.updateSuggests=function(){var schema=$scope.getInputSchema();if(schema&&schema.columns){$scope.remainingSuggests=listDifference(getInputColumns(),$scope.recipe.params.uniqueKey)}};$scope.addKeyPart=function(name){if(listDifference(getInputColumns(),$scope.recipe.params.uniqueKey).indexOf(name)>=0){$scope.recipe.params.uniqueKey.push(name);$scope.updateSuggests();$timeout(function(){$scope.uiState.newKeyPart="";$("#keypart").blur()})}};$scope.removeKeyPart=function(index){$scope.recipe.params.uniqueKey.splice(index,1);$scope.updateSuggests()};$scope.$on("typeahead-updated",function(){safeApply($scope,function(){$scope.addKeyPart($scope.uiState.newKeyPart)})});$scope.$on("computablesMapChanged",$scope.updateSuggests,true);$scope.$watch("getInputSchema()",$scope.updateSuggests);$scope.updateSuggests();$scope.enableAutoFixup()});app.directive("exportRecipeBody",function(Assert,ExportService){return{scope:true,link:function($scope){Assert.inScope($scope,"recipe");let setExportParams=function(params){$scope.recipe.params.exportParams=params};ExportService.initExportBehavior($scope,{},{advancedSampling:true,partitionListLoader:null},$scope.recipe.params,null,$scope.recipe.params.exportParams,setExportParams)}}});app.controller("ExportRecipeCreationController",function($scope,$stateParams,$state,$controller,Fn,DataikuAPI,WT1,RecipesUtils,RecipeDescService,RecipeComputablesService,PartitionDeps,BigDataService){$controller("_RecipeCreationControllerBase",{$scope:$scope});function init(){$scope.recipeName={};$scope.script="";$scope.recipe={projectKey:$stateParams.projectKey,type:"export",inputs:{},outputs:{},params:{}};if($scope.recipePrefillKey){var prefill=BigDataService.fetch($scope.recipePrefillKey);if(prefill){if(prefill.script){$scope.script=prefill.script}if(prefill.input){prefill.input.forEach(function(x){RecipesUtils.addInput($scope.recipe,"main",x)})}if(prefill.output){prefill.output.forEach(function(x){RecipesUtils.addOutput($scope.recipe,"main",x)})}}}$scope.$on("preselectInputDataset",function(scope,preselectedInputDataset){RecipesUtils.addInput($scope.recipe,"main",preselectedInputDataset);$scope.preselectedInputDataset=preselectedInputDataset});RecipeComputablesService.getComputablesMap($scope.recipe,$scope).then(function(map){$scope.setComputablesMap(map)})}$scope.$watch("[recipe.inputs, recipe.outputs]",function(nv,ov){if(nv&&$scope.recipe&&$scope.recipe.inputs&&$scope.recipe.outputs){if($scope.preselectedInputDataset&&$scope.recipe.inputs.main.items[0].ref!=$scope.preselectedInputDataset){$scope.zone=null}var outputs=RecipesUtils.getFlatOutputsList($scope.recipe);$scope.hasRequiredIO=RecipeDescService.hasValidRequiredRoles($scope.recipe);if(outputs.length&&$scope.hasRequiredIO){$scope.recipeName.name="compute_"+outputs[0].ref}else{$scope.recipeName.name=null}}},true);init();addDatasetUniquenessCheck($scope,DataikuAPI,$stateParams.projectKey);fetchManagedDatasetConnections($scope,DataikuAPI)});app.controller("ExportRecipeController",function($scope,$controller,Logger,$q,PartitionDeps){$scope.dateTimePatternDocLink="https://docs.oracle.com/en/java/javase/17/docs/api/java.base/java/time/format/DateTimeFormatter.html";$scope.recipe.params.timestampPrefix=$scope.recipe.params.timestampPrefix||{enabled:false,format:"yyyy-MM-dd'T'HH:mm:ssX"};$controller("_RecipeWithEngineBehavior",{$scope:$scope});$scope.hooks.save=function(){var deferred=$q.defer();var recipeSerialized=angular.copy($scope.recipe);PartitionDeps.prepareRecipeForSerialize(recipeSerialized);$scope.baseSave(recipeSerialized,null).then(function(){deferred.resolve("Save done")},function(error){Logger.error("Could not save recipe");deferred.reject("Could not save recipe")});return deferred.promise};$scope.hooks.preRunValidate=function(){var deferred=$q.defer();deferred.resolve({ok:true});return deferred.promise};$scope.enableAutoFixup();$scope.hooks.onRecipeLoaded=function(){$scope.hooks.updateRecipeStatus()};$scope.hooks.updateRecipeStatus=function(){const deferred=$q.defer();$scope.updateRecipeStatusBase(false).then(function(){if(!$scope.recipeStatus)return deferred.reject();deferred.resolve($scope.recipeStatus)});return deferred.promise};$scope.$watch("recipe.params",$scope.updateRecipeStatusLater,true);$scope.$watch("topNav.tab",function(newVal){if(newVal==="settings"){$scope.loadRecipeVariables()}})})})();(function(){"use strict";var app=angular.module("dataiku.recipes");app.controller("DownloadRecipeCreationController",function($scope,$stateParams,$state,$controller,Fn,DataikuAPI,WT1,RecipesUtils,RecipeDescService,DatasetsService,RecipeComputablesService,PartitionDeps,BigDataService,DatasetUtils){$controller("_RecipeCreationControllerBase",{$scope:$scope});$controller("_RecipeOutputNewManagedBehavior",{$scope:$scope});$scope.uiState=$scope.uiState||{};$scope.io.newOutputTypeRadio="new-odb";$scope.recipeType="download";$scope.setErrorInTopScope=function(scope){return setErrorInScope.bind($scope)};var makeMainRole=function(refs){return{main:{items:refs.filter(function(ref){return!!ref}).map(function(ref){return{ref:ref}})}}};$scope.doCreateRecipe=function(){var createOutputFolder=$scope.io.newOutputTypeRadio=="new-odb";var outputRef=createOutputFolder?$scope.newOutputODB.name:$scope.io.existingOutputDataset;var outputName=createOutputFolder?$scope.newOutputODB.name:$scope.availableOutputFolders.filter(function(f){return f.smartName==$scope.io.existingOutputDataset})[0].label;var recipe={type:$scope.recipeType,projectKey:$stateParams.projectKey,name:"download_to_"+outputName,inputs:{},outputs:makeMainRole([outputRef])};if($scope.zone)recipe.zone=$scope.zone;var settings={createOutputFolder:createOutputFolder,outputFolderSettings:$scope.getFolderCreationSettings()};return DataikuAPI.flow.recipes.generic.create(recipe,settings)};$scope.createRecipe=function(){$scope.recipeWT1Event("recipe-create-"+$scope.recipeType);var p=$scope.doCreateRecipe();if(p){$scope.creatingRecipe=true;p.success(function(data){$scope.creatingRecipe=false;$scope.dismiss();$scope.$state.go("projects.project.recipes.recipe",{recipeName:data.id})}).error(function(a,b,c){$scope.creatingRecipe=false;setErrorInScope.bind($scope)(a,b,c)})}};$scope.formIsValid=function(){if($scope.io.newOutputTypeRadio=="new-odb"){return $scope.newOutputODB&&$scope.newOutputODB.name&&$scope.newOutputODB.connectionOption}else if($scope.io.newOutputTypeRadio=="select"){return $scope.io.existingOutputDataset}else{return false}};DatasetUtils.listFoldersUsabilityForOutput($stateParams.projectKey,$scope.recipeType).then(function(data){$scope.availableOutputFolders=data.filter(function(computable){return computable.usableAsOutput["main"]&&computable.usableAsOutput["main"].usable&&!computable.alreadyUsedAsOutputOf})});var updateManagedFolderOptions=function(){var recipe={type:$scope.recipeType,projectKey:$stateParams.projectKey,name:"compute_",inputs:{},outputs:{}};DataikuAPI.datasets.getManagedFolderOptions(recipe,"main").success(function(data){$scope.setupManagedFolderOptions(data)}).error($scope.setErrorInTopScope($scope))};updateManagedFolderOptions()});app.controller("DownloadRecipeController",function($scope,$stateParams,$q,DataikuAPI,Logger,PartitionDeps,RecipesUtils){$scope.hooks.save=function(){var deferred=$q.defer();var recipeSerialized=angular.copy($scope.recipe);PartitionDeps.prepareRecipeForSerialize(recipeSerialized);$scope.baseSave(recipeSerialized,null).then(function(){deferred.resolve("Save done")},function(error){Logger.error("Could not save recipe");deferred.reject("Could not save recipe")});return deferred.promise};$scope.hooks.preRunValidate=function(){var deferred=$q.defer();deferred.resolve({ok:true});return deferred.promise};$scope.isOutputPartitioned=function(){return RecipesUtils.hasAnyPartitioning($scope.recipe,$scope.computablesMap)};$scope.enableAutoFixup();$scope.hasConnectionHasMetadata=function(source){return["Azure","S3","GCS"].indexOf(source.providerType)>=0};$scope.getDefaultPath=function(source){return["FTP","SFTP","SCP","Azure","S3","GCS","SharePointOnline"].indexOf(source.providerType)>=0?"":"/"};var contextVars={};$scope.getContextVars=function(){return contextVars};$scope.getConnectionType=function(t){return t=="SFTP"||t=="SCP"?"SSH":t};$scope.selectableProviderTypes=[];$scope.updateSelectableStorageBackends=function(){let sourceProviderTypes=[];if($scope.recipe&&$scope.recipe.params&&$scope.recipe.params.sources){sourceProviderTypes=$scope.recipe.params.sources.map(s=>s.providerType)}$scope.selectableProviderTypes=$scope.providerTypes.filter(b=>b.permitted||sourceProviderTypes.indexOf(b.providerType)>=0).map(b=>b.providerType)};$scope.providerTypes=[];DataikuAPI.datasets.listFSProviderTypes(true).success(function(data){$scope.providerTypes=data;$scope.providerTypes=[{providerType:"URL",permitted:true}].concat($scope.providerTypes);$scope.updateSelectableStorageBackends()}).error(setErrorInScope.bind($scope));$scope.$watch("recipe.params.sources",$scope.updateSelectableStorageBackends);$scope.addSource=function(){var source={useGlobalProxy:true,providerType:"URL",params:{path:"",consider404AsEmpty:true,fallbackHeadToGet:true,trustAnySSLCertificate:false}};$scope.recipe.params.sources.push(source)};$scope.removeSource=function(index){$scope.recipe.params.sources.splice(index,1)};$scope.onProviderParamsChanged=function(source){};$scope.checkSource=function(source){var recipeSerialized=angular.copy($scope.recipe);PartitionDeps.prepareRecipeForSerialize(recipeSerialized);DataikuAPI.flow.recipes.download.checkDownloadSource($stateParams.projectKey,recipeSerialized,source,source.$testPartition).success(function(data){source.$check=data}).error(setErrorInScope.bind($scope))};$scope.$watch("topNav.tab",function(newVal){if(newVal==="settings"){$scope.loadRecipeVariables()}})});app.controller("CreateUrlDownloadToFolderDatasetController",function($scope,$state,$timeout,DataikuAPI,WT1,JobDefinitionComputer){var folder;$scope.downloading=false;$scope.params={url:"",connection:null,recipeName:null,folderName:"",folderId:null};$scope.$watch("params.projectKey",function(projectKey){DataikuAPI.datasets.getManagedFolderOptionsNoContext(projectKey).success(function(data){$scope.connections=data.connections.filter(function(_){return["Filesystem","HDFS"].indexOf(_.connectionType)>=0});var selected=$scope.connections.map(function(_){return _.connectionName}).indexOf("filesystem_managed");if(selected<0){selected=$scope.connections.map(function(_){return _.connectionType}).indexOf("Filesystem");if(selected<0&&$scope.connections.length>0){selected=0}}if(selected>=0){$scope.params.connection=$scope.connections[selected]}})});$scope.checkURL=function(){$scope.downloading=true;function done(data){$scope.downloadCheck=data;$scope.downloading=false;if(data.successful){var url=new URL($scope.params.url);if(!$scope.params.folderName){$scope.params.folderName=url.hostname}}}DataikuAPI.flow.recipes.download.checkDownloadURL($scope.projectKey,$scope.params.url).success(done).error(done)};$scope.createFolderAndDownload=function(){if(!$scope.params.folderId){WT1.event("new-managed-folder-modal-create");DataikuAPI.datasets.newManagedFolder($scope.params.projectKey,$scope.params.folderName,{type:$scope.params.connection.fsProviderTypes[0],connectionId:$scope.params.connection.connectionName,partitioningOptionId:"NP"}).success(function(data){$scope.params.folderId=data.id;folder=data;createRecipe()}).error(setErrorInScope.bind($scope))}else if(!$scope.params.recipeName){createRecipe()}else{runRecipe()}};$scope.goToFolder=function(){$state.go("projects.project.managedfolders.managedfolder.view",{odbId:$scope.params.folderId});$scope.dismiss()};$scope.goCreateDataset=function(){$state.go("projects.project.datasets.new_with_type.settings",{type:"FilesInFolder",prefillParams:JSON.stringify({folderSmartId:$scope.params.folderId,itemPathPattern:"/.*"})});$scope.dismiss();return};function createRecipe(){var recipe={name:"compute_"+$scope.params.folderId,projectKey:$scope.params.projectKey,type:"download",inputs:{},outputs:{main:{items:[{ref:$scope.params.folderId,deps:[]}]}},params:{deleteExtraFiles:true,copyEvenUpToDateFiles:false,sources:[{useGlobalProxy:true,providerType:"URL",params:{path:$scope.params.url}}]}};$scope.creatingRecipe=true;DataikuAPI.flow.recipes.generic.create(recipe,{script:""}).success(function(data){$scope.params.recipeName=data.id;$scope.creatingRecipe=false;runRecipe()}).error(function(a,b,c){$scope.creatingRecipe=false;setErrorInScope.bind($scope)(a,b,c)})}function runRecipe(){$scope.downloading=true;$scope.jobStatus=null;var jd=JobDefinitionComputer.computeJobDefForBox($scope.params.projectKey,"NON_RECURSIVE_FORCED_BUILD",folder,null,"RECIPE",$scope.params.recipeName);DataikuAPI.flow.jobs.start(jd).success(function(data){$scope.jobId=data.id;waitForEndOfRecipeRun()}).error(function(a,b,c){$scope.downloading=false;setErrorInScope.bind($scope)(a,b,c)})}function waitForEndOfRecipeRun(){DataikuAPI.flow.jobs.getJobStatus($scope.params.projectKey,$scope.jobId).success(function(data){$scope.jobStatus=data;data.totalWarningsCount=0;for(var actId in data.baseStatus.activities){var activity=data.baseStatus.activities[actId];if(activity.warnings){data.totalWarningsCount+=activity.warnings.totalCount}}if(data.baseStatus.state!="DONE"&&data.baseStatus.state!="ABORTED"&&data.baseStatus.state!="FAILED"){$scope.jobCheckTimer=$timeout(waitForEndOfRecipeRun,2e3)}else{$scope.downloading=false}}).error(setErrorInScope.bind($scope))}})})();(function(){"use strict";const app=angular.module("dataiku.recipes");app.controller("MergeFolderRecipeCreationController",function($scope,$controller,$stateParams,DataikuAPI,Fn,RecipeComputablesService){$controller("CodeBasedRecipeCreationController",{$scope:$scope});$scope.recipeType="merge_folder";$scope.recipeName={};$scope.recipe={type:"merge_folder",projectKey:$stateParams.projectKey,inputs:{main:{items:[]}},outputs:{main:{items:[]}}};RecipeComputablesService.getComputablesMap($scope.recipe,$scope).then(function(map){$scope.setComputablesMap(map)})});app.controller("MergeFolderRecipeController",function($scope,$controller,$q,Logger,PartitionDeps){$controller("_RecipeWithEngineBehavior",{$scope:$scope});$scope.hooks.save=function(){const deferred=$q.defer();const recipeSerialized=angular.copy($scope.recipe);PartitionDeps.prepareRecipeForSerialize(recipeSerialized);$scope.baseSave(recipeSerialized,null).then(function(){deferred.resolve("Save done")},function(error){Logger.error("Could not save recipe");deferred.reject("Could not save recipe")});return deferred.promise};$scope.hooks.preRunValidate=function(){const deferred=$q.defer();deferred.resolve({ok:true});return deferred.promise};$scope.enableAutoFixup();$scope.hooks.onRecipeLoaded=function(){$scope.hooks.updateRecipeStatus()};$scope.hooks.updateRecipeStatus=function(){const deferred=$q.defer();$scope.updateRecipeStatusBase(false).then(function(){if(!$scope.recipeStatus)return deferred.reject();deferred.resolve($scope.recipeStatus)});return deferred.promise};$scope.$watch("recipe.params",$scope.updateRecipeStatusLater,true);$scope.conflictHandlings=[["SUFFIX","Add a suffix when conflicts happen"],["FAIL","Fail if files conflict"],["OVERWRITE","Overwrite files with the same name"]];$scope.recipe.params.conflictHandling=$scope.recipe.params.conflictHandling||"OVERWRITE"})})();(function(){"use strict";const app=angular.module("dataiku.recipes");app.controller("ListFolderContentsRecipeCreationController",function($scope,$controller,$stateParams,DataikuAPI,RecipeComputablesService){$scope.recipeType="list_folder_contents";$scope.inputFolderOnly=true;$controller("SingleOutputDatasetRecipeCreationController",{$scope:$scope});$scope.autosetName=async function(){if($scope.io.inputFolder&&$scope.io.inputFolder.name){const niceInputName=(await DataikuAPI.shakers.convertToASCII([$scope.io.inputFolder.name],true,true)).data[0];$scope.maybeSetNewDatasetName(niceInputName+"_files")}};$scope.recipeName={};$scope.recipe={type:"list_folder_contents",projectKey:$stateParams.projectKey,inputs:{main:{items:[]}},outputs:{main:{items:[]}}};$scope.$watchCollection("recipe.inputs.main.items",function(inputs){if(inputs&&inputs.length){const folderId=inputs[0].ref;$scope.io.inputFolder={smartName:folderId,name:$scope.computablesMap[folderId]&&$scope.computablesMap[folderId].label};DataikuAPI.flow.zones.getZoneId($stateParams.projectKey,{id:folderId,type:"MANAGED_FOLDER",projectKey:$stateParams.projectKey}).success(function(zone){$scope.zone=zone.id}).error(setErrorInScope.bind($scope))}});RecipeComputablesService.getComputablesMap($scope.recipe,$scope).then(function(map){$scope.setComputablesMap(map)})});app.controller("ListFolderContentsRecipeController",function($controller,$scope,$q,PartitionDeps,ComputableSchemaRecipeSave){$controller("_RecipeWithEngineBehavior",{$scope:$scope});$scope.hooks.save=function(){const deferred=$q.defer();const recipeSerialized=angular.copy($scope.recipe);PartitionDeps.prepareRecipeForSerialize(recipeSerialized);ComputableSchemaRecipeSave.handleSave($scope,recipeSerialized,"",deferred);return deferred.promise};$scope.hooks.preRunValidate=function(){const deferred=$q.defer();deferred.resolve({ok:true});return deferred.promise};$scope.enableAutoFixup();$scope.recipe.params.levelMapping=$scope.recipe.params.levelMapping||[];$scope.hooks.onRecipeLoaded=function(){$scope.hooks.updateRecipeStatus()};$scope.hooks.updateRecipeStatus=function(){const deferred=$q.defer();$scope.updateRecipeStatusBase(false).then(function(){if(!$scope.recipeStatus)return deferred.reject();deferred.resolve($scope.recipeStatus)});return deferred.promise};$scope.$watch("recipe.params",$scope.updateRecipeStatusLater,true);const booleanParameters=["path","basename","extension","lastModified","size"];for(const bp of booleanParameters){$scope.recipe.params[bp]=typeof $scope.recipe.params[bp]==="boolean"?$scope.recipe.params[bp]:true}})})();(function(){"use strict";const app=angular.module("dataiku.recipes");app.controller("ListAccessRecipeCreationController",function($scope,$controller,$stateParams,DataikuAPI,RecipeComputablesService){$scope.recipeType="list_access";$scope.inputFolderOnly=true;$controller("SingleOutputDatasetRecipeCreationController",{$scope:$scope});$scope.autosetName=async function(){if($scope.recipe?.inputs?.main?.items?.[0]?.description){const niceInputName=(await DataikuAPI.shakers.convertToASCII([$scope.recipe.inputs.main.items[0].description],true,true)).data[0];$scope.maybeSetNewDatasetName(niceInputName+"_access")}};$scope.recipeName={};$scope.recipe={type:"list_access",projectKey:$stateParams.projectKey,inputs:{main:{items:[]},manualMapping:{items:[]}},outputs:{main:{items:[]}}};$scope.$watchCollection("recipe.inputs.main.items",function(inputs){if(inputs?.length){const folderId=inputs[0].ref;$scope.io.inputFolder={smartName:folderId,name:$scope.computablesMap?.[folderId]?.label};DataikuAPI.flow.zones.getZoneId($stateParams.projectKey,{id:folderId,type:"MANAGED_FOLDER",projectKey:$stateParams.projectKey}).success(function(zone){$scope.zone=zone.id}).error(setErrorInScope.bind($scope))}});RecipeComputablesService.getComputablesMap($scope.recipe,$scope).then(function(map){$scope.setComputablesMap(map)})});app.controller("ListAccessRecipeController",function($controller,$scope,$q,PartitionDeps,ComputableSchemaRecipeSave,SmartId,DataikuAPI){$controller("_RecipeWithEngineBehavior",{$scope:$scope});$scope.hooks.save=function(){const deferred=$q.defer();const recipeSerialized=angular.copy($scope.recipe);PartitionDeps.prepareRecipeForSerialize(recipeSerialized);ComputableSchemaRecipeSave.handleSave($scope,recipeSerialized,"",deferred);return deferred.promise};$scope.hooks.preRunValidate=function(){const deferred=$q.defer();deferred.resolve({ok:true});return deferred.promise};$scope.enableAutoFixup();$scope.hooks.onRecipeLoaded=function(){$scope.hooks.updateRecipeStatus()};$scope.hooks.updateRecipeStatus=function(){const deferred=$q.defer();$scope.updateRecipeStatusBase(false).then(function(){if(!$scope.recipeStatus)return deferred.reject();deferred.resolve($scope.recipeStatus)});return deferred.promise};$scope.$watch("recipe.inputs.manualMapping.items",function(nv,ov){if(!nv)return;$scope.manualMappingDataset=nv.length?nv[0].ref:undefined;if(!$scope.manualMappingDataset){$scope.manualMappingDatasetColumns=[];return}const resolvedRef=SmartId.resolve($scope.manualMappingDataset,$scope.recipe.projectKey);DataikuAPI.datasets.get(resolvedRef.projectKey,resolvedRef.id,$scope.recipe.projectKey).then(response=>{const schema=response.data.schema;$scope.manualMappingDatasetColumns=schema.columns.map(col=>col.name);if(!ov||ov.length!==1||nv[0].ref!==ov[0].ref){$scope.recipe.params.manualMappingDssGroupCol=undefined;$scope.recipe.params.manualMappingEntraGroupCol=undefined}})},true);$scope.$watch("computablesMap",function(nv,ov){if(nv==null||ov!=null){return}const outputName=$scope.recipe?.outputs?.main?.items?.[0]?.ref;if(outputName!=null&&$scope.computablesMap?.[outputName]){$scope.computablesMap[outputName].usableAsInput.manualMapping.usable=false;$scope.computablesMap[outputName].usableAsInput.manualMapping.reason="The output of this recipe cannot be used as an input for itself"}},true);$scope.$watch("recipe.params",$scope.updateRecipeStatusLater,true)})})();(function(){"use strict";const app=angular.module("dataiku.recipes");app.controller("_DocExtractionRecipeControllerBase",function($scope,$state,$rootScope,$q,$controller,$stateParams,DataikuAPI,RequestCenterService,EmbeddingUtils,DOCUMENT_SPLITTING_METHOD_MAP,UPDATE_METHOD_MAP){$controller("RAGEmbeddingRecipeEditionController",{$scope:$scope,VECTOR_STORE_UPDATE_METHOD_MAP:UPDATE_METHOD_MAP});$controller("_RecipeWithEngineBehavior",{$scope:$scope});DataikuAPI.flow.recipes.nlp.getDefaultEmbedDocumentRecipeSettings($stateParams.projectKey).success(function(data){if(data?.defaultVLMId){$scope.adminDefaultVLMId=data.defaultVLMId;$scope.setDefaultVLM()}}).error(setErrorInScope.bind($scope));DataikuAPI.pretrainedModels.listAvailableLLMs($stateParams.projectKey,"IMAGE_INPUT").success(function(data){$scope.availableVLMs=data.identifiers;$scope.setDefaultVLM()}).error(setErrorInScope.bind($scope));$scope.setDefaultVLM=function(){if(!$scope.recipe.params.defaultVlmId){if($scope.adminDefaultVLMId&&$scope.availableVLMs&&$scope.availableVLMs.some(x=>x.id===$scope.adminDefaultVLMId)){$scope.recipe.params.defaultVlmId=$scope.adminDefaultVLMId}else if($scope.availableVLMs&&$scope.availableVLMs.length>0){$scope.recipe.params.defaultVlmId=$scope.availableVLMs[0].id}}};$scope.EMBED_DOCS_EXTRACTION_MODES=[{id:"MANAGED_TEXT_ONLY",title:"Text-first Extraction",base_description:"Extracts text from documents and uses headers to divide the content into meaningful extraction units. Supported file formats: {0}."},{id:"MANAGED_VISUAL_ONLY",title:"Visual-first Extraction",base_description:"Uses a Vision Language Model (VLM) to extract information from documents that may include text and visual elements like charts, graphics, and tables. Supported file formats: PDF, DOC, DOCX, PPT, PPTX, ODP, ODT, JPG, JPEG, PNG, TXT, MD."},{id:"CUSTOM_RULES",title:"Custom rules",base_description:"Create your own rules for how text is extracted and choose which documents to apply them to. This gives you full control over the extraction process."}];$scope.EMBED_DOCS_IMAGE_HANDLING_MODES={IGNORE:{id:"IGNORE",title:"Ignore",formats:["PDF","PPTX","DOCX","HTML","TXT","MD"]},OCR:{id:"OCR",title:"OCR",formats:["PDF","PPTX","DOCX","HTML","JPG","PNG","TXT","MD"]},VLM_ANNOTATE:{id:"VLM_ANNOTATE",title:"Describe images with VLM",formats:["PDF","PPTX","DOCX","HTML","TXT","MD"]}};$scope.EMBED_DOCS_ENGINE_MAP={STRUCTURED:{title:"Structured text extraction",description:"When possible, the engine uses document headers to divide the content into extraction units. Image handling can be used to leverage images in documents and scanned PDFs."+" Supported file formats are PDF, DOCX, PPTX, HTML, TXT, MD (without OCR), JPG, JPEG, and PNG (with OCR enabled)."},RAW:{title:"Raw text extraction",description:"Fast but doesn't extract the structure of the document, only the raw text. OCR can be used on images with text."+" Supported file formats are PDF, DOCX, PPTX, HTML, TXT, MD (without OCR), JPG, JPEG, and PNG (with OCR enabled)."},VLM:{title:"VLM extraction",description:"Uses a Vision Language Model to extract information from documents that may include text and visual elements like charts, graphics, and tables."+" Supported file formats are PDF, DOC, DOCX, ODT, PPT, PPTX, ODP, JPG, JPEG and PNG."},DONOTEXTRACT:{title:"Ignore (Do not extract)",description:"Ignore matching files."}};DataikuAPI.flow.recipes.nlp.getDefaultDocExtractionPrompts($stateParams.projectKey,$scope.recipe.name).success(function(data){$scope.promptsTemplates=data}).error(setErrorInScope.bind($scope));$scope.getPrompt=function(charsLimit,promptVersion){var promptTemplate;if(!$scope.promptsTemplates){return""}switch(promptVersion){case"DEFAULT_VLM_EXTRACTION":promptTemplate=$scope.promptsTemplates.defaultVlmExtractionTemplate;break;case"SUMMARY_PROMPT":promptTemplate=$scope.promptsTemplates.vlmSummaryExtractionTemplate;break;case"FULL_CONTENT_PROMPT":promptTemplate=$scope.promptsTemplates.vlmFullExtractionTemplate;break;case"ANNOTATION_PROMPT":promptTemplate=$scope.promptsTemplates.vlmAnnotationTemplate;break;default:return""}return promptTemplate.replace($scope.promptsTemplates.limitPlaceholder,charsLimit)};$scope.getPromptFromRule=function(rule,promptVersion){if(promptVersion){var chunkSize=$scope.defaultChunkSize;if(rule?.splittingSettings?.chunkSizeCharacters){chunkSize=rule.splittingSettings.chunkSizeCharacters}return $scope.getPrompt(chunkSize,promptVersion)}};$scope.overrideVLMAnnotationCustomPromptWith=function(rule){rule.structuredSettings.customVLMPrompt=$scope.getPromptFromRule(rule,"ANNOTATION_PROMPT")};$scope.overrideVLMExtractionCustomPromptWith=function(rule,promptVersion){rule.vlmSettings.customPrompt=$scope.getPromptFromRule(rule,promptVersion)};$scope.getActiveVLMfromLLMid=function(vlmId){return $scope.availableVLMs.find(llm=>llm.id===vlmId)};$scope.recipe.params.rules=$scope.recipe.params.rules||[];$scope.makeDefaultVLMSettings=function(rule){let chunkSize=$scope.defaultChunkSize;if(rule?.splittingSettings?.chunkSizeCharacters){chunkSize=rule.splittingSettings.chunkSizeCharacters}return{llmId:$scope.recipe.params.defaultVlmId==="DSS_NO_SELECTION"?undefined:$scope.recipe.params.defaultVlmId,splitUnit:"PAGE",customNbPages:1,customPagesOverlap:0,useCustomPrompt:false,customPrompt:$scope.getPrompt(chunkSize,"DEFAULT_VLM_EXTRACTION")}};$scope.makeDefaultStructuredSettings=function(){let chunkSize=$scope.defaultChunkSize;return{splitUnit:"SECTION",maxSectionDepth:6,imageHandlingMode:"IGNORE",ocrEngine:"AUTO",ocrLanguages:"en",useCustomVLMPrompt:false,customVLMPrompt:$scope.getPrompt(chunkSize,"ANNOTATION_PROMPT"),enableImageClassificationFiltering:true}};$scope.makeDefaultRawSettings=function(){return{useOCR:false,ocrEngine:"AUTO",ocrLanguages:"en"}};$scope.addNewRule=function(){$scope.recipe.params.rules.push({filter:{enabled:true,distinct:false,uiData:{mode:"||",conditions:[{input:"file extension",operator:"== [string]i"}]}},actionToPerform:"STRUCTURED",rawSettings:$scope.makeDefaultRawSettings(),structuredSettings:$scope.makeDefaultStructuredSettings(),splittingSettings:$scope.makeDefaultSplittingSettings(),storeInMultimodalColumn:"FULL_CONTENT"});$scope.uiState.showAdvancedSettings.push(false)};$scope.onRuleActionChange=function(idx){let ruleToBeUpdated=idx==-1?$scope.recipe.params.allOtherRule:$scope.recipe.params.rules[idx];switch(ruleToBeUpdated.actionToPerform){case"VLM":ruleToBeUpdated.vlmSettings=ruleToBeUpdated.vlmSettings||$scope.makeDefaultVLMSettings(ruleToBeUpdated);ruleToBeUpdated.storeInMultimodalColumn="IMAGES";break;case"STRUCTURED":ruleToBeUpdated.structuredSettings=ruleToBeUpdated.structuredSettings||$scope.makeDefaultStructuredSettings();ruleToBeUpdated.storeInMultimodalColumn=$scope.shouldStoreDetectedImages(ruleToBeUpdated)?"IMAGES":"FULL_CONTENT";break;case"RAW":ruleToBeUpdated.rawSettings=ruleToBeUpdated.rawSettings||$scope.makeDefaultRawSettings();ruleToBeUpdated.storeInMultimodalColumn="FULL_CONTENT";break}};$scope.clearAll=function(){for(var i=$scope.recipe.params.rules.length-1;i>=0;i--){$scope.removeRule(i)}};$scope.removeRule=function(idx){$scope.recipe.params.rules.splice(idx,1);$scope.uiState.showAdvancedSettings.splice(idx,1)};$scope.uiState={currentStep:"strategy",showAdvancedSettings:[],showAdvancedSettingsAllOtherFiles:false,selectAllMetadataColumns:true,requestSent:false};void function(){for(var i=0;i<$scope.recipe.params.rules.length;i++){$scope.uiState.showAdvancedSettings.push(false)}}();$scope.hooks.getPayloadData=function(){return angular.toJson($scope.desc)};$scope.hooks.updateRecipeStatus=function(){let deferred=$q.defer();let payload=$scope.hooks.getPayloadData();$scope.updateRecipeStatusBase(false,payload).then(function(){if(!$scope.recipeStatus)return deferred.reject();deferred.resolve($scope.recipeStatus)});return deferred.promise};$scope.hasAllRequiredOutputs=()=>{if(!$scope.recipeStatus||!$scope.recipeStatus.output||$scope.recipeStatus.output.fatal){return false}return true};$scope.hasMissingOutputFolder=()=>{if($scope.recipe.outputs.images&&!!$scope.recipe.outputs.images.items.length){return false}return!!$scope.recipeStatus&&!!$scope.recipeStatus.output&&$scope.recipeStatus.output.messages?.some(msg=>msg.code==="ERR_RECIPE_DOC_EXTRACTION_MISSING_FOLDER")};$scope.showWarningOnDocumentExtractionCodeEnv=()=>{if($scope.recipeStatus?.strategy){return $scope.recipeStatus.strategy.messages?.some(msg=>msg.code==="WARN_RECIPE_CODE_ENV_NOT_AVAILABLE")}return false};$scope.internalCodeEnvsHRef=function(){if($scope.appConfig.isAutomation){return $state.href("admin.codeenvs-automation.internal")}else{return $state.href("admin.codeenvs-design.internal")}};$scope.sendDocExtractionInternalCodeEnvRequest=function(){DataikuAPI.requests.createInternalCodeEnvRequest("INSTALL_CODE_ENV","INTERNAL_document_extraction","Please install document extraction internal code env","MANUAL").success(function(data){RequestCenterService.WT1Events.onRequestSent("CODE_ENV",null,"INTERNAL_document_extraction","Please install document extraction internal code env",data.id)}).error(setErrorInScope.bind($scope));$scope.uiState.requestSent=true};$scope.canChangeEngine=function(){return false};$scope.updateMethodDisabledReason=function(method){return""};$scope.baseRuleSchema={columns:[{name:"file extension",type:"string",$$groupKey:""},{name:"file name",type:"string",$$groupKey:""},{name:"file path",type:"string",$$groupKey:""}],userModified:false};$scope.ruleSchema=undefined;$scope.getRulesSchema=function(){return $scope.ruleSchema};$scope.createCustomRulesFrom=function(extractionMode){if($scope.recipe.params){const llmId=$scope.retrievableKnowledge?$scope.retrievableKnowledge.embeddingLLMId:null;DataikuAPI.flow.recipes.nlp.getDefaultDocExtractionRules(extractionMode.id,llmId,$scope.recipe.params.defaultVlmId,$stateParams.projectKey,$scope.recipe.params.defaultImageHandlingMode,$scope.recipe.name).success(function(data){if(data){$scope.recipe.params.rules=data.rules;Object.assign($scope.recipe.params.allOtherRule,data.allOtherRule);$scope.recipe.params.extractionMode="CUSTOM_RULES"}}).error(setErrorInScope.bind($scope))}};$scope.overrideCustomPromptWith=function(rule,promptVersion){if(promptVersion&&$scope.VLM_EXTRACTION_PROMPTS[promptVersion]){let chunkSize=$scope.defaultChunkSize;if(rule?.splittingSettings?.chunkSizeCharacters){chunkSize=rule.splittingSettings.chunkSizeCharacters}rule.vlmSettings.customPrompt=$scope.getPrompt(chunkSize,promptVersion)}};$scope.overrideVLMAnnotationCustomPromptWith=function(rule){rule.structuredSettings.customVLMPrompt=$scope.getVLMAnnotationPrompt(rule.splittingSettings.chunkSizeCharacters)};$scope.getAppropriateImagePath=function(){if($scope.recipe.params.extractionMode==="MANAGED_TEXT_ONLY"&&$scope.recipe.params.defaultImageHandlingMode!=="IGNORE"){return"/static/dataiku/images/recipes/"+$scope.recipe.type+"/"+$scope.recipe.params.extractionMode+"_WITH_IMAGE_HANDLING.svg"}return"/static/dataiku/images/recipes/"+$scope.recipe.type+"/"+$scope.recipe.params.extractionMode+".svg"};$scope.shouldStoreDetectedImages=function(rule){if(rule.actionToPerform==="STRUCTURED"){if($scope.recipe.type==="embed_documents"&&rule.structuredSettings.imageHandlingMode==="VLM_ANNOTATE"||$scope.recipe.type==="extract_content"&&$scope.desc.storeImages){return true}}return false};$scope.onImageHandlingChange=function(rule){if(["STRUCTURED","RAW"].contains(rule.actionToPerform)){if($scope.shouldStoreDetectedImages(rule)){rule.storeInMultimodalColumn="IMAGES"}else{rule.storeInMultimodalColumn="FULL_CONTENT"}}}});app.component("ocrEngine",{bindings:{engine:"=",languages:"="},templateUrl:"templates/recipes/doc-extraction-common/ocr-engine.component.html"})})();(function(){"use strict";const app=angular.module("dataiku.recipes");app.controller("EmbedDocumentsRecipeCreationController",function($scope,Fn,$stateParams,DataikuAPI,$q,Dialogs,WT1,$controller,RecipeComputablesService,Logger,SmartId,RetrievableKnowledgeUtils,$rootScope){$controller("_RecipeCreationControllerBase",{$scope:$scope});$controller("_RecipeOutputNewManagedBehavior",{$scope:$scope});$scope.recipeType="embed_documents";$scope.recipeName={};$scope.creationSettings={VLMId:null,embeddingLLMId:null,vectorStoreType:"CHROMA",connection:null,indexName:null,pineconeIndexName:null,zone:null,outputRetrievableKnowledgeName:null};$scope.recipe={type:$scope.recipeType,projectKey:$stateParams.projectKey,inputs:{main:{items:[]},metadata_dataset:{items:[]}},name:"compute_"+$scope.creationSettings.outputRetrievableKnowledgeName};function makeMainRole(refs){return{main:{items:refs.filter(function(ref){return!!ref}).map(function(ref){return{ref:ref}})}}}$scope.doCreateRecipe=function(){$scope.recipe.inputs=$scope.recipe&&$scope.recipe.inputs?$scope.recipe.inputs:makeMainRole([$scope.io.inputFolder]);$scope.recipe.name="compute_"+$scope.creationSettings.outputRetrievableKnowledgeName;const recipe=angular.copy($scope.recipe);const settings=angular.copy($scope.creationSettings);if($scope.zone){settings.zone=$scope.zone}return DataikuAPI.flow.recipes.generic.create(recipe,settings)};$scope.$watchCollection("recipe.inputs.main.items",function(inputs){if(inputs&&inputs.length&&$scope.computablesMap){const folderId=inputs[0].ref;$scope.io.inputFolder={smartName:folderId,name:$scope.computablesMap[folderId]&&$scope.computablesMap[folderId].label};DataikuAPI.flow.zones.getZoneId($stateParams.projectKey,{id:folderId,type:"MANAGED_FOLDER",projectKey:$stateParams.projectKey}).success(function(zone){$scope.zone=zone.id}).error(setErrorInScope.bind($scope))}});$scope.showOutputPane=function(){return!!$scope.io.inputFolder};$scope.formIsValid=function(){const creationSettings=$scope.creationSettings;if(!creationSettings.outputRetrievableKnowledgeName){return false}if(!creationSettings.embeddingLLMId){return false}if(!creationSettings.vectorStoreType){return false}if(RetrievableKnowledgeUtils.hasConnection(creationSettings)&&!creationSettings.connection){return false}return!(creationSettings.vectorStoreType==="PINECONE"&&!creationSettings.pineconeIndexName)};DataikuAPI.pretrainedModels.listAvailableLLMs($stateParams.projectKey,"TEXT_EMBEDDING_EXTRACTION").success(function(data){$scope.availableEmbeddingLLMs=data.identifiers;if($scope.availableEmbeddingLLMs.length>0){$scope.creationSettings.embeddingLLMId=data.identifiers[0].id}}).error(setErrorInScope.bind($scope));$scope.$on("preselectInputFolder",function(scope,preselectedInputFolder){$scope.io.inputFolder=preselectedInputFolder;$scope.preselectedInputFolder=preselectedInputFolder});$scope.$watch("io.inputFolder",function(nv){if(!nv)return;if(nv.name&&!$scope.creationSettings.outputRetrievableKnowledgeName){const niceInputName=nv.name.replace(/[A-Z]*\./,"").replace(/[^\w-_]+/g,"").replaceAll(" ","_");$scope.creationSettings.outputRetrievableKnowledgeName=niceInputName+"_embedded";$scope.recipe.name="compute_"+$scope.creationSettings.outputRetrievableKnowledgeName}if($scope.preselectedInputFolder&&$scope.io.inputFolder.smartName!=$scope.preselectedInputFolder.smartName){$scope.zone=null}});RecipeComputablesService.getComputablesMap($scope.recipe,$scope).then(function(map){$scope.setComputablesMap(map)})});app.controller("EmbedDocumentsRecipeController",function($scope,$state,$rootScope,$q,$controller,$stateParams,DataikuAPI,RequestCenterService,EmbeddingUtils,DOCUMENT_SPLITTING_METHOD_MAP,EMBED_DOCS_VECTOR_STORE_UPDATE_METHOD_MAP,VECTOR_STORE_TYPE_MAP,DatasetUtils,RecipesUtils,SmartId,WT1,ATSurveyService){$controller("_DocExtractionRecipeControllerBase",{$scope:$scope,UPDATE_METHOD_MAP:EMBED_DOCS_VECTOR_STORE_UPDATE_METHOD_MAP});$scope.hasMetadataStep=true;DatasetUtils.listDatasetsUsabilityForAny($stateParams.projectKey).success(data=>{$scope.availableInputDatasets=data}).error(setErrorInScope.bind($scope));$scope.shouldClearKnowledgeBank=function(){return false};const recipePayloadSave=$scope.hooks.save;$scope.hooks.save=function(){return recipePayloadSave().then(()=>{WT1.event("embed-documents-save");ATSurveyService.updateCounter("EmbedDocumentsSave")})};$scope.recipe.inputs["metadata_dataset"]=$scope.recipe.inputs["metadata_dataset"]||{items:[]};$scope.metadataDatasetColumns=undefined;$scope.getAllColumnsNames=function(){if(!$scope.metadataDatasetColumns)return[];return $scope.metadataDatasetColumns.map(column=>column.name)};$scope.getAvailableSecurityColumnsWithEmpty=function(){let availableOptions=$scope.getAllColumnsNames();availableOptions.unshift($scope.RESET_VALUE);return availableOptions};$scope.removeMetadataDataset=function(){$scope.recipe.inputs["metadata_dataset"].items=[];$scope.metadataDatasetColumns=[];$scope.desc.filePathMetadataColumn=undefined;$scope.desc.securityTokensColumn=undefined};$scope.getRemainingMetadataColumns=function(){if(!$scope.metadataDatasetColumns||$scope.metadataDatasetColumns.length===0)return[];return $scope.metadataDatasetColumns.filter(column=>column.name!==$scope.desc.filePathMetadataColumn&&column.name!==$scope.desc.securityTokensColumn)};$scope.updateAllMetadataSelection=function(shouldToggleAllMetadataBoolean){if(shouldToggleAllMetadataBoolean){$scope.uiState.selectAllMetadataColumns=!$scope.uiState.selectAllMetadataColumns}$scope.metadataDatasetColumns.forEach(function(col){col.selected=$scope.uiState.selectAllMetadataColumns})};$scope.onSingleColumnSelectionChange=function(){let areAllColumnSelected=true;$scope.getRemainingMetadataColumns().forEach(function(col){areAllColumnSelected=areAllColumnSelected&&col.selected});$scope.uiState.selectAllMetadataColumns=areAllColumnSelected};$scope.clickedOnColumnName=function(colName){const selectedColumn=$scope.metadataDatasetColumns.filter(col=>col.name==colName)[0];selectedColumn.selected=!selectedColumn.selected;$scope.onSingleColumnSelectionChange()};$scope.updateRulesSchema=function(){let ruleSchema=angular.copy($scope.baseRuleSchema);if($scope.hasMetadataStep&&$scope.metadataDatasetColumns&&$scope.metadataDatasetColumns.length>0){$scope.metadataDatasetColumns.forEach(function(col){ruleSchema.columns.push({name:col.name,type:col.type,$$groupKey:"Metadata dataset columns"})})}$scope.ruleSchema=ruleSchema};$scope.loadDatasetColumnsIfNeeded=function(resetSelection){if(!$scope.metadataDatasetRef){$scope.metadataDatasetColumns=[];$scope.updateRulesSchema();return}const resolvedRef=SmartId.resolve($scope.metadataDatasetRef,$stateParams.projectKey);DataikuAPI.datasets.get(resolvedRef.projectKey,resolvedRef.id,$stateParams.projectKey).then(response=>{const schema=response.data.schema;if(resetSelection){schema.columns.forEach(function(col){col.selected=true});$scope.uiState.selectAllMetadataColumns=true;$scope.desc.filePathMetadataColumn=schema.columns.map(col=>col.name).indexOf("path")>=0?"path":undefined;$scope.desc.securityTokensColumn=undefined}else{$scope.desc.filePathMetadataColumn=$scope.desc.filePathMetadataColumn||(schema.columns.map(col=>col.name).indexOf("path")>=0?"path":undefined);schema.columns.forEach(function(col){col.selected=$scope.desc.userDefinedMetadataColumns.map(meta=>meta.column).indexOf(col.name)>=0})}$scope.metadataDatasetColumns=schema.columns;$scope.updateRulesSchema();$scope.onSingleColumnSelectionChange()})};$scope.$watch("recipe.inputs.metadata_dataset.items",function(nv,ov){if(!nv)return;$scope.metadataDatasetRef=nv.length?nv[0].ref:undefined;let resetSelection;if(!$scope.metadataDatasetRef||!ov||ov.length!=1||$scope.metadataDatasetRef!==ov[0].ref){resetSelection=true}else{resetSelection=false}$scope.loadDatasetColumnsIfNeeded(resetSelection)},true);$scope.$watch("metadataDatasetColumns",function(nv,ov){if(!nv)return;$scope.desc.userDefinedMetadataColumns=$scope.getRemainingMetadataColumns().filter(column=>column.selected).map(column=>({column:column.name,meaning:column.meaning}))},true);$scope.isMetadataDatasetFilled=function(){return $scope.recipe.inputs["metadata_dataset"].items.length>0};$scope.makeDefaultSplittingSettings=function(){return{chunkSizeCharacters:$scope.defaultChunkSize,chunkOverlapCharacters:$scope.defaultOverlapSize}}})})();(function(){"use strict";const app=angular.module("dataiku.recipes");app.controller("ExtractContentRecipeCreationController",function($scope,Fn,$stateParams,DataikuAPI,$q,Dialogs,WT1,$controller,RecipeComputablesService,Logger,SmartId,RetrievableKnowledgeUtils,$rootScope){$scope.recipeType="extract_content";$scope.inputFolderOnly=true;$controller("SingleOutputDatasetRecipeCreationController",{$scope:$scope});$scope.autosetName=async function(){if($scope.io.inputFolder&&$scope.io.inputFolder.name){const niceInputName=(await DataikuAPI.shakers.convertToASCII([$scope.io.inputFolder.name],true,true)).data[0];$scope.maybeSetNewDatasetName(niceInputName+"_extracted_content")}};$scope.recipeName={};$scope.creationSettings={VLMId:null,zone:null,outputRetrievableKnowledgeName:null};$scope.recipe={type:$scope.recipeType,projectKey:$stateParams.projectKey,inputs:{main:{items:[]}},outputs:{main:{items:[]}},name:"compute_"+$scope.creationSettings.outputRetrievableKnowledgeName};$scope.$watchCollection("recipe.inputs.main.items",function(inputs){if(inputs&&inputs.length&&$scope.computablesMap){const folderId=inputs[0].ref;$scope.io.inputFolder={smartName:folderId,name:$scope.computablesMap[folderId]&&$scope.computablesMap[folderId].label};DataikuAPI.flow.zones.getZoneId($stateParams.projectKey,{id:folderId,type:"MANAGED_FOLDER",projectKey:$stateParams.projectKey}).success(function(zone){$scope.zone=zone.id}).error(setErrorInScope.bind($scope))}});RecipeComputablesService.getComputablesMap($scope.recipe,$scope).then(function(map){$scope.setComputablesMap(map)})});app.controller("ExtractContentRecipeController",function($scope,$state,$rootScope,$q,$controller,$stateParams,DataikuAPI,RequestCenterService,EmbeddingUtils,DOCUMENT_SPLITTING_METHOD_MAP,EXTRACT_CONTENT_UPDATE_METHOD_MAP,VECTOR_STORE_TYPE_MAP,DatasetUtils,RecipesUtils,SmartId){$controller("_DocExtractionRecipeControllerBase",{$scope:$scope,UPDATE_METHOD_MAP:EXTRACT_CONTENT_UPDATE_METHOD_MAP});$scope.hasMetadataStep=false;$scope.ruleSchema=$scope.baseRuleSchema;$scope.makeDefaultSplittingSettings=function(){return null};$scope.isImageStorageEnabled=function(){return $scope.recipe.params.extractionMode==="MANAGED_TEXT_ONLY"||$scope.recipe.params.extractionMode==="CUSTOM_RULES"&&($scope.recipe.params.allOtherRule.actionToPerform==="STRUCTURED"||$scope.recipe.params.rules.some(r=>r.actionToPerform==="STRUCTURED"))};$scope.imageStorageTooltip=function(){return!$scope.isImageStorageEnabled()?"Requires a Structured text engine to generate images. Select a Structured text engine in one of the rules from the Strategy step to enable this option.":""};$scope.isScreenshotStorageEnabled=function(){return $scope.recipe.params.extractionMode==="MANAGED_VISUAL_ONLY"||$scope.recipe.params.extractionMode==="CUSTOM_RULES"&&($scope.recipe.params.allOtherRule.actionToPerform==="VLM"||$scope.recipe.params.rules.some(r=>r.actionToPerform==="VLM"))};$scope.screenshotStorageTooltip=function(){return!$scope.isScreenshotStorageEnabled()?"Requires a VLM engine to generate images. Select a VLM engine in one of the rules from the Strategy step to enable this option.":""}})})();(function(){"use strict";var app=angular.module("dataiku.recipes");app.controller("EdaRecipeCreationController",function($scope,CreateModalFromTemplate){$scope.showCreateRecipeModal=cardType=>{let controller;let template;switch(cardType){case"univariate_header":controller="UnivariateRecipeCreationController";template="/templates/recipes/single-output-recipe-creation.html";break;case"pca":controller="PcaRecipeCreationController";template="/templates/recipes/eda_pca-recipe-creation.html";break;case"ttest_ztest_1samp":case"sign_test_1samp":case"shapiro":case"ttest_2samp":case"mood_test_2samp":case"levene_test_2samp":case"ks_test_2samp":case"oneway_anova":case"mood_nsamp":case"levene_nsamp":case"pairwise_ttest":case"pairwise_mood":case"pairwise_levene":case"chi2_independence_test":controller="StatsTestRecipeCreationController";template="/templates/recipes/single-output-recipe-creation.html";break;default:throw new Error(`Unsupported analysis type: ${cardType}`)}CreateModalFromTemplate(template,$scope,controller,scope=>{if($scope.preselectedInput){scope.preselectInputDataset($scope.preselectedInput)}scope.recipeSubType=scope.mapToRecipeSubType?scope.mapToRecipeSubType(cardType):undefined;scope.recipeCreationSettings={...scope.recipeCreationSettings,card:{type:cardType},useDefaultParameters:true}})}});app.controller("PcaRecipeCreationController",function($scope,$stateParams,$controller,DataikuAPI,RecipeComputablesService,DatasetUtils,PartitionDeps){$scope.recipeType="eda_pca";$controller("_RecipeCreationControllerBase",{$scope:$scope});addDatasetUniquenessCheck($scope,DataikuAPI,$stateParams.projectKey);fetchManagedDatasetConnections($scope,DataikuAPI);$scope.forceMainLabel=true;$scope.recipe={projectKey:$stateParams.projectKey,type:$scope.recipeType,inputs:{main:{items:[{ref:"",deps:[]}]}},outputs:{},params:{}};$scope.recipeCreationSettings={card:null};$scope.preselectInputDataset=datasetSmartName=>{$scope.recipe.inputs.main.items[0].ref=datasetSmartName;$scope.preselectedInputDataset=datasetSmartName};$scope.init=(card,dataSpec,rootCard)=>{const{datasetSelection,containerSelection,inputDatasetSmartName}=dataSpec;$scope.recipeCreationSettings={...$scope.recipeCreationSettings,card:card,datasetSelection:datasetSelection,containerSelection:containerSelection,originWorksheetId:$stateParams.worksheetId};$scope.preselectInputDataset(inputDatasetSmartName)};DatasetUtils.listDatasetsUsabilityInAndOut($stateParams.projectKey,$scope.recipeType).then(data=>{$scope.availableInputDatasets=data[0]});RecipeComputablesService.getComputablesMap($scope.recipe,$scope).then(computablesMap=>{$scope.setComputablesMap(computablesMap)});const hasMainInput=()=>{const{inputs}=$scope.recipe;const input=inputs["main"];return input!=null&&input.items!=null&&input.items.length>0&&input.items[0].ref};const hasOutput=roleName=>{const{outputs}=$scope.recipe;const output=outputs[roleName];return output!=null&&output.items!=null&&output.items.length>0&&output.items[0].ref};const hasAtLeastOneOutput=()=>{return hasOutput("main")||hasOutput("eigenvectors")||hasOutput("eigenvalues")};$scope.hasMainInput=hasMainInput;$scope.hasAtLeastOneOutput=hasAtLeastOneOutput;$scope.shouldDisplayOutputExplanation=()=>!hasAtLeastOneOutput();$scope.generateOutputExplanation=()=>"This recipe requires at least one output";$scope.$watch("recipe.inputs.main.items[0].ref",inputDsName=>{if(!inputDsName){return}$scope.recipe.name="pca_"+inputDsName.replace(/[A-Z]*\./,"");if($scope.preselectedInputDataset&&inputDsName!=$scope.preselectedInputDataset){$scope.zone=null}});$scope.doCreateRecipe=()=>{const recipe=angular.copy($scope.recipe);if($scope.recipeName){recipe.name=$scope.recipeName.name}PartitionDeps.prepareRecipeForSerialize(recipe);const settings={...$scope.recipeCreationSettings};if($scope.zone){settings.zone=$scope.zone}return DataikuAPI.flow.recipes.generic.create(recipe,settings)}});app.controller("_BaseStatsTestRecipeCreationController",function($scope,$stateParams,$controller){$controller("SingleOutputDatasetRecipeCreationController",{$scope:$scope});$scope.sanitizeCardType=cardType=>{if(cardType==="univariate_header"){return"univariate_analysis"}return cardType};$scope.autosetName=function(){if($scope.io.inputDataset){const niceInputName=$scope.io.inputDataset.replace(/[A-Z]*\./,"");const cardType=$scope.sanitizeCardType($scope.recipeCreationSettings.card.type);$scope.maybeSetNewDatasetName(niceInputName+"_"+cardType)}};$scope.recipeCreationSettings={};$scope.init=(card,dataSpec,rootCard)=>{const{datasetSelection,containerSelection,inputDatasetSmartName}=dataSpec;$scope.recipeSubType=$scope.mapToRecipeSubType?$scope.mapToRecipeSubType(card.type):undefined;$scope.recipeCreationSettings={...$scope.recipeCreationSettings,card:card,datasetSelection:datasetSelection,containerSelection:containerSelection,originWorksheetId:$stateParams.worksheetId,withConfidenceIntervals:rootCard.showConfidenceInterval,confidenceLevel:rootCard.confidenceLevel};$scope.preselectInputDataset(inputDatasetSmartName)};$scope.getCreationSettings=()=>{return $scope.recipeCreationSettings}});app.controller("StatsTestRecipeCreationController",function($scope,$controller){$scope.recipeType="eda_stats";$controller("_BaseStatsTestRecipeCreationController",{$scope:$scope});$scope.mapToRecipeSubType=cardType=>{switch(cardType){case"ttest_ztest_1samp":return"recipe_one-sample-t-test";case"sign_test_1samp":return"recipe_one-sample-sign-test";case"shapiro":return"recipe_one-sample-shapiro-test";case"ttest_2samp":return"recipe_two-sample-t-test";case"mood_test_2samp":return"recipe_two-sample-mood-test";case"levene_test_2samp":return"recipe_two-sample-levene-test";case"ks_test_2samp":return"recipe_two-sample-ks-test";case"oneway_anova":return"recipe_one-way-anova-test";case"mood_nsamp":return"recipe_n-sample-mood-test";case"levene_nsamp":return"recipe_n-sample-levene-test";case"pairwise_ttest":return"recipe_pairwise-t-test";case"pairwise_mood":return"recipe_pairwise-mood-test";case"pairwise_levene":return"recipe_pairwise-levene-test";case"chi2_independence_test":return"recipe_chi2-independence-test";default:return undefined}}});app.controller("UnivariateRecipeCreationController",function($scope,$controller){$scope.recipeType="eda_univariate";$controller("_BaseStatsTestRecipeCreationController",{$scope:$scope})});app.controller("_EdaRecipeEditionController",function($scope,$controller,$q,Assert,ComputableSchemaRecipeSave,StateUtils,DataikuAPI){Assert.inScope($scope,"hooks");Assert.inScope($scope,"recipe");Assert.inScope($scope,"script");Assert.inScope($scope,"origRecipe");Assert.inScope($scope,"origScript");$controller("_RecipeWithEngineBehavior",{$scope:$scope});$scope.payload=JSON.parse($scope.script.data);$scope.origPayload=JSON.parse($scope.origScript.data);$scope.originWorksheetId=$scope.recipe.params.originWorksheetId;$scope.propagateApiError=apiError=>{$scope.fatalAPIError=apiError;$scope.$applyAsync()};$scope.getRecipeSingleInput=()=>{return $scope.recipe.inputs["main"].items[0]};$scope.getRecipeMainOutput=()=>{return $scope.recipe.outputs["main"]?$scope.recipe.outputs["main"].items[0]:undefined};$scope.getRecipeFilter=()=>{return $scope.recipe.params.datasetSelection.filter};$scope.updateRecipePayload=payload=>{$scope.payload=payload;$scope.$applyAsync()};$scope.hooks.getPayloadData=()=>{return angular.toJson($scope.payload)};$scope.hooks.recipeIsDirty=()=>{if($scope.recipe==null){return false}if($scope.creation){return true}return!angular.equals($scope.recipe,$scope.origRecipe)||!angular.equals($scope.payload,$scope.origPayload)};$scope.hooks.save=()=>{const deferred=$q.defer();const sr=$scope.hooks.getRecipeSerialized();const payload=$scope.hooks.getPayloadData();$scope.script.data=payload;ComputableSchemaRecipeSave.handleSave($scope,sr,payload,deferred);return deferred.promise};$scope.$on("recipeSaved",()=>{$scope.origPayload=JSON.parse($scope.script.data)});$scope.hooks.updateRecipeStatus=function(){var deferred=$q.defer();var payload=$scope.hooks.getPayloadData();$scope.updateRecipeStatusBase(false,payload).then(function(){if(!$scope.recipeStatus)return deferred.reject();deferred.resolve($scope.recipeStatus)});return deferred.promise};$scope.hooks.onRecipeLoaded=function(){$scope.hooks.updateRecipeStatus()};$scope.originWorksheetExists=false;if($scope.originWorksheetId){DataikuAPI.statistics.get($scope.projectKey,$scope.originWorksheetId).then(()=>{$scope.originWorksheetExists=true}).catch(()=>{$scope.originWorksheetExists=false})}$scope.goToWorksheet=function(){StateUtils.go.statisticsWorksheet($scope.originWorksheetId,$scope.projectKey)}});app.controller("PcaRecipeEditionController",function($scope,$controller){$controller("_EdaRecipeEditionController",{$scope:$scope});$scope.hasAllRequiredOutputs=()=>{if(!$scope.recipe||!$scope.recipe.outputs){return false}const{main,eigenvectors,eigenvalues}=$scope.recipe.outputs;return main&&main.items&&main.items.length>0||eigenvectors&&eigenvectors.items&&eigenvectors.items.length>0||eigenvalues&&eigenvalues.items&&eigenvalues.items.length>0}});app.controller("StatsTestRecipeEditionController",function($scope,$controller){$controller("_EdaRecipeEditionController",{$scope:$scope})});app.controller("UnivariateRecipeEditionController",function($scope,$controller){$controller("_EdaRecipeEditionController",{$scope:$scope})})})();(function(){"use strict";var app=angular.module("dataiku.recipes");app.factory("CodeBasedEditorUtils",function($rootScope,CodeMirrorSettingService){let recipeScript;var svc={editorOptions:function(mode,$scope,enableLint){const hintModeBlacklist=["text/x-sql","text/x-sql2","text/x-hivesql","text/x-dkupig"];var options=CodeMirrorSettingService.get(mode,{onLoad:function(cm){$scope.cm=cm},words:getRecipeWords($scope)});options.extraKeys["Meta-Enter"]=function(cm){$scope.validateRecipe()};options.extraKeys["Ctrl-Enter"]=function(cm){$scope.validateRecipe()};options.extraKeys["Shift-Enter"]=function(cm){$scope.startSingleRecipeExecution()};options.gutters=["CodeMirror-lint-markers","CodeMirror-foldgutter"];$scope.$on("computablesMapChanged",()=>{if(hintModeBlacklist.indexOf(mode)<0){options.extraKeys[CodeMirrorSettingService.getShortcuts()["AUTOCOMPLETE_SHORTCUT"]]=CodeMirrorSettingService.showHint(mode,getRecipeWords($scope))}});if(enableLint){options.lint={getAnnotations:function(cm,updateFunction){$scope.linterFunction=function(err){updateFunction(err)}},async:true}}return options},registerBroadcastSelectionHandler:function(editorOptions){const onLoad=editorOptions.onLoad;editorOptions.onLoad=function(codeMirror){onLoad(codeMirror);let selection;codeMirror.on("cursorActivity",function(localCodeMirror){const newSelection=localCodeMirror.getSelection();if(selection!==newSelection){$rootScope.$broadcast("codeRecipeEditorSelectionChanged",newSelection);selection=newSelection}})}},setRecipeScript:function(script){recipeScript=script},getRecipeScript:function(){return recipeScript},updateLinter:function(validationResult,linterFunction){var found=[];if(validationResult){validationResult.topLevelMessages.messages.forEach(function(err){if(err.line>=0){var lineTo=err.lineTo>=0?err.lineTo:err.line;found.push({from:CodeMirror.Pos(err.line-1,0),to:CodeMirror.Pos(lineTo-1,1e3),message:err.message+(err.context?" (around "+err.context+")":""),severity:err.severity=="WARNING"?"warning":"error"})}})}if(linterFunction){linterFunction(found)}}};return svc;function getRecipeWords($scope){let inputs=$scope.recipe&&$scope.recipe.inputs&&$scope.recipe.inputs["main"]?$scope.recipe.inputs["main"].items:[];let outputs=$scope.recipe&&$scope.recipe.outputs&&$scope.recipe.outputs["main"]?$scope.recipe.outputs["main"].items:[];let computables=$scope.computablesMap||[];return inputs.concat(outputs).map(_=>computables[_.ref]).filter(_=>_&&_.dataset&&_.dataset.schema&&_.dataset.schema.columns).map(_=>_.dataset.schema.columns.map(c=>c.name)).reduce((a,b)=>a.concat(b.filter(_=>!a.includes(_))),[])}});app.factory("CodeBasedValidationUtils",function(DataikuAPI,RecipeRunJobService,$stateParams){var svc={getGenericCheckPromise:function($scope){$scope.hooks.resetScope();return DataikuAPI.flow.recipes.generic.getStatusWithSpinner($scope.hooks.getRecipeSerialized(),$scope.script.data,1,{targetPartitionSpec:RecipeRunJobService.getTargetPartition($scope,$stateParams)}).error(setErrorInScope.bind($scope)).then(function(resp){var data=resp.data;data.allMessagesLength=data.allMessagesForFrontend.messages.reduce(function(acc,msg){return acc+msg.message.length},0);return data})}};return svc});app.factory("CodeBasedToPluginConverter",function(CreateModalFromTemplate,DataikuAPI,WT1,$state,$rootScope,StateUtils,PluginsService){const svc={transformToDevPlugin:function($scope,convertAPIFunc,type){CreateModalFromTemplate("/templates/recipes/custom-code/code-recipe-to-customcode.html",$scope,null,function(modalScope){const getAPICallParams=function(scope){const params=scope.convert;const pluginId=params.mode=="NEW"?params.newPluginId:params.targetPluginId;return[pluginId,params.mode,scope.script.data,params.targetFolder,scope.hooks.getRecipeSerialized()]};PluginsService.transformToDevPlugin(modalScope,convertAPIFunc,getAPICallParams,"plugin-convert-to-customcode","customCodeRecipes",type)})}};return svc});app.directive("codeBasedRecipeBase",function($timeout,$stateParams,DataikuAPI,Assert,StateUtils,TopNav,RecipesUtils,$rootScope){return{controller:function($scope){const tabToSelect=StateUtils.defaultTab($scope.creation?"io":"code");TopNav.setTab(tabToSelect);Assert.inScope($scope,"hooks");function insert(text){if(!text)return;$timeout(function(){$scope.cm.replaceSelection(text,"end")});$scope.cm.focus()}function checkDatasetFragmentsLoaded(type,dataset){return $scope.insertableFragments&&$scope.insertableFragments[type][dataset.name]}function checkStreamingEndpointFragmentsLoaded(type,streamingEndpoint){return $scope.insertableFragments&&$scope.insertableFragments[type][streamingEndpoint.id]}$scope.insertColumn=function(type,dataset,column){if(checkDatasetFragmentsLoaded(type,dataset)){insert($scope.insertableFragments[type][dataset.name].columnRefs[column.name])}if(checkStreamingEndpointFragmentsLoaded(type,dataset)){insert($scope.insertableFragments[type][dataset.id].columnRefs[column.name])}};$scope.insertDataset=function(type,dataset){if(checkDatasetFragmentsLoaded(type,dataset)){insert($scope.insertableFragments[type][dataset.name].datasetRef)}};$scope.insertStreamingEndpoint=function(type,streamingEndpoint){if(checkStreamingEndpointFragmentsLoaded(type,streamingEndpoint)){insert($scope.insertableFragments[type][streamingEndpoint.id].datasetRef)}};$scope.$watchGroup(["recipe.inputs","recipe.outputs"],function(){DataikuAPI.flow.recipes.getInsertableFragments($stateParams.projectKey,$scope.recipe).success(function(fragments){$scope.insertableFragments=fragments}).error(setErrorInScope.bind($scope))},true);$scope.rightUIState={activeTab:"datasets"};$scope.resolveCodeForPreviewFunc=function(sample){var inputs=RecipesUtils.getFlatInputsList($scope.recipe);var outputs=RecipesUtils.getFlatOutputsList($scope.recipe);var resolveCode=sample.code;if(typeof resolveCode!=="undefined"&&inputs.length>0){var inputRegexp=new RegExp("__FIRST_INPUT__","g");resolveCode=resolveCode.replace(inputRegexp,inputs[0].ref)}if(typeof resolveCode!=="undefined"&&outputs.length>0){var outputRegexp=new RegExp("__FIRST_OUTPUT__","g");resolveCode=resolveCode.replace(outputRegexp,outputs[0].ref)}return resolveCode};$scope.resolveCodeForInsertionFunc=function(sample){var code="\n\n";code+=$scope.resolveCodeForPreviewFunc(sample);return code};$scope.$watch("topNav.tab",function(newVal){if(newVal==="code"){$scope.loadRecipeVariables()}});$scope.showWidePane=$rootScope.appConfig.aiGenerateSQLEnabled&&($scope.editorOptions.mode==="text/x-sql"||$scope.editorOptions.mode==="text/x-sql2")||$rootScope.appConfig.aiExplanationsEnabled&&($scope.editorOptions.mode==="text/x-python"||$scope.editorOptions.mode==="text/x-sql2")}}});app.directive("codeBasedRecipeAutofill",function(){return{controller:function($scope,DataikuAPI){var no_user_edit=false;var auto_change=false;var autofill=function(){auto_change=true;if($scope.autofillCode&&$scope.computablesMap)$scope.autofillCode();window.setTimeout(function(){if($scope.cm!=null&&$scope.script.data!=null&&$scope.cm.getValue()!=$scope.script.data){$scope.cm.setValue($scope.script.data)}auto_change=false},0)};if($scope.script.data==undefined||!$scope.script.data.length){no_user_edit=true;autofill()}$scope.$watch("script.data",function(nv,ov){if(!auto_change){no_user_edit=false}});var onRecipeIoOrComputableChange=function(){if(no_user_edit){var typing=0;auto_change=true;autofill()}};$scope.$on("computablesMapChanged",onRecipeIoOrComputableChange);$scope.$watch("[ recipe.inputs, recipe.outputs ]",onRecipeIoOrComputableChange,true)}}});app.controller("RecipeFromNotebookCreationController",function($scope,$stateParams,$controller,StateUtils,DataikuAPI,WT1,Fn,RecipeComputablesService,Logger){$controller("_RecipeCreationControllerBase",{$scope:$scope});$scope.setComputablesMap=function(map){$scope.computablesMap=map;$scope.$broadcast("computablesMapChanged")};$scope.recipeWT1Event=function(type,params){WT1.event(type,params||{})};$scope.createRecipe=function(){$("iframe#jupyter-iframe")[0].contentWindow.IPython.notebook.save_notebook().then(function(){WT1.event("notebook-ipython-create-recipe");$scope.creatingRecipe=true;DataikuAPI.jupyterNotebooks.createRecipeFromNotebook($stateParams.projectKey,$scope.notebookName,$scope.recipe).success(function(data){$scope.creatingRecipe=false;$scope.dismiss();StateUtils.go.recipe(data.id)}).error(function(a,b,c){$scope.creatingRecipe=false;setErrorInScope.bind($scope)(a,b,c)})}).catch(setErrorInScope.bind($scope))};function init(){$scope.recipe={projectKey:$stateParams.projectKey,type:$scope.newRecipeType,inputs:{},outputs:{},params:{}};RecipeComputablesService.getComputablesMap($scope.recipe,$scope).then(function(map){if($scope.analyzedDataset){let isAnalyzedDatasetInComputables=false;for(const computable of Object.values(map)){if(computable.type==="DATASET"&&computable.smartName===$scope.analyzedDataset){$scope.recipe.inputs.main={items:[{ref:$scope.analyzedDataset,deps:[]}]};isAnalyzedDatasetInComputables=true;break}}if(!isAnalyzedDatasetInComputables)Logger.warn(`Could not find analyzed (associated) dataset ${$scope.analyzedDataset} in computables map.`)}$scope.setComputablesMap(map)})}$scope.$watch("newRecipeType",Fn.doIfNv(init));addDatasetUniquenessCheck($scope,DataikuAPI,$stateParams.projectKey);fetchManagedDatasetConnections($scope,DataikuAPI)});app.controller("CodeBasedRecipeCreationController",function($scope,$stateParams,$state,$controller,Fn,DataikuAPI,WT1,RecipesUtils,RecipeDescService,RecipeComputablesService,PartitionDeps,BigDataService){$controller("_RecipeCreationControllerBase",{$scope:$scope});function init(){$scope.recipeName={};$scope.script="";$scope.recipe={projectKey:$stateParams.projectKey,type:$scope.newRecipeType,inputs:{},outputs:{},params:{}};if($scope.recipePrefillKey){var prefill=BigDataService.fetch($scope.recipePrefillKey);if(prefill){if(prefill.script){$scope.script=prefill.script}if(prefill.input){prefill.input.forEach(function(x){RecipesUtils.addInput($scope.recipe,"main",x)})}if(prefill.output){prefill.output.forEach(function(x){RecipesUtils.addOutput($scope.recipe,"main",x)})}if(prefill.notebookId){$scope.recipe.params.sqlNotebookId=prefill.notebookId}}}if($scope.preselectedInputs){if(angular.isArray($scope.preselectedInputs)){$scope.preselectedInputs.forEach(function(input){RecipesUtils.addInput($scope.recipe,"main",input)})}else{RecipesUtils.addInput($scope.recipe,"main",$scope.preselectedInputs)}}RecipeComputablesService.getComputablesMap($scope.recipe,$scope).then(function(map){$scope.setComputablesMap(map);setEnvSelection()})}$scope.$watch("[recipe.inputs, recipe.outputs]",function(nv,ov){if(nv&&$scope.recipe&&$scope.recipe.inputs&&$scope.recipe.outputs){if($scope.preselectedInputs&&$scope.recipe.inputs.main.items.map(it=>it.ref)[0]!=$scope.preselectedInputs[0]){$scope.zone=null}var outputs=RecipesUtils.getFlatOutputsList($scope.recipe);if(outputs.length&&RecipeDescService.hasValidRequiredRoles($scope.recipe)){$scope.recipeName.name="compute_"+outputs[0].ref}else{$scope.recipeName.name=null}setEnvSelection()}},true);$scope.$watch("newRecipeType",Fn.doIfNv(init));addDatasetUniquenessCheck($scope,DataikuAPI,$stateParams.projectKey);fetchManagedDatasetConnections($scope,DataikuAPI);function setEnvSelection(){if($scope.newRecipeType=="python"&&$scope.computablesMap&&$scope.recipe&&$scope.recipe.inputs&&$scope.recipe.inputs.main&&$scope.recipe.inputs.main.items){let knowledgeBankInputs=$scope.recipe.inputs.main.items.filter(i=>$scope.computablesMap[i.ref].type=="RETRIEVABLE_KNOWLEDGE");if(knowledgeBankInputs.length>0){var knowledgeBank=$scope.computablesMap[knowledgeBankInputs[0].ref];if(knowledgeBank.retrievableKnowledge&&knowledgeBank.retrievableKnowledge.envSelection){$scope.recipe.params.envSelection=knowledgeBank.retrievableKnowledge.envSelection}}}}});app.controller("_CodeBasedRecipeControllerBase",function($scope,$stateParams){$scope.enableAutoFixup()});app.controller("DummyRecipeController",function($scope,TopNav,StateUtils){TopNav.setTab(StateUtils.defaultTab("settings"));$scope.hooks.recipeIsDirty=function(){return false}});app.controller("MeaningPopoverController",function($scope,DataikuAPI,UDM_TYPES){$scope.types=UDM_TYPES;$scope.user_defined=!!$scope.col.meaning;$scope.getPlacement=function(tip,el){var offset=$(el).offset(),top=offset.top,height=$(document).outerHeight();return.5*height-top>0?"bottom":"top"};if(!$scope.appConfig.meanings.categories.filter(function(cat){return cat.label==="User-defined"})[0].meanings.filter(function(mapping){return mapping.id===$scope.col.meaning}).length){$scope.hide=true;return}DataikuAPI.meanings.getUDM($scope.col.meaning).success(function(udm){$scope.selected={item:{_source:udm}};$scope.selected.item._source.udm_type=udm.type})})})();(function(){"use strict";const app=angular.module("dataiku.recipes");app.factory("CodeRecipeFillingHelper",function(RecipesUtils){var svc={getIOData:function($scope){const inputItems=RecipesUtils.getInputsForRole($scope.recipe,"main");const inputDatasets=inputItems.map(item=>$scope.computablesMap[item.ref]).filter(x=>x.type=="DATASET");const inputStreamingEndpoints=inputItems.map(item=>$scope.computablesMap[item.ref]).filter(x=>x.type=="STREAMING_ENDPOINT");const outputItems=RecipesUtils.getOutputsForRole($scope.recipe,"main");const outputDatasets=outputItems.map(item=>$scope.computablesMap[item.ref]).filter(x=>x.type=="DATASET");const outputStreamingEndpoints=outputItems.map(item=>$scope.computablesMap[item.ref]).filter(x=>x.type=="STREAMING_ENDPOINT");return{inputItems:inputItems,inputDatasets:inputDatasets,inputStreamingEndpoints:inputStreamingEndpoints,outputItems:outputItems,outputDatasets:outputDatasets,outputStreamingEndpoints:outputStreamingEndpoints,isOneDatasetToOneDataset:inputDatasets.length==1&&outputDatasets.length==1,isOneStreamingEndpointToOneDataset:inputDatasets.length==0&&inputStreamingEndpoints.length==1&&outputDatasets.length==1&&outputStreamingEndpoints.length==0,isOneDatasetToOneStreamingEndpoint:inputDatasets.length==1&&inputStreamingEndpoints.length==0&&outputDatasets.length==0&&outputStreamingEndpoints.length==1,isOneStreamingEndpointToOneStreamingEndpoint:inputDatasets.length==0&&inputStreamingEndpoints.length==1&&outputDatasets.length==0&&outputStreamingEndpoints.length==1}}};return svc});app.factory("ComputableDataUtils",function(){function populateModelData(computable,itemRef,data,modelCounts){data+="# "+computable.label+"\n";if(computable.model&&["PYTHON_AGENT","PLUGIN_AGENT","TOOLS_USING_AGENT","LLM_GENERIC","RETRIEVAL_AUGMENTED_LLM"].includes(computable.model.savedModelType)){if(modelCounts.llm===1){data+="client = dataiku.api_client()\n";data+="project = client.get_default_project()\n"}if(computable.llmId!==undefined){data+="llm_"+modelCounts.llm+' = project.get_llm("'+computable.llmId+'")\n'}else{data+="llm_"+modelCounts.llm+' = project.get_llm("...") # Add the llm ID when you have an active version\n'}data+="completion_"+modelCounts.llm+" = llm_"+modelCounts.llm+".new_completion()\n";data+="query_"+modelCounts.llm+' = "..."\n';data+="completion_"+modelCounts.llm+".with_message(query_"+modelCounts.llm+")\n";data+="response_"+modelCounts.llm+" = completion_"+modelCounts.llm+".execute() # Call your llm\n";modelCounts.llm++}else{data+="model_"+modelCounts.ml+' = dataiku.Model("'+itemRef+'")\n';data+="pred_"+modelCounts.ml+" = model_"+modelCounts.ml+".get_predictor()\n";modelCounts.ml++}return data}return{populateModelData:populateModelData}});app.controller("PythonRecipeController",function($scope,$rootScope,CodeBasedEditorUtils,CodeBasedValidationUtils,CodeBasedToPluginConverter,CodeMirrorSettingService,DataikuAPI,$q,TopNav,$state,$stateParams,RecipesUtils,RecipeRunJobService,CreateModalFromTemplate,Dialogs,WT1,$timeout,CodeRecipeFillingHelper,ComputableDataUtils){$scope.enableAutoFixup();$scope.identifierQuote='"';$scope.editorOptions=CodeBasedEditorUtils.editorOptions("text/x-python",$scope,true);CodeBasedEditorUtils.registerBroadcastSelectionHandler($scope.editorOptions);CodeBasedEditorUtils.setRecipeScript($scope.script);$scope.hooks.insertVariable=function(variableName,type){$timeout(function(){if(type=="FLOW"){$scope.cm.replaceSelection('dataiku.dku_flow_variables["'+variableName+'"]',"end")}else{$scope.cm.replaceSelection('dataiku.get_custom_variables()["'+variableName+'"]',"end")}});$scope.cm.focus()};$scope.autofillCode=function(){const recipeIOData=CodeRecipeFillingHelper.getIOData($scope);$scope.script.data="# -*- coding: utf-8 -*-\n";$scope.script.data+="import dataiku\n";$scope.script.data+="import pandas as pd, numpy as np\n";$scope.script.data+="from dataiku import pandasutils as pdu\n\n";if(recipeIOData.inputItems.length>0){$scope.script.data+="# Read recipe inputs\n"}let modelCounts={ml:1,llm:1};recipeIOData.inputItems.forEach(function(item){var computable=$scope.computablesMap[item.ref];if(computable.type=="DATASET"){$scope.script.data+=computable.variableName+' = dataiku.Dataset("'+item.ref+'")\n';$scope.script.data+=computable.variableName+"_df = "+computable.variableName+".get_dataframe()\n"}else if(computable.type=="MANAGED_FOLDER"){$scope.script.data+=computable.variableName+' = dataiku.Folder("'+item.ref+'")\n';$scope.script.data+=computable.variableName+"_info = "+computable.variableName+".get_info()\n"}else if(computable.type=="SAVED_MODEL"){$scope.script.data+=ComputableDataUtils.populateModelData(computable,item.ref,$scope.script.data,modelCounts)}else if(computable.type=="MODEL_EVALUATION_STORE"){$scope.script.data+=computable.variableName+' = dataiku.ModelEvaluationStore("'+item.ref+'")\n';$scope.script.data+=computable.variableName+"_info = "+computable.variableName+".get_info()\n";modelCounts.ml++}else if(computable.type=="RETRIEVABLE_KNOWLEDGE"){$scope.script.data+='kb = dataiku.KnowledgeBank(id="'+item.ref+'")\n';$scope.script.data+="vector_store = kb.as_langchain_vectorstore()\n";$scope.script.data+='query = "..."\n';$scope.script.data+="search_results = vector_store.similarity_search(query) # query your KB\n"}});$scope.script.data+="\n\n";if(recipeIOData.isOneDatasetToOneDataset){const outputDataset0Computable=$scope.computablesMap[recipeIOData.outputDatasets[0].name];const inputDataset0Computable=$scope.computablesMap[recipeIOData.inputDatasets[0].smartName];$scope.script.data+="# Compute recipe outputs from inputs\n";$scope.script.data+="# TODO: Replace this part by your actual code that computes the output, as a Pandas dataframe\n";$scope.script.data+="# NB: DSS also supports other kinds of APIs for reading and writing data. Please see doc.\n\n";$scope.script.data+=outputDataset0Computable.variableName+"_df = "+inputDataset0Computable.variableName+"_df # For this sample code, simply copy input to output\n"}else if(recipeIOData.outputDatasets.length>0){$scope.script.data+="# Compute recipe outputs\n";$scope.script.data+="# TODO: Write here your actual code that computes the outputs\n";$scope.script.data+="# NB: DSS supports several kinds of APIs for reading and writing data. Please see doc.\n\n";recipeIOData.outputItems.forEach(function(item){var computable=$scope.computablesMap[item.ref];if(computable.type=="DATASET"){$scope.script.data+=computable.variableName+"_df = ... # Compute a Pandas dataframe to write into "+item.ref+"\n"}})}$scope.script.data+="\n\n";if(recipeIOData.outputItems.length>0){$scope.script.data+="# Write recipe outputs\n"}recipeIOData.outputItems.forEach(function(item){var computable=$scope.computablesMap[item.ref];if(computable.type=="DATASET"){$scope.script.data+=computable.variableName+' = dataiku.Dataset("'+item.ref+'")\n';$scope.script.data+=computable.variableName+".write_with_schema("+computable.variableName+"_df)\n"}else if(computable.type=="MANAGED_FOLDER"){$scope.script.data+=computable.variableName+' = dataiku.Folder("'+item.ref+'")\n';$scope.script.data+=computable.variableName+"_info = "+computable.variableName+".get_info()\n"}else if(computable.type=="STREAMING_ENDPOINT"){$scope.script.data+=computable.variableName+' = dataiku.StreamingEndpoint("'+item.ref+'")\n';$scope.script.data+="with "+computable.variableName+".get_writer() as "+computable.variableName+"_writer:\n";$scope.script.data+="    # "+computable.variableName+"_writer.write_row_dict(...)\n";$scope.script.data+="    # "+computable.variableName+"_writer.flush()\n"}else if(computable.type=="MODEL_EVALUATION_STORE"){$scope.script.data+=computable.variableName+' = dataiku.ModelEvaluationStore("'+item.ref+'")\n';$scope.script.data+=computable.variableName+"_info = "+computable.variableName+".get_info()\n"}})};$scope.hooks.transformToDevPlugin=function(){CodeBasedToPluginConverter.transformToDevPlugin($scope,DataikuAPI.flow.recipes.python.convertToCustom,"python")};$rootScope.$broadcast("transformToDevPlugin",$scope.hooks.transformToDevPlugin);$scope.validateRecipe=function(){return CodeBasedValidationUtils.getGenericCheckPromise($scope).then(function(valResult){$scope.valCtx.validationResult=valResult;CodeBasedEditorUtils.updateLinter(valResult,$scope.linterFunction);return valResult})};$scope.hooks.preRunValidate=$scope.validateRecipe});app.controller("CPythonRecipeController",function($scope,$controller,CodeBasedEditorUtils,CodeBasedValidationUtils,CodeRecipeFillingHelper,CodeBasedToPluginConverter,DataikuAPI,$q,TopNav,$state,$stateParams,RecipesUtils,RecipeRunJobService,CreateModalFromTemplate,Dialogs,WT1,$timeout,Logger,ComputableDataUtils){$controller("_ContinuousRecipeInitStartedJobBehavior",{$scope:$scope});$scope.enableAutoFixup();$scope.identifierQuote='"';$scope.editorOptions=CodeBasedEditorUtils.editorOptions("text/x-python",$scope,true);CodeBasedEditorUtils.registerBroadcastSelectionHandler($scope.editorOptions);CodeBasedEditorUtils.setRecipeScript($scope.script);$scope.hooks.insertVariable=function(variableName,type){$timeout(function(){if(type=="FLOW"){$scope.cm.replaceSelection('dataiku.dku_flow_variables["'+variableName+'"]',"end")}else{$scope.cm.replaceSelection('dataiku.get_custom_variables()["'+variableName+'"]',"end")}});$scope.cm.focus()};$scope.autofillCode=function(functionMode){var suffix;if(functionMode!==undefined&&$scope.script.data&&$scope.script.data.length>0){let endOfUserCode=$scope.script.data.indexOf("# Previous code");if(endOfUserCode<0){suffix='\n\n# Previous code \n"""\n'+$scope.script.data.trim()+'\n"""\n'}else{suffix='\n\n# Previous code since code mode change\n"""\n'+$scope.script.data.substring(0,endOfUserCode).trim()+'\n"""\n'}}else{suffix=""}if(functionMode){$scope.script.data=""}else{$scope.script.data="# -*- coding: utf-8 -*-\n"}$scope.script.data+="import dataiku\n";$scope.script.data+="import pandas as pd, numpy as np, json\n";$scope.script.data+="from dataiku import pandasutils as pdu\n\n";const recipeIOData=CodeRecipeFillingHelper.getIOData($scope);if(recipeIOData.inputItems.length>0){$scope.script.data+="# Read recipe inputs\n"}let modelCounts={ml:1,llm:1};recipeIOData.inputItems.forEach(function(item){var computable=$scope.computablesMap[item.ref];if(computable.type=="DATASET"){$scope.script.data+=computable.variableName+' = dataiku.Dataset("'+item.ref+'")\n';$scope.script.data+=computable.variableName+"_df = "+computable.variableName+".get_dataframe()\n"}else if(computable.type=="STREAMING_ENDPOINT"){$scope.script.data+=computable.variableName+' = dataiku.StreamingEndpoint("'+item.ref+'")\n';if(!functionMode){if(computable.streamingEndpoint.type=="kafka"){$scope.script.data+=computable.variableName+"_messages = "+computable.variableName+".get_message_iterator() # use as a generator, prefer get_native_kafka_consumer()\n"}else if(computable.streamingEndpoint.type=="sqs"){$scope.script.data+=computable.variableName+"_messages = "+computable.variableName+".get_message_iterator() # use as a generator, prefer get_native_sqs_consumer()\n"}else if(computable.streamingEndpoint.type=="httpsse"){$scope.script.data+=computable.variableName+"_messages = "+computable.variableName+".get_message_iterator() # use as a generator, prefer get_native_httpsse_consumer()\n"}}}else if(computable.type=="MANAGED_FOLDER"){$scope.script.data+=computable.variableName+' = dataiku.Folder("'+item.ref+'")\n';$scope.script.data+=computable.variableName+"_info = "+computable.variableName+".get_info()\n"}else if(computable.type=="SAVED_MODEL"){$scope.script.data+=ComputableDataUtils.populateModelData(computable,item.ref,$scope.script.data,modelCounts)}});$scope.script.data+="\n\n";if(functionMode){if(recipeIOData.outputItems.length>0){$scope.script.data+="# Write recipe outputs\n";recipeIOData.outputItems.forEach(function(item){var computable=$scope.computablesMap[item.ref];if(computable.type=="DATASET"){$scope.script.data+=computable.variableName+' = dataiku.Dataset("'+item.ref+'")\n'}else if(computable.type=="STREAMING_ENDPOINT"){$scope.script.data+=computable.variableName+' = dataiku.StreamingEndpoint("'+item.ref+'")\n'}else if(computable.type=="MANAGED_FOLDER"){$scope.script.data+=computable.variableName+' = dataiku.Folder("'+item.ref+'")\n';$scope.script.data+=computable.variableName+"_info = "+computable.variableName+".get_info()\n"}});$scope.script.data+="def init():\n";$scope.script.data+="    # called once, before the main loop of calls to process() starts\n";let schemaSuggested="...";if(recipeIOData.inputStreamingEndpoints.length==1){const inputSE0=recipeIOData.inputStreamingEndpoints[0];const inputComputable0=$scope.computablesMap[inputSE0.smartName];schemaSuggested=inputComputable0.variableName+".get_schema()"}recipeIOData.outputItems.forEach(function(item){var computable=$scope.computablesMap[item.ref];if(computable.type=="DATASET"){$scope.script.data+="    "+computable.variableName+".write_schema("+schemaSuggested+") # construct the list of columns in the output dataset\n"}else if(computable.type=="STREAMING_ENDPOINT"){$scope.script.data+="    "+computable.variableName+".set_schema("+schemaSuggested+") # construct the list of columns in the output streaming endpoint\n"}})}$scope.script.data+="\n\n";$scope.script.data+="# Process input in batches\n";$scope.script.data+="def process(inputs, outputs):\n";$scope.script.data+="    # TODO: Write here your actual code that computes the outputs\n";recipeIOData.inputItems.forEach(function(item){var computable=$scope.computablesMap[item.ref];if(computable.type=="STREAMING_ENDPOINT"){$scope.script.data+="    df_"+computable.variableName+" = inputs.get("+computable.variableName+")\n"}});let dataSuggested="...";if(recipeIOData.inputStreamingEndpoints.length==1&&recipeIOData.inputDatasets.length==0){let inputSE0=recipeIOData.inputStreamingEndpoints[0];let inputComputable0=$scope.computablesMap[inputSE0.smartName];dataSuggested="df_"+inputComputable0.variableName}recipeIOData.outputItems.forEach(function(item){var computable=$scope.computablesMap[item.ref];if(computable.type=="DATASET"){$scope.script.data+="    outputs.set("+computable.variableName+", "+dataSuggested+")\n"}else if(computable.type=="STREAMING_ENDPOINT"){$scope.script.data+="    outputs.set("+computable.variableName+", "+dataSuggested+")\n"}})}else{$scope.script.data+="# Compute recipe outputs\n";$scope.script.data+="# TODO: Write here your actual code that computes the outputs\n";$scope.script.data+="# NB: DSS supports several kinds of APIs for reading and writing data. Please see doc.\n\n";if(recipeIOData.outputItems.length>0){$scope.script.data+="# Write recipe outputs\n"}if(recipeIOData.isOneDatasetToOneStreamingEndpoint){let item=recipeIOData.outputItems[0];let inputItem=recipeIOData.inputItems[0];let inputComputable=$scope.computablesMap[inputItem.ref];let computable=$scope.computablesMap[item.ref];$scope.script.data+=computable.variableName+' = dataiku.StreamingEndpoint("'+item.ref+'")\n';$scope.script.data+=computable.variableName+".set_schema("+inputComputable.variableName+".read_schema()) # construct the list of columns in the output streaming endpoint\n";$scope.script.data+="with "+computable.variableName+".get_writer() as "+computable.variableName+"_writer:\n";$scope.script.data+="    cnt = 0\n";$scope.script.data+="    for i, row in "+inputComputable.variableName+"_df.iterrows(): # iterate over rows to write \n";$scope.script.data+="        "+computable.variableName+"_writer.write_row_dict(row.to_dict())\n";$scope.script.data+="        cnt += 1\n";$scope.script.data+="        if cnt > 100:\n";$scope.script.data+="            cnt = 0\n";$scope.script.data+="            "+computable.variableName+"_writer.flush()\n";$scope.script.data+="\n";$scope.script.data+="raise Exception('No more data to read')\n"}else if(recipeIOData.isOneStreamingEndpointToOneStreamingEndpoint){let item=recipeIOData.outputItems[0];let inputItem=recipeIOData.inputItems[0];let inputComputable=$scope.computablesMap[inputItem.ref];let computable=$scope.computablesMap[item.ref];$scope.script.data+=computable.variableName+' = dataiku.StreamingEndpoint("'+item.ref+'")\n';$scope.script.data+=computable.variableName+".set_schema("+inputComputable.variableName+".get_schema()) # construct the list of columns in the output streaming endpoint\n";$scope.script.data+="with "+computable.variableName+".get_writer() as "+computable.variableName+"_writer:\n";$scope.script.data+="    cnt = 0\n";$scope.script.data+="    for row in "+inputComputable.variableName+"_messages: # iterate over rows to write \n";$scope.script.data+="        "+computable.variableName+"_writer.write_row_dict(row)\n";$scope.script.data+="        cnt += 1\n";$scope.script.data+="        if cnt > 100:\n";$scope.script.data+="            cnt = 0\n";$scope.script.data+="            "+computable.variableName+"_writer.flush()\n"}else if(recipeIOData.isOneStreamingEndpointToOneDataset){let item=recipeIOData.outputItems[0];let inputItem=recipeIOData.inputItems[0];let inputComputable=$scope.computablesMap[inputItem.ref];let computable=$scope.computablesMap[item.ref];$scope.script.data+=computable.variableName+' = dataiku.Dataset("'+item.ref+'")\n';$scope.script.data+=computable.variableName+".write_schema("+inputComputable.variableName+".get_schema()) # construct the list of columns in the output dataset\n";$scope.script.data+="with "+computable.variableName+".get_continuous_writer('"+$stateParams.recipeName+"') as "+computable.variableName+"_writer:\n";$scope.script.data+="    cnt = 0\n";$scope.script.data+="    for row in "+inputComputable.variableName+"_messages: # iterate over rows to write \n";$scope.script.data+="        "+computable.variableName+"_writer.write_row_dict(row)\n";$scope.script.data+="        cnt += 1\n";$scope.script.data+="        if cnt > 100:\n";$scope.script.data+="            cnt = 0\n";$scope.script.data+="            "+computable.variableName+"_writer.checkpoint(str(cnt))\n"}else{recipeIOData.outputItems.forEach(function(item){const computable=$scope.computablesMap[item.ref];if(computable.type=="DATASET"){$scope.script.data+=computable.variableName+' = dataiku.Dataset("'+item.ref+'")\n';$scope.script.data+=computable.variableName+".write_schema(...) # construct the list of columns in the output dataset\n";$scope.script.data+="with "+computable.variableName+".get_continuous_writer() as "+computable.variableName+"_writer:\n";$scope.script.data+="    "+computable.variableName+"_writer.write_row_dict(...) # generate data to write \n"}else if(computable.type=="STREAMING_ENDPOINT"){$scope.script.data+=computable.variableName+' = dataiku.StreamingEndpoint("'+item.ref+'")\n';$scope.script.data+=computable.variableName+".set_schema(...) # construct the list of columns in the output streaming endpoint\n";$scope.script.data+="with "+computable.variableName+".get_writer() as "+computable.variableName+"_writer:\n";$scope.script.data+="    cnt = 0\n";$scope.script.data+="    for row in ...: # generate data to write \n";$scope.script.data+="        "+computable.variableName+"_writer.write_row_dict(row) # Here row is a dict \n";$scope.script.data+="        cnt += 1\n";$scope.script.data+="        if cnt > 100:\n";$scope.script.data+="            cnt = 0\n";$scope.script.data+="            "+computable.variableName+"_writer.flush()\n"}else if(computable.type=="MANAGED_FOLDER"){$scope.script.data+=computable.variableName+' = dataiku.Folder("'+item.ref+'")\n';$scope.script.data+=computable.variableName+"_info = "+computable.variableName+".get_info()\n"}})}}$scope.script.data+="\n\n";$scope.script.data+=suffix};$scope.transformToDevPlugin=function(){CodeBasedToPluginConverter.transformToDevPlugin($scope,DataikuAPI.flow.recipes.python.convertToCustom,"python")};$scope.validateRecipe=function(){return CodeBasedValidationUtils.getGenericCheckPromise($scope).then(function(valResult){$scope.valCtx.validationResult=valResult;CodeBasedEditorUtils.updateLinter(valResult,$scope.linterFunction);return valResult})};$scope.hooks.preRunValidate=$scope.validateRecipe;$scope.selectCodeMode=function(){var items=[{mode:"FREE_FORM",title:"Free-Form",desc:"The code is a script."},{mode:"FUNCTION",title:"Function",desc:"The code defines a process function, taking in batches of input rows and producing batches of output rows."}];Dialogs.select($scope,"Code mode","Select the mode for the code:",items,items[$scope.recipe.params.codeMode==="FUNCTION"?1:0]).then(function(item){$scope.recipe.params.codeMode=item.mode},function(){})};$scope.$watch("recipe.params.codeMode",function(mode,previous){Logger.info("Transform: from "+previous+" to "+mode);if(mode==="FUNCTION"&&previous==="FREE_FORM"){$scope.autofillCode(true);$timeout($scope.cm.setValue.bind($scope.cm,$scope.script.data),0)}else if(mode==="FREE_FORM"&&previous==="FUNCTION"){$scope.autofillCode(false);$timeout($scope.cm.setValue.bind($scope.cm,$scope.script.data),0)}});let setupFeedParams=function(){if(!$scope.recipe)return;if($scope.recipe.params.codeMode!="FUNCTION")return;if(!$scope.computablesMap)return;$scope.recipe.outputs["main"].items.forEach(function(output){var production=$scope.recipe.params.feedParams.outputs.filter(function(o){return o.ref==output.ref})[0];if(production==null){production={ref:output.ref,checkpointingType:"none",checkpointingParams:{}};let computable=$scope.computablesMap[output.ref];if(computable!=null&&computable.type=="DATASET"){production["checkpointingType"]="dataset";production["checkpointingParams"]["checkpointInterval"]=1e4;production["checkpointingParams"]["checkpointMaxRows"]=1e5}$scope.recipe.params.feedParams.outputs.push(production)}});if($scope.recipe.inputs.main&&$scope.recipe.inputs["main"].items){$scope.recipe.inputs["main"].items.forEach(function(input){var consumption=$scope.recipe.params.feedParams.inputs.filter(function(i){return i.ref==input.ref})[0];if(consumption==null){consumption={ref:input.ref,withWindow:false};let computable=$scope.computablesMap[input.ref];if(computable!=null&&computable.type=="STREAMING_ENDPOINT"){$scope.recipe.params.feedParams.inputs.push(consumption)}}})}$scope.recipe.params.feedParams.outputs=$scope.recipe.params.feedParams.outputs.filter(function(production){let output=$scope.recipe.outputs["main"].items.filter(function(o){return o.ref==production.ref})[0];return output!=null});$scope.recipe.params.feedParams.inputs=$scope.recipe.params.feedParams.inputs.filter(function(consumption){let input=$scope.recipe.inputs["main"].items.filter(function(i){return i.ref==consumption.ref})[0];return input!=null})};setupFeedParams();$scope.$watch("recipe.params.codeMode",setupFeedParams,false);$scope.$watch("recipe.inputs.main.items",setupFeedParams,true);$scope.$watch("recipe.outputs.main.items",setupFeedParams,true);$scope.$watch("computablesMap",setupFeedParams,false)});app.directive("feedProductionSettings",function(){return{scope:{computablesMap:"=",production:"="},templateUrl:"/templates/recipes/fragments/feed-production-settings.html",link:function($scope,element,attrs){let init=function(){$scope.possibleTypes=[];$scope.possibleTypesDescriptions=[];if(!$scope.computablesMap)return;if(!$scope.production)return;$scope.computable=$scope.computablesMap[$scope.production.ref];if($scope.computable.type=="DATASET"){$scope.possibleTypes.push({type:"dataset",label:"In the dataset"});$scope.possibleTypesDescriptions.push("Store checkpoint alongside the data if possible: as a hidden file for file-based dataset, in a dedicated table for sql dataset")}else if($scope.computable.type=="STREAMING_ENDPOINT"){$scope.possibleTypes.push({type:"none",label:"Don't store checkpoints"});$scope.possibleTypesDescriptions.push("");if($scope.computable.streamingEndpoint.type=="kafka"){$scope.possibleTypes.push({type:"kafka_transaction",label:"In a Kafka topic"});$scope.possibleTypesDescriptions.push("Store checkpoints in a second topic")}}$scope.possibleTypes.push({type:"file",label:"In a file"});$scope.possibleTypesDescriptions.push("Store checkpoints in a file on the local filesystem")};init();$scope.$watch("computablesMap",init,false);$scope.$watch("production",init,false);let fixupCheckpointingParams=function(){if(["dataset","file"].indexOf($scope.production.checkpointingType)>=0){$scope.production.checkpointingParams["checkpointInterval"]=$scope.production.checkpointingParams["checkpointInterval"]||1e4;$scope.production.checkpointingParams["checkpointMaxRows"]=$scope.production.checkpointingParams["checkpointMaxRows"]||1e5}if(["kafka_transaction"].indexOf($scope.production.checkpointingType)>=0){$scope.production.checkpointingParams["checkpointInterval"]=$scope.production.checkpointingParams["checkpointInterval"]||100}};$scope.$watch("production.checkpointingType",fixupCheckpointingParams)}}});app.directive("feedConsumptionSettings",function(){return{scope:{computablesMap:"=",consumption:"="},templateUrl:"/templates/recipes/fragments/feed-consumption-settings.html",link:function($scope,element,attrs){let init=function(){if(!$scope.computablesMap)return;if(!$scope.consumption)return;$scope.computable=$scope.computablesMap[$scope.consumption.ref]};init();$scope.$watch("computablesMap",init,false);$scope.$watch("consumption",init,false);$scope.canWindow=function(){return $scope.computable&&$scope.computable.type=="STREAMING_ENDPOINT"&&$scope.computable.streamingEndpoint.type.toLowerCase()=="kafka"}}}});app.controller("KsqlRecipeController",function($scope,$controller,CodeBasedEditorUtils,CodeBasedValidationUtils,CodeRecipeFillingHelper,CodeBasedToPluginConverter,ComputableSchemaRecipeSave,DataikuAPI,$q,TopNav,$state,$stateParams,RecipesUtils,RecipeRunJobService,CreateModalFromTemplate,Dialogs,WT1,$timeout){$controller("_ContinuousRecipeInitStartedJobBehavior",{$scope:$scope});$scope.enableAutoFixup();$scope.identifierQuote="`";$scope.editorOptions=CodeBasedEditorUtils.editorOptions("text/x-sql",$scope,true);$scope.hooks.insertVariable=function(variableName,type){$timeout(function(){if(type=="FLOW"){$scope.cm.replaceSelection('${"'+variableName+'"}',"end")}else{$scope.cm.replaceSelection('${"'+variableName+'"}',"end")}});$scope.cm.focus()};$scope.autofillCode=function(){$scope.script.data="// code"};$scope.synchronizeInput=function(loc){DataikuAPI.streamingEndpoints.syncKsql(loc.projectKey,loc.id,true).success(function(data){$scope.validateRecipe()}).error(setErrorInScope.bind($scope))};$scope.validateRecipe=function(){var preValidate=(new Date).getTime();return CodeBasedValidationUtils.getGenericCheckPromise($scope).then(function(valResult){$scope.valCtx.validationResult=valResult;CodeBasedEditorUtils.updateLinter(valResult,$scope.linterFunction);$scope.recipeWT1Event("ksql-validate",{ok:!valResult.topLevelMessages.error,time:(new Date).getTime()-preValidate,schemaChange:valResult.schemaResult?valResult.schemaResult.totalIncompatibilities>0:false,firstError:valResult.topLevelMessages.messages.length?valResult.topLevelMessages.messages[0].message:null});return ComputableSchemaRecipeSave.handleSchemaUpdateWithPrecomputed($scope,valResult.schemaResult).then(function(changeResult){if(changeResult.changed){return $scope.validateRecipe()}else{return valResult}})})};$scope.hooks.preRunValidate=$scope.validateRecipe});app.controller("JuliaRecipeController",function($scope,CodeBasedEditorUtils,CodeBasedValidationUtils,CodeBasedToPluginConverter,CodeMirrorSettingService,DataikuAPI,$q,TopNav,$state,$stateParams,RecipesUtils,RecipeRunJobService,CreateModalFromTemplate,Dialogs,WT1,$timeout,CodeRecipeFillingHelper){$scope.enableAutoFixup();$scope.identifierQuote='"';$scope.editorOptions=CodeBasedEditorUtils.editorOptions("text/x-julia",$scope);$scope.hooks.insertVariable=function(variableName,type){$timeout(function(){var fn=type=="FLOW"?"get_flow_variable":"get_custom_variable";$scope.cm.replaceSelection("Dataiku."+fn+'("'+variableName+'")',"end")});$scope.cm.focus()};$scope.autofillCode=function(){$scope.script.data="using Dataiku\n";$scope.script.data+="import Dataiku: get_dataframe\n\n";const recipeIOData=CodeRecipeFillingHelper.getIOData($scope);if(recipeIOData.inputItems.length>0){$scope.script.data+="# Read recipe inputs\n"}var modelCount=1;recipeIOData.inputItems.forEach(function(item){var computable=$scope.computablesMap[item.ref];if(computable.type=="DATASET"){$scope.script.data+=computable.variableName+'_df = get_dataframe(dataset"'+item.ref+'")\n'}else if(computable.type=="MANAGED_FOLDER"){$scope.script.data+=computable.variableName+'_info = Dataiku.get_settings(folder"'+item.ref+'")\n'}else if(computable.type=="SAVED_MODEL"){$scope.script.data+="# "+computable.label+"\n";$scope.script.data+="pred_"+modelCount+' = Dataiku.get_active_version(model"'+item.ref+'")\n';modelCount++}});$scope.script.data+="\n\n";if(recipeIOData.isOneDatasetToOneDataset){const outputDataset0Computable=$scope.computablesMap[recipeIOData.outputDatasets[0].name];const inputDataset0Computable=$scope.computablesMap[recipeIOData.inputDatasets[0].smartName];$scope.script.data+="# Compute recipe outputs from inputs\n";$scope.script.data+="# TODO: Replace this part by your actual code that computes the output, as a Julia DataFrame\n\n";$scope.script.data+=outputDataset0Computable.variableName+"_df = "+inputDataset0Computable.variableName+"_df # For this sample code, simply copy input to output\n"}else if(recipeIOData.outputDatasets.length>0){$scope.script.data+="# Compute recipe outputs\n";$scope.script.data+="# TODO: Write here your actual code that computes the outputs\n\n";recipeIOData.outputItems.forEach(function(item){var computable=$scope.computablesMap[item.ref];if(computable.type=="DATASET"){$scope.script.data+=computable.variableName+"_df = ... # Compute a Julia DataFrame to write into "+item.ref+"\n"}})}$scope.script.data+="\n\n";if(recipeIOData.outputItems.length>0){$scope.script.data+="# Write recipe outputs\n"}recipeIOData.outputItems.forEach(function(item){var computable=$scope.computablesMap[item.ref];if(computable.type=="DATASET"){$scope.script.data+='Dataiku.write_with_schema(dataset"'+item.ref+'", '+computable.variableName+"_df)\n"}else if(computable.type=="MANAGED_FOLDER"){$scope.script.data+=computable.variableName+'_info = Dataiku.get_settings(folder"'+item.ref+'")\n'}})};$scope.transformToDevPlugin=function(){CodeBasedToPluginConverter.transformToDevPlugin($scope,DataikuAPI.flow.recipes.julia.convertToCustom,"julia")};$scope.validateRecipe=function(){return CodeBasedValidationUtils.getGenericCheckPromise($scope).then(function(valResult){$scope.valCtx.validationResult=valResult;CodeBasedEditorUtils.updateLinter(valResult,$scope.linterFunction);return valResult})};$scope.hooks.preRunValidate=$scope.validateRecipe});app.controller("RRecipeController",function($rootScope,$scope,DataikuAPI,CodeBasedValidationUtils,CodeBasedEditorUtils,CodeBasedToPluginConverter,CodeMirrorSettingService,$state,$stateParams,RecipesUtils,Dialogs,CreateModalFromTemplate,WT1,$q,RecipeRunJobService,$timeout,CodeRecipeFillingHelper){$scope.enableAutoFixup();$scope.identifierQuote='"';$scope.editorOptions=CodeBasedEditorUtils.editorOptions("text/x-rsrc",$scope);$scope.hooks.insertVariable=function(variableName,type){$timeout(function(){var fn=type=="FLOW"?"dkuFlowVariable":"dkuCustomVariable";$scope.cm.replaceSelection(fn+'("'+variableName+'")',"end")});$scope.cm.focus()};$scope.autofillCode=function(){$scope.script.data="library(dataiku)\n\n";const recipeIOData=CodeRecipeFillingHelper.getIOData($scope);if(recipeIOData.inputItems.length>0){$scope.script.data+="# Recipe inputs\n"}recipeIOData.inputItems.forEach(function(item){var computable=$scope.computablesMap[item.ref];if(computable.type=="DATASET"){$scope.script.data+=computable.variableName+' <- dkuReadDataset("'+item.ref+'", samplingMethod="head", nbRows=100000)\n'}if(computable.type=="MANAGED_FOLDER"){$scope.script.data+=computable.variableName+' <- dkuManagedFolderPath("'+item.ref+'")\n'}});$scope.script.data+="\n";if(recipeIOData.isOneDatasetToOneDataset){const outputDataset0Computable=$scope.computablesMap[recipeIOData.outputDatasets[0].name];const inputDataset0Computable=$scope.computablesMap[recipeIOData.inputDatasets[0].smartName];$scope.script.data+="# Compute recipe outputs from inputs\n";$scope.script.data+="# TODO: Replace this part by your actual code that computes the output, as a R dataframe or data table\n";$scope.script.data+=outputDataset0Computable.variableName+" <- "+inputDataset0Computable.variableName+" # For this sample code, simply copy input to output\n"}else if(recipeIOData.outputDatasets.length>0){$scope.script.data+="# Compute recipe outputs\n";$scope.script.data+="# TODO: Write here your actual code that computes the outputs\n";recipeIOData.outputItems.forEach(function(item){var computable=$scope.computablesMap[item.ref];if(computable.type=="DATASET"){$scope.script.data+=computable.variableName+" <- replace_me # Compute a data frame for the output to write into "+item.ref+"\n"}})}$scope.script.data+="\n\n";var outputDatasets=RecipesUtils.getOutputsForRole($scope.recipe,"main");if(recipeIOData.outputItems.length>0){$scope.script.data+="# Recipe outputs\n"}recipeIOData.outputItems.forEach(function(item){var computable=$scope.computablesMap[item.ref];if(computable.type=="DATASET"){$scope.script.data+="dkuWriteDataset("+computable.variableName+',"'+item.ref+'")\n'}if(computable.type=="MANAGED_FOLDER"){$scope.script.data+=computable.variableName+' <- dkuManagedFolderPath("'+item.ref+'")\n'}})};$scope.hooks.transformToDevPlugin=function(){CodeBasedToPluginConverter.transformToDevPlugin($scope,DataikuAPI.flow.recipes.r.convertToCustom,"r")};$rootScope.$broadcast("transformToDevPlugin",$scope.hooks.transformToDevPlugin);$scope.validateRecipe=function(){return CodeBasedValidationUtils.getGenericCheckPromise($scope).then(function(valResult){$scope.valCtx.validationResult=valResult;CodeBasedEditorUtils.updateLinter(valResult,$scope.linterFunction);return valResult})};$scope.hooks.preRunValidate=$scope.validateRecipe});app.controller("ShellRecipeController",function($scope,DataikuAPI,$q,TopNav,$stateParams,RecipesUtils,RecipeRunJobService,CreateModalFromTemplate,Dialogs,$timeout,CodeBasedValidationUtils,CodeBasedEditorUtils,CodeBasedToPluginConverter){$scope.enableAutoFixup();$scope.identifierQuote="'";$scope.editorOptions=CodeBasedEditorUtils.editorOptions("text/x-sh",$scope,true);$scope.hooks.insertVariable=function(variableName,type){$timeout(function(){var shellName=(type=="USER"?"DKU_CUSTOM_VARIABLES_":"")+variableName;var shellVariable="$"+shellName;if(shellName.indexOf(".")>=0){shellVariable="$(printenv "+shellName+")"}$scope.cm.replaceSelection(shellVariable,"end")});$scope.cm.focus()};$scope.getInputOrOuputLabel=function(ref){if(ref==null||ref.length==0){return""}if($scope.computablesMap==null){return""}var computable=$scope.computablesMap[ref];return computable.label};$scope.inputDatasets=[];$scope.outputDatasets=[];var onRecipeIoOrComputableChange=function(){if($scope.computablesMap==null){return}$scope.inputDatasets=[];if($scope.recipe.inputs&&$scope.recipe.inputs["main"]&&$scope.recipe.inputs["main"].items){let found=null;$scope.recipe.inputs["main"].items.forEach(function(input){if(input.ref==$scope.recipe.params.pipeIn){found=input}if($scope.computablesMap[input.ref].dataset!=null){$scope.inputDatasets.push(input)}});if(found==null){$scope.recipe.params.pipeIn=null}}$scope.outputDatasets=[];if($scope.recipe.outputs&&$scope.recipe.outputs["main"]&&$scope.recipe.outputs["main"].items){let found=null;$scope.recipe.outputs["main"].items.forEach(function(output){if(output.ref==$scope.recipe.params.pipeOut){found=output}if($scope.computablesMap[output.ref].dataset!=null){$scope.outputDatasets.push(output)}});if(found==null){$scope.recipe.params.pipeOut=null}}$scope.validateRecipe(true)};$scope.$on("computablesMapChanged",onRecipeIoOrComputableChange);$scope.$watch("[recipe.inputs, recipe.outputs]",onRecipeIoOrComputableChange,true);$scope.validateRecipe=function(){return CodeBasedValidationUtils.getGenericCheckPromise($scope).then(function(valResult){$scope.valCtx.validationResult=valResult;CodeBasedEditorUtils.updateLinter(valResult,$scope.linterFunction);$scope.recipeWT1Event("shell-recipe-validate",{ok:!valResult.topLevelMessages.error});return valResult})};$scope.hooks.preRunValidate=$scope.validateRecipe;var superRecipeIsDirty=$scope.hooks.recipeIsDirty;$scope.hooks.recipeIsDirty=function(){if($scope.recipe.params.pipeIn==null){delete $scope.recipe.params.pipeIn}if($scope.recipe.params.pipeOut==null){delete $scope.recipe.params.pipeOut}return superRecipeIsDirty()}})})();(function(){"use strict";const app=angular.module("dataiku.recipes");app.controller("PySparkRecipeController",function($rootScope,$scope,DataikuAPI,CodeBasedEditorUtils,CodeBasedToPluginConverter,CodeBasedValidationUtils,$q,WT1,$state,$stateParams,CreateModalFromTemplate,Dialogs,RecipesUtils,$timeout,CodeRecipeFillingHelper){$scope.enableAutoFixup();if($scope.script.data==null)$scope.script.data="";$scope.identifierQuote='"';$scope.editorOptions=CodeBasedEditorUtils.editorOptions("text/x-python",$scope,true);CodeBasedEditorUtils.registerBroadcastSelectionHandler($scope.editorOptions);CodeBasedEditorUtils.setRecipeScript($scope.script);$scope.hooks.insertVariable=function(variableName,type){$timeout(function(){$scope.cm.replaceSelection('"'+variableName+'"',"end")});$scope.cm.focus()};$scope.hooks.transformToDevPlugin=function(){CodeBasedToPluginConverter.transformToDevPlugin($scope,DataikuAPI.flow.recipes.pyspark.convertToCustom,"pyspark")};$rootScope.$broadcast("transformToDevPlugin",$scope.hooks.transformToDevPlugin);$scope.autofillCode=function(){$scope.script.data="# -*- coding: utf-8 -*-\n";$scope.script.data+="import dataiku\n";$scope.script.data+="from dataiku import spark as dkuspark\n";$scope.script.data+="from pyspark import SparkContext\n";$scope.script.data+="from pyspark.sql import SQLContext\n\n";const sparkVersion=$scope.appConfig.sparkVersion||"1.X";if(sparkVersion.substring(0,1)=="1"){$scope.script.data+="sc = SparkContext()\n"}else{$scope.script.data+="sc = SparkContext.getOrCreate()\n"}$scope.script.data+="sqlContext = SQLContext(sc)\n\n";const recipeIOData=CodeRecipeFillingHelper.getIOData($scope);if(recipeIOData.inputItems.length>0){$scope.script.data+="# Read recipe inputs\n"}recipeIOData.inputItems.forEach(function(item){var computable=$scope.computablesMap[item.ref];if(computable.type=="DATASET"){$scope.script.data+=computable.variableName+' = dataiku.Dataset("'+item.ref+'")\n';$scope.script.data+=computable.variableName+"_df = dkuspark.get_dataframe(sqlContext, "+computable.variableName+")\n"}if(computable.type=="MANAGED_FOLDER"){$scope.script.data+=computable.variableName+' = dataiku.Folder("'+item.ref+'")\n';$scope.script.data+=computable.variableName+"_info = "+computable.variableName+".get_info()\n"}});$scope.script.data+="\n";if(recipeIOData.isOneDatasetToOneDataset){const outputDataset0Computable=$scope.computablesMap[recipeIOData.outputDatasets[0].name];const inputDataset0Computable=$scope.computablesMap[recipeIOData.inputDatasets[0].smartName];$scope.script.data+="# Compute recipe outputs from inputs\n";$scope.script.data+="# TODO: Replace this part by your actual code that computes the output, as a SparkSQL dataframe\n";$scope.script.data+=outputDataset0Computable.variableName+"_df = "+inputDataset0Computable.variableName+"_df # For this sample code, simply copy input to output\n"}else if(recipeIOData.outputDatasets.length>0){$scope.script.data+="# Compute recipe outputs\n";$scope.script.data+="# TODO: Write here your actual code that computes the outputs as SparkSQL dataframes\n";recipeIOData.outputItems.forEach(function(item){var computable=$scope.computablesMap[item.ref];if(computable.type=="DATASET"){$scope.script.data+=computable.variableName+"_df = ... # Compute a SparkSQL dataframe to write into "+item.ref+"\n"}})}$scope.script.data+="\n";if(recipeIOData.outputItems.length>0){$scope.script.data+="# Write recipe outputs\n"}recipeIOData.outputItems.forEach(function(item){var computable=$scope.computablesMap[item.ref];if(computable.type=="DATASET"){$scope.script.data+=computable.variableName+' = dataiku.Dataset("'+item.ref+'")\n';$scope.script.data+="dkuspark.write_with_schema("+computable.variableName+", "+computable.variableName+"_df)\n"}if(computable.type=="MANAGED_FOLDER"){var name=computable.box.name;$scope.script.data+=computable.variableName+' = dataiku.Folder("'+item.ref+'")\n';$scope.script.data+=computable.variableName+"_info = "+computable.variableName+".get_info()\n"}})};$scope.validateRecipe=function(){return CodeBasedValidationUtils.getGenericCheckPromise($scope).then(function(valResult){$scope.valCtx.validationResult=valResult;CodeBasedEditorUtils.updateLinter(valResult,$scope.linterFunction);return valResult})}});app.controller("SparkRRecipeController",function($rootScope,$scope,$q,WT1,$stateParams,RecipesUtils,CodeBasedEditorUtils,CodeBasedValidationUtils,Logger,Dialogs,$timeout,CodeRecipeFillingHelper){$scope.enableAutoFixup();if($scope.script.data==null)$scope.script.data="";$scope.identifierQuote='"';$scope.editorOptions=CodeBasedEditorUtils.editorOptions("text/x-rsrc",$scope);$scope.hooks.insertVariable=function(variableName,type){$scope.cm.replaceSelection('"'+variableName+'"',"end");$scope.cm.focus()};$scope.autofillCode=function(mode,transform){var previousCode="";if(transform&&$scope.script.data){previousCode=$scope.script.data.split("\n").map(function(x){return"# "+x}).join("\n")}const recipeIOData=CodeRecipeFillingHelper.getIOData($scope);if(mode==null)mode="SPARKR";if(mode=="SPARKR"){$scope.script.data="library(SparkR)\nlibrary(dataiku)\n";var sparkVersion=$scope.appConfig.sparkVersion||"1.X";sparkVersion=sparkVersion.substring(0,1);if(sparkVersion=="1"){$scope.script.data+="library(dataiku.spark)\n\n";$scope.script.data+="sc <- sparkR.init()\n";$scope.script.data+="sqlContext <- sparkRSQL.init(sc)\n"}else{$scope.script.data+="library(dataiku.spark2)\n\n";$scope.script.data+="sc <- sparkR.session()\n"}if(recipeIOData.inputItems.length>0){$scope.script.data+="# Recipe inputs\n"}recipeIOData.inputItems.forEach(function(item){var computable=$scope.computablesMap[item.ref];if(computable.type=="DATASET"){if(sparkVersion=="1"){$scope.script.data+=computable.variableName+' <- dkuSparkReadDataset(sqlContext, "'+item.ref+'")\n'}else{$scope.script.data+=computable.variableName+' <- dkuSparkReadDataset("'+item.ref+'")\n'}}if(computable.type=="MANAGED_FOLDER"){$scope.script.data+=computable.variableName+' <- dkuManagedFolderPath("'+item.ref+'")\n'}});$scope.script.data+="\n";if(recipeIOData.isOneDatasetToOneDataset){const outputDataset0Computable=$scope.computablesMap[recipeIOData.outputDatasets[0].name];const inputDataset0Computable=$scope.computablesMap[recipeIOData.inputDatasets[0].smartName];$scope.script.data+="# Compute recipe outputs from inputs\n";$scope.script.data+="# TODO: Replace this part by your actual code that computes the output, as Spark dataframe\n";$scope.script.data+=outputDataset0Computable.variableName+" <- "+inputDataset0Computable.variableName+" # For this sample code, simply copy input to output\n"}else if(recipeIOData.outputDatasets.length>0){$scope.script.data+="# Compute recipe outputs\n";$scope.script.data+="# TODO: Write here your actual code that computes the outputs\n";recipeIOData.outputItems.forEach(function(item){var computable=$scope.computablesMap[item.ref];if(computable.type=="DATASET"){$scope.script.data+=computable.variableName+" <- replace_me # Compute a data frame for the output to write into "+item.ref+"\n"}})}$scope.script.data+="\n\n";if(recipeIOData.outputItems.length>0){$scope.script.data+="# Recipe outputs\n"}recipeIOData.outputItems.forEach(function(item){var computable=$scope.computablesMap[item.ref];if(computable.type=="DATASET"){$scope.script.data+="dkuSparkWriteDataset("+computable.variableName+',"'+item.ref+'")\n'}if(computable.type=="MANAGED_FOLDER"){$scope.script.data+=computable.variableName+' <- dkuManagedFolderPath("'+item.ref+'")\n'}})}else{$scope.script.data="library(sparklyr)\nlibrary(dplyr)\nlibrary(dataiku.sparklyr)\n\n";$scope.script.data+="sc <- dku_spark_connect()\n\n";if(recipeIOData.inputItems.length>0){$scope.script.data+="# Recipe inputs\n"}recipeIOData.inputItems.forEach(function(item){var computable=$scope.computablesMap[item.ref];if(computable.type=="DATASET"){$scope.script.data+=computable.variableName+' <- spark_read_dku_dataset(sc, "'+item.ref+'", "'+computable.variableName+'_tbl")\n'}if(computable.type=="MANAGED_FOLDER"){$scope.script.data+=computable.variableName+' <- dkuManagedFolderPath("'+item.ref+'")\n'}});$scope.script.data+="\n";if(recipeIOData.isOneDatasetToOneDataset){const outputDataset0Computable=$scope.computablesMap[recipeIOData.outputDatasets[0].name];const inputDataset0Computable=$scope.computablesMap[recipeIOData.inputDatasets[0].smartName];$scope.script.data+="# Compute recipe outputs from inputs\n";$scope.script.data+="# TODO: Replace this part by your actual code that computes the output, as Sparklyr dataframe\n";$scope.script.data+=outputDataset0Computable.variableName+" <- "+inputDataset0Computable.variableName+" # For this sample code, simply copy input to output\n"}else if(recipeIOData.outputDatasets.length>0){$scope.script.data+="# Compute recipe outputs\n";$scope.script.data+="# TODO: Write here your actual code that computes the outputs as Sparklyr dataframes\n";recipeIOData.outputItems.forEach(function(item){var computable=$scope.computablesMap[item.ref];if(computable.type=="DATASET"){$scope.script.data+=computable.variableName+" <- replace_me # Compute a data frame for the output to write into "+item.ref+"\n"}})}$scope.script.data+="\n";var outputDatasets=RecipesUtils.getOutputsForRole($scope.recipe,"main");if(recipeIOData.outputItems.length>0){$scope.script.data+="# Recipe outputs\n"}recipeIOData.outputItems.forEach(function(item){var computable=$scope.computablesMap[item.ref];if(computable.type=="DATASET"){$scope.script.data+="spark_write_dku_dataset("+computable.variableName+',"'+item.ref+'")\n'}if(computable.type=="MANAGED_FOLDER"){$scope.script.data+=computable.variableName+' <- dkuManagedFolderPath("'+item.ref+'")\n'}})}$scope.script.data+="\n"+previousCode};$scope.selectRecipeMode=function(){var items=[{mode:"SPARKR",title:"SparkR",desc:"Use SparkR (native Spark) API"},{mode:"SPARKLYR",title:"Sparklyr",desc:"Use Sparklyr (dplyr) API"}];Dialogs.select($scope,"API","Select the API to use",items,items[$scope.recipe.params.recipeMode==="SPARKLYR"?1:0]).then(function(item){$scope.recipe.params.recipeMode=item.mode})};$scope.$watch("recipe.params.recipeMode",function(mode,previous){Logger.info("Transform: from "+previous+" to "+mode);if(previous!=null&&mode!=null&&previous!=mode){$scope.autofillCode(mode,true);$timeout($scope.cm.setValue.bind($scope.cm,$scope.script.data),0)}});$scope.validateRecipe=function(){return CodeBasedValidationUtils.getGenericCheckPromise($scope).then(function(valResult){$scope.valCtx.validationResult=valResult;CodeBasedEditorUtils.updateLinter(valResult,$scope.linterFunction);return valResult})}});app.controller("SparkSQLQueryRecipeController",function($rootScope,$scope,DataikuAPI,RecipeRunJobService,RecipesUtils,$q,WT1,$stateParams,$timeout,CodeBasedEditorUtils,CodeBasedValidationUtils,ComputableSchemaRecipeSave,Fn,CodeMirrorSettingService,SQLRecipeHelperService){$scope.enableAutoFixup();$scope.noPrefixForeign=true;$scope.identifierQuote="`";if($scope.script.data==null)$scope.script.data="";$scope.editorOptions=CodeBasedEditorUtils.editorOptions("text/x-sql2",$scope);$scope.editorOptions.extraKeys[CodeMirrorSettingService.getShortcuts()["AUTOCOMPLETE_SHORTCUT"]]=function(cm){return $scope.autocompleteSQL(cm,"spark_sql_query-recipe")};CodeBasedEditorUtils.registerBroadcastSelectionHandler($scope.editorOptions);CodeBasedEditorUtils.setRecipeScript($scope.script);$scope.anyPipelineTypeEnabled=function(){return $rootScope.projectSummary.sparkPipelinesEnabled};$scope.autocompleteSQL=function(cm,type){if(!$scope.tables){$scope.tables=[].concat($scope.recipe.inputs.main.items,$scope.recipe.outputs.main.items).map(function(t){return{table:t.ref}});$scope.fields=[].concat.apply([],$scope.tables.map(function(f){return $scope.computablesMap[f.table].dataset.schema.columns.map(function(c){return{table:f.table,name:c.name}})}));$scope.fields=$scope.fields.filter(function(f){return!(f.name in this)&&(this[f.name]=true)},{})}CodeMirror.showHint(cm,function(editor){return CodeMirror.sqlNotebookHint(editor,type+"-notebook",$scope.tables.map(Fn.prop("table")),$scope.fields)},{completeSingle:false})};$scope.sqlFormat=SQLRecipeHelperService.sqlFormat.bind(this,$scope);$scope.hooks.insertVariable=function(variableName,type){$timeout(function(){$scope.cm.replaceSelection("${"+variableName+"}","end")});$scope.cm.focus()};$scope.autofillCode=function(){};$scope.validateRecipe=function(){return CodeBasedValidationUtils.getGenericCheckPromise($scope).then(function(valResult){$scope.valCtx.validationResult=valResult;CodeBasedEditorUtils.updateLinter(valResult,$scope.linterFunction);$scope.recipeWT1Event("sparksql-query-validate",{ok:!valResult.topLevelMessages.error});return ComputableSchemaRecipeSave.handleSchemaUpdateWithPrecomputed($scope,valResult.schemaResult).then(function(changeResult){if(changeResult.changed){return $scope.validateRecipe()}else{return valResult}})})};$scope.hooks.preRunValidate=$scope.validateRecipe});app.controller("SparkScalaRecipeController",function($rootScope,$scope,DataikuAPI,$q,TopNav,$state,$stateParams,RecipesUtils,RecipeRunJobService,CreateModalFromTemplate,Logger,Dialogs,WT1,$timeout,CodeBasedEditorUtils,CodeBasedValidationUtils,CodeBasedToPluginConverter){$scope.enableAutoFixup();$scope.identifierQuote='"';$scope.editorOptions=CodeBasedEditorUtils.editorOptions("text/x-scala",$scope,true);$scope.hooks.insertVariable=function(variableName,type){$timeout(function(){var dic=type=="FLOW"?"dkuContext.flowVariables":"dkuContext.customVariables";$scope.cm.replaceSelection(dic+'("'+variableName+'")',"end")});$scope.cm.focus()};$scope.anyPipelineTypeEnabled=function(){return $rootScope.projectSummary.sparkPipelinesEnabled};$scope.hooks.transformToDevPlugin=function(){CodeBasedToPluginConverter.transformToDevPlugin($scope,DataikuAPI.flow.recipes.scala.convertToCustom,"spark_scala")};$rootScope.$broadcast("transformToDevPlugin",$scope.hooks.transformToDevPlugin);function getComputablesOfType(list,type){return list.map(function(_){return{ref:_.ref,computable:$scope.computablesMap[_.ref]}}).filter(function(_){return _.computable.type===type})}$scope.autofillCode=function(functionMode){var suffix=$scope.script.data;if(functionMode){$scope.script.data="// The code below is the body of a function with signature:\n";$scope.script.data+="// def transform(inputDatasets: Map[String, DataFrame],\n";$scope.script.data+="//   sparkContext: SparkContext, sqlContext: SQLContext, dkuContext: DataikuSparkContext\n";$scope.script.data+="// ): Map[String, DataFrame]\n\n";$scope.script.data+="import org.apache.spark.sql.functions._\n\n";suffix="\n\n/** Previous code */\n"+suffix.replace(/^/gm,"// ")}else{$scope.script.data="import com.dataiku.dss.spark._\n";$scope.script.data+="import org.apache.spark.SparkContext\n";$scope.script.data+="import org.apache.spark.sql.SQLContext\n";$scope.script.data+="import org.apache.spark.sql.SparkSession\n";$scope.script.data+="import org.apache.spark.sql.functions._\n\n";$scope.script.data+="val sparkConf    = DataikuSparkContext.buildSparkConf()\n";const sparkVersion=$scope.appConfig.sparkVersion||"1.X";if(sparkVersion.substring(0,1)=="1"){$scope.script.data+="val sparkContext = new SparkContext(sparkConf)\n"}else{$scope.script.data+="val sparkContext = SparkContext.getOrCreate(sparkConf)\n"}$scope.script.data+="val spark        = SparkSession.builder().config(sparkConf).getOrCreate()\n";$scope.script.data+="val sqlContext   = spark.sqlContext\n";$scope.script.data+="val dkuContext   = DataikuSparkContext.getContext(sparkContext)\n\n";suffix=""}var inputDatasets=RecipesUtils.getInputsForRole($scope.recipe,"main");if(inputDatasets.length>0){$scope.script.data+="// Recipe inputs\n"}getComputablesOfType(inputDatasets,"MANAGED_FOLDER").forEach(function(_){$scope.script.data+="val "+_.computable.variableName+' = dkuContext.getManagedFolderRoot("'+_.computable.box.id+(_.computable.box.projectKey===$scope.recipe.projectKey?"":'", "'+_.computable.box.projectKey)+'")\n'});getComputablesOfType(inputDatasets,"DATASET").forEach(function(_){$scope.script.data+="val "+_.computable.variableName+" = "+(functionMode?"inputDatasets(":"dkuContext.getDataFrame(sqlContext, ")+'"'+_.ref+'")\n'});$scope.script.data+="\n";var outputDatasets=RecipesUtils.getOutputsForRole($scope.recipe,"main");$scope.script.data+="// TODO: Write here your actual code that computes the outputs\n";getComputablesOfType(outputDatasets,"DATASET").forEach(function(_){$scope.script.data+="val "+_.computable.variableName+" = replace_me_by_your_code\n"});$scope.script.data+="\n";if(outputDatasets.length>0){$scope.script.data+="// Recipe outputs\n"}getComputablesOfType(outputDatasets,"MANAGED_FOLDER").forEach(function(_){$scope.script.data+="val "+_.computable.variableName+' = dkuContext.getManagedFolderRoot("'+_.computable.box.id+(_.computable.box.projectKey===$scope.recipe.projectKey?"":'", "'+_.computable.box.projectKey)+'")\n'});if(functionMode){$scope.script.data+="// The returned Map must contain (dataset name -> dataframe) pairs\n";$scope.script.data+="Map("+getComputablesOfType(outputDatasets,"DATASET").map(function(_){return'"'+_.ref+'" -> '+_.computable.variableName}).join(",\n    ")+")\n"}else{getComputablesOfType(outputDatasets,"DATASET").forEach(function(_){$scope.script.data+='dkuContext.save("'+_.ref+'", '+_.computable.variableName+");\n"})}$scope.script.data+=suffix};$scope.selectCodeMode=function(){var items=[{mode:"FREE_FORM",title:"Free-Form",desc:"The code is a script. "+"It must instantiate its Spark context and SQL context, load its input datasets and save its output datasets."},{mode:"FUNCTION",title:"Function",desc:"The code is the body of a function. "+"It recieves pre-instantiated Spark context, SQL context, and input datasets and must return its output datasets. "+"This mode is compatible with Spark pipelines."}];Dialogs.select($scope,"Code mode","Select the mode for the code:",items,items[$scope.recipe.params.codeMode==="FUNCTION"?1:0]).then(function(item){$scope.recipe.params.codeMode=item.mode})};var transformCode=true;$scope.$watch("recipe.params.codeMode",function(mode,previous){Logger.info("Transform: from "+previous+" to "+mode);if(transformCode&&mode==="FUNCTION"&&previous==="FREE_FORM"){transformCode=false;$scope.autofillCode(true);$timeout($scope.cm.setValue.bind($scope.cm,$scope.script.data),0)}});$scope.validateRecipe=function(){return CodeBasedValidationUtils.getGenericCheckPromise($scope).then(function(valResult){$scope.valCtx.validationResult=valResult;CodeBasedEditorUtils.updateLinter(valResult,$scope.linterFunction);$scope.recipeWT1Event("spark-scala-validate",{ok:!valResult.topLevelMessages.error,firstError:valResult.topLevelMessages.messages.length?valResult.topLevelMessages.messages[0].message:null});return valResult})};$scope.hooks.preRunValidate=$scope.validateRecipe});app.controller("StreamingSparkScalaRecipeController",function($scope,$controller,DataikuAPI,$q,TopNav,$state,$stateParams,RecipesUtils,RecipeRunJobService,CreateModalFromTemplate,Logger,Dialogs,WT1,$timeout,CodeBasedEditorUtils,CodeBasedValidationUtils,CodeBasedToPluginConverter){$scope.enableAutoFixup();$controller("_ContinuousRecipeInitStartedJobBehavior",{$scope:$scope});$scope.identifierQuote='"';$scope.editorOptions=CodeBasedEditorUtils.editorOptions("text/x-scala",$scope,true);$scope.hooks.insertVariable=function(variableName,type){$timeout(function(){var dic=type=="FLOW"?"dkuContext.flowVariables":"dkuContext.customVariables";$scope.cm.replaceSelection(dic+'("'+variableName+'")',"end")});$scope.cm.focus()};$scope.transformToDevPlugin=function(){CodeBasedToPluginConverter.transformToDevPlugin($scope,DataikuAPI.flow.recipes.scala.convertToCustom,"spark_scala")};function getComputablesOfType(list,type){return list.map(function(_){return{ref:_.ref,computable:$scope.computablesMap[_.ref]}}).filter(function(_){return _.computable.type===type})}$scope.autofillCode=function(functionMode){var suffix=$scope.script.data;if(functionMode){$scope.script.data="// The code below is the body of a function with signature:\n";$scope.script.data+="// def transform(inputDatasets: Map[String, DataFrame],\n";$scope.script.data+="//   sparkContext: SparkContext, sqlContext: SQLContext, dkuContext: DataikuSparkContext\n";$scope.script.data+="// ): Map[String, DataFrame]\n\n";$scope.script.data+="import org.apache.spark.sql.functions._\n\n";suffix="\n\n/** Previous code */\n"+suffix.replace(/^/gm,"// ")}else{$scope.script.data="import com.dataiku.dss.spark._\n";$scope.script.data+="import org.apache.spark.SparkContext\n";$scope.script.data+="import org.apache.spark.sql.SQLContext\n";$scope.script.data+="import org.apache.spark.sql.SparkSession\n";$scope.script.data+="import org.apache.spark.sql.functions._\n\n";$scope.script.data+="val sparkConf    = DataikuSparkContext.buildSparkConf()\n";$scope.script.data+="val sparkContext = new SparkContext(sparkConf)\n";$scope.script.data+="val spark        = SparkSession.builder().config(sparkConf).getOrCreate()\n";$scope.script.data+="val sqlContext   = spark.sqlContext\n";$scope.script.data+="val dkuContext   = DataikuSparkContext.getContext(sparkContext)\n\n";suffix=""}var inputDatasets=RecipesUtils.getInputsForRole($scope.recipe,"main");if(inputDatasets.length>0){$scope.script.data+="// Recipe inputs\n"}getComputablesOfType(inputDatasets,"MANAGED_FOLDER").forEach(function(_){$scope.script.data+="val "+_.computable.variableName+' = dkuContext.getManagedFolderRoot("'+_.computable.box.id+(_.computable.box.projectKey===$scope.recipe.projectKey?"":'", "'+_.computable.box.projectKey)+'")\n'});getComputablesOfType(inputDatasets,"DATASET").forEach(function(_){$scope.script.data+="val "+_.computable.variableName+" = "+(functionMode?"inputDatasets(":"dkuContext.getDataFrame(sqlContext, ")+'"'+_.ref+'")\n'});getComputablesOfType(inputDatasets,"STREAMING_ENDPOINT").forEach(function(_){$scope.script.data+="val "+_.computable.variableName+" = "+(functionMode?"inputStreamingEndpoints(":"dkuContext.getStream(")+'"'+_.ref+'")\n'});$scope.script.data+="\n";var outputDatasets=RecipesUtils.getOutputsForRole($scope.recipe,"main");let dataframeToOutput="someStreamingDataframe";let hasDatasetInput=false;if(inputDatasets.length==1&&outputDatasets.length==1){if(getComputablesOfType(inputDatasets,"DATASET").length==1){$scope.script.data+="// Replace by your code\n";const inputDataset0=getComputablesOfType(inputDatasets,"DATASET")[0];$scope.script.data+="val df = "+inputDataset0.computable.variableName+"\n";$scope.script.data+="\n";dataframeToOutput="df";hasDatasetInput=true}else if(getComputablesOfType(inputDatasets,"STREAMING_ENDPOINT").length==1){$scope.script.data+="// Add your code\n\n";dataframeToOutput=getComputablesOfType(inputDatasets,"STREAMING_ENDPOINT")[0].computable.variableName}}if(outputDatasets.length>0){$scope.script.data+="// Recipe outputs\n"}getComputablesOfType(outputDatasets,"MANAGED_FOLDER").forEach(function(_){$scope.script.data+="val "+_.computable.variableName+' = dkuContext.getManagedFolderRoot("'+_.computable.box.id+(_.computable.box.projectKey===$scope.recipe.projectKey?"":'", "'+_.computable.box.projectKey)+'")\n'});if(functionMode){$scope.script.data+="// The returned Map must contain (dataset or streaming endpoint name -> dataframe) pairs\n";$scope.script.data+="Map("+getComputablesOfType(outputDatasets,"DATASET").concat(getComputablesOfType(outputDatasets,"STREAMING_ENDPOINT")).map(function(_){return'"'+_.ref+'" -> '+dataframeToOutput}).join(",\n    ")+")\n"}else{if(getComputablesOfType(inputDatasets,"DATASET").length>0&&getComputablesOfType(outputDatasets,"STREAMING_ENDPOINT").length>0){$scope.script.data+="// Write your code here to run the recipe"}else{getComputablesOfType(outputDatasets,"STREAMING_ENDPOINT").forEach(function(_){$scope.script.data+="val "+_.computable.variableName+' = dkuContext.saveStreamingQueryToStreamingEndpoint("'+_.computable.streamingEndpoint.id+'", '+dataframeToOutput+")\n"+_.computable.variableName+".awaitTermination"})}getComputablesOfType(outputDatasets,"DATASET").forEach(function(_){if(hasDatasetInput){$scope.script.data+="val "+_.computable.variableName+' = dkuContext.save("'+_.ref+'", '+dataframeToOutput+")\n"}else{$scope.script.data+="val "+_.computable.variableName+' = dkuContext.saveStreamingQueryToDataset("'+_.ref+'", '+dataframeToOutput+")\n"+_.computable.variableName+".awaitTermination"}})}$scope.script.data+=suffix};$scope.selectCodeMode=function(){var items=[{mode:"FREE_FORM",title:"Free-Form",desc:"The code is a script. "+"It must instantiate its Spark context and SQL context, load its input datasets and save its output datasets."},{mode:"FUNCTION",title:"Function",desc:"The code is the body of a function. "+"It recieves pre-instantiated Spark context, SQL context, and input datasets and must return its output datasets. "+"This mode is compatible with Spark pipelines."}];Dialogs.select($scope,"Code mode","Select the mode for the code:",items,items[$scope.recipe.params.codeMode==="FUNCTION"?1:0]).then(function(item){$scope.recipe.params.codeMode=item.mode})};var transformCode=true;$scope.$watch("recipe.params.codeMode",function(mode,previous){Logger.info("Transform: from "+previous+" to "+mode);if(transformCode&&mode==="FUNCTION"&&previous==="FREE_FORM"){transformCode=false;$scope.autofillCode(true);$timeout($scope.cm.setValue.bind($scope.cm,$scope.script.data),0)}});$scope.validateRecipe=function(){return CodeBasedValidationUtils.getGenericCheckPromise($scope).then(function(valResult){$scope.valCtx.validationResult=valResult;CodeBasedEditorUtils.updateLinter(valResult,$scope.linterFunction);$scope.recipeWT1Event("spark-scala-validate",{ok:!valResult.topLevelMessages.error,firstError:valResult.topLevelMessages.messages.length?valResult.topLevelMessages.messages[0].message:null});return valResult})};$scope.hooks.preRunValidate=$scope.validateRecipe})})();(function(){"use strict";var app=angular.module("dataiku.recipes");app.controller("HiveRecipeController",function($scope,DataikuAPI,ActivityIndicator,$q,WT1,$stateParams,RecipeRunJobService,RecipesUtils,Fn,DKUtils,CreateModalFromTemplate,Dialogs,$state,$timeout,CodeBasedEditorUtils,CodeBasedValidationUtils,ComputableSchemaRecipeSave,CodeMirrorSettingService){$scope.identifierQuote="`";$scope.editorOptions=CodeBasedEditorUtils.editorOptions("text/x-hivesql",$scope,true);$scope.editorOptions.extraKeys[CodeMirrorSettingService.getShortcuts()["AUTOCOMPLETE_SHORTCUT"]]=function(cm){$scope.recipeWT1Event("hive-script-autocomplete");CodeMirror.showHint(cm,function(cm){var relevantDatasetRefs=RecipesUtils.getFlatIOList($scope.recipe).map(Fn.prop("ref"));var fieldsToAutocomplete=CodeMirror.sqlFieldsAutocomplete(cm,relevantDatasetRefs.map(function(v){return{table:v}}));var sqlFields=[];if(fieldsToAutocomplete&&fieldsToAutocomplete.length){for(var i in relevantDatasetRefs){var tableName=relevantDatasetRefs[i];var columns=$scope.computablesMap[tableName].dataset.schema.columns;for(var j in columns){sqlFields.push({name:columns[j].name,table:tableName})}}}CodeMirror.showHint(cm,function(cm){return CodeMirror.sqlNotebookHint(cm,"hive-recipe",relevantDatasetRefs,sqlFields)},{completeSingle:false})})};$scope.hooks.insertVariable=function(variableName,type){$timeout(function(){$scope.cm.replaceSelection(" ${"+variableName+"} ","end")});$scope.cm.focus()};$scope.enableAutoFixup();$scope.validateRecipe=function(){var preValidate=(new Date).getTime();return CodeBasedValidationUtils.getGenericCheckPromise($scope).then(function(valResult){$scope.valCtx.validationResult=valResult;CodeBasedEditorUtils.updateLinter(valResult,$scope.linterFunction);$scope.recipeWT1Event("hive-validate",{ok:!valResult.topLevelMessages.error,time:(new Date).getTime()-preValidate,schemaChange:valResult.schemaResult?valResult.schemaResult.totalIncompatibilities>0:false,firstError:valResult.topLevelMessages.messages.length?valResult.topLevelMessages.messages[0].message:null});return ComputableSchemaRecipeSave.handleSchemaUpdateWithPrecomputed($scope,valResult.schemaResult).then(function(changeResult){if(changeResult.changed){return $scope.validateRecipe()}else{return valResult}})})};$scope.hooks.preRunValidate=$scope.validateRecipe;$scope.synchronizeInput=function(datasetLoc){const datasets=[datasetLoc];DataikuAPI.datasets.synchronizeHiveMetastore(datasets).success(function(){$scope.validateRecipe()}).error(setErrorInScope.bind($scope))};$scope.autofillCode=function(){};$scope.doConversionToImpala=function(type,label){Dialogs.confirm($scope,"Convert to Impala recipe","Are you sure you want to convert "+"this to an Impala recipe? This operation is irreversible.").then(function(){$scope.recipe.type="impala";$scope.saveRecipe().then(function(){$state.go("projects.project.recipes.recipe",{projectKey:$stateParams.projectKey,recipeName:$scope.recipe.name});DKUtils.reloadState()})})};$scope.convertToImpala=function(){DataikuAPI.flow.recipes.hive.checkImpalaConvertibility($stateParams.projectKey,$scope.hooks.getRecipeSerialized(),$scope.script.data,RecipeRunJobService.getTargetPartition($scope,$stateParams)).success(function(data){var newScope=$scope.$new();newScope.executionPlan=data.executionPlan;newScope.query=data.sql;newScope.runsOnImpala=true;newScope.validatesOnImpala=data.runsOnImpala;newScope.impalaImpossibilityReason=data.impalaImpossibilityReason;newScope.convert=$scope.doConversionToImpala;newScope.uiState={currentTab:"query"};CreateModalFromTemplate("/templates/recipes/fragments/sql-modal.html",newScope,null,function(newScope){newScope.engine="IMPALA";newScope.isAlreadyRecipe=false})}).error(setErrorInScope.bind($scope))}});app.controller("ImpalaRecipeController",function($scope,DataikuAPI,ActivityIndicator,$q,WT1,$stateParams,RecipeRunJobService,RecipesUtils,Fn,CreateModalFromTemplate,$state,Dialogs,MonoFuture,CodeBasedEditorUtils,CodeBasedValidationUtils,ComputableSchemaRecipeSave,SQLRecipeHelperService,$timeout,CodeMirrorSettingService){$scope.enableAutoFixup();$scope.identifierQuote="`";$scope.editorOptions=CodeBasedEditorUtils.editorOptions("text/x-hivesql",$scope,true);$scope.editorOptions.extraKeys[CodeMirrorSettingService.getShortcuts()["AUTOCOMPLETE_SHORTCUT"]]=function(cm){$scope.recipeWT1Event("impala-script-autocomplete");SQLRecipeHelperService.handleAutocompleteRequest($scope,cm,"impala-recipe")};$scope.hooks.insertVariable=function(variableName,type){$timeout(function(){$scope.cm.replaceSelection(" ${"+variableName+"} ","end")});$scope.cm.focus()};$scope.autofillCode=function(){};$scope.validateRecipe=function(){return CodeBasedValidationUtils.getGenericCheckPromise($scope).then(function(valResult){$scope.valCtx.validationResult=valResult;CodeBasedEditorUtils.updateLinter(valResult,$scope.linterFunction);$scope.recipeWT1Event("impala-validate",{ok:!valResult.topLevelMessages.error,firstError:valResult.topLevelMessages.messages.length?valResult.topLevelMessages.messages[0].message:null});return ComputableSchemaRecipeSave.handleSchemaUpdateWithPrecomputed($scope,valResult.schemaResult).then(function(changeResult){if(changeResult.changed){return $scope.validateRecipe()}else{return valResult}})})};$scope.hooks.preRunValidate=$scope.validateRecipe;$scope.showExecutionPlan=function(){$scope.hooks.resetScope();MonoFuture($scope).wrap(DataikuAPI.flow.recipes.impala.getExecutionPlan)($stateParams.projectKey,$scope.hooks.getRecipeSerialized(),$scope.script.data,RecipeRunJobService.getTargetPartition($scope)).success(function(data){$scope.future=null;$scope.valCtx.validationResult=data.result.validationResult;if(!data.result.validationResult.topLevelMessages.error){CreateModalFromTemplate("/templates/recipes/fragments/sql-modal.html",$scope,null,function(newScope){newScope.executionPlan=data.result.executionPlan;newScope.query=data.result.executionPlan.query;newScope.uiState={currentTab:"plan"};newScope.engine="IMPALA";newScope.isAlreadyRecipe=true})}}).update(function(data){$scope.future=data}).error(function(data){$scope.future=null;if(data.aborted){$scope.valCtx={validationResult:{topLevelMessages:{messages:[{severity:"error",line:-1,message:"Query aborted"}]}}}}else{$scope.valCtx={validationResult:{topLevelMessages:{messages:[{severity:"error",line:-1,message:"Query failed unexpectedly"}]}}}}})};$scope.run=function(){$scope.hooks.resetScope();MonoFuture($scope).wrap(DataikuAPI.flow.recipes.impala.run)($stateParams.projectKey,$scope.hooks.getRecipeSerialized(),$scope.script.data,RecipeRunJobService.getTargetPartition($scope)).success(function(data){$scope.future=null;$scope.valCtx.validationResult=data.result;$scope.recipeWT1Event("impala-query-run",{ok:!data.result.topLevelMessages.error,runOK:data.result.runResult&&data.result.runResult.success,runRows:data.result.runResult?data.result.runResult.totalRows:-1});if(data.result&&data.result.runResult&&data.result.runResult.success&&data.result.runResult.rows){CreateModalFromTemplate("/templates/recipes/sql/rows-preview-modal.html",$scope)}}).update(function(data){$scope.future=data}).error(function(data){$scope.future=null;if(data.aborted){$scope.valCtx={validationResult:{genericCheckResult:{errors:[{severity:"error",line:-1,message:"Query aborted"}]}}}}else{$scope.valCtx={validationResult:{genericCheckResult:{errors:[{severity:"error",line:-1,message:"Query failed unexpectedly"}]}}}}})};$scope.$watch("[ recipe.inputs, recipe.outputs]",function(nv,ov){DataikuAPI.flow.recipes.impala.checkFullSqlAvailability($stateParams.projectKey,$scope.hooks.getRecipeSerialized()).success(function(data){$scope.fullSqlAvailability=data}).error(setErrorInScope.bind($scope))},true);$scope.visitUnsynchonizedDataset=function(){var name=$scope.valCtx.validationResult.runResult.datasetInNeedOfSynchronization;if(name!=null){$state.go("projects.project.datasets.dataset.settings",{projectKey:$stateParams.projectKey,datasetName:name})}};$scope.resynchronizeMetastore=function(){var name=$scope.valCtx.validationResult.runResult.datasetInNeedOfSynchronization;if(name!=null){Dialogs.confirmPositive($scope,"Hive metastore resynchronization","Are you sure you want to resynchronize "+name+" to the Hive metastore?").then(function(){ActivityIndicator.waiting("Synchronizing Hive metastore...");const datasets=[{type:"DATASET",projectKey:$stateParams.projectKey,id:name}];DataikuAPI.datasets.synchronizeHiveMetastore(datasets).success(function(data,status,headers){$scope.valCtx.validationResult=null;ActivityIndicator.success("Hive metastore successfully synchronized")}).error(function(data,status,headers){ActivityIndicator.hide();setErrorInScope.call($scope,data,status,headers)})})}}});app.controller("PigRecipeController",function($scope,DataikuAPI,ActivityIndicator,$q,WT1,TopNav,$stateParams,RecipesUtils,Fn,RecipeRunJobService,$timeout,CodeBasedEditorUtils,CodeBasedValidationUtils,ComputableSchemaRecipeSave,CodeMirrorSettingService){$scope.enableAutoFixup();$scope.identifierQuote="";$scope.editorOptions=CodeBasedEditorUtils.editorOptions("text/x-dkupig",$scope,true);$scope.editorOptions.extraKeys[CodeMirrorSettingService.getShortcuts()["AUTOCOMPLETE_SHORTCUT"]]=function(cm){$scope.recipeWT1Event("pig-autocomplete");CodeMirror.showHint(cm,function(editor){var inputs=RecipesUtils.getFlatInputsList($scope.recipe).map(Fn.prop("ref"));var outputs=RecipesUtils.getFlatOutputsList($scope.recipe).map(Fn.prop("ref"));var relations=$scope.valCtx.validationResult;if(relations){relations=relations.relationSchemas}return CodeMirror.pigHintWithContext(editor,{inputs:inputs,outputs:outputs,relations:relations})},{completeSingle:false})};$scope.hooks.insertVariable=function(variableName,type){$timeout(function(){$scope.cm.replaceSelection(" ${"+variableName+"} ","end")});$scope.cm.focus()};$scope.validateRecipe=function(){if($scope.valCtx.validationResult&&$scope.valCtx.validationResult.relationSchemas){populateOpenList("",$scope.valCtx.validationResult.relationSchemas)}return CodeBasedValidationUtils.getGenericCheckPromise($scope).then(function(valResult){$scope.valCtx.validationResult=valResult;CodeBasedEditorUtils.updateLinter(valResult,$scope.linterFunction);if(valResult.relationSchemas){restoreOpenState("",$scope.valCtx.validationResult.relationSchemas)}$scope.recipeWT1Event("pig-query-validate",{ok:!valResult.topLevelMessages.error});return ComputableSchemaRecipeSave.handleSchemaUpdateWithPrecomputed($scope,valResult.schemaResult).then(function(changeResult){if(changeResult.changed){return $scope.validateRecipe()}else{return valResult}})})};$scope.hooks.preRunValidate=$scope.validateRecipe;$scope.widgets=[];var openList=[];var openListSeparator="!#|~";function populateOpenList(path,oldResponse){if(oldResponse){for(var k in oldResponse){var field=oldResponse[k];var npath=path+openListSeparator+field.name;if(field.fields){populateOpenList(npath,field.fields)}if(field.show){openList.push(npath)}else{var idx=openList.indexOf(npath);if(idx!=-1){openList.splice(idx,1)}}}}openList.filter(function(elm,idx){return openList.indexOf(elm)==idx})}function restoreOpenState(path,newResponse){if(newResponse){for(var k in newResponse){var field=newResponse[k];if(field.name){var npath=path+openListSeparator+field.name;if(openList.indexOf(npath)!=-1){field.show=true;restoreOpenState(npath,field.fields)}}}}}$scope.autofillCode=function(){$scope.script.data="";var inputDatasets=RecipesUtils.getInputsForRole($scope.recipe,"main");if(inputDatasets.length>0){$scope.script.data+="-- Read input datasets\n";for(let i=0;i<inputDatasets.length;i++){let dataset=inputDatasets[i].ref;$scope.script.data+="relation_"+cleanupVariable(dataset)+" = DKULOAD '"+dataset+"';\n"}}$scope.script.data+="\n";$scope.script.data+="-- Applicative code\n\n";var outputDatasets=RecipesUtils.getOutputsForRole($scope.recipe,"main");if(outputDatasets.length>0){$scope.script.data+="-- Store output datasets\n";for(let i=0;i<outputDatasets.length;i++){let dataset=outputDatasets[i].ref;$scope.script.data+="DKUSTORE relation_"+cleanupVariable(dataset)+" INTO '"+dataset+"';\n"}}}})})();(function(){"use strict";const app=angular.module("dataiku.recipes");app.factory("SQLRecipeHelperService",function(RecipesUtils,Fn,DKUSQLFormatter){var svc={buildSQLDatasetsList:function($scope){var sqlDatasets=[];if($scope.computablesMap==null){return sqlDatasets}var found=null;if($scope.recipe.inputs&&$scope.recipe.inputs["main"]&&$scope.recipe.inputs["main"].items){$scope.recipe.inputs["main"].items.forEach(function(input){if(input.ref==$scope.recipe.params.mainConnectionDataset){found=input}if($scope.computablesMap[input.ref].dataset!=null){sqlDatasets.push(input)}})}if($scope.recipe.outputs&&$scope.recipe.outputs["main"]&&$scope.recipe.outputs["main"].items){$scope.recipe.outputs["main"].items.forEach(function(output){if(output.ref==$scope.recipe.params.mainConnectionDataset){found=output}if($scope.computablesMap[output.ref].dataset!=null){sqlDatasets.push(output)}})}if(found==null){delete $scope.recipe.params.mainConnectionDataset}return sqlDatasets},maintainSQLDatasetList:function($scope){$scope.sqlDatasets=[];var onRecipeIoOrComputableChange=function(){$scope.sqlDatasets=svc.buildSQLDatasetsList($scope)};$scope.$on("computablesMapChanged",onRecipeIoOrComputableChange);$scope.$watch("[recipe.inputs, recipe.outputs]",onRecipeIoOrComputableChange,true)},handleAutocompleteRequest:function($scope,cm,type){CodeMirror.showHint(cm,function(cm){var relevantDatasetRefs=RecipesUtils.getFlatIOList($scope.recipe).map(Fn.prop("ref"));var fieldsToAutocomplete=CodeMirror.sqlFieldsAutocomplete(cm,relevantDatasetRefs.map(function(v){return{table:v}}));var sqlFields=[];if(fieldsToAutocomplete&&fieldsToAutocomplete.length){for(var i in relevantDatasetRefs){var tableName=relevantDatasetRefs[i];var columns=$scope.computablesMap[tableName].dataset.schema.columns;for(var j in columns){sqlFields.push({name:columns[j].name,table:tableName})}}}CodeMirror.showHint(cm,function(cm){return CodeMirror.sqlNotebookHint(cm,type,relevantDatasetRefs,sqlFields)},{completeSingle:false})})},sqlFormat:function($scope){var codeMirrors=$(".editor .CodeMirror");var cm=codeMirrors[0].CodeMirror;cm.setValue(DKUSQLFormatter.format(cm.getValue(),cm.getOption("indentUnit")))}};return svc});app.controller("_SQLRecipeController",function($scope,DataikuAPI,$stateParams,RecipeRunJobService,$rootScope,MonoFuture,AISqlGenerationService,RatingFeedbackParams,WT1,ClipboardUtils){$scope.recipeLocalState={};$scope.aiQuery={};$scope.isAiGenerationFutureRunning=false;let requestId=null;let dialect=null;$scope.aiGenerationFuture=MonoFuture($scope);$scope.ratingFeedbackParams=RatingFeedbackParams;$scope.generate=function(){WT1.tryEvent("ai-sql-generation",()=>{const recipeSerialized=$scope.hooks.getRecipeSerialized();const firstInputNameFromRecipe=recipeSerialized.inputs.main.items[0].ref;dialect=$scope.computablesMap[firstInputNameFromRecipe].datasetType;return{...AISqlGenerationService.buildWT1SqlGenerationParams($scope.wt1RecipeType,recipeSerialized.inputs.main.items.length,dialect),aiServer:$rootScope.appConfig.isUsingLocalAIAssistant?"webapp":"default"}});$scope.ratingFeedbackParams.showRatingFeedback=false;$scope.ratingFeedbackParams.requestIdForFeedback=null;$scope.ratingFeedbackParams.featureRated=null;$scope.aiQuery={};$scope.isAiGenerationFutureRunning=true;$scope.aiGenerationFuture.wrap(DataikuAPI.flow.recipes.sql.startSQLQueryGeneration)($stateParams.projectKey,$scope.recipeLocalState.generationQuery,$scope.hooks.getRecipeSerialized(),RecipeRunJobService.getTargetPartition($scope)).success(function(data){$scope.aiQuery=AISqlGenerationService.processSQLGenerationResponse(data.result.queryName,data.result.sqlQuery,data.result.reasoning,data.result.messages);$scope.installingFuture=null;requestId=data.result.requestId;if(!$rootScope.appConfig.isUsingLocalAIAssistant){$scope.ratingFeedbackParams.showRatingFeedback=true;$scope.ratingFeedbackParams.requestIdForFeedback=requestId;$scope.ratingFeedbackParams.featureRated="text2sql"}WT1.tryEvent("ai-sql-generation-response",()=>{return{...AISqlGenerationService.buildWT1SqlGenerationResponseParams($scope.wt1RecipeType,dialect,requestId,$scope.aiQuery.warnings,$scope.aiQuery.errors),aiServer:$rootScope.appConfig.isUsingLocalAIAssistant?"webapp":"default"}})}).error(function(data,status,headers){setErrorInScope.bind($scope)(data,status,headers);WT1.tryEvent("ai-sql-generation-error",()=>{return{...AISqlGenerationService.buildWT1SqlErrorResponseParams($scope.wt1RecipeType,dialect),aiServer:$rootScope.appConfig.isUsingLocalAIAssistant?"webapp":"default"}})}).finally(function(){$scope.isAiGenerationFutureRunning=false})};$scope.abortAiGeneration=function(){$scope.aiGenerationFuture.abort();$scope.isAiGenerationFutureRunning=false};$scope.insertAiQuery=function(){const toInsert=AISqlGenerationService.getAIQueryToInsert($scope.aiQuery);$scope.script.data=!$scope.script.data.trim()?toInsert:$scope.script.data+"\n\n"+toInsert;WT1.tryEvent("ai-sql-insert-query",()=>{return{...AISqlGenerationService.buildWT1SqlInsertQueryParams($scope.wt1RecipeType,dialect,requestId),aiServer:$rootScope.appConfig.isUsingLocalAIAssistant?"webapp":"default"}})};$scope.disableGenerateButton=()=>AISqlGenerationService.isGenerateButtonDisabled($rootScope.topNav.isProjectAnalystRW,$scope.recipeLocalState.generationQuery);$scope.disableGenerateButtonMessage=()=>AISqlGenerationService.getGenerateButtonDisabledMessage($rootScope.topNav.isProjectAnalystRW);$scope.copyAiQueryToClipboard=()=>ClipboardUtils.copyToClipboard($scope.aiQuery.query,"SQL query copied to clipboard!")});app.controller("SQLScriptRecipeController",function($scope,$controller,CodeBasedEditorUtils,CodeBasedValidationUtils,CodeBasedToPluginConverter,DataikuAPI,$q,WT1,$stateParams,RecipeRunJobService,RecipesUtils,Fn,$timeout,SQLRecipeHelperService,CodeMirrorSettingService){$controller("_SQLRecipeController",{$scope:$scope});$scope.enableAutoFixup();$scope.wt1RecipeType="SQL_SCRIPT_RECIPE";$scope.identifierQuote=null;$scope.editorOptions=CodeBasedEditorUtils.editorOptions("text/x-sql2",$scope);CodeBasedEditorUtils.registerBroadcastSelectionHandler($scope.editorOptions);CodeBasedEditorUtils.setRecipeScript($scope.script);$scope.editorOptions.extraKeys[CodeMirrorSettingService.getShortcuts()["AUTOCOMPLETE_SHORTCUT"]]=function(cm){$scope.recipeWT1Event("sql-script-autocomplete");SQLRecipeHelperService.handleAutocompleteRequest($scope,cm,"sql-recipe")};$scope.hooks.insertVariable=function(variableName,type){$timeout(function(){$scope.cm.replaceSelection(" ${"+variableName+"} ","end")});$scope.cm.focus()};if($scope.script.data==null)$scope.script.data=" ";$scope.getInputOrOuputLabel=function(ref){if(ref==null||ref.length==0){return""}if($scope.computablesMap==null){return""}var computable=$scope.computablesMap[ref];return computable.label};SQLRecipeHelperService.maintainSQLDatasetList($scope);$scope.sqlFormat=SQLRecipeHelperService.sqlFormat.bind(this,$scope);$scope.validateRecipe=function(){return CodeBasedValidationUtils.getGenericCheckPromise($scope).then(function(valResult){$scope.valCtx.validationResult=valResult;CodeBasedEditorUtils.updateLinter(valResult,$scope.linterFunction);$scope.recipeWT1Event("sql-script-validate",{ok:!valResult.topLevelMessages.error});return valResult})};$scope.hooks.preRunValidate=$scope.validateRecipe});app.factory("HoverIntent",function(){var svc={create:function(cb){return{cb:cb}},move:function(hi,evt,triggerTag){if(hi.triggerTag==triggerTag){return}else if(hi.timeout){clearTimeout(hi.timeout)}hi.timeout=setTimeout(function(){hi.cb(hi.origEvent,hi.triggerTag)},500);hi.triggerTag=triggerTag;hi.origEvent=evt},clear:function(hi){clearTimeout(hi.timeout)}};return svc});app.controller("SQLQueryRecipeController",function($rootScope,$controller,$scope,CodeBasedEditorUtils,CodeBasedValidationUtils,CodeBasedToPluginConverter,DataikuAPI,$q,WT1,$stateParams,CreateModalFromTemplate,RecipeRunJobService,RecipesUtils,Fn,MonoFuture,$timeout,ComputableSchemaRecipeSave,SQLRecipeHelperService,CodeMirrorSettingService){$controller("_SQLRecipeController",{$scope:$scope});$scope.enableAutoFixup();$scope.wt1RecipeType="SQL_QUERY_RECIPE";$scope.identifierQuote=null;$scope.editorOptions=CodeBasedEditorUtils.editorOptions("text/x-sql2",$scope);CodeBasedEditorUtils.registerBroadcastSelectionHandler($scope.editorOptions);CodeBasedEditorUtils.setRecipeScript($scope.script);$scope.editorOptions.extraKeys[CodeMirrorSettingService.getShortcuts()["AUTOCOMPLETE_SHORTCUT"]]=function(cm){$scope.recipeWT1Event("sql-script-autocomplete");SQLRecipeHelperService.handleAutocompleteRequest($scope,cm,"sql-recipe")};$scope.anyPipelineTypeEnabled=function(){return $rootScope.projectSummary.sqlPipelinesEnabled};$scope.hooks.insertVariable=function(variableName,type){$timeout(function(){$scope.cm.replaceSelection(" ${"+variableName+"} ","end")});$scope.cm.focus()};$scope.autofillCode=function(){};$scope.getInputOrOuputLabel=function(ref){if(ref==null||ref.length==0){return""}if($scope.computablesMap==null){return""}var computable=$scope.computablesMap[ref];return computable.label};SQLRecipeHelperService.maintainSQLDatasetList($scope);$scope.sqlFormat=SQLRecipeHelperService.sqlFormat.bind(this,$scope);$scope.validateRecipe=function(){return CodeBasedValidationUtils.getGenericCheckPromise($scope).then(function(valResult){$scope.valCtx.validationResult=valResult;CodeBasedEditorUtils.updateLinter(valResult,$scope.linterFunction);$scope.recipeWT1Event("sql-query-validate",{ok:!valResult.topLevelMessages.error});return ComputableSchemaRecipeSave.handleSchemaUpdateWithPrecomputed($scope,valResult.schemaResult).then(function(changeResult){if(changeResult.changed){return $scope.validateRecipe()}else{return valResult}})})};$scope.hooks.preRunValidate=$scope.validateRecipe;$scope.showExecutionPlan=function(){$scope.hooks.resetScope();DataikuAPI.flow.recipes.sqlQuery.getExecutionPlan($stateParams.projectKey,$scope.hooks.getRecipeSerialized(),$scope.script.data,RecipeRunJobService.getTargetPartition($scope)).success(function(data){$scope.valCtx.validationResult=data.validationResult;if(!data.validationResult.topLevelMessages.error){CreateModalFromTemplate("/templates/recipes/fragments/sql-modal.html",$scope,null,function(newScope){newScope.executionPlan=data.executionPlan;if(data.executionPlan){newScope.query=data.executionPlan.query}else{newScope.failedToComputeExecutionPlan=true}newScope.uiState={currentTab:"plan"};newScope.engine="SQL";newScope.isAlreadyRecipe=true})}}).error(setErrorInScope.bind($scope))};$scope.showExpandedQuery=function(query){CreateModalFromTemplate("/templates/recipes/fragments/sql-modal.html",$scope,null,function(newScope){newScope.query=query;newScope.uiState={currentTab:"query"};newScope.engine="SQL";newScope.isAlreadyRecipe=true})};$scope.run=function(){$scope.hooks.resetScope();MonoFuture($scope).wrap(DataikuAPI.flow.recipes.sqlQuery.run)($stateParams.projectKey,$scope.hooks.getRecipeSerialized(),$scope.script.data,RecipeRunJobService.getTargetPartition($scope)).success(function(data){$scope.future=null;$scope.valCtx.validationResult=data.result;$scope.recipeWT1Event("sql-query-run",{ok:!data.result.topLevelMessages.error,runOK:data.result.runResult&&data.result.runResult.success,runRows:data.result.runResult?data.result.runResult.totalRows:-1});if(data.result&&data.result.runResult&&data.result.runResult.success&&data.result.runResult.rows){CreateModalFromTemplate("/templates/recipes/sql/rows-preview-modal.html",$scope)}}).update(function(data){$scope.future=data}).error(function(data){$scope.future=null;if(data.aborted){$scope.valCtx={validationResult:{topLevelMessages:{messages:[{severity:"error",line:-1,message:"Query aborted"}]}}}}else{$scope.valCtx={validationResult:{topLevelMessages:{messages:[{severity:"error",line:-1,message:"Query failed unexpectedly"}]}}}}})}})})();(function(){"use strict";const app=angular.module("dataiku.recipes.customcode",[]);app.controller("RecipeFromPluginCreationController",function($scope,DataikuAPI,WT1,$rootScope,CreateModalFromTemplate,SelectablePluginsService){$scope.uiState={step:"choose-recipe"};$scope.recipes=[];$scope.$watch("pluginId",function(nv,ov){if(!nv)return;$scope.plugin=Array.dkuFindFn($rootScope.appConfig.loadedPlugins,function(n){return n.id===nv});if($scope.plugin){$rootScope.appConfig.customCodeRecipes.forEach(function(recipe){if(recipe.ownerPluginId==$scope.pluginId){$scope.recipes.push({activated:SelectablePluginsService.canBeBuildFromInputs(recipe,$scope.inputCount),preselectedInputs:getPreselectedInputs(recipe.desc,$scope.inputs),preselectedRole:getPreselectedRole(recipe.desc,$scope.inputs),recipeType:recipe.recipeType,label:recipe.desc.meta.label,description:recipe.desc.meta.description,icon:recipe.desc.meta.icon||$scope.plugin.icon,iconColor:recipe.desc.meta.iconColor,displayOrderRank:recipe.desc.meta.displayOrderRank})}})}function getPreselectedInputs(desc,inputs){if(!inputs)return null;return(inputs.MANAGED_FOLDER||[]).concat(inputs.DATASET||[]).concat(inputs.SAVED_MODEL||[]).concat(inputs.PROMPTABLE_MODEL||[])}function getPreselectedRole(desc,inputs){let preselectedRoles=[];if(!inputs){return null}if(inputs.DATASET&&inputs.DATASET.length>0&&desc.selectableFromDataset){preselectedRoles[desc.selectableFromDataset]=inputs.DATASET}if(inputs.MANAGED_FOLDER&&inputs.MANAGED_FOLDER.length>0&&desc.selectableFromFolder){preselectedRoles[desc.selectableFromFolder]=inputs.MANAGED_FOLDER}if(inputs.SAVED_MODEL&&inputs.SAVED_MODEL.length>0&&(desc.selectableFromMLModel||desc.selectableFromSavedModel)){preselectedRoles[desc.selectableFromSavedModel]=inputs.SAVED_MODEL}if(inputs.PROMPTABLE_MODEL&&inputs.PROMPTABLE_MODEL.length>0&&(desc.selectableFromPromptableModel||desc.selectableFromSavedModel)){preselectedRoles[desc.selectableFromPromptableModel]=inputs.PROMPTABLE_MODEL}return preselectedRoles}$scope.recipes.sort((a,b)=>a.label.toLowerCase().localeCompare(b.label.toLowerCase()))});$scope.create=function(recipe,zoneId){$scope.showCreateCustomCodeRecipeModal(recipe.recipeType,recipe.preselectedInputs,recipe.preselectedRole,zoneId)}});app.controller("CustomCodeRecipeCreationController",function($scope,Assert,DataikuAPI,WT1,$stateParams,TopNav,Fn,PartitionDeps,RecipeComputablesService,$controller,$state,RecipesUtils,RecipeDescService,PluginConfigUtils){var realDismiss=$scope.dismiss;$scope.dismiss=function(){if(angular.isDefined($scope.oldScope)){$scope.oldScope.dismiss()}realDismiss()};$controller("_RecipeCreationControllerBase",{$scope:$scope});$scope.helpState={};$scope.recipeName={};function init(){$scope.recipe={projectKey:$stateParams.projectKey,type:$scope.newRecipeType,inputs:{},outputs:{},params:{customConfig:{}},zone:$scope.zone};$scope.loadedDesc=$scope.appConfig.customCodeRecipes.filter(function(x){return x.recipeType==$scope.recipe.type})[0];Assert.inScope($scope,"loadedDesc");$scope.desc=angular.copy($scope.loadedDesc.desc);PluginConfigUtils.setDefaultValues($scope.desc.params,$scope.recipe.params.customConfig);$scope.pluginDesc=$scope.appConfig.loadedPlugins.filter(function(x){return x.id==$scope.loadedDesc.ownerPluginId})[0];RecipeComputablesService.getComputablesMap($scope.recipe,$scope).then(function(map){$scope.setComputablesMap(map)});if($scope.preselectedInputs){for(let[inputType,ids]of Object.entries($scope.preselectedInputRole)){ids.forEach(function(id){RecipesUtils.addInput($scope.recipe,inputType,id)})}}}$scope.$watch("newRecipeType",Fn.doIfNv(init));addDatasetUniquenessCheck($scope,DataikuAPI,$stateParams.projectKey);$scope.$watch("[recipe.inputs, recipe.outputs]",function(nv,ov){if(nv&&$scope.recipe&&$scope.recipe.inputs&&$scope.recipe.outputs){if($scope.preselectedInputs&&!RecipesUtils.getFlatInputsList($scope.recipe).some(_=>_.ref===$scope.preselectedInputs[0])){$scope.zone=null}var outputs=RecipesUtils.getFlatOutputsList($scope.recipe);$scope.hasRequiredIO=RecipeDescService.hasValidRequiredRoles($scope.recipe);if(outputs.length&&$scope.hasRequiredIO){let firstNonNullOutput=outputs.find(o=>!!o);if(firstNonNullOutput){$scope.recipeName.name="compute_"+firstNonNullOutput.ref}else{$scope.recipeName.name=null}}else{$scope.recipeName.name=null}}},true)});app.controller("CustomCodeRecipeController",function($rootScope,$scope,Assert,DataikuAPI,WT1,$stateParams,StateUtils,TopNav,RecipesUtils,PluginConfigUtils,Logger,DatasetUtils){$scope.loadedDesc=$scope.appConfig.customCodeRecipes.filter(function(x){return x.recipeType==$scope.recipe.type})[0];if($scope.loadedDesc==null){return}$scope.desc=angular.copy($scope.loadedDesc.desc);$scope.pluginDesc=$scope.appConfig.loadedPlugins.filter(function(x){return x.id==$scope.loadedDesc.ownerPluginId})[0];if($scope.creation){TopNav.setTab(StateUtils.defaultTab("io"))}if(!$scope.recipe.params){$scope.recipe.params={}}if(!$scope.recipe.params.customConfig){$scope.recipe.params.customConfig={}}$scope.anyPipelineTypeEnabled=function(){return $rootScope.projectSummary.sparkPipelinesEnabled};$scope.columnsPerInputRole={};PluginConfigUtils.setDefaultValues($scope.desc.params,$scope.recipe.params.customConfig);$scope.desc.params.forEach(function(param){if($scope.recipe.params.customConfig[param.name]===undefined){if(param.type=="COLUMNS"){$scope.recipe.params.customConfig[param.name]=[]}}if(param.columnRole!=null){$scope.columnsPerInputRole[param.columnRole]=[]}});$scope.enableAutoFixup();function refreshColumnListsFromComputablesMap(){if(!$scope.computablesMap){return}DatasetUtils.updateRecipeComputables($scope,$scope.recipe,$stateParams.projectKey,$stateParams.projectKey).then(function(){for(const roleName in $scope.recipe.inputs){$scope.columnsPerInputRole[roleName]=[];const items=RecipesUtils.getInputsForRole($scope.recipe,roleName);items.forEach(function(item){const computable=$scope.computablesMap[item.ref];if(computable==null){Logger.error("Computable not found for "+item.ref)}else{if(!(roleName in $scope.columnsPerInputRole)){$scope.columnsPerInputRole[roleName]=[]}if(computable.dataset){$scope.columnsPerInputRole[roleName]=$scope.columnsPerInputRole[roleName].concat(computable.dataset.schema.columns)}}})}})}$scope.roleChanged=function(roleName){$scope.columnsPerInputRole[roleName]=[];const inputs=RecipesUtils.getInputsForRole($scope.recipe,roleName);inputs.forEach(function(input){const computable=$scope.computablesMap[input.ref];if(computable==null){Logger.error("Computable not found for "+input.ref)}else{if(computable.dataset){$scope.columnsPerInputRole[roleName]=$scope.columnsPerInputRole[roleName].concat(computable.dataset.schema.columns)}}})};$scope.toggleShowRequirements=function(){if($scope.showRequirements===undefined){$scope.showRequirements=false;DataikuAPI.flow.recipes.getRequirements($stateParams.projectKey,$scope.recipe.type).success(function(data){$scope.requirements=data}).error(setErrorInScope.bind($scope))}$scope.showRequirements=!$scope.showRequirements};refreshColumnListsFromComputablesMap();$scope.$on("computablesMapChanged",function(){refreshColumnListsFromComputablesMap()})});app.controller("AppRecipeCreationController",function($scope,Assert,DataikuAPI,WT1,$stateParams,TopNav,Fn,PartitionDeps,RecipeComputablesService,$controller,$state,RecipesUtils,RecipeDescService,PluginConfigUtils){var realDismiss=$scope.dismiss;$scope.dismiss=function(){if(angular.isDefined($scope.oldScope)){$scope.oldScope.dismiss()}realDismiss()};$controller("_RecipeCreationControllerBase",{$scope:$scope});$scope.helpState={};$scope.recipeName={};function init(){$scope.recipe={projectKey:$stateParams.projectKey,type:$scope.newRecipeType,inputs:{},outputs:{},params:{customConfig:{}}};$scope.loadedDesc=$scope.appConfig.appRecipes.filter(function(x){return x.recipeType==$scope.recipe.type})[0];Assert.inScope($scope,"loadedDesc");$scope.desc=angular.copy($scope.loadedDesc);RecipeComputablesService.getComputablesMap($scope.recipe,$scope).then(function(map){$scope.setComputablesMap(map)});if($scope.preselectedInputs){$scope.preselectedInputs.forEach(preselectedInput=>{RecipesUtils.addInput($scope.recipe,$scope.preselectedInputRole,preselectedInput)})}}$scope.$watch("newRecipeType",Fn.doIfNv(init));addDatasetUniquenessCheck($scope,DataikuAPI,$stateParams.projectKey);$scope.$watch("[recipe.inputs, recipe.outputs]",function(nv,ov){if(nv&&$scope.recipe&&$scope.recipe.inputs&&$scope.recipe.outputs){var outputs=RecipesUtils.getFlatOutputsList($scope.recipe);if(outputs.length){let firstNonNullOutput=outputs.find(o=>!!o);if(firstNonNullOutput){$scope.recipeName.name="compute_"+firstNonNullOutput.ref}else{$scope.recipeName.name=null}}else{$scope.recipeName.name=null}}},true)});app.controller("AppRecipeController",function($rootScope,$scope,Assert,DataikuAPI,WT1,$state,$stateParams,StateUtils,TopNav,RecipesUtils,PluginConfigUtils,Logger,DatasetUtils){$scope.loadedDesc=$scope.appConfig.appRecipes.filter(function(x){return x.recipeType==$scope.recipe.type})[0];Assert.inScope($scope,"loadedDesc");$scope.desc=angular.copy($scope.loadedDesc);TopNav.setTab("settings");if(!$scope.recipe.params){$scope.recipe.params={}}if(!$scope.recipe.params.variables){$scope.recipe.params.variables={}}$scope.desc.variablesEditionTile.behavior="INLINE_AUTO_SAVE";$scope.columnsPerInputRole={};$scope.enableAutoFixup();function refreshColumnListsFromComputablesMap(){if(!$scope.computablesMap){return}DatasetUtils.updateRecipeComputables($scope,$scope.recipe,$stateParams.projectKey,$stateParams.projectKey).then(function(){for(var roleName in $scope.recipe.inputs){$scope.columnsPerInputRole[roleName]=[];var items=RecipesUtils.getInputsForRole($scope.recipe,roleName);if(items.length>0){var input=items[0];var computable=$scope.computablesMap[input.ref];if(computable==null){Logger.error("Computable not found for "+input.ref)}else{$scope.columnsPerInputRole[roleName]=computable.dataset?computable.dataset.schema.columns:[]}}}})}$scope.roleChanged=function(roleName){$scope.columnsPerInputRole[roleName]=[];const inputs=RecipesUtils.getInputsForRole($scope.recipe,roleName);if(inputs.length>0){const computable=$scope.computablesMap[inputs[0].ref];if(computable==null){Logger.error("Computable not found for "+inputs[0].ref)}else{$scope.columnsPerInputRole[roleName]=computable.dataset?computable.dataset.schema.columns:[]}}};refreshColumnListsFromComputablesMap();$scope.$on("computablesMapChanged",function(){refreshColumnListsFromComputablesMap()});$scope.hasParameters=function(){let tile=$scope.desc?$scope.desc.variablesEditionTile:null;if(!tile)return false;return tile.html&&tile.html.length>0||tile.params&&tile.params.length>0};DataikuAPI.apps.getAppRecipeUsability($scope.recipe.type).success(function(data){$scope.usability=data}).error(setErrorInScope.bind($scope));$scope.canGoToDesigner=function(){return $scope.usability&&$scope.usability.canEdit&&!$rootScope.appConfig.isAutomation};$scope.goToDesigner=function(){if(!$scope.usability)return;if($scope.usability.origin=="PROJECT"){$state.go("projects.project.appdesigner",{projectKey:$scope.usability.projectKey})}else if($scope.usability.origin=="PLUGIN"){$state.go("projects.project.appdesigner",{projectKey:$scope.desc.recipeType.substring("App_PROJECT_".length)})}}})})();(function(){"use strict";const app=angular.module("dataiku.recipes");app.controller("_NLPLLMRecipeControllerBase",function($scope,$stateParams,$q,DataikuAPI,PartitionDeps,ComputableSchemaRecipeSave,SmartId,PromptUtils){$scope.onLLMChange=function(){if($scope.desc&&$scope.desc.llmId&&$scope.availableLLMs){$scope.activeLLM=$scope.availableLLMs.find(l=>l.id===$scope.desc.llmId);if(!$scope.activeLLM){$scope.retrievableKnowledge=undefined;return}$scope.temperatureRange=PromptUtils.getTemperatureRange($scope.activeLLM);$scope.topKRange=PromptUtils.getTopKRange($scope.activeLLM);if($scope.activeLLM.type==="RETRIEVAL_AUGMENTED"){const smartId=SmartId.resolve($scope.activeLLM.savedModelSmartId);DataikuAPI.savedmodels.get(smartId.projectKey,smartId.id).then(function({data}){DataikuAPI.retrievableknowledge.get(smartId.projectKey,data.inlineVersions[0].ragllmSettings.kbRef).then(function({data}){$scope.retrievableKnowledge=data})}).catch(setErrorInScope.bind($scope))}else{$scope.retrievableKnowledge=undefined}}};$scope.$watch("recipe.inputs.main",function(nv,ov){if(!nv)return;$scope.inputRef=($scope.recipe.inputs.main.items||[{}])[0].ref;if(!$scope.inputRef)return;var mainRoleAcceptDataset=true;if($scope.recipeDesc&&$scope.recipeDesc.inputRoles){mainRoleAcceptDataset=$scope.recipeDesc.inputRoles.find(role=>role.name=="main").acceptsDataset}if(mainRoleAcceptDataset){const resolvedRef=SmartId.resolve($scope.inputRef,$stateParams.projectKey);DataikuAPI.datasets.get(resolvedRef.projectKey,resolvedRef.id,$stateParams.projectKey).then(response=>{const schema=response.data.schema;$scope.inputDatasetColumns=schema.columns.map(column=>column.name);$scope.inputDatasetSchema=schema})}});const deregister=$scope.$watch("script",function(){if(!$scope.script)return;$scope.desc=JSON.parse($scope.script.data);$scope.onLLMChange();deregister()});$scope.loadLLMs=function(purpose){DataikuAPI.pretrainedModels.listAvailableLLMs($stateParams.projectKey,purpose).success(function(data){$scope.availableLLMs=data.identifiers;$scope.onLLMChange()}).error(setErrorInScope.bind($scope))};$scope.hooks.recipeIsDirty=function(){if(!$scope.recipe)return false;if($scope.creation)return true;const dirtyRecipe=!angular.equals($scope.recipe,$scope.origRecipe);const origDesc=JSON.parse($scope.origScript.data);const dirtyDesc=!angular.equals(origDesc,$scope.desc);return dirtyRecipe||dirtyDesc};$scope.hooks.save=function(){const recipeSerialized=angular.copy($scope.recipe);PartitionDeps.prepareRecipeForSerialize(recipeSerialized);const payload=angular.toJson($scope.desc);const deferred=$q.defer();ComputableSchemaRecipeSave.handleSave($scope,recipeSerialized,payload,deferred);$scope.script.data=payload;return deferred.promise}});app.controller("NLPRecipeConvertToPromptRecipeModal",function($scope,$stateParams,$state,DataikuAPI){DataikuAPI.flow.recipes.nlp.getPromptForNLPRecipe($stateParams.projectKey,$scope.recipe.name).success(function(data){$scope.prompt=data}).error(setErrorInScope.bind($scope));$scope.convert=function(){if(!$scope.recipe||!$scope.recipe.name)return;DataikuAPI.flow.recipes.nlp.convertToPromptRecipe($stateParams.projectKey,$scope.recipe.name).success(function(){$state.reload()}).error(setErrorInScope.bind($scope))}});app.controller("GenAIBaseEvaluationRecipeCreationController",function($scope,evaluatedType,DataikuAPI,ActiveProjectKey,DatasetUtils,$controller,RecipeComputablesService){$controller("_RecipeCreationControllerBase",{$scope:$scope});$scope.recipe={projectKey:ActiveProjectKey.get(),type:"nlp_"+evaluatedType+"_evaluation",inputs:{},outputs:{},params:{}};$scope.forceMainLabel=true;$scope.uiState={inputDs:null};addDatasetUniquenessCheck($scope,DataikuAPI,ActiveProjectKey.get());fetchManagedDatasetConnections($scope,DataikuAPI);$scope.$watch("uiState.inputDs",function(nv,ov){if(nv){$scope.recipe.name=evaluatedType+"_evaluate_"+nv.replace(/[A-Z]*\./,"")}if($scope.uiState.inputDs){$scope.recipe.inputs.main={items:[{ref:$scope.uiState.inputDs}]}}else{$scope.recipe.inputs.main={items:[]}}});DatasetUtils.listDatasetsUsabilityInAndOut(ActiveProjectKey.get(),$scope.recipe.type).then(function(data){$scope.availableInputDatasets=data[0]});RecipeComputablesService.getComputablesMap($scope.recipe,$scope).then(function(map){$scope.setComputablesMap(map)});$scope.hasMain=function(){const outputs=$scope.recipe.outputs;return outputs.main&&outputs.main.items&&outputs.main.items.length>0&&outputs.main.items[0].ref};$scope.hasMetrics=function(){const outputs=$scope.recipe.outputs;return outputs.metrics&&outputs.metrics.items&&outputs.metrics.items.length>0&&outputs.metrics.items[0].ref};$scope.hasEvaluationStore=function(){const outputs=$scope.recipe.outputs;return outputs.evaluationStore&&outputs.evaluationStore.items&&outputs.evaluationStore.items.length>0&&outputs.evaluationStore.items[0].ref};$scope.canCreate=function(){return $scope.recipe.name&&$scope.recipe.name.length>0&&$scope.recipe.outputs&&!$scope.shouldDisplayOutputExplanation()&&!$scope.newRecipeForm.$invalid};$scope.shouldDisplayOutputExplanation=function(){return!$scope.hasMain()&&!$scope.hasMetrics()&&!$scope.hasEvaluationStore()};$scope.generateOutputExplanation=function(){const requiredOutputRoles=[];$scope.recipeDesc.outputRoles.forEach((role,outputRoleidx)=>{requiredOutputRoles.push(role.name==="main"?'"Output Dataset"':'"'+(role.label||role.name)+'"')});const message="This recipe requires at least one output in: "+requiredOutputRoles.slice(0,-1).join(", ")+(requiredOutputRoles.length===2?" or ":", or ")+requiredOutputRoles.slice(-1)+".";return message};$scope.doCreateRecipe=function(){$scope.creatingRecipe=true;const settings={zone:$scope.zone};return DataikuAPI.flow.recipes.generic.create($scope.recipe,settings)}});app.controller("GenAIBaseEvaluationRecipeEditorController",function($scope,evaluatedType,$rootScope,$controller,$stateParams,ActiveProjectKey,DataikuAPI,FutureProgressModal,DOCUMENT_SPLITTING_METHOD_MAP,ModelLabelUtils,EmbeddingUtils,PromptUtils,LLMEvaluationMetrics,GenAiEvaluationMetrics){$controller("_NLPLLMRecipeControllerBase",{$scope:$scope});$scope.NO_COLUMN_SELECTED="None - no column selected";$scope.NO_LLM_SELECTED={id:"None",friendlyName:"None - no model selected",type:"None"};$scope.DOCUMENT_SPLITTING_METHOD_MAP=DOCUMENT_SPLITTING_METHOD_MAP;$scope.COLUMNS_NEEDED_BY_PROMPT_RECIPE=["llm_raw_query","llm_raw_response"];$scope.COLUMNS_NEEDED_BY_DATAIKU_ANSWERS=["question","answer","sources"];$scope.$watch("desc",(nv,ov)=>{if(angular.equals(nv,ov)){$scope.onInit()}});$scope.missingColumnsWarning="";$scope.$watch("inputDatasetColumns",(nv,ov)=>{if(nv){$scope.canPromptRecipe=$scope.COLUMNS_NEEDED_BY_PROMPT_RECIPE.every(col=>nv.includes(col));$scope.canDataikuAnswers=$scope.COLUMNS_NEEDED_BY_DATAIKU_ANSWERS.every(col=>nv.includes(col));$scope.updateMissingColumnsWarning($scope.desc.inputFormat)}});$scope.updateMissingColumnsWarning=function(inputFormat){if($scope.inputDatasetColumns){if(inputFormat==="PROMPT_RECIPE"&&!$scope.canPromptRecipe){$scope.missingColumnsWarning="Input dataset lacks some required columns: "+$scope.COLUMNS_NEEDED_BY_PROMPT_RECIPE.filter(col=>!$scope.inputDatasetColumns.includes(col))+'. Make sure "Raw query output mode" and "Raw response output mode" in your Prompt recipe are not set to "None".'}else if(inputFormat==="DATAIKU_ANSWERS"&&!$scope.canDataikuAnswers){$scope.missingColumnsWarning="Input dataset lacks some required columns: "+$scope.COLUMNS_NEEDED_BY_DATAIKU_ANSWERS.filter(col=>!$scope.inputDatasetColumns.includes(col))+". Make sure \"Retrieval Method\" is set to 'Use knowledge bank retrieval'."}else{$scope.missingColumnsWarning=""}}};DataikuAPI.pretrainedModels.listAvailableLLMs($stateParams.projectKey,"TEXT_EMBEDDING_EXTRACTION").success(function(data){$scope.availableEmbeddingLLMs=[$scope.NO_LLM_SELECTED].concat(data.identifiers);$scope.refreshEmbeddingLLM()}).error(setErrorInScope.bind($scope));DataikuAPI.pretrainedModels.listAvailableLLMConnections().success(function(data){$scope.localHuggingFaceConnectionNames=Object.values(data).filter(connection=>connection.type==="HuggingFaceLocal").map(connection=>connection.name)});$scope.refreshEmbeddingLLM=function(){if($scope.desc&&$scope.desc.embeddingLLMId&&$scope.availableEmbeddingLLMs){$scope.activeEmbeddingLLM=$scope.availableEmbeddingLLMs.find(l=>l.id===$scope.desc.embeddingLLMId)}};DataikuAPI.pretrainedModels.listAvailableLLMs($stateParams.projectKey,"GENERIC_COMPLETION").success(function(data){$scope.availableCompletionLLMs=[$scope.NO_LLM_SELECTED].concat(data.identifiers);$scope.refreshCompletionLLM()}).error(setErrorInScope.bind($scope));$scope.refreshCompletionLLM=function(){if($scope.desc&&$scope.desc.completionLLMId&&$scope.availableCompletionLLMs){$scope.activeCompletionLLM=$scope.availableCompletionLLMs.find(l=>l.id===$scope.desc.completionLLMId)}if($scope.activeCompletionLLM&&$scope.activeCompletionLLM.id!==$scope.NO_LLM_SELECTED.id){$scope.temperatureRange=PromptUtils.getTemperatureRange($scope.activeCompletionLLM);$scope.topKRange=PromptUtils.getTopKRange($scope.activeCompletionLLM)}};$scope.getMaxTokenLimit=function(){return $scope.activeEmbeddingLLM?$scope.activeEmbeddingLLM.maxTokensLimit:null};$scope.shouldWarnAboutChunkSize=function(){return EmbeddingUtils.shouldWarnAboutChunkSize($scope.activeEmbeddingLLM,$scope.desc.embeddingSettings.documentSplittingMode,$scope.desc.embeddingSettings.chunkSizeCharacters)};$scope.defaultRagasMaxWorkers=$rootScope.appConfig.defaultRagasMaxWorkers;$scope.mayRunCustomMetrics=$scope.mayWriteSafeCode();$scope.setRagasMaxWorkers=function(value){if(!value){$scope.desc.ragasMaxWorkers=null}};$scope.hasAllRequiredOutputs=function(){if(!$scope.recipe||!$scope.recipe.outputs){return false}const out=$scope.recipe.outputs;if(out.main&&out.main.items&&out.main.items.length){return true}else if(out.evaluationStore&&out.evaluationStore.items&&out.evaluationStore.items.length){return true}else if(out.metrics&&out.metrics.items&&out.metrics.items.length){return true}else{return false}};$scope.codeEnvWarning={enabled:false,envName:"",reason:""};DataikuAPI.codeenvs.listWithVisualMlPackages($stateParams.projectKey).success(function(data){$scope.envsCompatibility=data;updateCodeEnvWarning()}).error(setErrorInScope.bind($scope));$scope.$watchGroup(["recipe.params.envSelection.envMode","recipe.params.envSelection.envName"],(nv,ov)=>{updateCodeEnvWarning()});function updateCodeEnvWarning(){if($scope.envsCompatibility===undefined){return}const compatibilityInfo=filterCodeEnvCompatibilityInfo($scope.envsCompatibility);let compat;if(evaluatedType==="llm"){compat=compatibilityInfo.llmEvaluation}else if(evaluatedType==="agent"){compat=compatibilityInfo.agentEvaluation}else{return}$scope.codeEnvWarning.enabled=!compat.compatible;$scope.codeEnvWarning.envName=compatibilityInfo.envName?compatibilityInfo.envName:"DSS builtin env";if(compat.reasons.length>0){$scope.codeEnvWarning.reason=compat.reasons[0]}else{$scope.codeEnvWarning.reason=""}}function filterCodeEnvCompatibilityInfo(envsCompatibilityInfo){if($scope.recipe.params.envSelection.envMode==="EXPLICIT_ENV"){return envsCompatibilityInfo.envs.filter(env=>env.envName==$scope.recipe.params.envSelection.envName)[0]}if($scope.recipe.params.envSelection.envMode==="INHERIT"&&$scope.envsCompatibility.resolvedInheritDefault){return envsCompatibilityInfo.envs.filter(env=>env.envName==$scope.envsCompatibility.resolvedInheritDefault)[0]}return envsCompatibilityInfo.builtinEnvCompat}const baseCanSave=$scope.canSave;$scope.canSave=function(){return ModelLabelUtils.validateLabels($scope.desc)&&baseCanSave()}});app.service("GenAiEvaluationMetrics",function(){const svc={};svc.getCustomMetricNamesFromEvaluationDetails=function(evaluationDetails){let names=[];if(evaluationDetails.metrics&&evaluationDetails.metrics.customMetricsResults){names=evaluationDetails.metrics.customMetricsResults.map(function(metric){return metric.metric.name})}return names};return svc});app.component("llmSelector",{bindings:{availableLlms:"<",selectedLlmId:"=",onChange:"<",onChangeOutput:"&",defaultOpened:"<",dropdownPosition:"@",disableAlertWarning:"<",placeholder:"<",nullValueLabel:"<",nullValueId:"<",hideCopyButton:"<",hideGoToLlmButton:"<",disabled:"<",clearable:"<"},template:`
    <basic-select ng-if="$ctrl.availableLlms"
                  items="$ctrl.availableLlms"
                  ng-model="$ctrl.selectedLlmId"
                  bind-value="id"
                  bind-label="friendlyNameShort"
                  group-by-fn="$ctrl.groupBy"
                  bind-group-label-fn="$ctrl.niceModelType"
                  bind-group-annotation="connection"
                  bind-group-annotation-icon-fn="$ctrl.modelConnectionIcon"
                  bind-group-description="connectionDescription"
                  searchable="true"
                  search-fn="$ctrl.searchFunction"
                  placeholder="{{ $ctrl.nullValueLabel || $ctrl.placeholder }}"
                  invalidate-on-ghosts="true"
                  default-opened="$ctrl.defaultOpened"
                  dropdown-position="{{ $ctrl.dropdownPosition }}"
                  ng-disabled="$ctrl.disabled"
                  clearable="$ctrl.clearable"
                  ghost-items-tooltip="LLM not available. It has been disabled, retired, or is not supported for this feature. Choose another LLM or contact your administrator."
                  custom-ng-select-class="ng-dropdown-panel--500 
                                          ng-select--custom-dropdown-height 
                                          ng-select--custom-x-overflow"></basic-select>
    <copy-to-clipboard-icon ng-if="!$ctrl.hideCopyButton" icon="'copy-step'" icon-class="($ctrl.selectedLlmId || $ctrl.nullValueId) ? 'btn btn--text btn--icon btn--secondary' : 'btn btn--text btn--icon btn--secondary disabled'" disabled="!$ctrl.selectedLlmId && !$ctrl.nullValueId" value="$ctrl.selectedLlmId || $ctrl.nullValueId" name="'LLM ID'"></copy-to-clipboard-icon>
    <div class="help-inline padleft0" ng-if="!$ctrl.hideGoToLlmButton && $ctrl.selectedLLMHref">
        <external-link href="{{$ctrl.selectedLLMHref}}" target="_blank">Go to {{ ($ctrl.selectedLlmId || $ctrl.nullValueId || "").startsWith("agent:") ? "agent" : "LLM" }}</external-link>
    </div>
    <div class="mbot0 mtop8 alert alert-warning" ng-if="!$ctrl.isAvailable && !$ctrl.disableAlertWarning">
        LLM not available. It has been disabled, retired, or is not supported for this feature. Choose another LLM or contact your administrator. <strong>{{$ctrl.selectedLlmId}}</strong>
    </div>`,controller:function($scope,$filter,StateUtils,StringUtils){const $ctrl=this;$scope.$watch(function(){return $ctrl.selectedLlmId},function(newVal,oldVal){$ctrl.updateAvailability();$ctrl.updateLLMSourceLink();if(newVal!==oldVal&&$ctrl.onChange){$ctrl.onChange()}if(newVal!==oldVal&&$ctrl.onChangeOutput){$ctrl.onChangeOutput()}});$ctrl.$onChanges=()=>{if((typeof $ctrl.placeholder==="undefined"||$ctrl.placeholder===null)&&(typeof $ctrl.nullValueLabel==="undefined"||$ctrl.nullValueLabel===null)){$ctrl.placeholder="Nothing selected"}$ctrl.updateAvailability();$ctrl.updateLLMSourceLink()};$ctrl.isAvailable=true;$ctrl.updateAvailability=()=>{if($ctrl.availableLlms&&$ctrl.selectedLlmId){$ctrl.isAvailable=!!$ctrl.availableLlms.find(l=>l.id===$ctrl.selectedLlmId)}};$ctrl.selectedLLMHref=undefined;$ctrl.updateLLMSourceLink=()=>{$ctrl.selectedLLMHref=undefined;const targetId=$ctrl.selectedLlmId||$ctrl.nullValueId;if($ctrl.availableLlms&&targetId){const selectedLLM=$ctrl.availableLlms.find(l=>l.id===targetId);if(selectedLLM&&(["SAVED_MODEL_AGENT","RETRIEVAL_AUGMENTED"].includes(selectedLLM.type)||selectedLLM.type.startsWith("SAVED_MODEL_FINETUNED"))){$ctrl.selectedLLMHref=StateUtils.href.savedModel(selectedLLM.savedModelSmartId,undefined,{},{redirectToActiveVersion:true})}}};$ctrl.groupBy=modelOption=>{return $ctrl.niceModelType(modelOption)+" - "+modelOption.connection};$ctrl.niceModelType=modelOption=>{return $filter("niceLLMType")(modelOption.type)};$ctrl.modelConnectionIcon=modelOption=>{return"dku-icon-plug-disconnected-12"};$ctrl.searchFunction=(term,llm)=>{const normalized=StringUtils.normalizeTextForSearch(term);return StringUtils.normalizeTextForSearch(llm.friendlyNameShort).includes(normalized)||StringUtils.normalizeTextForSearch(llm.id).includes(normalized)||StringUtils.normalizeTextForSearch(llm.connection).includes(normalized)||StringUtils.normalizeTextForSearch(llm.connectionDescription).includes(normalized)}}});app.component("perCharsSplittingSettings",{bindings:{chunkSizeCharacters:"=",chunkOverlapCharacters:"=",embeddingLlm:"<",documentSplittingMode:"<",defaultChunkSize:"<",defaultOverlapSize:"<"},templateUrl:"templates/recipes/nlp/per-chars-splitting-settings.component.html",controller:function($scope,EmbeddingUtils){const $ctrl=this;$ctrl.shouldWarnAboutChunkSize=()=>{return EmbeddingUtils.shouldWarnAboutChunkSize($ctrl.embeddingLlm,$ctrl.documentSplittingMode,$ctrl.chunkSizeCharacters)};$ctrl.getModelMaxSizeInChars=()=>{return EmbeddingUtils.tokensToCharsOrDefault($ctrl.embeddingLlm)};$ctrl.resetToDefaultSplittingSettings=function(){$ctrl.chunkSizeCharacters=$ctrl.defaultChunkSize;$ctrl.chunkOverlapCharacters=$ctrl.defaultOverlapSize}}});app.service("TraceExplorerService",function($q,$rootScope,DataikuAPI,Dialogs,PluginsService,DataikuCloudService,$window,ActivityIndicator,SemanticVersionService){const traceExplorerPluginId="traces-explorer";const requiredPluginVersion="1.0.4";const buildTraceExplorerUrl=(traceExplorerWebApp,trace)=>{return DataikuAPI.webapps.getPublicInfo(traceExplorerWebApp.projectKey,traceExplorerWebApp.webAppId).then(resp=>{const publicInfo=resp.data;try{localStorage.setItem("ls.llm.traceExplorer.trace",JSON.stringify(trace))}catch(e){const message="Due to the trace size, Trace Explorer cannot be launched automatically. Please open it manually to copy and paste the trace data.";Dialogs.error($rootScope,"Unable to auto-open Trace Explorer",message);return $q.reject("LOCAL_STORAGE_ERROR")}let baseUrl="";if($rootScope.appConfig.dssExternalURL){baseUrl+=$rootScope.appConfig.dssExternalURL}baseUrl+="/webapps/";const vanityOrId=publicInfo.securityInfo.vanityURL||`${publicInfo.webapp.projectKey}/${publicInfo.webapp.id}`;return`${baseUrl}${vanityOrId}/`}).catch(e=>{if(e!=="LOCAL_STORAGE_ERROR"){const message=`The "Trace Explorer" Web App instance ${traceExplorerWebApp.webAppId} in the project ${traceExplorerWebApp.projectKey} does not exist or you don't have read access to the project. Please contact your administrator.`;Dialogs.error($rootScope,"Permission required",message)}return $q.reject()})};const handlePluginInstalled=trace=>{return PluginsService.getPluginVersion(traceExplorerPluginId).then(pluginVersion=>{if(SemanticVersionService.compareVersions(pluginVersion,requiredPluginVersion)<0){const message=`The currently installed "Trace Explorer" plugin (version ${pluginVersion}) does not support this feature. To proceed, the plugin must be updated to version ${requiredPluginVersion} or newer. Please contact your administrator.`;Dialogs.error($rootScope,"Plugin update required",message);return $q.reject()}const traceExplorerDefaultWebApp=$rootScope.appConfig?.llmSettings?.traceExplorerDefaultWebApp;if(!traceExplorerDefaultWebApp?.projectKey||!traceExplorerDefaultWebApp?.webAppId){const message='"Trace Explorer" plugin is installed. To finalize the setup, <doclink page="/agents/tracing#accessing-via-explore-trace-shortcut" title="read the documentation"/> or contact your administrator.';Dialogs.errorUnsafeHTML($rootScope,"Configuration required",message);return $q.reject()}return buildTraceExplorerUrl(traceExplorerDefaultWebApp,trace).then(traceExplorerUrl=>{$window.open(`${traceExplorerUrl}?readTraceFromLS=true`,"_blank")})})};const handlePluginNotInstalled=()=>{let cloudInfo;return DataikuCloudService.getCloudInfo().then(info=>{cloudInfo=info;let installMessage='Enhance your experience by installing the "Trace Explorer" plugin. You can ';if(cloudInfo.isDataikuCloud){installMessage+=cloudInfo.isSpaceAdmin?"install it on the Launchpad.":"ask your administrator to install it."}else{installMessage+=`${$rootScope.appConfig.admin?"install":"request"} it from the store.`}return Dialogs.confirm($rootScope,"Unlock Trace Exploration",installMessage,{positive:true,btnConfirm:"OK"})}).then(()=>{return PluginsService.getPluginStoreLink(cloudInfo,traceExplorerPluginId)}).then(pluginStoreUrl=>{$window.open(pluginStoreUrl,"_blank")})};this.openTraceExplorer=trace=>{PluginsService.checkInstalledStatus("traces-explorer").then(isPluginInstalled=>{if(isPluginInstalled){return handlePluginInstalled(trace)}else{return handlePluginNotInstalled()}}).catch(error=>{if(error&&error.message){ActivityIndicator.error(error.message,8e3)}})}})})();(function(){"use strict";const app=angular.module("dataiku.recipes");app.controller("PromptRecipeCreationController",function($scope,$stateParams,$controller,DataikuAPI){$scope.recipeType="prompt";$controller("SingleOutputDatasetRecipeCreationController",{$scope:$scope});$scope.showOutputPane=_=>!!$scope.io.inputDataset;$scope.recipe={inputs:{main:{items:[{ref:""}]}},outputs:{main:{items:[]}}};DataikuAPI.flow.listUsableComputables($stateParams.projectKey,{datasetsOnly:false}).then(function({data}){$scope.availableInputFolders=data.filter(computable=>computable.type=="MANAGED_FOLDER")}).catch(setErrorInScope.bind($scope));$scope.autosetName=function(){if($scope.io.inputDataset){const niceInputName=$scope.io.inputDataset.replace(/[A-Z]*\./,"");$scope.maybeSetNewDatasetName(niceInputName+"_generated")}};$scope.getCreationSettings=function(){const inputs=[];if($scope.io.inputDataset){inputs.push($scope.io.inputDataset)}const creationSettings={virtualInputs:inputs};if($scope.initialPayload){creationSettings.initialPayload=$scope.initialPayload}return creationSettings};addDatasetUniquenessCheck($scope,DataikuAPI,$stateParams.projectKey);fetchManagedDatasetConnections($scope,DataikuAPI);$scope.$watch("io.inputDataset",function(nv){if(nv){$scope.recipe.inputs.main.items[0].ref=nv}});$scope.$watch("io.inputImageFolder",function(nv){if(nv){if(!$scope.recipe.inputs.images){$scope.recipe.inputs.images={items:[{ref:""}]}}$scope.recipe.inputs.images.items[0].ref=nv}})});app.controller("PromptRecipeEditor",function($scope,$controller,$stateParams,Debounce,PromptUtils,CreateModalFromTemplate,DataikuAPI){$controller("_NLPLLMRecipeControllerBase",{$scope:$scope});$scope.loadLLMs("GENERIC_COMPLETION");$scope.getInputs=PromptUtils.getInputs;$scope.hasImageInput=PromptUtils.hasImageInput;$scope.addInput=function(){PromptUtils.getInputs($scope.desc.prompt).push({name:"",datasetColumnName:undefined});$scope.desc.prompt.structuredPromptExamples.forEach(example=>{example.inputs.push("")})};$scope.deleteInput=function(index){PromptUtils.getInputs($scope.desc.prompt).splice(index,1);$scope.desc.prompt.structuredPromptExamples.forEach(example=>{example.inputs.splice(index,1)})};$scope.updateInputCheck=Debounce().withDelay(300,300).wrap(_=>{PromptUtils.updateInputCheck($scope.desc.prompt,$scope.activeLLM.supportsImageInputs)});$scope.openEditInStudioModal=function(){CreateModalFromTemplate("/templates/recipes/nlp/edit-in-studio.html",$scope,"EditInStudioModalController",function(newScope){})};$scope.onPromptLLMChange=function(){$scope.onLLMChange();PromptUtils.updateInputsOnLLMChange($scope.desc.prompt,$scope.activeLLM);if($scope.recipe&&$scope.recipe.inputs){const items=[];if($scope.activeLLM&&$scope.activeLLM.retrievableKnowledgeSmartId){items.push({ref:$scope.activeLLM.retrievableKnowledgeSmartId})}$scope.recipe.inputs.model={items:items}}};var unwatch=$scope.$watch("desc",function(nv){if(nv){if(!$scope.desc.filter){$scope.desc.filter={enabled:false,distinct:false,uiData:{conditions:[],mode:"&&"}}}unwatch()}},true);$scope.$watch("recipe.inputs.images.items",function(nv){if(nv){$scope.desc.prompt.imageFolderId=(nv[0]||{}).ref}},true)});app.controller("EditInStudioModalController",function($scope,$stateParams,$state,DataikuAPI){$scope.prompt={};DataikuAPI.promptStudios.listHeads($stateParams.projectKey).then(function({data}){$scope.promptStudios=data;$scope.promptStudios.unshift({createOption:true});if(!$scope.desc.associatedPromptStudioId){$scope.overwriteDisabledReason="The prompt recipe was not created from a prompt studio";$scope.prompt.create=true;return}const originStudio=$scope.promptStudios.find(studio=>studio.id===$scope.desc.associatedPromptStudioId);if(!originStudio){$scope.overwriteDisabledReason="The prompt studio from which the recipe was created is not available (probably deleted)";$scope.prompt.create=true;return}$scope.prompt.studio=originStudio;$scope.originStudioName=originStudio.name;if(!originStudio.promptIds.includes($scope.desc.associatedPromptStudioPromptId)){$scope.overwriteDisabledReason="The prompt from which the recipe was created has been deleted from its prompt studio"}$scope.prompt.create=!!$scope.overwriteDisabledReason}).catch(setErrorInScope.bind($scope));$scope.optionLabel=function(option){if(option.createOption){return"Create a new Prompt studio..."}return option.name};$scope.editInStudio=function(){$scope.hooks.save().then(function(){const promptCreationSettings={};if($scope.prompt.studio.createOption){promptCreationSettings.newPromptStudioName=$scope.prompt.studio.name}else{promptCreationSettings.promptStudioId=$scope.prompt.studio.id;if(!$scope.prompt.create){promptCreationSettings.originPromptStudioPromptId=$scope.desc.associatedPromptStudioPromptId}}DataikuAPI.promptStudios.editFromRecipe($stateParams.projectKey,$scope.recipe.name,promptCreationSettings).then(function({data}){$state.go("projects.project.promptstudios.promptstudio",{promptStudioId:data.promptStudioId,promptId:data.promptStudioPromptId})}).catch(setErrorInScope.bind($scope))})}})})();(function(){"use strict";const app=angular.module("dataiku.recipes");app.controller("NLPLLMTextClassificationRecipeCreationController",function($scope,$stateParams,CreateModalFromTemplate,DatasetUtils,DatasetLabUtils,DataikuAPI,CachedAPICalls){const modelDefined={displayName:"Task-specific classes",desc:"Use predefined classes to perform specific text classification tasks",useCases:[{name:"Sentiment analysis",desc:"Analyze sentiment (positive, negative, neutral...) in a text",inputDatasetRequired:false,action:newSentimentAnalysis,icon:"dku-icon-sentiment-20 universe-color recipe-nlp"},{name:"Emotion analysis",desc:"Analyze emotions in a text",inputDatasetRequired:false,action:newEmotionAnalysis,icon:"dku-icon-heart-fill-20 universe-color recipe-nlp"},{name:"Other classification task",desc:"Perform a specific task with model-defined classes, using a fine-tuned model",inputDatasetRequired:false,action:newBuiltinClassesClassification,icon:"dku-icon-llm-text-classification-other-20 universe-color recipe-nlp"}]};const userDefined={displayName:"User-specified classes",desc:"Provide the classes to use for a text classification task",useCases:[{name:"LLM classification",desc:"Classify text with a LLM using classes you specify, optionally provide a few examples to help the model. Labeled dataset is not required",inputDatasetRequired:false,action:newCustomClassesClassification,icon:"dku-icon-edit-note-20 universe-color recipe-nlp"},{name:"AutoML Prediction",desc:"Train a classification model based on many labeled rows. Labeled dataset is required",inputDatasetRequired:true,action:newPrediction,icon:"dku-icon-automl-prediction-20 universe-color analysis"}]};$scope.textClassificationTypes=[modelDefined,userDefined];$scope.getUseCaseDisabledMessage=function(useCase){if(useCase.inputDatasetRequired&&!$scope.recipePresets.preselectedInput){return"Requires an input dataset"}return""};function copyToRecipeScope(recipePresets,modalScope){modalScope.zone=recipePresets.zone;modalScope.initialPayload=recipePresets.initialPayload;if(recipePresets.preselectedInput){modalScope.io.inputDataset=recipePresets.preselectedInput}}function newSentimentAnalysis(){CreateModalFromTemplate("/templates/recipes/nlp-based-recipe-creation.html",$scope.$parent,"NLPLLMModelProvidedClassificationRecipeCreationController",function(modalScope){$scope.recipePresets.initialPayload={task:"SENTIMENT_ANALYSIS",outputMode:"FIRST"};copyToRecipeScope($scope.recipePresets,modalScope)})}function newEmotionAnalysis(){CreateModalFromTemplate("/templates/recipes/nlp-based-recipe-creation.html",$scope.$parent,"NLPLLMModelProvidedClassificationRecipeCreationController",function(modalScope){$scope.recipePresets.initialPayload={task:"EMOTION_ANALYSIS",outputMode:"FIRST"};copyToRecipeScope($scope.recipePresets,modalScope)})}function newCustomClassesClassification(){CreateModalFromTemplate("/templates/recipes/nlp-based-recipe-creation.html",$scope.$parent,"NLPLLMUserProvidedClassificationRecipeCreationController",function(modalScope){copyToRecipeScope($scope.recipePresets,modalScope)})}function newBuiltinClassesClassification(){CreateModalFromTemplate("/templates/recipes/nlp-based-recipe-creation.html",$scope.$parent,"NLPLLMModelProvidedClassificationRecipeCreationController",function(modalScope){$scope.recipePresets.initialPayload={task:"OTHER",outputMode:"FIRST"};copyToRecipeScope($scope.recipePresets,modalScope)})}function newPrediction(){$scope.predictionTaskData={};$scope.datasetSmartName=$scope.recipePresets.preselectedInput;let backends;DataikuAPI.analysis.mlcommon.listBackends($stateParams.projectKey,$scope.datasetSmartName,"").then(function({data}){backends=data;const loc=DatasetUtils.getLocFromSmart($stateParams.projectKey,$scope.datasetSmartName);return DataikuAPI.datasets.get(loc.projectKey,loc.name,$stateParams.projectKey)}).then(function({data}){$scope.possibleColumns=data.schema.columns.map(it=>it.name);return CachedAPICalls.pmlGuessPolicies}).then(pmlGuessPolicies=>displayNewPredictionModal(pmlGuessPolicies,backends)).catch(setErrorInScope.bind($scope))}function displayNewPredictionModal(policies,backends){$scope.predictionTaskData.guessPolicies=policies;DatasetLabUtils.prepareGuessPolicies($scope.predictionTaskData,backends);const policyGroup="auto";DatasetLabUtils.updateTaskWithDefaultPolicy($scope.predictionTaskData,policyGroup,$scope.datasetSmartName);CreateModalFromTemplate("/templates/datasets/create-prediction-modal.html",$scope,"NewPMLTaskModalController",modalScope=>{modalScope.useCurrentAnalysisForNewMlTask=false;modalScope.selectPolicy=function(taskData,policy){DatasetLabUtils.updateTaskWithNewPolicy(taskData,policy,$scope.datasetSmartName)};modalScope.policyGroup=policyGroup})}});app.controller("NLPLLMUserProvidedClassificationRecipeCreationController",function($scope,$stateParams,$controller,DataikuAPI,RecipesUtils,RecipeDescService,RecipeComputablesService,PromptUtils){$scope.recipeType="nlp_llm_user_provided_classification";$controller("SingleOutputDatasetRecipeCreationController",{$scope:$scope});$scope.showOutputPane=_=>!!$scope.io.inputDataset;$scope.autosetName=function(){if($scope.io.inputDataset){const niceInputName=$scope.io.inputDataset.replace(/[A-Z]*\./,"");$scope.maybeSetNewDatasetName(niceInputName+"_classified")}};$scope.getCreationSettings=function(){const inputs=[];if($scope.io.inputDataset){inputs.push($scope.io.inputDataset)}const creationSettings={virtualInputs:inputs};if($scope.initialPayload){creationSettings.initialPayload=$scope.initialPayload}return creationSettings};addDatasetUniquenessCheck($scope,DataikuAPI,$stateParams.projectKey);fetchManagedDatasetConnections($scope,DataikuAPI)});app.controller("NLPLLMUserProvidedClassificationRecipeEditor",function($scope,$controller,$state,$stateParams,DataikuAPI,CreateModalFromTemplate){$controller("_NLPLLMRecipeControllerBase",{$scope:$scope});$scope.loadLLMs("CLASSIFICATION_WITH_USER_PROVIDED_CLASSES");$scope.openConvertToPromptModal=function(){if(!$scope.recipe||!$scope.recipe.name)return;$scope.saveRecipe().then(function(){CreateModalFromTemplate("/templates/recipes/nlp/convert-to-prompt-recipe.html",$scope,"NLPRecipeConvertToPromptRecipeModal",function(modalScope){})})}});app.controller("NLPLLMModelProvidedClassificationRecipeCreationController",function($scope,$stateParams,$controller,DataikuAPI,RecipesUtils,RecipeDescService,RecipeComputablesService,PromptUtils){$scope.recipeType="nlp_llm_model_provided_classification";$controller("SingleOutputDatasetRecipeCreationController",{$scope:$scope});$scope.showOutputPane=_=>!!$scope.io.inputDataset;$scope.autosetName=function(){if($scope.io.inputDataset){const niceInputName=$scope.io.inputDataset.replace(/[A-Z]*\./,"");$scope.maybeSetNewDatasetName(niceInputName+"_classified")}};$scope.getCreationSettings=function(){const inputs=[];if($scope.io.inputDataset){inputs.push($scope.io.inputDataset)}const creationSettings={virtualInputs:inputs};if($scope.initialPayload){creationSettings.initialPayload=$scope.initialPayload}return creationSettings};addDatasetUniquenessCheck($scope,DataikuAPI,$stateParams.projectKey);fetchManagedDatasetConnections($scope,DataikuAPI)});app.controller("NLPLLMModelProvidedClassificationRecipeEditor",function($scope,$controller,$state,$stateParams,DataikuAPI,CreateModalFromTemplate){$controller("_NLPLLMRecipeControllerBase",{$scope:$scope});$scope.taskOptions=[["SENTIMENT_ANALYSIS","Sentiment analysis (+/=/-)"],["EMOTION_ANALYSIS","Emotion analysis"],["OTHER","Other"]];const deregister=$scope.$watch("desc",function(){if(!$scope.desc)return;$scope.onTaskChange();deregister()});const genericOutputModes=[{label:"Output the most likely class",value:"FIRST"},{label:"Output all the classes",value:"ALL"}];const emotionAnalysisOutputModes=[{label:"Output the most likely class",value:"FIRST"},{label:"Output the top most likely classes",value:"MOST_RELEVANT"},{label:"Output all the classes",value:"ALL"}];$scope.onTaskChange=function(){if(!$scope.desc)return;switch($scope.desc.task){case"SENTIMENT_ANALYSIS":$scope.loadLLMs("SENTIMENT_ANALYSIS");if($scope.desc.outputMode==="MOST_RELEVANT"){$scope.desc.outputMode="FIRST"}$scope.outputModes=genericOutputModes;break;case"EMOTION_ANALYSIS":$scope.loadLLMs("EMOTION_ANALYSIS");$scope.outputModes=emotionAnalysisOutputModes;break;case"OTHER":$scope.loadLLMs("CLASSIFICATION_WITH_OTHER_MODEL_PROVIDED_CLASSES");if($scope.desc.outputMode==="MOST_RELEVANT"){$scope.desc.outputMode="FIRST"}$scope.outputModes=genericOutputModes;break}};$scope.openConvertToPromptModal=function(){if(!$scope.recipe||!$scope.recipe.name)return;$scope.saveRecipe().then(function(){CreateModalFromTemplate("/templates/recipes/nlp/convert-to-prompt-recipe.html",$scope,"NLPRecipeConvertToPromptRecipeModal",function(modalScope){})})}})})();(function(){"use strict";const app=angular.module("dataiku.recipes");app.controller("NLPLLMSummarizationRecipeCreationController",function($scope,$stateParams,$controller,DataikuAPI,RecipesUtils,RecipeDescService,RecipeComputablesService,PromptUtils){$scope.recipeType="nlp_llm_summarization";$controller("SingleOutputDatasetRecipeCreationController",{$scope:$scope});$scope.showOutputPane=_=>!!$scope.io.inputDataset;$scope.autosetName=function(){if($scope.io.inputDataset){const niceInputName=$scope.io.inputDataset.replace(/[A-Z]*\./,"");$scope.maybeSetNewDatasetName(niceInputName+"_summarized")}};$scope.getCreationSettings=function(){const inputs=[];if($scope.io.inputDataset){inputs.push($scope.io.inputDataset)}const creationSettings={virtualInputs:inputs};if($scope.initialPayload){creationSettings.initialPayload=$scope.initialPayload}return creationSettings};addDatasetUniquenessCheck($scope,DataikuAPI,$stateParams.projectKey);fetchManagedDatasetConnections($scope,DataikuAPI)});app.controller("NLPLLMSummarizationRecipeEditor",function($scope,$controller,$state,$stateParams,DataikuAPI,CreateModalFromTemplate){$controller("_NLPLLMRecipeControllerBase",{$scope:$scope});$scope.loadLLMs("SUMMARIZATION");$scope.targetLengthUnitOptions=[["WORD","Words"],["SENTENCE","Sentences"]];$scope.openConvertToPromptModal=function(){if(!$scope.recipe||!$scope.recipe.name)return;$scope.saveRecipe().then(function(){CreateModalFromTemplate("/templates/recipes/nlp/convert-to-prompt-recipe.html",$scope,"NLPRecipeConvertToPromptRecipeModal",function(modalScope){})})}})})();(function(){"use strict";const app=angular.module("dataiku.recipes");app.controller("FineTuningRecipeCreationController",function($scope,$stateParams,DataikuAPI,DatasetUtils,$controller,Logger,SmartId){$controller("_RecipeCreationControllerBase",{$scope:$scope});$controller("_RecipeOutputNewManagedBehavior",{$scope:$scope});$scope.recipeType="nlp_llm_finetuning";function makeMainRole(refs){return{main:{items:refs.filter(function(ref){return!!ref}).map(function(ref){return{ref:ref}})}}}$scope.creationSettings={};$scope.doCreateRecipe=function(){const inputs=$scope.recipe&&$scope.recipe.inputs?$scope.recipe.inputs:makeMainRole([$scope.io.inputDataset]);if($scope.io.validationDataset){inputs["validation_dataset"]={items:[{ref:$scope.io.validationDataset}]}}const outputModelName=$scope.creationSettings&&$scope.creationSettings.outputModelName;const recipe={type:$scope.recipeType,projectKey:$stateParams.projectKey,name:"finetune_"+outputModelName,inputs:inputs};const settings=angular.copy($scope.creationSettings);if($scope.zone){settings.zone=$scope.zone}return DataikuAPI.flow.recipes.generic.create(recipe,settings)};$scope.showOutputPane=function(){return!!$scope.io.inputDataset||!!$scope.io.inputFolder};$scope.formIsValid=function(){if(!$scope.inputFolderOnly&&!($scope.io.inputDataset&&$scope.activeSchema&&$scope.activeSchema.columns&&$scope.activeSchema.columns.length)){return false}return!!($scope.creationSettings&&$scope.creationSettings.outputModelName)};let updateInputDatasetSchema=function(){if($scope.availableInputDatasets==null)return;if(!$scope.io.inputDataset)return;let resolvedSmartId=SmartId.resolve($scope.io.inputDataset,contextProjectKey);let availableInput=$scope.availableInputDatasets.filter(o=>o.name==resolvedSmartId.id&&o.projectKey==resolvedSmartId.projectKey)[0];if(availableInput==null||availableInput.type=="DATASET"){DataikuAPI.datasets.get(resolvedSmartId.projectKey,resolvedSmartId.id,contextProjectKey).success(function(data){$scope.activeSchema=data.schema}).error(setErrorInScope.bind($scope))}else if(availableInput.type=="STREAMING_ENDPOINT"){DataikuAPI.streamingEndpoints.get(resolvedSmartId.projectKey,resolvedSmartId.id).success(function(data){$scope.activeSchema=data.schema}).error(setErrorInScope.bind($scope))}else{$scope.activeSchema={columns:[]}}};const inputsIndex={};DatasetUtils.listDatasetsUsabilityInAndOut($stateParams.projectKey,$scope.recipeType,$scope.datasetsOnly).then(function(data){$scope.availableInputDatasets=data[0];if($scope.filterUsableInputsOn){$scope.availableInputDatasets.forEach(function(c){let usability=c.usableAsInput[$scope.filterUsableInputsOn]||{};c.usable=usability.usable;c.usableReason=usability.reason})}else if($scope.inputDatasetsOnly){$scope.availableInputDatasets=data[0].filter(function(computable){return computable.usableAsInput["main"]&&computable.usableAsInput["main"].usable})}$scope.availableOutputDatasets=data[1].filter(function(computable){return computable.usableAsOutput["main"]&&computable.usableAsOutput["main"].usable&&!computable.alreadyUsedAsOutputOf});$scope.availableInputDatasets.forEach(function(it){inputsIndex[it.id]=it});updateInputDatasetSchema()});let contextProjectKey=$scope.context&&$scope.context.projectKey?$scope.context.projectKey:$stateParams.projectKey;$scope.$on("preselectInputDataset",function(scope,preselectedInputDataset){$scope.io.inputDataset=preselectedInputDataset;$scope.preselectedInputDataset=preselectedInputDataset});$scope.$watch("io.inputDataset",function(nv){if(!nv)return;if($scope.preselectedInputDataset&&$scope.io.inputDataset!=$scope.preselectedInputDataset){$scope.zone=null}updateInputDatasetSchema()})});app.controller("FineTuningRecipeEditionController",function($scope,$controller,$timeout,DataikuAPI,FinetuningUtilsService){$controller("_NLPLLMRecipeControllerBase",{$scope:$scope});$scope.loadLLMs("FINE_TUNING");$scope.onFineTuningLLMChange=()=>{$scope.onLLMChange();if(!$scope.isLlmCompatibleWithSystemMessage()&&!$scope.desc.systemMessageMode){$scope.desc.systemMessageMode="NONE"}};$scope.isLlmCompatibleWithSystemMessage=llmId=>{const llmRef=$scope.getLLMRef(llmId);if(!llmRef)return false;if(llmRef.type==="HUGGINGFACE_TRANSFORMER_LOCAL"){return true}else{return llmRef.handlesSystemMessage}};$scope.refreshModelDeployments=function(){DataikuAPI.savedmodels.llmGeneric.deployments.list($scope.recipe.projectKey,$scope.recipe.outputs.finetuned_model.items[0].ref).then(function(res){$scope.deployments=res.data}).catch(setErrorInScope.bind($scope))};$timeout(function(){if(!$scope.desc.llmId){angular.element("#fine-tuning__llm-selector + .bootstrap-select").click().addClass("open")}$scope.refreshModelDeployments();DataikuAPI.savedmodels.get($scope.recipe.projectKey,$scope.recipe.outputs.finetuned_model.items[0].ref).then(function(res){$scope.savedModel=res.data}).catch(setErrorInScope.bind($scope))},200);$scope.systemMessageModeOptions=[{name:"No system message",value:"NONE"},{name:"Dynamic",value:"DYNAMIC"},{name:"Static",value:"STATIC"}];$scope.quantizationOptions=[{name:"4 bits",value:"Q_4BIT"},{name:"8 bits",value:"Q_8BIT"},{name:"No quantization",value:"NONE"}];$scope.refreshCheckpointOptions=function(){if($scope.recipe.inputs.validation_dataset&&$scope.recipe.inputs.validation_dataset.items.length>0){$scope.checkpointOptions=[{name:"Keep all evaluation checkpoints",value:"KEEP_ALL_EVAL"},{name:"Keep only the best checkpoint",value:"KEEP_BEST_ONLY"},{name:"Keep only the best and last checkpoints",value:"KEEP_BEST_AND_LAST_ONLY"}]}else{$scope.checkpointOptions=[{name:"Keep all evaluation checkpoints",value:"KEEP_ALL_EVAL"},{name:"Keep only the last checkpoint",value:"KEEP_BEST_ONLY"}]}};$scope.getLLMRef=function(llmId){if(!$scope.availableLLMs||!llmId)return;return $scope.availableLLMs.find(llm=>llm.id==llmId)};$scope.hasHyperparameters=function(llmId){const llmRef=$scope.getLLMRef(llmId);if(!llmRef)return false;return["HUGGINGFACE_TRANSFORMER_LOCAL","SAVED_MODEL_FINETUNED_HUGGINGFACE_TRANSFORMER","BEDROCK","SAVED_MODEL_FINETUNED_BEDROCK","AZURE_OPENAI_MODEL","SAVED_MODEL_FINETUNED_AZURE_OPENAI","OPENAI","SAVED_MODEL_FINETUNED_OPENAI"].includes(llmRef.type)};$scope.supportsModelDeployment=function(){const llmRef=$scope.getLLMRef($scope.desc.llmId);if(!llmRef)return;return FinetuningUtilsService.supportsModelDeployment(llmRef.type)};$scope.getDeletedDeploymentsCountMessage=FinetuningUtilsService.getDeletedDeploymentsCountMessage;$scope.getNewDeploymentMessage=FinetuningUtilsService.getNewDeploymentMessage;$scope.$watch("recipe.outputs.finetuned_model",$scope.refreshModelDeployments);$scope.$watch("recipe.inputs.validation_dataset.items.length",$scope.refreshCheckpointOptions)});app.component("finetuningHyperparametersEditor",{bindings:{hyperparameters:"=",quantizationOptions:"<",checkpointOptions:"<",llmType:"<"},templateUrl:"templates/recipes/fine-tuning/hyperparameters.html",controller:function(){const $ctrl=this;$ctrl.isRemoteFineTuning=function(){return["BEDROCK","SAVED_MODEL_FINETUNED_BEDROCK","AZURE_OPENAI_MODEL","SAVED_MODEL_FINETUNED_AZURE_OPENAI","OPENAI","SAVED_MODEL_FINETUNED_OPENAI"].includes($ctrl.llmType)};$ctrl.$doCheck=()=>{const isCheckpointModeInvalid=!$ctrl.checkpointOptions.map(e=>e.value).includes($ctrl.hyperparameters.localHuggingFace.checkpointMode);if(isCheckpointModeInvalid){$ctrl.hyperparameters.localHuggingFace.checkpointMode="KEEP_BEST_ONLY"}}}})})();(function(){"use strict";const app=angular.module("dataiku.recipes");app.controller("RAGEmbeddingRecipeCreationController",function($scope,Fn,$stateParams,DataikuAPI,$q,Dialogs,DatasetsService,WT1,DatasetUtils,$controller,RecipeComputablesService,Logger,SmartId,RetrievableKnowledgeUtils){$controller("_RecipeCreationControllerBase",{$scope:$scope});$controller("_RecipeOutputNewManagedBehavior",{$scope:$scope});$scope.recipeType="nlp_llm_rag_embedding";function makeMainRole(refs){return{main:{items:refs.filter(function(ref){return!!ref}).map(function(ref){return{ref:ref}})}}}$scope.creationSettings={vectorStoreType:"CHROMA"};$scope.doCreateRecipe=function(){const inputs=$scope.recipe&&$scope.recipe.inputs?$scope.recipe.inputs:makeMainRole([$scope.io.inputDataset]);const recipe={type:"nlp_llm_rag_embedding",projectKey:$stateParams.projectKey,name:"compute_"+$scope.creationSettings.outputRetrievableKnowledgeName,inputs:inputs};const settings=angular.copy($scope.creationSettings);if($scope.zone){settings.zone=$scope.zone}return DataikuAPI.flow.recipes.generic.create(recipe,settings)};$scope.showOutputPane=function(){return!!$scope.io.inputDataset};$scope.formIsValid=function(){const creationSettings=$scope.creationSettings;if(!creationSettings.outputRetrievableKnowledgeName){return false}if(!creationSettings.embeddingLLMId){return false}if(!creationSettings.vectorStoreType){return false}if(RetrievableKnowledgeUtils.hasConnection(creationSettings)&&!creationSettings.connection){return false}if(creationSettings.vectorStoreType==="PINECONE"&&!creationSettings.pineconeIndexName){return false}return true};function updateInputDatasetSchema(){if($scope.availableInputDatasets==null)return;if(!$scope.io.inputDataset)return;let resolvedSmartId=SmartId.resolve($scope.io.inputDataset,contextProjectKey);let availableInput=$scope.availableInputDatasets.filter(o=>o.name==resolvedSmartId.id&&o.projectKey==resolvedSmartId.projectKey)[0];if(availableInput==null||availableInput.type=="DATASET"){DataikuAPI.datasets.get(resolvedSmartId.projectKey,resolvedSmartId.id,contextProjectKey).success(function(data){$scope.activeSchema=data.schema}).error(setErrorInScope.bind($scope))}else if(availableInput.type=="STREAMING_ENDPOINT"){DataikuAPI.streamingEndpoints.get(resolvedSmartId.projectKey,resolvedSmartId.id).success(function(data){$scope.activeSchema=data.schema}).error(setErrorInScope.bind($scope))}else{$scope.activeSchema={columns:[]}}}const inputsIndex={};DatasetUtils.listDatasetsUsabilityInAndOut($stateParams.projectKey,$scope.recipeType,$scope.datasetsOnly).then(function(data){$scope.availableInputDatasets=data[0];if($scope.filterUsableInputsOn){$scope.availableInputDatasets.forEach(function(c){const usability=c.usableAsInput[$scope.filterUsableInputsOn]||{};c.usable=usability.usable;c.usableReason=usability.reason})}else if($scope.inputDatasetsOnly){$scope.availableInputDatasets=data[0].filter(function(computable){return computable.usableAsInput["main"]&&computable.usableAsInput["main"].usable})}$scope.availableInputDatasets.forEach(function(it){inputsIndex[it.id]=it});updateInputDatasetSchema()});DataikuAPI.pretrainedModels.listAvailableLLMs($stateParams.projectKey,"TEXT_EMBEDDING_EXTRACTION").success(function(data){$scope.availableEmbeddingLLMs=data.identifiers;if($scope.availableEmbeddingLLMs.length>0){$scope.creationSettings.embeddingLLMId=data.identifiers[0].id}}).error(setErrorInScope.bind($scope));const contextProjectKey=$scope.context&&$scope.context.projectKey?$scope.context.projectKey:$stateParams.projectKey;$scope.$on("preselectInputDataset",function(scope,preselectedInputDataset){$scope.io.inputDataset=preselectedInputDataset;$scope.preselectedInputDataset=preselectedInputDataset});$scope.$watch("io.inputDataset",function(nv){if(!nv)return;if(!$scope.creationSettings.outputRetrievableKnowledgeName){const niceInputName=nv.replace(/[A-Z]*\./,"");$scope.creationSettings.outputRetrievableKnowledgeName=niceInputName+"_embedded"}if($scope.preselectedInputDataset&&$scope.io.inputDataset!=$scope.preselectedInputDataset){$scope.zone=null}updateInputDatasetSchema()})});app.controller("RAGEmbeddingRecipeEditionController",function($scope,$rootScope,$controller,$stateParams,DataikuAPI,EmbeddingUtils,DOCUMENT_SPLITTING_METHOD_MAP,VECTOR_STORE_UPDATE_METHOD_MAP,VECTOR_STORE_TYPE_MAP,Logger){$controller("_NLPLLMRecipeControllerBase",{$scope:$scope});$scope.loadLLMs("TEXT_EMBEDDING_EXTRACTION");$scope.DOCUMENT_SPLITTING_METHOD_MAP=DOCUMENT_SPLITTING_METHOD_MAP;$scope.VECTOR_STORE_UPDATE_METHOD_MAP=VECTOR_STORE_UPDATE_METHOD_MAP;$scope.VECTOR_STORE_TYPE_MAP=VECTOR_STORE_TYPE_MAP;$scope.$watch("desc",function(newVal){if(newVal&&!newVal.vectorStoreUpdateMethod){$scope.desc.vectorStoreUpdateMethod="OVERWRITE"}});$scope.splitIntoChunksDocRef=$rootScope.versionDocRoot+"preparation/processors/split-into-chunks.html";$scope.setSplittingMethod=function(splitting_method){$scope.desc.documentSplittingMode=splitting_method};$scope.shouldClearKnowledgeBank=function(){if(!$scope.previousDesc||!$scope.previousRk||!$scope.desc.vectorStoreUpdateMethod){return false}const vectorStoreUpdateMethod=$scope.VECTOR_STORE_UPDATE_METHOD_MAP[$scope.desc.vectorStoreUpdateMethod];if(!$scope.previousDesc.vectorStoreUpdateMethod){$scope.previousDesc.vectorStoreUpdateMethod="OVERWRITE"}const prevVectorStoreUpdateMethod=$scope.VECTOR_STORE_UPDATE_METHOD_MAP[$scope.previousDesc.vectorStoreUpdateMethod];const previousMetadataCols=$scope.previousDesc.metadataColumns.map(col=>col.column);for(const col of $scope.desc.metadataColumns){if(col.column&&!previousMetadataCols.includes(col.column)){return true}}if(!prevVectorStoreUpdateMethod.isSmart&&vectorStoreUpdateMethod.isSmart){return true}if($scope.retrievableKnowledge&&prevVectorStoreUpdateMethod.isSmart&&vectorStoreUpdateMethod.isSmart&&$scope.retrievableKnowledge.sourceIdColumn!==$scope.desc.sourceIdColumn){return true}if($scope.previousDesc.knowledgeColumn!==$scope.desc.knowledgeColumn){return true}if($scope.retrievableKnowledge&&vectorStoreUpdateMethod.isSmart&&$scope.retrievableKnowledge.vectorStoreType!==$scope.previousRk.vectorStoreType){return true}if($scope.desc.vectorStoreUpdateMethod!=="OVERWRITE"&&$scope.previousRk.embeddingLLMId!==$scope.retrievableKnowledge.embeddingLLMId){return true}if($scope.previousDesc.documentSplittingMode!==$scope.desc.documentSplittingMode){return true}else if($scope.previousDesc.documentSplittingMode==="CHARACTERS_BASED"){if($scope.previousDesc.chunkSizeCharacters!==$scope.desc.chunkSizeCharacters||$scope.previousDesc.chunkOverlapCharacters!==$scope.desc.chunkOverlapCharacters){return true}}return false};$scope.updateMethodDisabledReason=function(method){if(!$scope.retrievableKnowledge){return""}if(VECTOR_STORE_UPDATE_METHOD_MAP[method].isSmart&&$scope.retrievableKnowledge.vectorStoreType==="PINECONE"){return"Smart update methods not supported for Pinecone"}return""};$scope.$watch("embeddingLLM",function(newVal){$scope.defaultChunkSize=EmbeddingUtils.getChunkSizeCharacters(newVal);$scope.defaultOverlapSize=EmbeddingUtils.getOverlapSizeCharacters(newVal)});const checkRetrievalColumnsValidity=function(retrievalAugmentedLLMs){$scope.retrievalColumnsAlerts=[];if(retrievalAugmentedLLMs&&Array.isArray(retrievalAugmentedLLMs)){for(const retrievalAugmentedLLM of retrievalAugmentedLLMs){const activeSmiv=retrievalAugmentedLLM.inlineVersions.find(smiv=>smiv.versionId===retrievalAugmentedLLM.activeVersion);if(!activeSmiv){Logger.error(`Invalid active Saved Model Inline version: ${retrievalAugmentedLLM.activeVersion}`);continue}const ragllmSettings=activeSmiv.ragllmSettings;if(ragllmSettings.retrievalSource==="EMBEDDING"||ragllmSettings.retrievalColumns.length===0){continue}const metadataColNames=$scope.desc.metadataColumns.map(c=>c.column);for(let retrievalColumn of ragllmSettings.retrievalColumns){if(!metadataColNames.includes(retrievalColumn)){$scope.retrievalColumnsAlerts.push({label:retrievalAugmentedLLM.name,retrievalColumn:retrievalColumn,fullModelId:`S-${$stateParams.projectKey}-${retrievalAugmentedLLM.id}-${retrievalAugmentedLLM.activeVersion}`,smId:retrievalAugmentedLLM.id})}}}}};$scope.$watch("desc.metadataColumns",function(nv){checkRetrievalColumnsValidity($scope.retrievalAugmentedLLMs)},true);$scope.$watchGroup(["recipe.outputs.knowledge_bank","availableLLMs"],function([knowledgeBank,availableLLMs]){if(!knowledgeBank||!availableLLMs)return;const ref=(knowledgeBank.items||[{}])[0].ref;if(!ref)return;DataikuAPI.retrievableknowledge.get($stateParams.projectKey,ref).success(retrievableKnowledge=>{$scope.retrievableKnowledge=retrievableKnowledge;$scope.origRetrievableKnowledge=JSON.parse(JSON.stringify(retrievableKnowledge));$scope.embeddingLLM=availableLLMs.find(llm=>llm.id===retrievableKnowledge.embeddingLLMId);DataikuAPI.retrievableknowledge.getCurrentVersionInfo($stateParams.projectKey,$scope.retrievableKnowledge.id).then(function({data}){$scope.previousDesc=data.embeddingRecipeParams;$scope.previousRk=data.rkAtVersion;$scope.isRkBuilt=data.isBuilt}).catch(setErrorInScope.bind($scope));DataikuAPI.retrievableknowledge.getRetrievalAugmentedLLMList($stateParams.projectKey,$scope.retrievableKnowledge.id).success(function(data){$scope.retrievalAugmentedLLMs=data;checkRetrievalColumnsValidity($scope.retrievalAugmentedLLMs)}).error(setErrorInScope.bind($scope))})});$scope.RESET_VALUE="None - no column selected";$scope.getInputDatasetColumnsWithEmpty=function(){if(!$scope.inputDatasetColumns){return[]}let columns=angular.copy($scope.inputDatasetColumns);columns.unshift($scope.RESET_VALUE);return columns};$scope.securityTokensColumnSelectionChanged=function(){if($scope.desc.securityTokensColumn==$scope.RESET_VALUE){$scope.desc.securityTokensColumn=undefined}};const recipePayloadSave=$scope.hooks.save;$scope.hooks.save=function(){return recipePayloadSave().then(()=>{let sourceIdColumn=undefined;if($scope.VECTOR_STORE_UPDATE_METHOD_MAP[$scope.desc.vectorStoreUpdateMethod].isSmart){sourceIdColumn=$scope.desc.sourceIdColumn}if($scope.retrievableKnowledge&&$scope.retrievableKnowledge.sourceIdColumn!==sourceIdColumn){$scope.retrievableKnowledge.sourceIdColumn=sourceIdColumn;DataikuAPI.retrievableknowledge.save($scope.retrievableKnowledge).error(setErrorInScope.bind($scope))}})}});app.service("EmbeddingUtils",function(){const fallbackChunkSizeCharacters=3e3;const fallbackOverlapSizeCharacters=120;function tokensToCharsOrDefault(embeddingLLM){if(!embeddingLLM||!embeddingLLM.maxTokensLimit)return fallbackChunkSizeCharacters;return Math.round(embeddingLLM.maxTokensLimit*3/100)*100}function getChunkSizeCharacters(embeddingLLM){return Math.min(fallbackChunkSizeCharacters,tokensToCharsOrDefault(embeddingLLM))}function getOverlapSizeCharacters(embeddingLLM){if(!embeddingLLM||!embeddingLLM.maxTokensLimit){return fallbackOverlapSizeCharacters}return Math.min(fallbackOverlapSizeCharacters,Math.round(.2*getChunkSizeCharacters(embeddingLLM)))}function shouldWarnAboutChunkSize(embeddingLLM,documentSplittingMode,chunkSizeCharacters){if(documentSplittingMode!=="CHARACTERS_BASED")return false;return chunkSizeCharacters>tokensToCharsOrDefault(embeddingLLM)}return{tokensToCharsOrDefault:tokensToCharsOrDefault,shouldWarnAboutChunkSize:shouldWarnAboutChunkSize,getChunkSizeCharacters:getChunkSizeCharacters,getOverlapSizeCharacters:getOverlapSizeCharacters}})})();(function(){"use strict";const app=angular.module("dataiku.recipes");app.service("LLMEvaluationMetrics",function(){const svc={};svc.metrics=[{label:"Answer relevancy",name:"answerRelevancy",shortDescription:"Focuses on assessing how pertinent the generated answer is to the given prompt. This metric is computed using the question, the context and the answer. It requires an embedding LLM and a completion LLM.",selectable:true},{label:"Multimodal relevancy",name:"multimodalRelevancy",shortDescription:"Measures the relevance of the generated answer against both visual and textual context. The metric is computed using the question, the context and the answer. It requires an embedding LLM and a completion LLM.",promptRecipeFormatNeeded:true,selectable:true},{label:"Answer correctness",name:"answerCorrectness",shortDescription:"Measures the accuracy of the answer compared to the ground truth. This metric is computed using the ground truth and the answer. It requires an embedding LLM and a completion LLM.",selectable:true},{label:"Answer similarity",name:"answerSimilarity",shortDescription:"Assesses the semantic resemblance between the generated answer and the ground truth. The metric is computed using the ground truth and the answer. It requires an embedding LLM and a completion LLM.",selectable:true},{label:"Context recall",name:"contextRecall",shortDescription:"Measures the extent to which the retrieved context aligns with the ground truth. The metric is computed using the ground truth and the context. It requires an embedding LLM and a completion LLM.",selectable:true},{label:"Context precision",name:"contextPrecision",shortDescription:"Evaluates that the facts present in the context are ranked first by the ones most relevant to the ground-truth. This metric is computed using the question, ground truth and the context. It requires an embedding LLM and a completion LLM.",selectable:true},{label:"Faithfulness",name:"faithfulness",shortDescription:"Measures the factual consistency of the generated answer against the given context. The metric is computed using the answer and retrieved context. It requires an embedding LLM and a completion LLM.",selectable:true},{label:"Multimodal faithfulness",name:"multimodalFaithfulness",shortDescription:"Measures the factual consistency of the generated answer against both visual and textual context. The metric is computed using the answer and the retrieved context. It requires an embedding LLM and a completion LLM.",promptRecipeFormatNeeded:true,selectable:true},{label:"BERT Score",name:"bertScore",shortDescription:"Computes the similarity of answer and ground truth(s) using their tokens' embeddings. The metric is computed using the answer and the ground truth.",selectable:true},{label:"ROUGE",name:"rouge",shortDescription:"Measures the recall of word n-grams and longest common sequences for text summarization tasks. The metric is computed using the generated summary and a reference summary.",selectable:true},{label:"BLEU",name:"bleu",shortDescription:"Measures the precision of word n-grams between generated and reference texts for machine translation tasks. The metric is computed using the generated translation and a reference translation.",selectable:true},{label:"Average Input tokens",name:"inputTokensPerRow",shortDescription:"The number of tokens that were ingested by the LLM.",labelRowByRow:"Input Tokens",globalDescription:"The number of tokens that were ingested by the LLM. Average per row.",selectable:false},{label:"Average Output tokens",name:"outputTokensPerRow",shortDescription:"The number of tokens that were generated by the LLM.",labelRowByRow:"Output Tokens",globalDescription:"The number of tokens that were generated by the LLM. Average per row.",selectable:false},{label:"Sample row count",name:"sampleRowCount",shortDescription:"Total number of rows in the sample. May differ from the number of rows used for metric evaluation as some metrics require specific fields that might be missing in certain rows.",labelRowByRow:"Sample row count",nameRowByRow:"sampleRowCount",globalDescription:"Total number of rows in the sample. May differ from the number of rows used for metric evaluation as some metrics require specific fields that might be missing in certain rows.",selectable:false}];svc.nameByMetricCode={ANSWER_RELEVANCY:"answerRelevancy",ANSWER_CORRECTNESS:"answerCorrectness",ANSWER_SIMILARITY:"answerSimilarity",CONTEXT_RECALL:"contextRecall",CONTEXT_PRECISION:"contextPrecision",FAITHFULNESS:"faithfulness",MULTIMODAL_FAITHFULNESS:"multimodalFaithfulness",MULTIMODAL_RELEVANCY:"multimodalRelevancy",BERT_SCORE_PRECISION:"bertScore",BERT_SCORE_RECALL:"bertScore",BERT_SCORE_F1:"bertScore",BLEU:"bleu",ROUGE_1_PRECISION:"rouge",ROUGE_1_RECALL:"rouge",ROUGE_1_F1:"rouge",ROUGE_2_PRECISION:"rouge",ROUGE_2_RECALL:"rouge",ROUGE_2_F1:"rouge",ROUGE_L_PRECISION:"rouge",ROUGE_L_RECALL:"rouge",ROUGE_L_F1:"rouge",INPUT_TOKENS_PER_ROW:"inputTokensPerRow",OUTPUT_TOKENS_PER_ROW:"outputTokensPerRow",SAMPLE_ROW_COUNT:"sampleRowCount"};svc.computableMetrics=Object.keys(svc.nameByMetricCode);svc.llmTaskTypes=[{type:"QUESTION_ANSWERING",fullName:"Question Answering",shortName:"question answering"},{type:"SUMMARIZATION",fullName:"Summarization",shortName:"summarization"},{type:"TRANSLATION",fullName:"Translation",shortName:"translation"},{type:"OTHER_LLM_TASK",fullName:"Other LLM Evaluation Task",shortName:"other llm"}];svc.llmModelTaskTypes=[{type:"LLM",fullName:"Large Language Model",shortName:"LLM"}];svc.metricsPerTaskType={QUESTION_ANSWERING:["answerRelevancy","answerCorrectness","answerSimilarity","contextRecall","contextPrecision","faithfulness","bertScore"],SUMMARIZATION:["bertScore","rouge","answerSimilarity"],TRANSLATION:["bertScore","bleu","answerSimilarity"],OTHER_LLM_TASK:["bertScore"]};svc.fieldsNeededPerMetric={answerRelevancy:["input","output","context","embeddingLLM","completionLLM"],answerCorrectness:["input","output","groundTruth","embeddingLLM","completionLLM"],answerSimilarity:["input","output","groundTruth","embeddingLLM","completionLLM"],contextRecall:["input","groundTruth","context","embeddingLLM","completionLLM"],contextPrecision:["input","groundTruth","context","embeddingLLM","completionLLM"],faithfulness:["input","output","context","embeddingLLM","completionLLM"],multimodalFaithfulness:["input","output","context","embeddingLLM","completionLLM"],multimodalRelevancy:["input","output","context","embeddingLLM","completionLLM"],bertScore:["output","groundTruth"],bleu:["output","groundTruth"],rouge:["output","groundTruth"]};svc.isRecommendedMetric=function(metric,taskType){if(!Object.keys(svc.metricsPerTaskType).includes(taskType))return false;return svc.metricsPerTaskType[taskType].includes(metric)};svc.getPotentialWarningForMetricComputation=function(metric,packagesWarning,hasInput,hasOutput,hasGroundTruth,hasContext,hasEmbeddingLLM,hasCompletionLLM){if(!Object.keys(svc.fieldsNeededPerMetric).includes(metric)){return""}if(svc.fieldsNeededPerMetric[metric].includes("input")&&!hasInput){return"Requires an Input column"}if(svc.fieldsNeededPerMetric[metric].includes("output")&&!hasOutput){return"Requires an Output column"}if(svc.fieldsNeededPerMetric[metric].includes("groundTruth")&&!hasGroundTruth){return"Requires a Ground truth column"}if(svc.fieldsNeededPerMetric[metric].includes("context")&&!hasContext){return"Requires a Context column"}if(svc.fieldsNeededPerMetric[metric].includes("embeddingLLM")&&!hasEmbeddingLLM){return"Requires an Embedding LLM"}if(svc.fieldsNeededPerMetric[metric].includes("completionLLM")&&!hasCompletionLLM){return"Requires a Completion LLM"}else{return""}};svc.getMetricByCode=function(metricCode){const name=svc.nameByMetricCode[metricCode];if(!name){return undefined}return svc.metrics.find(m=>m.name===name)};svc.inputFormats=[{type:"PROMPT_RECIPE",fullName:"Prompt Recipe",shortName:"prompt recipe"},{type:"DATAIKU_ANSWERS",fullName:"Dataiku Answers",shortName:"dataiku answers"},{type:"CUSTOM",fullName:"Custom",shortName:"custom"}];return svc});app.controller("LLMEvaluationRecipeCreationController",function($scope,$controller){$controller("GenAIBaseEvaluationRecipeCreationController",{$scope:$scope,evaluatedType:"llm"})});app.controller("LLMEvaluationRecipeEditorController",function($scope,$controller,LLMEvaluationMetrics,WT1,DataikuAPI,ActiveProjectKey,FutureProgressModal,StringUtils){$controller("GenAIBaseEvaluationRecipeEditorController",{$scope:$scope,evaluatedType:"llm"});$scope.inputFormats=LLMEvaluationMetrics.inputFormats;$scope.saveColumnNames=function(){if($scope.desc.inputColumnName!==$scope.NO_COLUMN_SELECTED){$scope.savedInputColumnName=$scope.desc.inputColumnName}if($scope.desc.outputColumnName!==$scope.NO_COLUMN_SELECTED){$scope.savedOutputColumnName=$scope.desc.outputColumnName}if($scope.desc.contextColumnName!==$scope.NO_COLUMN_SELECTED){$scope.savedContextColumnName=$scope.desc.contextColumnName}};$scope.restoreColumnNames=function(){if($scope.savedInputColumnName!==undefined){$scope.desc.inputColumnName=$scope.savedInputColumnName;$scope.savedInputColumnName=undefined}if($scope.savedOutputColumnName!==undefined){$scope.desc.outputColumnName=$scope.savedOutputColumnName;$scope.savedOutputColumnName=undefined}if($scope.savedContextColumnName!==undefined){$scope.desc.contextColumnName=$scope.savedContextColumnName;$scope.savedContextColumnName=undefined}};$scope.$watch("desc.inputFormat",(nv,ov)=>{if(nv==="PROMPT_RECIPE"){if(ov!=="DATAIKU_ANSWERS"){$scope.saveColumnNames()}$scope.desc.inputColumnName="llm_raw_query";$scope.desc.outputColumnName="llm_raw_response";$scope.desc.contextColumnName="llm_raw_response"}else if(nv==="DATAIKU_ANSWERS"){if(ov!=="PROMPT_RECIPE"){$scope.saveColumnNames()}$scope.desc.inputColumnName="question";$scope.desc.outputColumnName="answer";$scope.desc.contextColumnName="sources"}else{$scope.restoreColumnNames()}$scope.updateMissingColumnsWarning(nv);$scope.updateContextWarning()});$scope.onInit=function(){$scope.filteredMetrics=getFilteredMetrics()};$scope.llmTaskTypes=LLMEvaluationMetrics.llmTaskTypes;const llmTaskTypeHelpers={QUESTION_ANSWERING:{inputColumn:"Question asked to the model",outputColumn:"Answer provided by the model (optional)",groundTruthColumn:"Reference answer (optional)",contextColumn:"Context(s) provided to the model (optional)"},SUMMARIZATION:{inputColumn:"Text to summarize",outputColumn:"Summary provided by the model (optional)",groundTruthColumn:"Reference summary (optional)",contextColumn:"Context(s) provided to the model (optional)"},TRANSLATION:{inputColumn:"Text to translate",outputColumn:"Translation provided by the model (optional)",groundTruthColumn:"Reference translation (optional)",contextColumn:"Context(s) provided to the model (optional)"},OTHER_LLM_TASK:{inputColumn:"",outputColumn:"Optional",groundTruthColumn:"Optional",contextColumn:"Optional"}};$scope.getTaskTypeHelper=function(column){if(!$scope.desc.llmTaskType)return"";return llmTaskTypeHelpers[$scope.desc.llmTaskType][column]};$scope.canUseContext=function(){return $scope.desc.llmTaskType!=="TRANSLATION"&&$scope.desc.llmTaskType!=="SUMMARIZATION"};$scope.shouldDisplayContext=function(){return $scope.canUseContext()&&!["PROMPT_RECIPE","DATAIKU_ANSWERS"].includes($scope.desc.inputFormat)};$scope.filteredMetrics=[];$scope.fieldsNeeded=LLMEvaluationMetrics.fieldsNeededPerMetric;$scope.$watch("desc.llmTaskType",(nv,ov)=>{if(!$scope.canUseContext()){if($scope.desc.contextColumnName!==$scope.NO_COLUMN_SELECTED){$scope.savedContextColumnName=$scope.desc.contextColumnName}$scope.desc.contextColumnName=$scope.NO_COLUMN_SELECTED}else if($scope.savedContextColumnName!==undefined){$scope.desc.contextColumnName=$scope.savedContextColumnName;$scope.savedContextColumnName=undefined}$scope.filteredMetrics=getFilteredMetrics()});$scope.$watch("desc.inputFormat",()=>{if($scope.desc.inputFormat){$scope.filteredMetrics=getFilteredMetrics()}});function getTaskTypeFullName(){if($scope.desc.llmTaskType){const llmTaskType=$scope.llmTaskTypes.find(t=>t.type==$scope.desc.llmTaskType);if(llmTaskType){return llmTaskType.fullName}}return null}$scope.getRecommendedForHelper=function(){const taskTypeFullName=getTaskTypeFullName();if(taskTypeFullName){return`(recommended for ${taskTypeFullName})`}else{return"(recommended)"}};function getFilteredMetrics(){return LLMEvaluationMetrics.metrics.filter(possibleMetric=>possibleMetric.selectable).filter(possibleMetric=>possibleMetric.promptRecipeFormatNeeded?$scope.desc.inputFormat==="PROMPT_RECIPE":true).map(possibleMetric=>{if($scope.desc.metrics.includes(possibleMetric.name)){return{...possibleMetric,$selected:true}}else{return{...possibleMetric,$selected:false}}})}$scope.updateFilteredMetricsSelection=function(){$scope.desc.metrics=$scope.filteredMetrics.filter(m=>m.$selected).map(m=>m.name);$scope.updateContextWarning()};$scope.isRecommendedMetric=function(metric){return LLMEvaluationMetrics.isRecommendedMetric(metric,$scope.desc.llmTaskType)};$scope.selectOnlyComputableMetrics=function(){$scope.filteredMetrics.forEach(metric=>metric.$selected=$scope.isRecommendedMetric(metric.name)&&!$scope.getPotentialWarningForMetricComputation(true,metric.name));$scope.updateFilteredMetricsSelection()};$scope.canRecommendMetrics=function(){return $scope.desc.llmTaskType!==null&&$scope.desc.llmTaskType!==undefined};$scope.getPotentialWarningForMetricComputation=function(isSelected,metric){if(!isSelected){return""}const hasInput=!!$scope.desc.inputColumnName&&$scope.desc.inputColumnName!==$scope.NO_COLUMN_SELECTED;const hasOutput=!!$scope.desc.outputColumnName&&$scope.desc.outputColumnName!==$scope.NO_COLUMN_SELECTED;const hasGroundTruth=!!$scope.desc.groundTruthColumnName&&$scope.desc.groundTruthColumnName!==$scope.NO_COLUMN_SELECTED;const hasContext=!!$scope.desc.contextColumnName&&$scope.desc.contextColumnName!==$scope.NO_COLUMN_SELECTED;const hasEmbeddingLLM=!!$scope.desc.embeddingLLMId&&$scope.desc.embeddingLLMId!==$scope.NO_LLM_SELECTED.id;const hasCompletionLLM=!!$scope.desc.completionLLMId&&$scope.desc.completionLLMId!==$scope.NO_LLM_SELECTED.id;return LLMEvaluationMetrics.getPotentialWarningForMetricComputation(metric,$scope.codeEnvWarning.reason,hasInput,hasOutput,hasGroundTruth,hasContext,hasEmbeddingLLM,hasCompletionLLM)};$scope.contextWarning="";$scope.updateContextWarning=function(){const needsContext=$scope.desc.metrics.some(m=>(LLMEvaluationMetrics.fieldsNeededPerMetric[m]||[]).includes("context"));if(needsContext&&$scope.desc.inputFormat==="PROMPT_RECIPE"){$scope.contextWarning='Context-based metrics require that the prompt recipe used a Retrieval-augmented LLM with "Source output format" set to "Separated"'}else if(needsContext&&$scope.desc.inputFormat==="DATAIKU_ANSWERS"){$scope.contextWarning="Context-based metrics require that Dataiku Answers' \"Retrieval Method\" was set to 'Use knowledge bank retrieval'"}else{$scope.contextWarning=""}};$scope.getContextColumnNeededIcon=function(metricName){if(["multimodalFaithfulness","multimodalRelevancy"].includes(metricName)){return"dku-icon-image-16 dibvat"}else{return"dku-icon-data-text-16 dibvat"}};$scope.getContextColumnNeededTooltip=function(metricName){if(["multimodalFaithfulness","multimodalRelevancy"].includes(metricName)){return"The context must be multimodal"}else{return"The context must be textual only"}};const customMetricDefaultCode=`def evaluate(input_df, recipe_params, interpreted_columns, **kwargs):
    """
    Custom score function.
    Must return a float representing the metric value over the whole sample, and 
    optionally an array of shape (nb_records,) with the row-by-row values
    - input_df is the Input dataset of the LLM evaluation recipe, as a Pandas DataFrame
    - recipe_params is an object with the LLM evaluation recipe parameters:
        - input_column_name: Name of the Input column as a string
        - output_column_name (may be None): Name of the Output column as a string
        - ground_truth_column_name (may be None): Name of the Ground truth column as 
          a string
        - context_column_name (may be None): Name of the Context column as a string
        - embedding_llm (may be None): A DKUEmbeddings object, to be used to query 
          the LLM mesh to embed the inputs
        - completion_llm (may be None): A DKULLM object, to be used to query the 
          LLM mesh with an eventual prompt
    - interpreted_columns are the input columns as they were used by the recipe,
      including some eventual pre-treatment, notably for the prompt recipe and dataiku
      answers cases. Formatted as Pandas Dataseries.
      If no pre-treatment happened, their content is the same as in the input_df
        - input : for Prompt recipe, this is a concatenation of all the prompt messages
        - output : for Prompt recipe, only the text, extracted from the json
        - ground_truth 
        - context : for Prompt recipe and Dataiku Answers, only the excerpt, extracted
          from the json
    """
    return 0.5, [optionally, one, value, per, row]`;$scope.getNewMetricTemplate=function(){if(!$scope.desc.customMetrics){$scope.desc.customMetrics=[]}const name=StringUtils.transmogrify("Custom Metric #"+($scope.desc.customMetrics.length+1).toString(),$scope.desc.customMetrics.map(a=>a.name),function(i){return"Custom Metric #"+(i+1).toString()});const template={name:name,metricCode:customMetricDefaultCode,description:"",greaterIsBetter:true,minValue:0,maxValue:1,type:"LLM",$foldableOpen:true};return template};$scope.snippetCategory="py-llm-custom-metric";$scope.addNewCustomMetric=function(){if(!$scope.desc.customMetrics){$scope.desc.customMetrics=[]}$scope.desc.customMetrics.push($scope.getNewMetricTemplate())};$scope.testCustomMetricResults={};$scope.testCustomMetric=function(customMetricIndex){const mainInput=$scope.recipe.inputs.main.items[0];const serialisedInputDataset=!!mainInput?$scope.computablesMap[mainInput.ref]:undefined;return DataikuAPI.flow.recipes.testCustomMetric(ActiveProjectKey.get(),$scope.recipe,$scope.desc,customMetricIndex,serialisedInputDataset).then(({data})=>{return FutureProgressModal.show($scope,data,"Testing")}).then(customMetricResult=>{$scope.testCustomMetricResults[customMetricIndex]=customMetricResult}).catch(setErrorInScope.bind($scope))};$scope.fireCustomMetricAddedWT1Event=function(){WT1.event("clicked-item",{"item-id":"llm-evaluation-add-custom-metric"})};$scope.fireCustomMetricRemovedWT1Event=function(){WT1.event("clicked-item",{"item-id":"llm-evaluation-remove-custom-metric"})};$scope.toggleFoldable=function(index){if($scope.desc.customMetrics[index]){$scope.desc.customMetrics[index].$foldableOpen=!$scope.desc.customMetrics[index].$foldableOpen}}});app.filter("sortLLMEvalMetrics",function(LLMEvaluationMetrics){return function(input,llmTaskType){if(!angular.isArray(input))return input;input.sort(function(a,b){const aIsRecommended=LLMEvaluationMetrics.isRecommendedMetric(a.name,llmTaskType);const bIsRecommended=LLMEvaluationMetrics.isRecommendedMetric(b.name,llmTaskType);if(aIsRecommended!=bIsRecommended){return(bIsRecommended&1)-(aIsRecommended&1)}else{return a.name.localeCompare(b.name)}});return input}})})();(function(){"use strict";const app=angular.module("dataiku.recipes");app.service("AgentEvaluationMetrics",function(){const svc={};svc.metrics=[{label:"Average number of tool calls",name:"averageToolExecutionsPerRow",shortDescription:"The number of tool calls made by the Agent.",labelRowByRow:"Average number of tool calls",nameRowByRow:"totalToolExecutions",globalDescription:"The number of tool calls made by the Agent. Average over all rows.",selectable:false,excludedFromSelectAll:false},{label:"Average number of failed tool calls",name:"averageFailedToolExecutionsPerRow",shortDescription:"The number of tool calls made by the Agent that failed on execution.",labelRowByRow:"Average number of failed tool calls",nameRowByRow:"totalFailedToolExecutions",globalDescription:"The number of tool calls made by the Agent that failed on execution. Average over all rows.",selectable:false,excludedFromSelectAll:false},{label:"Average tool call execution time",name:"averageToolExecutionTimeSecondsPerRow",shortDescription:"Time spent executing all the tools, in seconds.",labelRowByRow:"Average tool call execution time",nameRowByRow:"totalToolExecutionTimeSeconds",globalDescription:"Time spent executing all the tools, in ms. Average over all rows.",selectable:false,excludedFromSelectAll:false},{label:"Total execution time",name:"p95TotalAgentCallExecutionTimeSecondsPerRow",shortDescription:"Total time taken by the agent call, in seconds",labelRowByRow:"Total agent call execution time",nameRowByRow:"totalAgentCallExecutionTimeSeconds",globalDescription:"Total time taken by the agent execution, in seconds. P95 across all rows.",selectable:false,excludedFromSelectAll:false},{label:"Sample row count",name:"sampleRowCount",shortDescription:"Total number of rows in the sample. May differ from the number of rows used for metric evaluation as some metrics require specific fields that might be missing in certain rows.",labelRowByRow:"Sample row count",nameRowByRow:"sampleRowCount",globalDescription:"Total number of rows in the sample. May differ from the number of rows used for metric evaluation as some metrics require specific fields that might be missing in certain rows.",selectable:false,excludedFromSelectAll:false},{label:"Exact match",name:"toolCallExactMatch",shortDescription:"Whether the agent executes exactly as expected: Check whether all of the agent’s tool calls happen in the exact same order as the reference. Returns 0 if false, 1 if true.",labelRowByRow:"Median of Tool Call Exact match",nameRowByRow:"toolCallExactMatch",globalDescription:"Whether the agent executes exactly as expected: Check whether all of the agent’s tool calls happen in the exact same order as the reference. Returns 0 if false, 1 if true. Median over all rows.",selectable:true,excludedFromSelectAll:false},{label:"Partial match",name:"toolCallPartialMatch",shortDescription:"How well the agent executes calls in order: Proportion of ordered tool calls that are shared between the agent’s response and the reference. Returns a float between 0 (no match) and 1 (exact match).",labelRowByRow:"Median of Tool Call Partial match",nameRowByRow:"toolCallPartialMatch",globalDescription:"How well the agent executes calls in order: Proportion of ordered tool calls that are shared between the agent’s response and the reference. Returns a float between 0 (no match) and 1 (exact match). Median over all rows.",selectable:true,excludedFromSelectAll:false},{label:"Precision / Recall / F1",name:"toolCallPrecisionRecallF1",shortDescription:"Evaluates the agent’s tool call performance using precision, recall, and F1 Score. Two separate calls to the same tool are considered distinct.",nameRowByRow:"toolCallPrecisionRecallF1",globalDescription:"Evaluates the agent’s tool call performance using precision, recall, and F1 Score. Two separate calls to the same tool are considered distinct. Median over all rows.",selectable:true,excludedFromSelectAll:false},{label:"Agent Goal Accuracy with Reference",name:"agentGoalAccuracyWithReference",shortDescription:"Evaluate the performance of the LLM in identifying and achieving the goals of the user. Output 1 if the AI has achieved the goal and 0 if the AI has not achieved the goal. Uses Ground truth.",globalDescription:"Evaluate the performance of the LLM in identifying and achieving the goals of the user. Output 1 if the AI has achieved the goal and 0 if the AI has not achieved the goal. Average over all rows.",labelRowByRow:"Agent Goal Accuracy with Reference",nameRowByRow:"agentGoalAccuracyWithReference",selectable:true,excludedFromSelectAll:false,pairedWith:"agentGoalAccuracyWithoutReference"},{label:"Agent Goal Accuracy without Reference",name:"agentGoalAccuracyWithoutReference",shortDescription:"Evaluate the performance of the LLM in identifying and achieving the goals of the user. Output 1 if the AI has achieved the goal and 0 if the AI has not achieved the goal.",globalDescription:"Evaluate the performance of the LLM in identifying and achieving the goals of the user. Output 1 if the AI has achieved the goal and 0 if the AI has not achieved the goal. Average over all rows.",labelRowByRow:"Agent Goal Accuracy without Reference",nameRowByRow:"agentGoalAccuracyWithoutReference",selectable:true,excludedFromSelectAll:true,pairedWith:"agentGoalAccuracyWithReference"},{label:"Answer correctness",labelRowByRow:"Answer correctness",name:"answerCorrectness",nameRowByRow:"answerCorrectness",shortDescription:"Measures the accuracy of the answer compared to the ground truth. This metric is computed using the ground truth and the answer. It requires an embedding LLM and a completion LLM.",globalDescription:"Measures the accuracy of the answer compared to the ground truth. This metric is computed using the ground truth and the answer. It requires an embedding LLM and a completion LLM.",selectable:true},{label:"Answer similarity",labelRowByRow:"Answer similarity",name:"answerSimilarity",nameRowByRow:"answerSimilarity",shortDescription:"Assesses the semantic resemblance between the generated answer and the ground truth. The metric is computed using the ground truth and the answer. It requires an embedding LLM and a completion LLM.",globalDescription:"Assesses the semantic resemblance between the generated answer and the ground truth. The metric is computed using the ground truth and the answer. It requires an embedding LLM and a completion LLM.",selectable:true,excludedFromSelectAll:false},{label:"BERT Score",labelRowByRow:"BERT Score",name:"bertScore",nameRowByRow:"bertScore",shortDescription:"Computes the similarity of answer and ground truth(s) using their tokens' embeddings. The metric is computed using the answer and the ground truth.",globalDescription:"Computes the similarity of answer and ground truth(s) using their tokens' embeddings. The metric is computed using the answer and the ground truth.",selectable:true,excludedFromSelectAll:false}];svc.nameByMetricCode={AVERAGE_TOOL_EXECUTIONS_PER_ROW:"averageToolExecutionsPerRow",AVERAGE_FAILED_TOOL_EXECUTIONS_PER_ROW:"averageFailedToolExecutionsPerRow",AVERAGE_TOOL_EXECUTION_TIME_SECONDS_PER_ROW:"averageToolExecutionTimeSecondsPerRow",P95_TOTAL_AGENT_CALL_EXECUTION_TIME_SECONDS_PER_ROW:"p95TotalAgentCallExecutionTimeSecondsPerRow",TOTAL_TOOL_EXECUTIONS:"totalToolExecutions",TOTAL_FAILED_TOOL_EXECUTIONS:"totalFailedToolExecutions",TOTAL_TOOL_EXECUTION_TIME_SECONDS:"totalToolExecutionTimeSeconds",TOTAL_AGENT_CALL_EXECUTION_TIME_SECONDS:"totalAgentCallExecutionTimeSeconds",SAMPLE_ROW_COUNT:"sampleRowCount",TOOL_CALL_EXACT_MATCH:"toolCallExactMatch",TOOL_CALL_PARTIAL_MATCH:"toolCallPartialMatch",TOOL_CALL_PRECISION_RECALL_F1:"toolCallPrecisionRecallF1",TOOL_CALL_PRECISION:"toolCallPrecisionRecallF1",TOOL_CALL_RECALL:"toolCallPrecisionRecallF1",TOOL_CALL_F1:"toolCallPrecisionRecallF1",AGENT_GOAL_ACCURACY_WITH_REFERENCE:"agentGoalAccuracyWithReference",AGENT_GOAL_ACCURACY_WITHOUT_REFERENCE:"agentGoalAccuracyWithoutReference",ANSWER_CORRECTNESS:"answerCorrectness",ANSWER_SIMILARITY:"answerSimilarity",BERT_SCORE:"bertScore",BERT_SCORE_PRECISION:"bertScore",BERT_SCORE_RECALL:"bertScore",BERT_SCORE_F1:"bertScore"};svc.computableMetrics=Object.keys(svc.nameByMetricCode).filter(m=>!["TOOL_CALL_PRECISION_RECALL_F1","BERT_SCORE"].includes(m));svc.fieldsNeededPerMetric={toolCallExactMatch:["referenceToolCalls","actualToolCalls"],toolCallPartialMatch:["referenceToolCalls","actualToolCalls"],toolCallPrecisionRecallF1:["referenceToolCalls","actualToolCalls"],agentGoalAccuracyWithReference:["input","output","groundTruth","actualToolCalls","completionLLM","embeddingLLM"],agentGoalAccuracyWithoutReference:["input","output","actualToolCalls","completionLLM","embeddingLLM"],answerCorrectness:["input","output","groundTruth","embeddingLLM","completionLLM"],answerSimilarity:["input","output","groundTruth","embeddingLLM","completionLLM"],bertScore:["output","groundTruth"]};svc.metricGroups=[{name:"toolcallMetricsInOrder",selectAll:true,label:"In order tool call metrics",metrics:[svc.nameByMetricCode.TOOL_CALL_EXACT_MATCH,svc.nameByMetricCode.TOOL_CALL_PARTIAL_MATCH]},{name:"toolcallMetricsOutOfOrder",selectAll:true,label:"Out of order tool call metrics",metrics:[svc.nameByMetricCode.TOOL_CALL_PRECISION_RECALL_F1]},{name:"llmAsAJudge",selectAll:true,label:"LLM-as-a-judge metrics",metrics:[svc.nameByMetricCode.AGENT_GOAL_ACCURACY_WITH_REFERENCE,svc.nameByMetricCode.AGENT_GOAL_ACCURACY_WITHOUT_REFERENCE,svc.nameByMetricCode.ANSWER_CORRECTNESS,svc.nameByMetricCode.ANSWER_SIMILARITY]},{name:"deterministicLlm",selectAll:true,label:"Deterministic LLM metrics",metrics:[svc.nameByMetricCode.BERT_SCORE]}];svc.isInGroup=function(metric,groupName){const group=this.metricGroups.find(g=>g.name===groupName);if(!group)return false;return group.metrics.includes(metric.name)};svc.getPotentialWarningForMetricComputation=function(metric,packagesWarning,hasInput,hasOutput,hasGroundTruth,hasActualToolCalls,hasReferenceToolCalls,hasEmbeddingLLM,hasCompletionLLM){if(!Object.keys(svc.fieldsNeededPerMetric).includes(metric)){return""}if(svc.fieldsNeededPerMetric[metric].includes("input")&&!hasInput){return"Requires an Input column"}if(svc.fieldsNeededPerMetric[metric].includes("output")&&!hasOutput){return"Requires an Output column"}if(svc.fieldsNeededPerMetric[metric].includes("groundTruth")&&!hasGroundTruth){return"Requires a Ground truth column"}if(svc.fieldsNeededPerMetric[metric].includes("referenceToolCalls")&&!hasReferenceToolCalls){return"Requires a Reference tool call column"}if(svc.fieldsNeededPerMetric[metric].includes("actualToolCalls")&&!hasActualToolCalls){return"Requires an Actual tool call column"}if(svc.fieldsNeededPerMetric[metric].includes("embeddingLLM")&&!hasEmbeddingLLM){return"Requires an Embedding LLM"}if(svc.fieldsNeededPerMetric[metric].includes("completionLLM")&&!hasCompletionLLM){return"Requires a Completion LLM"}return""};svc.getMetricByCode=function(metricCode){const name=svc.nameByMetricCode[metricCode];if(!name){return undefined}return svc.metrics.find(m=>m.name===name)};svc.agentModelTaskTypes=[{type:"AGENT",fullName:"Agent",shortName:"AGENT"}];svc.inputFormats=[{type:"PROMPT_RECIPE",fullName:"Prompt Recipe",shortName:"prompt recipe"},{type:"CUSTOM",fullName:"Custom",shortName:"custom"}];return svc});app.controller("AgentEvaluationRecipeCreationController",function($scope,$controller){$controller("GenAIBaseEvaluationRecipeCreationController",{$scope:$scope,evaluatedType:"agent"})});app.controller("AgentEvaluationRecipeEditorController",function($scope,$controller,AgentEvaluationMetrics,WT1,DataikuAPI,ActiveProjectKey,FutureProgressModal,StringUtils,CodeMirrorSettingService){$controller("GenAIBaseEvaluationRecipeEditorController",{$scope:$scope,evaluatedType:"agent"});$scope.inputFormats=AgentEvaluationMetrics.inputFormats;$scope.saveColumnNames=function(){if($scope.desc.inputColumnName!==$scope.NO_COLUMN_SELECTED){$scope.savedColumnNames.input=$scope.desc.inputColumnName}if($scope.desc.outputColumnName!==$scope.NO_COLUMN_SELECTED){$scope.savedColumnNames.output=$scope.desc.outputColumnName}if($scope.desc.actualToolCallsColumnName!==$scope.NO_COLUMN_SELECTED){$scope.savedColumnNames.actualToolCalls=$scope.desc.actualToolCallsColumnName}};$scope.restoreColumnNames=function(){if($scope.savedColumnNames.input!==null){$scope.desc.inputColumnName=$scope.savedColumnNames.input;$scope.savedColumnNames.input=null}if($scope.savedColumnNames.output!==null){$scope.desc.outputColumnName=$scope.savedColumnNames.output;$scope.savedColumnNames.output=null}if($scope.savedColumnNames.actualToolCalls!==null){$scope.desc.actualToolCallsColumnName=$scope.savedColumnNames.actualToolCalls;$scope.savedColumnNames.actualToolCalls=null}};$scope.savedColumnNames={input:null,output:null,actualToolCalls:null};$scope.$watch("desc.inputFormat",(nv,ov)=>{if(nv==="PROMPT_RECIPE"){if(ov!=="DATAIKU_ANSWERS"){$scope.saveColumnNames()}$scope.desc.inputColumnName="llm_raw_query";$scope.desc.outputColumnName="llm_raw_response";$scope.desc.actualToolCallsColumnName="llm_raw_response"}else{$scope.restoreColumnNames()}$scope.updateMissingColumnsWarning(nv)});$scope.onInit=function(){$scope.filteredMetrics=getFilteredMetrics();$scope.metricGroups.forEach(group=>$scope.updateGroupSelectAll(group))};$scope.filteredMetrics=[];$scope.fieldsNeeded=AgentEvaluationMetrics.fieldsNeededPerMetric;$scope.metricGroups=AgentEvaluationMetrics.metricGroups;$scope.filterByGroup=function(groupName){return function(metric){return AgentEvaluationMetrics.isInGroup(metric,groupName)}};$scope.toggleAllMetrics=function(group){$scope.filteredMetrics.filter(m=>AgentEvaluationMetrics.isInGroup(m,group.name)).forEach(m=>m.$selected=group.selectAll&&!m.excludedFromSelectAll);$scope.updateFilteredMetricsSelection()};$scope.updateGroupSelectAll=function(group){const groupSelectAllableMetrics=$scope.filteredMetrics.filter(m=>AgentEvaluationMetrics.isInGroup(m,group.name)&&!m.excludedFromSelectAll);const metricSelectAllableCount=groupSelectAllableMetrics.length;const selectedMetricCount=groupSelectAllableMetrics.filter(m=>m.$selected).length;group.selectAll=metricSelectAllableCount===selectedMetricCount};$scope.updateAgentGoalMetrics=function(metric){if(metric.$selected){if(metric.name==="agentGoalAccuracyWithReference"){$scope.filteredMetrics.filter(m=>m.name==="agentGoalAccuracyWithoutReference").forEach(m=>m.$selected=false)}else if(metric.name==="agentGoalAccuracyWithoutReference"){$scope.filteredMetrics.filter(m=>m.name==="agentGoalAccuracyWithReference").forEach(m=>m.$selected=false)}}};$scope.$watch("desc.inputFormat",()=>{if($scope.desc.inputFormat){$scope.filteredMetrics=getFilteredMetrics()}});function getFilteredMetrics(){return AgentEvaluationMetrics.metrics.filter(possibleMetric=>possibleMetric.selectable).map(possibleMetric=>{if($scope.desc.metrics.includes(possibleMetric.name)){return{...possibleMetric,$selected:true}}return{...possibleMetric,$selected:false}})}$scope.updateFilteredMetricsSelection=function(){$scope.desc.metrics=$scope.filteredMetrics.filter(m=>m.$selected).map(m=>m.name)};$scope.getPotentialWarningForMetricComputation=function(isSelected,metric){if(!isSelected){return""}const hasInput=!!$scope.desc.inputColumnName&&$scope.desc.inputColumnName!==$scope.NO_COLUMN_SELECTED;const hasOutput=!!$scope.desc.outputColumnName&&$scope.desc.outputColumnName!==$scope.NO_COLUMN_SELECTED;const hasGroundTruth=!!$scope.desc.groundTruthColumnName&&$scope.desc.groundTruthColumnName!==$scope.NO_COLUMN_SELECTED;const hasActualToolCalls=!!$scope.desc.actualToolCallsColumnName&&$scope.desc.actualToolCallsColumnName!==$scope.NO_COLUMN_SELECTED;const hasReferenceToolCalls=!!$scope.desc.referenceToolCallsColumnName&&$scope.desc.referenceToolCallsColumnName!==$scope.NO_COLUMN_SELECTED;const hasEmbeddingLLM=!!$scope.desc.embeddingLLMId&&$scope.desc.embeddingLLMId!==$scope.NO_LLM_SELECTED.id;const hasCompletionLLM=!!$scope.desc.completionLLMId&&$scope.desc.completionLLMId!==$scope.NO_LLM_SELECTED.id;return AgentEvaluationMetrics.getPotentialWarningForMetricComputation(metric,$scope.codeEnvWarning.reason,hasInput,hasOutput,hasGroundTruth,hasActualToolCalls,hasReferenceToolCalls,hasEmbeddingLLM,hasCompletionLLM)};const customMetricDefaultCode=`def evaluate(input_df, recipe_params, interpreted_columns, **kwargs):
    """
    Custom score function.
    Must return a float representing the metric value over the whole sample, and 
    optionally an array of shape (nb_records,) with the row-by-row values
    - input_df is the Input dataset of the Agent evaluation recipe, as a Pandas DataFrame
    - recipe_params is an object with the Agent evaluation recipe parameters:
        - input_column_name: Name of the Input column as a string
        - output_column_name (may be None): Name of the Output column as a string
        - ground_truth_column_name (may be None): Name of the Ground truth column as 
          a string
        - reference_tool_calls_column_name (may be None): Name of the Reference tool 
          calls column as a string
        - actual_tool_calls_column_name (may be None): Name of the Actual tool calls 
          column as a string
        - embedding_llm (may be None): A DKUEmbeddings object, to be used to query 
          the LLM mesh to embed the inputs
        - completion_llm (may be None): A DKULLM object, to be used to query the 
          LLM mesh with an eventual prompt
    - interpreted_columns are the input columns as they were used by the recipe,
      including some eventual pre-treatment, notably for the prompt recipe and dataiku
      answers cases. Formatted as Pandas Dataseries.
      If no pre-treatment happened, their content is the same as in the input_df
        - input : for Prompt recipe, this is a concatenation of all the prompt messages
        - output : for Prompt recipe, only the text, extracted from the json
        - ground_truth 
        - reference_tool_calls
        - actual_tool_calls
    """
    return 0.5, [optionally, one, value, per, row]`;$scope.getNewMetricTemplate=function(){if(!$scope.desc.customMetrics){$scope.desc.customMetrics=[]}const name=StringUtils.transmogrify("Custom Metric #"+($scope.desc.customMetrics.length+1).toString(),$scope.desc.customMetrics.map(a=>a.name),function(i){return"Custom Metric #"+(i+1).toString()});const template={name:name,metricCode:customMetricDefaultCode,description:"",greaterIsBetter:true,minValue:0,maxValue:1,type:"LLM",$foldableOpen:true};return template};$scope.snippetCategory="py-agent-custom-metric";$scope.addNewCustomMetric=function(){if(!$scope.desc.customMetrics){$scope.desc.customMetrics=[]}$scope.desc.customMetrics.push($scope.getNewMetricTemplate())};$scope.testCustomMetricResults={};$scope.testCustomMetric=function(customMetricIndex){const mainInput=$scope.recipe.inputs.main.items[0];const serialisedInputDataset=!!mainInput?$scope.computablesMap[mainInput.ref]:undefined;return DataikuAPI.flow.recipes.testCustomMetric(ActiveProjectKey.get(),$scope.recipe,$scope.desc,customMetricIndex,serialisedInputDataset).then(({data})=>{return FutureProgressModal.show($scope,data,"Testing")}).then(customMetricResult=>{$scope.testCustomMetricResults[customMetricIndex]=customMetricResult}).catch(setErrorInScope.bind($scope))};$scope.fireCustomMetricAddedWT1Event=function(){WT1.event("clicked-item",{"item-id":"agent-evaluation-add-custom-metric"})};$scope.fireCustomMetricRemovedWT1Event=function(){WT1.event("clicked-item",{"item-id":"agent-evaluation-remove-custom-metric"})};$scope.toggleFoldable=function(index){if($scope.desc.customMetrics[index]){$scope.desc.customMetrics[index].$foldableOpen=!$scope.desc.customMetrics[index].$foldableOpen}};const customTraitDefaultCode=`# Add assertions to check against the agent result
# RESULT: 
#   - 1 if ALL of the assertions are valid 
#   - 0 if any of them is invalid
# USE: 
#   Assertions should be separated by an empty line.
#   Assertions should be in natural language, using the following fields:
#     - Input: The initial query sent to the agent, e.g., the user's question
#     - Output: The final answer from the agent, as viewed by the user
#     - Ground truth: The expected answer, 
#         from the Ground Truth column defined in the "Input dataset" section
#     - Actual tool calls: The list of tools that were called by the agent
#     - Reference tool calls: The list of tools expected to be called by the agent, 
#         from the Reference tool call column defined in the "Input dataset" section
# EXAMPLE:
The Output uses a polite and professional tone

The Actual tool calls contains a call to mytool,
followed by a call to mytool2,
not followed by any call`;$scope.getNewCustomTraitTemplate=function(){if(!$scope.desc.customTraits){$scope.desc.customTraits=[]}const name=StringUtils.transmogrify("Custom Trait #"+($scope.desc.customTraits.length+1).toString(),$scope.desc.customTraits.map(a=>a.name),function(i){return"Custom Trait #"+(i+1).toString()});const template={name:name,prompt:customTraitDefaultCode,description:"",type:"TRAIT",$foldableOpen:true};return template};$scope.traitSnippetCategory="sh-custom-trait";$scope.addNewCustomTrait=function(){if(!$scope.desc.customTraits){$scope.desc.customTraits=[]}$scope.desc.customTraits.push($scope.getNewCustomTraitTemplate())};$scope.toggleTraitFoldable=function(metric){if(metric){metric.$foldableOpen=!metric.$foldableOpen}};$scope.traitEditorOptions=CodeMirrorSettingService.get("text/x-sh");$scope.traitEditorOptions.lineNumbers=false;$scope.traitEditorOptions.foldGutter=false;$scope.traitEditorOptions.gutters=[];$scope.traitEditorOptions.lineWrapping=true;$scope.fireCustomTraitAddedWT1Event=function(){WT1.event("clicked-item",{"item-id":"agent-evaluation-add-custom-trait"})};$scope.fireCustomTraitRemovedWT1Event=function(){WT1.event("clicked-item",{"item-id":"agent-evaluation-remove-custom-trait"})}})})();(function(){"use strict";const app=angular.module("dataiku.recipes");app.constant("METRICS",{BINARY_CLASSIFICATION:["accuracy","precision","recall","f1","costMatrixGain","hammingLoss","mcc","auc","lift","averagePrecision","logLoss","calibrationLoss","customScore"],MULTICLASS:["accuracy","precision","recall","hammingLoss","mrocAUC","averagePrecision","logLoss","mcalibrationLoss","customScore"],REGRESSION:["evs","mape","mae","mse","rmse","rmsle","r2","pearson","customScore"],TIMESERIES:["mase","mape","smape","mae","meanAbsoluteQuantileLoss","meanWeightedQuantileLoss","mse","rmse","msis","nd"],TIMESERIES_SKIP_SCORING:["mape","smape","mae","meanAbsoluteQuantileLoss","meanWeightedQuantileLoss","mse","rmse","nd"],MULTIPLE_TIMESERIES:["mase","mape","smape","mae","mse","msis"],MULTIPLE_TIMESERIES_SKIP_SCORING:["mape","smape","mae","mse"],CAUSAL:["auuc","qini","netUplift","propensityAuc","propensityLogLoss","propensityCalibrationLoss"],CAUSAL_WITHOUT_PROPENSITY:["auuc","qini","netUplift"]});app.controller("_BaseMLRecipeEditor",function($scope,$q,$state,Assert,GraphZoomTrackerService,MLContainerInfoService,$stateParams,FullModelLikeIdUtils,GPU_SUPPORTING_CAPABILITY,GpuUsageService){Assert.inScope($scope,"script");Assert.inScope($scope,"recipe");GraphZoomTrackerService.setFocusItemById("recipe",$state.params.recipeName);$scope.GPU_SUPPORTING_CAPABILITY=GPU_SUPPORTING_CAPABILITY;$scope.GpuUsageService=GpuUsageService;$scope.desc=JSON.parse($scope.script.data);$scope.hooks.preRunValidate=function(){return $q.when({ok:true})};$scope.hooks.recipeIsDirty=function(){if(!$scope.recipe)return false;if($scope.creation){return true}else{var dirty=!angular.equals($scope.recipe,$scope.origRecipe);var origDesc=JSON.parse($scope.origScript.data);dirty=dirty||!angular.equals(origDesc,$scope.desc);return dirty}};$scope.shouldShowGpuControls=function(inUseCapabilities){if(inUseCapabilities.length==0){return false}const allowChangingMode=GpuUsageService.allowChangingMode(true,inUseCapabilities);return allowChangingMode||$scope.desc.gpuConfig.params.useGpu};$scope.getInUseGpuCapabilities=function(){const capabilities=[];if(!$scope.modelDetails){return capabilities}if($scope.usesCodeEnvSentenceEmbedding()){capabilities.push(GPU_SUPPORTING_CAPABILITY.SENTENCE_EMBEDDING)}if($scope.isTimeseriesForecasting()){capabilities.push(GPU_SUPPORTING_CAPABILITY.GLUONTS);return capabilities}if(["DEEP_HUB_IMAGE_OBJECT_DETECTION","DEEP_HUB_IMAGE_CLASSIFICATION"].includes($scope.modelDetails.modeling.type)){capabilities.push(GPU_SUPPORTING_CAPABILITY.DEEP_HUB);return capabilities}const alg=$scope.modelDetails.modeling.algorithm;if(["XGBOOST_REGRESSION","XGBOOST_CLASSIFICATION"].includes(alg)){capabilities.push(GPU_SUPPORTING_CAPABILITY.XGBOOST)}if(["TABICL_CLASSIFICATION"].includes(alg)){capabilities.push(GPU_SUPPORTING_CAPABILITY.TABICL)}if(["DEEP_NEURAL_NETWORK_REGRESSION","DEEP_NEURAL_NETWORK_CLASSIFICATION"].includes(alg)){capabilities.push(GPU_SUPPORTING_CAPABILITY.DEEP_NN)}if("KERAS_CODE"===alg){capabilities.push(GPU_SUPPORTING_CAPABILITY.KERAS)}return capabilities};$scope.usesCodeEnvSentenceEmbedding=function(){if(!$scope.modelDetails||!$scope.modelDetails.preprocessing||!$scope.modelDetails.preprocessing.per_feature){return false}return Object.values($scope.modelDetails.preprocessing.per_feature).some(featPreproc=>featPreproc.role==="INPUT"&&featPreproc.text_handling==="SENTENCE_EMBEDDING"&&featPreproc.sentenceEmbeddingModel!=null&&!featPreproc.isStructuredRef)};$scope.isMLBackendType=function(mlBackendType){return $scope.desc.backendType===mlBackendType};$scope.goToAnalysisModel=function(){Assert.trueish($scope.desc.generatingModelId,"no generatingModelId");const{elements,fullModelId}=FullModelLikeIdUtils.parseWithEnforcedProjectKey($scope.desc.generatingModelId,$stateParams.projectKey);const params={projectKey:elements.projectKey,analysisId:elements.analysisId,mlTaskId:elements.mlTaskId,fullModelId:fullModelId};let state="projects.project.analyses.analysis.ml.";if($scope.recipe.type=="prediction_training"){state+="predmltask.model.report"}else{state+="clustmltask.model.report"}$state.go(state,params)};$scope.inContainer=MLContainerInfoService.inContainer($scope,$stateParams.projectKey);$scope.getModelUsedCodeEnvName=function(){if($scope.modelDetails&&$scope.modelDetails.coreParams&&$scope.modelDetails.coreParams.executionParams){return $scope.modelDetails.coreParams.executionParams.envName}else{return undefined}};$scope.isPartitionedModel=function(){return $scope.modelDetails&&$scope.modelDetails.coreParams&&$scope.modelDetails.coreParams.partitionedModel&&$scope.modelDetails.coreParams.partitionedModel.enabled};$scope.isClassicalPrediction=function(){return $scope.modelDetails&&["BINARY_CLASSIFICATION","REGRESSION","MULTICLASS"].includes($scope.modelDetails.coreParams.prediction_type)}});app.controller("_MLRecipeWithOutputSchemaController",function($scope,$q,ComputableSchemaRecipeSave,PartitionDeps,DataikuAPI){$scope.hooks.save=function(){var recipeSerialized=angular.copy($scope.recipe);PartitionDeps.prepareRecipeForSerialize(recipeSerialized);var payload=angular.toJson($scope.desc);if($scope.forceDisableOutputSchemaHandling&&$scope.forceDisableOutputSchemaHandling()){$scope.script.data=payload;return $scope.baseSave(recipeSerialized,payload)}else{var deferred=$q.defer();ComputableSchemaRecipeSave.handleSave($scope,recipeSerialized,payload,deferred);$scope.script.data=payload;return deferred.promise}};$scope.updateUsabilityOfSMInputs=function(){DataikuAPI.flow.recipes.updateUsabilityOfSMInputs($scope.recipe.projectKey,$scope.model.needsInputDataFolder,$scope.model.miniTask.predictionType,Object.values($scope.computablesMap)).then(function({data}){const newComputablesMap=Object.fromEntries(data.map(d=>[d.smartName,d]));Object.assign($scope.computablesMap,newComputablesMap)}).catch(setErrorInScope.bind($scope))};function recipeSaved(){if($scope.uiState&&$scope.uiState.warningMessages&&$scope.uiState.warningMessages.model&&$scope.uiState.warningMessages.model.length>0){const customMetricsChanged=$scope.uiState.warningMessages.model.some(x=>x&&x.code==="WARN_RECIPE_INPUT_MODEL_CUSTOM_METRICS_CHANGED");if(customMetricsChanged){$scope.recipeUpdateData().then(_=>{$scope.uiState.warningMessages.model=[];$scope.desc=JSON.parse($scope.script.data);$scope.$broadcast("customMetricsUpdated")})}}}$scope.$on("recipeSaved",recipeSaved)});app.controller("_MLRecipeWithoutOutputSchemaController",function($scope,PartitionDeps,Assert){Assert.inScope($scope,"recipe");Assert.inScope($scope,"desc");$scope.hooks.save=function(){var recipeSerialized=angular.copy($scope.recipe);PartitionDeps.prepareRecipeForSerialize(recipeSerialized);var payload=angular.toJson($scope.desc);$scope.script.data=payload;return $scope.baseSave(recipeSerialized,payload)}});app.controller("_TimeseriesScoringOrEvaluationController",function($scope,TimeseriesForecastingUtils){$scope.prettyTimeSteps=TimeseriesForecastingUtils.prettyTimeSteps;$scope.prettySelectedDate=TimeseriesForecastingUtils.prettySelectedDate;$scope.getWeekDayName=TimeseriesForecastingUtils.getWeekDayName;$scope.isTimeseriesForecasting=function(){return $scope.modelDetails&&$scope.modelDetails.coreParams.prediction_type==="TIMESERIES_FORECAST"};$scope.externalFeatures=function(){if(!$scope.modelDetails||!$scope.modelDetails.modeling||TimeseriesForecastingUtils.ALGOS_WITHOUT_EXTERNAL_FEATURES.names.includes($scope.modelDetails.modeling.algorithm))return[];return Object.keys($scope.modelDetails.preprocessing.per_feature).filter(function(name){const preprocessing=$scope.modelDetails.preprocessing.per_feature[name];return preprocessing.role==="INPUT"})};$scope.canRefitModel=function(){return $scope.modelDetails&&$scope.modelDetails.modeling&&["AUTO_ARIMA","ARIMA","CROSTON","ETS","PROPHET","SEASONAL_LOESS"].includes($scope.modelDetails.modeling.algorithm)};$scope.mustRefitModel=function(){return $scope.modelDetails&&$scope.modelDetails.modeling&&["SEASONAL_LOESS","CROSTON"].includes($scope.modelDetails.modeling.algorithm)};$scope.isMultipleTimeseries=function(){return $scope.model&&$scope.model.miniTask&&$scope.model.miniTask.timeseriesIdentifiers&&$scope.model.miniTask.timeseriesIdentifiers.length>0};$scope.isGluonTSBased=function(){return $scope.modelDetails.modeling.algorithm.startsWith("GLUONTS")};$scope.showMaxUsedTimestepsForScoring=function(){return $scope.modelDetails.iperf.maxUsedTimestepsForScoring>$scope.modelDetails.iperf.minTimeseriesSizeForScoring};let timeUnitInMilliSeconds=function(timeunit){switch(timeunit){case"MILLISECOND":return 1;case"SECOND":return 1e3;case"MINUTE":return 6e4;case"HOUR":return 36e5;case"DAY":return 864e5;case"BUSINESS_DAY":return 864e5;case"WEEK":return 6048e5;case"MONTH":return 26298e5;case"QUARTER":return 78894e5;case"HALF_YEAR":return 157788e5;case"YEAR":return 315576e5}};let getPredictionLengthInMilliSeconds=function(){return $scope.desc.predictionLength*$scope.modelDetails.coreParams.timestepParams.numberOfTimeunits*timeUnitInMilliSeconds($scope.modelDetails.coreParams.timestepParams.timeunit)};$scope.isLastTimestampLikelyToOverflow=function(){return getPredictionLengthInMilliSeconds()>70057872e5};$scope.isPredictionLengthTooLong=function(){return getPredictionLengthInMilliSeconds()>18446744073709.55};$scope.isAlgoSupportingQuantiles=function(){return!TimeseriesForecastingUtils.ALGOS_WITHOUT_QUANTILES.includes($scope.modelDetails?.modeling?.algorithm)};$scope.isAlgoScoringLessThanPredictionLength=function(){return $scope.modelDetails&&$scope.modelDetails.modeling&&TimeseriesForecastingUtils.ALGOS_SCORING_UP_TO_PREDICTION_LENGTH.includes($scope.modelDetails.modeling.algorithm.toLowerCase())};$scope.initPredictionLength=function(){if(!$scope.desc.predictionLength)$scope.desc.predictionLength=$scope.modelDetails.coreParams.predictionLength};function initImputeMethods(modelDetails){if(modelDetails&&modelDetails.preprocessing&&modelDetails.preprocessing.timeseriesSampling){const timeseriesSampling=modelDetails.preprocessing.timeseriesSampling;$scope.numericalInterpolateMethod=TimeseriesForecastingUtils.TIMESERIES_IMPUTE_METHODS.find(obj=>obj.value===timeseriesSampling.numericalInterpolateMethod);$scope.numericalExtrapolateMethod=TimeseriesForecastingUtils.TIMESERIES_IMPUTE_METHODS.find(obj=>obj.value===timeseriesSampling.numericalExtrapolateMethod);$scope.categoricalImputeMethod=TimeseriesForecastingUtils.TIMESERIES_IMPUTE_METHODS.find(obj=>obj.value===timeseriesSampling.categoricalImputeMethod);$scope.duplicateTimestampsHandlingMethod=TimeseriesForecastingUtils.DUPLICATE_TIMESTAMPS_HANDLING_METHODS.find(obj=>obj.value===timeseriesSampling.duplicateTimestampsHandlingMethod)}}$scope.hasChangedNbEvalTimesteps=function(){if(!$scope?.origRecipe.versionTag?.versionNumber){return false}if($scope.origRecipe.versionTag.versionNumber==0){return false}let origDesc=JSON.parse($scope.origScript.data);return $scope.desc.maxNbForecastTimeSteps!==origDesc.maxNbForecastTimeSteps};function setMaxNbTimesteps(modelDetails){if(modelDetails&&$scope.desc){if($scope.isEvaluationRecipe&&$scope.isTimeseriesForecasting()&&$scope.isMLBackendType("PY_MEMORY")&&undefined===$scope.desc.maxNbForecastTimeSteps){$scope.desc.maxNbForecastTimeSteps=$scope.desc.maxNbForecastHorizons*(modelDetails.coreParams.predictionLength??10);$scope.hooks.save()}deregisterWatch()}}$scope.$watch("modelDetails",initImputeMethods,true);const deregisterWatch=$scope.$watch("modelDetails",setMaxNbTimesteps,true)});app.controller("_CausalPredictionScoringOrEvaluationController",function($scope){$scope.isCausalPrediction=function(){return $scope.modelDetails&&["CAUSAL_REGRESSION","CAUSAL_BINARY_CLASSIFICATION"].includes($scope.modelDetails.coreParams.prediction_type)};$scope.isCausalBinaryClassification=function(){return $scope.modelDetails&&"CAUSAL_BINARY_CLASSIFICATION"===$scope.modelDetails.coreParams.prediction_type};$scope.isMultiValuedTreatment=function(){return $scope.modelDetails&&$scope.modelDetails.coreParams.enable_multi_treatment&&$scope.modelDetails.coreParams.treatment_values.length>2};$scope.getFilteredTreatmentValues=function(){const controlValue=$scope.modelDetails.coreParams.control_value;const treatmentValues=$scope.modelDetails.coreParams.treatment_values.filter(x=>x!==controlValue);if($scope.modelDetails.preprocessing.drop_missing_treatment_values){return treatmentValues.filter(x=>x!=="")}else{return treatmentValues}}});app.controller("PredictionTrainingRecipeEditor",function($scope,$controller,ModelLabelUtils){$controller("_BaseMLRecipeEditor",{$scope:$scope});$controller("_MLRecipeWithoutOutputSchemaController",{$scope:$scope});$controller("_K8sConfigurationCheckerController",{$scope:$scope});$scope.operationModeChanged=function(nv){$scope.desc.splitParams.kfold=nv==="TRAIN_KFOLD"};$scope.isInputRoleAvailableForPayload=function(role){if(!$scope.desc){return false}switch(role.name){case"data":return $scope.desc&&$scope.desc.needsInputDataFolder;case"test":return $scope.desc.splitParams&&$scope.desc.splitParams.ttPolicy=="EXPLICIT_FILTERING_TWO_DATASETS";default:throw new Error(`Rules for availability of input role "${role.name}" not implemented`)}};$scope.enableAutoFixup();$scope.isMLLib=function(){return $scope.desc.backendType==="MLLIB"};$scope.isPartitionedModel=function(){return $scope.desc&&$scope.desc.core&&$scope.desc.core.partitionedModel&&$scope.desc.core.partitionedModel.enabled};function isClassification(){return $scope.desc&&$scope.desc.core&&$scope.desc.core.prediction_type&&["BINARY_CLASSIFICATION","MULTICLASS","CAUSAL_BINARY_CLASSIFICATION"].includes($scope.desc.core.prediction_type)}function isKFoldSplit(){return $scope.desc&&$scope.desc.splitParams&&$scope.desc.splitParams.kfold}$scope.isCompatibleWithStratifiedSplitting=function(){return $scope.isMLBackendType("PY_MEMORY")&&isKFoldSplit()&&isClassification()};$scope.isCompatibleWithGroupKFold=function(){return $scope.isMLBackendType("PY_MEMORY")&&isKFoldSplit()&&!$scope.isTimeseriesForecasting()};let groupKFoldColumnNames=null;function withPredictionIntervals(){if(isClassification()){return false}return $scope.desc.core.uncertainty!=null&&$scope.desc.core.uncertainty.predictionIntervalsEnabled}$scope.canTrainOnSplit=function(){return!$scope.isTimeseriesForecasting()};$scope.canTrainOnSplitAndFull=function(){return!withPredictionIntervals()};$scope.canTrainOnKFold=function(){return $scope.isMLBackendType("PY_MEMORY")&&(!($scope.desc.core.time!=null&&$scope.desc.core.time.enabled)||$scope.isTimeseriesForecasting())&&!$scope.isCausalPrediction()&&!withPredictionIntervals()};$scope.getGroupKFoldColumnNames=function(){if(groupKFoldColumnNames===null&&$scope.desc&&$scope.desc.preprocessing&&$scope.desc.preprocessing.per_feature){groupKFoldColumnNames=Object.keys($scope.desc.preprocessing.per_feature).filter(function(name){if($scope.isCausalPrediction()&&name===$scope.desc.core.treatment_variable){return false}return $scope.desc.core.target_variable!==name})}return groupKFoldColumnNames};$scope.isTimeseriesForecasting=function(){return $scope.desc&&$scope.desc.core&&$scope.desc.core.prediction_type&&$scope.desc.core.prediction_type==="TIMESERIES_FORECAST"};$scope.isCausalPrediction=function(){return $scope.desc&&$scope.desc.core&&$scope.desc.core.prediction_type&&["CAUSAL_REGRESSION","CAUSAL_BINARY_CLASSIFICATION"].includes($scope.desc.core.prediction_type)};$scope.mayUseContainer=function(){if(!$scope.desc)return false;const backendType=$scope.desc&&$scope.desc.core&&$scope.desc.core.backendType;return["PY_MEMORY","KERAS","DEEP_HUB"].includes(backendType)};$scope.partitionedSourceOptions=[["ACTIVE_VERSION","Active"],["LATEST_VERSION","Latest"],["EXPLICIT_VERSION","Explicit"],["NONE","None"]];$scope.partitionedSourceDescs=["Train upon the currently active saved model version","Train upon the most recently trained version","Choose which version to train upon","Build a new partitioned models from scratch"];$scope.hasSelectedK8sContainer=()=>{const{backendType}=$scope.desc;const{containerSelection}=$scope.recipe.params;return $scope.isK8sContainer(backendType,containerSelection)};const updateHpSearchDistribution=(newSelection,oldSelection)=>{if(angular.equals(newSelection,oldSelection)){return}const searchParams=$scope.desc.modeling.grid_search_params;if(!searchParams){return}searchParams.distributed=searchParams.distributed&&$scope.hasSelectedK8sContainer()};const baseCanSave=$scope.canSave;$scope.canSave=function(){return ModelLabelUtils.validateLabels($scope.recipe)&&baseCanSave()};$scope.$watch("recipe.params.containerSelection",updateHpSearchDistribution,true)});app.controller("ClusteringTrainingRecipeEditor",function($scope,$controller,ModelLabelUtils){$controller("_BaseMLRecipeEditor",{$scope:$scope});$controller("_MLRecipeWithoutOutputSchemaController",{$scope:$scope});$scope.enableAutoFixup();$scope.isMLLib=function(){return $scope.desc.backendType==="MLLIB"};const baseCanSave=$scope.canSave;$scope.canSave=function(){return ModelLabelUtils.validateLabels($scope.recipe)&&baseCanSave()}});app.controller("PredictionScoringRecipeEditor",function($scope,$controller,$q,DataikuAPI,Assert,MLExportService,FullModelLikeIdUtils,SavedModelsService){$controller("_BaseMLRecipeEditor",{$scope:$scope});$controller("_MLRecipeWithOutputSchemaController",{$scope:$scope});$controller("_RecipeWithEngineBehavior",{$scope:$scope});$controller("_TimeseriesScoringOrEvaluationController",{$scope:$scope});$controller("_CausalPredictionScoringOrEvaluationController",{$scope:$scope});const backendSupportsExplanations=()=>$scope.desc.backendType!=="DEEP_HUB";$scope.treatmentAssignmentModes=[["SAMPLE_RATIO_EXACT","Ratio of the data (exact)"],["SAMPLE_RATIO_APPROX","Ratio of the data (approximate)"],["THRESHOLD","Threshold on predicted effect"]];if(backendSupportsExplanations()){$scope.desc.individualExplanationParams={method:"ICE",nbExplanations:3,shapleyBackgroundSize:100,subChunkSize:5e3,...$scope.desc.individualExplanationParams||{}};$scope.$watch("recipeStatus.selectedEngine.type",nv=>{if(nv&&$scope.canComputeExplanations()===false){$scope.desc.outputExplanations=false}if(nv&&$scope.willUseSpark()){$scope.desc.outputModelMetadata=false}})}$scope.isInputRoleAvailableForPayload=function(role){if(!$scope.model)return false;switch(role.name){case"data":return $scope.model&&$scope.model.needsInputDataFolder;default:throw new Error(`Rules for availability of input role "${role.name}" not implemented`)}};$scope.enableAutoFixup();$scope.canChangeEngine=function(){return true};$scope.selectedEngine=function(){return $scope.recipeStatus&&$scope.recipeStatus.selectedEngine&&$scope.recipeStatus.selectedEngine.type};$scope.selectedEngineVariant=function(){return $scope.recipeStatus&&$scope.recipeStatus.selectedEngine&&$scope.recipeStatus.selectedEngine.variant};$scope.hooks.onRecipeLoaded=function(){$scope.hooks.updateRecipeStatus()};$scope.hooks.getPayloadData=function(){return angular.toJson($scope.desc)};$scope.hooks.updateRecipeStatus=function(){var deferred=$q.defer();var payload=$scope.hooks.getPayloadData();$scope.updateRecipeStatusBase(false,payload).then(function(){if(!$scope.recipeStatus)return deferred.reject();deferred.resolve($scope.recipeStatus)});return deferred.promise};var noProbAlgos=["DECISION_TREE_CLASSIFICATION","MLLIB_DECISION_TREE"];$scope.noSQLProbas=function(){return $scope.isMulticlass()&&$scope.selectedEngine()=="SQL"&&noProbAlgos.indexOf($scope.modelDetails.modeling.algorithm)>=0};var safeSQLAlgorithms=["LASSO_REGRESSION","RIDGE_REGRESSION","LEASTSQUARE_REGRESSION","LOGISTIC_REGRESSION","DECISION_TREE_CLASSIFICATION","DECISION_TREE_REGRESSION","MLLIB_LOGISTIC_REGRESSION","MLLIB_DECISION_TREE","MLLIB_LINEAR_REGRESSION"];$scope.isRiskySQL=function(){if($scope.recipeStatus&&$scope.recipeStatus.selectedEngine&&$scope.recipeStatus.selectedEngine.variant=="IN_SNOWFLAKE"){return false}if(!$scope.modelDetails){return false}return safeSQLAlgorithms.indexOf($scope.modelDetails.modeling.algorithm)<0};$scope.hasConditionalOutputs=function(){return $scope.model.conditionalOutputs&&$scope.model.conditionalOutputs.length>0};$scope.isSQL=function(){return $scope.selectedEngine()=="SQL"&&$scope.selectedEngineVariant()!="IN_SNOWFLAKE"&&$scope.model.miniTask.backendType!="VERTICA"};$scope.hasCalibration=function(){return $scope.modelDetails&&$scope.modelDetails.coreParams.calibration.calibrationMethod!="NO_CALIBRATION"};$scope.canForceOriginalEngine=function(){if(!$scope.model||!$scope.model.miniTask)return;if($scope.isExternalMLflowModel())return false;if($scope.isCausalPrediction())return false;var pyCase=$scope.model.miniTask.backendType=="PY_MEMORY"&&$scope.selectedEngine()=="DSS";var kerasCase=$scope.model.miniTask.backendType=="KERAS"&&$scope.selectedEngine()=="DSS";var mllibCase=$scope.model.miniTask.backendType=="MLLIB"&&$scope.selectedEngine()=="SPARK";return pyCase||mllibCase||kerasCase};$scope.willUseSpark=function(){return $scope.selectedEngine()=="SPARK"};$scope.canComputeExplanations=function(){if(!$scope.model||!$scope.model.miniTask||!$scope.modelDetails){return}if($scope.isMLflowModel()&&$scope.desc.mlFlowOutputStyle=="RAW"){return false}if($scope.isTimeseriesForecasting()||$scope.isCausalPrediction()){return false}if(!$scope.isExternalMLflowModel()){return $scope.model.miniTask.backendType=="PY_MEMORY"&&$scope.selectedEngine()=="DSS"}const canHavePerf=($scope.isBinaryClassification()||$scope.isMulticlass())&&$scope.isProbaAware()||$scope.isRegression();if(!canHavePerf){return false}if(!$scope.modelDetails.perf){r