(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    // (!) This controller previously was in static/dataiku/js/simple_report/config_ui.js
    app.controller('BoxplotsChartDefController', function($scope, ChartTypeChangeHandler, ChartColumnTypeUtils) {
        $scope.acceptMeasure = function(data) {
            return ChartTypeChangeHandler.boxplotsAcceptMeasure(data);
        };
        $scope.acceptBreakdownDimension = function(data) {
            return ChartTypeChangeHandler.boxplotsAcceptBreakdown(data);
        };

        $scope.acceptColorDimension = function(data) {
            return ChartTypeChangeHandler.boxplotsAcceptColorDimension(data);
        };

        $scope.getBreakdownDimList = (data) => ChartColumnTypeUtils.isHierarchy(data) ? $scope.chart.def.boxplotBreakdownHierarchyDimension : $scope.chart.def.boxplotBreakdownDim;
    });
})();
