(function() {
    "use strict";

    const projectRightColumnSummary = {
        templateUrl: "static/dataiku/shared/components/project-right-column-summary/project-right-column-summary.component.html",
        bindings: {
            summary: "<",
            canWriteProject: "<",
            activeTab: "<",
            clickTabFrom: "<",
            displayedTabs: "<",
            editCustomFields: "<",
            featureFlagEnabled: "<"
        },
        controller: function(
            $scope,
            $rootScope,
            $state,
            DataikuAPI,
            ActivityIndicator,
            ProjectActionsService,
            translate
        ) {
            const ctrl = this;
            $scope.translate = translate;

            ctrl.$onInit = function() {
                ctrl.projectHref = $state.href("projects.project.home.summary",
                    { projectKey: ctrl.summary.projectKey });
            };

            // For updating tags
            $scope.$on("objectSummaryEdited", function() {
                DataikuAPI.projects.saveSummary(ctrl.summary.projectKey, ctrl.summary)
                    .success(ActivityIndicator.success.bind(null, "Saved"))
                    .error(setErrorInScope.bind($scope));
            });

            /** ACTIONS **/
            ctrl.duplicateThisProject = () => ProjectActionsService.duplicateThisProject($scope, ctrl.summary);
            ctrl.exportThisProject = () => ProjectActionsService.exportThisProject($scope, ctrl.summary);
            ctrl.deleteThisProject = () => ProjectActionsService.deleteThisProject($scope, ctrl.summary);
            ctrl.moveThisProject = () => ProjectActionsService.moveThisProject($scope, ctrl.summary);
            ctrl.explainThisProject = () => ProjectActionsService.explainThisProject($scope, ctrl.summary);
            ctrl.saveCustomFields = function (customFields) {
                $scope.$emit('customFieldsSummaryEdited', customFields);
            };

            /** PERMISSIONS **/
            ctrl.isProjectAdmin = () => ctrl.summary && ctrl.summary.isProjectAdmin;
            ctrl.isProjectAnalystRW = () => ctrl.summary && ctrl.summary.canWriteProjectContent;
            ctrl.canManageBundles = () => $rootScope.appConfig && ctrl.summary &&
                ($rootScope.appConfig.requireProjectAdminPermissionToExportAndBundleProjects && ctrl.summary.isProjectAdmin)
                || (!$rootScope.appConfig.requireProjectAdminPermissionToExportAndBundleProjects && ctrl.summary.canWriteProjectContent);
            ctrl.showActionsSection = () => ctrl.canManageBundles() || $rootScope.appConfig.aiExplanationsEnabled;

            // custom fields
            ctrl.$onChanges = () => {
                ctrl.currentCustomFieldsTabData = (ctrl.displayedTabs || []).find(t => t.name === ctrl.activeTab)?.customFieldsData;
            };
        },
    };

    angular.module("dataiku.shared").component("projectRightColumnSummary", projectRightColumnSummary);
})();
