(function() {
    'use strict';

    angular.module('dataiku.workspaces').controller('WorkspaceObjectRightColumnActions', workspaceObjectRightColumnActionsController);

    /**
     * Controller used by the standardizedSidePanel to display information about workspace objects
     */
    function workspaceObjectRightColumnActionsController($controller, $scope, $rootScope, DataikuAPI, ActiveProjectKey, WT1) {
        $controller('_TaggableObjectPageRightColumnActions', { $scope });
        $controller('DatasetsCommon', { $scope });

        function updateUserInterests() {
            const { type, id, workspaceKey } = $scope.selection.selectedObject;
            DataikuAPI.interests.getForObject($rootScope.appConfig.login, type, ActiveProjectKey.get(), id, workspaceKey).success(data => {
                $scope.selection.selectedObject.interest = data;
                if ($scope.objectFullInfo) {
                    // Update details tab
                    $scope.objectFullInfo.interest = data;
                }
            }).error(setErrorInScope.bind($scope));
        }

        if ($scope.actions.includes('star') || $scope.actions.includes('watch')) {
            $scope.selection.selectedObject.interest = {};

            $scope.starWorkspaceObject = (value) => {
                $scope.starObjects(value);
                WT1.event('workspaces-star-object', { from: 'right-panel', star: value, objectType: $scope.selection.selectedObject.type });
            };
            
            const interestsListener = $rootScope.$on('userInterestsUpdated', updateUserInterests);
            $scope.$on("$destroy", interestsListener);
            updateUserInterests();
        }       
    }
}());
