import json

import pandas as pd
import logging
from dataiku.external_ml.proxy_model.common.outputformat import BaseReader
from dataiku.external_ml.proxy_model.sagemaker.outputformat import SagemakerJSONReader

logger = logging.getLogger(__name__)


class SagemakerJSONLINESReader(BaseReader):
    NAME = "OUTPUT_SAGEMAKER_JSONLINES"

    def __init__(self, prediction_type, value_to_class):
        super(SagemakerJSONLINESReader, self).__init__(prediction_type, value_to_class)
        self.json_reader = SagemakerJSONReader(prediction_type, value_to_class)

    def can_read(self, endpoint_output):
        try:
            self.read(endpoint_output)
            logger.info("Predictions are in JSONLINES format")
            return True
        except Exception as e:
            logger.info("Predictions are not in JSONLINES format")
            logger.debug("JSONLINES Parse exception: {}".format(e))
            return False

    def read_binary(self, endpoint_output):
        predictions = SagemakerJSONLINESReader.parse_endpoint_output(endpoint_output)
        self.json_reader.init_prediction_property(predictions)
        return pd.DataFrame(self.json_reader.read_binary_parsed(predictions))

    def read_multiclass(self, endpoint_output):
        predictions = SagemakerJSONLINESReader.parse_endpoint_output(endpoint_output)
        self.json_reader.init_prediction_property(predictions)
        return pd.DataFrame(self.json_reader.read_multiclass_parsed(predictions))

    def read_regression(self, endpoint_output):
        predictions = SagemakerJSONLINESReader.parse_endpoint_output(endpoint_output)
        self.json_reader.init_prediction_property(predictions)
        return pd.DataFrame(self.json_reader.read_regression_parsed(predictions))

    @staticmethod
    def parse_endpoint_output(endpoint_output):
        output_lines = endpoint_output.decode("utf-8").strip().split("\n")
        parsed_output = [json.loads(line) for line in output_lines]
        return parsed_output
