from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ...connections.abstract_sql_connection.custom_database_property import CustomDatabaseProperty, _CustomDatabaseProperty
    from ...containers.exec.container_exec_selection.container_exec_selection import ContainerExecSelection, _ContainerExecSelection

'''
Translated from class com.dataiku.dip.dao.SavedModel$AgentSettings
Via: com.dataiku.dip.dao.SavedModel$ToolsUsingAgentSettings
'''


class _AgentSettings(TypedDict):
    containerExecSelection: 'ContainerExecSelection'
    dkuProperties: List['CustomDatabaseProperty']
    maxParallelRequestsPerProcess: int
    minimumRetentionTimeSeconds: NotRequired[Optional[int]]
    singleInstance: bool


#    Translate from class com.dataiku.dip.dao.SavedModel$AgentSettings
#    @deprecated Translation is incomplete: annotate it with PyModel to generate a union of all concrete subclasses
AgentSettings = _AgentSettings


# EOF
