from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .expression_exit_condition import ExpressionExitCondition, _ExpressionExitCondition
    from .scratchpad_has_keys_exit_condition import ScratchpadHasKeysExitCondition, _ScratchpadHasKeysExitCondition
    from .state_has_keys_exit_condition import StateHasKeysExitCondition, _StateHasKeysExitCondition
    from .tools_called_exit_condition import ToolsCalledExitCondition, _ToolsCalledExitCondition

'''
Translated from class com.dataiku.dip.dao.SavedModel$ReactBlockExitCondition
Via: com.dataiku.dip.dao.SavedModel$StandardReactBlock
'''


class _ReactBlockExitCondition(TypedDict):
    nextBlock: str


# List of all concrete subclasses of com.dataiku.dip.dao.SavedModel$ReactBlockExitCondition
ReactBlockExitCondition = Union[
    'ExpressionExitCondition',
    'ScratchpadHasKeysExitCondition',
    'StateHasKeysExitCondition',
    'ToolsCalledExitCondition',
]

# Types of class com.dataiku.dip.dao.SavedModel$ReactBlockExitCondition in PolyJSON mappings (as literal type)
ReactBlockExitConditionTypeLiteral = Literal["EXPRESSION", "SCRATCHPAD_HAS_KEYS", "STATE_HAS_KEYS", "TOOLS_CALLED", ]


# EOF
