from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .stl_guessed_params import STLGuessedParams, _STLGuessedParams
from ...available_result.available_result import AvailableResult, _AvailableResult

'''
Translated from class com.dataiku.dip.eda.compute.computations.timeseries.STLDecomposition$STLDecompositionResult
Via: PyModel annotation in the class hierarchy
'''


class _STLDecompositionResult(_AvailableResult, TypedDict):
    type: Literal["stl_decomposition"]
    guessedParams: 'STLGuessedParams'
    observed: List[float]
    resid: List[float]
    seasonal: List[float]
    time: List[str]
    trend: List[float]


STLDecompositionResult = _STLDecompositionResult


# EOF
