from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .abstract_tool_call import AbstractToolCall, _AbstractToolCall
    from .chat_message_part import ChatMessagePart, _ChatMessagePart
    from .hierarchy_entry import HierarchyEntry, _HierarchyEntry
    from .memory_fragment import MemoryFragment, _MemoryFragment
    from .tool_output import ToolOutput, _ToolOutput
    from .tool_validation_request import ToolValidationRequest, _ToolValidationRequest
    from .tool_validation_response import ToolValidationResponse, _ToolValidationResponse

'''
Translated from class com.dataiku.dip.llm.online.LLMClient$ChatMessage
Via: PyModel annotation in the class hierarchy
'''


class _ChatMessage(TypedDict):
    content: NotRequired[Optional[str]]
    memoryFragment: NotRequired[Optional['MemoryFragment']]
    memoryFragmentTarget: NotRequired[Optional['HierarchyEntry']]
    partOfExample: NotRequired[Optional[bool]]
    parts: NotRequired[Optional[List['ChatMessagePart']]]
    role: str
    toolCalls: NotRequired[Optional[List['AbstractToolCall']]]
    toolOutputs: NotRequired[Optional[List['ToolOutput']]]
    toolValidationRequests: NotRequired[Optional[List['ToolValidationRequest']]]
    toolValidationResponses: NotRequired[Optional[List['ToolValidationResponse']]]


ChatMessage = _ChatMessage


# EOF
