GET_STATE_DESCRIPTOR = {
    "type": "function",
    "function": {
        "name": "__dku_state__get__",
        "description": "Gets a value from the agent's state store (short-term / conversation memory). The state is a simple key-value dictionary",
        "parameters": {
            "type": "object",
            "properties": {
                "key": {
                    "type": "string",
                    "description": "The key to search in the state"
                }
            },
            "required": ["key"]
        }
    }
}

GET_STATE_NAME = "__dku_state__get__"

SET_STATE_DESCRIPTOR = {
    "type": "function",
    "function": {
        "name": "__dku_state_set__",
        "description": "Writes a value to the agent's state store (short-term / conversation memory). The state is a simple key-value dictionary",
        "parameters": {
            "type": "object",
            "properties": {
                "key": {
                    "type": "string",
                    "description": "The key to write"
                },
                "value": {
                    "oneOf": [
                        { "type": "string" },
                        { "type": "number" },
                        { "type": "boolean" },
                        #{ "type": "array" },
                        #{ "type": "object" },
                        { "type": "null" }
                    ],
                    "description": "The value to write. Use null to delete a key from the state."
                }
            },
            "required": ["key", "value"]
        }
    }
}

SET_STATE_NAME = "__dku_state_set__"

GET_SCRATCHPAD_DESCRIPTOR = {
    "type": "function",
    "function": {
        "name": "__dku_scratchpad__get__",
        "description": "Gets a value from the agent's scratchpad store (single-turn memory). The scratchpad is a simple key-value dictionary",
        "parameters": {
            "type": "object",
            "properties": {
                "key": {
                    "type": "string",
                    "description": "The key to search in the scratchpad"
                }
            },
            "required": ["key"]
        }
    }
}

GET_SCRATCHPAD_NAME = "__dku_scratchpad__get__"

SET_SCRATCHPAD_DESCRIPTOR = {
    "type": "function",
    "function": {
        "name": "__dku_scratchpad_set__",
        "description": "Writes a value to the agent's scratchpad store (single-turn memory). The scratchpad is a simple key-value dictionary",
        "parameters": {
            "type": "object",
            "properties": {
                "key": {
                    "type": "string",
                    "description": "The key to write"
                },
                "value": {
                    "oneOf": [
                        { "type": "string" },
                        { "type": "number" },
                        { "type": "boolean" },
                        #{ "type": "array" },
                        #{ "type": "object" },
                        { "type": "null" }
                    ],
                    "description": "The value to write. Use null to delete a key from the scratchpad."
                }
            },
            "required": ["key", "value"]
        }
    }
}

SET_SCRATCHPAD_NAME = "__dku_scratchpad_set__"