import copy

from govern.models import Artifact, EnrichedArtifact

class Handler:
    def __init__(self, hook_phase, new_enriched_artifact, existing_enriched_artifact, auth_ctx_identifier, client):
        """
        Instantiate a new Govern hook handler.

        :param str hook_phase: The hook phase: CREATE, DELETE or UPDATE
        :param dict new_enriched_artifact: With hook_phase CREATE or UPDATE, a Python dict of the artifact to create/update. None if DELETE.
        :param dict existing_enriched_artifact: With hook_phase UPDATE or DELETE, a Python dict of the artifact before update/deletion. None if CREATE.
        :param str auth_ctx_identifier: the auth context identifier that triggered the hook
        :param :class:`~dataikuapi.govern_client.GovernClient` client: An instance of :class:`~dataikuapi.govern_client.GovernClient` to access the Govern API
        """

        self.hookPhase = hook_phase
        self.artifact = Artifact(copy.deepcopy(new_enriched_artifact['artifact'])) if new_enriched_artifact is not None and 'artifact' in new_enriched_artifact else None
        self.newEnrichedArtifact = EnrichedArtifact(new_enriched_artifact) if new_enriched_artifact is not None else None
        self.existingEnrichedArtifact = EnrichedArtifact(existing_enriched_artifact) if existing_enriched_artifact is not None else None
        self.authCtxIdentifier = auth_ctx_identifier
        self.client = client
        self.fieldMessages = {}
        self.message = ''
        self.artifactIdsToUpdate = []
        self.status = 'SUCCESS'

instance = None

def get_handler():
    """
    Return the current instance of :class:`govern.core.Handler`,
    previously set using :meth:`set_handler`

    :return: the instance of :class:`govern.core.Handler` that was previously set with :meth:`set_handler`
    """
    if instance is not None:
        return instance
    raise Exception("Handler not set")

def set_handler(handler):
    """
    Set the current instance of :class:`govern.core.Handler`

    :return: None
    """
    global instance
    instance = handler
