import mlflow
import pandas as pd
from mlflow.metrics import ari_grade_level

def evaluate(input_df, recipe_params, interpreted_columns, **kwargs):
    dataframe_with_interpreted_output = pd.concat([input_df, pd.Series(interpreted_columns.output, name="interpreted_output")], axis=1)

    with mlflow.start_run():
        results = mlflow.evaluate(
            data=input_df,
            targets=recipe_params.ground_truth_column_name,
            predictions="interpreted_output",
            extra_metrics=[ari_grade_level()],
        )
        return results.metrics['ari_grade_level/v1/mean'], None
