CREATE FUNCTION artifacts_timeline_at_action(action_id BIGINT, artifact_ids TEXT[])
RETURNS TABLE (
    history_action_id BIGINT,
    history_action_timestamp TIMESTAMP WITH TIME ZONE,
    history_action_user TEXT,
    _revision_timestamp TIMESTAMP WITH TIME ZONE,
    artifact_id TEXT,
    foreign_entity INT,
    history_action_json JSONB,
    after_blueprint_json JSONB,
    after_blueprint_version_json JSONB,
    after_blueprint_version_trace_json JSONB,
    after_artifact_json_with_relationships JSONB,
    after_signoffs JSONB,
    after_user_mapping_user_login TEXT,
    after_group_mapping_group_name TEXT,
    after_global_api_key_mapping_api_key_id TEXT,
    before_blueprint_json JSONB,
    before_blueprint_version_json JSONB,
    before_blueprint_version_trace_json JSONB,
    before_artifact_json_with_relationships JSONB,
    before_signoffs JSONB,
    before_user_mapping_user_login TEXT,
    before_group_mapping_group_name TEXT,
    before_global_api_key_mapping_api_key_id TEXT
)
LANGUAGE plpgsql AS
    $func$
BEGIN
    RETURN QUERY
WITH
main_filtered_timeline_query AS (
    SELECT
        partial_artifact_global_timeline.*
    FROM
        partial_artifact_global_timeline
    WHERE
        partial_artifact_global_timeline.history_action_id = action_id and (artifact_ids IS NULL OR partial_artifact_global_timeline.artifact_id = any(artifact_ids))
),
aggregated_timeline_query AS (
    SELECT
        main_filtered_timeline_query.history_action_id,
        main_filtered_timeline_query.min_revision_timestamp,
        main_filtered_timeline_query.max_revision_timestamp,
        ARRAY_AGG(main_filtered_timeline_query.artifact_id) AS artifact_ids
    FROM
        main_filtered_timeline_query
    GROUP BY 
        main_filtered_timeline_query.history_action_id, 
        main_filtered_timeline_query.min_revision_timestamp, 
        main_filtered_timeline_query.max_revision_timestamp
),
after_query AS (
    SELECT 
        artifacts_at_timestamp.*
    FROM 
        aggregated_timeline_query
    LEFT JOIN LATERAL
    (
        SELECT 
            *
        FROM
            artifacts_at_timestamp((EXTRACT(epoch FROM aggregated_timeline_query.max_revision_timestamp)::double precision * 1000)::bigint::text, aggregated_timeline_query.artifact_ids)
    ) artifacts_at_timestamp ON TRUE
),
before_query AS (
    SELECT 
        artifacts_at_timestamp.*
    FROM
        aggregated_timeline_query
    LEFT JOIN LATERAL
    (
        SELECT 
            *
        FROM
            artifacts_at_timestamp(((EXTRACT(epoch FROM aggregated_timeline_query.min_revision_timestamp)::double precision * 1000)::bigint - 1)::text, aggregated_timeline_query.artifact_ids)
    ) artifacts_at_timestamp ON TRUE
)
SELECT 
    main_filtered_timeline_query.history_action_id,
    main_filtered_timeline_query.history_action_timestamp,
    main_filtered_timeline_query.history_action_user,
    main_filtered_timeline_query.max_revision_timestamp AS _revision_timestamp,
    main_filtered_timeline_query.artifact_id,
    main_filtered_timeline_query.foreign_entity,
    main_filtered_timeline_query.history_action_json,
    after_query.blueprint_json AS after_blueprint_json,
    after_query.blueprint_version_json AS after_blueprint_version_json,
    after_query.blueprint_version_trace_json AS after_blueprint_version_trace_json,
    after_query.artifact_json_with_relationships AS after_artifact_json_with_relationships,
    after_query.signoffs AS after_signoffs,
    after_query.user_mapping_user_login AS after_user_mapping_user_login,
    after_query.group_mapping_group_name AS after_group_mapping_group_name,
    after_query.global_api_key_mapping_api_key_id AS after_global_api_key_mapping_api_key_id,
    before_query.blueprint_json AS before_blueprint_json,
    before_query.blueprint_version_json AS before_blueprint_version_json,
    before_query.blueprint_version_trace_json AS before_blueprint_version_trace_json,
    before_query.artifact_json_with_relationships AS before_artifact_json_with_relationships,
    before_query.signoffs AS before_signoffs,
    before_query.user_mapping_user_login AS before_user_mapping_user_login,
    before_query.group_mapping_group_name AS before_group_mapping_group_name,
    before_query.global_api_key_mapping_api_key_id AS before_global_api_key_mapping_api_key_id
FROM
    main_filtered_timeline_query
    LEFT JOIN LATERAL
    (
        SELECT 
            *
        FROM 
            after_query
        WHERE 
            after_query.artifact_id = main_filtered_timeline_query.artifact_id
        LIMIT 1
    ) after_query ON true
    LEFT JOIN LATERAL
    (
        SELECT
            *
        FROM
            before_query
        WHERE
            before_query.artifact_id = main_filtered_timeline_query.artifact_id
        LIMIT 1
    ) before_query ON true
    ORDER BY main_filtered_timeline_query.history_action_timestamp DESC, main_filtered_timeline_query.max_revision_timestamp DESC, main_filtered_timeline_query.artifact_id DESC;
END;
$func$;
