from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ..univariate.count_distinct.count_distinct import CountDistinct, _CountDistinct
    from ..univariate.empirical_cdf.empirical_cdf import EmpiricalCDF, _EmpiricalCDF
    from ..univariate.entropy.entropy import Entropy, _Entropy
    from ..univariate.fit_distribution.fit_distribution import FitDistribution, _FitDistribution
    from ..univariate.guess_time_step.guess_time_step import GuessTimeStep, _GuessTimeStep
    from ..univariate.ks_test_2_samp.ks_test_2_samp import KsTest2Samp, _KsTest2Samp
    from ..univariate.kurtosis.kurtosis import Kurtosis, _Kurtosis
    from ..univariate.levene_test_n_samp.levene_test_n_samp import LeveneTestNSamp, _LeveneTestNSamp
    from ..univariate.match_time_step.match_time_step import MatchTimeStep, _MatchTimeStep
    from ..univariate.max.max import Max, _Max
    from ..univariate.max_time.max_time import MaxTime, _MaxTime
    from ..univariate.mean.mean import Mean, _Mean
    from ..univariate.min.min import Min, _Min
    from ..univariate.min_time.min_time import MinTime, _MinTime
    from ..univariate.mood_test_n_samp.mood_test_n_samp import MoodTestNSamp, _MoodTestNSamp
    from ..univariate.one_way_anova.one_way_anova import OneWayAnova, _OneWayAnova
    from ..univariate.pairwise_levene_test.pairwise_levene_test import PairwiseLeveneTest, _PairwiseLeveneTest
    from ..univariate.pairwise_mood_test.pairwise_mood_test import PairwiseMoodTest, _PairwiseMoodTest
    from ..univariate.pairwise_t_test.pairwise_t_test import PairwiseTTest, _PairwiseTTest
    from ..univariate.quantiles.quantiles import Quantiles, _Quantiles
    from ..univariate.sem.sem import Sem, _Sem
    from ..univariate.shapiro.shapiro import Shapiro, _Shapiro
    from ..univariate.sign_test_1_samp.sign_test_1_samp import SignTest1Samp, _SignTest1Samp
    from ..univariate.skewness.skewness import Skewness, _Skewness
    from ..univariate.std_dev.std_dev import StdDev, _StdDev
    from ..univariate.sum.sum import Sum, _Sum
    from ..univariate.t_test_1_samp.t_test_1_samp import TTest1Samp, _TTest1Samp
    from ..univariate.test_distribution.test_distribution import TestDistribution, _TestDistribution
    from ..univariate.variance.variance import Variance, _Variance
    from ..univariate.z_test_1_samp.z_test_1_samp import ZTest1Samp, _ZTest1Samp
from .computation import Computation, _Computation

'''
Translated from class com.dataiku.dip.eda.compute.computations.Computation$UnivariateComputation
Via: PyModel annotation in the class hierarchy
'''


class _UnivariateComputation(_Computation, TypedDict):
    column: str


# List of all concrete subclasses of com.dataiku.dip.eda.compute.computations.Computation$UnivariateComputation
UnivariateComputation = Union[
    'CountDistinct',
    'EmpiricalCDF',
    'Entropy',
    'FitDistribution',
    'GuessTimeStep',
    'KsTest2Samp',
    'Kurtosis',
    'LeveneTestNSamp',
    'MatchTimeStep',
    'Max',
    'MaxTime',
    'Mean',
    'Min',
    'MinTime',
    'MoodTestNSamp',
    'OneWayAnova',
    'PairwiseLeveneTest',
    'PairwiseMoodTest',
    'PairwiseTTest',
    'Quantiles',
    'Sem',
    'Shapiro',
    'SignTest1Samp',
    'Skewness',
    'StdDev',
    'Sum',
    'TTest1Samp',
    'TestDistribution',
    'Variance',
    'ZTest1Samp',
]

# Types of class com.dataiku.dip.eda.compute.computations.Computation$UnivariateComputation in PolyJSON mappings (as literal type)
UnivariateComputationTypeLiteral = Literal["count_distinct", "empirical_cdf", "entropy", "fit_distribution", "guess_time_step", "ks_test_2samp", "kurtosis", "levene_test_nsamp", "match_time_step", "max", "max_time", "mean", "min", "min_time", "mood_test_nsamp", "one_way_anova", "pairwise_levene_test", "pairwise_mood_test", "pairwise_ttest", "quantiles", "sem", "shapiro", "sign_test_1samp", "skewness", "std_dev", "sum", "ttest_1samp", "test_distribution", "variance", "ztest_1samp", ]


# EOF
