from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ..acf.acf import ACF, _ACF
    from ..pacf.pacf import PACF, _PACF
from ..time_series_computation.time_series_computation import TimeSeriesComputation, _TimeSeriesComputation

'''
Translated from class com.dataiku.dip.eda.compute.computations.timeseries.CorrelationFunction
Via: PyModel annotation in the class hierarchy
'''


class _CorrelationFunction(_TimeSeriesComputation, TypedDict):
    pass


# List of all concrete subclasses of com.dataiku.dip.eda.compute.computations.timeseries.CorrelationFunction
CorrelationFunction = Union[
    'ACF',
    'PACF',
]

# Types of class com.dataiku.dip.eda.compute.computations.timeseries.CorrelationFunction in PolyJSON mappings (as literal type)
CorrelationFunctionTypeLiteral = Literal["acf", "pacf", ]


# EOF
