# Python<->Java mapping
from typing import List, Union
from dataikuapi.dss.llm import DSSLLMStreamedCompletionChunk, DSSLLMStreamedCompletionFooter, DSSLLMCompletionResponse, DSSLLMEmbeddingsResponse, DSSLLMImageGenerationResponse

from dataiku.generated_sources.com.dataiku.dip.dao.saved_model.tools_using_agent_settings import ToolsUsingAgentSettings
from dataiku.generated_sources.com.dataiku.dip.dao.saved_model.used_tool import UsedTool
from dataiku.generated_sources.com.dataiku.dip.llm.io.commands.process_single_prompt_command.process_single_prompt_command import ProcessSinglePromptCommand
from dataiku.generated_sources.com.dataiku.dip.llm.io.commands.process_single_embedding_command.process_single_embedding_command import ProcessSingleEmbeddingCommand
from dataiku.generated_sources.com.dataiku.dip.llm.io.commands.process_single_image_generation_command.process_single_image_generation_command import ProcessSingleImageGenerationCommand
from dataiku.generated_sources.com.dataiku.dip.llm.io.commands.stream_response_chunk_or_footer.stream_response_chunk_or_footer import StreamResponseChunkOrFooter
from dataiku.generated_sources.com.dataiku.dip.llm.custom.custom_python_llm_client.start_custom_llm_server_command import StartCustomLLMServerCommand
from dataiku.generated_sources.com.dataiku.dip.llm.langchain.python_llm_server.start_agent_server_command import StartAgentServerCommand
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.chat_message import ChatMessage
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.completion_settings import CompletionSettings
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.embedding_query import EmbeddingQuery
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.embedding_settings import EmbeddingSettings
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.function_tool import FunctionTool
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.function_tool_call import FunctionToolCall
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.tool_output import ToolOutput
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.image_generation_query import ImageGenerationQuery
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.image_generation_response import ImageGenerationResponse
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.llm_mesh_trace_span import LLMMeshTraceSpan
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.single_completion_query import SingleCompletionQuery
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.simple_completion_response import SimpleCompletionResponse
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.simple_embedding_response import SimpleEmbeddingResponse
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.streamed_completion_response_chunk import StreamedCompletionResponseChunk
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.streamed_completion_response_footer import StreamedCompletionResponseFooter
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.agent_hierarchy_entry import AgentHierarchyEntry
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.memory_fragment import MemoryFragment
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.tool_hierarchy_entry import ToolHierarchyEntry
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.tool_validation_response import ToolValidationResponse
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.tool_validation_request import ToolValidationRequest


CompletionResponse = Union[str, DSSLLMCompletionResponse, SimpleCompletionResponse]
EmbeddingResponse = Union[List[float], DSSLLMEmbeddingsResponse, SimpleEmbeddingResponse]
PluginImageGenerationResponse = Union[List[str], str, List[bytes], bytes, DSSLLMImageGenerationResponse, ImageGenerationResponse]
StreamCompletionResponse = Union[str, DSSLLMStreamedCompletionChunk, DSSLLMStreamedCompletionFooter, StreamResponseChunkOrFooter, StreamedCompletionResponseChunk, StreamedCompletionResponseFooter]
