from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ..acf.acf_result import ACFResult, _ACFResult
    from ..pacf.pacf_result import PACFResult, _PACFResult
from ...available_result.available_result import AvailableResult, _AvailableResult

'''
Translated from class com.dataiku.dip.eda.compute.computations.timeseries.CorrelationFunction$CorrelationFunctionResult
Via: PyModel annotation in the class hierarchy
'''


class _CorrelationFunctionResult(_AvailableResult, TypedDict):
    coefficients: List[float]
    confidenceIntervals: List[List[float]]


# List of all concrete subclasses of com.dataiku.dip.eda.compute.computations.timeseries.CorrelationFunction$CorrelationFunctionResult
CorrelationFunctionResult = Union[
    'ACFResult',
    'PACFResult',
]

# Types of class com.dataiku.dip.eda.compute.computations.timeseries.CorrelationFunction$CorrelationFunctionResult in PolyJSON mappings (as literal type)
CorrelationFunctionResultTypeLiteral = Literal["acf", "pacf", ]


# EOF
