from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .below_threshold_handling import BelowThresholdHandling
    from .faithfulness_settings import FaithfulnessSettings, _FaithfulnessSettings
    from .relevancy_settings import RelevancySettings, _RelevancySettings

'''
Translated from class com.dataiku.dip.llm.retrieval.RAGLLMSettings$GuardrailSettings
Via: PyModel annotation in the class hierarchy
'''


class _GuardrailSettings(TypedDict):
    enabled: bool
    handling: 'BelowThresholdHandling'
    threshold: float


# List of all concrete subclasses of com.dataiku.dip.llm.retrieval.RAGLLMSettings$GuardrailSettings
GuardrailSettings = Union[
    'FaithfulnessSettings',
    'RelevancySettings',
]


# EOF
