/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.fs.HDFSableDatasetHandler;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.spark.NativeFormatWriter;
import com.dataiku.dip.spark.package$;
import com.dataiku.dss.spark.WriteMode$;
import java.io.Serializable;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Enumeration;
import scala.Function1;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class DeltaWriter$
extends NativeFormatWriter {
    public static DeltaWriter$ MODULE$;
    private final Logger logger;

    static {
        new DeltaWriter$();
    }

    public void saveDeltaDataset(HDFSableDatasetHandler handler, org.apache.spark.sql.Dataset<Row> df, String partition, Enumeration.Value writeMode) {
        Dataset dataset = handler.getDataset();
        Partition dssPartition = partition != null ? PartitionFactory.fromIdentifier((PartitioningScheme)dataset.getPartitioningSchema(), (String)partition) : Partition.newNP();
        String path = handler.getFullyQualifiedRootPath();
        handler.addExtraConf(df.sqlContext().sparkContext().hadoopConfiguration(), true);
        handler.addExtraConf(package$.MODULE$.getSparkHadoopUtilConf(), true);
        org.apache.spark.sql.Dataset<Row> dssDataframe = this.addPartitionValues(this.adaptDataFrame(df, dataset.getSchema(), dataset.isManaged()), dataset, dssPartition);
        this.logger().info((Object)new StringBuilder(32).append("Saving dataframe as Delta (").append(writeMode).append(") to ").append(path).toString());
        Enumeration.Value value = writeMode;
        Enumeration.Value value2 = WriteMode$.MODULE$.Append();
        DataFrameWriter dfw = dssDataframe.write().mode(!(value != null ? !value.equals(value2) : value2 != null) ? "append" : "overwrite");
        DataFrameWriter dfwp = dssPartition.isNP() || dssPartition.isAll() ? dfw : dfw.partitionBy((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(dssPartition.getScheme().getDimensionNames()).asScala());
        dfwp.format("delta").save(path);
    }

    public org.apache.spark.sql.Dataset<Row> adaptDataFrame(org.apache.spark.sql.Dataset<Row> df, Schema dssSchema, boolean isManaged) {
        ObjectRef dssDataframe = ObjectRef.create(df);
        df.schema().foreach((Function1 & Serializable & scala.Serializable)field -> {
            dssDataframe.elem = DeltaWriter$.MODULE$.adaptDataFrameColumn((org.apache.spark.sql.Dataset<Row>)((org.apache.spark.sql.Dataset)dssDataframe.elem), field, dssSchema, isManaged);
            return BoxedUnit.UNIT;
        });
        return (org.apache.spark.sql.Dataset)dssDataframe.elem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public org.apache.spark.sql.Dataset<Row> adaptDataFrameColumn(org.apache.spark.sql.Dataset<Row> df, StructField field, Schema dssSchema, boolean isManaged) {
        DataType dataType;
        SchemaColumn sc = dssSchema.getColumn(field.name());
        DataType dataType2 = field.dataType();
        TimestampType$ timestampType$ = TimestampType$.MODULE$;
        if (dataType2 == null ? timestampType$ != null : !dataType2.equals(timestampType$)) {
            DataType dataType3 = field.dataType();
            DataType dataType4 = package$.MODULE$.datetimeNoTzDataType();
            if (!(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null)) {
                if (sc == null) return df;
                Type type = sc.getType();
                Type type2 = Type.DATE;
                if (type != null ? !type.equals(type2) : type2 != null) return df;
                String tzId = TimeZone.getDefault().getID();
                this.logger().debug((Object)new StringBuilder(57).append("saving dataframe column ").append(field.name()).append(" as datetime with tz switch from ").append(tzId).toString());
                return df.withColumn(field.name(), functions$.MODULE$.from_utc_timestamp(df.col(field.name()).cast((DataType)TimestampType$.MODULE$), tzId));
            }
        }
        if (BooleanType$.MODULE$.equals(dataType = field.dataType()) ? true : (ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : (LongType$.MODULE$.equals(dataType) ? true : (FloatType$.MODULE$.equals(dataType) ? true : (DoubleType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : (StringType$.MODULE$.equals(dataType) ? true : (dataType instanceof ArrayType ? true : (dataType instanceof MapType ? true : dataType instanceof StructType))))))))))) {
            return df;
        } else {
            if (dataType instanceof DecimalType) {
                this.logger().debug((Object)new StringBuilder(34).append("saving dataframe column ").append(field.name()).append(" as double").toString());
                return df.withColumn(field.name(), df.col(field.name()).cast((DataType)DoubleType$.MODULE$));
            }
            if (dataType instanceof DateType) {
                if (sc == null) return df;
                Type type = sc.getType();
                Type type3 = Type.DATE;
                if (type != null ? !type.equals(type3) : type3 != null) return df;
                String tzId = TimeZone.getDefault().getID();
                this.logger().debug((Object)new StringBuilder(57).append("saving dataframe column ").append(field.name()).append(" as datetime with tz switch from ").append(tzId).toString());
                return df.withColumn(field.name(), functions$.MODULE$.from_utc_timestamp(df.col(field.name()).cast((DataType)TimestampType$.MODULE$), tzId));
            } else {
                this.logger().debug((Object)new StringBuilder(34).append("saving dataframe column ").append(field.name()).append(" as string").toString());
                return df.withColumn(field.name(), df.col(field.name()).cast((DataType)StringType$.MODULE$));
            }
        }
    }

    private Logger logger() {
        return this.logger;
    }

    private DeltaWriter$() {
        MODULE$ = this;
        this.logger = Logger.getLogger((String)"dku.spark.delta");
    }
}

