/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.fs.HDFSableDatasetHandler;
import com.dataiku.dip.datasets.fs.UploadedFilesDatasetHandler;
import com.dataiku.dip.datasets.iceberg.IcebergDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.expressions.GrelToQueryMapping;
import com.dataiku.dip.expressions.GrelToQueryTranslator;
import com.dataiku.dip.expressions.GrelTranslator;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.spark.FastPathHandler$;
import com.dataiku.dip.spark.FlowDatasetRef;
import com.dataiku.dip.spark.HDFSDatasetRDD$;
import com.dataiku.dip.spark.HadoopFormatsSupport$;
import com.dataiku.dip.spark.SnowflakeFastpathSupport$;
import com.dataiku.dip.spark.StdDataikuSparkContext$;
import com.dataiku.dip.spark.StorageBackendsSupport$;
import com.dataiku.dip.spark.package$;
import com.dataiku.dip.sql.OracleSQLDialect;
import com.dataiku.dip.sql.RedshiftSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SnowflakeSQLDialect;
import com.dataiku.dip.sql.TeradataSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.SimpleSelectQueryBuilder;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\ruh!\u0002\u001f>\u0003\u00033\u0005\u0002\u0003+\u0001\u0005+\u0007I\u0011A+\t\u0011\u0005\u0004!\u0011#Q\u0001\nYCQA\u0019\u0001\u0005\u0002\rDQA\u001d\u0001\u0005\u0002MD\u0011\"!\u001a\u0001#\u0003%\t!a\u001a\t\u0013\u0005u\u0004!%A\u0005\u0002\u0005}\u0004\"CAB\u0001E\u0005I\u0011AA@\u0011%\t)\tAI\u0001\n\u0003\t9\tC\u0004\u0002\f\u0002!\t!!$\t\u0013\u0005]\u0006!%A\u0005\u0002\u0005\u001d\u0004\"CA]\u0001E\u0005I\u0011AA@\u0011%\tY\fAI\u0001\n\u0003\ty\bC\u0005\u0002>\u0002\t\n\u0011\"\u0001\u0002\b\"9\u0011q\u0018\u0001\u0005\u0002\u0005\u0005\u0007\"CAh\u0001E\u0005I\u0011AA4\u0011%\t\t\u000eAI\u0001\n\u0003\ty\bC\u0005\u0002T\u0002\t\n\u0011\"\u0001\u0002\u0000!I\u0011Q\u001b\u0001\u0012\u0002\u0013\u0005\u0011q\u0011\u0005\b\u0003/\u0004A\u0011AAm\u0011%\t9\u000fAI\u0001\n\u0003\t9\u0007C\u0005\u0002j\u0002\t\n\u0011\"\u0001\u0002\u0000!I\u00111\u001e\u0001\u0012\u0002\u0013\u0005\u0011q\u0010\u0005\n\u0003[\u0004\u0011\u0013!C\u0001\u0003\u000fCq!a<\u0001\t\u0003\t\t\u0010C\u0005\u0003\u0010\u0001\t\n\u0011\"\u0001\u0002\u0000!I!\u0011\u0003\u0001\u0012\u0002\u0013\u0005\u0011q\u0010\u0005\n\u0005'\u0001\u0011\u0013!C\u0001\u0003\u000fCqA!\u0006\u0001\t\u0003\u00119\u0002C\u0004\u0003\u0016\u0001!\tAa\n\t\u000f\t%\u0003\u0001\"\u0001\u0003L!9!\u0011\f\u0001\u0005\u0002\tm\u0003b\u0002B%\u0001\u0011\u0005!1\r\u0005\b\u0005k\u0002A\u0011\u0001B<\u0011\u001d\u0011)\b\u0001C\u0001\u0005\u000bCqA!'\u0001\t\u0003\u0011Y\nC\u0004\u0003\u001a\u0002!\tA!+\t\u000f\tm\u0006\u0001\"\u0001\u0003>\"9!1\u001a\u0001\u0005\u0002\t5\u0007b\u0002Bp\u0001\u0011\u0005!\u0011\u001d\u0005\b\u0005?\u0004A\u0011\u0001B\u007f\u0011\u001d\u0019\u0019\u0002\u0001C\u0001\u0007+Aqaa\u0005\u0001\t\u0003\u0019\t\u0004C\u0004\u0004J\u0001!\taa\u0013\t\u000f\r%\u0003\u0001\"\u0001\u0004\\!I11\u0010\u0001\u0002\u0002\u0013\u00053Q\u0010\u0005\n\u0007\u001b\u0003\u0011\u0011!C\u0001\u0007\u001fC\u0011ba&\u0001\u0003\u0003%\ta!'\t\u0013\r}\u0005!!A\u0005B\r\u0005\u0006\"CBX\u0001\u0005\u0005I\u0011ABY\u0011%\u0019)\fAA\u0001\n\u0003\u001a9\fC\u0005\u0004:\u0002\t\t\u0011\"\u0011\u0004<\"I1Q\u0018\u0001\u0002\u0002\u0013\u00053qX\u0004\b\u0007\u0007l\u0004\u0012ABc\r\u0019aT\b#\u0001\u0004H\"1!M\u000eC\u0001\u0007\u0013D\u0011ba37\u0005\u0004%\ta!4\t\u0011\rmg\u0007)A\u0005\u0007\u001fD\u0011b!87\u0003\u0003%\tia8\t\u0013\rMh'!A\u0005\n\rU(a\u0004$bgR\u0004\u0016\r\u001e5IC:$G.\u001a:\u000b\u0005yz\u0014!B:qCJ\\'B\u0001!B\u0003\r!\u0017\u000e\u001d\u0006\u0003\u0005\u000e\u000bq\u0001Z1uC&\\WOC\u0001E\u0003\r\u0019w.\\\u0002\u0001+\t9\u0005n\u0005\u0003\u0001\u0011:\u000b\u0006CA%M\u001b\u0005Q%\"A&\u0002\u000bM\u001c\u0017\r\\1\n\u00055S%AB!osJ+g\r\u0005\u0002J\u001f&\u0011\u0001K\u0013\u0002\b!J|G-^2u!\tI%+\u0003\u0002T\u0015\na1+\u001a:jC2L'0\u00192mK\u0006y1\u000f]1sW>\u0013'.Z2u)f\u0004X-F\u0001W!\t9fL\u0004\u0002Y9B\u0011\u0011LS\u0007\u00025*\u00111,R\u0001\u0007yI|w\u000e\u001e \n\u0005uS\u0015A\u0002)sK\u0012,g-\u0003\u0002`A\n11\u000b\u001e:j]\u001eT!!\u0018&\u0002!M\u0004\u0018M]6PE*,7\r\u001e+za\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002ecB\u0019Q\r\u00014\u000e\u0003u\u0002\"a\u001a5\r\u0001\u0011)\u0011\u000e\u0001b\u0001U\n\tA+\u0005\u0002l]B\u0011\u0011\n\\\u0005\u0003[*\u0013qAT8uQ&tw\r\u0005\u0002J_&\u0011\u0001O\u0013\u0002\u0004\u0003:L\b\"\u0002+\u0004\u0001\u00041\u0016aA4fiRiA/!\u0004\u0002(\u0005]\u0012qIA/\u0003C\u0002B!S;go&\u0011aO\u0013\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007a\f9AD\u0002z\u0003\u0007q1A_A\u0001\u001d\tYxP\u0004\u0002}}:\u0011\u0011,`\u0005\u0002\t&\u0011!iQ\u0005\u0003\u0001\u0006K!AP \n\u0007\u0005\u0015Q(\u0001\bGY><H)\u0019;bg\u0016$(+\u001a4\n\t\u0005%\u00111\u0002\u0002\u001e\u0013:\u0004X\u000f\u001e#bi\u0006\u001cX\r\u001e#bi\u00064'/Y7f%\u0016\fG-T8eK*\u0019\u0011QA\u001f\t\u000f\u0005=A\u00011\u0001\u0002\u0012\u0005Q1/\u001d7D_:$X\r\u001f;\u0011\t\u0005M\u00111E\u0007\u0003\u0003+QA!a\u0006\u0002\u001a\u0005\u00191/\u001d7\u000b\u0007y\nYB\u0003\u0003\u0002\u001e\u0005}\u0011AB1qC\u000eDWM\u0003\u0002\u0002\"\u0005\u0019qN]4\n\t\u0005\u0015\u0012Q\u0003\u0002\u000b'Fc5i\u001c8uKb$\bbBA\u0015\t\u0001\u0007\u00111F\u0001\bI\u0006$\u0018m]3u!\u0011\ti#a\r\u000e\u0005\u0005=\"bAA\u0019\u007f\u0005I1m\u001c:f[>$W\r\\\u0005\u0005\u0003k\tyCA\u0004ECR\f7/\u001a;\t\u0013\u0005eB\u0001%AA\u0002\u0005m\u0012\u0001C:b[Bd\u0017N\\4\u0011\t\u0005u\u00121I\u0007\u0003\u0003\u007fQ1!!\u0011@\u0003!!\u0017\r^1tKR\u001c\u0018\u0002BA#\u0003\u007f\u0011QbU1na2Lgn\u001a)be\u0006l\u0007\"CA%\tA\u0005\t\u0019AA&\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0006\u0003\u001b\n9F\u0016\b\u0005\u0003\u001f\n\u0019FD\u0002Z\u0003#J\u0011aS\u0005\u0004\u0003+R\u0015a\u00029bG.\fw-Z\u0005\u0005\u00033\nYF\u0001\u0003MSN$(bAA+\u0015\"I\u0011q\f\u0003\u0011\u0002\u0003\u0007\u00111J\u0001\fG>dW/\u001c8OC6,7\u000f\u0003\u0005\u0002d\u0011\u0001\n\u00111\u0001W\u0003A1\u0017\u000e\u001c;fe\u0016C\bO]3tg&|g.A\u0007hKR$C-\u001a4bk2$HeM\u000b\u0003\u0003SRC!a\u000f\u0002l-\u0012\u0011Q\u000e\t\u0005\u0003_\nI(\u0004\u0002\u0002r)!\u00111OA;\u0003%)hn\u00195fG.,GMC\u0002\u0002x)\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tY(!\u001d\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007hKR$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u0003SC!a\u0013\u0002l\u0005iq-\u001a;%I\u00164\u0017-\u001e7uIU\nQbZ3uI\u0011,g-Y;mi\u00122TCAAEU\r1\u00161N\u0001/O\u0016$H)\u0019;b\rJ\fW.\u001a$s_6DEIR*bE2,w+\u001b;i\r\u0006\u001cH\u000fU1uQ&3\u0007k\\:tS\ndW\rF\tu\u0003\u001f\u000b\t*a%\u0002\u0016\u0006]\u0015\u0011TAN\u0003WCq!a\u0004\n\u0001\u0004\t\t\u0002C\u0004\u0002*%\u0001\r!a\u000b\t\u0013\u0005e\u0012\u0002%AA\u0002\u0005m\u0002\"CA%\u0013A\u0005\t\u0019AA&\u0011%\ty&\u0003I\u0001\u0002\u0004\tY\u0005\u0003\u0005\u0002d%\u0001\n\u00111\u0001W\u0011\u001d\ti*\u0003a\u0001\u0003?\u000baa]2iK6\f\u0007\u0003BAQ\u0003Ok!!a)\u000b\t\u0005\u0015\u0016QC\u0001\u0006if\u0004Xm]\u0005\u0005\u0003S\u000b\u0019K\u0001\u0006TiJ,8\r\u001e+za\u0016Dq!!,\n\u0001\u0004\ty+A\u0007tG\",W.Y\"pYVlgn\u001d\t\u0007\u0003\u001b\n9&!-\u0011\t\u00055\u00121W\u0005\u0005\u0003k\u000byC\u0001\u0007TG\",W.Y\"pYVlg.\u0001\u001dhKR$\u0015\r^1Ge\u0006lWM\u0012:p[\"#eiU1cY\u0016<\u0016\u000e\u001e5GCN$\b+\u0019;i\u0013\u001a\u0004vn]:jE2,G\u0005Z3gCVdG\u000fJ\u001a\u0002q\u001d,G\u000fR1uC\u001a\u0013\u0018-\\3Ge>l\u0007\n\u0012$TC\ndWmV5uQ\u001a\u000b7\u000f\u001e)bi\"Le\rU8tg&\u0014G.\u001a\u0013eK\u001a\fW\u000f\u001c;%i\u0005At-\u001a;ECR\fgI]1nK\u001a\u0013x.\u001c%E\rN\u000b'\r\\3XSRDg)Y:u!\u0006$\b.\u00134Q_N\u001c\u0018N\u00197fI\u0011,g-Y;mi\u0012*\u0014\u0001O4fi\u0012\u000bG/\u0019$sC6,gI]8n\u0011\u001235+\u00192mK^KG\u000f\u001b$bgR\u0004\u0016\r\u001e5JMB{7o]5cY\u0016$C-\u001a4bk2$HEN\u0001\fO\u0016$\u0018i\u001d*f[>$X\rF\u0007u\u0003\u0007\f)-a2\u0002J\u0006-\u0017Q\u001a\u0005\b\u0003\u001fq\u0001\u0019AA\t\u0011\u001d\tIC\u0004a\u0001\u0003WA\u0011\"!\u000f\u000f!\u0003\u0005\r!a\u000f\t\u0013\u0005%c\u0002%AA\u0002\u0005-\u0003\"CA0\u001dA\u0005\t\u0019AA&\u0011!\t\u0019G\u0004I\u0001\u0002\u00041\u0016!F4fi\u0006\u001b(+Z7pi\u0016$C-\u001a4bk2$HeM\u0001\u0016O\u0016$\u0018i\u001d*f[>$X\r\n3fM\u0006,H\u000e\u001e\u00135\u0003U9W\r^!t%\u0016lw\u000e^3%I\u00164\u0017-\u001e7uIU\nQcZ3u\u0003N\u0014V-\\8uK\u0012\"WMZ1vYR$c'\u0001\thKR\f5\u000fS5wKN,'O^3seQiA/a7\u0002^\u0006}\u0017\u0011]Ar\u0003KDq!a\u0004\u0014\u0001\u0004\t\t\u0002C\u0004\u0002*M\u0001\r!a\u000b\t\u0013\u0005e2\u0003%AA\u0002\u0005m\u0002\"CA%'A\u0005\t\u0019AA&\u0011%\tyf\u0005I\u0001\u0002\u0004\tY\u0005\u0003\u0005\u0002dM\u0001\n\u00111\u0001W\u0003i9W\r^!t\u0011&4Xm]3sm\u0016\u0014(\u0007\n3fM\u0006,H\u000e\u001e\u00134\u0003i9W\r^!t\u0011&4Xm]3sm\u0016\u0014(\u0007\n3fM\u0006,H\u000e\u001e\u00135\u0003i9W\r^!t\u0011&4Xm]3sm\u0016\u0014(\u0007\n3fM\u0006,H\u000e\u001e\u00136\u0003i9W\r^!t\u0011&4Xm]3sm\u0016\u0014(\u0007\n3fM\u0006,H\u000e\u001e\u00137\u0003]9W\r^!t\u0011\u0006$wn\u001c9Ge>l\u0007\n\u0012$TC\ndW\rF\bu\u0003g\f)0a>\u0003\b\t%!1\u0002B\u0007\u0011\u001d\ty\u0001\u0007a\u0001\u0003#Aq!!\u000b\u0019\u0001\u0004\tY\u0003C\u0004\u0002zb\u0001\r!a?\u0002\u0007\u0011\u001c\b\u000e\u0005\u0003\u0002~\n\rQBAA\u0000\u0015\u0011\u0011\t!a\u0010\u0002\u0005\u0019\u001c\u0018\u0002\u0002B\u0003\u0003\u007f\u0014a\u0003\u0013#G'\u0006\u0014G.\u001a#bi\u0006\u001cX\r\u001e%b]\u0012dWM\u001d\u0005\b\u0003sA\u0002\u0019AA\u001e\u0011%\ty\u0006\u0007I\u0001\u0002\u0004\tY\u0005C\u0005\u0002Ja\u0001\n\u00111\u0001\u0002L!A\u00111\r\r\u0011\u0002\u0003\u0007a+A\u0011hKR\f5\u000fS1e_>\u0004hI]8n\u0011\u001235+\u00192mK\u0012\"WMZ1vYR$S'A\u0011hKR\f5\u000fS1e_>\u0004hI]8n\u0011\u001235+\u00192mK\u0012\"WMZ1vYR$c'A\u0011hKR\f5\u000fS1e_>\u0004hI]8n\u0011\u001235+\u00192mK\u0012\"WMZ1vYR$s'\u0001\u0005hKR\f5oQ:w)5!(\u0011\u0004B\u000e\u0005?\u0011\tCa\t\u0003&!9\u0011q\u0002\u000fA\u0002\u0005E\u0001b\u0002B\u000f9\u0001\u0007\u00111`\u0001\bQ\u0006tG\r\\3s\u0011\u001d\tI\u0005\ba\u0001\u0003\u0017Bq!!(\u001d\u0001\u0004\ty\nC\u0004\u0002:q\u0001\r!a\u000f\t\u000f\u00055F\u00041\u0001\u00020R\tBO!\u000b\u0003,\t5\"q\u0006B\u0019\u0005g\u0011)Da\u0010\t\u000f\u0005=Q\u00041\u0001\u0002\u0012!9!QD\u000fA\u0002\u0005m\bbBA%;\u0001\u0007\u00111\n\u0005\b\u0003;k\u0002\u0019AAP\u0011\u001d\tI$\ba\u0001\u0003wAq!!,\u001e\u0001\u0004\ty\u000bC\u0004\u00038u\u0001\rA!\u000f\u0002\u000f=\u0004H/[8ogB)qKa\u000fW-&\u0019!Q\b1\u0003\u00075\u000b\u0007\u000fC\u0004\u0003Bu\u0001\rAa\u0011\u0002\u000bA\fG\u000f[:\u0011\u000b\u00055#Q\t,\n\t\t\u001d\u00131\f\u0002\u0004'\u0016\f\u0018!C4fi\u0006\u001b(j]8o)5!(Q\nB(\u0005#\u0012\u0019F!\u0016\u0003X!9\u0011q\u0002\u0010A\u0002\u0005E\u0001b\u0002B\u000f=\u0001\u0007\u00111 \u0005\b\u0003\u0013r\u0002\u0019AA&\u0011\u001d\tiJ\ba\u0001\u0003?Cq!!\u000f\u001f\u0001\u0004\tY\u0004C\u0004\u0002.z\u0001\r!a,\u0002\u001b\r\fg.\u00168oKN$(j]8o)\t\u0011i\u0006E\u0002J\u0005?J1A!\u0019K\u0005\u001d\u0011un\u001c7fC:$\u0012\u0003\u001eB3\u0005O\u0012IGa\u001b\u0003n\t=$\u0011\u000fB:\u0011\u001d\ty\u0001\ta\u0001\u0003#AqA!\b!\u0001\u0004\tY\u0010C\u0004\u0002J\u0001\u0002\r!a\u0013\t\u000f\u0005u\u0005\u00051\u0001\u0002 \"9\u0011\u0011\b\u0011A\u0002\u0005m\u0002bBAWA\u0001\u0007\u0011q\u0016\u0005\b\u0005o\u0001\u0003\u0019\u0001B\u001d\u0011\u001d\u0011\t\u0005\ta\u0001\u0005\u0007\nAbZ3u\u0003N\u0004\u0016M]9vKR$R\u0002\u001eB=\u0005w\u0012iHa \u0003\u0002\n\r\u0005bBA\bC\u0001\u0007\u0011\u0011\u0003\u0005\b\u0005;\t\u0003\u0019AA~\u0011\u001d\tI%\ta\u0001\u0003\u0017Bq!!(\"\u0001\u0004\ty\nC\u0004\u0002:\u0005\u0002\r!a\u000f\t\u000f\u00055\u0016\u00051\u0001\u00020R\tBOa\"\u0003\n\n-%Q\u0012BH\u0005#\u0013\u0019Ja&\t\u000f\u0005=!\u00051\u0001\u0002\u0012!9!Q\u0004\u0012A\u0002\u0005m\bbBA%E\u0001\u0007\u00111\n\u0005\b\u0003;\u0013\u0003\u0019AAP\u0011\u001d\tID\ta\u0001\u0003wAq!!,#\u0001\u0004\ty\u000bC\u0004\u0003\u0016\n\u0002\rA!\u0018\u0002\u0017%tg-\u001a:TG\",W.\u0019\u0005\b\u0005\u0003\u0012\u0003\u0019\u0001B\"\u0003!9W\r^!t\u001fJ\u001bE#\u0004;\u0003\u001e\n}%\u0011\u0015BR\u0005K\u00139\u000bC\u0004\u0002\u0010\r\u0002\r!!\u0005\t\u000f\tu1\u00051\u0001\u0002|\"9\u0011\u0011J\u0012A\u0002\u0005-\u0003bBAOG\u0001\u0007\u0011q\u0014\u0005\b\u0003s\u0019\u0003\u0019AA\u001e\u0011\u001d\tik\ta\u0001\u0003_#\u0012\u0003\u001eBV\u0005[\u0013yK!-\u00034\nU&q\u0017B]\u0011\u001d\ty\u0001\na\u0001\u0003#AqA!\b%\u0001\u0004\tY\u0010C\u0004\u0002J\u0011\u0002\r!a\u0013\t\u000f\u0005uE\u00051\u0001\u0002 \"9\u0011\u0011\b\u0013A\u0002\u0005m\u0002bBAWI\u0001\u0007\u0011q\u0016\u0005\b\u0005+#\u0003\u0019\u0001B/\u0011\u001d\u0011\t\u0005\na\u0001\u0005\u0007\nacZ3u\u0003N$U\r\u001c;b\rJ|W\u000e\u0013#G'\u0006\u0013G.\u001a\u000b\u000ei\n}&\u0011\u0019Bb\u0005\u000b\u00149M!3\t\u000f\u0005=Q\u00051\u0001\u0002\u0012!9!QD\u0013A\u0002\u0005m\bbBA%K\u0001\u0007\u00111\n\u0005\b\u0003;+\u0003\u0019AAP\u0011\u001d\tI$\na\u0001\u0003wAq!!,&\u0001\u0004\ty+\u0001\u0006hKR\f5\u000fR3mi\u0006$r\u0002\u001eBh\u0005#\u0014\u0019Na6\u0003Z\nm'Q\u001c\u0005\b\u0003\u001f1\u0003\u0019AA\t\u0011\u001d\u0011iB\na\u0001\u0003wDaA!6'\u0001\u00041\u0016\u0001\u00029bi\"Dq!!\u0013'\u0001\u0004\tY\u0005C\u0004\u0002\u001e\u001a\u0002\r!a(\t\u000f\u0005eb\u00051\u0001\u0002<!9\u0011Q\u0016\u0014A\u0002\u0005=\u0016AD4fi\u0006\u001b8K\\8xM2\f7.\u001a\u000b\u0010i\n\r(Q\u001dBz\u0005k\u00149P!?\u0003|\"9\u0011qB\u0014A\u0002\u0005E\u0001b\u0002BtO\u0001\u0007!\u0011^\u0001\u000fI\u0006$\u0018m]3u\u0011\u0006tG\r\\3s!\u0011\u0011YOa<\u000e\u0005\t5(\u0002BA\f\u0003\u007fIAA!=\u0003n\nq\u0012IY:ue\u0006\u001cGoU)M)\u0006\u0014G.\u001a#bi\u0006\u001cX\r\u001e%b]\u0012dWM\u001d\u0005\b\u0003;;\u0003\u0019AAP\u0011\u001d\tIe\na\u0001\u0003\u0017Bq!!\u000f(\u0001\u0004\tY\u0004C\u0004\u0002.\u001e\u0002\r!a,\t\r\u0005\rt\u00051\u0001W)U!(q`B\u0001\u0007\u0007\u0019)aa\u0002\u0004\n\r-1QBB\b\u0007#Aq!a\u0004)\u0001\u0004\t\t\u0002C\u0004\u0003h\"\u0002\rA!;\t\u000f\u0005u\u0005\u00061\u0001\u0002 \"9\u0011\u0011\n\u0015A\u0002\u0005-\u0003bBA\u001dQ\u0001\u0007\u00111\b\u0005\b\u0003[C\u0003\u0019AAX\u0011\u0019\t\u0019\u0007\u000ba\u0001-\"9!Q\u0013\u0015A\u0002\tu\u0003b\u0002B\u001cQ\u0001\u0007!\u0011\b\u0005\u0007\u0003/A\u0003\u0019\u0001,\u0002\u0019\u001d,G/Q:JG\u0016\u0014WM]4\u0015\u001fQ\u001c9b!\u0007\u0004(\r%21FB\u0017\u0007_Aq!a\u0004*\u0001\u0004\t\t\u0002C\u0004\u0003h&\u0002\raa\u0007\u0011\t\ru11E\u0007\u0003\u0007?QAa!\t\u0002@\u00059\u0011nY3cKJ<\u0017\u0002BB\u0013\u0007?\u0011Q#S2fE\u0016\u0014x\rR1uCN,G\u000fS1oI2,'\u000fC\u0004\u0002\u001e&\u0002\r!a(\t\u000f\u0005%\u0013\u00061\u0001\u0002L!9\u0011\u0011H\u0015A\u0002\u0005m\u0002bBAWS\u0001\u0007\u0011q\u0016\u0005\u0007\u0003GJ\u0003\u0019\u0001,\u0015+Q\u001c\u0019d!\u000e\u00048\rm2QHB \u0007\u0003\u001a\u0019e!\u0012\u0004H!9\u0011q\u0002\u0016A\u0002\u0005E\u0001b\u0002BtU\u0001\u000711\u0004\u0005\b\u0007sQ\u0003\u0019AA&\u00039\tX/\u00197jM&,G\rV1cY\u0016Dq!!(+\u0001\u0004\ty\nC\u0004\u0002J)\u0002\r!a\u0013\t\u000f\u0005e\"\u00061\u0001\u0002<!9\u0011Q\u0016\u0016A\u0002\u0005=\u0006BBA2U\u0001\u0007a\u000bC\u0004\u0003\u0016*\u0002\rA!\u0018\t\u000f\t]\"\u00061\u0001\u0003:\u0005Aq-\u001a;BgN\u000bF\nF\bu\u0007\u001b\u001aye!\u0015\u0004T\rU3qKB-\u0011\u001d\tya\u000ba\u0001\u0003#AqAa:,\u0001\u0004\u0011I\u000fC\u0004\u0002\u001e.\u0002\r!a(\t\u000f\u0005%3\u00061\u0001\u0002L!9\u0011\u0011H\u0016A\u0002\u0005m\u0002bBAWW\u0001\u0007\u0011q\u0016\u0005\u0007\u0003GZ\u0003\u0019\u0001,\u00153Q\u001cifa\u0018\u0004b\r\r4QMB4\u0007S\u001aYg!\u001c\u0004r\rU4\u0011\u0010\u0005\b\u0003\u001fa\u0003\u0019AA\t\u0011\u001d\u00119\u000f\fa\u0001\u0005SDq!!(-\u0001\u0004\ty\nC\u0004\u0002J1\u0002\r!a\u0013\t\u000f\u0005eB\u00061\u0001\u0002<!9\u0011Q\u0016\u0017A\u0002\u0005=\u0006BBA2Y\u0001\u0007a\u000bC\u0004\u0003\u00162\u0002\rA!\u0018\t\r\r=D\u00061\u0001W\u0003\u001dQGMY2Ve2Daaa\u001d-\u0001\u00041\u0016A\u00036eE\u000e$%/\u001b<fe\"91q\u000f\u0017A\u0002\te\u0012a\u00036eE\u000e|\u0005\u000f^5p]NDa!a\u0006-\u0001\u00041\u0016!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0004\u0000A!1\u0011QBF\u001b\t\u0019\u0019I\u0003\u0003\u0004\u0006\u000e\u001d\u0015\u0001\u00027b]\u001eT!a!#\u0002\t)\fg/Y\u0005\u0004?\u000e\r\u0015\u0001\u00049s_\u0012,8\r^!sSRLXCABI!\rI51S\u0005\u0004\u0007+S%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u00018\u0004\u001c\"I1QT\u0018\u0002\u0002\u0003\u00071\u0011S\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\r\r\u0006#BBS\u0007WsWBABT\u0015\r\u0019IKS\u0001\u000bG>dG.Z2uS>t\u0017\u0002BBW\u0007O\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!QLBZ\u0011!\u0019i*MA\u0001\u0002\u0004q\u0017\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\rE\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\r}\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0003^\r\u0005\u0007\u0002CBOi\u0005\u0005\t\u0019\u00018\u0002\u001f\u0019\u000b7\u000f\u001e)bi\"D\u0015M\u001c3mKJ\u0004\"!\u001a\u001c\u0014\u0007YB\u0015\u000b\u0006\u0002\u0004F\u00061An\\4hKJ,\"aa4\u0011\t\rE7q[\u0007\u0003\u0007'TAa!6\u0002\u001c\u0005)An\\45U&!1\u0011\\Bj\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013aB;oCB\u0004H._\u000b\u0005\u0007C\u001c\t\u0010\u0006\u0003\u0004d\u000e%\b\u0003B%\u0004fZK1aa:K\u0005\u0019y\u0005\u000f^5p]\"I11\u001e\u001e\u0002\u0002\u0003\u00071Q^\u0001\u0004q\u0012\u0002\u0004\u0003B3\u0001\u0007_\u00042aZBy\t\u0015I'H1\u0001k\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\r]\b\u0003BBA\u0007sLAaa?\u0004\u0004\n1qJ\u00196fGR\u0004")
public abstract class FastPathHandler<T>
implements Product,
scala.Serializable {
    private final String sparkObjectType;

    public static <T> Option<String> unapply(FastPathHandler<T> fastPathHandler) {
        return FastPathHandler$.MODULE$.unapply(fastPathHandler);
    }

    public static Logger logger() {
        return FastPathHandler$.MODULE$.logger();
    }

    public String sparkObjectType() {
        return this.sparkObjectType;
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> get(SQLContext sqlContext, Dataset dataset, SamplingParam sampling, List<String> partitions, List<String> columnNames, String filterExpression) {
        Schema dsSchema = StdDataikuSparkContext$.MODULE$.datasetStoredSchema(dataset);
        List<SchemaColumn> schemaColumns = package$.MODULE$.getSchemaColumns(dsSchema, columnNames);
        StructType schema = package$.MODULE$.dkuToSpark(schemaColumns);
        String logPrefix = new StringBuilder(6).append("get ").append(dataset.getFullName()).append(": ").toString();
        FastPathHandler$.MODULE$.logger().info((Object)new StringBuilder(31).append(logPrefix).append("Loading dataset as Spark ").append(this.sparkObjectType()).append(" type=").append(dataset.getType()).toString());
        String string = dataset.getType();
        if ("HDFS".equals(string)) {
            Tuple2<Object, String> hdfsAccessibility = StorageBackendsSupport$.MODULE$.isHDFSDatasetCompatible(dataset);
            if (!hdfsAccessibility._1$mcZ$sp()) {
                FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(46).append(logPrefix).append("Direct read of HDFS dataset is not supported: ").append(hdfsAccessibility._2()).toString());
                FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(70).append(logPrefix).append("Reading HDFS dataset as remote ").append(this.sparkObjectType()).append(". Computation will not be distributed: ").append(hdfsAccessibility._2()).toString());
                return this.getAsRemote(sqlContext, dataset, sampling, partitions, columnNames, filterExpression);
            }
            return this.getDataFrameFromHDFSableWithFastPathIfPossible(sqlContext, dataset, sampling, partitions, columnNames, filterExpression, schema, schemaColumns);
        }
        if ("S3".equals(string)) {
            Tuple2<Object, String> s3Accessibility = StorageBackendsSupport$.MODULE$.isS3DatasetCompatible(dataset, (AuthCtx)DSSAuthCtx.newNone(), false);
            if (!s3Accessibility._1$mcZ$sp()) {
                FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(44).append(logPrefix).append("Direct read of S3 dataset is not supported: ").append(s3Accessibility._2()).toString());
                FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(68).append(logPrefix).append("Reading S3 dataset as remote ").append(this.sparkObjectType()).append(". Computation will not be distributed: ").append(s3Accessibility._2()).toString());
                return this.getAsRemote(sqlContext, dataset, sampling, partitions, columnNames, filterExpression);
            }
            return this.getDataFrameFromHDFSableWithFastPathIfPossible(sqlContext, dataset, sampling, partitions, columnNames, filterExpression, schema, schemaColumns);
        }
        if ("Azure".equals(string)) {
            Tuple2<Object, String> azureAccessibility = StorageBackendsSupport$.MODULE$.isAzureDatasetCompatible(dataset, (AuthCtx)DSSAuthCtx.newNone(), false);
            if (!azureAccessibility._1$mcZ$sp()) {
                FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(47).append(logPrefix).append("Direct read of Azure dataset is not supported: ").append(azureAccessibility._2()).toString());
                FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(71).append(logPrefix).append("Reading Azure dataset as remote ").append(this.sparkObjectType()).append(". Computation will not be distributed: ").append(azureAccessibility._2()).toString());
                return this.getAsRemote(sqlContext, dataset, sampling, partitions, columnNames, filterExpression);
            }
            return this.getDataFrameFromHDFSableWithFastPathIfPossible(sqlContext, dataset, sampling, partitions, columnNames, filterExpression, schema, schemaColumns);
        }
        if ("GCS".equals(string)) {
            Tuple2<Object, String> gcsAccessibility = StorageBackendsSupport$.MODULE$.isGCSDatasetCompatible(dataset, (AuthCtx)DSSAuthCtx.newNone(), false);
            if (!gcsAccessibility._1$mcZ$sp()) {
                FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(45).append(logPrefix).append("Direct read of GCS dataset is not supported: ").append(gcsAccessibility._2()).toString());
                FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(69).append(logPrefix).append("Reading GCS dataset as remote ").append(this.sparkObjectType()).append(". Computation will not be distributed: ").append(gcsAccessibility._2()).toString());
                return this.getAsRemote(sqlContext, dataset, sampling, partitions, columnNames, filterExpression);
            }
            return this.getDataFrameFromHDFSableWithFastPathIfPossible(sqlContext, dataset, sampling, partitions, columnNames, filterExpression, schema, schemaColumns);
        }
        if ("hiveserver2".equals(string)) {
            return this.getAsHiveserver2(sqlContext, dataset, sampling, partitions, columnNames, filterExpression);
        }
        if ("Snowflake".equals(string)) {
            Tuple2<Object, String> snowflakeAccessibility = StorageBackendsSupport$.MODULE$.isSnowflakeReadCompatible(dataset, filterExpression, sampling);
            if (snowflakeAccessibility._1$mcZ$sp()) {
                FastPathHandler$.MODULE$.logger().info((Object)new StringBuilder(30).append(logPrefix).append("Using Snowflake read fast-path").toString());
                AbstractSQLTableDatasetHandler dsh = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
                return this.getAsSnowflake(sqlContext, dsh, schema, partitions, sampling, schemaColumns, filterExpression);
            }
            FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(51).append(logPrefix).append("Direct read of Snowflake dataset is not supported: ").append(snowflakeAccessibility._2()).toString());
            FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(77).append(logPrefix).append("Reading Snowflake dataset as a remote ").append(this.sparkObjectType()).append(". Computation will not be distributed: ").append(snowflakeAccessibility._2()).toString());
            return this.getAsRemote(sqlContext, dataset, sampling, partitions, columnNames, filterExpression);
        }
        if ("iceberg".equals(string)) {
            Tuple2<Object, String> icebergAccessibility = StorageBackendsSupport$.MODULE$.isIcebergReadCompatible(dataset, filterExpression, sampling, sqlContext);
            if (icebergAccessibility._1$mcZ$sp()) {
                FastPathHandler$.MODULE$.logger().info((Object)new StringBuilder(28).append(logPrefix).append("Using Iceberg read fast-path").toString());
                IcebergDatasetHandler dsh = (IcebergDatasetHandler)DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
                return this.getAsIceberg(sqlContext, dsh, schema, partitions, sampling, schemaColumns, filterExpression);
            }
            FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(49).append(logPrefix).append("Direct read of Iceberg dataset is not supported: ").append(icebergAccessibility._2()).toString());
            FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(75).append(logPrefix).append("Reading Iceberg dataset as a remote ").append(this.sparkObjectType()).append(". Computation will not be distributed: ").append(icebergAccessibility._2()).toString());
            return this.getAsRemote(sqlContext, dataset, sampling, partitions, columnNames, filterExpression);
        }
        if ("UploadedFiles".equals(string) && StorageBackendsSupport$.MODULE$.isReadDatasetAccessible(dataset)) {
            UploadedFilesDatasetHandler dsh = (UploadedFilesDatasetHandler)DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
            Dataset realDataset = dsh.getRealDataset();
            String string2 = realDataset.getType();
            if ("HDFS".equals(string2) ? true : ("S3".equals(string2) ? true : ("GCS".equals(string2) ? true : "Azure".equals(string2)))) {
                return this.get(sqlContext, realDataset, sampling, partitions, columnNames, filterExpression);
            }
            FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(137).append(logPrefix).append("Reading uploaded dataset as a remote ").append(this.sparkObjectType()).append(". Computation will not be distributed: Uploaded dataset is not on a compatible cloud storage or HDFS").toString());
            return this.getAsRemote(sqlContext, dataset, sampling, partitions, columnNames, filterExpression);
        }
        if (dataset.getParams() instanceof AbstractSQLDatasetHandler.AbstractSQLConfig) {
            Tuple2<Object, String> sqlAccessibility = StorageBackendsSupport$.MODULE$.isSQLReadCompatible(dataset, filterExpression, sampling);
            if (sqlAccessibility._1$mcZ$sp()) {
                FastPathHandler$.MODULE$.logger().info((Object)new StringBuilder(24).append(logPrefix).append("Using SQL read fast-path").toString());
                AbstractSQLTableDatasetHandler dsh = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
                return this.getAsSQL(sqlContext, dsh, schema, partitions, sampling, schemaColumns, filterExpression);
            }
            FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(45).append(logPrefix).append("Direct read of SQL dataset is not supported: ").append(sqlAccessibility._2()).toString());
            FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(71).append(logPrefix).append("Reading SQL dataset as a remote ").append(this.sparkObjectType()).append(". Computation will not be distributed: ").append(sqlAccessibility._2()).toString());
            return this.getAsRemote(sqlContext, dataset, sampling, partitions, columnNames, filterExpression);
        }
        FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(113).append(logPrefix).append("Reading dataset as a remote ").append(this.sparkObjectType()).append(". Computation will not be distributed: dataset type ").append(dataset.getType()).append(" cannot be read directly in Spark").toString());
        return this.getAsRemote(sqlContext, dataset, sampling, partitions, columnNames, filterExpression);
    }

    public SamplingParam get$default$3() {
        return null;
    }

    public List<String> get$default$4() {
        return null;
    }

    public List<String> get$default$5() {
        return null;
    }

    public String get$default$6() {
        return null;
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getDataFrameFromHDFSableWithFastPathIfPossible(SQLContext sqlContext, Dataset dataset, SamplingParam sampling, List<String> partitions, List<String> columnNames, String filterExpression, StructType schema, List<SchemaColumn> schemaColumns) {
        String logPrefix = new StringBuilder(18).append("getFromHDFSable ").append(dataset.getFullName()).append(": ").toString();
        if (StdDataikuSparkContext$.MODULE$.isCsvDataset(dataset)) {
            Tuple2<Object, String> csvUsability = HadoopFormatsSupport$.MODULE$.getCsvReadUsability(sqlContext, dataset, sampling, filterExpression, partitions);
            if (csvUsability._1$mcZ$sp()) {
                FastPathHandler$.MODULE$.logger().info((Object)new StringBuilder(24).append(logPrefix).append("Using Csv read fast-path").toString());
                HDFSableDatasetHandler dsh = (HDFSableDatasetHandler)DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
                return this.getAsCsv(sqlContext, dsh, partitions, schema, sampling, schemaColumns);
            }
            FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(47).append(logPrefix).append("Cannot use Csv read fast-path on Csv-").append(dataset.getType()).append(" dataset: ").append(csvUsability._2()).toString());
        }
        if (StdDataikuSparkContext$.MODULE$.isJsonDataset(dataset)) {
            Tuple2<Object, String> jsonUsability = HadoopFormatsSupport$.MODULE$.getJsonReadUsability(sqlContext, dataset, sampling, filterExpression, partitions, this.canUnnestJson());
            if (jsonUsability._1$mcZ$sp()) {
                FastPathHandler$.MODULE$.logger().info((Object)new StringBuilder(25).append(logPrefix).append("Using Json read fast-path").toString());
                HDFSableDatasetHandler dsh = (HDFSableDatasetHandler)DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
                return this.getAsJson(sqlContext, dsh, partitions, schema, sampling, schemaColumns);
            }
            FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(49).append(logPrefix).append("Cannot use Json read fast-path on Json-").append(dataset.getType()).append(" dataset: ").append(jsonUsability._2()).toString());
        }
        if (StdDataikuSparkContext$.MODULE$.isParquetDataset(dataset)) {
            Tuple2<Object, String> parquetUsability = HadoopFormatsSupport$.MODULE$.getParquetReadUsability(sqlContext, dataset, sampling, filterExpression, partitions);
            if (parquetUsability._1$mcZ$sp()) {
                FastPathHandler$.MODULE$.logger().info((Object)new StringBuilder(28).append(logPrefix).append("Using Parquet read fast-path").toString());
                HDFSableDatasetHandler dsh = (HDFSableDatasetHandler)DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
                return this.getAsParquet(sqlContext, dsh, partitions, schema, sampling, schemaColumns);
            }
            FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(55).append(logPrefix).append("Cannot use Parquet read fast-path on Parquet-").append(dataset.getType()).append(" dataset: ").append(parquetUsability._2()).toString());
        }
        if (StdDataikuSparkContext$.MODULE$.isORCDataset(dataset)) {
            Tuple2<Object, String> orcUsability = HadoopFormatsSupport$.MODULE$.getORCReadUsability(sqlContext, dataset, sampling, filterExpression, partitions);
            if (orcUsability._1$mcZ$sp()) {
                FastPathHandler$.MODULE$.logger().info((Object)new StringBuilder(24).append(logPrefix).append("Using ORC read fast-path").toString());
                HDFSableDatasetHandler dsh = (HDFSableDatasetHandler)DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
                return this.getAsORC(sqlContext, dsh, partitions, schema, sampling, schemaColumns);
            }
            FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(47).append(logPrefix).append("Cannot use ORC read fast-path on ORC-").append(dataset.getType()).append(" dataset: ").append(orcUsability._2()).toString());
        }
        if (StdDataikuSparkContext$.MODULE$.isDeltaDataset(dataset)) {
            Tuple2<Object, String> deltaUsability = HadoopFormatsSupport$.MODULE$.getDeltaReadUsability(sqlContext, dataset, sampling, filterExpression, partitions);
            if (deltaUsability._1$mcZ$sp()) {
                FastPathHandler$.MODULE$.logger().info((Object)new StringBuilder(26).append(logPrefix).append("Using Delta read fast-path").toString());
                HDFSableDatasetHandler dsh = (HDFSableDatasetHandler)DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
                return this.getAsDeltaFromHDFSAble(sqlContext, dsh, partitions, schema, sampling, schemaColumns);
            }
            throw new UnsupportedOperationException(new StringBuilder(27).append(logPrefix).append("Cannot read Delta dataset: ").append(deltaUsability._2()).toString());
        }
        Tuple2<Object, String> universalFormatUsability = HadoopFormatsSupport$.MODULE$.getUniversalFormatReadUsability(dataset, sampling);
        if (universalFormatUsability._1$mcZ$sp()) {
            FastPathHandler$.MODULE$.logger().info((Object)new StringBuilder(28).append(logPrefix).append("Using regular Universal read").toString());
            HDFSableDatasetHandler dsh = (HDFSableDatasetHandler)DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
            return this.getAsHadoopFromHDFSable(sqlContext, dataset, dsh, sampling, columnNames, partitions, filterExpression);
        }
        FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(47).append(logPrefix).append("Cannot use regular Universal read on ").append(dataset.getType()).append(" dataset: ").append(universalFormatUsability._2()).toString());
        FastPathHandler$.MODULE$.logger().warn((Object)new StringBuilder(66).append(logPrefix).append("Reading ").append(dataset.getType()).append(" dataset as remote ").append(this.sparkObjectType()).append(". Computation will not be distributed: ").append(universalFormatUsability._2()).toString());
        return this.getAsRemote(sqlContext, dataset, sampling, partitions, columnNames, filterExpression);
    }

    public SamplingParam getDataFrameFromHDFSableWithFastPathIfPossible$default$3() {
        return null;
    }

    public List<String> getDataFrameFromHDFSableWithFastPathIfPossible$default$4() {
        return null;
    }

    public List<String> getDataFrameFromHDFSableWithFastPathIfPossible$default$5() {
        return null;
    }

    public String getDataFrameFromHDFSableWithFastPathIfPossible$default$6() {
        return null;
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsRemote(SQLContext sqlContext, Dataset dataset, SamplingParam sampling, List<String> partitions, List<String> columnNames, String filterExpression) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public SamplingParam getAsRemote$default$3() {
        return null;
    }

    public List<String> getAsRemote$default$4() {
        return null;
    }

    public List<String> getAsRemote$default$5() {
        return null;
    }

    public String getAsRemote$default$6() {
        return null;
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsHiveserver2(SQLContext sqlContext, Dataset dataset, SamplingParam sampling, List<String> partitions, List<String> columnNames, String filterExpression) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public SamplingParam getAsHiveserver2$default$3() {
        return null;
    }

    public List<String> getAsHiveserver2$default$4() {
        return null;
    }

    public List<String> getAsHiveserver2$default$5() {
        return null;
    }

    public String getAsHiveserver2$default$6() {
        return null;
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsHadoopFromHDFSable(SQLContext sqlContext, Dataset dataset, HDFSableDatasetHandler dsh, SamplingParam sampling, List<String> columnNames, List<String> partitions, String filterExpression) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public List<String> getAsHadoopFromHDFSable$default$5() {
        return null;
    }

    public List<String> getAsHadoopFromHDFSable$default$6() {
        return null;
    }

    public String getAsHadoopFromHDFSable$default$7() {
        return null;
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsCsv(SQLContext sqlContext, HDFSableDatasetHandler handler, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns) {
        Seq<String> paths = HDFSDatasetRDD$.MODULE$.listDirectories(handler, partitions);
        FastPathHandler$.MODULE$.logger().info((Object)"read csv using sqlcontext");
        handler.addExtraConf(sqlContext.sparkContext().hadoopConfiguration(), true);
        handler.addExtraConf(package$.MODULE$.getSparkHadoopUtilConf(), true);
        CSVFormatConfig csvFormatConfig = (CSVFormatConfig)handler.getDataset().getFormatParamsAs(CSVFormatConfig.class);
        Map options = Predef$.MODULE$.Map().empty();
        if (csvFormatConfig.charset != null && csvFormatConfig.charset.length() > 0) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"charset"), (Object)csvFormatConfig.charset));
        }
        if (csvFormatConfig.parseHeaderRow) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"header"), (Object)"true"));
        }
        options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sep"), (Object)String.valueOf(BoxesRunTime.boxToCharacter((char)csvFormatConfig.getSeparatorChar()))));
        options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampNTZFormat"), (Object)"yyyy-MM-dd HH:mm:ss[.SSS]"));
        CSVFormatConfig.CSVStyle cSVStyle = csvFormatConfig.style;
        if (CSVFormatConfig.CSVStyle.EXCEL.equals(cSVStyle)) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"quote"), (Object)String.valueOf(BoxesRunTime.boxToCharacter((char)csvFormatConfig.getQuoteChar()))));
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"escape"), (Object)String.valueOf(BoxesRunTime.boxToCharacter((char)csvFormatConfig.getQuoteChar()))));
        } else if (CSVFormatConfig.CSVStyle.UNIX.equals(cSVStyle)) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"quote"), (Object)String.valueOf(BoxesRunTime.boxToCharacter((char)csvFormatConfig.getQuoteChar()))));
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"escape"), (Object)String.valueOf(BoxesRunTime.boxToCharacter((char)csvFormatConfig.getEscapeChar()))));
        } else if (CSVFormatConfig.CSVStyle.ESCAPE_ONLY_NO_QUOTE.equals(cSVStyle)) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"escape"), (Object)String.valueOf(BoxesRunTime.boxToCharacter((char)csvFormatConfig.getEscapeChar()))));
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"quoteMode"), (Object)"NONE"));
        } else if (CSVFormatConfig.CSVStyle.NO_ESCAPE_NO_QUOTE.equals(cSVStyle)) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"quoteMode"), (Object)"NONE"));
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"escape"), (Object)""));
        } else {
            throw new MatchError((Object)cSVStyle);
        }
        CSVFormatConfig.DateSerializationFormat dateSerializationFormat = csvFormatConfig.dateSerializationFormat;
        if (CSVFormatConfig.DateSerializationFormat.HIVE.equals(dateSerializationFormat)) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateFormat"), (Object)"yyyy-MM-dd"));
        } else if (CSVFormatConfig.DateSerializationFormat.ISO.equals(dateSerializationFormat)) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateFormat"), (Object)"yyyy-MM-dd"));
        } else if (CSVFormatConfig.DateSerializationFormat.ISO_STRICT.equals(dateSerializationFormat)) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateFormat"), (Object)"yyyy-MM-dd"));
        } else if (CSVFormatConfig.DateSerializationFormat.ISO_FORCED_UTC.equals(dateSerializationFormat)) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateFormat"), (Object)"yyyy-MM-dd"));
        } else {
            throw new MatchError((Object)dateSerializationFormat);
        }
        return this.getAsCsv(sqlContext, handler, partitions, schema, sampling, schemaColumns, (Map<String, String>)options, paths);
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsCsv(SQLContext sqlContext, HDFSableDatasetHandler handler, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns, Map<String, String> options, Seq<String> paths) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsJson(SQLContext sqlContext, HDFSableDatasetHandler handler, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns) {
        Seq<String> paths = HDFSDatasetRDD$.MODULE$.listDirectories(handler, partitions);
        FastPathHandler$.MODULE$.logger().info((Object)"read json using sqlcontext");
        handler.addExtraConf(sqlContext.sparkContext().hadoopConfiguration(), true);
        handler.addExtraConf(package$.MODULE$.getSparkHadoopUtilConf(), true);
        return this.getAsJson(sqlContext, handler, partitions, schema, sampling, schemaColumns, (Map<String, String>)Predef$.MODULE$.Map().empty(), paths);
    }

    public boolean canUnnestJson() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsJson(SQLContext sqlContext, HDFSableDatasetHandler handler, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns, Map<String, String> options, Seq<String> paths) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsParquet(SQLContext sqlContext, HDFSableDatasetHandler handler, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns) {
        Seq<String> paths = HDFSDatasetRDD$.MODULE$.listDirectories(handler, partitions);
        FastPathHandler$.MODULE$.logger().info((Object)"read parquet using sqlcontext");
        handler.addExtraConf(sqlContext.sparkContext().hadoopConfiguration(), true);
        handler.addExtraConf(package$.MODULE$.getSparkHadoopUtilConf(), true);
        boolean hasDowncastedTypes = schemaColumns.exists((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FastPathHandler.$anonfun$getAsParquet$1(c)));
        if (hasDowncastedTypes) {
            FastPathHandler$.MODULE$.logger().info((Object)"Found downcasted types, using native parquet reader with schema inferred by parquet");
        }
        boolean inferSchema = hasDowncastedTypes || StdDataikuSparkContext$.MODULE$.isParquetInputSchemaInferrenceEnabled(sqlContext);
        return this.getAsParquet(sqlContext, handler, partitions, schema, sampling, schemaColumns, inferSchema, paths);
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsParquet(SQLContext sqlContext, HDFSableDatasetHandler handler, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns, boolean inferSchema, Seq<String> paths) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsORC(SQLContext sqlContext, HDFSableDatasetHandler handler, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns) {
        Seq<String> paths = HDFSDatasetRDD$.MODULE$.listDirectories(handler, partitions);
        FastPathHandler$.MODULE$.logger().info((Object)"read ORC using sqlcontext.");
        handler.addExtraConf(sqlContext.sparkContext().hadoopConfiguration(), true);
        handler.addExtraConf(package$.MODULE$.getSparkHadoopUtilConf(), true);
        boolean hasDowncastedTypes = schemaColumns.exists((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FastPathHandler.$anonfun$getAsORC$1(c)));
        if (hasDowncastedTypes) {
            FastPathHandler$.MODULE$.logger().info((Object)"Found downcasted types, using native ORC reader with schema inferred by ORC");
        }
        FastPathHandler$.MODULE$.logger().info((Object)new StringBuilder(30).append("Accessing dataframe as ORC to ").append(paths.mkString(",")).toString());
        boolean inferSchema = hasDowncastedTypes || StdDataikuSparkContext$.MODULE$.isORCInputSchemaInferrenceEnabled(sqlContext);
        return this.getAsORC(sqlContext, handler, partitions, schema, sampling, schemaColumns, inferSchema, paths);
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsORC(SQLContext sqlContext, HDFSableDatasetHandler handler, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns, boolean inferSchema, Seq<String> paths) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsDeltaFromHDFSAble(SQLContext sqlContext, HDFSableDatasetHandler handler, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns) {
        String path = handler.getFullyQualifiedRootPath();
        FastPathHandler$.MODULE$.logger().info((Object)"read Delta using sqlcontext.");
        handler.addExtraConf(sqlContext.sparkContext().hadoopConfiguration(), true);
        handler.addExtraConf(package$.MODULE$.getSparkHadoopUtilConf(), true);
        return this.getAsDelta(sqlContext, handler, path, partitions, schema, sampling, schemaColumns);
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsDelta(SQLContext sqlContext, HDFSableDatasetHandler handler, String path, List<String> partitions, StructType schema, SamplingParam sampling, List<SchemaColumn> schemaColumns) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsSnowflake(SQLContext sqlContext, AbstractSQLTableDatasetHandler datasetHandler, StructType schema, List<String> partitions, SamplingParam sampling, List<SchemaColumn> schemaColumns, String filterExpression) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Dataset dataset = datasetHandler.getDataset();
        SimpleSelectQueryBuilder query = SimpleSelectQueryBuilder.selectAll().from(datasetHandler.getResolvedTable(), datasetHandler.getResolvedTable().getTable());
        if (filterExpression != null) {
            GrelToQueryTranslator translator = new GrelToQueryTranslator((GrelTranslator.GrelMapping)new GrelToQueryMapping((SQLDialect)new SnowflakeSQLDialect()));
            Expression expression = new Expression(filterExpression, datasetHandler.getDataset().getSchema());
            ExpressionBuilder value = (ExpressionBuilder)translator.translateToQuery((Expression)expression, (boolean)true).result;
            boxedUnit2 = query.where(value);
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (partitions != null) {
            PartitioningScheme partitioningScheme = dataset.getPartitioningSchema();
            java.util.List sourcePartitions = PartitionFactory.fromPartitionSpec((PartitioningScheme)partitioningScheme, (String)partitions.mkString(","));
            boxedUnit = query.where(ExpressionUtils.getPartitionFilterClause((PartitioningScheme)partitioningScheme, (Dataset)dataset, (java.util.List)sourcePartitions, (SQLDialect)new SnowflakeSQLDialect()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boolean hasDowncastedTypes = schemaColumns.exists((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FastPathHandler.$anonfun$getAsSnowflake$1(c)));
        if (hasDowncastedTypes) {
            FastPathHandler$.MODULE$.logger().info((Object)"Found downcasted types, using native Snowflake reader with schema inferred by Snowflake");
        }
        Map<String, String> options = SnowflakeFastpathSupport$.MODULE$.getConnectionOptions(datasetHandler.getConnectionName(), datasetHandler.getResolvedTable().getCatalog(), datasetHandler.getResolvedTable().getSchemaNullIfBlank(), dataset.getProjectKey());
        String sql = query.toSQL((SQLDialect)SnowflakeFastpathSupport$.MODULE$.SnowflakeSqlDialect());
        boolean inferSchema = hasDowncastedTypes || StdDataikuSparkContext$.MODULE$.isSnowflakeInputSchemaInferrenceEnabled(sqlContext);
        return this.getAsSnowflake(sqlContext, datasetHandler, schema, partitions, sampling, schemaColumns, filterExpression, inferSchema, options, sql);
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsSnowflake(SQLContext sqlContext, AbstractSQLTableDatasetHandler datasetHandler, StructType schema, List<String> partitions, SamplingParam sampling, List<SchemaColumn> schemaColumns, String filterExpression, boolean inferSchema, Map<String, String> options, String sql) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsIceberg(SQLContext sqlContext, IcebergDatasetHandler datasetHandler, StructType schema, List<String> partitions, SamplingParam sampling, List<SchemaColumn> schemaColumns, String filterExpression) {
        FastPathHandler$.MODULE$.logger().info((Object)"read iceberg using sqlcontext");
        Buffer extraConf = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(datasetHandler.getExtraConf()).asScala();
        Buffer extraHadoopConf = (Buffer)extraConf.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)p.name.startsWith("spark.hadoop.")));
        Buffer extraCatalogConf = (Buffer)extraConf.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)FastPathHandler.$anonfun$getAsIceberg$2(p)));
        SQLConf sqlConf = SQLConf$.MODULE$.get();
        extraCatalogConf.foreach((Function1 & Serializable & scala.Serializable)p -> {
            sqlConf.setConfString(p.name, p.value);
            return BoxedUnit.UNIT;
        });
        Configuration hadoopConfiguration = sqlContext.sparkContext().hadoopConfiguration();
        Configuration hadoopConfiguration2 = package$.MODULE$.getSparkHadoopUtilConf();
        extraHadoopConf.foreach((Function1 & Serializable & scala.Serializable)p -> {
            FastPathHandler.$anonfun$getAsIceberg$4(hadoopConfiguration, hadoopConfiguration2, p);
            return BoxedUnit.UNIT;
        });
        List qualifiedTable = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(datasetHandler.getResolvedTableChunks()).asScala()).toList();
        boolean hasDowncastedTypes = schemaColumns.exists((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FastPathHandler.$anonfun$getAsIceberg$5(c)));
        if (hasDowncastedTypes) {
            FastPathHandler$.MODULE$.logger().info((Object)"Found downcasted types, using native Iceberg reader with schema inferred by Iceberg");
        }
        boolean inferSchema = hasDowncastedTypes || StdDataikuSparkContext$.MODULE$.isIcebergInputSchemaInferrenceEnabled(sqlContext);
        return this.getAsIceberg(sqlContext, datasetHandler, (List<String>)qualifiedTable, schema, partitions, sampling, schemaColumns, filterExpression, inferSchema, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsIceberg(SQLContext sqlContext, IcebergDatasetHandler datasetHandler, List<String> qualifiedTable, StructType schema, List<String> partitions, SamplingParam sampling, List<SchemaColumn> schemaColumns, String filterExpression, boolean inferSchema, Map<String, String> options) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsSQL(SQLContext sqlContext, AbstractSQLTableDatasetHandler datasetHandler, StructType schema, List<String> partitions, SamplingParam sampling, List<SchemaColumn> schemaColumns, String filterExpression) {
        Map map;
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        StructType schemaFixedUp;
        Dataset dataset = datasetHandler.getDataset();
        SQLConnectionProvider.SQLConnectionData connData = datasetHandler.getConnectionData();
        SQLDialect dialect = connData.getDialect();
        SimpleSelectQueryBuilder query = SimpleSelectQueryBuilder.select().from(datasetHandler.getResolvedTable(), datasetHandler.getResolvedTable().getTable());
        schemaColumns.foreach((Function1 & Serializable & scala.Serializable)sc -> query.column(sc.getName()));
        SQLDialect sQLDialect = dialect;
        StructType structType = sQLDialect instanceof RedshiftSQLDialect ? new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)f -> new StructField(f.name().toLowerCase(), f.dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))) : (sQLDialect instanceof OracleSQLDialect ? new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)f -> {
            DataType dataType = f.dataType();
            if (LongType$.MODULE$.equals(dataType)) {
                return new StructField(f.name(), (DataType)new DecimalType(38, 0), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            }
            return f;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))) : (schemaFixedUp = sQLDialect instanceof TeradataSQLDialect ? new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)f -> {
            DataType dataType = f.dataType();
            if (DoubleType$.MODULE$.equals(dataType)) {
                return new StructField(f.name(), (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            }
            return f;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))) : schema));
        if (filterExpression != null) {
            GrelToQueryTranslator translator = new GrelToQueryTranslator((GrelTranslator.GrelMapping)new GrelToQueryMapping(dialect));
            Expression expression = new Expression(filterExpression, datasetHandler.getDataset().getSchema());
            ExpressionBuilder value = (ExpressionBuilder)translator.translateToQuery((Expression)expression, (boolean)true).result;
            boxedUnit2 = query.where(value);
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (partitions != null) {
            PartitioningScheme partitioningScheme = dataset.getPartitioningSchema();
            java.util.List sourcePartitions = PartitionFactory.fromPartitionSpec((PartitioningScheme)partitioningScheme, (String)partitions.mkString(","));
            boxedUnit = query.where(ExpressionUtils.getPartitionFilterClause((PartitioningScheme)partitioningScheme, (Dataset)dataset, (java.util.List)sourcePartitions, (SQLDialect)dialect));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boolean hasDowncastedTypes = schemaColumns.exists((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FastPathHandler.$anonfun$getAsSQL$5(c)));
        if (hasDowncastedTypes) {
            FastPathHandler$.MODULE$.logger().info((Object)"Found downcasted types, using native SQL reader with schema inferred by Spark");
        }
        SQLConnectionProvider.SparkJDBCInfo connectionInfo = connData.getSparkConnectionInfo(datasetHandler.getAuthCtx(), dataset.getProjectKey());
        String sql = new StringBuilder(6).append("(").append(query.toSQL(dialect)).append(") tbl").toString();
        boolean inferSchema = hasDowncastedTypes || StdDataikuSparkContext$.MODULE$.isSQLInputSchemaInferrenceEnabled(sqlContext, dataset.getParams().getConnection());
        Map connectionOptions = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(connectionInfo.properties.stringPropertyNames()).asScala()).map((Function1 & Serializable & scala.Serializable)n -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)n.toString()), (Object)connectionInfo$1.properties.getProperty((String)n).toString()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.mutable.Map datasetOptions = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(datasetHandler.getSparkConnectionInfo()).asScala();
        Map allOptions = ((TraversableOnce)connectionOptions.toSeq().$plus$plus((GenTraversableOnce)datasetOptions.toSet(), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (new StringOps(Predef$.MODULE$.augmentString((String)allOptions.getOrElse((Object)"numPartitions", (Function0 & Serializable & scala.Serializable)() -> "0"))).toInt() < 0) {
            int numExecutors = new StringOps(Predef$.MODULE$.augmentString(sqlContext.sparkContext().getConf().get("spark.executor.instances", "1"))).toInt();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numPartitions"), (Object)Integer.toString(numExecutors));
            map = ((TraversableOnce)((MapLike)allOptions.filter((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)FastPathHandler.$anonfun$getAsSQL$8(kv)))).toSeq().$plus$plus((GenTraversableOnce)Nil$.MODULE$.$colon$colon((Object)tuple2), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else {
            map = allOptions;
        }
        Map allOptionsWithNumPartitions = map;
        FastPathHandler$.MODULE$.logger().info((Object)new StringBuilder(43).append("Read in ").append(allOptionsWithNumPartitions.getOrElse((Object)"numPartitions", (Function0 & Serializable & scala.Serializable)() -> "N/A")).append(" partitions with schema ").append(schema).append(" and sql : ").append(sql).toString());
        return this.getAsSQL(sqlContext, datasetHandler, schemaFixedUp, partitions, sampling, schemaColumns, filterExpression, inferSchema, connectionInfo.url, connectionInfo.driver, (Map<String, String>)allOptionsWithNumPartitions, sql);
    }

    public Tuple2<T, FlowDatasetRef.InputDatasetDataframeReadMode> getAsSQL(SQLContext sqlContext, AbstractSQLTableDatasetHandler datasetHandler, StructType schema, List<String> partitions, SamplingParam sampling, List<SchemaColumn> schemaColumns, String filterExpression, boolean inferSchema, String jdbcUrl, String jdbcDriver, Map<String, String> jdbcOptions, String sql) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public String productPrefix() {
        return "FastPathHandler";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.sparkObjectType();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FastPathHandler;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FastPathHandler)) return false;
        boolean bl = true;
        if (!bl) return false;
        FastPathHandler fastPathHandler = (FastPathHandler)x$1;
        String string = this.sparkObjectType();
        String string2 = fastPathHandler.sparkObjectType();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!fastPathHandler.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getAsParquet$1(SchemaColumn c) {
        return c.originalType != null;
    }

    public static final /* synthetic */ boolean $anonfun$getAsORC$1(SchemaColumn c) {
        return c.originalType != null;
    }

    public static final /* synthetic */ boolean $anonfun$getAsSnowflake$1(SchemaColumn c) {
        return c.originalType != null;
    }

    public static final /* synthetic */ boolean $anonfun$getAsIceberg$2(AbstractSQLConnection.CustomDatabaseProperty p) {
        return !p.name.startsWith("spark.hadoop.");
    }

    public static final /* synthetic */ void $anonfun$getAsIceberg$4(Configuration hadoopConfiguration$1, Configuration hadoopConfiguration2$1, AbstractSQLConnection.CustomDatabaseProperty p) {
        String key = p.name.substring("spark.hadoop.".length());
        hadoopConfiguration$1.set(key, p.value);
        hadoopConfiguration2$1.set(key, p.value);
    }

    public static final /* synthetic */ boolean $anonfun$getAsIceberg$5(SchemaColumn c) {
        return StringUtils.isNotBlank((String)c.originalType);
    }

    public static final /* synthetic */ boolean $anonfun$getAsSQL$5(SchemaColumn c) {
        return c.originalType != null;
    }

    public static final /* synthetic */ boolean $anonfun$getAsSQL$8(Tuple2 kv) {
        return !"numPartitions".equals(kv._1());
    }

    public FastPathHandler(String sparkObjectType) {
        this.sparkObjectType = sparkObjectType;
        Product.$init$((Product)this);
    }
}

