/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeModalityCollectionJobDef;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeModalityCollectionJobResult;
import com.dataiku.dip.spark.FlowDatasetRef;
import com.dataiku.dip.spark.GlobalMetastoreHiveConfig$;
import com.dataiku.dip.spark.InputDatasetsReadParams;
import com.dataiku.dip.spark.LocalMetastoreHiveConfig$;
import com.dataiku.dip.spark.StdDataikuSparkContext;
import com.dataiku.dip.spark.package$;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.functions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class PivotRecipeModalityCollectionJob$ {
    public static PivotRecipeModalityCollectionJob$ MODULE$;
    private final Logger logger;

    static {
        new PivotRecipeModalityCollectionJob$();
    }

    public void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage: PivotRecipeModalityCollectionJob DESCRIPTOR_FILE");
            System.exit(1);
        }
        File runDir = com.dataiku.dip.remoterun.package$.MODULE$.getLocalRunFile(".").getAbsoluteFile();
        try {
            Tuple3<SparkContext, SQLContext, Object> tuple3;
            com.dataiku.dip.utils.package$.MODULE$.initializeApplication(com.dataiku.dip.utils.package$.MODULE$.initializeApplication$default$1(), com.dataiku.dip.utils.package$.MODULE$.initializeApplication$default$2());
            this.logger.info((Object)"Reading job descriptor");
            PivotRecipeModalityCollectionJobDef desc = (PivotRecipeModalityCollectionJobDef)com.dataiku.dip.remoterun.package$.MODULE$.getFromResourceOrFile(args[0], ClassTag$.MODULE$.apply(PivotRecipeModalityCollectionJobDef.class));
            this.logger.info((Object)"Creating Spark context");
            Tuple3<SparkContext, SQLContext, Object> tuple32 = tuple3 = desc.useGlobalMetastore ? package$.MODULE$.setupSQLContext(GlobalMetastoreHiveConfig$.MODULE$.apply("PivotRecipeModalityCollectionJob"), (Option<String>)new Some((Object)desc.metastoreDatabase), package$.MODULE$.setupSQLContext$default$3()) : package$.MODULE$.setupSQLContext(LocalMetastoreHiveConfig$.MODULE$.apply(runDir, "PivotRecipeModalityCollectionJob"), (Option<String>)None$.MODULE$, package$.MODULE$.setupSQLContext$default$3());
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            SparkContext sc = (SparkContext)tuple3._1();
            SQLContext ssc = (SQLContext)tuple3._2();
            Tuple2 tuple2 = new Tuple2((Object)sc, (Object)ssc);
            SparkContext sc2 = (SparkContext)tuple2._1();
            SQLContext ssc2 = (SQLContext)tuple2._2();
            StdDataikuSparkContext dsc = new StdDataikuSparkContext();
            this.logger.info((Object)"Opening input datasets: ");
            FlowDatasetRef input = desc.input;
            this.logger.info((Object)new StringBuilder(22).append("Opening : ").append(input.fullName).append(" with parts ").append(input.partitions).toString());
            Dataset df = null;
            df = dsc.internalGetDataFrame(ssc2, input.fullName, dsc.internalGetDataFrame$default$3(), dsc.internalGetDataFrame$default$4(), dsc.internalGetDataFrame$default$5());
            InputDatasetsReadParams.InputDatasetReadParams readParams = desc.readParams.getReadParams(input.ref);
            if (input.mightNeedRepartitioning && readParams.repartition > 1) {
                df = df.repartition(readParams.repartition);
            } else if (readParams.repartition > 1) {
                this.logger.warn((Object)"Asked to repartition a non-HDFS dataset");
                df = df.repartition(readParams.repartition);
            }
            if (input.registerAsTempTable) {
                com.dataiku.dip.utils.package$.MODULE$.registerTempTableProperly((Dataset<Row>)df, input.tableName);
            }
            PivotRecipeModalityCollectionJobResult results = new PivotRecipeModalityCollectionJobResult();
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(desc.modalityCollectionDefs).asScala()).foreach((Function1 & Serializable & scala.Serializable)modalityCollectionDef -> BoxesRunTime.boxToBoolean((boolean)PivotRecipeModalityCollectionJob$.$anonfun$main$1(ssc2, results, modalityCollectionDef)));
            this.logger.info((Object)new StringBuilder(10).append("Collected ").append(JSON.prettyLog((Object)results)).toString());
            com.dataiku.dip.remoterun.package$.MODULE$.storeJsonResult("results.json", results);
            com.dataiku.dip.remoterun.package$.MODULE$.exitWhenDoneIfNeeded(sc2);
        }
        catch (Throwable t) {
            com.dataiku.dip.remoterun.package$.MODULE$.storeError(t);
            System.exit(1);
        }
    }

    private static final List keyValuesExtract$1(Row row) {
        return ((TraversableOnce)row.toSeq().map((Function1 & Serializable & scala.Serializable)x$2 -> (String)Option$.MODULE$.apply(x$2).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> null), Seq$.MODULE$.canBuildFrom())).toList();
    }

    public static final /* synthetic */ boolean $anonfun$main$1(SQLContext ssc$1, PivotRecipeModalityCollectionJobResult results$1, PivotRecipeModalityCollectionJobDef.PivotRecipeModalityCollectionDef modalityCollectionDef) {
        PivotRecipeModalityCollectionJob$.MODULE$.logger.info((Object)new StringBuilder(26).append("Building result of query: ").append(modalityCollectionDef.sqlQuery).toString());
        Dataset result = ssc$1.sql(modalityCollectionDef.sqlQuery);
        Buffer keyColumns = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(modalityCollectionDef.keyColumns).asScala();
        PivotRecipeModalityCollectionJobResult.PivotRecipeModalityCollectionResult modalityCollectionResult = new PivotRecipeModalityCollectionJobResult.PivotRecipeModalityCollectionResult();
        modalityCollectionResult.pivotIndex = modalityCollectionDef.pivotIndex;
        modalityCollectionResult.modalities = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.select((Seq)keyColumns.map((Function1 & Serializable & scala.Serializable)n -> functions$.MODULE$.col(new StringBuilder(2).append("`").append((String)n).append("`").toString()), Buffer$.MODULE$.canBuildFrom())).rdd().map((Function1 & Serializable & scala.Serializable)r -> (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)PivotRecipeModalityCollectionJob$.keyValuesExtract$1(r)).asJava(), ClassTag$.MODULE$.apply(java.util.List.class)).collect())).toList()).asJava();
        return results$1.modalityCollectionResults.add(modalityCollectionResult);
    }

    private PivotRecipeModalityCollectionJob$() {
        MODULE$ = this;
        this.logger = Logger.getLogger((String)"dku.spark.recipe.pivot");
    }
}

