/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.builders;

import com.dataiku.scoring.builders.AlgorithmBuilder;
import java.util.Set;

public enum AlgorithmBuilding {
    LINEAR(new AlgorithmBuilder.LinearBuilder(), Set.of(AlgorithmType.REGRESSION)),
    LOGISTIC(new AlgorithmBuilder.LogisticRegressionBuilder(), Set.of(AlgorithmType.PROBABILISTIC)),
    FOREST_REGRESSOR(new AlgorithmBuilder.ForestRegressorBuilder(), Set.of(AlgorithmType.REGRESSION)),
    FOREST_CLASSIFIER(new AlgorithmBuilder.ForestClassifierBuilder(), Set.of(AlgorithmType.PROBABILISTIC)),
    GRADIENT_BOOSTING_REGRESSOR(new AlgorithmBuilder.GradientBoostingRegressorBuilder(), Set.of(AlgorithmType.REGRESSION)),
    GRADIENT_BOOSTING_CLASSIFIER(new AlgorithmBuilder.GradientBoostingClassifierBuilder(), Set.of(AlgorithmType.PROBABILISTIC)),
    DECISION_TREE(new AlgorithmBuilder.DecisionTreeBuilder(), Set.of(AlgorithmType.REGRESSION, AlgorithmType.PROBABILISTIC)),
    MULTI_LAYER_PERCEPTRON(new AlgorithmBuilder.MLPBuilder(), Set.of(AlgorithmType.REGRESSION, AlgorithmType.PROBABILISTIC));

    public final AlgorithmBuilder<?> builder;
    private final Set<AlgorithmType> supportedTypes;

    private AlgorithmBuilding(AlgorithmBuilder<?> builder, Set<AlgorithmType> supportedTypes) {
        this.builder = builder;
        this.supportedTypes = supportedTypes;
    }

    public boolean supports(AlgorithmType t) {
        if (t == AlgorithmType.CLASSIFICATION_ONLY) {
            return this.supportedTypes.contains((Object)AlgorithmType.CLASSIFICATION_ONLY) || this.supports(AlgorithmType.PROBABILISTIC);
        }
        return this.supportedTypes.contains((Object)t);
    }

    public static enum AlgorithmType {
        REGRESSION,
        PROBABILISTIC,
        CLASSIFICATION_ONLY;

    }
}

