/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.builders;

import com.dataiku.scoring.builders.AlgorithmBuilding;
import com.dataiku.scoring.builders.BuildUtils;
import com.dataiku.scoring.builders.DimensionType;
import com.dataiku.scoring.builders.Processors;
import com.dataiku.scoring.models.Classifier;
import com.dataiku.scoring.models.DecisionTreeModel;
import com.dataiku.scoring.models.DecisionTreeRegressor;
import com.dataiku.scoring.models.Estimator;
import com.dataiku.scoring.models.GradientBoostingClassifier;
import com.dataiku.scoring.models.GradientBoostingRegressor;
import com.dataiku.scoring.models.ProbabilisticClassifier;
import com.dataiku.scoring.models.Regressor;
import com.dataiku.scoring.pipelines.AbstractCalibrator;
import com.dataiku.scoring.pipelines.AbstractPipeline;
import com.dataiku.scoring.pipelines.BinaryProbabilisticPipeline;
import com.dataiku.scoring.pipelines.BinaryProbabilisticPipelineImpl;
import com.dataiku.scoring.pipelines.Coercion;
import com.dataiku.scoring.pipelines.MulticlassProbabilisticPipeline;
import com.dataiku.scoring.pipelines.MulticlassProbabilisticPipelineImpl;
import com.dataiku.scoring.pipelines.NonProbabilisticClassificationPipeline;
import com.dataiku.scoring.pipelines.NonProbabilisticClassificationPipelineImpl;
import com.dataiku.scoring.pipelines.Normalization;
import com.dataiku.scoring.pipelines.PartitionedPipeline;
import com.dataiku.scoring.pipelines.PreprocessingPipeline;
import com.dataiku.scoring.pipelines.Processor;
import com.dataiku.scoring.pipelines.RegressionPipeline;
import com.dataiku.scoring.pipelines.RegressionPipelineImpl;
import com.dataiku.scoring.pipelines.overrides.NonProbabilisticClassificationOverridesLayer;
import com.dataiku.scoring.pipelines.overrides.OverridesOutcomeComputer;
import com.dataiku.scoring.pipelines.overrides.OverridesOutcomeComputerBuilder;
import com.dataiku.scoring.pipelines.overrides.ProbabilisticClassificationOverridesLayer;
import com.dataiku.scoring.pipelines.overrides.RegressionOverridesLayer;
import com.dataiku.scoring.pipelines.uncertainty.PredictionIntervalModel;
import com.dataiku.scoring.util.ModelVersioning;
import com.dataiku.scoring.util.RawObservation;
import com.dataiku.scoring.util.StringUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class Build {
    public static final String PIPELINE_META_FILE = "dss_pipeline_meta.json";
    public static final Logger logger = Logger.getLogger("dku.scoring");

    public static DssPipelineMeta pipelineMeta(URL resources) throws IOException {
        return BuildUtils.parseURL(new URL(resources, PIPELINE_META_FILE), DssPipelineMeta.class);
    }

    private static AlgorithmBuilding getAlgorithm(DssPipelineMeta meta) throws IOException {
        if (meta.algorithm_name == null) {
            throw new IllegalArgumentException("Failed to parse a valid algorithm name from dss_pipeline_meta.json");
        }
        return meta.algorithm_name;
    }

    public static Coercion coercion(URL resources) throws IOException {
        return BuildUtils.parseURL(new URL(resources, "rpreprocessing_params.json"), MinifiedResolvedPreprocessingParams.class).buildCoercion();
    }

    private static SplitDesc.Schema getSchema(URL resources) throws IOException {
        return BuildUtils.parseURL((URL)new URL((URL)resources, (String)"split/split.json"), SplitDesc.class).schema;
    }

    public static Normalization normalization(URL resources, DssPipelineMeta meta) throws IOException {
        return BuildUtils.parseURL(new URL(resources, "rpreprocessing_params.json"), MinifiedResolvedPreprocessingParams.class).buildNormalization(Build.getSchema(resources), meta);
    }

    public static PreprocessingPipeline preprocessingPipeline(URL resources, DssPipelineMeta meta) throws IOException {
        List<Processor> stages = Processors.importAllFrom(resources);
        PreprocessingPipeline pipe = new PreprocessingPipeline(meta.columns, stages);
        logger.info("Loaded preprocessing pipeline: ");
        logger.info(pipe.toString());
        return pipe;
    }

    static boolean isTrainedAfter13400(String version) {
        if ("dev/doesnotmatter".equals(version)) {
            return true;
        }
        if (version == null || version.isEmpty()) {
            return false;
        }
        try {
            return Integer.parseInt(version) >= 13400;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    private static void configureXgboostTrees(Estimator model, String trainedWithDSSVersion) {
        block4: {
            block3: {
                if (!(model instanceof GradientBoostingRegressor)) break block3;
                for (DecisionTreeRegressor tree : ((GradientBoostingRegressor)model).getTrees()) {
                    if (tree.variant != DecisionTreeModel.TreeVariant.XGBOOST || !Build.isTrainedAfter13400(trainedWithDSSVersion)) continue;
                    tree.setUnrecordedAsMissing();
                }
                break block4;
            }
            if (!(model instanceof GradientBoostingClassifier)) break block4;
            DecisionTreeRegressor[][] decisionTreeRegressorArray = ((GradientBoostingClassifier)model).getTrees();
            int n = decisionTreeRegressorArray.length;
            for (int i = 0; i < n; ++i) {
                DecisionTreeRegressor[] trees;
                for (DecisionTreeRegressor tree : trees = decisionTreeRegressorArray[i]) {
                    if (tree.variant != DecisionTreeModel.TreeVariant.XGBOOST || !Build.isTrainedAfter13400(trainedWithDSSVersion)) continue;
                    tree.setUnrecordedAsMissing();
                }
            }
        }
    }

    public static RegressionPipeline regressionPipeline(URL resources) throws IOException {
        return Build.regressionPipeline(resources, Build.pipelineMeta(resources));
    }

    public static RegressionPipeline regressionPipeline(URL resources, DssPipelineMeta meta) throws IOException {
        return Build.regressionPipeline(resources, meta, null, true);
    }

    public static RegressionPipeline regressionPipeline(URL resources, Map<String, URL> partitionUrls) throws IOException {
        return Build.regressionPipeline(resources, partitionUrls, true);
    }

    public static RegressionPipeline regressionPipeline(URL resources, Map<String, URL> partitionUrls, boolean initialize) throws IOException {
        return Build.regressionPipeline(resources, Build.pipelineMeta(resources), partitionUrls, initialize);
    }

    public static RegressionPipeline regressionPipeline(URL resources, DssPipelineMeta meta, Map<String, URL> partitionUrls, boolean initialize) throws IOException {
        AbstractPipeline pipeline;
        RegressionOverridesLayer overridesLayer;
        AlgorithmBuilding algo = Build.getAlgorithm(meta);
        if (!algo.supports(AlgorithmBuilding.AlgorithmType.REGRESSION)) {
            throw new IllegalArgumentException("Trying to import a model trained with the " + String.valueOf((Object)algo) + " algorithm, which does not support regression.");
        }
        OverridesOutcomeComputer<RawObservation> outcomeComputer = OverridesOutcomeComputerBuilder.importFromResourcesOrNull(resources, Build.getSchema(resources), meta.type);
        RegressionOverridesLayer regressionOverridesLayer = overridesLayer = outcomeComputer == null ? null : new RegressionOverridesLayer(outcomeComputer);
        if (meta.partitioning == null) {
            PreprocessingPipeline preproc = Build.preprocessingPipeline(resources, meta);
            Regressor model = (Regressor)algo.builder.importFrom(resources, AlgorithmBuilding.AlgorithmType.REGRESSION);
            Build.configureXgboostTrees(model, ModelVersioning.getSourceDssVersion(resources));
            logger.info("Loaded model: " + model.toString());
            PredictionIntervalModel predictionIntervalModel = PredictionIntervalModel.importFromResourcesOrNull(resources);
            pipeline = new RegressionPipelineImpl(preproc, model, overridesLayer, predictionIntervalModel);
        } else {
            HashMap<String, RegressionPipeline> partitions = new HashMap<String, RegressionPipeline>(meta.partitions.length);
            for (String partition : meta.partitions) {
                URL partUrl = partitionUrls != null ? partitionUrls.get(partition) : new URL(resources, "parts/" + StringUtils.escape(partition) + "/");
                PreprocessingPipeline preproc = Build.preprocessingPipeline(partUrl, Build.pipelineMeta(partUrl));
                Regressor model = (Regressor)algo.builder.importFrom(partUrl, AlgorithmBuilding.AlgorithmType.REGRESSION);
                Build.configureXgboostTrees(model, ModelVersioning.getSourceDssVersion(resources));
                partitions.put(partition, new RegressionPipelineImpl(preproc, model, overridesLayer));
            }
            logger.info("Loading partitioned pipeline from " + meta.partitions.length + " partitions");
            pipeline = new PartitionedPipeline.Regression(meta.partitioning, meta.partitioningTypes, partitions);
        }
        if (initialize) {
            pipeline.init();
        }
        return pipeline;
    }

    public static NonProbabilisticClassificationPipeline nonProbabilisticClassificationPipeline(URL resources) throws IOException {
        return Build.nonProbabilisticClassificationPipeline(resources, Build.pipelineMeta(resources));
    }

    public static NonProbabilisticClassificationPipeline nonProbabilisticClassificationPipeline(URL resources, DssPipelineMeta meta) throws IOException {
        return Build.nonProbabilisticClassificationPipeline(resources, meta, null, true);
    }

    public static NonProbabilisticClassificationPipeline nonProbabilisticClassificationPipeline(URL resources, Map<String, URL> partitionUrls) throws IOException {
        return Build.nonProbabilisticClassificationPipeline(resources, partitionUrls, true);
    }

    public static NonProbabilisticClassificationPipeline nonProbabilisticClassificationPipeline(URL resources, Map<String, URL> partitionUrls, boolean initialize) throws IOException {
        return Build.nonProbabilisticClassificationPipeline(resources, Build.pipelineMeta(resources), partitionUrls, initialize);
    }

    public static NonProbabilisticClassificationPipeline nonProbabilisticClassificationPipeline(URL resources, DssPipelineMeta meta, Map<String, URL> partitionUrls, boolean initialize) throws IOException {
        AbstractPipeline pipeline;
        NonProbabilisticClassificationOverridesLayer overridesLayer;
        AlgorithmBuilding algo = Build.getAlgorithm(meta);
        if (!algo.supports(AlgorithmBuilding.AlgorithmType.CLASSIFICATION_ONLY)) {
            throw new IllegalArgumentException("Trying to import a model trained with the " + String.valueOf((Object)algo) + " algorithm, which does not support classification.");
        }
        OverridesOutcomeComputer<RawObservation> outcomeComputer = OverridesOutcomeComputerBuilder.importFromResourcesOrNull(resources, Build.getSchema(resources), meta.type);
        NonProbabilisticClassificationOverridesLayer nonProbabilisticClassificationOverridesLayer = overridesLayer = outcomeComputer == null ? null : new NonProbabilisticClassificationOverridesLayer(outcomeComputer);
        if (meta.partitioning == null) {
            PreprocessingPipeline preproc = Build.preprocessingPipeline(resources, meta);
            Classifier model = (Classifier)algo.builder.importFrom(resources, AlgorithmBuilding.AlgorithmType.CLASSIFICATION_ONLY);
            Build.configureXgboostTrees(model, ModelVersioning.getSourceDssVersion(resources));
            logger.info("Loaded model: " + model.toString());
            pipeline = new NonProbabilisticClassificationPipelineImpl(preproc, model, meta.classes, overridesLayer);
        } else {
            HashMap<String, NonProbabilisticClassificationPipeline> partitions = new HashMap<String, NonProbabilisticClassificationPipeline>(meta.partitions.length);
            for (String partition : meta.partitions) {
                URL partUrl = partitionUrls != null ? partitionUrls.get(partition) : new URL(resources, "parts/" + StringUtils.escape(partition) + "/");
                PreprocessingPipeline preproc = Build.preprocessingPipeline(partUrl, Build.pipelineMeta(partUrl));
                Classifier model = (Classifier)algo.builder.importFrom(partUrl, AlgorithmBuilding.AlgorithmType.CLASSIFICATION_ONLY);
                Build.configureXgboostTrees(model, ModelVersioning.getSourceDssVersion(resources));
                partitions.put(partition, new NonProbabilisticClassificationPipelineImpl(preproc, model, meta.classes, overridesLayer));
            }
            logger.info("Loading partitioned pipeline from " + meta.partitions.length + " partitions");
            pipeline = new PartitionedPipeline.NonProbabilisticClassification(meta.partitioning, meta.partitioningTypes, (Map<String, NonProbabilisticClassificationPipeline>)partitions);
        }
        if (initialize) {
            pipeline.init();
        }
        return pipeline;
    }

    public static BinaryProbabilisticPipeline binaryProbabilisticPipeline(URL resources, Double threshold) throws IOException {
        return Build.binaryProbabilisticPipeline(resources, Build.pipelineMeta(resources), threshold);
    }

    public static BinaryProbabilisticPipeline binaryProbabilisticPipeline(URL resources, DssPipelineMeta meta) throws IOException {
        return Build.binaryProbabilisticPipeline(resources, meta, null);
    }

    public static BinaryProbabilisticPipeline binaryProbabilisticPipeline(URL resources, DssPipelineMeta meta, Double threshold) throws IOException {
        return Build.binaryProbabilisticPipeline(resources, meta, threshold, null, true);
    }

    public static BinaryProbabilisticPipeline binaryProbabilisticPipeline(URL resources, Double threshold, Map<String, URL> partitionUrls) throws IOException {
        return Build.binaryProbabilisticPipeline(resources, threshold, partitionUrls, true);
    }

    public static BinaryProbabilisticPipeline binaryProbabilisticPipeline(URL resources, Double threshold, Map<String, URL> partitionUrls, boolean initialize) throws IOException {
        return Build.binaryProbabilisticPipeline(resources, Build.pipelineMeta(resources), threshold, partitionUrls, initialize);
    }

    public static BinaryProbabilisticPipeline binaryProbabilisticPipeline(URL resources, DssPipelineMeta meta, Double threshold, Map<String, URL> partitionUrls, boolean initialize) throws IOException {
        AbstractPipeline pipeline;
        ProbabilisticClassificationOverridesLayer overridesLayer;
        AlgorithmBuilding algo = Build.getAlgorithm(meta);
        if (!algo.supports(AlgorithmBuilding.AlgorithmType.PROBABILISTIC)) {
            throw new IllegalArgumentException("Trying to import a model trained with the " + String.valueOf((Object)algo) + " algorithm, which does not support binary probabilities.");
        }
        OverridesOutcomeComputer<RawObservation> outcomeComputer = OverridesOutcomeComputerBuilder.importFromResourcesOrNull(resources, Build.getSchema(resources), meta.type);
        ProbabilisticClassificationOverridesLayer probabilisticClassificationOverridesLayer = overridesLayer = outcomeComputer == null ? null : new ProbabilisticClassificationOverridesLayer(outcomeComputer, meta.classes);
        if (meta.partitioning == null) {
            if (threshold == null) {
                threshold = BuildUtils.parseURL((URL)new URL((URL)resources, (String)"user_meta.json"), BinaryData.class).activeClassifierThreshold;
            }
            PreprocessingPipeline preproc = Build.preprocessingPipeline(resources, meta);
            ProbabilisticClassifier model = (ProbabilisticClassifier)algo.builder.importFrom(resources, AlgorithmBuilding.AlgorithmType.PROBABILISTIC);
            Build.configureXgboostTrees(model, ModelVersioning.getSourceDssVersion(resources));
            logger.info("Loaded model: " + model.toString());
            AbstractCalibrator calibrator = algo.builder.parseCalibrator(resources);
            double[] probaPercentiles = BuildUtils.parseURL((URL)new URL((URL)resources, (String)"perf.json"), BinaryPerfData.class).probaPercentiles;
            pipeline = new BinaryProbabilisticPipelineImpl(preproc, model, meta.classes, threshold, probaPercentiles, calibrator, null, overridesLayer);
        } else {
            HashMap<String, BinaryProbabilisticPipeline> partitions = new HashMap<String, BinaryProbabilisticPipeline>(meta.partitions.length);
            for (String partition : meta.partitions) {
                URL partUrl = partitionUrls != null ? partitionUrls.get(partition) : new URL(resources, "parts/" + StringUtils.escape(partition) + "/");
                PreprocessingPipeline preproc = Build.preprocessingPipeline(partUrl, Build.pipelineMeta(partUrl));
                ProbabilisticClassifier model = (ProbabilisticClassifier)algo.builder.importFrom(partUrl, AlgorithmBuilding.AlgorithmType.PROBABILISTIC);
                Build.configureXgboostTrees(model, ModelVersioning.getSourceDssVersion(resources));
                AbstractCalibrator calibrator = algo.builder.parseCalibrator(partUrl);
                double th = BuildUtils.parseURL((URL)new URL((URL)partUrl, (String)"user_meta.json"), BinaryData.class).activeClassifierThreshold;
                double[] probaPercentiles = BuildUtils.parseURL((URL)new URL((URL)partUrl, (String)"perf.json"), BinaryPerfData.class).probaPercentiles;
                partitions.put(partition, new BinaryProbabilisticPipelineImpl(preproc, model, meta.classes, th, probaPercentiles, calibrator, partition, overridesLayer));
            }
            logger.info("Loading partitioned pipeline from " + meta.partitions.length + " partitions");
            pipeline = new PartitionedPipeline.BinaryProbabilistic(meta.partitioning, meta.partitioningTypes, (Map<String, BinaryProbabilisticPipeline>)partitions);
        }
        if (initialize) {
            pipeline.init();
        }
        return pipeline;
    }

    public static MulticlassProbabilisticPipeline multiclassProbabilisticPipeline(URL resources) throws IOException {
        return Build.multiclassProbabilisticPipeline(resources, Build.pipelineMeta(resources));
    }

    public static MulticlassProbabilisticPipeline multiclassProbabilisticPipeline(URL resources, DssPipelineMeta meta) throws IOException {
        return Build.multiclassProbabilisticPipeline(resources, meta, null, true);
    }

    public static MulticlassProbabilisticPipeline multiclassProbabilisticPipeline(URL resources, Map<String, URL> partitionUrls) throws IOException {
        return Build.multiclassProbabilisticPipeline(resources, partitionUrls, true);
    }

    public static MulticlassProbabilisticPipeline multiclassProbabilisticPipeline(URL resources, Map<String, URL> partitionUrls, boolean initialize) throws IOException {
        return Build.multiclassProbabilisticPipeline(resources, Build.pipelineMeta(resources), partitionUrls, initialize);
    }

    public static MulticlassProbabilisticPipeline multiclassProbabilisticPipeline(URL resources, DssPipelineMeta meta, Map<String, URL> partitionUrls, boolean initialize) throws IOException {
        AbstractPipeline pipeline;
        ProbabilisticClassificationOverridesLayer overridesLayer;
        AlgorithmBuilding algo = Build.getAlgorithm(meta);
        if (!algo.supports(AlgorithmBuilding.AlgorithmType.PROBABILISTIC)) {
            throw new IllegalArgumentException("Trying to import a model trained with the " + String.valueOf((Object)algo) + " algorithm, which does not support multiclass probabilities.");
        }
        OverridesOutcomeComputer<RawObservation> outcomeComputer = OverridesOutcomeComputerBuilder.importFromResourcesOrNull(resources, Build.getSchema(resources), meta.type);
        ProbabilisticClassificationOverridesLayer probabilisticClassificationOverridesLayer = overridesLayer = outcomeComputer == null ? null : new ProbabilisticClassificationOverridesLayer(outcomeComputer, meta.classes);
        if (meta.partitioning == null) {
            PreprocessingPipeline preproc = Build.preprocessingPipeline(resources, meta);
            ProbabilisticClassifier model = (ProbabilisticClassifier)algo.builder.importFrom(resources, AlgorithmBuilding.AlgorithmType.PROBABILISTIC);
            Build.configureXgboostTrees(model, ModelVersioning.getSourceDssVersion(resources));
            logger.info("Loaded model: " + model.toString());
            AbstractCalibrator calibrator = algo.builder.parseCalibrator(resources);
            pipeline = new MulticlassProbabilisticPipelineImpl(preproc, model, meta.classes, calibrator, null, overridesLayer);
        } else {
            HashMap<String, MulticlassProbabilisticPipeline> partitions = new HashMap<String, MulticlassProbabilisticPipeline>(meta.partitions.length);
            for (String partition : meta.partitions) {
                URL partUrl = partitionUrls != null ? partitionUrls.get(partition) : new URL(resources, "parts/" + StringUtils.escape(partition) + "/");
                DssPipelineMeta partitionMeta = Build.pipelineMeta(partUrl);
                PreprocessingPipeline preproc = Build.preprocessingPipeline(partUrl, partitionMeta);
                ProbabilisticClassifier model = (ProbabilisticClassifier)algo.builder.importFrom(partUrl, AlgorithmBuilding.AlgorithmType.PROBABILISTIC);
                Build.configureXgboostTrees(model, ModelVersioning.getSourceDssVersion(resources));
                AbstractCalibrator calibrator = algo.builder.parseCalibrator(partUrl);
                partitions.put(partition, new MulticlassProbabilisticPipelineImpl(preproc, model, partitionMeta.classes, calibrator, partition, overridesLayer));
            }
            logger.info("Loading partitioned pipeline from " + meta.partitions.length + " partitions");
            pipeline = new PartitionedPipeline.MulticlassProbabilistic(meta.partitioning, meta.partitioningTypes, (Map<String, MulticlassProbabilisticPipeline>)partitions);
        }
        if (initialize) {
            pipeline.init();
        }
        return pipeline;
    }

    public static class DssPipelineMeta {
        public String trainedWithDSSVersion;
        public String backend;
        public boolean isValid = false;
        public ModelType type;
        public AlgorithmBuilding algorithm_name;
        public String[] columns;
        public String[] classes;
        public String[] partitions;
        public String[] partitioning;
        public DimensionType[] partitioningTypes;

        public static enum ModelType {
            REGRESSION(false, false, true),
            CLASSIFICATION_ONLY(false, false, false),
            BINARY_PROBABILISTIC(true, true, false),
            MULTICLASS_PROBABILISTIC(true, false, false);

            public final boolean isProbabilistic;
            public final boolean isThresholdDependent;
            public final boolean supportsPredictionIntervals;

            private ModelType(boolean isProbabilistic, boolean isThresholdDependent, boolean supportsPredictionIntervals) {
                this.isProbabilistic = isProbabilistic;
                this.isThresholdDependent = isThresholdDependent;
                this.supportsPredictionIntervals = supportsPredictionIntervals;
            }
        }
    }

    static class MinifiedResolvedPreprocessingParams {
        public Map<String, FeaturePreprocessingParams> per_feature;

        MinifiedResolvedPreprocessingParams() {
        }

        Coercion buildCoercion() {
            HashMap<String, Boolean> mapping = new HashMap<String, Boolean>();
            for (Map.Entry<String, FeaturePreprocessingParams> e : this.per_feature.entrySet()) {
                if (e.getValue().role != FeaturePreprocessingParams.Role.INPUT) continue;
                mapping.put(e.getKey(), e.getValue().type.equals((Object)FeaturePreprocessingParams.FeatureType.NUMERIC));
            }
            return new Coercion(mapping);
        }

        Normalization buildNormalization(SplitDesc.Schema schema, DssPipelineMeta meta) {
            HashMap<String, Normalization.Action> actions = new HashMap<String, Normalization.Action>();
            boolean isMLlib = meta.backend != null && meta.backend.startsWith("MLLIB");
            HashSet<String> temporalTypes = new HashSet<String>();
            temporalTypes.add("date");
            temporalTypes.add("dateonly");
            temporalTypes.add("datetimenotz");
            block3: for (Map.Entry<String, FeaturePreprocessingParams> e : this.per_feature.entrySet()) {
                SplitDesc.Schema.SchemaColumn column = schema.getColumn(e.getKey());
                if (column == null) {
                    switch (e.getValue().role) {
                        case TARGET: 
                        case REJECT: 
                        case WEIGHT: {
                            continue block3;
                        }
                    }
                    throw new IllegalArgumentException("Unknown feature " + e.getKey());
                }
                if (e.getValue().role == FeaturePreprocessingParams.Role.TARGET) continue;
                if (e.getValue().type == FeaturePreprocessingParams.FeatureType.NUMERIC && temporalTypes.contains(column.type)) {
                    actions.put(e.getKey(), isMLlib ? Normalization.Action.TO_MLLIB_EPOCH : Normalization.Action.TO_EPOCH);
                    continue;
                }
                if (e.getValue().type != FeaturePreprocessingParams.FeatureType.CATEGORY || !temporalTypes.contains(column.type)) continue;
                actions.put(e.getKey(), isMLlib ? Normalization.Action.TO_MLLIB_STRING : Normalization.Action.TO_STRING);
            }
            return new Normalization(actions);
        }

        static class FeaturePreprocessingParams {
            public String name;
            public Role role;
            public FeatureType type;

            FeaturePreprocessingParams() {
            }

            public static enum FeatureType {
                NUMERIC,
                CATEGORY,
                TEXT,
                VECTOR;

            }

            public static enum Role {
                INPUT,
                REJECT,
                PROFILING,
                TARGET,
                WEIGHT;

            }
        }
    }

    public static class SplitDesc {
        public Schema schema = new Schema();

        public static class Schema {
            public List<SchemaColumn> columns = new ArrayList<SchemaColumn>();

            public SchemaColumn getColumn(String key) {
                for (SchemaColumn column : this.columns) {
                    if (!(key == null ? column.name == null : key.equals(column.name))) continue;
                    return column;
                }
                return null;
            }

            public static class SchemaColumn {
                public String name;
                public String type;

                public SchemaColumn(String name, String type) {
                    this.name = name;
                    this.type = type;
                }
            }
        }
    }

    private static class BinaryData {
        public double activeClassifierThreshold;

        private BinaryData() {
        }
    }

    private static class BinaryPerfData {
        public double[] probaPercentiles;

        private BinaryPerfData() {
        }
    }
}

