/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.generated;

import com.dataiku.dss.shadelib.com.google.gson.Gson;
import com.dataiku.dss.shadelib.com.google.gson.GsonBuilder;
import com.dataiku.dss.shadelib.com.google.gson.stream.JsonReader;
import com.dataiku.scoring.ClassificationModel;
import com.dataiku.scoring.ClassificationResult;
import com.dataiku.scoring.Model;
import com.dataiku.scoring.Observation;
import com.dataiku.scoring.RegressionModel;
import com.dataiku.scoring.RegressionResult;
import com.dataiku.scoring.Try;
import com.dataiku.scoring.builders.Build;
import com.dataiku.scoring.builders.ObservationBuilder;
import com.dataiku.scoring.generated.Prediction;
import com.dataiku.scoring.pipelines.BinaryProbabilisticPipeline;
import com.dataiku.scoring.pipelines.ClassificationPipeline;
import com.dataiku.scoring.pipelines.Coercion;
import com.dataiku.scoring.pipelines.MulticlassProbabilisticPipeline;
import com.dataiku.scoring.pipelines.NonProbabilisticClassificationPipeline;
import com.dataiku.scoring.pipelines.NonProbabilisticClassificationResult;
import com.dataiku.scoring.pipelines.Normalization;
import com.dataiku.scoring.pipelines.RegressionPipeline;
import com.dataiku.scoring.pipelines.Result;
import com.dataiku.scoring.util.RawObservation;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Scanner;

public abstract class AbstractGeneratedModel<T>
implements Model<T>,
Serializable {
    protected final transient Coercion coercion;
    protected final transient Normalization normalization;
    protected final transient URL resources;

    public AbstractGeneratedModel() {
        String path = this.getClass().getPackage().getName().replace('.', '/') + "/_" + this.getClass().getSimpleName() + "/";
        this.resources = this.getClass().getClassLoader().getResource(path);
        try {
            this.coercion = Build.coercion(this.resources);
            this.normalization = Build.normalization(this.resources, Build.pipelineMeta(this.resources));
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not initialize model", e);
        }
    }

    @Override
    public Observation.Builder observationBuilder() {
        return new ObservationBuilder.NormalizingCoercingBuilder(this.coercion, this.normalization);
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            return this.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Error when de-serializing " + this.getClass().getCanonicalName(), e);
        }
    }

    public void scoreJsonStream(InputStream in, PrintStream out, PrintStream err) {
        Gson gson = new GsonBuilder().create();
        Scanner input = new Scanner(in);
        while (input.hasNextLine()) {
            String output;
            block11: {
                String line = input.nextLine();
                if (line.trim().isEmpty()) continue;
                try {
                    JsonReader obj = new JsonReader((Reader)new StringReader(line));
                    obj.setLenient(true);
                    obj.beginObject();
                    Observation.Builder obsBuilder = this.observationBuilder();
                    block9: while (obj.hasNext()) {
                        String name = obj.nextName();
                        switch (obj.peek()) {
                            case NUMBER: {
                                if (this.coercion.isNumeric(name) == Boolean.TRUE) {
                                    obsBuilder.with(name, obj.nextDouble());
                                    continue block9;
                                }
                                obsBuilder.with(name, obj.nextString());
                                continue block9;
                            }
                            case STRING: {
                                obsBuilder.with(name, obj.nextString());
                                continue block9;
                            }
                            case BOOLEAN: {
                                obsBuilder.with(name, Boolean.toString(obj.nextBoolean()));
                                continue block9;
                            }
                            case NULL: {
                                obsBuilder.with(name, (String)null);
                                obj.nextNull();
                                continue block9;
                            }
                        }
                        obj.skipValue();
                    }
                    obj.endObject();
                    Try result = this.predict(obsBuilder.build());
                    output = this instanceof PClassification && result.isSuccess() ? gson.toJson(Try.success(new Prediction.PClassificationWithMap((Prediction.PClassification)result.get(), ((PClassification)this).getPipeline().getClasses()))) : gson.toJson(result);
                }
                catch (Exception e) {
                    output = gson.toJson(Try.failure(e.getMessage()));
                    if (err == null) break block11;
                    e.printStackTrace(err);
                }
            }
            out.println(output);
        }
    }

    static abstract class PClassification
    extends Classification<com.dataiku.scoring.pipelines.ClassificationResult> {
        PClassification() {
        }
    }

    public static class MPClassification
    extends PClassification {
        protected final transient MulticlassProbabilisticPipeline pipe;

        public MPClassification() {
            try {
                this.pipe = Build.multiclassProbabilisticPipeline(this.resources);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not initialize model pipeline", e);
            }
        }

        protected MulticlassProbabilisticPipeline getPipeline() {
            return this.pipe;
        }

        @Override
        public Try<ClassificationResult> predict(Observation o) {
            Try res = this.pipe.getPredictionResults(RawObservation.cast(o));
            return res.isError() ? Try.failure(res.getMessage()) : Try.success(new Prediction.PClassification((com.dataiku.scoring.pipelines.ClassificationResult)res.get()));
        }
    }

    public static class BPClassification
    extends PClassification {
        protected final transient BinaryProbabilisticPipeline pipe;

        public BPClassification(Double threshold) {
            try {
                this.pipe = Build.binaryProbabilisticPipeline(this.resources, this.checkThreshold(threshold));
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not initialize model pipeline", e);
            }
        }

        private Double checkThreshold(Double threshold) {
            if (threshold != null && (threshold < 0.0 || threshold > 1.0)) {
                throw new IllegalArgumentException("threshold must be between 0.0 and 1.0");
            }
            return threshold;
        }

        protected BinaryProbabilisticPipeline getPipeline() {
            return this.pipe;
        }

        @Override
        public Try<ClassificationResult> predict(Observation o) {
            Try res = this.pipe.getPredictionResults(RawObservation.cast(o));
            return res.isError() ? Try.failure(res.getMessage()) : Try.success(new Prediction.PClassification((com.dataiku.scoring.pipelines.ClassificationResult)res.get()));
        }
    }

    public static class NPClassification
    extends Classification<NonProbabilisticClassificationResult> {
        protected final transient NonProbabilisticClassificationPipeline pipe;

        public NPClassification() {
            try {
                this.pipe = Build.nonProbabilisticClassificationPipeline(this.resources);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not initialize model pipeline", e);
            }
        }

        protected NonProbabilisticClassificationPipeline getPipeline() {
            return this.pipe;
        }

        @Override
        public Try<ClassificationResult> predict(Observation o) {
            Try res = this.pipe.getPredictionResults(RawObservation.cast(o));
            return res.isError() ? Try.failure(res.getMessage()) : Try.success(new Prediction.NPClassification((NonProbabilisticClassificationResult)res.get()));
        }
    }

    public static abstract class Classification<Y extends Result<String>>
    extends AbstractGeneratedModel<ClassificationResult>
    implements ClassificationModel {
        protected abstract ClassificationPipeline<Y> getPipeline();

        @Override
        public int getNumClasses() {
            return this.getPipeline().getClasses().length;
        }

        @Override
        public Collection<String> getClassLabels() {
            return Arrays.asList(this.getPipeline().getClasses());
        }
    }

    public static class Regression
    extends AbstractGeneratedModel<RegressionResult>
    implements RegressionModel {
        protected final transient RegressionPipeline pipe;

        public Regression() {
            try {
                this.pipe = Build.regressionPipeline(this.resources);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not initialize model pipeline", e);
            }
        }

        @Override
        public Try<RegressionResult> predict(Observation o) {
            Try res = this.pipe.getPredictionResults(RawObservation.cast(o));
            return res.isError() ? Try.failure(res.getMessage()) : Try.success(new Prediction.Regression((com.dataiku.scoring.pipelines.RegressionResult)res.get()));
        }
    }
}

