/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines;

import com.dataiku.scoring.pipelines.Processor;
import com.dataiku.scoring.util.RawObservation;
import java.util.HashMap;
import java.util.Map;

public class FeatureSelection {
    private FeatureSelection() {
    }

    public static class PCA
    implements Processor {
        private static final long serialVersionUID = 1L;
        private final boolean sparse;
        private final double[][] rot;
        private final double[] explainedStandardDeviations;
        private final double[] shift;
        private final String[] inputFeatures;
        private final Map<String, Integer> inputFeaturesMapping;

        public PCA(boolean sparse, double[][] rot, double[] explainedVariance, double[] shift, String[] inputFeatures) {
            int i;
            this.sparse = sparse;
            this.rot = rot;
            if (explainedVariance != null) {
                this.explainedStandardDeviations = new double[explainedVariance.length];
                for (i = 0; i < this.explainedStandardDeviations.length; ++i) {
                    this.explainedStandardDeviations[i] = Math.sqrt(explainedVariance[i]);
                }
            } else {
                this.explainedStandardDeviations = null;
            }
            this.shift = shift;
            this.inputFeatures = inputFeatures;
            this.inputFeaturesMapping = new HashMap<String, Integer>();
            for (i = 0; i < inputFeatures.length; ++i) {
                this.inputFeaturesMapping.put(inputFeatures[i], i);
            }
        }

        public static String name(int i) {
            return "principal_component:" + i;
        }

        private void processSparse(RawObservation data) {
            for (int j = 0; j < this.rot[0].length; ++j) {
                double d = 0.0;
                for (String s : data.keys()) {
                    Integer i = this.inputFeaturesMapping.get(s);
                    if (i == null) continue;
                    d += data.getAsDouble(s) * this.rot[i][j];
                }
                data.put(PCA.name(j), d);
            }
        }

        public void processDense(RawObservation data) {
            double[] v = new double[this.inputFeatures.length];
            for (int i = 0; i < this.inputFeatures.length; ++i) {
                Double d = data.getAsDouble(this.inputFeatures[i]);
                double d2 = v[i] = d == null ? 0.0 : d;
                if (this.shift == null) continue;
                int n = i;
                v[n] = v[n] - this.shift[i];
            }
            for (int j = 0; j < this.rot[0].length; ++j) {
                double d = 0.0;
                for (int i = 0; i < v.length; ++i) {
                    d += v[i] * this.rot[i][j];
                }
                if (this.explainedStandardDeviations != null) {
                    d /= this.explainedStandardDeviations[j];
                }
                data.put(PCA.name(j), d);
            }
        }

        @Override
        public void process(RawObservation data) {
            if (this.sparse) {
                this.processSparse(data);
            } else {
                this.processDense(data);
            }
        }
    }

    public static class Drop
    implements Processor {
        private static final long serialVersionUID = 1L;

        @Override
        public void process(RawObservation data) {
        }
    }
}

