/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines;

import com.dataiku.scoring.Try;
import com.dataiku.scoring.linalg.Vector;
import com.dataiku.scoring.models.Classifier;
import com.dataiku.scoring.pipelines.AbstractClassificationPipeline;
import com.dataiku.scoring.pipelines.NonProbabilisticClassificationPipeline;
import com.dataiku.scoring.pipelines.NonProbabilisticClassificationResult;
import com.dataiku.scoring.pipelines.PreprocessingPipeline;
import com.dataiku.scoring.pipelines.overrides.OverridesLayerBase;
import com.dataiku.scoring.util.RawObservation;

public class NonProbabilisticClassificationPipelineImpl
extends AbstractClassificationPipeline<Classifier, NonProbabilisticClassificationResult>
implements NonProbabilisticClassificationPipeline {
    private static final long serialVersionUID = 0L;

    public NonProbabilisticClassificationPipelineImpl(PreprocessingPipeline preprocessing, Classifier model, String[] classes, OverridesLayerBase<NonProbabilisticClassificationResult> overridesLayer) {
        super(preprocessing, model, classes, overridesLayer);
    }

    @Override
    public Try<NonProbabilisticClassificationResult> getPredictionResults(RawObservation r) {
        this.checkInitialized();
        RawObservation originObservation = this.copyRawObservationForPostPredictIfNeededOrNull(r);
        Try<Vector> v = this.preprocessing.process(r);
        if (v.isError()) {
            return Try.failure(v.getMessage());
        }
        Try<Integer> i = ((Classifier)this.model).predict(v.get());
        if (i.isError()) {
            return Try.failure(i.getMessage());
        }
        Integer res = i.get();
        if (res == null || res < 0 || res >= this.classes.length) {
            return Try.failure("Classification yielded an invalid (null or out of bounds) index.");
        }
        return this.postPredict(originObservation, new NonProbabilisticClassificationResult(this.classes[res]));
    }
}

