/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines;

import com.dataiku.scoring.pipelines.Processor;
import com.dataiku.scoring.util.RawObservation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class Quantizer
implements Processor {
    private static final long serialVersionUID = 0L;
    private final String[] columns;
    private final List<TreeSet<Double>> thresholds;
    private final List<Map<Double, Double>> mappers;

    public Quantizer(String[] columns, double[][] thresholds) {
        this.columns = columns;
        this.thresholds = new ArrayList<TreeSet<Double>>(thresholds.length);
        this.mappers = new ArrayList<Map<Double, Double>>(thresholds.length);
        for (int i = 0; i < thresholds.length; ++i) {
            TreeSet<Double> cuts = new TreeSet<Double>();
            for (double d : thresholds[i]) {
                cuts.add(d);
            }
            this.thresholds.add(cuts);
            HashMap<Double, Double> m = new HashMap<Double, Double>();
            int j = 1;
            for (double d : this.thresholds.get(i)) {
                m.put(d, Double.valueOf(j));
                ++j;
            }
            this.mappers.add(m);
        }
    }

    public String[] getColumns() {
        return this.columns;
    }

    public List<TreeSet<Double>> getThresholds() {
        return this.thresholds;
    }

    public List<Map<Double, Double>> getMappers() {
        return this.mappers;
    }

    private static String quantizedName(String col) {
        return "quantized:" + col;
    }

    @Override
    public void process(RawObservation data) {
        for (int i = 0; i < this.columns.length; ++i) {
            Double d = (Double)data.get(this.columns[i]);
            Double floor = this.thresholds.get(i).floor(d);
            double index = floor == null ? 0.0 : this.mappers.get(i).get(floor);
            data.put(Quantizer.quantizedName(this.columns[i]), index);
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append("Quantizer(");
        for (int i = 0; i < this.columns.length; ++i) {
            s.append(this.columns[i]).append(" cuts ").append(Arrays.toString(this.thresholds.get(i).toArray()));
            if (i == this.columns.length - 1) continue;
            s.append(" ; ");
        }
        return s.append(")").toString();
    }
}

