/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import io.trino.jdbc.$internal.guava.collect.AbstractIterator;
import io.trino.jdbc.CancellableIterator;
import java.util.Objects;

public class CancellableLimitingIterator<T>
extends AbstractIterator<T>
implements CancellableIterator<T> {
    private final long maxRows;
    private final CancellableIterator<T> delegate;
    private long currentRow;

    CancellableLimitingIterator(CancellableIterator<T> delegate, long maxRows) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.maxRows = maxRows;
    }

    @Override
    public void cancel() {
        this.delegate.cancel();
    }

    @Override
    protected T computeNext() {
        if (this.maxRows > 0L && this.currentRow >= this.maxRows) {
            this.cancel();
            return this.endOfData();
        }
        ++this.currentRow;
        if (this.delegate.hasNext()) {
            return (T)this.delegate.next();
        }
        return this.endOfData();
    }

    static <T> CancellableIterator<T> limit(CancellableIterator<T> delegate, long maxRows) {
        return new CancellableLimitingIterator<T>(delegate, maxRows);
    }
}

