/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.trino.jdbc.$internal.client.Column;
import io.trino.jdbc.$internal.client.QueryStatusInfo;
import io.trino.jdbc.$internal.client.StatementClient;
import io.trino.jdbc.$internal.guava.base.Verify;
import io.trino.jdbc.AbstractTrinoResultSet;
import io.trino.jdbc.AsyncResultIterator;
import io.trino.jdbc.CancellableLimitingIterator;
import io.trino.jdbc.QueryStats;
import io.trino.jdbc.ResultUtils;
import io.trino.jdbc.WarningsManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class TrinoResultSet
extends AbstractTrinoResultSet {
    private final Statement statement;
    private final StatementClient client;
    private final String queryId;
    @GuardedBy(value="this")
    private boolean closed;
    @GuardedBy(value="this")
    private boolean closeStatementOnClose;

    static TrinoResultSet create(Statement statement, StatementClient client, long maxRows, Consumer<QueryStats> progressCallback, WarningsManager warningsManager) throws SQLException {
        Objects.requireNonNull(client, "client is null");
        List<Column> columns = TrinoResultSet.getColumns(client, progressCallback);
        return new TrinoResultSet(statement, client, columns, maxRows, progressCallback, warningsManager);
    }

    private TrinoResultSet(Statement statement, StatementClient client, List<Column> columns, long maxRows, Consumer<QueryStats> progressCallback, WarningsManager warningsManager) throws SQLException {
        super(Optional.of(Objects.requireNonNull(statement, "statement is null")), columns, CancellableLimitingIterator.limit(new AsyncResultIterator(Objects.requireNonNull(client, "client is null"), progressCallback, warningsManager, Optional.empty()), maxRows));
        this.statement = statement;
        this.client = Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(progressCallback, "progressCallback is null");
        this.queryId = client.currentStatusInfo().getId();
    }

    public String getQueryId() {
        return this.queryId;
    }

    public QueryStats getStats() {
        return QueryStats.create(this.queryId, this.client.getStats());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCloseStatementOnClose() throws SQLException {
        boolean alreadyClosed;
        TrinoResultSet trinoResultSet = this;
        synchronized (trinoResultSet) {
            alreadyClosed = this.closed;
            if (!alreadyClosed) {
                this.closeStatementOnClose = true;
            }
        }
        if (alreadyClosed) {
            this.statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        boolean closeStatement;
        TrinoResultSet trinoResultSet = this;
        synchronized (trinoResultSet) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            closeStatement = this.closeStatementOnClose;
        }
        super.close();
        this.client.close();
        if (closeStatement) {
            this.statement.close();
        }
    }

    @Override
    public synchronized boolean isClosed() throws SQLException {
        return this.closed;
    }

    void partialCancel() {
        this.client.cancelLeafStage();
    }

    private static List<Column> getColumns(StatementClient client, Consumer<QueryStats> progressCallback) throws SQLException {
        QueryStatusInfo results;
        while (client.isRunning()) {
            results = client.currentStatusInfo();
            progressCallback.accept(QueryStats.create(results.getId(), results.getStats()));
            List<Column> columns = results.getColumns();
            if (columns != null) {
                return columns;
            }
            client.advance();
        }
        Verify.verify(client.isFinished());
        results = client.finalStatusInfo();
        if (results.getError() == null) {
            throw new SQLException(String.format("Query has no columns (#%s)", results.getId()));
        }
        throw ResultUtils.resultsException(results);
    }
}

